/* GNU Mailutils -- a suite of utilities for electronic mail
   Copyright (C) 2005-2025 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General
   Public License along with this library.  If not, see 
   <http://www.gnu.org/licenses/>. */

#if HAVE_CONFIG_H
# include <config.h>
#endif
#include <inttostr.h>
#include <mu_umaxtostr.h>

#define UINTMAX_STRSIZE_BOUND INT_BUFSIZE_BOUND (uintmax_t)
static char buffer_pool[MU_UMAXTOSTR_IDX_MAX][UINTMAX_STRSIZE_BOUND];

const char *
mu_umaxtostr_n (int n, uintmax_t val)
{
  if (n < 0 || n >= MU_UMAXTOSTR_IDX_MAX)
    return "INTERNAL ERROR: bad mu_umaxtostr index; please report!";
  return umaxtostr (val, buffer_pool[n]);
}
