/* Example program for GNU libtextstyle.
   Copyright (C) 2018-2026 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* Written by Bruno Haible.  */

/* List of first names and the probability that they are given to boys vs. girls
   in the USA from 1880 to 2016.
   Origin of data: <https://www.ssa.gov/oact/babynames/limits.html>.  */

struct first_name
{
  /* Given first name.  */
  const char *name;
  /* Number of uses for boys / total number of uses.  */
  float p_boy;
};

static const struct first_name names[] =
{
  { "Aaban", 1.0 },
  { "Aabha", 0.0 },
  { "Aabid", 1.0 },
  { "Aabir", 1.0 },
  { "Aabriella", 0.0 },
  { "Aada", 0.0 },
  { "Aadam", 1.0 },
  { "Aadan", 1.0 },
  { "Aadarsh", 1.0 },
  { "Aaden", 0.9988672 },
  { "Aadesh", 1.0 },
  { "Aadhav", 1.0 },
  { "Aadhavan", 1.0 },
  { "Aadhi", 1.0 },
  { "Aadhira", 0.0 },
  { "Aadhvik", 1.0 },
  { "Aadhvika", 0.0 },
  { "Aadhya", 0.0 },
  { "Aadhyan", 1.0 },
  { "Aadi", 0.97951347 },
  { "Aadian", 1.0 },
  { "Aadil", 1.0 },
  { "Aadin", 1.0 },
  { "Aadish", 1.0 },
  { "Aadison", 0.0 },
  { "Aadit", 1.0 },
  { "Aadith", 1.0 },
  { "Aadithya", 1.0 },
  { "Aaditri", 0.0 },
  { "Aaditya", 1.0 },
  { "Aadiv", 1.0 },
  { "Aadon", 1.0 },
  { "Aadrian", 1.0 },
  { "Aadrika", 0.0 },
  { "Aadrit", 1.0 },
  { "Aadriti", 0.0 },
  { "Aadvi", 0.0 },
  { "Aadvik", 1.0 },
  { "Aadvika", 0.0 },
  { "Aadya", 0.0 },
  { "Aadyn", 0.9668737 },
  { "Aafia", 0.0 },
  { "Aafiya", 0.0 },
  { "Aafiyah", 0.0 },
  { "Aafreen", 0.0 },
  { "Aagam", 1.0 },
  { "Aage", 1.0 },
  { "Aagna", 0.0 },
  { "Aagot", 0.0 },
  { "Aahaan", 1.0 },
  { "Aahan", 1.0 },
  { "Aahana", 0.0 },
  { "Aahil", 1.0 },
  { "Aahir", 1.0 },
  { "Aahliyah", 0.0 },
  { "Aahna", 0.0 },
  { "Aahron", 1.0 },
  { "Aaidan", 1.0 },
  { "Aaiden", 1.0 },
  { "Aaidyn", 1.0 },
  { "Aaila", 0.0 },
  { "Aailiyah", 0.0 },
  { "Aailyah", 0.0 },
  { "Aaima", 0.0 },
  { "Aaira", 0.0 },
  { "Aairah", 0.0 },
  { "Aaisha", 0.0 },
  { "Aaishah", 0.0 },
  { "Aaiyana", 0.0 },
  { "Aaiza", 0.0 },
  { "Aaja", 0.0 },
  { "Aajah", 0.0 },
  { "Aajaylah", 0.0 },
  { "Aajon", 1.0 },
  { "Aakanksha", 0.0 },
  { "Aakarsh", 1.0 },
  { "Aakash", 1.0 },
  { "Aakeem", 1.0 },
  { "Aakilah", 0.0 },
  { "Aakira", 0.0 },
  { "Aakiyah", 0.0 },
  { "Aakriti", 0.0 },
  { "Aala", 0.0 },
  { "Aalaiya", 0.0 },
  { "Aalaiyah", 0.0 },
  { "Aalana", 0.0 },
  { "Aalanah", 0.0 },
  { "Aalani", 0.0 },
  { "Aalap", 1.0 },
  { "Aalaya", 0.0 },
  { "Aalayah", 0.0 },
  { "Aalayiah", 0.0 },
  { "Aalayjah", 0.0 },
  { "Aalayna", 0.0 },
  { "Aalaysha", 0.0 },
  { "Aalaysia", 0.0 },
  { "Aalea", 0.0 },
  { "Aaleah", 0.0 },
  { "Aaleahya", 0.0 },
  { "Aaleayah", 0.0 },
  { "Aaleena", 0.0 },
  { "Aaleeya", 0.0 },
  { "Aaleeyah", 0.0 },
  { "Aaleiah", 0.0 },
  { "Aaleigha", 0.0 },
  { "Aaleiyah", 0.0 },
  { "Aalena", 0.0 },
  { "Aalexis", 0.0 },
  { "Aalexus", 0.0 },
  { "Aaleya", 0.0 },
  { "Aaleyah", 0.0 },
  { "Aali", 1.0 },
  { "Aalia", 0.0 },
  { "Aaliah", 0.0 },
  { "Aaliana", 0.0 },
  { "Aalias", 1.0 },
  { "Aaliayah", 0.0 },
  { "Aaliayh", 0.0 },
  { "Aalicia", 0.0 },
  { "Aaliha", 0.0 },
  { "Aalijah", 0.59032255 },
  { "Aalim", 1.0 },
  { "Aalimah", 0.0 },
  { "Aalina", 0.0 },
  { "Aalinah", 0.0 },
  { "Aalisa", 0.0 },
  { "Aalisha", 0.0 },
  { "Aalivia", 0.0 },
  { "Aaliya", 0.0 },
  { "Aaliyaa", 0.0 },
  { "Aaliyah", 0.0011201168 },
  { "Aaliyaha", 0.0 },
  { "Aaliyahmarie", 0.0 },
  { "Aaliyahrose", 0.0 },
  { "Aaliyan", 0.046296295 },
  { "Aaliyana", 0.0 },
  { "Aaliyanna", 0.0 },
  { "Aaliyha", 0.0 },
  { "Aaliyiah", 0.0 },
  { "Aalliyah", 0.0 },
  { "Aallyah", 0.0 },
  { "Aalok", 1.0 },
  { "Aalon", 1.0 },
  { "Aaloni", 0.0 },
  { "Aalya", 0.0 },
  { "Aalyah", 0.0 },
  { "Aalycia", 0.0 },
  { "Aalyha", 0.0 },
  { "Aalyia", 0.0 },
  { "Aalyiah", 0.0 },
  { "Aalyna", 0.0 },
  { "Aalysia", 0.0 },
  { "Aalyssa", 0.0 },
  { "Aalyvia", 0.0 },
  { "Aamanda", 0.0 },
  { "Aamanee", 0.0 },
  { "Aamani", 0.0 },
  { "Aamar", 1.0 },
  { "Aamari", 0.5736842 },
  { "Aamarion", 1.0 },
  { "Aamaya", 0.0 },
  { "Aamber", 0.0 },
  { "Aamena", 0.0 },
  { "Aamer", 1.0 },
  { "Aamia", 0.0 },
  { "Aamil", 1.0 },
  { "Aamilah", 0.0 },
  { "Aamina", 0.0 },
  { "Aaminah", 0.0 },
  { "Aamir", 0.99649125 },
  { "Aamira", 0.0 },
  { "Aamirah", 0.0 },
  { "Aamiya", 0.0 },
  { "Aamiyah", 0.0 },
  { "Aamna", 0.0 },
  { "Aamoni", 0.0 },
  { "Aamora", 0.0 },
  { "Aamori", 0.0 },
  { "Aamya", 0.0 },
  { "Aamyah", 0.0 },
  { "Aana", 0.0 },
  { "Aanand", 1.0 },
  { "Aanav", 1.0 },
  { "Aanay", 1.0 },
  { "Aanaya", 0.0 },
  { "Aanchal", 0.0 },
  { "Aania", 0.0 },
  { "Aaniah", 0.0 },
  { "Aanijah", 0.0 },
  { "Aanika", 0.0 },
  { "Aanisah", 0.0 },
  { "Aaniya", 0.0 },
  { "Aaniyah", 0.0 },
  { "Aaniylah", 0.0 },
  { "Aansh", 1.0 },
  { "Aanshi", 0.0 },
  { "Aanvi", 0.0 },
  { "Aanya", 0.0 },
  { "Aanyah", 0.0 },
  { "Aanyla", 0.0 },
  { "Aapri", 0.0 },
  { "Aaqib", 1.0 },
  { "Aaqil", 1.0 },
  { "Aara", 0.0 },
  { "Aarabella", 0.0 },
  { "Aarabhi", 0.0 },
  { "Aaradhana", 0.0 },
  { "Aaradhy", 1.0 },
  { "Aaradhya", 0.0 },
  { "Aaraf", 1.0 },
  { "Aaraiz", 1.0 },
  { "Aaralyn", 0.0 },
  { "Aaralynn", 0.0 },
  { "Aaran", 1.0 },
  { "Aaraon", 1.0 },
  { "Aaratrika", 0.0 },
  { "Aarav", 1.0 },
  { "Aaravi", 0.0 },
  { "Aaravreddy", 1.0 },
  { "Aaraya", 0.0 },
  { "Aaren", 0.73193914 },
  { "Aareon", 0.76744187 },
  { "Aareona", 0.0 },
  { "Aari", 0.5263158 },
  { "Aaria", 0.0 },
  { "Aariah", 0.0 },
  { "Aarian", 0.6666667 },
  { "Aariana", 0.0 },
  { "Aarianna", 0.0 },
  { "Aarib", 1.0 },
  { "Aaric", 1.0 },
  { "Aarica", 0.0 },
  { "Aarick", 1.0 },
  { "Aarie", 0.0 },
  { "Aariel", 0.0 },
  { "Aariella", 0.0 },
  { "Aarielle", 0.0 },
  { "Aarien", 1.0 },
  { "Aarik", 1.0 },
  { "Aarika", 0.0 },
  { "Aariketh", 1.0 },
  { "Aarilyn", 0.0 },
  { "Aarilynn", 0.0 },
  { "Aarin", 0.6239103 },
  { "Aarini", 0.0 },
  { "Aarion", 0.76430976 },
  { "Aariona", 0.0 },
  { "Aarionna", 0.0 },
  { "Aaris", 0.47435898 },
  { "Aarish", 1.0 },
  { "Aarit", 1.0 },
  { "Aariv", 1.0 },
  { "Aariya", 0.0 },
  { "Aariyah", 0.0 },
  { "Aariyan", 1.0 },
  { "Aariyana", 0.0 },
  { "Aariyanna", 0.0 },
  { "Aariyona", 0.0 },
  { "Aariyonna", 0.0 },
  { "Aariz", 1.0 },
  { "Aarjav", 1.0 },
  { "Aarn", 1.0 },
  { "Aarna", 0.0 },
  { "Aarnav", 1.0 },
  { "Aarnavi", 0.0 },
  { "Aarne", 1.0 },
  { "Aaro", 1.0 },
  { "Aaroh", 1.0 },
  { "Aarohan", 1.0 },
  { "Aarohi", 0.0 },
  { "Aarolyn", 0.0 },
  { "Aaron", 0.99254096 },
  { "Aarona", 0.0 },
  { "Aaronae", 0.0 },
  { "Aaronda", 0.0 },
  { "Aaronette", 0.0 },
  { "Aaronisha", 0.0 },
  { "Aaronjacob", 1.0 },
  { "Aaronjames", 1.0 },
  { "Aaronjohn", 1.0 },
  { "Aaronjoseph", 1.0 },
  { "Aaronjosh", 1.0 },
  { "Aaronjoshua", 1.0 },
  { "Aaronlee", 1.0 },
  { "Aaronmichael", 1.0 },
  { "Aaronn", 1.0 },
  { "Aaroosh", 1.0 },
  { "Aarren", 1.0 },
  { "Aarron", 1.0 },
  { "Aarsh", 1.0 },
  { "Aarshi", 0.0 },
  { "Aarshiya", 0.0 },
  { "Aarthi", 0.0 },
  { "Aarti", 0.0 },
  { "Aaruhi", 0.0 },
  { "Aarush", 1.0 },
  { "Aarushi", 0.0 },
  { "Aarvi", 0.0 },
  { "Aarvin", 1.0 },
  { "Aarya", 0.18580247 },
  { "Aaryah", 0.0 },
  { "Aaryahi", 0.0 },
  { "Aaryan", 0.99516517 },
  { "Aaryana", 0.0 },
  { "Aaryanna", 0.0 },
  { "Aaryash", 1.0 },
  { "Aaryav", 1.0 },
  { "Aaryn", 0.38123873 },
  { "Aarynn", 0.0 },
  { "Aaryon", 1.0 },
  { "Aaryona", 0.0 },
  { "Aarza", 0.0 },
  { "Aaseem", 1.0 },
  { "Aaser", 1.0 },
  { "Aasha", 0.0 },
  { "Aashana", 0.0 },
  { "Aashay", 1.0 },
  { "Aashi", 0.0 },
  { "Aashia", 0.0 },
  { "Aashika", 0.0 },
  { "Aashini", 0.0 },
  { "Aashir", 1.0 },
  { "Aashirya", 0.0 },
  { "Aashish", 1.0 },
  { "Aashita", 0.0 },
  { "Aashiyana", 0.0 },
  { "Aashka", 0.0 },
  { "Aashman", 1.0 },
  { "Aashna", 0.0 },
  { "Aashni", 0.0 },
  { "Aashray", 1.0 },
  { "Aashrita", 0.0 },
  { "Aashrith", 1.0 },
  { "Aashritha", 0.0 },
  { "Aashvi", 0.0 },
  { "Aasia", 0.0 },
  { "Aasim", 1.0 },
  { "Aasin", 1.0 },
  { "Aasir", 1.0 },
  { "Aasiya", 0.0 },
  { "Aasiyah", 0.0 },
  { "Aason", 1.0 },
  { "Aastha", 0.0 },
  { "Aathan", 1.0 },
  { "Aatif", 1.0 },
  { "Aatish", 1.0 },
  { "Aava", 0.0 },
  { "Aavah", 0.0 },
  { "Aavash", 1.0 },
  { "Aaven", 1.0 },
  { "Aavi", 1.0 },
  { "Aavin", 1.0 },
  { "Aavion", 1.0 },
  { "Aavish", 1.0 },
  { "Aavya", 0.0 },
  { "Aavyan", 1.0 },
  { "Aavyn", 0.54545456 },
  { "Aaya", 0.0 },
  { "Aayaan", 1.0 },
  { "Aayah", 0.0 },
  { "Aayam", 1.0 },
  { "Aayan", 1.0 },
  { "Aayana", 0.0 },
  { "Aayanah", 0.0 },
  { "Aayanna", 0.0 },
  { "Aayansh", 1.0 },
  { "Aayat", 0.0 },
  { "Aaydan", 1.0 },
  { "Aayden", 0.9962321 },
  { "Aayla", 0.0 },
  { "Aaylah", 0.0 },
  { "Aayliah", 0.0 },
  { "Aayra", 0.0 },
  { "Aayu", 1.0 },
  { "Aayush", 1.0 },
  { "Aayusha", 0.0 },
  { "Aayushi", 0.0 },
  { "Aazan", 1.0 },
  { "Aazeen", 0.0 },
  { "Aazil", 1.0 },
  { "Aazim", 1.0 },
  { "Aaziyah", 0.0 },
  { "Ab", 1.0 },
  { "Aba", 0.18518518 },
  { "Abaan", 1.0 },
  { "Abaas", 1.0 },
  { "Abad", 1.0 },
  { "Abagael", 0.0 },
  { "Abagail", 0.0 },
  { "Abagaile", 0.0 },
  { "Abagale", 0.0 },
  { "Abagayle", 0.0 },
  { "Abaigael", 0.0 },
  { "Abaigail", 0.0 },
  { "Abaigeal", 0.0 },
  { "Aban", 1.0 },
  { "Abanoub", 1.0 },
  { "Abas", 1.0 },
  { "Abasi", 1.0 },
  { "Abass", 1.0 },
  { "Abayomi", 1.0 },
  { "Abb", 1.0 },
  { "Abba", 0.8666667 },
  { "Abbaas", 1.0 },
  { "Abbagail", 0.0 },
  { "Abbagale", 0.0 },
  { "Abbagayle", 0.0 },
  { "Abbas", 1.0 },
  { "Abbe", 0.0 },
  { "Abbee", 0.0 },
  { "Abbegail", 0.0 },
  { "Abbegale", 0.0 },
  { "Abbegayle", 0.0 },
  { "Abbey", 0.0020493004 },
  { "Abbeygail", 0.0 },
  { "Abbeygale", 0.0 },
  { "Abbi", 0.0 },
  { "Abbie", 0.015052568 },
  { "Abbiegail", 0.0 },
  { "Abbiegale", 0.0 },
  { "Abbiegayle", 0.0 },
  { "Abbigael", 0.0 },
  { "Abbigail", 0.00044283058 },
  { "Abbigaile", 0.0 },
  { "Abbigal", 0.0 },
  { "Abbigale", 0.0 },
  { "Abbigayl", 0.0 },
  { "Abbigayle", 0.0 },
  { "Abbilyn", 0.0 },
  { "Abbot", 1.0 },
  { "Abbott", 0.975 },
  { "Abbra", 0.0 },
  { "Abbriella", 0.0 },
  { "Abbrielle", 0.0 },
  { "Abby", 0.0031726556 },
  { "Abbye", 0.0 },
  { "Abbygael", 0.0 },
  { "Abbygail", 0.0 },
  { "Abbygaile", 0.0 },
  { "Abbygale", 0.0 },
  { "Abbygayl", 0.0 },
  { "Abbygayle", 0.0 },
  { "Abbylynn", 0.0 },
  { "Abcde", 0.0 },
  { "Abd", 1.0 },
  { "Abdala", 1.0 },
  { "Abdalah", 1.0 },
  { "Abdalla", 1.0 },
  { "Abdallah", 1.0 },
  { "Abdalrahman", 1.0 },
  { "Abdalrhman", 1.0 },
  { "Abdel", 1.0 },
  { "Abdelaziz", 1.0 },
  { "Abdelhadi", 1.0 },
  { "Abdelhamid", 1.0 },
  { "Abdelkareem", 1.0 },
  { "Abdelkarim", 1.0 },
  { "Abdellah", 1.0 },
  { "Abdelrahman", 1.0 },
  { "Abdelrhman", 1.0 },
  { "Abderrahman", 1.0 },
  { "Abdi", 0.96240604 },
  { "Abdia", 0.0 },
  { "Abdias", 1.0 },
  { "Abdiasis", 1.0 },
  { "Abdiaziz", 1.0 },
  { "Abdiel", 1.0 },
  { "Abdifatah", 1.0 },
  { "Abdihafid", 1.0 },
  { "Abdihakim", 1.0 },
  { "Abdihamid", 1.0 },
  { "Abdikadir", 1.0 },
  { "Abdikarim", 1.0 },
  { "Abdikhaliq", 1.0 },
  { "Abdilahi", 1.0 },
  { "Abdimalik", 1.0 },
  { "Abdinajib", 1.0 },
  { "Abdinasir", 1.0 },
  { "Abdiqani", 1.0 },
  { "Abdirahim", 1.0 },
  { "Abdirahin", 1.0 },
  { "Abdirahman", 1.0 },
  { "Abdirashid", 1.0 },
  { "Abdirisaq", 1.0 },
  { "Abdirizak", 1.0 },
  { "Abdisalam", 1.0 },
  { "Abdisalan", 1.0 },
  { "Abdisamad", 1.0 },
  { "Abdishakur", 1.0 },
  { "Abdiwahab", 1.0 },
  { "Abdiwali", 1.0 },
  { "Abdo", 1.0 },
  { "Abdon", 1.0 },
  { "Abdou", 1.0 },
  { "Abdoul", 1.0 },
  { "Abdoulaye", 1.0 },
  { "Abdoulaziz", 1.0 },
  { "Abdoulie", 1.0 },
  { "Abdourahman", 1.0 },
  { "Abdourahmane", 1.0 },
  { "Abdrahman", 1.0 },
  { "Abdrew", 1.0 },
  { "Abdu", 1.0 },
  { "Abdual", 1.0 },
  { "Abduallah", 1.0 },
  { "Abduel", 1.0 },
  { "Abdul", 1.0 },
  { "Abdula", 1.0 },
  { "Abdulah", 1.0 },
  { "Abdulahad", 1.0 },
  { "Abdulahi", 1.0 },
  { "Abdulai", 1.0 },
  { "Abdulaye", 1.0 },
  { "Abdulazeem", 1.0 },
  { "Abdulazeez", 1.0 },
  { "Abdulaziz", 1.0 },
  { "Abdulbari", 1.0 },
  { "Abdulbasit", 1.0 },
  { "Abdule", 1.0 },
  { "Abdulelah", 1.0 },
  { "Abdulhaadi", 1.0 },
  { "Abdulhadi", 1.0 },
  { "Abdulhakeem", 1.0 },
  { "Abdulhakim", 1.0 },
  { "Abdulhalim", 1.0 },
  { "Abdulhameed", 1.0 },
  { "Abdulhamid", 1.0 },
  { "Abduljabbar", 1.0 },
  { "Abduljaleel", 1.0 },
  { "Abduljalil", 1.0 },
  { "Abdulkadir", 1.0 },
  { "Abdulkareem", 1.0 },
  { "Abdulkarim", 1.0 },
  { "Abdulkhaliq", 1.0 },
  { "Abdull", 1.0 },
  { "Abdulla", 1.0 },
  { "Abdullah", 1.0 },
  { "Abdullahi", 1.0 },
  { "Abdullatif", 1.0 },
  { "Abdulloh", 1.0 },
  { "Abdulmajeed", 1.0 },
  { "Abdulmajid", 1.0 },
  { "Abdulmalek", 1.0 },
  { "Abdulmalik", 1.0 },
  { "Abdulmohsen", 1.0 },
  { "Abdulnasir", 1.0 },
  { "Abdulqadir", 1.0 },
  { "Abdulraheem", 1.0 },
  { "Abdulrahim", 1.0 },
  { "Abdulrahman", 1.0 },
  { "Abdulrazaq", 1.0 },
  { "Abdulrehman", 1.0 },
  { "Abdulrhman", 1.0 },
  { "Abdulsalam", 1.0 },
  { "Abdulsamad", 1.0 },
  { "Abdulwadud", 1.0 },
  { "Abdulwahab", 1.0 },
  { "Abdulwahid", 1.0 },
  { "Abdulwali", 1.0 },
  { "Abdur", 1.0 },
  { "Abdurahman", 1.0 },
  { "Abdurahmon", 1.0 },
  { "Abdurraheem", 1.0 },
  { "Abdurrahim", 1.0 },
  { "Abdurrahmaan", 1.0 },
  { "Abdurrahman", 1.0 },
  { "Abdurrehman", 1.0 },
  { "Abdussamad", 1.0 },
  { "Abe", 1.0 },
  { "Abeal", 1.0 },
  { "Abed", 1.0 },
  { "Abedallah", 1.0 },
  { "Abedalrahman", 1.0 },
  { "Abednego", 1.0 },
  { "Abeeha", 0.0 },
  { "Abeer", 0.06666667 },
  { "Abeera", 0.0 },
  { "Abegail", 0.0 },
  { "Abegale", 0.0 },
  { "Abegayle", 0.0 },
  { "Abel", 0.9976223 },
  { "Abela", 0.0 },
  { "Abelardo", 1.0 },
  { "Abelina", 0.0 },
  { "Abelino", 1.0 },
  { "Abell", 0.7826087 },
  { "Abella", 0.0 },
  { "Abem", 1.0 },
  { "Aben", 1.0 },
  { "Abena", 0.0 },
  { "Abenezer", 1.0 },
  { "Abeni", 0.0 },
  { "Aber", 0.0 },
  { "Aberdeen", 0.0 },
  { "Aberham", 1.0 },
  { "Abernathy", 0.0 },
  { "Abert", 1.0 },
  { "Abery", 0.0 },
  { "Abey", 0.37037036 },
  { "Abgail", 0.0 },
  { "Abha", 0.0 },
  { "Abhay", 1.0 },
  { "Abheek", 1.0 },
  { "Abhi", 1.0 },
  { "Abhigna", 0.0 },
  { "Abhijay", 1.0 },
  { "Abhijeet", 1.0 },
  { "Abhijit", 1.0 },
  { "Abhijot", 1.0 },
  { "Abhik", 1.0 },
  { "Abhilash", 1.0 },
  { "Abhimanyu", 1.0 },
  { "Abhinav", 1.0 },
  { "Abhinay", 1.0 },
  { "Abhinaya", 0.0 },
  { "Abhiraam", 1.0 },
  { "Abhiraj", 1.0 },
  { "Abhiram", 1.0 },
  { "Abhirami", 0.0 },
  { "Abhirup", 1.0 },
  { "Abhishek", 1.0 },
  { "Abhyuday", 1.0 },
  { "Abi", 0.043137256 },
  { "Abia", 0.0 },
  { "Abiageal", 0.0 },
  { "Abiah", 0.0 },
  { "Abian", 1.0 },
  { "Abianna", 0.0 },
  { "Abibail", 0.0 },
  { "Abid", 1.0 },
  { "Abida", 0.0 },
  { "Abidah", 0.0 },
  { "Abidan", 1.0 },
  { "Abie", 0.90589887 },
  { "Abiegail", 0.0 },
  { "Abiel", 0.9787037 },
  { "Abiela", 0.0 },
  { "Abiella", 0.0 },
  { "Abiezer", 1.0 },
  { "Abigael", 0.0030826142 },
  { "Abigaelle", 0.0 },
  { "Abigahil", 0.0 },
  { "Abigai", 0.0 },
  { "Abigail", 0.0017929892 },
  { "Abigaile", 0.0 },
  { "Abigailgrace", 0.0 },
  { "Abigaille", 0.0 },
  { "Abigailmarie", 0.0 },
  { "Abigailrose", 0.0 },
  { "Abigal", 0.0 },
  { "Abigale", 0.0 },
  { "Abigayil", 0.0 },
  { "Abigayl", 0.0 },
  { "Abigayle", 0.00085984526 },
  { "Abigeal", 0.0 },
  { "Abigel", 0.0 },
  { "Abigial", 0.0 },
  { "Abiha", 0.0 },
  { "Abihail", 0.0 },
  { "Abijah", 0.8322368 },
  { "Abilene", 0.0 },
  { "Abilgail", 0.0 },
  { "Abilio", 1.0 },
  { "Abilyn", 0.0 },
  { "Abilynn", 0.0 },
  { "Abimael", 1.0 },
  { "Abimbola", 0.05882353 },
  { "Abimelec", 1.0 },
  { "Abin", 1.0 },
  { "Abinadab", 1.0 },
  { "Abinadi", 1.0 },
  { "Abinav", 1.0 },
  { "Abinaya", 0.0 },
  { "Abiodun", 1.0 },
  { "Abiola", 0.22564103 },
  { "Abiona", 0.0 },
  { "Abir", 0.7467363 },
  { "Abira", 0.0 },
  { "Abiram", 1.0 },
  { "Abirami", 0.0 },
  { "Abisag", 0.0 },
  { "Abisai", 0.9417143 },
  { "Abisaid", 1.0 },
  { "Abish", 0.0 },
  { "Abisha", 0.0 },
  { "Abishai", 0.865285 },
  { "Abishek", 1.0 },
  { "Abisola", 0.0 },
  { "Abiud", 1.0 },
  { "Abiyah", 0.29411766 },
  { "Abla", 0.0 },
  { "Able", 1.0 },
  { "Abnel", 1.0 },
  { "Abner", 1.0 },
  { "Abney", 0.33333334 },
  { "Abony", 0.0 },
  { "Abou", 1.0 },
  { "Aboubacar", 1.0 },
  { "Aboubakar", 1.0 },
  { "Abra", 0.0 },
  { "Abraam", 1.0 },
  { "Abraar", 1.0 },
  { "Abrah", 0.0 },
  { "Abraham", 0.99765337 },
  { "Abrahan", 1.0 },
  { "Abraheem", 1.0 },
  { "Abrahem", 1.0 },
  { "Abrahim", 1.0 },
  { "Abrahm", 1.0 },
  { "Abram", 1.0 },
  { "Abran", 1.0 },
  { "Abranda", 0.0 },
  { "Abrar", 0.47467437 },
  { "Abraxas", 0.54545456 },
  { "Abraya", 0.0 },
  { "Abrea", 0.0 },
  { "Abreana", 0.0 },
  { "Abreanna", 0.0 },
  { "Abree", 0.0 },
  { "Abreia", 0.0 },
  { "Abrem", 1.0 },
  { "Abren", 1.0 },
  { "Abreona", 0.0 },
  { "Abreonna", 0.0 },
  { "Abrey", 0.0 },
  { "Abreya", 0.0 },
  { "Abrham", 1.0 },
  { "Abri", 0.0 },
  { "Abria", 0.0 },
  { "Abriah", 0.0 },
  { "Abrial", 0.0 },
  { "Abriam", 1.0 },
  { "Abrian", 0.98355263 },
  { "Abriana", 0.0 },
  { "Abrianna", 0.0 },
  { "Abriannah", 0.0 },
  { "Abrianne", 0.0 },
  { "Abrie", 0.0 },
  { "Abriel", 0.37291667 },
  { "Abriela", 0.0 },
  { "Abriele", 0.0 },
  { "Abriella", 0.0 },
  { "Abrielle", 0.0 },
  { "Abrien", 1.0 },
  { "Abrienne", 0.0 },
  { "Abrigail", 0.0 },
  { "Abrihet", 0.0 },
  { "Abril", 0.00068832596 },
  { "Abrille", 0.0 },
  { "Abrina", 0.0 },
  { "Abrion", 1.0 },
  { "Abriona", 0.0 },
  { "Abrionna", 0.0 },
  { "Abrish", 0.0 },
  { "Abriya", 0.0 },
  { "Abriyah", 0.0 },
  { "Abriyana", 0.0 },
  { "Abrom", 1.0 },
  { "Abron", 1.0 },
  { "Abrum", 1.0 },
  { "Abry", 0.0 },
  { "Abryana", 0.0 },
  { "Abryanna", 0.0 },
  { "Abryella", 0.0 },
  { "Abryelle", 0.0 },
  { "Abryl", 0.0 },
  { "Absalat", 0.0 },
  { "Absalom", 1.0 },
  { "Absalon", 1.0 },
  { "Abshir", 1.0 },
  { "Absidy", 0.0 },
  { "Abtin", 1.0 },
  { "Abu", 1.0 },
  { "Abubacar", 1.0 },
  { "Abubacarr", 1.0 },
  { "Abubakar", 1.0 },
  { "Abubakarr", 1.0 },
  { "Abubakary", 1.0 },
  { "Abubaker", 1.0 },
  { "Abubakr", 1.0 },
  { "Abuk", 0.0 },
  { "Abukar", 1.0 },
  { "Abundio", 1.0 },
  { "Aby", 0.21705426 },
  { "Abyade", 0.0 },
  { "Abyan", 0.7910448 },
  { "Abygael", 0.0 },
  { "Abygail", 0.0 },
  { "Abygaile", 0.0 },
  { "Abygale", 0.0 },
  { "Abygayle", 0.0 },
  { "Abyssinia", 0.0 },
  { "Ac", 1.0 },
  { "Acacia", 0.0 },
  { "Acacius", 1.0 },
  { "Acadia", 0.0 },
  { "Acamas", 1.0 },
  { "Acari", 1.0 },
  { "Acasia", 0.0 },
  { "Accacia", 0.0 },
  { "Accalia", 0.0 },
  { "Access", 1.0 },
  { "Accie", 1.0 },
  { "Accursio", 1.0 },
  { "Ace", 0.9972386 },
  { "Acea", 0.9350649 },
  { "Acein", 1.0 },
  { "Aceion", 1.0 },
  { "Acel", 1.0 },
  { "Acelee", 0.0 },
  { "Acelin", 0.848 },
  { "Acelino", 1.0 },
  { "Acelyn", 0.029023746 },
  { "Acelynn", 0.0 },
  { "Acen", 1.0 },
  { "Acencion", 1.0 },
  { "Aceon", 1.0 },
  { "Acer", 1.0 },
  { "Aceson", 1.0 },
  { "Aceston", 1.0 },
  { "Acesyn", 1.0 },
  { "Aceton", 1.0 },
  { "Acey", 0.9489559 },
  { "Aceyn", 1.0 },
  { "Achai", 1.0 },
  { "Achaia", 0.0 },
  { "Achaius", 1.0 },
  { "Achan", 0.0 },
  { "Achante", 0.0 },
  { "Achanti", 0.0 },
  { "Achary", 1.0 },
  { "Achazia", 0.0 },
  { "Achel", 0.0 },
  { "Acheron", 1.0 },
  { "Achille", 1.0 },
  { "Achilles", 1.0 },
  { "Achilleus", 1.0 },
  { "Achillies", 1.0 },
  { "Achintya", 1.0 },
  { "Achol", 0.0 },
  { "Achraf", 1.0 },
  { "Achsa", 0.0 },
  { "Achsah", 0.0 },
  { "Achyut", 1.0 },
  { "Achyuth", 1.0 },
  { "Acia", 0.0 },
  { "Aciano", 1.0 },
  { "Acie", 0.97597307 },
  { "Aciel", 1.0 },
  { "Acil", 1.0 },
  { "Acire", 0.0 },
  { "Ackeem", 1.0 },
  { "Ackley", 1.0 },
  { "Acob", 1.0 },
  { "Acquanetta", 0.0 },
  { "Acquanette", 0.0 },
  { "Acsa", 0.0 },
  { "Acura", 0.0 },
  { "Acxel", 1.0 },
  { "Acy", 0.98207885 },
  { "Ad", 1.0 },
  { "Ada", 0.0029549503 },
  { "Adabel", 0.0 },
  { "Adabella", 0.0 },
  { "Adabelle", 0.0 },
  { "Adacia", 0.0 },
  { "Adae", 1.0 },
  { "Adael", 1.0 },
  { "Adaela", 0.0 },
  { "Adaelyn", 0.0 },
  { "Adaeze", 0.0 },
  { "Adagio", 1.0 },
  { "Adah", 0.0 },
  { "Adahir", 1.0 },
  { "Adahli", 0.0 },
  { "Adahlia", 0.0 },
  { "Adahy", 1.0 },
  { "Adai", 0.0 },
  { "Adaia", 0.0 },
  { "Adaiah", 0.14942528 },
  { "Adaija", 0.0 },
  { "Adaijah", 0.0 },
  { "Adailyn", 0.0 },
  { "Adain", 1.0 },
  { "Adair", 0.5322948 },
  { "Adaira", 0.0 },
  { "Adaire", 0.0 },
  { "Adairis", 0.0 },
  { "Adaisha", 0.0 },
  { "Adaisia", 0.0 },
  { "Adaja", 0.0 },
  { "Adajah", 0.0 },
  { "Adaku", 0.0 },
  { "Adal", 1.0 },
  { "Adala", 0.0 },
  { "Adalade", 0.0 },
  { "Adalae", 0.0 },
  { "Adalai", 0.0 },
  { "Adalaide", 0.0 },
  { "Adalay", 0.0 },
  { "Adalaya", 0.0 },
  { "Adalayde", 0.0 },
  { "Adalbert", 1.0 },
  { "Adalberto", 1.0 },
  { "Adale", 0.0 },
  { "Adalea", 0.0 },
  { "Adaleah", 0.0 },
  { "Adalee", 0.0 },
  { "Adaleen", 0.0 },
  { "Adaleena", 0.0 },
  { "Adalei", 0.0 },
  { "Adaleia", 0.0 },
  { "Adaleigh", 0.0 },
  { "Adaleine", 0.0 },
  { "Adalen", 0.0 },
  { "Adalena", 0.0 },
  { "Adalene", 0.0 },
  { "Adaley", 0.0 },
  { "Adaleya", 0.0 },
  { "Adaleyza", 0.0 },
  { "Adalhi", 0.0 },
  { "Adali", 0.055555556 },
  { "Adalia", 0.0 },
  { "Adaliah", 0.0 },
  { "Adalicia", 0.0 },
  { "Adalid", 0.9 },
  { "Adalida", 0.0 },
  { "Adalie", 0.0 },
  { "Adaliene", 0.0 },
  { "Adalin", 0.0 },
  { "Adalina", 0.0 },
  { "Adalind", 0.0 },
  { "Adalinda", 0.0 },
  { "Adaline", 0.0 },
  { "Adalinn", 0.0 },
  { "Adalinne", 0.0 },
  { "Adalis", 0.0 },
  { "Adalisa", 0.0 },
  { "Adalise", 0.0 },
  { "Adalisse", 0.0 },
  { "Adalius", 1.0 },
  { "Adaliyah", 0.0 },
  { "Adaliz", 0.0 },
  { "Adalize", 0.0 },
  { "Adallyn", 0.0 },
  { "Adaly", 0.0 },
  { "Adalya", 0.0 },
  { "Adalye", 0.0 },
  { "Adalyn", 0.0 },
  { "Adalyna", 0.0 },
  { "Adalynd", 0.0 },
  { "Adalyne", 0.0 },
  { "Adalynn", 0.0 },
  { "Adalynne", 0.0 },
  { "Adalys", 0.0 },
  { "Adalyse", 0.0 },
  { "Adam", 0.9962988 },
  { "Adama", 0.40409207 },
  { "Adamae", 0.0 },
  { "Adamari", 0.0 },
  { "Adamarie", 0.0 },
  { "Adamaris", 0.0 },
  { "Adamariz", 0.0 },
  { "Adamary", 0.0 },
  { "Adamarys", 0.0 },
  { "Adamina", 0.0 },
  { "Adamjames", 1.0 },
  { "Adamm", 1.0 },
  { "Adamma", 0.0 },
  { "Adammichael", 1.0 },
  { "Adamo", 1.0 },
  { "Adams", 1.0 },
  { "Adan", 0.9959742 },
  { "Adana", 0.0 },
  { "Adaneli", 0.0 },
  { "Adanelly", 0.0 },
  { "Adanely", 0.0 },
  { "Adanna", 0.0 },
  { "Adannaya", 0.0 },
  { "Adante", 1.0 },
  { "Adanya", 0.0 },
  { "Adaobi", 0.0 },
  { "Adaora", 0.0 },
  { "Adar", 0.6421053 },
  { "Adara", 0.0 },
  { "Adarah", 0.0 },
  { "Adari", 1.0 },
  { "Adaria", 0.0 },
  { "Adarian", 1.0 },
  { "Adarien", 1.0 },
  { "Adarion", 1.0 },
  { "Adarious", 1.0 },
  { "Adarius", 1.0 },
  { "Adarrion", 1.0 },
  { "Adarrius", 1.0 },
  { "Adarryl", 1.0 },
  { "Adarryll", 1.0 },
  { "Adarsh", 1.0 },
  { "Adaryl", 1.0 },
  { "Adaryll", 1.0 },
  { "Adasha", 0.0 },
  { "Adashia", 0.0 },
  { "Adasia", 0.0 },
  { "Adason", 0.5 },
  { "Adassa", 0.0 },
  { "Adasyn", 0.0 },
  { "Adasynn", 0.0 },
  { "Adau", 0.0 },
  { "Adaugo", 0.0 },
  { "Adaure", 0.0 },
  { "Adavia", 0.0 },
  { "Adavion", 1.0 },
  { "Adaya", 0.0 },
  { "Adayah", 0.0 },
  { "Adayla", 0.0 },
  { "Adaysha", 0.0 },
  { "Adayshia", 0.0 },
  { "Adaysia", 0.0 },
  { "Adbeel", 1.0 },
  { "Adbiel", 1.0 },
  { "Add", 1.0 },
  { "Adda", 0.0 },
  { "Addah", 0.0 },
  { "Addai", 1.0 },
  { "Addalee", 0.0 },
  { "Addaleigh", 0.0 },
  { "Addaley", 0.0 },
  { "Addalie", 0.0 },
  { "Addalin", 0.0 },
  { "Addalina", 0.0 },
  { "Addaline", 0.0 },
  { "Addallee", 0.0 },
  { "Addaly", 0.0 },
  { "Addalyn", 0.0 },
  { "Addalyne", 0.0 },
  { "Addalynn", 0.0 },
  { "Addalynne", 0.0 },
  { "Addam", 1.0 },
  { "Addan", 1.0 },
  { "Addasyn", 0.0 },
  { "Addelaide", 0.0 },
  { "Addelin", 0.0 },
  { "Addelina", 0.0 },
  { "Addeline", 0.0 },
  { "Addell", 0.0 },
  { "Addelyn", 0.0 },
  { "Addelyne", 0.0 },
  { "Addelynn", 0.0 },
  { "Addelynne", 0.0 },
  { "Adden", 1.0 },
  { "Adderly", 1.0 },
  { "Addeson", 0.0 },
  { "Addesyn", 0.0 },
  { "Addey", 0.0 },
  { "Addi", 0.0 },
  { "Addia", 0.0 },
  { "Addicus", 1.0 },
  { "Addicyn", 0.0 },
  { "Addie", 0.016165346 },
  { "Addiel", 1.0 },
  { "Addielynn", 0.0 },
  { "Addiemae", 0.0 },
  { "Addieson", 0.0 },
  { "Addilee", 0.0 },
  { "Addileigh", 0.0 },
  { "Addiley", 0.0 },
  { "Addiline", 0.0 },
  { "Addilyn", 0.0010845987 },
  { "Addilyne", 0.0 },
  { "Addilynn", 0.0 },
  { "Addilynne", 0.0 },
  { "Addine", 0.0 },
  { "Addington", 0.61538464 },
  { "Addis", 0.71482176 },
  { "Addisan", 0.0 },
  { "Addisen", 0.005550416 },
  { "Addisin", 0.0 },
  { "Addison", 0.10249436 },
  { "Addisson", 0.0 },
  { "Addiston", 0.0 },
  { "Addisun", 0.0 },
  { "Addisyn", 0.0 },
  { "Addisynn", 0.0 },
  { "Addix", 1.0 },
  { "Addle", 0.0 },
  { "Addlee", 0.0 },
  { "Addley", 0.0 },
  { "Addlie", 0.0 },
  { "Addlyn", 0.0 },
  { "Addlynn", 0.0 },
  { "Addonis", 1.0 },
  { "Addriana", 0.0 },
  { "Addrianna", 0.0 },
  { "Addrienne", 0.0 },
  { "Addsion", 0.0 },
  { "Addy", 0.019315189 },
  { "Addylan", 0.0 },
  { "Addylen", 0.0 },
  { "Addylin", 0.0 },
  { "Addyline", 0.0 },
  { "Addylyn", 0.0 },
  { "Addylynn", 0.0 },
  { "Addysan", 0.0 },
  { "Addysen", 0.0 },
  { "Addysin", 0.0 },
  { "Addysn", 0.0 },
  { "Addyson", 0.002336118 },
  { "Addysun", 0.0 },
  { "Addysyn", 0.0 },
  { "Ade", 0.9607143 },
  { "Adea", 0.0 },
  { "Adean", 0.19827586 },
  { "Adeana", 0.0 },
  { "Adeanna", 0.0 },
  { "Adebayo", 1.0 },
  { "Adebisi", 0.0 },
  { "Adebola", 0.2 },
  { "Adebowale", 1.0 },
  { "Adecyn", 0.0 },
  { "Adedamola", 1.0 },
  { "Adedayo", 1.0 },
  { "Adedeji", 1.0 },
  { "Adedotun", 1.0 },
  { "Adedoyin", 0.29411766 },
  { "Adee", 0.0 },
  { "Adeeb", 1.0 },
  { "Adeeba", 0.0 },
  { "Adeel", 1.0 },
  { "Adeem", 1.0 },
  { "Adeen", 1.0 },
  { "Adeena", 0.0 },
  { "Adefolarin", 1.0 },
  { "Adein", 1.0 },
  { "Adeja", 0.0 },
  { "Adejah", 0.0 },
  { "Adekemi", 0.0 },
  { "Adekunle", 1.0 },
  { "Adel", 0.4785399 },
  { "Adela", 0.0 },
  { "Adelade", 0.0 },
  { "Adelae", 0.0 },
  { "Adelah", 0.0 },
  { "Adelai", 0.0 },
  { "Adelaid", 0.0 },
  { "Adelaida", 0.0 },
  { "Adelaide", 0.0 },
  { "Adelaido", 1.0 },
  { "Adelaina", 0.0 },
  { "Adelaine", 0.0 },
  { "Adelais", 0.0 },
  { "Adelane", 0.0 },
  { "Adelard", 1.0 },
  { "Adelay", 0.0 },
  { "Adelaya", 0.0 },
  { "Adelayda", 0.0 },
  { "Adelayde", 0.0 },
  { "Adelayne", 0.0 },
  { "Adelbert", 1.0 },
  { "Adele", 0.00028014058 },
  { "Adelea", 0.0 },
  { "Adelean", 0.0 },
  { "Adelee", 0.0 },
  { "Adeleen", 0.0 },
  { "Adelei", 0.0 },
  { "Adeleigh", 0.0 },
  { "Adeleine", 0.0 },
  { "Adeleke", 1.0 },
  { "Adelen", 0.0 },
  { "Adelena", 0.0 },
  { "Adelene", 0.0 },
  { "Adeley", 0.0 },
  { "Adelfa", 0.0 },
  { "Adelfina", 0.0 },
  { "Adelfo", 1.0 },
  { "Adelheid", 0.0 },
  { "Adeli", 0.0 },
  { "Adelia", 0.0 },
  { "Adeliah", 0.0 },
  { "Adelice", 0.0 },
  { "Adelicia", 0.0 },
  { "Adelie", 0.0 },
  { "Adelilah", 0.0 },
  { "Adelin", 0.0 },
  { "Adelina", 0.0 },
  { "Adelinah", 0.0 },
  { "Adelind", 0.0 },
  { "Adeline", 0.00050698075 },
  { "Adelinn", 0.0 },
  { "Adelinne", 0.0 },
  { "Adelino", 1.0 },
  { "Adelis", 0.0 },
  { "Adelisa", 0.0 },
  { "Adelise", 0.0 },
  { "Adelita", 0.0 },
  { "Adeliz", 0.0 },
  { "Adell", 0.14569445 },
  { "Adella", 0.0 },
  { "Adelle", 0.0 },
  { "Adellia", 0.0 },
  { "Adelline", 0.0 },
  { "Adellyn", 0.0 },
  { "Adellynn", 0.0 },
  { "Adelma", 0.0 },
  { "Adelmira", 0.0 },
  { "Adelmo", 1.0 },
  { "Adelore", 1.0 },
  { "Adelphia", 0.0 },
  { "Adely", 0.0 },
  { "Adelya", 0.0 },
  { "Adelyn", 0.0004621428 },
  { "Adelyna", 0.0 },
  { "Adelyne", 0.0 },
  { "Adelynn", 0.0 },
  { "Adelynne", 0.0 },
  { "Adelys", 0.0 },
  { "Adem", 1.0 },
  { "Ademar", 1.0 },
  { "Ademide", 0.8888889 },
  { "Ademir", 1.0 },
  { "Ademola", 1.0 },
  { "Aden", 0.9709961 },
  { "Adena", 0.0 },
  { "Adene", 0.0 },
  { "Adenike", 0.0 },
  { "Adeniyi", 1.0 },
  { "Adenn", 1.0 },
  { "Adeola", 0.082446806 },
  { "Adeolu", 1.0 },
  { "Adeoluwa", 1.0 },
  { "Adeon", 1.0 },
  { "Ader", 0.0 },
  { "Adera", 0.0 },
  { "Aderemi", 1.0 },
  { "Aderinsola", 0.0 },
  { "Adero", 0.0 },
  { "Aderonke", 0.0 },
  { "Aderyn", 0.0 },
  { "Adesewa", 0.0 },
  { "Adesh", 1.0 },
  { "Adesha", 0.0 },
  { "Adesina", 0.0 },
  { "Adesire", 0.0 },
  { "Adesola", 0.0 },
  { "Adessa", 0.0 },
  { "Adesuwa", 0.0 },
  { "Adetayo", 1.0 },
  { "Adetokunbo", 0.94736844 },
  { "Adetola", 1.0 },
  { "Adeva", 0.0 },
  { "Adewale", 1.0 },
  { "Adey", 0.0 },
  { "Adeyemi", 1.0 },
  { "Adeyinka", 0.5 },
  { "Adger", 1.0 },
  { "Adgie", 0.41666666 },
  { "Adham", 1.0 },
  { "Adhara", 0.0 },
  { "Adharsh", 1.0 },
  { "Adharv", 1.0 },
  { "Adhav", 1.0 },
  { "Adheesh", 1.0 },
  { "Adhem", 1.0 },
  { "Adhemar", 1.0 },
  { "Adhira", 0.0 },
  { "Adhiraj", 1.0 },
  { "Adhithi", 0.0 },
  { "Adhithya", 1.0 },
  { "Adhitya", 1.0 },
  { "Adhley", 0.0 },
  { "Adhrit", 1.0 },
  { "Adhrith", 1.0 },
  { "Adhvaith", 1.0 },
  { "Adhvik", 1.0 },
  { "Adhvika", 0.0 },
  { "Adhya", 0.0 },
  { "Adhyan", 1.0 },
  { "Adi", 0.4127726 },
  { "Adia", 0.0 },
  { "Adiah", 0.0 },
  { "Adiam", 0.0 },
  { "Adian", 1.0 },
  { "Adiana", 0.0 },
  { "Adianey", 0.0 },
  { "Adianez", 0.0 },
  { "Adianna", 0.0 },
  { "Adib", 1.0 },
  { "Adiba", 0.0 },
  { "Adidas", 1.0 },
  { "Adie", 0.093023255 },
  { "Adiel", 0.9402314 },
  { "Adiela", 0.0 },
  { "Adiella", 0.0 },
  { "Adielle", 0.0 },
  { "Adien", 1.0 },
  { "Adijah", 0.0 },
  { "Adika", 1.0 },
  { "Adikus", 1.0 },
  { "Adil", 1.0 },
  { "Adila", 0.0 },
  { "Adilah", 0.0 },
  { "Adilee", 0.0 },
  { "Adileigh", 0.0 },
  { "Adilen", 0.0 },
  { "Adilena", 0.0 },
  { "Adilene", 0.0013647885 },
  { "Adileni", 0.0 },
  { "Adilenne", 0.0 },
  { "Adileny", 0.0 },
  { "Adiley", 0.0 },
  { "Adilia", 0.0 },
  { "Adiline", 0.0 },
  { "Adilson", 1.0 },
  { "Adilyn", 0.0 },
  { "Adilyne", 0.0 },
  { "Adilynn", 0.0 },
  { "Adilynne", 0.0 },
  { "Adin", 0.96885186 },
  { "Adina", 0.0 },
  { "Adinah", 0.0 },
  { "Adine", 0.0 },
  { "Adir", 1.0 },
  { "Adira", 0.0 },
  { "Adirah", 0.0 },
  { "Adis", 0.94871795 },
  { "Adisa", 0.41830066 },
  { "Adisen", 0.0 },
  { "Adish", 1.0 },
  { "Adison", 0.171875 },
  { "Adisson", 0.058139537 },
  { "Adisyn", 0.0 },
  { "Adisynn", 0.0 },
  { "Adisynne", 0.0 },
  { "Adit", 1.0 },
  { "Adith", 1.0 },
  { "Adithi", 0.0 },
  { "Adithri", 0.0 },
  { "Adithya", 1.0 },
  { "Aditi", 0.0 },
  { "Aditri", 0.0 },
  { "Aditya", 0.99889505 },
  { "Adiv", 1.0 },
  { "Adiva", 0.0 },
  { "Adiya", 0.0 },
  { "Adiyah", 0.0 },
  { "Adiyan", 1.0 },
  { "Adja", 0.0 },
  { "Adji", 0.0 },
  { "Adjoa", 0.0 },
  { "Adjua", 0.0 },
  { "Adlai", 0.8981818 },
  { "Adlan", 1.0 },
  { "Adlar", 1.0 },
  { "Adlea", 0.0 },
  { "Adlean", 0.0 },
  { "Adlee", 0.0 },
  { "Adlei", 0.0 },
  { "Adleigh", 0.0 },
  { "Adlemi", 0.0 },
  { "Adlen", 0.0 },
  { "Adlena", 0.0 },
  { "Adlene", 0.0 },
  { "Adler", 0.90428346 },
  { "Adley", 0.14347638 },
  { "Adlia", 1.0 },
  { "Adlie", 0.0 },
  { "Adlih", 0.0 },
  { "Adlin", 0.0 },
  { "Adlina", 0.0 },
  { "Adline", 0.0 },
  { "Adly", 0.0 },
  { "Adlyn", 0.0 },
  { "Adlynn", 0.0 },
  { "Adma", 1.0 },
  { "Admir", 1.0 },
  { "Admiral", 1.0 },
  { "Admire", 0.07936508 },
  { "Adn", 0.0 },
  { "Adna", 0.02948403 },
  { "Adnaan", 1.0 },
  { "Adnan", 1.0 },
  { "Adnel", 1.0 },
  { "Adner", 1.0 },
  { "Adniel", 1.0 },
  { "Adnrea", 0.0 },
  { "Adnrew", 1.0 },
  { "Ado", 1.0 },
  { "Adolf", 1.0 },
  { "Adolfo", 0.9993473 },
  { "Adoline", 0.0 },
  { "Adolph", 0.99893224 },
  { "Adolpha", 0.0 },
  { "Adolphe", 1.0 },
  { "Adolphine", 0.0 },
  { "Adolpho", 1.0 },
  { "Adolphus", 1.0 },
  { "Adom", 1.0 },
  { "Adomas", 1.0 },
  { "Adon", 1.0 },
  { "Adona", 0.0 },
  { "Adonai", 0.78740156 },
  { "Adonay", 1.0 },
  { "Adoncia", 0.0 },
  { "Adones", 1.0 },
  { "Adoni", 1.0 },
  { "Adonia", 0.0 },
  { "Adoniah", 0.6363636 },
  { "Adonias", 1.0 },
  { "Adonica", 0.0 },
  { "Adonijah", 0.9322917 },
  { "Adoniram", 1.0 },
  { "Adonis", 0.9904786 },
  { "Adoniyah", 1.0 },
  { "Adoniz", 1.0 },
  { "Adonna", 0.0 },
  { "Adonnis", 1.0 },
  { "Adontae", 1.0 },
  { "Adonte", 1.0 },
  { "Adonus", 1.0 },
  { "Adony", 1.0 },
  { "Adonya", 0.0 },
  { "Adonys", 1.0 },
  { "Ador", 0.0 },
  { "Adora", 0.0 },
  { "Adorabella", 0.0 },
  { "Adorable", 0.0 },
  { "Adorae", 0.0 },
  { "Adorah", 0.0 },
  { "Adoraim", 1.0 },
  { "Adore", 0.08154506 },
  { "Adoree", 0.0 },
  { "Adoria", 0.0 },
  { "Adorian", 1.0 },
  { "Adorion", 1.0 },
  { "Adorn", 0.0 },
  { "Adra", 0.0 },
  { "Adrain", 0.8792445 },
  { "Adraine", 0.022421524 },
  { "Adrainne", 0.0 },
  { "Adran", 1.0 },
  { "Adraya", 0.0 },
  { "Adre", 1.0 },
  { "Adrea", 0.0 },
  { "Adream", 0.0 },
  { "Adrean", 0.6390845 },
  { "Adreana", 0.0 },
  { "Adreann", 0.0 },
  { "Adreanna", 0.0 },
  { "Adreanne", 0.0 },
  { "Adreauna", 0.0 },
  { "Adree", 0.0 },
  { "Adreena", 0.0 },
  { "Adreian", 1.0 },
  { "Adrein", 1.0 },
  { "Adreina", 0.0 },
  { "Adreinne", 0.0 },
  { "Adrell", 1.0 },
  { "Adren", 1.0 },
  { "Adrena", 0.0 },
  { "Adrene", 0.0 },
  { "Adreon", 1.0 },
  { "Adreona", 0.0 },
  { "Adreonna", 0.0 },
  { "Adrew", 1.0 },
  { "Adrey", 0.0 },
  { "Adreyan", 1.0 },
  { "Adreyona", 0.0 },
  { "Adri", 0.104166664 },
  { "Adria", 0.0011780545 },
  { "Adriaan", 1.0 },
  { "Adriah", 0.0 },
  { "Adriahna", 0.0 },
  { "Adrial", 1.0 },
  { "Adrialis", 0.0 },
  { "Adrialys", 0.0 },
  { "Adriam", 1.0 },
  { "Adrian", 0.9372302 },
  { "Adriana", 0.0045941807 },
  { "Adrianah", 0.0 },
  { "Adriane", 0.043163203 },
  { "Adrianjames", 1.0 },
  { "Adriann", 0.10028929 },
  { "Adrianna", 0.00041308088 },
  { "Adriannah", 0.0 },
  { "Adrianne", 0.0023732965 },
  { "Adrianno", 1.0 },
  { "Adrianny", 0.0 },
  { "Adriano", 1.0 },
  { "Adrianpaul", 1.0 },
  { "Adriauna", 0.0 },
  { "Adriaunna", 0.0 },
  { "Adric", 1.0 },
  { "Adrick", 1.0 },
  { "Adrie", 0.0 },
  { "Adriean", 1.0 },
  { "Adrieana", 0.0 },
  { "Adrieanna", 0.0 },
  { "Adrieanne", 0.0 },
  { "Adriel", 0.9319381 },
  { "Adriela", 0.0 },
  { "Adriell", 1.0 },
  { "Adriella", 0.0 },
  { "Adrielle", 0.0 },
  { "Adrien", 0.8520091 },
  { "Adriena", 0.0 },
  { "Adriene", 0.0251962 },
  { "Adrienn", 0.20588236 },
  { "Adrienna", 0.0 },
  { "Adrienne", 0.005717878 },
  { "Adriennie", 0.0 },
  { "Adrieonna", 0.0 },
  { "Adrihana", 0.0 },
  { "Adrihanna", 0.0 },
  { "Adrija", 0.0 },
  { "Adrijana", 0.0 },
  { "Adrik", 1.0 },
  { "Adrika", 0.0 },
  { "Adrin", 0.966759 },
  { "Adrina", 0.0 },
  { "Adrine", 0.072463766 },
  { "Adrinna", 0.0 },
  { "Adrinne", 0.0 },
  { "Adrion", 1.0 },
  { "Adriona", 0.0 },
  { "Adrionna", 0.0 },
  { "Adris", 1.0 },
  { "Adrita", 0.0 },
  { "Adrith", 1.0 },
  { "Adriunna", 0.0 },
  { "Adrius", 1.0 },
  { "Adriyan", 1.0 },
  { "Adriyana", 0.0 },
  { "Adriyanna", 0.0 },
  { "Adriyel", 1.0 },
  { "Adron", 1.0 },
  { "Adry", 0.0 },
  { "Adryan", 0.8610635 },
  { "Adryana", 0.0 },
  { "Adryanah", 0.0 },
  { "Adryann", 0.0 },
  { "Adryanna", 0.0 },
  { "Adryauna", 0.0 },
  { "Adryel", 1.0 },
  { "Adryen", 1.0 },
  { "Adryian", 1.0 },
  { "Adryn", 0.8125 },
  { "Adryon", 1.0 },
  { "Adryonna", 0.0 },
  { "Adulfo", 1.0 },
  { "Adut", 0.0 },
  { "Advait", 1.0 },
  { "Advaita", 0.0 },
  { "Advaith", 1.0 },
  { "Advay", 1.0 },
  { "Advik", 1.0 },
  { "Advika", 0.0 },
  { "Advit", 1.0 },
  { "Advita", 0.0 },
  { "Advith", 1.0 },
  { "Advitha", 0.0 },
  { "Adwaith", 1.0 },
  { "Adwin", 1.0 },
  { "Adwit", 1.0 },
  { "Adwita", 0.0 },
  { "Adwitiya", 0.0 },
  { "Adwoa", 0.0 },
  { "Ady", 0.0 },
  { "Adya", 0.0 },
  { "Adyaan", 1.0 },
  { "Adyan", 1.0 },
  { "Adyanna", 0.0 },
  { "Adyant", 1.0 },
  { "Adyen", 1.0 },
  { "Adylan", 0.0 },
  { "Adylee", 0.0 },
  { "Adyleigh", 0.0 },
  { "Adylen", 0.0 },
  { "Adylene", 0.0 },
  { "Adylenne", 0.0 },
  { "Adylin", 0.0 },
  { "Adylina", 0.0 },
  { "Adyline", 0.0 },
  { "Adylinn", 0.0 },
  { "Adylyn", 0.0 },
  { "Adylynn", 0.0 },
  { "Adym", 1.0 },
  { "Adyn", 0.9129771 },
  { "Adynn", 0.7875 },
  { "Adysan", 0.0 },
  { "Adysen", 0.0 },
  { "Adysin", 0.0 },
  { "Adyson", 0.008886565 },
  { "Adysson", 0.0 },
  { "Adysun", 0.0 },
  { "Adysyn", 0.0 },
  { "Aedan", 0.98676515 },
  { "Aeddon", 1.0 },
  { "Aeden", 0.99272346 },
  { "Aedin", 1.0 },
  { "Aedon", 1.0 },
  { "Aedric", 1.0 },
  { "Aedyn", 0.8728223 },
  { "Aeiden", 1.0 },
  { "Aeiress", 0.0 },
  { "Aeisha", 0.0 },
  { "Aeja", 0.0 },
  { "Aela", 0.0 },
  { "Aelan", 0.0 },
  { "Aelani", 0.0 },
  { "Aeleen", 0.0 },
  { "Aelia", 0.0 },
  { "Aeliana", 0.0 },
  { "Aelicia", 0.0 },
  { "Aelin", 0.0 },
  { "Aelisa", 0.0 },
  { "Aelish", 0.0 },
  { "Aelita", 0.0 },
  { "Aella", 0.0 },
  { "Aelred", 1.0 },
  { "Aelyn", 0.0 },
  { "Aelynn", 0.0 },
  { "Aemelia", 0.0 },
  { "Aemilia", 0.0 },
  { "Aemon", 1.0 },
  { "Aenea", 0.0 },
  { "Aeneas", 1.0 },
  { "Aengus", 1.0 },
  { "Aeon", 0.5637584 },
  { "Aeona", 0.0 },
  { "Aeowyn", 0.0 },
  { "Aerabella", 0.0 },
  { "Aeralyn", 0.0 },
  { "Aeralynn", 0.0 },
  { "Aeri", 0.0 },
  { "Aerial", 0.0032102729 },
  { "Aerian", 1.0 },
  { "Aeriana", 0.0 },
  { "Aerianna", 0.0 },
  { "Aeric", 1.0 },
  { "Aerica", 0.0 },
  { "Aerick", 1.0 },
  { "Aericka", 0.0 },
  { "Aerie", 0.0 },
  { "Aeriel", 0.0 },
  { "Aeriell", 0.0 },
  { "Aeriella", 0.0 },
  { "Aerielle", 0.0 },
  { "Aeries", 0.0 },
  { "Aerik", 1.0 },
  { "Aerika", 0.0 },
  { "Aerilyn", 0.0 },
  { "Aerilynn", 0.0 },
  { "Aerin", 0.021563342 },
  { "Aerion", 0.82608694 },
  { "Aeriona", 0.0 },
  { "Aerionna", 0.0 },
  { "Aeris", 0.0049916804 },
  { "Aeriss", 0.0 },
  { "Aerith", 0.0 },
  { "Aerius", 1.0 },
  { "Aero", 0.82901555 },
  { "Aeron", 0.8939641 },
  { "Aerowyn", 0.0 },
  { "Aeryal", 0.0 },
  { "Aeryana", 0.0 },
  { "Aeryanna", 0.0 },
  { "Aeryk", 1.0 },
  { "Aeryn", 0.024896266 },
  { "Aeryona", 0.0 },
  { "Aesa", 0.0 },
  { "Aesha", 0.0 },
  { "Aeshia", 0.0 },
  { "Aeson", 1.0 },
  { "Aesop", 1.0 },
  { "Aethan", 1.0 },
  { "Aetna", 0.0 },
  { "Aeva", 0.0 },
  { "Aevah", 0.0 },
  { "Aevin", 1.0 },
  { "Aevry", 0.0 },
  { "Aevyn", 0.0 },
  { "Aeyden", 1.0 },
  { "Aeyla", 0.0 },
  { "Afa", 1.0 },
  { "Afaf", 0.0 },
  { "Afeef", 1.0 },
  { "Afeni", 0.0 },
  { "Aferdita", 0.0 },
  { "Affaan", 1.0 },
  { "Affan", 1.0 },
  { "Affie", 0.0 },
  { "Affinity", 0.0 },
  { "Afi", 0.0 },
  { "Afia", 0.0 },
  { "Afif", 1.0 },
  { "Afifa", 0.0 },
  { "Afifah", 0.0 },
  { "Afina", 0.0 },
  { "Afiya", 0.0 },
  { "Afiyah", 0.0 },
  { "Afnan", 0.19130434 },
  { "Afolabi", 1.0 },
  { "Afomia", 0.0 },
  { "Afonso", 1.0 },
  { "Afra", 0.0 },
  { "Afrah", 0.0 },
  { "Afraz", 1.0 },
  { "Afred", 1.0 },
  { "Afreen", 0.0 },
  { "Africa", 0.0 },
  { "Africia", 0.0 },
  { "Afrika", 0.0 },
  { "Afrim", 1.0 },
  { "Afrin", 0.0 },
  { "Afrodita", 0.0 },
  { "Afsa", 0.0 },
  { "Afsana", 0.0 },
  { "Afsaneh", 0.0 },
  { "Afshan", 0.0 },
  { "Afsheen", 0.13043478 },
  { "Afshin", 1.0 },
  { "Aftab", 1.0 },
  { "Aftan", 0.0 },
  { "Aften", 0.0 },
  { "Aftin", 0.0 },
  { "Afton", 0.1383237 },
  { "Aftyn", 0.0 },
  { "Afua", 0.0 },
  { "Afzal", 1.0 },
  { "Agam", 0.65384614 },
  { "Agamjot", 1.0 },
  { "Agamveer", 1.0 },
  { "Agape", 0.20833333 },
  { "Agapita", 0.0 },
  { "Agapito", 1.0 },
  { "Agassi", 1.0 },
  { "Agasthya", 1.0 },
  { "Agastya", 1.0 },
  { "Agata", 0.0 },
  { "Agatha", 0.0 },
  { "Agathe", 0.0 },
  { "Agda", 0.0 },
  { "Agee", 1.0 },
  { "Agel", 1.0 },
  { "Agela", 0.0 },
  { "Ageliki", 0.0 },
  { "Agena", 0.0 },
  { "Agent", 1.0 },
  { "Aggeliki", 0.0 },
  { "Aggie", 0.020311441 },
  { "Agha", 1.0 },
  { "Agigail", 0.0 },
  { "Agila", 0.0 },
  { "Agim", 1.0 },
  { "Aginah", 0.0 },
  { "Aglae", 0.0 },
  { "Aglaia", 0.0 },
  { "Agna", 0.0 },
  { "Agneda", 0.0 },
  { "Agnella", 0.0 },
  { "Agnes", 0.002942591 },
  { "Agnesa", 0.0 },
  { "Agnese", 0.0 },
  { "Agness", 0.0 },
  { "Agnessa", 0.0 },
  { "Agneta", 0.0 },
  { "Agnew", 1.0 },
  { "Agnieszka", 0.0 },
  { "Agnita", 0.0 },
  { "Agnus", 0.0 },
  { "Agostina", 0.0 },
  { "Agostino", 1.0 },
  { "Agrim", 1.0 },
  { "Agrima", 0.0 },
  { "Agripina", 0.0 },
  { "Agripino", 1.0 },
  { "Agron", 1.0 },
  { "Agueda", 0.0 },
  { "Agusta", 0.045627378 },
  { "Agustin", 0.9985329 },
  { "Agustina", 0.0 },
  { "Agustine", 1.0 },
  { "Agustus", 1.0 },
  { "Agustya", 1.0 },
  { "Ah", 0.77894735 },
  { "Ahaan", 1.0 },
  { "Ahaana", 0.0 },
  { "Ahad", 1.0 },
  { "Ahadu", 1.0 },
  { "Ahalya", 0.0 },
  { "Ahamad", 1.0 },
  { "Ahamed", 1.0 },
  { "Ahan", 1.0 },
  { "Ahana", 0.0 },
  { "Ahanna", 1.0 },
  { "Ahanu", 1.0 },
  { "Aharon", 1.0 },
  { "Aharshi", 1.0 },
  { "Ahava", 0.0 },
  { "Ahavah", 0.0 },
  { "Ahaziah", 1.0 },
  { "Ahbleza", 1.0 },
  { "Ahbree", 0.0 },
  { "Ahdia", 0.0 },
  { "Aheli", 0.0 },
  { "Ahian", 1.0 },
  { "Ahijah", 1.0 },
  { "Ahil", 1.0 },
  { "Ahilyn", 0.0 },
  { "Ahinara", 0.0 },
  { "Ahir", 1.0 },
  { "Ahisha", 0.0 },
  { "Ahitana", 0.0 },
  { "Ahja", 0.0 },
  { "Ahjah", 0.0 },
  { "Ahjahnae", 0.0 },
  { "Ahjanae", 0.0 },
  { "Ahjanay", 0.0 },
  { "Ahkai", 1.0 },
  { "Ahkari", 1.0 },
  { "Ahkeel", 1.0 },
  { "Ahkeelah", 0.0 },
  { "Ahkeem", 1.0 },
  { "Ahkil", 1.0 },
  { "Ahking", 1.0 },
  { "Ahlaam", 0.0 },
  { "Ahlai", 0.0 },
  { "Ahlam", 0.0 },
  { "Ahlana", 0.0 },
  { "Ahlani", 0.0 },
  { "Ahlanie", 0.0 },
  { "Ahlanna", 0.0 },
  { "Ahlaya", 0.0 },
  { "Ahlayah", 0.0 },
  { "Ahlayla", 0.0 },
  { "Ahlayna", 0.0 },
  { "Ahlaysia", 0.0 },
  { "Ahlea", 0.0 },
  { "Ahleah", 0.0 },
  { "Ahleena", 0.0 },
  { "Ahleeyah", 0.0 },
  { "Ahleigha", 0.0 },
  { "Ahlena", 0.0 },
  { "Ahlexis", 0.0 },
  { "Ahlexus", 0.0 },
  { "Ahley", 0.0 },
  { "Ahlia", 0.0 },
  { "Ahliana", 0.0 },
  { "Ahlias", 1.0 },
  { "Ahlijah", 1.0 },
  { "Ahlina", 0.0 },
  { "Ahlivia", 0.0 },
  { "Ahliya", 0.0 },
  { "Ahliyah", 0.0 },
  { "Ahlona", 0.0 },
  { "Ahlyana", 0.0 },
  { "Ahlyssa", 0.0 },
  { "Ahlyvia", 0.0 },
  { "Ahmaad", 1.0 },
  { "Ahmad", 0.9989052 },
  { "Ahmadou", 1.0 },
  { "Ahmaj", 1.0 },
  { "Ahman", 1.0 },
  { "Ahmand", 1.0 },
  { "Ahmani", 0.14855877 },
  { "Ahmar", 1.0 },
  { "Ahmara", 0.0 },
  { "Ahmare", 1.0 },
  { "Ahmari", 0.71352786 },
  { "Ahmaria", 0.0 },
  { "Ahmarie", 0.0 },
  { "Ahmarion", 1.0 },
  { "Ahmarria", 0.0 },
  { "Ahmaud", 1.0 },
  { "Ahmauri", 1.0 },
  { "Ahmaya", 0.0 },
  { "Ahmed", 1.0 },
  { "Ahmednur", 1.0 },
  { "Ahmeer", 1.0 },
  { "Ahmeir", 1.0 },
  { "Ahmer", 1.0 },
  { "Ahmere", 1.0 },
  { "Ahmet", 1.0 },
  { "Ahmi", 0.88372093 },
  { "Ahmia", 0.0 },
  { "Ahmiah", 0.0 },
  { "Ahmid", 1.0 },
  { "Ahmier", 1.0 },
  { "Ahmik", 1.0 },
  { "Ahmina", 0.0 },
  { "Ahmir", 0.99727666 },
  { "Ahmira", 0.0 },
  { "Ahmiracle", 0.0 },
  { "Ahmirah", 0.0 },
  { "Ahmire", 1.0 },
  { "Ahmiya", 0.0 },
  { "Ahmiyah", 0.0 },
  { "Ahmod", 1.0 },
  { "Ahmon", 1.0 },
  { "Ahmond", 1.0 },
  { "Ahmoni", 0.0 },
  { "Ahmonie", 0.0 },
  { "Ahmora", 0.0 },
  { "Ahmya", 0.0 },
  { "Ahmyah", 0.0 },
  { "Ahmyiah", 0.0 },
  { "Ahmyra", 0.0 },
  { "Ahna", 0.0 },
  { "Ahnaf", 1.0 },
  { "Ahnah", 0.0 },
  { "Ahnalee", 0.0 },
  { "Ahnaleigh", 0.0 },
  { "Ahnalia", 0.0 },
  { "Ahnalise", 0.0 },
  { "Ahnari", 0.0 },
  { "Ahnaya", 0.0 },
  { "Ahnesti", 0.0 },
  { "Ahnesty", 0.0 },
  { "Ahni", 0.0 },
  { "Ahnia", 0.0 },
  { "Ahniah", 0.0 },
  { "Ahnika", 0.0 },
  { "Ahnisty", 0.0 },
  { "Ahniya", 0.0 },
  { "Ahniyah", 0.0 },
  { "Ahniyla", 0.0 },
  { "Ahnjayla", 0.0 },
  { "Ahnna", 0.0 },
  { "Ahnya", 0.0 },
  { "Ahnyah", 0.0 },
  { "Ahnyia", 0.0 },
  { "Ahnyla", 0.0 },
  { "Ahnylah", 0.0 },
  { "Ahona", 0.0 },
  { "Ahonesti", 0.0 },
  { "Ahonesty", 0.0 },
  { "Ahrayah", 0.0 },
  { "Ahreanna", 0.0 },
  { "Ahren", 1.0 },
  { "Ahri", 0.0 },
  { "Ahria", 0.0 },
  { "Ahriah", 0.0 },
  { "Ahrian", 1.0 },
  { "Ahriana", 0.0 },
  { "Ahrianna", 0.0 },
  { "Ahriel", 0.0 },
  { "Ahriya", 0.0 },
  { "Ahriyah", 0.0 },
  { "Ahron", 1.0 },
  { "Ahrya", 0.0 },
  { "Ahsaki", 0.0 },
  { "Ahsan", 1.0 },
  { "Ahsen", 1.0 },
  { "Ahsha", 0.0 },
  { "Ahshanti", 0.0 },
  { "Ahsia", 0.0 },
  { "Ahsir", 1.0 },
  { "Ahslee", 0.0 },
  { "Ahsley", 0.0 },
  { "Ahsoka", 0.0 },
  { "Ahti", 1.0 },
  { "Ahtyana", 0.0 },
  { "Ahtziri", 0.0 },
  { "Ahtziry", 0.0 },
  { "Ahuva", 0.0 },
  { "Ahva", 0.0 },
  { "Ahviana", 0.0 },
  { "Ahvianna", 0.0 },
  { "Ahyaan", 1.0 },
  { "Ahyan", 1.0 },
  { "Ahyana", 0.0 },
  { "Ahyanna", 0.0 },
  { "Ahylin", 0.0 },
  { "Ahyonna", 0.0 },
  { "Ahzab", 1.0 },
  { "Ahzaria", 0.0 },
  { "Ahzariah", 0.0 },
  { "Ahzhane", 0.0 },
  { "Ahzir", 1.0 },
  { "Ahziyah", 0.0 },
  { "Ai", 0.029891305 },
  { "Aia", 0.0 },
  { "Aiah", 0.0 },
  { "Aian", 1.0 },
  { "Aiana", 0.0 },
  { "Aianna", 0.0 },
  { "Aibel", 1.0 },
  { "Aibhilin", 0.0 },
  { "Aibhlinn", 0.0 },
  { "Aibileen", 0.0 },
  { "Aicen", 1.0 },
  { "Aicha", 0.0 },
  { "Aichatou", 0.0 },
  { "Aicia", 0.0 },
  { "Aida", 0.00041138718 },
  { "Aidah", 0.0 },
  { "Aidaliz", 0.0 },
  { "Aidaly", 0.0 },
  { "Aidalyn", 0.0 },
  { "Aidan", 0.9761473 },
  { "Aidana", 0.0 },
  { "Aidanjames", 1.0 },
  { "Aidanjohn", 1.0 },
  { "Aidann", 1.0 },
  { "Aidar", 1.0 },
  { "Aiddan", 1.0 },
  { "Aidden", 1.0 },
  { "Aide", 0.0 },
  { "Aidean", 1.0 },
  { "Aided", 0.0 },
  { "Aidee", 0.0 },
  { "Aideen", 0.26530612 },
  { "Aidel", 0.0 },
  { "Aidelis", 0.0 },
  { "Aideliz", 0.0 },
  { "Aidelyn", 0.0 },
  { "Aiden", 0.9902006 },
  { "Aidenjames", 1.0 },
  { "Aidenjoseph", 1.0 },
  { "Aidenmatthew", 1.0 },
  { "Aidenmichael", 1.0 },
  { "Aidenn", 1.0 },
  { "Aidet", 0.0 },
  { "Aideth", 0.0 },
  { "Aideyn", 1.0 },
  { "Aidia", 0.0 },
  { "Aidian", 1.0 },
  { "Aidien", 1.0 },
  { "Aidin", 0.98098254 },
  { "Aidon", 1.0 },
  { "Aidrian", 1.0 },
  { "Aidrianna", 0.0 },
  { "Aidric", 1.0 },
  { "Aidrick", 1.0 },
  { "Aidrik", 1.0 },
  { "Aidsa", 0.0 },
  { "Aidy", 0.0 },
  { "Aidyen", 1.0 },
  { "Aidyn", 0.8247652 },
  { "Aidynn", 0.5362319 },
  { "Aiedan", 1.0 },
  { "Aieden", 1.0 },
  { "Aiesha", 0.0 },
  { "Aieshia", 0.0 },
  { "Aigne", 0.0 },
  { "Aigner", 0.0 },
  { "Aiham", 1.0 },
  { "Aiiden", 1.0 },
  { "Aija", 0.0 },
  { "Aijah", 0.0 },
  { "Aijahlon", 1.0 },
  { "Aijalon", 0.5177665 },
  { "Aijha", 0.0 },
  { "Aika", 0.0 },
  { "Aikeem", 1.0 },
  { "Aiken", 1.0 },
  { "Aiker", 1.0 },
  { "Aiko", 0.0 },
  { "Aila", 0.0 },
  { "Ailah", 0.0 },
  { "Ailaina", 0.0 },
  { "Ailan", 1.0 },
  { "Ailana", 0.0 },
  { "Ailani", 0.0 },
  { "Ailanie", 0.0 },
  { "Ailanny", 0.0 },
  { "Ailany", 0.0 },
  { "Aile", 0.0 },
  { "Ailea", 0.0 },
  { "Aileah", 0.0 },
  { "Ailean", 0.0 },
  { "Aileana", 0.0 },
  { "Ailed", 0.0 },
  { "Ailee", 0.0 },
  { "Aileen", 0.00014723638 },
  { "Aileena", 0.0 },
  { "Aileene", 0.0 },
  { "Aileigh", 0.0 },
  { "Ailen", 0.0 },
  { "Ailena", 0.0 },
  { "Ailene", 0.0 },
  { "Aileny", 0.0 },
  { "Ailet", 0.0 },
  { "Aileth", 0.0 },
  { "Ailey", 0.0 },
  { "Aili", 0.0 },
  { "Ailia", 0.0 },
  { "Ailiana", 0.0 },
  { "Ailie", 0.0 },
  { "Ailin", 0.00550055 },
  { "Ailina", 0.0 },
  { "Ailine", 0.0 },
  { "Ailis", 0.0 },
  { "Ailisa", 0.0 },
  { "Ailise", 0.0 },
  { "Ailish", 0.0 },
  { "Ailiyah", 0.0 },
  { "Ailleen", 0.0 },
  { "Aillene", 0.0 },
  { "Ailsa", 0.0 },
  { "Ailton", 1.0 },
  { "Aily", 0.0 },
  { "Ailyah", 0.0 },
  { "Ailyn", 0.0 },
  { "Ailyne", 0.0 },
  { "Ailynn", 0.0 },
  { "Aima", 0.0 },
  { "Aimal", 1.0 },
  { "Aiman", 0.75265956 },
  { "Aimani", 0.0 },
  { "Aimar", 0.5307692 },
  { "Aimara", 0.0 },
  { "Aime", 0.21974966 },
  { "Aimee", 0.0014651464 },
  { "Aimen", 0.3880597 },
  { "Aimi", 0.0 },
  { "Aimie", 0.0 },
  { "Aimme", 0.0 },
  { "Aimo", 1.0 },
  { "Aimon", 1.0 },
  { "Aimsley", 0.0 },
  { "Aimy", 0.0 },
  { "Ain", 0.0 },
  { "Aina", 0.0 },
  { "Ainara", 0.0 },
  { "Aindrea", 0.0 },
  { "Aine", 0.0 },
  { "Ainesh", 1.0 },
  { "Ainhara", 0.0 },
  { "Ainhoa", 0.0 },
  { "Aini", 0.0 },
  { "Ainka", 0.0 },
  { "Aino", 0.0 },
  { "Ainslee", 0.0 },
  { "Ainslei", 0.0 },
  { "Ainsleigh", 0.0 },
  { "Ainsley", 0.024748752 },
  { "Ainslie", 0.0 },
  { "Ainsly", 0.0 },
  { "Ainsworth", 1.0 },
  { "Ainzlee", 0.0 },
  { "Ainzley", 0.0 },
  { "Aiona", 0.0 },
  { "Aionna", 0.0 },
  { "Aira", 0.0 },
  { "Airabella", 0.0 },
  { "Airabelle", 0.0 },
  { "Airah", 0.0 },
  { "Airalyn", 0.0 },
  { "Airalynn", 0.0 },
  { "Airam", 0.1388889 },
  { "Airan", 1.0 },
  { "Airanna", 0.0 },
  { "Aire", 0.0 },
  { "Aireal", 0.0 },
  { "Aireana", 0.0 },
  { "Aireanna", 0.0 },
  { "Aireka", 0.0 },
  { "Airel", 0.0 },
  { "Airelle", 0.0 },
  { "Airen", 0.45783132 },
  { "Aireon", 0.9230769 },
  { "Aireona", 0.0 },
  { "Aireonna", 0.0 },
  { "Aires", 0.78125 },
  { "Airess", 0.0 },
  { "Aireyana", 0.0 },
  { "Airi", 0.0 },
  { "Airial", 0.0 },
  { "Airian", 0.0 },
  { "Airiana", 0.0 },
  { "Airianna", 0.0 },
  { "Airic", 1.0 },
  { "Airica", 0.0 },
  { "Airick", 1.0 },
  { "Airicka", 0.0 },
  { "Airiel", 0.0 },
  { "Airielle", 0.0 },
  { "Airik", 1.0 },
  { "Airika", 0.0 },
  { "Airin", 0.1388889 },
  { "Airion", 1.0 },
  { "Airiona", 0.0 },
  { "Airionna", 0.0 },
  { "Airis", 0.094827585 },
  { "Airius", 1.0 },
  { "Airlene", 0.0 },
  { "Airlie", 0.0 },
  { "Airon", 0.9734042 },
  { "Airrion", 1.0 },
  { "Airron", 1.0 },
  { "Airyana", 0.0 },
  { "Airyanna", 0.0 },
  { "Airyn", 0.048076924 },
  { "Airyona", 0.0 },
  { "Airyonna", 0.0 },
  { "Airys", 0.0 },
  { "Aisa", 0.010162601 },
  { "Aisah", 0.0 },
  { "Aisaiah", 1.0 },
  { "Aisatou", 0.0 },
  { "Aisea", 1.0 },
  { "Aisen", 1.0 },
  { "Aisha", 0.0013024602 },
  { "Aishah", 0.0 },
  { "Aishani", 0.0 },
  { "Aishat", 0.0 },
  { "Aishatu", 0.0 },
  { "Aishe", 0.0 },
  { "Aishi", 0.0 },
  { "Aishia", 0.0 },
  { "Aishini", 0.0 },
  { "Aishleen", 0.0 },
  { "Aishlin", 0.0 },
  { "Aishling", 0.0 },
  { "Aishlyn", 0.0 },
  { "Aishvi", 0.0 },
  { "Aishwarya", 0.0 },
  { "Aisia", 0.0 },
  { "Aisja", 0.0 },
  { "Aisla", 0.0 },
  { "Aislee", 0.0 },
  { "Aisleen", 0.0 },
  { "Aisleigh", 0.0 },
  { "Aisley", 0.0 },
  { "Aislin", 0.0 },
  { "Aisling", 0.0 },
  { "Aislinn", 0.0 },
  { "Aislyn", 0.0 },
  { "Aislynn", 0.0 },
  { "Aislynne", 0.0 },
  { "Aison", 1.0 },
  { "Aisosa", 0.0 },
  { "Aissa", 0.0 },
  { "Aissata", 0.0 },
  { "Aissatou", 0.0 },
  { "Aisya", 0.0 },
  { "Aitan", 1.0 },
  { "Aitana", 0.0 },
  { "Aitanna", 0.0 },
  { "Aithan", 1.0 },
  { "Aithana", 0.0 },
  { "Aithen", 1.0 },
  { "Aitiana", 0.0 },
  { "Aitlin", 0.0 },
  { "Aitor", 1.0 },
  { "Aitza", 0.0 },
  { "Aiva", 0.0 },
  { "Aivah", 0.0 },
  { "Aivan", 0.93421054 },
  { "Aiven", 1.0 },
  { "Aivery", 0.0 },
  { "Aivley", 0.0 },
  { "Aivree", 0.0 },
  { "Aivry", 0.0 },
  { "Aivy", 0.0 },
  { "Aixa", 0.0 },
  { "Aiya", 0.0 },
  { "Aiyah", 0.0 },
  { "Aiyahna", 0.0 },
  { "Aiyan", 1.0 },
  { "Aiyana", 0.0 },
  { "Aiyanah", 0.0 },
  { "Aiyani", 0.0 },
  { "Aiyanna", 0.0 },
  { "Aiyannah", 0.0 },
  { "Aiydan", 1.0 },
  { "Aiyden", 1.0 },
  { "Aiyla", 0.0 },
  { "Aiylah", 0.0 },
  { "Aiyona", 0.0 },
  { "Aiyonna", 0.0 },
  { "Aiysha", 0.0 },
  { "Aiza", 0.0 },
  { "Aizah", 0.0 },
  { "Aizayah", 1.0 },
  { "Aizeah", 1.0 },
  { "Aizel", 1.0 },
  { "Aizen", 1.0 },
  { "Aizha", 0.0 },
  { "Aizik", 1.0 },
  { "Aizlee", 0.0 },
  { "Aizleigh", 0.0 },
  { "Aizley", 0.0 },
  { "Aizlyn", 0.0 },
  { "Aizlynn", 0.0 },
  { "Aizza", 0.0 },
  { "Aj", 0.9829107 },
  { "Aja", 0.010819165 },
  { "Ajacia", 0.0 },
  { "Ajada", 0.0 },
  { "Ajaden", 1.0 },
  { "Ajae", 0.2682927 },
  { "Ajah", 0.0 },
  { "Ajahn", 1.0 },
  { "Ajahnae", 0.0 },
  { "Ajahnay", 0.0 },
  { "Ajahni", 1.0 },
  { "Ajai", 0.5185185 },
  { "Ajak", 1.0 },
  { "Ajala", 0.0 },
  { "Ajalae", 0.0 },
  { "Ajalon", 0.36842105 },
  { "Ajamu", 1.0 },
  { "Ajan", 1.0 },
  { "Ajana", 0.0 },
  { "Ajanae", 0.0 },
  { "Ajanai", 0.0 },
  { "Ajanay", 0.0 },
  { "Ajane", 0.0 },
  { "Ajanea", 0.0 },
  { "Ajanee", 0.0 },
  { "Ajang", 1.0 },
  { "Ajani", 0.90193903 },
  { "Ajanique", 0.0 },
  { "Ajasia", 0.0 },
  { "Ajavian", 1.0 },
  { "Ajavion", 1.0 },
  { "Ajax", 1.0 },
  { "Ajay", 0.9986996 },
  { "Ajaya", 0.0 },
  { "Ajayah", 0.0 },
  { "Ajayceon", 1.0 },
  { "Ajaycia", 0.0 },
  { "Ajayden", 1.0 },
  { "Ajaye", 1.0 },
  { "Ajayla", 0.0 },
  { "Ajaylah", 0.0 },
  { "Ajaysia", 0.0 },
  { "Ajdin", 1.0 },
  { "Aje", 0.0 },
  { "Ajea", 0.0 },
  { "Ajee", 0.104166664 },
  { "Ajeenah", 0.0 },
  { "Ajeet", 1.0 },
  { "Ajena", 0.0 },
  { "Ajenae", 0.0 },
  { "Ajene", 0.6013514 },
  { "Ajeya", 0.0 },
  { "Ajha", 0.0 },
  { "Ajhane", 0.0 },
  { "Ajhani", 1.0 },
  { "Aji", 0.0 },
  { "Ajia", 0.0 },
  { "Ajiah", 0.0 },
  { "Ajiana", 0.0 },
  { "Ajianna", 0.0 },
  { "Ajit", 1.0 },
  { "Ajita", 0.0 },
  { "Ajitesh", 1.0 },
  { "Ajith", 1.0 },
  { "Ajiya", 0.0 },
  { "Ajiyah", 0.0 },
  { "Ajla", 0.0 },
  { "Ajmal", 1.0 },
  { "Ajna", 0.0 },
  { "Ajon", 1.0 },
  { "Ajoni", 1.0 },
  { "Ajooni", 0.0 },
  { "Ajournee", 0.0 },
  { "Ajsa", 0.0 },
  { "Ajsha", 0.0 },
  { "Ajua", 0.0 },
  { "Ajuni", 0.0 },
  { "Ajwa", 0.0 },
  { "Ajwan", 0.0 },
  { "Akaash", 1.0 },
  { "Akachi", 1.0 },
  { "Akachukwu", 1.0 },
  { "Akacia", 0.0 },
  { "Akaden", 1.0 },
  { "Akadia", 0.0 },
  { "Akadian", 1.0 },
  { "Akaela", 0.0 },
  { "Akai", 0.9037037 },
  { "Akaia", 0.0 },
  { "Akaila", 0.0 },
  { "Akailah", 0.0 },
  { "Akain", 1.0 },
  { "Akaisha", 0.0 },
  { "Akaiya", 0.0 },
  { "Akaiyah", 0.0 },
  { "Akaja", 0.0 },
  { "Akala", 0.0 },
  { "Akali", 0.0 },
  { "Akam", 1.0 },
  { "Akane", 0.0 },
  { "Akanksha", 0.0 },
  { "Akanni", 1.0 },
  { "Akansha", 0.0 },
  { "Akara", 0.0 },
  { "Akari", 0.30174926 },
  { "Akaria", 0.0 },
  { "Akarsh", 1.0 },
  { "Akash", 1.0 },
  { "Akasha", 0.0 },
  { "Akashdeep", 1.0 },
  { "Akashia", 0.0 },
  { "Akasia", 0.0 },
  { "Akaya", 0.0 },
  { "Akaycia", 0.0 },
  { "Akayden", 1.0 },
  { "Akayla", 0.0 },
  { "Akaylah", 0.0 },
  { "Akaylia", 0.0 },
  { "Akaysha", 0.0 },
  { "Akaysia", 0.0 },
  { "Akbar", 1.0 },
  { "Akea", 0.0 },
  { "Akeam", 1.0 },
  { "Akeara", 0.0 },
  { "Akeba", 0.0 },
  { "Akebia", 0.0 },
  { "Akeda", 0.0 },
  { "Akeel", 1.0 },
  { "Akeela", 0.0 },
  { "Akeelah", 0.0 },
  { "Akeem", 1.0 },
  { "Akeema", 0.0 },
  { "Akeen", 1.0 },
  { "Akeena", 0.0 },
  { "Akeera", 0.0 },
  { "Akeesha", 0.0 },
  { "Akeeyla", 0.0 },
  { "Akeia", 0.0 },
  { "Akeiba", 0.0 },
  { "Akeil", 1.0 },
  { "Akeila", 0.0 },
  { "Akeilah", 0.0 },
  { "Akeim", 1.0 },
  { "Akeira", 0.0 },
  { "Akeisha", 0.0 },
  { "Akeiya", 0.0 },
  { "Akela", 0.008992806 },
  { "Akelah", 0.0 },
  { "Akelia", 0.0 },
  { "Akem", 1.0 },
  { "Akemi", 0.007032349 },
  { "Akemy", 0.0 },
  { "Aken", 1.0 },
  { "Akena", 0.0 },
  { "Akendra", 0.0 },
  { "Akenya", 0.0 },
  { "Akenzie", 0.0 },
  { "Aker", 1.0 },
  { "Akera", 0.019455252 },
  { "Akerah", 0.0 },
  { "Akeria", 0.0 },
  { "Akeriah", 0.0 },
  { "Akerra", 0.0 },
  { "Akerria", 0.0 },
  { "Akesha", 0.0 },
  { "Akeshia", 0.0 },
  { "Aketzali", 0.0 },
  { "Aketzalli", 0.0 },
  { "Aketzaly", 0.0 },
  { "Akevia", 0.0 },
  { "Akeya", 0.0 },
  { "Akeyah", 0.0 },
  { "Akeyia", 0.0 },
  { "Akeyla", 0.0 },
  { "Akeylah", 0.0 },
  { "Akeyra", 0.0 },
  { "Akhari", 1.0 },
  { "Akheem", 1.0 },
  { "Akhenaton", 1.0 },
  { "Akhi", 1.0 },
  { "Akhia", 0.0 },
  { "Akhil", 1.0 },
  { "Akhila", 0.0 },
  { "Akhilesh", 1.0 },
  { "Akhilles", 1.0 },
  { "Akhilleus", 1.0 },
  { "Akhir", 1.0 },
  { "Akhira", 0.0 },
  { "Akhirah", 0.0 },
  { "Akhiya", 0.0 },
  { "Aki", 0.55833334 },
  { "Akia", 0.058204334 },
  { "Akiah", 0.0 },
  { "Akiana", 0.0 },
  { "Akiba", 0.054347824 },
  { "Akida", 0.7368421 },
  { "Akie", 0.3125 },
  { "Akieba", 0.0 },
  { "Akiel", 1.0 },
  { "Akiela", 0.0 },
  { "Akiem", 1.0 },
  { "Akiera", 0.0 },
  { "Akierra", 0.0 },
  { "Akiesha", 0.0 },
  { "Akif", 1.0 },
  { "Akihiro", 1.0 },
  { "Akiko", 0.0 },
  { "Akil", 1.0 },
  { "Akila", 0.0 },
  { "Akilah", 0.0 },
  { "Akilan", 1.0 },
  { "Akiles", 1.0 },
  { "Akilesh", 1.0 },
  { "Akili", 0.63033175 },
  { "Akilia", 0.0 },
  { "Akilles", 1.0 },
  { "Akillian", 1.0 },
  { "Akim", 1.0 },
  { "Akima", 0.0 },
  { "Akimi", 0.0 },
  { "Akin", 1.0 },
  { "Akina", 0.0 },
  { "Aking", 1.0 },
  { "Akinola", 1.0 },
  { "Akintunde", 1.0 },
  { "Akio", 1.0 },
  { "Akir", 1.0 },
  { "Akira", 0.2204767 },
  { "Akirah", 0.0 },
  { "Akire", 0.0 },
  { "Akiria", 0.0 },
  { "Akiro", 1.0 },
  { "Akirra", 0.0 },
  { "Akisha", 0.0 },
  { "Akishia", 0.0 },
  { "Akita", 0.0 },
  { "Akito", 1.0 },
  { "Akiva", 0.9376637 },
  { "Akiya", 0.0 },
  { "Akiyah", 0.0 },
  { "Akiylah", 0.0 },
  { "Akiyra", 0.0 },
  { "Akmal", 1.0 },
  { "Ako", 0.8148148 },
  { "Akol", 1.0 },
  { "Akon", 0.7922078 },
  { "Akoni", 1.0 },
  { "Akorede", 1.0 },
  { "Akos", 1.0 },
  { "Akosha", 0.0 },
  { "Akosita", 0.0 },
  { "Akosua", 0.0 },
  { "Akoya", 0.0 },
  { "Akram", 1.0 },
  { "Akria", 0.0 },
  { "Akrish", 1.0 },
  { "Akriti", 0.0 },
  { "Aksa", 0.0 },
  { "Aksana", 0.0 },
  { "Aksel", 1.0 },
  { "Aksh", 1.0 },
  { "Aksha", 0.0 },
  { "Akshada", 0.0 },
  { "Akshadha", 0.0 },
  { "Akshaj", 1.0 },
  { "Akshan", 1.0 },
  { "Akshar", 1.0 },
  { "Akshara", 0.0 },
  { "Akshat", 1.0 },
  { "Akshata", 0.0 },
  { "Akshath", 1.0 },
  { "Akshay", 1.0 },
  { "Akshaya", 0.0 },
  { "Akshit", 1.0 },
  { "Akshita", 0.0 },
  { "Akshith", 1.0 },
  { "Akshitha", 0.0 },
  { "Aksil", 1.0 },
  { "Akua", 0.0 },
  { "Akul", 1.0 },
  { "Akur", 0.0 },
  { "Akura", 0.0 },
  { "Akwasi", 1.0 },
  { "Akwete", 0.0 },
  { "Akxel", 1.0 },
  { "Akya", 0.0 },
  { "Akyah", 0.0 },
  { "Akyia", 0.0 },
  { "Akyiah", 0.0 },
  { "Akyla", 0.0 },
  { "Akylah", 0.0 },
  { "Akyra", 0.0 },
  { "Akyrah", 0.0 },
  { "Akyria", 0.0 },
  { "Akyrie", 1.0 },
  { "Akzel", 1.0 },
  { "Al", 0.98517525 },
  { "Ala", 0.18043202 },
  { "Alaa", 0.27448276 },
  { "Alaan", 1.0 },
  { "Alaana", 0.0 },
  { "Alabama", 0.0 },
  { "Alac", 1.0 },
  { "Alacia", 0.0 },
  { "Alacyia", 0.0 },
  { "Aladdin", 1.0 },
  { "Aladin", 1.0 },
  { "Aladino", 1.0 },
  { "Aladrian", 0.0 },
  { "Alae", 0.0 },
  { "Alaejah", 0.0 },
  { "Alaena", 0.0 },
  { "Alaetra", 0.0 },
  { "Alaeya", 0.0 },
  { "Alaeyah", 0.0 },
  { "Alafia", 0.0 },
  { "Alagie", 1.0 },
  { "Alah", 0.0 },
  { "Alahia", 0.0 },
  { "Alahna", 0.0 },
  { "Alahni", 0.0 },
  { "Alahnna", 0.0 },
  { "Alai", 0.33333334 },
  { "Alaia", 0.0 },
  { "Alaiah", 0.0 },
  { "Alaida", 0.0 },
  { "Alaiha", 0.0 },
  { "Alaiia", 0.0 },
  { "Alaiiah", 0.0 },
  { "Alaija", 0.0 },
  { "Alaijah", 0.008474576 },
  { "Alaijha", 0.0 },
  { "Alaila", 0.0 },
  { "Alailah", 0.0 },
  { "Alain", 0.9983046 },
  { "Alaina", 0.00016137709 },
  { "Alainah", 0.0 },
  { "Alaine", 0.0 },
  { "Alainey", 0.0 },
  { "Alaini", 0.0 },
  { "Alainie", 0.0 },
  { "Alainna", 0.0 },
  { "Alainnah", 0.0 },
  { "Alair", 0.0 },
  { "Alaira", 0.0 },
  { "Alaire", 0.0 },
  { "Alaisa", 0.0 },
  { "Alaisha", 0.0 },
  { "Alaisia", 0.0 },
  { "Alaiya", 0.0 },
  { "Alaiyah", 0.0 },
  { "Alaiyna", 0.0 },
  { "Alaiza", 0.0 },
  { "Alaizah", 0.0 },
  { "Alaizha", 0.0 },
  { "Alaja", 0.0 },
  { "Alajah", 0.0 },
  { "Alajandro", 1.0 },
  { "Alajha", 0.0 },
  { "Alajhia", 0.0 },
  { "Alajia", 0.0 },
  { "Alajiah", 0.0 },
  { "Alajuwon", 1.0 },
  { "Alakai", 1.0 },
  { "Alakay", 1.0 },
  { "Alaki", 1.0 },
  { "Alala", 0.0 },
  { "Alalah", 0.0 },
  { "Alam", 1.0 },
  { "Alama", 0.0 },
  { "Alamae", 0.0 },
  { "Alamar", 0.0 },
  { "Alamea", 0.0 },
  { "Alameda", 0.0 },
  { "Alameen", 1.0 },
  { "Alamin", 1.0 },
  { "Alan", 0.99690986 },
  { "Alana", 0.00057415914 },
  { "Alanah", 0.0 },
  { "Alancia", 0.0 },
  { "Aland", 1.0 },
  { "Alanda", 0.0 },
  { "Alander", 1.0 },
  { "Alandis", 1.0 },
  { "Alando", 1.0 },
  { "Alandra", 0.0 },
  { "Alandre", 1.0 },
  { "Alandrea", 0.0 },
  { "Alandria", 0.0 },
  { "Alandus", 1.0 },
  { "Alane", 0.0 },
  { "Alanea", 0.0 },
  { "Alanee", 0.0 },
  { "Alaney", 0.0 },
  { "Alani", 0.007913897 },
  { "Alania", 0.0 },
  { "Alanie", 0.0 },
  { "Alanii", 0.0 },
  { "Alanis", 0.0 },
  { "Alaniz", 0.0 },
  { "Alanmichael", 1.0 },
  { "Alann", 1.0 },
  { "Alanna", 0.0003363121 },
  { "Alannah", 0.0 },
  { "Alanni", 0.0 },
  { "Alannie", 0.0 },
  { "Alannis", 0.0 },
  { "Alanny", 0.0 },
  { "Alannys", 0.0 },
  { "Alano", 1.0 },
  { "Alanood", 0.0 },
  { "Alanoud", 0.0 },
  { "Alanson", 1.0 },
  { "Alanta", 0.0 },
  { "Alantae", 1.0 },
  { "Alante", 0.8206039 },
  { "Alantis", 0.0 },
  { "Alantra", 0.0 },
  { "Alany", 0.0 },
  { "Alanya", 0.0 },
  { "Alanys", 0.0 },
  { "Alanzo", 1.0 },
  { "Alara", 0.0 },
  { "Alarah", 0.0 },
  { "Alaria", 0.0 },
  { "Alaric", 1.0 },
  { "Alarice", 0.0 },
  { "Alarick", 1.0 },
  { "Alarie", 0.0 },
  { "Alarik", 1.0 },
  { "Alaris", 0.0 },
  { "Alasdair", 1.0 },
  { "Alasha", 0.0 },
  { "Alashia", 0.0 },
  { "Alasia", 0.0 },
  { "Alasiah", 0.0 },
  { "Alaska", 0.0 },
  { "Alassandra", 0.0 },
  { "Alassane", 1.0 },
  { "Alastair", 1.0 },
  { "Alastar", 1.0 },
  { "Alaster", 1.0 },
  { "Alastor", 1.0 },
  { "Alathea", 0.0 },
  { "Alauna", 0.0 },
  { "Alaunah", 0.0 },
  { "Alaundra", 0.0 },
  { "Alauni", 0.0 },
  { "Alaunna", 0.0 },
  { "Alaura", 0.0 },
  { "Alaurah", 0.0 },
  { "Alawna", 0.0 },
  { "Alax", 1.0 },
  { "Alaxander", 1.0 },
  { "Alaxandra", 0.0 },
  { "Alaxandria", 0.0 },
  { "Alaxis", 0.0 },
  { "Alay", 1.0 },
  { "Alaya", 0.0 },
  { "Alayah", 0.0 },
  { "Alayana", 0.0 },
  { "Alayasia", 0.0 },
  { "Alaycia", 0.0 },
  { "Alayda", 0.0 },
  { "Alaye", 0.6875 },
  { "Alayha", 0.0 },
  { "Alayia", 0.0 },
  { "Alayiah", 0.0 },
  { "Alayja", 0.0 },
  { "Alayjah", 0.0 },
  { "Alayjha", 0.0 },
  { "Alayjia", 0.0 },
  { "Alayjiah", 0.0 },
  { "Alayla", 0.0 },
  { "Alaylah", 0.0 },
  { "Alayn", 1.0 },
  { "Alayna", 0.00020036868 },
  { "Alaynah", 0.0 },
  { "Alayne", 0.0 },
  { "Alaynia", 0.0 },
  { "Alaynie", 0.0 },
  { "Alaynna", 0.0 },
  { "Alaynnah", 0.0 },
  { "Alaysa", 0.0 },
  { "Alaysha", 0.0 },
  { "Alayshia", 0.0 },
  { "Alaysia", 0.0 },
  { "Alaysiah", 0.0 },
  { "Alayssa", 0.0 },
  { "Alaythia", 0.0 },
  { "Alayza", 0.0 },
  { "Alayzah", 0.0 },
  { "Alayzha", 0.0 },
  { "Alayzhia", 0.0 },
  { "Alayzia", 0.0 },
  { "Alayziah", 0.0 },
  { "Alaz", 1.0 },
  { "Alaza", 0.0 },
  { "Alazae", 0.0 },
  { "Alazah", 0.0 },
  { "Alazar", 1.0 },
  { "Alazay", 0.0 },
  { "Alazaya", 0.0 },
  { "Alaze", 0.0 },
  { "Alazea", 0.0 },
  { "Alazhia", 0.0 },
  { "Alazia", 0.0 },
  { "Alaziah", 0.0 },
  { "Alazne", 0.0 },
  { "Alba", 0.01805718 },
  { "Alban", 1.0 },
  { "Albana", 0.0 },
  { "Albani", 0.0 },
  { "Albanie", 0.0 },
  { "Albano", 1.0 },
  { "Albany", 0.008183306 },
  { "Albara", 1.0 },
  { "Albaraa", 1.0 },
  { "Albaro", 1.0 },
  { "Albee", 0.0 },
  { "Albeiro", 1.0 },
  { "Alben", 1.0 },
  { "Albena", 0.0 },
  { "Alber", 1.0 },
  { "Alberdia", 0.0 },
  { "Alberico", 1.0 },
  { "Albert", 0.99476916 },
  { "Alberta", 0.005645241 },
  { "Alberteen", 0.0 },
  { "Alberth", 1.0 },
  { "Albertha", 0.0 },
  { "Albertia", 0.0 },
  { "Albertico", 1.0 },
  { "Albertie", 0.0 },
  { "Albertina", 0.0 },
  { "Albertine", 0.0 },
  { "Albertis", 1.0 },
  { "Albertjames", 1.0 },
  { "Alberto", 0.99252635 },
  { "Albertus", 1.0 },
  { "Albesa", 0.0 },
  { "Albi", 1.0 },
  { "Albia", 0.0 },
  { "Albie", 0.48706895 },
  { "Albieri", 1.0 },
  { "Albieris", 1.0 },
  { "Albiery", 1.0 },
  { "Albin", 1.0 },
  { "Albina", 0.0 },
  { "Albino", 1.0 },
  { "Albion", 1.0 },
  { "Albiona", 0.0 },
  { "Albirda", 0.0 },
  { "Albirdia", 0.0 },
  { "Albirta", 0.0 },
  { "Albirtha", 0.0 },
  { "Albon", 1.0 },
  { "Alborz", 1.0 },
  { "Albree", 0.0 },
  { "Albrey", 0.0 },
  { "Albria", 0.0 },
  { "Alburn", 1.0 },
  { "Albus", 1.0 },
  { "Alby", 0.7169811 },
  { "Alcaria", 0.0 },
  { "Alcario", 1.0 },
  { "Alcee", 1.0 },
  { "Alchemy", 0.0 },
  { "Alcia", 0.0 },
  { "Alcibiades", 1.0 },
  { "Alcide", 1.0 },
  { "Alcides", 1.0 },
  { "Alcie", 0.02793296 },
  { "Alcina", 0.0 },
  { "Alcindor", 1.0 },
  { "Alcine", 0.0 },
  { "Alco", 1.0 },
  { "Alcuin", 1.0 },
  { "Alcus", 1.0 },
  { "Alcy", 0.0 },
  { "Alda", 0.0020157227 },
  { "Aldah", 0.0 },
  { "Aldahir", 1.0 },
  { "Aldair", 1.0 },
  { "Aldan", 1.0 },
  { "Aldana", 0.0 },
  { "Aldayr", 1.0 },
  { "Aldayshein", 1.0 },
  { "Aldea", 0.0 },
  { "Aldean", 0.31623933 },
  { "Aldeen", 0.0 },
  { "Aldemar", 1.0 },
  { "Alden", 0.95000994 },
  { "Aldena", 0.0 },
  { "Aldene", 0.014204546 },
  { "Alder", 0.93246186 },
  { "Alderic", 1.0 },
  { "Aldhair", 1.0 },
  { "Aldia", 0.0 },
  { "Aldie", 0.65625 },
  { "Aldijana", 0.0 },
  { "Aldin", 1.0 },
  { "Aldina", 0.0 },
  { "Aldine", 0.16424116 },
  { "Aldis", 1.0 },
  { "Aldo", 0.99902403 },
  { "Aldolfo", 1.0 },
  { "Aldon", 1.0 },
  { "Aldona", 0.0 },
  { "Aldonia", 0.0 },
  { "Aldonna", 0.0 },
  { "Aldor", 1.0 },
  { "Aldora", 0.0 },
  { "Aldoris", 0.0 },
  { "Aldous", 1.0 },
  { "Aldred", 1.0 },
  { "Aldren", 1.0 },
  { "Aldrena", 0.0 },
  { "Aldric", 1.0 },
  { "Aldrich", 1.0 },
  { "Aldrick", 1.0 },
  { "Aldridge", 1.0 },
  { "Aldrik", 1.0 },
  { "Aldrin", 1.0 },
  { "Aldrina", 0.0 },
  { "Alduin", 1.0 },
  { "Aldus", 1.0 },
  { "Aldwin", 1.0 },
  { "Aldyn", 0.68367344 },
  { "Aldyth", 0.0 },
  { "Ale", 0.61538464 },
  { "Alea", 0.0 },
  { "Aleacia", 0.0 },
  { "Aleah", 0.0 },
  { "Aleaha", 0.0 },
  { "Aleahya", 0.0 },
  { "Alean", 0.0 },
  { "Aleana", 0.0 },
  { "Aleanah", 0.0 },
  { "Aleander", 1.0 },
  { "Aleandra", 0.0 },
  { "Aleane", 0.0 },
  { "Aleanna", 0.0 },
  { "Aleara", 0.0 },
  { "Aleasa", 0.0 },
  { "Alease", 0.0 },
  { "Aleasha", 0.0 },
  { "Aleashia", 0.0 },
  { "Aleasia", 0.0 },
  { "Aleata", 0.0 },
  { "Aleatha", 0.0 },
  { "Aleathea", 0.0 },
  { "Aleathia", 0.0 },
  { "Aleatra", 0.0 },
  { "Aleaya", 0.0 },
  { "Aleayah", 0.0 },
  { "Alec", 0.9935015 },
  { "Aleca", 0.0 },
  { "Alecander", 1.0 },
  { "Aleccia", 0.0 },
  { "Alece", 0.0 },
  { "Alecea", 0.0 },
  { "Aleceia", 0.0 },
  { "Alecha", 0.0 },
  { "Alechia", 0.0 },
  { "Alecia", 0.0 },
  { "Aleciram", 0.0 },
  { "Aleck", 1.0 },
  { "Alecsa", 0.0 },
  { "Alecsander", 1.0 },
  { "Alecsandra", 0.0 },
  { "Alecsis", 0.0 },
  { "Alectra", 0.0 },
  { "Alecxa", 0.0 },
  { "Alecxander", 1.0 },
  { "Alecxia", 0.0 },
  { "Alecxis", 1.0 },
  { "Aleczander", 1.0 },
  { "Aleczandria", 0.0 },
  { "Aleda", 0.0 },
  { "Aledra", 0.0 },
  { "Alee", 0.12138728 },
  { "Aleea", 0.0 },
  { "Aleeah", 0.0 },
  { "Aleeana", 0.0 },
  { "Aleece", 0.0 },
  { "Aleecia", 0.0 },
  { "Aleecya", 0.0 },
  { "Aleeha", 0.0 },
  { "Aleeka", 0.0 },
  { "Aleela", 0.0 },
  { "Aleem", 1.0 },
  { "Aleema", 0.0 },
  { "Aleemah", 0.0 },
  { "Aleen", 0.0 },
  { "Aleena", 0.0 },
  { "Aleenah", 0.0 },
  { "Aleene", 0.0 },
  { "Aleera", 0.0 },
  { "Aleesa", 0.0 },
  { "Aleese", 0.0 },
  { "Aleesha", 0.0 },
  { "Aleeshia", 0.0 },
  { "Aleesia", 0.0 },
  { "Aleeta", 0.0 },
  { "Aleeya", 0.0 },
  { "Aleeyah", 0.0 },
  { "Aleeza", 0.0 },
  { "Aleezah", 0.0 },
  { "Aleezay", 0.0 },
  { "Alegacy", 0.0 },
  { "Alegandra", 0.0 },
  { "Alegandro", 1.0 },
  { "Alegend", 1.0 },
  { "Alegna", 0.0 },
  { "Alegra", 0.0 },
  { "Alegria", 0.0 },
  { "Aleha", 0.0 },
  { "Alei", 0.0 },
  { "Aleia", 0.0 },
  { "Aleiah", 0.0 },
  { "Aleicia", 0.0 },
  { "Aleida", 0.0 },
  { "Aleidy", 0.0 },
  { "Aleigh", 0.0 },
  { "Aleigha", 0.0 },
  { "Aleighana", 0.0 },
  { "Aleighanna", 0.0 },
  { "Aleighia", 0.0 },
  { "Aleighna", 0.0 },
  { "Aleighsha", 0.0 },
  { "Aleighya", 0.0 },
  { "Aleiha", 0.0 },
  { "Aleijah", 0.0 },
  { "Aleila", 0.0 },
  { "Aleily", 0.0 },
  { "Aleina", 0.0 },
  { "Aleinah", 0.0 },
  { "Aleine", 0.0 },
  { "Aleira", 0.0 },
  { "Aleisa", 0.0 },
  { "Aleise", 0.0 },
  { "Aleisha", 0.0 },
  { "Aleishia", 0.0 },
  { "Aleister", 1.0 },
  { "Aleita", 0.0 },
  { "Aleitha", 0.0 },
  { "Aleix", 1.0 },
  { "Aleiya", 0.0 },
  { "Aleiyah", 0.0 },
  { "Aleiza", 0.0 },
  { "Aleja", 0.0 },
  { "Alejadro", 1.0 },
  { "Alejah", 0.0 },
  { "Alejando", 1.0 },
  { "Alejandr", 1.0 },
  { "Alejandra", 0.010597283 },
  { "Alejandria", 0.0 },
  { "Alejandrina", 0.0 },
  { "Alejandro", 0.9935018 },
  { "Alejo", 1.0 },
  { "Alejondro", 1.0 },
  { "Alejos", 1.0 },
  { "Alek", 0.9819149 },
  { "Aleka", 0.0 },
  { "Alekai", 1.0 },
  { "Alekay", 1.0 },
  { "Alekhya", 0.0 },
  { "Aleki", 1.0 },
  { "Alekos", 1.0 },
  { "Aleks", 1.0 },
  { "Aleksa", 0.098615915 },
  { "Aleksah", 0.0 },
  { "Aleksandar", 1.0 },
  { "Aleksander", 1.0 },
  { "Aleksandr", 1.0 },
  { "Aleksandra", 0.0 },
  { "Aleksandre", 1.0 },
  { "Aleksandria", 0.0 },
  { "Aleksandrs", 1.0 },
  { "Aleksei", 0.9660057 },
  { "Aleksey", 0.9769053 },
  { "Aleksi", 0.70526314 },
  { "Aleksia", 0.0 },
  { "Aleksis", 0.06849315 },
  { "Aleksy", 1.0 },
  { "Alektra", 0.0 },
  { "Alekxa", 0.0 },
  { "Alekxander", 1.0 },
  { "Alekya", 0.0 },
  { "Alekza", 0.0 },
  { "Alekzander", 1.0 },
  { "Alekzandr", 1.0 },
  { "Alekzandra", 0.0 },
  { "Alela", 0.0 },
  { "Aleli", 0.0 },
  { "Alelia", 0.0 },
  { "Alely", 0.0 },
  { "Alem", 1.0 },
  { "Alema", 0.8076923 },
  { "Alen", 1.0 },
  { "Alena", 0.0 },
  { "Alenah", 0.0 },
  { "Alencia", 0.0 },
  { "Alenda", 0.0 },
  { "Alene", 0.00057650177 },
  { "Aleni", 0.0 },
  { "Alenia", 0.0 },
  { "Alenis", 0.0 },
  { "Alenka", 0.0 },
  { "Alenna", 0.0 },
  { "Alennah", 0.0 },
  { "Aleny", 0.0 },
  { "Aleona", 0.0 },
  { "Aleph", 0.91071427 },
  { "Aleq", 1.0 },
  { "Alera", 0.0 },
  { "Alerah", 0.0 },
  { "Aleria", 0.0 },
  { "Aleric", 1.0 },
  { "Alero", 0.0 },
  { "Aleron", 1.0 },
  { "Ales", 1.0 },
  { "Alesa", 0.0 },
  { "Alesana", 0.0 },
  { "Alesander", 1.0 },
  { "Alesandra", 0.0 },
  { "Alesandro", 1.0 },
  { "Alescia", 0.0 },
  { "Alese", 0.0 },
  { "Alesea", 0.0 },
  { "Alesha", 0.0008147746 },
  { "Aleshanee", 0.0 },
  { "Aleshea", 0.0 },
  { "Aleshia", 0.0 },
  { "Aleshka", 0.0 },
  { "Alesi", 0.0 },
  { "Alesia", 0.0 },
  { "Alesiram", 0.0 },
  { "Aleska", 0.0 },
  { "Alessa", 0.0 },
  { "Alessand", 1.0 },
  { "Alessander", 1.0 },
  { "Alessandra", 0.0 },
  { "Alessandria", 0.0 },
  { "Alessandro", 1.0 },
  { "Alessi", 0.0 },
  { "Alessia", 0.0 },
  { "Alessio", 1.0 },
  { "Alesso", 1.0 },
  { "Alessondra", 0.0 },
  { "Alessya", 0.0 },
  { "Alesya", 0.0 },
  { "Aleta", 0.0 },
  { "Aletha", 0.0 },
  { "Alethea", 0.0 },
  { "Aletheia", 0.0 },
  { "Alethia", 0.0 },
  { "Aletia", 0.0 },
  { "Aletra", 0.0 },
  { "Aletris", 0.0 },
  { "Aletse", 0.0 },
  { "Aletta", 0.0 },
  { "Alette", 0.0 },
  { "Aletza", 0.0 },
  { "Alevia", 0.0 },
  { "Alex", 0.968901 },
  { "Alexa", 0.0021406445 },
  { "Alexader", 1.0 },
  { "Alexadra", 0.0 },
  { "Alexah", 0.0 },
  { "Alexamarie", 0.0 },
  { "Alexan", 1.0 },
  { "Alexana", 0.0 },
  { "Alexand", 1.0 },
  { "Alexanda", 0.0 },
  { "Alexandar", 1.0 },
  { "Alexande", 1.0 },
  { "Alexander", 0.9932576 },
  { "Alexandera", 0.0 },
  { "Alexanderia", 0.0 },
  { "Alexanderjames", 1.0 },
  { "Alexandia", 0.0 },
  { "Alexandira", 0.0 },
  { "Alexandor", 1.0 },
  { "Alexandr", 0.5796089 },
  { "Alexandra", 0.003740996 },
  { "Alexandrah", 0.0 },
  { "Alexandre", 0.9694801 },
  { "Alexandrea", 0.0 },
  { "Alexandreia", 0.0 },
  { "Alexandrer", 1.0 },
  { "Alexandrew", 1.0 },
  { "Alexandria", 0.0023854715 },
  { "Alexandriah", 0.0 },
  { "Alexandrina", 0.0 },
  { "Alexandrine", 0.0 },
  { "Alexandro", 1.0 },
  { "Alexandros", 1.0 },
  { "Alexandru", 1.0 },
  { "Alexandrya", 0.0 },
  { "Alexaner", 1.0 },
  { "Alexann", 0.0 },
  { "Alexanna", 0.0 },
  { "Alexanndra", 0.0 },
  { "Alexanne", 0.0 },
  { "Alexanra", 0.0 },
  { "Alexarae", 0.0 },
  { "Alexaray", 0.0 },
  { "Alexas", 0.0 },
  { "Alexaundra", 0.0 },
  { "Alexaundrea", 0.0 },
  { "Alexaundria", 0.0 },
  { "Alexavia", 0.0 },
  { "Alexavier", 1.0 },
  { "Alexavior", 1.0 },
  { "Alexcia", 0.0 },
  { "Alexcis", 0.048672568 },
  { "Alexcya", 0.0 },
  { "Alexe", 0.0 },
  { "Alexea", 0.0 },
  { "Alexee", 0.0 },
  { "Alexei", 0.90346086 },
  { "Alexeia", 0.0 },
  { "Alexender", 1.0 },
  { "Alexendra", 0.0 },
  { "Alexendria", 0.0 },
  { "Alexes", 0.16567342 },
  { "Alexeus", 0.0 },
  { "Alexey", 0.95165396 },
  { "Alexeya", 0.0 },
  { "Alexi", 0.28046745 },
  { "Alexia", 0.0010367089 },
  { "Alexiah", 0.0 },
  { "Alexian", 1.0 },
  { "Alexiana", 0.0 },
  { "Alexianna", 0.0 },
  { "Alexias", 0.0 },
  { "Alexica", 0.0 },
  { "Alexicia", 0.0 },
  { "Alexie", 0.15139443 },
  { "Alexiea", 0.0 },
  { "Alexiel", 0.6666667 },
  { "Alexies", 0.0 },
  { "Alexina", 0.0 },
  { "Alexine", 0.0 },
  { "Alexio", 1.0 },
  { "Alexiona", 0.0 },
  { "Alexionna", 0.0 },
  { "Alexios", 1.0 },
  { "Alexious", 0.0 },
  { "Alexis", 0.15660518 },
  { "Alexisa", 0.0 },
  { "Alexisia", 0.0 },
  { "Alexisjade", 0.0 },
  { "Alexismarie", 0.0 },
  { "Alexisnicole", 0.0 },
  { "Alexisrose", 0.0 },
  { "Alexiss", 0.03649635 },
  { "Alexius", 0.07559926 },
  { "Alexix", 0.11904762 },
  { "Alexiya", 0.0 },
  { "Alexiyah", 0.0 },
  { "Alexiyana", 0.0 },
  { "Alexiz", 0.4844358 },
  { "Alexjandro", 1.0 },
  { "Alexnader", 1.0 },
  { "Alexnadra", 0.0 },
  { "Alexondra", 0.0 },
  { "Alexondria", 0.0 },
  { "Alexous", 0.0 },
  { "Alexs", 1.0 },
  { "Alexsa", 0.0 },
  { "Alexsander", 1.0 },
  { "Alexsandra", 0.0 },
  { "Alexsandria", 0.0 },
  { "Alexsandro", 1.0 },
  { "Alexsi", 1.0 },
  { "Alexsia", 0.0 },
  { "Alexsis", 0.13121547 },
  { "Alexson", 1.0 },
  { "Alexsondra", 0.0 },
  { "Alexssa", 0.0 },
  { "Alexsus", 0.0 },
  { "Alexsys", 0.0 },
  { "Alexuis", 0.0 },
  { "Alexus", 0.013048381 },
  { "Alexusia", 0.0 },
  { "Alexuss", 0.0 },
  { "Alexx", 0.63893807 },
  { "Alexxa", 0.0 },
  { "Alexxander", 1.0 },
  { "Alexxandra", 0.0 },
  { "Alexxandria", 0.0 },
  { "Alexxes", 0.0 },
  { "Alexxia", 0.0 },
  { "Alexxis", 0.005167959 },
  { "Alexxus", 0.0 },
  { "Alexxys", 0.0 },
  { "Alexy", 0.4465409 },
  { "Alexya", 0.0 },
  { "Alexyanna", 0.0 },
  { "Alexyia", 0.0 },
  { "Alexys", 0.08205244 },
  { "Alexyss", 0.0 },
  { "Alexyz", 0.0 },
  { "Alexz", 0.0 },
  { "Alexza", 0.0 },
  { "Alexzandar", 1.0 },
  { "Alexzander", 1.0 },
  { "Alexzandra", 0.0 },
  { "Alexzandrea", 0.0 },
  { "Alexzandria", 0.0 },
  { "Alexzandrya", 0.0 },
  { "Alexzandyr", 1.0 },
  { "Alexzavier", 1.0 },
  { "Alexzia", 0.0 },
  { "Alexzis", 0.0 },
  { "Aley", 0.15384616 },
  { "Aleya", 0.0 },
  { "Aleyah", 0.0 },
  { "Aleyana", 0.0 },
  { "Aleycia", 0.0 },
  { "Aleyda", 0.0 },
  { "Aleydis", 0.0 },
  { "Aleyha", 0.0 },
  { "Aleyia", 0.0 },
  { "Aleyiah", 0.0 },
  { "Aleyla", 0.0 },
  { "Aleyna", 0.0 },
  { "Aleynah", 0.0 },
  { "Aleynna", 0.0 },
  { "Aleysa", 0.0 },
  { "Aleyse", 0.0 },
  { "Aleysha", 0.0 },
  { "Aleyshka", 0.0 },
  { "Aleysia", 0.0 },
  { "Aleyssa", 0.0 },
  { "Aleyza", 0.0 },
  { "Alez", 1.0 },
  { "Aleza", 0.0 },
  { "Alezae", 0.0 },
  { "Alezander", 1.0 },
  { "Alezandra", 0.0 },
  { "Alezandria", 0.0 },
  { "Alezandro", 1.0 },
  { "Alezay", 0.0 },
  { "Alezia", 0.0 },
  { "Alf", 1.0 },
  { "Alfa", 0.020920502 },
  { "Alfair", 0.0 },
  { "Alfanette", 0.0 },
  { "Alfanso", 1.0 },
  { "Alfard", 1.0 },
  { "Alfaretta", 0.0 },
  { "Alferd", 1.0 },
  { "Alferdo", 1.0 },
  { "Alferetta", 0.0 },
  { "Alfhild", 0.0 },
  { "Alfia", 0.0 },
  { "Alfie", 0.82528406 },
  { "Alfio", 1.0 },
  { "Alfiya", 0.0 },
  { "Alfonce", 1.0 },
  { "Alfons", 1.0 },
  { "Alfonsa", 0.92903227 },
  { "Alfonse", 1.0 },
  { "Alfonsina", 0.0 },
  { "Alfonso", 0.99723274 },
  { "Alfonson", 1.0 },
  { "Alfonza", 1.0 },
  { "Alfonzia", 1.0 },
  { "Alfonzie", 1.0 },
  { "Alfonzo", 1.0 },
  { "Alford", 0.99895483 },
  { "Alfornia", 1.0 },
  { "Alfread", 1.0 },
  { "Alfreada", 0.0 },
  { "Alfred", 0.9946759 },
  { "Alfreda", 0.0030674846 },
  { "Alfreddie", 1.0 },
  { "Alfredia", 0.0 },
  { "Alfredo", 0.9947179 },
  { "Alfredrick", 1.0 },
  { "Alfreeda", 0.0 },
  { "Alfreida", 0.0 },
  { "Alfretta", 0.0 },
  { "Alfrida", 0.0 },
  { "Alfrieda", 0.0 },
  { "Alfy", 1.0 },
  { "Alga", 0.03649635 },
  { "Algean", 0.0 },
  { "Algene", 0.3218391 },
  { "Algenis", 1.0 },
  { "Alger", 1.0 },
  { "Algerd", 1.0 },
  { "Algeria", 0.0 },
  { "Algerine", 0.0 },
  { "Algernon", 1.0 },
  { "Algert", 1.0 },
  { "Algertha", 0.0 },
  { "Algia", 0.5576923 },
  { "Algie", 0.8089947 },
  { "Algin", 1.0 },
  { "Algird", 1.0 },
  { "Algirdas", 1.0 },
  { "Algis", 1.0 },
  { "Algot", 1.0 },
  { "Algy", 1.0 },
  { "Alhaji", 1.0 },
  { "Alhakim", 1.0 },
  { "Alham", 0.0 },
  { "Alhan", 1.0 },
  { "Alhana", 0.0 },
  { "Alhanouf", 0.0 },
  { "Alhasan", 1.0 },
  { "Alhassan", 1.0 },
  { "Alhassane", 1.0 },
  { "Alheli", 0.0 },
  { "Alhena", 0.0 },
  { "Alhia", 0.0 },
  { "Ali", 0.71903014 },
  { "Alia", 0.0 },
  { "Aliaa", 0.0 },
  { "Aliah", 0.0 },
  { "Aliaha", 0.0 },
  { "Aliahna", 0.0 },
  { "Alian", 1.0 },
  { "Aliana", 0.0 },
  { "Alianah", 0.0 },
  { "Aliandra", 0.0 },
  { "Aliani", 0.0 },
  { "Alianie", 0.0 },
  { "Alianis", 0.0 },
  { "Alianna", 0.0 },
  { "Aliannah", 0.0 },
  { "Alianne", 0.0 },
  { "Aliannie", 0.0 },
  { "Alianny", 0.0 },
  { "Aliannys", 0.0 },
  { "Aliany", 0.0 },
  { "Alianys", 0.0 },
  { "Alias", 1.0 },
  { "Aliauna", 0.0 },
  { "Aliaya", 0.0 },
  { "Aliayah", 0.0 },
  { "Aliaz", 1.0 },
  { "Alic", 1.0 },
  { "Alica", 0.0 },
  { "Alicai", 0.0 },
  { "Aliccia", 0.0 },
  { "Alice", 0.0034684525 },
  { "Alicea", 0.0 },
  { "Aliceann", 0.0 },
  { "Aliceia", 0.0 },
  { "Alicemae", 0.0 },
  { "Alicemarie", 0.0 },
  { "Alicen", 0.0 },
  { "Aliceson", 0.0 },
  { "Aliceteen", 0.0 },
  { "Aliceyn", 0.0 },
  { "Alicha", 0.0 },
  { "Alichia", 0.0 },
  { "Alicia", 0.003147272 },
  { "Aliciah", 0.0 },
  { "Aliciamarie", 0.0 },
  { "Alician", 0.0 },
  { "Aliciana", 0.0 },
  { "Alicianna", 0.0 },
  { "Aliciya", 0.0 },
  { "Alicja", 0.0 },
  { "Alick", 1.0 },
  { "Alicya", 0.0 },
  { "Alicyn", 0.0 },
  { "Alida", 0.0 },
  { "Alidia", 0.0 },
  { "Alidiya", 0.0 },
  { "Alie", 0.13138686 },
  { "Aliea", 0.0 },
  { "Alieah", 0.0 },
  { "Aliece", 0.0 },
  { "Aliecia", 0.0 },
  { "Alieda", 0.0 },
  { "Aliee", 0.0 },
  { "Alieen", 0.0 },
  { "Aliegha", 0.0 },
  { "Alien", 0.0 },
  { "Aliena", 0.0 },
  { "Aliene", 0.0 },
  { "Alienna", 0.0 },
  { "Aliera", 0.0 },
  { "Aliesa", 0.0 },
  { "Aliese", 0.0 },
  { "Aliesha", 0.0 },
  { "Alieshia", 0.0 },
  { "Aliette", 0.0 },
  { "Alieu", 1.0 },
  { "Alieya", 0.0 },
  { "Alieyah", 0.0 },
  { "Alieza", 0.0 },
  { "Aliezah", 0.0 },
  { "Alif", 1.0 },
  { "Alifa", 0.0 },
  { "Aliha", 0.0 },
  { "Alii", 0.85714287 },
  { "Aliina", 0.0 },
  { "Aliisa", 0.0 },
  { "Aliiyah", 0.0 },
  { "Alija", 0.6036036 },
  { "Alijah", 0.88125604 },
  { "Alijandra", 0.0 },
  { "Alijandro", 1.0 },
  { "Alijha", 0.7962963 },
  { "Alijiah", 1.0 },
  { "Alik", 0.9831081 },
  { "Alika", 0.5404377 },
  { "Alikah", 0.0 },
  { "Alikai", 1.0 },
  { "Alike", 0.0 },
  { "Alikhan", 1.0 },
  { "Aliki", 0.0 },
  { "Alila", 0.0 },
  { "Alilah", 0.0 },
  { "Alilia", 0.0 },
  { "Aliliana", 0.0 },
  { "Alilyana", 0.0 },
  { "Alim", 1.0 },
  { "Alima", 0.0 },
  { "Alimah", 0.0 },
  { "Alimatou", 0.0 },
  { "Alin", 0.24423076 },
  { "Alina", 0.0 },
  { "Alinah", 0.0 },
  { "Alinda", 0.0 },
  { "Aline", 0.00034884532 },
  { "Alinea", 0.0 },
  { "Alinna", 0.0 },
  { "Alinne", 0.0 },
  { "Alinson", 0.0 },
  { "Aliona", 0.0 },
  { "Alionna", 0.0 },
  { "Aliou", 1.0 },
  { "Alioune", 1.0 },
  { "Alique", 0.5 },
  { "Alira", 0.0 },
  { "Alirah", 0.0 },
  { "Alireza", 1.0 },
  { "Alis", 0.015625 },
  { "Alisa", 0.00066644454 },
  { "Alisabeth", 0.0 },
  { "Alisah", 0.0 },
  { "Alisan", 0.0 },
  { "Alisana", 0.0 },
  { "Alisande", 0.0 },
  { "Alisandra", 0.0 },
  { "Alischa", 0.0 },
  { "Aliscia", 0.0 },
  { "Alise", 0.0 },
  { "Alisea", 0.0 },
  { "Alisen", 0.0 },
  { "Alish", 0.0 },
  { "Alisha", 0.0023789203 },
  { "Alishaba", 0.0 },
  { "Alishah", 0.083333336 },
  { "Alishan", 1.0 },
  { "Alishba", 0.0 },
  { "Alishea", 0.0 },
  { "Alisher", 1.0 },
  { "Alishia", 0.0 },
  { "Alishya", 0.0 },
  { "Alisi", 0.0 },
  { "Alisia", 0.0 },
  { "Alisiah", 0.0 },
  { "Alisiana", 0.0 },
  { "Aliska", 0.0 },
  { "Alison", 0.005302962 },
  { "Aliss", 0.0 },
  { "Alissa", 0.0008326842 },
  { "Alissabeth", 0.0 },
  { "Alissah", 0.0 },
  { "Alissandra", 0.0 },
  { "Alisse", 0.0 },
  { "Alissha", 0.0 },
  { "Alissia", 0.0 },
  { "Alisson", 0.0 },
  { "Alissondra", 0.0 },
  { "Alissya", 0.0 },
  { "Alista", 0.0 },
  { "Alistair", 1.0 },
  { "Alistaire", 1.0 },
  { "Alistar", 1.0 },
  { "Alister", 1.0 },
  { "Alisun", 0.0 },
  { "Alisya", 0.0 },
  { "Alisyn", 0.0 },
  { "Alisynn", 0.0 },
  { "Alita", 0.0 },
  { "Alitha", 0.0 },
  { "Alithea", 0.0 },
  { "Alithia", 0.0 },
  { "Alitia", 0.0 },
  { "Alitza", 0.0 },
  { "Alitzah", 0.0 },
  { "Alitzel", 0.0 },
  { "Alius", 1.0 },
  { "Aliva", 0.0 },
  { "Alivea", 0.0 },
  { "Aliveah", 0.0 },
  { "Aliveya", 0.0 },
  { "Alivia", 0.0003974563 },
  { "Aliviah", 0.0 },
  { "Aliviana", 0.0 },
  { "Alivianna", 0.0 },
  { "Aliviya", 0.0 },
  { "Aliviyah", 0.0 },
  { "Alivn", 1.0 },
  { "Alivya", 0.0 },
  { "Alivyah", 0.0 },
  { "Alix", 0.20876777 },
  { "Alixa", 0.0 },
  { "Alixander", 1.0 },
  { "Alixandra", 0.0 },
  { "Alixandrea", 0.0 },
  { "Alixandria", 0.0 },
  { "Alixe", 0.0 },
  { "Alixia", 0.0 },
  { "Alixis", 0.0 },
  { "Alixon", 0.0 },
  { "Alixx", 0.0 },
  { "Alixzander", 1.0 },
  { "Alixzandria", 0.0 },
  { "Aliya", 0.0 },
  { "Aliyaah", 0.0 },
  { "Aliyaan", 1.0 },
  { "Aliyah", 0.0009307836 },
  { "Aliyaha", 0.0 },
  { "Aliyahmarie", 0.0 },
  { "Aliyahna", 0.0 },
  { "Aliyan", 0.7659575 },
  { "Aliyana", 0.0 },
  { "Aliyanah", 0.0 },
  { "Aliyani", 0.0 },
  { "Aliyanna", 0.0 },
  { "Aliyannah", 0.0 },
  { "Aliyas", 1.0 },
  { "Aliye", 0.0 },
  { "Aliyha", 0.0 },
  { "Aliyia", 0.0 },
  { "Aliyiah", 0.0 },
  { "Aliyna", 0.0 },
  { "Aliyonna", 0.0 },
  { "Aliysha", 0.0 },
  { "Aliyssa", 0.0 },
  { "Aliyya", 0.0 },
  { "Aliyyah", 0.0 },
  { "Aliz", 0.0 },
  { "Aliza", 0.00061387353 },
  { "Alizabella", 0.0 },
  { "Alizabeth", 0.0 },
  { "Alizae", 0.005740528 },
  { "Alizah", 0.006443299 },
  { "Alizai", 0.0 },
  { "Alizander", 1.0 },
  { "Alizandra", 0.0 },
  { "Alizay", 0.0068775793 },
  { "Alizaya", 0.0 },
  { "Alizayah", 0.0 },
  { "Alizaye", 0.0 },
  { "Alize", 0.0629152 },
  { "Alizea", 0.0 },
  { "Alizeah", 0.0 },
  { "Alizee", 0.0 },
  { "Alizeh", 0.0 },
  { "Alizet", 0.0 },
  { "Alizette", 0.0 },
  { "Alizey", 0.0 },
  { "Alizeya", 0.0 },
  { "Alizia", 0.0 },
  { "Aliziah", 0.0 },
  { "Alizon", 0.0 },
  { "Alizza", 0.0 },
  { "Alizzon", 0.0 },
  { "Aljandro", 1.0 },
  { "Aljaquan", 1.0 },
  { "Aljawhara", 0.0 },
  { "Aljay", 1.0 },
  { "Aljean", 0.0 },
  { "Aljohara", 0.0 },
  { "Aljoharah", 0.0 },
  { "Alka", 0.0 },
  { "Alkeem", 1.0 },
  { "Alkeria", 0.0 },
  { "Alla", 0.008718396 },
  { "Allah", 0.90697676 },
  { "Allahna", 0.0 },
  { "Allaina", 0.0 },
  { "Allaire", 0.0 },
  { "Allam", 1.0 },
  { "Allan", 0.99731266 },
  { "Allana", 0.0 },
  { "Allanah", 0.0 },
  { "Allandra", 0.0 },
  { "Allani", 0.0 },
  { "Allanie", 0.0 },
  { "Allanmichael", 1.0 },
  { "Allanna", 0.0 },
  { "Allannah", 0.0 },
  { "Allante", 0.77834177 },
  { "Allard", 1.0 },
  { "Allasia", 0.0 },
  { "Allateef", 1.0 },
  { "Allaura", 0.0 },
  { "Allaya", 0.0 },
  { "Allayah", 0.0 },
  { "Allayna", 0.0 },
  { "Allaynah", 0.0 },
  { "Allayne", 0.0 },
  { "Alle", 0.0 },
  { "Allea", 0.0 },
  { "Alleah", 0.0 },
  { "Allean", 0.0 },
  { "Alleana", 0.0 },
  { "Alleane", 0.0 },
  { "Allec", 1.0 },
  { "Allecia", 0.0 },
  { "Allee", 0.0 },
  { "Alleen", 0.0 },
  { "Alleena", 0.0 },
  { "Alleene", 0.0 },
  { "Allegra", 0.0 },
  { "Alleigh", 0.0 },
  { "Alleigha", 0.0 },
  { "Alleine", 0.0 },
  { "Alleisha", 0.0 },
  { "Allejah", 0.0 },
  { "Allen", 0.99310875 },
  { "Allena", 0.0 },
  { "Allenah", 0.0 },
  { "Allenby", 1.0 },
  { "Allene", 0.00057110225 },
  { "Allenmichael", 1.0 },
  { "Allenna", 0.0 },
  { "Allera", 0.0 },
  { "Alleria", 0.0 },
  { "Allesandra", 0.0 },
  { "Allese", 0.0 },
  { "Allesha", 0.0 },
  { "Alleshia", 0.0 },
  { "Allesia", 0.0 },
  { "Alleson", 0.0 },
  { "Allessa", 0.0 },
  { "Allessandra", 0.0 },
  { "Alleta", 0.0 },
  { "Alletha", 0.0 },
  { "Alletta", 0.0 },
  { "Allex", 0.7078189 },
  { "Allexa", 0.0 },
  { "Allexander", 1.0 },
  { "Allexandra", 0.0 },
  { "Allexandria", 0.0 },
  { "Allexia", 0.0 },
  { "Allexis", 0.0 },
  { "Allexus", 0.0 },
  { "Allexys", 0.0 },
  { "Alley", 0.042 },
  { "Alleya", 0.0 },
  { "Alleyah", 0.0 },
  { "Alleyna", 0.0 },
  { "Alleyne", 0.0 },
  { "Alli", 0.0014257199 },
  { "Allia", 0.0 },
  { "Alliah", 0.0 },
  { "Alliana", 0.0 },
  { "Allianah", 0.0 },
  { "Allianna", 0.0 },
  { "Alliannah", 0.0 },
  { "Allias", 1.0 },
  { "Allice", 0.0 },
  { "Allicen", 0.0 },
  { "Allicia", 0.0 },
  { "Allicyn", 0.0 },
  { "Allida", 0.0 },
  { "Allie", 0.0628169 },
  { "Allieana", 0.0 },
  { "Allieanna", 0.0 },
  { "Alliee", 0.0 },
  { "Alliemae", 0.0 },
  { "Allien", 0.0 },
  { "Alliene", 0.0 },
  { "Allijah", 1.0 },
  { "Allimae", 0.0 },
  { "Allin", 1.0 },
  { "Allina", 0.0 },
  { "Allinah", 0.0 },
  { "Alline", 0.0 },
  { "Allinson", 0.0 },
  { "Alliona", 0.0 },
  { "Allionna", 0.0 },
  { "Allis", 0.0 },
  { "Allisa", 0.0 },
  { "Allisan", 0.0 },
  { "Allisandra", 0.0 },
  { "Allise", 0.0 },
  { "Allisen", 0.0 },
  { "Allisha", 0.0 },
  { "Allishia", 0.0 },
  { "Allisia", 0.0 },
  { "Allisin", 0.0 },
  { "Allison", 0.012823079 },
  { "Allissa", 0.0 },
  { "Allissia", 0.0 },
  { "Allisson", 0.0 },
  { "Allistair", 1.0 },
  { "Allister", 0.99182564 },
  { "Allisun", 0.0 },
  { "Allisyn", 0.0 },
  { "Allita", 0.0 },
  { "Allivia", 0.0 },
  { "Allix", 0.0 },
  { "Alliya", 0.0 },
  { "Alliyah", 0.0 },
  { "Alliyana", 0.0 },
  { "Alliyiah", 0.0 },
  { "Allizae", 0.0 },
  { "Allize", 0.0 },
  { "Allizon", 0.0 },
  { "Allizzon", 0.0 },
  { "Allon", 1.0 },
  { "Allona", 0.0 },
  { "Allonah", 0.0 },
  { "Allondra", 0.0 },
  { "Allonte", 1.0 },
  { "Allonzo", 1.0 },
  { "Allora", 0.0 },
  { "Allorah", 0.0 },
  { "Allory", 0.0 },
  { "Allsion", 0.0 },
  { "Allson", 0.0 },
  { "Allston", 1.0 },
  { "Allura", 0.0 },
  { "Allure", 0.0 },
  { "Allwin", 1.0 },
  { "Ally", 0.0011243535 },
  { "Allya", 0.0 },
  { "Allyah", 0.0 },
  { "Allyana", 0.0 },
  { "Allyanah", 0.0 },
  { "Allyanna", 0.0 },
  { "Allyannah", 0.0 },
  { "Allyce", 0.0 },
  { "Allycia", 0.0 },
  { "Allye", 0.0 },
  { "Allyiah", 0.0 },
  { "Allyn", 0.63410264 },
  { "Allyna", 0.0 },
  { "Allyne", 0.0 },
  { "Allynn", 0.0 },
  { "Allyonna", 0.0 },
  { "Allyra", 0.0 },
  { "Allyria", 0.0 },
  { "Allysa", 0.0 },
  { "Allysah", 0.0 },
  { "Allysan", 0.0 },
  { "Allysandra", 0.0 },
  { "Allyse", 0.0 },
  { "Allysen", 0.0 },
  { "Allysha", 0.0 },
  { "Allyshia", 0.0 },
  { "Allysia", 0.0 },
  { "Allysin", 0.0 },
  { "Allyson", 0.0004188774 },
  { "Allyssa", 0.0 },
  { "Allyssah", 0.0 },
  { "Allysse", 0.0 },
  { "Allyssia", 0.0 },
  { "Allysson", 0.0 },
  { "Allysun", 0.0 },
  { "Allysyn", 0.0 },
  { "Allyx", 0.0 },
  { "Allyza", 0.0 },
  { "Allyzon", 0.0 },
  { "Alma", 0.013498957 },
  { "Almadelia", 0.0 },
  { "Almae", 0.0 },
  { "Almalik", 1.0 },
  { "Alman", 1.0 },
  { "Almanda", 0.0 },
  { "Almando", 1.0 },
  { "Almanzo", 1.0 },
  { "Almar", 0.0 },
  { "Almaree", 0.0 },
  { "Almarene", 0.0 },
  { "Almarie", 0.0 },
  { "Almarine", 0.0 },
  { "Almarion", 1.0 },
  { "Almarosa", 0.0 },
  { "Almas", 0.0 },
  { "Almatine", 0.0 },
  { "Almaz", 0.0 },
  { "Almeada", 0.0 },
  { "Almeater", 0.0 },
  { "Almeda", 0.0 },
  { "Almedia", 0.0 },
  { "Almedin", 1.0 },
  { "Almedina", 0.0 },
  { "Almee", 0.0 },
  { "Almeer", 1.0 },
  { "Almena", 0.0 },
  { "Almendra", 0.0 },
  { "Almenia", 0.0 },
  { "Almer", 0.6345062 },
  { "Almera", 0.0 },
  { "Almeria", 0.0 },
  { "Almerinda", 0.0 },
  { "Almeta", 0.0 },
  { "Almeter", 0.0 },
  { "Almetia", 0.0 },
  { "Almetra", 0.0 },
  { "Almetta", 0.0 },
  { "Almetter", 0.0 },
  { "Almida", 0.0 },
  { "Almin", 1.0 },
  { "Almina", 0.0 },
  { "Almir", 1.0 },
  { "Almira", 0.0 },
  { "Almitra", 0.0 },
  { "Almo", 0.79452056 },
  { "Almon", 0.9889367 },
  { "Almond", 1.0 },
  { "Almondo", 1.0 },
  { "Almonte", 1.0 },
  { "Almonza", 1.0 },
  { "Almonzo", 1.0 },
  { "Almore", 1.0 },
  { "Almos", 1.0 },
  { "Almous", 1.0 },
  { "Almudena", 0.0 },
  { "Almus", 1.0 },
  { "Almyra", 0.0 },
  { "Alna", 0.0 },
  { "Alneisha", 0.0 },
  { "Alnesha", 0.0 },
  { "Alnetia", 0.0 },
  { "Alnisa", 0.0 },
  { "Alnisha", 0.0 },
  { "Alnita", 0.0 },
  { "Alnora", 0.0 },
  { "Alo", 1.0 },
  { "Aloa", 0.0 },
  { "Aloah", 0.0 },
  { "Alodie", 0.0 },
  { "Aloe", 0.0 },
  { "Aloha", 0.0 },
  { "Alohi", 0.0 },
  { "Alohilani", 0.0 },
  { "Alohna", 0.0 },
  { "Alois", 0.92978483 },
  { "Aloise", 0.21875 },
  { "Aloisius", 1.0 },
  { "Alok", 1.0 },
  { "Aloma", 0.0 },
  { "Alon", 0.97565925 },
  { "Alona", 0.0 },
  { "Alonah", 0.0 },
  { "Alonda", 0.0 },
  { "Alondo", 1.0 },
  { "Alondra", 0.0033023849 },
  { "Alondre", 1.0 },
  { "Alondrea", 0.0 },
  { "Alondria", 0.0 },
  { "Aloni", 0.0 },
  { "Alonia", 0.0 },
  { "Alonie", 0.0 },
  { "Alonii", 0.0 },
  { "Alonna", 0.0 },
  { "Alonnah", 0.0 },
  { "Alonni", 0.0 },
  { "Alonnie", 0.0 },
  { "Alonso", 1.0 },
  { "Alonta", 1.0 },
  { "Alontae", 1.0 },
  { "Alontay", 1.0 },
  { "Alonte", 0.9856115 },
  { "Alonya", 0.0 },
  { "Alonza", 0.99819005 },
  { "Alonzia", 0.22727273 },
  { "Alonzo", 0.99621713 },
  { "Alora", 0.0 },
  { "Alorah", 0.0 },
  { "Alori", 0.0 },
  { "Aloria", 0.0 },
  { "Alouise", 0.0 },
  { "Aloura", 0.0 },
  { "Aloys", 1.0 },
  { "Aloyse", 0.0 },
  { "Aloysia", 0.0 },
  { "Aloysious", 1.0 },
  { "Aloysius", 1.0 },
  { "Aloysuis", 1.0 },
  { "Alp", 1.0 },
  { "Alpa", 0.0 },
  { "Alper", 1.0 },
  { "Alperen", 1.0 },
  { "Alpesh", 1.0 },
  { "Alph", 1.0 },
  { "Alpha", 0.24501696 },
  { "Alpharetta", 0.0 },
  { "Alphe", 1.0 },
  { "Alphea", 0.0 },
  { "Alphee", 1.0 },
  { "Alpheus", 1.0 },
  { "Alphia", 0.0 },
  { "Alphie", 1.0 },
  { "Alphild", 0.0 },
  { "Alphine", 0.0 },
  { "Alphon", 1.0 },
  { "Alphonce", 1.0 },
  { "Alphones", 1.0 },
  { "Alphons", 1.0 },
  { "Alphonsa", 1.0 },
  { "Alphonse", 1.0 },
  { "Alphonsine", 0.0 },
  { "Alphonso", 0.99820095 },
  { "Alphonsus", 1.0 },
  { "Alphonza", 1.0 },
  { "Alphonzo", 1.0 },
  { "Alphus", 1.0 },
  { "Alphy", 1.0 },
  { "Alpine", 0.0 },
  { "Alprentice", 1.0 },
  { "Alquan", 1.0 },
  { "Alquin", 1.0 },
  { "Alrahman", 1.0 },
  { "Alray", 1.0 },
  { "Alreem", 0.0 },
  { "Alric", 1.0 },
  { "Alrick", 1.0 },
  { "Alrik", 1.0 },
  { "Alrita", 0.0 },
  { "Alroy", 1.0 },
  { "Alsa", 0.0 },
  { "Alsace", 0.0 },
  { "Alsatia", 0.0 },
  { "Alsexander", 1.0 },
  { "Alsha", 0.0 },
  { "Alshawn", 1.0 },
  { "Alshon", 1.0 },
  { "Alsie", 0.0 },
  { "Alsiha", 0.0 },
  { "Alsion", 0.0 },
  { "Alson", 1.0 },
  { "Alston", 0.99285716 },
  { "Alta", 0.004065323 },
  { "Altaf", 1.0 },
  { "Altagracia", 0.0 },
  { "Altair", 0.46919432 },
  { "Altaira", 0.0 },
  { "Altamae", 0.0 },
  { "Altamease", 0.0 },
  { "Altamese", 0.0 },
  { "Altan", 1.0 },
  { "Altarik", 1.0 },
  { "Altariq", 1.0 },
  { "Altavious", 1.0 },
  { "Altay", 1.0 },
  { "Altee", 0.0 },
  { "Alten", 1.0 },
  { "Alter", 0.94690263 },
  { "Alterick", 1.0 },
  { "Alterik", 1.0 },
  { "Altermease", 0.0 },
  { "Altha", 0.0062038405 },
  { "Althea", 0.00030255356 },
  { "Altheda", 0.0 },
  { "Altheia", 0.0 },
  { "Althelia", 0.0 },
  { "Althena", 0.0 },
  { "Althera", 0.0 },
  { "Altheria", 0.0 },
  { "Althia", 0.0 },
  { "Altia", 0.0 },
  { "Altie", 0.015151516 },
  { "Altin", 1.0 },
  { "Altina", 0.0 },
  { "Alto", 0.9476351 },
  { "Alton", 0.9919629 },
  { "Altonette", 0.0 },
  { "Altonia", 0.5833333 },
  { "Altonio", 1.0 },
  { "Altonya", 0.0 },
  { "Altoria", 0.0 },
  { "Altouise", 0.0 },
  { "Altovese", 0.0 },
  { "Altovise", 0.0 },
  { "Altrice", 0.0 },
  { "Altrina", 0.0 },
  { "Altus", 1.0 },
  { "Alucard", 1.0 },
  { "Aluel", 0.0 },
  { "Alula", 1.0 },
  { "Aluna", 0.0 },
  { "Alundra", 0.0 },
  { "Alura", 0.0 },
  { "Alusine", 1.0 },
  { "Alva", 0.5644868 },
  { "Alvada", 0.0 },
  { "Alvah", 0.9614561 },
  { "Alvan", 1.0 },
  { "Alvana", 0.0 },
  { "Alvania", 0.0 },
  { "Alvar", 1.0 },
  { "Alvaretta", 0.0 },
  { "Alvarez", 1.0 },
  { "Alvaro", 0.99965894 },
  { "Alve", 1.0 },
  { "Alveda", 0.0 },
  { "Alveena", 0.0 },
  { "Alveiro", 1.0 },
  { "Alven", 1.0 },
  { "Alvena", 0.0 },
  { "Alvene", 0.0 },
  { "Alvenia", 0.0 },
  { "Alver", 0.9596774 },
  { "Alvera", 0.0 },
  { "Alverda", 0.0 },
  { "Alveretta", 0.0 },
  { "Alveria", 0.0 },
  { "Alvern", 0.7236842 },
  { "Alverna", 0.0 },
  { "Alverne", 0.0 },
  { "Alvernia", 0.0 },
  { "Alvernon", 1.0 },
  { "Alvert", 1.0 },
  { "Alverta", 0.0 },
  { "Alvertia", 0.0 },
  { "Alvertis", 1.0 },
  { "Alverto", 1.0 },
  { "Alvery", 1.0 },
  { "Alves", 1.0 },
  { "Alvesta", 0.0 },
  { "Alvester", 1.0 },
  { "Alveta", 0.0 },
  { "Alvetta", 0.0 },
  { "Alvey", 1.0 },
  { "Alvi", 1.0 },
  { "Alvia", 0.5325301 },
  { "Alvida", 0.0 },
  { "Alvie", 0.8709398 },
  { "Alvieri", 1.0 },
  { "Alviery", 1.0 },
  { "Alvilda", 0.0 },
  { "Alvilde", 0.0 },
  { "Alvin", 0.99310064 },
  { "Alvina", 0.00048444918 },
  { "Alvine", 0.040983606 },
  { "Alvinia", 0.0 },
  { "Alvino", 1.0 },
  { "Alvion", 1.0 },
  { "Alvira", 0.0 },
  { "Alvis", 0.93979686 },
  { "Alvita", 0.0 },
  { "Alvoid", 1.0 },
  { "Alvon", 1.0 },
  { "Alvonia", 0.0 },
  { "Alvontae", 1.0 },
  { "Alvonte", 1.0 },
  { "Alvord", 1.0 },
  { "Alvy", 1.0 },
  { "Alvyn", 1.0 },
  { "Alwaleed", 1.0 },
  { "Alward", 1.0 },
  { "Alwayne", 0.0 },
  { "Alwilda", 0.0 },
  { "Alwillie", 0.0 },
  { "Alwin", 1.0 },
  { "Alwina", 0.0 },
  { "Alwine", 0.0 },
  { "Alwood", 1.0 },
  { "Alwyn", 0.9789644 },
  { "Alxander", 1.0 },
  { "Alxavier", 1.0 },
  { "Alxis", 0.0 },
  { "Aly", 0.35123184 },
  { "Alya", 0.0 },
  { "Alyaa", 0.0 },
  { "Alyaan", 1.0 },
  { "Alyah", 0.0 },
  { "Alyan", 1.0 },
  { "Alyana", 0.0 },
  { "Alyanah", 0.0 },
  { "Alyanna", 0.0 },
  { "Alyannah", 0.0 },
  { "Alyas", 1.0 },
  { "Alyasia", 0.0 },
  { "Alyca", 0.0 },
  { "Alyce", 0.0 },
  { "Alycea", 0.0 },
  { "Alycee", 0.0 },
  { "Alyceia", 0.0 },
  { "Alycen", 0.0 },
  { "Alycia", 0.0 },
  { "Alyciah", 0.0 },
  { "Alyciana", 0.0 },
  { "Alyda", 0.0 },
  { "Alydia", 0.0 },
  { "Alye", 0.0 },
  { "Alyea", 0.0 },
  { "Alyena", 0.0 },
  { "Alyene", 0.0 },
  { "Alyese", 0.0 },
  { "Alyeska", 0.0 },
  { "Alyessa", 0.0 },
  { "Alyha", 0.0 },
  { "Alyia", 0.0 },
  { "Alyiah", 0.0 },
  { "Alyiana", 0.0 },
  { "Alyias", 1.0 },
  { "Alyicia", 0.0 },
  { "Alyis", 1.0 },
  { "Alyisa", 0.0 },
  { "Alyissa", 0.0 },
  { "Alyjah", 0.8409894 },
  { "Alyk", 1.0 },
  { "Alyka", 0.0 },
  { "Alyla", 0.0 },
  { "Alylah", 0.0 },
  { "Alympia", 0.0 },
  { "Alymuhammad", 1.0 },
  { "Alyn", 0.4279661 },
  { "Alyna", 0.0 },
  { "Alynah", 0.0 },
  { "Alyncia", 0.0 },
  { "Alynda", 0.0 },
  { "Alyne", 0.0 },
  { "Alynia", 0.0 },
  { "Alynn", 0.0 },
  { "Alynna", 0.0 },
  { "Alynnah", 0.0 },
  { "Alynne", 0.0 },
  { "Alyona", 0.0 },
  { "Alyonna", 0.0 },
  { "Alyosha", 1.0 },
  { "Alyra", 0.0 },
  { "Alyrah", 0.0 },
  { "Alyre", 1.0 },
  { "Alyria", 0.0 },
  { "Alyric", 0.048387095 },
  { "Alyrica", 0.0 },
  { "Alys", 0.0 },
  { "Alysa", 0.0 },
  { "Alysabeth", 0.0 },
  { "Alysah", 0.0 },
  { "Alysan", 0.0 },
  { "Alysandra", 0.0 },
  { "Alyscia", 0.0 },
  { "Alyse", 0.0 },
  { "Alysea", 0.0 },
  { "Alysen", 0.0 },
  { "Alysha", 0.0 },
  { "Alyshea", 0.0 },
  { "Alyshia", 0.0 },
  { "Alysia", 0.0 },
  { "Alysiah", 0.0 },
  { "Alysiana", 0.0 },
  { "Alysianna", 0.0 },
  { "Alysin", 0.0 },
  { "Alyson", 0.00036241076 },
  { "Alyss", 0.0 },
  { "Alyssa", 0.0014270047 },
  { "Alyssaann", 0.0 },
  { "Alyssabeth", 0.0 },
  { "Alyssah", 0.0 },
  { "Alyssamae", 0.0 },
  { "Alyssamarie", 0.0 },
  { "Alyssandra", 0.0 },
  { "Alyssanicole", 0.0 },
  { "Alyssarae", 0.0 },
  { "Alyssarose", 0.0 },
  { "Alysse", 0.0 },
  { "Alyssea", 0.0 },
  { "Alyssha", 0.0 },
  { "Alyssia", 0.0 },
  { "Alysson", 0.0 },
  { "Alyssum", 0.0 },
  { "Alyssya", 0.0 },
  { "Alysta", 0.0 },
  { "Alyster", 1.0 },
  { "Alysun", 0.0 },
  { "Alythia", 0.0 },
  { "Alyus", 1.0 },
  { "Alyvea", 0.0 },
  { "Alyvia", 0.0 },
  { "Alyviah", 0.0 },
  { "Alywin", 1.0 },
  { "Alyx", 0.10144927 },
  { "Alyxa", 0.0 },
  { "Alyxander", 1.0 },
  { "Alyxandra", 0.0 },
  { "Alyxandrea", 0.0 },
  { "Alyxandria", 0.0 },
  { "Alyxia", 0.0 },
  { "Alyxis", 0.0 },
  { "Alyxus", 0.0 },
  { "Alyxzander", 1.0 },
  { "Alyza", 0.0 },
  { "Alyzabeth", 0.0 },
  { "Alyzae", 0.0 },
  { "Alyzah", 0.0 },
  { "Alyze", 0.0 },
  { "Alyzea", 0.0 },
  { "Alyzia", 0.0 },
  { "Alyzon", 0.0 },
  { "Alyzza", 0.0 },
  { "Alza", 0.0 },
  { "Alzada", 0.0 },
  { "Alzahra", 0.0 },
  { "Alzain", 0.0 },
  { "Alzata", 0.0 },
  { "Alzena", 0.0 },
  { "Alzenia", 0.0 },
  { "Alzie", 0.0 },
  { "Alzina", 0.0 },
  { "Alzira", 0.0 },
  { "Alzonia", 0.0 },
  { "Alzora", 0.0 },
  { "Ama", 0.0 },
  { "Amaad", 1.0 },
  { "Amaal", 0.0 },
  { "Amaan", 1.0 },
  { "Amaani", 0.0 },
  { "Amaar", 1.0 },
  { "Amaari", 1.0 },
  { "Amabel", 0.0 },
  { "Amabella", 0.0 },
  { "Amabelle", 0.0 },
  { "Amad", 1.0 },
  { "Amada", 0.0 },
  { "Amadea", 0.0 },
  { "Amadeo", 1.0 },
  { "Amadeus", 1.0 },
  { "Amadi", 0.4448276 },
  { "Amadis", 0.0 },
  { "Amadita", 0.0 },
  { "Amado", 1.0 },
  { "Amador", 1.0 },
  { "Amadou", 1.0 },
  { "Amadu", 1.0 },
  { "Amagine", 0.0 },
  { "Amahd", 1.0 },
  { "Amahia", 0.0 },
  { "Amahni", 0.0 },
  { "Amahri", 0.65957445 },
  { "Amahya", 0.0 },
  { "Amai", 0.0 },
  { "Amaia", 0.0 },
  { "Amaiah", 0.0 },
  { "Amaijah", 0.0 },
  { "Amair", 1.0 },
  { "Amaira", 0.0 },
  { "Amairah", 0.0 },
  { "Amairani", 0.0 },
  { "Amairany", 0.0 },
  { "Amaire", 1.0 },
  { "Amais", 1.0 },
  { "Amaiya", 0.0 },
  { "Amaiyah", 0.0 },
  { "Amaj", 1.0 },
  { "Amaja", 0.0 },
  { "Amajae", 1.0 },
  { "Amajah", 0.0 },
  { "Amaje", 1.0 },
  { "Amaka", 0.0 },
  { "Amal", 0.105860114 },
  { "Amala", 0.0 },
  { "Amalea", 0.0 },
  { "Amaleah", 0.0 },
  { "Amalee", 0.0 },
  { "Amali", 0.0 },
  { "Amalia", 0.0 },
  { "Amaliah", 0.0 },
  { "Amalie", 0.0 },
  { "Amalin", 0.0 },
  { "Amalina", 0.0 },
  { "Amalio", 1.0 },
  { "Amaliya", 0.0 },
  { "Amalthea", 0.0 },
  { "Amaly", 0.0 },
  { "Amalya", 0.0 },
  { "Amalyah", 0.0 },
  { "Amalyn", 0.0 },
  { "Amamda", 0.0 },
  { "Aman", 0.9211148 },
  { "Amana", 0.0 },
  { "Amanada", 0.0 },
  { "Amanah", 0.0 },
  { "Amanat", 0.0 },
  { "Amancio", 1.0 },
  { "Amand", 0.0 },
  { "Amanda", 0.0027199944 },
  { "Amandah", 0.0 },
  { "Amandajean", 0.0 },
  { "Amandajo", 0.0 },
  { "Amandalee", 0.0 },
  { "Amandaleigh", 0.0 },
  { "Amandalyn", 0.0 },
  { "Amandalynn", 0.0 },
  { "Amandamarie", 0.0 },
  { "Amandarae", 0.0 },
  { "Amandarose", 0.0 },
  { "Amande", 0.0 },
  { "Amandeep", 0.5642857 },
  { "Amandia", 0.0 },
  { "Amandine", 0.0 },
  { "Amandip", 1.0 },
  { "Amando", 0.8980213 },
  { "Amandra", 0.0 },
  { "Amandus", 1.0 },
  { "Amandy", 0.0 },
  { "Amane", 0.0 },
  { "Amanee", 0.0 },
  { "Amani", 0.17655185 },
  { "Amania", 0.0 },
  { "Amanie", 0.029411765 },
  { "Amanii", 0.0 },
  { "Amanita", 0.0 },
  { "Amanjit", 1.0 },
  { "Amanjot", 1.0 },
  { "Amannda", 0.0 },
  { "Amanni", 0.0 },
  { "Amanoa", 0.0 },
  { "Amanpreet", 0.21383648 },
  { "Amante", 1.0 },
  { "Amantha", 0.0 },
  { "Amanti", 0.6419753 },
  { "Amanuel", 1.0 },
  { "Amany", 0.0 },
  { "Amar", 0.9488666 },
  { "Amara", 0.017323121 },
  { "Amarachi", 0.0 },
  { "Amarachukwu", 0.0 },
  { "Amarae", 0.0 },
  { "Amarah", 0.0 },
  { "Amaranta", 0.0 },
  { "Amarante", 1.0 },
  { "Amaranth", 0.0 },
  { "Amarantha", 0.0 },
  { "Amardeep", 1.0 },
  { "Amare", 0.943762 },
  { "Amarea", 0.048387095 },
  { "Amareah", 0.0 },
  { "Amaree", 0.5652174 },
  { "Amareion", 1.0 },
  { "Amareli", 0.0 },
  { "Amarelis", 0.0 },
  { "Amarely", 0.0 },
  { "Amarelys", 0.0 },
  { "Amareon", 1.0 },
  { "Amareona", 0.0 },
  { "Amarey", 0.8 },
  { "Amareya", 0.0 },
  { "Amareyon", 1.0 },
  { "Amarhi", 0.0 },
  { "Amari", 0.54339325 },
  { "Amaria", 0.0026136958 },
  { "Amariae", 1.0 },
  { "Amariah", 0.0 },
  { "Amarian", 1.0 },
  { "Amariana", 0.0 },
  { "Amariani", 0.0 },
  { "Amarianna", 0.0 },
  { "Amariauna", 0.0 },
  { "Amarie", 0.19341373 },
  { "Amariea", 0.0 },
  { "Amariee", 0.0 },
  { "Amarielle", 0.0 },
  { "Amarien", 1.0 },
  { "Amarieon", 1.0 },
  { "Amarii", 0.55396825 },
  { "Amarilis", 0.0 },
  { "Amarillis", 0.0 },
  { "Amarillys", 0.0 },
  { "Amarily", 0.0 },
  { "Amarilys", 0.0 },
  { "Amarin", 0.5 },
  { "Amarina", 0.0 },
  { "Amario", 1.0 },
  { "Amarion", 0.9866949 },
  { "Amariona", 0.0 },
  { "Amarionna", 0.0 },
  { "Amarious", 1.0 },
  { "Amaris", 0.032007046 },
  { "Amarisa", 0.0 },
  { "Amarise", 0.0 },
  { "Amariss", 0.0 },
  { "Amarissa", 0.0 },
  { "Amarius", 1.0 },
  { "Amariya", 0.0 },
  { "Amariyae", 0.0 },
  { "Amariyah", 0.0 },
  { "Amariyana", 0.0 },
  { "Amariyanna", 0.0 },
  { "Amariyon", 1.0 },
  { "Amariz", 0.0 },
  { "Amarley", 0.0 },
  { "Amaro", 1.0 },
  { "Amaron", 1.0 },
  { "Amarpreet", 0.0 },
  { "Amarr", 1.0 },
  { "Amarra", 0.0 },
  { "Amarrah", 0.0 },
  { "Amarre", 1.0 },
  { "Amarri", 0.53419596 },
  { "Amarria", 0.0 },
  { "Amarrie", 0.0 },
  { "Amarrion", 1.0 },
  { "Amartya", 1.0 },
  { "Amaru", 1.0 },
  { "Amary", 0.11111111 },
  { "Amarya", 0.0 },
  { "Amaryah", 0.0 },
  { "Amaryana", 0.0 },
  { "Amarye", 0.0 },
  { "Amaryia", 0.0 },
  { "Amarylis", 0.0 },
  { "Amaryllis", 0.0 },
  { "Amaryn", 0.0 },
  { "Amaryon", 1.0 },
  { "Amarys", 0.0 },
  { "Amaryss", 0.0 },
  { "Amasa", 1.0 },
  { "Amata", 0.0 },
  { "Amathyst", 0.0 },
  { "Amato", 1.0 },
  { "Amatullah", 0.0 },
  { "Amaud", 1.0 },
  { "Amaura", 0.0 },
  { "Amaure", 1.0 },
  { "Amauri", 0.7181673 },
  { "Amauria", 0.0 },
  { "Amauriah", 0.0 },
  { "Amaurie", 0.5555556 },
  { "Amaurion", 1.0 },
  { "Amauris", 1.0 },
  { "Amaury", 0.9957948 },
  { "Amaurys", 1.0 },
  { "Amay", 1.0 },
  { "Amaya", 0.0006371098 },
  { "Amayah", 0.0 },
  { "Amayha", 0.0 },
  { "Amayia", 0.0 },
  { "Amayiah", 0.0 },
  { "Amayla", 0.0 },
  { "Amaylee", 0.0 },
  { "Amayra", 0.0 },
  { "Amayrani", 0.0 },
  { "Amayrany", 0.0 },
  { "Amazen", 0.0 },
  { "Amaziah", 0.7606838 },
  { "Amazin", 0.0 },
  { "Amazing", 0.046153847 },
  { "Amazyn", 0.0 },
  { "Amba", 0.0 },
  { "Ambar", 0.0021626297 },
  { "Ambee", 0.0 },
  { "Ambellina", 0.0 },
  { "Amber", 0.0026507496 },
  { "Ambera", 0.0 },
  { "Amberann", 0.0 },
  { "Amberdawn", 0.0 },
  { "Ambere", 0.0 },
  { "Amberia", 0.0 },
  { "Amberjo", 0.0 },
  { "Amberle", 0.0 },
  { "Amberlea", 0.0 },
  { "Amberlee", 0.0 },
  { "Amberleigh", 0.0 },
  { "Amberley", 0.0 },
  { "Amberli", 0.0 },
  { "Amberlie", 0.0 },
  { "Amberlin", 0.0 },
  { "Amberly", 0.0 },
  { "Amberlyn", 0.0 },
  { "Amberlynn", 0.0 },
  { "Amberlynne", 0.0 },
  { "Ambermarie", 0.0 },
  { "Ambernicole", 0.0 },
  { "Ambernique", 0.0 },
  { "Amberrae", 0.0 },
  { "Amberrose", 0.0 },
  { "Ambers", 1.0 },
  { "Ambert", 0.0 },
  { "Ambi", 0.0 },
  { "Ambika", 0.0 },
  { "Ambir", 0.0 },
  { "Ambor", 0.0 },
  { "Ambr", 0.0 },
  { "Ambra", 0.0 },
  { "Ambrasia", 0.0 },
  { "Ambre", 0.0 },
  { "Ambrea", 0.0 },
  { "Ambreal", 0.0 },
  { "Ambreanna", 0.0 },
  { "Ambree", 0.0 },
  { "Ambreen", 0.0 },
  { "Ambreia", 0.0 },
  { "Ambresha", 0.0 },
  { "Ambrey", 0.0 },
  { "Ambri", 0.0 },
  { "Ambria", 0.0 },
  { "Ambriah", 0.0 },
  { "Ambriana", 0.0 },
  { "Ambrianna", 0.0 },
  { "Ambrie", 0.0 },
  { "Ambriehl", 0.0 },
  { "Ambriel", 0.0 },
  { "Ambriella", 0.0 },
  { "Ambrielle", 0.0 },
  { "Ambrocio", 1.0 },
  { "Ambros", 1.0 },
  { "Ambrose", 1.0 },
  { "Ambrosha", 0.0 },
  { "Ambrosia", 0.0 },
  { "Ambrosio", 1.0 },
  { "Ambrous", 1.0 },
  { "Ambry", 0.0 },
  { "Ambur", 0.0 },
  { "Ambus", 1.0 },
  { "Amby", 0.0 },
  { "Ambyr", 0.0 },
  { "Amdanda", 0.0 },
  { "Amdrea", 0.0 },
  { "Amdrew", 1.0 },
  { "Ame", 0.0 },
  { "Amea", 0.0 },
  { "Ameah", 0.0 },
  { "Ameal", 1.0 },
  { "Amear", 1.0 },
  { "Ameara", 0.0 },
  { "Amechi", 1.0 },
  { "Amecia", 0.0 },
  { "Amed", 1.0 },
  { "Amedee", 1.0 },
  { "Amedeo", 1.0 },
  { "Amedio", 1.0 },
  { "Amee", 0.0 },
  { "Ameelah", 0.0 },
  { "Ameelia", 0.0 },
  { "Ameen", 1.0 },
  { "Ameena", 0.0 },
  { "Ameenah", 0.0 },
  { "Ameer", 1.0 },
  { "Ameera", 0.0 },
  { "Ameerah", 0.0 },
  { "Ameere", 1.0 },
  { "Ameeria", 0.0 },
  { "Ameesha", 0.0 },
  { "Ameet", 1.0 },
  { "Ameeya", 0.0 },
  { "Ameeyah", 0.0 },
  { "Amei", 0.0 },
  { "Ameia", 0.0 },
  { "Ameiah", 0.0 },
  { "Ameika", 0.0 },
  { "Ameil", 1.0 },
  { "Ameila", 0.0 },
  { "Ameilia", 0.0 },
  { "Ameilya", 0.0 },
  { "Ameina", 0.0 },
  { "Ameir", 1.0 },
  { "Ameira", 0.0 },
  { "Ameirah", 0.0 },
  { "Ameire", 1.0 },
  { "Ameisha", 0.0 },
  { "Ameiya", 0.0 },
  { "Ameiyah", 0.0 },
  { "Ameka", 0.0 },
  { "Amekia", 0.0 },
  { "Amel", 0.6034091 },
  { "Amela", 0.0 },
  { "Amelah", 0.0 },
  { "Amelda", 0.0 },
  { "Amelea", 0.0 },
  { "Ameleah", 0.0 },
  { "Amelee", 0.0 },
  { "Ameli", 0.0 },
  { "Amelia", 0.0011865296 },
  { "Ameliagrace", 0.0 },
  { "Ameliah", 0.0 },
  { "Ameliajane", 0.0 },
  { "Ameliamae", 0.0 },
  { "Ameliana", 0.0 },
  { "Amelianna", 0.0 },
  { "Ameliarose", 0.0 },
  { "Amelie", 0.0 },
  { "Amelina", 0.0 },
  { "Amelinda", 0.0 },
  { "Ameline", 0.0 },
  { "Amelio", 1.0 },
  { "Amelita", 0.0 },
  { "Ameliya", 0.0 },
  { "Ameliyah", 0.0 },
  { "Amella", 0.0 },
  { "Amelle", 0.0 },
  { "Amellia", 0.0 },
  { "Amely", 0.0 },
  { "Amelya", 0.0 },
  { "Amelyah", 0.0 },
  { "Amen", 0.63871634 },
  { "Amena", 0.0 },
  { "Amenah", 0.0 },
  { "Amenata", 0.0 },
  { "Amenda", 0.0 },
  { "Amenia", 0.0 },
  { "Amer", 0.99018 },
  { "Amera", 0.0 },
  { "Amerah", 0.0 },
  { "Amere", 0.83666277 },
  { "Ameri", 0.046511628 },
  { "Ameria", 0.0 },
  { "Ameriah", 0.0 },
  { "Ameriana", 0.0 },
  { "America", 0.0012933473 },
  { "Americas", 0.0 },
  { "Americo", 1.0 },
  { "Americus", 0.2508834 },
  { "Amerie", 0.0 },
  { "Amerigo", 1.0 },
  { "Amerika", 0.0 },
  { "Amerion", 1.0 },
  { "Ameris", 0.0 },
  { "Amerissa", 0.0 },
  { "Amerius", 0.0 },
  { "Ameriya", 0.0 },
  { "Ameriyah", 0.0 },
  { "Amerra", 0.0 },
  { "Amerson", 0.5 },
  { "Amery", 0.17082533 },
  { "Ameryst", 0.0 },
  { "Ames", 0.9955986 },
  { "Amesha", 0.0 },
  { "Ameshia", 0.0 },
  { "Amethyst", 0.0 },
  { "Ametra", 0.0 },
  { "Ametria", 0.0 },
  { "Amey", 0.030751709 },
  { "Ameya", 0.24629879 },
  { "Ameyaa", 0.0 },
  { "Ameyah", 0.0 },
  { "Ameyali", 0.0 },
  { "Ameyalli", 0.0 },
  { "Ameyia", 0.0 },
  { "Amgela", 0.0 },
  { "Amhad", 1.0 },
  { "Ami", 0.03925482 },
  { "Amia", 0.0 },
  { "Amiah", 0.0 },
  { "Amiaha", 0.0 },
  { "Amias", 1.0 },
  { "Amiaya", 0.0 },
  { "Amiayah", 0.0 },
  { "Amica", 0.0 },
  { "Amichai", 1.0 },
  { "Amicia", 0.0 },
  { "Amid", 1.0 },
  { "Amida", 0.0 },
  { "Amidala", 0.0 },
  { "Amie", 0.0018792577 },
  { "Amiee", 0.0 },
  { "Amiel", 0.9448209 },
  { "Amiela", 0.0 },
  { "Amielia", 0.0 },
  { "Amielle", 0.0 },
  { "Amiena", 0.0 },
  { "Amier", 1.0 },
  { "Amiera", 0.0 },
  { "Amierah", 0.0 },
  { "Amiere", 0.9270833 },
  { "Amii", 0.0 },
  { "Amiia", 0.0 },
  { "Amiin", 1.0 },
  { "Amiina", 0.0 },
  { "Amiir", 1.0 },
  { "Amiira", 0.0 },
  { "Amija", 0.0 },
  { "Amijah", 0.0 },
  { "Amika", 0.0 },
  { "Amil", 0.75582576 },
  { "Amila", 0.0 },
  { "Amilah", 0.0 },
  { "Amilcar", 1.0 },
  { "Amilcare", 1.0 },
  { "Amilda", 0.0 },
  { "Amile", 1.0 },
  { "Amilea", 0.0 },
  { "Amileah", 0.0 },
  { "Amilee", 0.0 },
  { "Amileo", 1.0 },
  { "Amiley", 0.0 },
  { "Amilia", 0.0 },
  { "Amiliah", 0.0 },
  { "Amilian", 0.0 },
  { "Amiliana", 0.0 },
  { "Amiliano", 1.0 },
  { "Amilie", 0.0 },
  { "Amilio", 1.0 },
  { "Amiliya", 0.0 },
  { "Amiliyah", 0.0 },
  { "Amill", 1.0 },
  { "Amilla", 0.0 },
  { "Amilleon", 0.0 },
  { "Amilli", 0.0 },
  { "Amillia", 0.0 },
  { "Amilliah", 0.0 },
  { "Amillian", 0.0 },
  { "Amilliana", 0.0 },
  { "Amillianna", 0.0 },
  { "Amillie", 0.0 },
  { "Amillio", 1.0 },
  { "Amillion", 0.3529412 },
  { "Amilliona", 0.0 },
  { "Amilliyon", 0.0 },
  { "Amillya", 0.0 },
  { "Amily", 0.0 },
  { "Amilya", 0.0 },
  { "Amilyah", 0.0 },
  { "Amilyn", 0.0 },
  { "Amilynn", 0.0 },
  { "Amin", 1.0 },
  { "Amina", 0.0 },
  { "Aminah", 0.0 },
  { "Aminat", 0.0 },
  { "Aminata", 0.0 },
  { "Aminatou", 0.0 },
  { "Aminda", 0.0 },
  { "Amine", 1.0 },
  { "Aminna", 0.0 },
  { "Amino", 0.0 },
  { "Aminta", 0.0 },
  { "Amir", 0.98594445 },
  { "Amira", 0.0 },
  { "Amiracle", 0.0 },
  { "Amirah", 0.0 },
  { "Amirali", 1.0 },
  { "Amirbek", 1.0 },
  { "Amire", 0.86212623 },
  { "Amirea", 0.0 },
  { "Amiree", 0.0 },
  { "Amirh", 0.0 },
  { "Amiri", 0.8112927 },
  { "Amiria", 0.0 },
  { "Amiriah", 0.0 },
  { "Amirie", 0.0 },
  { "Amiriya", 0.0 },
  { "Amirjon", 1.0 },
  { "Amirr", 1.0 },
  { "Amirra", 0.0 },
  { "Amirrah", 0.0 },
  { "Amirya", 0.0 },
  { "Amiryah", 0.0 },
  { "Amirykal", 0.0 },
  { "Amis", 1.0 },
  { "Amisa", 0.0 },
  { "Amisadai", 0.03968254 },
  { "Amisaday", 0.0 },
  { "Amish", 1.0 },
  { "Amisha", 0.0 },
  { "Amishi", 0.0 },
  { "Amissa", 0.0 },
  { "Amista", 0.0 },
  { "Amistad", 1.0 },
  { "Amit", 0.93591905 },
  { "Amita", 0.0 },
  { "Amitabh", 1.0 },
  { "Amitai", 1.0 },
  { "Amith", 1.0 },
  { "Amitha", 0.0 },
  { "Amitiel", 0.0 },
  { "Amitis", 0.0 },
  { "Amitoj", 1.0 },
  { "Amittai", 1.0 },
  { "Amity", 0.0 },
  { "Amius", 1.0 },
  { "Amiya", 0.0 },
  { "Amiyaah", 0.0 },
  { "Amiyah", 0.0 },
  { "Amiyha", 0.0 },
  { "Amiyiah", 0.0 },
  { "Amiyla", 0.0 },
  { "Amiylah", 0.0 },
  { "Amiyr", 1.0 },
  { "Amiyra", 0.0 },
  { "Amiyrah", 0.0 },
  { "Amjad", 1.0 },
  { "Amjed", 1.0 },
  { "Amma", 0.0 },
  { "Ammaar", 1.0 },
  { "Ammaarah", 0.0 },
  { "Ammad", 1.0 },
  { "Amman", 1.0 },
  { "Ammanda", 0.0 },
  { "Ammanuel", 1.0 },
  { "Ammar", 1.0 },
  { "Ammara", 0.0 },
  { "Ammarah", 0.0 },
  { "Ammarie", 0.0 },
  { "Ammber", 0.0 },
  { "Amme", 0.0 },
  { "Ammer", 0.5 },
  { "Ammerie", 0.0 },
  { "Ammi", 0.0 },
  { "Ammie", 0.012359984 },
  { "Ammiel", 1.0 },
  { "Ammon", 1.0 },
  { "Ammy", 0.0 },
  { "Amna", 0.0 },
  { "Amnah", 0.0 },
  { "Amneet", 0.0 },
  { "Amneh", 0.0 },
  { "Amner", 1.0 },
  { "Amneris", 0.0 },
  { "Amnesty", 0.0 },
  { "Amo", 0.33333334 },
  { "Amod", 1.0 },
  { "Amogh", 1.0 },
  { "Amoi", 0.0 },
  { "Amol", 1.0 },
  { "Amolika", 0.0 },
  { "Amon", 1.0 },
  { "Amond", 1.0 },
  { "Amonda", 0.0 },
  { "Amondo", 1.0 },
  { "Amondre", 1.0 },
  { "Amone", 0.0 },
  { "Amonee", 0.0 },
  { "Amoni", 0.13309982 },
  { "Amonie", 0.0 },
  { "Amonii", 0.0 },
  { "Amonni", 0.0 },
  { "Amonnie", 0.0 },
  { "Amont", 1.0 },
  { "Amonta", 1.0 },
  { "Amontae", 1.0 },
  { "Amontay", 1.0 },
  { "Amonte", 1.0 },
  { "Amonti", 0.9166667 },
  { "Amor", 0.20233747 },
  { "Amora", 0.0 },
  { "Amorae", 0.0 },
  { "Amorah", 0.0 },
  { "Amore", 0.18313253 },
  { "Amoree", 0.0 },
  { "Amoreena", 0.0 },
  { "Amoret", 0.0 },
  { "Amorette", 0.0 },
  { "Amori", 0.40980393 },
  { "Amoria", 0.0 },
  { "Amoriah", 0.0 },
  { "Amorian", 1.0 },
  { "Amoriana", 0.0 },
  { "Amorie", 0.16433567 },
  { "Amorina", 0.0 },
  { "Amorion", 1.0 },
  { "Amorita", 0.0 },
  { "Amorra", 0.0 },
  { "Amorrah", 0.0 },
  { "Amory", 0.5034325 },
  { "Amos", 0.9980517 },
  { "Amose", 1.0 },
  { "Amour", 0.13861386 },
  { "Amoura", 0.0 },
  { "Amoure", 0.0 },
  { "Amouri", 0.56 },
  { "Amous", 1.0 },
  { "Amoy", 0.0 },
  { "Amoya", 0.0 },
  { "Amoz", 1.0 },
  { "Amparo", 0.005178191 },
  { "Ample", 0.0 },
  { "Amr", 1.0 },
  { "Amra", 0.0 },
  { "Amrah", 0.0 },
  { "Amram", 1.0 },
  { "Amran", 0.17982456 },
  { "Amree", 0.0 },
  { "Amreen", 0.0 },
  { "Amreet", 0.0 },
  { "Amren", 1.0 },
  { "Amri", 0.026143791 },
  { "Amrie", 0.0 },
  { "Amriel", 0.0 },
  { "Amrik", 1.0 },
  { "Amrin", 0.0 },
  { "Amrit", 0.5790698 },
  { "Amrita", 0.0 },
  { "Amrith", 1.0 },
  { "Amritha", 0.0 },
  { "Amritpal", 1.0 },
  { "Amro", 1.0 },
  { "Amrom", 1.0 },
  { "Amron", 1.0 },
  { "Amruta", 0.0 },
  { "Amruth", 1.0 },
  { "Amrutha", 0.0 },
  { "Amry", 0.0 },
  { "Amryn", 0.11320755 },
  { "Amsey", 0.0 },
  { "Amsi", 0.0 },
  { "Amuel", 1.0 },
  { "Amukta", 0.0 },
  { "Amulek", 1.0 },
  { "Amulya", 0.0 },
  { "Amun", 1.0 },
  { "Amunet", 0.0 },
  { "Amunique", 0.0 },
  { "Amuri", 1.0 },
  { "Amvi", 0.0 },
  { "Amy", 0.0026740136 },
  { "Amya", 0.0 },
  { "Amyah", 0.0 },
  { "Amyann", 0.0 },
  { "Amyas", 1.0 },
  { "Amybeth", 0.0 },
  { "Amye", 0.0 },
  { "Amyha", 0.0 },
  { "Amyia", 0.0 },
  { "Amyiah", 0.0 },
  { "Amyjo", 0.0 },
  { "Amyla", 0.0 },
  { "Amylah", 0.0 },
  { "Amylea", 0.0 },
  { "Amylee", 0.0 },
  { "Amylia", 0.0 },
  { "Amyliah", 0.0 },
  { "Amylyn", 0.0 },
  { "Amylynn", 0.0 },
  { "Amymarie", 0.0 },
  { "Amyna", 0.0 },
  { "Amyr", 1.0 },
  { "Amyra", 0.0 },
  { "Amyracle", 0.0 },
  { "Amyrah", 0.0 },
  { "Amyre", 0.10909091 },
  { "Amyree", 0.0 },
  { "Amyri", 0.0 },
  { "Amyria", 0.0 },
  { "Amyriah", 0.0 },
  { "Amyrical", 0.0 },
  { "Amyrie", 0.0 },
  { "Amyrikal", 0.0 },
  { "Amyrion", 1.0 },
  { "Amysue", 0.0 },
  { "Amythest", 0.0 },
  { "Amythyst", 0.0 },
  { "Amyya", 0.0 },
  { "Amzee", 0.0 },
  { "Amzi", 0.375 },
  { "Amzie", 0.34591195 },
  { "An", 0.45422536 },
  { "Ana", 0.005942864 },
  { "Anaahat", 0.0 },
  { "Anaalicia", 0.0 },
  { "Anaaya", 0.0 },
  { "Anab", 0.0 },
  { "Anabeatriz", 0.0 },
  { "Anabel", 0.003782557 },
  { "Anabela", 0.0 },
  { "Anabele", 0.0 },
  { "Anabelen", 0.0 },
  { "Anabeli", 0.0 },
  { "Anabelia", 0.0 },
  { "Anabell", 0.0 },
  { "Anabella", 0.0 },
  { "Anabelle", 0.0 },
  { "Anabelli", 0.0 },
  { "Anaberta", 0.0 },
  { "Anabeth", 0.0 },
  { "Anabia", 0.0 },
  { "Anabiya", 0.0 },
  { "Anabrenda", 0.0 },
  { "Anacamila", 0.0 },
  { "Anacani", 0.0 },
  { "Anacaren", 0.0 },
  { "Anacarina", 0.0 },
  { "Anacarolina", 0.0 },
  { "Anacecilia", 0.0 },
  { "Anaceli", 0.0 },
  { "Anacelia", 0.0 },
  { "Anacelis", 0.0 },
  { "Anacely", 0.0 },
  { "Anachristina", 0.0 },
  { "Anacia", 0.0 },
  { "Anaclara", 0.0 },
  { "Anacleto", 1.0 },
  { "Anacristina", 0.0 },
  { "Anadalay", 0.0 },
  { "Anadela", 0.0 },
  { "Anadelia", 0.0 },
  { "Anadia", 0.0 },
  { "Anae", 0.0 },
  { "Anaee", 0.0 },
  { "Anaeja", 0.0 },
  { "Anaejah", 0.0 },
  { "Anael", 0.19469027 },
  { "Anaeli", 0.0 },
  { "Anaelisa", 0.0 },
  { "Anaelise", 0.0 },
  { "Anaelle", 0.0 },
  { "Anaely", 0.0 },
  { "Anagabriel", 0.0 },
  { "Anagabriela", 0.0 },
  { "Anagh", 1.0 },
  { "Anagha", 0.0 },
  { "Anagrace", 0.0 },
  { "Anah", 0.0 },
  { "Anahat", 0.0 },
  { "Anahi", 0.0021260544 },
  { "Anahia", 0.0 },
  { "Anahid", 0.0 },
  { "Anahie", 0.0 },
  { "Anahii", 0.0 },
  { "Anahis", 0.0 },
  { "Anahit", 0.0 },
  { "Anahita", 0.0 },
  { "Anahla", 0.0 },
  { "Anahli", 0.0 },
  { "Anahlia", 0.0 },
  { "Anahly", 0.0 },
  { "Anahy", 0.0 },
  { "Anahya", 0.0 },
  { "Anai", 0.0 },
  { "Anaia", 0.0 },
  { "Anaiah", 0.0063931807 },
  { "Anaias", 1.0 },
  { "Anaica", 0.0 },
  { "Anaid", 0.0 },
  { "Anaida", 0.0 },
  { "Anaie", 0.0 },
  { "Anaih", 0.0 },
  { "Anaiis", 0.0 },
  { "Anaija", 0.0 },
  { "Anaijah", 0.0 },
  { "Anaika", 0.0 },
  { "Anaila", 0.0 },
  { "Anailah", 0.0 },
  { "Anaili", 0.0 },
  { "Anaily", 0.0 },
  { "Anaira", 0.0 },
  { "Anairis", 0.0 },
  { "Anais", 0.007082371 },
  { "Anaisa", 0.0 },
  { "Anaisabel", 0.0 },
  { "Anaisabella", 0.0 },
  { "Anaise", 0.0 },
  { "Anaisha", 0.0 },
  { "Anaisia", 0.0 },
  { "Anaissa", 0.0 },
  { "Anaiya", 0.0 },
  { "Anaiyah", 0.0 },
  { "Anaiz", 0.0 },
  { "Anaiza", 0.0 },
  { "Anaja", 0.0 },
  { "Anajae", 0.0 },
  { "Anajah", 0.0 },
  { "Anajee", 1.0 },
  { "Anajia", 0.0 },
  { "Anajulia", 0.0 },
  { "Anaka", 0.0 },
  { "Anakah", 0.0 },
  { "Anakaren", 0.0 },
  { "Anakarina", 0.0 },
  { "Anakin", 0.99698013 },
  { "Anakyn", 1.0 },
  { "Anala", 0.0 },
  { "Analah", 0.0 },
  { "Analaura", 0.0 },
  { "Analaya", 0.0 },
  { "Analayah", 0.0 },
  { "Analea", 0.0 },
  { "Analeah", 0.0 },
  { "Analecia", 0.0 },
  { "Analee", 0.0 },
  { "Analeece", 0.0 },
  { "Analeesa", 0.0 },
  { "Analeese", 0.0 },
  { "Analei", 0.0 },
  { "Analeia", 0.0 },
  { "Analeiah", 0.0 },
  { "Analeigh", 0.0 },
  { "Analeigha", 0.0 },
  { "Analeise", 0.0 },
  { "Analena", 0.0 },
  { "Analese", 0.0 },
  { "Analeshia", 0.0 },
  { "Analexis", 0.0 },
  { "Analey", 0.0 },
  { "Analeya", 0.0 },
  { "Analeyah", 0.0 },
  { "Anali", 0.0 },
  { "Analia", 0.0 },
  { "Analiah", 0.0 },
  { "Analice", 0.0 },
  { "Analicia", 0.0 },
  { "Analidia", 0.0 },
  { "Analie", 0.0 },
  { "Analiegh", 0.0 },
  { "Analiesa", 0.0 },
  { "Analiese", 0.0 },
  { "Analiha", 0.0 },
  { "Analilia", 0.0 },
  { "Analily", 0.0 },
  { "Analin", 0.0 },
  { "Analina", 0.0 },
  { "Analis", 0.0 },
  { "Analisa", 0.0 },
  { "Analise", 0.0 },
  { "Analisha", 0.0 },
  { "Analisia", 0.0 },
  { "Analissa", 0.0 },
  { "Analisse", 0.0 },
  { "Analiya", 0.0 },
  { "Analiyah", 0.0 },
  { "Analiz", 0.0 },
  { "Analiza", 0.0 },
  { "Analize", 0.0 },
  { "Analleli", 0.0 },
  { "Anallely", 0.0 },
  { "Anally", 0.0 },
  { "Analu", 1.0 },
  { "Analucia", 0.0 },
  { "Analuisa", 0.0 },
  { "Analuiza", 0.0 },
  { "Analuz", 0.0 },
  { "Analy", 0.0 },
  { "Analya", 0.0 },
  { "Analyah", 0.0 },
  { "Analyce", 0.0 },
  { "Analycia", 0.0 },
  { "Analydia", 0.0 },
  { "Analyn", 0.0 },
  { "Analynn", 0.0 },
  { "Analys", 0.0 },
  { "Analysa", 0.0 },
  { "Analyse", 0.0 },
  { "Analysia", 0.0 },
  { "Analyss", 0.0 },
  { "Analyssa", 0.0 },
  { "Analysse", 0.0 },
  { "Analyssia", 0.0 },
  { "Analyz", 0.0 },
  { "Anam", 0.0 },
  { "Anamae", 0.0 },
  { "Anamar", 0.0 },
  { "Anamari", 0.0 },
  { "Anamaria", 0.0 },
  { "Anamarie", 0.0 },
  { "Anamaris", 0.0 },
  { "Anamary", 0.0 },
  { "Anamda", 0.0 },
  { "Anamia", 0.0 },
  { "Anamika", 0.0 },
  { "Anamile", 0.0 },
  { "Anamta", 0.0 },
  { "Anan", 0.92537314 },
  { "Anana", 0.0 },
  { "Anand", 1.0 },
  { "Ananda", 0.05215282 },
  { "Anandi", 0.0 },
  { "Anandita", 0.0 },
  { "Anani", 0.0 },
  { "Anania", 1.0 },
  { "Ananiah", 0.0 },
  { "Ananias", 1.0 },
  { "Anannya", 0.0 },
  { "Anansa", 0.0 },
  { "Ananshi", 0.0 },
  { "Anant", 1.0 },
  { "Ananth", 1.0 },
  { "Ananya", 0.0 },
  { "Ananyaa", 0.0 },
  { "Anapaola", 0.0 },
  { "Anapatricia", 0.0 },
  { "Anapaula", 0.0 },
  { "Anar", 1.0 },
  { "Anara", 0.0 },
  { "Anarae", 0.0 },
  { "Anarah", 0.0 },
  { "Anareli", 0.0 },
  { "Anarely", 0.0 },
  { "Anari", 0.043557167 },
  { "Anaria", 0.0 },
  { "Anariah", 0.0 },
  { "Anarie", 0.0 },
  { "Anariya", 0.0 },
  { "Anariyah", 0.0 },
  { "Anarosa", 0.0 },
  { "Anarose", 0.0 },
  { "Anaruth", 0.0 },
  { "Anas", 1.0 },
  { "Anasa", 0.0 },
  { "Anasha", 0.0 },
  { "Anashe", 0.0 },
  { "Anashia", 0.0 },
  { "Anasia", 0.0 },
  { "Anasofia", 0.0 },
  { "Anasol", 0.0 },
  { "Anasophia", 0.0 },
  { "Anass", 1.0 },
  { "Anassa", 0.0 },
  { "Anastacia", 0.0 },
  { "Anastacio", 1.0 },
  { "Anastaisa", 0.0 },
  { "Anastaisha", 0.0 },
  { "Anastaja", 0.0 },
  { "Anastajia", 0.0 },
  { "Anastasha", 0.0 },
  { "Anastashia", 0.0 },
  { "Anastasi", 0.0 },
  { "Anastasia", 0.0005630906 },
  { "Anastasija", 0.0 },
  { "Anastasio", 1.0 },
  { "Anastasios", 1.0 },
  { "Anastasiya", 0.0 },
  { "Anastassia", 0.0 },
  { "Anastasya", 0.0 },
  { "Anastatia", 0.0 },
  { "Anastaysia", 0.0 },
  { "Anastazia", 0.0 },
  { "Anastazja", 0.0 },
  { "Anastin", 0.0 },
  { "Anaston", 0.0 },
  { "Anastyn", 0.0 },
  { "Anat", 0.0 },
  { "Anatalia", 0.0 },
  { "Anatasia", 0.0 },
  { "Anathea", 0.0 },
  { "Anatol", 1.0 },
  { "Anatole", 1.0 },
  { "Anatoli", 1.0 },
  { "Anatolia", 0.0 },
  { "Anatoliy", 1.0 },
  { "Anatoly", 1.0 },
  { "Anaum", 0.0 },
  { "Anauri", 0.0 },
  { "Anautica", 0.0 },
  { "Anav", 1.0 },
  { "Anavae", 0.0 },
  { "Anavaeh", 0.0 },
  { "Anavay", 0.0 },
  { "Anaveah", 0.0 },
  { "Anavel", 0.0 },
  { "Anavela", 0.0 },
  { "Anavey", 0.0 },
  { "Anavi", 0.0 },
  { "Anaviah", 0.0 },
  { "Anavictoria", 0.0 },
  { "Anay", 0.5080697 },
  { "Anaya", 0.0 },
  { "Anayaa", 0.0 },
  { "Anayah", 0.0 },
  { "Anayalee", 0.0 },
  { "Anayanci", 0.0 },
  { "Anayancy", 0.0 },
  { "Anayansi", 0.0 },
  { "Anayeli", 0.0 },
  { "Anayelis", 0.0 },
  { "Anayelli", 0.0 },
  { "Anayelly", 0.0 },
  { "Anayely", 0.0 },
  { "Anayha", 0.0 },
  { "Anayi", 0.0 },
  { "Anayia", 0.0 },
  { "Anayiah", 0.0 },
  { "Anayis", 0.0 },
  { "Anayjah", 0.0 },
  { "Anayla", 0.0 },
  { "Anaylah", 0.0 },
  { "Anayra", 0.0 },
  { "Anays", 0.0 },
  { "Anaysa", 0.0 },
  { "Anaysha", 0.0 },
  { "Anayshia", 0.0 },
  { "Anaysia", 0.0 },
  { "Anayssa", 0.0 },
  { "Anazia", 0.0 },
  { "Anber", 0.0 },
  { "Anberlin", 0.0 },
  { "Anberlyn", 0.0 },
  { "Anberlynn", 0.0 },
  { "Anbria", 0.0 },
  { "Ance", 1.0 },
  { "Ancel", 1.0 },
  { "Ancelmo", 1.0 },
  { "Anchal", 0.0 },
  { "Anchita", 0.0 },
  { "Anchor", 1.0 },
  { "Ancika", 0.0 },
  { "Ancil", 1.0 },
  { "Ancle", 1.0 },
  { "Ancy", 0.0 },
  { "Anda", 0.0 },
  { "Andaiye", 0.0 },
  { "Andalasia", 0.0 },
  { "Andalucia", 0.0 },
  { "Andalyn", 0.0 },
  { "Andalynn", 0.0 },
  { "Andamo", 1.0 },
  { "Andan", 1.0 },
  { "Andarius", 1.0 },
  { "Anddy", 1.0 },
  { "Ande", 0.1764706 },
  { "Andea", 0.0 },
  { "Andee", 0.005144033 },
  { "Andel", 1.0 },
  { "Andela", 0.0 },
  { "Andelin", 0.0 },
  { "Andella", 0.0 },
  { "Andelyn", 0.0 },
  { "Andelynn", 0.0 },
  { "Anden", 1.0 },
  { "Ander", 1.0 },
  { "Andera", 0.023904383 },
  { "Anderea", 0.0 },
  { "Anderew", 1.0 },
  { "Anderia", 0.0 },
  { "Anders", 1.0 },
  { "Andersen", 0.7838785 },
  { "Anderson", 0.9714872 },
  { "Andersson", 1.0 },
  { "Andersyn", 0.0 },
  { "Anderw", 1.0 },
  { "Anderzon", 1.0 },
  { "Andes", 1.0 },
  { "Andew", 1.0 },
  { "Andhy", 1.0 },
  { "Andi", 0.15129073 },
  { "Andia", 0.0 },
  { "Andice", 0.0 },
  { "Andie", 0.058857143 },
  { "Andiel", 1.0 },
  { "Andilyn", 0.0 },
  { "Andilynn", 0.0 },
  { "Andin", 0.9137931 },
  { "Andino", 1.0 },
  { "Andis", 1.0 },
  { "Andjela", 0.0 },
  { "Andjoua", 0.0 },
  { "Andols", 1.0 },
  { "Andon", 1.0 },
  { "Andoni", 1.0 },
  { "Andonia", 0.0 },
  { "Andony", 1.0 },
  { "Andora", 0.0 },
  { "Andra", 0.32053837 },
  { "Andrade", 1.0 },
  { "Andrae", 0.97998047 },
  { "Andraea", 0.0 },
  { "Andraia", 0.0 },
  { "Andralyn", 0.0 },
  { "Andranae", 0.0 },
  { "Andranette", 0.0 },
  { "Andranik", 1.0 },
  { "Andranique", 0.0 },
  { "Andras", 1.0 },
  { "Andray", 1.0 },
  { "Andraya", 0.0 },
  { "Andre", 0.9820701 },
  { "Andrea", 0.013426401 },
  { "Andreah", 0.0 },
  { "Andreal", 0.0 },
  { "Andreamarie", 0.0 },
  { "Andrean", 0.2 },
  { "Andreana", 0.0 },
  { "Andreanna", 0.0 },
  { "Andreas", 0.99317265 },
  { "Andreau", 1.0 },
  { "Andreaus", 1.0 },
  { "Andreaz", 1.0 },
  { "Andreca", 0.0 },
  { "Andreco", 1.0 },
  { "Andree", 0.31968948 },
  { "Andreea", 0.0 },
  { "Andreena", 0.0 },
  { "Andrei", 1.0 },
  { "Andreia", 0.0 },
  { "Andreika", 0.0 },
  { "Andreina", 0.0049792533 },
  { "Andreis", 1.0 },
  { "Andreita", 0.0 },
  { "Andrej", 1.0 },
  { "Andrejs", 1.0 },
  { "Andrek", 1.0 },
  { "Andreka", 0.0 },
  { "Andrekia", 0.0 },
  { "Andrel", 0.8648649 },
  { "Andrell", 0.6988764 },
  { "Andrella", 0.0 },
  { "Andrelle", 0.0 },
  { "Andren", 1.0 },
  { "Andrena", 0.0 },
  { "Andrenae", 0.0 },
  { "Andrene", 0.0 },
  { "Andrenette", 0.0 },
  { "Andrenika", 0.0 },
  { "Andreniki", 0.0 },
  { "Andrenique", 0.0 },
  { "Andreo", 1.0 },
  { "Andreona", 0.0 },
  { "Andreonna", 0.0 },
  { "Andreous", 1.0 },
  { "Andreq", 1.0 },
  { "Andres", 0.99450386 },
  { "Andresha", 0.0 },
  { "Andress", 1.0 },
  { "Andressa", 0.0 },
  { "Andretta", 0.0 },
  { "Andretti", 1.0 },
  { "Andreu", 1.0 },
  { "Andreus", 1.0 },
  { "Andrew", 0.9961935 },
  { "Andrewjacob", 1.0 },
  { "Andrewjames", 1.0 },
  { "Andrewjohn", 1.0 },
  { "Andrewjoseph", 1.0 },
  { "Andrewmichael", 1.0 },
  { "Andrews", 1.0 },
  { "Andrey", 0.9562555 },
  { "Andreya", 0.0 },
  { "Andreyah", 0.0 },
  { "Andreyna", 0.0 },
  { "Andrez", 1.0 },
  { "Andri", 0.95689654 },
  { "Andria", 0.0036359504 },
  { "Andriah", 0.0 },
  { "Andrian", 0.8509317 },
  { "Andriana", 0.0 },
  { "Andrianna", 0.0 },
  { "Andrianne", 0.0 },
  { "Andric", 1.0 },
  { "Andrica", 0.0 },
  { "Andrick", 1.0 },
  { "Andricka", 0.0 },
  { "Andrico", 1.0 },
  { "Andrie", 1.0 },
  { "Andriea", 0.0 },
  { "Andrieka", 0.0 },
  { "Andriel", 0.69902915 },
  { "Andrielle", 0.0 },
  { "Andriena", 0.0 },
  { "Andrienna", 0.0 },
  { "Andrienne", 0.0 },
  { "Andrietta", 0.0 },
  { "Andriette", 0.0 },
  { "Andrijana", 0.0 },
  { "Andrik", 1.0 },
  { "Andrika", 0.0 },
  { "Andrina", 0.0 },
  { "Andrine", 0.0 },
  { "Andris", 1.0 },
  { "Andrius", 1.0 },
  { "Andriy", 1.0 },
  { "Andro", 1.0 },
  { "Andromeda", 0.0 },
  { "Andron", 1.0 },
  { "Androniki", 0.0 },
  { "Andropolis", 1.0 },
  { "Andros", 1.0 },
  { "Androw", 1.0 },
  { "Andru", 1.0 },
  { "Andrue", 1.0 },
  { "Andrus", 1.0 },
  { "Andruw", 1.0 },
  { "Andrw", 1.0 },
  { "Andry", 0.9770642 },
  { "Andrya", 0.0 },
  { "Andrzej", 1.0 },
  { "Anduin", 1.0 },
  { "Andwele", 1.0 },
  { "Andy", 0.9886199 },
  { "Andyn", 1.0 },
  { "Ane", 0.0 },
  { "Anea", 0.0 },
  { "Aneah", 0.0 },
  { "Aneas", 1.0 },
  { "Anease", 0.0 },
  { "Aneatra", 0.0 },
  { "Anecia", 0.0 },
  { "Aneda", 0.0 },
  { "Anedra", 0.0 },
  { "Anee", 0.0 },
  { "Aneea", 0.0 },
  { "Aneecia", 0.0 },
  { "Aneek", 1.0 },
  { "Aneeka", 0.0 },
  { "Aneeksha", 0.0 },
  { "Aneel", 1.0 },
  { "Aneela", 0.0 },
  { "Aneeq", 1.0 },
  { "Aneeqa", 0.0 },
  { "Anees", 1.0 },
  { "Aneesa", 0.0 },
  { "Aneesah", 0.0 },
  { "Aneesh", 1.0 },
  { "Aneesha", 0.0 },
  { "Aneesia", 0.0 },
  { "Aneeya", 0.0 },
  { "Aneeza", 0.0 },
  { "Anegla", 0.0 },
  { "Aneia", 0.0 },
  { "Aneicia", 0.0 },
  { "Aneida", 0.0 },
  { "Aneika", 0.0 },
  { "Aneil", 1.0 },
  { "Aneila", 0.0 },
  { "Aneira", 0.0 },
  { "Aneisa", 0.0 },
  { "Aneisha", 0.0 },
  { "Aneissa", 0.0 },
  { "Aneita", 0.0 },
  { "Aneitra", 0.0 },
  { "Aneiya", 0.0 },
  { "Aneiyah", 0.0 },
  { "Aneka", 0.0 },
  { "Anel", 0.12580486 },
  { "Anela", 0.0 },
  { "Anelah", 0.0 },
  { "Anele", 0.0 },
  { "Aneley", 0.0 },
  { "Aneli", 0.0 },
  { "Anelia", 0.0 },
  { "Anelie", 0.0 },
  { "Aneliese", 0.0 },
  { "Anelis", 0.0 },
  { "Anelisa", 0.0 },
  { "Anelise", 0.0 },
  { "Anelisse", 0.0 },
  { "Aneliz", 0.0 },
  { "Anell", 0.0 },
  { "Anella", 0.0 },
  { "Anelle", 0.0 },
  { "Anello", 1.0 },
  { "Anelly", 0.0 },
  { "Anely", 0.0 },
  { "Anelys", 0.0 },
  { "Anelyse", 0.0 },
  { "Anemone", 0.0 },
  { "Aner", 0.5882353 },
  { "Aneres", 0.0 },
  { "Aneri", 0.0 },
  { "Aneria", 0.0 },
  { "Aneris", 0.0 },
  { "Anes", 1.0 },
  { "Anesa", 0.0 },
  { "Anesha", 0.0 },
  { "Aneshia", 0.0 },
  { "Anesia", 0.0 },
  { "Anessa", 0.0 },
  { "Anessah", 0.0 },
  { "Anessia", 0.0 },
  { "Anesti", 0.5 },
  { "Anesty", 0.0 },
  { "Anet", 0.0 },
  { "Aneta", 0.0 },
  { "Aneth", 0.0 },
  { "Anetha", 0.0 },
  { "Anetia", 0.0 },
  { "Anetra", 0.0 },
  { "Anetria", 0.0 },
  { "Anett", 0.0 },
  { "Anetta", 0.0 },
  { "Anette", 0.0 },
  { "Aneudi", 1.0 },
  { "Aneudy", 1.0 },
  { "Aneva", 0.0 },
  { "Anevaeh", 0.0 },
  { "Anevay", 0.0 },
  { "Aneya", 0.0 },
  { "Aneyah", 0.0 },
  { "Aneyda", 0.0 },
  { "Aneysa", 0.0 },
  { "Aneysha", 0.0 },
  { "Anezka", 0.0 },
  { "Anfal", 0.0 },
  { "Anferne", 1.0 },
  { "Anfernee", 1.0 },
  { "Anferney", 1.0 },
  { "Anferny", 1.0 },
  { "Anfisa", 0.0 },
  { "Anfrenee", 1.0 },
  { "Ang", 1.0 },
  { "Anga", 0.0 },
  { "Angad", 1.0 },
  { "Angala", 0.0 },
  { "Angalee", 0.0 },
  { "Angalena", 0.0 },
  { "Angalina", 0.0 },
  { "Anganette", 0.0 },
  { "Ange", 0.02849003 },
  { "Angeal", 1.0 },
  { "Angee", 0.0 },
  { "Angel", 0.7022274 },
  { "Angela", 0.0032146599 },
  { "Angelah", 0.0 },
  { "Angelamae", 0.0 },
  { "Angelamaria", 0.0 },
  { "Angelamarie", 0.0 },
  { "Angelann", 0.0 },
  { "Angelar", 0.0 },
  { "Angeldaniel", 1.0 },
  { "Angeldavid", 1.0 },
  { "Angeldejesus", 1.0 },
  { "Angele", 0.0 },
  { "Angelea", 0.0 },
  { "Angeleah", 0.0 },
  { "Angelean", 0.0 },
  { "Angeleana", 0.0 },
  { "Angeleca", 0.0 },
  { "Angelee", 0.0 },
  { "Angeleen", 0.0 },
  { "Angeleena", 0.0 },
  { "Angeleia", 0.0 },
  { "Angeleigh", 0.0 },
  { "Angelena", 0.0 },
  { "Angelene", 0.0 },
  { "Angelenia", 0.0 },
  { "Angeleque", 0.0 },
  { "Angeles", 0.020907044 },
  { "Angelese", 0.0 },
  { "Angeleta", 0.0 },
  { "Angelete", 0.0 },
  { "Angeletta", 0.0 },
  { "Angelette", 0.0 },
  { "Angelgabriel", 1.0 },
  { "Angeli", 0.0 },
  { "Angelia", 0.0009934971 },
  { "Angeliah", 0.0 },
  { "Angelian", 0.0 },
  { "Angeliana", 0.0 },
  { "Angelic", 0.0 },
  { "Angelica", 0.0036063364 },
  { "Angelicamae", 0.0 },
  { "Angelicamaria", 0.0 },
  { "Angelicamarie", 0.0 },
  { "Angelice", 0.0 },
  { "Angelicia", 0.0 },
  { "Angelick", 0.0 },
  { "Angelicque", 0.0 },
  { "Angelie", 0.0 },
  { "Angeliese", 0.0 },
  { "Angeligue", 0.0 },
  { "Angelik", 0.0 },
  { "Angelika", 0.0 },
  { "Angelike", 0.0 },
  { "Angeliki", 0.0 },
  { "Angelin", 0.0 },
  { "Angelina", 0.00095607236 },
  { "Angelinah", 0.0 },
  { "Angelinamarie", 0.0 },
  { "Angeline", 0.0002836477 },
  { "Angelinna", 0.0 },
  { "Angelinne", 0.0 },
  { "Angelino", 1.0 },
  { "Angeliq", 0.0 },
  { "Angeliqu", 0.0 },
  { "Angeliqua", 0.0 },
  { "Angelique", 0.00021581957 },
  { "Angelis", 0.07322176 },
  { "Angelisa", 0.0 },
  { "Angelise", 0.0 },
  { "Angelisha", 0.0 },
  { "Angelissa", 0.0 },
  { "Angelisse", 0.0 },
  { "Angelita", 0.0032101336 },
  { "Angelite", 0.0 },
  { "Angelith", 0.0 },
  { "Angelito", 1.0 },
  { "Angeliya", 0.0 },
  { "Angeliyah", 0.0 },
  { "Angeliz", 0.0 },
  { "Angeliza", 0.0 },
  { "Angelize", 0.0 },
  { "Angeljesus", 1.0 },
  { "Angell", 0.22628951 },
  { "Angella", 0.0 },
  { "Angelle", 0.0 },
  { "Angellea", 0.0 },
  { "Angelleah", 0.0 },
  { "Angellee", 0.0 },
  { "Angelleigh", 0.0 },
  { "Angellena", 0.0 },
  { "Angelli", 0.0 },
  { "Angellia", 0.0 },
  { "Angellica", 0.0 },
  { "Angellie", 0.0 },
  { "Angellina", 0.0 },
  { "Angelline", 0.0 },
  { "Angellique", 0.0 },
  { "Angello", 1.0 },
  { "Angelluis", 1.0 },
  { "Angelly", 0.0 },
  { "Angellyn", 0.0 },
  { "Angellyna", 0.0 },
  { "Angellynn", 0.0 },
  { "Angelmanuel", 1.0 },
  { "Angelmarie", 0.0 },
  { "Angelmiguel", 1.0 },
  { "Angelo", 0.9889882 },
  { "Angelos", 1.0 },
  { "Angelou", 1.0 },
  { "Angelous", 1.0 },
  { "Angelque", 0.0 },
  { "Angelray", 1.0 },
  { "Angelrose", 0.0 },
  { "Angeluis", 1.0 },
  { "Angelus", 0.9251497 },
  { "Angely", 0.0 },
  { "Angelyca", 0.0 },
  { "Angelyce", 0.0 },
  { "Angelyka", 0.0 },
  { "Angelyn", 0.0 },
  { "Angelyna", 0.0 },
  { "Angelyne", 0.0 },
  { "Angelynn", 0.0 },
  { "Angelynna", 0.0 },
  { "Angelynne", 0.0 },
  { "Angelys", 0.0 },
  { "Angelyse", 0.0 },
  { "Angelyssa", 0.0 },
  { "Angelysse", 0.0 },
  { "Angenetta", 0.0 },
  { "Angenette", 0.0 },
  { "Angeni", 0.0 },
  { "Angenie", 0.0 },
  { "Angenique", 0.0 },
  { "Angenita", 0.0 },
  { "Anges", 0.0 },
  { "Anggie", 0.0 },
  { "Angharad", 0.0 },
  { "Anghel", 1.0 },
  { "Angi", 0.0 },
  { "Angia", 0.0 },
  { "Angie", 0.0021134145 },
  { "Angiela", 0.0 },
  { "Angielina", 0.0 },
  { "Angil", 0.0 },
  { "Angila", 0.0 },
  { "Angilee", 0.0 },
  { "Angilina", 0.0 },
  { "Angilique", 0.0 },
  { "Anginette", 0.0 },
  { "Angiolina", 0.0 },
  { "Angla", 0.0 },
  { "Angle", 0.09811617 },
  { "Anglea", 0.0 },
  { "Anglee", 0.0 },
  { "Angleica", 0.0 },
  { "Anglene", 0.0 },
  { "Angleo", 1.0 },
  { "Angler", 1.0 },
  { "Angles", 0.0 },
  { "Anglia", 0.0 },
  { "Anglica", 0.0 },
  { "Anglie", 0.0 },
  { "Anglina", 0.0 },
  { "Angline", 0.0 },
  { "Anglique", 0.0 },
  { "Anglo", 1.0 },
  { "Anguel", 1.0 },
  { "Angula", 0.0 },
  { "Angus", 1.0 },
  { "Angy", 0.0 },
  { "Angye", 0.0 },
  { "Angyl", 0.0 },
  { "Anh", 0.30879447 },
  { "Anhad", 1.0 },
  { "Anhar", 0.0 },
  { "Anhelica", 0.0 },
  { "Anhthu", 0.0 },
  { "Anhtony", 1.0 },
  { "Anhtuan", 1.0 },
  { "Anhuar", 1.0 },
  { "Ani", 0.0019762847 },
  { "Ania", 0.0 },
  { "Aniah", 0.0 },
  { "Aniaha", 0.0 },
  { "Anias", 0.88 },
  { "Aniaya", 0.0 },
  { "Aniayah", 0.0 },
  { "Anibal", 0.9939176 },
  { "Anibella", 0.0 },
  { "Anibelle", 0.0 },
  { "Anica", 0.0 },
  { "Anice", 0.0 },
  { "Aniceta", 0.0 },
  { "Aniceto", 1.0 },
  { "Anicia", 0.0 },
  { "Anicka", 0.0 },
  { "Anida", 0.0 },
  { "Anie", 0.0 },
  { "Aniece", 0.0 },
  { "Aniecia", 0.0 },
  { "Aniel", 1.0 },
  { "Aniela", 0.0 },
  { "Anielka", 0.0 },
  { "Aniella", 0.0 },
  { "Anielle", 0.0 },
  { "Aniello", 1.0 },
  { "Aniesa", 0.0 },
  { "Aniesha", 0.0 },
  { "Aniessa", 0.0 },
  { "Anieta", 0.0 },
  { "Anietra", 0.0 },
  { "Anieya", 0.0 },
  { "Anieyah", 0.0 },
  { "Aniha", 0.0 },
  { "Anihya", 0.0 },
  { "Aniiya", 0.0 },
  { "Aniiyah", 0.0 },
  { "Anij", 0.0 },
  { "Anija", 0.0 },
  { "Anijae", 0.0 },
  { "Anijah", 0.0 },
  { "Anijha", 0.0 },
  { "Anijia", 0.0 },
  { "Anik", 0.9346154 },
  { "Anika", 0.0 },
  { "Anikah", 0.0 },
  { "Anikait", 1.0 },
  { "Anikan", 1.0 },
  { "Anike", 0.0 },
  { "Aniken", 1.0 },
  { "Aniket", 1.0 },
  { "Aniketh", 1.0 },
  { "Aniki", 1.0 },
  { "Anikia", 0.0 },
  { "Anikin", 1.0 },
  { "Anikka", 0.0 },
  { "Aniko", 0.0 },
  { "Anikyn", 1.0 },
  { "Anil", 1.0 },
  { "Anila", 0.0 },
  { "Anilah", 0.0 },
  { "Anilu", 0.0 },
  { "Anilya", 0.0 },
  { "Anilyah", 0.0 },
  { "Anilyn", 0.0 },
  { "Anime", 0.0 },
  { "Animesh", 1.0 },
  { "Anina", 0.0 },
  { "Anindita", 0.0 },
  { "Aniq", 1.0 },
  { "Aniqa", 0.0 },
  { "Aniqua", 0.0 },
  { "Anique", 0.0 },
  { "Anir", 1.0 },
  { "Anira", 0.0 },
  { "Anirah", 0.0 },
  { "Anirud", 1.0 },
  { "Aniruddh", 1.0 },
  { "Aniruddha", 1.0 },
  { "Anirudh", 1.0 },
  { "Anirvin", 1.0 },
  { "Anis", 0.79041916 },
  { "Anisa", 0.0 },
  { "Anisah", 0.0 },
  { "Anise", 0.0 },
  { "Aniseto", 1.0 },
  { "Anisette", 0.0 },
  { "Anish", 1.0 },
  { "Anisha", 0.0 },
  { "Anishia", 0.0 },
  { "Anishka", 0.0 },
  { "Anisia", 0.0 },
  { "Anisjon", 1.0 },
  { "Anisley", 0.0 },
  { "Anissa", 0.00042480882 },
  { "Anissah", 0.0 },
  { "Anisse", 0.0 },
  { "Anissia", 0.0 },
  { "Anistasia", 0.0 },
  { "Anisten", 0.0 },
  { "Anistin", 0.0 },
  { "Aniston", 0.010439561 },
  { "Anisty", 0.0 },
  { "Anistyn", 0.0 },
  { "Anistynn", 0.0 },
  { "Anita", 0.0031913107 },
  { "Anite", 0.0 },
  { "Anitha", 0.0 },
  { "Anitia", 0.0 },
  { "Anitra", 0.0 },
  { "Anitrea", 0.0 },
  { "Anitria", 0.0 },
  { "Anitrice", 0.0 },
  { "Anitta", 0.0 },
  { "Anitza", 0.0 },
  { "Aniv", 1.0 },
  { "Aniva", 0.0 },
  { "Anival", 1.0 },
  { "Anivea", 0.0 },
  { "Anivia", 0.0 },
  { "Aniya", 0.0 },
  { "Aniyah", 0.0002193656 },
  { "Aniyaha", 0.0 },
  { "Aniyahlee", 0.0 },
  { "Aniyan", 0.0 },
  { "Aniye", 0.0 },
  { "Aniyha", 0.0 },
  { "Aniyia", 0.0 },
  { "Aniyiah", 0.0 },
  { "Aniyja", 0.0 },
  { "Aniyjah", 0.0 },
  { "Aniyla", 0.0 },
  { "Aniylah", 0.0 },
  { "Aniysa", 0.0 },
  { "Aniyyah", 0.0 },
  { "Aniza", 0.0 },
  { "Anja", 0.0 },
  { "Anjae", 0.0 },
  { "Anjail", 0.0 },
  { "Anjalee", 0.0 },
  { "Anjalena", 0.0 },
  { "Anjali", 0.0 },
  { "Anjalie", 0.0 },
  { "Anjalika", 0.0 },
  { "Anjalina", 0.0 },
  { "Anjaliyah", 0.0 },
  { "Anjaly", 0.0 },
  { "Anjan", 1.0 },
  { "Anjana", 0.0 },
  { "Anjanae", 0.0 },
  { "Anjanet", 0.0 },
  { "Anjanett", 0.0 },
  { "Anjanetta", 0.0 },
  { "Anjanette", 0.0 },
  { "Anjani", 0.0 },
  { "Anjanie", 0.0 },
  { "Anjanique", 0.0 },
  { "Anjannette", 0.0 },
  { "Anjay", 1.0 },
  { "Anjeanette", 0.0 },
  { "Anjel", 0.73150104 },
  { "Anjela", 0.0 },
  { "Anjelah", 0.0 },
  { "Anjeli", 0.0 },
  { "Anjelia", 0.0 },
  { "Anjelica", 0.0 },
  { "Anjelicia", 0.0 },
  { "Anjeliett", 0.0 },
  { "Anjelika", 0.0 },
  { "Anjelina", 0.0 },
  { "Anjelique", 0.0 },
  { "Anjelita", 0.0 },
  { "Anjellica", 0.0 },
  { "Anjelo", 1.0 },
  { "Anjely", 0.0 },
  { "Anjelyka", 0.0 },
  { "Anjelyn", 0.0 },
  { "Anjelyna", 0.0 },
  { "Anjenette", 0.0 },
  { "Anjennette", 0.0 },
  { "Anji", 0.0 },
  { "Anjie", 0.0 },
  { "Anjli", 0.0 },
  { "Anjola", 0.0 },
  { "Anjolaoluwa", 0.057894737 },
  { "Anjolee", 0.0 },
  { "Anjolena", 0.0 },
  { "Anjoli", 0.0 },
  { "Anjolie", 0.0 },
  { "Anjolina", 0.0 },
  { "Anjolique", 0.0 },
  { "Anjonette", 0.0 },
  { "Anjrue", 1.0 },
  { "Anju", 0.0 },
  { "Anjuan", 1.0 },
  { "Anjuli", 0.0 },
  { "Anjulie", 0.0 },
  { "Anjum", 0.0 },
  { "Anka", 0.0 },
  { "Anke", 0.0 },
  { "Anker", 1.0 },
  { "Ankit", 1.0 },
  { "Ankita", 0.0 },
  { "Ankith", 1.0 },
  { "Ankitha", 0.0 },
  { "Ankoma", 1.0 },
  { "Ankoor", 1.0 },
  { "Ankur", 1.0 },
  { "Ankush", 1.0 },
  { "Anleigh", 0.0 },
  { "Anley", 0.0 },
  { "Anlin", 0.0 },
  { "Anllely", 0.0 },
  { "Anlly", 0.0 },
  { "Anly", 0.0 },
  { "Anmar", 1.0 },
  { "Anmarie", 0.0 },
  { "Anmay", 1.0 },
  { "Anmol", 0.5727003 },
  { "Ann", 0.0029076021 },
  { "Anna", 0.003081386 },
  { "Annaalicia", 0.0 },
  { "Annabel", 0.0 },
  { "Annabela", 0.0 },
  { "Annabele", 0.0 },
  { "Annabell", 0.0 },
  { "Annabella", 0.0 },
  { "Annabellah", 0.0 },
  { "Annabelle", 0.0001819472 },
  { "Annabellee", 0.0 },
  { "Annabellelee", 0.0 },
  { "Annabeth", 0.0 },
  { "Annacarolina", 0.0 },
  { "Annacatherine", 0.0 },
  { "Annachristina", 0.0 },
  { "Annaclaire", 0.0 },
  { "Annaclara", 0.0 },
  { "Annadell", 0.0 },
  { "Annaelise", 0.0 },
  { "Annaelizabeth", 0.0 },
  { "Annaelle", 0.0 },
  { "Annagail", 0.0 },
  { "Annagene", 0.0 },
  { "Annagrace", 0.0 },
  { "Annah", 0.0 },
  { "Annahbella", 0.0 },
  { "Annahi", 0.0 },
  { "Annahy", 0.0 },
  { "Annai", 0.0 },
  { "Annaie", 0.0 },
  { "Annaira", 0.0 },
  { "Annais", 0.0 },
  { "Annaise", 0.0 },
  { "Annajane", 0.0 },
  { "Annajean", 0.0 },
  { "Annajo", 0.0 },
  { "Annajoy", 0.0 },
  { "Annajulia", 0.0 },
  { "Annaka", 0.0 },
  { "Annakaren", 0.0 },
  { "Annakate", 0.0 },
  { "Annakatherine", 0.0 },
  { "Annakathryn", 0.0 },
  { "Annakay", 0.0 },
  { "Annakiya", 0.0 },
  { "Annalaura", 0.0 },
  { "Annalaya", 0.0 },
  { "Annalayah", 0.0 },
  { "Annalea", 0.0 },
  { "Annaleah", 0.0 },
  { "Annalease", 0.0 },
  { "Annalecia", 0.0 },
  { "Annalee", 0.0 },
  { "Annaleece", 0.0 },
  { "Annaleese", 0.0 },
  { "Annalei", 0.0 },
  { "Annaleia", 0.0 },
  { "Annaleigh", 0.0 },
  { "Annaleigha", 0.0 },
  { "Annaleisa", 0.0 },
  { "Annaleise", 0.0 },
  { "Annalena", 0.0 },
  { "Annalene", 0.0 },
  { "Annalese", 0.0 },
  { "Annalesia", 0.0 },
  { "Annaley", 0.0 },
  { "Annaleya", 0.0 },
  { "Annali", 0.0 },
  { "Annalia", 0.0 },
  { "Annaliah", 0.0 },
  { "Annalice", 0.0 },
  { "Annalicia", 0.0 },
  { "Annalie", 0.0 },
  { "Annaliece", 0.0 },
  { "Annaliesa", 0.0 },
  { "Annaliese", 0.0 },
  { "Annaliesse", 0.0 },
  { "Annaliisa", 0.0 },
  { "Annalin", 0.0 },
  { "Annalina", 0.0 },
  { "Annaline", 0.0 },
  { "Annalis", 0.0 },
  { "Annalisa", 0.0 },
  { "Annalise", 0.0 },
  { "Annalisha", 0.0 },
  { "Annalisia", 0.0 },
  { "Annalissa", 0.0 },
  { "Annalisse", 0.0 },
  { "Annaliya", 0.0 },
  { "Annaliyah", 0.0 },
  { "Annaliz", 0.0 },
  { "Annaliza", 0.0 },
  { "Annalize", 0.0 },
  { "Annalou", 0.0 },
  { "Annalouise", 0.0 },
  { "Annalucia", 0.0 },
  { "Annaluisa", 0.0 },
  { "Annaluiza", 0.0 },
  { "Annaly", 0.0 },
  { "Annalya", 0.0 },
  { "Annalyce", 0.0 },
  { "Annalycia", 0.0 },
  { "Annalyn", 0.0 },
  { "Annalyne", 0.0 },
  { "Annalynn", 0.0 },
  { "Annalynne", 0.0 },
  { "Annalys", 0.0 },
  { "Annalysa", 0.0 },
  { "Annalyse", 0.0 },
  { "Annalysia", 0.0 },
  { "Annalyss", 0.0 },
  { "Annalyssa", 0.0 },
  { "Annalysse", 0.0 },
  { "Annalyssia", 0.0 },
  { "Annam", 0.0 },
  { "Annamae", 0.0 },
  { "Annamari", 0.0 },
  { "Annamaria", 0.0 },
  { "Annamarie", 0.0 },
  { "Annamary", 0.0 },
  { "Annamay", 0.0 },
  { "Annamolly", 0.0 },
  { "Annan", 1.0 },
  { "Annanicole", 0.0 },
  { "Annanya", 0.0 },
  { "Annapaula", 0.0 },
  { "Annapurna", 0.0 },
  { "Annarae", 0.0 },
  { "Annarosa", 0.0 },
  { "Annarose", 0.0 },
  { "Annaruth", 0.0 },
  { "Annas", 0.60714287 },
  { "Annasha", 0.0 },
  { "Annasia", 0.0 },
  { "Annasofia", 0.0 },
  { "Annasophia", 0.0 },
  { "Annastacia", 0.0 },
  { "Annastashia", 0.0 },
  { "Annastasia", 0.0 },
  { "Annastassia", 0.0 },
  { "Annastazia", 0.0 },
  { "Annastin", 0.0 },
  { "Annaston", 0.0 },
  { "Annastyn", 0.0 },
  { "Annavictoria", 0.0 },
  { "Annay", 0.0 },
  { "Annaya", 0.0 },
  { "Annayah", 0.0 },
  { "Annayeli", 0.0 },
  { "Annazette", 0.0 },
  { "Anndee", 0.0 },
  { "Anndi", 0.0 },
  { "Anndrea", 0.0 },
  { "Anndria", 0.0 },
  { "Anndy", 1.0 },
  { "Anne", 0.002579212 },
  { "Annea", 0.0 },
  { "Annease", 0.0 },
  { "Annebelle", 0.0 },
  { "Annecia", 0.0 },
  { "Annecy", 0.0 },
  { "Annee", 0.0 },
  { "Anneelise", 0.0 },
  { "Anneelizabeth", 0.0 },
  { "Anneice", 0.0 },
  { "Anneisha", 0.0 },
  { "Anneka", 0.0 },
  { "Anneke", 0.0 },
  { "Annel", 0.0 },
  { "Annelee", 0.0 },
  { "Anneleise", 0.0 },
  { "Anneli", 0.0 },
  { "Annelie", 0.0 },
  { "Annelies", 0.0 },
  { "Anneliesa", 0.0 },
  { "Anneliese", 0.0 },
  { "Anneliesse", 0.0 },
  { "Annelis", 0.0 },
  { "Annelisa", 0.0 },
  { "Annelise", 0.0 },
  { "Annelisse", 0.0 },
  { "Anneliz", 0.0 },
  { "Annelizabeth", 0.0 },
  { "Annell", 0.0 },
  { "Annella", 0.0 },
  { "Annelle", 0.0 },
  { "Annelouise", 0.0 },
  { "Annely", 0.0 },
  { "Annelyn", 0.0 },
  { "Annelys", 0.0 },
  { "Annelyse", 0.0 },
  { "Annemargaret", 0.0 },
  { "Annemari", 0.0 },
  { "Annemarie", 0.0 },
  { "Annemary", 0.0 },
  { "Anner", 0.011483254 },
  { "Annesa", 0.0 },
  { "Annese", 0.0 },
  { "Annesha", 0.0 },
  { "Anneshia", 0.0 },
  { "Annesia", 0.0 },
  { "Annesley", 0.0 },
  { "Annesophie", 0.0 },
  { "Annessa", 0.0 },
  { "Annessia", 0.0 },
  { "Annet", 0.0 },
  { "Anneta", 0.0 },
  { "Annete", 0.0 },
  { "Anneth", 0.0 },
  { "Annetha", 0.0 },
  { "Annetra", 0.0 },
  { "Annett", 0.0 },
  { "Annetta", 0.0 },
  { "Annette", 0.0029674827 },
  { "Annettee", 0.0 },
  { "Annettia", 0.0 },
  { "Annettie", 0.0 },
  { "Annexie", 0.0 },
  { "Anney", 0.0 },
  { "Anngela", 0.0 },
  { "Anngelica", 0.0 },
  { "Anngelina", 0.0 },
  { "Anngie", 0.0 },
  { "Anni", 0.0 },
  { "Annia", 0.0 },
  { "Anniah", 0.0 },
  { "Annias", 1.0 },
  { "Annibale", 1.0 },
  { "Annibella", 0.0 },
  { "Annibelle", 0.0 },
  { "Annica", 0.0 },
  { "Annice", 0.0 },
  { "Annicia", 0.0 },
  { "Annick", 0.0 },
  { "Annicka", 0.0 },
  { "Annie", 0.0054887 },
  { "Anniebell", 0.0 },
  { "Anniebelle", 0.0 },
  { "Anniece", 0.0 },
  { "Annielaurie", 0.0 },
  { "Annielee", 0.0 },
  { "Annielou", 0.0 },
  { "Anniemae", 0.0 },
  { "Anniemarie", 0.0 },
  { "Annieruth", 0.0 },
  { "Annies", 0.0 },
  { "Anniesha", 0.0 },
  { "Annika", 0.0 },
  { "Annikah", 0.0 },
  { "Annikka", 0.0 },
  { "Annil", 0.0 },
  { "Annilee", 0.0 },
  { "Annily", 0.0 },
  { "Annilyn", 0.0 },
  { "Annina", 0.0 },
  { "Anniqua", 0.0 },
  { "Annique", 0.0 },
  { "Annis", 0.0023964397 },
  { "Annisa", 0.0 },
  { "Annise", 0.0 },
  { "Annisha", 0.0 },
  { "Annison", 0.0 },
  { "Annissa", 0.0 },
  { "Annissia", 0.0 },
  { "Annisten", 0.0 },
  { "Annistin", 0.0 },
  { "Anniston", 0.0 },
  { "Annistyn", 0.0 },
  { "Annita", 0.0 },
  { "Annitra", 0.0 },
  { "Annitta", 0.0 },
  { "Annitte", 0.0 },
  { "Anniya", 0.0 },
  { "Anniyah", 0.0 },
  { "Annjane", 0.0 },
  { "Annjanette", 0.0 },
  { "Annjeanette", 0.0 },
  { "Annjelica", 0.0 },
  { "Annlee", 0.0 },
  { "Annleigh", 0.0 },
  { "Annley", 0.0 },
  { "Annlouise", 0.0 },
  { "Annlynn", 0.0 },
  { "Annmargaret", 0.0 },
  { "Annmari", 0.0 },
  { "Annmaria", 0.0 },
  { "Annmarie", 0.0 },
  { "Annmary", 0.0 },
  { "Annon", 1.0 },
  { "Annora", 0.0 },
  { "Annorah", 0.0 },
  { "Annslee", 0.0 },
  { "Annsleigh", 0.0 },
  { "Annsley", 0.0 },
  { "Annslie", 0.0 },
  { "Anntionette", 0.0 },
  { "Anntoinette", 0.0 },
  { "Anntonette", 0.0 },
  { "Annum", 0.0 },
  { "Annunciata", 0.0 },
  { "Annunziata", 0.0 },
  { "Annunzio", 1.0 },
  { "Anny", 0.0 },
  { "Annya", 0.0 },
  { "Annyah", 0.0 },
  { "Annye", 0.0 },
  { "Annyka", 0.0 },
  { "Annysa", 0.0 },
  { "Annyssa", 0.0 },
  { "Annyston", 0.0 },
  { "Annzlee", 0.0 },
  { "Annzley", 0.0 },
  { "Anokhi", 0.0 },
  { "Anoki", 1.0 },
  { "Anola", 0.0 },
  { "Anon", 1.0 },
  { "Anona", 0.0 },
  { "Anonda", 0.0 },
  { "Anooj", 1.0 },
  { "Anoop", 0.8695652 },
  { "Anoosha", 0.0 },
  { "Anora", 0.0 },
  { "Anorah", 0.0 },
  { "Anorea", 0.0 },
  { "Anori", 0.0 },
  { "Anosha", 0.0 },
  { "Anothny", 1.0 },
  { "Anothony", 1.0 },
  { "Anothy", 1.0 },
  { "Anouk", 0.0 },
  { "Anoush", 0.0 },
  { "Anousha", 0.0 },
  { "Anoushka", 0.0 },
  { "Anousone", 1.0 },
  { "Anova", 0.0 },
  { "Anqi", 0.0 },
  { "Anquan", 1.0 },
  { "Anquanette", 0.0 },
  { "Anquavious", 1.0 },
  { "Anquenette", 0.0 },
  { "Anquetta", 0.0 },
  { "Anquette", 0.0 },
  { "Anquinetta", 0.0 },
  { "Anquinette", 0.0 },
  { "Anqunette", 0.0 },
  { "Anre", 1.0 },
  { "Anrea", 0.0 },
  { "Anrew", 1.0 },
  { "Anri", 1.0 },
  { "Ansa", 0.0 },
  { "Ansal", 0.0 },
  { "Ansar", 1.0 },
  { "Ansara", 1.0 },
  { "Ansel", 0.9970432 },
  { "Ansell", 1.0 },
  { "Anselm", 1.0 },
  { "Anselma", 0.0 },
  { "Anselmi", 1.0 },
  { "Anselmo", 1.0 },
  { "Ansen", 1.0 },
  { "Ansh", 1.0 },
  { "Ansha", 0.0 },
  { "Anshel", 1.0 },
  { "Anshi", 0.0 },
  { "Anshika", 0.0 },
  { "Anshita", 0.0 },
  { "Anshu", 0.08196721 },
  { "Anshul", 1.0 },
  { "Anshuman", 1.0 },
  { "Anshveer", 1.0 },
  { "Ansil", 1.0 },
  { "Anslea", 0.0 },
  { "Anslee", 0.0 },
  { "Anslei", 0.0 },
  { "Ansleigh", 0.0 },
  { "Anslem", 1.0 },
  { "Ansley", 0.029396858 },
  { "Ansli", 0.0 },
  { "Anslie", 0.0 },
  { "Anson", 0.99920624 },
  { "Ansonia", 0.0 },
  { "Ansony", 1.0 },
  { "Ansu", 1.0 },
  { "Ansumana", 1.0 },
  { "Anta", 0.0 },
  { "Antaeus", 1.0 },
  { "Antaja", 0.0 },
  { "Antajuan", 1.0 },
  { "Antal", 1.0 },
  { "Antalya", 0.0 },
  { "Antanae", 0.0 },
  { "Antanasia", 0.0 },
  { "Antanay", 0.0 },
  { "Antanea", 0.0 },
  { "Antaneisha", 0.0 },
  { "Antanesha", 0.0 },
  { "Antanette", 0.0 },
  { "Antania", 0.0 },
  { "Antanika", 0.0 },
  { "Antanique", 0.0 },
  { "Antanisha", 0.0 },
  { "Antaniya", 0.0 },
  { "Antaniyah", 0.0 },
  { "Antar", 1.0 },
  { "Antara", 0.0 },
  { "Antares", 1.0 },
  { "Antario", 1.0 },
  { "Antarious", 1.0 },
  { "Antarius", 1.0 },
  { "Antashia", 0.0 },
  { "Antasia", 0.0 },
  { "Antaun", 1.0 },
  { "Antavia", 0.0 },
  { "Antavion", 1.0 },
  { "Antavious", 1.0 },
  { "Antavis", 1.0 },
  { "Antavius", 1.0 },
  { "Antawan", 1.0 },
  { "Antawn", 1.0 },
  { "Antawon", 1.0 },
  { "Antaysia", 0.0 },
  { "Ante", 1.0 },
  { "Antea", 0.0 },
  { "Anteaus", 1.0 },
  { "Antelmo", 1.0 },
  { "Antenette", 0.0 },
  { "Anteo", 1.0 },
  { "Anteria", 0.0 },
  { "Anterio", 1.0 },
  { "Anterion", 1.0 },
  { "Anterious", 1.0 },
  { "Anterius", 1.0 },
  { "Antero", 1.0 },
  { "Anterria", 0.0 },
  { "Anterrio", 1.0 },
  { "Anterrion", 1.0 },
  { "Anterrius", 1.0 },
  { "Antesha", 0.0 },
  { "Antha", 0.0 },
  { "Anthani", 1.0 },
  { "Anthany", 1.0 },
  { "Anthea", 0.0 },
  { "Antheia", 0.0 },
  { "Anthem", 0.88461536 },
  { "Antheny", 1.0 },
  { "Anthia", 0.0 },
  { "Anthnoy", 1.0 },
  { "Anthny", 1.0 },
  { "Anthoine", 1.0 },
  { "Anthon", 1.0 },
  { "Anthone", 1.0 },
  { "Anthonee", 1.0 },
  { "Anthonella", 0.0 },
  { "Anthonette", 0.0 },
  { "Anthoney", 1.0 },
  { "Anthoni", 1.0 },
  { "Anthonia", 0.0 },
  { "Anthonie", 1.0 },
  { "Anthonio", 1.0 },
  { "Anthonique", 0.0 },
  { "Anthonny", 1.0 },
  { "Anthony", 0.99506944 },
  { "Anthonyjames", 1.0 },
  { "Anthonyjohn", 1.0 },
  { "Anthonyjoseph", 1.0 },
  { "Anthonyjr", 1.0 },
  { "Anthonymichael", 1.0 },
  { "Anthory", 1.0 },
  { "Anthoula", 0.0 },
  { "Anthoy", 1.0 },
  { "Anthuan", 1.0 },
  { "Antia", 0.0 },
  { "Antiana", 0.0 },
  { "Antianna", 0.0 },
  { "Antigone", 0.0 },
  { "Antimo", 1.0 },
  { "Antina", 0.0 },
  { "Antinette", 0.0 },
  { "Antinio", 1.0 },
  { "Antinique", 0.0 },
  { "Antinisha", 0.0 },
  { "Antino", 1.0 },
  { "Antion", 1.0 },
  { "Antiona", 0.7826087 },
  { "Antione", 0.9896274 },
  { "Antionett", 0.0 },
  { "Antionetta", 0.0 },
  { "Antionette", 0.0 },
  { "Antionio", 1.0 },
  { "Antionna", 0.0 },
  { "Antionne", 1.0 },
  { "Antiono", 1.0 },
  { "Antiqua", 0.0 },
  { "Antisha", 0.0 },
  { "Antiwan", 1.0 },
  { "Antje", 0.0 },
  { "Antjuan", 1.0 },
  { "Antoan", 1.0 },
  { "Antohny", 1.0 },
  { "Antoin", 1.0 },
  { "Antoinae", 0.0 },
  { "Antoine", 0.9862236 },
  { "Antoinese", 0.0 },
  { "Antoinesha", 0.0 },
  { "Antoinet", 0.0 },
  { "Antoinett", 0.0 },
  { "Antoinetta", 0.0 },
  { "Antoinette", 0.0008692762 },
  { "Antoiniece", 0.0 },
  { "Antoinio", 1.0 },
  { "Antoinique", 0.0 },
  { "Antoinne", 1.0 },
  { "Antoinnette", 0.0 },
  { "Antoino", 1.0 },
  { "Antojuan", 1.0 },
  { "Antolin", 1.0 },
  { "Antolina", 0.0 },
  { "Anton", 0.9990682 },
  { "Antona", 0.0 },
  { "Antonae", 0.0 },
  { "Antonasia", 0.0 },
  { "Antonay", 0.0 },
  { "Antone", 0.9982938 },
  { "Antonea", 0.0 },
  { "Antoneisha", 0.0 },
  { "Antonela", 0.0 },
  { "Antonella", 0.0 },
  { "Antonello", 1.0 },
  { "Antoneo", 1.0 },
  { "Antonese", 0.0 },
  { "Antonesha", 0.0 },
  { "Antoneshia", 0.0 },
  { "Antonett", 0.0 },
  { "Antonetta", 0.0 },
  { "Antonette", 0.0 },
  { "Antoney", 1.0 },
  { "Antoneyo", 1.0 },
  { "Antoni", 0.9973319 },
  { "Antonia", 0.07499642 },
  { "Antoniah", 0.0 },
  { "Antonial", 1.0 },
  { "Antonica", 0.0 },
  { "Antonie", 0.97269183 },
  { "Antonieo", 1.0 },
  { "Antonieta", 0.0 },
  { "Antonietta", 0.0 },
  { "Antoniette", 0.0 },
  { "Antonin", 1.0 },
  { "Antonina", 0.0 },
  { "Antonine", 1.0 },
  { "Antoninette", 0.0 },
  { "Antonino", 1.0 },
  { "Antonio", 0.99197865 },
  { "Antoniodejesus", 1.0 },
  { "Antonion", 1.0 },
  { "Antonios", 1.0 },
  { "Antonious", 1.0 },
  { "Antonique", 0.0 },
  { "Antonis", 1.0 },
  { "Antonise", 0.0 },
  { "Antonisha", 0.0 },
  { "Antonita", 0.0 },
  { "Antonitte", 0.0 },
  { "Antonius", 1.0 },
  { "Antoniya", 0.0 },
  { "Antoniyah", 0.0 },
  { "Antoniyo", 1.0 },
  { "Antonne", 1.0 },
  { "Antonnette", 0.0 },
  { "Antonnia", 0.0 },
  { "Antonnio", 1.0 },
  { "Antonny", 1.0 },
  { "Antony", 1.0 },
  { "Antonya", 0.0 },
  { "Antonyio", 1.0 },
  { "Antonyo", 1.0 },
  { "Antoria", 0.0 },
  { "Antorio", 1.0 },
  { "Antorion", 1.0 },
  { "Antorria", 0.0 },
  { "Antowain", 1.0 },
  { "Antowan", 1.0 },
  { "Antowine", 1.0 },
  { "Antown", 1.0 },
  { "Antowne", 1.0 },
  { "Antoya", 0.0 },
  { "Antranette", 0.0 },
  { "Antravion", 1.0 },
  { "Antravious", 1.0 },
  { "Antre", 1.0 },
  { "Antrea", 0.0 },
  { "Antrel", 1.0 },
  { "Antrell", 1.0 },
  { "Antrese", 0.0 },
  { "Antrez", 1.0 },
  { "Antria", 0.0 },
  { "Antrice", 0.0 },
  { "Antrina", 0.0 },
  { "Antrione", 1.0 },
  { "Antroine", 1.0 },
  { "Antron", 1.0 },
  { "Antrone", 1.0 },
  { "Antronette", 0.0 },
  { "Antroy", 1.0 },
  { "Anttwan", 1.0 },
  { "Antuan", 1.0 },
  { "Antuane", 1.0 },
  { "Antuwan", 1.0 },
  { "Antvan", 1.0 },
  { "Antwaan", 1.0 },
  { "Antwain", 1.0 },
  { "Antwaine", 1.0 },
  { "Antwan", 0.99054396 },
  { "Antwana", 0.5833333 },
  { "Antwanae", 0.0 },
  { "Antwand", 1.0 },
  { "Antwane", 1.0 },
  { "Antwanesha", 0.0 },
  { "Antwanett", 0.0 },
  { "Antwanette", 0.0 },
  { "Antwanique", 0.0 },
  { "Antwanisha", 0.0 },
  { "Antwann", 1.0 },
  { "Antwanne", 1.0 },
  { "Antwaun", 0.9964489 },
  { "Antwaune", 1.0 },
  { "Antwayne", 1.0 },
  { "Antwian", 1.0 },
  { "Antwin", 1.0 },
  { "Antwine", 1.0 },
  { "Antwinette", 0.0 },
  { "Antwion", 1.0 },
  { "Antwione", 1.0 },
  { "Antwoin", 1.0 },
  { "Antwoine", 1.0 },
  { "Antwoinette", 0.0 },
  { "Antwon", 0.9991734 },
  { "Antwone", 1.0 },
  { "Antwonette", 0.0 },
  { "Antwonn", 1.0 },
  { "Antwonne", 1.0 },
  { "Antwuan", 1.0 },
  { "Antwun", 1.0 },
  { "Antwyne", 1.0 },
  { "Antyon", 1.0 },
  { "Antyone", 1.0 },
  { "Anu", 0.04385965 },
  { "Anuar", 1.0 },
  { "Anubhav", 1.0 },
  { "Anubis", 1.0 },
  { "Anudeep", 1.0 },
  { "Anuel", 1.0 },
  { "Anuhea", 0.0 },
  { "Anuhya", 0.0 },
  { "Anuj", 1.0 },
  { "Anuja", 0.0 },
  { "Anujin", 0.0 },
  { "Anum", 0.0 },
  { "Anuoluwa", 0.22727273 },
  { "Anuoluwapo", 0.0 },
  { "Anup", 1.0 },
  { "Anupam", 1.0 },
  { "Anupama", 0.0 },
  { "Anupriya", 0.0 },
  { "Anuraag", 1.0 },
  { "Anuradha", 0.0 },
  { "Anurag", 1.0 },
  { "Anureet", 0.0 },
  { "Anush", 1.0 },
  { "Anusha", 0.0 },
  { "Anushka", 0.0 },
  { "Anushree", 0.0 },
  { "Anushri", 0.0 },
  { "Anuska", 0.0 },
  { "Anusri", 0.0 },
  { "Anuva", 0.0 },
  { "Anvay", 1.0 },
  { "Anvesha", 0.0 },
  { "Anvi", 0.0 },
  { "Anvik", 1.0 },
  { "Anvika", 0.0 },
  { "Anvit", 1.0 },
  { "Anvita", 0.0 },
  { "Anvith", 1.0 },
  { "Anvitha", 0.0 },
  { "Anwaar", 0.0 },
  { "Anwan", 1.0 },
  { "Anwar", 0.9618745 },
  { "Anwen", 0.0 },
  { "Anwesha", 0.0 },
  { "Anwita", 0.0 },
  { "Anwitha", 0.0 },
  { "Anwon", 1.0 },
  { "Anwyn", 0.0 },
  { "Any", 0.0 },
  { "Anya", 0.0 },
  { "Anyae", 0.0 },
  { "Anyah", 0.0 },
  { "Anyanka", 0.0 },
  { "Anyce", 0.0 },
  { "Anycia", 0.0 },
  { "Anye", 0.0 },
  { "Anyea", 0.0 },
  { "Anyela", 0.0 },
  { "Anyeli", 0.0 },
  { "Anyelin", 0.0 },
  { "Anyelina", 0.0 },
  { "Anyeline", 0.0 },
  { "Anyelis", 0.0 },
  { "Anyelo", 1.0 },
  { "Anyely", 0.0 },
  { "Anyha", 0.0 },
  { "Anyhia", 0.0 },
  { "Anyi", 0.0 },
  { "Anyia", 0.0 },
  { "Anyiah", 0.0 },
  { "Anyieth", 0.0 },
  { "Anyila", 0.0 },
  { "Anyja", 0.0 },
  { "Anyjah", 0.0 },
  { "Anyjha", 0.0 },
  { "Anyka", 0.0 },
  { "Anyla", 0.0 },
  { "Anylah", 0.0 },
  { "Anylia", 0.0 },
  { "Anyliah", 0.0 },
  { "Anyra", 0.0 },
  { "Anyree", 0.0 },
  { "Anyri", 0.0 },
  { "Anyria", 0.0 },
  { "Anyriah", 0.0 },
  { "Anyrie", 0.0 },
  { "Anysa", 0.0 },
  { "Anysha", 0.0 },
  { "Anyshia", 0.0 },
  { "Anysia", 0.0 },
  { "Anyssa", 0.0 },
  { "Anyssia", 0.0 },
  { "Anyston", 0.0 },
  { "Anyya", 0.0 },
  { "Anza", 0.0 },
  { "Anzal", 0.0 },
  { "Anzar", 1.0 },
  { "Anze", 1.0 },
  { "Anzel", 0.9166667 },
  { "Anzie", 0.0 },
  { "Anzio", 1.0 },
  { "Anzlee", 0.0 },
  { "Anzleigh", 0.0 },
  { "Anzley", 0.0 },
  { "Anzlie", 0.0 },
  { "Aodhan", 1.0 },
  { "Aoi", 0.119791664 },
  { "Aoibheann", 0.0 },
  { "Aoife", 0.0 },
  { "Aoki", 0.0 },
  { "Aolani", 0.0 },
  { "Aolanis", 0.0 },
  { "Aolany", 0.0 },
  { "Aonesti", 0.0 },
  { "Aonesty", 0.0 },
  { "Aonna", 0.0 },
  { "Aous", 1.0 },
  { "Aowyn", 0.0 },
  { "Apache", 0.61538464 },
  { "Aparajita", 0.0 },
  { "Aparna", 0.0 },
  { "Apasra", 0.0 },
  { "Aphrodite", 0.0 },
  { "Aphton", 0.0 },
  { "Apiffany", 0.0 },
  { "Apiphany", 0.0 },
  { "Apirl", 0.0 },
  { "Apolinar", 0.9960723 },
  { "Apolline", 0.0 },
  { "Apollo", 1.0 },
  { "Apollonia", 0.0 },
  { "Apollos", 1.0 },
  { "Apolo", 1.0 },
  { "Apolonia", 0.0 },
  { "Apolonio", 1.0 },
  { "Aponi", 0.0 },
  { "Apoorva", 0.0 },
  { "Apostolis", 1.0 },
  { "Apostolos", 1.0 },
  { "Apphia", 0.0 },
  { "Appie", 0.0 },
  { "Apple", 0.0 },
  { "Apples", 0.0 },
  { "Applonia", 0.0 },
  { "Appollonia", 0.0 },
  { "Appolonia", 0.0 },
  { "Aprecious", 0.0 },
  { "Aprel", 0.0 },
  { "Aprell", 0.0 },
  { "Apria", 0.0 },
  { "Apriel", 0.0 },
  { "April", 0.0028021913 },
  { "Aprilann", 0.0 },
  { "Aprile", 0.0 },
  { "Apriljoy", 0.0 },
  { "Aprill", 0.0 },
  { "Aprille", 0.0 },
  { "Aprillynn", 0.0 },
  { "Aprilmarie", 0.0 },
  { "Apryl", 0.0 },
  { "Apryle", 0.0 },
  { "Apryll", 0.0 },
  { "Apsara", 0.0 },
  { "Apurva", 0.21705426 },
  { "Aqeel", 1.0 },
  { "Aqib", 1.0 },
  { "Aqil", 1.0 },
  { "Aqila", 0.0 },
  { "Aqilah", 0.0 },
  { "Aqsa", 0.0 },
  { "Aqua", 0.0 },
  { "Aquaisha", 0.0 },
  { "Aquala", 0.0 },
  { "Aquan", 1.0 },
  { "Aquanetta", 0.0 },
  { "Aquanette", 0.0 },
  { "Aquanis", 1.0 },
  { "Aquaria", 0.0 },
  { "Aquarius", 0.38802084 },
  { "Aquasha", 0.0 },
  { "Aquasia", 0.0 },
  { "Aquavia", 0.0 },
  { "Aquavion", 1.0 },
  { "Aquavious", 1.0 },
  { "Aqueela", 0.0 },
  { "Aqueelah", 0.0 },
  { "Aquera", 0.0 },
  { "Aquetzalli", 0.0 },
  { "Aquia", 0.0 },
  { "Aquiel", 0.0 },
  { "Aquil", 1.0 },
  { "Aquila", 0.08897743 },
  { "Aquilah", 0.0 },
  { "Aquileo", 1.0 },
  { "Aquiles", 1.0 },
  { "Aquilina", 0.0 },
  { "Aquilino", 1.0 },
  { "Aquill", 1.0 },
  { "Aquilla", 0.10583942 },
  { "Aquille", 1.0 },
  { "Aquina", 0.0 },
  { "Aquinas", 1.0 },
  { "Aquinnah", 0.0 },
  { "Aquino", 1.0 },
  { "Aquira", 0.0 },
  { "Aquisha", 0.0 },
  { "Aquita", 0.0 },
  { "Ar", 1.0 },
  { "Ara", 0.27825466 },
  { "Araba", 0.0 },
  { "Arabel", 0.0 },
  { "Arabela", 0.0 },
  { "Arabell", 0.0 },
  { "Arabella", 0.0 },
  { "Arabellah", 0.0 },
  { "Arabellarose", 0.0 },
  { "Arabelle", 0.0 },
  { "Arabia", 0.0 },
  { "Arabian", 0.0 },
  { "Aracel", 0.0 },
  { "Aracele", 0.0 },
  { "Araceli", 0.007758039 },
  { "Aracelia", 0.0 },
  { "Aracelie", 0.0 },
  { "Aracelio", 1.0 },
  { "Aracelis", 0.0 },
  { "Araceliz", 0.0 },
  { "Aracelli", 0.0 },
  { "Aracellie", 0.0 },
  { "Aracelly", 0.0 },
  { "Aracely", 0.0012671351 },
  { "Aracelys", 0.0 },
  { "Arad", 1.0 },
  { "Aradhana", 0.0 },
  { "Aradhya", 0.031446543 },
  { "Aradia", 0.0 },
  { "Arael", 1.0 },
  { "Araelynn", 0.0 },
  { "Araeya", 0.0 },
  { "Araf", 1.0 },
  { "Arafat", 1.0 },
  { "Aragon", 1.0 },
  { "Aragorn", 1.0 },
  { "Arah", 0.0 },
  { "Arahbella", 0.0 },
  { "Arahi", 0.0 },
  { "Arai", 0.0 },
  { "Araia", 0.0 },
  { "Araiah", 0.0 },
  { "Araina", 0.0 },
  { "Arainna", 0.0 },
  { "Araiya", 0.0 },
  { "Araiyah", 0.0 },
  { "Araiza", 0.0 },
  { "Aralee", 0.0 },
  { "Arali", 0.0 },
  { "Aralia", 0.0 },
  { "Aralin", 0.0 },
  { "Aralis", 0.0 },
  { "Araly", 0.0 },
  { "Aralyn", 0.0 },
  { "Aralynn", 0.0 },
  { "Aralynne", 0.0 },
  { "Aram", 0.9852427 },
  { "Arame", 0.0 },
  { "Arami", 0.0 },
  { "Aramie", 0.0 },
  { "Araminta", 0.0 },
  { "Aramis", 0.91217566 },
  { "Aramus", 1.0 },
  { "Aramys", 1.0 },
  { "Aran", 0.962963 },
  { "Aranda", 0.0 },
  { "Aransa", 0.0 },
  { "Arantxa", 0.0 },
  { "Arantza", 0.0 },
  { "Aranxa", 0.0 },
  { "Aranya", 0.0 },
  { "Aranza", 0.0 },
  { "Aranzazu", 0.0 },
  { "Araoluwa", 0.0 },
  { "Aras", 1.0 },
  { "Arasele", 0.0 },
  { "Araseli", 0.0 },
  { "Arasely", 0.0 },
  { "Arash", 1.0 },
  { "Arashdeep", 1.0 },
  { "Arashel", 0.0 },
  { "Arata", 1.0 },
  { "Arath", 1.0 },
  { "Arathi", 0.0 },
  { "Arati", 0.0 },
  { "Arav", 1.0 },
  { "Aravella", 0.0 },
  { "Aravind", 1.0 },
  { "Aravis", 0.0 },
  { "Arawyn", 0.0 },
  { "Arax", 0.0 },
  { "Araxi", 0.0 },
  { "Araya", 0.0022935779 },
  { "Arayah", 0.0 },
  { "Arayana", 0.0 },
  { "Arayeli", 0.0 },
  { "Arayia", 0.0 },
  { "Arayiah", 0.0 },
  { "Arayla", 0.0 },
  { "Araylia", 0.0 },
  { "Arayna", 0.0 },
  { "Araz", 1.0 },
  { "Arazeli", 0.0 },
  { "Arba", 0.74603176 },
  { "Arbaaz", 1.0 },
  { "Arbadella", 0.0 },
  { "Arbay", 0.0 },
  { "Arbaz", 1.0 },
  { "Arbedella", 0.0 },
  { "Arbelia", 0.0 },
  { "Arbell", 0.0 },
  { "Arbella", 0.0 },
  { "Arbelle", 0.0 },
  { "Arben", 1.0 },
  { "Arber", 1.0 },
  { "Arbi", 1.0 },
  { "Arbie", 0.78923076 },
  { "Arbin", 1.0 },
  { "Arbon", 1.0 },
  { "Arbor", 0.21428572 },
  { "Arbra", 0.0 },
  { "Arbri", 0.0 },
  { "Arbrianna", 0.0 },
  { "Arbrielle", 0.0 },
  { "Arbutis", 0.0 },
  { "Arbutus", 0.0 },
  { "Arby", 1.0 },
  { "Arcadia", 0.0 },
  { "Arcadian", 1.0 },
  { "Arcadio", 1.0 },
  { "Arcadius", 1.0 },
  { "Arcangel", 1.0 },
  { "Arcangela", 0.0 },
  { "Arcangelo", 1.0 },
  { "Arcel", 1.0 },
  { "Arceli", 0.0 },
  { "Arcelia", 0.0 },
  { "Arcella", 0.0 },
  { "Arcely", 0.0 },
  { "Arcenia", 0.0 },
  { "Arcenio", 1.0 },
  { "Arch", 1.0 },
  { "Archa", 1.0 },
  { "Archan", 1.0 },
  { "Archana", 0.0 },
  { "Archelle", 0.0 },
  { "Archer", 0.98401064 },
  { "Archi", 0.0 },
  { "Archibald", 1.0 },
  { "Archie", 0.97547865 },
  { "Archiebald", 1.0 },
  { "Archille", 1.0 },
  { "Archimedes", 1.0 },
  { "Archisha", 0.0 },
  { "Archit", 1.0 },
  { "Archita", 0.0 },
  { "Archith", 1.0 },
  { "Architha", 0.0 },
  { "Archivaldo", 1.0 },
  { "Arcie", 0.24285714 },
  { "Arcilia", 0.0 },
  { "Arco", 1.0 },
  { "Arcola", 0.0 },
  { "Arcus", 1.0 },
  { "Arda", 0.5414365 },
  { "Ardala", 0.0 },
  { "Ardalia", 0.0 },
  { "Ardan", 1.0 },
  { "Ardarius", 1.0 },
  { "Ardath", 0.016320474 },
  { "Ardean", 0.37 },
  { "Ardeen", 0.0 },
  { "Ardel", 0.2421875 },
  { "Ardele", 0.0 },
  { "Ardelia", 0.0 },
  { "Ardell", 0.4778042 },
  { "Ardella", 0.0 },
  { "Ardelle", 0.0 },
  { "Arden", 0.57024455 },
  { "Ardena", 0.0 },
  { "Ardene", 0.0 },
  { "Ardenia", 0.0 },
  { "Ardes", 0.0 },
  { "Ardeth", 0.0 },
  { "Ardi", 1.0 },
  { "Ardia", 0.0 },
  { "Ardian", 1.0 },
  { "Ardiana", 0.0 },
  { "Ardice", 0.0 },
  { "Ardie", 0.4764977 },
  { "Ardilia", 0.0 },
  { "Ardin", 1.0 },
  { "Ardina", 0.0 },
  { "Ardine", 0.03846154 },
  { "Ardis", 0.13853224 },
  { "Ardit", 1.0 },
  { "Ardita", 0.0 },
  { "Ardith", 0.022934174 },
  { "Ardon", 1.0 },
  { "Ardonia", 0.0 },
  { "Ardoth", 0.0 },
  { "Ardra", 0.0 },
  { "Ardriana", 0.0 },
  { "Ardus", 0.0 },
  { "Ardwin", 1.0 },
  { "Ardy", 0.0 },
  { "Ardyce", 0.0 },
  { "Ardyn", 0.0 },
  { "Ardynn", 0.0 },
  { "Ardys", 0.0052137645 },
  { "Ardyth", 0.0 },
  { "Ardythe", 0.0 },
  { "Areah", 0.0 },
  { "Areal", 0.0 },
  { "Arean", 1.0 },
  { "Areana", 0.0 },
  { "Areanna", 0.0 },
  { "Areatha", 0.0 },
  { "Areather", 0.0 },
  { "Arec", 1.0 },
  { "Ared", 1.0 },
  { "Aree", 0.12195122 },
  { "Areeb", 1.0 },
  { "Areeba", 0.0 },
  { "Areebah", 0.0 },
  { "Areecia", 0.0 },
  { "Areeg", 0.0 },
  { "Areej", 0.0 },
  { "Areen", 0.036231883 },
  { "Areena", 0.0 },
  { "Areesha", 0.0 },
  { "Areeya", 0.0 },
  { "Aref", 1.0 },
  { "Areg", 1.0 },
  { "Areia", 0.0 },
  { "Areial", 0.0 },
  { "Areiana", 0.0 },
  { "Areianna", 0.0 },
  { "Areigha", 0.0 },
  { "Areil", 0.0 },
  { "Areille", 0.0 },
  { "Areion", 0.1388889 },
  { "Areiona", 0.0 },
  { "Areionna", 0.0 },
  { "Areisy", 0.0 },
  { "Arek", 1.0 },
  { "Arel", 0.9708738 },
  { "Arela", 0.0 },
  { "Arelene", 0.0 },
  { "Areli", 0.01306004 },
  { "Arelia", 0.0 },
  { "Arelie", 0.0 },
  { "Arelin", 0.0 },
  { "Arelis", 0.0 },
  { "Areliz", 0.0 },
  { "Arella", 0.0 },
  { "Arelle", 0.0 },
  { "Arelli", 0.0 },
  { "Arelly", 0.0 },
  { "Arellys", 0.0 },
  { "Arely", 0.0 },
  { "Arelyn", 0.0 },
  { "Arelys", 0.0 },
  { "Aremi", 0.0 },
  { "Aremy", 0.0 },
  { "Aren", 0.8324051 },
  { "Arena", 0.0 },
  { "Arend", 1.0 },
  { "Arenda", 0.0 },
  { "Arene", 0.0 },
  { "Areni", 0.0 },
  { "Areon", 0.6456693 },
  { "Areona", 0.0 },
  { "Areonia", 0.0 },
  { "Areonna", 0.0 },
  { "Ares", 0.9732669 },
  { "Aresenio", 1.0 },
  { "Aresha", 0.0 },
  { "Areta", 0.0 },
  { "Aretha", 0.0 },
  { "Arethea", 0.0 },
  { "Arether", 0.0 },
  { "Arethia", 0.0 },
  { "Areti", 0.0 },
  { "Aretina", 0.0 },
  { "Aretta", 0.0 },
  { "Aretzi", 0.0 },
  { "Aretzy", 0.0 },
  { "Arey", 0.0 },
  { "Areya", 0.0 },
  { "Areyah", 0.0 },
  { "Areyana", 0.0 },
  { "Areyanna", 0.0 },
  { "Areyon", 0.3125 },
  { "Areyona", 0.0 },
  { "Areyonna", 0.0 },
  { "Arezo", 0.0 },
  { "Arfa", 0.0 },
  { "Arfaan", 1.0 },
  { "Arfan", 1.0 },
  { "Argatha", 0.0 },
  { "Argel", 1.0 },
  { "Argelia", 0.0 },
  { "Argelio", 1.0 },
  { "Argelis", 0.8780488 },
  { "Argene", 1.0 },
  { "Argenis", 1.0 },
  { "Argeniz", 1.0 },
  { "Argent", 0.0 },
  { "Argentina", 0.0 },
  { "Argentine", 0.0 },
  { "Argenys", 1.0 },
  { "Argie", 0.12977777 },
  { "Argil", 1.0 },
  { "Argiro", 0.0 },
  { "Argle", 1.0 },
  { "Argo", 1.0 },
  { "Argonne", 1.0 },
  { "Argus", 1.0 },
  { "Argusta", 0.2736842 },
  { "Arguster", 0.52380955 },
  { "Argyl", 1.0 },
  { "Argyle", 0.8309859 },
  { "Argyro", 0.0 },
  { "Arha", 1.0 },
  { "Arhaam", 1.0 },
  { "Arhaan", 1.0 },
  { "Arham", 1.0 },
  { "Arhan", 1.0 },
  { "Arhant", 1.0 },
  { "Arhea", 0.0 },
  { "Arhiana", 0.0 },
  { "Arhianna", 0.0 },
  { "Arhonda", 0.0 },
  { "Arhtur", 1.0 },
  { "Arhum", 1.0 },
  { "Ari", 0.8253306 },
  { "Aria", 0.013680625 },
  { "Ariaa", 0.0 },
  { "Ariaan", 1.0 },
  { "Ariabella", 0.0 },
  { "Ariadna", 0.0 },
  { "Ariadne", 0.0 },
  { "Ariadnna", 0.0 },
  { "Ariadnne", 0.0 },
  { "Ariadny", 0.0 },
  { "Ariagna", 0.0 },
  { "Ariah", 0.00702439 },
  { "Ariaha", 0.0 },
  { "Ariahana", 0.0 },
  { "Ariahna", 0.0 },
  { "Ariahnna", 0.0 },
  { "Ariajade", 0.0 },
  { "Arial", 0.0 },
  { "Ariale", 0.0 },
  { "Arialle", 0.0 },
  { "Arialynn", 0.0 },
  { "Ariam", 0.06563707 },
  { "Ariamarie", 0.0 },
  { "Arian", 0.75865066 },
  { "Ariana", 0.0019448106 },
  { "Arianah", 0.0 },
  { "Arianamarie", 0.0 },
  { "Arianda", 0.0 },
  { "Ariane", 0.0014216662 },
  { "Ariani", 0.0 },
  { "Arianie", 0.0 },
  { "Arianis", 0.0 },
  { "Ariann", 0.014117647 },
  { "Arianna", 0.00084766716 },
  { "Ariannah", 0.0 },
  { "Arianne", 0.0 },
  { "Arianni", 0.0 },
  { "Ariannie", 0.0 },
  { "Arianny", 0.0 },
  { "Ariano", 1.0 },
  { "Ariany", 0.0 },
  { "Arianys", 0.0 },
  { "Ariarose", 0.0 },
  { "Arias", 0.8209607 },
  { "Ariat", 1.0 },
  { "Ariatna", 0.0 },
  { "Ariauna", 0.0 },
  { "Ariaunna", 0.0 },
  { "Ariaya", 0.0 },
  { "Ariayah", 0.0 },
  { "Arib", 1.0 },
  { "Ariba", 0.0 },
  { "Aribah", 0.0 },
  { "Aribel", 0.0 },
  { "Aribella", 0.0 },
  { "Aribelle", 0.0 },
  { "Aribeth", 0.0 },
  { "Aric", 0.9993146 },
  { "Arica", 0.0 },
  { "Aricca", 0.0 },
  { "Aricel", 0.0 },
  { "Aricela", 0.0 },
  { "Ariceli", 0.0 },
  { "Aricella", 0.0 },
  { "Aricely", 0.0 },
  { "Aricia", 0.0 },
  { "Aricin", 1.0 },
  { "Arick", 1.0 },
  { "Aricka", 0.0 },
  { "Aridai", 0.0 },
  { "Ariday", 0.0 },
  { "Arie", 0.39030766 },
  { "Ariea", 0.0 },
  { "Arieah", 0.0 },
  { "Arieal", 0.0 },
  { "Arieana", 0.0 },
  { "Arieanna", 0.0 },
  { "Ariebella", 0.0 },
  { "Ariee", 0.0 },
  { "Arieh", 1.0 },
  { "Ariel", 0.20655094 },
  { "Ariela", 0.0 },
  { "Arielah", 0.0 },
  { "Ariele", 0.0 },
  { "Arieli", 0.0 },
  { "Arielis", 0.0 },
  { "Arieliz", 0.0 },
  { "Ariell", 0.00622665 },
  { "Ariella", 0.0 },
  { "Ariellah", 0.0 },
  { "Arielle", 0.001712622 },
  { "Arielly", 0.0 },
  { "Arielmarie", 0.0 },
  { "Ariely", 0.0 },
  { "Arielyn", 0.0 },
  { "Arielys", 0.0 },
  { "Arielyz", 0.0 },
  { "Arien", 0.55444443 },
  { "Ariena", 0.0 },
  { "Ariene", 0.0 },
  { "Arienette", 0.0 },
  { "Arienna", 0.0 },
  { "Arienne", 0.0 },
  { "Arieon", 0.6047904 },
  { "Arieona", 0.0 },
  { "Arieonna", 0.0 },
  { "Aries", 0.5971884 },
  { "Arieta", 0.0 },
  { "Arietta", 0.0 },
  { "Arieus", 1.0 },
  { "Arieya", 0.0 },
  { "Arieyana", 0.0 },
  { "Arieyanna", 0.0 },
  { "Arieyonna", 0.0 },
  { "Ariez", 0.94186044 },
  { "Arif", 1.0 },
  { "Arifa", 0.0 },
  { "Ariha", 0.0 },
  { "Arihaan", 1.0 },
  { "Arihan", 1.0 },
  { "Arihana", 0.0 },
  { "Arihanna", 0.0 },
  { "Arihant", 1.0 },
  { "Arii", 0.0 },
  { "Ariiana", 0.0 },
  { "Arij", 0.0 },
  { "Arijah", 0.0 },
  { "Arijana", 0.0 },
  { "Arijit", 1.0 },
  { "Arik", 1.0 },
  { "Arika", 0.0 },
  { "Arikah", 0.0 },
  { "Arikka", 0.0 },
  { "Aril", 0.0 },
  { "Arilene", 0.0 },
  { "Arilla", 0.0 },
  { "Arillia", 0.0 },
  { "Arilyn", 0.0 },
  { "Arilynn", 0.0 },
  { "Arim", 0.0 },
  { "Arimentha", 0.0 },
  { "Arin", 0.4061866 },
  { "Arina", 0.0 },
  { "Arinda", 0.0 },
  { "Arine", 0.0 },
  { "Arinjay", 1.0 },
  { "Arinn", 0.0 },
  { "Arinna", 0.0 },
  { "Arinola", 0.0 },
  { "Arinze", 1.0 },
  { "Arinzechukwu", 1.0 },
  { "Ario", 1.0 },
  { "Arion", 0.73646533 },
  { "Ariona", 0.0 },
  { "Arionah", 0.0 },
  { "Arione", 0.0 },
  { "Arionna", 0.0 },
  { "Arionne", 0.0 },
  { "Ariq", 1.0 },
  { "Aris", 0.6 },
  { "Arisa", 0.0 },
  { "Arisai", 0.0 },
  { "Arisbel", 0.0 },
  { "Arisbet", 0.0 },
  { "Arisbeth", 0.0 },
  { "Arisdelsy", 0.0 },
  { "Arisela", 0.0 },
  { "Arish", 1.0 },
  { "Arisha", 0.0 },
  { "Arishka", 0.0 },
  { "Arisleidy", 0.0 },
  { "Arismel", 0.0 },
  { "Arismendy", 1.0 },
  { "Arison", 1.0 },
  { "Ariss", 0.0 },
  { "Arissa", 0.0 },
  { "Arista", 0.0 },
  { "Aristea", 0.0 },
  { "Aristede", 1.0 },
  { "Aristedes", 1.0 },
  { "Aristeo", 1.0 },
  { "Aristide", 1.0 },
  { "Aristides", 1.0 },
  { "Aristidis", 1.0 },
  { "Ariston", 1.0 },
  { "Aristotelis", 1.0 },
  { "Aristotle", 1.0 },
  { "Arit", 0.0 },
  { "Arita", 0.0 },
  { "Aritha", 0.0 },
  { "Aritra", 1.0 },
  { "Aritza", 0.0 },
  { "Aritzel", 0.0 },
  { "Aritzi", 0.0 },
  { "Aritzy", 0.0 },
  { "Ariunna", 0.0 },
  { "Arius", 0.9357798 },
  { "Ariv", 1.0 },
  { "Ariya", 0.0115074795 },
  { "Ariyah", 0.0 },
  { "Ariyahna", 0.0 },
  { "Ariyal", 0.0 },
  { "Ariyan", 0.44339624 },
  { "Ariyana", 0.0 },
  { "Ariyanah", 0.0 },
  { "Ariyani", 0.0 },
  { "Ariyanna", 0.0 },
  { "Ariyannah", 0.0 },
  { "Ariyauna", 0.0 },
  { "Ariyeh", 1.0 },
  { "Ariyel", 0.0 },
  { "Ariyella", 0.0 },
  { "Ariyelle", 0.0 },
  { "Ariyha", 0.0 },
  { "Ariyiah", 0.0 },
  { "Ariyon", 0.34765625 },
  { "Ariyona", 0.0 },
  { "Ariyonna", 0.0 },
  { "Ariyunna", 0.0 },
  { "Ariz", 1.0 },
  { "Ariza", 0.0 },
  { "Arizbeth", 0.0 },
  { "Arizel", 0.0 },
  { "Arizona", 0.04384944 },
  { "Arizonia", 0.0 },
  { "Arjae", 1.0 },
  { "Arjan", 1.0 },
  { "Arjanae", 0.0 },
  { "Arjav", 1.0 },
  { "Arjay", 1.0 },
  { "Arjean", 0.0 },
  { "Arjen", 1.0 },
  { "Arjenis", 1.0 },
  { "Arjeta", 0.0 },
  { "Arjit", 1.0 },
  { "Arjun", 1.0 },
  { "Arjuna", 1.0 },
  { "Ark", 1.0 },
  { "Arka", 1.0 },
  { "Arkadia", 0.0 },
  { "Arkadian", 1.0 },
  { "Arkadiusz", 1.0 },
  { "Arkady", 1.0 },
  { "Arkan", 1.0 },
  { "Arkangel", 1.0 },
  { "Arkayla", 0.0 },
  { "Arkeba", 0.0 },
  { "Arkee", 1.0 },
  { "Arkeem", 1.0 },
  { "Arkeen", 1.0 },
  { "Arkeisha", 0.0 },
  { "Arkeith", 1.0 },
  { "Arkel", 1.0 },
  { "Arkell", 1.0 },
  { "Arkeria", 0.0 },
  { "Arkesha", 0.0 },
  { "Arkeshia", 0.0 },
  { "Arkham", 1.0 },
  { "Arkia", 0.0 },
  { "Arkie", 0.16818182 },
  { "Arkim", 1.0 },
  { "Arkin", 1.0 },
  { "Arkisha", 0.0 },
  { "Arkita", 0.0 },
  { "Arkley", 1.0 },
  { "Arko", 1.0 },
  { "Arkyn", 1.0 },
  { "Arl", 1.0 },
  { "Arla", 0.0065109152 },
  { "Arlaina", 0.0 },
  { "Arlaine", 0.0 },
  { "Arlan", 1.0 },
  { "Arlana", 0.0 },
  { "Arland", 0.99714124 },
  { "Arlanda", 0.27173913 },
  { "Arlander", 1.0 },
  { "Arlandis", 1.0 },
  { "Arlando", 1.0 },
  { "Arlandria", 0.0 },
  { "Arlandus", 1.0 },
  { "Arlane", 0.0 },
  { "Arlayne", 0.0 },
  { "Arlea", 0.0 },
  { "Arlean", 0.0 },
  { "Arleane", 0.0 },
  { "Arleaner", 0.0 },
  { "Arlease", 0.0 },
  { "Arleatha", 0.0 },
  { "Arlecia", 0.0 },
  { "Arleda", 0.0 },
  { "Arlee", 0.30718476 },
  { "Arleen", 0.00048899755 },
  { "Arleena", 0.0 },
  { "Arleene", 0.0 },
  { "Arleeta", 0.0 },
  { "Arleht", 0.0 },
  { "Arleigh", 0.5367965 },
  { "Arlein", 0.0 },
  { "Arleine", 0.0 },
  { "Arlen", 0.91309756 },
  { "Arlena", 0.0 },
  { "Arlene", 0.0025449228 },
  { "Arlener", 0.0 },
  { "Arleni", 0.0 },
  { "Arlenis", 0.0 },
  { "Arlenne", 0.0 },
  { "Arleny", 0.0 },
  { "Arlenys", 0.0 },
  { "Arleon", 0.0 },
  { "Arles", 0.9701493 },
  { "Arlesa", 0.0 },
  { "Arlesha", 0.0 },
  { "Arlesia", 0.0 },
  { "Arless", 0.9285714 },
  { "Arlester", 1.0 },
  { "Arlet", 0.005165289 },
  { "Arleta", 0.0 },
  { "Arlete", 0.0 },
  { "Arleth", 0.0 },
  { "Arletha", 0.0 },
  { "Arlethe", 0.0 },
  { "Arlethea", 0.0 },
  { "Arlether", 0.0 },
  { "Arlethia", 0.0 },
  { "Arlett", 0.0 },
  { "Arletta", 0.0 },
  { "Arlette", 0.0 },
  { "Arlevia", 0.0 },
  { "Arlex", 1.0 },
  { "Arley", 0.834814 },
  { "Arli", 0.0 },
  { "Arliana", 0.0 },
  { "Arlice", 0.63414633 },
  { "Arlicia", 0.0 },
  { "Arlie", 0.75399286 },
  { "Arlien", 0.0 },
  { "Arliene", 0.0 },
  { "Arlillian", 0.0 },
  { "Arlin", 0.8433762 },
  { "Arlina", 0.0 },
  { "Arlind", 1.0 },
  { "Arlinda", 0.0 },
  { "Arline", 0.0020470829 },
  { "Arling", 1.0 },
  { "Arlington", 0.97343326 },
  { "Arlis", 0.69649655 },
  { "Arlisa", 0.0 },
  { "Arlisha", 0.0 },
  { "Arliss", 0.4157549 },
  { "Arlissa", 0.0 },
  { "Arlita", 0.0 },
  { "Arliz", 0.0 },
  { "Arlo", 0.9772787 },
  { "Arloa", 0.0 },
  { "Arloene", 0.0 },
  { "Arloine", 0.0 },
  { "Arlon", 1.0 },
  { "Arlonda", 0.0 },
  { "Arlondo", 1.0 },
  { "Arlone", 0.0 },
  { "Arlos", 1.0 },
  { "Arlow", 0.9084507 },
  { "Arlowe", 0.0 },
  { "Arloween", 0.0 },
  { "Arlowene", 0.0 },
  { "Arlton", 1.0 },
  { "Arlus", 1.0 },
  { "Arly", 0.06521739 },
  { "Arlyce", 0.0 },
  { "Arlyle", 0.0 },
  { "Arlyn", 0.51101756 },
  { "Arlynda", 0.0 },
  { "Arlyne", 0.0 },
  { "Arlynes", 0.0 },
  { "Arlynn", 0.12248996 },
  { "Arlynne", 0.0 },
  { "Arlys", 0.0 },
  { "Arlyss", 0.0 },
  { "Arlyssa", 0.0 },
  { "Arma", 0.0 },
  { "Armaad", 1.0 },
  { "Armaan", 1.0 },
  { "Armad", 1.0 },
  { "Armahn", 1.0 },
  { "Armahni", 0.25 },
  { "Arman", 1.0 },
  { "Armana", 0.0 },
  { "Armand", 0.99960047 },
  { "Armanda", 0.0 },
  { "Armande", 0.0 },
  { "Armandina", 0.0 },
  { "Armando", 0.994894 },
  { "Armanee", 0.0 },
  { "Armani", 0.5600205 },
  { "Armanie", 0.297561 },
  { "Armanii", 0.3283582 },
  { "Armann", 1.0 },
  { "Armanni", 0.75 },
  { "Armante", 1.0 },
  { "Armanti", 1.0 },
  { "Armany", 1.0 },
  { "Armar", 1.0 },
  { "Armard", 1.0 },
  { "Armari", 0.6953125 },
  { "Armarion", 1.0 },
  { "Armas", 1.0 },
  { "Armatha", 0.0 },
  { "Armaun", 1.0 },
  { "Armeda", 0.0 },
  { "Armeen", 0.90384614 },
  { "Armel", 1.0 },
  { "Armelda", 0.0 },
  { "Armelia", 0.0 },
  { "Armelinda", 0.0 },
  { "Armella", 0.0 },
  { "Armelle", 0.0 },
  { "Armen", 0.99730605 },
  { "Armena", 0.0 },
  { "Armend", 1.0 },
  { "Armenda", 0.0 },
  { "Armenia", 0.0 },
  { "Armenta", 0.0 },
  { "Armentha", 0.0 },
  { "Armer", 0.27272728 },
  { "Armesha", 0.0 },
  { "Armeta", 0.0 },
  { "Armetha", 0.0 },
  { "Armetrice", 0.0 },
  { "Armetta", 0.0 },
  { "Armiah", 0.0 },
  { "Armida", 0.0 },
  { "Armie", 0.0 },
  { "Armilda", 0.0 },
  { "Armilla", 0.0 },
  { "Armin", 1.0 },
  { "Armina", 0.0 },
  { "Arminda", 0.0 },
  { "Armine", 0.0 },
  { "Arminta", 0.0 },
  { "Armintha", 0.0 },
  { "Armir", 1.0 },
  { "Armisha", 0.0 },
  { "Armistead", 1.0 },
  { "Armistice", 0.52380955 },
  { "Armita", 0.0 },
  { "Armittie", 0.0 },
  { "Armiya", 0.0 },
  { "Armiyah", 0.0 },
  { "Armod", 1.0 },
  { "Armon", 1.0 },
  { "Armond", 1.0 },
  { "Armondo", 1.0 },
  { "Armone", 0.84126985 },
  { "Armonee", 0.075 },
  { "Armoney", 0.0 },
  { "Armoni", 0.37953487 },
  { "Armonie", 0.2557143 },
  { "Armonii", 0.0 },
  { "Armonni", 0.0 },
  { "Armonnie", 0.0 },
  { "Armonta", 1.0 },
  { "Armontae", 1.0 },
  { "Armonte", 1.0 },
  { "Armony", 0.0 },
  { "Armor", 1.0 },
  { "Armour", 1.0 },
  { "Armstead", 1.0 },
  { "Armster", 1.0 },
  { "Armstrong", 1.0 },
  { "Army", 0.0 },
  { "Armya", 0.0 },
  { "Arn", 1.0 },
  { "Arna", 0.0 },
  { "Arnab", 1.0 },
  { "Arnae", 0.0 },
  { "Arnald", 1.0 },
  { "Arnaldo", 1.0 },
  { "Arnardo", 1.0 },
  { "Arnasia", 0.0 },
  { "Arnaud", 1.0 },
  { "Arnav", 1.0 },
  { "Arnavi", 0.0 },
  { "Arnay", 1.0 },
  { "Arnaz", 1.0 },
  { "Arne", 1.0 },
  { "Arnecia", 0.0 },
  { "Arneda", 0.0 },
  { "Arnedra", 0.0 },
  { "Arnee", 0.0 },
  { "Arneice", 0.0 },
  { "Arneisha", 0.0 },
  { "Arneita", 0.0 },
  { "Arnel", 0.9730061 },
  { "Arnela", 0.0 },
  { "Arnelda", 0.0 },
  { "Arnelia", 0.0 },
  { "Arnell", 0.6093137 },
  { "Arnella", 0.0 },
  { "Arnelle", 0.0 },
  { "Arner", 1.0 },
  { "Arnes", 1.0 },
  { "Arnesh", 1.0 },
  { "Arnesha", 0.0 },
  { "Arneshia", 0.0 },
  { "Arnesia", 0.0 },
  { "Arness", 1.0 },
  { "Arnessa", 0.0 },
  { "Arnesto", 1.0 },
  { "Arnet", 1.0 },
  { "Arneta", 0.0 },
  { "Arnetha", 0.0 },
  { "Arnetia", 0.0 },
  { "Arnetra", 0.0 },
  { "Arnetria", 0.0 },
  { "Arnett", 0.9453751 },
  { "Arnetta", 0.0 },
  { "Arnette", 0.030330881 },
  { "Arnettie", 0.0 },
  { "Arney", 1.0 },
  { "Arnez", 0.9896907 },
  { "Arni", 0.0 },
  { "Arnica", 0.0 },
  { "Arnice", 0.0 },
  { "Arnie", 0.89546263 },
  { "Arniece", 0.0 },
  { "Arniesha", 0.0 },
  { "Arnika", 0.0 },
  { "Arnim", 1.0 },
  { "Arnis", 1.0 },
  { "Arnise", 0.0 },
  { "Arnisha", 0.0 },
  { "Arnissa", 0.0 },
  { "Arnit", 1.0 },
  { "Arnita", 0.0 },
  { "Arnitha", 0.0 },
  { "Arnitra", 0.0 },
  { "Arniya", 0.0 },
  { "Arniyah", 0.0 },
  { "Arno", 1.0 },
  { "Arnob", 1.0 },
  { "Arnol", 1.0 },
  { "Arnola", 0.0 },
  { "Arnold", 0.9946808 },
  { "Arnoldo", 1.0 },
  { "Arnolfo", 1.0 },
  { "Arnon", 1.0 },
  { "Arnt", 1.0 },
  { "Arnulfo", 1.0 },
  { "Arny", 1.0 },
  { "Aro", 1.0 },
  { "Aroara", 0.0 },
  { "Aroha", 0.0 },
  { "Arohan", 1.0 },
  { "Arohi", 0.0 },
  { "Arol", 1.0 },
  { "Arold", 1.0 },
  { "Aroldo", 1.0 },
  { "Arolyn", 0.0 },
  { "Aron", 0.9808429 },
  { "Arona", 0.2857143 },
  { "Aronda", 0.0 },
  { "Aronde", 1.0 },
  { "Arooj", 0.0 },
  { "Aroon", 1.0 },
  { "Aroosa", 0.0 },
  { "Aroosh", 0.14705883 },
  { "Arora", 0.0 },
  { "Aroura", 0.0 },
  { "Aroush", 0.0 },
  { "Arowyn", 0.0 },
  { "Aroya", 0.0 },
  { "Aroyal", 1.0 },
  { "Arpa", 0.0 },
  { "Arpad", 1.0 },
  { "Arpan", 0.9766355 },
  { "Arpi", 0.0 },
  { "Arpie", 0.0 },
  { "Arpil", 0.0 },
  { "Arpine", 0.0 },
  { "Arpit", 1.0 },
  { "Arpita", 0.0 },
  { "Arquan", 1.0 },
  { "Arquilla", 0.0 },
  { "Arquimedes", 1.0 },
  { "Arquimides", 1.0 },
  { "Arquita", 0.0 },
  { "Arra", 0.0 },
  { "Arrabella", 0.0 },
  { "Arrabelle", 0.0 },
  { "Arrah", 0.0 },
  { "Arran", 1.0 },
  { "Arraya", 0.0 },
  { "Arrayah", 0.0 },
  { "Arreana", 0.0 },
  { "Arreanna", 0.0 },
  { "Arren", 0.9315961 },
  { "Arrena", 0.0 },
  { "Arreon", 0.4 },
  { "Arreona", 0.0 },
  { "Arreonna", 0.0 },
  { "Arretta", 0.0 },
  { "Arri", 0.4651163 },
  { "Arria", 0.0 },
  { "Arriah", 0.0 },
  { "Arrian", 0.7941176 },
  { "Arriana", 0.0 },
  { "Arriane", 0.0 },
  { "Arrianna", 0.0 },
  { "Arriannah", 0.0 },
  { "Arrianne", 0.0 },
  { "Arric", 1.0 },
  { "Arrica", 0.0 },
  { "Arrick", 1.0 },
  { "Arrie", 0.15234375 },
  { "Arrieanna", 0.0 },
  { "Arriel", 0.0 },
  { "Arriell", 0.0 },
  { "Arriella", 0.0 },
  { "Arrielle", 0.0 },
  { "Arrietta", 0.0 },
  { "Arrietty", 0.0 },
  { "Arrihanna", 0.0 },
  { "Arrik", 1.0 },
  { "Arrika", 0.0 },
  { "Arrilla", 0.0 },
  { "Arrin", 0.5828221 },
  { "Arrington", 0.7048666 },
  { "Arrion", 0.76488096 },
  { "Arriona", 0.0 },
  { "Arrionna", 0.0 },
  { "Arris", 1.0 },
  { "Arrissa", 0.0 },
  { "Arrius", 1.0 },
  { "Arriya", 0.0 },
  { "Arriyah", 0.0 },
  { "Arriyana", 0.0 },
  { "Arriyanah", 0.0 },
  { "Arriyanna", 0.0 },
  { "Arro", 1.0 },
  { "Arron", 0.97847456 },
  { "Arrow", 0.71105194 },
  { "Arry", 1.0 },
  { "Arrya", 0.0 },
  { "Arryana", 0.0 },
  { "Arryanna", 0.0 },
  { "Arryn", 0.1375 },
  { "Arryon", 0.0 },
  { "Arryonna", 0.0 },
  { "Arsal", 1.0 },
  { "Arsalaan", 1.0 },
  { "Arsalan", 1.0 },
  { "Arsam", 1.0 },
  { "Arsema", 0.0 },
  { "Arsen", 1.0 },
  { "Arsene", 1.0 },
  { "Arsenia", 0.0 },
  { "Arsenial", 1.0 },
  { "Arsenio", 1.0 },
  { "Arseniy", 1.0 },
  { "Arseno", 1.0 },
  { "Arseny", 1.0 },
  { "Arsh", 1.0 },
  { "Arsha", 0.23255815 },
  { "Arshaan", 1.0 },
  { "Arshad", 1.0 },
  { "Arshag", 1.0 },
  { "Arshan", 1.0 },
  { "Arshanti", 0.0 },
  { "Arshaun", 1.0 },
  { "Arshawn", 1.0 },
  { "Arshdeep", 0.8636364 },
  { "Arshi", 0.0 },
  { "Arshia", 0.25986078 },
  { "Arshika", 0.0 },
  { "Arshiya", 0.0 },
  { "Arshon", 1.0 },
  { "Arshveer", 1.0 },
  { "Arsie", 0.0 },
  { "Arslan", 1.0 },
  { "Arson", 1.0 },
  { "Arsula", 0.0 },
  { "Arsyn", 1.0 },
  { "Art", 0.9991518 },
  { "Arta", 0.011705685 },
  { "Artadius", 1.0 },
  { "Artan", 1.0 },
  { "Artasia", 0.0 },
  { "Artavia", 0.0 },
  { "Artavian", 1.0 },
  { "Artavion", 1.0 },
  { "Artavious", 1.0 },
  { "Artavis", 1.0 },
  { "Artavius", 1.0 },
  { "Artee", 0.7222222 },
  { "Arteen", 1.0 },
  { "Artelia", 0.0 },
  { "Artell", 0.5833333 },
  { "Artella", 0.0 },
  { "Artem", 1.0 },
  { "Artemas", 1.0 },
  { "Artemia", 0.0 },
  { "Artemio", 1.0 },
  { "Artemis", 0.13175675 },
  { "Artemisa", 0.0 },
  { "Artemisia", 0.0 },
  { "Artemiy", 1.0 },
  { "Artemus", 1.0 },
  { "Artemy", 1.0 },
  { "Artena", 0.0 },
  { "Artensia", 0.0 },
  { "Arter", 1.0 },
  { "Arteria", 0.0 },
  { "Artesha", 0.0 },
  { "Artesia", 0.0 },
  { "Artez", 1.0 },
  { "Arth", 1.0 },
  { "Artha", 0.17754173 },
  { "Arthalia", 0.0 },
  { "Arthar", 1.0 },
  { "Arthas", 1.0 },
  { "Arthea", 0.0 },
  { "Arthel", 1.0 },
  { "Arthelia", 0.0 },
  { "Arthell", 1.0 },
  { "Arthella", 0.0 },
  { "Arthemise", 0.0 },
  { "Arthena", 0.0 },
  { "Arthenia", 0.0 },
  { "Arther", 0.9906412 },
  { "Artherine", 0.0 },
  { "Arthetta", 0.0 },
  { "Arthi", 0.0 },
  { "Arthor", 1.0 },
  { "Arthur", 0.9939636 },
  { "Arthuree", 0.0 },
  { "Arthurene", 0.0 },
  { "Arthurine", 0.0 },
  { "Arthuro", 1.0 },
  { "Arthus", 1.0 },
  { "Arti", 0.03088803 },
  { "Artia", 0.0 },
  { "Artiana", 0.0 },
  { "Artice", 0.7037037 },
  { "Articia", 0.0 },
  { "Artie", 0.40362006 },
  { "Artimese", 0.0 },
  { "Artimus", 1.0 },
  { "Artin", 1.0 },
  { "Artina", 0.0 },
  { "Artis", 0.84607875 },
  { "Artisha", 0.0 },
  { "Artishia", 0.0 },
  { "Artist", 0.9744898 },
  { "Arto", 1.0 },
  { "Arton", 1.0 },
  { "Artorius", 1.0 },
  { "Artra", 0.0 },
  { "Artrell", 1.0 },
  { "Artresha", 0.0 },
  { "Artrice", 0.0 },
  { "Artricia", 0.0 },
  { "Artrina", 0.0 },
  { "Artur", 1.0 },
  { "Artura", 0.0 },
  { "Arturo", 0.99606246 },
  { "Arty", 1.0 },
  { "Artyom", 1.0 },
  { "Aruba", 0.0 },
  { "Arul", 1.0 },
  { "Arun", 1.0 },
  { "Aruna", 0.0 },
  { "Arunas", 1.0 },
  { "Arundhati", 0.0 },
  { "Arunima", 0.0 },
  { "Arush", 1.0 },
  { "Arusha", 0.0 },
  { "Arushi", 0.0 },
  { "Aruther", 1.0 },
  { "Aruthur", 1.0 },
  { "Arva", 0.0 },
  { "Arvada", 0.0 },
  { "Arval", 1.0 },
  { "Arvard", 1.0 },
  { "Arve", 1.0 },
  { "Arveda", 0.0 },
  { "Arveen", 0.0 },
  { "Arvel", 1.0 },
  { "Arvell", 1.0 },
  { "Arvella", 0.0 },
  { "Arvelle", 1.0 },
  { "Arven", 1.0 },
  { "Arvena", 0.0 },
  { "Arvene", 1.0 },
  { "Arvester", 1.0 },
  { "Arveta", 0.0 },
  { "Arvetta", 0.0 },
  { "Arvey", 1.0 },
  { "Arvi", 0.6666667 },
  { "Arvia", 0.0 },
  { "Arvid", 1.0 },
  { "Arvie", 0.63951933 },
  { "Arvil", 1.0 },
  { "Arvile", 1.0 },
  { "Arvill", 1.0 },
  { "Arvilla", 0.0 },
  { "Arville", 0.9856957 },
  { "Arvillia", 0.0 },
  { "Arvin", 1.0 },
  { "Arvina", 0.0 },
  { "Arvind", 1.0 },
  { "Arvine", 1.0 },
  { "Arvion", 1.0 },
  { "Arvis", 0.77283657 },
  { "Arvle", 1.0 },
  { "Arvo", 1.0 },
  { "Arvol", 1.0 },
  { "Arvon", 1.0 },
  { "Arvy", 1.0 },
  { "Arvydas", 1.0 },
  { "Arwa", 0.0 },
  { "Arwen", 0.0 },
  { "Arwilda", 0.0 },
  { "Arwilla", 0.0 },
  { "Arwin", 1.0 },
  { "Arwood", 1.0 },
  { "Arwyn", 0.0 },
  { "Arwynn", 0.0 },
  { "Ary", 0.46570972 },
  { "Arya", 0.17255083 },
  { "Aryaa", 0.0 },
  { "Aryaan", 1.0 },
  { "Aryadne", 0.0 },
  { "Aryah", 0.0 },
  { "Aryahi", 0.0 },
  { "Aryahna", 0.0 },
  { "Aryal", 0.0 },
  { "Aryam", 0.05703422 },
  { "Aryaman", 1.0 },
  { "Aryan", 0.9003734 },
  { "Aryana", 0.0 },
  { "Aryanah", 0.0 },
  { "Aryane", 0.0 },
  { "Aryani", 0.0 },
  { "Aryann", 0.0 },
  { "Aryanna", 0.0 },
  { "Aryannah", 0.0 },
  { "Aryanne", 0.0 },
  { "Aryanni", 0.0 },
  { "Aryash", 1.0 },
  { "Aryauna", 0.0 },
  { "Aryav", 1.0 },
  { "Aryaveer", 1.0 },
  { "Arybella", 0.0 },
  { "Arye", 1.0 },
  { "Aryeh", 0.9978485 },
  { "Aryel", 0.05 },
  { "Aryela", 0.0 },
  { "Aryell", 0.0 },
  { "Aryella", 0.0 },
  { "Aryelle", 0.0 },
  { "Aryen", 1.0 },
  { "Aryes", 1.0 },
  { "Aryhanna", 0.0 },
  { "Aryia", 0.0 },
  { "Aryiah", 0.0 },
  { "Aryian", 0.3939394 },
  { "Aryiana", 0.0 },
  { "Aryianna", 0.0 },
  { "Aryiel", 0.0 },
  { "Aryion", 1.0 },
  { "Aryk", 1.0 },
  { "Aryka", 0.0 },
  { "Arykah", 0.0 },
  { "Aryn", 0.12579282 },
  { "Arynn", 0.0 },
  { "Arynne", 0.0 },
  { "Aryo", 1.0 },
  { "Aryon", 0.7823129 },
  { "Aryona", 0.0 },
  { "Aryonna", 0.0 },
  { "Arys", 0.7222222 },
  { "Arysa", 0.0 },
  { "Aryss", 0.0 },
  { "Aryssa", 0.0 },
  { "Arysta", 0.0 },
  { "Aryton", 1.0 },
  { "Aryus", 1.0 },
  { "Arza", 1.0 },
  { "Arzel", 1.0 },
  { "Arzelia", 0.0 },
  { "Arzell", 0.9101124 },
  { "Arzella", 0.0 },
  { "Arzetta", 0.0 },
  { "Arzie", 1.0 },
  { "Arzilla", 0.0 },
  { "Arzjon", 1.0 },
  { "Arzo", 1.0 },
  { "Arzola", 0.0 },
  { "Arzona", 0.0 },
  { "Arzoo", 0.0 },
  { "Arzu", 0.0 },
  { "Asa", 0.9305827 },
  { "Asaad", 1.0 },
  { "Asaan", 1.0 },
  { "Asacia", 0.0 },
  { "Asad", 1.0 },
  { "Asada", 0.0 },
  { "Asadbek", 1.0 },
  { "Asadullah", 1.0 },
  { "Asae", 0.0 },
  { "Asael", 1.0 },
  { "Asaf", 1.0 },
  { "Asah", 1.0 },
  { "Asahel", 1.0 },
  { "Asahi", 1.0 },
  { "Asai", 1.0 },
  { "Asaiah", 0.86415094 },
  { "Asaiya", 0.0 },
  { "Asako", 0.0 },
  { "Asal", 0.0 },
  { "Asala", 0.0 },
  { "Asalah", 0.0 },
  { "Asalee", 0.0 },
  { "Asalia", 0.0 },
  { "Asami", 0.0 },
  { "Asan", 1.0 },
  { "Asana", 0.0 },
  { "Asani", 0.24545455 },
  { "Asantae", 1.0 },
  { "Asante", 0.8045574 },
  { "Asanti", 0.18390805 },
  { "Asao", 1.0 },
  { "Asaph", 1.0 },
  { "Asar", 1.0 },
  { "Asaria", 0.0 },
  { "Asasha", 0.0 },
  { "Asata", 0.0 },
  { "Asaun", 1.0 },
  { "Asauni", 0.0 },
  { "Asaya", 1.0 },
  { "Asayo", 0.0 },
  { "Asbel", 1.0 },
  { "Asberry", 1.0 },
  { "Asbery", 1.0 },
  { "Asbiel", 1.0 },
  { "Asbury", 1.0 },
  { "Ascencion", 0.84639496 },
  { "Ascension", 0.6388889 },
  { "Ascher", 1.0 },
  { "Aschley", 0.0 },
  { "Aschton", 1.0 },
  { "Asdrubal", 1.0 },
  { "Ase", 0.42857143 },
  { "Asean", 1.0 },
  { "Aseante", 1.0 },
  { "Aseda", 0.75 },
  { "Aseel", 0.113259666 },
  { "Aseelah", 0.0 },
  { "Aseem", 1.0 },
  { "Asees", 0.0 },
  { "Asela", 0.0 },
  { "Aselin", 0.0 },
  { "Asem", 1.0 },
  { "Asena", 0.0 },
  { "Asenat", 0.0 },
  { "Asenath", 0.0 },
  { "Asencion", 0.7755102 },
  { "Asenet", 0.0 },
  { "Aseneth", 0.0 },
  { "Asenith", 0.0 },
  { "Asension", 1.0 },
  { "Aser", 1.0 },
  { "Aseret", 0.0 },
  { "Aset", 0.0 },
  { "Asfia", 0.0 },
  { "Asfiya", 0.0 },
  { "Ash", 0.96544915 },
  { "Asha", 0.0042570173 },
  { "Ashaad", 1.0 },
  { "Ashaan", 1.0 },
  { "Ashad", 1.0 },
  { "Ashadieeyah", 0.0 },
  { "Ashae", 0.0 },
  { "Ashai", 0.5833333 },
  { "Ashaiya", 0.0 },
  { "Ashaki", 0.0 },
  { "Ashala", 0.0 },
  { "Ashalee", 0.0 },
  { "Ashaley", 0.0 },
  { "Ashalina", 0.0 },
  { "Ashalyn", 0.0 },
  { "Ashan", 1.0 },
  { "Ashana", 0.0 },
  { "Ashanae", 0.0 },
  { "Ashanda", 0.0 },
  { "Ashane", 0.0 },
  { "Ashanee", 0.0 },
  { "Ashani", 0.0 },
  { "Ashanique", 0.0 },
  { "Ashanna", 0.0 },
  { "Ashanni", 0.0 },
  { "Ashanta", 0.0099502485 },
  { "Ashantae", 0.0 },
  { "Ashantai", 0.0 },
  { "Ashantay", 0.0 },
  { "Ashante", 0.10604192 },
  { "Ashantee", 0.0 },
  { "Ashantey", 0.0 },
  { "Ashanti", 0.06229025 },
  { "Ashantia", 0.0 },
  { "Ashantiana", 0.0 },
  { "Ashantianna", 0.0 },
  { "Ashantie", 0.0 },
  { "Ashantii", 0.0 },
  { "Ashantis", 0.0 },
  { "Ashanty", 0.0 },
  { "Ashar", 1.0 },
  { "Ashara", 0.0 },
  { "Asharee", 0.0 },
  { "Ashari", 0.0 },
  { "Asharia", 0.0 },
  { "Ashariah", 0.0 },
  { "Asharie", 0.0 },
  { "Asharra", 0.0 },
  { "Asharri", 0.0 },
  { "Ashaud", 1.0 },
  { "Ashaun", 1.0 },
  { "Ashauna", 0.0 },
  { "Ashaunie", 0.0 },
  { "Ashaunta", 0.0 },
  { "Ashauntae", 0.0 },
  { "Ashaunte", 0.0 },
  { "Ashauntee", 0.0 },
  { "Ashaunti", 0.0 },
  { "Ashaureah", 0.0 },
  { "Ashauria", 0.0 },
  { "Ashawn", 1.0 },
  { "Ashawna", 0.0 },
  { "Ashawni", 0.0 },
  { "Ashawnti", 0.0 },
  { "Ashay", 0.46 },
  { "Ashaya", 0.0 },
  { "Ashayla", 0.0 },
  { "Ashaz", 1.0 },
  { "Ashburn", 1.0 },
  { "Ashby", 0.6995808 },
  { "Ashden", 0.94074076 },
  { "Ashdon", 1.0 },
  { "Ashdyn", 0.8378378 },
  { "Ashe", 0.72649574 },
  { "Ashea", 0.0 },
  { "Ashee", 0.0 },
  { "Asheena", 0.0 },
  { "Ashelee", 0.0 },
  { "Asheley", 0.0 },
  { "Asheli", 0.0 },
  { "Ashelle", 0.0 },
  { "Ashelly", 0.0 },
  { "Ashely", 0.010759299 },
  { "Ashelyn", 0.0 },
  { "Ashelynn", 0.0 },
  { "Asher", 0.9840991 },
  { "Ashera", 0.0 },
  { "Asherah", 0.0 },
  { "Asheton", 0.55932206 },
  { "Ashey", 0.0 },
  { "Ashford", 1.0 },
  { "Ashgan", 0.0 },
  { "Ashi", 0.0 },
  { "Ashia", 0.0 },
  { "Ashiah", 0.0 },
  { "Ashiana", 0.0 },
  { "Ashianna", 0.0 },
  { "Ashika", 0.0 },
  { "Ashilee", 0.0 },
  { "Ashiley", 0.0 },
  { "Ashim", 1.0 },
  { "Ashima", 0.0 },
  { "Ashini", 0.0 },
  { "Ashir", 1.0 },
  { "Ashira", 0.0 },
  { "Ashirah", 0.0 },
  { "Ashish", 1.0 },
  { "Ashita", 0.0 },
  { "Ashiya", 0.0 },
  { "Ashiyah", 0.0 },
  { "Ashja", 0.0 },
  { "Ashka", 0.0 },
  { "Ashkan", 1.0 },
  { "Ashkii", 1.0 },
  { "Ashkon", 1.0 },
  { "Ashla", 0.0 },
  { "Ashlae", 0.0 },
  { "Ashlan", 0.038647342 },
  { "Ashland", 0.16912752 },
  { "Ashlay", 0.0 },
  { "Ashle", 0.0 },
  { "Ashlea", 0.0 },
  { "Ashleah", 0.0 },
  { "Ashlee", 0.005950322 },
  { "Ashleeann", 0.0 },
  { "Ashleen", 0.0 },
  { "Ashleey", 0.0 },
  { "Ashleh", 0.0 },
  { "Ashlei", 0.0 },
  { "Ashleigh", 0.0026262498 },
  { "Ashlely", 0.0 },
  { "Ashlen", 0.012782694 },
  { "Ashley", 0.018207176 },
  { "Ashleyann", 0.0 },
  { "Ashleyanne", 0.0 },
  { "Ashleyelizabeth", 0.0 },
  { "Ashleykate", 0.0 },
  { "Ashleylynn", 0.0 },
  { "Ashleymae", 0.0 },
  { "Ashleymarie", 0.0 },
  { "Ashleyn", 0.0 },
  { "Ashleynicole", 0.0 },
  { "Ashleyrae", 0.0 },
  { "Ashleyrose", 0.0 },
  { "Ashli", 0.0 },
  { "Ashlie", 0.00050095184 },
  { "Ashliegh", 0.0 },
  { "Ashlii", 0.0 },
  { "Ashlin", 0.06087981 },
  { "Ashling", 0.0 },
  { "Ashlinn", 0.0 },
  { "Ashliy", 0.0 },
  { "Ashlley", 0.0 },
  { "Ashlly", 0.0 },
  { "Ashlon", 0.06849315 },
  { "Ashly", 0.010992971 },
  { "Ashlye", 0.0 },
  { "Ashlyn", 0.0012220789 },
  { "Ashlynd", 0.0 },
  { "Ashlyne", 0.0 },
  { "Ashlynn", 0.0005404675 },
  { "Ashlynne", 0.0 },
  { "Ashmeet", 0.0 },
  { "Ashmi", 0.0 },
  { "Ashmit", 1.0 },
  { "Ashmita", 0.0 },
  { "Ashna", 0.0 },
  { "Ashneel", 1.0 },
  { "Ashney", 0.0 },
  { "Ashni", 0.0 },
  { "Ashok", 1.0 },
  { "Ashoka", 1.0 },
  { "Ashon", 1.0 },
  { "Ashonda", 0.0 },
  { "Ashonna", 0.0 },
  { "Ashonta", 0.0 },
  { "Ashonte", 0.0 },
  { "Ashonti", 0.0 },
  { "Ashor", 1.0 },
  { "Ashot", 1.0 },
  { "Ashraf", 1.0 },
  { "Ashrit", 1.0 },
  { "Ashrita", 0.0 },
  { "Ashrith", 1.0 },
  { "Ashritha", 0.0 },
  { "Ashriya", 0.0 },
  { "Ashston", 1.0 },
  { "Ashtan", 0.4892704 },
  { "Ashten", 0.4935662 },
  { "Ashtian", 1.0 },
  { "Ashtin", 0.5221596 },
  { "Ashtion", 1.0 },
  { "Ashton", 0.77949256 },
  { "Ashtun", 1.0 },
  { "Ashtyn", 0.19058536 },
  { "Ashtynn", 0.031496063 },
  { "Ashuna", 0.0 },
  { "Ashunta", 0.0 },
  { "Ashunte", 0.0 },
  { "Ashunti", 0.0 },
  { "Ashur", 1.0 },
  { "Ashura", 0.0 },
  { "Ashutosh", 1.0 },
  { "Ashvath", 1.0 },
  { "Ashvi", 0.0 },
  { "Ashvik", 1.0 },
  { "Ashvika", 0.0 },
  { "Ashvin", 1.0 },
  { "Ashwaq", 0.0 },
  { "Ashwath", 1.0 },
  { "Ashwika", 0.0 },
  { "Ashwin", 1.0 },
  { "Ashwini", 0.0 },
  { "Ashya", 0.0 },
  { "Ashyah", 0.0 },
  { "Ashyia", 0.0 },
  { "Ashyiah", 0.0 },
  { "Ashyla", 0.0 },
  { "Ashyr", 1.0 },
  { "Ashyra", 0.0 },
  { "Ashyria", 0.0 },
  { "Asia", 0.006265584 },
  { "Asiah", 0.10880829 },
  { "Asialyn", 0.0 },
  { "Asialynn", 0.0 },
  { "Asiamarie", 0.0 },
  { "Asian", 0.4074074 },
  { "Asiana", 0.0 },
  { "Asianae", 0.0 },
  { "Asianah", 0.0 },
  { "Asianay", 0.0 },
  { "Asiane", 0.0 },
  { "Asianna", 0.0 },
  { "Asiaonna", 0.0 },
  { "Asie", 0.5263158 },
  { "Asiel", 0.98540145 },
  { "Asier", 1.0 },
  { "Asif", 1.0 },
  { "Asiha", 0.0 },
  { "Asija", 0.0 },
  { "Asijah", 0.0 },
  { "Asil", 0.47619048 },
  { "Asilee", 0.0 },
  { "Asim", 1.0 },
  { "Asimina", 0.0 },
  { "Asir", 1.0 },
  { "Asira", 0.0 },
  { "Asire", 1.0 },
  { "Asis", 1.0 },
  { "Asisha", 0.0 },
  { "Asiya", 0.0 },
  { "Asiyah", 0.03109328 },
  { "Asja", 0.0 },
  { "Asjah", 0.0 },
  { "Asjha", 0.0 },
  { "Asjia", 0.0 },
  { "Askari", 1.0 },
  { "Askia", 1.0 },
  { "Aslam", 1.0 },
  { "Aslan", 0.8982229 },
  { "Aslean", 0.0 },
  { "Aslee", 0.0 },
  { "Asleigh", 0.0 },
  { "Asley", 0.0 },
  { "Aslhey", 0.0 },
  { "Asli", 0.0 },
  { "Aslin", 0.0 },
  { "Asly", 0.0 },
  { "Aslyn", 0.0 },
  { "Aslynn", 0.0 },
  { "Asma", 0.0 },
  { "Asmaa", 0.0 },
  { "Asmahan", 0.0 },
  { "Asmar", 1.0 },
  { "Asmara", 0.0 },
  { "Asmi", 0.0 },
  { "Asmir", 1.0 },
  { "Asmita", 0.0 },
  { "Asmitha", 0.0 },
  { "Asna", 0.0 },
  { "Ason", 0.875 },
  { "Asoni", 0.0 },
  { "Asonte", 0.625 },
  { "Aspacia", 0.0 },
  { "Aspasia", 0.0 },
  { "Aspen", 0.08812448 },
  { "Aspenn", 0.0 },
  { "Aspin", 0.0 },
  { "Aspyn", 0.006793478 },
  { "Aspynn", 0.0 },
  { "Asra", 0.0 },
  { "Asrar", 0.0 },
  { "Asriel", 0.8095238 },
  { "Assa", 0.0 },
  { "Assad", 1.0 },
  { "Assael", 1.0 },
  { "Assaf", 1.0 },
  { "Assan", 1.0 },
  { "Assandra", 0.0 },
  { "Assane", 1.0 },
  { "Assante", 1.0 },
  { "Assata", 0.0 },
  { "Asser", 1.0 },
  { "Assetou", 0.0 },
  { "Assia", 0.0 },
  { "Assiatou", 0.0 },
  { "Assie", 0.0 },
  { "Assitan", 0.0 },
  { "Assma", 0.0 },
  { "Assunta", 0.0 },
  { "Assyria", 0.0 },
  { "Asta", 0.0 },
  { "Astacia", 0.0 },
  { "Astara", 0.0 },
  { "Astaria", 0.0 },
  { "Astasia", 0.0 },
  { "Astella", 0.0 },
  { "Asten", 0.7894737 },
  { "Aster", 0.3078759 },
  { "Asteria", 0.0 },
  { "Astha", 0.0 },
  { "Asthon", 1.0 },
  { "Asti", 0.0 },
  { "Astin", 0.7048872 },
  { "Astley", 1.0 },
  { "Aston", 0.9325897 },
  { "Astor", 1.0 },
  { "Astoria", 0.0 },
  { "Astou", 0.0 },
  { "Astra", 0.0 },
  { "Astraea", 0.0 },
  { "Astraeus", 1.0 },
  { "Astraya", 0.0 },
  { "Astrea", 0.0 },
  { "Astreia", 0.0 },
  { "Astri", 0.0 },
  { "Astria", 0.0 },
  { "Astrid", 0.0 },
  { "Astride", 0.0 },
  { "Astrin", 0.0 },
  { "Astro", 1.0 },
  { "Astry", 0.0 },
  { "Astryd", 0.0 },
  { "Astyn", 0.43636364 },
  { "Asucena", 0.0 },
  { "Asuka", 0.0 },
  { "Asul", 0.0 },
  { "Asuna", 0.0 },
  { "Asuncion", 0.3838384 },
  { "Asunta", 0.0 },
  { "Asusena", 0.0 },
  { "Asuzena", 0.0 },
  { "Aswad", 1.0 },
  { "Aswath", 1.0 },
  { "Aswell", 1.0 },
  { "Aswin", 1.0 },
  { "Asya", 0.0 },
  { "Asyah", 0.0 },
  { "Asyana", 0.0 },
  { "Asyia", 0.0 },
  { "Asyiah", 0.0 },
  { "Asyra", 0.0 },
  { "Asyria", 0.0 },
  { "Aszia", 0.0 },
  { "Aszure", 0.0 },
  { "Ata", 1.0 },
  { "Atahan", 1.0 },
  { "Atai", 1.0 },
  { "Ataja", 0.0 },
  { "Atakan", 1.0 },
  { "Atal", 1.0 },
  { "Atalanta", 0.0 },
  { "Atalaya", 0.0 },
  { "Atalee", 0.0 },
  { "Atalia", 0.0 },
  { "Ataliah", 0.0 },
  { "Atalie", 0.0 },
  { "Ataly", 0.0 },
  { "Atalya", 0.0 },
  { "Atanacio", 1.0 },
  { "Atanya", 0.0 },
  { "Atara", 0.0 },
  { "Atarah", 0.0 },
  { "Atari", 0.62204725 },
  { "Atasha", 0.0 },
  { "Atasia", 0.0 },
  { "Atavia", 0.0 },
  { "Atavion", 1.0 },
  { "Ataya", 0.0 },
  { "Ateeb", 1.0 },
  { "Atef", 1.0 },
  { "Atem", 1.0 },
  { "Aten", 1.0 },
  { "Atena", 0.0 },
  { "Atenas", 0.0 },
  { "Atenea", 0.0 },
  { "Ater", 1.0 },
  { "Atesha", 0.0 },
  { "Atha", 0.06428572 },
  { "Athala", 0.0 },
  { "Athalee", 0.0 },
  { "Athaleen", 0.0 },
  { "Athalene", 0.0 },
  { "Athalia", 0.0 },
  { "Athaliah", 0.0 },
  { "Athalie", 0.0 },
  { "Athan", 1.0 },
  { "Athanasia", 0.0 },
  { "Athanasios", 1.0 },
  { "Athanasius", 1.0 },
  { "Athaniel", 1.0 },
  { "Atharv", 1.0 },
  { "Atharva", 1.0 },
  { "Athea", 0.0 },
  { "Atheana", 0.0 },
  { "Atheena", 0.0 },
  { "Atheer", 0.0 },
  { "Athel", 0.89221555 },
  { "Athelene", 0.0 },
  { "Athelia", 0.0 },
  { "Atheline", 0.0 },
  { "Athen", 1.0 },
  { "Athena", 0.0 },
  { "Athenamarie", 0.0 },
  { "Athenarose", 0.0 },
  { "Athene", 0.0 },
  { "Athenea", 0.0 },
  { "Athenia", 0.0 },
  { "Athenna", 0.0 },
  { "Athens", 0.8375 },
  { "Ather", 0.5641026 },
  { "Atherine", 0.0 },
  { "Atherton", 1.0 },
  { "Athie", 0.0 },
  { "Athina", 0.0 },
  { "Athira", 0.0 },
  { "Athlee", 0.0 },
  { "Athleen", 0.0 },
  { "Athlene", 0.0 },
  { "Athlyn", 0.0 },
  { "Athol", 1.0 },
  { "Athon", 1.0 },
  { "Athony", 1.0 },
  { "Athos", 1.0 },
  { "Athryn", 0.0 },
  { "Athulya", 0.0 },
  { "Athylene", 0.0 },
  { "Athyna", 0.0 },
  { "Athziri", 0.0 },
  { "Athziry", 0.0 },
  { "Atia", 0.0 },
  { "Atiana", 0.0 },
  { "Atianna", 0.0 },
  { "Atiba", 0.98655915 },
  { "Atie", 0.0 },
  { "Atif", 1.0 },
  { "Atifa", 0.0 },
  { "Atiim", 1.0 },
  { "Atika", 0.0 },
  { "Atiksh", 1.0 },
  { "Atilano", 1.0 },
  { "Atilio", 1.0 },
  { "Atilla", 1.0 },
  { "Atina", 0.0 },
  { "Atinuke", 0.0 },
  { "Atira", 0.0 },
  { "Atisha", 0.0 },
  { "Atit", 1.0 },
  { "Ativa", 0.0 },
  { "Atiya", 0.0 },
  { "Atiyah", 0.0 },
  { "Atiyana", 0.0 },
  { "Atiyanna", 0.0 },
  { "Atiyya", 0.0 },
  { "Atiyyah", 0.0 },
  { "Atlai", 1.0 },
  { "Atlanta", 0.0 },
  { "Atlantis", 0.038812786 },
  { "Atlas", 0.9480045 },
  { "Atlean", 0.0 },
  { "Atlee", 0.8176964 },
  { "Atleigh", 0.0 },
  { "Atley", 0.5063613 },
  { "Atline", 0.0 },
  { "Atlis", 1.0 },
  { "Atnhony", 1.0 },
  { "Ato", 1.0 },
  { "Atoli", 0.0 },
  { "Atom", 1.0 },
  { "Atong", 0.0 },
  { "Atonia", 0.0 },
  { "Atonio", 1.0 },
  { "Atonya", 0.0 },
  { "Atoria", 0.0 },
  { "Atosha", 0.0 },
  { "Atoya", 0.0 },
  { "Atravion", 1.0 },
  { "Atrayu", 1.0 },
  { "Atreal", 1.0 },
  { "Atreau", 1.0 },
  { "Atreju", 1.0 },
  { "Atrell", 1.0 },
  { "Atreo", 1.0 },
  { "Atreu", 1.0 },
  { "Atreus", 1.0 },
  { "Atreya", 0.8181818 },
  { "Atreyu", 1.0 },
  { "Atrice", 0.0 },
  { "Atricia", 0.0 },
  { "Atrick", 1.0 },
  { "Atrina", 0.0 },
  { "Atsuko", 0.0 },
  { "Atsushi", 1.0 },
  { "Atta", 0.54545456 },
  { "Attache", 0.0 },
  { "Attalia", 0.0 },
  { "Attalie", 0.0 },
  { "Attallah", 0.0 },
  { "Atthew", 1.0 },
  { "Attia", 0.0 },
  { "Attiana", 0.0 },
  { "Attica", 0.0 },
  { "Atticus", 0.99508566 },
  { "Attie", 0.0 },
  { "Attikus", 1.0 },
  { "Attila", 1.0 },
  { "Attilio", 1.0 },
  { "Attis", 1.0 },
  { "Attison", 0.0 },
  { "Attiya", 0.0 },
  { "Attiyya", 0.0 },
  { "Attley", 1.0 },
  { "Attoria", 0.0 },
  { "Atul", 1.0 },
  { "Atward", 1.0 },
  { "Atwell", 1.0 },
  { "Atwood", 1.0 },
  { "Atyana", 0.0 },
  { "Atyanna", 0.0 },
  { "Atyia", 0.0 },
  { "Atzel", 1.0 },
  { "Atzhiri", 0.0 },
  { "Atzhiry", 0.0 },
  { "Atzi", 0.0 },
  { "Atzimba", 0.0 },
  { "Atzin", 0.8267717 },
  { "Atziri", 0.0 },
  { "Atziry", 0.0 },
  { "Auberon", 1.0 },
  { "Aubert", 1.0 },
  { "Aubery", 0.85982907 },
  { "Aubie", 0.82758623 },
  { "Aubin", 0.8 },
  { "Aubra", 0.89337176 },
  { "Aubray", 0.0 },
  { "Aubre", 0.020576132 },
  { "Aubrea", 0.0 },
  { "Aubreah", 0.0 },
  { "Aubreana", 0.0 },
  { "Aubreanna", 0.0 },
  { "Aubreauna", 0.0 },
  { "Aubree", 0.0012062726 },
  { "Aubreeana", 0.0 },
  { "Aubreeann", 0.0 },
  { "Aubreeanna", 0.0 },
  { "Aubreella", 0.0 },
  { "Aubreelynn", 0.0 },
  { "Aubreerose", 0.0 },
  { "Aubrei", 0.0 },
  { "Aubreigh", 0.0 },
  { "Aubrelle", 0.0 },
  { "Aubren", 0.30555555 },
  { "Aubreona", 0.0 },
  { "Aubreonna", 0.0 },
  { "Aubrey", 0.22959164 },
  { "Aubreyana", 0.0 },
  { "Aubreyann", 0.0 },
  { "Aubreyanna", 0.0 },
  { "Aubreyella", 0.0 },
  { "Aubreyelle", 0.0 },
  { "Aubreyjo", 0.0 },
  { "Aubreylynn", 0.0 },
  { "Aubreyona", 0.0 },
  { "Aubreyonna", 0.0 },
  { "Aubreyrose", 0.0 },
  { "Aubri", 0.0 },
  { "Aubria", 0.0 },
  { "Aubriahna", 0.0 },
  { "Aubriana", 0.0 },
  { "Aubrianah", 0.0 },
  { "Aubriann", 0.0 },
  { "Aubrianna", 0.0 },
  { "Aubriannah", 0.0 },
  { "Aubrianne", 0.0 },
  { "Aubriauna", 0.0 },
  { "Aubriaunna", 0.0 },
  { "Aubrie", 0.0 },
  { "Aubrieana", 0.0 },
  { "Aubrieanna", 0.0 },
  { "Aubriee", 0.0 },
  { "Aubriegh", 0.0 },
  { "Aubriel", 0.0 },
  { "Aubriela", 0.0 },
  { "Aubriella", 0.0 },
  { "Aubrielle", 0.0 },
  { "Aubrii", 0.0 },
  { "Aubrilyn", 0.0 },
  { "Aubrin", 0.0 },
  { "Aubrina", 0.0 },
  { "Aubriona", 0.0 },
  { "Aubrionna", 0.0 },
  { "Aubriyana", 0.0 },
  { "Aubry", 0.3635321 },
  { "Aubryana", 0.0 },
  { "Aubryanna", 0.0 },
  { "Aubrye", 0.0 },
  { "Aubryella", 0.0 },
  { "Aubryelle", 0.0 },
  { "Aubryn", 0.0 },
  { "Aubrynn", 0.0 },
  { "Auburn", 0.399653 },
  { "Aubyn", 0.0 },
  { "Aud", 1.0 },
  { "Auda", 0.0 },
  { "Auddie", 1.0 },
  { "Aude", 0.0 },
  { "Audean", 0.0 },
  { "Audee", 0.0 },
  { "Audel", 1.0 },
  { "Audelia", 0.0 },
  { "Audelio", 1.0 },
  { "Audeliz", 1.0 },
  { "Audell", 0.0 },
  { "Audella", 0.0 },
  { "Auden", 0.7044649 },
  { "Audene", 0.0 },
  { "Audery", 0.0 },
  { "Audette", 0.0 },
  { "Audey", 1.0 },
  { "Audi", 0.38812786 },
  { "Audia", 0.0 },
  { "Audiana", 0.0 },
  { "Audianna", 0.0 },
  { "Audie", 0.642743 },
  { "Audiel", 1.0 },
  { "Audin", 1.0 },
  { "Audine", 0.0 },
  { "Audio", 1.0 },
  { "Audis", 1.0 },
  { "Audley", 0.9927954 },
  { "Audna", 0.0 },
  { "Audon", 1.0 },
  { "Audra", 0.007840429 },
  { "Audrae", 0.0 },
  { "Audranna", 0.0 },
  { "Audray", 0.0 },
  { "Audraya", 0.0 },
  { "Audre", 0.046511628 },
  { "Audrea", 0.0 },
  { "Audreana", 0.0 },
  { "Audreanna", 0.0 },
  { "Audreauna", 0.0 },
  { "Audree", 0.0 },
  { "Audreena", 0.0 },
  { "Audrei", 0.0 },
  { "Audreigh", 0.0 },
  { "Audrena", 0.0 },
  { "Audrene", 0.0 },
  { "Audreona", 0.0 },
  { "Audresha", 0.0 },
  { "Audrey", 0.010494992 },
  { "Audreya", 0.0 },
  { "Audreyana", 0.0 },
  { "Audreyann", 0.0 },
  { "Audreyanna", 0.0 },
  { "Audreyna", 0.0 },
  { "Audreyonna", 0.0 },
  { "Audreyrose", 0.0 },
  { "Audri", 0.0 },
  { "Audria", 0.0 },
  { "Audriana", 0.0 },
  { "Audrianna", 0.0 },
  { "Audrianne", 0.0 },
  { "Audriauna", 0.0 },
  { "Audriaunna", 0.0 },
  { "Audric", 1.0 },
  { "Audrick", 1.0 },
  { "Audrie", 0.0013758943 },
  { "Audrieana", 0.0 },
  { "Audrieanna", 0.0 },
  { "Audriel", 0.0 },
  { "Audriella", 0.0 },
  { "Audrielle", 0.0 },
  { "Audriena", 0.0 },
  { "Audrienna", 0.0 },
  { "Audrienne", 0.0 },
  { "Audrii", 0.0 },
  { "Audrina", 0.0 },
  { "Audrinah", 0.0 },
  { "Audrinna", 0.0 },
  { "Audriona", 0.0 },
  { "Audrionna", 0.0 },
  { "Audris", 0.0 },
  { "Audrone", 0.0 },
  { "Audry", 0.112090394 },
  { "Audryana", 0.0 },
  { "Audryanna", 0.0 },
  { "Audryna", 0.0 },
  { "Audrynna", 0.0 },
  { "Audvik", 1.0 },
  { "Audwin", 1.0 },
  { "Audy", 0.9589041 },
  { "Audyn", 0.078125 },
  { "Auggie", 1.0 },
  { "Augie", 0.99134946 },
  { "Augus", 1.0 },
  { "August", 0.9202088 },
  { "Augusta", 0.09388671 },
  { "Augustas", 1.0 },
  { "Auguste", 0.9111111 },
  { "Augusten", 1.0 },
  { "Auguster", 1.0 },
  { "Augustin", 1.0 },
  { "Augustina", 0.0 },
  { "Augustine", 0.7746022 },
  { "Augustino", 1.0 },
  { "Augustis", 1.0 },
  { "Augusto", 1.0 },
  { "Augustus", 0.99935794 },
  { "Augustyn", 1.0 },
  { "Auja", 0.0 },
  { "Aujah", 0.0 },
  { "Aujanae", 0.0 },
  { "Aujanai", 0.0 },
  { "Aujane", 0.0 },
  { "Aukai", 1.0 },
  { "Aukeem", 1.0 },
  { "Aukievah", 0.0 },
  { "Aul", 1.0 },
  { "Aula", 0.0 },
  { "Aulani", 0.0 },
  { "Aulbrey", 0.0 },
  { "Aulda", 0.0 },
  { "Aulden", 1.0 },
  { "Aulelei", 0.0 },
  { "Aulene", 0.0 },
  { "Aulii", 0.0 },
  { "Auline", 0.0 },
  { "Aulona", 0.0 },
  { "Aulora", 0.0 },
  { "Aulton", 1.0 },
  { "Aum", 1.0 },
  { "Aumi", 1.0 },
  { "Aumya", 0.0 },
  { "Aun", 1.0 },
  { "Auna", 0.0 },
  { "Aunah", 0.0 },
  { "Aunalee", 0.0 },
  { "Aunaleigh", 0.0 },
  { "Aundra", 0.6603625 },
  { "Aundrae", 1.0 },
  { "Aundray", 1.0 },
  { "Aundraya", 0.0 },
  { "Aundre", 1.0 },
  { "Aundrea", 0.037614297 },
  { "Aundreah", 0.0 },
  { "Aundreia", 0.0 },
  { "Aundrey", 0.9844237 },
  { "Aundreya", 0.0 },
  { "Aundria", 0.0 },
  { "Aune", 0.0 },
  { "Auner", 1.0 },
  { "Aunesti", 0.0 },
  { "Aunesty", 0.0 },
  { "Aung", 1.0 },
  { "Aungelique", 0.0 },
  { "Auni", 0.0 },
  { "Aunica", 0.0 },
  { "Aunika", 0.0 },
  { "Aunisti", 0.0 },
  { "Aunisty", 0.0 },
  { "Auniya", 0.0 },
  { "Aunjel", 0.0 },
  { "Aunna", 0.0 },
  { "Aunnika", 0.0 },
  { "Aunya", 0.0 },
  { "Aunyae", 0.0 },
  { "Aunye", 0.0 },
  { "Aura", 0.0 },
  { "Aurabella", 0.0 },
  { "Auralee", 0.0 },
  { "Auralia", 0.0 },
  { "Aurash", 1.0 },
  { "Auraya", 0.0 },
  { "Aurbree", 0.0 },
  { "Aurea", 0.0 },
  { "Aureana", 0.0 },
  { "Aureanna", 0.0 },
  { "Auree", 0.0 },
  { "Aurel", 0.8428571 },
  { "Aurele", 1.0 },
  { "Aureli", 0.0 },
  { "Aurelia", 0.0 },
  { "Aureliana", 0.0 },
  { "Aureliano", 1.0 },
  { "Aurelie", 0.0 },
  { "Aurelio", 0.99910086 },
  { "Aurelius", 1.0 },
  { "Aurella", 0.0 },
  { "Aurellia", 0.0 },
  { "Aurelya", 0.0 },
  { "Auren", 0.61165047 },
  { "Aureo", 1.0 },
  { "Aureon", 0.0 },
  { "Auretta", 0.0 },
  { "Aureus", 1.0 },
  { "Aurey", 0.0 },
  { "Auri", 0.057803467 },
  { "Auria", 0.0 },
  { "Auriah", 0.0 },
  { "Aurian", 0.3529412 },
  { "Auriana", 0.0 },
  { "Aurianna", 0.0 },
  { "Auric", 1.0 },
  { "Aurick", 1.0 },
  { "Aurie", 0.0 },
  { "Auriel", 0.054758802 },
  { "Auriella", 0.0 },
  { "Aurielle", 0.0 },
  { "Aurieona", 0.0 },
  { "Aurik", 1.0 },
  { "Auril", 0.0 },
  { "Aurilla", 0.0 },
  { "Aurin", 1.0 },
  { "Aurion", 0.44444445 },
  { "Auriona", 0.0 },
  { "Aurionna", 0.0 },
  { "Auriya", 0.0 },
  { "Auriyah", 0.0 },
  { "Auriyana", 0.0 },
  { "Auroara", 0.0 },
  { "Aurohom", 1.0 },
  { "Auron", 1.0 },
  { "Aurora", 0.001006226 },
  { "Aurorah", 0.0 },
  { "Auroralee", 0.0 },
  { "Auroralynn", 0.0 },
  { "Aurore", 0.0 },
  { "Auroura", 0.0 },
  { "Aurra", 0.0 },
  { "Aurther", 1.0 },
  { "Aurthor", 1.0 },
  { "Aurthur", 1.0 },
  { "Aury", 0.046728972 },
  { "Auryana", 0.0 },
  { "Auryanna", 0.0 },
  { "Auryn", 0.8 },
  { "Ausar", 1.0 },
  { "Ausbon", 1.0 },
  { "Ausby", 1.0 },
  { "Ausencio", 1.0 },
  { "Auset", 0.0 },
  { "Ausha", 0.0 },
  { "Ausia", 0.0 },
  { "Ausie", 1.0 },
  { "Ausitn", 1.0 },
  { "Austa", 0.0 },
  { "Austan", 1.0 },
  { "Austeja", 0.0 },
  { "Austen", 0.90684897 },
  { "Austi", 0.0 },
  { "Austie", 0.0 },
  { "Austin", 0.9891568 },
  { "Austina", 0.0 },
  { "Austine", 0.47663552 },
  { "Austinjames", 1.0 },
  { "Austinjohn", 1.0 },
  { "Austinlee", 1.0 },
  { "Austinmichael", 1.0 },
  { "Austinn", 1.0 },
  { "Austintyler", 1.0 },
  { "Auston", 1.0 },
  { "Australia", 0.03206997 },
  { "Austreberto", 1.0 },
  { "Austria", 0.0 },
  { "Austun", 1.0 },
  { "Austyn", 0.61420214 },
  { "Austynn", 0.0 },
  { "Autavia", 0.0 },
  { "Authar", 1.0 },
  { "Auther", 0.9928149 },
  { "Autherine", 0.0 },
  { "Author", 1.0 },
  { "Authur", 1.0 },
  { "Autiana", 0.0 },
  { "Autianna", 0.0 },
  { "Autie", 0.15068494 },
  { "Autin", 1.0 },
  { "Autis", 1.0 },
  { "Autmn", 0.0 },
  { "Autom", 0.0 },
  { "Automn", 0.0 },
  { "Autra", 0.0 },
  { "Autrey", 0.9102564 },
  { "Autry", 0.8516566 },
  { "Auttum", 0.0 },
  { "Auttumn", 0.0 },
  { "Autum", 0.0 },
  { "Autume", 0.0 },
  { "Autumm", 0.0 },
  { "Autumn", 0.0023095675 },
  { "Autumne", 0.0 },
  { "Autumnn", 0.0 },
  { "Autumnrose", 0.0 },
  { "Autunm", 0.0 },
  { "Auturo", 1.0 },
  { "Autym", 0.0 },
  { "Autymn", 0.0 },
  { "Autzen", 1.0 },
  { "Auviana", 0.0 },
  { "Auvianna", 0.0 },
  { "Auzhane", 0.0 },
  { "Auzie", 1.0 },
  { "Av", 1.0 },
  { "Ava", 0.0011870926 },
  { "Avaa", 0.0 },
  { "Avaah", 0.0 },
  { "Avaan", 1.0 },
  { "Avaani", 0.0 },
  { "Avabella", 0.0 },
  { "Avabelle", 0.0 },
  { "Avaclaire", 0.0 },
  { "Avacyn", 0.0 },
  { "Avadna", 0.0 },
  { "Avae", 0.0 },
  { "Avaeah", 0.0 },
  { "Avaeh", 0.0 },
  { "Avaelizabeth", 0.0 },
  { "Avagail", 0.0 },
  { "Avagrace", 0.0 },
  { "Avah", 0.0 },
  { "Avahlyn", 0.0 },
  { "Avahlynn", 0.0 },
  { "Avaia", 0.0 },
  { "Avaiah", 0.0 },
  { "Avaiya", 0.0 },
  { "Avaiyah", 0.0 },
  { "Avajames", 0.0 },
  { "Avajane", 0.0 },
  { "Avajo", 0.0 },
  { "Avajoy", 0.0 },
  { "Avakate", 0.0 },
  { "Avala", 0.0 },
  { "Avalanna", 0.0 },
  { "Avalea", 0.0 },
  { "Avalee", 0.0 },
  { "Avaleen", 0.0 },
  { "Avaleena", 0.0 },
  { "Avalei", 0.0 },
  { "Avaleigh", 0.0 },
  { "Avalena", 0.0 },
  { "Avalene", 0.0 },
  { "Avaley", 0.0 },
  { "Avali", 0.0 },
  { "Avalia", 0.0 },
  { "Avalie", 0.0 },
  { "Avaliese", 0.0 },
  { "Avalin", 0.0 },
  { "Avalina", 0.0 },
  { "Avaline", 0.0 },
  { "Avalise", 0.0 },
  { "Avalon", 0.009737099 },
  { "Avalyn", 0.0 },
  { "Avalyna", 0.0 },
  { "Avalyne", 0.0 },
  { "Avalynn", 0.0 },
  { "Avalynne", 0.0 },
  { "Avalyse", 0.0 },
  { "Avamae", 0.0 },
  { "Avamaria", 0.0 },
  { "Avamarie", 0.0 },
  { "Avamay", 0.0 },
  { "Avamonroe", 0.0 },
  { "Avan", 0.93093526 },
  { "Avana", 0.0 },
  { "Avanah", 0.0 },
  { "Avander", 1.0 },
  { "Avaneesh", 1.0 },
  { "Avanel", 0.0 },
  { "Avanell", 0.0 },
  { "Avanelle", 0.0 },
  { "Avangaline", 0.0 },
  { "Avangelene", 0.0 },
  { "Avangelia", 0.0 },
  { "Avangelina", 0.0 },
  { "Avangeline", 0.0 },
  { "Avani", 0.007518797 },
  { "Avanicole", 0.0 },
  { "Avanish", 1.0 },
  { "Avanna", 0.0 },
  { "Avannah", 0.0 },
  { "Avanni", 0.0 },
  { "Avant", 1.0 },
  { "Avanta", 1.0 },
  { "Avantae", 1.0 },
  { "Avantay", 1.0 },
  { "Avante", 0.9494008 },
  { "Avanthi", 0.0 },
  { "Avanthika", 0.0 },
  { "Avanti", 0.14942528 },
  { "Avantika", 0.0 },
  { "Avanya", 0.0 },
  { "Avarae", 0.0 },
  { "Avard", 1.0 },
  { "Avaree", 0.0 },
  { "Avareigh", 0.0 },
  { "Avarey", 0.0 },
  { "Avari", 0.11646587 },
  { "Avarie", 0.0 },
  { "Avariella", 0.0 },
  { "Avarielle", 0.0 },
  { "Avarose", 0.0 },
  { "Avary", 0.0649259 },
  { "Avash", 1.0 },
  { "Avasophia", 0.0 },
  { "Avaughn", 1.0 },
  { "Avaya", 0.0 },
  { "Avayah", 0.0 },
  { "Avayiah", 0.0 },
  { "Avayla", 0.0 },
  { "Ave", 0.0 },
  { "Avea", 0.0 },
  { "Aveah", 0.0 },
  { "Aveaha", 0.0 },
  { "Aveana", 0.0 },
  { "Aveanna", 0.0 },
  { "Aveda", 0.0 },
  { "Avedis", 1.0 },
  { "Avee", 0.0 },
  { "Aveen", 0.0 },
  { "Aveena", 0.0 },
  { "Aveer", 1.0 },
  { "Aveigha", 0.0 },
  { "Aveion", 1.0 },
  { "Avel", 1.0 },
  { "Avelardo", 1.0 },
  { "Aveleen", 0.0 },
  { "Avelene", 0.0 },
  { "Avelia", 0.0 },
  { "Avelie", 0.0 },
  { "Avelin", 0.0 },
  { "Avelina", 0.0 },
  { "Aveline", 0.0 },
  { "Avelinn", 0.0 },
  { "Avelino", 1.0 },
  { "Avella", 0.0 },
  { "Avellana", 0.0 },
  { "Avelle", 0.0 },
  { "Avellina", 0.0 },
  { "Avelyn", 0.0 },
  { "Avelynn", 0.0 },
  { "Avemaria", 0.0 },
  { "Aven", 0.59679145 },
  { "Avena", 0.0 },
  { "Avenell", 0.0 },
  { "Avenelle", 0.0 },
  { "Avenir", 1.0 },
  { "Avenlea", 0.0 },
  { "Avenlee", 0.0 },
  { "Avenleigh", 0.0 },
  { "Avenley", 0.0 },
  { "Avenly", 0.0 },
  { "Avenn", 1.0 },
  { "Aveon", 0.9483204 },
  { "Aveona", 0.0 },
  { "Aveonna", 0.0 },
  { "Aver", 0.0 },
  { "Avera", 0.0 },
  { "Averee", 0.03783102 },
  { "Avereigh", 0.0 },
  { "Averell", 1.0 },
  { "Averett", 1.0 },
  { "Averey", 0.31343284 },
  { "Averi", 0.04150597 },
  { "Averiana", 0.0 },
  { "Averianna", 0.0 },
  { "Averick", 1.0 },
  { "Averie", 0.020134227 },
  { "Averiee", 0.0 },
  { "Averiella", 0.0 },
  { "Averielle", 0.0 },
  { "Averii", 0.0 },
  { "Averil", 0.098434 },
  { "Averill", 0.6745562 },
  { "Averion", 1.0 },
  { "Averionna", 0.0 },
  { "Averlee", 0.0 },
  { "Averleigh", 0.0 },
  { "Averley", 0.0 },
  { "Averlie", 0.0 },
  { "Averly", 0.0 },
  { "Avery", 0.31904274 },
  { "Averyana", 0.0 },
  { "Averyanna", 0.0 },
  { "Averyl", 0.0 },
  { "Averylynn", 0.0 },
  { "Averymarie", 0.0 },
  { "Averyn", 1.0 },
  { "Averyon", 1.0 },
  { "Averyona", 0.0 },
  { "Averyonna", 0.0 },
  { "Averyrose", 0.0 },
  { "Aves", 0.0 },
  { "Avet", 1.0 },
  { "Avetis", 1.0 },
  { "Avett", 0.9597315 },
  { "Avey", 0.0 },
  { "Aveya", 0.0 },
  { "Aveyah", 0.0 },
  { "Aveyon", 1.0 },
  { "Avi", 0.88469136 },
  { "Avia", 0.0 },
  { "Aviad", 1.0 },
  { "Aviah", 0.0 },
  { "Aviahna", 0.0 },
  { "Avian", 0.8012912 },
  { "Aviana", 0.0 },
  { "Avianah", 0.0 },
  { "Avianca", 0.0 },
  { "Aviance", 0.0 },
  { "Avianna", 0.0 },
  { "Aviannah", 0.0 },
  { "Avianne", 0.0 },
  { "Aviara", 0.0 },
  { "Aviary", 0.0 },
  { "Avice", 0.0 },
  { "Avichai", 1.0 },
  { "Avid", 1.0 },
  { "Avidan", 1.0 },
  { "Avie", 0.008688783 },
  { "Aviel", 0.9715994 },
  { "Aviela", 0.0 },
  { "Aviella", 0.0 },
  { "Avielle", 0.025 },
  { "Avien", 1.0 },
  { "Avienda", 0.0 },
  { "Aviendha", 0.0 },
  { "Avienne", 0.0 },
  { "Avieon", 1.0 },
  { "Avier", 1.0 },
  { "Avigail", 0.0 },
  { "Avigayil", 0.0 },
  { "Avigdor", 1.0 },
  { "Avighna", 1.0 },
  { "Avik", 1.0 },
  { "Avika", 0.0 },
  { "Avila", 0.0 },
  { "Avilee", 0.0 },
  { "Avilene", 0.0 },
  { "Avilyn", 0.0 },
  { "Avilynn", 0.0 },
  { "Avimael", 1.0 },
  { "Avin", 0.92676765 },
  { "Avina", 0.0 },
  { "Avinash", 1.0 },
  { "Avinell", 0.0 },
  { "Avinoam", 1.0 },
  { "Avion", 0.8544907 },
  { "Aviona", 0.0 },
  { "Avionce", 0.0 },
  { "Avione", 0.0 },
  { "Avionna", 0.0 },
  { "Avionne", 0.0 },
  { "Avir", 1.0 },
  { "Avira", 0.0 },
  { "Aviraaj", 1.0 },
  { "Aviraj", 1.0 },
  { "Aviral", 1.0 },
  { "Aviram", 1.0 },
  { "Aviree", 0.0 },
  { "Avis", 0.044005137 },
  { "Avish", 1.0 },
  { "Avisha", 0.0 },
  { "Avishai", 1.0 },
  { "Avishek", 1.0 },
  { "Avishi", 0.0 },
  { "Avishka", 0.0 },
  { "Avita", 0.0 },
  { "Avitaj", 1.0 },
  { "Avital", 0.0 },
  { "Avitaz", 1.0 },
  { "Aviv", 0.80172414 },
  { "Aviva", 0.0 },
  { "Avivah", 0.0 },
  { "Aviya", 0.0 },
  { "Aviyah", 0.0 },
  { "Aviyana", 0.0 },
  { "Aviyanna", 0.0 },
  { "Aviyon", 0.93939394 },
  { "Aviyonna", 0.0 },
  { "Avleen", 0.0 },
  { "Avlyn", 0.0 },
  { "Avlynn", 0.0 },
  { "Avneesh", 1.0 },
  { "Avneet", 0.013020833 },
  { "Avner", 1.0 },
  { "Avni", 0.0 },
  { "Avnish", 1.0 },
  { "Avnoor", 0.0 },
  { "Avo", 0.02793296 },
  { "Avola", 0.0 },
  { "Avon", 0.6802193 },
  { "Avona", 0.0 },
  { "Avonda", 0.0 },
  { "Avondre", 1.0 },
  { "Avonel", 0.0 },
  { "Avonell", 0.0 },
  { "Avonelle", 0.0 },
  { "Avonlea", 0.0 },
  { "Avonlee", 0.0 },
  { "Avonna", 0.0 },
  { "Avonne", 0.0 },
  { "Avonni", 0.0 },
  { "Avont", 1.0 },
  { "Avonta", 1.0 },
  { "Avontae", 1.0 },
  { "Avontay", 1.0 },
  { "Avonte", 1.0 },
  { "Avor", 0.0 },
  { "Avoree", 0.0 },
  { "Avori", 0.0 },
  { "Avorie", 0.0 },
  { "Avory", 0.42771083 },
  { "Avra", 0.0 },
  { "Avraham", 1.0 },
  { "Avrahom", 1.0 },
  { "Avraj", 1.0 },
  { "Avram", 1.0 },
  { "Avree", 0.024774775 },
  { "Avreet", 0.0 },
  { "Avreigh", 0.0 },
  { "Avren", 1.0 },
  { "Avrey", 0.4420168 },
  { "Avri", 0.057356607 },
  { "Avrian", 1.0 },
  { "Avriana", 0.0 },
  { "Avrianna", 0.0 },
  { "Avrie", 0.01146789 },
  { "Avriel", 0.11678832 },
  { "Avriella", 0.0 },
  { "Avrielle", 0.0 },
  { "Avrik", 1.0 },
  { "Avril", 0.0020169422 },
  { "Avrill", 0.0 },
  { "Avrilynn", 0.0 },
  { "Avrion", 1.0 },
  { "Avroham", 1.0 },
  { "Avrohom", 1.0 },
  { "Avrom", 1.0 },
  { "Avron", 1.0 },
  { "Avrora", 0.0 },
  { "Avrum", 1.0 },
  { "Avrumi", 1.0 },
  { "Avrumy", 1.0 },
  { "Avry", 0.47635525 },
  { "Avryl", 0.0 },
  { "Avryn", 0.0 },
  { "Avshalom", 1.0 },
  { "Avva", 0.0 },
  { "Avy", 0.052980132 },
  { "Avya", 0.0 },
  { "Avyaan", 1.0 },
  { "Avyan", 1.0 },
  { "Avyana", 0.0 },
  { "Avyanah", 0.0 },
  { "Avyanna", 0.0 },
  { "Avyansh", 1.0 },
  { "Avyay", 1.0 },
  { "Avyion", 1.0 },
  { "Avyn", 0.44054055 },
  { "Avynlee", 0.0 },
  { "Avynn", 0.0 },
  { "Avyon", 1.0 },
  { "Avyona", 0.0 },
  { "Avyonna", 0.0 },
  { "Avyukt", 1.0 },
  { "Avyukth", 1.0 },
  { "Awa", 0.0 },
  { "Awab", 1.0 },
  { "Awad", 1.0 },
  { "Awais", 1.0 },
  { "Awan", 1.0 },
  { "Awanda", 0.0 },
  { "Awbree", 0.0 },
  { "Awbrey", 0.0 },
  { "Aweis", 1.0 },
  { "Awesome", 1.0 },
  { "Awet", 1.0 },
  { "Aweys", 1.0 },
  { "Awi", 0.0 },
  { "Awilda", 0.0 },
  { "Awn", 0.0 },
  { "Awna", 0.0 },
  { "Awo", 0.0 },
  { "Aws", 1.0 },
  { "Awwab", 1.0 },
  { "Awwal", 1.0 },
  { "Axa", 0.0 },
  { "Axal", 1.0 },
  { "Axavier", 1.0 },
  { "Axcel", 1.0 },
  { "Axcell", 1.0 },
  { "Axe", 1.0 },
  { "Axeel", 1.0 },
  { "Axel", 0.996702 },
  { "Axell", 1.0 },
  { "Axelle", 0.0 },
  { "Axeton", 1.0 },
  { "Axia", 0.0 },
  { "Axie", 0.0 },
  { "Axiel", 1.0 },
  { "Axil", 1.0 },
  { "Axiom", 1.0 },
  { "Axiry", 0.0 },
  { "Axis", 1.0 },
  { "Axl", 1.0 },
  { "Axle", 1.0 },
  { "Axon", 1.0 },
  { "Axsel", 1.0 },
  { "Axten", 1.0 },
  { "Axtin", 1.0 },
  { "Axton", 1.0 },
  { "Axtyn", 1.0 },
  { "Axwell", 1.0 },
  { "Axxel", 1.0 },
  { "Axyl", 1.0 },
  { "Axzel", 1.0 },
  { "Aya", 0.0 },
  { "Ayaa", 0.0 },
  { "Ayaan", 0.9643595 },
  { "Ayaana", 0.0 },
  { "Ayaansh", 1.0 },
  { "Ayaat", 0.0 },
  { "Ayad", 1.0 },
  { "Ayah", 0.0 },
  { "Ayahna", 0.0 },
  { "Ayaina", 0.0 },
  { "Ayak", 0.0 },
  { "Ayaka", 0.0 },
  { "Ayako", 0.0 },
  { "Ayal", 1.0 },
  { "Ayala", 0.0 },
  { "Ayalah", 0.0 },
  { "Ayame", 0.0 },
  { "Ayami", 0.0 },
  { "Ayan", 0.74625 },
  { "Ayana", 0.0004947066 },
  { "Ayanah", 0.0 },
  { "Ayanami", 0.0 },
  { "Ayanda", 0.0 },
  { "Ayane", 0.0 },
  { "Ayani", 0.0 },
  { "Ayania", 0.0 },
  { "Ayaniah", 0.0 },
  { "Ayanle", 1.0 },
  { "Ayanna", 0.0 },
  { "Ayannah", 0.0 },
  { "Ayanne", 0.0 },
  { "Ayanni", 0.0 },
  { "Ayannia", 0.0 },
  { "Ayano", 0.0 },
  { "Ayansh", 1.0 },
  { "Ayante", 0.0 },
  { "Ayantu", 0.0 },
  { "Ayari", 0.0 },
  { "Ayasha", 0.0 },
  { "Ayat", 0.0 },
  { "Ayati", 0.0 },
  { "Ayatollah", 1.0 },
  { "Ayatt", 0.0 },
  { "Ayauna", 0.0 },
  { "Ayaz", 1.0 },
  { "Aybel", 1.0 },
  { "Aybree", 0.0 },
  { "Aybri", 0.0 },
  { "Aybrie", 0.0 },
  { "Ayce", 1.0 },
  { "Aycen", 1.0 },
  { "Ayda", 0.0 },
  { "Aydah", 0.0 },
  { "Aydain", 1.0 },
  { "Aydali", 0.0 },
  { "Aydan", 0.9185199 },
  { "Aydann", 1.0 },
  { "Aydden", 1.0 },
  { "Ayde", 0.0 },
  { "Aydee", 0.0 },
  { "Aydeen", 1.0 },
  { "Aydelis", 0.0 },
  { "Aydeliz", 0.0 },
  { "Ayden", 0.96854347 },
  { "Aydenn", 0.97882736 },
  { "Aydenne", 0.0 },
  { "Aydia", 0.0 },
  { "Aydian", 1.0 },
  { "Aydien", 1.0 },
  { "Aydin", 0.9593271 },
  { "Aydn", 1.0 },
  { "Aydon", 1.0 },
  { "Aydree", 0.0 },
  { "Aydren", 1.0 },
  { "Aydrian", 0.83093524 },
  { "Aydriana", 0.0 },
  { "Aydrianna", 0.0 },
  { "Aydric", 1.0 },
  { "Aydrie", 0.0 },
  { "Aydrien", 1.0 },
  { "Aydrik", 1.0 },
  { "Aydun", 1.0 },
  { "Aydyn", 0.9657321 },
  { "Aye", 0.0 },
  { "Ayea", 0.0 },
  { "Ayeasha", 0.0 },
  { "Ayedan", 1.0 },
  { "Ayeden", 1.0 },
  { "Ayedin", 1.0 },
  { "Ayeesha", 0.0 },
  { "Ayeh", 0.0 },
  { "Ayeisha", 0.0 },
  { "Ayela", 0.0 },
  { "Ayele", 0.5 },
  { "Ayeleen", 0.0 },
  { "Ayelen", 0.0 },
  { "Ayelene", 0.0 },
  { "Ayelet", 0.0 },
  { "Ayelin", 0.0 },
  { "Ayen", 0.0 },
  { "Ayerim", 0.0 },
  { "Ayesha", 0.0 },
  { "Ayeshah", 0.0 },
  { "Ayeshia", 0.0 },
  { "Ayeza", 0.0 },
  { "Ayham", 1.0 },
  { "Ayhan", 1.0 },
  { "Ayhem", 1.0 },
  { "Ayia", 0.0 },
  { "Ayiana", 0.0 },
  { "Ayianna", 0.0 },
  { "Ayiden", 1.0 },
  { "Ayin", 0.0 },
  { "Ayinde", 1.0 },
  { "Ayira", 0.0 },
  { "Ayisha", 0.0 },
  { "Ayishah", 0.0 },
  { "Ayja", 0.0 },
  { "Ayjah", 0.0 },
  { "Ayla", 0.0 },
  { "Aylah", 0.0 },
  { "Aylamae", 0.0 },
  { "Aylan", 1.0 },
  { "Aylana", 0.0 },
  { "Aylani", 0.0 },
  { "Aylanie", 0.0 },
  { "Aylanna", 0.0 },
  { "Aylanni", 0.0 },
  { "Ayleah", 0.0 },
  { "Ayled", 0.0 },
  { "Aylee", 0.0 },
  { "Ayleen", 0.0 },
  { "Ayleena", 0.0 },
  { "Ayleene", 0.0 },
  { "Ayleigh", 0.0 },
  { "Aylen", 0.08490566 },
  { "Aylena", 0.0 },
  { "Aylene", 0.0 },
  { "Aylenne", 0.0 },
  { "Aylet", 0.0 },
  { "Ayleth", 0.0 },
  { "Ayli", 0.0 },
  { "Aylia", 0.0 },
  { "Ayliah", 0.0 },
  { "Ayliana", 0.0 },
  { "Aylianna", 0.0 },
  { "Aylie", 0.0 },
  { "Aylin", 0.0017774267 },
  { "Aylina", 0.0 },
  { "Ayline", 0.0 },
  { "Aylinn", 0.0 },
  { "Aylinne", 0.0 },
  { "Aylisha", 0.0 },
  { "Aylissa", 0.0 },
  { "Aylla", 0.0 },
  { "Aylon", 1.0 },
  { "Aylssa", 0.0 },
  { "Aylyn", 0.0 },
  { "Aylynn", 0.0 },
  { "Aymaan", 1.0 },
  { "Ayman", 0.98310196 },
  { "Aymar", 0.0 },
  { "Aymara", 0.0 },
  { "Ayme", 0.0 },
  { "Aymee", 0.0 },
  { "Aymen", 0.9502924 },
  { "Aymeric", 1.0 },
  { "Aymie", 0.0 },
  { "Ayn", 0.0 },
  { "Ayna", 0.0 },
  { "Aynara", 0.0 },
  { "Ayneka", 0.0 },
  { "Ayni", 0.0 },
  { "Aynia", 0.0 },
  { "Ayniah", 0.0 },
  { "Aynslee", 0.0 },
  { "Aynsleigh", 0.0 },
  { "Aynsley", 0.0 },
  { "Aynslie", 0.0 },
  { "Aynur", 0.0 },
  { "Ayo", 0.5928144 },
  { "Ayobami", 1.0 },
  { "Ayodeji", 1.0 },
  { "Ayodele", 0.70658684 },
  { "Ayofemi", 0.0 },
  { "Ayoka", 0.0 },
  { "Ayoki", 0.0 },
  { "Ayomi", 0.0 },
  { "Ayomide", 0.58945906 },
  { "Ayomikun", 0.7291667 },
  { "Ayomiposi", 0.52 },
  { "Ayon", 1.0 },
  { "Ayona", 0.0 },
  { "Ayonah", 0.0 },
  { "Ayondela", 0.0 },
  { "Ayonna", 0.0 },
  { "Ayoob", 1.0 },
  { "Ayoola", 0.5 },
  { "Ayooluwa", 0.33333334 },
  { "Ayotomi", 1.0 },
  { "Ayotunde", 1.0 },
  { "Ayoub", 1.0 },
  { "Ayra", 0.0 },
  { "Ayrabella", 0.0 },
  { "Ayrah", 0.0 },
  { "Ayram", 0.0 },
  { "Ayreana", 0.0 },
  { "Ayreanna", 0.0 },
  { "Ayren", 0.921875 },
  { "Ayreona", 0.0 },
  { "Ayreonna", 0.0 },
  { "Ayres", 1.0 },
  { "Ayria", 0.0 },
  { "Ayriah", 0.0 },
  { "Ayrial", 0.0 },
  { "Ayrian", 0.3 },
  { "Ayriana", 0.0 },
  { "Ayrianna", 0.0 },
  { "Ayriauna", 0.0 },
  { "Ayric", 1.0 },
  { "Ayrica", 0.0 },
  { "Ayrie", 0.0 },
  { "Ayriel", 0.0 },
  { "Ayrihanna", 0.0 },
  { "Ayrika", 0.0 },
  { "Ayrin", 0.0 },
  { "Ayrion", 0.5 },
  { "Ayrionna", 0.0 },
  { "Ayris", 0.0 },
  { "Ayron", 0.98207885 },
  { "Ayrton", 1.0 },
  { "Aysa", 0.040983606 },
  { "Ayse", 0.0 },
  { "Aysel", 0.0 },
  { "Aysen", 1.0 },
  { "Aysenur", 0.0 },
  { "Aysha", 0.0 },
  { "Ayshah", 0.0 },
  { "Ayshia", 0.0 },
  { "Aysia", 0.0 },
  { "Aysiah", 0.0 },
  { "Ayslee", 0.0 },
  { "Ayslin", 0.0 },
  { "Ayslinn", 0.0 },
  { "Ayslyn", 0.0 },
  { "Ayson", 1.0 },
  { "Ayssa", 0.0 },
  { "Aysu", 0.0 },
  { "Aytana", 0.0 },
  { "Ayten", 0.0 },
  { "Aythan", 1.0 },
  { "Aythen", 1.0 },
  { "Ayub", 1.0 },
  { "Ayumi", 0.0 },
  { "Ayumu", 1.0 },
  { "Ayuna", 0.0 },
  { "Ayunna", 0.0 },
  { "Ayush", 1.0 },
  { "Ayusha", 0.0 },
  { "Ayushi", 0.0 },
  { "Ayushmaan", 1.0 },
  { "Ayushman", 1.0 },
  { "Ayuub", 1.0 },
  { "Ayva", 0.0 },
  { "Ayvah", 0.0 },
  { "Ayvan", 1.0 },
  { "Ayvani", 0.0 },
  { "Ayvee", 0.0 },
  { "Ayven", 0.8938356 },
  { "Ayveon", 1.0 },
  { "Ayveri", 0.0 },
  { "Ayverie", 0.0 },
  { "Ayvia", 0.0 },
  { "Ayviana", 0.0 },
  { "Ayvin", 1.0 },
  { "Ayvion", 1.0 },
  { "Ayvree", 0.0 },
  { "Ayvri", 0.0 },
  { "Ayvrie", 0.0 },
  { "Ayyan", 1.0 },
  { "Ayyoub", 1.0 },
  { "Ayyub", 1.0 },
  { "Ayza", 0.0 },
  { "Ayzah", 0.0 },
  { "Ayzaria", 0.0 },
  { "Ayzel", 0.0 },
  { "Ayzen", 1.0 },
  { "Ayzha", 0.0 },
  { "Ayzia", 0.0 },
  { "Ayzlee", 0.0 },
  { "Ayzlin", 0.0 },
  { "Ayzlyn", 0.0 },
  { "Aza", 0.1092437 },
  { "Azaad", 1.0 },
  { "Azaan", 1.0 },
  { "Azad", 1.0 },
  { "Azadeh", 0.0 },
  { "Azael", 1.0 },
  { "Azaela", 0.0 },
  { "Azaelia", 0.0 },
  { "Azah", 0.0 },
  { "Azahel", 1.0 },
  { "Azahria", 0.0 },
  { "Azai", 1.0 },
  { "Azaia", 0.0 },
  { "Azaiah", 0.8855535 },
  { "Azaila", 0.0 },
  { "Azailya", 0.0 },
  { "Azaira", 0.0 },
  { "Azairah", 0.0 },
  { "Azaireyah", 0.0 },
  { "Azaiyah", 0.0 },
  { "Azalaya", 0.0 },
  { "Azalea", 0.0 },
  { "Azaleah", 0.0 },
  { "Azalee", 0.0 },
  { "Azaleia", 0.0 },
  { "Azaleigh", 0.0 },
  { "Azaleigha", 0.0 },
  { "Azalene", 0.0 },
  { "Azaley", 0.0 },
  { "Azaleya", 0.0 },
  { "Azaleyah", 0.0 },
  { "Azalia", 0.0 },
  { "Azaliah", 0.0 },
  { "Azalie", 0.0 },
  { "Azaline", 0.0 },
  { "Azaliya", 0.0 },
  { "Azaliyah", 0.0 },
  { "Azalya", 0.0 },
  { "Azalyn", 0.0 },
  { "Azalynn", 0.0 },
  { "Azam", 1.0 },
  { "Azan", 1.0 },
  { "Azana", 0.0 },
  { "Azanae", 0.0 },
  { "Azaneth", 0.0 },
  { "Azani", 0.0 },
  { "Azania", 0.0 },
  { "Azaniah", 0.33333334 },
  { "Azante", 1.0 },
  { "Azar", 0.91803277 },
  { "Azara", 0.0 },
  { "Azarae", 0.0 },
  { "Azarael", 1.0 },
  { "Azarah", 0.0 },
  { "Azaraya", 0.0 },
  { "Azarea", 0.0 },
  { "Azareah", 0.0 },
  { "Azaree", 0.0 },
  { "Azareel", 1.0 },
  { "Azareeyah", 0.0 },
  { "Azarel", 1.0 },
  { "Azareth", 0.0 },
  { "Azareya", 0.0 },
  { "Azareyah", 0.0 },
  { "Azari", 0.30688623 },
  { "Azaria", 0.023402523 },
  { "Azariah", 0.40652072 },
  { "Azarian", 1.0 },
  { "Azariana", 0.0 },
  { "Azarias", 1.0 },
  { "Azarie", 0.04901961 },
  { "Azariea", 0.0 },
  { "Azariel", 1.0 },
  { "Azarion", 1.0 },
  { "Azarious", 1.0 },
  { "Azarius", 1.0 },
  { "Azariya", 0.0 },
  { "Azariyah", 0.03214286 },
  { "Azarria", 0.0 },
  { "Azarriah", 0.0 },
  { "Azarya", 0.19736843 },
  { "Azaryah", 0.30054644 },
  { "Azaryia", 0.0 },
  { "Azavian", 1.0 },
  { "Azavier", 1.0 },
  { "Azavion", 1.0 },
  { "Azaya", 0.0 },
  { "Azayah", 0.36923078 },
  { "Azayla", 0.0 },
  { "Azaylah", 0.0 },
  { "Azaylea", 0.0 },
  { "Azayleah", 0.0 },
  { "Azaylee", 0.0 },
  { "Azaylia", 0.0 },
  { "Azayliah", 0.0 },
  { "Azayvion", 1.0 },
  { "Azazel", 1.0 },
  { "Azden", 1.0 },
  { "Azealia", 0.0 },
  { "Azeem", 1.0 },
  { "Azeemah", 0.0 },
  { "Azeen", 0.0 },
  { "Azeez", 1.0 },
  { "Azeeza", 0.0 },
  { "Azekiel", 1.0 },
  { "Azel", 0.82206404 },
  { "Azelea", 0.0 },
  { "Azelene", 0.0 },
  { "Azelia", 0.0 },
  { "Azelie", 0.0 },
  { "Azelin", 0.0 },
  { "Azell", 0.8064516 },
  { "Azella", 0.0 },
  { "Azelle", 0.0 },
  { "Azelya", 0.0 },
  { "Azelyn", 0.0 },
  { "Azelynn", 0.0 },
  { "Azema", 0.0 },
  { "Azena", 0.0 },
  { "Azende", 1.0 },
  { "Azenet", 0.0 },
  { "Azeneth", 0.0 },
  { "Azer", 1.0 },
  { "Azera", 0.0 },
  { "Azeria", 0.0 },
  { "Azeriah", 0.16949153 },
  { "Azerion", 1.0 },
  { "Azfar", 1.0 },
  { "Azha", 0.0 },
  { "Azhaan", 1.0 },
  { "Azhan", 1.0 },
  { "Azhanae", 0.0 },
  { "Azhane", 0.0 },
  { "Azhani", 0.0 },
  { "Azhar", 0.68014705 },
  { "Azhari", 0.0 },
  { "Azharia", 0.0 },
  { "Azhia", 0.0 },
  { "Azi", 1.0 },
  { "Azia", 0.0 },
  { "Aziah", 0.38014784 },
  { "Aziana", 0.0 },
  { "Azianna", 0.0 },
  { "Azie", 0.0 },
  { "Aziel", 0.98542273 },
  { "Azier", 1.0 },
  { "Azikiwe", 1.0 },
  { "Azilda", 0.0 },
  { "Azile", 0.0 },
  { "Azilee", 0.0 },
  { "Azilyn", 0.0 },
  { "Azilynn", 0.0 },
  { "Azim", 1.0 },
  { "Azimjon", 1.0 },
  { "Azion", 0.88461536 },
  { "Azir", 1.0 },
  { "Azira", 0.0 },
  { "Azirah", 0.0 },
  { "Aziria", 0.0 },
  { "Aziriah", 0.0 },
  { "Azita", 0.0 },
  { "Aziya", 0.0 },
  { "Aziyah", 0.03255341 },
  { "Aziz", 1.0 },
  { "Aziza", 0.0 },
  { "Azizah", 0.0 },
  { "Azizi", 0.1744186 },
  { "Azizjon", 1.0 },
  { "Azja", 0.0 },
  { "Azjah", 0.0 },
  { "Azjon", 1.0 },
  { "Azka", 0.0 },
  { "Azlaan", 1.0 },
  { "Azlan", 0.9752322 },
  { "Azlee", 0.0 },
  { "Azleigh", 0.0 },
  { "Azlin", 0.0 },
  { "Azlyn", 0.0 },
  { "Azlynn", 0.0 },
  { "Azlynne", 0.0 },
  { "Azmariah", 0.0 },
  { "Azmeer", 1.0 },
  { "Azmi", 1.0 },
  { "Azmina", 0.0 },
  { "Azmir", 1.0 },
  { "Azon", 1.0 },
  { "Azora", 0.0 },
  { "Azori", 0.0 },
  { "Azoria", 0.0 },
  { "Azoriah", 0.0 },
  { "Azra", 0.022164276 },
  { "Azrael", 0.82260185 },
  { "Azrah", 0.0 },
  { "Azreal", 1.0 },
  { "Azria", 0.0 },
  { "Azriah", 0.39285713 },
  { "Azriel", 0.75740945 },
  { "Azriela", 0.0 },
  { "Azriella", 0.0 },
  { "Azrielle", 0.0 },
  { "Azrien", 1.0 },
  { "Azryel", 1.0 },
  { "Azsa", 0.0 },
  { "Azsha", 0.0 },
  { "Azteca", 0.0 },
  { "Aztlan", 1.0 },
  { "Azucena", 0.0 },
  { "Azul", 0.02032767 },
  { "Azula", 0.0 },
  { "Azumi", 0.0 },
  { "Azur", 0.0 },
  { "Azura", 0.0 },
  { "Azurae", 0.0 },
  { "Azurah", 0.0 },
  { "Azurdee", 0.0 },
  { "Azure", 0.12834224 },
  { "Azuredee", 0.0 },
  { "Azuree", 0.0 },
  { "Azuri", 0.0 },
  { "Azuriah", 1.0 },
  { "Azurie", 0.0 },
  { "Azury", 0.0 },
  { "Azusa", 0.0 },
  { "Azusena", 0.0 },
  { "Azuzena", 0.0 },
  { "Azya", 0.0 },
  { "Azyah", 0.0 },
  { "Azyan", 1.0 },
  { "Azyia", 0.0 },
  { "Azyiah", 0.0 },
  { "Azyla", 0.0 },
  { "Azylah", 0.0 },
  { "Azyon", 1.0 },
  { "Azyra", 0.0 },
  { "Azyrah", 0.0 },
  { "Azyria", 0.0 },
  { "Azyriah", 0.0 },
  { "Azza", 0.0 },
  { "Azzahra", 0.0 },
  { "Azzam", 1.0 },
  { "Azzan", 1.0 },
  { "Azzareya", 0.0 },
  { "Azzaria", 0.0 },
  { "Azziah", 0.0 },
  { "Azzie", 0.022703819 },
  { "Azzure", 0.0625 },
  { "Baani", 0.0 },
  { "Baasil", 1.0 },
  { "Baba", 1.0 },
  { "Babacar", 1.0 },
  { "Babajide", 1.0 },
  { "Babak", 1.0 },
  { "Babara", 0.0 },
  { "Babatunde", 1.0 },
  { "Babbett", 0.0 },
  { "Babbette", 0.0 },
  { "Babbi", 0.0 },
  { "Babbie", 0.0 },
  { "Babby", 0.0 },
  { "Babe", 0.4739011 },
  { "Baber", 1.0 },
  { "Babetta", 0.0 },
  { "Babette", 0.0015285845 },
  { "Babie", 0.0 },
  { "Babita", 0.0 },
  { "Baboucarr", 1.0 },
  { "Babs", 0.0 },
  { "Baby", 0.50920707 },
  { "Babyboy", 1.0 },
  { "Babygirl", 0.0033975085 },
  { "Bacari", 1.0 },
  { "Bacarri", 1.0 },
  { "Bach", 1.0 },
  { "Bachir", 1.0 },
  { "Bacil", 1.0 },
  { "Bacilia", 0.0 },
  { "Bacilio", 1.0 },
  { "Badal", 1.0 },
  { "Baden", 1.0 },
  { "Bader", 1.0 },
  { "Badhir", 1.0 },
  { "Badi", 1.0 },
  { "Badia", 0.0 },
  { "Badr", 1.0 },
  { "Bae", 0.17857143 },
  { "Baeden", 1.0 },
  { "Baela", 0.0 },
  { "Baelee", 0.0 },
  { "Baeleigh", 0.0 },
  { "Baeley", 0.0 },
  { "Baelfire", 1.0 },
  { "Baeli", 0.0 },
  { "Baelie", 0.0 },
  { "Baelin", 1.0 },
  { "Baelor", 1.0 },
  { "Baelyn", 0.12087912 },
  { "Baelynn", 0.0 },
  { "Baer", 1.0 },
  { "Baggio", 1.0 },
  { "Bah", 0.0 },
  { "Baha", 1.0 },
  { "Bahaa", 1.0 },
  { "Bahar", 0.0 },
  { "Bahareh", 0.0 },
  { "Bahati", 0.0 },
  { "Bahe", 1.0 },
  { "Baheejah", 0.0 },
  { "Baheerah", 0.0 },
  { "Bahia", 0.0 },
  { "Bahiya", 0.0 },
  { "Bahiyah", 0.0 },
  { "Bahiyyah", 0.0 },
  { "Bahja", 0.0 },
  { "Bai", 0.5 },
  { "Baiba", 0.0 },
  { "Baiden", 1.0 },
  { "Baila", 0.0 },
  { "Bailasan", 0.0 },
  { "Baile", 0.0 },
  { "Bailea", 0.0 },
  { "Bailee", 0.016644074 },
  { "Bailei", 0.0 },
  { "Baileigh", 0.0 },
  { "Bailen", 1.0 },
  { "Bailey", 0.17892721 },
  { "Baileyann", 0.0 },
  { "Baileyrae", 0.0 },
  { "Baili", 0.0 },
  { "Bailie", 0.0 },
  { "Bailiegh", 0.0 },
  { "Baille", 0.0 },
  { "Baillee", 0.0 },
  { "Bailley", 0.0 },
  { "Baillie", 0.0 },
  { "Bailly", 0.0 },
  { "Bailor", 0.64285713 },
  { "Baily", 0.24244186 },
  { "Bailye", 0.0 },
  { "Bailyn", 0.06944445 },
  { "Bailynn", 0.0 },
  { "Bain", 1.0 },
  { "Baine", 1.0 },
  { "Bair", 1.0 },
  { "Baird", 1.0 },
  { "Bairo", 1.0 },
  { "Bairon", 1.0 },
  { "Baisha", 0.0 },
  { "Baisley", 0.0 },
  { "Baiya", 0.0 },
  { "Baize", 1.0 },
  { "Baja", 0.0 },
  { "Bakar", 1.0 },
  { "Bakari", 1.0 },
  { "Bakary", 1.0 },
  { "Baker", 0.9590643 },
  { "Bakhita", 0.0 },
  { "Bakir", 1.0 },
  { "Bakr", 1.0 },
  { "Balaji", 1.0 },
  { "Balal", 1.0 },
  { "Balam", 1.0 },
  { "Balbina", 0.0 },
  { "Baldassare", 1.0 },
  { "Baldemar", 1.0 },
  { "Baldo", 1.0 },
  { "Baldomero", 1.0 },
  { "Baldwin", 1.0 },
  { "Bale", 1.0 },
  { "Balee", 0.0 },
  { "Baleigh", 0.0 },
  { "Balen", 1.0 },
  { "Balentin", 1.0 },
  { "Baler", 1.0 },
  { "Baleria", 0.0 },
  { "Balery", 0.0 },
  { "Baley", 0.23953488 },
  { "Balfour", 1.0 },
  { "Bali", 0.0 },
  { "Balian", 1.0 },
  { "Balie", 0.0 },
  { "Baliegh", 0.0 },
  { "Balil", 1.0 },
  { "Balin", 1.0 },
  { "Balinda", 0.0 },
  { "Balint", 1.0 },
  { "Balke", 1.0 },
  { "Ballard", 1.0 },
  { "Ballarie", 0.0 },
  { "Balmore", 1.0 },
  { "Balon", 0.0 },
  { "Balqis", 0.0 },
  { "Balraj", 1.0 },
  { "Baltasar", 1.0 },
  { "Baltazar", 1.0 },
  { "Balthazar", 1.0 },
  { "Balvina", 0.0 },
  { "Balynda", 0.0 },
  { "Bam", 1.0 },
  { "Bama", 0.0 },
  { "Bambi", 0.0 },
  { "Bambie", 0.0 },
  { "Bambina", 0.0 },
  { "Bamby", 0.0 },
  { "Bamidele", 1.0 },
  { "Bamma", 0.0 },
  { "Bana", 0.0 },
  { "Banan", 1.0 },
  { "Bandar", 1.0 },
  { "Bandi", 0.0 },
  { "Bandon", 1.0 },
  { "Bandy", 0.67391306 },
  { "Bane", 1.0 },
  { "Baneen", 0.0 },
  { "Banelly", 0.0 },
  { "Banesa", 0.0 },
  { "Banessa", 0.0 },
  { "Baneza", 0.0 },
  { "Bang", 1.0 },
  { "Bangaly", 1.0 },
  { "Bani", 0.0 },
  { "Bania", 0.0 },
  { "Banisha", 0.0 },
  { "Banita", 0.0 },
  { "Banjamin", 1.0 },
  { "Banks", 1.0 },
  { "Bankston", 1.0 },
  { "Banna", 0.0 },
  { "Banner", 0.9456869 },
  { "Bannie", 0.0 },
  { "Banning", 1.0 },
  { "Bannon", 1.0 },
  { "Bansari", 0.0 },
  { "Bansi", 0.0 },
  { "Bansri", 0.0 },
  { "Banx", 1.0 },
  { "Banyan", 1.0 },
  { "Banyon", 1.0 },
  { "Bao", 0.56823266 },
  { "Baotran", 0.0 },
  { "Baptiste", 1.0 },
  { "Baqir", 1.0 },
  { "Bar", 0.425 },
  { "Bara", 1.0 },
  { "Baraa", 0.82857144 },
  { "Baraah", 0.0 },
  { "Barabara", 0.0 },
  { "Barabra", 0.0 },
  { "Barack", 1.0 },
  { "Barak", 1.0 },
  { "Baraka", 0.9268293 },
  { "Barakah", 0.0 },
  { "Barakat", 0.0 },
  { "Baran", 0.7888889 },
  { "Baranda", 0.0 },
  { "Barara", 0.0 },
  { "Barb", 0.0 },
  { "Barba", 0.0 },
  { "Barbaa", 0.0 },
  { "Barbar", 0.0 },
  { "Barbara", 0.002877878 },
  { "Barbaraa", 0.0 },
  { "Barbaraann", 0.0 },
  { "Barbaraanne", 0.0 },
  { "Barbarajean", 0.0 },
  { "Barbarajo", 0.0 },
  { "Barbaralee", 0.0 },
  { "Barbarann", 0.0 },
  { "Barbaranne", 0.0 },
  { "Barbarba", 0.0 },
  { "Barbare", 0.0 },
  { "Barbarella", 0.0 },
  { "Barbarette", 0.0 },
  { "Barbarita", 0.0 },
  { "Barbaro", 1.0 },
  { "Barbe", 0.0 },
  { "Barbee", 0.0 },
  { "Barber", 0.7826087 },
  { "Barbera", 0.0 },
  { "Barbett", 0.0 },
  { "Barbetta", 0.0 },
  { "Barbette", 0.0 },
  { "Barbi", 0.0 },
  { "Barbie", 0.0 },
  { "Barbora", 0.0 },
  { "Barbra", 0.0 },
  { "Barbro", 0.0 },
  { "Barby", 0.0 },
  { "Barclay", 0.975181 },
  { "Bard", 1.0 },
  { "Bardara", 0.0 },
  { "Bardia", 1.0 },
  { "Bardo", 1.0 },
  { "Bareera", 0.0 },
  { "Bareerah", 0.0 },
  { "Barek", 1.0 },
  { "Baren", 1.0 },
  { "Barett", 1.0 },
  { "Baretta", 0.7222222 },
  { "Bari", 0.07295466 },
  { "Bariah", 0.0 },
  { "Barika", 0.0 },
  { "Barin", 1.0 },
  { "Baris", 1.0 },
  { "Barisha", 0.0 },
  { "Barker", 1.0 },
  { "Barkim", 1.0 },
  { "Barkley", 0.98392284 },
  { "Barkon", 1.0 },
  { "Barkot", 0.47619048 },
  { "Barksdale", 1.0 },
  { "Barlow", 1.0 },
  { "Barnabas", 1.0 },
  { "Barnaby", 1.0 },
  { "Barnard", 1.0 },
  { "Barndon", 1.0 },
  { "Barnell", 0.94174755 },
  { "Barnes", 1.0 },
  { "Barnet", 1.0 },
  { "Barnett", 0.9953125 },
  { "Barnetta", 0.0 },
  { "Barnette", 0.0 },
  { "Barney", 0.9943657 },
  { "Barnie", 0.99226004 },
  { "Barnwell", 1.0 },
  { "Barny", 1.0 },
  { "Barok", 1.0 },
  { "Baron", 1.0 },
  { "Barr", 1.0 },
  { "Barre", 1.0 },
  { "Barren", 1.0 },
  { "Barret", 0.9956102 },
  { "Barrett", 0.95858335 },
  { "Barrette", 1.0 },
  { "Barri", 0.085299455 },
  { "Barrick", 1.0 },
  { "Barrie", 0.4381579 },
  { "Barrington", 1.0 },
  { "Barrion", 1.0 },
  { "Barris", 1.0 },
  { "Barron", 1.0 },
  { "Barry", 0.99576426 },
  { "Barsha", 0.0 },
  { "Bart", 0.9996941 },
  { "Barta", 0.0 },
  { "Bartek", 1.0 },
  { "Bartel", 1.0 },
  { "Barth", 1.0 },
  { "Bartha", 0.0 },
  { "Bartholome", 1.0 },
  { "Bartholomew", 1.0 },
  { "Bartie", 0.0 },
  { "Bartlett", 1.0 },
  { "Bartley", 1.0 },
  { "Bartlomiej", 1.0 },
  { "Bartly", 1.0 },
  { "Barto", 1.0 },
  { "Bartola", 0.0 },
  { "Bartolo", 1.0 },
  { "Bartolome", 1.0 },
  { "Bartolomeo", 1.0 },
  { "Barton", 1.0 },
  { "Bartosz", 1.0 },
  { "Bartow", 1.0 },
  { "Bartt", 1.0 },
  { "Bartu", 1.0 },
  { "Barty", 1.0 },
  { "Baruc", 1.0 },
  { "Baruch", 1.0 },
  { "Baruti", 1.0 },
  { "Bary", 1.0 },
  { "Baryn", 1.0 },
  { "Bas", 0.0 },
  { "Bascom", 1.0 },
  { "Bascomb", 1.0 },
  { "Bascum", 1.0 },
  { "Baseemah", 0.0 },
  { "Basel", 1.0 },
  { "Basem", 1.0 },
  { "Bash", 1.0 },
  { "Basha", 0.0 },
  { "Bashan", 1.0 },
  { "Bashar", 1.0 },
  { "Bashawn", 1.0 },
  { "Basheba", 0.0 },
  { "Basheer", 1.0 },
  { "Bashir", 1.0 },
  { "Bashira", 0.0 },
  { "Bashirah", 0.0 },
  { "Bashiri", 1.0 },
  { "Bashy", 0.0 },
  { "Basia", 0.0 },
  { "Basil", 0.9885547 },
  { "Basile", 1.0 },
  { "Basilia", 0.0 },
  { "Basiliki", 0.0 },
  { "Basilio", 1.0 },
  { "Basilios", 1.0 },
  { "Basilisa", 0.0 },
  { "Basim", 1.0 },
  { "Basimah", 0.0 },
  { "Basir", 1.0 },
  { "Basit", 1.0 },
  { "Basma", 0.0 },
  { "Basmah", 0.0 },
  { "Bass", 1.0 },
  { "Bassam", 1.0 },
  { "Bassel", 1.0 },
  { "Bassem", 1.0 },
  { "Bassey", 1.0 },
  { "Bassheva", 0.0 },
  { "Bassil", 1.0 },
  { "Bassirou", 1.0 },
  { "Bassy", 0.0 },
  { "Bastian", 1.0 },
  { "Bastien", 1.0 },
  { "Bastion", 1.0 },
  { "Basya", 0.0 },
  { "Batel", 0.0 },
  { "Bates", 1.0 },
  { "Bathsheba", 0.0 },
  { "Batina", 0.0 },
  { "Batool", 0.0 },
  { "Batoul", 0.0 },
  { "Batrice", 0.0 },
  { "Batrina", 0.0 },
  { "Batsheva", 0.0 },
  { "Battal", 1.0 },
  { "Battista", 1.0 },
  { "Battle", 1.0 },
  { "Batu", 1.0 },
  { "Batuhan", 1.0 },
  { "Batul", 0.0 },
  { "Batula", 0.0 },
  { "Batya", 0.0 },
  { "Baudel", 1.0 },
  { "Baudelia", 0.0 },
  { "Baudelio", 1.0 },
  { "Baudilio", 1.0 },
  { "Bauer", 1.0 },
  { "Bautista", 1.0 },
  { "Bavan", 0.0 },
  { "Bavly", 1.0 },
  { "Bawi", 0.83125 },
  { "Baxlee", 0.0 },
  { "Baxley", 0.42553192 },
  { "Baxter", 1.0 },
  { "Baxton", 1.0 },
  { "Bay", 0.30208334 },
  { "Baya", 0.0 },
  { "Bayah", 0.0 },
  { "Bayan", 0.13068181 },
  { "Bayani", 1.0 },
  { "Bayard", 1.0 },
  { "Bayardo", 1.0 },
  { "Bayden", 0.979661 },
  { "Baye", 0.0 },
  { "Bayete", 1.0 },
  { "Bayla", 0.0 },
  { "Baylaa", 0.0 },
  { "Baylan", 1.0 },
  { "Bayle", 0.1124498 },
  { "Baylea", 0.0 },
  { "Baylee", 0.032636248 },
  { "Bayleen", 0.0 },
  { "Baylei", 0.0 },
  { "Bayleigh", 0.0 },
  { "Baylen", 0.87819254 },
  { "Bayler", 0.7318008 },
  { "Bayless", 1.0 },
  { "Bayley", 0.18954249 },
  { "Bayli", 0.0 },
  { "Baylian", 1.0 },
  { "Baylie", 0.008049536 },
  { "Bayliegh", 0.0 },
  { "Baylin", 0.5795148 },
  { "Baylon", 1.0 },
  { "Baylor", 0.7312132 },
  { "Bayly", 0.17741935 },
  { "Baylyn", 0.0 },
  { "Baylynn", 0.0 },
  { "Baynard", 1.0 },
  { "Bayne", 1.0 },
  { "Bayoleth", 0.0 },
  { "Bayro", 1.0 },
  { "Bayron", 1.0 },
  { "Bayshawn", 1.0 },
  { "Bayyinah", 0.0 },
  { "Bayze", 1.0 },
  { "Baze", 1.0 },
  { "Bazel", 1.0 },
  { "Bazil", 1.0 },
  { "Bb", 1.0 },
  { "Be", 1.0 },
  { "Bea", 0.0 },
  { "Beach", 1.0 },
  { "Beacher", 1.0 },
  { "Beadie", 0.0 },
  { "Beah", 0.0 },
  { "Beal", 1.0 },
  { "Beale", 1.0 },
  { "Beaman", 1.0 },
  { "Beamon", 1.0 },
  { "Bean", 1.0 },
  { "Beanca", 0.0 },
  { "Beandon", 1.0 },
  { "Beaney", 0.0 },
  { "Beanna", 0.0 },
  { "Beaonca", 0.0 },
  { "Bear", 1.0 },
  { "Bearett", 1.0 },
  { "Bearl", 1.0 },
  { "Bearnice", 0.0 },
  { "Beasia", 0.0 },
  { "Beasley", 1.0 },
  { "Beata", 0.0 },
  { "Beate", 0.0 },
  { "Beatha", 0.0 },
  { "Beather", 0.0 },
  { "Beathrice", 0.0 },
  { "Beatric", 0.0 },
  { "Beatrica", 0.0 },
  { "Beatrice", 0.0038430283 },
  { "Beatris", 0.0 },
  { "Beatrix", 0.0 },
  { "Beatriz", 0.0030558119 },
  { "Beatrize", 0.0 },
  { "Beatryce", 0.0 },
  { "Beatta", 0.0 },
  { "Beattie", 1.0 },
  { "Beatty", 1.0 },
  { "Beau", 0.98412746 },
  { "Beauden", 1.0 },
  { "Beauen", 1.0 },
  { "Beauford", 0.9902057 },
  { "Beaufort", 1.0 },
  { "Beaula", 0.0 },
  { "Beaulah", 0.0 },
  { "Beaumont", 1.0 },
  { "Beauregard", 1.0 },
  { "Beautiful", 0.0 },
  { "Beautifull", 0.0 },
  { "Beauton", 0.0 },
  { "Beautrice", 0.0 },
  { "Beauty", 0.0 },
  { "Beautyful", 0.0 },
  { "Beaux", 0.90672016 },
  { "Beaver", 1.0 },
  { "Bebe", 0.0 },
  { "Beca", 0.0 },
  { "Becca", 0.0 },
  { "Becci", 0.0 },
  { "Beck", 1.0 },
  { "Becka", 0.0 },
  { "Beckah", 0.0 },
  { "Beckam", 1.0 },
  { "Beckem", 1.0 },
  { "Becker", 1.0 },
  { "Becket", 1.0 },
  { "Beckett", 0.96387523 },
  { "Beckette", 0.5 },
  { "Beckey", 0.0 },
  { "Beckham", 0.99087864 },
  { "Beckhem", 1.0 },
  { "Becki", 0.0 },
  { "Beckie", 0.0 },
  { "Beckley", 0.2173913 },
  { "Becklyn", 0.0 },
  { "Beckman", 1.0 },
  { "Beckum", 1.0 },
  { "Becky", 0.0016612828 },
  { "Beda", 0.0 },
  { "Bedar", 0.0 },
  { "Beddie", 0.0 },
  { "Bedelia", 0.0 },
  { "Bedell", 0.0 },
  { "Bedford", 1.0 },
  { "Bedie", 0.0 },
  { "Bee", 0.6245421 },
  { "Beebe", 0.1388889 },
  { "Beecher", 1.0 },
  { "Beedie", 0.0 },
  { "Beena", 0.0 },
  { "Beenish", 0.0 },
  { "Beesan", 0.0 },
  { "Beeta", 0.0 },
  { "Begum", 0.0 },
  { "Behati", 0.0 },
  { "Behnam", 1.0 },
  { "Behr", 1.0 },
  { "Behrang", 1.0 },
  { "Behrett", 1.0 },
  { "Behruz", 1.0 },
  { "Behtzy", 0.0 },
  { "Beige", 0.0 },
  { "Beighley", 0.0 },
  { "Beija", 0.0 },
  { "Beila", 0.0 },
  { "Beily", 0.0 },
  { "Beira", 0.0 },
  { "Bejamin", 1.0 },
  { "Bejan", 1.0 },
  { "Bek", 1.0 },
  { "Beka", 1.0 },
  { "Bekah", 0.0 },
  { "Bekam", 1.0 },
  { "Bekett", 1.0 },
  { "Bekham", 1.0 },
  { "Beki", 0.0 },
  { "Bekim", 1.0 },
  { "Bekka", 0.0 },
  { "Bekki", 0.0 },
  { "Bela", 0.4467881 },
  { "Belah", 0.0 },
  { "Belal", 1.0 },
  { "Belana", 0.0 },
  { "Belanna", 0.0 },
  { "Belany", 0.0 },
  { "Belarmino", 1.0 },
  { "Belden", 1.0 },
  { "Beldon", 1.0 },
  { "Belem", 0.0 },
  { "Belen", 0.0068552773 },
  { "Belenda", 0.0 },
  { "Beleta", 0.0 },
  { "Belford", 1.0 },
  { "Belgica", 0.0 },
  { "Belia", 0.0 },
  { "Belicia", 0.0 },
  { "Believe", 0.0 },
  { "Belina", 0.0 },
  { "Belinda", 0.0020874504 },
  { "Belisa", 0.0 },
  { "Belisario", 1.0 },
  { "Belissa", 0.0 },
  { "Belita", 0.0 },
  { "Beliz", 0.0 },
  { "Belize", 0.0 },
  { "Belkis", 0.0 },
  { "Belky", 0.0 },
  { "Belkys", 0.0 },
  { "Bell", 0.050801095 },
  { "Bella", 0.0006442444 },
  { "Bellaann", 0.0 },
  { "Belladonna", 0.0 },
  { "Bellagrace", 0.0 },
  { "Bellah", 0.0 },
  { "Bellaluna", 0.0 },
  { "Bellalynn", 0.0 },
  { "Bellamae", 0.0 },
  { "Bellamarie", 0.0 },
  { "Bellamay", 0.0 },
  { "Bellamee", 0.0 },
  { "Bellami", 0.0 },
  { "Bellamia", 0.0 },
  { "Bellamie", 0.0 },
  { "Bellamy", 0.09081197 },
  { "Bellani", 0.0 },
  { "Bellanie", 0.0 },
  { "Bellanira", 0.0 },
  { "Bellany", 0.0 },
  { "Bellarae", 0.0 },
  { "Bellarose", 0.0 },
  { "Bellasophia", 0.0 },
  { "Bellatrix", 0.0 },
  { "Belle", 0.0 },
  { "Bellemy", 0.0 },
  { "Bellicia", 0.0 },
  { "Bellina", 0.0 },
  { "Bellinda", 0.0 },
  { "Bellissa", 0.0 },
  { "Belma", 0.0 },
  { "Belmaris", 0.0 },
  { "Belmeda", 0.0 },
  { "Belmin", 1.0 },
  { "Belmira", 0.0 },
  { "Belmont", 1.0 },
  { "Belon", 0.0 },
  { "Beloved", 0.0 },
  { "Belsy", 0.0 },
  { "Belton", 1.0 },
  { "Belua", 0.0 },
  { "Belva", 0.0 },
  { "Belverly", 0.0 },
  { "Belvia", 0.0 },
  { "Belvie", 0.0 },
  { "Belvin", 0.9834123 },
  { "Belynda", 0.0 },
  { "Belzora", 0.0 },
  { "Bemjamin", 1.0 },
  { "Bemnet", 0.3918919 },
  { "Ben", 0.9944232 },
  { "Bena", 0.0 },
  { "Benae", 0.0 },
  { "Benaiah", 1.0 },
  { "Benajamin", 1.0 },
  { "Benajmin", 1.0 },
  { "Benancia", 0.0 },
  { "Benancio", 1.0 },
  { "Benaniah", 1.0 },
  { "Benard", 1.0 },
  { "Benardo", 1.0 },
  { "Benas", 1.0 },
  { "Benay", 0.0 },
  { "Bence", 1.0 },
  { "Benda", 0.0 },
  { "Bendetta", 0.0 },
  { "Bendrick", 1.0 },
  { "Bene", 0.0 },
  { "Benecia", 0.0 },
  { "Benecio", 1.0 },
  { "Benedek", 1.0 },
  { "Benedetta", 0.0 },
  { "Benedetto", 1.0 },
  { "Benedict", 1.0 },
  { "Benedicta", 0.0 },
  { "Benedicte", 0.0 },
  { "Benedicto", 1.0 },
  { "Benedikt", 1.0 },
  { "Benee", 0.0 },
  { "Benelli", 0.0 },
  { "Benen", 1.0 },
  { "Benesha", 0.0 },
  { "Benessa", 0.0 },
  { "Benet", 0.64912283 },
  { "Beneta", 0.0 },
  { "Benett", 1.0 },
  { "Benetta", 0.0 },
  { "Benette", 0.0 },
  { "Beneva", 0.0 },
  { "Benford", 1.0 },
  { "Bengamin", 1.0 },
  { "Bengi", 1.0 },
  { "Bengie", 1.0 },
  { "Bengiman", 1.0 },
  { "Bengt", 1.0 },
  { "Bengy", 1.0 },
  { "Benham", 1.0 },
  { "Benhamin", 1.0 },
  { "Benhard", 1.0 },
  { "Benhart", 1.0 },
  { "Benhur", 1.0 },
  { "Beni", 0.67346936 },
  { "Beniah", 1.0 },
  { "Beniamin", 1.0 },
  { "Benica", 0.0 },
  { "Benicia", 0.0 },
  { "Benicio", 1.0 },
  { "Benie", 1.0 },
  { "Benigna", 0.0 },
  { "Benigno", 1.0 },
  { "Benika", 0.0 },
  { "Benilda", 0.0 },
  { "Benilde", 0.0 },
  { "Benina", 0.0 },
  { "Benino", 1.0 },
  { "Benisha", 0.0 },
  { "Benita", 0.0 },
  { "Benitez", 1.0 },
  { "Benito", 0.99769294 },
  { "Benjahmin", 1.0 },
  { "Benjain", 1.0 },
  { "Benjaman", 1.0 },
  { "Benjamen", 1.0 },
  { "Benjamim", 1.0 },
  { "Benjamin", 0.99670476 },
  { "Benjamine", 1.0 },
  { "Benjaminjoseph", 1.0 },
  { "Benjammin", 1.0 },
  { "Benjamon", 1.0 },
  { "Benjamyn", 1.0 },
  { "Benje", 1.0 },
  { "Benjeman", 1.0 },
  { "Benjemin", 1.0 },
  { "Benjerman", 1.0 },
  { "Benjermen", 1.0 },
  { "Benjermin", 1.0 },
  { "Benji", 0.9674064 },
  { "Benjiam", 1.0 },
  { "Benjie", 0.96691567 },
  { "Benjiman", 1.0 },
  { "Benjimen", 1.0 },
  { "Benjimin", 1.0 },
  { "Benjmain", 1.0 },
  { "Benjman", 1.0 },
  { "Benjy", 1.0 },
  { "Benley", 1.0 },
  { "Benn", 1.0 },
  { "Benna", 0.0 },
  { "Bennard", 1.0 },
  { "Benne", 0.0 },
  { "Benner", 1.0 },
  { "Bennet", 0.97590363 },
  { "Bennett", 0.97284526 },
  { "Bennetta", 0.0 },
  { "Bennette", 0.32967034 },
  { "Benney", 1.0 },
  { "Benni", 0.0 },
  { "Bennie", 0.8432199 },
  { "Benning", 1.0 },
  { "Bennington", 1.0 },
  { "Bennit", 1.0 },
  { "Bennita", 0.0 },
  { "Bennjamin", 1.0 },
  { "Benno", 1.0 },
  { "Benny", 0.98795766 },
  { "Bennye", 0.0 },
  { "Beno", 1.0 },
  { "Benoit", 1.0 },
  { "Bensen", 1.0 },
  { "Bensley", 1.0 },
  { "Benson", 0.9994237 },
  { "Bensyn", 1.0 },
  { "Bente", 0.0 },
  { "Bentely", 1.0 },
  { "Benten", 1.0 },
  { "Bentlea", 0.0 },
  { "Bentlee", 0.8002624 },
  { "Bentlei", 0.5416667 },
  { "Bentleigh", 0.12958436 },
  { "Bentley", 0.9418058 },
  { "Bentli", 0.3 },
  { "Bentlie", 0.3626943 },
  { "Bently", 0.9671973 },
  { "Bento", 1.0 },
  { "Benton", 1.0 },
  { "Bentura", 0.8958333 },
  { "Bentyn", 1.0 },
  { "Bentz", 1.0 },
  { "Bentzion", 1.0 },
  { "Benuel", 1.0 },
  { "Benvinda", 0.0 },
  { "Beny", 1.0 },
  { "Benyam", 1.0 },
  { "Benyamin", 1.0 },
  { "Benz", 1.0 },
  { "Benzel", 1.0 },
  { "Benzino", 1.0 },
  { "Benzion", 1.0 },
  { "Beola", 0.0 },
  { "Beonca", 0.0 },
  { "Beonce", 0.0 },
  { "Beonica", 0.0 },
  { "Beonka", 0.0 },
  { "Beorn", 1.0 },
  { "Beowulf", 1.0 },
  { "Ber", 1.0 },
  { "Bera", 0.062176164 },
  { "Beranda", 0.0 },
  { "Berania", 0.0 },
  { "Berat", 1.0 },
  { "Berchie", 0.0 },
  { "Berchman", 1.0 },
  { "Berda", 0.0 },
  { "Berdean", 0.0 },
  { "Berdeen", 0.0 },
  { "Berdell", 0.38174275 },
  { "Berdella", 0.0 },
  { "Berdena", 0.0 },
  { "Berdene", 0.0 },
  { "Berdia", 0.0 },
  { "Berdie", 0.0 },
  { "Berdina", 0.0 },
  { "Berdine", 0.0 },
  { "Berdyne", 0.0 },
  { "Berea", 0.0 },
  { "Berek", 1.0 },
  { "Bereket", 1.0 },
  { "Berel", 1.0 },
  { "Beren", 0.81005585 },
  { "Berend", 1.0 },
  { "Berenda", 0.0 },
  { "Berenger", 1.0 },
  { "Berenice", 0.0012200533 },
  { "Berenis", 0.0 },
  { "Berenise", 0.0 },
  { "Berenisse", 0.0 },
  { "Bereniz", 0.0 },
  { "Berenize", 0.0 },
  { "Beresford", 1.0 },
  { "Beret", 0.0 },
  { "Beretta", 0.0 },
  { "Berg", 1.0 },
  { "Bergan", 0.0 },
  { "Berge", 1.0 },
  { "Bergen", 0.43376625 },
  { "Berger", 1.0 },
  { "Bergetta", 0.0 },
  { "Bergin", 0.0 },
  { "Beri", 0.0 },
  { "Beric", 1.0 },
  { "Beril", 1.0 },
  { "Berina", 0.0 },
  { "Berinda", 0.0 },
  { "Berish", 1.0 },
  { "Berit", 0.0 },
  { "Berita", 0.0 },
  { "Berj", 1.0 },
  { "Berk", 1.0 },
  { "Berkay", 1.0 },
  { "Berke", 1.0 },
  { "Berkeley", 0.38708088 },
  { "Berklee", 0.019503547 },
  { "Berkleigh", 0.0 },
  { "Berkley", 0.39888123 },
  { "Berkli", 0.0 },
  { "Berklie", 0.0 },
  { "Berkly", 0.0 },
  { "Berl", 0.99464667 },
  { "Berla", 0.0 },
  { "Berle", 0.96783626 },
  { "Berlena", 0.0 },
  { "Berlene", 0.0 },
  { "Berley", 1.0 },
  { "Berlie", 0.64726025 },
  { "Berlin", 0.5243991 },
  { "Berlina", 0.0 },
  { "Berlinda", 0.0 },
  { "Berline", 0.0 },
  { "Berlon", 1.0 },
  { "Berlyn", 0.100367196 },
  { "Berlynn", 0.0 },
  { "Berma", 0.0 },
  { "Berman", 1.0 },
  { "Bern", 1.0 },
  { "Berna", 0.0 },
  { "Bernabe", 1.0 },
  { "Bernace", 0.0 },
  { "Bernadean", 0.0 },
  { "Bernadeen", 0.0 },
  { "Bernadene", 0.0 },
  { "Bernadet", 0.0 },
  { "Bernadett", 0.0 },
  { "Bernadetta", 0.0 },
  { "Bernadette", 0.0011243114 },
  { "Bernadina", 0.0 },
  { "Bernadine", 0.0 },
  { "Bernadino", 1.0 },
  { "Bernado", 1.0 },
  { "Bernadyne", 0.0 },
  { "Bernal", 1.0 },
  { "Bernaldo", 1.0 },
  { "Bernalee", 0.0 },
  { "Bernando", 1.0 },
  { "Bernard", 0.9950736 },
  { "Bernarda", 0.0 },
  { "Bernardette", 0.0 },
  { "Bernardina", 0.0 },
  { "Bernardine", 0.0 },
  { "Bernardino", 1.0 },
  { "Bernardita", 0.0 },
  { "Bernardo", 1.0 },
  { "Bernarr", 1.0 },
  { "Bernasia", 0.0 },
  { "Bernave", 1.0 },
  { "Bernay", 0.0 },
  { "Bernd", 1.0 },
  { "Bernda", 0.0 },
  { "Berne", 1.0 },
  { "Bernece", 0.0 },
  { "Berneda", 0.0 },
  { "Bernedette", 0.0 },
  { "Berneice", 0.0 },
  { "Berneil", 0.0 },
  { "Berneita", 0.0 },
  { "Bernel", 1.0 },
  { "Bernelda", 0.0 },
  { "Bernell", 0.67419636 },
  { "Bernella", 0.0 },
  { "Bernelle", 0.0 },
  { "Bernerd", 1.0 },
  { "Bernese", 0.0 },
  { "Bernesha", 0.0 },
  { "Bernessa", 0.0 },
  { "Bernessia", 0.0 },
  { "Bernest", 1.0 },
  { "Bernestine", 0.0 },
  { "Bernet", 1.0 },
  { "Berneta", 0.0 },
  { "Bernetha", 0.0 },
  { "Bernett", 0.33766234 },
  { "Bernetta", 0.0 },
  { "Bernette", 0.0 },
  { "Berney", 1.0 },
  { "Bernhard", 1.0 },
  { "Bernhardt", 1.0 },
  { "Bernhart", 1.0 },
  { "Berni", 0.0 },
  { "Bernia", 0.0 },
  { "Bernice", 0.018381042 },
  { "Bernicia", 0.0 },
  { "Bernida", 0.0 },
  { "Bernie", 0.85596246 },
  { "Berniece", 0.0 },
  { "Bernina", 0.0 },
  { "Bernis", 0.8 },
  { "Bernise", 0.0 },
  { "Bernisha", 0.0 },
  { "Bernistine", 0.0 },
  { "Bernita", 0.0 },
  { "Bernitha", 0.0 },
  { "Bernitta", 0.0 },
  { "Berniya", 0.0 },
  { "Bernnadette", 0.0 },
  { "Bernon", 1.0 },
  { "Bernt", 1.0 },
  { "Berny", 1.0 },
  { "Bernyce", 0.0 },
  { "Beronica", 0.0 },
  { "Berra", 0.0 },
  { "Berrett", 1.0 },
  { "Berri", 0.0 },
  { "Berrie", 0.0 },
  { "Berrin", 1.0 },
  { "Berry", 0.9422917 },
  { "Berryman", 1.0 },
  { "Bersain", 1.0 },
  { "Bert", 0.98075795 },
  { "Berta", 0.0 },
  { "Berte", 0.0 },
  { "Berteal", 0.0 },
  { "Bertel", 1.0 },
  { "Bertell", 1.0 },
  { "Bertella", 0.0 },
  { "Bertelle", 0.0 },
  { "Berten", 1.0 },
  { "Bertena", 0.0 },
  { "Berth", 0.0 },
  { "Bertha", 0.0044888426 },
  { "Berthal", 0.73913044 },
  { "Berthalee", 0.0 },
  { "Berthamae", 0.0 },
  { "Berthe", 0.0 },
  { "Berthel", 0.67741936 },
  { "Berthella", 0.0 },
  { "Berthena", 0.0 },
  { "Berthenia", 0.0 },
  { "Berther", 0.0 },
  { "Berthia", 0.0 },
  { "Berthina", 0.0 },
  { "Berthine", 0.0 },
  { "Berthol", 1.0 },
  { "Berthold", 1.0 },
  { "Bertia", 0.0 },
  { "Bertice", 0.20091324 },
  { "Bertie", 0.0590467 },
  { "Bertil", 1.0 },
  { "Bertile", 0.0 },
  { "Bertilla", 0.0 },
  { "Bertille", 0.0 },
  { "Bertin", 1.0 },
  { "Bertina", 0.0 },
  { "Bertine", 0.0 },
  { "Bertis", 0.95991564 },
  { "Berto", 1.0 },
  { "Berton", 1.0 },
  { "Bertram", 1.0 },
  { "Bertran", 1.0 },
  { "Bertrand", 1.0 },
  { "Bertrice", 0.0 },
  { "Bertrum", 1.0 },
  { "Bertus", 1.0 },
  { "Bervin", 1.0 },
  { "Berwick", 1.0 },
  { "Berwin", 1.0 },
  { "Berwyn", 1.0 },
  { "Beryl", 0.1887508 },
  { "Beryle", 0.14596273 },
  { "Besa", 0.0 },
  { "Besan", 0.0 },
  { "Besart", 1.0 },
  { "Beshoy", 1.0 },
  { "Besiana", 0.0 },
  { "Besim", 1.0 },
  { "Besma", 0.0 },
  { "Besnik", 1.0 },
  { "Bess", 0.0006997901 },
  { "Besse", 0.0 },
  { "Bessie", 0.0043162266 },
  { "Bessiemae", 0.0 },
  { "Bessy", 0.0 },
  { "Bessye", 0.0 },
  { "Besty", 0.0 },
  { "Beta", 0.0 },
  { "Betania", 0.0 },
  { "Betanya", 0.0 },
  { "Betel", 0.0 },
  { "Beth", 0.002039203 },
  { "Betha", 0.0 },
  { "Bethal", 0.0 },
  { "Bethan", 0.0 },
  { "Bethanee", 0.0 },
  { "Bethaney", 0.0 },
  { "Bethani", 0.0 },
  { "Bethania", 0.0 },
  { "Bethanie", 0.0 },
  { "Bethann", 0.0 },
  { "Bethanne", 0.0 },
  { "Bethanni", 0.0 },
  { "Bethannie", 0.0 },
  { "Bethanny", 0.0 },
  { "Bethany", 0.0019029889 },
  { "Bethanya", 0.0 },
  { "Bethanye", 0.0 },
  { "Bethe", 0.0 },
  { "Bethea", 0.0 },
  { "Bethel", 0.17443688 },
  { "Bethellen", 0.0 },
  { "Bethena", 0.0 },
  { "Bethene", 0.0 },
  { "Bethenia", 0.0 },
  { "Bethenny", 0.0 },
  { "Betheny", 0.0 },
  { "Bethia", 0.0 },
  { "Bethie", 0.0 },
  { "Bethina", 0.0 },
  { "Bethine", 0.0 },
  { "Bethlehem", 0.0 },
  { "Bethlyn", 0.0 },
  { "Bethney", 0.0 },
  { "Bethony", 0.0 },
  { "Bethsaida", 0.0 },
  { "Bethsheba", 0.0 },
  { "Bethsy", 0.0 },
  { "Bethy", 0.0 },
  { "Bethyl", 0.0 },
  { "Bethzabel", 0.0 },
  { "Bethzabeth", 0.0 },
  { "Bethzaida", 0.0 },
  { "Bethzaira", 0.0 },
  { "Bethzi", 0.0 },
  { "Bethzy", 0.0 },
  { "Betim", 1.0 },
  { "Betina", 0.0 },
  { "Beto", 1.0 },
  { "Betony", 0.0 },
  { "Betrice", 0.0 },
  { "Betrina", 0.0 },
  { "Betsabe", 0.0 },
  { "Betsabet", 0.0 },
  { "Betsabeth", 0.0 },
  { "Betsaida", 0.0 },
  { "Betsayda", 0.0 },
  { "Betselot", 0.0 },
  { "Betsey", 0.0 },
  { "Betsi", 0.0 },
  { "Betsie", 0.0 },
  { "Betsua", 0.0 },
  { "Betsy", 0.00020742585 },
  { "Betsye", 0.0 },
  { "Bett", 0.0 },
  { "Betta", 0.0 },
  { "Bette", 0.0006313494 },
  { "Betteann", 0.0 },
  { "Bettee", 0.0 },
  { "Bettejane", 0.0 },
  { "Bettejean", 0.0 },
  { "Bettejo", 0.0 },
  { "Bettelou", 0.0 },
  { "Bettey", 0.0 },
  { "Betti", 0.0 },
  { "Bettiann", 0.0 },
  { "Bettianne", 0.0 },
  { "Bettie", 0.0021618523 },
  { "Bettijane", 0.0 },
  { "Bettilou", 0.0 },
  { "Bettina", 0.0 },
  { "Bettine", 0.0 },
  { "Bettsy", 0.0 },
  { "Betty", 0.003608557 },
  { "Bettyann", 0.0 },
  { "Bettyanne", 0.0 },
  { "Bettye", 0.0020463252 },
  { "Bettyjane", 0.0 },
  { "Bettyjean", 0.0 },
  { "Bettyjo", 0.0 },
  { "Bettylee", 0.0 },
  { "Bettylou", 0.0 },
  { "Bettylu", 0.0 },
  { "Bettymae", 0.0 },
  { "Bettymarie", 0.0 },
  { "Bettzy", 0.0 },
  { "Betul", 0.0 },
  { "Bety", 0.0 },
  { "Betzabe", 0.0 },
  { "Betzabel", 0.0 },
  { "Betzabet", 0.0 },
  { "Betzabeth", 0.0 },
  { "Betzaida", 0.0 },
  { "Betzaira", 0.0 },
  { "Betzalel", 1.0 },
  { "Betzayda", 0.0 },
  { "Betzayra", 0.0 },
  { "Betzhy", 0.0 },
  { "Betzi", 0.0 },
  { "Betzy", 0.0 },
  { "Beuford", 1.0 },
  { "Beula", 0.0 },
  { "Beulah", 0.002906025 },
  { "Beuna", 0.0 },
  { "Beunca", 0.0 },
  { "Beunka", 0.0 },
  { "Bev", 0.0049850447 },
  { "Beva", 0.0 },
  { "Bevan", 0.89144737 },
  { "Bevely", 0.090277776 },
  { "Bevelyn", 0.0 },
  { "Bevereley", 0.0 },
  { "Beverely", 0.0 },
  { "Beverle", 0.0 },
  { "Beverlee", 0.0 },
  { "Beverley", 0.029688902 },
  { "Beverli", 0.0 },
  { "Beverlie", 0.0 },
  { "Beverlin", 0.0 },
  { "Beverly", 0.0121478615 },
  { "Beverlyann", 0.0 },
  { "Beverlye", 0.0 },
  { "Beverlyn", 0.0 },
  { "Bevery", 0.0 },
  { "Bevie", 0.0 },
  { "Bevin", 0.11305872 },
  { "Bevis", 1.0 },
  { "Bevon", 1.0 },
  { "Bevyn", 0.0 },
  { "Bex", 1.0 },
  { "Bexar", 1.0 },
  { "Bexlee", 0.0 },
  { "Bexleigh", 0.0 },
  { "Bexley", 0.06861314 },
  { "Bexli", 0.0 },
  { "Bexlie", 0.0 },
  { "Bexton", 1.0 },
  { "Beya", 0.0 },
  { "Beyah", 0.0 },
  { "Beyan", 1.0 },
  { "Beyanka", 0.0 },
  { "Beyda", 0.0 },
  { "Beyla", 0.0 },
  { "Beyonca", 0.0 },
  { "Beyonce", 0.0 },
  { "Beyoncee", 0.0 },
  { "Beyonka", 0.0 },
  { "Beyounce", 0.0 },
  { "Beyunka", 0.0 },
  { "Beyza", 0.0 },
  { "Beza", 0.0 },
  { "Bezaleel", 1.0 },
  { "Bezalel", 1.0 },
  { "Bezawit", 0.0 },
  { "Bg", 0.0 },
  { "Bhakti", 0.0 },
  { "Bharat", 1.0 },
  { "Bharath", 1.0 },
  { "Bhargav", 1.0 },
  { "Bhargava", 1.0 },
  { "Bhargavi", 0.0 },
  { "Bhavana", 0.0 },
  { "Bhavani", 0.0 },
  { "Bhavesh", 1.0 },
  { "Bhavi", 0.0 },
  { "Bhavik", 1.0 },
  { "Bhavika", 0.0 },
  { "Bhavin", 1.0 },
  { "Bhavini", 0.0 },
  { "Bhavna", 0.0 },
  { "Bhavya", 0.19944598 },
  { "Bhoomi", 0.0 },
  { "Bhoomika", 0.0 },
  { "Bhrianna", 0.0 },
  { "Bhumi", 0.0 },
  { "Bhumika", 0.0 },
  { "Bhuvan", 1.0 },
  { "Bhuvi", 0.0 },
  { "Bia", 0.0 },
  { "Biaca", 0.0 },
  { "Biafra", 0.0 },
  { "Biaggio", 1.0 },
  { "Biagio", 1.0 },
  { "Biak", 0.17142858 },
  { "Biana", 0.0 },
  { "Bianaca", 0.0 },
  { "Bianca", 0.0027338876 },
  { "Biancamarie", 0.0 },
  { "Biancca", 0.0 },
  { "Biance", 0.0 },
  { "Biancha", 0.0 },
  { "Biancia", 0.0 },
  { "Bianco", 0.1125 },
  { "Bianet", 0.0 },
  { "Bianeth", 0.0 },
  { "Bianey", 0.0 },
  { "Bianica", 0.0 },
  { "Bianka", 0.0 },
  { "Biankah", 0.0 },
  { "Bianna", 0.0 },
  { "Biannca", 0.0 },
  { "Bianney", 0.0 },
  { "Bianny", 0.0 },
  { "Biatris", 0.0 },
  { "Biatriz", 0.0 },
  { "Biaunca", 0.0 },
  { "Bibb", 1.0 },
  { "Bibek", 1.0 },
  { "Bibi", 0.0 },
  { "Bibian", 0.0 },
  { "Bibiana", 0.0 },
  { "Bibianna", 0.0 },
  { "Bibiano", 1.0 },
  { "Bicente", 1.0 },
  { "Bich", 0.0 },
  { "Bictor", 1.0 },
  { "Bidal", 1.0 },
  { "Biddie", 0.0 },
  { "Biddy", 0.0 },
  { "Bidwell", 1.0 },
  { "Biel", 1.0 },
  { "Bielka", 0.0 },
  { "Bienvenida", 0.0 },
  { "Bienvenido", 1.0 },
  { "Biff", 1.0 },
  { "Biftu", 0.0 },
  { "Bige", 1.0 },
  { "Bihaan", 1.0 },
  { "Bijal", 0.0 },
  { "Bijan", 0.97091275 },
  { "Bijon", 0.8 },
  { "Bijou", 0.0 },
  { "Bijoux", 0.0 },
  { "Biju", 1.0 },
  { "Biko", 1.0 },
  { "Bikram", 1.0 },
  { "Bilaal", 1.0 },
  { "Bilal", 0.9988548 },
  { "Bilan", 0.0 },
  { "Bilbo", 1.0 },
  { "Bilen", 0.0 },
  { "Bilguun", 1.0 },
  { "Bilinda", 0.0 },
  { "Biljana", 0.0 },
  { "Bill", 0.9955514 },
  { "Billa", 0.0 },
  { "Billal", 1.0 },
  { "Bille", 0.4509804 },
  { "Billee", 0.008250825 },
  { "Billey", 1.0 },
  { "Billi", 0.0028968714 },
  { "Billie", 0.23764628 },
  { "Billiejean", 0.0 },
  { "Billiejo", 0.0 },
  { "Billiejoe", 0.0 },
  { "Billijo", 0.0 },
  { "Billion", 1.0 },
  { "Billison", 1.0 },
  { "Billy", 0.98618674 },
  { "Billye", 0.032258064 },
  { "Billyjack", 1.0 },
  { "Billyjo", 0.43589744 },
  { "Billyjoe", 1.0 },
  { "Billyray", 1.0 },
  { "Bilma", 0.0 },
  { "Bilol", 1.0 },
  { "Bilon", 0.0 },
  { "Bilqis", 0.0 },
  { "Bily", 1.0 },
  { "Bimal", 1.0 },
  { "Bimbo", 1.0 },
  { "Bin", 1.0 },
  { "Bina", 0.0 },
  { "Binaca", 0.0 },
  { "Binah", 0.0 },
  { "Binca", 0.0 },
  { "Bindi", 0.0 },
  { "Bindu", 0.0 },
  { "Bindy", 0.0 },
  { "Bineta", 0.0 },
  { "Binford", 1.0 },
  { "Bing", 1.0 },
  { "Bingham", 1.0 },
  { "Binh", 0.92621356 },
  { "Binisha", 0.0 },
  { "Binita", 0.0 },
  { "Binky", 0.0 },
  { "Binnie", 0.21367522 },
  { "Binta", 0.0 },
  { "Binti", 0.0 },
  { "Bintou", 0.0 },
  { "Bintu", 0.0 },
  { "Binu", 1.0 },
  { "Binyamin", 1.0 },
  { "Binyomin", 1.0 },
  { "Bioleta", 0.0 },
  { "Bion", 1.0 },
  { "Bionca", 0.0 },
  { "Bionce", 0.0 },
  { "Bionda", 0.0 },
  { "Bionka", 0.0 },
  { "Biran", 1.0 },
  { "Biranna", 0.0 },
  { "Birch", 1.0 },
  { "Birchard", 1.0 },
  { "Birche", 1.0 },
  { "Birchel", 1.0 },
  { "Birchie", 0.0 },
  { "Bird", 0.47391304 },
  { "Birda", 0.0 },
  { "Birdell", 0.054347824 },
  { "Birdella", 0.0 },
  { "Birdena", 0.0 },
  { "Birdene", 0.0 },
  { "Birder", 0.0 },
  { "Birdia", 0.0 },
  { "Birdie", 0.008691374 },
  { "Birdine", 0.0 },
  { "Birdye", 0.0 },
  { "Biren", 1.0 },
  { "Birger", 1.0 },
  { "Birgit", 0.0 },
  { "Birgitta", 0.0 },
  { "Birgitte", 0.0 },
  { "Biridiana", 0.0 },
  { "Birk", 1.0 },
  { "Birklee", 0.0 },
  { "Birkley", 0.0 },
  { "Birl", 1.0 },
  { "Birney", 1.0 },
  { "Biron", 1.0 },
  { "Birt", 0.98134327 },
  { "Birta", 0.0 },
  { "Birtha", 0.0 },
  { "Birthel", 0.0 },
  { "Birtie", 0.0 },
  { "Birttany", 0.0 },
  { "Birty", 0.0 },
  { "Biruk", 1.0 },
  { "Biruta", 0.0 },
  { "Birute", 0.0 },
  { "Birydiana", 0.0 },
  { "Bisa", 0.0 },
  { "Bisan", 0.0 },
  { "Bisceglia", 0.0 },
  { "Bisente", 1.0 },
  { "Bishara", 1.0 },
  { "Bisharo", 0.0 },
  { "Bisher", 1.0 },
  { "Bishop", 0.99903715 },
  { "Bishoy", 1.0 },
  { "Bisleidy", 0.0 },
  { "Bisma", 0.0 },
  { "Bismah", 0.0 },
  { "Bismarck", 1.0 },
  { "Bismark", 1.0 },
  { "Bisola", 0.0 },
  { "Bison", 1.0 },
  { "Bissan", 0.0 },
  { "Bissie", 0.0 },
  { "Bita", 0.0 },
  { "Bitania", 0.0 },
  { "Bitanya", 0.0 },
  { "Bitha", 0.0 },
  { "Bithiah", 0.0 },
  { "Bitia", 0.0 },
  { "Bitsy", 0.0 },
  { "Bittany", 0.0 },
  { "Bivian", 0.41666666 },
  { "Biviana", 0.0 },
  { "Bix", 1.0 },
  { "Bixby", 0.5555556 },
  { "Biyanca", 0.0 },
  { "Biyanka", 0.0 },
  { "Bj", 0.992785 },
  { "Bjana", 0.0 },
  { "Bjarne", 1.0 },
  { "Bjay", 1.0 },
  { "Bjorn", 1.0 },
  { "Bla", 0.0 },
  { "Blace", 1.0 },
  { "Blackie", 1.0 },
  { "Blade", 1.0 },
  { "Bladen", 1.0 },
  { "Bladimir", 1.0 },
  { "Bladyn", 1.0 },
  { "Blaid", 1.0 },
  { "Blaide", 1.0 },
  { "Blaiden", 1.0 },
  { "Blaidyn", 1.0 },
  { "Blaik", 1.0 },
  { "Blaike", 0.5872483 },
  { "Blaiklee", 0.0 },
  { "Blaikley", 0.0 },
  { "Blain", 0.99236643 },
  { "Blaine", 0.96781564 },
  { "Blair", 0.5145104 },
  { "Blaire", 0.015468347 },
  { "Blaise", 0.9286883 },
  { "Blaiz", 1.0 },
  { "Blaize", 0.89542896 },
  { "Blake", 0.95416826 },
  { "Blakelee", 0.03358209 },
  { "Blakeleigh", 0.0 },
  { "Blakeley", 0.123786405 },
  { "Blakeli", 0.0 },
  { "Blakelie", 0.0 },
  { "Blakely", 0.15613067 },
  { "Blakelyn", 0.0 },
  { "Blakelynn", 0.0 },
  { "Blaken", 1.0 },
  { "Blakeney", 0.0 },
  { "Blakesley", 0.0 },
  { "Blaklee", 0.0 },
  { "Blakleigh", 0.0 },
  { "Blakley", 0.1408046 },
  { "Blaklie", 0.0 },
  { "Blakney", 0.0 },
  { "Blan", 1.0 },
  { "Blanca", 0.005101008 },
  { "Blancaestela", 0.0 },
  { "Blanch", 0.004651163 },
  { "Blancha", 0.0 },
  { "Blanchard", 1.0 },
  { "Blanche", 0.002546389 },
  { "Blanchie", 0.0 },
  { "Bland", 1.0 },
  { "Blandina", 0.0 },
  { "Blandine", 0.0 },
  { "Blandon", 1.0 },
  { "Blandy", 0.0 },
  { "Blane", 0.9973778 },
  { "Blaney", 0.41666666 },
  { "Blanka", 0.0 },
  { "Blannie", 0.0 },
  { "Blanton", 1.0 },
  { "Blas", 1.0 },
  { "Blasa", 0.0 },
  { "Blase", 1.0 },
  { "Blass", 1.0 },
  { "Blayd", 1.0 },
  { "Blayde", 1.0 },
  { "Blayden", 1.0 },
  { "Blaydin", 1.0 },
  { "Blaydon", 1.0 },
  { "Blayk", 1.0 },
  { "Blayke", 0.53259003 },
  { "Blayklee", 0.0 },
  { "Blaykleigh", 0.0 },
  { "Blayn", 1.0 },
  { "Blayne", 0.89957213 },
  { "Blayr", 0.0 },
  { "Blayre", 0.0 },
  { "Blayse", 1.0 },
  { "Blayson", 1.0 },
  { "Blayten", 1.0 },
  { "Blayton", 1.0 },
  { "Blayz", 1.0 },
  { "Blayze", 0.9555302 },
  { "Blaz", 1.0 },
  { "Blaza", 0.0 },
  { "Blaze", 0.9344554 },
  { "Blazen", 1.0 },
  { "Blazer", 1.0 },
  { "Blease", 1.0 },
  { "Bleeker", 0.0 },
  { "Bleidy", 0.0 },
  { "Blen", 0.0 },
  { "Blenda", 0.0 },
  { "Blendia", 0.0 },
  { "Bleona", 0.0 },
  { "Blerim", 1.0 },
  { "Blerina", 0.0 },
  { "Blerta", 0.0 },
  { "Bless", 0.5246753 },
  { "Blessed", 0.30991736 },
  { "Blessen", 0.0 },
  { "Blessence", 0.0 },
  { "Blessin", 0.0 },
  { "Blessing", 0.078086674 },
  { "Blessings", 0.0 },
  { "Blessn", 0.0 },
  { "Blesson", 1.0 },
  { "Blessy", 0.0 },
  { "Blessyn", 0.0 },
  { "Bleu", 0.4814815 },
  { "Blia", 0.0 },
  { "Blima", 0.0 },
  { "Blimi", 0.0 },
  { "Blimie", 0.0 },
  { "Blimy", 0.0 },
  { "Blin", 1.0 },
  { "Blinda", 0.0 },
  { "Bliss", 0.12750717 },
  { "Blissany", 0.0 },
  { "Blithe", 0.0 },
  { "Blodwen", 0.0 },
  { "Blodwyn", 0.0 },
  { "Blon", 0.0 },
  { "Blondean", 0.0 },
  { "Blondell", 0.010073875 },
  { "Blondena", 0.0 },
  { "Blondie", 0.0 },
  { "Blondina", 0.0 },
  { "Blondine", 0.0 },
  { "Bloneva", 0.0 },
  { "Blong", 1.0 },
  { "Blonnie", 0.0 },
  { "Bloomie", 0.0 },
  { "Blossie", 0.0 },
  { "Blossom", 0.0 },
  { "Blouncie", 1.0 },
  { "Blu", 0.65986395 },
  { "Blue", 0.7081281 },
  { "Bluford", 1.0 },
  { "Bluma", 0.0 },
  { "Bly", 0.90909094 },
  { "Blynda", 0.0 },
  { "Blynn", 1.0 },
  { "Blyss", 0.0 },
  { "Blyth", 0.0 },
  { "Blythe", 0.048230786 },
  { "Bnai", 0.0 },
  { "Bo", 0.9402885 },
  { "Boady", 1.0 },
  { "Boaz", 1.0 },
  { "Bob", 0.9965455 },
  { "Boback", 1.0 },
  { "Bobak", 1.0 },
  { "Boban", 1.0 },
  { "Bobb", 1.0 },
  { "Bobbe", 0.0 },
  { "Bobbee", 0.0 },
  { "Bobbetta", 0.0 },
  { "Bobbette", 0.0 },
  { "Bobbi", 0.0027093387 },
  { "Bobbie", 0.17258449 },
  { "Bobbiejean", 0.0 },
  { "Bobbiejo", 0.0 },
  { "Bobbielee", 0.0 },
  { "Bobbiesue", 0.0 },
  { "Bobbijo", 0.0 },
  { "Bobbilee", 0.0 },
  { "Bobbilynn", 0.0 },
  { "Bobbisue", 0.0 },
  { "Bobby", 0.9701819 },
  { "Bobbye", 0.029681763 },
  { "Bobbyetta", 0.0 },
  { "Bobbyjo", 0.0 },
  { "Bobbyjoe", 1.0 },
  { "Bobbylee", 1.0 },
  { "Bobetta", 0.0 },
  { "Bobette", 0.0 },
  { "Bobi", 0.0 },
  { "Bobie", 0.47302383 },
  { "Bobijo", 0.0 },
  { "Bobo", 1.0 },
  { "Bobra", 0.0 },
  { "Boby", 1.0 },
  { "Bocar", 1.0 },
  { "Bocephus", 1.0 },
  { "Bodan", 1.0 },
  { "Bode", 1.0 },
  { "Bodean", 1.0 },
  { "Bodee", 0.98762375 },
  { "Boden", 1.0 },
  { "Bodey", 1.0 },
  { "Bodhan", 1.0 },
  { "Bodhi", 0.97088605 },
  { "Bodhin", 1.0 },
  { "Bodi", 1.0 },
  { "Bodie", 0.9982906 },
  { "Bodin", 1.0 },
  { "Bodyn", 1.0 },
  { "Boe", 0.99100256 },
  { "Boede", 1.0 },
  { "Boedy", 1.0 },
  { "Boen", 1.0 },
  { "Boey", 0.0 },
  { "Bogar", 1.0 },
  { "Bogart", 1.0 },
  { "Bogdan", 1.0 },
  { "Bogdana", 0.0 },
  { "Bohan", 1.0 },
  { "Bohannon", 1.0 },
  { "Bohdan", 1.0 },
  { "Bohde", 1.0 },
  { "Bohden", 1.0 },
  { "Bohdi", 1.0 },
  { "Bohen", 1.0 },
  { "Bohumil", 1.0 },
  { "Boice", 1.0 },
  { "Boise", 1.0 },
  { "Boisey", 1.0 },
  { "Boisy", 1.0 },
  { "Bojan", 1.0 },
  { "Bol", 1.0 },
  { "Bolaji", 1.0 },
  { "Bolanle", 0.0 },
  { "Bolden", 1.0 },
  { "Boleslaus", 1.0 },
  { "Boleslaw", 1.0 },
  { "Bolin", 1.0 },
  { "Bolish", 1.0 },
  { "Bolivar", 1.0 },
  { "Bolivia", 0.0 },
  { "Bolling", 1.0 },
  { "Bolton", 1.0 },
  { "Boluwatife", 0.5794392 },
  { "Bomani", 1.0 },
  { "Bomer", 1.0 },
  { "Bon", 1.0 },
  { "Bona", 0.05376344 },
  { "Bonalyn", 0.0 },
  { "Bonanza", 1.0 },
  { "Bonard", 1.0 },
  { "Boncile", 0.0 },
  { "Bond", 0.97029704 },
  { "Bonda", 0.0 },
  { "Boneita", 0.0 },
  { "Bonell", 0.5 },
  { "Boneta", 0.0 },
  { "Bonetta", 0.0 },
  { "Boneva", 0.0 },
  { "Boney", 1.0 },
  { "Bong", 1.0 },
  { "Bonham", 1.0 },
  { "Boni", 0.0 },
  { "Bonieta", 0.0 },
  { "Boniface", 1.0 },
  { "Bonifacia", 0.0 },
  { "Bonifacio", 1.0 },
  { "Bonique", 0.0 },
  { "Bonita", 0.00031804087 },
  { "Bonitta", 0.0 },
  { "Bonna", 0.0 },
  { "Bonne", 0.0 },
  { "Bonnee", 0.0 },
  { "Bonnell", 0.0 },
  { "Bonnelle", 0.0 },
  { "Bonner", 1.0 },
  { "Bonnetta", 0.0 },
  { "Bonnette", 0.0 },
  { "Bonney", 0.011061947 },
  { "Bonni", 0.0 },
  { "Bonnibel", 0.0 },
  { "Bonnie", 0.012307204 },
  { "Bonniejean", 0.0 },
  { "Bonniejo", 0.0 },
  { "Bonnielee", 0.0 },
  { "Bonnielou", 0.0 },
  { "Bonnita", 0.0 },
  { "Bonnitta", 0.0 },
  { "Bonny", 0.04057205 },
  { "Bonnye", 0.0 },
  { "Bonzie", 0.0 },
  { "Booker", 0.9995468 },
  { "Bookert", 1.0 },
  { "Boomer", 1.0 },
  { "Boon", 1.0 },
  { "Boone", 1.0 },
  { "Booth", 1.0 },
  { "Boots", 0.18300654 },
  { "Bopha", 0.0 },
  { "Bora", 0.76513314 },
  { "Borach", 1.0 },
  { "Boran", 1.0 },
  { "Borden", 1.0 },
  { "Borghild", 0.0 },
  { "Borgny", 0.0 },
  { "Boris", 1.0 },
  { "Borja", 1.0 },
  { "Born", 1.0 },
  { "Borna", 1.0 },
  { "Boruch", 1.0 },
  { "Borys", 1.0 },
  { "Bosco", 1.0 },
  { "Bose", 1.0 },
  { "Bosede", 0.0 },
  { "Bosie", 1.0 },
  { "Boss", 1.0 },
  { "Bossie", 1.0 },
  { "Bosten", 1.0 },
  { "Bostin", 1.0 },
  { "Boston", 0.9167549 },
  { "Bostyn", 0.30057803 },
  { "Bostynn", 0.0 },
  { "Boswell", 1.0 },
  { "Boubacar", 1.0 },
  { "Boulder", 1.0 },
  { "Boun", 1.0 },
  { "Bourne", 1.0 },
  { "Bouvier", 1.0 },
  { "Bow", 0.9655172 },
  { "Bowan", 1.0 },
  { "Bowden", 1.0 },
  { "Bowdie", 1.0 },
  { "Bowdrie", 1.0 },
  { "Bowdy", 1.0 },
  { "Bowe", 1.0 },
  { "Bowen", 0.9831263 },
  { "Bower", 1.0 },
  { "Bowie", 0.6741706 },
  { "Bowin", 1.0 },
  { "Bowman", 1.0 },
  { "Bowyn", 0.875 },
  { "Boy", 1.0 },
  { "Boyan", 1.0 },
  { "Boyce", 0.9893928 },
  { "Boyd", 0.997582 },
  { "Boyde", 1.0 },
  { "Boyden", 1.0 },
  { "Boyed", 1.0 },
  { "Boyer", 1.0 },
  { "Boykin", 1.0 },
  { "Boynton", 1.0 },
  { "Boysie", 1.0 },
  { "Boz", 1.0 },
  { "Bozena", 0.0 },
  { "Brace", 1.0 },
  { "Bracelyn", 0.0 },
  { "Bracelynn", 0.0 },
  { "Bracen", 1.0 },
  { "Bracey", 0.59183675 },
  { "Brach", 1.0 },
  { "Bracha", 0.0 },
  { "Bracie", 0.0 },
  { "Brack", 1.0 },
  { "Bracken", 1.0 },
  { "Brackston", 1.0 },
  { "Bracy", 0.9425287 },
  { "Bracyn", 1.0 },
  { "Brad", 0.99719274 },
  { "Bradan", 1.0 },
  { "Bradbury", 1.0 },
  { "Bradd", 1.0 },
  { "Bradden", 1.0 },
  { "Braddock", 1.0 },
  { "Braddox", 1.0 },
  { "Bradee", 0.29464287 },
  { "Bradely", 1.0 },
  { "Braden", 0.99376553 },
  { "Braderick", 1.0 },
  { "Bradey", 0.9872881 },
  { "Bradfield", 1.0 },
  { "Bradford", 0.99876857 },
  { "Bradi", 0.0 },
  { "Bradie", 0.29689807 },
  { "Bradin", 1.0 },
  { "Bradlee", 0.9317305 },
  { "Bradleigh", 0.03343465 },
  { "Bradley", 0.995082 },
  { "Bradli", 0.0 },
  { "Bradlie", 0.18965517 },
  { "Bradly", 0.99880123 },
  { "Bradlyn", 1.0 },
  { "Bradney", 1.0 },
  { "Bradnon", 1.0 },
  { "Bradon", 1.0 },
  { "Bradrick", 1.0 },
  { "Bradshaw", 1.0 },
  { "Bradson", 1.0 },
  { "Brady", 0.98064405 },
  { "Bradyen", 1.0 },
  { "Bradyn", 0.9513562 },
  { "Bradynn", 0.75 },
  { "Brae", 0.38848922 },
  { "Braecyn", 1.0 },
  { "Braedan", 1.0 },
  { "Braeden", 0.9824307 },
  { "Braedin", 1.0 },
  { "Braedon", 1.0 },
  { "Braedy", 1.0 },
  { "Braedyn", 0.87907183 },
  { "Braegan", 1.0 },
  { "Braela", 0.0 },
  { "Braelan", 1.0 },
  { "Braelee", 0.0 },
  { "Braelei", 0.0 },
  { "Braeleigh", 0.0 },
  { "Braelen", 1.0 },
  { "Braeley", 0.0 },
  { "Braeli", 0.0 },
  { "Braelie", 0.0 },
  { "Braelin", 0.5754923 },
  { "Braelinn", 0.0 },
  { "Braelon", 1.0 },
  { "Braely", 0.0 },
  { "Braelyn", 0.10013175 },
  { "Braelyne", 0.0 },
  { "Braelynn", 0.021926053 },
  { "Braelynne", 0.0 },
  { "Braesen", 1.0 },
  { "Braeson", 1.0 },
  { "Braesyn", 1.0 },
  { "Braeton", 1.0 },
  { "Braeya", 0.0 },
  { "Brage", 1.0 },
  { "Braham", 1.0 },
  { "Braheem", 1.0 },
  { "Brahian", 1.0 },
  { "Brahim", 1.0 },
  { "Brahin", 1.0 },
  { "Brahm", 1.0 },
  { "Brahms", 1.0 },
  { "Braian", 1.0 },
  { "Braidan", 1.0 },
  { "Braiden", 0.97771263 },
  { "Braidon", 1.0 },
  { "Braidy", 0.26086956 },
  { "Braidyn", 0.85565215 },
  { "Braijon", 1.0 },
  { "Brailee", 0.0 },
  { "Braileigh", 0.0 },
  { "Brailen", 1.0 },
  { "Brailey", 0.0055555557 },
  { "Brailin", 1.0 },
  { "Brailon", 1.0 },
  { "Braily", 0.0 },
  { "Brailyn", 0.25422138 },
  { "Brailynn", 0.031825796 },
  { "Brain", 0.9978242 },
  { "Braina", 0.0 },
  { "Brainard", 1.0 },
  { "Brainna", 0.0 },
  { "Brais", 1.0 },
  { "Braisen", 1.0 },
  { "Braisley", 0.0 },
  { "Braison", 1.0 },
  { "Braiya", 0.0 },
  { "Brajon", 1.0 },
  { "Bralan", 1.0 },
  { "Bralee", 0.0 },
  { "Bralei", 0.0 },
  { "Braleigh", 0.0 },
  { "Bralen", 0.9836601 },
  { "Braley", 0.042801555 },
  { "Bralie", 0.0 },
  { "Bralin", 1.0 },
  { "Brallan", 1.0 },
  { "Bralon", 1.0 },
  { "Bralyn", 0.6061885 },
  { "Bralynn", 0.18787879 },
  { "Bralynne", 0.0 },
  { "Bram", 1.0 },
  { "Bran", 1.0 },
  { "Brana", 0.0 },
  { "Branae", 0.0 },
  { "Branan", 1.0 },
  { "Branasia", 0.0 },
  { "Brance", 1.0 },
  { "Branch", 1.0 },
  { "Branco", 1.0 },
  { "Brancon", 1.0 },
  { "Brancy", 0.0 },
  { "Brand", 0.93406594 },
  { "Branda", 0.0 },
  { "Brandace", 0.0 },
  { "Brandais", 0.0 },
  { "Brandal", 1.0 },
  { "Brandale", 1.0 },
  { "Brandall", 1.0 },
  { "Brandalyn", 0.0 },
  { "Brandalynn", 0.0 },
  { "Brandan", 0.98300886 },
  { "Brandarius", 1.0 },
  { "Brandasia", 0.0 },
  { "Branddon", 1.0 },
  { "Brande", 0.0 },
  { "Brandea", 0.0 },
  { "Brandee", 0.0 },
  { "Brandeis", 0.0 },
  { "Brandel", 0.8 },
  { "Brandell", 0.9381443 },
  { "Brandelyn", 0.0 },
  { "Brandelynn", 0.0 },
  { "Branden", 0.9878774 },
  { "Brandenn", 1.0 },
  { "Brander", 1.0 },
  { "Brandessa", 0.0 },
  { "Brandey", 0.0 },
  { "Brandi", 0.0038212182 },
  { "Brandia", 0.0 },
  { "Brandiann", 0.0 },
  { "Brandice", 0.0 },
  { "Brandie", 0.0018362566 },
  { "Brandii", 0.0 },
  { "Brandilee", 0.0 },
  { "Brandilyn", 0.0 },
  { "Brandilynn", 0.0 },
  { "Brandin", 0.9512108 },
  { "Brandina", 0.0 },
  { "Brandis", 0.1031941 },
  { "Brandise", 0.0 },
  { "Brandisha", 0.0 },
  { "Brandiss", 0.0 },
  { "Brandley", 1.0 },
  { "Brandlyn", 0.0 },
  { "Brandn", 1.0 },
  { "Brando", 1.0 },
  { "Brandol", 1.0 },
  { "Brandolyn", 0.0 },
  { "Brandom", 1.0 },
  { "Brandon", 0.994531 },
  { "Brandonjames", 1.0 },
  { "Brandonkyle", 1.0 },
  { "Brandonlee", 1.0 },
  { "Brandonmichael", 1.0 },
  { "Brandonn", 1.0 },
  { "Brandonray", 1.0 },
  { "Brandson", 1.0 },
  { "Brandt", 0.99317896 },
  { "Brandtley", 1.0 },
  { "Brandtly", 1.0 },
  { "Brandton", 1.0 },
  { "Brandun", 1.0 },
  { "Brandy", 0.020573813 },
  { "Brandyann", 0.0 },
  { "Brandyce", 0.0 },
  { "Brandye", 0.0 },
  { "Brandylee", 0.0 },
  { "Brandylynn", 0.0 },
  { "Brandyn", 0.9153831 },
  { "Braneisha", 0.0 },
  { "Branen", 1.0 },
  { "Branesha", 0.0 },
  { "Branford", 1.0 },
  { "Branham", 1.0 },
  { "Brania", 0.0 },
  { "Braniah", 0.0 },
  { "Branigan", 0.44285715 },
  { "Branisha", 0.0 },
  { "Braniya", 0.0 },
  { "Braniyah", 0.0 },
  { "Branko", 1.0 },
  { "Branlee", 1.0 },
  { "Branly", 1.0 },
  { "Brann", 1.0 },
  { "Branna", 0.0 },
  { "Brannan", 0.9715762 },
  { "Branndon", 1.0 },
  { "Brannen", 1.0 },
  { "Brannick", 1.0 },
  { "Brannigan", 0.6956522 },
  { "Brannock", 1.0 },
  { "Brannon", 0.975 },
  { "Branon", 1.0 },
  { "Branoon", 1.0 },
  { "Bransen", 1.0 },
  { "Bransford", 1.0 },
  { "Branson", 0.9991697 },
  { "Branston", 1.0 },
  { "Bransyn", 1.0 },
  { "Brant", 0.9989072 },
  { "Branten", 1.0 },
  { "Brantlee", 0.8873608 },
  { "Brantleigh", 0.06329114 },
  { "Brantley", 0.96752435 },
  { "Brantlie", 0.0 },
  { "Brantly", 0.9931507 },
  { "Brantlyn", 1.0 },
  { "Branton", 1.0 },
  { "Brantson", 1.0 },
  { "Branwen", 0.0 },
  { "Branwyn", 0.0 },
  { "Brany", 0.0 },
  { "Branya", 0.0 },
  { "Branyah", 0.0 },
  { "Brasen", 1.0 },
  { "Brashad", 1.0 },
  { "Brashaun", 1.0 },
  { "Brashawn", 1.0 },
  { "Brasher", 1.0 },
  { "Brasi", 1.0 },
  { "Brasia", 0.0 },
  { "Brason", 1.0 },
  { "Braston", 1.0 },
  { "Braulia", 0.0 },
  { "Braulio", 1.0 },
  { "Braun", 1.0 },
  { "Brave", 0.8835617 },
  { "Braven", 1.0 },
  { "Bravery", 0.7307692 },
  { "Bravin", 1.0 },
  { "Bravlio", 1.0 },
  { "Bravo", 1.0 },
  { "Bravon", 1.0 },
  { "Bravyn", 1.0 },
  { "Brawley", 1.0 },
  { "Brax", 1.0 },
  { "Braxden", 1.0 },
  { "Braxdon", 1.0 },
  { "Braxdyn", 1.0 },
  { "Braxen", 1.0 },
  { "Braxlee", 0.6315789 },
  { "Braxleigh", 0.0 },
  { "Braxley", 0.6956522 },
  { "Braxon", 1.0 },
  { "Braxson", 1.0 },
  { "Braxsten", 1.0 },
  { "Braxston", 1.0 },
  { "Braxstyn", 1.0 },
  { "Braxtan", 1.0 },
  { "Braxten", 0.9958054 },
  { "Braxtin", 0.9852941 },
  { "Braxton", 0.9838219 },
  { "Braxtyn", 0.8030769 },
  { "Braxtynn", 0.52380955 },
  { "Braxx", 1.0 },
  { "Braxxton", 1.0 },
  { "Bray", 0.9411765 },
  { "Braya", 0.0 },
  { "Brayah", 0.0 },
  { "Brayam", 1.0 },
  { "Brayan", 0.9986982 },
  { "Brayana", 0.0 },
  { "Brayanna", 0.0 },
  { "Brayant", 1.0 },
  { "Brayce", 1.0 },
  { "Braycen", 1.0 },
  { "Braydan", 0.99040306 },
  { "Brayde", 1.0 },
  { "Braydee", 0.073529415 },
  { "Brayden", 0.9912042 },
  { "Braydenn", 1.0 },
  { "Braydi", 0.0 },
  { "Braydin", 0.98854166 },
  { "Braydn", 1.0 },
  { "Braydon", 0.99818224 },
  { "Braydyn", 1.0 },
  { "Brayelle", 0.0 },
  { "Brayen", 1.0 },
  { "Brayhan", 1.0 },
  { "Brayla", 0.0 },
  { "Braylah", 0.0 },
  { "Braylan", 0.9536178 },
  { "Brayland", 1.0 },
  { "Brayle", 0.0 },
  { "Braylea", 0.0 },
  { "Braylee", 0.0147125395 },
  { "Braylei", 0.0 },
  { "Brayleigh", 0.0 },
  { "Braylen", 0.94409513 },
  { "Braylend", 1.0 },
  { "Braylenn", 0.6875 },
  { "Brayley", 0.0 },
  { "Brayli", 0.0 },
  { "Braylie", 0.0 },
  { "Braylin", 0.6454979 },
  { "Braylinn", 0.0 },
  { "Brayln", 1.0 },
  { "Braylon", 0.9919112 },
  { "Braylyn", 0.42281106 },
  { "Braylynn", 0.1041456 },
  { "Braylynne", 0.0 },
  { "Brayn", 1.0 },
  { "Braynt", 1.0 },
  { "Brayon", 1.0 },
  { "Brayonna", 0.0 },
  { "Braysen", 1.0 },
  { "Brayshaun", 1.0 },
  { "Brayshawn", 1.0 },
  { "Brayson", 1.0 },
  { "Brayston", 1.0 },
  { "Brayten", 1.0 },
  { "Brayton", 0.98969555 },
  { "Brayven", 1.0 },
  { "Brayzen", 1.0 },
  { "Brazen", 1.0 },
  { "Brazil", 0.10757946 },
  { "Brazos", 1.0 },
  { "Bre", 0.0 },
  { "Brea", 0.0 },
  { "Breaanna", 0.0 },
  { "Breaden", 1.0 },
  { "Breah", 0.0 },
  { "Breahanna", 0.0 },
  { "Breahna", 0.0 },
  { "Breahnna", 0.0 },
  { "Breaira", 0.0 },
  { "Breaja", 0.0 },
  { "Breajah", 0.0 },
  { "Breaker", 1.0 },
  { "Breale", 0.0 },
  { "Brealeigh", 0.0 },
  { "Brealle", 0.0 },
  { "Brealyn", 0.0 },
  { "Brealynn", 0.0 },
  { "Brean", 0.064935066 },
  { "Breana", 0.0 },
  { "Breanah", 0.0 },
  { "Breanca", 0.0 },
  { "Breanda", 0.0 },
  { "Breandan", 1.0 },
  { "Breandra", 0.0 },
  { "Breandrea", 0.0 },
  { "Breane", 0.0 },
  { "Breania", 0.0 },
  { "Breann", 0.0 },
  { "Breanna", 0.00080373924 },
  { "Breannah", 0.0 },
  { "Breanne", 0.0 },
  { "Breannia", 0.0 },
  { "Breannon", 0.0 },
  { "Breara", 0.0 },
  { "Breasha", 0.0 },
  { "Breashia", 0.0 },
  { "Breasia", 0.0 },
  { "Breasya", 0.0 },
  { "Breaun", 0.23809524 },
  { "Breauna", 0.0 },
  { "Breaunna", 0.0 },
  { "Breawna", 0.0 },
  { "Breayla", 0.0 },
  { "Breayna", 0.0 },
  { "Breazae", 0.0 },
  { "Breazia", 0.0 },
  { "Brec", 1.0 },
  { "Brecca", 0.0 },
  { "Breccan", 1.0 },
  { "Brecia", 0.0 },
  { "Breck", 0.8378713 },
  { "Breckan", 1.0 },
  { "Brecken", 0.805 },
  { "Brecker", 1.0 },
  { "Breckin", 0.8799662 },
  { "Brecklin", 0.0 },
  { "Brecklyn", 0.0 },
  { "Brecklynn", 0.0 },
  { "Breckon", 1.0 },
  { "Breckyn", 0.22605364 },
  { "Breckynn", 0.0 },
  { "Brecon", 1.0 },
  { "Breda", 0.0 },
  { "Bredan", 1.0 },
  { "Bredyn", 1.0 },
  { "Bree", 0.0020408162 },
  { "Breea", 0.0 },
  { "Breeah", 0.0 },
  { "Breeahna", 0.0 },
  { "Breean", 0.0 },
  { "Breeana", 0.0 },
  { "Breeann", 0.0 },
  { "Breeanna", 0.0 },
  { "Breeannah", 0.0 },
  { "Breeanne", 0.0 },
  { "Breeauna", 0.0 },
  { "Breeaunna", 0.0 },
  { "Breece", 0.21568628 },
  { "Breegan", 0.0 },
  { "Breelan", 0.0 },
  { "Breeland", 0.0 },
  { "Breelee", 0.0 },
  { "Breeleigh", 0.0 },
  { "Breeley", 0.0 },
  { "Breelin", 0.0 },
  { "Breella", 0.0 },
  { "Breelle", 0.0 },
  { "Breely", 0.0 },
  { "Breelyn", 0.0 },
  { "Breelynn", 0.0 },
  { "Breen", 0.0 },
  { "Breena", 0.0 },
  { "Breeona", 0.0 },
  { "Breeonna", 0.0 },
  { "Brees", 0.7755102 },
  { "Breesa", 0.0 },
  { "Breese", 0.0 },
  { "Breesha", 0.0 },
  { "Breeya", 0.0 },
  { "Breeyah", 0.0 },
  { "Breeyana", 0.0 },
  { "Breeyanna", 0.0 },
  { "Breez", 0.47619048 },
  { "Breeza", 0.0 },
  { "Breeze", 0.06518724 },
  { "Breezi", 0.0 },
  { "Breezie", 0.0 },
  { "Breezy", 0.0 },
  { "Breh", 1.0 },
  { "Brehan", 0.0 },
  { "Brehana", 0.0 },
  { "Brehanna", 0.0 },
  { "Brehea", 0.0 },
  { "Brehon", 1.0 },
  { "Brei", 0.0 },
  { "Breia", 0.0 },
  { "Breiah", 0.0 },
  { "Breiana", 0.0 },
  { "Breiann", 0.0 },
  { "Breianna", 0.0 },
  { "Breianne", 0.0 },
  { "Breiden", 1.0 },
  { "Breidy", 0.0 },
  { "Breidyn", 1.0 },
  { "Breigh", 0.0 },
  { "Breigha", 0.0 },
  { "Breighana", 0.0 },
  { "Breighanna", 0.0 },
  { "Breighden", 1.0 },
  { "Breighlyn", 0.0 },
  { "Breighlynn", 0.0 },
  { "Breighton", 1.0 },
  { "Breilyn", 0.0 },
  { "Breilynn", 0.0 },
  { "Brein", 0.0 },
  { "Breina", 0.0 },
  { "Breindel", 0.0 },
  { "Breindy", 0.0 },
  { "Breinne", 0.0 },
  { "Breion", 0.75274724 },
  { "Breiona", 0.0 },
  { "Breionna", 0.0 },
  { "Breisha", 0.0 },
  { "Breitlin", 1.0 },
  { "Brejae", 0.0 },
  { "Brejon", 1.0 },
  { "Brek", 1.0 },
  { "Breken", 1.0 },
  { "Brekia", 0.0 },
  { "Brekin", 1.0 },
  { "Brekka", 0.0 },
  { "Brekke", 0.0 },
  { "Brekken", 0.93491125 },
  { "Brekkin", 1.0 },
  { "Brekkyn", 0.0 },
  { "Breklyn", 0.0 },
  { "Breklynn", 0.0 },
  { "Brekon", 1.0 },
  { "Brekyn", 0.33070865 },
  { "Brelan", 1.0 },
  { "Breland", 0.8613333 },
  { "Brelee", 0.0 },
  { "Breleigh", 0.0 },
  { "Brelen", 1.0 },
  { "Brelin", 1.0 },
  { "Brelle", 0.0 },
  { "Brelon", 1.0 },
  { "Brely", 0.0 },
  { "Brelyn", 0.07364341 },
  { "Brelynn", 0.007215007 },
  { "Bremen", 1.0 },
  { "Bren", 0.7692308 },
  { "Brena", 0.0 },
  { "Brenae", 0.0 },
  { "Brenai", 0.0 },
  { "Brenan", 1.0 },
  { "Brenard", 1.0 },
  { "Brenasia", 0.0 },
  { "Brenay", 0.0 },
  { "Brenaya", 0.0 },
  { "Brence", 1.0 },
  { "Brend", 0.0 },
  { "Brenda", 0.00348637 },
  { "Brendaa", 0.0 },
  { "Brendalee", 0.0 },
  { "Brendalis", 0.0 },
  { "Brendaliz", 0.0 },
  { "Brendaly", 0.0 },
  { "Brendalyn", 0.0 },
  { "Brendalynn", 0.0 },
  { "Brendan", 0.99634904 },
  { "Brendasia", 0.0 },
  { "Brendell", 0.20833333 },
  { "Brendella", 0.0 },
  { "Brenden", 0.9983046 },
  { "Brender", 0.0 },
  { "Brendetta", 0.0 },
  { "Brendi", 0.0 },
  { "Brendia", 0.0 },
  { "Brendin", 1.0 },
  { "Brendolyn", 0.0 },
  { "Brendon", 0.99886394 },
  { "Brendt", 1.0 },
  { "Brendy", 0.0 },
  { "Brendyn", 1.0 },
  { "Brene", 0.0 },
  { "Brenea", 0.0 },
  { "Brenee", 0.0 },
  { "Breneisha", 0.0 },
  { "Brenen", 1.0 },
  { "Brener", 1.0 },
  { "Brenesha", 0.0 },
  { "Breneshia", 0.0 },
  { "Brenetta", 0.0 },
  { "Brenette", 0.0 },
  { "Brenham", 1.0 },
  { "Brenia", 0.0 },
  { "Breniah", 0.0 },
  { "Brenice", 0.0 },
  { "Brenicia", 0.0 },
  { "Brenika", 0.0 },
  { "Brenin", 0.9691358 },
  { "Brenisha", 0.0 },
  { "Brenita", 0.0 },
  { "Breniya", 0.0 },
  { "Breniyah", 0.0 },
  { "Brenlee", 0.0 },
  { "Brenleigh", 0.0 },
  { "Brenley", 0.034267914 },
  { "Brenli", 0.0 },
  { "Brenlie", 0.0 },
  { "Brenly", 0.0 },
  { "Brenlyn", 0.0 },
  { "Brenlynn", 0.0 },
  { "Brenn", 0.496063 },
  { "Brenna", 0.0 },
  { "Brennae", 0.0 },
  { "Brennah", 0.0 },
  { "Brennan", 0.93885756 },
  { "Brennda", 0.0 },
  { "Brenndan", 1.0 },
  { "Brennden", 1.0 },
  { "Brenndon", 1.0 },
  { "Brennen", 0.9796548 },
  { "Brenner", 0.9902629 },
  { "Brennick", 1.0 },
  { "Brennin", 1.0 },
  { "Brennley", 0.0 },
  { "Brennon", 1.0 },
  { "Brennus", 1.0 },
  { "Brennyn", 0.46124032 },
  { "Breno", 1.0 },
  { "Brenon", 1.0 },
  { "Brensen", 1.0 },
  { "Brenson", 1.0 },
  { "Brenston", 1.0 },
  { "Brent", 0.9959225 },
  { "Brentan", 1.0 },
  { "Brenten", 1.0 },
  { "Brentin", 1.0 },
  { "Brentlee", 0.84415585 },
  { "Brentleigh", 0.0 },
  { "Brentley", 0.9351536 },
  { "Brently", 0.984141 },
  { "Brentney", 0.0 },
  { "Brentnie", 0.0 },
  { "Brenton", 0.9987265 },
  { "Brentson", 1.0 },
  { "Brentt", 1.0 },
  { "Brentten", 1.0 },
  { "Brentton", 1.0 },
  { "Brentwood", 1.0 },
  { "Brentyn", 1.0 },
  { "Brenya", 0.0 },
  { "Brenyn", 0.75333333 },
  { "Breon", 0.88114756 },
  { "Breona", 0.0 },
  { "Breonah", 0.0 },
  { "Breonca", 0.0 },
  { "Breonda", 0.0 },
  { "Breondra", 0.0 },
  { "Breonia", 0.0 },
  { "Breonica", 0.0 },
  { "Breonka", 0.0 },
  { "Breonna", 0.0 },
  { "Breonnah", 0.0 },
  { "Breonne", 0.0 },
  { "Breontae", 1.0 },
  { "Breonte", 0.54545456 },
  { "Breosha", 0.0 },
  { "Brescia", 0.0 },
  { "Breseis", 0.0 },
  { "Bresha", 0.0 },
  { "Breshae", 0.0 },
  { "Breshai", 0.0 },
  { "Breshaun", 1.0 },
  { "Breshauna", 0.0 },
  { "Breshawn", 0.556962 },
  { "Breshawna", 0.0 },
  { "Breshay", 0.0 },
  { "Breshayla", 0.0 },
  { "Breshey", 0.0 },
  { "Breshia", 0.0 },
  { "Breshonna", 0.0 },
  { "Breshuna", 0.0 },
  { "Breslin", 0.57425743 },
  { "Breslyn", 0.0 },
  { "Breslynn", 0.0 },
  { "Bret", 0.9922268 },
  { "Breta", 0.0 },
  { "Brete", 1.0 },
  { "Bretha", 0.0 },
  { "Bretley", 1.0 },
  { "Bretney", 0.0 },
  { "Breton", 1.0 },
  { "Brett", 0.97959936 },
  { "Bretta", 0.0 },
  { "Brettany", 0.0 },
  { "Brette", 0.018835617 },
  { "Bretten", 1.0 },
  { "Brettlee", 1.0 },
  { "Brettley", 1.0 },
  { "Brettly", 1.0 },
  { "Brettney", 0.0 },
  { "Brettnie", 0.0 },
  { "Bretton", 1.0 },
  { "Breuna", 0.0 },
  { "Breunna", 0.0 },
  { "Brevan", 1.0 },
  { "Brevard", 1.0 },
  { "Breven", 1.0 },
  { "Brevin", 1.0 },
  { "Brevon", 1.0 },
  { "Brevyn", 0.94634145 },
  { "Brewer", 1.0 },
  { "Brewster", 1.0 },
  { "Brex", 1.0 },
  { "Brexlee", 0.0 },
  { "Brexley", 0.0 },
  { "Brexlie", 0.0 },
  { "Brexlyn", 0.0 },
  { "Brexten", 1.0 },
  { "Brextin", 1.0 },
  { "Brexton", 1.0 },
  { "Brextyn", 1.0 },
  { "Brey", 1.0 },
  { "Breya", 0.0 },
  { "Breyah", 0.0 },
  { "Breyan", 0.6666667 },
  { "Breyana", 0.0 },
  { "Breyanah", 0.0 },
  { "Breyanna", 0.0 },
  { "Breyannah", 0.0 },
  { "Breyanne", 0.0 },
  { "Breyauna", 0.0 },
  { "Breyawna", 0.0 },
  { "Breydan", 1.0 },
  { "Breyden", 1.0 },
  { "Breydi", 0.0 },
  { "Breydin", 1.0 },
  { "Breydon", 1.0 },
  { "Breyell", 0.0 },
  { "Breyelle", 0.0 },
  { "Breyen", 1.0 },
  { "Breyer", 0.8907563 },
  { "Breylan", 1.0 },
  { "Breylee", 0.0 },
  { "Breylen", 1.0 },
  { "Breylin", 0.8012048 },
  { "Breylon", 1.0 },
  { "Breylyn", 0.0 },
  { "Breylynn", 0.0 },
  { "Breyn", 0.0 },
  { "Breyon", 0.8663854 },
  { "Breyona", 0.0 },
  { "Breyonce", 0.0 },
  { "Breyonia", 0.0 },
  { "Breyonna", 0.0 },
  { "Breyson", 1.0 },
  { "Breyton", 1.0 },
  { "Breyunna", 0.0 },
  { "Brezae", 0.0 },
  { "Breze", 0.0 },
  { "Brezhane", 0.0 },
  { "Brezlin", 0.54545456 },
  { "Brezlyn", 0.0 },
  { "Brezlynn", 0.0 },
  { "Brezzy", 0.0 },
  { "Brhea", 0.0 },
  { "Brhett", 1.0 },
  { "Brhianna", 0.0 },
  { "Bri", 0.0 },
  { "Bria", 0.0039596832 },
  { "Briah", 0.0 },
  { "Briahna", 0.0 },
  { "Briahnna", 0.0 },
  { "Briaja", 0.0 },
  { "Briajah", 0.0 },
  { "Brialle", 0.0 },
  { "Briam", 1.0 },
  { "Briamarie", 0.0 },
  { "Brian", 0.9960866 },
  { "Briana", 0.0021772804 },
  { "Brianah", 0.0 },
  { "Brianalee", 0.0 },
  { "Brianamarie", 0.0 },
  { "Briananthony", 1.0 },
  { "Brianca", 0.0 },
  { "Briance", 0.0 },
  { "Brianda", 0.0027472528 },
  { "Briandra", 0.0 },
  { "Briane", 0.15669516 },
  { "Briani", 0.0 },
  { "Briania", 0.0 },
  { "Brianica", 0.0 },
  { "Brianie", 0.0 },
  { "Brianka", 0.0 },
  { "Briann", 0.012861736 },
  { "Brianna", 0.0016840579 },
  { "Briannah", 0.0 },
  { "Briannalee", 0.0 },
  { "Briannan", 0.0 },
  { "Brianne", 0.0015899831 },
  { "Brianney", 0.0 },
  { "Brianni", 0.0 },
  { "Briannia", 0.0 },
  { "Briannica", 0.0 },
  { "Briannie", 0.0 },
  { "Briannon", 0.0 },
  { "Brianny", 0.0 },
  { "Briant", 1.0 },
  { "Briante", 0.05319149 },
  { "Briany", 0.0 },
  { "Briar", 0.6184408 },
  { "Briara", 0.0 },
  { "Briarrose", 0.0 },
  { "Briasha", 0.0 },
  { "Briasia", 0.0 },
  { "Briauna", 0.0 },
  { "Briaunna", 0.0 },
  { "Briawna", 0.0 },
  { "Briayan", 1.0 },
  { "Briazia", 0.0 },
  { "Bric", 1.0 },
  { "Brice", 0.9768173 },
  { "Briceida", 0.0 },
  { "Briceidy", 0.0 },
  { "Bricelyn", 0.0 },
  { "Bricelynn", 0.0 },
  { "Bricen", 1.0 },
  { "Briceson", 1.0 },
  { "Briceston", 1.0 },
  { "Briceton", 1.0 },
  { "Briceyda", 0.0 },
  { "Brichelle", 0.0 },
  { "Bricia", 0.0 },
  { "Brick", 1.0 },
  { "Bricker", 1.0 },
  { "Bricola", 0.0 },
  { "Bricyn", 1.0 },
  { "Bridan", 1.0 },
  { "Briden", 1.0 },
  { "Bridey", 0.0 },
  { "Bridge", 0.9056604 },
  { "Bridger", 0.998805 },
  { "Bridges", 1.0 },
  { "Bridget", 0.0016852039 },
  { "Bridgete", 0.0 },
  { "Bridgett", 0.0 },
  { "Bridgetta", 0.0 },
  { "Bridgette", 0.00069198164 },
  { "Bridgid", 0.0 },
  { "Bridgit", 0.0 },
  { "Bridgitt", 0.0 },
  { "Bridgitte", 0.0 },
  { "Bridie", 0.0 },
  { "Bridjette", 0.0 },
  { "Bridney", 0.0 },
  { "Bridon", 1.0 },
  { "Bridy", 0.0 },
  { "Bridyn", 1.0 },
  { "Brie", 0.0 },
  { "Briea", 0.0 },
  { "Brieah", 0.0 },
  { "Brieana", 0.0 },
  { "Brieann", 0.0 },
  { "Brieanna", 0.0 },
  { "Brieanne", 0.0 },
  { "Briel", 0.0 },
  { "Briela", 0.0 },
  { "Briele", 0.0 },
  { "Brielee", 0.0 },
  { "Briell", 0.0 },
  { "Briella", 0.0 },
  { "Briellah", 0.0 },
  { "Brielle", 0.0 },
  { "Brielyn", 0.0 },
  { "Brielynn", 0.0 },
  { "Brien", 0.99858916 },
  { "Briena", 0.0 },
  { "Brienna", 0.0 },
  { "Brienne", 0.0037936268 },
  { "Brieon", 0.0 },
  { "Brieona", 0.0 },
  { "Brieonna", 0.0 },
  { "Brier", 0.64788735 },
  { "Brierra", 0.0 },
  { "Brierre", 0.0 },
  { "Briesha", 0.0 },
  { "Brietta", 0.0 },
  { "Briette", 0.0 },
  { "Brieya", 0.0 },
  { "Brig", 1.0 },
  { "Brigden", 1.0 },
  { "Brigdon", 1.0 },
  { "Briget", 0.0 },
  { "Brigett", 0.0 },
  { "Brigetta", 0.0 },
  { "Brigette", 0.0 },
  { "Brigg", 1.0 },
  { "Briggett", 0.0 },
  { "Briggette", 0.0 },
  { "Briggitte", 0.0 },
  { "Briggs", 0.9940187 },
  { "Briggston", 1.0 },
  { "Brigham", 1.0 },
  { "Brighid", 0.0 },
  { "Brighley", 0.0 },
  { "Bright", 0.97596157 },
  { "Brighten", 0.6163522 },
  { "Brightly", 0.0 },
  { "Brighton", 0.6442073 },
  { "Brightyn", 0.0 },
  { "Brigid", 0.0 },
  { "Brigida", 0.0 },
  { "Brigido", 1.0 },
  { "Brigina", 0.0 },
  { "Brigit", 0.0 },
  { "Brigita", 0.0 },
  { "Brigitt", 0.0 },
  { "Brigitta", 0.0 },
  { "Brigitte", 0.0 },
  { "Brigston", 1.0 },
  { "Brihana", 0.0 },
  { "Brihanna", 0.0 },
  { "Brihany", 0.0 },
  { "Brij", 1.0 },
  { "Brijae", 0.0 },
  { "Brijesh", 1.0 },
  { "Brijet", 0.0 },
  { "Brijette", 0.0 },
  { "Brijida", 0.0 },
  { "Brijido", 1.0 },
  { "Brijin", 0.0 },
  { "Brik", 1.0 },
  { "Brilan", 1.0 },
  { "Brilea", 0.0 },
  { "Brilee", 0.021535581 },
  { "Brilei", 0.0 },
  { "Brileigh", 0.0 },
  { "Brilen", 1.0 },
  { "Briley", 0.1870328 },
  { "Brilie", 0.0 },
  { "Brilliance", 0.0 },
  { "Brilliant", 1.0 },
  { "Brilyn", 0.13377926 },
  { "Brilynn", 0.00755287 },
  { "Brilynne", 0.0 },
  { "Brin", 0.09002433 },
  { "Brina", 0.003912363 },
  { "Brinae", 0.0 },
  { "Brinda", 0.0 },
  { "Brinden", 1.0 },
  { "Brinder", 0.0 },
  { "Brindi", 0.0 },
  { "Brindin", 1.0 },
  { "Brindle", 0.0 },
  { "Brindley", 0.0 },
  { "Brindon", 1.0 },
  { "Brindy", 0.0 },
  { "Brinesha", 0.0 },
  { "Briney", 0.0 },
  { "Brinisha", 0.0 },
  { "Briniya", 0.0 },
  { "Briniyah", 0.0 },
  { "Brink", 1.0 },
  { "Brinklee", 0.0 },
  { "Brinkley", 0.036259543 },
  { "Brinlea", 0.0 },
  { "Brinlee", 0.0 },
  { "Brinlei", 0.0 },
  { "Brinleigh", 0.0 },
  { "Brinley", 0.015093787 },
  { "Brinli", 0.0 },
  { "Brinlie", 0.0 },
  { "Brinly", 0.0 },
  { "Brinlyn", 0.0 },
  { "Brinlynn", 0.0 },
  { "Brinn", 0.029069768 },
  { "Brinna", 0.0 },
  { "Brinnlee", 0.0 },
  { "Brinnley", 0.0 },
  { "Brinnly", 0.0 },
  { "Brinslee", 0.0 },
  { "Brinsley", 0.0 },
  { "Brinson", 0.9807074 },
  { "Brint", 1.0 },
  { "Brintney", 0.0 },
  { "Brinton", 1.0 },
  { "Brinya", 0.0 },
  { "Brion", 0.9696422 },
  { "Briona", 0.0 },
  { "Brionca", 0.0 },
  { "Brione", 0.16923077 },
  { "Brioni", 0.0 },
  { "Brionica", 0.0 },
  { "Brionna", 0.0 },
  { "Brionnah", 0.0 },
  { "Brionne", 0.03311258 },
  { "Brionni", 0.0 },
  { "Briony", 0.0 },
  { "Brisa", 0.0 },
  { "Brisaida", 0.0 },
  { "Brisais", 0.0 },
  { "Brisamar", 0.0 },
  { "Brisayda", 0.0 },
  { "Brisco", 1.0 },
  { "Briscoe", 1.0 },
  { "Briseida", 0.0 },
  { "Briseidy", 0.0 },
  { "Briseis", 0.0 },
  { "Briselda", 0.0 },
  { "Brisen", 1.0 },
  { "Briseyda", 0.0 },
  { "Brisha", 0.0 },
  { "Brishae", 0.0 },
  { "Brishana", 0.0 },
  { "Brishaun", 1.0 },
  { "Brishauna", 0.0 },
  { "Brishawn", 1.0 },
  { "Brishen", 1.0 },
  { "Brishon", 0.0 },
  { "Brisia", 0.0 },
  { "Brisna", 0.0 },
  { "Brisny", 0.0 },
  { "Brison", 1.0 },
  { "Brissa", 0.0 },
  { "Brisseida", 0.0 },
  { "Brisseyda", 0.0 },
  { "Brissia", 0.0 },
  { "Bristal", 0.0 },
  { "Bristen", 0.4054054 },
  { "Brister", 1.0 },
  { "Bristin", 0.33333334 },
  { "Bristol", 0.07434092 },
  { "Briston", 1.0 },
  { "Bristy", 0.0 },
  { "Bristyl", 0.0 },
  { "Bristyn", 0.0 },
  { "Brisyn", 1.0 },
  { "Brit", 0.81014305 },
  { "Brita", 0.0 },
  { "Britain", 0.54330707 },
  { "Britainy", 0.0 },
  { "Britan", 0.7027027 },
  { "Britane", 0.0 },
  { "Britanee", 0.0 },
  { "Britaney", 0.0 },
  { "Britani", 0.0 },
  { "Britania", 0.0 },
  { "Britanie", 0.0 },
  { "Britanna", 0.0 },
  { "Britanni", 0.0 },
  { "Britannia", 0.0 },
  { "Britannica", 0.0 },
  { "Britanny", 0.0 },
  { "Britany", 0.0 },
  { "Britanya", 0.0 },
  { "Briteny", 0.0 },
  { "Brithanny", 0.0 },
  { "Brithany", 0.0 },
  { "Brithney", 0.0 },
  { "Brithny", 0.0 },
  { "Britian", 0.88505745 },
  { "Britiany", 0.0 },
  { "Britinee", 0.0 },
  { "Britiney", 0.0 },
  { "Britini", 0.0 },
  { "Britiny", 0.0 },
  { "British", 0.089361705 },
  { "Britlany", 0.0 },
  { "Britlee", 0.0 },
  { "Britleigh", 0.0 },
  { "Britley", 0.0 },
  { "Britlyn", 0.0 },
  { "Britlynn", 0.0 },
  { "Britnae", 0.0 },
  { "Britnai", 0.0 },
  { "Britnay", 0.0 },
  { "Britne", 0.0 },
  { "Britnee", 0.0 },
  { "Britnei", 0.0 },
  { "Britney", 0.0024106184 },
  { "Britni", 0.0 },
  { "Britnie", 0.0 },
  { "Britny", 0.0 },
  { "Britnye", 0.0 },
  { "Briton", 0.9904943 },
  { "Britt", 0.61472034 },
  { "Britta", 0.0 },
  { "Brittain", 0.5585997 },
  { "Brittainey", 0.0 },
  { "Brittaini", 0.0 },
  { "Brittainy", 0.0 },
  { "Brittan", 0.35359117 },
  { "Brittana", 0.0 },
  { "Brittanae", 0.0 },
  { "Brittane", 0.0 },
  { "Brittanee", 0.0 },
  { "Brittaney", 0.0 },
  { "Brittani", 0.001874095 },
  { "Brittania", 0.0 },
  { "Brittanica", 0.0 },
  { "Brittanie", 0.0 },
  { "Brittanii", 0.0 },
  { "Brittanni", 0.0 },
  { "Brittannie", 0.0 },
  { "Brittanny", 0.0 },
  { "Brittant", 0.0 },
  { "Brittany", 0.0030041663 },
  { "Brittanya", 0.0 },
  { "Brittanyann", 0.0 },
  { "Brittanye", 0.0 },
  { "Brittanylee", 0.0 },
  { "Brittanymarie", 0.0 },
  { "Brittanynicole", 0.0 },
  { "Brittary", 0.0 },
  { "Brittay", 0.0 },
  { "Britte", 0.0 },
  { "Britten", 0.59348613 },
  { "Britteney", 0.0 },
  { "Britteni", 0.0 },
  { "Britteny", 0.0 },
  { "Britthany", 0.0 },
  { "Brittian", 0.76363635 },
  { "Brittiana", 0.0 },
  { "Brittiani", 0.0 },
  { "Brittiany", 0.0 },
  { "Brittie", 0.0 },
  { "Brittin", 0.33731344 },
  { "Brittina", 0.0 },
  { "Brittinay", 0.0 },
  { "Brittine", 0.0 },
  { "Brittinee", 0.0 },
  { "Brittiney", 0.0 },
  { "Brittini", 0.0 },
  { "Brittinie", 0.0 },
  { "Brittiny", 0.0 },
  { "Brittish", 0.0 },
  { "Brittlee", 0.0 },
  { "Brittley", 0.0 },
  { "Brittlyn", 0.0 },
  { "Brittlynn", 0.0 },
  { "Brittna", 0.0 },
  { "Brittnae", 0.0 },
  { "Brittnany", 0.0 },
  { "Brittnay", 0.0 },
  { "Brittne", 0.0 },
  { "Brittnea", 0.0 },
  { "Brittnee", 0.0 },
  { "Brittnei", 0.0 },
  { "Brittney", 0.0032309194 },
  { "Brittneyann", 0.0 },
  { "Brittni", 0.0010015023 },
  { "Brittnie", 0.0 },
  { "Brittnii", 0.0 },
  { "Brittny", 0.0 },
  { "Brittnye", 0.0 },
  { "Britton", 0.77795964 },
  { "Brittoni", 0.0 },
  { "Brittony", 0.0 },
  { "Britttany", 0.0 },
  { "Brittyn", 0.0 },
  { "Brityn", 0.0 },
  { "Britynn", 0.0 },
  { "Britza", 0.0 },
  { "Britzel", 0.0 },
  { "Britzy", 0.0 },
  { "Briuna", 0.0 },
  { "Briunna", 0.0 },
  { "Brix", 1.0 },
  { "Brixen", 1.0 },
  { "Brixley", 0.0 },
  { "Brixon", 1.0 },
  { "Brixten", 0.6666667 },
  { "Brixtin", 1.0 },
  { "Brixton", 0.90252393 },
  { "Brixtyn", 0.0 },
  { "Brixx", 1.0 },
  { "Briya", 0.0 },
  { "Briyah", 0.0 },
  { "Briyan", 1.0 },
  { "Briyana", 0.0 },
  { "Briyanah", 0.0 },
  { "Briyanna", 0.0 },
  { "Briyelle", 0.0 },
  { "Briyit", 0.0 },
  { "Briyith", 0.0 },
  { "Briyon", 1.0 },
  { "Briyona", 0.0 },
  { "Briyonna", 0.0 },
  { "Briza", 0.0 },
  { "Brizeida", 0.0 },
  { "Brizeth", 0.0 },
  { "Brizeyda", 0.0 },
  { "Brizia", 0.0 },
  { "Brizleth", 0.0 },
  { "Brizza", 0.0 },
  { "Brizzia", 0.0 },
  { "Brnadon", 1.0 },
  { "Brndon", 1.0 },
  { "Broadus", 1.0 },
  { "Broady", 1.0 },
  { "Broc", 1.0 },
  { "Broch", 1.0 },
  { "Brocha", 0.0 },
  { "Brock", 0.9981268 },
  { "Brockman", 1.0 },
  { "Brockston", 1.0 },
  { "Brockton", 1.0 },
  { "Brocton", 1.0 },
  { "Brodan", 1.0 },
  { "Brodderick", 1.0 },
  { "Broddrick", 1.0 },
  { "Brode", 1.0 },
  { "Brodee", 0.9744898 },
  { "Broden", 1.0 },
  { "Broder", 1.0 },
  { "Broderic", 1.0 },
  { "Broderick", 1.0 },
  { "Broderik", 1.0 },
  { "Brodey", 1.0 },
  { "Brodhi", 1.0 },
  { "Brodi", 0.8240866 },
  { "Brodie", 0.96099216 },
  { "Brodin", 1.0 },
  { "Brodix", 1.0 },
  { "Brodney", 1.0 },
  { "Brodric", 1.0 },
  { "Brodrick", 1.0 },
  { "Brodus", 1.0 },
  { "Brody", 0.99641716 },
  { "Brodyn", 1.0 },
  { "Broedy", 1.0 },
  { "Brogan", 0.8252607 },
  { "Brogen", 1.0 },
  { "Broghan", 0.825 },
  { "Brogyn", 1.0 },
  { "Brohdy", 1.0 },
  { "Brok", 1.0 },
  { "Brolin", 1.0 },
  { "Broly", 1.0 },
  { "Brom", 1.0 },
  { "Bromley", 1.0 },
  { "Bron", 1.0 },
  { "Brona", 0.0 },
  { "Bronagh", 0.0 },
  { "Bronc", 1.0 },
  { "Bronce", 1.0 },
  { "Bronco", 1.0 },
  { "Bronda", 0.0 },
  { "Brondon", 1.0 },
  { "Bronica", 0.0 },
  { "Bronis", 1.0 },
  { "Bronislaus", 1.0 },
  { "Bronislava", 0.0 },
  { "Bronislaw", 1.0 },
  { "Bronislawa", 0.0 },
  { "Bronko", 1.0 },
  { "Bronn", 1.0 },
  { "Bronna", 0.0 },
  { "Bronner", 1.0 },
  { "Bronnie", 0.10958904 },
  { "Bronsen", 1.0 },
  { "Bronson", 1.0 },
  { "Bronston", 1.0 },
  { "Bronsyn", 1.0 },
  { "Bronte", 0.021301774 },
  { "Bronti", 0.0 },
  { "Bronwen", 0.0 },
  { "Bronwyn", 0.0 },
  { "Bronwynn", 0.0 },
  { "Bronx", 0.98697066 },
  { "Bronxton", 1.0 },
  { "Bronze", 1.0 },
  { "Brook", 0.24068874 },
  { "Brookann", 0.0 },
  { "Brooke", 0.0106022 },
  { "Brookeann", 0.0 },
  { "Brookelin", 0.0 },
  { "Brookelle", 0.0 },
  { "Brookelyn", 0.0 },
  { "Brookelyne", 0.0 },
  { "Brookelynn", 0.0 },
  { "Brookelynne", 0.0 },
  { "Brooker", 1.0 },
  { "Brookes", 0.65625 },
  { "Brookie", 0.012915129 },
  { "Brooklan", 0.0 },
  { "Brooklee", 0.0 },
  { "Brookleigh", 0.0 },
  { "Brooklen", 0.0 },
  { "Brooklenn", 0.0 },
  { "Brookley", 0.0 },
  { "Brooklin", 0.0026910657 },
  { "Brooklinn", 0.0 },
  { "Brooklon", 0.0 },
  { "Brookly", 0.0 },
  { "Brooklyn", 0.0138148405 },
  { "Brooklyne", 0.0 },
  { "Brooklynmarie", 0.0 },
  { "Brooklynn", 0.0006951927 },
  { "Brooklynne", 0.0 },
  { "Brooklynrose", 0.0 },
  { "Brooks", 0.95264405 },
  { "Brooksey", 0.0 },
  { "Brooksie", 0.0 },
  { "Brooksley", 0.0 },
  { "Brookson", 1.0 },
  { "Brookston", 1.0 },
  { "Brookyln", 0.0 },
  { "Broox", 1.0 },
  { "Brooxie", 0.0 },
  { "Bror", 1.0 },
  { "Brosnan", 1.0 },
  { "Brother", 1.0 },
  { "Broughton", 1.0 },
  { "Broward", 1.0 },
  { "Browder", 1.0 },
  { "Browdy", 1.0 },
  { "Brown", 0.9965541 },
  { "Brownell", 1.0 },
  { "Brownie", 0.40942323 },
  { "Browning", 1.0 },
  { "Brownlow", 1.0 },
  { "Brox", 1.0 },
  { "Broxton", 1.0 },
  { "Brttany", 0.0 },
  { "Bruce", 0.9963468 },
  { "Brucelee", 1.0 },
  { "Brucha", 0.0 },
  { "Bruchy", 0.0 },
  { "Brucie", 0.0 },
  { "Bruin", 1.0 },
  { "Bruk", 1.0 },
  { "Bruke", 1.0 },
  { "Bruna", 0.0 },
  { "Brunell", 0.15625 },
  { "Brunella", 0.0 },
  { "Brunelle", 0.0 },
  { "Bruner", 1.0 },
  { "Brunetta", 0.0 },
  { "Brunette", 0.0 },
  { "Brunhilda", 0.0 },
  { "Brunilda", 0.0 },
  { "Brunna", 0.0 },
  { "Bruno", 1.0 },
  { "Brunson", 1.0 },
  { "Bruster", 1.0 },
  { "Brutus", 1.0 },
  { "Bry", 1.0 },
  { "Brya", 0.019607844 },
  { "Bryah", 0.0 },
  { "Bryahna", 0.0 },
  { "Bryam", 1.0 },
  { "Bryan", 0.995488 },
  { "Bryana", 0.0 },
  { "Bryanah", 0.0 },
  { "Bryand", 1.0 },
  { "Bryanda", 0.0 },
  { "Bryani", 0.0 },
  { "Bryann", 0.23126338 },
  { "Bryanna", 0.0 },
  { "Bryannah", 0.0 },
  { "Bryanne", 0.0 },
  { "Bryant", 0.99529815 },
  { "Bryar", 0.7908003 },
  { "Bryasha", 0.0 },
  { "Bryasia", 0.0 },
  { "Bryauna", 0.0 },
  { "Bryaunna", 0.0 },
  { "Bryce", 0.9739922 },
  { "Brycelyn", 0.0 },
  { "Brycelynn", 0.0 },
  { "Brycen", 0.9974298 },
  { "Brycenn", 1.0 },
  { "Bryceon", 1.0 },
  { "Bryceson", 1.0 },
  { "Bryceton", 1.0 },
  { "Brycie", 0.0 },
  { "Brycin", 1.0 },
  { "Brycn", 1.0 },
  { "Brycon", 1.0 },
  { "Brycson", 1.0 },
  { "Brycyn", 1.0 },
  { "Brydan", 1.0 },
  { "Bryden", 0.98511326 },
  { "Brydie", 0.0 },
  { "Brydin", 1.0 },
  { "Brydon", 1.0 },
  { "Brye", 0.7368421 },
  { "Bryell", 0.0 },
  { "Bryella", 0.0 },
  { "Bryelle", 0.0 },
  { "Bryen", 1.0 },
  { "Bryenna", 0.0 },
  { "Bryent", 1.0 },
  { "Bryer", 0.91508055 },
  { "Bryhana", 0.0 },
  { "Bryhanna", 0.0 },
  { "Bryheem", 1.0 },
  { "Bryia", 0.0 },
  { "Bryian", 1.0 },
  { "Bryiana", 0.0 },
  { "Bryianna", 0.0 },
  { "Bryice", 1.0 },
  { "Bryin", 1.0 },
  { "Bryken", 1.0 },
  { "Bryker", 1.0 },
  { "Bryla", 0.0 },
  { "Brylan", 0.9235352 },
  { "Bryland", 1.0 },
  { "Brylea", 0.0 },
  { "Bryleah", 0.0 },
  { "Brylee", 0.049656138 },
  { "Brylei", 0.0 },
  { "Bryleigh", 0.0 },
  { "Brylen", 0.89224136 },
  { "Bryler", 1.0 },
  { "Bryley", 0.19745223 },
  { "Bryli", 0.0 },
  { "Brylie", 0.0028901733 },
  { "Bryliee", 0.0 },
  { "Brylin", 0.53846157 },
  { "Brylinn", 0.0 },
  { "Brylon", 1.0 },
  { "Brylyn", 0.2037037 },
  { "Brylynn", 0.0 },
  { "Bryn", 0.15695772 },
  { "Bryna", 0.0 },
  { "Brynae", 0.0 },
  { "Brynda", 0.0 },
  { "Bryndal", 0.0 },
  { "Bryndan", 1.0 },
  { "Bryndee", 0.0 },
  { "Brynden", 1.0 },
  { "Bryndis", 0.0 },
  { "Bryndle", 0.0 },
  { "Bryndon", 1.0 },
  { "Bryne", 0.9478261 },
  { "Brynesha", 0.0 },
  { "Brynia", 0.0 },
  { "Bryniah", 0.0 },
  { "Brynisha", 0.0 },
  { "Brynja", 0.0 },
  { "Brynlea", 0.0 },
  { "Brynlee", 0.0010614585 },
  { "Brynlei", 0.0 },
  { "Brynleigh", 0.0 },
  { "Brynley", 0.0 },
  { "Brynli", 0.0 },
  { "Brynlie", 0.0 },
  { "Brynlin", 0.0 },
  { "Brynly", 0.0 },
  { "Brynlyn", 0.0 },
  { "Brynlynn", 0.0 },
  { "Brynn", 0.015061201 },
  { "Brynna", 0.0 },
  { "Brynnan", 0.0 },
  { "Brynne", 0.0 },
  { "Brynnen", 0.3181818 },
  { "Brynner", 1.0 },
  { "Brynnlea", 0.0 },
  { "Brynnlee", 0.0 },
  { "Brynnleigh", 0.0 },
  { "Brynnley", 0.0 },
  { "Brynnli", 0.0 },
  { "Brynnlie", 0.0 },
  { "Brynnly", 0.0 },
  { "Brynsley", 0.0 },
  { "Brynson", 1.0 },
  { "Brynt", 1.0 },
  { "Brynton", 1.0 },
  { "Brynzlee", 0.0 },
  { "Bryon", 0.9988305 },
  { "Bryona", 0.0 },
  { "Bryonna", 0.0 },
  { "Bryony", 0.0 },
  { "Bryor", 1.0 },
  { "Brysa", 0.0 },
  { "Brysan", 1.0 },
  { "Bryse", 0.96153843 },
  { "Bryseida", 0.0 },
  { "Brysen", 0.99746835 },
  { "Bryshaun", 1.0 },
  { "Bryshawn", 1.0 },
  { "Bryshere", 1.0 },
  { "Bryshon", 1.0 },
  { "Brysin", 1.0 },
  { "Bryson", 0.99577343 },
  { "Brysonn", 1.0 },
  { "Bryssa", 0.0 },
  { "Bryssia", 0.0 },
  { "Brystal", 0.0 },
  { "Brysten", 1.0 },
  { "Brystin", 1.0 },
  { "Brystle", 0.0 },
  { "Brystol", 0.018348623 },
  { "Bryston", 1.0 },
  { "Brysun", 1.0 },
  { "Brysyn", 1.0 },
  { "Brytan", 1.0 },
  { "Brytani", 0.0 },
  { "Brytanie", 0.0 },
  { "Brytanni", 0.0 },
  { "Brytany", 0.0 },
  { "Bryten", 0.9556962 },
  { "Brytin", 1.0 },
  { "Brytne", 0.0 },
  { "Brytnee", 0.0 },
  { "Brytney", 0.0 },
  { "Brytni", 0.0 },
  { "Brytnie", 0.0 },
  { "Bryton", 0.9396521 },
  { "Bryttani", 0.0 },
  { "Bryttanie", 0.0 },
  { "Bryttany", 0.0 },
  { "Bryttnee", 0.0 },
  { "Bryttney", 0.0 },
  { "Bryttni", 0.0 },
  { "Bryttnie", 0.0 },
  { "Bryttnii", 0.0 },
  { "Bryxton", 1.0 },
  { "Btittany", 0.0 },
  { "Bub", 1.0 },
  { "Bubba", 1.0 },
  { "Bubber", 1.0 },
  { "Bubbles", 0.0 },
  { "Bubby", 1.0 },
  { "Buchanan", 1.0 },
  { "Buck", 1.0 },
  { "Buckey", 1.0 },
  { "Buckie", 1.0 },
  { "Buckley", 1.0 },
  { "Buckner", 1.0 },
  { "Bucky", 1.0 },
  { "Bud", 1.0 },
  { "Budd", 1.0 },
  { "Buddie", 0.9966689 },
  { "Buddy", 0.99798524 },
  { "Bueford", 1.0 },
  { "Buel", 1.0 },
  { "Buela", 0.0 },
  { "Buelah", 0.0 },
  { "Buell", 1.0 },
  { "Buena", 0.0 },
  { "Buenaventura", 1.0 },
  { "Bufard", 1.0 },
  { "Buff", 0.3974359 },
  { "Buffey", 0.0 },
  { "Buffi", 0.0 },
  { "Buffie", 0.0 },
  { "Bufford", 1.0 },
  { "Buffy", 0.0018354236 },
  { "Buford", 0.98995525 },
  { "Bugra", 1.0 },
  { "Bukhari", 1.0 },
  { "Bula", 0.0 },
  { "Bulah", 0.0 },
  { "Bular", 0.0 },
  { "Buleah", 0.0 },
  { "Bulmaro", 1.0 },
  { "Bulut", 1.0 },
  { "Bun", 1.0 },
  { "Buna", 0.0 },
  { "Bundy", 1.0 },
  { "Bunia", 0.0 },
  { "Bunice", 0.0 },
  { "Bunie", 0.0 },
  { "Bunion", 1.0 },
  { "Bunita", 0.0 },
  { "Bunk", 1.0 },
  { "Bunni", 0.0 },
  { "Bunnie", 0.0724299 },
  { "Bunny", 0.07586558 },
  { "Bunyan", 1.0 },
  { "Bunyon", 1.0 },
  { "Burach", 1.0 },
  { "Burak", 1.0 },
  { "Bural", 1.0 },
  { "Burbon", 1.0 },
  { "Burce", 1.0 },
  { "Burch", 1.0 },
  { "Burchard", 1.0 },
  { "Burchel", 1.0 },
  { "Burchell", 1.0 },
  { "Burdell", 0.8514589 },
  { "Burdella", 0.0 },
  { "Burdelle", 0.0 },
  { "Burdena", 0.0 },
  { "Burdene", 0.0 },
  { "Burdett", 1.0 },
  { "Burdetta", 0.0 },
  { "Burdette", 0.93097824 },
  { "Burdie", 0.0 },
  { "Burdine", 0.0 },
  { "Burech", 1.0 },
  { "Burel", 1.0 },
  { "Burell", 1.0 },
  { "Buren", 1.0 },
  { "Burford", 1.0 },
  { "Burgandi", 0.0 },
  { "Burgandie", 0.0 },
  { "Burgandy", 0.0 },
  { "Burgess", 1.0 },
  { "Burgin", 1.0 },
  { "Burgundy", 0.0 },
  { "Burhan", 1.0 },
  { "Burhanuddin", 1.0 },
  { "Burie", 1.0 },
  { "Burim", 1.0 },
  { "Burk", 1.0 },
  { "Burke", 0.98987687 },
  { "Burklee", 0.0 },
  { "Burkleigh", 0.0 },
  { "Burkley", 0.5217391 },
  { "Burl", 0.9973515 },
  { "Burla", 0.0 },
  { "Burle", 1.0 },
  { "Burleen", 0.0 },
  { "Burleigh", 1.0 },
  { "Burlen", 1.0 },
  { "Burlene", 0.0 },
  { "Burley", 0.9829206 },
  { "Burlie", 0.7765363 },
  { "Burlin", 1.0 },
  { "Burline", 0.0 },
  { "Burlon", 1.0 },
  { "Burlyn", 1.0 },
  { "Burma", 0.0 },
  { "Burmah", 0.0 },
  { "Burman", 1.0 },
  { "Burna", 0.0 },
  { "Burnace", 1.0 },
  { "Burnadette", 0.0 },
  { "Burnadine", 0.0 },
  { "Burnam", 1.0 },
  { "Burnard", 1.0 },
  { "Burneice", 0.0 },
  { "Burnell", 0.8239311 },
  { "Burnelle", 0.0 },
  { "Burnes", 0.91935486 },
  { "Burnese", 0.0 },
  { "Burness", 1.0 },
  { "Burnest", 1.0 },
  { "Burnestine", 0.0 },
  { "Burnet", 1.0 },
  { "Burneta", 0.0 },
  { "Burnett", 0.8465293 },
  { "Burnetta", 0.0 },
  { "Burnette", 0.23370111 },
  { "Burney", 0.9943694 },
  { "Burnham", 1.0 },
  { "Burnice", 0.4553846 },
  { "Burnie", 0.9339019 },
  { "Burniece", 0.0 },
  { "Burnis", 0.9034335 },
  { "Burnita", 0.0 },
  { "Burnley", 1.0 },
  { "Burns", 1.0 },
  { "Buron", 1.0 },
  { "Burr", 1.0 },
  { "Burrel", 1.0 },
  { "Burrell", 1.0 },
  { "Burrill", 1.0 },
  { "Burris", 1.0 },
  { "Burrus", 1.0 },
  { "Burt", 1.0 },
  { "Burtha", 0.0 },
  { "Burtie", 0.0 },
  { "Burtis", 1.0 },
  { "Burton", 0.9978481 },
  { "Buruk", 1.0 },
  { "Burvin", 1.0 },
  { "Burwell", 1.0 },
  { "Buryl", 1.0 },
  { "Buse", 0.0 },
  { "Bush", 1.0 },
  { "Bushra", 0.0 },
  { "Busra", 0.0 },
  { "Buss", 1.0 },
  { "Buster", 0.9993802 },
  { "Butch", 1.0 },
  { "Butler", 1.0 },
  { "Butterfly", 0.0 },
  { "Buxton", 1.0 },
  { "Buz", 1.0 },
  { "Buzz", 1.0 },
  { "Buzzy", 1.0 },
  { "Bwana", 1.0 },
  { "Byan", 1.0 },
  { "Byanca", 0.0 },
  { "Byanka", 0.0 },
  { "Byard", 1.0 },
  { "Byata", 0.0 },
  { "Byford", 1.0 },
  { "Byntlee", 0.84375 },
  { "Bynum", 1.0 },
  { "Byonce", 0.0 },
  { "Byra", 0.0 },
  { "Byran", 1.0 },
  { "Byrant", 1.0 },
  { "Byrce", 1.0 },
  { "Byrd", 0.73700625 },
  { "Byrde", 0.0 },
  { "Byrdie", 0.0 },
  { "Byren", 1.0 },
  { "Byrl", 0.90924656 },
  { "Byrle", 0.53333336 },
  { "Byrne", 1.0 },
  { "Byrnece", 0.0 },
  { "Byron", 0.9962643 },
  { "Byrum", 1.0 },
  { "Byson", 1.0 },
  { "Caaden", 1.0 },
  { "Caaliyah", 0.0 },
  { "Caanan", 1.0 },
  { "Caasi", 0.0 },
  { "Cabe", 1.0 },
  { "Cabel", 1.0 },
  { "Cabela", 0.0 },
  { "Cabell", 1.0 },
  { "Cabella", 0.0 },
  { "Cable", 1.0 },
  { "Cabot", 1.0 },
  { "Cabral", 1.0 },
  { "Cabren", 1.0 },
  { "Cabria", 0.0 },
  { "Cabrielle", 0.0 },
  { "Cabrina", 0.0 },
  { "Cabrini", 0.0 },
  { "Cace", 1.0 },
  { "Cacee", 0.0 },
  { "Cacey", 0.07798165 },
  { "Cache", 0.6078767 },
  { "Cachet", 0.0 },
  { "Caci", 0.0 },
  { "Cacia", 0.0 },
  { "Cacie", 0.0 },
  { "Cacy", 0.0 },
  { "Cad", 1.0 },
  { "Cada", 0.0 },
  { "Cadan", 1.0 },
  { "Cadance", 0.005688282 },
  { "Cadarius", 1.0 },
  { "Cadarrius", 1.0 },
  { "Cadden", 1.0 },
  { "Caddie", 0.0 },
  { "Cade", 0.995956 },
  { "Cadedra", 0.0 },
  { "Cadee", 0.0 },
  { "Cadeidra", 0.0 },
  { "Cadeisha", 0.0 },
  { "Cadeja", 0.0 },
  { "Cadejah", 0.0 },
  { "Cadel", 1.0 },
  { "Cadell", 1.0 },
  { "Cadem", 1.0 },
  { "Cademon", 1.0 },
  { "Caden", 0.9856904 },
  { "Cadence", 0.065730534 },
  { "Cadense", 0.0 },
  { "Cadesha", 0.0 },
  { "Cadeshia", 0.0 },
  { "Cadesia", 0.0 },
  { "Cadet", 1.0 },
  { "Cadey", 0.0 },
  { "Cadge", 1.0 },
  { "Cadhla", 0.0 },
  { "Cadi", 0.0 },
  { "Cadia", 0.0 },
  { "Cadian", 1.0 },
  { "Cadie", 0.0 },
  { "Cadien", 1.0 },
  { "Cadience", 0.0 },
  { "Cadijah", 0.0 },
  { "Cadillac", 1.0 },
  { "Cadin", 0.9752322 },
  { "Cadince", 0.0 },
  { "Cadisha", 0.0 },
  { "Cadon", 1.0 },
  { "Cadrian", 0.6296296 },
  { "Cady", 0.008837826 },
  { "Cadyn", 0.71251935 },
  { "Cadynce", 0.0 },
  { "Caed", 1.0 },
  { "Caedan", 1.0 },
  { "Caedance", 0.0 },
  { "Caeden", 0.98432434 },
  { "Caedence", 0.0 },
  { "Caedin", 1.0 },
  { "Caedmon", 1.0 },
  { "Caedon", 1.0 },
  { "Caedyn", 0.79019076 },
  { "Cael", 0.99597526 },
  { "Caela", 0.0 },
  { "Caelainn", 0.0 },
  { "Caelan", 0.76484287 },
  { "Caeleb", 1.0 },
  { "Caelee", 0.0 },
  { "Caeleigh", 0.0 },
  { "Caelen", 0.8721374 },
  { "Caeley", 0.0 },
  { "Caeli", 0.0 },
  { "Caelia", 0.0 },
  { "Caelie", 0.0 },
  { "Caelin", 0.43137255 },
  { "Caelix", 1.0 },
  { "Caellum", 1.0 },
  { "Caelob", 1.0 },
  { "Caelon", 1.0 },
  { "Caelum", 1.0 },
  { "Caely", 0.0 },
  { "Caelyn", 0.002408478 },
  { "Caelynn", 0.0 },
  { "Caera", 0.0 },
  { "Caesar", 1.0 },
  { "Caesare", 0.8076923 },
  { "Caeser", 1.0 },
  { "Caeson", 1.0 },
  { "Caesyn", 1.0 },
  { "Caetano", 1.0 },
  { "Caetlin", 0.0 },
  { "Caetlyn", 0.0 },
  { "Caezar", 1.0 },
  { "Caffey", 0.0 },
  { "Caffie", 0.0 },
  { "Caffrey", 1.0 },
  { "Cagan", 1.0 },
  { "Cage", 1.0 },
  { "Cager", 1.0 },
  { "Cagney", 0.36082473 },
  { "Cahari", 1.0 },
  { "Cahill", 1.0 },
  { "Cahlia", 0.0 },
  { "Cahlil", 1.0 },
  { "Cahlin", 0.0 },
  { "Cahmari", 1.0 },
  { "Cahner", 1.0 },
  { "Cahterine", 0.0 },
  { "Cahya", 0.0 },
  { "Cai", 0.72930866 },
  { "Caia", 0.0 },
  { "Caiah", 0.0 },
  { "Caid", 1.0 },
  { "Caida", 0.0 },
  { "Caidan", 1.0 },
  { "Caidance", 0.0 },
  { "Caide", 1.0 },
  { "Caidee", 0.0 },
  { "Caiden", 0.973911 },
  { "Caidence", 0.09117647 },
  { "Caidenn", 1.0 },
  { "Caidin", 1.0 },
  { "Caidon", 1.0 },
  { "Caidy", 0.0 },
  { "Caidyn", 0.60105264 },
  { "Caidynce", 0.0 },
  { "Caige", 1.0 },
  { "Cail", 1.0 },
  { "Caila", 0.0 },
  { "Cailah", 0.0 },
  { "Cailan", 0.6519608 },
  { "Caile", 0.0 },
  { "Cailean", 0.8 },
  { "Caileb", 1.0 },
  { "Cailee", 0.0 },
  { "Caileen", 0.0 },
  { "Caileigh", 0.0 },
  { "Cailen", 0.51715684 },
  { "Cailey", 0.0 },
  { "Caili", 0.0 },
  { "Cailie", 0.0 },
  { "Cailin", 0.008493771 },
  { "Cailley", 0.0 },
  { "Caillou", 1.0 },
  { "Cailon", 0.0 },
  { "Cailtin", 0.0 },
  { "Cailum", 1.0 },
  { "Caily", 0.0 },
  { "Cailyn", 0.0 },
  { "Cailynn", 0.0 },
  { "Cailynne", 0.0 },
  { "Caiman", 1.0 },
  { "Caimen", 1.0 },
  { "Caimin", 1.0 },
  { "Caimon", 1.0 },
  { "Cain", 1.0 },
  { "Cainan", 1.0 },
  { "Caine", 1.0 },
  { "Cainen", 1.0 },
  { "Cainin", 1.0 },
  { "Cainon", 1.0 },
  { "Caio", 1.0 },
  { "Caira", 0.0 },
  { "Cairah", 0.0 },
  { "Cairee", 1.0 },
  { "Cairi", 0.0 },
  { "Cairl", 1.0 },
  { "Cairn", 0.0 },
  { "Cairo", 0.89958656 },
  { "Cairon", 1.0 },
  { "Cairra", 0.0 },
  { "Caisen", 1.0 },
  { "Caisey", 0.0 },
  { "Caisha", 0.0 },
  { "Caisley", 0.0 },
  { "Caislynn", 0.0 },
  { "Caison", 1.0 },
  { "Caisyn", 0.525 },
  { "Cait", 0.0 },
  { "Caite", 0.0 },
  { "Caitelyn", 0.0 },
  { "Caithlin", 0.0 },
  { "Caitie", 0.0 },
  { "Caitilin", 0.0 },
  { "Caitilyn", 0.0 },
  { "Caitin", 0.0 },
  { "Caitlain", 0.0 },
  { "Caitlan", 0.0 },
  { "Caitland", 0.0 },
  { "Caitlen", 0.0 },
  { "Caitlin", 0.0025403493 },
  { "Caitline", 0.0 },
  { "Caitlinn", 0.0 },
  { "Caitlyn", 0.0006621227 },
  { "Caitlynd", 0.0 },
  { "Caitlyne", 0.0 },
  { "Caitlynn", 0.0 },
  { "Caitlynne", 0.0 },
  { "Caitria", 0.0 },
  { "Caitrin", 0.0 },
  { "Caitriona", 0.0 },
  { "Caitryn", 0.0 },
  { "Caity", 0.0 },
  { "Caityln", 0.0 },
  { "Caitylyn", 0.0 },
  { "Caius", 1.0 },
  { "Caiya", 0.0 },
  { "Caiyah", 0.0 },
  { "Caiyden", 1.0 },
  { "Cajuan", 1.0 },
  { "Cajun", 1.0 },
  { "Cal", 0.99808025 },
  { "Cala", 0.0 },
  { "Calab", 1.0 },
  { "Calaeb", 1.0 },
  { "Calah", 0.0 },
  { "Calahan", 1.0 },
  { "Calais", 0.0 },
  { "Calamity", 0.0 },
  { "Calan", 0.9690881 },
  { "Calanda", 0.0 },
  { "Calandra", 0.0 },
  { "Calandria", 0.0 },
  { "Calani", 0.0 },
  { "Calantha", 0.0 },
  { "Calanthe", 0.0 },
  { "Calasia", 0.0 },
  { "Calaya", 0.0 },
  { "Calayah", 0.0 },
  { "Calaysia", 0.0 },
  { "Calbe", 1.0 },
  { "Calbert", 1.0 },
  { "Calcifer", 1.0 },
  { "Calden", 1.0 },
  { "Calder", 0.98093843 },
  { "Caldonia", 0.0 },
  { "Caldwell", 1.0 },
  { "Cale", 0.9893872 },
  { "Calea", 0.0 },
  { "Caleab", 1.0 },
  { "Caleah", 0.0 },
  { "Caleal", 1.0 },
  { "Caleb", 0.9978526 },
  { "Calebe", 1.0 },
  { "Calebjames", 1.0 },
  { "Caled", 1.0 },
  { "Caledonia", 0.0 },
  { "Calee", 0.0 },
  { "Caleel", 1.0 },
  { "Caleen", 0.0 },
  { "Caleena", 0.0 },
  { "Caleesha", 0.0 },
  { "Caleesi", 0.0 },
  { "Calei", 0.0 },
  { "Caleia", 0.0 },
  { "Caleiah", 0.0 },
  { "Caleigh", 0.0 },
  { "Caleigha", 0.0 },
  { "Calek", 1.0 },
  { "Calel", 1.0 },
  { "Calem", 1.0 },
  { "Calen", 0.9035777 },
  { "Calena", 0.0 },
  { "Calene", 0.0 },
  { "Caleob", 1.0 },
  { "Calep", 1.0 },
  { "Calese", 0.0 },
  { "Calesha", 0.0 },
  { "Caleshia", 0.0 },
  { "Caletha", 0.0 },
  { "Calev", 1.0 },
  { "Calex", 1.0 },
  { "Caley", 0.059285432 },
  { "Caleya", 0.0 },
  { "Caleyah", 0.0 },
  { "Calhan", 1.0 },
  { "Calhoun", 1.0 },
  { "Cali", 0.009807148 },
  { "Calia", 0.0 },
  { "Caliah", 0.0 },
  { "Calian", 1.0 },
  { "Caliana", 0.0 },
  { "Caliann", 0.0 },
  { "Calianna", 0.0 },
  { "Calianne", 0.0 },
  { "Calib", 1.0 },
  { "Caliber", 0.95454544 },
  { "Calice", 0.0 },
  { "Calicia", 0.0 },
  { "Calida", 0.0 },
  { "Calie", 0.0 },
  { "Calieb", 1.0 },
  { "Caliee", 0.0 },
  { "Caliegh", 0.0 },
  { "Caliel", 1.0 },
  { "Caliese", 0.0 },
  { "California", 0.0 },
  { "Calii", 0.0 },
  { "Calijah", 1.0 },
  { "Calik", 1.0 },
  { "Calil", 1.0 },
  { "Calilynn", 0.0 },
  { "Calimarie", 0.0 },
  { "Calin", 0.81069607 },
  { "Calina", 0.0 },
  { "Calinda", 0.0 },
  { "Caline", 0.0 },
  { "Calionna", 0.0 },
  { "Caliope", 0.0 },
  { "Calip", 1.0 },
  { "Caliph", 1.0 },
  { "Calirae", 0.0 },
  { "Calirose", 0.0 },
  { "Calis", 0.0 },
  { "Calisa", 0.0 },
  { "Calise", 0.0 },
  { "Calisha", 0.0 },
  { "Calisi", 0.0 },
  { "Calissa", 0.0 },
  { "Calisse", 0.0 },
  { "Calista", 0.0 },
  { "Calisto", 1.0 },
  { "Calistro", 1.0 },
  { "Calita", 0.0 },
  { "Calix", 1.0 },
  { "Calixta", 0.0 },
  { "Calixto", 1.0 },
  { "Calixtro", 1.0 },
  { "Caliya", 0.0 },
  { "Caliyah", 0.0 },
  { "Calizza", 0.0 },
  { "Calla", 0.0 },
  { "Callaghan", 0.87741935 },
  { "Callah", 0.0 },
  { "Callahan", 0.6927298 },
  { "Callalily", 0.0 },
  { "Callan", 0.73530877 },
  { "Callandra", 0.0 },
  { "Callasandra", 0.0 },
  { "Callaway", 0.51435405 },
  { "Calle", 0.0 },
  { "Callee", 0.0 },
  { "Calleen", 0.0 },
  { "Calleigh", 0.0 },
  { "Callen", 0.91518146 },
  { "Calletana", 0.0 },
  { "Calletano", 1.0 },
  { "Calley", 0.0 },
  { "Calli", 0.0 },
  { "Callia", 0.0 },
  { "Calliah", 0.0 },
  { "Calliana", 0.0 },
  { "Callianna", 0.0 },
  { "Callianne", 0.0 },
  { "Callie", 0.011236156 },
  { "Callieann", 0.0 },
  { "Calliegh", 0.0 },
  { "Calliemae", 0.0 },
  { "Callin", 0.9430894 },
  { "Calliope", 0.0 },
  { "Callis", 1.0 },
  { "Callisa", 0.0 },
  { "Callison", 0.0 },
  { "Callissa", 0.0 },
  { "Callista", 0.0 },
  { "Callister", 1.0 },
  { "Callisto", 0.0 },
  { "Callon", 1.0 },
  { "Calloway", 0.9138756 },
  { "Callum", 1.0 },
  { "Cally", 0.0 },
  { "Callye", 0.0 },
  { "Callyn", 0.013550135 },
  { "Callysta", 0.0 },
  { "Calman", 1.0 },
  { "Calmer", 1.0 },
  { "Calob", 1.0 },
  { "Calogera", 0.0 },
  { "Calogero", 1.0 },
  { "Calon", 1.0 },
  { "Calondra", 0.0 },
  { "Calonia", 0.0 },
  { "Calsey", 0.0 },
  { "Caltlin", 0.0 },
  { "Calton", 1.0 },
  { "Calub", 1.0 },
  { "Caludia", 0.0 },
  { "Calum", 1.0 },
  { "Calvan", 1.0 },
  { "Calvary", 0.4021739 },
  { "Calven", 1.0 },
  { "Calvert", 1.0 },
  { "Calvester", 1.0 },
  { "Calvin", 0.9939994 },
  { "Calvina", 0.0 },
  { "Calvinesha", 0.0 },
  { "Calvion", 1.0 },
  { "Calvon", 1.0 },
  { "Calvyn", 1.0 },
  { "Caly", 0.0 },
  { "Calyb", 1.0 },
  { "Calyce", 0.0 },
  { "Calyn", 0.099734046 },
  { "Calynn", 0.0 },
  { "Calynne", 0.0 },
  { "Calypso", 0.0 },
  { "Calyse", 0.0 },
  { "Calyssa", 0.0 },
  { "Calysta", 0.0 },
  { "Calyx", 0.54022986 },
  { "Cam", 0.83255816 },
  { "Cama", 0.0 },
  { "Camacho", 1.0 },
  { "Camaira", 0.0 },
  { "Camaiya", 0.0 },
  { "Camala", 0.0 },
  { "Camalla", 0.0 },
  { "Camani", 0.234375 },
  { "Camar", 1.0 },
  { "Camara", 0.1042471 },
  { "Camare", 1.0 },
  { "Camaree", 0.54545456 },
  { "Camaren", 0.91525424 },
  { "Camareon", 1.0 },
  { "Camari", 0.5948492 },
  { "Camaria", 0.0 },
  { "Camariah", 0.0 },
  { "Camarie", 0.09767442 },
  { "Camarii", 1.0 },
  { "Camario", 1.0 },
  { "Camarion", 1.0 },
  { "Camariyah", 0.0 },
  { "Camaro", 0.40625 },
  { "Camaron", 0.92896175 },
  { "Camarri", 0.5 },
  { "Camary", 0.0 },
  { "Camaryn", 0.0 },
  { "Camas", 0.0 },
  { "Camauri", 0.61413044 },
  { "Camaury", 1.0 },
  { "Camay", 0.0 },
  { "Camaya", 0.0 },
  { "Cambel", 0.0 },
  { "Cambell", 0.2744361 },
  { "Cambelle", 0.0 },
  { "Camber", 0.056016598 },
  { "Camberly", 0.0 },
  { "Cambi", 0.0 },
  { "Cambra", 0.0 },
  { "Cambre", 0.0 },
  { "Cambrea", 0.0 },
  { "Cambree", 0.0 },
  { "Cambreigh", 0.0 },
  { "Cambren", 1.0 },
  { "Cambrey", 0.0 },
  { "Cambri", 0.0 },
  { "Cambria", 0.0 },
  { "Cambriah", 0.0 },
  { "Cambridge", 0.53535354 },
  { "Cambrie", 0.0 },
  { "Cambriella", 0.0 },
  { "Cambrielle", 0.0 },
  { "Cambron", 1.0 },
  { "Cambry", 0.0 },
  { "Cambrya", 0.0 },
  { "Cambryn", 0.19135803 },
  { "Cambrynn", 0.0 },
  { "Camdan", 1.0 },
  { "Camden", 0.9347102 },
  { "Camdin", 1.0 },
  { "Camdon", 1.0 },
  { "Camdyn", 0.5481941 },
  { "Camdynn", 0.27631578 },
  { "Camea", 0.0 },
  { "Cameca", 0.0 },
  { "Camecia", 0.0 },
  { "Camee", 0.0 },
  { "Cameika", 0.0 },
  { "Cameil", 0.0 },
  { "Cameisha", 0.0 },
  { "Cameka", 0.0 },
  { "Camela", 0.0 },
  { "Camelia", 0.0 },
  { "Camella", 0.0 },
  { "Camelle", 0.0 },
  { "Camellia", 0.0 },
  { "Camello", 1.0 },
  { "Camelo", 1.0 },
  { "Camely", 0.0 },
  { "Camen", 0.84615386 },
  { "Cameo", 0.12566371 },
  { "Cameon", 1.0 },
  { "Camera", 0.0 },
  { "Cameran", 0.5216895 },
  { "Cameren", 0.8564626 },
  { "Cameria", 0.0 },
  { "Camerin", 0.7008872 },
  { "Camerina", 0.0 },
  { "Camerino", 1.0 },
  { "Camerion", 1.0 },
  { "Cameron", 0.9089988 },
  { "Camerone", 1.0 },
  { "Camerron", 1.0 },
  { "Camerson", 1.0 },
  { "Camery", 0.0 },
  { "Cameryn", 0.22112 },
  { "Camerynn", 0.0 },
  { "Camesha", 0.0 },
  { "Cameshia", 0.0 },
  { "Camey", 0.0 },
  { "Cami", 0.0 },
  { "Camia", 0.0 },
  { "Camiah", 0.0 },
  { "Camica", 0.0 },
  { "Camie", 0.0 },
  { "Camiel", 0.7 },
  { "Camielle", 0.0 },
  { "Camiesha", 0.0 },
  { "Camika", 0.0 },
  { "Camil", 0.39007092 },
  { "Camila", 0.00087950745 },
  { "Camilah", 0.0 },
  { "Camile", 0.036065575 },
  { "Camili", 0.0 },
  { "Camilia", 0.0 },
  { "Camill", 0.0 },
  { "Camilla", 0.00028684802 },
  { "Camillah", 0.0 },
  { "Camille", 0.020291308 },
  { "Camillemarie", 0.0 },
  { "Camillia", 0.0 },
  { "Camillie", 0.0 },
  { "Camillo", 1.0 },
  { "Camillus", 1.0 },
  { "Camilly", 0.0 },
  { "Camillya", 0.0 },
  { "Camilo", 1.0 },
  { "Camily", 0.0 },
  { "Camilya", 0.0 },
  { "Camira", 0.0 },
  { "Camirah", 0.0 },
  { "Camiren", 1.0 },
  { "Camiron", 1.0 },
  { "Camiryn", 0.0 },
  { "Camisa", 0.0 },
  { "Camisha", 0.0 },
  { "Camishia", 0.0 },
  { "Camiya", 0.0 },
  { "Camiyah", 0.0 },
  { "Camlin", 0.5 },
  { "Camlyn", 0.0 },
  { "Camm", 1.0 },
  { "Cammeron", 1.0 },
  { "Cammi", 0.0 },
  { "Cammie", 0.0071905497 },
  { "Cammille", 0.0 },
  { "Cammron", 1.0 },
  { "Cammy", 0.0 },
  { "Camon", 1.0 },
  { "Camoni", 0.0 },
  { "Camonte", 1.0 },
  { "Camora", 0.0 },
  { "Camorah", 0.0 },
  { "Camoren", 1.0 },
  { "Camori", 0.0 },
  { "Camorra", 0.0 },
  { "Camoya", 0.0 },
  { "Camp", 1.0 },
  { "Campbell", 0.45921385 },
  { "Campbelle", 0.0 },
  { "Camper", 1.0 },
  { "Campion", 1.0 },
  { "Campton", 1.0 },
  { "Camra", 0.0 },
  { "Camran", 0.9411765 },
  { "Camree", 0.0 },
  { "Camren", 0.91391563 },
  { "Camreon", 1.0 },
  { "Camrey", 0.0 },
  { "Camri", 0.0 },
  { "Camrie", 0.0 },
  { "Camrin", 0.8145973 },
  { "Camrion", 1.0 },
  { "Camron", 0.97170013 },
  { "Camrun", 1.0 },
  { "Camry", 0.089955024 },
  { "Camryn", 0.13131493 },
  { "Camryne", 0.0 },
  { "Camrynn", 0.0669145 },
  { "Camrynne", 0.0 },
  { "Camy", 0.0 },
  { "Camya", 0.0 },
  { "Camyah", 0.0 },
  { "Camyia", 0.0 },
  { "Camyiah", 0.0 },
  { "Camyla", 0.0 },
  { "Camylle", 0.0 },
  { "Camyra", 0.0 },
  { "Camyrah", 0.0 },
  { "Camyri", 0.0 },
  { "Camyria", 0.0 },
  { "Camyrn", 0.0 },
  { "Camyron", 0.6875 },
  { "Can", 1.0 },
  { "Cana", 0.0 },
  { "Canaan", 0.9329779 },
  { "Canace", 0.0 },
  { "Canada", 0.0 },
  { "Canan", 0.8484849 },
  { "Canary", 0.0 },
  { "Canasia", 0.0 },
  { "Canda", 0.0 },
  { "Candace", 0.0018688936 },
  { "Candan", 1.0 },
  { "Candance", 0.0 },
  { "Candas", 0.0 },
  { "Candase", 0.0 },
  { "Cande", 0.0 },
  { "Candece", 0.0 },
  { "Candee", 0.0 },
  { "Candela", 0.0 },
  { "Candelaria", 0.0 },
  { "Candelario", 1.0 },
  { "Canden", 1.0 },
  { "Candence", 0.0 },
  { "Candes", 0.0 },
  { "Candess", 0.0 },
  { "Candi", 0.0 },
  { "Candia", 0.0 },
  { "Candiace", 0.0 },
  { "Candiance", 0.0 },
  { "Candias", 0.0 },
  { "Candic", 0.0 },
  { "Candice", 0.0022894111 },
  { "Candid", 0.0 },
  { "Candida", 0.0 },
  { "Candido", 1.0 },
  { "Candie", 0.0 },
  { "Candiece", 0.0 },
  { "Candies", 0.0 },
  { "Candina", 0.0 },
  { "Candis", 0.0 },
  { "Candise", 0.0 },
  { "Candiss", 0.0 },
  { "Candita", 0.0 },
  { "Candius", 0.0 },
  { "Candle", 0.0 },
  { "Candler", 0.92537314 },
  { "Candon", 1.0 },
  { "Candra", 0.0 },
  { "Candrea", 0.0 },
  { "Candria", 0.0 },
  { "Candrice", 0.0 },
  { "Candus", 0.0 },
  { "Candy", 0.0035371936 },
  { "Candyce", 0.0 },
  { "Candye", 0.0 },
  { "Candys", 0.0 },
  { "Candyse", 0.0 },
  { "Cane", 1.0 },
  { "Canei", 0.0 },
  { "Caneisha", 0.0 },
  { "Canek", 1.0 },
  { "Canela", 0.0 },
  { "Canelo", 1.0 },
  { "Canen", 1.0 },
  { "Canesha", 0.0 },
  { "Caneshia", 0.0 },
  { "Canessa", 0.0 },
  { "Canh", 1.0 },
  { "Cania", 0.0 },
  { "Caniah", 0.0 },
  { "Canice", 0.0 },
  { "Caniesha", 0.0 },
  { "Canin", 1.0 },
  { "Canio", 1.0 },
  { "Canisha", 0.0 },
  { "Canishia", 0.0 },
  { "Canita", 0.0 },
  { "Caniya", 0.0 },
  { "Caniyah", 0.0 },
  { "Canna", 0.0 },
  { "Cannan", 1.0 },
  { "Cannen", 1.0 },
  { "Cannie", 0.022624435 },
  { "Cannin", 1.0 },
  { "Cannon", 0.97886705 },
  { "Canon", 0.9871037 },
  { "Cansas", 0.0 },
  { "Cansu", 0.0 },
  { "Cante", 0.0 },
  { "Cantina", 0.0 },
  { "Canton", 1.0 },
  { "Cantrece", 0.0 },
  { "Cantrell", 0.8611111 },
  { "Cantrice", 0.0 },
  { "Canuto", 1.0 },
  { "Canya", 0.0 },
  { "Canye", 1.0 },
  { "Canyen", 1.0 },
  { "Canyla", 0.0 },
  { "Canyn", 1.0 },
  { "Canyon", 0.9457639 },
  { "Caoilainn", 0.0 },
  { "Caoilinn", 0.0 },
  { "Caoimhe", 0.0 },
  { "Caolan", 1.0 },
  { "Cap", 1.0 },
  { "Cape", 1.0 },
  { "Capella", 0.0 },
  { "Capers", 1.0 },
  { "Capitola", 0.0 },
  { "Capone", 1.0 },
  { "Capp", 1.0 },
  { "Cappie", 0.0 },
  { "Cappy", 0.5 },
  { "Caprece", 0.0 },
  { "Caprecia", 0.0 },
  { "Capree", 0.15151516 },
  { "Capresha", 0.0 },
  { "Capri", 0.018874172 },
  { "Capria", 0.0 },
  { "Caprial", 0.0 },
  { "Capriana", 0.0 },
  { "Caprica", 0.0 },
  { "Caprice", 0.04933256 },
  { "Capricia", 0.0 },
  { "Caprina", 0.0 },
  { "Caprise", 0.0 },
  { "Caprisha", 0.0 },
  { "Captain", 1.0 },
  { "Captola", 0.0 },
  { "Captolia", 0.0 },
  { "Capucine", 0.0 },
  { "Capus", 1.0 },
  { "Car", 1.0 },
  { "Cara", 0.0012108902 },
  { "Carabella", 0.0 },
  { "Carabelle", 0.0 },
  { "Caragan", 0.0 },
  { "Caragh", 0.0 },
  { "Carah", 0.0 },
  { "Caral", 0.0 },
  { "Caralee", 0.0 },
  { "Caraleigh", 0.0 },
  { "Caralena", 0.0 },
  { "Caralina", 0.0 },
  { "Caraline", 0.0 },
  { "Caralyn", 0.0 },
  { "Caralyne", 0.0 },
  { "Caralynn", 0.0 },
  { "Caramia", 0.0 },
  { "Caramie", 0.0 },
  { "Caran", 0.0 },
  { "Carbon", 1.0 },
  { "Carcyn", 0.0 },
  { "Cardae", 1.0 },
  { "Cardale", 1.0 },
  { "Cardarius", 1.0 },
  { "Cardea", 1.0 },
  { "Cardel", 1.0 },
  { "Cardelia", 0.0 },
  { "Cardell", 0.9900433 },
  { "Cardella", 0.0 },
  { "Carden", 0.89403975 },
  { "Carder", 1.0 },
  { "Cardero", 1.0 },
  { "Cardia", 0.0 },
  { "Cardie", 0.0 },
  { "Cardier", 1.0 },
  { "Cardin", 0.9228395 },
  { "Cardine", 0.0 },
  { "Cardis", 1.0 },
  { "Cardiss", 0.0 },
  { "Cardon", 1.0 },
  { "Cardyn", 0.0 },
  { "Care", 1.0 },
  { "Caree", 0.0 },
  { "Careem", 1.0 },
  { "Careen", 0.0 },
  { "Careena", 0.0 },
  { "Careese", 0.0 },
  { "Carel", 0.70731705 },
  { "Careli", 0.0 },
  { "Carell", 1.0 },
  { "Carelle", 0.0 },
  { "Carely", 0.0 },
  { "Carelyn", 0.0 },
  { "Caren", 0.0 },
  { "Carena", 0.0 },
  { "Carenda", 0.0 },
  { "Carene", 0.0 },
  { "Careron", 1.0 },
  { "Caresa", 0.0 },
  { "Caresha", 0.0 },
  { "Caress", 0.0 },
  { "Caressa", 0.0 },
  { "Caresse", 0.0 },
  { "Caretha", 0.0 },
  { "Caretta", 0.0 },
  { "Carey", 0.56891865 },
  { "Careyann", 0.0 },
  { "Cari", 0.0043744533 },
  { "Caria", 0.0 },
  { "Cariah", 0.0 },
  { "Cariana", 0.0 },
  { "Cariann", 0.0 },
  { "Carianna", 0.0 },
  { "Carianne", 0.0 },
  { "Caribbean", 0.0 },
  { "Caribe", 1.0 },
  { "Carice", 0.0 },
  { "Caricia", 0.0 },
  { "Caridad", 0.0 },
  { "Caridee", 0.0 },
  { "Carie", 0.0 },
  { "Cariel", 0.0 },
  { "Carielle", 0.0 },
  { "Carig", 1.0 },
  { "Carigan", 0.0 },
  { "Caril", 0.0 },
  { "Carilee", 0.0 },
  { "Carilla", 0.0 },
  { "Carilyn", 0.0 },
  { "Carilynn", 0.0 },
  { "Carime", 0.0 },
  { "Carin", 0.0 },
  { "Carina", 0.002352783 },
  { "Carinda", 0.0 },
  { "Carine", 0.0 },
  { "Carington", 0.0 },
  { "Carinna", 0.0 },
  { "Carinne", 0.0 },
  { "Cario", 1.0 },
  { "Carion", 1.0 },
  { "Caris", 0.0 },
  { "Carisa", 0.0 },
  { "Carise", 0.0 },
  { "Carisha", 0.0 },
  { "Carisia", 0.0 },
  { "Carisma", 0.0 },
  { "Cariss", 0.0 },
  { "Carissa", 0.0004320121 },
  { "Carisse", 0.0 },
  { "Carissia", 0.0 },
  { "Carista", 0.0 },
  { "Carita", 0.0 },
  { "Caritina", 0.0 },
  { "Cariya", 0.0 },
  { "Cariyah", 0.0 },
  { "Carizma", 0.0 },
  { "Carl", 0.9936852 },
  { "Carla", 0.0028687448 },
  { "Carlan", 0.61538464 },
  { "Carlana", 0.0 },
  { "Carland", 1.0 },
  { "Carlann", 0.0 },
  { "Carlanthony", 1.0 },
  { "Carlas", 0.7467811 },
  { "Carlasia", 0.0 },
  { "Carlaya", 0.0 },
  { "Carlaysia", 0.0 },
  { "Carle", 0.76237625 },
  { "Carlea", 0.0 },
  { "Carleah", 0.0 },
  { "Carlean", 0.0 },
  { "Carlecia", 0.0 },
  { "Carlee", 0.026183797 },
  { "Carleen", 0.0 },
  { "Carleena", 0.0 },
  { "Carleene", 0.0 },
  { "Carlei", 0.0 },
  { "Carleigh", 0.0 },
  { "Carleigha", 0.0 },
  { "Carleisha", 0.0 },
  { "Carlen", 0.1576087 },
  { "Carlena", 0.0 },
  { "Carlene", 0.0 },
  { "Carlens", 1.0 },
  { "Carleon", 1.0 },
  { "Carles", 0.9925262 },
  { "Carlese", 0.0 },
  { "Carlesha", 0.0 },
  { "Carleshia", 0.0 },
  { "Carlesia", 0.0 },
  { "Carless", 1.0 },
  { "Carlester", 1.0 },
  { "Carlet", 0.0 },
  { "Carleta", 0.0 },
  { "Carletha", 0.0 },
  { "Carlethia", 0.0 },
  { "Carleton", 1.0 },
  { "Carlett", 0.0 },
  { "Carletta", 0.0 },
  { "Carlette", 0.0 },
  { "Carley", 0.025019832 },
  { "Carlhenry", 1.0 },
  { "Carli", 0.00060760725 },
  { "Carlia", 0.0 },
  { "Carliana", 0.0 },
  { "Carlianna", 0.0 },
  { "Carlianne", 0.0 },
  { "Carlicia", 0.0 },
  { "Carlie", 0.08507836 },
  { "Carliee", 0.0 },
  { "Carliegh", 0.0 },
  { "Carlile", 1.0 },
  { "Carlin", 0.5832933 },
  { "Carlina", 0.0 },
  { "Carlinda", 0.0 },
  { "Carline", 0.0030138637 },
  { "Carling", 0.0 },
  { "Carlis", 0.87276626 },
  { "Carlisa", 0.0 },
  { "Carlise", 0.0 },
  { "Carlisha", 0.0 },
  { "Carlishia", 0.0 },
  { "Carlisia", 0.0 },
  { "Carlisle", 0.80840874 },
  { "Carliss", 0.218509 },
  { "Carlissa", 0.0 },
  { "Carlissia", 0.0 },
  { "Carlita", 0.0 },
  { "Carlitha", 0.0 },
  { "Carlito", 1.0 },
  { "Carlitos", 1.0 },
  { "Carlitta", 0.0 },
  { "Carliyah", 0.0 },
  { "Carlla", 0.0 },
  { "Carlleen", 0.0 },
  { "Carllene", 0.0 },
  { "Carlo", 0.9944193 },
  { "Carlon", 0.8210526 },
  { "Carlos", 0.99290586 },
  { "Carlosadrian", 1.0 },
  { "Carlosalberto", 1.0 },
  { "Carlosantonio", 1.0 },
  { "Carlosdaniel", 1.0 },
  { "Carlose", 1.0 },
  { "Carloseduardo", 1.0 },
  { "Carlosjavier", 1.0 },
  { "Carlosjr", 1.0 },
  { "Carlosmanuel", 1.0 },
  { "Carloss", 1.0 },
  { "Carlota", 0.0 },
  { "Carlotta", 0.0 },
  { "Carlotte", 0.0 },
  { "Carlous", 1.0 },
  { "Carloyn", 0.0 },
  { "Carlson", 1.0 },
  { "Carlston", 1.0 },
  { "Carlton", 0.9943076 },
  { "Carlus", 0.9813084 },
  { "Carlvin", 1.0 },
  { "Carly", 0.0025593038 },
  { "Carlyann", 0.0 },
  { "Carlye", 0.0 },
  { "Carlyle", 0.9544389 },
  { "Carlyn", 0.015854236 },
  { "Carlyne", 0.0 },
  { "Carlynn", 0.0 },
  { "Carlyon", 0.0 },
  { "Carlyrose", 0.0 },
  { "Carlyse", 0.0 },
  { "Carlysha", 0.0 },
  { "Carlysia", 0.0 },
  { "Carlysle", 1.0 },
  { "Carlyssa", 0.0 },
  { "Carlyssia", 0.0 },
  { "Carma", 0.0 },
  { "Carmah", 0.0 },
  { "Carmala", 0.0 },
  { "Carmalena", 0.0 },
  { "Carmaleta", 0.0 },
  { "Carmaletta", 0.0 },
  { "Carmaline", 0.0 },
  { "Carmalita", 0.0 },
  { "Carman", 0.31138584 },
  { "Carmani", 0.0 },
  { "Carmecia", 0.0 },
  { "Carmeisha", 0.0 },
  { "Carmel", 0.15934262 },
  { "Carmela", 0.00021597338 },
  { "Carmeleta", 0.0 },
  { "Carmeletta", 0.0 },
  { "Carmelia", 0.0 },
  { "Carmelina", 0.0 },
  { "Carmeline", 0.0 },
  { "Carmelita", 0.0 },
  { "Carmelite", 0.0 },
  { "Carmelito", 1.0 },
  { "Carmelitta", 0.0 },
  { "Carmell", 0.07317073 },
  { "Carmella", 0.0 },
  { "Carmelle", 0.0 },
  { "Carmellia", 0.0 },
  { "Carmello", 0.9878893 },
  { "Carmelo", 0.99949676 },
  { "Carmelyn", 0.0 },
  { "Carmen", 0.108595684 },
  { "Carmena", 0.0 },
  { "Carmencita", 0.0 },
  { "Carmene", 0.0 },
  { "Carmenita", 0.0 },
  { "Carmenlita", 0.0 },
  { "Carmeron", 1.0 },
  { "Carmesa", 0.0 },
  { "Carmesha", 0.0 },
  { "Carmeshia", 0.0 },
  { "Carmesia", 0.0 },
  { "Carmetta", 0.0 },
  { "Carmi", 0.39285713 },
  { "Carmia", 0.0 },
  { "Carmichael", 1.0 },
  { "Carmie", 0.14018692 },
  { "Carmila", 0.0 },
  { "Carmilita", 0.0 },
  { "Carmilla", 0.0 },
  { "Carmille", 0.0 },
  { "Carmin", 0.1408297 },
  { "Carmina", 0.0 },
  { "Carmindy", 0.0 },
  { "Carmine", 0.96357363 },
  { "Carminia", 0.0 },
  { "Carmino", 1.0 },
  { "Carmisha", 0.0 },
  { "Carmita", 0.0 },
  { "Carmon", 0.4423213 },
  { "Carmya", 0.0 },
  { "Carmyn", 0.0 },
  { "Carmyne", 1.0 },
  { "Carmynn", 0.0 },
  { "Carna", 0.0 },
  { "Carnation", 0.0 },
  { "Carneal", 1.0 },
  { "Carneisha", 0.0 },
  { "Carnel", 1.0 },
  { "Carnelia", 0.0 },
  { "Carnelius", 1.0 },
  { "Carnell", 0.89177406 },
  { "Carnella", 0.0 },
  { "Carnes", 1.0 },
  { "Carnesha", 0.0 },
  { "Carneshia", 0.0 },
  { "Carnetta", 0.0 },
  { "Carney", 0.98792756 },
  { "Carnie", 0.8035714 },
  { "Carnisha", 0.0 },
  { "Carnita", 0.0 },
  { "Caro", 0.018248174 },
  { "Carol", 0.010494535 },
  { "Carola", 0.0 },
  { "Carolan", 0.0 },
  { "Carolann", 0.0 },
  { "Carolanne", 0.0 },
  { "Carold", 1.0 },
  { "Caroldean", 0.0 },
  { "Caroldine", 0.0 },
  { "Carole", 0.0023807592 },
  { "Carolea", 0.0 },
  { "Caroleann", 0.0 },
  { "Carolee", 0.0 },
  { "Caroleen", 0.0 },
  { "Caroleena", 0.0 },
  { "Carolen", 0.0 },
  { "Carolena", 0.0 },
  { "Carolene", 0.0 },
  { "Caroletta", 0.0 },
  { "Carolette", 0.0 },
  { "Carolgene", 0.0 },
  { "Carolie", 0.0 },
  { "Carolin", 0.0 },
  { "Carolina", 0.003288684 },
  { "Carolinda", 0.0 },
  { "Caroline", 0.0013974528 },
  { "Carolita", 0.0 },
  { "Caroljean", 0.0 },
  { "Caroljo", 0.0 },
  { "Caroll", 0.373436 },
  { "Carolle", 0.0 },
  { "Carollee", 0.0 },
  { "Carollou", 0.0 },
  { "Carollyn", 0.0 },
  { "Carollynn", 0.0 },
  { "Carolos", 1.0 },
  { "Carols", 1.0 },
  { "Carolsue", 0.0 },
  { "Carolus", 1.0 },
  { "Caroly", 0.0 },
  { "Carolyn", 0.0029112003 },
  { "Carolyna", 0.0 },
  { "Carolyne", 0.0 },
  { "Carolynn", 0.0 },
  { "Carolynne", 0.0 },
  { "Carolyon", 0.0 },
  { "Caron", 0.22406639 },
  { "Caronda", 0.0 },
  { "Caros", 1.0 },
  { "Caroyl", 0.0 },
  { "Caroyn", 0.0 },
  { "Carpenter", 1.0 },
  { "Carper", 1.0 },
  { "Carr", 1.0 },
  { "Carra", 0.0 },
  { "Carragan", 0.0 },
  { "Carrah", 0.0 },
  { "Carranza", 1.0 },
  { "Carre", 0.0 },
  { "Carree", 0.0 },
  { "Carreen", 0.0 },
  { "Carrel", 0.9729064 },
  { "Carrell", 0.86965376 },
  { "Carren", 0.0 },
  { "Carrena", 0.0 },
  { "Carrera", 0.0 },
  { "Carressa", 0.0 },
  { "Carrey", 0.11320755 },
  { "Carri", 0.0 },
  { "Carriana", 0.0 },
  { "Carriann", 0.0 },
  { "Carrianna", 0.0 },
  { "Carrianne", 0.0 },
  { "Carrick", 1.0 },
  { "Carrie", 0.004460571 },
  { "Carrieann", 0.0 },
  { "Carrieanne", 0.0 },
  { "Carriebell", 0.0 },
  { "Carrielynn", 0.0 },
  { "Carrigan", 0.009871668 },
  { "Carrin", 0.0 },
  { "Carrina", 0.0 },
  { "Carrine", 0.0 },
  { "Carrington", 0.41520613 },
  { "Carrion", 1.0 },
  { "Carris", 0.5151515 },
  { "Carrisa", 0.0 },
  { "Carrissa", 0.0 },
  { "Carrol", 0.5878647 },
  { "Carrold", 1.0 },
  { "Carrole", 0.0 },
  { "Carroll", 0.8570079 },
  { "Carrolle", 0.0 },
  { "Carrolyn", 0.0 },
  { "Carron", 0.17594256 },
  { "Carrson", 1.0 },
  { "Carry", 0.1809409 },
  { "Carrye", 0.0 },
  { "Carryl", 0.0 },
  { "Carryn", 0.0 },
  { "Carsan", 1.0 },
  { "Carsandra", 0.0 },
  { "Carsen", 0.7806245 },
  { "Carshena", 0.0 },
  { "Carsie", 1.0 },
  { "Carsin", 1.0 },
  { "Carson", 0.93816054 },
  { "Carsten", 0.99749124 },
  { "Carston", 1.0 },
  { "Carstyn", 1.0 },
  { "Carsyn", 0.30397505 },
  { "Carsynn", 0.0 },
  { "Cartavious", 1.0 },
  { "Cartel", 1.0 },
  { "Cartell", 1.0 },
  { "Carter", 0.96854347 },
  { "Carterjames", 1.0 },
  { "Carterlee", 1.0 },
  { "Cartez", 1.0 },
  { "Cartha", 0.0 },
  { "Carthel", 1.0 },
  { "Carthell", 1.0 },
  { "Cartier", 0.870317 },
  { "Cartina", 0.0 },
  { "Cartisha", 0.0 },
  { "Cartlin", 0.0 },
  { "Cartney", 0.0 },
  { "Cartrell", 1.0 },
  { "Cartrina", 0.0 },
  { "Caruso", 1.0 },
  { "Carvel", 1.0 },
  { "Carvell", 1.0 },
  { "Carven", 1.0 },
  { "Carver", 0.99163383 },
  { "Carveth", 1.0 },
  { "Carville", 1.0 },
  { "Carvin", 1.0 },
  { "Carvis", 1.0 },
  { "Carvon", 1.0 },
  { "Carwin", 1.0 },
  { "Carwyn", 1.0 },
  { "Cary", 0.82035744 },
  { "Carya", 0.0 },
  { "Caryann", 0.0 },
  { "Carye", 0.0 },
  { "Caryl", 0.051412344 },
  { "Caryle", 0.0 },
  { "Caryll", 0.0 },
  { "Carylon", 0.0 },
  { "Caryn", 0.0 },
  { "Caryna", 0.0 },
  { "Carynn", 0.0 },
  { "Caryol", 0.0 },
  { "Carys", 0.0 },
  { "Caryss", 0.0 },
  { "Caryssa", 0.0 },
  { "Carzell", 1.0 },
  { "Cas", 1.0 },
  { "Casadee", 0.0 },
  { "Casadi", 0.0 },
  { "Casady", 0.0 },
  { "Casandr", 0.0 },
  { "Casandra", 0.00044759896 },
  { "Casanova", 1.0 },
  { "Casara", 0.0 },
  { "Casarah", 0.0 },
  { "Casaundra", 0.0 },
  { "Casaya", 0.0 },
  { "Casch", 1.0 },
  { "Cascia", 0.0 },
  { "Casden", 1.0 },
  { "Case", 1.0 },
  { "Casea", 0.0 },
  { "Casee", 0.0 },
  { "Caselyn", 0.0 },
  { "Caselynn", 0.0 },
  { "Casen", 0.99528956 },
  { "Caseton", 1.0 },
  { "Casey", 0.5914304 },
  { "Caseyann", 0.0 },
  { "Caseylynn", 0.0 },
  { "Cash", 0.9968437 },
  { "Casha", 0.0 },
  { "Cashae", 0.0 },
  { "Cashala", 0.0 },
  { "Cashana", 0.0 },
  { "Cashanda", 0.0 },
  { "Cashanti", 0.0 },
  { "Cashara", 0.0 },
  { "Cashaun", 1.0 },
  { "Cashawn", 1.0 },
  { "Cashay", 0.0 },
  { "Cashden", 1.0 },
  { "Cashe", 0.38181818 },
  { "Cashea", 0.0 },
  { "Casheena", 0.0 },
  { "Cashel", 1.0 },
  { "Cashen", 1.0 },
  { "Cashion", 1.0 },
  { "Cashious", 1.0 },
  { "Cashis", 1.0 },
  { "Cashius", 1.0 },
  { "Cashlin", 0.46666667 },
  { "Cashlyn", 0.0 },
  { "Cashlynn", 0.0 },
  { "Cashmere", 0.36373875 },
  { "Cashmiere", 1.0 },
  { "Cashmir", 0.8378378 },
  { "Cashon", 1.0 },
  { "Cashous", 1.0 },
  { "Cashten", 1.0 },
  { "Cashtin", 1.0 },
  { "Cashton", 1.0 },
  { "Cashtyn", 1.0 },
  { "Cashus", 1.0 },
  { "Casi", 0.0 },
  { "Casia", 0.0 },
  { "Casiah", 0.0 },
  { "Casiana", 0.0 },
  { "Casiano", 1.0 },
  { "Casidee", 0.0 },
  { "Casidhe", 0.0 },
  { "Casidy", 0.0 },
  { "Casie", 0.0037894738 },
  { "Casilda", 0.0 },
  { "Casimer", 1.0 },
  { "Casimera", 0.0 },
  { "Casimere", 1.0 },
  { "Casimier", 1.0 },
  { "Casimir", 1.0 },
  { "Casimira", 0.0 },
  { "Casimiro", 1.0 },
  { "Casin", 1.0 },
  { "Casina", 0.0 },
  { "Casino", 1.0 },
  { "Casius", 1.0 },
  { "Casiyah", 0.0 },
  { "Caslyn", 0.0 },
  { "Casmer", 1.0 },
  { "Casmera", 0.0 },
  { "Casmere", 1.0 },
  { "Casmier", 1.0 },
  { "Casmin", 0.0 },
  { "Casmir", 0.95254236 },
  { "Casmira", 0.0 },
  { "Cason", 0.99232835 },
  { "Casondra", 0.0 },
  { "Casonja", 0.0 },
  { "Casonya", 0.0 },
  { "Caspar", 1.0 },
  { "Casper", 1.0 },
  { "Caspian", 1.0 },
  { "Cass", 0.92813027 },
  { "Cassadee", 0.0 },
  { "Cassadi", 0.0 },
  { "Cassadie", 0.0 },
  { "Cassadra", 0.0 },
  { "Cassady", 0.076182134 },
  { "Cassand", 0.0 },
  { "Cassanda", 0.0 },
  { "Cassander", 0.0 },
  { "Cassandera", 0.0 },
  { "Cassandr", 0.0 },
  { "Cassandra", 0.00225581 },
  { "Cassandre", 0.0 },
  { "Cassandrea", 0.0 },
  { "Cassandria", 0.0 },
  { "Cassanora", 0.0 },
  { "Cassanova", 1.0 },
  { "Cassara", 0.0 },
  { "Cassarah", 0.0 },
  { "Cassaundra", 0.0 },
  { "Cassedy", 0.0 },
  { "Cassee", 0.0 },
  { "Cassel", 1.0 },
  { "Cassell", 1.0 },
  { "Cassen", 1.0 },
  { "Cassendra", 0.0 },
  { "Cassey", 0.08511807 },
  { "Cassi", 0.0 },
  { "Cassia", 0.0 },
  { "Cassiah", 0.0 },
  { "Cassian", 1.0 },
  { "Cassiana", 0.0 },
  { "Cassiday", 0.0 },
  { "Cassidee", 0.0 },
  { "Cassidey", 0.0 },
  { "Cassidi", 0.0 },
  { "Cassidie", 0.0 },
  { "Cassidy", 0.056251634 },
  { "Cassie", 0.008512703 },
  { "Cassiel", 0.8079096 },
  { "Cassietta", 0.0 },
  { "Cassin", 1.0 },
  { "Cassina", 0.0 },
  { "Cassiopeia", 0.0 },
  { "Cassiopia", 0.0 },
  { "Cassity", 0.0 },
  { "Cassius", 1.0 },
  { "Casslyn", 0.0 },
  { "Casson", 1.0 },
  { "Cassondr", 0.0 },
  { "Cassondra", 0.0 },
  { "Cassonia", 0.0 },
  { "Cassundra", 0.0 },
  { "Cassy", 0.0 },
  { "Cassye", 0.0 },
  { "Casta", 0.0 },
  { "Castella", 0.0 },
  { "Casten", 1.0 },
  { "Caster", 1.0 },
  { "Castiel", 0.98359436 },
  { "Castin", 1.0 },
  { "Castina", 0.0 },
  { "Castle", 1.0 },
  { "Casto", 1.0 },
  { "Caston", 1.0 },
  { "Castor", 1.0 },
  { "Castoria", 0.0 },
  { "Castro", 1.0 },
  { "Castulo", 1.0 },
  { "Castyn", 1.0 },
  { "Casundra", 0.0 },
  { "Caswell", 1.0 },
  { "Casy", 0.58653843 },
  { "Casyn", 0.9100346 },
  { "Catalaya", 0.0 },
  { "Catalayah", 0.0 },
  { "Cataldo", 1.0 },
  { "Catalea", 0.0 },
  { "Cataleah", 0.0 },
  { "Cataleena", 0.0 },
  { "Cataleia", 0.0 },
  { "Catalena", 0.0 },
  { "Cataleya", 0.0 },
  { "Cataleyah", 0.0 },
  { "Catalia", 0.0 },
  { "Catalin", 0.0 },
  { "Catalina", 0.00041395624 },
  { "Catalino", 1.0 },
  { "Cataliya", 0.0 },
  { "Cataliyah", 0.0 },
  { "Catalya", 0.0 },
  { "Catalyna", 0.0 },
  { "Catana", 0.0 },
  { "Catara", 0.0 },
  { "Catarena", 0.0 },
  { "Catarina", 0.0 },
  { "Catarino", 1.0 },
  { "Catasha", 0.0 },
  { "Catch", 1.0 },
  { "Catcher", 1.0 },
  { "Cate", 0.0 },
  { "Cateena", 0.0 },
  { "Catelaya", 0.0 },
  { "Cateleya", 0.0 },
  { "Catelin", 0.0 },
  { "Catello", 1.0 },
  { "Catelyn", 0.0 },
  { "Catelynn", 0.0 },
  { "Catelynne", 0.0 },
  { "Catena", 0.0 },
  { "Catenia", 0.0 },
  { "Catera", 0.0 },
  { "Cateria", 0.0 },
  { "Caterin", 0.0 },
  { "Caterina", 0.0 },
  { "Caterine", 0.0 },
  { "Caternia", 0.0 },
  { "Caterra", 0.0 },
  { "Catessa", 0.0 },
  { "Catey", 0.0 },
  { "Cath", 0.0 },
  { "Catha", 0.0 },
  { "Cathal", 1.0 },
  { "Cathaleen", 0.0 },
  { "Cathalene", 0.0 },
  { "Cathaleya", 0.0 },
  { "Cathalia", 0.0 },
  { "Cathalina", 0.0 },
  { "Cathaline", 0.0 },
  { "Cathan", 1.0 },
  { "Catharina", 0.0 },
  { "Catharine", 0.0 },
  { "Cathay", 0.0 },
  { "Cathe", 0.0 },
  { "Cathee", 0.0 },
  { "Catheleen", 0.0 },
  { "Cathelene", 0.0 },
  { "Catheline", 0.0 },
  { "Cather", 0.0 },
  { "Catheren", 0.0 },
  { "Catherene", 0.0 },
  { "Catherin", 0.0 },
  { "Catherina", 0.0 },
  { "Catherine", 0.0027659223 },
  { "Catherline", 0.0 },
  { "Cathern", 0.0 },
  { "Catherne", 0.0 },
  { "Catheryn", 0.0 },
  { "Catheryne", 0.0 },
  { "Cathey", 0.0 },
  { "Cathi", 0.0 },
  { "Cathia", 0.0 },
  { "Cathie", 0.0 },
  { "Cathirine", 0.0 },
  { "Cathlean", 0.0 },
  { "Cathleen", 0.00033525546 },
  { "Cathlena", 0.0 },
  { "Cathlene", 0.0 },
  { "Cathlin", 0.0 },
  { "Cathlina", 0.0 },
  { "Cathline", 0.0 },
  { "Cathlyn", 0.0 },
  { "Cathreen", 0.0 },
  { "Cathren", 0.0 },
  { "Cathrin", 0.0 },
  { "Cathrina", 0.0 },
  { "Cathrine", 0.0 },
  { "Cathryn", 0.0 },
  { "Cathryne", 0.0 },
  { "Cathrynn", 0.0 },
  { "Cathy", 0.0020128044 },
  { "Cathyann", 0.0 },
  { "Cathye", 0.0 },
  { "Cathyjo", 0.0 },
  { "Cathylee", 0.0 },
  { "Cathyleen", 0.0 },
  { "Cathyrn", 0.0 },
  { "Cati", 0.0 },
  { "Catia", 0.0 },
  { "Catiana", 0.0 },
  { "Catie", 0.0 },
  { "Catilaya", 0.0 },
  { "Catileya", 0.0 },
  { "Catilin", 0.0 },
  { "Catilyn", 0.0 },
  { "Catina", 0.0019111324 },
  { "Catine", 0.0 },
  { "Catinia", 0.0 },
  { "Catinna", 0.0 },
  { "Catiria", 0.0 },
  { "Catisha", 0.0 },
  { "Catlin", 0.29713523 },
  { "Catlyn", 0.0 },
  { "Catlynn", 0.0 },
  { "Cato", 1.0 },
  { "Caton", 0.7583333 },
  { "Catonya", 0.0 },
  { "Catori", 0.0 },
  { "Catoria", 0.0 },
  { "Catosha", 0.0 },
  { "Catoya", 0.0 },
  { "Catrease", 0.0 },
  { "Catrece", 0.0 },
  { "Catreena", 0.0 },
  { "Catrell", 1.0 },
  { "Catrena", 0.0 },
  { "Catrenia", 0.0 },
  { "Catrese", 0.0 },
  { "Catressa", 0.0 },
  { "Catria", 0.0 },
  { "Catriana", 0.0 },
  { "Catrice", 0.0 },
  { "Catricia", 0.0 },
  { "Catrin", 0.0 },
  { "Catrina", 0.0 },
  { "Catrinia", 0.0 },
  { "Catrinna", 0.0 },
  { "Catriona", 0.0 },
  { "Catrisha", 0.0 },
  { "Cattalaya", 0.0 },
  { "Cattaleya", 0.0 },
  { "Cattibrie", 0.0 },
  { "Cattie", 0.0 },
  { "Cattina", 0.0 },
  { "Cattleya", 0.0 },
  { "Caty", 0.0 },
  { "Catya", 0.0 },
  { "Caua", 1.0 },
  { "Cauan", 1.0 },
  { "Caudie", 0.0 },
  { "Caulder", 1.0 },
  { "Caulen", 1.0 },
  { "Caulin", 1.0 },
  { "Caullin", 1.0 },
  { "Cauy", 1.0 },
  { "Cavalli", 1.0 },
  { "Cavan", 1.0 },
  { "Cavanaugh", 1.0 },
  { "Cavani", 1.0 },
  { "Cavari", 1.0 },
  { "Cavell", 1.0 },
  { "Caven", 1.0 },
  { "Cavett", 1.0 },
  { "Cavin", 1.0 },
  { "Cavion", 1.0 },
  { "Cavon", 1.0 },
  { "Cavonte", 1.0 },
  { "Cawanda", 0.0 },
  { "Cawanna", 0.0 },
  { "Cay", 0.043650795 },
  { "Caya", 0.0 },
  { "Cayce", 0.31156716 },
  { "Caycee", 0.0 },
  { "Caycen", 1.0 },
  { "Cayci", 0.0 },
  { "Caycie", 0.0 },
  { "Cayd", 1.0 },
  { "Caydan", 0.97863245 },
  { "Caydance", 0.0 },
  { "Cayde", 1.0 },
  { "Caydee", 0.0 },
  { "Cayden", 0.9490283 },
  { "Caydence", 0.057069574 },
  { "Caydenn", 1.0 },
  { "Caydin", 0.9128329 },
  { "Caydince", 0.0 },
  { "Caydn", 1.0 },
  { "Caydon", 1.0 },
  { "Caydyn", 1.0 },
  { "Caye", 0.0 },
  { "Cayenne", 0.06185567 },
  { "Cayetana", 0.0 },
  { "Cayetano", 1.0 },
  { "Cayl", 1.0 },
  { "Cayla", 0.0 },
  { "Caylah", 0.0 },
  { "Caylan", 0.38987342 },
  { "Caylani", 0.0 },
  { "Cayle", 0.6527415 },
  { "Caylea", 0.0 },
  { "Cayleb", 1.0 },
  { "Caylee", 0.0 },
  { "Cayleeann", 0.0 },
  { "Cayleen", 0.0 },
  { "Caylei", 0.0 },
  { "Cayleigh", 0.0 },
  { "Caylem", 1.0 },
  { "Caylen", 0.3345112 },
  { "Caylene", 0.0 },
  { "Cayler", 1.0 },
  { "Cayley", 0.0 },
  { "Cayli", 0.0 },
  { "Cayliana", 0.0 },
  { "Caylib", 1.0 },
  { "Caylie", 0.0 },
  { "Caylin", 0.03667791 },
  { "Caylinn", 0.0 },
  { "Caylob", 1.0 },
  { "Caylon", 0.9506173 },
  { "Caylor", 0.53409094 },
  { "Caylub", 1.0 },
  { "Caylum", 1.0 },
  { "Caylyn", 0.0 },
  { "Caylynn", 0.0 },
  { "Cayman", 0.7641509 },
  { "Caymen", 0.93454546 },
  { "Caymon", 1.0 },
  { "Caymus", 1.0 },
  { "Cayn", 1.0 },
  { "Caynan", 1.0 },
  { "Cayne", 1.0 },
  { "Caynen", 1.0 },
  { "Cayo", 1.0 },
  { "Cayra", 0.0 },
  { "Cayse", 0.6875 },
  { "Caysee", 0.0 },
  { "Caysen", 0.9678335 },
  { "Caysey", 1.0 },
  { "Caysi", 0.0 },
  { "Caysie", 0.0 },
  { "Caysin", 1.0 },
  { "Cayslee", 0.0 },
  { "Cayson", 0.9895022 },
  { "Caytie", 0.0 },
  { "Caytlen", 0.0 },
  { "Caytlin", 0.0 },
  { "Caytlyn", 0.0 },
  { "Caytlynn", 0.0 },
  { "Cayton", 0.8043478 },
  { "Cayvion", 1.0 },
  { "Caz", 1.0 },
  { "Cazandra", 0.0 },
  { "Cazden", 1.0 },
  { "Caziah", 0.68421054 },
  { "Caziyah", 0.0 },
  { "Cazzie", 1.0 },
  { "Cchristopher", 1.0 },
  { "Ceaira", 0.0 },
  { "Ceairra", 0.0 },
  { "Cealie", 0.0 },
  { "Cean", 1.0 },
  { "Ceana", 0.0 },
  { "Ceandra", 0.0 },
  { "Ceandre", 1.0 },
  { "Ceann", 0.0 },
  { "Ceanna", 0.0 },
  { "Ceara", 0.0 },
  { "Cearah", 0.0 },
  { "Cearia", 0.0 },
  { "Cearra", 0.0 },
  { "Ceasar", 1.0 },
  { "Ceasare", 1.0 },
  { "Ceaser", 1.0 },
  { "Ceasia", 0.0 },
  { "Ceason", 0.0 },
  { "Ceazar", 1.0 },
  { "Ceazia", 0.0 },
  { "Cebastian", 1.0 },
  { "Cebell", 0.0 },
  { "Cebert", 1.0 },
  { "Cebria", 0.0 },
  { "Cebrina", 0.0 },
  { "Cebron", 1.0 },
  { "Cece", 0.0 },
  { "Ceceila", 0.0 },
  { "Ceceilia", 0.0 },
  { "Cecel", 0.0 },
  { "Cecele", 0.0 },
  { "Cecelia", 0.00019825179 },
  { "Cecelie", 0.0 },
  { "Cecelio", 1.0 },
  { "Cecellia", 0.0 },
  { "Cecely", 0.0 },
  { "Ceci", 0.0 },
  { "Cecia", 0.0 },
  { "Cecial", 1.0 },
  { "Cecil", 0.9324071 },
  { "Cecila", 0.0 },
  { "Cecile", 0.009358157 },
  { "Cecilee", 0.0 },
  { "Ceciley", 0.0 },
  { "Cecili", 0.0 },
  { "Cecilia", 0.0018956838 },
  { "Cecilie", 0.0 },
  { "Cecilio", 1.0 },
  { "Cecilla", 0.0 },
  { "Cecille", 0.0 },
  { "Cecillia", 0.0 },
  { "Cecilly", 0.0 },
  { "Cecily", 0.0 },
  { "Cecilya", 0.0 },
  { "Ceclia", 0.0 },
  { "Cecy", 0.0 },
  { "Cecyle", 0.0 },
  { "Cecylia", 0.0 },
  { "Cedar", 0.5845552 },
  { "Cedarius", 1.0 },
  { "Ceddrick", 1.0 },
  { "Cedell", 0.9230769 },
  { "Cedella", 0.0 },
  { "Cedeno", 1.0 },
  { "Cederia", 0.0 },
  { "Cederic", 1.0 },
  { "Cederick", 1.0 },
  { "Cedra", 0.0 },
  { "Cedrea", 0.0 },
  { "Cedria", 0.0 },
  { "Cedriana", 0.0 },
  { "Cedrianna", 0.0 },
  { "Cedric", 0.9931178 },
  { "Cedrica", 0.0 },
  { "Cedrice", 1.0 },
  { "Cedrick", 0.99832636 },
  { "Cedricka", 0.0 },
  { "Cedrie", 1.0 },
  { "Cedrik", 1.0 },
  { "Cedrika", 0.0 },
  { "Cedrina", 0.0 },
  { "Cee", 0.0 },
  { "Ceeanna", 0.0 },
  { "Ceejay", 1.0 },
  { "Ceferino", 1.0 },
  { "Ceianna", 0.0 },
  { "Ceiara", 0.0 },
  { "Ceil", 0.0 },
  { "Ceila", 0.0 },
  { "Ceili", 0.0 },
  { "Ceilia", 0.0 },
  { "Ceilidh", 0.0 },
  { "Ceinna", 0.0 },
  { "Ceion", 1.0 },
  { "Ceionna", 0.0 },
  { "Ceira", 0.0 },
  { "Ceirra", 0.0 },
  { "Cejay", 1.0 },
  { "Ceji", 0.0 },
  { "Cela", 0.0 },
  { "Celaya", 0.0 },
  { "Cele", 0.0 },
  { "Celebrity", 0.0 },
  { "Celecia", 0.0 },
  { "Celedonia", 0.0 },
  { "Celedonio", 1.0 },
  { "Celeena", 0.0 },
  { "Celena", 0.0 },
  { "Celene", 0.0 },
  { "Celenia", 0.0 },
  { "Celenne", 0.0 },
  { "Celeny", 0.0 },
  { "Celerina", 0.0 },
  { "Celerino", 1.0 },
  { "Celes", 0.0 },
  { "Celese", 0.0 },
  { "Celess", 0.0 },
  { "Celesse", 0.0 },
  { "Celest", 0.0 },
  { "Celesta", 0.0 },
  { "Celeste", 0.0010161696 },
  { "Celester", 0.4488778 },
  { "Celestia", 0.0 },
  { "Celestial", 0.0 },
  { "Celestie", 0.0 },
  { "Celestin", 1.0 },
  { "Celestina", 0.0 },
  { "Celestine", 0.02372916 },
  { "Celestino", 1.0 },
  { "Celestte", 0.0 },
  { "Celeta", 0.0 },
  { "Celetha", 0.0 },
  { "Celia", 0.0013783597 },
  { "Celiana", 0.0 },
  { "Celica", 0.0 },
  { "Celicia", 0.0 },
  { "Celida", 0.0 },
  { "Celie", 0.0 },
  { "Celimar", 0.0 },
  { "Celin", 0.0 },
  { "Celina", 0.0004225352 },
  { "Celinda", 0.0 },
  { "Celine", 0.0 },
  { "Celines", 0.0 },
  { "Celinez", 0.0 },
  { "Celinna", 0.0 },
  { "Celio", 1.0 },
  { "Celis", 0.0 },
  { "Celisa", 0.0 },
  { "Celise", 0.0 },
  { "Celisha", 0.0 },
  { "Celissa", 0.0 },
  { "Celisse", 0.0 },
  { "Celita", 0.0 },
  { "Celiyah", 0.0 },
  { "Cella", 0.0 },
  { "Celleste", 0.0 },
  { "Cellestine", 0.0 },
  { "Cellia", 0.0 },
  { "Cellie", 0.0 },
  { "Cellina", 0.0 },
  { "Cellus", 1.0 },
  { "Celsa", 0.0 },
  { "Celsea", 0.0 },
  { "Celsey", 0.0 },
  { "Celsi", 0.0 },
  { "Celsie", 0.0 },
  { "Celso", 1.0 },
  { "Celton", 1.0 },
  { "Celvin", 1.0 },
  { "Cely", 0.0 },
  { "Celyn", 0.0 },
  { "Celyna", 0.0 },
  { "Celyne", 0.0 },
  { "Celynn", 0.0 },
  { "Cem", 1.0 },
  { "Cemal", 1.0 },
  { "Cemiyah", 0.0 },
  { "Cemone", 0.0 },
  { "Cemre", 0.0 },
  { "Cemya", 0.0 },
  { "Cena", 0.013986014 },
  { "Cenae", 0.0 },
  { "Cenai", 0.0 },
  { "Cenaida", 0.0 },
  { "Cendi", 0.0 },
  { "Cendra", 0.0 },
  { "Cendy", 0.0 },
  { "Cenedra", 0.0 },
  { "Cengiz", 1.0 },
  { "Cenia", 0.0 },
  { "Cenie", 0.0 },
  { "Cenith", 0.0 },
  { "Ceniya", 0.0 },
  { "Ceniyah", 0.0 },
  { "Cennedy", 0.0 },
  { "Cennie", 0.0 },
  { "Centeria", 0.0 },
  { "Centhia", 0.0 },
  { "Central", 1.0 },
  { "Centrell", 1.0 },
  { "Centwane", 1.0 },
  { "Cenya", 0.0 },
  { "Ceola", 0.009610984 },
  { "Ceolia", 0.0 },
  { "Ceon", 1.0 },
  { "Ceona", 0.0 },
  { "Ceonna", 0.0 },
  { "Cepeda", 1.0 },
  { "Cephas", 1.0 },
  { "Cephus", 1.0 },
  { "Cequan", 1.0 },
  { "Cera", 0.0 },
  { "Cerah", 0.0 },
  { "Cerdic", 1.0 },
  { "Cerelia", 0.0 },
  { "Ceren", 0.0 },
  { "Cerena", 0.0 },
  { "Cereniti", 0.0 },
  { "Cerenity", 0.0 },
  { "Ceres", 0.0 },
  { "Ceresa", 0.0 },
  { "Cerese", 0.0 },
  { "Ceretha", 0.0 },
  { "Cergio", 1.0 },
  { "Ceri", 0.0 },
  { "Ceria", 0.0 },
  { "Ceriah", 0.0 },
  { "Ceridwen", 0.0 },
  { "Cerina", 0.0 },
  { "Cerinity", 0.0 },
  { "Cerisa", 0.0 },
  { "Cerise", 0.0 },
  { "Cerissa", 0.0 },
  { "Cerita", 0.0 },
  { "Ceriyah", 0.0 },
  { "Cerjio", 1.0 },
  { "Ceron", 1.0 },
  { "Cerone", 1.0 },
  { "Cerra", 0.0 },
  { "Cerri", 0.0 },
  { "Cerria", 0.0 },
  { "Cerridwen", 0.0 },
  { "Cerrie", 0.0 },
  { "Cerrisa", 0.0 },
  { "Cerrissa", 0.0 },
  { "Cerrone", 1.0 },
  { "Cervando", 1.0 },
  { "Cervante", 1.0 },
  { "Cervantes", 1.0 },
  { "Cerys", 0.0 },
  { "Cesalie", 0.0 },
  { "Cesar", 0.995546 },
  { "Cesare", 1.0 },
  { "Cesareo", 1.0 },
  { "Cesaria", 0.0 },
  { "Cesarina", 0.0 },
  { "Cesario", 1.0 },
  { "Cesc", 1.0 },
  { "Cescily", 0.0 },
  { "Cesear", 1.0 },
  { "Cesia", 0.0 },
  { "Cesiah", 0.0 },
  { "Cesidio", 1.0 },
  { "Cesilee", 0.0 },
  { "Cesiley", 0.0 },
  { "Cesilia", 0.0 },
  { "Cesilie", 0.0 },
  { "Cesily", 0.0 },
  { "Cesira", 0.0 },
  { "Cesley", 0.0 },
  { "Ceslie", 0.0 },
  { "Cessily", 0.0 },
  { "Cessna", 0.0 },
  { "Cetera", 0.0 },
  { "Ceth", 1.0 },
  { "Cetric", 1.0 },
  { "Cevanna", 0.0 },
  { "Cevera", 0.0 },
  { "Cevilla", 0.0 },
  { "Cevin", 1.0 },
  { "Cevion", 1.0 },
  { "Cevon", 1.0 },
  { "Ceyana", 0.0 },
  { "Ceyara", 0.0 },
  { "Ceyda", 0.0 },
  { "Ceylan", 0.0 },
  { "Ceylin", 0.0 },
  { "Ceylon", 1.0 },
  { "Ceyonce", 0.0 },
  { "Ceyonna", 0.0 },
  { "Cezanne", 0.0 },
  { "Cezar", 1.0 },
  { "Cha", 0.8724138 },
  { "Chaarvi", 0.0 },
  { "Chaaya", 0.0 },
  { "Chabeli", 0.0 },
  { "Chabelli", 0.0 },
  { "Chabely", 0.0 },
  { "Chablis", 0.0 },
  { "Chabria", 0.0 },
  { "Chace", 0.9731082 },
  { "Chachi", 1.0 },
  { "Chad", 0.9956792 },
  { "Chada", 0.0 },
  { "Chadae", 0.0 },
  { "Chadarius", 1.0 },
  { "Chadd", 1.0 },
  { "Chaddrick", 1.0 },
  { "Chade", 0.11612903 },
  { "Chaden", 1.0 },
  { "Chaderick", 1.0 },
  { "Chadi", 1.0 },
  { "Chadijah", 0.0 },
  { "Chadlee", 1.0 },
  { "Chadley", 1.0 },
  { "Chadly", 1.0 },
  { "Chadman", 1.0 },
  { "Chadney", 0.8958333 },
  { "Chadric", 1.0 },
  { "Chadrick", 1.0 },
  { "Chadron", 1.0 },
  { "Chadsity", 0.0 },
  { "Chadwell", 1.0 },
  { "Chadwic", 1.0 },
  { "Chadwich", 1.0 },
  { "Chadwick", 0.99830836 },
  { "Chadwin", 1.0 },
  { "Chadwyck", 1.0 },
  { "Chadyeane", 0.0 },
  { "Chae", 0.45820433 },
  { "Chaeden", 1.0 },
  { "Chael", 1.0 },
  { "Chaela", 0.0 },
  { "Chaeli", 0.0 },
  { "Chaely", 0.0 },
  { "Chaelyn", 0.0 },
  { "Chaelynn", 0.0 },
  { "Chaena", 0.0 },
  { "Chaffee", 0.5 },
  { "Chai", 0.6334012 },
  { "Chaia", 0.0 },
  { "Chaiden", 1.0 },
  { "Chaila", 0.0 },
  { "Chailee", 0.0 },
  { "Chailey", 0.0 },
  { "Chaille", 0.0 },
  { "Chailyn", 0.0 },
  { "Chailynn", 0.0 },
  { "Chaim", 0.99929774 },
  { "Chain", 1.0 },
  { "Chairity", 0.0 },
  { "Chairty", 0.0 },
  { "Chais", 0.9632353 },
  { "Chaise", 0.7471439 },
  { "Chaislyn", 0.0 },
  { "Chaison", 1.0 },
  { "Chaisson", 1.0 },
  { "Chaisty", 0.0 },
  { "Chaitan", 1.0 },
  { "Chaitanya", 1.0 },
  { "Chaithra", 0.0 },
  { "Chaitra", 0.0 },
  { "Chaiya", 0.0 },
  { "Chaka", 0.237534 },
  { "Chakakhan", 0.0 },
  { "Chakara", 0.0 },
  { "Chakayla", 0.0 },
  { "Chakela", 0.0 },
  { "Chakelia", 0.0 },
  { "Chakera", 0.0 },
  { "Chakeria", 0.0 },
  { "Chaketa", 0.0 },
  { "Chakevia", 0.0 },
  { "Chakeya", 0.0 },
  { "Chakia", 0.0 },
  { "Chakina", 0.0 },
  { "Chakira", 0.0 },
  { "Chakita", 0.0 },
  { "Chakiya", 0.0 },
  { "Chakka", 0.0 },
  { "Chakong", 1.0 },
  { "Chakotay", 1.0 },
  { "Chakya", 0.0 },
  { "Chakyra", 0.0 },
  { "Chala", 0.0 },
  { "Chalan", 0.0 },
  { "Chalanda", 0.0 },
  { "Chalandra", 0.0 },
  { "Chale", 1.0 },
  { "Chalea", 0.0 },
  { "Chalee", 0.0 },
  { "Chalei", 0.0 },
  { "Chalen", 1.0 },
  { "Chalena", 0.0 },
  { "Chalene", 0.0 },
  { "Chales", 1.0 },
  { "Chalese", 0.0 },
  { "Chalet", 0.0 },
  { "Chalette", 0.0 },
  { "Chaley", 0.0 },
  { "Chali", 0.0 },
  { "Chalia", 0.0 },
  { "Chalice", 0.0 },
  { "Chalie", 0.0 },
  { "Chalina", 0.0 },
  { "Chalino", 1.0 },
  { "Chalis", 0.0 },
  { "Chalisa", 0.0 },
  { "Chalise", 0.0 },
  { "Chalissa", 0.0 },
  { "Chalisse", 0.0 },
  { "Chalita", 0.0 },
  { "Chaliyah", 0.0 },
  { "Challen", 0.93421054 },
  { "Challie", 0.5 },
  { "Challis", 0.2421875 },
  { "Challise", 0.0 },
  { "Chalmas", 1.0 },
  { "Chalmer", 1.0 },
  { "Chalmers", 1.0 },
  { "Chalmus", 1.0 },
  { "Chalon", 0.14193548 },
  { "Chalonda", 0.0 },
  { "Chalres", 1.0 },
  { "Chalsea", 0.0 },
  { "Chalsey", 0.0 },
  { "Chalsie", 0.0 },
  { "Chaly", 1.0 },
  { "Chalyce", 0.0 },
  { "Chalyn", 0.0 },
  { "Chalynn", 0.0 },
  { "Chalyse", 0.0 },
  { "Chama", 0.0 },
  { "Chamaine", 0.0 },
  { "Chamar", 1.0 },
  { "Chamara", 0.0 },
  { "Chamari", 0.0 },
  { "Chamarion", 1.0 },
  { "Chamarra", 0.0 },
  { "Chamaya", 0.0 },
  { "Chamber", 1.0 },
  { "Chamberlain", 0.9433962 },
  { "Chamberlin", 1.0 },
  { "Chamberlyn", 0.0 },
  { "Chambers", 1.0 },
  { "Chambre", 0.0 },
  { "Chambria", 0.0 },
  { "Chameka", 0.0 },
  { "Chamel", 0.5 },
  { "Chamelle", 0.0 },
  { "Chamere", 0.0 },
  { "Chamia", 0.0 },
  { "Chamika", 0.0 },
  { "Chamille", 0.0 },
  { "Chamique", 0.0 },
  { "Chamira", 0.0 },
  { "Chamisa", 0.0 },
  { "Chamise", 0.0 },
  { "Chamiya", 0.0 },
  { "Chamiyah", 0.0 },
  { "Champ", 1.0 },
  { "Champagne", 0.0 },
  { "Champaign", 0.0 },
  { "Champaigne", 0.0 },
  { "Champaine", 0.0 },
  { "Champale", 0.0 },
  { "Champane", 0.0 },
  { "Champayne", 0.0 },
  { "Champion", 1.0 },
  { "Chamroeun", 1.0 },
  { "Chamya", 0.0 },
  { "Chan", 0.8219983 },
  { "Chana", 0.0 },
  { "Chanae", 0.0 },
  { "Chanah", 0.0 },
  { "Chanai", 0.0 },
  { "Chanan", 1.0 },
  { "Chananya", 1.0 },
  { "Chanavia", 0.0 },
  { "Chanay", 0.0 },
  { "Chanaya", 0.0 },
  { "Chanc", 1.0 },
  { "Chance", 0.97541356 },
  { "Chancee", 0.0 },
  { "Chanceler", 1.0 },
  { "Chanceller", 1.0 },
  { "Chancellor", 1.0 },
  { "Chancelor", 1.0 },
  { "Chances", 0.0 },
  { "Chanceton", 1.0 },
  { "Chancey", 0.71343285 },
  { "Chanci", 0.0 },
  { "Chancie", 0.123853214 },
  { "Chancler", 1.0 },
  { "Chancy", 0.7546948 },
  { "Chanda", 0.0026251026 },
  { "Chandace", 0.0 },
  { "Chandal", 0.0 },
  { "Chandale", 0.0 },
  { "Chandan", 1.0 },
  { "Chandani", 0.0 },
  { "Chandar", 0.52 },
  { "Chandara", 0.87234044 },
  { "Chande", 1.0 },
  { "Chandee", 0.0 },
  { "Chandel", 0.0 },
  { "Chandell", 0.0 },
  { "Chandelle", 0.0 },
  { "Chanden", 1.0 },
  { "Chander", 1.0 },
  { "Chandi", 0.0 },
  { "Chandice", 0.0 },
  { "Chandini", 0.0 },
  { "Chandlar", 0.36363637 },
  { "Chandler", 0.8049035 },
  { "Chandley", 0.0 },
  { "Chandlor", 1.0 },
  { "Chandlyr", 0.0 },
  { "Chandni", 0.0 },
  { "Chandon", 1.0 },
  { "Chandra", 0.003814147 },
  { "Chandre", 0.0 },
  { "Chandrea", 0.0 },
  { "Chandrell", 0.0 },
  { "Chandria", 0.0 },
  { "Chandrika", 0.0 },
  { "Chandris", 0.0 },
  { "Chandy", 0.0 },
  { "Chane", 0.7117117 },
  { "Chanea", 0.0 },
  { "Chanee", 0.0 },
  { "Chaneice", 0.0 },
  { "Chaneka", 0.0 },
  { "Chanel", 0.005156828 },
  { "Chanele", 0.0 },
  { "Chanell", 0.0 },
  { "Chanella", 0.0 },
  { "Chanelle", 0.0 },
  { "Chanelly", 0.0 },
  { "Chanequa", 0.0 },
  { "Chanese", 0.0 },
  { "Chanet", 0.0 },
  { "Chaneta", 0.0 },
  { "Chanetta", 0.0 },
  { "Chanette", 0.0 },
  { "Chaney", 0.24680851 },
  { "Chaneyra", 0.0 },
  { "Chang", 0.98397434 },
  { "Changa", 1.0 },
  { "Chanh", 1.0 },
  { "Chani", 0.0 },
  { "Chania", 0.0 },
  { "Chaniah", 0.0 },
  { "Chanice", 0.0 },
  { "Chanie", 0.0 },
  { "Chaniece", 0.0 },
  { "Chaniel", 0.0 },
  { "Chanielle", 0.0 },
  { "Chanika", 0.0 },
  { "Chanille", 0.0 },
  { "Chanin", 0.035256412 },
  { "Chanina", 1.0 },
  { "Chaning", 0.4814815 },
  { "Chaniqua", 0.0 },
  { "Chanique", 0.0 },
  { "Chanise", 0.0 },
  { "Chanita", 0.0 },
  { "Chanity", 0.0 },
  { "Chaniya", 0.0 },
  { "Chaniyah", 0.0 },
  { "Chanlee", 0.0 },
  { "Chanler", 0.7204861 },
  { "Chanley", 0.0 },
  { "Channa", 0.0057670125 },
  { "Channah", 0.0 },
  { "Channan", 0.0 },
  { "Channce", 1.0 },
  { "Channel", 0.0 },
  { "Channell", 0.0 },
  { "Channelle", 0.0 },
  { "Channen", 1.0 },
  { "Channer", 1.0 },
  { "Channie", 0.0 },
  { "Channin", 0.5714286 },
  { "Channing", 0.6515233 },
  { "Channon", 0.3384755 },
  { "Channy", 0.3125 },
  { "Chano", 1.0 },
  { "Chanoa", 0.0 },
  { "Chanoch", 1.0 },
  { "Chanon", 0.29545453 },
  { "Chans", 1.0 },
  { "Chanse", 0.9848197 },
  { "Chansler", 1.0 },
  { "Chanson", 1.0 },
  { "Chanston", 1.0 },
  { "Chant", 1.0 },
  { "Chanta", 0.0 },
  { "Chantae", 0.0 },
  { "Chantai", 0.0 },
  { "Chantail", 0.0 },
  { "Chantal", 0.00084490044 },
  { "Chantale", 0.0 },
  { "Chantall", 0.0 },
  { "Chantalle", 0.0 },
  { "Chantasia", 0.0 },
  { "Chantavia", 0.0 },
  { "Chantay", 0.0 },
  { "Chantaye", 0.0 },
  { "Chante", 0.008297712 },
  { "Chantea", 0.0 },
  { "Chanteal", 0.0 },
  { "Chantee", 0.0 },
  { "Chantel", 0.0007440979 },
  { "Chantele", 0.0 },
  { "Chantell", 0.001435132 },
  { "Chantella", 0.0 },
  { "Chantelle", 0.0012277471 },
  { "Chanteria", 0.0 },
  { "Chantey", 0.0 },
  { "Chantez", 0.0 },
  { "Chantha", 0.46875 },
  { "Chanthy", 1.0 },
  { "Chanti", 0.0 },
  { "Chantia", 0.0 },
  { "Chantice", 0.0 },
  { "Chantiel", 0.0 },
  { "Chantil", 0.0 },
  { "Chantile", 0.0 },
  { "Chantill", 0.0 },
  { "Chantille", 0.0 },
  { "Chantilly", 0.0 },
  { "Chantily", 0.0 },
  { "Chantina", 0.0 },
  { "Chantis", 0.0 },
  { "Chantise", 0.0 },
  { "Chantle", 0.0 },
  { "Chantler", 1.0 },
  { "Chantol", 0.0 },
  { "Chanton", 1.0 },
  { "Chantoria", 0.0 },
  { "Chantra", 0.35185185 },
  { "Chantrea", 0.0 },
  { "Chantrel", 0.0 },
  { "Chantrell", 0.0 },
  { "Chantrelle", 0.0 },
  { "Chantrice", 0.0 },
  { "Chantry", 1.0 },
  { "Chanty", 0.0 },
  { "Chantz", 1.0 },
  { "Chany", 0.0 },
  { "Chanya", 0.0 },
  { "Chanyah", 0.0 },
  { "Chanyce", 0.0 },
  { "Chanyia", 0.0 },
  { "Chanz", 1.0 },
  { "Chanze", 1.0 },
  { "Chao", 0.8892308 },
  { "Chaos", 1.0 },
  { "Chap", 1.0 },
  { "Chapel", 0.26086956 },
  { "Chapelle", 0.0 },
  { "Chapin", 0.8381295 },
  { "Chaplin", 1.0 },
  { "Chapman", 1.0 },
  { "Chappell", 0.89361703 },
  { "Chaquan", 0.83870965 },
  { "Chaquana", 0.0 },
  { "Chaquanna", 0.0 },
  { "Chaqueta", 0.0 },
  { "Chaquetta", 0.0 },
  { "Chaquilla", 0.0 },
  { "Chaquille", 0.8148148 },
  { "Chaquita", 0.0 },
  { "Chaquitta", 0.0 },
  { "Char", 0.0 },
  { "Chara", 0.0 },
  { "Charade", 0.0 },
  { "Charae", 0.0 },
  { "Charaine", 0.0 },
  { "Charan", 1.0 },
  { "Charanda", 0.0 },
  { "Charay", 0.0 },
  { "Charbel", 1.0 },
  { "Chard", 1.0 },
  { "Charda", 0.0 },
  { "Chardae", 0.0 },
  { "Chardai", 0.0 },
  { "Chardanae", 0.0 },
  { "Chardanay", 0.0 },
  { "Chardarius", 1.0 },
  { "Chardasia", 0.0 },
  { "Charday", 0.0 },
  { "Charde", 0.0 },
  { "Chardee", 0.0 },
  { "Chardell", 0.0 },
  { "Chardey", 0.0 },
  { "Chardon", 0.0 },
  { "Chardonae", 0.0 },
  { "Chardonay", 0.0 },
  { "Chardonnae", 0.0 },
  { "Chardonnay", 0.0 },
  { "Chare", 0.0 },
  { "Charea", 0.0 },
  { "Charece", 0.0 },
  { "Charee", 0.0 },
  { "Chareen", 0.0 },
  { "Chareese", 0.0 },
  { "Charel", 0.0 },
  { "Charell", 0.0 },
  { "Charelle", 0.0 },
  { "Charels", 1.0 },
  { "Charemon", 0.0 },
  { "Charen", 0.0 },
  { "Charene", 0.0 },
  { "Chares", 1.0 },
  { "Charese", 0.0 },
  { "Charessa", 0.0 },
  { "Charesse", 0.0 },
  { "Charetta", 0.0 },
  { "Charette", 0.0 },
  { "Charger", 1.0 },
  { "Charhonda", 0.0 },
  { "Chari", 0.0 },
  { "Charia", 0.0 },
  { "Chariah", 0.0 },
  { "Charice", 0.0 },
  { "Charidy", 0.0 },
  { "Charie", 0.0 },
  { "Chariel", 0.0 },
  { "Charielle", 0.0 },
  { "Charies", 1.0 },
  { "Chariese", 0.0 },
  { "Charika", 0.0 },
  { "Charilyn", 0.0 },
  { "Charina", 0.0 },
  { "Charis", 0.012023001 },
  { "Charisa", 0.0 },
  { "Charise", 0.0 },
  { "Charish", 0.0 },
  { "Charisha", 0.0 },
  { "Charisma", 0.0 },
  { "Chariss", 0.0 },
  { "Charissa", 0.0 },
  { "Charisse", 0.0 },
  { "Charissma", 0.0 },
  { "Charistopher", 1.0 },
  { "Charita", 0.0 },
  { "Charitee", 0.0 },
  { "Charith", 1.0 },
  { "Charitha", 0.0 },
  { "Chariti", 0.0 },
  { "Charitie", 0.0 },
  { "Charito", 0.0 },
  { "Charity", 0.0011387859 },
  { "Chariya", 0.0 },
  { "Chariyah", 0.0 },
  { "Charizma", 0.0 },
  { "Charkita", 0.0 },
  { "Charl", 0.3529412 },
  { "Charla", 0.0 },
  { "Charlae", 0.0 },
  { "Charlain", 0.0 },
  { "Charlaine", 0.0 },
  { "Charlan", 0.0 },
  { "Charlana", 0.0 },
  { "Charlanda", 0.0 },
  { "Charlane", 0.0 },
  { "Charlann", 0.0 },
  { "Charlanne", 0.0 },
  { "Charlas", 1.0 },
  { "Charlay", 0.0 },
  { "Charlayne", 0.0 },
  { "Charlcie", 0.0 },
  { "Charlcy", 0.0 },
  { "Charle", 0.8764151 },
  { "Charlea", 0.0 },
  { "Charleah", 0.0 },
  { "Charlean", 0.0 },
  { "Charleane", 0.0 },
  { "Charlecia", 0.0 },
  { "Charlee", 0.021695111 },
  { "Charleeann", 0.0 },
  { "Charleen", 0.0 },
  { "Charleene", 0.0 },
  { "Charlei", 0.0 },
  { "Charleigh", 0.0 },
  { "Charlemagne", 0.72727275 },
  { "Charlen", 0.0 },
  { "Charlena", 0.0 },
  { "Charlene", 0.0028784873 },
  { "Charles", 0.99481726 },
  { "Charlesa", 0.0 },
  { "Charlesanthony", 1.0 },
  { "Charlese", 0.0 },
  { "Charlesedward", 1.0 },
  { "Charlesetta", 0.0 },
  { "Charlesha", 0.0 },
  { "Charlesia", 0.0 },
  { "Charlesjoseph", 1.0 },
  { "Charleson", 1.0 },
  { "Charlesten", 1.0 },
  { "Charlestine", 0.0 },
  { "Charleston", 0.74990845 },
  { "Charlestyn", 0.0 },
  { "Charleszetta", 0.0 },
  { "Charlet", 0.0 },
  { "Charleta", 0.0 },
  { "Charletha", 0.0 },
  { "Charleton", 1.0 },
  { "Charlett", 0.0 },
  { "Charletta", 0.0 },
  { "Charlette", 0.0 },
  { "Charley", 0.7672508 },
  { "Charli", 0.020436201 },
  { "Charlia", 0.0 },
  { "Charliann", 0.0 },
  { "Charlianne", 0.0 },
  { "Charlice", 0.0 },
  { "Charlicia", 0.0 },
  { "Charlie", 0.88713044 },
  { "Charlieann", 0.0 },
  { "Charliee", 0.0 },
  { "Charliegh", 0.0 },
  { "Charliemae", 0.0 },
  { "Charliene", 0.0 },
  { "Charlierae", 0.0 },
  { "Charlierose", 0.0 },
  { "Charlies", 1.0 },
  { "Charliese", 0.0 },
  { "Charlii", 0.0 },
  { "Charlin", 0.0 },
  { "Charlina", 0.0 },
  { "Charlinda", 0.0 },
  { "Charline", 0.0 },
  { "Charlirae", 0.0 },
  { "Charlis", 0.82258064 },
  { "Charlisa", 0.0 },
  { "Charlise", 0.0 },
  { "Charlisha", 0.0 },
  { "Charlisia", 0.0 },
  { "Charliss", 0.0 },
  { "Charlissa", 0.0 },
  { "Charlisse", 0.0 },
  { "Charlita", 0.0 },
  { "Charliyah", 0.0 },
  { "Charlize", 0.0 },
  { "Charlla", 0.0 },
  { "Charlles", 1.0 },
  { "Charloette", 0.0 },
  { "Charlon", 0.0 },
  { "Charlona", 0.0 },
  { "Charlonda", 0.0 },
  { "Charlot", 0.0 },
  { "Charlote", 0.0 },
  { "Charlott", 0.0 },
  { "Charlotta", 0.0 },
  { "Charlotte", 0.0020085392 },
  { "Charlotteann", 0.0 },
  { "Charlottee", 0.0 },
  { "Charlottemarie", 0.0 },
  { "Charlotterose", 0.0 },
  { "Charlottie", 0.0 },
  { "Charlottle", 0.0 },
  { "Charls", 1.0 },
  { "Charlsa", 0.0 },
  { "Charlse", 1.0 },
  { "Charlsea", 0.0 },
  { "Charlsey", 0.0 },
  { "Charlsie", 0.0 },
  { "Charlston", 1.0 },
  { "Charlton", 0.9985337 },
  { "Charly", 0.36056533 },
  { "Charlyann", 0.0 },
  { "Charlye", 0.0 },
  { "Charlyee", 0.0 },
  { "Charlyn", 0.0 },
  { "Charlynda", 0.0 },
  { "Charlyne", 0.0 },
  { "Charlynn", 0.0 },
  { "Charlynne", 0.0 },
  { "Charlyse", 0.0 },
  { "Charlytte", 0.0 },
  { "Charlyze", 0.0 },
  { "Charlz", 1.0 },
  { "Charm", 0.0 },
  { "Charma", 0.0 },
  { "Charmae", 0.0 },
  { "Charmagne", 0.0 },
  { "Charmaigne", 0.0 },
  { "Charmain", 0.0 },
  { "Charmaine", 0.0013080444 },
  { "Charman", 0.0 },
  { "Charmane", 0.0 },
  { "Charmarie", 0.0 },
  { "Charmayne", 0.0 },
  { "Charme", 0.0 },
  { "Charmecia", 0.0 },
  { "Charmeka", 0.0 },
  { "Charmel", 0.0 },
  { "Charmell", 0.0 },
  { "Charmella", 0.0 },
  { "Charmelle", 0.0 },
  { "Charmen", 0.0 },
  { "Charmi", 0.0 },
  { "Charmia", 0.0 },
  { "Charmian", 0.0 },
  { "Charmica", 0.0 },
  { "Charmie", 0.0 },
  { "Charmika", 0.0 },
  { "Charmin", 0.0 },
  { "Charmine", 0.0 },
  { "Charming", 1.0 },
  { "Charmion", 0.0 },
  { "Charmisa", 0.0 },
  { "Charmon", 0.0 },
  { "Charmonique", 0.0 },
  { "Charna", 0.0 },
  { "Charnae", 0.0 },
  { "Charnai", 0.0 },
  { "Charnay", 0.0 },
  { "Charnaye", 0.0 },
  { "Charne", 0.0 },
  { "Charnea", 0.0 },
  { "Charnece", 0.0 },
  { "Charnee", 0.0 },
  { "Charneice", 0.0 },
  { "Charneka", 0.0 },
  { "Charnel", 0.0 },
  { "Charnele", 0.0 },
  { "Charnell", 0.0 },
  { "Charnelle", 0.0 },
  { "Charnese", 0.0 },
  { "Charnesha", 0.0 },
  { "Charneshia", 0.0 },
  { "Charnesia", 0.0 },
  { "Charnessa", 0.0 },
  { "Charnetta", 0.0 },
  { "Charnette", 0.0 },
  { "Charney", 0.0 },
  { "Charnice", 0.0 },
  { "Charniece", 0.0 },
  { "Charnika", 0.0 },
  { "Charniqua", 0.0 },
  { "Charnique", 0.0 },
  { "Charnise", 0.0 },
  { "Charnisha", 0.0 },
  { "Charnissa", 0.0 },
  { "Charnita", 0.0 },
  { "Charny", 0.0 },
  { "Charo", 0.024590164 },
  { "Charod", 1.0 },
  { "Charol", 0.0 },
  { "Charolene", 0.0 },
  { "Charolet", 0.0 },
  { "Charolett", 0.0 },
  { "Charolette", 0.0 },
  { "Charolotte", 0.0 },
  { "Charolyn", 0.0 },
  { "Charon", 0.1768092 },
  { "Charona", 0.0 },
  { "Charonda", 0.0 },
  { "Charone", 0.23809524 },
  { "Charotte", 0.0 },
  { "Charquita", 0.0 },
  { "Charra", 0.0 },
  { "Charrell", 0.0 },
  { "Charrelle", 0.0 },
  { "Charri", 0.0 },
  { "Charrie", 0.0 },
  { "Charrise", 0.0 },
  { "Charrissa", 0.0 },
  { "Charrisse", 0.0 },
  { "Charro", 0.0 },
  { "Charron", 0.12315271 },
  { "Charry", 0.0 },
  { "Charryse", 0.0 },
  { "Charsie", 0.0 },
  { "Charta", 0.0 },
  { "Chartese", 0.0 },
  { "Chartez", 1.0 },
  { "Charu", 0.0 },
  { "Charvae", 0.0 },
  { "Charvette", 0.0 },
  { "Charvey", 0.0 },
  { "Charvez", 1.0 },
  { "Charvi", 0.0 },
  { "Charvik", 1.0 },
  { "Charvis", 1.0 },
  { "Charvon", 0.0 },
  { "Chary", 0.0 },
  { "Charyl", 0.0 },
  { "Charylene", 0.0 },
  { "Charyn", 0.0 },
  { "Charysse", 0.0 },
  { "Chas", 0.99688476 },
  { "Chasadee", 0.0 },
  { "Chasadie", 0.0 },
  { "Chasady", 0.0 },
  { "Chasaty", 0.0 },
  { "Chase", 0.97855985 },
  { "Chaselyn", 0.0 },
  { "Chaselynn", 0.0 },
  { "Chasen", 1.0 },
  { "Chasetin", 1.0 },
  { "Chaseton", 1.0 },
  { "Chasey", 0.0 },
  { "Chasia", 0.0 },
  { "Chasidee", 0.0 },
  { "Chasidi", 0.0 },
  { "Chasidy", 0.0 },
  { "Chasie", 0.0 },
  { "Chasin", 1.0 },
  { "Chasitee", 0.0 },
  { "Chasiti", 0.0 },
  { "Chasitie", 0.0 },
  { "Chasitity", 0.0 },
  { "Chasitiy", 0.0 },
  { "Chasitty", 0.0 },
  { "Chasity", 0.000965859 },
  { "Chaska", 0.8701299 },
  { "Chaske", 1.0 },
  { "Chaskel", 1.0 },
  { "Chaslyn", 0.0 },
  { "Chaslynn", 0.0 },
  { "Chasmin", 0.0 },
  { "Chasmine", 0.0 },
  { "Chasney", 0.0 },
  { "Chason", 1.0 },
  { "Chass", 1.0 },
  { "Chassady", 0.0 },
  { "Chasse", 1.0 },
  { "Chassi", 0.0 },
  { "Chassica", 0.0 },
  { "Chassidi", 0.0 },
  { "Chassidy", 0.0 },
  { "Chassie", 0.0 },
  { "Chassiti", 0.0 },
  { "Chassitty", 0.0 },
  { "Chassity", 0.0 },
  { "Chassy", 0.0 },
  { "Chasta", 0.0 },
  { "Chastain", 0.5 },
  { "Chastan", 1.0 },
  { "Chasteen", 1.0 },
  { "Chastelin", 0.0 },
  { "Chasteline", 0.0 },
  { "Chastelyn", 0.0 },
  { "Chastelyne", 0.0 },
  { "Chasten", 0.98188406 },
  { "Chastidy", 0.0 },
  { "Chastie", 0.0 },
  { "Chastin", 0.76666665 },
  { "Chastina", 0.0 },
  { "Chastine", 0.0 },
  { "Chastity", 0.0 },
  { "Chaston", 1.0 },
  { "Chasty", 0.0 },
  { "Chastyn", 1.0 },
  { "Chaswick", 1.0 },
  { "Chasya", 0.0 },
  { "Chasyn", 1.0 },
  { "Chat", 1.0 },
  { "Chata", 0.0 },
  { "Chatal", 0.0 },
  { "Chataqua", 0.0 },
  { "Chatara", 0.0 },
  { "Chatavia", 0.0 },
  { "Chatham", 0.75886524 },
  { "Chatherine", 0.0 },
  { "Chatia", 0.0 },
  { "Chatina", 0.0 },
  { "Chatman", 1.0 },
  { "Chatney", 0.0 },
  { "Chato", 1.0 },
  { "Chatoya", 0.0 },
  { "Chatrice", 0.0 },
  { "Chattie", 0.0 },
  { "Chau", 0.22384937 },
  { "Chaun", 0.97494304 },
  { "Chauna", 0.0 },
  { "Chaunce", 1.0 },
  { "Chauncey", 0.9484107 },
  { "Chaunci", 0.0 },
  { "Chauncie", 0.0 },
  { "Chauncy", 0.9738303 },
  { "Chaunda", 0.0 },
  { "Chaundra", 0.0 },
  { "Chaunice", 0.0 },
  { "Chaunta", 0.0 },
  { "Chauntae", 0.0 },
  { "Chauntay", 0.0 },
  { "Chaunte", 0.0 },
  { "Chauntee", 0.0 },
  { "Chauntel", 0.0 },
  { "Chauntell", 0.0 },
  { "Chauntelle", 0.0 },
  { "Chauntia", 0.0 },
  { "Chauntrice", 0.0 },
  { "Chaurice", 0.0 },
  { "Chava", 0.0 },
  { "Chavah", 0.0 },
  { "Chavas", 1.0 },
  { "Chavaughn", 0.0 },
  { "Chave", 0.0 },
  { "Chavela", 0.0 },
  { "Chaveli", 0.0 },
  { "Chavella", 0.0 },
  { "Chavelle", 0.0 },
  { "Chavely", 0.0 },
  { "Chavez", 0.99017197 },
  { "Chavi", 0.0 },
  { "Chavie", 0.0 },
  { "Chavis", 1.0 },
  { "Chaviva", 0.0 },
  { "Chavon", 0.07575758 },
  { "Chavonda", 0.0 },
  { "Chavone", 0.0 },
  { "Chavonna", 0.0 },
  { "Chavonne", 0.0 },
  { "Chavonte", 0.0 },
  { "Chavy", 0.0 },
  { "Chawana", 0.0 },
  { "Chawanda", 0.0 },
  { "Chawanna", 0.0 },
  { "Chawn", 0.8237885 },
  { "Chawna", 0.0 },
  { "Chay", 0.87383175 },
  { "Chaya", 0.00087435514 },
  { "Chayah", 0.0 },
  { "Chayan", 0.84375 },
  { "Chayane", 1.0 },
  { "Chayanna", 0.0 },
  { "Chayanne", 0.63857377 },
  { "Chayce", 0.8490771 },
  { "Chayden", 0.9783394 },
  { "Chaydon", 1.0 },
  { "Chaye", 0.0 },
  { "Chayenne", 0.0 },
  { "Chayil", 0.0 },
  { "Chayim", 1.0 },
  { "Chayla", 0.0 },
  { "Chaylee", 0.0 },
  { "Chaylen", 0.0 },
  { "Chaylene", 0.0 },
  { "Chaylin", 0.0 },
  { "Chaylyn", 0.0 },
  { "Chaylynn", 0.0 },
  { "Chayna", 0.0 },
  { "Chaynce", 1.0 },
  { "Chayne", 0.9056604 },
  { "Chaynee", 0.0 },
  { "Chayni", 0.0 },
  { "Chayse", 0.706104 },
  { "Chaysen", 1.0 },
  { "Chayson", 1.0 },
  { "Chaysten", 1.0 },
  { "Chayston", 1.0 },
  { "Chayten", 1.0 },
  { "Chayton", 0.99615383 },
  { "Chayzen", 1.0 },
  { "Chaz", 0.98315966 },
  { "Chazaray", 1.0 },
  { "Chazden", 1.0 },
  { "Chaze", 1.0 },
  { "Chazity", 0.0 },
  { "Chazlyn", 0.0 },
  { "Chazlynn", 0.0 },
  { "Chazman", 1.0 },
  { "Chazmin", 0.0 },
  { "Chazmine", 0.0 },
  { "Chazmon", 1.0 },
  { "Chazten", 1.0 },
  { "Chazton", 1.0 },
  { "Chazz", 0.9774495 },
  { "Che", 0.8439777 },
  { "Chea", 0.15789473 },
  { "Chealse", 0.0 },
  { "Chealsea", 0.0 },
  { "Chealsey", 0.0 },
  { "Chealsie", 0.0 },
  { "Chealsy", 0.0 },
  { "Ched", 1.0 },
  { "Chedrick", 1.0 },
  { "Chedva", 0.0 },
  { "Chee", 0.6086142 },
  { "Cheemeng", 1.0 },
  { "Cheena", 0.0 },
  { "Cheenou", 1.0 },
  { "Cheenue", 1.0 },
  { "Cheerful", 0.0 },
  { "Cheetara", 0.0 },
  { "Cheick", 1.0 },
  { "Cheikh", 1.0 },
  { "Cheila", 0.0 },
  { "Cheilon", 0.0 },
  { "Cheire", 0.0 },
  { "Cheisa", 0.0 },
  { "Cheisea", 0.0 },
  { "Chejuana", 0.0 },
  { "Chekesha", 0.0 },
  { "Cheketa", 0.0 },
  { "Chekita", 0.0 },
  { "Chela", 0.0 },
  { "Chelan", 0.0 },
  { "Chelbe", 0.0 },
  { "Chelbi", 0.0 },
  { "Chelbie", 0.0 },
  { "Chelby", 0.0 },
  { "Chelce", 0.0 },
  { "Chelcea", 0.0 },
  { "Chelcee", 0.0 },
  { "Chelcey", 0.0 },
  { "Chelci", 0.0 },
  { "Chelcia", 0.0 },
  { "Chelcie", 0.0 },
  { "Chelcy", 0.0 },
  { "Chele", 0.0 },
  { "Chelea", 0.0 },
  { "Chelena", 0.0 },
  { "Chelene", 0.0 },
  { "Chelesa", 0.0 },
  { "Chelese", 0.0 },
  { "Chelesea", 0.0 },
  { "Chelesy", 0.0 },
  { "Chelette", 0.0 },
  { "Cheli", 0.0 },
  { "Chelia", 0.0 },
  { "Chelisa", 0.0 },
  { "Chelise", 0.0 },
  { "Chelita", 0.0 },
  { "Chella", 0.0 },
  { "Chelle", 0.0 },
  { "Chelley", 0.0 },
  { "Chelli", 0.0 },
  { "Chellie", 0.0 },
  { "Chellsea", 0.0 },
  { "Chellsee", 0.0 },
  { "Chellsey", 0.0 },
  { "Chellsie", 0.0 },
  { "Chelly", 0.0 },
  { "Chelon", 0.0 },
  { "Chelonda", 0.0 },
  { "Chelsa", 0.0 },
  { "Chelsae", 0.0 },
  { "Chelsay", 0.0 },
  { "Chelse", 0.0 },
  { "Chelsea", 0.0028141525 },
  { "Chelseaann", 0.0 },
  { "Chelseaanne", 0.0 },
  { "Chelsealynn", 0.0 },
  { "Chelseamarie", 0.0 },
  { "Chelseay", 0.0 },
  { "Chelsee", 0.0 },
  { "Chelsei", 0.0 },
  { "Chelsen", 0.0 },
  { "Chelsey", 0.0020878168 },
  { "Chelsi", 0.0 },
  { "Chelsia", 0.0 },
  { "Chelsie", 0.0 },
  { "Chelssie", 0.0 },
  { "Chelssy", 0.0 },
  { "Chelsy", 0.0 },
  { "Chelsye", 0.0 },
  { "Chelton", 1.0 },
  { "Cheltzie", 0.0 },
  { "Chely", 0.0 },
  { "Chelyn", 0.0 },
  { "Chelynne", 0.0 },
  { "Chelzie", 0.0 },
  { "Chemaine", 0.0 },
  { "Chemane", 0.0 },
  { "Chemar", 1.0 },
  { "Chemeka", 0.0 },
  { "Chemene", 0.0 },
  { "Chemere", 0.0 },
  { "Chemika", 0.0 },
  { "Chemise", 0.0 },
  { "Chen", 0.75 },
  { "Chena", 0.0 },
  { "Chenae", 0.0 },
  { "Chenavia", 0.0 },
  { "Chenay", 0.0 },
  { "Chenda", 0.0 },
  { "Chendra", 0.0 },
  { "Chene", 0.14666666 },
  { "Chenea", 0.0 },
  { "Chenee", 0.0 },
  { "Cheneka", 0.0 },
  { "Chenel", 0.0 },
  { "Chenele", 0.0 },
  { "Chenell", 0.0 },
  { "Chenelle", 0.0 },
  { "Chenequa", 0.0 },
  { "Chenese", 0.0 },
  { "Cheney", 0.36391437 },
  { "Cheng", 0.9414484 },
  { "Chengyu", 1.0 },
  { "Chenia", 0.0 },
  { "Chenice", 0.0 },
  { "Cheniece", 0.0 },
  { "Chenier", 1.0 },
  { "Chenika", 0.0 },
  { "Chenille", 0.0 },
  { "Chenin", 0.0 },
  { "Cheniqua", 0.0 },
  { "Chenique", 0.0 },
  { "Chenise", 0.0 },
  { "Chenita", 0.0 },
  { "Cheniya", 0.0 },
  { "Chennel", 0.0 },
  { "Chennell", 0.0 },
  { "Chennelle", 0.0 },
  { "Chenoa", 0.0 },
  { "Chenoah", 0.0 },
  { "Chentel", 0.0 },
  { "Chenxi", 0.0 },
  { "Chenyu", 1.0 },
  { "Cheo", 1.0 },
  { "Chequetta", 0.0 },
  { "Chequita", 0.0 },
  { "Cher", 0.06097561 },
  { "Chera", 0.0 },
  { "Cherae", 0.0 },
  { "Cherakee", 0.0 },
  { "Cheral", 0.0 },
  { "Cheralee", 0.0 },
  { "Cheralyn", 0.0 },
  { "Cheramie", 0.0 },
  { "Cheray", 0.0 },
  { "Chere", 0.0 },
  { "Cherea", 0.0 },
  { "Cherece", 0.0 },
  { "Cheree", 0.0 },
  { "Chereen", 0.0 },
  { "Chereese", 0.0 },
  { "Chereka", 0.0 },
  { "Cherel", 0.0 },
  { "Cherell", 0.0 },
  { "Cherelle", 0.0 },
  { "Cherelyn", 0.0 },
  { "Cherena", 0.0 },
  { "Cherene", 0.0 },
  { "Cheresa", 0.0 },
  { "Cherese", 0.0 },
  { "Cheresse", 0.0 },
  { "Cheretta", 0.0 },
  { "Cherette", 0.0 },
  { "Cherhonda", 0.0 },
  { "Cheri", 0.00033307428 },
  { "Cheria", 0.0 },
  { "Cheriah", 0.0 },
  { "Cheriann", 0.0 },
  { "Cherianne", 0.0 },
  { "Cherica", 0.0 },
  { "Cherice", 0.0 },
  { "Chericka", 0.0 },
  { "Cherida", 0.0 },
  { "Cheridan", 0.0 },
  { "Cheridyn", 0.0 },
  { "Cherie", 0.000870322 },
  { "Cheriece", 0.0 },
  { "Cheriese", 0.0 },
  { "Cherif", 1.0 },
  { "Cherika", 0.0 },
  { "Cheril", 0.0 },
  { "Cherilee", 0.0 },
  { "Cherill", 0.0 },
  { "Cherilyn", 0.0 },
  { "Cherilynn", 0.0 },
  { "Cherin", 0.0 },
  { "Cherina", 0.0 },
  { "Cherine", 0.0 },
  { "Cheris", 0.0 },
  { "Cherisa", 0.0 },
  { "Cherise", 0.0 },
  { "Cherish", 0.0 },
  { "Cherisha", 0.0 },
  { "Cherissa", 0.0 },
  { "Cherisse", 0.0 },
  { "Cherita", 0.0 },
  { "Cherith", 0.0 },
  { "Cherity", 0.0 },
  { "Cherl", 0.0 },
  { "Cherle", 0.0 },
  { "Cherlene", 0.0 },
  { "Cherles", 1.0 },
  { "Cherlin", 0.0 },
  { "Cherline", 0.0 },
  { "Cherlonda", 0.0 },
  { "Cherly", 0.0 },
  { "Cherlyl", 0.0 },
  { "Cherlyn", 0.0 },
  { "Cherlynn", 0.0 },
  { "Chermaine", 0.0 },
  { "Chermeka", 0.0 },
  { "Cherod", 1.0 },
  { "Cherokee", 0.122238584 },
  { "Cherol", 0.0 },
  { "Cherolyn", 0.0 },
  { "Cheron", 0.13487738 },
  { "Cheronda", 0.0 },
  { "Cherone", 0.0 },
  { "Cherra", 0.0 },
  { "Cherre", 0.0 },
  { "Cherree", 0.0 },
  { "Cherrel", 0.0 },
  { "Cherrell", 0.0 },
  { "Cherrelle", 0.0 },
  { "Cherri", 0.0 },
  { "Cherrica", 0.0 },
  { "Cherrice", 0.0 },
  { "Cherrie", 0.0 },
  { "Cherril", 0.0 },
  { "Cherrill", 0.0 },
  { "Cherrilyn", 0.0 },
  { "Cherrilynn", 0.0 },
  { "Cherrise", 0.0 },
  { "Cherrish", 0.0 },
  { "Cherrisse", 0.0 },
  { "Cherrita", 0.0 },
  { "Cherron", 0.015527951 },
  { "Cherronda", 0.0 },
  { "Cherry", 0.011783189 },
  { "Cherryann", 0.0 },
  { "Cherrye", 0.0 },
  { "Cherryl", 0.0 },
  { "Cherryle", 0.0 },
  { "Cherryll", 0.0 },
  { "Cherub", 0.0 },
  { "Chervon", 0.0 },
  { "Chervonne", 0.0 },
  { "Chery", 0.0 },
  { "Cheryal", 0.0 },
  { "Cheryce", 0.0 },
  { "Cherye", 0.0 },
  { "Cheryel", 0.0 },
  { "Cheryl", 0.0022266908 },
  { "Cheryla", 0.0 },
  { "Cherylan", 0.0 },
  { "Cherylann", 0.0 },
  { "Cherylanne", 0.0 },
  { "Cheryle", 0.0 },
  { "Cherylee", 0.0 },
  { "Cherylene", 0.0 },
  { "Cherylin", 0.0 },
  { "Cheryll", 0.0 },
  { "Cherylle", 0.0 },
  { "Cheryllee", 0.0 },
  { "Cheryllyn", 0.0 },
  { "Cheryllynn", 0.0 },
  { "Cheryllynne", 0.0 },
  { "Cheryln", 0.0 },
  { "Cherylyn", 0.0 },
  { "Cherylynn", 0.0 },
  { "Cheryn", 0.0 },
  { "Cheryse", 0.0 },
  { "Cherysh", 0.0 },
  { "Ches", 1.0 },
  { "Chesa", 0.0 },
  { "Chesica", 0.0 },
  { "Cheska", 0.0 },
  { "Cheskel", 1.0 },
  { "Chesky", 1.0 },
  { "Cheslea", 0.0 },
  { "Chesleigh", 0.47619048 },
  { "Chesley", 0.79774487 },
  { "Cheslie", 0.0 },
  { "Chesna", 0.0 },
  { "Chesnee", 0.0 },
  { "Chesney", 0.055657774 },
  { "Chesni", 0.0 },
  { "Chesnie", 0.0 },
  { "Chess", 1.0 },
  { "Chessa", 0.0 },
  { "Chessica", 0.0 },
  { "Chessie", 0.0 },
  { "Chesten", 1.0 },
  { "Chester", 0.99318796 },
  { "Chesterfield", 1.0 },
  { "Chesterine", 0.0 },
  { "Chestin", 1.0 },
  { "Chestina", 0.0 },
  { "Chestine", 0.016025642 },
  { "Chestley", 1.0 },
  { "Cheston", 1.0 },
  { "Chet", 1.0 },
  { "Chetan", 1.0 },
  { "Chetana", 0.0 },
  { "Chetanna", 1.0 },
  { "Chetara", 0.0 },
  { "Chethan", 1.0 },
  { "Chett", 1.0 },
  { "Cheval", 1.0 },
  { "Chevala", 0.0 },
  { "Chevalier", 1.0 },
  { "Chevas", 1.0 },
  { "Chevaun", 0.0 },
  { "Chevell", 0.0 },
  { "Chevella", 0.0 },
  { "Chevelle", 0.07009175 },
  { "Chevette", 0.0 },
  { "Cheveyo", 1.0 },
  { "Chevez", 1.0 },
  { "Chevi", 0.0 },
  { "Chevie", 0.20987654 },
  { "Chevis", 0.96 },
  { "Chevon", 0.10194175 },
  { "Chevonda", 0.0 },
  { "Chevone", 0.0 },
  { "Chevonne", 0.0 },
  { "Chevy", 0.8273447 },
  { "Chew", 1.0 },
  { "Chey", 0.5135135 },
  { "Cheyan", 0.0 },
  { "Cheyana", 0.0 },
  { "Cheyane", 0.0 },
  { "Cheyann", 0.0 },
  { "Cheyanna", 0.0 },
  { "Cheyanne", 0.0 },
  { "Cheyeanne", 0.0 },
  { "Cheyeene", 0.0 },
  { "Cheyene", 0.029649595 },
  { "Cheyenn", 0.0 },
  { "Cheyenna", 0.0 },
  { "Cheyenne", 0.038407404 },
  { "Cheyla", 0.0 },
  { "Cheylee", 0.0 },
  { "Cheylin", 0.0 },
  { "Cheylyn", 0.0 },
  { "Cheylynn", 0.0 },
  { "Cheyna", 0.0 },
  { "Cheyne", 0.8870334 },
  { "Cheyney", 0.15151516 },
  { "Cheynne", 0.0 },
  { "Cheyrl", 0.0 },
  { "Cheyton", 1.0 },
  { "Chez", 0.8 },
  { "Cheza", 0.0 },
  { "Chezarae", 0.6 },
  { "Chezaray", 1.0 },
  { "Chezare", 0.75 },
  { "Chezkel", 1.0 },
  { "Chezky", 1.0 },
  { "Chezney", 0.0 },
  { "Cheznie", 0.0 },
  { "Chi", 0.43601894 },
  { "Chia", 0.24381626 },
  { "Chiagoziem", 1.0 },
  { "Chiaki", 0.0 },
  { "Chiam", 1.0 },
  { "Chiamaka", 0.0 },
  { "Chiamanda", 0.0 },
  { "Chian", 0.0 },
  { "Chiana", 0.0 },
  { "Chiane", 0.0 },
  { "Chiani", 0.0 },
  { "Chiann", 0.0 },
  { "Chianna", 0.0 },
  { "Chianne", 0.0 },
  { "Chiante", 0.06329114 },
  { "Chianti", 0.04901961 },
  { "Chiara", 0.0 },
  { "Chiarra", 0.0 },
  { "Chibueze", 1.0 },
  { "Chibuike", 1.0 },
  { "Chibuikem", 1.0 },
  { "Chibuzo", 1.0 },
  { "Chibuzor", 1.0 },
  { "Chic", 1.0 },
  { "Chicago", 1.0 },
  { "Chick", 1.0 },
  { "Chico", 1.0 },
  { "Chicora", 0.0 },
  { "Chicquita", 0.0 },
  { "Chidalu", 1.0 },
  { "Chidera", 0.32780847 },
  { "Chidi", 1.0 },
  { "Chidiebere", 1.0 },
  { "Chidiebube", 1.0 },
  { "Chidima", 0.0 },
  { "Chidimma", 0.0 },
  { "Chidinma", 0.0 },
  { "Chidozie", 1.0 },
  { "Chidubem", 1.0 },
  { "Chidumebi", 0.0 },
  { "Chie", 0.0 },
  { "Chiebuka", 1.0 },
  { "Chiedozie", 1.0 },
  { "Chiedu", 1.0 },
  { "Chief", 1.0 },
  { "Chieko", 0.0 },
  { "Chiem", 1.0 },
  { "Chiemeka", 1.0 },
  { "Chiemela", 0.0 },
  { "Chiemerie", 1.0 },
  { "Chiemi", 0.0 },
  { "Chien", 1.0 },
  { "Chierika", 0.0 },
  { "Chiffon", 0.0 },
  { "Chigozie", 0.95522386 },
  { "Chigozirim", 0.76 },
  { "Chih", 1.0 },
  { "Chihiro", 0.0 },
  { "Chijioke", 1.0 },
  { "Chika", 0.076712325 },
  { "Chikaima", 0.0 },
  { "Chikamara", 0.0 },
  { "Chikamso", 0.5535714 },
  { "Chikara", 0.0 },
  { "Chike", 1.0 },
  { "Chiketa", 0.0 },
  { "Chikezie", 1.0 },
  { "Chikita", 0.0 },
  { "Child", 0.5954198 },
  { "Childnotnamed", 0.0 },
  { "Chilton", 1.0 },
  { "Chilyn", 0.0 },
  { "Chima", 1.0 },
  { "Chimamaka", 0.0 },
  { "Chimamanda", 0.0 },
  { "Chimaobi", 1.0 },
  { "Chimaobim", 1.0 },
  { "Chimdi", 1.0 },
  { "Chimeka", 0.0 },
  { "Chimene", 0.0 },
  { "Chimeng", 1.0 },
  { "Chimera", 0.0 },
  { "Chimere", 0.0060313633 },
  { "Chimereze", 1.0 },
  { "Chimira", 0.0 },
  { "Chin", 1.0 },
  { "China", 0.0022168034 },
  { "Chinara", 0.0 },
  { "Chinasa", 0.0 },
  { "Chinaza", 0.0 },
  { "Chinda", 0.0 },
  { "Chinedu", 1.0 },
  { "Chinedum", 1.0 },
  { "Chineka", 0.0 },
  { "Chinelle", 0.0 },
  { "Chinelo", 0.036764707 },
  { "Chineme", 0.0 },
  { "Chinemerem", 0.88372093 },
  { "Chinenye", 0.0 },
  { "Chinere", 0.0 },
  { "Chinesta", 0.0 },
  { "Chinester", 0.0 },
  { "Chineta", 0.0 },
  { "Chinetta", 0.0 },
  { "Chineye", 0.0 },
  { "Ching", 0.7368421 },
  { "Chinh", 1.0 },
  { "Chinika", 0.0 },
  { "Chiniqua", 0.0 },
  { "Chinita", 0.0 },
  { "Chinitta", 0.0 },
  { "Chinmay", 1.0 },
  { "Chinmayi", 0.0 },
  { "Chinna", 0.0 },
  { "Chino", 1.0 },
  { "Chinomso", 1.0 },
  { "Chinonso", 1.0 },
  { "Chinonye", 0.0 },
  { "Chinou", 1.0 },
  { "Chintan", 1.0 },
  { "Chinua", 1.0 },
  { "Chinue", 0.0 },
  { "Chinwe", 0.0 },
  { "Chinwendu", 0.0 },
  { "Chinyere", 0.0 },
  { "Chioke", 1.0 },
  { "Chioma", 0.0 },
  { "Chip", 1.0 },
  { "Chipper", 1.0 },
  { "Chiquana", 0.0 },
  { "Chiqueta", 0.0 },
  { "Chiquetta", 0.0 },
  { "Chiquia", 0.0 },
  { "Chiquila", 0.0 },
  { "Chiquita", 0.00096432015 },
  { "Chiquitha", 0.0 },
  { "Chiquitia", 0.0 },
  { "Chiquitta", 0.0 },
  { "Chiquta", 0.0 },
  { "Chira", 0.0 },
  { "Chiraag", 1.0 },
  { "Chirag", 1.0 },
  { "Chirelle", 0.0 },
  { "Chiriga", 0.0 },
  { "Chirles", 1.0 },
  { "Chirley", 0.0 },
  { "Chiron", 0.91071427 },
  { "Chirs", 1.0 },
  { "Chirstian", 1.0 },
  { "Chirstina", 0.0 },
  { "Chirstine", 0.0 },
  { "Chirstopher", 1.0 },
  { "Chirsty", 0.0 },
  { "Chisa", 0.0 },
  { "Chisara", 0.0 },
  { "Chisato", 0.0 },
  { "Chisholm", 1.0 },
  { "Chisimdi", 0.0 },
  { "Chisom", 0.2925532 },
  { "Chistian", 1.0 },
  { "Chistie", 0.0 },
  { "Chistina", 0.0 },
  { "Chistine", 0.0 },
  { "Chistopher", 1.0 },
  { "Chisty", 0.0 },
  { "Chisum", 1.0 },
  { "Chitara", 0.0 },
  { "Chitina", 0.0 },
  { "Chitose", 0.0 },
  { "Chitra", 0.0 },
  { "Chivas", 1.0 },
  { "Chivon", 0.0 },
  { "Chivonne", 0.0 },
  { "Chiya", 0.0 },
  { "Chiye", 0.0 },
  { "Chiyeko", 0.0 },
  { "Chiyo", 0.0 },
  { "Chiyoka", 0.0 },
  { "Chiyoko", 0.0 },
  { "Chiyono", 0.0 },
  { "Chizara", 0.0 },
  { "Chizaram", 0.05978261 },
  { "Chizitelu", 0.0 },
  { "Chizitere", 0.0 },
  { "Chiziterem", 0.0 },
  { "Chizoba", 0.0 },
  { "Chizu", 0.0 },
  { "Chizue", 0.0 },
  { "Chizuko", 0.0 },
  { "Chlo", 0.0 },
  { "Chloa", 0.0 },
  { "Chloe", 0.0015658045 },
  { "Chloeann", 0.0 },
  { "Chloeanne", 0.0 },
  { "Chloee", 0.0 },
  { "Chloegrace", 0.0 },
  { "Chloeigh", 0.0 },
  { "Chloejane", 0.0 },
  { "Chloelynn", 0.0 },
  { "Chloemae", 0.0 },
  { "Chloemarie", 0.0 },
  { "Chloey", 0.0 },
  { "Chloi", 0.0 },
  { "Chloie", 0.0 },
  { "Chlora", 0.0 },
  { "Chlorene", 0.0 },
  { "Chlorine", 0.0 },
  { "Chloris", 0.0 },
  { "Chloye", 0.0 },
  { "Choice", 0.97619045 },
  { "Chol", 1.0 },
  { "Chole", 0.0 },
  { "Cholena", 0.0 },
  { "Chon", 1.0 },
  { "Chona", 0.0 },
  { "Chonda", 0.0 },
  { "Chondra", 0.0 },
  { "Chong", 0.59574467 },
  { "Chonita", 0.0 },
  { "Chonna", 0.0 },
  { "Chontae", 0.0 },
  { "Chonte", 0.0 },
  { "Chontel", 0.0 },
  { "Chontell", 0.0 },
  { "Chontelle", 0.0 },
  { "Chord", 1.0 },
  { "Chorlette", 0.0 },
  { "Chosen", 0.7368421 },
  { "Chosyn", 1.0 },
  { "Chou", 1.0 },
  { "Choua", 0.18067227 },
  { "Choya", 0.8202247 },
  { "Choyce", 0.56 },
  { "Chozen", 1.0 },
  { "Chquita", 0.0 },
  { "Chree", 0.0 },
  { "Chrie", 0.0 },
  { "Chris", 0.8625032 },
  { "Chrisa", 0.0 },
  { "Chrisalyn", 0.0 },
  { "Chrisalynn", 0.0 },
  { "Chrisan", 0.0 },
  { "Chrisander", 1.0 },
  { "Chrisandra", 0.0 },
  { "Chrisangel", 1.0 },
  { "Chrisann", 0.0 },
  { "Chrisanna", 0.0 },
  { "Chrisanne", 0.0 },
  { "Chrisanthe", 0.0 },
  { "Chrisanthi", 0.0 },
  { "Chrisanthony", 1.0 },
  { "Chrisaun", 1.0 },
  { "Chrisean", 1.0 },
  { "Chrisel", 0.0 },
  { "Chriselda", 0.0 },
  { "Chriselle", 0.0 },
  { "Chrisette", 0.0 },
  { "Chrisha", 0.0 },
  { "Chrishad", 1.0 },
  { "Chrishae", 0.0 },
  { "Chrishana", 0.0 },
  { "Chrishanda", 0.0 },
  { "Chrishanna", 0.0 },
  { "Chrishaud", 1.0 },
  { "Chrishaun", 0.98054475 },
  { "Chrishauna", 0.0 },
  { "Chrishaunda", 0.0 },
  { "Chrishawn", 0.91240877 },
  { "Chrishawna", 0.0 },
  { "Chrishay", 0.0 },
  { "Chrishayla", 0.0 },
  { "Chrishea", 0.0 },
  { "Chrishell", 0.0 },
  { "Chrishelle", 0.0 },
  { "Chrishiya", 0.0 },
  { "Chrishna", 0.0 },
  { "Chrishon", 1.0 },
  { "Chrishona", 0.0 },
  { "Chrishonda", 0.0 },
  { "Chrishonna", 0.0 },
  { "Chrishun", 1.0 },
  { "Chrishya", 0.0 },
  { "Chrisi", 0.0 },
  { "Chrisie", 0.0 },
  { "Chrisina", 0.0 },
  { "Chrisinda", 0.0 },
  { "Chrisine", 0.0 },
  { "Chrisitan", 1.0 },
  { "Chrisitne", 0.0 },
  { "Chrisiyah", 0.0 },
  { "Chrisley", 0.0 },
  { "Chrisly", 0.0 },
  { "Chrislyn", 0.0 },
  { "Chrislynn", 0.0 },
  { "Chrisma", 0.0 },
  { "Chrisna", 0.375 },
  { "Chrisopher", 1.0 },
  { "Chrisotpher", 1.0 },
  { "Chrisoula", 0.0 },
  { "Chrispher", 1.0 },
  { "Chrispin", 1.0 },
  { "Chriss", 0.7536946 },
  { "Chrissa", 0.0 },
  { "Chrissandra", 0.0 },
  { "Chrissean", 1.0 },
  { "Chrissette", 0.0 },
  { "Chrissey", 0.0 },
  { "Chrisshawn", 1.0 },
  { "Chrissi", 0.0 },
  { "Chrissiana", 0.0 },
  { "Chrissie", 0.0 },
  { "Chrissy", 0.0 },
  { "Christ", 0.9861922 },
  { "Christa", 0.00082855124 },
  { "Christabel", 0.0 },
  { "Christabell", 0.0 },
  { "Christabella", 0.0 },
  { "Christabelle", 0.0 },
  { "Christafer", 1.0 },
  { "Christain", 0.86976945 },
  { "Christal", 0.0 },
  { "Christale", 0.0 },
  { "Christalle", 0.0 },
  { "Christalyn", 0.0 },
  { "Christalynn", 0.0 },
  { "Christan", 0.5164602 },
  { "Christana", 0.0 },
  { "Christann", 0.0 },
  { "Christanna", 0.0 },
  { "Christany", 0.0 },
  { "Christapher", 1.0 },
  { "Christaphor", 1.0 },
  { "Christasha", 0.0 },
  { "Christasia", 0.0 },
  { "Christe", 0.0 },
  { "Christean", 0.0 },
  { "Christeanna", 0.0 },
  { "Christee", 0.0 },
  { "Christeen", 0.0 },
  { "Christeena", 0.0 },
  { "Christel", 0.0 },
  { "Christela", 0.0 },
  { "Christell", 0.0 },
  { "Christella", 0.0 },
  { "Christelle", 0.0 },
  { "Christen", 0.15215774 },
  { "Christena", 0.0 },
  { "Christene", 0.0 },
  { "Christenia", 0.0 },
  { "Christepher", 1.0 },
  { "Christer", 1.0 },
  { "Christerfer", 1.0 },
  { "Christerpher", 1.0 },
  { "Christerphor", 1.0 },
  { "Christey", 0.0 },
  { "Christhian", 1.0 },
  { "Christhoper", 1.0 },
  { "Christhopher", 1.0 },
  { "Christi", 0.0010535894 },
  { "Christia", 0.10161091 },
  { "Christiaan", 1.0 },
  { "Christiam", 1.0 },
  { "Christian", 0.9546493 },
  { "Christiana", 0.0 },
  { "Christianah", 0.0 },
  { "Christianalexan", 1.0 },
  { "Christiananthon", 1.0 },
  { "Christiandaniel", 1.0 },
  { "Christiane", 0.002676182 },
  { "Christianjacob", 1.0 },
  { "Christianjames", 1.0 },
  { "Christianjay", 1.0 },
  { "Christianjohn", 1.0 },
  { "Christianjoseph", 1.0 },
  { "Christianjoshua", 1.0 },
  { "Christianmichae", 1.0 },
  { "Christiann", 0.0 },
  { "Christianna", 0.0 },
  { "Christianne", 0.0 },
  { "Christiano", 1.0 },
  { "Christianpaul", 1.0 },
  { "Christianson", 1.0 },
  { "Christie", 0.018928189 },
  { "Christieann", 0.0 },
  { "Christielee", 0.0 },
  { "Christien", 0.868472 },
  { "Christiene", 0.0 },
  { "Christienne", 0.0 },
  { "Christifer", 1.0 },
  { "Christin", 0.08137611 },
  { "Christina", 0.004166099 },
  { "Christinamarie", 0.0 },
  { "Christine", 0.0034627456 },
  { "Christinea", 0.0 },
  { "Christineanne", 0.0 },
  { "Christinejoy", 0.0 },
  { "Christinemarie", 0.0 },
  { "Christing", 0.0 },
  { "Christinia", 0.0 },
  { "Christinna", 0.0 },
  { "Christino", 1.0 },
  { "Christion", 0.9854077 },
  { "Christiona", 0.0 },
  { "Christionna", 0.0 },
  { "Christiopher", 1.0 },
  { "Christipher", 1.0 },
  { "Christiyana", 0.0 },
  { "Christl", 0.0 },
  { "Christle", 0.0 },
  { "Christlyn", 0.0 },
  { "Christlynn", 0.0 },
  { "Christmas", 0.0 },
  { "Christna", 0.0 },
  { "Christne", 0.0 },
  { "Christo", 1.0 },
  { "Christobal", 1.0 },
  { "Christobel", 0.0 },
  { "Christof", 1.0 },
  { "Christofer", 1.0 },
  { "Christoff", 1.0 },
  { "Christoffer", 1.0 },
  { "Christofher", 1.0 },
  { "Christoher", 1.0 },
  { "Christohper", 1.0 },
  { "Christohpher", 1.0 },
  { "Christol", 0.0 },
  { "Christola", 0.0 },
  { "Christon", 0.8274832 },
  { "Christoopher", 1.0 },
  { "Christop", 1.0 },
  { "Christopehr", 1.0 },
  { "Christoper", 1.0 },
  { "Christoph", 1.0 },
  { "Christophe", 1.0 },
  { "Christophel", 1.0 },
  { "Christophen", 1.0 },
  { "Christopher", 0.995323 },
  { "Christopheranth", 1.0 },
  { "Christopherdavi", 1.0 },
  { "Christophere", 1.0 },
  { "Christopherjame", 1.0 },
  { "Christopherjohn", 1.0 },
  { "Christopherjose", 1.0 },
  { "Christopherjr", 1.0 },
  { "Christopherlee", 1.0 },
  { "Christophermich", 1.0 },
  { "Christopherpaul", 1.0 },
  { "Christopherryan", 1.0 },
  { "Christophor", 1.0 },
  { "Christophr", 1.0 },
  { "Christopoher", 1.0 },
  { "Christorpher", 1.0 },
  { "Christos", 1.0 },
  { "Christoval", 1.0 },
  { "Christpher", 1.0 },
  { "Christphor", 1.0 },
  { "Christpoher", 1.0 },
  { "Christropher", 1.0 },
  { "Christy", 0.01933536 },
  { "Christyan", 0.9820144 },
  { "Christyana", 0.0 },
  { "Christyann", 0.0 },
  { "Christyanna", 0.0 },
  { "Christye", 0.0 },
  { "Christyl", 0.0 },
  { "Christyle", 0.0 },
  { "Christylee", 0.0 },
  { "Christyn", 0.0058708414 },
  { "Christyna", 0.0 },
  { "Christyne", 0.0 },
  { "Christyonna", 0.0 },
  { "Chrisy", 0.0 },
  { "Chritian", 1.0 },
  { "Chritina", 0.0 },
  { "Chritine", 0.0 },
  { "Chritopher", 1.0 },
  { "Chrles", 1.0 },
  { "Chrostopher", 1.0 },
  { "Chrsitina", 0.0 },
  { "Chrsitine", 0.0 },
  { "Chrsitopher", 1.0 },
  { "Chrstina", 0.0 },
  { "Chrstine", 0.0 },
  { "Chrstopher", 1.0 },
  { "Chryel", 0.0 },
  { "Chryl", 0.0 },
  { "Chrys", 0.09767442 },
  { "Chrysa", 0.0 },
  { "Chrysander", 1.0 },
  { "Chrysanne", 0.0 },
  { "Chrysanthe", 0.0 },
  { "Chrysanthemum", 0.0 },
  { "Chrysanthia", 0.0 },
  { "Chrysoula", 0.0 },
  { "Chryssa", 0.0 },
  { "Chrysta", 0.0 },
  { "Chrystal", 0.0003190607 },
  { "Chrystalyn", 0.0 },
  { "Chrystan", 0.0 },
  { "Chrysteen", 0.0 },
  { "Chrystel", 0.0 },
  { "Chrystell", 0.0 },
  { "Chrystelle", 0.0 },
  { "Chrysten", 0.0 },
  { "Chrystene", 0.0 },
  { "Chrysti", 0.0 },
  { "Chrystian", 0.9109415 },
  { "Chrystiana", 0.0 },
  { "Chrystie", 0.0 },
  { "Chrystin", 0.0 },
  { "Chrystina", 0.0 },
  { "Chrystine", 0.0 },
  { "Chrystle", 0.0 },
  { "Chrystopher", 1.0 },
  { "Chrystyan", 1.0 },
  { "Chrystyna", 0.0 },
  { "Chu", 1.0 },
  { "Chua", 0.0 },
  { "Chubasco", 1.0 },
  { "Chubbie", 1.0 },
  { "Chubby", 1.0 },
  { "Chuck", 1.0 },
  { "Chuckie", 1.0 },
  { "Chucky", 1.0 },
  { "Chudney", 0.061728396 },
  { "Chue", 0.98502994 },
  { "Chuefeng", 1.0 },
  { "Chueyee", 1.0 },
  { "Chuka", 1.0 },
  { "Chukwubuikem", 1.0 },
  { "Chukwudi", 1.0 },
  { "Chukwudubem", 1.0 },
  { "Chukwuebuka", 1.0 },
  { "Chukwuemeka", 1.0 },
  { "Chukwuka", 1.0 },
  { "Chukwuma", 1.0 },
  { "Chukwunonso", 1.0 },
  { "Chuma", 1.0 },
  { "Chumani", 0.0 },
  { "Chumy", 0.0 },
  { "Chun", 0.81666666 },
  { "Chuna", 1.0 },
  { "Chundra", 0.0 },
  { "Chung", 0.94736844 },
  { "Chunta", 0.0 },
  { "Chuong", 1.0 },
  { "Church", 1.0 },
  { "Churchel", 1.0 },
  { "Churchill", 1.0 },
  { "Chutney", 0.0 },
  { "Chuy", 1.0 },
  { "Chy", 0.0 },
  { "Chyan", 0.0 },
  { "Chyana", 0.0 },
  { "Chyane", 0.0 },
  { "Chyann", 0.0 },
  { "Chyanna", 0.0 },
  { "Chyanne", 0.0017755682 },
  { "Chyeanne", 0.0 },
  { "Chyene", 0.0 },
  { "Chyenna", 0.0 },
  { "Chyenne", 0.0036737693 },
  { "Chyla", 0.0 },
  { "Chylah", 0.0 },
  { "Chylar", 0.0 },
  { "Chylee", 0.0 },
  { "Chyleen", 0.0 },
  { "Chyler", 0.17747441 },
  { "Chyles", 0.0 },
  { "Chylie", 0.0 },
  { "Chylynn", 0.0 },
  { "Chyna", 0.0 },
  { "Chynah", 0.0 },
  { "Chynia", 0.0 },
  { "Chynna", 0.0 },
  { "Chynthia", 0.0 },
  { "Chyra", 0.0 },
  { "Chyral", 0.0 },
  { "Chyrel", 0.0 },
  { "Chyrell", 0.0 },
  { "Chyrisse", 0.0 },
  { "Chyrl", 0.0 },
  { "Chyrle", 0.0 },
  { "Chyrstal", 0.0 },
  { "Chystal", 0.0 },
  { "Chyvonne", 0.0 },
  { "Cia", 0.0 },
  { "Ciah", 0.0 },
  { "Ciaira", 0.0 },
  { "Cian", 0.9912525 },
  { "Ciana", 0.0 },
  { "Cianah", 0.0 },
  { "Cianan", 1.0 },
  { "Ciandra", 0.0 },
  { "Ciane", 0.0 },
  { "Ciani", 0.0 },
  { "Cianie", 0.0 },
  { "Cianna", 0.0 },
  { "Ciannah", 0.0 },
  { "Cianne", 0.0 },
  { "Cianni", 0.0 },
  { "Cianny", 0.0 },
  { "Ciara", 0.0002118067 },
  { "Ciarah", 0.0 },
  { "Ciaran", 0.98050684 },
  { "Ciaria", 0.0 },
  { "Ciarra", 0.0 },
  { "Ciarrah", 0.0 },
  { "Ciasia", 0.0 },
  { "Ciauna", 0.0 },
  { "Ciboney", 0.0 },
  { "Cicel", 1.0 },
  { "Ciceley", 0.0 },
  { "Cicely", 0.0 },
  { "Cicero", 1.0 },
  { "Cici", 0.0 },
  { "Cicilia", 0.0 },
  { "Cicily", 0.0 },
  { "Ciclali", 0.0 },
  { "Ciclaly", 0.0 },
  { "Cicley", 0.0 },
  { "Cid", 1.0 },
  { "Cidalia", 0.0 },
  { "Cidnee", 0.0 },
  { "Cidney", 0.019165726 },
  { "Cidni", 0.0 },
  { "Cidnie", 0.0 },
  { "Cie", 0.0 },
  { "Cieana", 0.0 },
  { "Cieanna", 0.0 },
  { "Cieara", 0.0 },
  { "Ciearra", 0.0 },
  { "Ciel", 0.31986532 },
  { "Ciela", 0.0 },
  { "Cielita", 0.0 },
  { "Ciella", 0.0 },
  { "Cielle", 0.0 },
  { "Cielo", 0.014109986 },
  { "Ciena", 0.0 },
  { "Cienna", 0.0 },
  { "Ciera", 0.000445474 },
  { "Cierah", 0.0 },
  { "Cieran", 1.0 },
  { "Cieria", 0.0 },
  { "Cierra", 0.0013249908 },
  { "Cierrah", 0.0 },
  { "Cierre", 0.0 },
  { "Cierria", 0.0 },
  { "Ciersten", 0.0 },
  { "Cigi", 0.0 },
  { "Ciin", 0.0 },
  { "Cija", 0.0 },
  { "Ciji", 0.0 },
  { "Cilas", 1.0 },
  { "Ciley", 0.0 },
  { "Cilia", 0.0 },
  { "Cilicia", 0.0 },
  { "Cilla", 0.0 },
  { "Cillian", 1.0 },
  { "Cilton", 1.0 },
  { "Cimara", 0.0 },
  { "Cimarron", 0.875 },
  { "Cimberly", 0.0 },
  { "Cimone", 0.0 },
  { "Cimora", 0.0 },
  { "Cin", 1.0 },
  { "Cina", 0.0 },
  { "Cinamon", 0.0 },
  { "Cincere", 0.8013582 },
  { "Cinch", 1.0 },
  { "Cind", 0.0 },
  { "Cinda", 0.0 },
  { "Cindal", 0.0 },
  { "Cinde", 0.0 },
  { "Cindee", 0.0 },
  { "Cindel", 0.0 },
  { "Cindell", 0.0 },
  { "Cinder", 0.0 },
  { "Cinderella", 0.0 },
  { "Cindey", 0.0 },
  { "Cindi", 0.0 },
  { "Cindia", 0.0 },
  { "Cindie", 0.0 },
  { "Cindra", 0.0 },
  { "Cindy", 0.0030026522 },
  { "Cindya", 0.0 },
  { "Cindyann", 0.0 },
  { "Cindye", 0.0 },
  { "Cindylee", 0.0 },
  { "Cindylou", 0.0 },
  { "Cing", 0.0 },
  { "Ciniya", 0.0 },
  { "Ciniyah", 0.0 },
  { "Cinnamin", 0.0 },
  { "Cinnamon", 0.0 },
  { "Cinque", 1.0 },
  { "Cinsere", 0.92537314 },
  { "Cinthia", 0.0010109519 },
  { "Cinthya", 0.0 },
  { "Cintia", 0.0 },
  { "Cintra", 0.0 },
  { "Cintya", 0.0 },
  { "Cinya", 0.0 },
  { "Cinzia", 0.0 },
  { "Ciomara", 0.0 },
  { "Cion", 1.0 },
  { "Ciona", 0.0 },
  { "Cionna", 0.0 },
  { "Cionne", 0.0 },
  { "Cionni", 0.0 },
  { "Ciprian", 1.0 },
  { "Cipriana", 0.0 },
  { "Ciprianna", 0.0 },
  { "Cipriano", 1.0 },
  { "Cira", 0.0 },
  { "Circe", 0.0 },
  { "Cire", 0.5382353 },
  { "Ciree", 1.0 },
  { "Cirena", 0.0 },
  { "Cirenia", 0.0 },
  { "Ciri", 0.0 },
  { "Ciria", 0.0 },
  { "Ciriaco", 1.0 },
  { "Cirila", 0.0 },
  { "Cirildo", 1.0 },
  { "Cirilla", 0.0 },
  { "Cirilo", 1.0 },
  { "Cirino", 1.0 },
  { "Ciro", 1.0 },
  { "Cirra", 0.0 },
  { "Cirrus", 1.0 },
  { "Cirsten", 0.0 },
  { "Cisco", 1.0 },
  { "Cisely", 0.0 },
  { "Cissie", 0.0 },
  { "Cissy", 0.0 },
  { "Cita", 0.0 },
  { "Citali", 0.0 },
  { "Citalli", 0.0 },
  { "Citally", 0.0 },
  { "Cithlali", 0.0 },
  { "Cithlaly", 0.0 },
  { "Citialli", 0.0 },
  { "Citlali", 0.0 },
  { "Citlalic", 0.0 },
  { "Citlalli", 0.0 },
  { "Citlally", 0.0 },
  { "Citlaly", 0.0 },
  { "Citori", 0.0 },
  { "Cittlali", 0.0 },
  { "Cittlaly", 0.0 },
  { "Civona", 0.0 },
  { "Ciya", 0.0 },
  { "Ciyah", 0.0 },
  { "Ciyana", 0.0 },
  { "Ciyanna", 0.0 },
  { "Cj", 0.89469516 },
  { "Cjay", 1.0 },
  { "Clabe", 1.0 },
  { "Clabern", 1.0 },
  { "Clabon", 1.0 },
  { "Claborn", 1.0 },
  { "Cladie", 0.0 },
  { "Clady", 0.0 },
  { "Clae", 1.0 },
  { "Claiborn", 1.0 },
  { "Claiborne", 0.97797716 },
  { "Clair", 0.74856967 },
  { "Claira", 0.0 },
  { "Clairabelle", 0.0 },
  { "Clairah", 0.0 },
  { "Clairann", 0.0 },
  { "Claire", 0.012193291 },
  { "Clairece", 0.0 },
  { "Clairemarie", 0.0 },
  { "Clairene", 0.0 },
  { "Clairese", 0.0 },
  { "Clairessa", 0.0 },
  { "Clairice", 0.0 },
  { "Clairissa", 0.0 },
  { "Clairity", 0.0 },
  { "Clairmont", 1.0 },
  { "Clance", 1.0 },
  { "Clancey", 0.7553192 },
  { "Clancie", 0.0 },
  { "Clancy", 0.7115269 },
  { "Clanton", 1.0 },
  { "Clara", 0.0036740124 },
  { "Clarabel", 0.0 },
  { "Clarabell", 0.0 },
  { "Clarabella", 0.0 },
  { "Clarabelle", 0.0 },
  { "Clarabeth", 0.0 },
  { "Clarah", 0.0 },
  { "Clarajane", 0.0 },
  { "Claraliz", 0.0 },
  { "Claramae", 0.0 },
  { "Clarance", 1.0 },
  { "Claranell", 0.0 },
  { "Clarann", 0.0 },
  { "Claranne", 0.0 },
  { "Clararose", 0.0 },
  { "Clarcie", 0.0 },
  { "Clardie", 1.0 },
  { "Clardy", 1.0 },
  { "Clare", 0.096135065 },
  { "Clareatha", 0.0 },
  { "Clarece", 0.0 },
  { "Claree", 0.0 },
  { "Clareen", 0.0 },
  { "Clareese", 0.0 },
  { "Claren", 0.4047619 },
  { "Clarena", 0.0 },
  { "Clarenc", 1.0 },
  { "Clarence", 0.9938876 },
  { "Clarencia", 0.0 },
  { "Clarenda", 0.0 },
  { "Clarendon", 1.0 },
  { "Clarene", 0.0 },
  { "Claresa", 0.0 },
  { "Clarese", 0.0 },
  { "Claressa", 0.0 },
  { "Claretha", 0.0 },
  { "Claretta", 0.0 },
  { "Clarette", 0.0 },
  { "Claria", 0.0 },
  { "Claribel", 0.0 },
  { "Claribell", 0.0 },
  { "Claribelle", 0.0 },
  { "Clarica", 0.0 },
  { "Clarice", 0.0038123983 },
  { "Clarie", 0.0 },
  { "Clariece", 0.0 },
  { "Clarina", 0.0 },
  { "Clarince", 1.0 },
  { "Clarinda", 0.0 },
  { "Clarine", 0.0 },
  { "Clarion", 0.9186992 },
  { "Claris", 0.07333333 },
  { "Clarisa", 0.0 },
  { "Clarise", 0.0 },
  { "Clarisha", 0.0 },
  { "Clarissa", 0.00055452867 },
  { "Clarisse", 0.0 },
  { "Clarissia", 0.0 },
  { "Claristine", 0.0 },
  { "Clarita", 0.0 },
  { "Claritha", 0.0 },
  { "Claritsa", 0.0 },
  { "Clarity", 0.0 },
  { "Claritza", 0.0 },
  { "Clarivel", 0.0 },
  { "Clarixa", 0.0 },
  { "Clariza", 0.0 },
  { "Clark", 0.99610436 },
  { "Clarke", 0.8614341 },
  { "Clarkie", 0.0 },
  { "Clarkson", 1.0 },
  { "Clarnce", 1.0 },
  { "Clarnece", 1.0 },
  { "Claro", 1.0 },
  { "Claron", 1.0 },
  { "Clarra", 0.0 },
  { "Clarrisa", 0.0 },
  { "Clarrissa", 0.0 },
  { "Clarsie", 0.0 },
  { "Clary", 0.45268542 },
  { "Claryce", 0.0 },
  { "Clarys", 0.0 },
  { "Claryssa", 0.0 },
  { "Clash", 1.0 },
  { "Classie", 0.0 },
  { "Classy", 0.0 },
  { "Clata", 0.0 },
  { "Clate", 1.0 },
  { "Clatie", 0.0 },
  { "Claton", 1.0 },
  { "Claud", 0.9957038 },
  { "Clauda", 0.0 },
  { "Claude", 0.9896317 },
  { "Claudea", 0.0 },
  { "Claudean", 0.0 },
  { "Claudeen", 0.0 },
  { "Claudel", 1.0 },
  { "Claudell", 0.65603644 },
  { "Claudelle", 0.0 },
  { "Claudene", 0.0 },
  { "Claudett", 0.0 },
  { "Claudetta", 0.0 },
  { "Claudette", 0.00058798376 },
  { "Claudia", 0.0059892526 },
  { "Claudiajoy", 0.0 },
  { "Claudie", 0.4432698 },
  { "Claudina", 0.0 },
  { "Claudine", 0.0013249713 },
  { "Claudinette", 0.0 },
  { "Claudio", 0.9947121 },
  { "Claudis", 0.96961325 },
  { "Claudius", 1.0 },
  { "Claudy", 0.9574468 },
  { "Claudya", 0.0 },
  { "Claus", 1.0 },
  { "Clausell", 1.0 },
  { "Clauzell", 1.0 },
  { "Claven", 1.0 },
  { "Clavin", 1.0 },
  { "Clavon", 1.0 },
  { "Clawson", 1.0 },
  { "Claxton", 1.0 },
  { "Clay", 0.9928046 },
  { "Claybon", 1.0 },
  { "Clayborn", 1.0 },
  { "Clayborne", 1.0 },
  { "Claybourne", 1.0 },
  { "Clayburn", 1.0 },
  { "Clayden", 1.0 },
  { "Claydon", 1.0 },
  { "Claymon", 1.0 },
  { "Clayne", 1.0 },
  { "Clayre", 0.0 },
  { "Clayson", 1.0 },
  { "Clayt", 1.0 },
  { "Clayten", 1.0 },
  { "Claytie", 0.0 },
  { "Claytin", 1.0 },
  { "Clayton", 0.995502 },
  { "Clayvon", 1.0 },
  { "Clea", 0.0152207 },
  { "Cleaburn", 1.0 },
  { "Cleada", 0.0 },
  { "Cleah", 0.0 },
  { "Cleal", 1.0 },
  { "Cleamon", 1.0 },
  { "Cleao", 0.33333334 },
  { "Cleara", 0.0 },
  { "Clearance", 1.0 },
  { "Clearence", 1.0 },
  { "Clearnce", 1.0 },
  { "Cleary", 0.5555556 },
  { "Cleason", 1.0 },
  { "Cleaster", 0.1970803 },
  { "Cleaston", 1.0 },
  { "Cleat", 1.0 },
  { "Cleata", 0.0 },
  { "Cleatis", 0.90789473 },
  { "Cleatrice", 0.0 },
  { "Cleatus", 0.92634857 },
  { "Cleave", 1.0 },
  { "Cleaveland", 1.0 },
  { "Cleaven", 1.0 },
  { "Cleavie", 0.0 },
  { "Cleavland", 1.0 },
  { "Cleavon", 1.0 },
  { "Clebert", 1.0 },
  { "Cleburn", 1.0 },
  { "Cleburne", 1.0 },
  { "Cleda", 0.0 },
  { "Cledia", 0.0 },
  { "Cledis", 1.0 },
  { "Cledith", 0.4579646 },
  { "Cledus", 1.0 },
  { "Clee", 1.0 },
  { "Cleetus", 0.0 },
  { "Clegg", 1.0 },
  { "Cleidy", 0.0 },
  { "Cleighton", 1.0 },
  { "Clela", 0.0 },
  { "Cleland", 1.0 },
  { "Clelia", 0.0 },
  { "Clell", 1.0 },
  { "Clella", 0.0 },
  { "Clellan", 1.0 },
  { "Clellie", 0.41666666 },
  { "Clellon", 1.0 },
  { "Clem", 0.9874971 },
  { "Clema", 0.0 },
  { "Cleman", 1.0 },
  { "Clematine", 0.0 },
  { "Clemen", 1.0 },
  { "Clemence", 0.4675615 },
  { "Clemencia", 0.0 },
  { "Clemens", 1.0 },
  { "Clement", 0.9995612 },
  { "Clemente", 1.0 },
  { "Clementeen", 0.0 },
  { "Clementene", 0.0 },
  { "Clementina", 0.0 },
  { "Clementine", 0.0 },
  { "Clements", 1.0 },
  { "Clemet", 1.0 },
  { "Clemetine", 0.0 },
  { "Clemie", 0.023148147 },
  { "Clemintine", 0.0 },
  { "Clemma", 0.0 },
  { "Clemmie", 0.26977518 },
  { "Clemmon", 1.0 },
  { "Clemon", 1.0 },
  { "Clemons", 1.0 },
  { "Clemont", 1.0 },
  { "Clemontine", 0.0 },
  { "Clemson", 1.0 },
  { "Clen", 1.0 },
  { "Clenard", 1.0 },
  { "Clendon", 1.0 },
  { "Clennie", 0.5510204 },
  { "Clennon", 1.0 },
  { "Clenon", 1.0 },
  { "Clent", 1.0 },
  { "Clenton", 1.0 },
  { "Cleo", 0.2725047 },
  { "Cleoda", 0.0 },
  { "Cleodis", 1.0 },
  { "Cleofas", 0.7619048 },
  { "Cleofus", 1.0 },
  { "Cleola", 0.0 },
  { "Cleoma", 0.0 },
  { "Cleon", 0.93971294 },
  { "Cleona", 0.0 },
  { "Cleone", 0.003773585 },
  { "Cleonia", 0.0 },
  { "Cleonte", 1.0 },
  { "Cleopatra", 0.0 },
  { "Cleopatria", 0.0 },
  { "Cleopha", 0.0 },
  { "Cleophas", 0.9765784 },
  { "Cleophes", 1.0 },
  { "Cleophis", 1.0 },
  { "Cleophus", 0.9906954 },
  { "Cleora", 0.0 },
  { "Cleoria", 0.0 },
  { "Cleota", 0.0 },
  { "Cleotha", 0.7195005 },
  { "Cleother", 1.0 },
  { "Cleothis", 1.0 },
  { "Cleotilde", 0.0 },
  { "Cleotis", 1.0 },
  { "Clera", 0.0 },
  { "Clerance", 1.0 },
  { "Clercie", 0.0 },
  { "Clerence", 1.0 },
  { "Clerissa", 0.0 },
  { "Clermont", 1.0 },
  { "Clero", 0.0 },
  { "Clesha", 0.0 },
  { "Clessie", 0.0 },
  { "Clesson", 1.0 },
  { "Clesta", 0.0 },
  { "Cleste", 0.0 },
  { "Clester", 0.83597887 },
  { "Clestine", 0.0 },
  { "Cleston", 1.0 },
  { "Cleta", 0.0 },
  { "Clete", 1.0 },
  { "Cletes", 1.0 },
  { "Cletha", 0.0 },
  { "Cletis", 0.9096591 },
  { "Cleto", 1.0 },
  { "Cletta", 0.0 },
  { "Cletus", 0.9643606 },
  { "Cletys", 0.0 },
  { "Cleva", 0.0 },
  { "Cleve", 0.99491936 },
  { "Cleveland", 0.9960221 },
  { "Cleven", 1.0 },
  { "Clever", 1.0 },
  { "Clevester", 1.0 },
  { "Clevette", 0.0 },
  { "Clevia", 0.0 },
  { "Clevie", 0.19594595 },
  { "Clevland", 1.0 },
  { "Clevon", 1.0 },
  { "Clhoe", 0.0 },
  { "Clida", 0.0 },
  { "Clide", 0.95131576 },
  { "Clidie", 0.0 },
  { "Clidy", 0.0 },
  { "Clif", 1.0 },
  { "Cliff", 1.0 },
  { "Cliffard", 1.0 },
  { "Cliffie", 0.0 },
  { "Clifford", 0.9893151 },
  { "Cliffton", 1.0 },
  { "Cliford", 1.0 },
  { "Clift", 1.0 },
  { "Cliftina", 0.0 },
  { "Clifton", 0.9937533 },
  { "Clim", 1.0 },
  { "Climmie", 0.36061028 },
  { "Climon", 1.0 },
  { "Clinard", 1.0 },
  { "Cline", 1.0 },
  { "Clinesha", 0.0 },
  { "Clinetta", 0.0 },
  { "Clinique", 0.0 },
  { "Clinnie", 0.45454547 },
  { "Clint", 0.998307 },
  { "Clinten", 1.0 },
  { "Clintin", 1.0 },
  { "Clinton", 0.99553096 },
  { "Clintona", 0.0 },
  { "Clintonia", 0.0 },
  { "Clio", 0.03875969 },
  { "Cliona", 0.0 },
  { "Clione", 0.0 },
  { "Clista", 0.0 },
  { "Clister", 0.0 },
  { "Cliston", 1.0 },
  { "Clive", 1.0 },
  { "Clo", 0.0 },
  { "Cloa", 0.0 },
  { "Cloda", 0.0 },
  { "Clodagh", 0.0 },
  { "Clodean", 0.0 },
  { "Clodie", 0.0 },
  { "Cloe", 0.0014392631 },
  { "Cloee", 0.0 },
  { "Cloetta", 0.0 },
  { "Cloey", 0.0 },
  { "Cloi", 0.0 },
  { "Cloice", 1.0 },
  { "Cloid", 1.0 },
  { "Cloie", 0.0 },
  { "Clois", 0.72791165 },
  { "Cloise", 1.0 },
  { "Cloma", 0.0 },
  { "Clomer", 1.0 },
  { "Clora", 0.0 },
  { "Cloral", 1.0 },
  { "Cloree", 0.0 },
  { "Clorence", 1.0 },
  { "Clorene", 0.0 },
  { "Cloretta", 0.0 },
  { "Cloria", 0.0 },
  { "Clorice", 0.0 },
  { "Clorie", 0.0 },
  { "Clorinda", 0.0 },
  { "Clorine", 0.0 },
  { "Cloris", 0.0 },
  { "Clorisa", 0.0 },
  { "Clorise", 0.0 },
  { "Clorissa", 0.0 },
  { "Clota", 0.0 },
  { "Clote", 0.0 },
  { "Cloteal", 0.0 },
  { "Clotee", 0.0 },
  { "Cloteen", 0.0 },
  { "Clotell", 0.0 },
  { "Clotene", 0.0 },
  { "Clothilda", 0.0 },
  { "Clothilde", 0.0 },
  { "Clotie", 0.0 },
  { "Clotiel", 0.0 },
  { "Clotilda", 0.0 },
  { "Clotilde", 0.0 },
  { "Clotile", 0.0 },
  { "Clotine", 0.0 },
  { "Clotis", 1.0 },
  { "Cloud", 1.0 },
  { "Cloude", 1.0 },
  { "Cloudia", 0.0 },
  { "Cloudie", 0.625 },
  { "Clouis", 1.0 },
  { "Clova", 0.0 },
  { "Clover", 0.012825349 },
  { "Clovia", 0.0 },
  { "Clovie", 0.0 },
  { "Clovis", 0.8258333 },
  { "Clowey", 0.0 },
  { "Clowie", 0.0 },
  { "Cloy", 0.96183205 },
  { "Cloyce", 0.87875754 },
  { "Cloyd", 1.0 },
  { "Cloyde", 1.0 },
  { "Cloye", 0.0 },
  { "Cloyed", 1.0 },
  { "Cloys", 1.0 },
  { "Cloyse", 1.0 },
  { "Clu", 1.0 },
  { "Cludia", 0.0 },
  { "Clura", 0.0 },
  { "Cluster", 1.0 },
  { "Clutch", 1.0 },
  { "Clyda", 0.0 },
  { "Clyde", 0.97301936 },
  { "Clydean", 0.0 },
  { "Clydeen", 0.0 },
  { "Clydel", 0.0 },
  { "Clydell", 0.6227273 },
  { "Clydene", 0.0 },
  { "Clydetta", 0.0 },
  { "Clydette", 0.0 },
  { "Clydia", 0.0 },
  { "Clydie", 0.025142858 },
  { "Clydine", 0.0 },
  { "Clyne", 1.0 },
  { "Clynt", 1.0 },
  { "Clynton", 1.0 },
  { "Clysta", 0.0 },
  { "Clyta", 0.0 },
  { "Clytee", 0.0 },
  { "Clytia", 0.0 },
  { "Clytie", 0.0 },
  { "Cmone", 0.0 },
  { "Cmya", 0.0 },
  { "Cne", 0.0 },
  { "Cniya", 0.0 },
  { "Cniyah", 0.0 },
  { "Cnya", 0.0 },
  { "Cnythia", 0.0 },
  { "Coady", 1.0 },
  { "Coal", 1.0 },
  { "Coalson", 1.0 },
  { "Coalton", 1.0 },
  { "Coast", 1.0 },
  { "Cobain", 1.0 },
  { "Cobalt", 1.0 },
  { "Cobb", 1.0 },
  { "Cobbie", 1.0 },
  { "Cobe", 1.0 },
  { "Cobee", 1.0 },
  { "Coben", 1.0 },
  { "Cobert", 1.0 },
  { "Cobey", 1.0 },
  { "Cobi", 0.7518685 },
  { "Cobie", 0.7261663 },
  { "Cobin", 1.0 },
  { "Cobina", 0.0 },
  { "Cobra", 1.0 },
  { "Coburn", 1.0 },
  { "Coby", 0.9585893 },
  { "Cobyn", 1.0 },
  { "Cochise", 1.0 },
  { "Coco", 0.0 },
  { "Cocoa", 0.0 },
  { "Coda", 0.87304074 },
  { "Coddy", 1.0 },
  { "Codee", 0.5804989 },
  { "Codell", 1.0 },
  { "Coden", 1.0 },
  { "Codera", 1.0 },
  { "Codero", 1.0 },
  { "Coderro", 1.0 },
  { "Codey", 0.99121433 },
  { "Codi", 0.3680872 },
  { "Codie", 0.6057853 },
  { "Cody", 0.9827713 },
  { "Codyallen", 1.0 },
  { "Codye", 1.0 },
  { "Codyjames", 1.0 },
  { "Codylee", 1.0 },
  { "Coe", 1.0 },
  { "Coedy", 1.0 },
  { "Coehn", 1.0 },
  { "Coel", 1.0 },
  { "Coella", 0.0 },
  { "Coen", 1.0 },
  { "Coeta", 0.0 },
  { "Coetta", 0.0 },
  { "Coey", 0.5 },
  { "Coffy", 0.0 },
  { "Cogan", 1.0 },
  { "Cohan", 1.0 },
  { "Cohen", 0.9899666 },
  { "Cohl", 1.0 },
  { "Cohlton", 1.0 },
  { "Cohner", 1.0 },
  { "Cohutta", 1.0 },
  { "Cohyn", 1.0 },
  { "Coi", 0.5945946 },
  { "Coila", 0.0 },
  { "Coilin", 1.0 },
  { "Coire", 1.0 },
  { "Coit", 1.0 },
  { "Coke", 1.0 },
  { "Coker", 1.0 },
  { "Cola", 0.2382353 },
  { "Colan", 1.0 },
  { "Colanda", 0.0 },
  { "Colandra", 0.0 },
  { "Colbe", 0.94957983 },
  { "Colbee", 0.17857143 },
  { "Colben", 1.0 },
  { "Colbert", 1.0 },
  { "Colbey", 0.94899815 },
  { "Colbi", 0.122370936 },
  { "Colbie", 0.14899452 },
  { "Colbin", 1.0 },
  { "Colburn", 1.0 },
  { "Colby", 0.93045056 },
  { "Colbyn", 1.0 },
  { "Colden", 1.0 },
  { "Coldin", 1.0 },
  { "Cole", 0.99648464 },
  { "Colean", 0.0 },
  { "Coleby", 1.0 },
  { "Coleden", 1.0 },
  { "Coledon", 1.0 },
  { "Colee", 0.0 },
  { "Coleen", 0.0 },
  { "Coleena", 0.0 },
  { "Coleene", 0.0 },
  { "Coleeta", 0.0 },
  { "Coleigh", 0.0 },
  { "Coleman", 0.9981824 },
  { "Colemon", 1.0 },
  { "Colen", 1.0 },
  { "Colena", 0.0 },
  { "Colene", 0.0 },
  { "Coleon", 1.0 },
  { "Coleone", 1.0 },
  { "Coleridge", 1.0 },
  { "Colesha", 0.0 },
  { "Coleson", 1.0 },
  { "Coleston", 1.0 },
  { "Colesyn", 1.0 },
  { "Coleta", 0.0 },
  { "Coleten", 1.0 },
  { "Coletha", 0.0 },
  { "Coletin", 1.0 },
  { "Coleton", 1.0 },
  { "Coletta", 0.0 },
  { "Colette", 0.0 },
  { "Coletyn", 1.0 },
  { "Coley", 0.88526076 },
  { "Colgan", 1.0 },
  { "Colicia", 0.0 },
  { "Colie", 0.84766215 },
  { "Colin", 0.9964621 },
  { "Colina", 0.0 },
  { "Colinda", 0.0 },
  { "Coline", 0.0 },
  { "Colisa", 0.0 },
  { "Colisha", 0.0 },
  { "Colista", 0.0 },
  { "Colita", 0.0 },
  { "Collan", 1.0 },
  { "Colleen", 0.0020321072 },
  { "Colleena", 0.0 },
  { "Colleene", 0.0 },
  { "Collen", 0.5419643 },
  { "Collena", 0.0 },
  { "Collene", 0.0 },
  { "Collenn", 0.0 },
  { "Collete", 0.0 },
  { "Collett", 0.0 },
  { "Colletta", 0.0 },
  { "Collette", 0.0 },
  { "Colley", 1.0 },
  { "Collie", 0.7705457 },
  { "Collier", 0.9378173 },
  { "Collin", 0.99419075 },
  { "Colline", 0.0 },
  { "Collins", 0.61246663 },
  { "Collis", 0.9923606 },
  { "Collyn", 0.79704016 },
  { "Collynn", 0.5 },
  { "Collyns", 0.0 },
  { "Colm", 1.0 },
  { "Colman", 1.0 },
  { "Colmon", 1.0 },
  { "Colon", 0.9917231 },
  { "Colonel", 1.0 },
  { "Colorado", 1.0 },
  { "Colquitt", 1.0 },
  { "Colsen", 1.0 },
  { "Colson", 1.0 },
  { "Colsten", 1.0 },
  { "Colston", 1.0 },
  { "Colsyn", 1.0 },
  { "Colt", 0.99923885 },
  { "Coltan", 1.0 },
  { "Colten", 1.0 },
  { "Colter", 1.0 },
  { "Coltin", 1.0 },
  { "Coltn", 1.0 },
  { "Colton", 0.99845564 },
  { "Coltrane", 1.0 },
  { "Coltyn", 1.0 },
  { "Colum", 1.0 },
  { "Columba", 0.0 },
  { "Columbia", 0.007751938 },
  { "Columbine", 0.0 },
  { "Columbo", 1.0 },
  { "Columbus", 1.0 },
  { "Colvin", 1.0 },
  { "Colwyn", 1.0 },
  { "Colyer", 1.0 },
  { "Colyn", 0.98542273 },
  { "Colynn", 0.0 },
  { "Coma", 0.22727273 },
  { "Comaneci", 0.0 },
  { "Comari", 1.0 },
  { "Comeka", 0.0 },
  { "Comekia", 0.0 },
  { "Comelia", 0.0 },
  { "Comer", 1.0 },
  { "Comesha", 0.0 },
  { "Comfort", 0.0 },
  { "Comilla", 0.0 },
  { "Comisha", 0.0 },
  { "Commer", 1.0 },
  { "Commie", 0.6964286 },
  { "Commodore", 1.0 },
  { "Common", 1.0 },
  { "Compton", 1.0 },
  { "Con", 1.0 },
  { "Cona", 0.0 },
  { "Conagher", 1.0 },
  { "Conal", 1.0 },
  { "Conall", 1.0 },
  { "Conan", 1.0 },
  { "Conant", 1.0 },
  { "Conar", 1.0 },
  { "Conard", 1.0 },
  { "Concepcion", 0.1577061 },
  { "Concepsion", 0.0 },
  { "Conception", 0.0 },
  { "Concetta", 0.00035468538 },
  { "Concettina", 0.0 },
  { "Concetto", 1.0 },
  { "Concha", 0.0 },
  { "Conchata", 0.0 },
  { "Concheta", 0.0 },
  { "Conchetta", 0.0 },
  { "Conchita", 0.0 },
  { "Conda", 0.06818182 },
  { "Condace", 0.0 },
  { "Conde", 1.0 },
  { "Condie", 1.0 },
  { "Condol", 0.0 },
  { "Condola", 0.0 },
  { "Condoleezza", 0.0 },
  { "Condon", 1.0 },
  { "Condra", 0.0 },
  { "Condredge", 1.0 },
  { "Condy", 1.0 },
  { "Conelia", 0.0 },
  { "Conell", 1.0 },
  { "Coner", 1.0 },
  { "Conesha", 0.0 },
  { "Coney", 1.0 },
  { "Conferina", 0.0 },
  { "Confesor", 1.0 },
  { "Cong", 1.0 },
  { "Congetta", 0.0 },
  { "Congress", 1.0 },
  { "Coni", 0.0 },
  { "Conie", 0.0 },
  { "Conisha", 0.0 },
  { "Conita", 0.0 },
  { "Conjetta", 0.0 },
  { "Conlan", 1.0 },
  { "Conlee", 0.6813187 },
  { "Conleigh", 0.0 },
  { "Conley", 0.93057024 },
  { "Conlin", 1.0 },
  { "Conlon", 1.0 },
  { "Conn", 1.0 },
  { "Conna", 0.0 },
  { "Connal", 1.0 },
  { "Connall", 1.0 },
  { "Connan", 1.0 },
  { "Connar", 0.9501608 },
  { "Connard", 1.0 },
  { "Conne", 0.0 },
  { "Connee", 0.0 },
  { "Connel", 1.0 },
  { "Connell", 0.99665326 },
  { "Connelly", 0.41588786 },
  { "Conner", 0.98477405 },
  { "Connery", 1.0 },
  { "Conney", 1.0 },
  { "Conni", 0.0 },
  { "Connice", 0.0 },
  { "Connie", 0.02545549 },
  { "Connis", 1.0 },
  { "Connley", 1.0 },
  { "Connolly", 0.7826087 },
  { "Connor", 0.99231774 },
  { "Connstance", 0.0 },
  { "Conny", 0.27670753 },
  { "Connye", 0.0 },
  { "Cono", 1.0 },
  { "Conola", 0.0 },
  { "Conor", 0.9967946 },
  { "Conquista", 0.0 },
  { "Conrad", 0.9995323 },
  { "Conrada", 0.0 },
  { "Conrado", 1.0 },
  { "Conred", 1.0 },
  { "Conroy", 1.0 },
  { "Consandra", 0.0 },
  { "Consepcion", 0.02189781 },
  { "Consetta", 0.0 },
  { "Consiglia", 0.0 },
  { "Constanc", 0.0 },
  { "Constance", 0.0030089552 },
  { "Constancia", 0.0 },
  { "Constancio", 1.0 },
  { "Constande", 0.0 },
  { "Constandina", 0.0 },
  { "Constandinos", 1.0 },
  { "Constant", 0.93157893 },
  { "Constantin", 1.0 },
  { "Constantina", 0.0 },
  { "Constantine", 0.9946918 },
  { "Constantino", 1.0 },
  { "Constantinos", 1.0 },
  { "Constanza", 0.0 },
  { "Constence", 0.0 },
  { "Constina", 0.0 },
  { "Consuela", 0.0 },
  { "Consuella", 0.0 },
  { "Consuello", 0.0 },
  { "Consuelo", 0.0053317538 },
  { "Conswala", 0.0 },
  { "Conswella", 0.0 },
  { "Conswello", 0.0 },
  { "Contance", 0.0 },
  { "Contenia", 0.0 },
  { "Content", 0.0 },
  { "Contesa", 0.0 },
  { "Contessa", 0.0 },
  { "Contessia", 0.0 },
  { "Contina", 0.0 },
  { "Continia", 0.0 },
  { "Contrell", 1.0 },
  { "Contrella", 0.0 },
  { "Contrena", 0.0 },
  { "Contrina", 0.0 },
  { "Converse", 1.0 },
  { "Conway", 1.0 },
  { "Conwell", 1.0 },
  { "Conya", 0.0 },
  { "Conye", 1.0 },
  { "Conzuelo", 0.0 },
  { "Conzy", 0.0 },
  { "Cookie", 0.0 },
  { "Cooledge", 1.0 },
  { "Cooley", 1.0 },
  { "Coolidge", 1.0 },
  { "Coopar", 1.0 },
  { "Cooper", 0.9796478 },
  { "Cope", 1.0 },
  { "Copelan", 1.0 },
  { "Copeland", 0.84502447 },
  { "Copelin", 1.0 },
  { "Copelyn", 0.0 },
  { "Copelynn", 0.0 },
  { "Copen", 1.0 },
  { "Copper", 0.7368421 },
  { "Cor", 1.0 },
  { "Cora", 0.0030041218 },
  { "Corabel", 0.0 },
  { "Corabell", 0.0 },
  { "Corabella", 0.0 },
  { "Corabelle", 0.0 },
  { "Corah", 0.0 },
  { "Coraima", 0.0 },
  { "Coraine", 0.0 },
  { "Coral", 0.01915555 },
  { "Coralai", 0.0 },
  { "Coralea", 0.0 },
  { "Coralee", 0.0 },
  { "Coraleen", 0.0 },
  { "Coralei", 0.0 },
  { "Coraleigh", 0.0 },
  { "Coralene", 0.0 },
  { "Coralia", 0.0 },
  { "Coralie", 0.0 },
  { "Coralin", 0.0 },
  { "Coralina", 0.0 },
  { "Coraline", 0.0 },
  { "Coralis", 0.0 },
  { "Coralito", 0.0 },
  { "Coraliz", 0.0 },
  { "Coralline", 0.0 },
  { "Coraly", 0.0 },
  { "Coralyn", 0.0 },
  { "Coralyne", 0.0 },
  { "Coralynn", 0.0 },
  { "Coralynne", 0.0 },
  { "Coralys", 0.0 },
  { "Coramae", 0.0 },
  { "Coran", 1.0 },
  { "Corando", 1.0 },
  { "Coray", 1.0 },
  { "Corayma", 0.0 },
  { "Corazon", 0.0 },
  { "Corban", 0.99802566 },
  { "Corben", 1.0 },
  { "Corbet", 1.0 },
  { "Corbett", 1.0 },
  { "Corbi", 0.0 },
  { "Corbie", 0.29411766 },
  { "Corbin", 0.9840507 },
  { "Corbit", 1.0 },
  { "Corbitt", 1.0 },
  { "Corbon", 1.0 },
  { "Corby", 0.81546897 },
  { "Corbyn", 0.8738375 },
  { "Corbynn", 0.0 },
  { "Cord", 1.0 },
  { "Corda", 0.020725388 },
  { "Cordae", 0.9898167 },
  { "Cordai", 1.0 },
  { "Cordairo", 1.0 },
  { "Cordale", 1.0 },
  { "Cordalro", 1.0 },
  { "Cordara", 1.0 },
  { "Cordarell", 1.0 },
  { "Cordarian", 1.0 },
  { "Cordario", 1.0 },
  { "Cordarious", 1.0 },
  { "Cordaris", 1.0 },
  { "Cordarius", 1.0 },
  { "Cordaro", 1.0 },
  { "Cordarrel", 1.0 },
  { "Cordarrell", 1.0 },
  { "Cordarrius", 1.0 },
  { "Cordarro", 1.0 },
  { "Cordarrow", 1.0 },
  { "Cordarryl", 1.0 },
  { "Cordaryl", 1.0 },
  { "Cordasia", 0.0 },
  { "Corday", 1.0 },
  { "Corddaryl", 1.0 },
  { "Corde", 0.9913644 },
  { "Cordea", 1.0 },
  { "Cordeja", 0.0 },
  { "Cordel", 1.0 },
  { "Cordelia", 0.0 },
  { "Cordell", 0.9854888 },
  { "Cordella", 0.0 },
  { "Cordelle", 0.9468085 },
  { "Cordellia", 0.0 },
  { "Cordelra", 1.0 },
  { "Cordelro", 1.0 },
  { "Corden", 1.0 },
  { "Cordera", 1.0 },
  { "Corderal", 1.0 },
  { "Corderall", 1.0 },
  { "Corderia", 1.0 },
  { "Corderial", 1.0 },
  { "Corderick", 1.0 },
  { "Corderio", 1.0 },
  { "Corderious", 1.0 },
  { "Corderius", 1.0 },
  { "Cordero", 0.99469966 },
  { "Corderra", 1.0 },
  { "Corderrius", 1.0 },
  { "Corderro", 1.0 },
  { "Cordes", 1.0 },
  { "Cordeshia", 0.0 },
  { "Cordey", 1.0 },
  { "Cordez", 1.0 },
  { "Cordia", 0.0 },
  { "Cordie", 0.07485432 },
  { "Cordilia", 0.0 },
  { "Cordin", 1.0 },
  { "Cordis", 1.0 },
  { "Cordney", 0.9405941 },
  { "Cordon", 1.0 },
  { "Cordula", 0.0 },
  { "Cordy", 0.43835616 },
  { "Corea", 0.0 },
  { "Corean", 0.0 },
  { "Coreatha", 0.0 },
  { "Coree", 0.29749104 },
  { "Coreen", 0.0 },
  { "Coreena", 0.0 },
  { "Coreene", 0.0 },
  { "Corell", 1.0 },
  { "Corella", 0.0 },
  { "Corelle", 0.0 },
  { "Coren", 0.5674603 },
  { "Corena", 0.0 },
  { "Corene", 0.0 },
  { "Corenia", 0.0 },
  { "Corenna", 0.0 },
  { "Corenne", 0.0 },
  { "Corenthia", 0.0 },
  { "Corentin", 1.0 },
  { "Coreon", 1.0 },
  { "Coreta", 0.0 },
  { "Coretha", 0.0 },
  { "Coretta", 0.0 },
  { "Corette", 0.0 },
  { "Corey", 0.9532697 },
  { "Coreyana", 0.0 },
  { "Coreyanna", 0.0 },
  { "Coreyion", 1.0 },
  { "Coreyon", 1.0 },
  { "Coreyona", 0.0 },
  { "Coreyonna", 0.0 },
  { "Corgan", 1.0 },
  { "Cori", 0.09356963 },
  { "Coriah", 0.0 },
  { "Corian", 0.9306931 },
  { "Coriana", 0.0 },
  { "Coriann", 0.0 },
  { "Corianna", 0.0 },
  { "Corianne", 0.0 },
  { "Corie", 0.22126816 },
  { "Corielle", 0.0 },
  { "Coriene", 0.0 },
  { "Corienne", 0.0 },
  { "Corieon", 1.0 },
  { "Corii", 0.0 },
  { "Corin", 0.33985624 },
  { "Corina", 0.0 },
  { "Corinda", 0.0 },
  { "Corine", 0.0011702348 },
  { "Corinn", 0.0 },
  { "Corinna", 0.0 },
  { "Corinne", 0.00031621553 },
  { "Corinth", 0.0 },
  { "Corintha", 0.0 },
  { "Corinthia", 0.0 },
  { "Corinthian", 0.7784027 },
  { "Corinthians", 1.0 },
  { "Corion", 1.0 },
  { "Corionna", 0.0 },
  { "Corisa", 0.0 },
  { "Corisha", 0.0 },
  { "Corissa", 0.0 },
  { "Corita", 0.0 },
  { "Coriyah", 0.0 },
  { "Corkey", 1.0 },
  { "Corky", 0.9229607 },
  { "Corla", 0.0 },
  { "Corleen", 0.0 },
  { "Corlene", 0.0 },
  { "Corleone", 1.0 },
  { "Corless", 0.0 },
  { "Corletta", 0.0 },
  { "Corlette", 0.0 },
  { "Corley", 0.46125463 },
  { "Corlin", 1.0 },
  { "Corlis", 0.062135924 },
  { "Corliss", 0.10748982 },
  { "Corlyn", 0.0 },
  { "Corma", 0.0 },
  { "Cormac", 1.0 },
  { "Cormack", 1.0 },
  { "Corman", 1.0 },
  { "Cormari", 1.0 },
  { "Cormarion", 1.0 },
  { "Cormick", 1.0 },
  { "Corneal", 0.8148148 },
  { "Cornealius", 1.0 },
  { "Corneall", 1.0 },
  { "Cornecia", 0.0 },
  { "Corneil", 1.0 },
  { "Corneilius", 1.0 },
  { "Corneilous", 1.0 },
  { "Corneilus", 1.0 },
  { "Corneisha", 0.0 },
  { "Cornel", 1.0 },
  { "Cornelia", 0.0011967228 },
  { "Cornelieus", 1.0 },
  { "Cornelio", 1.0 },
  { "Cornelious", 0.95621854 },
  { "Cornelis", 1.0 },
  { "Cornelius", 0.9822676 },
  { "Cornell", 0.96948975 },
  { "Cornella", 0.0 },
  { "Cornelle", 1.0 },
  { "Cornellia", 0.0 },
  { "Cornellius", 1.0 },
  { "Corneluis", 1.0 },
  { "Cornesha", 0.0 },
  { "Corneshia", 0.0 },
  { "Cornesia", 0.0 },
  { "Cornetta", 0.0 },
  { "Corney", 1.0 },
  { "Cornia", 0.0 },
  { "Cornie", 0.49411765 },
  { "Cornisha", 0.0 },
  { "Corniya", 0.0 },
  { "Corniyah", 0.0 },
  { "Corny", 1.0 },
  { "Corolyn", 0.0 },
  { "Coron", 1.0 },
  { "Corona", 0.0 },
  { "Coronda", 0.0 },
  { "Corra", 0.0 },
  { "Corrado", 1.0 },
  { "Corrah", 0.0 },
  { "Corraine", 0.0 },
  { "Corran", 1.0 },
  { "Correan", 0.0 },
  { "Corree", 0.0 },
  { "Correen", 0.0 },
  { "Correena", 0.0 },
  { "Correll", 1.0 },
  { "Corren", 0.16666667 },
  { "Correna", 0.0 },
  { "Correne", 0.0 },
  { "Correon", 1.0 },
  { "Corretta", 0.0 },
  { "Correy", 0.959256 },
  { "Corri", 0.038135592 },
  { "Corriana", 0.0 },
  { "Corrianna", 0.0 },
  { "Corrice", 1.0 },
  { "Corrida", 0.0 },
  { "Corrie", 0.13279848 },
  { "Corrigan", 0.83035713 },
  { "Corrin", 0.057599224 },
  { "Corrina", 0.0 },
  { "Corrinda", 0.0 },
  { "Corrine", 0.0 },
  { "Corrinn", 0.0 },
  { "Corrinna", 0.0 },
  { "Corrinne", 0.0 },
  { "Corrion", 1.0 },
  { "Corris", 0.62857145 },
  { "Corrisa", 0.0 },
  { "Corrissa", 0.0 },
  { "Corron", 1.0 },
  { "Corry", 0.87115306 },
  { "Corryn", 0.0 },
  { "Corryne", 0.0 },
  { "Corsandra", 0.0 },
  { "Corsha", 0.0 },
  { "Corsica", 0.0 },
  { "Corson", 1.0 },
  { "Cort", 1.0 },
  { "Cortana", 0.0 },
  { "Cortasia", 0.0 },
  { "Cortavia", 0.0 },
  { "Cortavion", 1.0 },
  { "Cortavious", 1.0 },
  { "Cortavius", 1.0 },
  { "Cortaz", 1.0 },
  { "Cortazia", 0.0 },
  { "Cortell", 1.0 },
  { "Corteney", 0.0 },
  { "Cortes", 1.0 },
  { "Cortez", 0.99098736 },
  { "Corteze", 1.0 },
  { "Cortina", 0.0 },
  { "Cortisha", 0.0 },
  { "Cortlan", 1.0 },
  { "Cortland", 0.983454 },
  { "Cortlandt", 1.0 },
  { "Cortlen", 1.0 },
  { "Cortlin", 1.0 },
  { "Cortlyn", 0.04373178 },
  { "Cortlynn", 0.0 },
  { "Cortne", 0.0 },
  { "Cortnee", 0.0 },
  { "Cortnei", 0.0 },
  { "Cortney", 0.15496695 },
  { "Cortni", 0.0 },
  { "Cortnie", 0.0 },
  { "Cortny", 0.0 },
  { "Cortrell", 1.0 },
  { "Corutney", 0.0 },
  { "Corvell", 1.0 },
  { "Corvetta", 0.0 },
  { "Corvette", 0.0 },
  { "Corvin", 1.0 },
  { "Corvina", 0.0 },
  { "Corvon", 1.0 },
  { "Corvus", 1.0 },
  { "Corvyn", 1.0 },
  { "Corwin", 1.0 },
  { "Corwyn", 1.0 },
  { "Corwynn", 1.0 },
  { "Cory", 0.95081794 },
  { "Coryana", 0.0 },
  { "Coryann", 0.0 },
  { "Corydon", 1.0 },
  { "Corye", 1.0 },
  { "Coryell", 1.0 },
  { "Coryion", 1.0 },
  { "Coryn", 0.0 },
  { "Coryna", 0.0 },
  { "Coryne", 0.0 },
  { "Corynn", 0.0 },
  { "Corynne", 0.0 },
  { "Coryon", 1.0 },
  { "Cosandra", 0.0 },
  { "Cosby", 0.9021277 },
  { "Cosetta", 0.0 },
  { "Cosette", 0.0 },
  { "Cosha", 0.0 },
  { "Cosie", 0.0 },
  { "Cosima", 0.0 },
  { "Cosimo", 1.0 },
  { "Cosma", 0.0 },
  { "Cosmas", 1.0 },
  { "Cosme", 1.0 },
  { "Cosmo", 1.0 },
  { "Cosmos", 1.0 },
  { "Cossandra", 0.0 },
  { "Cossette", 0.0 },
  { "Cossie", 1.0 },
  { "Costa", 1.0 },
  { "Costantino", 1.0 },
  { "Costanzo", 1.0 },
  { "Costas", 1.0 },
  { "Costella", 0.0 },
  { "Costello", 0.91803277 },
  { "Coston", 1.0 },
  { "Cote", 1.0 },
  { "Cotenia", 0.0 },
  { "Cotey", 1.0 },
  { "Cotha", 0.0 },
  { "Coti", 0.18333334 },
  { "Cotie", 0.4857143 },
  { "Cotina", 0.0 },
  { "Cotis", 1.0 },
  { "Cotrina", 0.0 },
  { "Cott", 1.0 },
  { "Cotter", 1.0 },
  { "Cottie", 0.0 },
  { "Cotton", 1.0 },
  { "Cottrell", 1.0 },
  { "Coty", 0.875969 },
  { "Coua", 0.0 },
  { "Cougar", 1.0 },
  { "Coula", 0.0 },
  { "Coulette", 0.0 },
  { "Coulson", 1.0 },
  { "Coulten", 1.0 },
  { "Coulter", 1.0 },
  { "Coulton", 1.0 },
  { "Coumba", 0.0 },
  { "Council", 1.0 },
  { "Count", 1.0 },
  { "Countess", 0.0 },
  { "Countney", 0.0 },
  { "Couper", 1.0 },
  { "Courage", 0.8926554 },
  { "Courey", 1.0 },
  { "Couri", 0.0 },
  { "Courney", 0.0 },
  { "Courntey", 0.0 },
  { "Court", 1.0 },
  { "Courtany", 0.0 },
  { "Courtenay", 0.17385258 },
  { "Courteney", 0.0044286977 },
  { "Courteny", 0.0 },
  { "Courtez", 1.0 },
  { "Courtlan", 1.0 },
  { "Courtland", 0.944474 },
  { "Courtlandt", 1.0 },
  { "Courtlin", 0.796875 },
  { "Courtlyn", 0.013717421 },
  { "Courtlynn", 0.0 },
  { "Courtnay", 0.02096436 },
  { "Courtne", 0.0 },
  { "Courtnee", 0.0049474337 },
  { "Courtnei", 0.0 },
  { "Courtney", 0.08061614 },
  { "Courtneyann", 0.0 },
  { "Courtni", 0.0 },
  { "Courtnie", 0.0 },
  { "Courtny", 0.00990099 },
  { "Courtnye", 0.0 },
  { "Courvoisier", 1.0 },
  { "Coury", 1.0 },
  { "Coutney", 0.0 },
  { "Couture", 0.0 },
  { "Couy", 1.0 },
  { "Cova", 0.046296295 },
  { "Cove", 0.93639576 },
  { "Coven", 1.0 },
  { "Covert", 1.0 },
  { "Covey", 0.9632353 },
  { "Covie", 0.0 },
  { "Covin", 1.0 },
  { "Covington", 1.0 },
  { "Covy", 1.0 },
  { "Cowan", 1.0 },
  { "Cowana", 0.0 },
  { "Cowanda", 0.0 },
  { "Cowen", 1.0 },
  { "Coy", 0.9493952 },
  { "Coya", 0.0 },
  { "Coyal", 1.0 },
  { "Coye", 0.90625 },
  { "Coyer", 1.0 },
  { "Coyla", 0.0 },
  { "Coyle", 1.0 },
  { "Coyote", 1.0 },
  { "Coyt", 1.0 },
  { "Coyte", 1.0 },
  { "Cozell", 1.0 },
  { "Cozella", 0.0 },
  { "Cozetta", 0.0 },
  { "Cozette", 0.0 },
  { "Cozie", 0.0 },
  { "Cozmo", 1.0 },
  { "Cozy", 0.17213115 },
  { "Crae", 1.0 },
  { "Crafton", 1.0 },
  { "Crag", 1.0 },
  { "Cragi", 1.0 },
  { "Craig", 0.9966197 },
  { "Craige", 1.0 },
  { "Craigory", 1.0 },
  { "Cramer", 1.0 },
  { "Cramon", 1.0 },
  { "Crandall", 1.0 },
  { "Crandon", 1.0 },
  { "Crane", 1.0 },
  { "Cranford", 1.0 },
  { "Cranston", 1.0 },
  { "Crash", 1.0 },
  { "Crate", 1.0 },
  { "Craven", 1.0 },
  { "Crawford", 0.99546105 },
  { "Crawley", 1.0 },
  { "Cray", 1.0 },
  { "Crayson", 1.0 },
  { "Crayton", 1.0 },
  { "Crea", 0.0 },
  { "Cread", 1.0 },
  { "Creasie", 0.0 },
  { "Crecencio", 1.0 },
  { "Creda", 0.0 },
  { "Credell", 1.0 },
  { "Credence", 0.6666667 },
  { "Cree", 0.35128418 },
  { "Creed", 1.0 },
  { "Creedan", 1.0 },
  { "Creedance", 0.41666666 },
  { "Creede", 1.0 },
  { "Creeden", 1.0 },
  { "Creedence", 0.7 },
  { "Creedon", 1.0 },
  { "Creedyn", 1.0 },
  { "Creek", 1.0 },
  { "Creel", 1.0 },
  { "Creg", 1.0 },
  { "Cregg", 1.0 },
  { "Creig", 1.0 },
  { "Creigh", 1.0 },
  { "Creighton", 0.9968088 },
  { "Creo", 1.0 },
  { "Creola", 0.0 },
  { "Creolia", 0.0 },
  { "Creon", 1.0 },
  { "Creosha", 0.0 },
  { "Crescencia", 0.0 },
  { "Crescencio", 1.0 },
  { "Crescent", 0.0 },
  { "Crescentia", 0.0 },
  { "Crescenzo", 1.0 },
  { "Cresencia", 0.0 },
  { "Cresenciano", 1.0 },
  { "Cresencio", 1.0 },
  { "Cresha", 0.0 },
  { "Creshawn", 1.0 },
  { "Cresie", 0.0 },
  { "Crespin", 1.0 },
  { "Cress", 1.0 },
  { "Cressa", 0.0 },
  { "Cressida", 0.0 },
  { "Cressie", 0.0 },
  { "Cresta", 0.0 },
  { "Crestina", 0.0 },
  { "Creston", 1.0 },
  { "Creta", 0.0 },
  { "Crete", 0.0 },
  { "Cretia", 0.0 },
  { "Crettie", 0.0 },
  { "Crew", 0.9981825 },
  { "Crewe", 1.0 },
  { "Crews", 1.0 },
  { "Creyton", 1.0 },
  { "Crhistopher", 1.0 },
  { "Criag", 1.0 },
  { "Crichton", 1.0 },
  { "Cricket", 0.0 },
  { "Crickett", 0.0 },
  { "Crimson", 0.24873525 },
  { "Crimsyn", 0.0 },
  { "Cris", 0.725599 },
  { "Crisangel", 1.0 },
  { "Crisann", 0.0 },
  { "Crisanna", 0.0 },
  { "Crisanta", 0.0 },
  { "Crisanto", 1.0 },
  { "Crisbel", 0.0 },
  { "Criscia", 0.0 },
  { "Crisel", 0.0 },
  { "Criselda", 0.0 },
  { "Criselle", 0.0 },
  { "Crisette", 0.0 },
  { "Crisha", 0.0 },
  { "Crishaun", 1.0 },
  { "Crishawn", 1.0 },
  { "Crishon", 1.0 },
  { "Crisinda", 0.0 },
  { "Crislyn", 0.0 },
  { "Crislynn", 0.0 },
  { "Crisma", 0.0 },
  { "Crisoforo", 1.0 },
  { "Crisol", 0.0 },
  { "Crispin", 0.9970291 },
  { "Crispina", 0.0 },
  { "Crispus", 1.0 },
  { "Criss", 0.82985073 },
  { "Crissa", 0.0 },
  { "Crissandra", 0.0 },
  { "Crissangel", 1.0 },
  { "Crissey", 0.0 },
  { "Crissi", 0.0 },
  { "Crissie", 0.0 },
  { "Crisslyn", 0.0 },
  { "Crisstopher", 1.0 },
  { "Crissy", 0.0 },
  { "Crist", 1.0 },
  { "Crista", 0.0 },
  { "Cristabel", 0.0 },
  { "Cristabella", 0.0 },
  { "Cristain", 1.0 },
  { "Cristal", 0.0035723564 },
  { "Cristalina", 0.0 },
  { "Cristalle", 0.0 },
  { "Cristaly", 0.0 },
  { "Cristalyn", 0.0 },
  { "Cristan", 0.44077134 },
  { "Cristee", 0.0 },
  { "Cristeen", 0.0 },
  { "Cristel", 0.0 },
  { "Cristela", 0.0 },
  { "Cristell", 0.0 },
  { "Cristella", 0.0 },
  { "Cristelle", 0.0 },
  { "Cristen", 0.045487363 },
  { "Cristena", 0.0 },
  { "Cristene", 0.0 },
  { "Cristhian", 1.0 },
  { "Cristhofer", 1.0 },
  { "Cristi", 0.0 },
  { "Cristia", 0.0 },
  { "Cristian", 0.98189116 },
  { "Cristiana", 0.0 },
  { "Cristianna", 0.0 },
  { "Cristiano", 1.0 },
  { "Cristie", 0.0 },
  { "Cristien", 1.0 },
  { "Cristin", 0.027422303 },
  { "Cristina", 0.005280141 },
  { "Cristine", 0.0 },
  { "Cristinia", 0.0 },
  { "Cristino", 1.0 },
  { "Cristion", 1.0 },
  { "Cristle", 0.0 },
  { "Cristo", 1.0 },
  { "Cristobal", 0.99840903 },
  { "Cristofer", 1.0 },
  { "Cristoffer", 1.0 },
  { "Cristofher", 1.0 },
  { "Cristol", 0.0 },
  { "Criston", 0.8362069 },
  { "Cristopher", 1.0 },
  { "Cristos", 1.0 },
  { "Cristoval", 1.0 },
  { "Cristy", 0.006908463 },
  { "Cristyan", 1.0 },
  { "Cristyl", 0.0 },
  { "Cristyle", 0.0 },
  { "Cristyn", 0.0 },
  { "Cristyna", 0.0 },
  { "Crit", 1.0 },
  { "Crixus", 1.0 },
  { "Criztian", 1.0 },
  { "Crmen", 0.0 },
  { "Crockett", 1.0 },
  { "Croix", 1.0 },
  { "Crol", 0.0 },
  { "Cromer", 1.0 },
  { "Cromwell", 1.0 },
  { "Crosbie", 0.0 },
  { "Crosby", 0.9168183 },
  { "Crosley", 0.6851852 },
  { "Cross", 1.0 },
  { "Crossley", 1.0 },
  { "Crosslyn", 0.0 },
  { "Crowell", 1.0 },
  { "Crowley", 1.0 },
  { "Crown", 1.0 },
  { "Croy", 1.0 },
  { "Crstal", 0.0 },
  { "Cru", 1.0 },
  { "Crucita", 0.0 },
  { "Crue", 1.0 },
  { "Cruise", 1.0 },
  { "Cruiz", 1.0 },
  { "Cruize", 1.0 },
  { "Crus", 1.0 },
  { "Cruse", 1.0 },
  { "Crusita", 0.0 },
  { "Crusoe", 1.0 },
  { "Crustal", 0.0 },
  { "Cruz", 0.840729 },
  { "Cruze", 1.0 },
  { "Cruzita", 0.0 },
  { "Cruzito", 1.0 },
  { "Crys", 0.0 },
  { "Crysal", 0.0 },
  { "Crysania", 0.0 },
  { "Crysany", 0.0 },
  { "Crysta", 0.0 },
  { "Crystabel", 0.0 },
  { "Crystal", 0.0035843595 },
  { "Crystalann", 0.0 },
  { "Crystale", 0.0 },
  { "Crystalee", 0.0 },
  { "Crystalgayle", 0.0 },
  { "Crystalin", 0.0 },
  { "Crystalina", 0.0 },
  { "Crystaline", 0.0 },
  { "Crystall", 0.0 },
  { "Crystalle", 0.0 },
  { "Crystallee", 0.0 },
  { "Crystallynn", 0.0 },
  { "Crystalmarie", 0.0 },
  { "Crystalrose", 0.0 },
  { "Crystalyn", 0.0 },
  { "Crystalynn", 0.0 },
  { "Crystan", 0.0 },
  { "Crystel", 0.0 },
  { "Crystell", 0.0 },
  { "Crystella", 0.0 },
  { "Crystelle", 0.0 },
  { "Crysten", 0.0 },
  { "Crysti", 0.0 },
  { "Crystian", 1.0 },
  { "Crystiana", 0.0 },
  { "Crystianna", 0.0 },
  { "Crystie", 0.0 },
  { "Crystil", 0.0 },
  { "Crystin", 0.0 },
  { "Crystina", 0.0 },
  { "Crystine", 0.0 },
  { "Crystl", 0.0 },
  { "Crystle", 0.0 },
  { "Crystofer", 1.0 },
  { "Crystol", 0.0 },
  { "Crystopher", 1.0 },
  { "Crystral", 0.0 },
  { "Crystyl", 0.0 },
  { "Crystyle", 0.0 },
  { "Crytal", 0.0 },
  { "Csilla", 0.0 },
  { "Cuahtemoc", 1.0 },
  { "Cuahutemoc", 1.0 },
  { "Cuauhtemoc", 1.0 },
  { "Cuauhtli", 1.0 },
  { "Cub", 1.0 },
  { "Cuba", 0.07679739 },
  { "Cubby", 1.0 },
  { "Cubert", 1.0 },
  { "Cubia", 0.0 },
  { "Cubie", 0.2037037 },
  { "Cuca", 0.0 },
  { "Cuinn", 1.0 },
  { "Cuitlahuac", 1.0 },
  { "Cula", 0.0 },
  { "Cullan", 1.0 },
  { "Culleen", 0.0 },
  { "Cullen", 0.99225545 },
  { "Culley", 1.0 },
  { "Cullie", 1.0 },
  { "Cullin", 1.0 },
  { "Cullus", 1.0 },
  { "Cully", 1.0 },
  { "Cullyn", 1.0 },
  { "Culver", 1.0 },
  { "Cuma", 0.0 },
  { "Cumi", 0.0 },
  { "Cung", 1.0 },
  { "Cuong", 1.0 },
  { "Cupertino", 1.0 },
  { "Cupid", 1.0 },
  { "Cura", 0.0 },
  { "Curby", 1.0 },
  { "Curie", 0.0 },
  { "Curissa", 0.0 },
  { "Curits", 1.0 },
  { "Curl", 1.0 },
  { "Curlee", 0.8971292 },
  { "Curlene", 0.0 },
  { "Curley", 0.8290653 },
  { "Curlie", 0.32457787 },
  { "Curly", 0.9745763 },
  { "Curran", 0.97275203 },
  { "Curren", 1.0 },
  { "Currie", 0.78313255 },
  { "Currin", 1.0 },
  { "Curron", 1.0 },
  { "Curry", 0.9464398 },
  { "Curstin", 0.0 },
  { "Curstyn", 0.0 },
  { "Curt", 1.0 },
  { "Curtavious", 1.0 },
  { "Curteria", 0.0 },
  { "Curtesha", 0.0 },
  { "Curtez", 1.0 },
  { "Curtia", 0.0 },
  { "Curtice", 1.0 },
  { "Curties", 1.0 },
  { "Curtina", 0.0 },
  { "Curtis", 0.99106354 },
  { "Curtisa", 0.0 },
  { "Curtisha", 0.0 },
  { "Curtiss", 1.0 },
  { "Curtissa", 0.0 },
  { "Curtistine", 0.0 },
  { "Curtney", 0.0 },
  { "Curtrina", 0.0 },
  { "Curtus", 1.0 },
  { "Curvin", 1.0 },
  { "Cushena", 0.0 },
  { "Custer", 1.0 },
  { "Custodio", 1.0 },
  { "Cutberto", 1.0 },
  { "Cuthbert", 1.0 },
  { "Cutina", 0.0 },
  { "Cutler", 1.0 },
  { "Cutter", 1.0 },
  { "Cuyler", 0.9842767 },
  { "Cy", 0.99525505 },
  { "Cya", 0.0 },
  { "Cyaira", 0.0 },
  { "Cyaire", 1.0 },
  { "Cyan", 0.16999133 },
  { "Cyana", 0.0 },
  { "Cyane", 0.0 },
  { "Cyani", 0.0 },
  { "Cyann", 0.0 },
  { "Cyanna", 0.0 },
  { "Cyanne", 0.0 },
  { "Cyanni", 0.0 },
  { "Cyanthia", 0.0 },
  { "Cyara", 0.0 },
  { "Cyarah", 0.0 },
  { "Cyarra", 0.0 },
  { "Cyasia", 0.0 },
  { "Cybele", 0.0 },
  { "Cybelle", 0.0 },
  { "Cybil", 0.0 },
  { "Cybill", 0.0 },
  { "Cyd", 0.0 },
  { "Cydne", 0.0 },
  { "Cydnee", 0.0 },
  { "Cydnei", 0.0 },
  { "Cydney", 0.0050301813 },
  { "Cydni", 0.0 },
  { "Cydnie", 0.0 },
  { "Cydny", 0.0 },
  { "Cye", 1.0 },
  { "Cyenna", 0.0 },
  { "Cyenthia", 0.0 },
  { "Cyera", 0.0 },
  { "Cyerah", 0.0 },
  { "Cyerra", 0.0 },
  { "Cyinthia", 0.0 },
  { "Cyion", 1.0 },
  { "Cyla", 0.0 },
  { "Cylah", 0.0 },
  { "Cylan", 1.0 },
  { "Cylar", 1.0 },
  { "Cylas", 1.0 },
  { "Cyle", 0.9923352 },
  { "Cylee", 0.0 },
  { "Cyleigh", 0.0 },
  { "Cylen", 1.0 },
  { "Cylena", 0.0 },
  { "Cyler", 0.9907579 },
  { "Cylie", 0.0 },
  { "Cylin", 1.0 },
  { "Cylinda", 0.0 },
  { "Cylis", 1.0 },
  { "Cylus", 1.0 },
  { "Cylvia", 0.0 },
  { "Cymande", 1.0 },
  { "Cymantha", 0.0 },
  { "Cymbre", 0.0 },
  { "Cymon", 1.0 },
  { "Cymone", 0.0 },
  { "Cymphonique", 0.0 },
  { "Cymphony", 0.0 },
  { "Cynae", 0.0 },
  { "Cynai", 0.0 },
  { "Cynamon", 0.0 },
  { "Cynara", 0.0 },
  { "Cynarra", 0.0 },
  { "Cyncere", 0.65609753 },
  { "Cynda", 0.0 },
  { "Cyndal", 0.0 },
  { "Cynde", 0.0 },
  { "Cyndee", 0.0 },
  { "Cyndel", 0.0 },
  { "Cyndi", 0.0 },
  { "Cyndia", 0.0 },
  { "Cyndie", 0.0 },
  { "Cyndil", 0.0 },
  { "Cyndle", 0.0 },
  { "Cyndra", 0.0 },
  { "Cyndy", 0.0 },
  { "Cynequa", 0.0 },
  { "Cynetha", 0.0 },
  { "Cynethia", 0.0 },
  { "Cynia", 0.0 },
  { "Cyniah", 0.0 },
  { "Cynii", 0.0 },
  { "Cynita", 0.0 },
  { "Cynitha", 0.0 },
  { "Cynithia", 0.0 },
  { "Cyniya", 0.0 },
  { "Cyniyah", 0.0 },
  { "Cynnamon", 0.0 },
  { "Cynne", 0.0 },
  { "Cynnthia", 0.0 },
  { "Cynteria", 0.0 },
  { "Cyntha", 0.0 },
  { "Cynthea", 0.0 },
  { "Cyntheia", 0.0 },
  { "Cynthi", 0.0 },
  { "Cynthia", 0.0027609956 },
  { "Cynthiaa", 0.0 },
  { "Cynthiaann", 0.0 },
  { "Cynthie", 0.0 },
  { "Cynthina", 0.0 },
  { "Cynthis", 0.0 },
  { "Cynthnia", 0.0 },
  { "Cynthya", 0.0 },
  { "Cyntia", 0.0 },
  { "Cyntoria", 0.0 },
  { "Cyntrell", 0.0 },
  { "Cyon", 1.0 },
  { "Cyonna", 0.0 },
  { "Cypher", 1.0 },
  { "Cypress", 0.4497768 },
  { "Cyprian", 1.0 },
  { "Cyprus", 0.91525424 },
  { "Cyra", 0.0 },
  { "Cyrah", 0.0 },
  { "Cyrano", 1.0 },
  { "Cyre", 0.0 },
  { "Cyree", 1.0 },
  { "Cyrell", 1.0 },
  { "Cyrelle", 0.0 },
  { "Cyrena", 0.0 },
  { "Cyrene", 0.0 },
  { "Cyrenity", 0.0 },
  { "Cyrenna", 0.0 },
  { "Cyress", 1.0 },
  { "Cyria", 0.0 },
  { "Cyriah", 0.0 },
  { "Cyriana", 0.0 },
  { "Cyric", 1.0 },
  { "Cyrie", 1.0 },
  { "Cyriel", 1.0 },
  { "Cyrielle", 0.0 },
  { "Cyril", 0.99173975 },
  { "Cyrill", 1.0 },
  { "Cyrilla", 0.0 },
  { "Cyrille", 0.8064516 },
  { "Cyrina", 0.0 },
  { "Cyrine", 0.0 },
  { "Cyris", 1.0 },
  { "Cyrita", 0.0 },
  { "Cyron", 1.0 },
  { "Cyrstal", 0.0 },
  { "Cyrus", 0.9997531 },
  { "Cyruss", 1.0 },
  { "Cyson", 1.0 },
  { "Cystal", 0.0 },
  { "Cythia", 0.0 },
  { "Cythina", 0.0 },
  { "Cythnia", 0.0 },
  { "Cytlali", 0.0 },
  { "Cytlalli", 0.0 },
  { "Cytlaly", 0.0 },
  { "Cytnhia", 0.0 },
  { "Czar", 1.0 },
  { "Czaria", 0.0 },
  { "Czarina", 0.0 },
  { "Czeslaw", 1.0 },
  { "Czeslawa", 0.0 },
  { "Da", 0.615894 },
  { "Daaiel", 1.0 },
  { "Daaimah", 0.0 },
  { "Daaiyah", 0.0 },
  { "Daan", 1.0 },
  { "Daana", 0.0 },
  { "Daandre", 1.0 },
  { "Daania", 0.0 },
  { "Daanish", 1.0 },
  { "Daanya", 0.0 },
  { "Daanyal", 1.0 },
  { "Daarina", 0.0 },
  { "Daaron", 1.0 },
  { "Daasia", 0.0 },
  { "Dabid", 1.0 },
  { "Dabin", 1.0 },
  { "Dabne", 0.0 },
  { "Dabney", 0.38410595 },
  { "Dabria", 0.0 },
  { "Dabriel", 1.0 },
  { "Dabrielle", 0.0 },
  { "Dabriyon", 1.0 },
  { "Dacari", 1.0 },
  { "Dacarri", 1.0 },
  { "Dace", 0.9564165 },
  { "Dacee", 0.0 },
  { "Dacen", 1.0 },
  { "Dacey", 0.0 },
  { "Dache", 0.0 },
  { "Dachelle", 0.0 },
  { "Dachia", 0.0 },
  { "Daci", 0.0 },
  { "Dacia", 0.0 },
  { "Dacian", 1.0 },
  { "Daciana", 0.0 },
  { "Dacie", 0.035460994 },
  { "Dacien", 1.0 },
  { "Dacio", 1.0 },
  { "Dacion", 1.0 },
  { "Dack", 1.0 },
  { "Dacoda", 0.81931466 },
  { "Dacorey", 1.0 },
  { "Dacorian", 1.0 },
  { "Dacorion", 1.0 },
  { "Dacota", 0.7267267 },
  { "Dacotah", 0.7037037 },
  { "Dacy", 0.0 },
  { "Daddy", 1.0 },
  { "Dade", 1.0 },
  { "Daden", 1.0 },
  { "Dadne", 0.0 },
  { "Dadra", 0.0 },
  { "Dadrian", 1.0 },
  { "Dadriana", 0.0 },
  { "Dadrianna", 0.0 },
  { "Dadrien", 1.0 },
  { "Dae", 0.65 },
  { "Daebreon", 0.2777778 },
  { "Daebreona", 0.0 },
  { "Daedalus", 1.0 },
  { "Daedra", 0.0 },
  { "Daedrian", 1.0 },
  { "Daedric", 1.0 },
  { "Daegan", 0.9408867 },
  { "Daegen", 1.0 },
  { "Daegon", 1.0 },
  { "Daehan", 1.0 },
  { "Daeisha", 0.0 },
  { "Daeja", 0.0 },
  { "Daejah", 0.0 },
  { "Daejanae", 0.0 },
  { "Daejanay", 0.0 },
  { "Daejaun", 1.0 },
  { "Daejha", 0.0 },
  { "Daejhun", 1.0 },
  { "Daejia", 0.0 },
  { "Daejion", 1.0 },
  { "Daejohn", 1.0 },
  { "Daejon", 1.0 },
  { "Daejuan", 1.0 },
  { "Daekwan", 1.0 },
  { "Daekwon", 1.0 },
  { "Dael", 1.0 },
  { "Daela", 0.0 },
  { "Daelan", 1.0 },
  { "Daelani", 0.0 },
  { "Daelen", 1.0 },
  { "Daelin", 0.8705584 },
  { "Daelon", 1.0 },
  { "Daely", 0.0 },
  { "Daelyn", 0.317662 },
  { "Daelynn", 0.030567685 },
  { "Daemen", 1.0 },
  { "Daemeon", 1.0 },
  { "Daemian", 1.0 },
  { "Daemien", 1.0 },
  { "Daemion", 1.0 },
  { "Daemon", 1.0 },
  { "Daemond", 1.0 },
  { "Daemyn", 1.0 },
  { "Daena", 0.0 },
  { "Daenerys", 0.0 },
  { "Daenna", 0.0 },
  { "Daeon", 1.0 },
  { "Daeonna", 0.0 },
  { "Daequan", 1.0 },
  { "Daequon", 1.0 },
  { "Daeqwon", 1.0 },
  { "Daerion", 1.0 },
  { "Daeron", 1.0 },
  { "Daesean", 1.0 },
  { "Daesha", 0.0 },
  { "Daeshaun", 1.0 },
  { "Daeshawn", 0.99338627 },
  { "Daeshawna", 0.0 },
  { "Daeshia", 0.0 },
  { "Daeshon", 1.0 },
  { "Daeshun", 1.0 },
  { "Daesia", 0.0 },
  { "Daeson", 1.0 },
  { "Daesy", 0.0 },
  { "Daeton", 1.0 },
  { "Daeun", 0.0 },
  { "Daevaughn", 1.0 },
  { "Daeveon", 1.0 },
  { "Daevian", 1.0 },
  { "Daevin", 1.0 },
  { "Daevion", 1.0 },
  { "Daevon", 1.0 },
  { "Daevyn", 1.0 },
  { "Daewon", 1.0 },
  { "Daeyon", 1.0 },
  { "Daeyonna", 0.0 },
  { "Daezha", 0.0 },
  { "Daezon", 1.0 },
  { "Daffany", 0.0 },
  { "Daffie", 0.0 },
  { "Daffne", 0.0 },
  { "Daffney", 0.0 },
  { "Daffy", 0.0 },
  { "Dafina", 0.0 },
  { "Dafna", 0.0 },
  { "Dafne", 0.0 },
  { "Dafnee", 0.0 },
  { "Dafney", 0.0 },
  { "Dafni", 0.0 },
  { "Dafnne", 0.0 },
  { "Dafny", 0.0 },
  { "Dag", 1.0 },
  { "Dagan", 0.9902344 },
  { "Dagem", 1.0 },
  { "Dagen", 0.91768295 },
  { "Dagger", 1.0 },
  { "Dagim", 1.0 },
  { "Dagmar", 0.0 },
  { "Dagmara", 0.0 },
  { "Dagmawi", 1.0 },
  { "Dagne", 0.0 },
  { "Dagney", 0.0 },
  { "Dagny", 0.0 },
  { "Dago", 1.0 },
  { "Dagoberto", 1.0 },
  { "Dagon", 1.0 },
  { "Daguan", 1.0 },
  { "Dah", 0.5405405 },
  { "Dahabo", 0.0 },
  { "Dahana", 0.0 },
  { "Dahani", 1.0 },
  { "Dahiana", 0.0 },
  { "Dahianna", 0.0 },
  { "Dahir", 1.0 },
  { "Dahja", 0.0 },
  { "Dahl", 1.0 },
  { "Dahlia", 0.0 },
  { "Dahliah", 0.0 },
  { "Dahliana", 0.0 },
  { "Dahlila", 0.0 },
  { "Dahlilah", 0.0 },
  { "Dahlin", 1.0 },
  { "Dahlon", 1.0 },
  { "Dahlton", 1.0 },
  { "Dahlya", 0.0 },
  { "Dahlyla", 0.0 },
  { "Dahmari", 1.0 },
  { "Dahmir", 1.0 },
  { "Dahn", 0.23809524 },
  { "Dahna", 0.0 },
  { "Dahndray", 1.0 },
  { "Dahntay", 1.0 },
  { "Dahnya", 0.0 },
  { "Dahquan", 1.0 },
  { "Dai", 0.65591395 },
  { "Daia", 0.0 },
  { "Daiah", 0.0 },
  { "Daian", 1.0 },
  { "Daiana", 0.0 },
  { "Daianera", 0.0 },
  { "Daianna", 0.0 },
  { "Daiceon", 1.0 },
  { "Daichi", 1.0 },
  { "Daicy", 0.0 },
  { "Daid", 1.0 },
  { "Daiden", 1.0 },
  { "Daidra", 0.0 },
  { "Daidre", 0.0 },
  { "Daidrian", 1.0 },
  { "Daiel", 1.0 },
  { "Daielle", 0.0 },
  { "Daigan", 1.0 },
  { "Daigen", 1.0 },
  { "Daigo", 1.0 },
  { "Daigon", 1.0 },
  { "Daiguan", 1.0 },
  { "Daija", 0.0 },
  { "Daijah", 0.0 },
  { "Daijana", 0.0 },
  { "Daijanae", 0.0 },
  { "Daijanay", 0.0 },
  { "Daijaun", 1.0 },
  { "Daijha", 0.0 },
  { "Daijia", 0.0 },
  { "Daijiah", 0.0 },
  { "Daijohn", 1.0 },
  { "Daijon", 0.99240124 },
  { "Daijour", 1.0 },
  { "Daijsha", 0.0 },
  { "Daijuan", 1.0 },
  { "Daiki", 1.0 },
  { "Daikwon", 1.0 },
  { "Dail", 0.7595357 },
  { "Daila", 0.0 },
  { "Dailah", 0.0 },
  { "Dailan", 1.0 },
  { "Dailani", 0.0 },
  { "Dailany", 0.0 },
  { "Dailee", 0.0 },
  { "Daileen", 0.0 },
  { "Daileigh", 0.0 },
  { "Dailen", 0.98452014 },
  { "Dailene", 0.0 },
  { "Dailey", 0.36042404 },
  { "Dailin", 0.21666667 },
  { "Dailon", 1.0 },
  { "Daily", 0.33031675 },
  { "Dailyn", 0.22653429 },
  { "Dailynn", 0.035842296 },
  { "Dailynne", 0.0 },
  { "Daiman", 1.0 },
  { "Daimar", 1.0 },
  { "Daimarely", 0.0 },
  { "Daimarion", 1.0 },
  { "Daimen", 1.0 },
  { "Daimeon", 1.0 },
  { "Daimian", 1.0 },
  { "Daimien", 1.0 },
  { "Daimion", 1.0 },
  { "Daimon", 1.0 },
  { "Daimond", 0.0 },
  { "Daimyan", 1.0 },
  { "Dain", 1.0 },
  { "Daina", 0.0020508613 },
  { "Dainan", 1.0 },
  { "Dainara", 0.0 },
  { "Daine", 0.5 },
  { "Dainel", 1.0 },
  { "Dainelle", 0.0 },
  { "Dainen", 1.0 },
  { "Dainera", 0.0 },
  { "Dainette", 0.0 },
  { "Dainian", 1.0 },
  { "Dainna", 0.0 },
  { "Dainon", 1.0 },
  { "Daintry", 0.0 },
  { "Dainty", 0.0 },
  { "Daion", 1.0 },
  { "Daiona", 0.0 },
  { "Daionna", 0.0 },
  { "Daiquan", 1.0 },
  { "Daiquiri", 0.0 },
  { "Daiquon", 1.0 },
  { "Dair", 1.0 },
  { "Daira", 0.0 },
  { "Daire", 0.92771083 },
  { "Dairel", 1.0 },
  { "Dairen", 1.0 },
  { "Dairian", 0.0 },
  { "Dairin", 0.0 },
  { "Dairion", 1.0 },
  { "Dairius", 1.0 },
  { "Dairl", 1.0 },
  { "Dairo", 1.0 },
  { "Dairon", 1.0 },
  { "Dairra", 0.0 },
  { "Dairus", 1.0 },
  { "Dairy", 0.0 },
  { "Dairyn", 0.0 },
  { "Daisa", 0.0 },
  { "Daise", 0.0 },
  { "Daisean", 1.0 },
  { "Daisee", 0.0 },
  { "Daisey", 0.0 },
  { "Daisha", 0.0 },
  { "Daishae", 0.0 },
  { "Daishana", 0.0 },
  { "Daishanae", 0.0 },
  { "Daishanay", 0.0 },
  { "Daishaun", 1.0 },
  { "Daishawn", 1.0 },
  { "Daishia", 0.0 },
  { "Daishon", 1.0 },
  { "Daishun", 1.0 },
  { "Daisi", 0.0 },
  { "Daisia", 0.0 },
  { "Daisie", 0.0 },
  { "Daisja", 0.0 },
  { "Daisjah", 0.0 },
  { "Daison", 1.0 },
  { "Daissy", 0.0 },
  { "Daisuke", 1.0 },
  { "Daisy", 0.004504764 },
  { "Daisya", 0.0 },
  { "Daisye", 0.0 },
  { "Daisylynn", 0.0 },
  { "Daisymae", 0.0 },
  { "Daisymarie", 0.0 },
  { "Daiten", 1.0 },
  { "Daithi", 1.0 },
  { "Daiton", 1.0 },
  { "Daityn", 0.0 },
  { "Daiva", 0.0 },
  { "Daivd", 1.0 },
  { "Daiven", 1.0 },
  { "Daiveon", 1.0 },
  { "Daivian", 1.0 },
  { "Daivid", 1.0 },
  { "Daivik", 1.0 },
  { "Daivion", 1.0 },
  { "Daivon", 1.0 },
  { "Daivyon", 1.0 },
  { "Daiwik", 1.0 },
  { "Daiya", 0.0 },
  { "Daiyaan", 1.0 },
  { "Daiyah", 0.0 },
  { "Daiyan", 1.0 },
  { "Daiyana", 0.0 },
  { "Daiyon", 1.0 },
  { "Daiza", 0.0 },
  { "Daizah", 0.0 },
  { "Daizee", 0.0 },
  { "Daizha", 0.0 },
  { "Daizhane", 0.0 },
  { "Daizhaun", 1.0 },
  { "Daizhon", 1.0 },
  { "Daizia", 0.0 },
  { "Daizie", 0.0 },
  { "Daizja", 0.0 },
  { "Daizjah", 0.0 },
  { "Daizon", 1.0 },
  { "Daizsa", 0.0 },
  { "Daizy", 0.0 },
  { "Daja", 0.0 },
  { "Dajae", 0.0 },
  { "Dajah", 0.003567788 },
  { "Dajaha", 0.0 },
  { "Dajahn", 1.0 },
  { "Dajahnae", 0.0 },
  { "Dajahnay", 0.0 },
  { "Dajai", 0.0 },
  { "Dajan", 1.0 },
  { "Dajana", 0.0 },
  { "Dajanae", 0.0 },
  { "Dajanai", 0.0 },
  { "Dajanay", 0.0 },
  { "Dajane", 0.0 },
  { "Dajanea", 0.0 },
  { "Dajanee", 0.0 },
  { "Dajanique", 0.0 },
  { "Dajaun", 1.0 },
  { "Dajauna", 0.0 },
  { "Dajavette", 0.0 },
  { "Daje", 0.0 },
  { "Dajea", 0.0 },
  { "Dajean", 1.0 },
  { "Dajee", 0.0 },
  { "Dajha", 0.0 },
  { "Dajhia", 0.0 },
  { "Dajhon", 1.0 },
  { "Dajia", 0.0 },
  { "Dajiah", 0.0 },
  { "Dajiana", 0.0 },
  { "Dajion", 1.0 },
  { "Dajohn", 1.0 },
  { "Dajon", 0.9576784 },
  { "Dajona", 0.0 },
  { "Dajonae", 0.0 },
  { "Dajonique", 0.0 },
  { "Dajonna", 0.0 },
  { "Dajoun", 1.0 },
  { "Dajour", 0.96068376 },
  { "Dajoure", 1.0 },
  { "Dajsha", 0.0 },
  { "Dajshia", 0.0 },
  { "Dajua", 0.0 },
  { "Dajuan", 1.0 },
  { "Dajuana", 0.0 },
  { "Dajun", 1.0 },
  { "Dajuon", 1.0 },
  { "Dajza", 0.0 },
  { "Dak", 1.0 },
  { "Dakai", 1.0 },
  { "Dakaiden", 1.0 },
  { "Dakar", 1.0 },
  { "Dakara", 0.0 },
  { "Dakarai", 0.98444253 },
  { "Dakari", 0.9407202 },
  { "Dakaria", 0.0 },
  { "Dakarie", 1.0 },
  { "Dakarii", 1.0 },
  { "Dakarion", 1.0 },
  { "Dakarri", 1.0 },
  { "Dakayden", 1.0 },
  { "Dakayla", 0.0 },
  { "Dake", 1.0 },
  { "Dakeem", 1.0 },
  { "Dakeisha", 0.0 },
  { "Daken", 1.0 },
  { "Dakera", 0.0 },
  { "Dakeria", 0.0 },
  { "Dakesha", 0.0 },
  { "Dakhari", 1.0 },
  { "Dakhi", 1.0 },
  { "Dakhia", 0.0 },
  { "Dakia", 0.0 },
  { "Dakim", 1.0 },
  { "Dakin", 1.0 },
  { "Daking", 1.0 },
  { "Dakira", 0.0 },
  { "Dakisha", 0.0 },
  { "Dakita", 0.0 },
  { "Dakiya", 0.0 },
  { "Dakiyah", 0.0 },
  { "Dakkota", 0.87234044 },
  { "Dakoata", 1.0 },
  { "Dakobe", 1.0 },
  { "Dakoda", 0.79988265 },
  { "Dakodah", 0.5875 },
  { "Dakori", 1.0 },
  { "Dakota", 0.73385084 },
  { "Dakotah", 0.6112161 },
  { "Dakotajames", 1.0 },
  { "Dakotta", 0.6292135 },
  { "Daks", 1.0 },
  { "Daksh", 1.0 },
  { "Daksha", 0.0 },
  { "Daktari", 1.0 },
  { "Dakuan", 1.0 },
  { "Dakwan", 1.0 },
  { "Dakwon", 1.0 },
  { "Dakya", 0.0 },
  { "Dakyah", 0.0 },
  { "Dakyla", 0.0 },
  { "Dakyra", 0.0 },
  { "Dakyrah", 0.0 },
  { "Dal", 1.0 },
  { "Dala", 0.0 },
  { "Dalai", 0.0 },
  { "Dalaila", 0.0 },
  { "Dalaina", 0.0 },
  { "Dalaine", 0.0 },
  { "Dalainee", 0.0 },
  { "Dalainey", 0.0 },
  { "Dalajah", 0.0 },
  { "Dalal", 0.0 },
  { "Dalan", 1.0 },
  { "Dalana", 0.0 },
  { "Dalane", 0.0 },
  { "Dalanee", 0.0 },
  { "Dalaney", 0.0 },
  { "Dalani", 0.0 },
  { "Dalanie", 0.0 },
  { "Dalanna", 0.0 },
  { "Dalano", 1.0 },
  { "Dalante", 1.0 },
  { "Dalany", 0.0 },
  { "Dalari", 0.0 },
  { "Dalarie", 0.0 },
  { "Dalary", 0.0 },
  { "Dalas", 0.7058824 },
  { "Dalasha", 0.0 },
  { "Dalasia", 0.0 },
  { "Dalay", 0.0 },
  { "Dalaya", 0.0 },
  { "Dalayah", 0.0 },
  { "Dalayjah", 0.0 },
  { "Dalayla", 0.0 },
  { "Dalaylah", 0.0 },
  { "Dalayna", 0.0 },
  { "Dalaynee", 0.0 },
  { "Dalayni", 0.0 },
  { "Dalaynie", 0.0 },
  { "Dalaysa", 0.0 },
  { "Dalaysha", 0.0 },
  { "Dalayshia", 0.0 },
  { "Dalaysia", 0.0 },
  { "Dalayssa", 0.0 },
  { "Dalayza", 0.0 },
  { "Dalbert", 1.0 },
  { "Dale", 0.9268393 },
  { "Dalea", 0.0 },
  { "Daleah", 0.0 },
  { "Dalecia", 0.0 },
  { "Dalee", 0.0 },
  { "Daleen", 0.0 },
  { "Daleena", 0.0 },
  { "Daleesa", 0.0 },
  { "Daleigh", 0.0 },
  { "Daleila", 0.0 },
  { "Daleisa", 0.0 },
  { "Daleisha", 0.0 },
  { "Daleiza", 0.0 },
  { "Dalen", 0.99102134 },
  { "Dalena", 0.0 },
  { "Dalene", 0.0 },
  { "Dalenna", 0.0 },
  { "Daleon", 1.0 },
  { "Daler", 1.0 },
  { "Dalerie", 0.0 },
  { "Dalery", 0.0 },
  { "Dalesa", 0.0 },
  { "Dalesha", 0.0 },
  { "Daleshia", 0.0 },
  { "Dalesia", 0.0 },
  { "Dalessandro", 1.0 },
  { "Dalet", 0.0 },
  { "Daleth", 0.0 },
  { "Dalevon", 1.0 },
  { "Dalexa", 0.0 },
  { "Dalexia", 0.0 },
  { "Daley", 0.22593321 },
  { "Daleya", 0.0 },
  { "Daleyah", 0.0 },
  { "Daleysa", 0.0 },
  { "Daleysha", 0.0 },
  { "Daleysi", 0.0 },
  { "Daleyssa", 0.0 },
  { "Daleyza", 0.0 },
  { "Daleyzah", 0.0 },
  { "Daleyzza", 0.0 },
  { "Dalhart", 1.0 },
  { "Dalhia", 0.0 },
  { "Dali", 0.25 },
  { "Dalia", 0.00051146536 },
  { "Daliah", 0.0 },
  { "Dalian", 1.0 },
  { "Daliana", 0.0 },
  { "Dalianna", 0.0 },
  { "Dalibor", 1.0 },
  { "Dalice", 0.0 },
  { "Dalicia", 0.0 },
  { "Dalida", 0.0 },
  { "Dalijah", 0.0 },
  { "Dalil", 1.0 },
  { "Dalila", 0.0 },
  { "Dalilah", 0.0 },
  { "Dalin", 0.9402655 },
  { "Dalina", 0.0 },
  { "Dalinda", 0.0 },
  { "Dalis", 0.040441178 },
  { "Dalisa", 0.0 },
  { "Dalisha", 0.0 },
  { "Dalisia", 0.0 },
  { "Dalissa", 0.0 },
  { "Daliya", 0.0 },
  { "Daliyah", 0.0 },
  { "Daliyla", 0.0 },
  { "Daliylah", 0.0 },
  { "Daliza", 0.0 },
  { "Dall", 1.0 },
  { "Dallace", 0.0 },
  { "Dallan", 1.0 },
  { "Dallana", 0.0 },
  { "Dallanara", 0.0 },
  { "Dallary", 0.0 },
  { "Dallas", 0.8353299 },
  { "Dallee", 0.0 },
  { "Dallen", 1.0 },
  { "Dallene", 0.0 },
  { "Dalles", 1.0 },
  { "Dalli", 0.0 },
  { "Dallie", 0.01984127 },
  { "Dallin", 1.0 },
  { "Dallion", 1.0 },
  { "Dallis", 0.5620389 },
  { "Dallon", 1.0 },
  { "Dallton", 1.0 },
  { "Dally", 0.0 },
  { "Dallyce", 0.0 },
  { "Dallyn", 0.88584477 },
  { "Dallys", 0.0 },
  { "Dalma", 0.0 },
  { "Dalmar", 1.0 },
  { "Dalmer", 1.0 },
  { "Dalon", 1.0 },
  { "Dalonda", 0.0 },
  { "Dalonna", 0.0 },
  { "Dalonta", 1.0 },
  { "Dalontae", 1.0 },
  { "Dalonte", 1.0 },
  { "Dalonzo", 1.0 },
  { "Dalores", 0.0 },
  { "Daloris", 0.0 },
  { "Dalpha", 0.0 },
  { "Dalphine", 0.0 },
  { "Dalphus", 1.0 },
  { "Dalshawn", 1.0 },
  { "Dalson", 1.0 },
  { "Dalston", 1.0 },
  { "Daltan", 1.0 },
  { "Dalten", 1.0 },
  { "Daltin", 1.0 },
  { "Dalton", 0.9950426 },
  { "Daltry", 1.0 },
  { "Daltyn", 1.0 },
  { "Dalva", 0.0 },
  { "Dalven", 1.0 },
  { "Dalvin", 1.0 },
  { "Dalvon", 1.0 },
  { "Dalvyn", 1.0 },
  { "Daly", 0.12969284 },
  { "Dalya", 0.0 },
  { "Dalyah", 0.0 },
  { "Dalyce", 0.0 },
  { "Dalyla", 0.0 },
  { "Dalylah", 0.0 },
  { "Dalyn", 0.6736658 },
  { "Dalynn", 0.103286386 },
  { "Dalys", 0.29166666 },
  { "Dalyss", 0.0 },
  { "Dalyssa", 0.0 },
  { "Dalziel", 1.0 },
  { "Dam", 1.0 },
  { "Dama", 0.0 },
  { "Damacio", 1.0 },
  { "Damaiah", 0.0 },
  { "Damain", 1.0 },
  { "Damaine", 1.0 },
  { "Damaire", 1.0 },
  { "Damaiya", 0.0 },
  { "Damaj", 1.0 },
  { "Damajae", 1.0 },
  { "Damajah", 1.0 },
  { "Damaje", 1.0 },
  { "Damal", 1.0 },
  { "Damali", 0.0 },
  { "Daman", 1.0 },
  { "Damani", 0.80508137 },
  { "Damante", 1.0 },
  { "Damany", 1.0 },
  { "Damar", 0.99493927 },
  { "Damara", 0.0 },
  { "Damarae", 1.0 },
  { "Damarco", 1.0 },
  { "Damarcus", 1.0 },
  { "Damare", 1.0 },
  { "Damarea", 0.9375 },
  { "Damaree", 1.0 },
  { "Damareion", 1.0 },
  { "Damareon", 1.0 },
  { "Damari", 0.8342512 },
  { "Damaria", 0.15825687 },
  { "Damariae", 1.0 },
  { "Damariah", 0.0 },
  { "Damarian", 1.0 },
  { "Damariana", 0.0 },
  { "Damariay", 1.0 },
  { "Damarie", 0.6923077 },
  { "Damarien", 1.0 },
  { "Damarieon", 1.0 },
  { "Damarii", 1.0 },
  { "Damario", 1.0 },
  { "Damarion", 1.0 },
  { "Damariona", 0.0 },
  { "Damarious", 1.0 },
  { "Damaris", 0.0427736 },
  { "Damarius", 1.0 },
  { "Damariya", 0.0 },
  { "Damariye", 1.0 },
  { "Damariyon", 1.0 },
  { "Damariz", 0.0 },
  { "Damarkis", 1.0 },
  { "Damarko", 1.0 },
  { "Damarkus", 1.0 },
  { "Damarlo", 1.0 },
  { "Damarques", 1.0 },
  { "Damarquez", 1.0 },
  { "Damarquis", 1.0 },
  { "Damarr", 1.0 },
  { "Damarrea", 1.0 },
  { "Damarri", 1.0 },
  { "Damarria", 0.0 },
  { "Damarrion", 1.0 },
  { "Damarrius", 1.0 },
  { "Damarte", 1.0 },
  { "Damarus", 1.0 },
  { "Damary", 0.0 },
  { "Damaryon", 1.0 },
  { "Damarys", 0.0 },
  { "Damascus", 1.0 },
  { "Damase", 1.0 },
  { "Damasio", 1.0 },
  { "Damaso", 1.0 },
  { "Damato", 1.0 },
  { "Damauni", 1.0 },
  { "Damauri", 1.0 },
  { "Damaurion", 1.0 },
  { "Damaury", 1.0 },
  { "Damaya", 0.0 },
  { "Damayah", 0.0 },
  { "Damayanti", 0.0 },
  { "Damayia", 0.0 },
  { "Damber", 0.0 },
  { "Damean", 1.0 },
  { "Damecia", 0.0 },
  { "Dameer", 1.0 },
  { "Dameian", 1.0 },
  { "Dameika", 0.0 },
  { "Damein", 1.0 },
  { "Dameion", 1.0 },
  { "Dameir", 1.0 },
  { "Dameisha", 0.0 },
  { "Damek", 1.0 },
  { "Dameka", 0.0 },
  { "Damekia", 0.0 },
  { "Dameko", 1.0 },
  { "Damel", 1.0 },
  { "Damell", 1.0 },
  { "Damen", 1.0 },
  { "Dameon", 1.0 },
  { "Damera", 0.0 },
  { "Damere", 1.0 },
  { "Dameria", 0.0 },
  { "Damerion", 1.0 },
  { "Damerius", 1.0 },
  { "Dameron", 0.7222222 },
  { "Damesha", 0.0 },
  { "Dameshia", 0.0 },
  { "Dameta", 0.0 },
  { "Dametra", 0.0 },
  { "Dametre", 1.0 },
  { "Dametri", 1.0 },
  { "Dametria", 0.0 },
  { "Dametrice", 0.0 },
  { "Dametrious", 1.0 },
  { "Dametris", 1.0 },
  { "Dametrius", 1.0 },
  { "Dameyon", 1.0 },
  { "Dameyune", 1.0 },
  { "Dami", 0.0 },
  { "Damia", 0.0 },
  { "Damiah", 0.0 },
  { "Damiam", 1.0 },
  { "Damian", 0.9959847 },
  { "Damiana", 0.0 },
  { "Damiane", 1.0 },
  { "Damiani", 1.0 },
  { "Damiann", 1.0 },
  { "Damianna", 0.0 },
  { "Damiano", 1.0 },
  { "Damica", 0.0 },
  { "Damichael", 1.0 },
  { "Damico", 1.0 },
  { "Damie", 0.13333334 },
  { "Damiean", 1.0 },
  { "Damiel", 1.0 },
  { "Damielle", 0.0 },
  { "Damien", 0.99522734 },
  { "Damiene", 1.0 },
  { "Damieon", 1.0 },
  { "Damier", 1.0 },
  { "Damiere", 1.0 },
  { "Damiesha", 0.0 },
  { "Damika", 0.0 },
  { "Damilare", 1.0 },
  { "Damilola", 0.2160804 },
  { "Damin", 1.0 },
  { "Damina", 0.0 },
  { "Damine", 1.0 },
  { "Damini", 0.0 },
  { "Damion", 0.9975524 },
  { "Damione", 1.0 },
  { "Damionna", 0.0 },
  { "Damir", 0.9964106 },
  { "Damira", 0.0 },
  { "Damiracle", 0.0 },
  { "Damirah", 0.0 },
  { "Damire", 1.0 },
  { "Damisha", 0.0 },
  { "Damishia", 0.0 },
  { "Damisi", 1.0 },
  { "Damiso", 1.0 },
  { "Damita", 0.0 },
  { "Damitra", 0.0 },
  { "Damitri", 1.0 },
  { "Damitrius", 1.0 },
  { "Damiun", 1.0 },
  { "Damius", 1.0 },
  { "Damiya", 0.0 },
  { "Damiyah", 0.0 },
  { "Damiyan", 1.0 },
  { "Damiyon", 1.0 },
  { "Damla", 0.0 },
  { "Dammian", 1.0 },
  { "Dammion", 1.0 },
  { "Dammon", 1.0 },
  { "Damne", 0.0 },
  { "Damon", 0.99497306 },
  { "Damona", 0.0 },
  { "Damond", 0.99755263 },
  { "Damondre", 1.0 },
  { "Damone", 1.0 },
  { "Damonee", 1.0 },
  { "Damonei", 1.0 },
  { "Damoney", 1.0 },
  { "Damoni", 0.73967683 },
  { "Damonica", 0.0 },
  { "Damonie", 0.6897959 },
  { "Damonii", 1.0 },
  { "Damonique", 0.0 },
  { "Damonn", 1.0 },
  { "Damonni", 1.0 },
  { "Damonnie", 1.0 },
  { "Damont", 1.0 },
  { "Damonta", 1.0 },
  { "Damontae", 1.0 },
  { "Damontay", 1.0 },
  { "Damonte", 1.0 },
  { "Damontez", 1.0 },
  { "Damontra", 1.0 },
  { "Damontrae", 1.0 },
  { "Damontray", 1.0 },
  { "Damontre", 1.0 },
  { "Damori", 1.0 },
  { "Damorian", 1.0 },
  { "Damorion", 1.0 },
  { "Damorris", 1.0 },
  { "Damu", 1.0 },
  { "Damus", 1.0 },
  { "Damya", 0.0 },
  { "Damyah", 0.0 },
  { "Damyan", 1.0 },
  { "Damyen", 1.0 },
  { "Damyia", 0.0 },
  { "Damyiah", 0.0 },
  { "Damyla", 0.0 },
  { "Damyn", 1.0 },
  { "Damyon", 1.0 },
  { "Damyra", 0.0 },
  { "Damyria", 0.0 },
  { "Damyrion", 1.0 },
  { "Damyron", 1.0 },
  { "Dan", 0.99487114 },
  { "Dana", 0.21713783 },
  { "Danaca", 0.0 },
  { "Danae", 0.0009277872 },
  { "Danaeja", 0.0 },
  { "Danaejah", 0.0 },
  { "Danah", 0.0 },
  { "Danahe", 0.0 },
  { "Danahi", 0.0 },
  { "Danai", 0.017421603 },
  { "Danaia", 0.0 },
  { "Danaija", 0.0 },
  { "Danaijah", 0.0 },
  { "Danail", 1.0 },
  { "Danaira", 0.0 },
  { "Danaisa", 0.0 },
  { "Danaisha", 0.0 },
  { "Danait", 0.0 },
  { "Danaiya", 0.0 },
  { "Danaiyah", 0.0 },
  { "Danaja", 0.0 },
  { "Danajah", 0.0 },
  { "Danajha", 0.0 },
  { "Danajia", 0.0 },
  { "Danaka", 0.0 },
  { "Danal", 1.0 },
  { "Danald", 1.0 },
  { "Danalee", 0.0 },
  { "Danali", 0.0 },
  { "Danaly", 0.0 },
  { "Danalyn", 0.0 },
  { "Danalynn", 0.0 },
  { "Danamarie", 0.0 },
  { "Danan", 1.0 },
  { "Danapaola", 0.0 },
  { "Danara", 0.0 },
  { "Danard", 1.0 },
  { "Danari", 0.6976744 },
  { "Danaria", 0.0 },
  { "Danariah", 0.0 },
  { "Danarius", 1.0 },
  { "Danasha", 0.0 },
  { "Danashia", 0.0 },
  { "Danasia", 0.0 },
  { "Danautica", 0.0 },
  { "Danavia", 0.0 },
  { "Danay", 0.0 },
  { "Danaya", 0.0 },
  { "Danayah", 0.0 },
  { "Danayara", 0.0 },
  { "Danaye", 0.0 },
  { "Danayia", 0.0 },
  { "Danayja", 0.0 },
  { "Danayjah", 0.0 },
  { "Danayla", 0.0 },
  { "Danaysha", 0.0 },
  { "Danayshia", 0.0 },
  { "Danaysia", 0.0 },
  { "Danaysy", 0.0 },
  { "Danazha", 0.0 },
  { "Danazia", 0.0 },
  { "Dancia", 0.0 },
  { "Dancy", 0.0 },
  { "Dandi", 0.0 },
  { "Dandra", 0.09022556 },
  { "Dandrae", 1.0 },
  { "Dandre", 0.9948165 },
  { "Dandrea", 0.1605166 },
  { "Dandrell", 1.0 },
  { "Dandrew", 1.0 },
  { "Dandria", 0.0 },
  { "Dandrick", 1.0 },
  { "Dandridge", 1.0 },
  { "Dandy", 0.95238096 },
  { "Dane", 0.9880289 },
  { "Danea", 0.0 },
  { "Daneah", 0.0 },
  { "Daneal", 0.7777778 },
  { "Danean", 0.0 },
  { "Daneca", 0.0 },
  { "Danecia", 0.0 },
  { "Danee", 0.0 },
  { "Daneeka", 0.0 },
  { "Daneel", 1.0 },
  { "Daneen", 0.0 },
  { "Daneesha", 0.0 },
  { "Daneida", 0.0 },
  { "Daneika", 0.0 },
  { "Daneil", 0.97425586 },
  { "Daneila", 0.0 },
  { "Daneille", 0.0 },
  { "Daneisha", 0.0 },
  { "Daneisy", 0.0 },
  { "Daneja", 0.0 },
  { "Danek", 1.0 },
  { "Daneka", 0.0 },
  { "Danel", 0.683871 },
  { "Danela", 0.0 },
  { "Danele", 0.0 },
  { "Daneli", 0.0 },
  { "Danelia", 0.0 },
  { "Danelis", 0.0 },
  { "Danell", 0.23365617 },
  { "Danella", 0.0 },
  { "Danelle", 0.00649259 },
  { "Danelly", 0.0 },
  { "Danely", 0.0 },
  { "Danelys", 0.0 },
  { "Danen", 1.0 },
  { "Danene", 0.0 },
  { "Danequa", 0.0 },
  { "Danera", 0.0 },
  { "Danery", 0.0 },
  { "Danesa", 0.0 },
  { "Danese", 0.0 },
  { "Danesh", 1.0 },
  { "Danesha", 0.0 },
  { "Daneshia", 0.0 },
  { "Danesia", 0.0 },
  { "Danessa", 0.0 },
  { "Danet", 0.0 },
  { "Danetra", 0.0 },
  { "Danetria", 0.0 },
  { "Danett", 0.0 },
  { "Danetta", 0.0 },
  { "Danette", 0.0 },
  { "Daney", 0.15068494 },
  { "Daneya", 0.0 },
  { "Daneyah", 0.0 },
  { "Daneysha", 0.0 },
  { "Danford", 1.0 },
  { "Danforth", 1.0 },
  { "Dang", 0.9802632 },
  { "Dangel", 0.6052632 },
  { "Dangela", 0.0 },
  { "Dangello", 1.0 },
  { "Dangelo", 1.0 },
  { "Danger", 1.0 },
  { "Dangkhoa", 1.0 },
  { "Danh", 1.0 },
  { "Dani", 0.10388313 },
  { "Dania", 0.0007247427 },
  { "Daniah", 0.0 },
  { "Danial", 0.991396 },
  { "Daniale", 0.0 },
  { "Danialle", 0.0 },
  { "Danian", 1.0 },
  { "Daniana", 0.0 },
  { "Daniaya", 0.0 },
  { "Danica", 0.0 },
  { "Danicah", 0.0 },
  { "Danice", 0.0 },
  { "Danicia", 0.0 },
  { "Danicka", 0.0 },
  { "Danie", 0.67657995 },
  { "Danieal", 0.38297874 },
  { "Daniece", 0.0 },
  { "Danieka", 0.0 },
  { "Daniel", 0.9957214 },
  { "Daniela", 0.0028596993 },
  { "Danield", 1.0 },
  { "Daniele", 0.17438883 },
  { "Danielee", 0.0 },
  { "Danielia", 0.0 },
  { "Danielis", 0.0 },
  { "Danieliz", 0.0 },
  { "Danieljames", 1.0 },
  { "Danieljohn", 1.0 },
  { "Danieljoseph", 1.0 },
  { "Danieljr", 1.0 },
  { "Daniell", 0.28039354 },
  { "Daniella", 0.00022100261 },
  { "Daniellah", 0.0 },
  { "Danielle", 0.0051596216 },
  { "Daniellee", 1.0 },
  { "Daniellemarie", 0.0 },
  { "Daniellerose", 0.0 },
  { "Daniellie", 0.0 },
  { "Danielly", 0.0 },
  { "Daniels", 1.0 },
  { "Danielson", 1.0 },
  { "Daniely", 0.0 },
  { "Danielynn", 0.0 },
  { "Danielys", 0.0 },
  { "Danien", 1.0 },
  { "Daniesha", 0.0 },
  { "Daniette", 0.0 },
  { "Daniil", 1.0 },
  { "Danija", 0.0 },
  { "Danijah", 0.0 },
  { "Danijel", 1.0 },
  { "Danijela", 0.0 },
  { "Danik", 1.0 },
  { "Danika", 0.0 },
  { "Danikah", 0.0 },
  { "Danikka", 0.0 },
  { "Danil", 1.0 },
  { "Danila", 0.16447368 },
  { "Danilah", 0.0 },
  { "Danile", 0.974359 },
  { "Danilee", 0.0 },
  { "Danilla", 0.0 },
  { "Danille", 0.0 },
  { "Danillie", 0.0 },
  { "Danilo", 1.0 },
  { "Danilyn", 0.0 },
  { "Danilynn", 0.0 },
  { "Danina", 0.0 },
  { "Danine", 0.0 },
  { "Danion", 1.0 },
  { "Daniqua", 0.0 },
  { "Danique", 0.0 },
  { "Danira", 0.0 },
  { "Danis", 0.76865673 },
  { "Danisa", 0.0 },
  { "Danise", 0.0 },
  { "Danish", 1.0 },
  { "Danisha", 0.0 },
  { "Danishia", 0.0 },
  { "Danissa", 0.0 },
  { "Danit", 0.0 },
  { "Danita", 0.0 },
  { "Danitra", 0.0 },
  { "Danity", 0.0 },
  { "Danitza", 0.0 },
  { "Danixa", 0.0 },
  { "Daniya", 0.0 },
  { "Daniyah", 0.0 },
  { "Daniyal", 1.0 },
  { "Daniyel", 1.0 },
  { "Daniyla", 0.0 },
  { "Daniylah", 0.0 },
  { "Daniza", 0.0 },
  { "Danja", 0.0 },
  { "Danka", 0.0 },
  { "Danl", 1.0 },
  { "Danley", 1.0 },
  { "Dann", 0.48769575 },
  { "Danna", 0.0074110674 },
  { "Dannae", 0.0 },
  { "Dannah", 0.0 },
  { "Dannaka", 0.0 },
  { "Dannalee", 0.0 },
  { "Dannaly", 0.0 },
  { "Dannalyn", 0.0 },
  { "Dannan", 0.0 },
  { "Dannapaola", 0.0 },
  { "Dannay", 0.0 },
  { "Danne", 0.2675841 },
  { "Dannea", 0.0 },
  { "Dannee", 0.0 },
  { "Dannel", 0.8507463 },
  { "Dannell", 0.3776596 },
  { "Dannelle", 0.0 },
  { "Dannely", 0.0 },
  { "Dannen", 1.0 },
  { "Danner", 0.98452014 },
  { "Dannesha", 0.0 },
  { "Dannett", 0.0 },
  { "Dannetta", 0.0 },
  { "Dannette", 0.0 },
  { "Danney", 0.99032885 },
  { "Danni", 0.033930253 },
  { "Dannia", 0.0 },
  { "Dannial", 1.0 },
  { "Dannica", 0.0 },
  { "Dannicka", 0.0 },
  { "Dannie", 0.8068254 },
  { "Danniel", 0.92577815 },
  { "Danniela", 0.0 },
  { "Danniele", 0.0 },
  { "Danniell", 0.0 },
  { "Danniella", 0.0 },
  { "Dannielle", 0.0 },
  { "Dannielyn", 0.0 },
  { "Dannielynn", 0.0 },
  { "Dannika", 0.0 },
  { "Dannille", 0.0 },
  { "Dannilyn", 0.0 },
  { "Dannilynn", 0.0 },
  { "Dannion", 1.0 },
  { "Dannis", 1.0 },
  { "Dannisha", 0.0 },
  { "Dannita", 0.0 },
  { "Dannon", 0.84110534 },
  { "Danny", 0.9944613 },
  { "Dannya", 0.0 },
  { "Dannye", 0.78125 },
  { "Dannyel", 1.0 },
  { "Dannyell", 0.0 },
  { "Dannyelle", 0.0 },
  { "Dannylynn", 0.0 },
  { "Dannyray", 1.0 },
  { "Dano", 1.0 },
  { "Danon", 0.8969072 },
  { "Danovan", 1.0 },
  { "Danquan", 1.0 },
  { "Dansby", 1.0 },
  { "Danson", 1.0 },
  { "Danta", 0.9754902 },
  { "Dantae", 1.0 },
  { "Dantasia", 0.0 },
  { "Dantavious", 1.0 },
  { "Dantavis", 1.0 },
  { "Dantavius", 1.0 },
  { "Dantay", 1.0 },
  { "Dante", 0.9891096 },
  { "Dantee", 1.0 },
  { "Dantel", 1.0 },
  { "Danterius", 1.0 },
  { "Danterrius", 1.0 },
  { "Dantes", 1.0 },
  { "Dantez", 1.0 },
  { "Danthony", 1.0 },
  { "Danti", 1.0 },
  { "Dantley", 1.0 },
  { "Dantoinette", 0.0 },
  { "Danton", 1.0 },
  { "Dantoni", 1.0 },
  { "Dantonio", 1.0 },
  { "Dantre", 1.0 },
  { "Dantrel", 1.0 },
  { "Dantrell", 1.0 },
  { "Dantwan", 1.0 },
  { "Danual", 1.0 },
  { "Danuel", 0.98245615 },
  { "Danuta", 0.0 },
  { "Danute", 0.0 },
  { "Dany", 0.91033924 },
  { "Danya", 0.008745477 },
  { "Danyaal", 1.0 },
  { "Danyae", 0.0 },
  { "Danyael", 1.0 },
  { "Danyah", 0.0 },
  { "Danyail", 0.0 },
  { "Danyal", 0.71929824 },
  { "Danyale", 0.051177073 },
  { "Danyall", 0.0 },
  { "Danyalle", 0.0 },
  { "Danyca", 0.0 },
  { "Danye", 0.7735849 },
  { "Danyea", 0.0 },
  { "Danyeal", 0.0 },
  { "Danyeil", 0.0 },
  { "Danyel", 0.2073441 },
  { "Danyela", 0.0 },
  { "Danyele", 0.0 },
  { "Danyell", 0.114245415 },
  { "Danyella", 0.0 },
  { "Danyelle", 0.006480995 },
  { "Danyetta", 0.0 },
  { "Danyette", 0.0 },
  { "Danyia", 0.0 },
  { "Danyiah", 0.0 },
  { "Danyiel", 0.0 },
  { "Danyielle", 0.0 },
  { "Danyka", 0.0 },
  { "Danykah", 0.0 },
  { "Danyl", 0.5597015 },
  { "Danyla", 0.0 },
  { "Danylah", 0.0 },
  { "Danyle", 0.0 },
  { "Danyll", 0.0 },
  { "Danylle", 0.0 },
  { "Danylo", 1.0 },
  { "Danyne", 0.0 },
  { "Danyon", 1.0 },
  { "Danyra", 0.0 },
  { "Danysha", 0.0 },
  { "Danytza", 0.0 },
  { "Danzel", 1.0 },
  { "Danzell", 1.0 },
  { "Danzelle", 1.0 },
  { "Danziel", 1.0 },
  { "Danzig", 1.0 },
  { "Dao", 0.68231046 },
  { "Daon", 1.0 },
  { "Daonna", 0.0 },
  { "Daonte", 1.0 },
  { "Daoud", 1.0 },
  { "Daouda", 1.0 },
  { "Daphane", 0.0 },
  { "Daphanie", 0.0 },
  { "Daphen", 0.0 },
  { "Daphene", 0.0 },
  { "Daphine", 0.0 },
  { "Daphna", 0.0 },
  { "Daphne", 0.0002044094 },
  { "Daphnee", 0.0 },
  { "Daphney", 0.0 },
  { "Daphni", 0.0 },
  { "Daphnie", 0.0 },
  { "Daphny", 0.0 },
  { "Daphyne", 0.0 },
  { "Daquain", 1.0 },
  { "Daquan", 0.9992012 },
  { "Daquana", 0.0 },
  { "Daquanda", 0.0 },
  { "Daquandre", 1.0 },
  { "Daquane", 1.0 },
  { "Daquann", 1.0 },
  { "Daquanna", 0.0 },
  { "Daquante", 1.0 },
  { "Daquarious", 1.0 },
  { "Daquarius", 1.0 },
  { "Daquasha", 0.0 },
  { "Daquasia", 0.0 },
  { "Daquavion", 1.0 },
  { "Daquavious", 1.0 },
  { "Daquavius", 1.0 },
  { "Daquawn", 1.0 },
  { "Daquel", 1.0 },
  { "Daquesha", 0.0 },
  { "Daquez", 1.0 },
  { "Daquian", 1.0 },
  { "Daquin", 1.0 },
  { "Daquinn", 1.0 },
  { "Daquion", 1.0 },
  { "Daquisha", 0.0 },
  { "Daquita", 0.0 },
  { "Daquon", 1.0 },
  { "Daquwan", 1.0 },
  { "Daqwan", 1.0 },
  { "Daqwane", 1.0 },
  { "Daqwon", 1.0 },
  { "Dar", 1.0 },
  { "Dara", 0.046863962 },
  { "Darae", 0.33333334 },
  { "Darah", 0.0 },
  { "Darail", 1.0 },
  { "Darain", 1.0 },
  { "Daral", 1.0 },
  { "Darald", 1.0 },
  { "Daralee", 0.0 },
  { "Daralene", 0.0 },
  { "Daraly", 0.0 },
  { "Daralyn", 0.0 },
  { "Daralynn", 0.0 },
  { "Daran", 0.99140894 },
  { "Darann", 0.0 },
  { "Darasimi", 0.0 },
  { "Darathy", 0.0 },
  { "Daray", 1.0 },
  { "Darayl", 1.0 },
  { "Darbee", 0.0 },
  { "Darbey", 0.0 },
  { "Darbi", 0.0 },
  { "Darbie", 0.0 },
  { "Darby", 0.2670268 },
  { "Darcas", 0.0 },
  { "Darce", 0.0 },
  { "Darcee", 0.0 },
  { "Darcel", 0.09555069 },
  { "Darcell", 0.24477611 },
  { "Darcella", 0.0 },
  { "Darcelle", 0.0 },
  { "Darcey", 0.04596577 },
  { "Darchell", 0.0 },
  { "Darchelle", 0.0 },
  { "Darci", 0.0 },
  { "Darcia", 0.0 },
  { "Darcie", 0.0 },
  { "Darco", 1.0 },
  { "Darcus", 0.029810298 },
  { "Darcy", 0.11001629 },
  { "Dardan", 1.0 },
  { "Dardanella", 0.0 },
  { "Darden", 1.0 },
  { "Dardenella", 0.0 },
  { "Dardi", 0.0 },
  { "Dare", 0.4921875 },
  { "Darea", 0.0 },
  { "Darean", 0.68292683 },
  { "Dareck", 1.0 },
  { "Dareece", 1.0 },
  { "Dareen", 0.029239766 },
  { "Dareese", 0.0 },
  { "Dareian", 1.0 },
  { "Darein", 0.7619048 },
  { "Dareion", 1.0 },
  { "Darek", 1.0 },
  { "Dareka", 0.0 },
  { "Darel", 0.99752843 },
  { "Dareld", 1.0 },
  { "Darelene", 0.0 },
  { "Dareli", 0.0 },
  { "Darell", 0.9979184 },
  { "Darelle", 0.962069 },
  { "Darely", 0.0 },
  { "Darelyn", 0.0 },
  { "Darelys", 0.0 },
  { "Daren", 0.98192656 },
  { "Darena", 0.0 },
  { "Darence", 1.0 },
  { "Darenda", 0.0 },
  { "Darene", 0.0 },
  { "Dareon", 0.9830508 },
  { "Dareona", 0.0 },
  { "Darese", 1.0 },
  { "Daresha", 0.0 },
  { "Dareth", 0.0 },
  { "Daretha", 0.0 },
  { "Daretta", 0.0 },
  { "Dareus", 1.0 },
  { "Darey", 1.0 },
  { "Dargan", 1.0 },
  { "Darhl", 1.0 },
  { "Darhonda", 0.0 },
  { "Darhyl", 1.0 },
  { "Dari", 0.045614034 },
  { "Daria", 0.0006164468 },
  { "Dariah", 0.0 },
  { "Darian", 0.7074534 },
  { "Dariana", 0.0 },
  { "Dariane", 0.0 },
  { "Dariann", 0.0 },
  { "Darianna", 0.0 },
  { "Darianne", 0.0 },
  { "Darianny", 0.0 },
  { "Dariany", 0.0 },
  { "Darianys", 0.0 },
  { "Darias", 1.0 },
  { "Daric", 1.0 },
  { "Darica", 0.0 },
  { "Darice", 0.009961686 },
  { "Darick", 1.0 },
  { "Darico", 1.0 },
  { "Darie", 0.0 },
  { "Dariean", 0.0 },
  { "Dariel", 0.8759584 },
  { "Dariela", 0.0 },
  { "Darielis", 0.0 },
  { "Dariell", 0.74358976 },
  { "Dariella", 0.0 },
  { "Darielle", 0.0 },
  { "Dariely", 0.0 },
  { "Darielys", 0.0 },
  { "Darien", 0.8421144 },
  { "Dariene", 0.0 },
  { "Darienne", 0.0 },
  { "Darieon", 1.0 },
  { "Daries", 1.0 },
  { "Darieus", 1.0 },
  { "Darihanna", 0.0 },
  { "Darik", 1.0 },
  { "Darika", 0.0 },
  { "Darikson", 1.0 },
  { "Daril", 1.0 },
  { "Darilyn", 0.0 },
  { "Darilynn", 0.0 },
  { "Darin", 0.9888148 },
  { "Darina", 0.0 },
  { "Darinda", 0.0 },
  { "Darine", 0.0 },
  { "Darinel", 1.0 },
  { "Darinesha", 0.0 },
  { "Darinka", 0.0 },
  { "Dario", 1.0 },
  { "Darion", 0.9225993 },
  { "Dariona", 0.0 },
  { "Darionna", 0.0 },
  { "Darionne", 1.0 },
  { "Darionte", 1.0 },
  { "Darious", 1.0 },
  { "Darique", 1.0 },
  { "Daris", 0.64880604 },
  { "Darise", 0.0 },
  { "Darisha", 0.0 },
  { "Darisley", 0.0 },
  { "Darissa", 0.0 },
  { "Darita", 0.0 },
  { "Darith", 1.0 },
  { "Daritza", 0.0 },
  { "Dariun", 1.0 },
  { "Darius", 0.99458945 },
  { "Dariush", 1.0 },
  { "Dariusz", 1.0 },
  { "Darivs", 1.0 },
  { "Dariya", 0.0 },
  { "Dariyah", 0.0 },
  { "Dariyan", 0.45238096 },
  { "Dariyana", 0.0 },
  { "Dariyelle", 0.0 },
  { "Dariyon", 0.94623655 },
  { "Darkiel", 1.0 },
  { "Darko", 1.0 },
  { "Darl", 0.9665072 },
  { "Darla", 0.0006442684 },
  { "Darlah", 0.0 },
  { "Darlaine", 0.0 },
  { "Darlana", 0.0 },
  { "Darlane", 0.0 },
  { "Darle", 0.8507463 },
  { "Darlean", 0.0 },
  { "Darleane", 0.0 },
  { "Darlee", 0.0 },
  { "Darleen", 0.0 },
  { "Darleena", 0.0 },
  { "Darleene", 0.0 },
  { "Darlen", 0.0 },
  { "Darlena", 0.0 },
  { "Darlene", 0.0029588114 },
  { "Darleni", 0.0 },
  { "Darlenis", 0.0 },
  { "Darlenne", 0.0 },
  { "Darleny", 0.0 },
  { "Darlenys", 0.0 },
  { "Darles", 0.0 },
  { "Darlesha", 0.0 },
  { "Darleta", 0.0 },
  { "Darleth", 0.0 },
  { "Darletha", 0.0 },
  { "Darletta", 0.0 },
  { "Darlette", 0.0 },
  { "Darley", 0.5 },
  { "Darlia", 0.0 },
  { "Darlicia", 0.0 },
  { "Darlie", 0.0 },
  { "Darlien", 0.0 },
  { "Darliene", 0.0 },
  { "Darlin", 0.06451613 },
  { "Darlina", 0.0 },
  { "Darlinda", 0.0 },
  { "Darline", 0.0 },
  { "Darling", 0.006527415 },
  { "Darlis", 0.0 },
  { "Darlisa", 0.0 },
  { "Darlise", 0.0 },
  { "Darlisha", 0.0 },
  { "Darliss", 0.0 },
  { "Darlita", 0.0 },
  { "Darlo", 1.0 },
  { "Darlow", 1.0 },
  { "Darly", 0.59090906 },
  { "Darlyene", 0.0 },
  { "Darlyn", 0.012418687 },
  { "Darlynda", 0.0 },
  { "Darlyne", 0.0 },
  { "Darlynn", 0.0 },
  { "Darlynne", 0.0 },
  { "Darlys", 0.0 },
  { "Darma", 0.0 },
  { "Darmani", 1.0 },
  { "Darmarcus", 1.0 },
  { "Darmesha", 0.0 },
  { "Darmon", 1.0 },
  { "Darnae", 0.0 },
  { "Darnaja", 0.0 },
  { "Darnasia", 0.0 },
  { "Darnay", 1.0 },
  { "Darnecia", 0.0 },
  { "Darnee", 1.0 },
  { "Darneil", 1.0 },
  { "Darneisha", 0.0 },
  { "Darnel", 0.95155036 },
  { "Darnell", 0.92086905 },
  { "Darnella", 0.0 },
  { "Darnelle", 0.5891089 },
  { "Darnese", 0.0 },
  { "Darnesha", 0.0 },
  { "Darneshia", 0.0 },
  { "Darnetha", 0.0 },
  { "Darnetta", 0.0 },
  { "Darnette", 0.0 },
  { "Darney", 1.0 },
  { "Darnez", 1.0 },
  { "Darnice", 0.0 },
  { "Darniece", 0.0 },
  { "Darniesha", 0.0 },
  { "Darnika", 0.0 },
  { "Darnise", 0.0 },
  { "Darnisha", 0.0 },
  { "Darnishia", 0.0 },
  { "Darnita", 0.0 },
  { "Darnley", 1.0 },
  { "Darol", 1.0 },
  { "Darold", 1.0 },
  { "Darolyn", 0.0 },
  { "Daron", 0.97862107 },
  { "Daronda", 0.0 },
  { "Darone", 1.0 },
  { "Daronn", 1.0 },
  { "Daronta", 1.0 },
  { "Daronte", 1.0 },
  { "Darothy", 0.0 },
  { "Darquan", 1.0 },
  { "Darquez", 1.0 },
  { "Darquis", 1.0 },
  { "Darquise", 1.0 },
  { "Darquisha", 0.0 },
  { "Darr", 1.0 },
  { "Darra", 0.0 },
  { "Darragh", 0.82843137 },
  { "Darrah", 0.0 },
  { "Darrain", 1.0 },
  { "Darral", 1.0 },
  { "Darrall", 1.0 },
  { "Darran", 1.0 },
  { "Darrayl", 1.0 },
  { "Darrean", 0.47058824 },
  { "Darreck", 1.0 },
  { "Darrein", 0.8 },
  { "Darreion", 1.0 },
  { "Darrek", 1.0 },
  { "Darrel", 0.99588835 },
  { "Darreld", 1.0 },
  { "Darrell", 0.9925623 },
  { "Darrelle", 0.79153097 },
  { "Darrellyn", 0.0 },
  { "Darrelyn", 0.0 },
  { "Darren", 0.99447334 },
  { "Darrence", 1.0 },
  { "Darrent", 1.0 },
  { "Darreon", 1.0 },
  { "Darresha", 0.0 },
  { "Darrett", 1.0 },
  { "Darreus", 1.0 },
  { "Darreyl", 1.0 },
  { "Darri", 0.0 },
  { "Darria", 0.0 },
  { "Darriah", 0.0 },
  { "Darrian", 0.7694134 },
  { "Darriana", 0.0 },
  { "Darriane", 0.0 },
  { "Darrianna", 0.0 },
  { "Darrias", 1.0 },
  { "Darric", 1.0 },
  { "Darrica", 0.0 },
  { "Darrick", 0.99862224 },
  { "Darricka", 0.0 },
  { "Darrie", 0.832 },
  { "Darriel", 0.7913279 },
  { "Darriell", 0.16923077 },
  { "Darrielle", 0.0 },
  { "Darrien", 0.89351034 },
  { "Darries", 1.0 },
  { "Darrik", 1.0 },
  { "Darrika", 0.0 },
  { "Darril", 1.0 },
  { "Darrill", 1.0 },
  { "Darrilyn", 0.0 },
  { "Darrin", 0.99546987 },
  { "Darrington", 1.0 },
  { "Darrio", 1.0 },
  { "Darrion", 0.96453226 },
  { "Darriona", 0.0 },
  { "Darrione", 1.0 },
  { "Darrionna", 0.0 },
  { "Darrious", 1.0 },
  { "Darris", 0.9518427 },
  { "Darrisha", 0.0 },
  { "Darrius", 1.0 },
  { "Darriyah", 0.0 },
  { "Darrly", 1.0 },
  { "Darrlyn", 1.0 },
  { "Darrnell", 1.0 },
  { "Darro", 1.0 },
  { "Darrol", 1.0 },
  { "Darrold", 1.0 },
  { "Darroll", 1.0 },
  { "Darron", 0.9991715 },
  { "Darrow", 1.0 },
  { "Darrus", 1.0 },
  { "Darry", 1.0 },
  { "Darryal", 1.0 },
  { "Darryan", 0.44117647 },
  { "Darryel", 1.0 },
  { "Darryell", 1.0 },
  { "Darryl", 0.9877311 },
  { "Darryle", 1.0 },
  { "Darrylin", 0.0 },
  { "Darryll", 1.0 },
  { "Darryn", 0.9765343 },
  { "Darryon", 1.0 },
  { "Darryus", 1.0 },
  { "Darsey", 0.0 },
  { "Darsh", 1.0 },
  { "Darsha", 0.0 },
  { "Darshae", 0.0 },
  { "Darshan", 0.98333335 },
  { "Darshana", 0.0 },
  { "Darshanna", 0.0 },
  { "Darshaun", 1.0 },
  { "Darshawn", 1.0 },
  { "Darshay", 0.0 },
  { "Darshea", 0.0 },
  { "Darshell", 0.0 },
  { "Darshelle", 0.0 },
  { "Darshi", 0.0 },
  { "Darshik", 1.0 },
  { "Darshil", 1.0 },
  { "Darshini", 0.0 },
  { "Darshon", 1.0 },
  { "Darsi", 0.0 },
  { "Darsie", 0.0 },
  { "Darson", 1.0 },
  { "Darsy", 0.0 },
  { "Dart", 1.0 },
  { "Dartagnan", 1.0 },
  { "Dartagnon", 1.0 },
  { "Dartanian", 1.0 },
  { "Dartanion", 1.0 },
  { "Dartanya", 0.0 },
  { "Dartanyan", 1.0 },
  { "Dartanyon", 1.0 },
  { "Dartavious", 1.0 },
  { "Dartavius", 1.0 },
  { "Dartez", 1.0 },
  { "Darth", 1.0 },
  { "Dartha", 0.0 },
  { "Darthea", 0.0 },
  { "Darthie", 0.0 },
  { "Darthula", 0.0 },
  { "Darthy", 0.0 },
  { "Dartisha", 0.0 },
  { "Dartrell", 1.0 },
  { "Daruis", 1.0 },
  { "Darus", 1.0 },
  { "Darvel", 1.0 },
  { "Darvell", 1.0 },
  { "Darvens", 1.0 },
  { "Darvi", 0.0 },
  { "Darvin", 1.0 },
  { "Darvis", 1.0 },
  { "Darvon", 1.0 },
  { "Darweshi", 1.0 },
  { "Darwin", 0.9968241 },
  { "Darwing", 1.0 },
  { "Darwood", 1.0 },
  { "Darwuin", 1.0 },
  { "Darwyn", 1.0 },
  { "Dary", 0.85276073 },
  { "Darya", 0.0 },
  { "Daryah", 0.0 },
  { "Daryal", 1.0 },
  { "Daryan", 0.63172805 },
  { "Daryana", 0.0 },
  { "Daryann", 0.0 },
  { "Daryanna", 0.0 },
  { "Daryel", 1.0 },
  { "Daryell", 1.0 },
  { "Daryen", 0.7307692 },
  { "Daryiah", 0.0 },
  { "Daryian", 0.3529412 },
  { "Daryk", 1.0 },
  { "Daryl", 0.9338117 },
  { "Daryla", 0.0 },
  { "Darylann", 0.0 },
  { "Daryle", 0.93003535 },
  { "Darylene", 0.0 },
  { "Daryll", 0.989905 },
  { "Darylle", 1.0 },
  { "Daryn", 0.7160187 },
  { "Daryna", 0.0 },
  { "Darynne", 0.0 },
  { "Daryon", 1.0 },
  { "Daryus", 1.0 },
  { "Darzell", 1.0 },
  { "Dasa", 0.0 },
  { "Dasaan", 1.0 },
  { "Dasael", 1.0 },
  { "Dasai", 1.0 },
  { "Dasan", 1.0 },
  { "Dasani", 0.26450115 },
  { "Dasanii", 0.0 },
  { "Dasany", 0.0 },
  { "Dasaun", 1.0 },
  { "Dascha", 0.0 },
  { "Daschel", 1.0 },
  { "Daschle", 1.0 },
  { "Dasean", 1.0 },
  { "Dasen", 1.0 },
  { "Dash", 0.9787353 },
  { "Dasha", 0.0 },
  { "Dashaan", 1.0 },
  { "Dashad", 1.0 },
  { "Dashae", 0.02016129 },
  { "Dashai", 0.0 },
  { "Dashal", 1.0 },
  { "Dashall", 1.0 },
  { "Dashan", 0.95348835 },
  { "Dashana", 0.0 },
  { "Dashanae", 0.0 },
  { "Dashanay", 0.0 },
  { "Dashanda", 0.0 },
  { "Dashane", 0.6666667 },
  { "Dashani", 0.0 },
  { "Dashanique", 0.0 },
  { "Dashanna", 0.0 },
  { "Dashanta", 0.0 },
  { "Dashanti", 0.0 },
  { "Dashara", 0.0 },
  { "Dashari", 0.0 },
  { "Dasharia", 0.0 },
  { "Dashaun", 0.98811734 },
  { "Dashauna", 0.0 },
  { "Dashawn", 0.9382279 },
  { "Dashawna", 0.0 },
  { "Dashawnda", 0.0 },
  { "Dashawnna", 0.0 },
  { "Dashay", 0.0754717 },
  { "Dashaya", 0.0 },
  { "Dashayla", 0.0 },
  { "Dashea", 0.0 },
  { "Dasheem", 1.0 },
  { "Dasheena", 0.0 },
  { "Dasheika", 0.0 },
  { "Dashel", 0.98678416 },
  { "Dashell", 0.38961038 },
  { "Dashelle", 0.0 },
  { "Dashia", 0.0 },
  { "Dashiah", 0.0 },
  { "Dashiel", 1.0 },
  { "Dashiell", 0.99459726 },
  { "Dashima", 0.0 },
  { "Dashira", 0.0 },
  { "Dashiya", 0.0 },
  { "Dashiyah", 0.0 },
  { "Dashley", 0.0 },
  { "Dashly", 0.0 },
  { "Dashna", 0.0 },
  { "Dashon", 0.9782609 },
  { "Dashona", 0.0 },
  { "Dashonda", 0.0 },
  { "Dashone", 1.0 },
  { "Dashonna", 0.0 },
  { "Dashonte", 0.0 },
  { "Dashown", 1.0 },
  { "Dashton", 1.0 },
  { "Dashuan", 1.0 },
  { "Dashun", 1.0 },
  { "Dashya", 0.0 },
  { "Dashyia", 0.0 },
  { "Dashyra", 0.0 },
  { "Dasia", 0.0 },
  { "Dasiah", 0.0 },
  { "Dasian", 1.0 },
  { "Dasianae", 0.0 },
  { "Dasie", 0.0 },
  { "Dasir", 1.0 },
  { "Dasiya", 0.0 },
  { "Dasiyah", 0.0 },
  { "Dasja", 0.0 },
  { "Dasjah", 0.0 },
  { "Dasjia", 0.0 },
  { "Dasmine", 0.41379312 },
  { "Dasmon", 1.0 },
  { "Dasmond", 1.0 },
  { "Dason", 1.0 },
  { "Dassie", 0.0 },
  { "Dassy", 0.0 },
  { "Dastan", 1.0 },
  { "Dastyn", 1.0 },
  { "Dasya", 0.0 },
  { "Dat", 1.0 },
  { "Datari", 1.0 },
  { "Datavia", 0.0 },
  { "Datavian", 1.0 },
  { "Datavion", 1.0 },
  { "Datavious", 1.0 },
  { "Datavius", 1.0 },
  { "Datha", 0.0 },
  { "Dathan", 1.0 },
  { "Dathel", 0.0 },
  { "Dathen", 1.0 },
  { "Dathol", 0.0 },
  { "Dathon", 1.0 },
  { "Datia", 0.0 },
  { "Datid", 1.0 },
  { "Daton", 1.0 },
  { "Datra", 0.0 },
  { "Datrell", 1.0 },
  { "Datreon", 1.0 },
  { "Datrice", 0.0 },
  { "Datrick", 1.0 },
  { "Datril", 0.54545456 },
  { "Datrion", 1.0 },
  { "Datron", 1.0 },
  { "Datwan", 1.0 },
  { "Datwon", 1.0 },
  { "Daud", 1.0 },
  { "Dauda", 1.0 },
  { "Daudi", 1.0 },
  { "Daughn", 0.0 },
  { "Daughtry", 1.0 },
  { "Daulton", 1.0 },
  { "Daun", 0.03354037 },
  { "Dauna", 0.0 },
  { "Daundra", 0.0 },
  { "Daundre", 1.0 },
  { "Daune", 0.22695035 },
  { "Daunta", 1.0 },
  { "Dauntae", 1.0 },
  { "Dauntay", 1.0 },
  { "Daunte", 1.0 },
  { "Dauphine", 0.0 },
  { "Daureen", 0.0 },
  { "Dauri", 0.0 },
  { "Daurice", 0.055555556 },
  { "Daury", 1.0 },
  { "Dausen", 1.0 },
  { "Dauson", 1.0 },
  { "Dav", 1.0 },
  { "Dava", 0.0 },
  { "Davada", 0.0 },
  { "Davae", 0.09615385 },
  { "Davaeh", 0.0 },
  { "Davahn", 1.0 },
  { "Davalyn", 0.0 },
  { "Davan", 0.76 },
  { "Davana", 0.0 },
  { "Davanee", 0.0 },
  { "Davaney", 0.0 },
  { "Davani", 0.0 },
  { "Davanie", 0.0 },
  { "Davanna", 0.0 },
  { "Davant", 1.0 },
  { "Davanta", 1.0 },
  { "Davantae", 1.0 },
  { "Davantay", 1.0 },
  { "Davante", 1.0 },
  { "Davany", 0.0 },
  { "Davar", 1.0 },
  { "Davares", 1.0 },
  { "Davari", 1.0 },
  { "Davaria", 0.0 },
  { "Davarian", 1.0 },
  { "Davario", 1.0 },
  { "Davarion", 1.0 },
  { "Davarious", 1.0 },
  { "Davaris", 1.0 },
  { "Davarius", 1.0 },
  { "Davarous", 1.0 },
  { "Davarrio", 1.0 },
  { "Davarus", 1.0 },
  { "Davasha", 0.0 },
  { "Davasia", 0.0 },
  { "Davaughn", 1.0 },
  { "Davaun", 1.0 },
  { "Davaunte", 1.0 },
  { "Davaya", 0.0 },
  { "Davayah", 0.0 },
  { "Davd", 1.0 },
  { "Dave", 0.99821544 },
  { "Daveah", 0.0 },
  { "Davean", 1.0 },
  { "Daved", 1.0 },
  { "Daveda", 0.0 },
  { "Davee", 0.52380955 },
  { "Daveed", 1.0 },
  { "Daveen", 0.0 },
  { "Daveena", 0.0 },
  { "Daveigh", 0.0 },
  { "Davein", 1.0 },
  { "Daveion", 1.0 },
  { "Daveisha", 0.0 },
  { "Davel", 1.0 },
  { "Davell", 1.0 },
  { "Davelle", 0.95 },
  { "Davelyn", 0.0 },
  { "Daven", 0.9607843 },
  { "Davena", 0.0 },
  { "Davene", 0.020920502 },
  { "Daveney", 0.0 },
  { "Davenia", 0.0 },
  { "Davens", 1.0 },
  { "Daveon", 0.993361 },
  { "Daveona", 0.0 },
  { "Daveonna", 0.0 },
  { "Daveontae", 1.0 },
  { "Daveonte", 1.0 },
  { "Davesha", 0.0 },
  { "Daveta", 0.0 },
  { "Davetta", 0.0 },
  { "Davette", 0.0 },
  { "Davey", 0.97882426 },
  { "Daveya", 0.0 },
  { "Daveyon", 1.0 },
  { "Davi", 0.6931524 },
  { "Davia", 0.0 },
  { "Daviah", 0.0 },
  { "Davian", 0.98020977 },
  { "Daviana", 0.0 },
  { "Davianna", 0.0 },
  { "Daviante", 1.0 },
  { "Daviaun", 1.0 },
  { "David", 0.99643487 },
  { "Davida", 0.0012575453 },
  { "Davidalexander", 1.0 },
  { "Davidallen", 1.0 },
  { "Davidanthony", 1.0 },
  { "Davidchristophe", 1.0 },
  { "Davide", 1.0 },
  { "Davidjames", 1.0 },
  { "Davidjeremiah", 1.0 },
  { "Davidjohn", 1.0 },
  { "Davidjoseph", 1.0 },
  { "Davidjr", 1.0 },
  { "Davidlee", 1.0 },
  { "Davidmichael", 1.0 },
  { "Davidpaul", 1.0 },
  { "Davidson", 1.0 },
  { "Davie", 0.80986273 },
  { "Davied", 1.0 },
  { "Daviel", 1.0 },
  { "Davielle", 0.0 },
  { "Davien", 1.0 },
  { "Davieon", 1.0 },
  { "Davier", 1.0 },
  { "Daviere", 1.0 },
  { "Davies", 1.0 },
  { "Daviette", 0.0 },
  { "Davika", 0.0 },
  { "Davilyn", 0.0 },
  { "Davin", 0.966185 },
  { "Davina", 0.0 },
  { "Davinah", 0.0 },
  { "Davinci", 1.0 },
  { "Davinder", 1.0 },
  { "Davindra", 1.0 },
  { "Davine", 0.22966507 },
  { "Davinee", 0.0 },
  { "Daviney", 0.0 },
  { "Davinia", 0.0 },
  { "Davinity", 0.0 },
  { "Davinna", 0.0 },
  { "Davio", 1.0 },
  { "Davion", 0.98110074 },
  { "Daviona", 0.0 },
  { "Davione", 0.9578544 },
  { "Davionn", 1.0 },
  { "Davionna", 0.0 },
  { "Davionne", 0.71308017 },
  { "Davionta", 1.0 },
  { "Daviontae", 1.0 },
  { "Davionte", 1.0 },
  { "Davious", 1.0 },
  { "Davis", 0.97196424 },
  { "Davisha", 0.0 },
  { "Davison", 1.0 },
  { "Davit", 1.0 },
  { "Davita", 0.0 },
  { "Davius", 1.0 },
  { "Daviya", 0.0 },
  { "Daviyah", 0.0 },
  { "Daviyana", 0.0 },
  { "Daviyon", 1.0 },
  { "Davlyn", 0.0 },
  { "Davlynn", 0.0 },
  { "Davod", 1.0 },
  { "Davohn", 1.0 },
  { "Davon", 0.97101104 },
  { "Davona", 0.0 },
  { "Davonda", 0.0 },
  { "Davondre", 1.0 },
  { "Davone", 0.9734982 },
  { "Davonia", 0.0 },
  { "Davonn", 1.0 },
  { "Davonna", 0.0 },
  { "Davonne", 0.66211605 },
  { "Davonta", 1.0 },
  { "Davontae", 1.0 },
  { "Davontai", 1.0 },
  { "Davontay", 1.0 },
  { "Davontaye", 1.0 },
  { "Davonte", 0.9988238 },
  { "Davontea", 1.0 },
  { "Davontre", 1.0 },
  { "Davonya", 0.0 },
  { "Davor", 1.0 },
  { "Davron", 1.0 },
  { "Davuan", 1.0 },
  { "Davud", 1.0 },
  { "Davvid", 1.0 },
  { "Davy", 0.94408274 },
  { "Davyan", 1.0 },
  { "Davyd", 1.0 },
  { "Davyen", 1.0 },
  { "Davyeon", 1.0 },
  { "Davyion", 1.0 },
  { "Davyn", 0.8827586 },
  { "Davyne", 0.0 },
  { "Davynn", 0.0 },
  { "Davyon", 1.0 },
  { "Dawain", 1.0 },
  { "Dawan", 0.9576271 },
  { "Dawana", 0.0 },
  { "Dawanda", 0.0 },
  { "Dawane", 1.0 },
  { "Dawann", 1.0 },
  { "Dawanna", 0.0 },
  { "Dawaun", 1.0 },
  { "Dawayne", 1.0 },
  { "Dawens", 1.0 },
  { "Dawes", 1.0 },
  { "Dawid", 1.0 },
  { "Dawin", 1.0 },
  { "Dawit", 1.0 },
  { "Dawlton", 1.0 },
  { "Dawm", 0.0 },
  { "Dawn", 0.0035677564 },
  { "Dawna", 0.0 },
  { "Dawnae", 0.0 },
  { "Dawnda", 0.0 },
  { "Dawndee", 0.0 },
  { "Dawndi", 0.0 },
  { "Dawndra", 0.0 },
  { "Dawndria", 0.0 },
  { "Dawne", 0.0 },
  { "Dawnee", 0.0 },
  { "Dawneen", 0.0 },
  { "Dawneisha", 0.0 },
  { "Dawnel", 0.0 },
  { "Dawnell", 0.0 },
  { "Dawnella", 0.0 },
  { "Dawnelle", 0.0 },
  { "Dawnene", 0.0 },
  { "Dawnesha", 0.0 },
  { "Dawnett", 0.0 },
  { "Dawnetta", 0.0 },
  { "Dawnette", 0.0 },
  { "Dawni", 0.0 },
  { "Dawnica", 0.0 },
  { "Dawnie", 0.0 },
  { "Dawniel", 0.0 },
  { "Dawnielle", 0.0 },
  { "Dawnisha", 0.0 },
  { "Dawnita", 0.0 },
  { "Dawnmarie", 0.0 },
  { "Dawnn", 0.0 },
  { "Dawnna", 0.0 },
  { "Dawnne", 0.0 },
  { "Dawnta", 0.0 },
  { "Dawnte", 0.45454547 },
  { "Dawny", 0.0 },
  { "Dawnya", 0.0 },
  { "Dawnyel", 0.0 },
  { "Dawnyell", 0.0 },
  { "Dawnyelle", 0.0 },
  { "Dawon", 1.0 },
  { "Dawone", 1.0 },
  { "Dawood", 1.0 },
  { "Dawoud", 1.0 },
  { "Dawsen", 0.9863388 },
  { "Dawson", 0.9818685 },
  { "Dawsyn", 0.49119717 },
  { "Dawsynn", 0.0 },
  { "Dawt", 0.0 },
  { "Dawton", 1.0 },
  { "Dawuan", 1.0 },
  { "Dawud", 1.0 },
  { "Dawyn", 0.0 },
  { "Dawyne", 1.0 },
  { "Dax", 0.9983095 },
  { "Daxel", 1.0 },
  { "Daxen", 1.0 },
  { "Daxia", 0.0 },
  { "Daxin", 1.0 },
  { "Daxon", 1.0 },
  { "Daxson", 1.0 },
  { "Daxston", 1.0 },
  { "Daxten", 1.0 },
  { "Daxter", 1.0 },
  { "Daxtin", 1.0 },
  { "Daxton", 1.0 },
  { "Daxtyn", 1.0 },
  { "Daxx", 1.0 },
  { "Daxxon", 1.0 },
  { "Daxxton", 1.0 },
  { "Daxyn", 1.0 },
  { "Day", 0.4797048 },
  { "Daya", 0.0 },
  { "Dayah", 0.0 },
  { "Dayahna", 0.0 },
  { "Dayami", 0.0 },
  { "Dayamin", 0.0 },
  { "Dayamir", 0.0 },
  { "Dayamit", 0.0 },
  { "Dayamy", 0.0 },
  { "Dayan", 0.6238185 },
  { "Dayana", 0.0 },
  { "Dayanah", 0.0 },
  { "Dayanaira", 0.0 },
  { "Dayanara", 0.0 },
  { "Dayanari", 0.0 },
  { "Dayane", 0.0 },
  { "Dayanera", 0.0 },
  { "Dayani", 0.0 },
  { "Dayanie", 0.0 },
  { "Dayanira", 0.0 },
  { "Dayanis", 0.0 },
  { "Dayann", 0.0 },
  { "Dayanna", 0.0 },
  { "Dayannara", 0.0 },
  { "Dayanne", 0.0 },
  { "Dayanni", 0.0 },
  { "Dayany", 0.0 },
  { "Dayari", 0.0 },
  { "Dayasia", 0.0 },
  { "Dayatra", 0.0 },
  { "Daycee", 0.0 },
  { "Daycen", 1.0 },
  { "Dayceon", 1.0 },
  { "Daycia", 0.0 },
  { "Dayde", 1.0 },
  { "Dayden", 1.0 },
  { "Daydra", 0.0 },
  { "Daydrian", 1.0 },
  { "Daye", 0.0 },
  { "Dayeli", 0.0 },
  { "Dayelin", 0.0 },
  { "Dayesha", 0.0 },
  { "Daygan", 1.0 },
  { "Daygen", 1.0 },
  { "Daygoro", 1.0 },
  { "Dayiana", 0.0 },
  { "Dayion", 1.0 },
  { "Dayja", 0.0 },
  { "Dayjah", 0.0 },
  { "Dayjon", 1.0 },
  { "Daykota", 1.0 },
  { "Dayl", 0.25 },
  { "Dayla", 0.0 },
  { "Daylah", 0.0 },
  { "Daylan", 0.96368355 },
  { "Dayland", 1.0 },
  { "Daylani", 0.0 },
  { "Daylanie", 0.0 },
  { "Daylany", 0.0 },
  { "Dayle", 0.3451515 },
  { "Daylee", 0.016574586 },
  { "Dayleen", 0.0 },
  { "Dayleigh", 0.0 },
  { "Daylen", 0.91413116 },
  { "Daylene", 0.0 },
  { "Dayleon", 1.0 },
  { "Dayli", 0.0 },
  { "Daylia", 0.0 },
  { "Daylie", 0.0 },
  { "Daylin", 0.5710121 },
  { "Dayline", 0.0 },
  { "Daylinn", 0.0 },
  { "Dayln", 0.9325843 },
  { "Daylon", 0.99632895 },
  { "Daylyn", 0.46882793 },
  { "Daylynn", 0.09034268 },
  { "Dayman", 1.0 },
  { "Daymar", 1.0 },
  { "Daymein", 1.0 },
  { "Daymen", 1.0 },
  { "Daymeon", 1.0 },
  { "Daymi", 0.0 },
  { "Daymian", 1.0 },
  { "Daymien", 1.0 },
  { "Daymin", 1.0 },
  { "Daymion", 1.0 },
  { "Daymon", 1.0 },
  { "Daymond", 1.0 },
  { "Dayn", 1.0 },
  { "Dayna", 0.006104835 },
  { "Daynah", 0.0 },
  { "Dayne", 0.949232 },
  { "Daynesha", 0.0 },
  { "Daynisha", 0.0 },
  { "Daynna", 0.0 },
  { "Dayo", 0.0 },
  { "Dayon", 0.9833837 },
  { "Dayona", 0.0 },
  { "Dayonna", 0.0 },
  { "Dayonte", 1.0 },
  { "Dayquan", 1.0 },
  { "Dayquon", 1.0 },
  { "Dayqwan", 1.0 },
  { "Dayra", 0.0 },
  { "Dayren", 1.0 },
  { "Dayri", 0.0 },
  { "Dayrin", 0.0 },
  { "Dayris", 0.0 },
  { "Dayro", 1.0 },
  { "Dayron", 1.0 },
  { "Daysan", 1.0 },
  { "Dayse", 0.0 },
  { "Daysean", 1.0 },
  { "Daysen", 1.0 },
  { "Daysha", 0.0 },
  { "Dayshana", 0.0 },
  { "Dayshanay", 0.0 },
  { "Dayshaun", 1.0 },
  { "Dayshawn", 0.99597096 },
  { "Dayshawna", 0.0 },
  { "Dayshia", 0.0 },
  { "Dayshon", 1.0 },
  { "Dayshun", 1.0 },
  { "Daysi", 0.0 },
  { "Daysia", 0.0 },
  { "Daysie", 0.0 },
  { "Dayson", 1.0 },
  { "Daysun", 1.0 },
  { "Daysy", 0.0 },
  { "Dayten", 1.0 },
  { "Daythan", 1.0 },
  { "Daytin", 1.0 },
  { "Dayton", 0.96559924 },
  { "Daytona", 0.25707546 },
  { "Daytron", 1.0 },
  { "Daytwan", 1.0 },
  { "Daytwon", 1.0 },
  { "Dayva", 0.0 },
  { "Dayvanee", 0.0 },
  { "Dayveion", 1.0 },
  { "Dayven", 1.0 },
  { "Dayveon", 1.0 },
  { "Dayvian", 1.0 },
  { "Dayvid", 1.0 },
  { "Dayvien", 1.0 },
  { "Dayvin", 1.0 },
  { "Dayvion", 1.0 },
  { "Dayvon", 1.0 },
  { "Dayvonna", 0.0 },
  { "Dayvonne", 1.0 },
  { "Dayyan", 1.0 },
  { "Dayza", 0.0 },
  { "Dayzah", 0.0 },
  { "Dayzee", 0.0 },
  { "Dayzha", 0.0 },
  { "Dayzhane", 0.0 },
  { "Dayzi", 0.0 },
  { "Dayzia", 0.0 },
  { "Dayzie", 0.0 },
  { "Daz", 1.0 },
  { "Dazah", 0.0 },
  { "Dazani", 0.0 },
  { "Dazaria", 0.0 },
  { "Dazariah", 0.0 },
  { "Dazarion", 1.0 },
  { "Dazavion", 1.0 },
  { "Dazay", 0.0 },
  { "Dazaya", 0.0 },
  { "Dazha", 0.0 },
  { "Dazhan", 1.0 },
  { "Dazhanae", 0.0 },
  { "Dazhane", 0.0 },
  { "Dazhaun", 1.0 },
  { "Dazhia", 0.0 },
  { "Dazhon", 1.0 },
  { "Dazia", 0.0 },
  { "Daziah", 0.0 },
  { "Dazie", 0.0 },
  { "Daziel", 1.0 },
  { "Dazion", 1.0 },
  { "Dazire", 0.0 },
  { "Daziya", 0.0 },
  { "Daziyah", 0.0 },
  { "Dazja", 0.0 },
  { "Dazjah", 0.0 },
  { "Dazlyn", 0.0 },
  { "Dazlynn", 0.0 },
  { "Dazmine", 0.0 },
  { "Dazmon", 1.0 },
  { "Dazmond", 1.0 },
  { "Dazon", 1.0 },
  { "Dazsha", 0.0 },
  { "Dazya", 0.0 },
  { "Dazza", 0.0 },
  { "Dazzlyn", 0.0 },
  { "Dcarlo", 1.0 },
  { "Dcarlos", 1.0 },
  { "Dcorian", 1.0 },
  { "Ddnald", 1.0 },
  { "Ddnna", 0.0 },
  { "De", 0.5151286 },
  { "Dea", 0.010059171 },
  { "Deaaron", 1.0 },
  { "Deacan", 1.0 },
  { "Deacon", 1.0 },
  { "Deadra", 0.0 },
  { "Deadre", 0.0 },
  { "Deadria", 0.0 },
  { "Deadrian", 1.0 },
  { "Deadrick", 1.0 },
  { "Deagan", 1.0 },
  { "Deagen", 1.0 },
  { "Deaglan", 1.0 },
  { "Deago", 1.0 },
  { "Deagon", 1.0 },
  { "Deah", 0.0 },
  { "Deahna", 0.0 },
  { "Deaija", 0.0 },
  { "Deaijah", 0.0 },
  { "Deair", 1.0 },
  { "Deaira", 0.0 },
  { "Deairah", 0.0 },
  { "Deaire", 1.0 },
  { "Deaires", 1.0 },
  { "Deairra", 0.0 },
  { "Deaisa", 0.0 },
  { "Deaisha", 0.0 },
  { "Deaja", 0.0 },
  { "Deajah", 0.0 },
  { "Deajanae", 0.0 },
  { "Deajane", 0.0 },
  { "Deajha", 0.0 },
  { "Deajia", 0.0 },
  { "Deajon", 1.0 },
  { "Deaken", 1.0 },
  { "Deakin", 1.0 },
  { "Deakon", 1.0 },
  { "Deakyn", 1.0 },
  { "Deal", 1.0 },
  { "Dealia", 0.0 },
  { "Dealie", 0.0 },
  { "Deallen", 1.0 },
  { "Dealva", 0.0 },
  { "Deamber", 0.0 },
  { "Deambra", 0.0 },
  { "Deamontae", 1.0 },
  { "Deamonte", 1.0 },
  { "Dean", 0.9835261 },
  { "Deana", 0.0006001886 },
  { "Deanah", 0.0 },
  { "Deanca", 0.0 },
  { "Deanda", 0.0 },
  { "Deandra", 0.14834298 },
  { "Deandrae", 1.0 },
  { "Deandray", 1.0 },
  { "Deandre", 0.9835229 },
  { "Deandrea", 0.24340075 },
  { "Deandres", 1.0 },
  { "Deandrew", 1.0 },
  { "Deandrey", 1.0 },
  { "Deandria", 0.0 },
  { "Deandrick", 1.0 },
  { "Deane", 0.6757832 },
  { "Deaneen", 0.0 },
  { "Deanesha", 0.0 },
  { "Deanette", 0.0 },
  { "Deangalo", 1.0 },
  { "Deangel", 0.0 },
  { "Deangela", 0.0 },
  { "Deangelia", 0.0 },
  { "Deangelio", 1.0 },
  { "Deangelis", 0.0 },
  { "Deangello", 1.0 },
  { "Deangelo", 0.9980841 },
  { "Deangilo", 1.0 },
  { "Deangleo", 1.0 },
  { "Deanglo", 1.0 },
  { "Deani", 0.0 },
  { "Deania", 0.0 },
  { "Deanie", 0.02670227 },
  { "Deanine", 0.0 },
  { "Deanise", 0.0 },
  { "Deanjelo", 1.0 },
  { "Deann", 0.0 },
  { "Deanna", 0.0019893353 },
  { "Deannah", 0.0 },
  { "Deanndra", 0.0 },
  { "Deanne", 0.00033708624 },
  { "Deannea", 0.0 },
  { "Deannette", 0.0 },
  { "Deannia", 0.0 },
  { "Deannie", 0.0 },
  { "Deano", 1.0 },
  { "Deanta", 1.0 },
  { "Deantae", 1.0 },
  { "Deantay", 1.0 },
  { "Deante", 0.9980292 },
  { "Deanthony", 1.0 },
  { "Deantoine", 1.0 },
  { "Deantonio", 1.0 },
  { "Deantony", 1.0 },
  { "Deantrae", 1.0 },
  { "Deantre", 1.0 },
  { "Deantwan", 1.0 },
  { "Deantwon", 1.0 },
  { "Deanza", 0.0 },
  { "Deaquan", 1.0 },
  { "Deara", 0.0 },
  { "Deardra", 0.0 },
  { "Deareon", 1.0 },
  { "Deari", 0.083333336 },
  { "Dearia", 0.0 },
  { "Deariah", 0.0 },
  { "Dearie", 0.0 },
  { "Dearies", 1.0 },
  { "Dearion", 0.925 },
  { "Dearious", 1.0 },
  { "Dearis", 1.0 },
  { "Dearius", 1.0 },
  { "Dearl", 1.0 },
  { "Dearld", 1.0 },
  { "Dearmond", 1.0 },
  { "Dearon", 1.0 },
  { "Dearra", 0.0 },
  { "Dearria", 0.0 },
  { "Dearrius", 1.0 },
  { "Dearron", 1.0 },
  { "Deasha", 0.0 },
  { "Deashawn", 1.0 },
  { "Deashia", 0.0 },
  { "Deashley", 0.0 },
  { "Deasia", 0.0 },
  { "Deasiah", 0.0 },
  { "Deasja", 0.0 },
  { "Deason", 1.0 },
  { "Deasya", 0.0 },
  { "Deaton", 1.0 },
  { "Deatra", 0.0 },
  { "Deatria", 0.0 },
  { "Deatrice", 0.0 },
  { "Deatrick", 1.0 },
  { "Deatta", 0.0 },
  { "Deaudra", 0.0 },
  { "Deaudre", 1.0 },
  { "Deaun", 0.0 },
  { "Deauna", 0.0 },
  { "Deaundra", 0.2739726 },
  { "Deaundray", 1.0 },
  { "Deaundre", 1.0 },
  { "Deaundrea", 0.15384616 },
  { "Deaundrey", 1.0 },
  { "Deaundria", 0.0 },
  { "Deaunna", 0.0 },
  { "Deaunta", 1.0 },
  { "Deauntae", 1.0 },
  { "Deaunte", 1.0 },
  { "Deauntre", 1.0 },
  { "Deautre", 1.0 },
  { "Deavan", 1.0 },
  { "Deavante", 1.0 },
  { "Deaven", 0.75697213 },
  { "Deaveon", 0.6969697 },
  { "Deavian", 0.0 },
  { "Deavin", 0.9621212 },
  { "Deavion", 0.63721806 },
  { "Deavionne", 0.0 },
  { "Deavon", 0.93363845 },
  { "Deavonte", 1.0 },
  { "Deavyn", 0.0 },
  { "Deawn", 0.0 },
  { "Deayra", 0.0 },
  { "Deaysha", 0.0 },
  { "Deaysia", 0.0 },
  { "Deazia", 0.0 },
  { "Deb", 0.0 },
  { "Deba", 0.0 },
  { "Debanhi", 0.0 },
  { "Debanhy", 0.0 },
  { "Debany", 0.0 },
  { "Debar", 0.0 },
  { "Debara", 0.0 },
  { "Debarah", 0.0 },
  { "Debarh", 0.0 },
  { "Debaroh", 0.0 },
  { "Debb", 0.0 },
  { "Debbe", 0.0 },
  { "Debbee", 0.0 },
  { "Debbera", 0.0 },
  { "Debbey", 0.0 },
  { "Debbi", 0.0 },
  { "Debbie", 0.002307774 },
  { "Debbora", 0.0 },
  { "Debborah", 0.0 },
  { "Debborrah", 0.0 },
  { "Debbra", 0.0 },
  { "Debbrah", 0.0 },
  { "Debby", 0.0 },
  { "Debbye", 0.0 },
  { "Debe", 0.0 },
  { "Debera", 0.0 },
  { "Deberah", 0.0 },
  { "Debhora", 0.0 },
  { "Debhra", 0.0 },
  { "Debi", 0.0 },
  { "Debie", 0.0 },
  { "Deboah", 0.0 },
  { "Deboarh", 0.0 },
  { "Debony", 0.0 },
  { "Debooah", 0.0 },
  { "Debor", 0.0 },
  { "Debora", 0.00095322396 },
  { "Deboraa", 0.0 },
  { "Deboraah", 0.0 },
  { "Deborah", 0.0022355046 },
  { "Deboraha", 0.0 },
  { "Deborahann", 0.0 },
  { "Deborahh", 0.0 },
  { "Deboral", 0.0 },
  { "Deboran", 0.0 },
  { "Deborh", 0.0 },
  { "Deborha", 0.0 },
  { "Deboria", 0.0 },
  { "Deboris", 1.0 },
  { "Deboroh", 0.0 },
  { "Deborra", 0.0 },
  { "Deborrah", 0.0 },
  { "Debr", 0.0 },
  { "Debra", 0.0020782102 },
  { "Debraa", 0.0 },
  { "Debraann", 0.0 },
  { "Debraca", 0.0 },
  { "Debrah", 0.0 },
  { "Debraha", 0.0 },
  { "Debrajo", 0.0 },
  { "Debralee", 0.0 },
  { "Debralyn", 0.0 },
  { "Debrann", 0.0 },
  { "Debraoh", 0.0 },
  { "Debrea", 0.0 },
  { "Debrha", 0.0 },
  { "Debria", 0.0 },
  { "Debriana", 0.0 },
  { "Debrianna", 0.0 },
  { "Debrina", 0.0 },
  { "Debrisha", 0.0 },
  { "Debro", 0.0 },
  { "Debroa", 0.0 },
  { "Debroah", 0.0 },
  { "Debroh", 0.0 },
  { "Debroha", 0.0 },
  { "Debron", 1.0 },
  { "Debrorah", 0.0 },
  { "Debrra", 0.0 },
  { "Debs", 1.0 },
  { "Deby", 0.0 },
  { "Decameron", 1.0 },
  { "Decan", 1.0 },
  { "Decara", 0.0 },
  { "Decari", 1.0 },
  { "Decario", 1.0 },
  { "Decarion", 1.0 },
  { "Decarius", 1.0 },
  { "Decarla", 0.0 },
  { "Decarlo", 1.0 },
  { "Decarlos", 1.0 },
  { "Decarri", 1.0 },
  { "Decarter", 1.0 },
  { "Decatur", 1.0 },
  { "Decca", 0.0 },
  { "Decedric", 1.0 },
  { "December", 0.0045011253 },
  { "Dechane", 1.0 },
  { "Dechanel", 0.0 },
  { "Dechaun", 1.0 },
  { "Dechelle", 0.0 },
  { "Dechen", 0.0 },
  { "Dechlan", 1.0 },
  { "Decia", 0.0 },
  { "Deciderio", 1.0 },
  { "Decie", 0.0 },
  { "Decima", 0.0 },
  { "Decimus", 1.0 },
  { "Deckard", 1.0 },
  { "Decker", 0.98519164 },
  { "Decklan", 1.0 },
  { "Decklen", 1.0 },
  { "Decklin", 1.0 },
  { "Decklyn", 0.7091837 },
  { "Declan", 0.99528384 },
  { "Declen", 1.0 },
  { "Declin", 1.0 },
  { "Declyn", 0.6354515 },
  { "Declynn", 0.0 },
  { "Decoda", 1.0 },
  { "Decody", 1.0 },
  { "Decola", 0.0 },
  { "Decole", 0.0 },
  { "Decora", 0.0 },
  { "Decorey", 1.0 },
  { "Decorian", 1.0 },
  { "Decorion", 1.0 },
  { "Decorius", 1.0 },
  { "Decory", 1.0 },
  { "Decota", 0.8780488 },
  { "Dectrick", 1.0 },
  { "Deda", 0.0 },
  { "Dedan", 1.0 },
  { "Deddie", 0.0 },
  { "Deddrick", 1.0 },
  { "Dede", 0.0 },
  { "Dedee", 0.0 },
  { "Dedera", 0.0 },
  { "Dederick", 1.0 },
  { "Dedi", 0.0 },
  { "Dedie", 0.0 },
  { "Dedorah", 0.0 },
  { "Dedra", 0.0 },
  { "Dedrah", 0.0 },
  { "Dedre", 0.0 },
  { "Dedrea", 0.0 },
  { "Dedrek", 1.0 },
  { "Dedria", 0.0 },
  { "Dedrian", 1.0 },
  { "Dedriana", 0.0 },
  { "Dedrianna", 0.0 },
  { "Dedric", 0.98896855 },
  { "Dedrick", 0.996245 },
  { "Dedrie", 0.0 },
  { "Dee", 0.3137 },
  { "Deea", 0.0 },
  { "Deeana", 0.0 },
  { "Deeandra", 0.0 },
  { "Deeandre", 1.0 },
  { "Deeann", 0.0 },
  { "Deeanna", 0.0 },
  { "Deeanne", 0.0 },
  { "Deeasia", 0.0 },
  { "Deeba", 0.0 },
  { "Deeda", 0.0 },
  { "Deeddra", 0.0 },
  { "Deede", 0.0 },
  { "Deedee", 0.0 },
  { "Deedgra", 0.0 },
  { "Deedie", 0.0 },
  { "Deedra", 0.0 },
  { "Deedre", 0.0 },
  { "Deedrick", 1.0 },
  { "Deedy", 0.0 },
  { "Deegan", 0.99517876 },
  { "Deejay", 0.96 },
  { "Deeken", 1.0 },
  { "Deeksha", 0.0 },
  { "Deekshitha", 0.0 },
  { "Deelan", 1.0 },
  { "Deelda", 0.0 },
  { "Deelilah", 0.0 },
  { "Deella", 0.0 },
  { "Deelynn", 0.0 },
  { "Deem", 0.0 },
  { "Deema", 0.0 },
  { "Deemah", 0.0 },
  { "Deems", 1.0 },
  { "Deen", 0.9891068 },
  { "Deena", 0.00037372002 },
  { "Deenah", 0.0 },
  { "Deene", 0.0 },
  { "Deeneen", 0.0 },
  { "Deenie", 0.0 },
  { "Deenna", 0.0 },
  { "Deep", 1.0 },
  { "Deepa", 0.0 },
  { "Deepak", 1.0 },
  { "Deepesh", 1.0 },
  { "Deepika", 0.0 },
  { "Deepshika", 0.0 },
  { "Deepthi", 0.0 },
  { "Deepti", 0.0 },
  { "Deeqa", 0.0 },
  { "Deera", 0.0 },
  { "Deeric", 1.0 },
  { "Deerica", 0.0 },
  { "Deerick", 1.0 },
  { "Deericka", 0.0 },
  { "Deerika", 0.0 },
  { "Deesha", 0.0 },
  { "Deeshawn", 1.0 },
  { "Deethya", 0.0 },
  { "Deetra", 0.0 },
  { "Deett", 0.0 },
  { "Deetta", 0.0 },
  { "Deette", 0.0 },
  { "Deetya", 0.0 },
  { "Deeva", 0.0 },
  { "Deevon", 1.0 },
  { "Deeya", 0.0 },
  { "Defne", 0.0 },
  { "Defonta", 1.0 },
  { "Deforest", 1.0 },
  { "Deforrest", 1.0 },
  { "Degan", 1.0 },
  { "Degen", 1.0 },
  { "Deguan", 1.0 },
  { "Dehaven", 1.0 },
  { "Dehja", 0.0 },
  { "Dehlia", 0.0 },
  { "Dehlila", 0.0 },
  { "Deia", 0.0 },
  { "Deiadra", 0.0 },
  { "Deiah", 0.0 },
  { "Deiana", 0.0 },
  { "Deianeira", 0.0 },
  { "Deianira", 0.0 },
  { "Deianna", 0.0 },
  { "Deiara", 0.0 },
  { "Deiby", 1.0 },
  { "Deici", 0.0 },
  { "Deicy", 0.0 },
  { "Deida", 0.0 },
  { "Deidra", 0.0 },
  { "Deidre", 0.0007502899 },
  { "Deidrea", 0.0 },
  { "Deidree", 0.0 },
  { "Deidri", 0.0 },
  { "Deidria", 0.0 },
  { "Deidrick", 1.0 },
  { "Deighton", 1.0 },
  { "Deigo", 1.0 },
  { "Deija", 0.0 },
  { "Deijah", 0.0 },
  { "Deijon", 1.0 },
  { "Deila", 0.0 },
  { "Deilani", 0.0 },
  { "Deilany", 0.0 },
  { "Deilyn", 0.0 },
  { "Deimos", 1.0 },
  { "Deimy", 0.0 },
  { "Dein", 1.0 },
  { "Deina", 0.0 },
  { "Deion", 0.97646385 },
  { "Deiona", 0.0 },
  { "Deiondra", 0.0 },
  { "Deiondre", 1.0 },
  { "Deione", 1.0 },
  { "Deionna", 0.0 },
  { "Deionta", 1.0 },
  { "Deiontae", 1.0 },
  { "Deiontay", 1.0 },
  { "Deionte", 1.0 },
  { "Deiontre", 1.0 },
  { "Deira", 0.0 },
  { "Deirde", 0.0 },
  { "Deirdra", 0.0 },
  { "Deirdre", 0.0 },
  { "Deirore", 0.0 },
  { "Deirra", 0.0 },
  { "Deise", 0.0 },
  { "Deisel", 1.0 },
  { "Deisha", 0.0 },
  { "Deisi", 0.0 },
  { "Deisree", 0.0 },
  { "Deissy", 0.0 },
  { "Deisy", 0.0 },
  { "Deith", 1.0 },
  { "Deitra", 0.0 },
  { "Deitre", 0.0 },
  { "Deitric", 1.0 },
  { "Deitrich", 1.0 },
  { "Deitrick", 1.0 },
  { "Deiveon", 1.0 },
  { "Deivi", 1.0 },
  { "Deivid", 1.0 },
  { "Deivin", 1.0 },
  { "Deivion", 0.5882353 },
  { "Deivy", 1.0 },
  { "Deizel", 1.0 },
  { "Deja", 0.0054987213 },
  { "Dejaa", 0.0 },
  { "Dejae", 0.0 },
  { "Dejah", 0.0016528926 },
  { "Dejahn", 1.0 },
  { "Dejahna", 0.0 },
  { "Dejahnae", 0.0 },
  { "Dejahnay", 0.0 },
  { "Dejahne", 0.0 },
  { "Dejahnique", 0.0 },
  { "Dejai", 0.0 },
  { "Dejamarie", 0.0 },
  { "Dejan", 0.9597523 },
  { "Dejana", 0.0 },
  { "Dejanae", 0.0 },
  { "Dejanai", 0.0 },
  { "Dejanay", 0.0 },
  { "Dejanaye", 0.0 },
  { "Dejane", 0.0 },
  { "Dejanea", 0.0 },
  { "Dejanee", 0.0 },
  { "Dejaneira", 0.0 },
  { "Dejanelle", 0.0 },
  { "Dejania", 0.0 },
  { "Dejanique", 0.0 },
  { "Dejanira", 0.0 },
  { "Dejanna", 0.0 },
  { "Dejarae", 0.0 },
  { "Dejarvis", 1.0 },
  { "Dejaun", 1.0 },
  { "Dejavion", 1.0 },
  { "Dejay", 1.0 },
  { "Dejean", 1.0 },
  { "Dejenae", 0.0 },
  { "Dejesus", 1.0 },
  { "Dejha", 0.0 },
  { "Dejhana", 0.0 },
  { "Dejhanae", 0.0 },
  { "Dejhon", 1.0 },
  { "Dejia", 0.0 },
  { "Dejiah", 0.0 },
  { "Dejion", 1.0 },
  { "Dejohn", 1.0 },
  { "Dejoire", 0.0 },
  { "Dejon", 0.96898913 },
  { "Dejona", 0.0 },
  { "Dejonae", 0.0 },
  { "Dejone", 0.0 },
  { "Dejonna", 0.0 },
  { "Dejonnae", 0.0 },
  { "Dejontae", 1.0 },
  { "Dejonte", 1.0 },
  { "Dejoun", 1.0 },
  { "Dejour", 0.9414226 },
  { "Dejsha", 0.0 },
  { "Dejuan", 0.99228543 },
  { "Dejuana", 0.0 },
  { "Dejuane", 1.0 },
  { "Dejuante", 1.0 },
  { "Dejun", 1.0 },
  { "Dejuna", 0.0 },
  { "Dekai", 1.0 },
  { "Dekan", 1.0 },
  { "Dekanye", 1.0 },
  { "Dekara", 0.0 },
  { "Dekari", 1.0 },
  { "Dekayden", 1.0 },
  { "Dekayla", 0.0 },
  { "Deke", 1.0 },
  { "Dekeisha", 0.0 },
  { "Dekel", 1.0 },
  { "Deken", 1.0 },
  { "Dekendra", 0.0 },
  { "Dekendrick", 1.0 },
  { "Deker", 1.0 },
  { "Dekesha", 0.0 },
  { "Dekeshia", 0.0 },
  { "Dekevion", 1.0 },
  { "Dekevious", 1.0 },
  { "Dekhari", 1.0 },
  { "Dekia", 0.0 },
  { "Dekin", 1.0 },
  { "Deking", 1.0 },
  { "Dekira", 0.0 },
  { "Dekisha", 0.0 },
  { "Dekita", 0.0 },
  { "Dekiya", 0.0 },
  { "Dekiyah", 0.0 },
  { "Dekker", 1.0 },
  { "Deklan", 1.0 },
  { "Deklen", 1.0 },
  { "Deklin", 1.0 },
  { "Deklyn", 0.81489843 },
  { "Deklynn", 0.0 },
  { "Dekobe", 1.0 },
  { "Dekoda", 0.81666666 },
  { "Dekon", 1.0 },
  { "Dekorion", 1.0 },
  { "Dekota", 0.73 },
  { "Dekotah", 0.0 },
  { "Dekoven", 1.0 },
  { "Dekwan", 1.0 },
  { "Dekwon", 1.0 },
  { "Dekyla", 0.0 },
  { "Dekyra", 0.0 },
  { "Del", 0.86209726 },
  { "Dela", 0.01091703 },
  { "Delacey", 0.0 },
  { "Delacy", 0.2 },
  { "Delaenie", 0.0 },
  { "Delaia", 0.0 },
  { "Delaiah", 0.0 },
  { "Delaila", 0.0 },
  { "Delailah", 0.0 },
  { "Delaili", 0.0 },
  { "Delain", 0.14285715 },
  { "Delaina", 0.0 },
  { "Delainah", 0.0 },
  { "Delaine", 0.093472384 },
  { "Delainee", 0.0 },
  { "Delainey", 0.0 },
  { "Delaini", 0.0 },
  { "Delainie", 0.0 },
  { "Delainy", 0.0 },
  { "Delajah", 0.0 },
  { "Delali", 0.0 },
  { "Delan", 1.0 },
  { "Delana", 0.0 },
  { "Delance", 1.0 },
  { "Delancey", 0.26666668 },
  { "Delancy", 0.23809524 },
  { "Deland", 1.0 },
  { "Delanda", 0.0 },
  { "Delando", 1.0 },
  { "Delandra", 0.0 },
  { "Delandre", 1.0 },
  { "Delandria", 0.0 },
  { "Delane", 0.49490616 },
  { "Delanea", 0.0 },
  { "Delanee", 0.0 },
  { "Delanei", 0.0 },
  { "Delaney", 0.031278305 },
  { "Delani", 0.013623978 },
  { "Delania", 0.0 },
  { "Delanie", 0.0 },
  { "Delann", 0.0 },
  { "Delanna", 0.0 },
  { "Delanne", 0.0 },
  { "Delannie", 0.0 },
  { "Delanny", 0.0 },
  { "Delano", 0.98653775 },
  { "Delanor", 1.0 },
  { "Delanta", 1.0 },
  { "Delantae", 1.0 },
  { "Delante", 1.0 },
  { "Delany", 0.0 },
  { "Delanya", 0.0 },
  { "Delaphine", 0.0 },
  { "Delara", 0.0 },
  { "Delaris", 0.0 },
  { "Delasha", 0.0 },
  { "Delasia", 0.0 },
  { "Delaun", 1.0 },
  { "Delaura", 0.0 },
  { "Delauren", 0.0 },
  { "Delavan", 1.0 },
  { "Delavina", 0.0 },
  { "Delawrence", 1.0 },
  { "Delaya", 0.0 },
  { "Delayah", 0.0 },
  { "Delayla", 0.0 },
  { "Delaylah", 0.0 },
  { "Delayna", 0.0 },
  { "Delayne", 0.08523592 },
  { "Delaynee", 0.0 },
  { "Delayney", 0.0 },
  { "Delayni", 0.0 },
  { "Delaynie", 0.0 },
  { "Delaysha", 0.0 },
  { "Delaysia", 0.0 },
  { "Delayza", 0.0 },
  { "Delba", 0.0 },
  { "Delbert", 0.9973975 },
  { "Delberta", 0.0 },
  { "Delborah", 0.0 },
  { "Delbra", 0.0 },
  { "Delbreco", 1.0 },
  { "Delcan", 1.0 },
  { "Delcenia", 0.0 },
  { "Delci", 0.0 },
  { "Delcia", 0.0 },
  { "Delcie", 0.0 },
  { "Delcina", 0.0 },
  { "Delcine", 0.0 },
  { "Delcy", 0.0 },
  { "Deldon", 1.0 },
  { "Deldra", 0.0 },
  { "Deldrick", 1.0 },
  { "Delea", 0.0 },
  { "Deleah", 0.0 },
  { "Delean", 0.0 },
  { "Deleana", 0.0 },
  { "Deleatrice", 0.0 },
  { "Delecia", 0.0 },
  { "Delee", 0.0 },
  { "Deleen", 0.0 },
  { "Deleena", 0.0 },
  { "Deleesa", 0.0 },
  { "Delema", 0.0 },
  { "Delena", 0.0 },
  { "Delene", 0.0 },
  { "Delenia", 0.0 },
  { "Delenn", 0.0 },
  { "Delenna", 0.0 },
  { "Deleno", 1.0 },
  { "Deleon", 0.9840365 },
  { "Delephine", 0.0 },
  { "Delesa", 0.0 },
  { "Delesha", 0.0 },
  { "Deleshia", 0.0 },
  { "Delesia", 0.0 },
  { "Deleta", 0.0 },
  { "Deletha", 0.0 },
  { "Delethia", 0.0 },
  { "Deletta", 0.0 },
  { "Delexis", 0.0 },
  { "Delexus", 0.0 },
  { "Deleyza", 0.0 },
  { "Delfa", 0.0 },
  { "Delfin", 1.0 },
  { "Delfina", 0.0 },
  { "Delfinia", 0.0 },
  { "Delfino", 1.0 },
  { "Delford", 1.0 },
  { "Delfred", 1.0 },
  { "Delfreda", 0.0 },
  { "Delia", 0.0017220309 },
  { "Deliah", 0.0 },
  { "Deliana", 0.0 },
  { "Delianna", 0.0 },
  { "Deliany", 0.0 },
  { "Delianys", 0.0 },
  { "Delica", 0.0 },
  { "Delice", 0.0 },
  { "Delicia", 0.0 },
  { "Delie", 0.0 },
  { "Delight", 0.0 },
  { "Delijah", 0.4084507 },
  { "Delila", 0.0 },
  { "Delilah", 0.0 },
  { "Delilahrose", 0.0 },
  { "Delilha", 0.0 },
  { "Delilia", 0.0 },
  { "Deliliah", 0.0 },
  { "Delima", 0.0 },
  { "Delimar", 0.0 },
  { "Delina", 0.0 },
  { "Delinah", 0.0 },
  { "Delinda", 0.0 },
  { "Delinia", 0.0 },
  { "Delino", 1.0 },
  { "Delio", 1.0 },
  { "Delisa", 0.0 },
  { "Delise", 0.0 },
  { "Delisha", 0.0 },
  { "Delishia", 0.0 },
  { "Delisia", 0.0 },
  { "Delissa", 0.0 },
  { "Delissia", 0.0 },
  { "Delita", 0.0 },
  { "Delite", 0.0 },
  { "Delitha", 0.0 },
  { "Deliyah", 0.0 },
  { "Deliylah", 0.0 },
  { "Deliza", 0.0 },
  { "Deljuan", 1.0 },
  { "Dell", 0.60915655 },
  { "Della", 0.002062651 },
  { "Dellah", 0.0 },
  { "Dellamae", 0.0 },
  { "Dellan", 1.0 },
  { "Dellana", 0.0 },
  { "Dellaney", 0.0 },
  { "Dellanie", 0.0 },
  { "Dellanira", 0.0 },
  { "Dellar", 0.0 },
  { "Dellareese", 0.0 },
  { "Dellas", 1.0 },
  { "Delle", 0.0 },
  { "Dellen", 1.0 },
  { "Dellena", 0.0 },
  { "Dellene", 0.0 },
  { "Deller", 0.0 },
  { "Dellia", 0.0 },
  { "Dellie", 0.017054264 },
  { "Dellis", 1.0 },
  { "Dellon", 1.0 },
  { "Dellora", 0.0 },
  { "Delloyd", 1.0 },
  { "Delma", 0.1463242 },
  { "Delman", 1.0 },
  { "Delmar", 0.99055606 },
  { "Delmarco", 1.0 },
  { "Delmarie", 0.0 },
  { "Delmario", 1.0 },
  { "Delmas", 1.0 },
  { "Delmer", 0.9979036 },
  { "Delmi", 0.0 },
  { "Delmira", 0.0 },
  { "Delmis", 0.5882353 },
  { "Delmo", 1.0 },
  { "Delmon", 1.0 },
  { "Delmond", 1.0 },
  { "Delmonica", 0.0 },
  { "Delmont", 1.0 },
  { "Delmonta", 1.0 },
  { "Delmonte", 1.0 },
  { "Delmor", 1.0 },
  { "Delmore", 1.0 },
  { "Delmos", 1.0 },
  { "Delmus", 1.0 },
  { "Delmy", 0.0 },
  { "Delna", 0.0 },
  { "Delno", 1.0 },
  { "Deloice", 0.0 },
  { "Delois", 0.014149849 },
  { "Deloise", 0.0 },
  { "Deloma", 0.0 },
  { "Delon", 0.9709035 },
  { "Delona", 0.018382354 },
  { "Delonda", 0.0 },
  { "Delondo", 1.0 },
  { "Delone", 0.52873564 },
  { "Deloni", 1.0 },
  { "Delonia", 0.0 },
  { "Delonna", 0.0 },
  { "Delonta", 1.0 },
  { "Delontae", 1.0 },
  { "Delontay", 1.0 },
  { "Delonte", 1.0 },
  { "Delonzo", 1.0 },
  { "Delor", 1.0 },
  { "Delora", 0.0 },
  { "Deloras", 0.0 },
  { "Delorce", 0.0 },
  { "Delore", 0.75609756 },
  { "Delorean", 0.8466667 },
  { "Deloren", 1.0 },
  { "Delorenzo", 1.0 },
  { "Delores", 0.003641815 },
  { "Delorese", 0.0 },
  { "Deloria", 0.0 },
  { "Delorian", 0.7826087 },
  { "Delorice", 0.0 },
  { "Delories", 0.0 },
  { "Deloris", 0.0026751813 },
  { "Delorise", 0.0 },
  { "Deloros", 0.0 },
  { "Delors", 0.0 },
  { "Delorse", 0.0 },
  { "Delorus", 0.0 },
  { "Delos", 1.0 },
  { "Deloss", 1.0 },
  { "Delouise", 0.0 },
  { "Delouris", 0.0 },
  { "Deloy", 1.0 },
  { "Deloyce", 0.0 },
  { "Deloyd", 1.0 },
  { "Delpha", 0.0 },
  { "Delphene", 0.0 },
  { "Delphenia", 0.0 },
  { "Delphia", 0.0 },
  { "Delphie", 0.0 },
  { "Delphin", 1.0 },
  { "Delphina", 0.0 },
  { "Delphine", 0.0032728354 },
  { "Delphinia", 0.0 },
  { "Delphis", 1.0 },
  { "Delphus", 1.0 },
  { "Delquan", 1.0 },
  { "Delrae", 0.0 },
  { "Delray", 1.0 },
  { "Delrick", 1.0 },
  { "Delrico", 1.0 },
  { "Delrita", 0.0 },
  { "Delron", 1.0 },
  { "Delrose", 0.0 },
  { "Delroy", 1.0 },
  { "Delsa", 0.0 },
  { "Delsean", 1.0 },
  { "Delsen", 1.0 },
  { "Delsey", 0.0 },
  { "Delsha", 0.0 },
  { "Delshaun", 1.0 },
  { "Delshawn", 1.0 },
  { "Delshon", 1.0 },
  { "Delsia", 0.0 },
  { "Delsie", 0.0 },
  { "Delsin", 1.0 },
  { "Delson", 1.0 },
  { "Delsy", 0.0 },
  { "Delta", 0.023385301 },
  { "Deltha", 0.0 },
  { "Deltina", 0.0 },
  { "Delton", 1.0 },
  { "Deltrick", 1.0 },
  { "Deluca", 1.0 },
  { "Deluvina", 0.0 },
  { "Delva", 0.0 },
  { "Delvan", 1.0 },
  { "Delvante", 1.0 },
  { "Delvaughn", 1.0 },
  { "Delvecchio", 1.0 },
  { "Delver", 1.0 },
  { "Delvia", 0.0 },
  { "Delvin", 0.99565816 },
  { "Delvina", 0.0 },
  { "Delvion", 1.0 },
  { "Delvis", 1.0 },
  { "Delvon", 1.0 },
  { "Delvonta", 1.0 },
  { "Delvontae", 1.0 },
  { "Delvonte", 1.0 },
  { "Delwayne", 1.0 },
  { "Delwin", 1.0 },
  { "Delwood", 1.0 },
  { "Delwyn", 1.0 },
  { "Dely", 0.0 },
  { "Delya", 0.0 },
  { "Delycia", 0.0 },
  { "Delyla", 0.0 },
  { "Delylah", 0.0 },
  { "Delyle", 1.0 },
  { "Delyn", 0.16176471 },
  { "Delynda", 0.0 },
  { "Delynn", 0.121026896 },
  { "Delynne", 0.0 },
  { "Delysa", 0.0 },
  { "Delyssa", 0.0 },
  { "Delyza", 0.0 },
  { "Delzora", 0.0 },
  { "Dema", 0.0 },
  { "Demacio", 1.0 },
  { "Demaine", 1.0 },
  { "Demaj", 1.0 },
  { "Demajae", 1.0 },
  { "Demaje", 1.0 },
  { "Demandre", 1.0 },
  { "Demani", 0.7742616 },
  { "Demante", 1.0 },
  { "Demanuel", 1.0 },
  { "Demar", 1.0 },
  { "Demara", 0.0 },
  { "Demarcio", 1.0 },
  { "Demarco", 1.0 },
  { "Demarcos", 1.0 },
  { "Demarcus", 0.99770516 },
  { "Demare", 1.0 },
  { "Demarea", 1.0 },
  { "Demarean", 1.0 },
  { "Demaree", 0.8358209 },
  { "Demareo", 1.0 },
  { "Demareon", 1.0 },
  { "Demari", 0.88901097 },
  { "Demaria", 0.15733333 },
  { "Demariae", 1.0 },
  { "Demariah", 0.0 },
  { "Demarian", 1.0 },
  { "Demariana", 0.0 },
  { "Demarie", 0.3809524 },
  { "Demariea", 1.0 },
  { "Demarien", 1.0 },
  { "Demario", 0.9971279 },
  { "Demarion", 1.0 },
  { "Demariona", 0.0 },
  { "Demarionna", 0.0 },
  { "Demarious", 1.0 },
  { "Demaris", 0.21600622 },
  { "Demarius", 1.0 },
  { "Demariya", 0.0 },
  { "Demariyah", 0.0 },
  { "Demariyon", 1.0 },
  { "Demark", 1.0 },
  { "Demarkas", 1.0 },
  { "Demarkio", 1.0 },
  { "Demarkis", 1.0 },
  { "Demarko", 1.0 },
  { "Demarkus", 1.0 },
  { "Demarlo", 1.0 },
  { "Demaro", 1.0 },
  { "Demarque", 1.0 },
  { "Demarques", 1.0 },
  { "Demarquez", 1.0 },
  { "Demarquis", 1.0 },
  { "Demarquise", 1.0 },
  { "Demarqus", 1.0 },
  { "Demarr", 1.0 },
  { "Demarre", 1.0 },
  { "Demarrea", 1.0 },
  { "Demarreon", 1.0 },
  { "Demarri", 1.0 },
  { "Demarrie", 1.0 },
  { "Demarrio", 1.0 },
  { "Demarrion", 1.0 },
  { "Demarrius", 1.0 },
  { "Demartez", 1.0 },
  { "Demarus", 1.0 },
  { "Demaryius", 1.0 },
  { "Demas", 1.0 },
  { "Demaurea", 1.0 },
  { "Demauri", 1.0 },
  { "Demauria", 0.45 },
  { "Demaurie", 1.0 },
  { "Demaurio", 1.0 },
  { "Demaurion", 1.0 },
  { "Demaury", 1.0 },
  { "Demaya", 0.0 },
  { "Demba", 1.0 },
  { "Demea", 0.7058824 },
  { "Demeatra", 0.0 },
  { "Demeatrice", 0.30508474 },
  { "Demeatrius", 1.0 },
  { "Demeca", 0.0 },
  { "Demecia", 0.0 },
  { "Demecio", 1.0 },
  { "Demeco", 1.0 },
  { "Demedrick", 1.0 },
  { "Demeir", 1.0 },
  { "Demeisha", 0.0 },
  { "Demeka", 0.0 },
  { "Demekia", 0.0 },
  { "Demeko", 1.0 },
  { "Demel", 1.0 },
  { "Demelza", 0.0 },
  { "Dementrius", 1.0 },
  { "Demere", 1.0 },
  { "Demeree", 0.0 },
  { "Demeri", 0.0 },
  { "Demeria", 0.0 },
  { "Demerick", 1.0 },
  { "Demerion", 1.0 },
  { "Demeris", 1.0 },
  { "Demerius", 1.0 },
  { "Demerrick", 1.0 },
  { "Demery", 0.2 },
  { "Demesha", 0.0 },
  { "Demeshia", 0.0 },
  { "Demeta", 0.0 },
  { "Demeter", 1.0 },
  { "Demeteria", 0.0 },
  { "Demeterius", 1.0 },
  { "Demethra", 0.0 },
  { "Demetia", 0.0 },
  { "Demetirus", 1.0 },
  { "Demetra", 0.0029119146 },
  { "Demetras", 0.0 },
  { "Demetre", 0.98107255 },
  { "Demetree", 1.0 },
  { "Demetres", 0.94174755 },
  { "Demetress", 0.08955224 },
  { "Demetreus", 1.0 },
  { "Demetrey", 1.0 },
  { "Demetri", 0.9567123 },
  { "Demetria", 0.013022998 },
  { "Demetrial", 0.0 },
  { "Demetrian", 1.0 },
  { "Demetriana", 0.0 },
  { "Demetrianna", 0.0 },
  { "Demetrias", 0.72159094 },
  { "Demetric", 0.8317642 },
  { "Demetrica", 0.0 },
  { "Demetrice", 0.47875187 },
  { "Demetrices", 1.0 },
  { "Demetricia", 0.0 },
  { "Demetrick", 1.0 },
  { "Demetrics", 1.0 },
  { "Demetricus", 1.0 },
  { "Demetrie", 0.94585985 },
  { "Demetries", 1.0 },
  { "Demetrik", 1.0 },
  { "Demetrio", 1.0 },
  { "Demetrion", 1.0 },
  { "Demetriona", 0.0 },
  { "Demetrios", 1.0 },
  { "Demetrious", 0.96604216 },
  { "Demetris", 0.7374154 },
  { "Demetrise", 0.19354838 },
  { "Demetrish", 0.0 },
  { "Demetriss", 0.0 },
  { "Demetriu", 1.0 },
  { "Demetrius", 0.95118093 },
  { "Demetrous", 1.0 },
  { "Demetruis", 0.99384993 },
  { "Demetrus", 0.9664122 },
  { "Demetry", 1.0 },
  { "Demeturis", 1.0 },
  { "Demi", 0.0 },
  { "Demia", 0.0 },
  { "Demiah", 0.0 },
  { "Demian", 0.99153566 },
  { "Demiana", 0.0 },
  { "Demica", 0.0 },
  { "Demicah", 1.0 },
  { "Demichael", 1.0 },
  { "Demicheal", 1.0 },
  { "Demico", 1.0 },
  { "Demid", 1.0 },
  { "Demie", 0.0 },
  { "Demien", 1.0 },
  { "Demier", 1.0 },
  { "Demii", 0.0 },
  { "Demika", 0.0 },
  { "Demiko", 1.0 },
  { "Demilade", 0.65384614 },
  { "Demille", 1.0 },
  { "Deming", 1.0 },
  { "Demingo", 1.0 },
  { "Demion", 1.0 },
  { "Demir", 1.0 },
  { "Demira", 0.0 },
  { "Demiracle", 0.0 },
  { "Demire", 1.0 },
  { "Demis", 1.0 },
  { "Demisha", 0.0 },
  { "Demita", 0.0 },
  { "Demitra", 0.0 },
  { "Demitre", 1.0 },
  { "Demitri", 0.9873834 },
  { "Demitria", 0.0 },
  { "Demitric", 1.0 },
  { "Demitrice", 0.45454547 },
  { "Demitrie", 1.0 },
  { "Demitrio", 1.0 },
  { "Demitrios", 1.0 },
  { "Demitrious", 1.0 },
  { "Demitris", 1.0 },
  { "Demitrius", 0.9940379 },
  { "Demitrus", 1.0 },
  { "Demitry", 1.0 },
  { "Demiya", 0.0 },
  { "Demiyah", 0.0 },
  { "Demmi", 0.0 },
  { "Demmie", 0.0 },
  { "Demon", 1.0 },
  { "Demona", 0.0 },
  { "Demond", 0.9955697 },
  { "Demonde", 1.0 },
  { "Demondre", 1.0 },
  { "Demone", 1.0 },
  { "Demonei", 1.0 },
  { "Demoni", 0.7361111 },
  { "Demonica", 0.0 },
  { "Demonie", 0.9104478 },
  { "Demont", 1.0 },
  { "Demonta", 1.0 },
  { "Demontae", 1.0 },
  { "Demontavious", 1.0 },
  { "Demontay", 1.0 },
  { "Demonte", 1.0 },
  { "Demontez", 1.0 },
  { "Demontra", 1.0 },
  { "Demontrae", 1.0 },
  { "Demontray", 1.0 },
  { "Demontre", 1.0 },
  { "Demontreal", 1.0 },
  { "Demontrell", 1.0 },
  { "Demontrey", 1.0 },
  { "Demontrez", 1.0 },
  { "Demorea", 1.0 },
  { "Demorian", 1.0 },
  { "Demorio", 1.0 },
  { "Demorion", 1.0 },
  { "Demoris", 1.0 },
  { "Demorrio", 1.0 },
  { "Demorris", 1.0 },
  { "Demos", 1.0 },
  { "Demosthenes", 1.0 },
  { "Demple", 0.0 },
  { "Dempsey", 0.92977667 },
  { "Dempsie", 1.0 },
  { "Dempsy", 1.0 },
  { "Demri", 0.0 },
  { "Demtrius", 1.0 },
  { "Demus", 1.0 },
  { "Demy", 0.0 },
  { "Demya", 0.0 },
  { "Demyah", 0.0 },
  { "Demyan", 1.0 },
  { "Demyia", 0.0 },
  { "Demyiah", 0.0 },
  { "Demyla", 0.0 },
  { "Demyra", 0.0 },
  { "Den", 1.0 },
  { "Dena", 0.0017378351 },
  { "Denae", 0.0 },
  { "Denaeja", 0.0 },
  { "Denah", 0.0 },
  { "Denahi", 1.0 },
  { "Denai", 0.0 },
  { "Denaija", 0.0 },
  { "Denaijah", 0.0 },
  { "Denaisha", 0.0 },
  { "Denaiya", 0.0 },
  { "Denaja", 0.0 },
  { "Denajah", 0.0 },
  { "Denajia", 0.0 },
  { "Denali", 0.28029293 },
  { "Denalia", 0.0 },
  { "Denaly", 0.0 },
  { "Denamarie", 0.0 },
  { "Denard", 1.0 },
  { "Denardo", 1.0 },
  { "Denari", 0.88095236 },
  { "Denaria", 0.0 },
  { "Denario", 1.0 },
  { "Denarious", 1.0 },
  { "Denarius", 1.0 },
  { "Denaro", 1.0 },
  { "Denarrius", 1.0 },
  { "Denasha", 0.0 },
  { "Denashia", 0.0 },
  { "Denasia", 0.0 },
  { "Denautica", 0.0 },
  { "Denay", 0.0 },
  { "Denaya", 0.0 },
  { "Denayah", 0.0 },
  { "Denaye", 0.0 },
  { "Denaysha", 0.0 },
  { "Denaysia", 0.0 },
  { "Denazia", 0.0 },
  { "Denby", 1.0 },
  { "Dencie", 0.0 },
  { "Dencil", 1.0 },
  { "Dendrick", 1.0 },
  { "Dene", 0.28050315 },
  { "Denea", 0.0 },
  { "Denean", 0.0 },
  { "Deneane", 0.0 },
  { "Denease", 0.0 },
  { "Denece", 0.0 },
  { "Denecia", 0.0 },
  { "Deneco", 1.0 },
  { "Denedra", 0.0 },
  { "Denee", 0.0 },
  { "Deneem", 0.0 },
  { "Deneen", 0.0019395954 },
  { "Deneena", 0.0 },
  { "Deneene", 0.0 },
  { "Deneesha", 0.0 },
  { "Deneice", 0.0 },
  { "Deneil", 0.0 },
  { "Deneise", 0.0 },
  { "Deneisha", 0.0 },
  { "Deneishia", 0.0 },
  { "Deneka", 0.0 },
  { "Denekia", 0.0 },
  { "Denel", 0.0 },
  { "Denelda", 0.0 },
  { "Denell", 0.12159329 },
  { "Denelle", 0.0093896715 },
  { "Denena", 0.0 },
  { "Denene", 0.0 },
  { "Denequa", 0.0 },
  { "Denerick", 1.0 },
  { "Denerio", 1.0 },
  { "Denero", 1.0 },
  { "Denes", 1.0 },
  { "Denesa", 0.0 },
  { "Denese", 0.0 },
  { "Denesha", 0.0 },
  { "Deneshia", 0.0 },
  { "Denesia", 0.0 },
  { "Denessa", 0.0 },
  { "Deneta", 0.0 },
  { "Denetia", 0.0 },
  { "Denetra", 0.0 },
  { "Denetria", 0.0 },
  { "Denetrice", 0.0 },
  { "Denetris", 0.0 },
  { "Denetrius", 0.0 },
  { "Denett", 0.0 },
  { "Denetta", 0.0 },
  { "Denette", 0.0 },
  { "Deneva", 0.0 },
  { "Deney", 1.0 },
  { "Denford", 1.0 },
  { "Deng", 1.0 },
  { "Denham", 1.0 },
  { "Deni", 0.19015957 },
  { "Denia", 0.0 },
  { "Deniah", 0.0 },
  { "Denica", 0.0 },
  { "Denice", 0.0 },
  { "Denicia", 0.0 },
  { "Denicka", 0.0 },
  { "Denico", 1.0 },
  { "Denie", 0.0 },
  { "Deniece", 0.0 },
  { "Deniecia", 0.0 },
  { "Deniel", 1.0 },
  { "Deniella", 0.0 },
  { "Denielle", 0.0 },
  { "Deniene", 0.0 },
  { "Deniese", 0.0 },
  { "Deniesha", 0.0 },
  { "Denija", 0.0 },
  { "Denijah", 0.0 },
  { "Denika", 0.0 },
  { "Deniko", 1.0 },
  { "Denilah", 0.0 },
  { "Denille", 0.0 },
  { "Denilson", 1.0 },
  { "Denilzon", 1.0 },
  { "Denim", 0.73913044 },
  { "Denin", 1.0 },
  { "Denina", 0.0 },
  { "Denine", 0.0 },
  { "Deniqua", 0.0 },
  { "Denique", 0.0 },
  { "Denira", 0.0 },
  { "Deniro", 1.0 },
  { "Denis", 0.9605914 },
  { "Denisa", 0.0 },
  { "Denise", 0.0036531175 },
  { "Denisha", 0.0 },
  { "Denishea", 0.0 },
  { "Denishia", 0.0 },
  { "Denisia", 0.0 },
  { "Denison", 1.0 },
  { "Deniss", 0.057471264 },
  { "Denissa", 0.0 },
  { "Denisse", 0.0 },
  { "Denita", 0.0 },
  { "Denitra", 0.0 },
  { "Denitta", 0.0 },
  { "Deniya", 0.0 },
  { "Deniyah", 0.0 },
  { "Deniz", 0.5519836 },
  { "Denize", 0.0 },
  { "Denley", 1.0 },
  { "Denman", 1.0 },
  { "Denmark", 1.0 },
  { "Denna", 0.0 },
  { "Dennae", 0.0 },
  { "Dennard", 1.0 },
  { "Denne", 0.0 },
  { "Dennell", 0.2631579 },
  { "Dennen", 0.0 },
  { "Dennes", 1.0 },
  { "Dennese", 0.0 },
  { "Dennesly", 0.0 },
  { "Dennett", 1.0 },
  { "Dennetta", 0.0 },
  { "Dennette", 0.0 },
  { "Denney", 1.0 },
  { "Denni", 0.0862069 },
  { "Dennia", 0.0 },
  { "Dennice", 0.0 },
  { "Dennie", 0.8220507 },
  { "Dennielle", 0.0 },
  { "Dennies", 1.0 },
  { "Dennine", 0.0 },
  { "Dennis", 0.99570495 },
  { "Dennise", 0.024057971 },
  { "Dennisha", 0.0 },
  { "Dennishia", 0.0 },
  { "Dennison", 1.0 },
  { "Dennisse", 0.0 },
  { "Dennita", 0.0 },
  { "Dennon", 1.0 },
  { "Denny", 0.9746062 },
  { "Dennys", 0.83693516 },
  { "Deno", 1.0 },
  { "Denon", 1.0 },
  { "Denora", 0.0 },
  { "Denoris", 1.0 },
  { "Denorris", 1.0 },
  { "Denotra", 0.0 },
  { "Denroy", 1.0 },
  { "Densel", 1.0 },
  { "Densie", 0.0 },
  { "Densil", 1.0 },
  { "Denson", 1.0 },
  { "Dent", 1.0 },
  { "Denton", 1.0 },
  { "Dentrell", 1.0 },
  { "Denver", 0.91012716 },
  { "Denvil", 1.0 },
  { "Deny", 1.0 },
  { "Denya", 0.0 },
  { "Denyah", 0.0 },
  { "Denyce", 0.0 },
  { "Denyel", 0.0 },
  { "Denyell", 0.0 },
  { "Denyelle", 0.0 },
  { "Denyia", 0.0 },
  { "Denyla", 0.0 },
  { "Denylah", 0.0 },
  { "Denym", 0.48547718 },
  { "Denys", 0.2755102 },
  { "Denyse", 0.0 },
  { "Denysha", 0.0 },
  { "Denysse", 0.0 },
  { "Denzal", 1.0 },
  { "Denzale", 1.0 },
  { "Denzel", 0.9959602 },
  { "Denzell", 1.0 },
  { "Denzelle", 1.0 },
  { "Denziel", 1.0 },
  { "Denzil", 0.9822129 },
  { "Denzle", 1.0 },
  { "Denzyl", 1.0 },
  { "Deo", 1.0 },
  { "Deobrah", 0.0 },
  { "Deola", 0.0 },
  { "Deolinda", 0.0 },
  { "Deon", 0.89342 },
  { "Deona", 0.0 },
  { "Deonate", 1.0 },
  { "Deonca", 0.0 },
  { "Deonda", 0.0 },
  { "Deondra", 0.23459582 },
  { "Deondrae", 1.0 },
  { "Deondray", 1.0 },
  { "Deondre", 0.99597853 },
  { "Deondrea", 0.43589744 },
  { "Deondrey", 1.0 },
  { "Deondria", 0.0 },
  { "Deondric", 1.0 },
  { "Deondrick", 1.0 },
  { "Deone", 0.37671232 },
  { "Deoni", 0.0 },
  { "Deonia", 0.0 },
  { "Deonica", 0.0 },
  { "Deonie", 0.0 },
  { "Deonka", 0.0 },
  { "Deonn", 0.0 },
  { "Deonna", 0.001396258 },
  { "Deonne", 0.09710744 },
  { "Deonni", 0.0 },
  { "Deonnie", 0.0 },
  { "Deonsha", 0.0 },
  { "Deonshay", 0.0 },
  { "Deonta", 0.9856287 },
  { "Deontae", 1.0 },
  { "Deontai", 1.0 },
  { "Deontavious", 1.0 },
  { "Deontay", 1.0 },
  { "Deontaye", 1.0 },
  { "Deonte", 0.994618 },
  { "Deontea", 1.0 },
  { "Deontee", 1.0 },
  { "Deontez", 1.0 },
  { "Deontia", 1.0 },
  { "Deontra", 0.88235295 },
  { "Deontrae", 1.0 },
  { "Deontray", 1.0 },
  { "Deontre", 1.0 },
  { "Deontrey", 1.0 },
  { "Deontrez", 1.0 },
  { "Deonza", 0.0 },
  { "Deora", 0.0 },
  { "Deosha", 0.0 },
  { "Deotha", 0.0 },
  { "Deotis", 1.0 },
  { "Deoveon", 0.21428572 },
  { "Deovian", 0.0 },
  { "Deovion", 0.622807 },
  { "Depaul", 1.0 },
  { "Depree", 1.0 },
  { "Depriest", 1.0 },
  { "Deprise", 0.0 },
  { "Deqa", 0.0 },
  { "Dequan", 0.9986184 },
  { "Dequana", 0.0 },
  { "Dequanda", 0.0 },
  { "Dequandra", 0.0 },
  { "Dequandre", 1.0 },
  { "Dequane", 1.0 },
  { "Dequann", 1.0 },
  { "Dequanna", 0.0 },
  { "Dequanta", 1.0 },
  { "Dequantae", 1.0 },
  { "Dequante", 1.0 },
  { "Dequantez", 1.0 },
  { "Dequarious", 1.0 },
  { "Dequarius", 1.0 },
  { "Dequasha", 0.0 },
  { "Dequaveon", 1.0 },
  { "Dequavion", 1.0 },
  { "Dequavious", 1.0 },
  { "Dequavius", 1.0 },
  { "Dequawn", 1.0 },
  { "Dequay", 1.0 },
  { "Dequentin", 1.0 },
  { "Dequesha", 0.0 },
  { "Dequez", 1.0 },
  { "Dequilla", 0.0 },
  { "Dequincy", 1.0 },
  { "Dequindre", 1.0 },
  { "Dequinn", 1.0 },
  { "Dequinton", 1.0 },
  { "Dequisha", 0.0 },
  { "Dequita", 0.0 },
  { "Dequon", 1.0 },
  { "Dequone", 1.0 },
  { "Deqwan", 1.0 },
  { "Der", 0.0 },
  { "Dera", 0.0 },
  { "Derak", 1.0 },
  { "Deral", 1.0 },
  { "Derald", 1.0 },
  { "Deralyn", 0.0 },
  { "Deran", 1.0 },
  { "Deray", 1.0 },
  { "Derba", 0.0 },
  { "Derby", 0.85294116 },
  { "Derck", 1.0 },
  { "Derean", 1.0 },
  { "Derec", 1.0 },
  { "Dereck", 1.0 },
  { "Dereginald", 1.0 },
  { "Dereion", 1.0 },
  { "Derek", 0.9960223 },
  { "Dereka", 0.0 },
  { "Dereke", 1.0 },
  { "Derekia", 0.0 },
  { "Derel", 1.0 },
  { "Derell", 1.0 },
  { "Derelle", 1.0 },
  { "Derelys", 0.0 },
  { "Deremy", 1.0 },
  { "Deren", 1.0 },
  { "Derena", 0.0 },
  { "Derenda", 0.0 },
  { "Derene", 0.0 },
  { "Dereon", 0.7611444 },
  { "Dereona", 0.0 },
  { "Dereonna", 0.0 },
  { "Deresa", 0.0 },
  { "Deresha", 0.0 },
  { "Dereth", 0.0 },
  { "Deretha", 0.0 },
  { "Derex", 1.0 },
  { "Dereyon", 1.0 },
  { "Derez", 1.0 },
  { "Derf", 1.0 },
  { "Derhonda", 0.0 },
  { "Deri", 0.0 },
  { "Deria", 0.0 },
  { "Deriah", 0.0 },
  { "Derian", 0.8962337 },
  { "Deriana", 0.0 },
  { "Derianna", 0.0 },
  { "Deric", 1.0 },
  { "Derica", 0.0 },
  { "Derice", 1.0 },
  { "Derick", 0.9978977 },
  { "Dericka", 0.0 },
  { "Derico", 1.0 },
  { "Deridre", 0.0 },
  { "Deriek", 1.0 },
  { "Deriel", 1.0 },
  { "Derielle", 0.0 },
  { "Derien", 1.0 },
  { "Derik", 1.0 },
  { "Derika", 0.0 },
  { "Derike", 1.0 },
  { "Derin", 0.845339 },
  { "Derina", 0.0 },
  { "Derinda", 0.0 },
  { "Derion", 0.94901145 },
  { "Deriona", 0.0 },
  { "Derionna", 0.0 },
  { "Derious", 1.0 },
  { "Derique", 1.0 },
  { "Deris", 1.0 },
  { "Derise", 0.0 },
  { "Derisha", 0.0 },
  { "Derita", 0.0 },
  { "Derith", 0.0 },
  { "Derius", 1.0 },
  { "Deriya", 0.0 },
  { "Deriyah", 0.0 },
  { "Deriyon", 1.0 },
  { "Derk", 1.0 },
  { "Derl", 1.0 },
  { "Derle", 1.0 },
  { "Derlene", 0.0 },
  { "Derlin", 1.0 },
  { "Derlis", 1.0 },
  { "Derly", 1.0 },
  { "Dermaine", 1.0 },
  { "Dermarr", 1.0 },
  { "Dermont", 1.0 },
  { "Dermot", 1.0 },
  { "Dermott", 1.0 },
  { "Derna", 0.0 },
  { "Dernell", 1.0 },
  { "Dero", 1.0 },
  { "Deroderick", 1.0 },
  { "Deroe", 1.0 },
  { "Derold", 1.0 },
  { "Derome", 1.0 },
  { "Deron", 0.9936674 },
  { "Deronda", 0.0 },
  { "Derone", 1.0 },
  { "Deronn", 1.0 },
  { "Deronna", 0.0 },
  { "Deronne", 1.0 },
  { "Deronta", 1.0 },
  { "Derontae", 1.0 },
  { "Deronte", 1.0 },
  { "Derotha", 0.0 },
  { "Deroy", 1.0 },
  { "Derquan", 1.0 },
  { "Derra", 0.0 },
  { "Derral", 1.0 },
  { "Derrald", 1.0 },
  { "Derrall", 1.0 },
  { "Derran", 1.0 },
  { "Derrance", 1.0 },
  { "Derreck", 1.0 },
  { "Derrek", 1.0 },
  { "Derrel", 1.0 },
  { "Derrell", 0.9972164 },
  { "Derrelle", 1.0 },
  { "Derren", 1.0 },
  { "Derreon", 1.0 },
  { "Derri", 0.0 },
  { "Derria", 0.0 },
  { "Derriah", 0.0 },
  { "Derrian", 0.8787879 },
  { "Derriana", 0.0 },
  { "Derrianna", 0.0 },
  { "Derric", 1.0 },
  { "Derrica", 0.0 },
  { "Derrice", 1.0 },
  { "Derrich", 1.0 },
  { "Derrick", 0.99298596 },
  { "Derricka", 0.0 },
  { "Derrico", 1.0 },
  { "Derrie", 0.69863015 },
  { "Derrien", 1.0 },
  { "Derrik", 1.0 },
  { "Derrika", 0.0 },
  { "Derrike", 1.0 },
  { "Derril", 1.0 },
  { "Derrill", 1.0 },
  { "Derrin", 1.0 },
  { "Derringer", 1.0 },
  { "Derrion", 0.966716 },
  { "Derriona", 0.0 },
  { "Derrione", 1.0 },
  { "Derrionna", 0.0 },
  { "Derrious", 1.0 },
  { "Derris", 1.0 },
  { "Derrisha", 0.0 },
  { "Derrius", 1.0 },
  { "Derriyah", 0.0 },
  { "Derrol", 1.0 },
  { "Derrold", 1.0 },
  { "Derron", 1.0 },
  { "Derrus", 1.0 },
  { "Derry", 0.91835517 },
  { "Derryck", 1.0 },
  { "Derryk", 1.0 },
  { "Derryl", 0.98362446 },
  { "Derryon", 1.0 },
  { "Dervin", 1.0 },
  { "Dervon", 1.0 },
  { "Derward", 1.0 },
  { "Derwin", 1.0 },
  { "Derwood", 1.0 },
  { "Derwyn", 1.0 },
  { "Derya", 0.0 },
  { "Deryan", 1.0 },
  { "Deryck", 1.0 },
  { "Deryk", 1.0 },
  { "Derykah", 0.0 },
  { "Deryl", 0.9057072 },
  { "Deryle", 1.0 },
  { "Deryn", 0.15714286 },
  { "Deryon", 1.0 },
  { "Des", 0.54545456 },
  { "Desa", 0.0 },
  { "Desai", 1.0 },
  { "Desales", 0.0 },
  { "Desandra", 0.0 },
  { "Desani", 0.2 },
  { "Desara", 0.0 },
  { "Desarae", 0.0 },
  { "Desarai", 0.0 },
  { "Desaray", 0.0 },
  { "Desaraye", 0.0 },
  { "Desare", 0.0 },
  { "Desarea", 0.0 },
  { "Desaree", 0.0 },
  { "Desarey", 0.0 },
  { "Desari", 0.0 },
  { "Desarie", 0.0 },
  { "Desaun", 1.0 },
  { "Desda", 0.0 },
  { "Desdemona", 0.0 },
  { "Desean", 0.9970222 },
  { "Desera", 0.0 },
  { "Deserae", 0.0 },
  { "Deserai", 0.0 },
  { "Deseray", 0.0 },
  { "Desere", 0.0 },
  { "Deserea", 0.0 },
  { "Deseree", 0.0 },
  { "Deseret", 0.0 },
  { "Deserey", 0.0 },
  { "Deseri", 0.0 },
  { "Deseria", 0.0 },
  { "Deserie", 0.0 },
  { "Desery", 0.0 },
  { "Desha", 0.006119951 },
  { "Deshad", 1.0 },
  { "Deshae", 0.18141593 },
  { "Deshai", 0.0 },
  { "Deshaila", 0.0 },
  { "Deshala", 0.0 },
  { "Deshan", 0.9527559 },
  { "Deshana", 0.0 },
  { "Deshanae", 0.0 },
  { "Deshanay", 0.0 },
  { "Deshanda", 0.0 },
  { "Deshandra", 0.0 },
  { "Deshane", 0.93333334 },
  { "Deshanique", 0.0 },
  { "Deshanna", 0.0 },
  { "Deshannon", 0.3713355 },
  { "Deshanon", 1.0 },
  { "Deshanta", 0.0 },
  { "Deshante", 0.21839081 },
  { "Deshanti", 0.0 },
  { "Deshara", 0.0 },
  { "Deshard", 1.0 },
  { "Deshaud", 1.0 },
  { "Deshaun", 0.9571826 },
  { "Deshauna", 0.0 },
  { "Deshaunda", 0.0 },
  { "Deshaundra", 0.0 },
  { "Deshaune", 1.0 },
  { "Deshaunta", 0.0 },
  { "Deshaunte", 1.0 },
  { "Deshawn", 0.9253345 },
  { "Deshawna", 0.0 },
  { "Deshawnda", 0.0 },
  { "Deshawndre", 1.0 },
  { "Deshawnna", 0.0 },
  { "Deshawnte", 1.0 },
  { "Deshay", 0.38689217 },
  { "Deshaya", 0.0 },
  { "Deshayla", 0.0 },
  { "Deshea", 0.09248555 },
  { "Desheena", 0.0 },
  { "Desheila", 0.0 },
  { "Deshelia", 0.0 },
  { "Deshell", 0.0 },
  { "Deshera", 0.0 },
  { "Deshia", 0.0 },
  { "Deshion", 1.0 },
  { "Deshira", 0.0 },
  { "Deshiya", 0.0 },
  { "Deshna", 0.0 },
  { "Deshon", 0.93333334 },
  { "Deshona", 0.0 },
  { "Deshonda", 0.0 },
  { "Deshondra", 0.0 },
  { "Deshone", 0.8449848 },
  { "Deshonia", 0.0 },
  { "Deshonna", 0.0 },
  { "Deshonta", 0.0 },
  { "Deshonte", 0.45454547 },
  { "Deshown", 1.0 },
  { "Deshuan", 1.0 },
  { "Deshun", 0.9671323 },
  { "Deshuna", 0.0 },
  { "Deshunda", 0.0 },
  { "Deshundra", 0.0 },
  { "Deshya", 0.0 },
  { "Desi", 0.7381119 },
  { "Desia", 0.0 },
  { "Desiah", 0.0 },
  { "Desiderio", 1.0 },
  { "Desieree", 0.0 },
  { "Desinae", 0.0 },
  { "Desira", 0.0 },
  { "Desirae", 0.0 },
  { "Desiraee", 0.0 },
  { "Desirai", 0.0 },
  { "Desiray", 0.0 },
  { "Desiraye", 0.0 },
  { "Desire", 0.008785416 },
  { "Desirea", 0.0 },
  { "Desireah", 0.0 },
  { "Desiree", 0.002423204 },
  { "Desirey", 0.0 },
  { "Desiri", 0.0 },
  { "Desirie", 0.0 },
  { "Desirrae", 0.0 },
  { "Desirre", 0.0 },
  { "Desirree", 0.0 },
  { "Desitny", 0.0 },
  { "Desiya", 0.0 },
  { "Desiyah", 0.0 },
  { "Desja", 0.0 },
  { "Desjah", 0.0 },
  { "Desjambra", 0.0 },
  { "Desjon", 1.0 },
  { "Desjuan", 1.0 },
  { "Deslie", 0.0 },
  { "Deslyn", 0.0 },
  { "Deslynn", 0.0 },
  { "Desma", 0.0 },
  { "Desman", 1.0 },
  { "Desmand", 1.0 },
  { "Desmariah", 0.0 },
  { "Desmarie", 0.0 },
  { "Desmen", 1.0 },
  { "Desmend", 1.0 },
  { "Desmin", 0.9705882 },
  { "Desmine", 1.0 },
  { "Desmon", 1.0 },
  { "Desmona", 0.0 },
  { "Desmond", 0.9927376 },
  { "Desmone", 0.87234044 },
  { "Desmonique", 0.0 },
  { "Desmund", 1.0 },
  { "Desnee", 0.0 },
  { "Despena", 0.0 },
  { "Despina", 0.0 },
  { "Desra", 0.0 },
  { "Desrae", 0.0 },
  { "Desray", 0.0 },
  { "Desree", 0.0 },
  { "Desriee", 0.0 },
  { "Dessa", 0.0 },
  { "Dessarae", 0.0 },
  { "Dessel", 0.0 },
  { "Dessence", 0.0 },
  { "Desseray", 0.0 },
  { "Dessia", 0.0 },
  { "Dessiah", 0.26086956 },
  { "Dessica", 0.0 },
  { "Dessie", 0.027168324 },
  { "Dessirae", 0.0 },
  { "Dessire", 0.0 },
  { "Dessiree", 0.0 },
  { "Desta", 0.0 },
  { "Destainy", 0.0 },
  { "Destan", 1.0 },
  { "Destane", 0.0 },
  { "Destanee", 0.0 },
  { "Destaney", 0.0 },
  { "Destani", 0.0 },
  { "Destanie", 0.0 },
  { "Destannie", 0.0 },
  { "Destany", 0.0 },
  { "Desten", 1.0 },
  { "Destene", 0.0 },
  { "Destenee", 0.0 },
  { "Desteney", 0.0 },
  { "Desteni", 0.0 },
  { "Destenie", 0.0 },
  { "Desteny", 0.0 },
  { "Dester", 0.42857143 },
  { "Destery", 1.0 },
  { "Destiany", 0.0 },
  { "Destin", 0.88590014 },
  { "Destina", 0.0 },
  { "Destinae", 0.0 },
  { "Destinay", 0.0 },
  { "Destine", 0.13476703 },
  { "Destinea", 0.0 },
  { "Destined", 1.0 },
  { "Destinee", 0.0 },
  { "Destinei", 0.0 },
  { "Destiney", 0.0 },
  { "Desting", 0.0 },
  { "Destini", 0.0 },
  { "Destinie", 0.0 },
  { "Destinii", 0.0 },
  { "Destinique", 0.0 },
  { "Destinni", 0.0 },
  { "Destinnie", 0.0 },
  { "Destinny", 0.0 },
  { "Destiny", 0.0033449922 },
  { "Destinyann", 0.0 },
  { "Destinye", 0.0 },
  { "Destinymarie", 0.0 },
  { "Destinyrose", 0.0 },
  { "Destney", 0.0 },
  { "Deston", 1.0 },
  { "Destoni", 0.0 },
  { "Destony", 0.0 },
  { "Destri", 0.16129032 },
  { "Destry", 0.9077021 },
  { "Destyn", 0.7505519 },
  { "Destyne", 0.0 },
  { "Destynee", 0.0 },
  { "Destyni", 0.0 },
  { "Destynie", 0.0 },
  { "Destyny", 0.0 },
  { "Desuan", 1.0 },
  { "Desyrae", 0.0 },
  { "Desyre", 0.0 },
  { "Desyree", 0.0 },
  { "Deta", 0.0 },
  { "Detarius", 1.0 },
  { "Detavion", 1.0 },
  { "Detavious", 1.0 },
  { "Detavius", 1.0 },
  { "Deterrio", 1.0 },
  { "Deterrion", 1.0 },
  { "Deterrius", 1.0 },
  { "Detisha", 0.0 },
  { "Detoya", 0.0 },
  { "Detra", 0.0 },
  { "Detrail", 1.0 },
  { "Detravion", 1.0 },
  { "Detravious", 1.0 },
  { "Detrell", 1.0 },
  { "Detrevion", 1.0 },
  { "Detrez", 1.0 },
  { "Detri", 0.0 },
  { "Detria", 0.0 },
  { "Detric", 0.9882353 },
  { "Detrica", 0.0 },
  { "Detrice", 0.0 },
  { "Detrich", 0.9140625 },
  { "Detricia", 0.0 },
  { "Detrick", 0.9832552 },
  { "Detrina", 0.0 },
  { "Detroit", 1.0 },
  { "Detron", 1.0 },
  { "Detroy", 1.0 },
  { "Detta", 0.0 },
  { "Dette", 0.0 },
  { "Dettrick", 1.0 },
  { "Detwan", 1.0 },
  { "Detzani", 0.0 },
  { "Deucalion", 1.0 },
  { "Deuce", 1.0 },
  { "Deuel", 1.0 },
  { "Deundra", 0.61509436 },
  { "Deundrae", 1.0 },
  { "Deundray", 1.0 },
  { "Deundre", 1.0 },
  { "Deundrea", 1.0 },
  { "Deundria", 0.0 },
  { "Deunta", 1.0 },
  { "Deuntae", 1.0 },
  { "Deuntay", 1.0 },
  { "Deunte", 1.0 },
  { "Deuntray", 1.0 },
  { "Deus", 1.0 },
  { "Dev", 1.0 },
  { "Deva", 0.017372422 },
  { "Devaansh", 1.0 },
  { "Devaeh", 0.0 },
  { "Devahn", 1.0 },
  { "Devaj", 1.0 },
  { "Devaki", 0.0 },
  { "Deval", 1.0 },
  { "Devale", 1.0 },
  { "Devam", 1.0 },
  { "Devan", 0.72004426 },
  { "Devana", 0.0 },
  { "Devanae", 0.0 },
  { "Devanand", 1.0 },
  { "Devance", 1.0 },
  { "Devane", 1.0 },
  { "Devanee", 0.0 },
  { "Devaney", 0.0 },
  { "Devang", 1.0 },
  { "Devanhi", 0.0 },
  { "Devani", 0.0 },
  { "Devanie", 0.0 },
  { "Devann", 0.051282052 },
  { "Devanna", 0.0 },
  { "Devanne", 0.0 },
  { "Devannie", 0.0 },
  { "Devanny", 0.0 },
  { "Devansh", 1.0 },
  { "Devanshi", 0.0 },
  { "Devanta", 1.0 },
  { "Devantae", 1.0 },
  { "Devante", 0.9926669 },
  { "Devanti", 1.0 },
  { "Devantre", 1.0 },
  { "Devany", 0.0 },
  { "Devar", 1.0 },
  { "Devara", 0.0 },
  { "Devari", 1.0 },
  { "Devarian", 1.0 },
  { "Devario", 1.0 },
  { "Devarion", 1.0 },
  { "Devarious", 1.0 },
  { "Devaris", 1.0 },
  { "Devarius", 1.0 },
  { "Devaron", 1.0 },
  { "Devarsh", 1.0 },
  { "Devarus", 1.0 },
  { "Devaugh", 1.0 },
  { "Devaughn", 1.0 },
  { "Devaughnte", 1.0 },
  { "Devaun", 1.0 },
  { "Devaunte", 1.0 },
  { "Devaya", 0.0 },
  { "Devayah", 0.0 },
  { "Deveah", 0.0 },
  { "Devean", 1.0 },
  { "Deveda", 0.0 },
  { "Deveion", 1.0 },
  { "Devel", 1.0 },
  { "Devell", 1.0 },
  { "Develle", 1.0 },
  { "Develyn", 0.0 },
  { "Deven", 0.88632995 },
  { "Devena", 0.0 },
  { "Devendra", 1.0 },
  { "Deveney", 0.0 },
  { "Deveni", 0.0 },
  { "Devente", 1.0 },
  { "Deveny", 0.0 },
  { "Deveon", 1.0 },
  { "Dever", 1.0 },
  { "Devera", 0.0 },
  { "Deveraux", 1.0 },
  { "Devere", 1.0 },
  { "Devereaux", 0.9548872 },
  { "Devereux", 1.0 },
  { "Deverick", 1.0 },
  { "Deverie", 0.0 },
  { "Deverl", 1.0 },
  { "Deverly", 0.0 },
  { "Devern", 1.0 },
  { "Deverne", 1.0 },
  { "Deveron", 1.0 },
  { "Devery", 0.76368874 },
  { "Devesh", 1.0 },
  { "Deveshi", 0.0 },
  { "Deveta", 0.0 },
  { "Devetta", 0.0 },
  { "Devette", 0.0 },
  { "Deveyon", 1.0 },
  { "Devi", 0.0 },
  { "Devia", 0.0 },
  { "Devian", 0.9211469 },
  { "Deviana", 0.0 },
  { "Devida", 0.0 },
  { "Devie", 0.0 },
  { "Devien", 1.0 },
  { "Devika", 0.0 },
  { "Deville", 1.0 },
  { "Devin", 0.89888144 },
  { "Devina", 0.0 },
  { "Devindra", 1.0 },
  { "Devine", 0.5197947 },
  { "Devinee", 0.0 },
  { "Devinity", 0.0 },
  { "Devinlee", 1.0 },
  { "Devinn", 0.7304582 },
  { "Devinne", 0.0 },
  { "Deviny", 0.0 },
  { "Devion", 0.984945 },
  { "Devione", 1.0 },
  { "Devionna", 0.0 },
  { "Devionne", 1.0 },
  { "Deviontae", 1.0 },
  { "Devionte", 1.0 },
  { "Devita", 0.0 },
  { "Devito", 1.0 },
  { "Deviyon", 1.0 },
  { "Devki", 0.0 },
  { "Devlan", 1.0 },
  { "Devlen", 1.0 },
  { "Devlin", 0.9484601 },
  { "Devlon", 1.0 },
  { "Devlyn", 0.6070727 },
  { "Devlynn", 0.0 },
  { "Devn", 1.0 },
  { "Devoe", 1.0 },
  { "Devohn", 1.0 },
  { "Devoiry", 0.0 },
  { "Devola", 0.0 },
  { "Devon", 0.778636 },
  { "Devona", 0.0 },
  { "Devonae", 0.0 },
  { "Devonaire", 1.0 },
  { "Devonda", 0.0 },
  { "Devondra", 0.0 },
  { "Devondre", 1.0 },
  { "Devondrick", 1.0 },
  { "Devone", 0.8542413 },
  { "Devonee", 0.0 },
  { "Devoney", 0.0 },
  { "Devoni", 0.0 },
  { "Devonia", 0.0 },
  { "Devonie", 0.0 },
  { "Devonn", 0.9474886 },
  { "Devonna", 0.0 },
  { "Devonne", 0.40973505 },
  { "Devonnte", 1.0 },
  { "Devonta", 0.9878049 },
  { "Devontae", 1.0 },
  { "Devontai", 1.0 },
  { "Devontavius", 1.0 },
  { "Devontay", 1.0 },
  { "Devontaye", 1.0 },
  { "Devonte", 0.99702907 },
  { "Devontea", 1.0 },
  { "Devontee", 1.0 },
  { "Devontez", 1.0 },
  { "Devonti", 1.0 },
  { "Devontia", 1.0 },
  { "Devontra", 1.0 },
  { "Devontrae", 1.0 },
  { "Devontray", 1.0 },
  { "Devontre", 1.0 },
  { "Devontrey", 1.0 },
  { "Devony", 0.0 },
  { "Devonya", 0.0 },
  { "Devora", 0.0 },
  { "Devorah", 0.0 },
  { "Devoria", 0.0 },
  { "Devoris", 1.0 },
  { "Devory", 0.0 },
  { "Devota", 0.0 },
  { "Devra", 0.0 },
  { "Devraj", 1.0 },
  { "Devree", 0.0 },
  { "Devren", 1.0 },
  { "Devri", 0.0 },
  { "Devrick", 1.0 },
  { "Devrie", 0.0 },
  { "Devrim", 1.0 },
  { "Devrin", 1.0 },
  { "Devron", 1.0 },
  { "Devry", 0.7105263 },
  { "Devun", 1.0 },
  { "Devunta", 1.0 },
  { "Devunte", 1.0 },
  { "Devven", 1.0 },
  { "Devvin", 1.0 },
  { "Devvon", 0.921875 },
  { "Devy", 0.0 },
  { "Devyani", 0.0 },
  { "Devyn", 0.45214352 },
  { "Devyne", 0.32163742 },
  { "Devynn", 0.17086332 },
  { "Devynne", 0.0 },
  { "Devyon", 1.0 },
  { "Dewain", 1.0 },
  { "Dewaine", 1.0 },
  { "Dewan", 0.97480315 },
  { "Dewana", 0.0 },
  { "Dewand", 1.0 },
  { "Dewanda", 0.0 },
  { "Dewane", 1.0 },
  { "Dewann", 1.0 },
  { "Dewanna", 0.0 },
  { "Deward", 1.0 },
  { "Dewarren", 1.0 },
  { "Dewaun", 1.0 },
  { "Dewayna", 0.0 },
  { "Dewayne", 0.99573845 },
  { "Dewel", 1.0 },
  { "Dewell", 1.0 },
  { "Dewetta", 0.0 },
  { "Dewey", 0.98422086 },
  { "Dewi", 0.0 },
  { "Dewie", 0.93700784 },
  { "Dewight", 1.0 },
  { "Dewilla", 0.0 },
  { "Dewin", 1.0 },
  { "Dewit", 1.0 },
  { "Dewitt", 1.0 },
  { "Dewitte", 1.0 },
  { "Dewon", 1.0 },
  { "Dewone", 1.0 },
  { "Dewuan", 1.0 },
  { "Dewy", 1.0 },
  { "Dewyane", 1.0 },
  { "Dewyne", 1.0 },
  { "Dex", 1.0 },
  { "Dexiree", 0.0 },
  { "Dexten", 1.0 },
  { "Dexter", 0.9932759 },
  { "Dextin", 1.0 },
  { "Dexton", 1.0 },
  { "Dextyn", 1.0 },
  { "Dexx", 1.0 },
  { "Deya", 0.0 },
  { "Deyadira", 0.0 },
  { "Deyala", 0.0 },
  { "Deyan", 1.0 },
  { "Deyana", 0.0 },
  { "Deyanara", 0.0 },
  { "Deyaneira", 0.0 },
  { "Deyani", 0.0 },
  { "Deyanira", 0.0 },
  { "Deyanna", 0.0 },
  { "Deyannah", 0.0 },
  { "Deyanne", 0.0 },
  { "Deyante", 1.0 },
  { "Deybi", 1.0 },
  { "Deyci", 0.0 },
  { "Deycy", 0.0 },
  { "Deyja", 0.0 },
  { "Deyjah", 0.0 },
  { "Deyla", 0.0 },
  { "Deylan", 1.0 },
  { "Deylani", 0.0 },
  { "Deylen", 1.0 },
  { "Deyli", 0.0 },
  { "Deylin", 0.33333334 },
  { "Deylon", 1.0 },
  { "Deymar", 1.0 },
  { "Deymi", 0.0 },
  { "Deymian", 1.0 },
  { "Deyna", 0.0 },
  { "Deyon", 0.97795594 },
  { "Deyona", 0.0 },
  { "Deyonce", 0.10769231 },
  { "Deyonna", 0.0 },
  { "Deyonne", 0.0 },
  { "Deyonta", 1.0 },
  { "Deyontae", 1.0 },
  { "Deyonte", 1.0 },
  { "Deyra", 0.0 },
  { "Deyren", 1.0 },
  { "Deysha", 0.0 },
  { "Deyshaun", 1.0 },
  { "Deyshawn", 1.0 },
  { "Deysi", 0.0 },
  { "Deysia", 0.0 },
  { "Deyssi", 0.0 },
  { "Deysy", 0.0 },
  { "Deyton", 1.0 },
  { "Deyvi", 1.0 },
  { "Deyvid", 1.0 },
  { "Deyvin", 1.0 },
  { "Deyvion", 1.0 },
  { "Deyvon", 1.0 },
  { "Dez", 1.0 },
  { "Deza", 0.0 },
  { "Dezani", 0.0 },
  { "Dezarae", 0.0 },
  { "Dezarai", 0.0 },
  { "Dezaray", 0.0 },
  { "Dezaraye", 0.0 },
  { "Dezare", 0.0 },
  { "Dezarea", 0.0 },
  { "Dezaree", 0.0 },
  { "Dezarey", 0.0 },
  { "Dezaria", 0.0 },
  { "Dezariah", 0.0 },
  { "Dezariyah", 0.0 },
  { "Dezavion", 1.0 },
  { "Dezden", 1.0 },
  { "Dezera", 0.0 },
  { "Dezerae", 0.0 },
  { "Dezerai", 0.0 },
  { "Dezeray", 0.0 },
  { "Dezere", 0.0 },
  { "Dezerea", 0.0 },
  { "Dezeree", 0.0 },
  { "Dezerey", 0.0 },
  { "Dezha", 0.0 },
  { "Dezhan", 1.0 },
  { "Dezhanae", 0.0 },
  { "Dezhane", 0.0 },
  { "Dezhaun", 1.0 },
  { "Dezhon", 1.0 },
  { "Dezi", 0.5905512 },
  { "Dezia", 0.0 },
  { "Deziah", 0.025906736 },
  { "Dezion", 1.0 },
  { "Dezira", 0.0 },
  { "Dezirae", 0.0 },
  { "Deziray", 0.0 },
  { "Deziraye", 0.0 },
  { "Dezire", 0.0 },
  { "Dezirea", 0.0 },
  { "Deziree", 0.0 },
  { "Dezirey", 0.0 },
  { "Deziya", 0.0 },
  { "Deziyah", 0.0 },
  { "Dezja", 0.0 },
  { "Dezjuan", 1.0 },
  { "Dezlyn", 0.0 },
  { "Dezlynn", 0.0 },
  { "Dezman", 1.0 },
  { "Dezmand", 1.0 },
  { "Dezmariah", 0.0 },
  { "Dezmarie", 0.0 },
  { "Dezmen", 1.0 },
  { "Dezmend", 1.0 },
  { "Dezmin", 1.0 },
  { "Dezmon", 1.0 },
  { "Dezmond", 1.0 },
  { "Dezmund", 1.0 },
  { "Dezmyn", 0.7619048 },
  { "Dezon", 1.0 },
  { "Dezra", 0.0 },
  { "Dezrae", 0.0 },
  { "Dezree", 0.0 },
  { "Dezstany", 0.0 },
  { "Deztany", 0.0 },
  { "Deztinee", 0.0 },
  { "Deztiney", 0.0 },
  { "Deztini", 0.0 },
  { "Deztiny", 0.0 },
  { "Deztyni", 0.0 },
  { "Dezya", 0.0 },
  { "Dezyah", 0.0 },
  { "Dezyrae", 0.0 },
  { "Dezyre", 0.0 },
  { "Dezzarae", 0.0 },
  { "Dezzie", 0.020242915 },
  { "Dhahran", 1.0 },
  { "Dhairya", 1.0 },
  { "Dhakirah", 0.0 },
  { "Dhalia", 0.0 },
  { "Dhamani", 1.0 },
  { "Dhamar", 0.0 },
  { "Dhameer", 1.0 },
  { "Dhana", 0.0 },
  { "Dhananjay", 1.0 },
  { "Dhane", 1.0 },
  { "Dhanesh", 1.0 },
  { "Dhani", 0.7256944 },
  { "Dhanna", 0.0 },
  { "Dhanush", 1.0 },
  { "Dhanvi", 0.0 },
  { "Dhanvin", 1.0 },
  { "Dhanya", 0.0 },
  { "Dhara", 0.0 },
  { "Dharius", 1.0 },
  { "Dharma", 0.0121951215 },
  { "Dharmesh", 1.0 },
  { "Dharmik", 1.0 },
  { "Dharshini", 0.0 },
  { "Dharti", 0.0 },
  { "Dhati", 1.0 },
  { "Dhatri", 0.0 },
  { "Dhaval", 1.0 },
  { "Dheeksha", 0.0 },
  { "Dheer", 1.0 },
  { "Dheera", 1.0 },
  { "Dheeraj", 1.0 },
  { "Dheeran", 1.0 },
  { "Dhiago", 1.0 },
  { "Dhilan", 1.0 },
  { "Dhillon", 1.0 },
  { "Dhir", 1.0 },
  { "Dhiraj", 1.0 },
  { "Dhiren", 1.0 },
  { "Dhivya", 0.0 },
  { "Dhiya", 0.0 },
  { "Dhrish", 1.0 },
  { "Dhrithi", 0.0 },
  { "Dhriti", 0.0 },
  { "Dhru", 1.0 },
  { "Dhruthi", 0.0 },
  { "Dhruti", 0.0 },
  { "Dhruv", 1.0 },
  { "Dhruva", 1.0 },
  { "Dhruvan", 1.0 },
  { "Dhruvi", 0.0 },
  { "Dhruvin", 1.0 },
  { "Dhvani", 0.0 },
  { "Dhwani", 0.0 },
  { "Dhyaan", 1.0 },
  { "Dhyan", 1.0 },
  { "Dhyana", 0.0 },
  { "Dhyani", 0.0 },
  { "Dhyey", 1.0 },
  { "Dhylan", 1.0 },
  { "Di", 0.18571429 },
  { "Dia", 0.054342307 },
  { "Diab", 1.0 },
  { "Diablo", 1.0 },
  { "Diabolique", 0.33333334 },
  { "Diadra", 0.0 },
  { "Diago", 1.0 },
  { "Diahann", 0.0 },
  { "Diahanna", 0.0 },
  { "Diahn", 0.0 },
  { "Diaja", 0.0 },
  { "Diajah", 0.0 },
  { "Dial", 1.0 },
  { "Diala", 0.0 },
  { "Diallo", 0.99332446 },
  { "Dialo", 1.0 },
  { "Diamani", 0.0 },
  { "Diamante", 0.69417477 },
  { "Diamantina", 0.0 },
  { "Diamon", 0.04699248 },
  { "Diamond", 0.06400511 },
  { "Diamonde", 0.0 },
  { "Diamondique", 0.0 },
  { "Diamondnique", 0.0 },
  { "Diamonds", 0.0 },
  { "Diamone", 0.0 },
  { "Diamoni", 0.0 },
  { "Diamonique", 0.0 },
  { "Diamonta", 1.0 },
  { "Diamontae", 1.0 },
  { "Diamonte", 0.93415636 },
  { "Diamyn", 0.0 },
  { "Dian", 0.017925736 },
  { "Diana", 0.0035943654 },
  { "Dianah", 0.0 },
  { "Dianalaura", 0.0 },
  { "Dianalee", 0.0 },
  { "Dianaliz", 0.0 },
  { "Dianalynn", 0.0 },
  { "Dianalys", 0.0 },
  { "Dianamarie", 0.0 },
  { "Dianara", 0.0 },
  { "Dianca", 0.0 },
  { "Diandra", 0.0 },
  { "Diandre", 0.9734982 },
  { "Diandrea", 0.0 },
  { "Diandria", 0.0 },
  { "Diane", 0.0026689826 },
  { "Dianela", 0.0 },
  { "Dianeli", 0.0 },
  { "Dianelis", 0.0 },
  { "Dianeliz", 0.0 },
  { "Dianelly", 0.0 },
  { "Dianely", 0.0 },
  { "Dianelys", 0.0 },
  { "Dianet", 0.0 },
  { "Dianetta", 0.0 },
  { "Dianette", 0.0 },
  { "Dianey", 0.0 },
  { "Diangela", 0.0 },
  { "Diangelo", 1.0 },
  { "Diani", 0.0 },
  { "Diania", 0.0 },
  { "Dianie", 0.0 },
  { "Dianira", 0.0 },
  { "Dianita", 0.0 },
  { "Diann", 0.0 },
  { "Dianna", 0.0011513691 },
  { "Diannah", 0.0 },
  { "Dianne", 0.0019519567 },
  { "Dianney", 0.0 },
  { "Dianni", 0.0 },
  { "Diannia", 0.0 },
  { "Diannie", 0.0 },
  { "Dianny", 0.0 },
  { "Diante", 0.984814 },
  { "Diantha", 0.0 },
  { "Dianthe", 0.0 },
  { "Dianthia", 0.0 },
  { "Diany", 0.0 },
  { "Diaquan", 1.0 },
  { "Diar", 1.0 },
  { "Diara", 0.0 },
  { "Diarmuid", 1.0 },
  { "Diarra", 0.21081081 },
  { "Diary", 0.0 },
  { "Diasha", 0.0 },
  { "Diasia", 0.0 },
  { "Diasy", 0.0 },
  { "Diaundra", 0.0 },
  { "Diavian", 0.027777778 },
  { "Diavion", 0.13157895 },
  { "Diavione", 0.0 },
  { "Diavionne", 0.0 },
  { "Diavonte", 1.0 },
  { "Diaz", 1.0 },
  { "Diba", 0.0 },
  { "Dibanhi", 0.0 },
  { "Dibbie", 0.0 },
  { "Dicey", 0.0 },
  { "Dichelle", 0.0 },
  { "Dicie", 0.0 },
  { "Dick", 0.99836284 },
  { "Dickey", 1.0 },
  { "Dicki", 0.0 },
  { "Dickie", 0.94490355 },
  { "Dicksie", 0.0 },
  { "Dickson", 1.0 },
  { "Dicky", 1.0 },
  { "Dicy", 0.0 },
  { "Didi", 0.0 },
  { "Didier", 1.0 },
  { "Didra", 0.0 },
  { "Dieatra", 0.0 },
  { "Diedra", 0.0 },
  { "Diedre", 0.0 },
  { "Diedri", 0.0 },
  { "Diedrich", 1.0 },
  { "Diedrick", 1.0 },
  { "Diego", 0.9978593 },
  { "Diella", 0.0 },
  { "Diellza", 0.0 },
  { "Diem", 0.08963093 },
  { "Diena", 0.0 },
  { "Dienna", 0.0 },
  { "Dienne", 0.0 },
  { "Dieon", 1.0 },
  { "Diep", 0.22222222 },
  { "Diera", 0.0 },
  { "Dierdra", 0.0 },
  { "Dierdre", 0.0 },
  { "Dierick", 1.0 },
  { "Dierk", 1.0 },
  { "Dierks", 1.0 },
  { "Dierra", 0.0 },
  { "Dierre", 1.0 },
  { "Diesel", 1.0 },
  { "Diesha", 0.0 },
  { "Dieter", 1.0 },
  { "Dietmar", 1.0 },
  { "Dietra", 0.0 },
  { "Dietrich", 0.9217437 },
  { "Dietrick", 1.0 },
  { "Dietta", 0.0 },
  { "Dieu", 0.0 },
  { "Dieudonne", 0.0 },
  { "Dieynaba", 0.0 },
  { "Diezel", 1.0 },
  { "Digby", 1.0 },
  { "Digna", 0.0 },
  { "Dihanna", 0.0 },
  { "Dija", 0.0 },
  { "Dijana", 0.0 },
  { "Dijion", 1.0 },
  { "Dijohn", 1.0 },
  { "Dijon", 0.9509943 },
  { "Dijonae", 0.0 },
  { "Dijonay", 0.0 },
  { "Dijone", 0.0 },
  { "Dijonna", 0.0 },
  { "Dijonnae", 0.0 },
  { "Dijonnaise", 0.0 },
  { "Dijoun", 1.0 },
  { "Dijuan", 1.0 },
  { "Dikembe", 1.0 },
  { "Dikran", 1.0 },
  { "Diksha", 0.0 },
  { "Dila", 0.0 },
  { "Dilan", 0.97606456 },
  { "Dilana", 0.0 },
  { "Diland", 1.0 },
  { "Dilanjan", 1.0 },
  { "Dilann", 1.0 },
  { "Dilany", 0.0 },
  { "Dilara", 0.0 },
  { "Dilayla", 0.0 },
  { "Dilbert", 1.0 },
  { "Dilcia", 0.0 },
  { "Dilek", 0.0 },
  { "Dilen", 1.0 },
  { "Dilenny", 0.0 },
  { "Dileydi", 0.0 },
  { "Dilia", 0.0 },
  { "Diliana", 0.0 },
  { "Dililah", 0.0 },
  { "Dilin", 1.0 },
  { "Dill", 1.0 },
  { "Dilla", 0.0 },
  { "Dillan", 0.9578003 },
  { "Dillard", 1.0 },
  { "Dillen", 0.9233983 },
  { "Dillian", 1.0 },
  { "Dillie", 0.0 },
  { "Dillin", 1.0 },
  { "Dillinger", 1.0 },
  { "Dillion", 1.0 },
  { "Dillon", 0.9904377 },
  { "Dillonger", 1.0 },
  { "Dillyn", 0.7055655 },
  { "Dillynn", 0.0 },
  { "Dilma", 0.0 },
  { "Dilmon", 1.0 },
  { "Dilon", 1.0 },
  { "Dilpreet", 0.50666666 },
  { "Dilraj", 1.0 },
  { "Dilreet", 0.0 },
  { "Dilshaan", 1.0 },
  { "Dilshan", 1.0 },
  { "Dilson", 1.0 },
  { "Dilver", 1.0 },
  { "Dilworth", 1.0 },
  { "Dilyla", 0.0 },
  { "Dilylah", 0.0 },
  { "Dilyn", 0.6293996 },
  { "Dilynn", 0.10230179 },
  { "Dilys", 0.0 },
  { "Dim", 0.0 },
  { "Dima", 0.18404908 },
  { "Dimaggio", 1.0 },
  { "Dimani", 1.0 },
  { "Dimante", 1.0 },
  { "Dimar", 1.0 },
  { "Dimarco", 1.0 },
  { "Dimarcus", 1.0 },
  { "Dimari", 1.0 },
  { "Dimario", 1.0 },
  { "Dimarion", 1.0 },
  { "Dimas", 1.0 },
  { "Dimesha", 0.0 },
  { "Dimetra", 0.0 },
  { "Dimetri", 1.0 },
  { "Dimetrius", 1.0 },
  { "Dimia", 0.0 },
  { "Diminic", 1.0 },
  { "Dimitar", 1.0 },
  { "Dimitra", 0.0 },
  { "Dimitre", 1.0 },
  { "Dimitri", 0.9872881 },
  { "Dimitria", 0.0 },
  { "Dimitric", 1.0 },
  { "Dimitrie", 1.0 },
  { "Dimitrios", 1.0 },
  { "Dimitrious", 1.0 },
  { "Dimitris", 1.0 },
  { "Dimitrius", 1.0 },
  { "Dimitriy", 1.0 },
  { "Dimitry", 1.0 },
  { "Dimon", 0.16949153 },
  { "Dimond", 0.0 },
  { "Dimonique", 0.0 },
  { "Dimonte", 1.0 },
  { "Dimple", 0.0 },
  { "Dimples", 0.0 },
  { "Dimya", 0.0 },
  { "Din", 1.0 },
  { "Dina", 0.002494011 },
  { "Dinae", 0.0 },
  { "Dinah", 0.0 },
  { "Dinahlee", 0.0 },
  { "Dinalee", 0.0 },
  { "Dinamarie", 0.0 },
  { "Dinara", 0.0 },
  { "Dinari", 1.0 },
  { "Dinasia", 0.0 },
  { "Dinasti", 0.0 },
  { "Dinasty", 0.0 },
  { "Dindi", 0.0 },
  { "Dinean", 0.0 },
  { "Dineen", 0.0 },
  { "Dineisha", 0.0 },
  { "Dinelle", 0.0 },
  { "Dinene", 0.0 },
  { "Dinero", 1.0 },
  { "Dinese", 0.0 },
  { "Dinesh", 1.0 },
  { "Dinesha", 0.0 },
  { "Dineshia", 0.0 },
  { "Dinetta", 0.0 },
  { "Dinh", 1.0 },
  { "Dinia", 0.0 },
  { "Dinise", 0.0 },
  { "Dinisha", 0.0 },
  { "Dinita", 0.0 },
  { "Dink", 1.0 },
  { "Dinna", 0.0 },
  { "Dinnah", 0.0 },
  { "Dinneen", 0.0 },
  { "Dinnia", 0.0 },
  { "Dinnie", 0.84375 },
  { "Dinnis", 1.0 },
  { "Dino", 1.0 },
  { "Dinora", 0.0 },
  { "Dinorah", 0.0 },
  { "Dinos", 1.0 },
  { "Diny", 0.0 },
  { "Dio", 1.0 },
  { "Diocelina", 0.0 },
  { "Diogenes", 1.0 },
  { "Diogo", 1.0 },
  { "Diolinda", 0.0 },
  { "Diomar", 1.0 },
  { "Diomedes", 1.0 },
  { "Dion", 0.9369462 },
  { "Diona", 0.0 },
  { "Dionah", 0.0 },
  { "Dionca", 0.0 },
  { "Diondra", 0.007215007 },
  { "Diondray", 1.0 },
  { "Diondre", 1.0 },
  { "Diondria", 0.0 },
  { "Dione", 0.19021173 },
  { "Dionel", 1.0 },
  { "Dioni", 0.44444445 },
  { "Dionicia", 0.0 },
  { "Dionicio", 1.0 },
  { "Dionis", 1.0 },
  { "Dionisia", 0.0 },
  { "Dionisio", 1.0 },
  { "Dionisios", 1.0 },
  { "Dionn", 1.0 },
  { "Dionna", 0.0013709898 },
  { "Dionnah", 0.0 },
  { "Dionne", 0.041399073 },
  { "Dionni", 0.0 },
  { "Dionnie", 0.0 },
  { "Dionta", 1.0 },
  { "Diontae", 1.0 },
  { "Diontay", 1.0 },
  { "Diontaye", 1.0 },
  { "Dionte", 0.99122804 },
  { "Diontray", 1.0 },
  { "Diontre", 1.0 },
  { "Diony", 1.0 },
  { "Dionysia", 0.0 },
  { "Dionysios", 1.0 },
  { "Dionysius", 1.0 },
  { "Dionysus", 1.0 },
  { "Dionza", 0.0 },
  { "Diop", 1.0 },
  { "Dior", 0.27626136 },
  { "Diora", 0.0 },
  { "Diore", 0.0 },
  { "Dioselin", 0.0 },
  { "Dioselina", 0.0 },
  { "Dioseline", 0.0 },
  { "Dioselyn", 0.0 },
  { "Diovanni", 1.0 },
  { "Dipa", 0.0 },
  { "Dipak", 1.0 },
  { "Dipali", 0.0 },
  { "Dipesh", 1.0 },
  { "Dipson", 1.0 },
  { "Dipti", 0.0 },
  { "Diquan", 1.0 },
  { "Diquon", 1.0 },
  { "Diran", 1.0 },
  { "Dirck", 1.0 },
  { "Diretha", 0.0 },
  { "Dirinda", 0.0 },
  { "Dirk", 1.0 },
  { "Dirl", 1.0 },
  { "Diron", 1.0 },
  { "Dirrick", 1.0 },
  { "Disa", 0.0 },
  { "Disaya", 0.0 },
  { "Diseree", 0.0 },
  { "Disha", 0.0 },
  { "Dishan", 1.0 },
  { "Dishaun", 1.0 },
  { "Dishawn", 1.0 },
  { "Disheka", 0.0 },
  { "Dishita", 0.0 },
  { "Dishon", 1.0 },
  { "Disiree", 0.0 },
  { "Disney", 0.037037037 },
  { "Dison", 1.0 },
  { "Dissie", 0.0 },
  { "Distin", 1.0 },
  { "Distiny", 0.0 },
  { "Dita", 0.0 },
  { "Diti", 0.0 },
  { "Ditya", 0.0 },
  { "Diva", 0.0 },
  { "Divam", 1.0 },
  { "Divan", 1.0 },
  { "Divante", 1.0 },
  { "Divany", 0.0 },
  { "Diven", 1.0 },
  { "Divesh", 1.0 },
  { "Divia", 0.0 },
  { "Diviana", 0.0 },
  { "Divid", 1.0 },
  { "Divij", 1.0 },
  { "Divija", 0.0 },
  { "Divin", 1.0 },
  { "Divina", 0.0 },
  { "Divine", 0.42593277 },
  { "Divinity", 0.0 },
  { "Divion", 1.0 },
  { "Divisha", 0.0 },
  { "Divit", 1.0 },
  { "Divith", 1.0 },
  { "Divleen", 0.0 },
  { "Divon", 1.0 },
  { "Divontae", 1.0 },
  { "Divonte", 1.0 },
  { "Divya", 0.006802721 },
  { "Divyam", 1.0 },
  { "Divyansh", 1.0 },
  { "Divyanshi", 0.0 },
  { "Divyesh", 1.0 },
  { "Divyne", 0.0 },
  { "Dix", 1.0 },
  { "Dixee", 0.0 },
  { "Dixi", 0.0 },
  { "Dixiana", 0.0 },
  { "Dixianna", 0.0 },
  { "Dixie", 0.017295308 },
  { "Dixielee", 0.0 },
  { "Dixielynn", 0.0 },
  { "Dixon", 0.99810964 },
  { "Dixy", 0.0 },
  { "Diya", 0.0032249396 },
  { "Diyaa", 0.0 },
  { "Diyala", 0.0 },
  { "Diyan", 1.0 },
  { "Diyana", 0.0 },
  { "Diyanna", 0.0 },
  { "Diyar", 1.0 },
  { "Diyari", 1.0 },
  { "Diyon", 1.0 },
  { "Diyonna", 0.0 },
  { "Diyor", 1.0 },
  { "Diyora", 0.0 },
  { "Dizzy", 1.0 },
  { "Dj", 0.9813218 },
  { "Djamila", 0.0 },
  { "Djana", 0.0 },
  { "Djanae", 0.0 },
  { "Django", 1.0 },
  { "Djaun", 1.0 },
  { "Djavan", 1.0 },
  { "Djavon", 1.0 },
  { "Djay", 1.0 },
  { "Djellza", 0.0 },
  { "Djenaba", 0.0 },
  { "Djenabou", 0.0 },
  { "Djene", 0.0 },
  { "Djeneba", 0.0 },
  { "Djenne", 0.0 },
  { "Djibril", 1.0 },
  { "Djimon", 0.95473254 },
  { "Djon", 1.0 },
  { "Djordje", 1.0 },
  { "Djuan", 0.99517244 },
  { "Djuana", 0.0 },
  { "Djuanna", 0.0 },
  { "Djuna", 0.0 },
  { "Dkaiden", 1.0 },
  { "Dkari", 1.0 },
  { "Dkayla", 0.0 },
  { "Dkhari", 1.0 },
  { "Dkota", 1.0 },
  { "Dkwon", 1.0 },
  { "Dlana", 0.0 },
  { "Dlaney", 0.0 },
  { "Dlayna", 0.0 },
  { "Dlila", 0.0 },
  { "Dlilah", 0.0 },
  { "Dlinda", 0.0 },
  { "Dlisa", 0.0 },
  { "Dliyah", 0.0 },
  { "Dlorah", 0.0 },
  { "Dlyan", 1.0 },
  { "Dlyla", 0.0 },
  { "Dlylah", 0.0 },
  { "Dlynn", 0.0 },
  { "Dmani", 0.7282609 },
  { "Dmar", 1.0 },
  { "Dmarco", 1.0 },
  { "Dmarcus", 1.0 },
  { "Dmareon", 1.0 },
  { "Dmari", 1.0 },
  { "Dmaria", 0.0 },
  { "Dmarian", 1.0 },
  { "Dmario", 1.0 },
  { "Dmarion", 1.0 },
  { "Dmarius", 1.0 },
  { "Dmarko", 1.0 },
  { "Dmarkus", 1.0 },
  { "Dmarquis", 1.0 },
  { "Dmarrion", 1.0 },
  { "Dmauri", 1.0 },
  { "Dmaurion", 1.0 },
  { "Dmaya", 0.0 },
  { "Dmetri", 1.0 },
  { "Dmetrius", 1.0 },
  { "Dmia", 0.0 },
  { "Dmichael", 1.0 },
  { "Dmir", 1.0 },
  { "Dmiracle", 0.0 },
  { "Dmitri", 1.0 },
  { "Dmitris", 1.0 },
  { "Dmitrius", 1.0 },
  { "Dmitriy", 1.0 },
  { "Dmitry", 1.0 },
  { "Dmiya", 0.0 },
  { "Dmiyah", 0.0 },
  { "Dmon", 1.0 },
  { "Dmoni", 1.0 },
  { "Dmontae", 1.0 },
  { "Dmonte", 1.0 },
  { "Dmorea", 1.0 },
  { "Dmya", 0.0 },
  { "Dmyah", 0.0 },
  { "Dnae", 0.0 },
  { "Dnaiel", 1.0 },
  { "Dnaielle", 0.0 },
  { "Dnaja", 0.0 },
  { "Dnajah", 0.0 },
  { "Dnasia", 0.0 },
  { "Dnaya", 0.0 },
  { "Dneisha", 0.0 },
  { "Dnesha", 0.0 },
  { "Dnia", 0.0 },
  { "Dniah", 0.0 },
  { "Dniel", 1.0 },
  { "Dnielle", 0.0 },
  { "Dnijah", 0.0 },
  { "Dnisha", 0.0 },
  { "Dniya", 0.0 },
  { "Dniyah", 0.0 },
  { "Dnya", 0.0 },
  { "Dnyah", 0.0 },
  { "Dnyia", 0.0 },
  { "Dnyla", 0.0 },
  { "Dnylah", 0.0 },
  { "Do", 1.0 },
  { "Doaa", 0.0 },
  { "Doak", 1.0 },
  { "Doan", 0.6851852 },
  { "Doane", 1.0 },
  { "Doanld", 1.0 },
  { "Dobbie", 0.6875 },
  { "Dobby", 1.0 },
  { "Dobie", 1.0 },
  { "Doborah", 0.0 },
  { "Doc", 1.0 },
  { "Docia", 0.0 },
  { "Docie", 0.0 },
  { "Dock", 1.0 },
  { "Dockie", 1.0 },
  { "Doctor", 1.0 },
  { "Dodd", 1.0 },
  { "Doddie", 0.0 },
  { "Dodge", 1.0 },
  { "Dodger", 1.0 },
  { "Dodi", 0.010799136 },
  { "Dodie", 0.0 },
  { "Dodson", 1.0 },
  { "Dody", 0.0 },
  { "Doe", 0.0 },
  { "Doel", 1.0 },
  { "Doha", 0.0 },
  { "Dohn", 1.0 },
  { "Dohnovan", 1.0 },
  { "Doil", 1.0 },
  { "Dois", 0.61935484 },
  { "Dokken", 1.0 },
  { "Dokota", 1.0 },
  { "Dola", 0.0 },
  { "Dolan", 1.0 },
  { "Dolce", 0.0 },
  { "Dolen", 1.0 },
  { "Dolena", 0.0 },
  { "Dolene", 0.0 },
  { "Doletha", 0.0 },
  { "Doll", 0.062015504 },
  { "Dolleen", 0.0 },
  { "Dollena", 0.0 },
  { "Dollene", 0.0 },
  { "Dolley", 0.0 },
  { "Dolli", 0.0 },
  { "Dollicia", 0.0 },
  { "Dollie", 0.003176587 },
  { "Dollinda", 0.0 },
  { "Dolline", 0.0 },
  { "Dolly", 0.0022171831 },
  { "Dollye", 0.0 },
  { "Dolora", 0.0 },
  { "Doloras", 0.0 },
  { "Dolores", 0.0062941676 },
  { "Dolorese", 0.0 },
  { "Dolorez", 0.0 },
  { "Doloria", 0.0 },
  { "Dolories", 0.0 },
  { "Doloris", 0.0 },
  { "Dolorita", 0.0 },
  { "Doloros", 0.0 },
  { "Dolorosa", 0.0 },
  { "Dolorous", 0.0 },
  { "Dolorse", 0.0 },
  { "Dolph", 1.0 },
  { "Dolphine", 0.0 },
  { "Dolphis", 1.0 },
  { "Dolphus", 1.0 },
  { "Dolres", 0.0 },
  { "Dolton", 1.0 },
  { "Dom", 1.0 },
  { "Domani", 0.9846626 },
  { "Domanic", 0.9903509 },
  { "Domanick", 1.0 },
  { "Domanik", 1.0 },
  { "Domanique", 0.2802303 },
  { "Domari", 1.0 },
  { "Domarion", 1.0 },
  { "Domeeka", 0.0 },
  { "Domenic", 1.0 },
  { "Domenica", 0.0 },
  { "Domenick", 1.0 },
  { "Domenico", 1.0 },
  { "Domenik", 0.97727275 },
  { "Domenique", 0.25757575 },
  { "Domer", 1.0 },
  { "Dometrius", 1.0 },
  { "Domian", 1.0 },
  { "Domiano", 1.0 },
  { "Domica", 0.0 },
  { "Domicella", 0.0 },
  { "Domico", 1.0 },
  { "Domie", 0.0 },
  { "Domina", 0.0 },
  { "Dominador", 1.0 },
  { "Dominae", 0.0 },
  { "Dominant", 1.0 },
  { "Dominck", 1.0 },
  { "Domineck", 1.0 },
  { "Dominee", 0.0 },
  { "Domineek", 1.0 },
  { "Dominek", 0.77272725 },
  { "Domineke", 1.0 },
  { "Domineque", 0.36585367 },
  { "Dominesha", 0.0 },
  { "Dominga", 0.0026123303 },
  { "Domingo", 0.9980983 },
  { "Domingos", 1.0 },
  { "Domingue", 0.21839081 },
  { "Domini", 0.0 },
  { "Dominic", 0.9925706 },
  { "Dominica", 0.0 },
  { "Dominicc", 1.0 },
  { "Dominice", 0.0 },
  { "Dominicia", 0.0 },
  { "Dominick", 0.995667 },
  { "Dominicka", 0.0 },
  { "Dominico", 1.0 },
  { "Dominie", 0.95804197 },
  { "Dominigue", 0.21800947 },
  { "Dominik", 0.9883278 },
  { "Dominika", 0.0 },
  { "Dominike", 1.0 },
  { "Dominio", 1.0 },
  { "Dominion", 1.0 },
  { "Dominiq", 0.9822695 },
  { "Dominiqu", 0.0 },
  { "Dominiqua", 0.0 },
  { "Dominique", 0.30688015 },
  { "Dominisha", 0.0 },
  { "Domino", 0.052083332 },
  { "Dominoe", 0.0 },
  { "Dominque", 0.37974682 },
  { "Dominquie", 0.5 },
  { "Dominus", 1.0 },
  { "Dominyc", 1.0 },
  { "Dominyck", 1.0 },
  { "Dominyk", 1.0 },
  { "Dominykas", 1.0 },
  { "Domique", 0.32850242 },
  { "Domita", 0.0 },
  { "Domitila", 0.0 },
  { "Domitilo", 1.0 },
  { "Domminic", 1.0 },
  { "Domminick", 1.0 },
  { "Dommonique", 0.0 },
  { "Domnic", 1.0 },
  { "Domnick", 1.0 },
  { "Domnik", 1.0 },
  { "Domnique", 0.33971292 },
  { "Domoni", 1.0 },
  { "Domonic", 0.9762496 },
  { "Domonica", 0.0 },
  { "Domonick", 1.0 },
  { "Domonigue", 0.0 },
  { "Domonik", 1.0 },
  { "Domonique", 0.25622466 },
  { "Domonque", 0.0 },
  { "Domunique", 1.0 },
  { "Domynic", 1.0 },
  { "Domynick", 1.0 },
  { "Domynik", 1.0 },
  { "Domynique", 0.0 },
  { "Don", 0.99281263 },
  { "Dona", 0.009206166 },
  { "Donabelle", 0.0 },
  { "Donaciana", 0.0 },
  { "Donaciano", 1.0 },
  { "Donae", 0.02955665 },
  { "Donagene", 0.0 },
  { "Donah", 0.0 },
  { "Donahue", 1.0 },
  { "Donail", 1.0 },
  { "Donajean", 0.0 },
  { "Donaji", 0.0 },
  { "Donal", 0.99864167 },
  { "Donald", 0.9960697 },
  { "Donalda", 0.0 },
  { "Donaldeen", 0.0 },
  { "Donaldine", 0.0 },
  { "Donaldo", 1.0 },
  { "Donaldson", 1.0 },
  { "Donalee", 0.0 },
  { "Donaleen", 0.0 },
  { "Donalene", 0.0 },
  { "Donall", 1.0 },
  { "Donalyn", 0.0 },
  { "Donalynn", 0.0 },
  { "Donamarie", 0.0 },
  { "Donard", 1.0 },
  { "Donashia", 0.0 },
  { "Donasia", 0.0 },
  { "Donat", 1.0 },
  { "Donata", 0.0 },
  { "Donate", 1.0 },
  { "Donatella", 0.0 },
  { "Donatello", 1.0 },
  { "Donathan", 1.0 },
  { "Donathon", 1.0 },
  { "Donato", 1.0 },
  { "Donavan", 0.99935883 },
  { "Donaven", 1.0 },
  { "Donavin", 1.0 },
  { "Donavon", 1.0 },
  { "Donavyn", 1.0 },
  { "Doncella", 0.0 },
  { "Donchevell", 1.0 },
  { "Donda", 0.0 },
  { "Dondee", 0.0 },
  { "Dondi", 0.67076385 },
  { "Dondie", 0.0 },
  { "Dondra", 0.03929273 },
  { "Dondrae", 1.0 },
  { "Dondray", 1.0 },
  { "Dondre", 1.0 },
  { "Dondrea", 0.1827957 },
  { "Dondrell", 1.0 },
  { "Dondrey", 1.0 },
  { "Dondria", 0.0 },
  { "Dondrick", 1.0 },
  { "Doneal", 1.0 },
  { "Donecia", 0.0 },
  { "Doneen", 0.0 },
  { "Doneisha", 0.0 },
  { "Doneka", 0.0 },
  { "Donel", 0.95839113 },
  { "Doneld", 1.0 },
  { "Donelda", 0.0 },
  { "Donelia", 0.0 },
  { "Donell", 0.88857466 },
  { "Donella", 0.0 },
  { "Donelle", 0.21898822 },
  { "Donene", 0.0 },
  { "Donese", 0.0 },
  { "Donesha", 0.0 },
  { "Doneshia", 0.0 },
  { "Donesia", 0.0 },
  { "Doneta", 0.0 },
  { "Donetta", 0.0 },
  { "Donette", 0.0 },
  { "Doneva", 0.0 },
  { "Donevan", 1.0 },
  { "Donevin", 1.0 },
  { "Doney", 0.5 },
  { "Dong", 1.0 },
  { "Doni", 0.16502462 },
  { "Donia", 0.0 },
  { "Donica", 0.0 },
  { "Donice", 0.0 },
  { "Donicia", 0.0 },
  { "Donicio", 1.0 },
  { "Donie", 0.12051518 },
  { "Doniece", 0.0 },
  { "Doniel", 0.98172325 },
  { "Doniell", 0.0 },
  { "Donielle", 0.044585988 },
  { "Doniesha", 0.0 },
  { "Donika", 0.0 },
  { "Doninic", 1.0 },
  { "Doninique", 0.20652173 },
  { "Doniqua", 0.0 },
  { "Donique", 0.2278481 },
  { "Donis", 0.16172107 },
  { "Donise", 0.0 },
  { "Donisha", 0.0 },
  { "Donishia", 0.0 },
  { "Donita", 0.0 },
  { "Donitra", 0.0 },
  { "Donitta", 0.0 },
  { "Donivan", 1.0 },
  { "Donivee", 0.0 },
  { "Doniven", 1.0 },
  { "Donivin", 1.0 },
  { "Donivon", 1.0 },
  { "Doniya", 0.0 },
  { "Doniyah", 0.0 },
  { "Donja", 0.0 },
  { "Donjae", 1.0 },
  { "Donjanae", 0.0 },
  { "Donjay", 1.0 },
  { "Donje", 1.0 },
  { "Donjuan", 1.0 },
  { "Donlad", 1.0 },
  { "Donld", 1.0 },
  { "Donley", 1.0 },
  { "Donminique", 1.0 },
  { "Donmonique", 0.0 },
  { "Donn", 0.99060035 },
  { "Donna", 0.0026801089 },
  { "Donnabel", 0.0 },
  { "Donnabell", 0.0 },
  { "Donnabelle", 0.0 },
  { "Donnae", 0.0 },
  { "Donnah", 0.0 },
  { "Donnajean", 0.0 },
  { "Donnajo", 0.0 },
  { "Donnal", 1.0 },
  { "Donnald", 1.0 },
  { "Donnalee", 0.0 },
  { "Donnalou", 0.0 },
  { "Donnalyn", 0.0 },
  { "Donnalynn", 0.0 },
  { "Donnamae", 0.0 },
  { "Donnamaria", 0.0 },
  { "Donnamarie", 0.0 },
  { "Donnarae", 0.0 },
  { "Donnas", 0.0 },
  { "Donnasia", 0.0 },
  { "Donnavan", 1.0 },
  { "Donnaven", 1.0 },
  { "Donnavin", 1.0 },
  { "Donnavon", 1.0 },
  { "Donnay", 0.0 },
  { "Donne", 0.40609136 },
  { "Donneisha", 0.0 },
  { "Donnel", 0.94247246 },
  { "Donnell", 0.93150866 },
  { "Donnella", 0.0 },
  { "Donnelle", 0.4259928 },
  { "Donnelly", 1.0 },
  { "Donner", 1.0 },
  { "Donnesha", 0.0 },
  { "Donneshia", 0.0 },
  { "Donneta", 0.0 },
  { "Donnett", 0.0 },
  { "Donnetta", 0.0 },
  { "Donnette", 0.0 },
  { "Donney", 1.0 },
  { "Donni", 0.032432433 },
  { "Donnia", 0.0 },
  { "Donnica", 0.0 },
  { "Donnice", 0.0 },
  { "Donnie", 0.8940832 },
  { "Donniece", 0.0 },
  { "Donnielle", 0.0 },
  { "Donniesha", 0.0 },
  { "Donnika", 0.0 },
  { "Donnis", 0.30359522 },
  { "Donnise", 0.0 },
  { "Donnisha", 0.0 },
  { "Donnita", 0.0 },
  { "Donnitta", 0.0 },
  { "Donnivan", 1.0 },
  { "Donnivin", 1.0 },
  { "Donnovan", 1.0 },
  { "Donnovin", 1.0 },
  { "Donny", 0.9968407 },
  { "Donnye", 1.0 },
  { "Donoban", 1.0 },
  { "Donold", 1.0 },
  { "Donovan", 0.99616 },
  { "Donovann", 1.0 },
  { "Donoven", 1.0 },
  { "Donovin", 1.0 },
  { "Donovon", 1.0 },
  { "Donovyn", 1.0 },
  { "Donquarius", 1.0 },
  { "Donquavious", 1.0 },
  { "Donquell", 1.0 },
  { "Donquez", 1.0 },
  { "Donrico", 1.0 },
  { "Donsha", 0.49019608 },
  { "Donshae", 0.325 },
  { "Donshay", 0.6956522 },
  { "Donta", 0.9760841 },
  { "Dontae", 0.99686635 },
  { "Dontai", 1.0 },
  { "Dontajah", 0.0 },
  { "Dontario", 1.0 },
  { "Dontarious", 1.0 },
  { "Dontarius", 1.0 },
  { "Dontarrius", 1.0 },
  { "Dontasia", 0.0 },
  { "Dontate", 1.0 },
  { "Dontavia", 0.09243698 },
  { "Dontavian", 1.0 },
  { "Dontavias", 1.0 },
  { "Dontavion", 1.0 },
  { "Dontavious", 1.0 },
  { "Dontavis", 1.0 },
  { "Dontavius", 1.0 },
  { "Dontay", 1.0 },
  { "Dontaye", 1.0 },
  { "Dontaysha", 0.0 },
  { "Dontaz", 1.0 },
  { "Donte", 0.9908189 },
  { "Dontea", 1.0 },
  { "Dontee", 1.0 },
  { "Dontel", 1.0 },
  { "Dontell", 1.0 },
  { "Donterio", 1.0 },
  { "Donterious", 1.0 },
  { "Donterius", 1.0 },
  { "Donterrio", 1.0 },
  { "Donterrious", 1.0 },
  { "Donterrius", 1.0 },
  { "Dontevion", 1.0 },
  { "Dontevious", 1.0 },
  { "Dontevius", 1.0 },
  { "Dontey", 1.0 },
  { "Dontez", 1.0 },
  { "Donti", 1.0 },
  { "Dontia", 0.26530612 },
  { "Dontonio", 1.0 },
  { "Dontra", 1.0 },
  { "Dontrae", 1.0 },
  { "Dontrail", 1.0 },
  { "Dontravious", 1.0 },
  { "Dontravius", 1.0 },
  { "Dontray", 1.0 },
  { "Dontre", 1.0 },
  { "Dontrea", 1.0 },
  { "Dontreal", 1.0 },
  { "Dontrel", 1.0 },
  { "Dontrell", 0.99381286 },
  { "Dontrelle", 1.0 },
  { "Dontrey", 1.0 },
  { "Dontrez", 1.0 },
  { "Dontrice", 0.0 },
  { "Donvan", 1.0 },
  { "Dony", 1.0 },
  { "Donya", 0.10663984 },
  { "Donyae", 0.58674467 },
  { "Donyai", 1.0 },
  { "Donyale", 0.18244803 },
  { "Donye", 0.74927115 },
  { "Donyea", 0.6501901 },
  { "Donyel", 0.45142856 },
  { "Donyell", 0.5587583 },
  { "Donyelle", 0.038659792 },
  { "Donyetta", 0.0 },
  { "Donza", 0.0 },
  { "Donzaleigh", 0.0 },
  { "Donzel", 1.0 },
  { "Donzell", 0.9776699 },
  { "Donzella", 0.0 },
  { "Donzetta", 0.0 },
  { "Dooley", 1.0 },
  { "Dor", 0.6875 },
  { "Dora", 0.005202766 },
  { "Dorabelle", 0.0 },
  { "Dorace", 0.0 },
  { "Dorae", 0.0 },
  { "Doraelia", 0.0 },
  { "Dorah", 0.0 },
  { "Dorain", 0.85106385 },
  { "Doraine", 0.0 },
  { "Doral", 0.7152318 },
  { "Doralee", 0.0 },
  { "Doralene", 0.0 },
  { "Doraline", 0.0 },
  { "Doraliz", 0.0 },
  { "Doraly", 0.0 },
  { "Doralyn", 0.0 },
  { "Doralynn", 0.0 },
  { "Doramae", 0.0 },
  { "Doran", 0.9791667 },
  { "Dorance", 1.0 },
  { "Doranda", 0.0 },
  { "Dorane", 0.0 },
  { "Dorann", 0.0 },
  { "Doranna", 0.0 },
  { "Doranne", 0.0 },
  { "Doras", 0.0 },
  { "Doratha", 0.0 },
  { "Dorathea", 0.0 },
  { "Dorathy", 0.0 },
  { "Doray", 0.0 },
  { "Dorca", 0.0 },
  { "Dorcas", 0.0 },
  { "Dorce", 1.0 },
  { "Dorcia", 0.0 },
  { "Dorcie", 0.1923077 },
  { "Dorcus", 0.017421603 },
  { "Dorcy", 1.0 },
  { "Dore", 0.09389672 },
  { "Dorea", 0.0 },
  { "Dorean", 0.2639296 },
  { "Doreatha", 0.0 },
  { "Doreathea", 0.0 },
  { "Doreather", 0.0 },
  { "Doree", 0.0 },
  { "Doreen", 0.0012527809 },
  { "Doreena", 0.0 },
  { "Doreene", 0.0 },
  { "Dorel", 1.0 },
  { "Dorelia", 0.0 },
  { "Dorell", 1.0 },
  { "Dorella", 0.0 },
  { "Dorelle", 0.0 },
  { "Doremus", 1.0 },
  { "Doren", 0.89915967 },
  { "Dorena", 0.0 },
  { "Dorenda", 0.0 },
  { "Dorene", 0.0 },
  { "Doreon", 1.0 },
  { "Dores", 0.2173913 },
  { "Doresa", 0.0 },
  { "Dorese", 0.0 },
  { "Doresha", 0.0 },
  { "Doretha", 0.0 },
  { "Dorethea", 0.0 },
  { "Dorether", 0.0 },
  { "Dorethia", 0.0 },
  { "Dorethy", 0.0 },
  { "Doretta", 0.0 },
  { "Dorette", 0.0 },
  { "Dorey", 0.12727273 },
  { "Dori", 0.0 },
  { "Doria", 0.0 },
  { "Dorian", 0.8142731 },
  { "Doriana", 0.0 },
  { "Doriane", 0.0 },
  { "Doriann", 0.0 },
  { "Dorianna", 0.0 },
  { "Dorianne", 0.0 },
  { "Dorica", 0.0 },
  { "Dorice", 0.0 },
  { "Dorie", 0.020466173 },
  { "Doriel", 1.0 },
  { "Dorielle", 0.0 },
  { "Dorien", 0.9404145 },
  { "Doriene", 0.0 },
  { "Dorienne", 0.0 },
  { "Dories", 0.0 },
  { "Dorilla", 0.0 },
  { "Dorin", 0.8727273 },
  { "Dorina", 0.0 },
  { "Dorinda", 0.0 },
  { "Dorine", 0.0 },
  { "Dorinna", 0.0 },
  { "Dorinne", 0.0 },
  { "Dorion", 1.0 },
  { "Doris", 0.006970432 },
  { "Dorisa", 0.0 },
  { "Dorisann", 0.0 },
  { "Dorise", 0.0 },
  { "Dorisha", 0.0 },
  { "Dorislee", 0.0 },
  { "Dorismae", 0.0 },
  { "Dorismar", 0.0 },
  { "Dorissa", 0.0 },
  { "Doristeen", 0.0 },
  { "Doristene", 0.0 },
  { "Doristine", 0.0 },
  { "Dorit", 0.0 },
  { "Dorita", 0.0 },
  { "Doritha", 0.0 },
  { "Dorithy", 0.0 },
  { "Dorjan", 1.0 },
  { "Dorla", 0.0 },
  { "Dorlan", 1.0 },
  { "Dorland", 1.0 },
  { "Dorlas", 0.0 },
  { "Dorlean", 0.0 },
  { "Dorlee", 0.0 },
  { "Dorleen", 0.0 },
  { "Dorlene", 0.0 },
  { "Dorles", 0.0 },
  { "Dorline", 0.0 },
  { "Dorlis", 0.0 },
  { "Dorlisa", 0.0 },
  { "Dorma", 0.0 },
  { "Dormalee", 0.0 },
  { "Dorman", 1.0 },
  { "Dormilee", 0.0 },
  { "Dormon", 1.0 },
  { "Dorn", 0.9493671 },
  { "Dorna", 0.0 },
  { "Dorne", 1.0 },
  { "Dornell", 1.0 },
  { "Dornisha", 0.0 },
  { "Doro", 1.0 },
  { "Dorohty", 0.0 },
  { "Doron", 1.0 },
  { "Dorota", 0.0 },
  { "Dorotea", 0.0 },
  { "Doroteo", 1.0 },
  { "Dorotha", 0.0 },
  { "Dorothe", 0.0 },
  { "Dorothea", 0.00017749904 },
  { "Dorothee", 0.0 },
  { "Dorothene", 0.0 },
  { "Dorothey", 0.0 },
  { "Dorothia", 0.0 },
  { "Dorothie", 0.0 },
  { "Dorothy", 0.0033118608 },
  { "Dorothyann", 0.0 },
  { "Dorothye", 0.0 },
  { "Dorothymae", 0.0 },
  { "Doroty", 0.0 },
  { "Dorpha", 0.0 },
  { "Dorr", 1.0 },
  { "Dorra", 0.0 },
  { "Dorrace", 0.0 },
  { "Dorraine", 0.0 },
  { "Dorrance", 1.0 },
  { "Dorreen", 0.0 },
  { "Dorrel", 1.0 },
  { "Dorrell", 1.0 },
  { "Dorren", 0.33333334 },
  { "Dorrence", 1.0 },
  { "Dorrene", 0.0 },
  { "Dorretta", 0.0 },
  { "Dorri", 0.0 },
  { "Dorrian", 0.9329004 },
  { "Dorrie", 0.0 },
  { "Dorrien", 1.0 },
  { "Dorrine", 0.0 },
  { "Dorrion", 1.0 },
  { "Dorris", 0.18539014 },
  { "Dorrit", 0.0 },
  { "Dorron", 1.0 },
  { "Dorry", 0.0 },
  { "Dorsa", 0.0 },
  { "Dorse", 1.0 },
  { "Dorsel", 1.0 },
  { "Dorsett", 1.0 },
  { "Dorsey", 0.8685861 },
  { "Dorsha", 0.0 },
  { "Dorsi", 0.0 },
  { "Dorsie", 0.39379844 },
  { "Dorth", 0.0 },
  { "Dortha", 0.0 },
  { "Dorthay", 0.0 },
  { "Dorthe", 0.0 },
  { "Dorthea", 0.0 },
  { "Dorthella", 0.0 },
  { "Dorthey", 0.0 },
  { "Dorthia", 0.0 },
  { "Dorthie", 0.0 },
  { "Dorthula", 0.0 },
  { "Dorthy", 0.0038835907 },
  { "Doruk", 1.0 },
  { "Dorus", 1.0 },
  { "Dorvin", 1.0 },
  { "Dorwin", 1.0 },
  { "Dory", 0.11888783 },
  { "Doryan", 1.0 },
  { "Doryce", 0.0 },
  { "Dorylee", 0.0 },
  { "Dorys", 0.0 },
  { "Dosha", 0.0 },
  { "Doshia", 0.0 },
  { "Doshie", 0.0 },
  { "Dosia", 0.0 },
  { "Dosie", 0.3 },
  { "Doss", 1.0 },
  { "Dossie", 0.45067698 },
  { "Dot", 0.016528925 },
  { "Dotha", 0.0 },
  { "Dotsie", 0.0 },
  { "Dotson", 1.0 },
  { "Dotsy", 0.0 },
  { "Dott", 0.0 },
  { "Dotti", 0.0 },
  { "Dottie", 0.0 },
  { "Dotty", 0.0 },
  { "Dottye", 0.0 },
  { "Doty", 0.0 },
  { "Doua", 0.58208954 },
  { "Douaa", 0.0 },
  { "Douachee", 0.0 },
  { "Doug", 0.99977744 },
  { "Dougal", 1.0 },
  { "Dougald", 1.0 },
  { "Dougals", 1.0 },
  { "Douglas", 0.9962845 },
  { "Douglass", 0.99549395 },
  { "Dougles", 1.0 },
  { "Douglus", 1.0 },
  { "Doulgas", 1.0 },
  { "Dounia", 0.0 },
  { "Dov", 1.0 },
  { "Dova", 0.0 },
  { "Dovan", 1.0 },
  { "Dovber", 1.0 },
  { "Dove", 0.02739726 },
  { "Dover", 1.0 },
  { "Dovetta", 0.0 },
  { "Dovey", 0.0 },
  { "Dovi", 1.0 },
  { "Dovid", 1.0 },
  { "Dovie", 0.0011214534 },
  { "Dovion", 0.0 },
  { "Dovon", 1.0 },
  { "Dovonte", 1.0 },
  { "Dow", 1.0 },
  { "Doward", 1.0 },
  { "Dowd", 1.0 },
  { "Dowe", 1.0 },
  { "Dowell", 1.0 },
  { "Dowl", 1.0 },
  { "Down", 0.0 },
  { "Downey", 1.0 },
  { "Downing", 1.0 },
  { "Doxie", 0.0 },
  { "Doy", 0.95555556 },
  { "Doyal", 1.0 },
  { "Doyce", 0.84615386 },
  { "Doye", 0.84126985 },
  { "Doyel", 1.0 },
  { "Doyl", 1.0 },
  { "Doyla", 0.0 },
  { "Doyle", 0.9917488 },
  { "Doylene", 0.0 },
  { "Doyne", 0.8769531 },
  { "Doyt", 1.0 },
  { "Dozie", 1.0 },
  { "Dozier", 1.0 },
  { "Dquan", 1.0 },
  { "Dquarious", 1.0 },
  { "Dquarius", 1.0 },
  { "Dquavion", 1.0 },
  { "Drace", 1.0 },
  { "Dracen", 1.0 },
  { "Draco", 1.0 },
  { "Draconis", 1.0 },
  { "Dracy", 1.0 },
  { "Draden", 1.0 },
  { "Dradyn", 1.0 },
  { "Drae", 1.0 },
  { "Draeden", 1.0 },
  { "Draedon", 1.0 },
  { "Draedyn", 1.0 },
  { "Draegan", 1.0 },
  { "Draelyn", 1.0 },
  { "Draeson", 1.0 },
  { "Draevyn", 1.0 },
  { "Dragan", 1.0 },
  { "Dragen", 1.0 },
  { "Drago", 1.0 },
  { "Dragon", 1.0 },
  { "Draiden", 1.0 },
  { "Draidyn", 1.0 },
  { "Draike", 1.0 },
  { "Draiman", 1.0 },
  { "Draiven", 1.0 },
  { "Draizy", 0.0 },
  { "Drakar", 1.0 },
  { "Drake", 0.99759454 },
  { "Draken", 1.0 },
  { "Drakkar", 1.0 },
  { "Drako", 1.0 },
  { "Draper", 1.0 },
  { "Drapper", 1.0 },
  { "Draquan", 1.0 },
  { "Drashawn", 1.0 },
  { "Drashti", 0.0 },
  { "Drason", 1.0 },
  { "Draven", 0.9646432 },
  { "Dravid", 1.0 },
  { "Dravin", 1.0 },
  { "Dravion", 1.0 },
  { "Dravon", 1.0 },
  { "Dravyn", 1.0 },
  { "Drax", 1.0 },
  { "Draxie", 0.0 },
  { "Draxton", 1.0 },
  { "Dray", 1.0 },
  { "Draya", 0.0 },
  { "Drayah", 0.0 },
  { "Drayce", 1.0 },
  { "Draycen", 1.0 },
  { "Drayden", 1.0 },
  { "Draydin", 1.0 },
  { "Draydon", 1.0 },
  { "Drayk", 1.0 },
  { "Drayke", 1.0 },
  { "Draylan", 1.0 },
  { "Draylee", 0.0 },
  { "Draylen", 1.0 },
  { "Draylin", 1.0 },
  { "Draylon", 1.0 },
  { "Draymond", 1.0 },
  { "Drayon", 1.0 },
  { "Draysen", 1.0 },
  { "Drayson", 1.0 },
  { "Drayten", 1.0 },
  { "Drayton", 1.0 },
  { "Drayven", 1.0 },
  { "Drayvin", 1.0 },
  { "Drayvon", 1.0 },
  { "Drazen", 1.0 },
  { "Dre", 1.0 },
  { "Drea", 0.0 },
  { "Dreah", 0.0 },
  { "Dream", 0.07232472 },
  { "Dreama", 0.0 },
  { "Dreamer", 0.058139537 },
  { "Drean", 1.0 },
  { "Dreana", 0.0 },
  { "Dreanna", 0.0 },
  { "Dreauna", 0.0 },
  { "Dreda", 0.0 },
  { "Dredan", 1.0 },
  { "Dreddy", 1.0 },
  { "Dreden", 1.0 },
  { "Dredon", 1.0 },
  { "Dredyn", 1.0 },
  { "Dree", 0.0 },
  { "Dreema", 0.0 },
  { "Dreena", 0.0 },
  { "Dregan", 1.0 },
  { "Dreighton", 1.0 },
  { "Dreion", 1.0 },
  { "Drekwon", 1.0 },
  { "Drelan", 1.0 },
  { "Drelen", 1.0 },
  { "Drelin", 1.0 },
  { "Drelon", 1.0 },
  { "Drelyn", 1.0 },
  { "Drelynn", 0.61290324 },
  { "Drema", 0.0 },
  { "Dremon", 1.0 },
  { "Dremond", 1.0 },
  { "Dren", 1.0 },
  { "Drena", 0.0 },
  { "Drenda", 0.0 },
  { "Drene", 0.0 },
  { "Drenisha", 0.0 },
  { "Dreniyah", 0.0 },
  { "Drenna", 0.0 },
  { "Drennan", 1.0 },
  { "Drennen", 1.0 },
  { "Drennon", 1.0 },
  { "Dreon", 1.0 },
  { "Dreona", 0.0 },
  { "Dreonna", 0.0 },
  { "Drequan", 1.0 },
  { "Dresden", 0.8034682 },
  { "Dresdyn", 1.0 },
  { "Dresean", 1.0 },
  { "Dresha", 0.0 },
  { "Dreshan", 1.0 },
  { "Dreshaun", 1.0 },
  { "Dreshawn", 1.0 },
  { "Dreshon", 1.0 },
  { "Dreshun", 1.0 },
  { "Dreson", 1.0 },
  { "Dresyn", 1.0 },
  { "Dretha", 0.0 },
  { "Dreu", 0.8 },
  { "Dreux", 1.0 },
  { "Drevan", 1.0 },
  { "Drevaughn", 1.0 },
  { "Dreven", 1.0 },
  { "Dreveon", 1.0 },
  { "Drevian", 1.0 },
  { "Drevin", 1.0 },
  { "Drevion", 1.0 },
  { "Drevon", 1.0 },
  { "Drevonn", 1.0 },
  { "Drevonte", 1.0 },
  { "Drevyn", 1.0 },
  { "Drew", 0.91509974 },
  { "Drewann", 0.0 },
  { "Drewcilla", 0.0 },
  { "Drewey", 1.0 },
  { "Drewry", 1.0 },
  { "Drex", 1.0 },
  { "Drexal", 1.0 },
  { "Drexel", 0.97003746 },
  { "Drexell", 1.0 },
  { "Drexler", 1.0 },
  { "Drexton", 1.0 },
  { "Drey", 1.0 },
  { "Dreya", 0.0 },
  { "Dreyah", 0.0 },
  { "Dreyanna", 0.0 },
  { "Dreydan", 1.0 },
  { "Dreyden", 1.0 },
  { "Dreydin", 1.0 },
  { "Dreydon", 1.0 },
  { "Dreyken", 1.0 },
  { "Dreylan", 1.0 },
  { "Dreylin", 1.0 },
  { "Dreylon", 1.0 },
  { "Dreyon", 1.0 },
  { "Dreysen", 1.0 },
  { "Dreyson", 1.0 },
  { "Dreyten", 1.0 },
  { "Dreyton", 1.0 },
  { "Dreyven", 1.0 },
  { "Dreyvin", 1.0 },
  { "Drezden", 1.0 },
  { "Drian", 1.0 },
  { "Driana", 0.0 },
  { "Drianna", 0.0 },
  { "Driggs", 1.0 },
  { "Drilon", 1.0 },
  { "Drin", 1.0 },
  { "Drina", 0.0 },
  { "Drinda", 0.0 },
  { "Drisana", 0.0 },
  { "Driscilla", 0.0 },
  { "Driscoll", 1.0 },
  { "Drish", 1.0 },
  { "Drisha", 0.0 },
  { "Drishti", 0.0 },
  { "Drishya", 0.0 },
  { "Driss", 1.0 },
  { "Dristan", 1.0 },
  { "Dristen", 0.8979592 },
  { "Dristi", 0.0 },
  { "Dristin", 0.73333335 },
  { "Driston", 1.0 },
  { "Dristy", 0.0 },
  { "Drita", 0.0 },
  { "Dritan", 1.0 },
  { "Driton", 1.0 },
  { "Driver", 1.0 },
  { "Driyah", 0.0 },
  { "Drizzt", 1.0 },
  { "Dron", 1.0 },
  { "Dru", 0.59771335 },
  { "Druann", 0.0 },
  { "Druanne", 0.0 },
  { "Druce", 1.0 },
  { "Drucella", 0.0 },
  { "Drucie", 0.0 },
  { "Drucilla", 0.0 },
  { "Drue", 0.5657542 },
  { "Druecilla", 0.0 },
  { "Druey", 1.0 },
  { "Drummond", 1.0 },
  { "Drury", 1.0 },
  { "Druscilla", 0.0 },
  { "Drusella", 0.0 },
  { "Drusie", 0.0 },
  { "Drusilla", 0.0 },
  { "Druzella", 0.0 },
  { "Dryden", 1.0 },
  { "Drystal", 0.0 },
  { "Drystan", 1.0 },
  { "Dryver", 1.0 },
  { "Dsean", 1.0 },
  { "Dshae", 0.0 },
  { "Dshanti", 0.0 },
  { "Dshaun", 1.0 },
  { "Dshawn", 1.0 },
  { "Dshayla", 0.0 },
  { "Dshon", 1.0 },
  { "Dshun", 1.0 },
  { "Du", 1.0 },
  { "Dua", 0.0 },
  { "Duaa", 0.0 },
  { "Duain", 1.0 },
  { "Duaine", 1.0 },
  { "Dual", 1.0 },
  { "Duan", 1.0 },
  { "Duana", 0.0 },
  { "Duane", 0.9912321 },
  { "Duann", 0.0 },
  { "Duanna", 0.0 },
  { "Duanne", 0.66871166 },
  { "Duante", 1.0 },
  { "Duard", 1.0 },
  { "Duarte", 1.0 },
  { "Duayne", 1.0 },
  { "Dub", 1.0 },
  { "Duban", 1.0 },
  { "Dublin", 0.7675841 },
  { "Dublyn", 0.0 },
  { "Dubois", 1.0 },
  { "Dubraska", 0.0 },
  { "Duc", 1.0 },
  { "Ducati", 1.0 },
  { "Duce", 1.0 },
  { "Duchein", 1.0 },
  { "Duchess", 0.0 },
  { "Dud", 1.0 },
  { "Dude", 1.0 },
  { "Dudley", 0.98992443 },
  { "Duel", 1.0 },
  { "Duell", 1.0 },
  { "Duella", 0.0 },
  { "Duewa", 0.0 },
  { "Duey", 1.0 },
  { "Duff", 1.0 },
  { "Duffie", 0.85 },
  { "Duffy", 0.97511667 },
  { "Dugald", 1.0 },
  { "Dugan", 1.0 },
  { "Duglas", 1.0 },
  { "Duha", 0.0 },
  { "Duice", 0.0 },
  { "Duie", 1.0 },
  { "Duilio", 1.0 },
  { "Dujon", 1.0 },
  { "Dujuan", 1.0 },
  { "Dujuana", 0.0 },
  { "Duke", 1.0 },
  { "Dukens", 1.0 },
  { "Dula", 0.0 },
  { "Dulan", 1.0 },
  { "Dulaney", 0.0 },
  { "Dulani", 1.0 },
  { "Dulce", 0.0028536485 },
  { "Dulcemaria", 0.0 },
  { "Dulcey", 0.0 },
  { "Dulcia", 0.0 },
  { "Dulcie", 0.0 },
  { "Dulcinea", 0.0 },
  { "Dulcy", 0.0 },
  { "Dulio", 1.0 },
  { "Dulse", 0.0 },
  { "Dulton", 1.0 },
  { "Dumaka", 1.0 },
  { "Dumar", 1.0 },
  { "Dumas", 1.0 },
  { "Dumont", 1.0 },
  { "Duna", 0.0 },
  { "Dunbar", 1.0 },
  { "Duncan", 0.9994279 },
  { "Dundre", 1.0 },
  { "Dune", 1.0 },
  { "Dung", 0.6203704 },
  { "Dunia", 0.0 },
  { "Duniya", 0.0 },
  { "Dunk", 1.0 },
  { "Dunn", 1.0 },
  { "Dunstan", 1.0 },
  { "Dunta", 1.0 },
  { "Duntae", 1.0 },
  { "Dunte", 1.0 },
  { "Dunya", 0.0 },
  { "Duong", 1.0 },
  { "Dupre", 1.0 },
  { "Dupree", 1.0 },
  { "Dupri", 1.0 },
  { "Duquan", 1.0 },
  { "Dura", 0.0 },
  { "Durah", 0.0 },
  { "Dural", 1.0 },
  { "Duran", 1.0 },
  { "Durand", 1.0 },
  { "Durane", 1.0 },
  { "Durango", 1.0 },
  { "Durant", 1.0 },
  { "Durante", 1.0 },
  { "Durbin", 1.0 },
  { "Dureen", 0.0 },
  { "Durel", 1.0 },
  { "Durell", 1.0 },
  { "Durelle", 0.8067227 },
  { "Durenda", 0.0 },
  { "Durene", 0.0 },
  { "Duretta", 0.0 },
  { "Durga", 0.0 },
  { "Durham", 1.0 },
  { "Durie", 1.0 },
  { "Duriel", 1.0 },
  { "Durinda", 0.0 },
  { "Duriyah", 0.0 },
  { "Durk", 1.0 },
  { "Durke", 1.0 },
  { "Durl", 1.0 },
  { "Durland", 1.0 },
  { "Durlene", 0.0 },
  { "Duron", 1.0 },
  { "Durrani", 0.0 },
  { "Durrel", 1.0 },
  { "Durrell", 1.0 },
  { "Durriyah", 0.0 },
  { "Durron", 1.0 },
  { "Duru", 0.0 },
  { "Durva", 0.0 },
  { "Durville", 1.0 },
  { "Durward", 1.0 },
  { "Durwin", 1.0 },
  { "Durwood", 1.0 },
  { "Duryea", 1.0 },
  { "Dusan", 1.0 },
  { "Dusean", 1.0 },
  { "Dushan", 1.0 },
  { "Dushane", 1.0 },
  { "Dusharme", 0.0 },
  { "Dushaun", 1.0 },
  { "Dushawn", 0.9753363 },
  { "Dushon", 0.85 },
  { "Dusin", 1.0 },
  { "Dusitn", 1.0 },
  { "Duska", 0.0 },
  { "Duskin", 1.0 },
  { "Dustan", 1.0 },
  { "Dustee", 0.0 },
  { "Dusten", 1.0 },
  { "Dusti", 0.005113636 },
  { "Dustie", 0.012114538 },
  { "Dustin", 0.9932858 },
  { "Dustina", 0.0 },
  { "Dustine", 0.3966942 },
  { "Dustinjames", 1.0 },
  { "Dustion", 1.0 },
  { "Dustn", 1.0 },
  { "Duston", 1.0 },
  { "Dustun", 1.0 },
  { "Dusty", 0.70460117 },
  { "Dustyn", 0.976834 },
  { "Dut", 1.0 },
  { "Dutch", 1.0 },
  { "Dutchess", 0.0 },
  { "Duuana", 0.0 },
  { "Duuna", 0.0 },
  { "Duval", 1.0 },
  { "Duvall", 1.0 },
  { "Duvan", 1.0 },
  { "Duveen", 0.0 },
  { "Duvid", 1.0 },
  { "Duvier", 1.0 },
  { "Duvon", 1.0 },
  { "Duwaine", 1.0 },
  { "Duwan", 1.0 },
  { "Duwana", 0.0 },
  { "Duwane", 1.0 },
  { "Duwanna", 0.0 },
  { "Duward", 1.0 },
  { "Duwayne", 1.0 },
  { "Duy", 1.0 },
  { "Duyen", 0.0 },
  { "Dvante", 1.0 },
  { "Dvaughn", 1.0 },
  { "Dvid", 1.0 },
  { "Dvir", 1.0 },
  { "Dvon", 1.0 },
  { "Dvonta", 1.0 },
  { "Dvontae", 1.0 },
  { "Dvonte", 1.0 },
  { "Dvora", 0.0 },
  { "Dvyne", 0.0 },
  { "Dwain", 1.0 },
  { "Dwaina", 0.0 },
  { "Dwaine", 1.0 },
  { "Dwala", 0.0 },
  { "Dwan", 0.5709571 },
  { "Dwana", 0.0 },
  { "Dwanda", 0.0 },
  { "Dwane", 1.0 },
  { "Dwania", 0.0 },
  { "Dwann", 0.8 },
  { "Dwanna", 0.0 },
  { "Dwanye", 1.0 },
  { "Dward", 1.0 },
  { "Dwaun", 1.0 },
  { "Dwaylon", 1.0 },
  { "Dwayn", 1.0 },
  { "Dwayna", 0.0 },
  { "Dwayne", 0.99394506 },
  { "Dwen", 1.0 },
  { "Dwendolyn", 0.0 },
  { "Dwight", 0.99584776 },
  { "Dwij", 1.0 },
  { "Dwija", 0.0 },
  { "Dwon", 1.0 },
  { "Dwone", 1.0 },
  { "Dwright", 1.0 },
  { "Dwuan", 1.0 },
  { "Dwyane", 1.0 },
  { "Dwyer", 1.0 },
  { "Dwyla", 0.0 },
  { "Dwyn", 0.0 },
  { "Dwyne", 1.0 },
  { "Dyala", 0.0 },
  { "Dyami", 0.9833887 },
  { "Dyamon", 0.0 },
  { "Dyamond", 0.008539709 },
  { "Dyan", 0.037866667 },
  { "Dyana", 0.0 },
  { "Dyanara", 0.0 },
  { "Dyandra", 0.0 },
  { "Dyane", 0.0 },
  { "Dyani", 0.009124087 },
  { "Dyanira", 0.0 },
  { "Dyann", 0.0 },
  { "Dyanna", 0.0 },
  { "Dyanne", 0.0 },
  { "Dyanni", 0.0 },
  { "Dyante", 1.0 },
  { "Dyasia", 0.0 },
  { "Dyce", 1.0 },
  { "Dycen", 1.0 },
  { "Dyego", 1.0 },
  { "Dyeisha", 0.0 },
  { "Dyemond", 0.0 },
  { "Dyer", 1.0 },
  { "Dyesha", 0.0 },
  { "Dyian", 1.0 },
  { "Dyisha", 0.0 },
  { "Dyke", 1.0 },
  { "Dykeria", 0.0 },
  { "Dylahn", 1.0 },
  { "Dylam", 1.0 },
  { "Dylan", 0.9697274 },
  { "Dylana", 0.0 },
  { "Dyland", 1.0 },
  { "Dylane", 0.0 },
  { "Dylaney", 0.0 },
  { "Dylanger", 1.0 },
  { "Dylanie", 0.0 },
  { "Dylanjacob", 1.0 },
  { "Dylanjames", 1.0 },
  { "Dylanmichael", 1.0 },
  { "Dylann", 0.29225737 },
  { "Dylanne", 0.0 },
  { "Dylanthomas", 1.0 },
  { "Dyle", 1.0 },
  { "Dylen", 0.97689074 },
  { "Dylenn", 1.0 },
  { "Dylhan", 1.0 },
  { "Dylian", 1.0 },
  { "Dylilah", 0.0 },
  { "Dylin", 0.82913166 },
  { "Dyllan", 0.88007957 },
  { "Dyllen", 1.0 },
  { "Dyllian", 1.0 },
  { "Dyllin", 1.0 },
  { "Dyllon", 1.0 },
  { "Dyllyn", 1.0 },
  { "Dylon", 1.0 },
  { "Dylyn", 0.7826087 },
  { "Dylynn", 0.0 },
  { "Dyman", 0.0 },
  { "Dymere", 1.0 },
  { "Dymin", 0.0 },
  { "Dymir", 1.0 },
  { "Dymon", 0.056265984 },
  { "Dymond", 0.04038257 },
  { "Dymone", 0.0 },
  { "Dymonique", 0.0 },
  { "Dymphna", 0.0 },
  { "Dymple", 0.0 },
  { "Dyna", 0.0 },
  { "Dynah", 0.0 },
  { "Dynalee", 0.0 },
  { "Dynasha", 0.0 },
  { "Dynasia", 0.0 },
  { "Dynastee", 0.0 },
  { "Dynasti", 0.0 },
  { "Dynastie", 0.0 },
  { "Dynasty", 0.0 },
  { "Dyneisha", 0.0 },
  { "Dynell", 0.90625 },
  { "Dynelle", 0.0 },
  { "Dynesha", 0.0 },
  { "Dyneshia", 0.0 },
  { "Dynesti", 0.0 },
  { "Dynesty", 0.0 },
  { "Dynetta", 0.0 },
  { "Dynette", 0.0 },
  { "Dynisha", 0.0 },
  { "Dynisty", 0.0 },
  { "Dynita", 0.0 },
  { "Dynver", 0.0 },
  { "Dyon", 0.97206706 },
  { "Dyona", 0.0 },
  { "Dyondre", 1.0 },
  { "Dyoni", 0.0 },
  { "Dyonna", 0.0 },
  { "Dyonne", 0.0 },
  { "Dyontae", 1.0 },
  { "Dyonte", 1.0 },
  { "Dyquan", 1.0 },
  { "Dyral", 1.0 },
  { "Dyran", 1.0 },
  { "Dyrell", 1.0 },
  { "Dyrk", 1.0 },
  { "Dyron", 1.0 },
  { "Dysan", 1.0 },
  { "Dysean", 1.0 },
  { "Dysen", 1.0 },
  { "Dysha", 0.0 },
  { "Dyshaun", 1.0 },
  { "Dyshawn", 1.0 },
  { "Dysheka", 0.0 },
  { "Dyshon", 1.0 },
  { "Dyson", 0.99613005 },
  { "Dystanie", 0.0 },
  { "Dystany", 0.0 },
  { "Dystinee", 0.0 },
  { "Dystini", 0.0 },
  { "Dystiny", 0.0 },
  { "Dyuthi", 0.0 },
  { "Dyuti", 0.0 },
  { "Dyvion", 1.0 },
  { "Dyvon", 1.0 },
  { "Dyvonne", 0.0 },
  { "Dywan", 1.0 },
  { "Dywana", 0.0 },
  { "Dywane", 1.0 },
  { "Dywanna", 0.0 },
  { "Dywayne", 1.0 },
  { "Dzaria", 0.0 },
  { "Dzejla", 0.0 },
  { "Dzenan", 1.0 },
  { "Dzeneta", 0.0 },
  { "Dzenita", 0.0 },
  { "Dziah", 0.0 },
  { "Dzion", 1.0 },
  { "Dzire", 0.0 },
  { "Dziyah", 0.0 },
  { "Dzung", 1.0 },
  { "Dzuy", 1.0 },
  { "Dzya", 0.0 },
  { "Dzyre", 0.0 },
  { "Ea", 0.0 },
  { "Eabha", 0.0 },
  { "Eaden", 0.64827585 },
  { "Eadie", 0.0 },
  { "Eadon", 1.0 },
  { "Eadric", 1.0 },
  { "Eadyn", 0.0 },
  { "Eaen", 1.0 },
  { "Eagan", 1.0 },
  { "Eagle", 1.0 },
  { "Eain", 1.0 },
  { "Ealon", 1.0 },
  { "Ealyn", 0.0 },
  { "Eames", 1.0 },
  { "Eammon", 1.0 },
  { "Eamon", 1.0 },
  { "Eamonn", 1.0 },
  { "Ean", 1.0 },
  { "Eann", 1.0 },
  { "Eanna", 0.0 },
  { "Eara", 0.0 },
  { "Eardie", 0.0 },
  { "Earic", 1.0 },
  { "Earica", 0.0 },
  { "Earie", 0.0 },
  { "Earin", 1.0 },
  { "Earl", 0.99226516 },
  { "Earla", 0.0 },
  { "Earland", 1.0 },
  { "Earldean", 0.0 },
  { "Earldene", 0.0 },
  { "Earldine", 0.0 },
  { "Earle", 0.9758249 },
  { "Earlean", 0.0 },
  { "Earleane", 0.0 },
  { "Earlee", 0.24719101 },
  { "Earleen", 0.0 },
  { "Earleene", 0.0 },
  { "Earlen", 0.0 },
  { "Earlena", 0.0 },
  { "Earlene", 0.00035285816 },
  { "Earlesha", 0.0 },
  { "Earletta", 0.0 },
  { "Earlette", 0.0 },
  { "Earley", 1.0 },
  { "Earlie", 0.6299081 },
  { "Earlin", 1.0 },
  { "Earlina", 0.0 },
  { "Earline", 0.003558075 },
  { "Earling", 1.0 },
  { "Earlis", 1.0 },
  { "Earlisa", 0.0 },
  { "Earlisha", 0.0 },
  { "Earlon", 1.0 },
  { "Early", 0.9138369 },
  { "Earlyn", 0.0 },
  { "Earlyne", 0.0 },
  { "Earlynn", 0.0 },
  { "Earma", 0.0 },
  { "Earman", 1.0 },
  { "Earmel", 1.0 },
  { "Earmer", 0.0 },
  { "Earmie", 0.0 },
  { "Earmon", 1.0 },
  { "Earn", 1.0 },
  { "Earna", 0.0 },
  { "Earnease", 0.0 },
  { "Earnell", 0.77272725 },
  { "Earnest", 0.9876673 },
  { "Earnestean", 0.0 },
  { "Earnesteen", 0.0 },
  { "Earnestene", 0.0 },
  { "Earnestine", 0.0037815387 },
  { "Earney", 1.0 },
  { "Earnice", 0.0 },
  { "Earnie", 0.78338873 },
  { "Earnistine", 0.0 },
  { "Earnst", 1.0 },
  { "Earnstine", 0.0 },
  { "Earon", 0.9709302 },
  { "Earron", 1.0 },
  { "Earsel", 0.9177215 },
  { "Earsell", 0.0 },
  { "Earsie", 0.029761905 },
  { "Earskin", 1.0 },
  { "Earsley", 0.0 },
  { "Earstine", 0.0 },
  { "Earth", 0.0 },
  { "Eartha", 0.010862186 },
  { "Earthalee", 0.0 },
  { "Earthel", 0.0 },
  { "Earther", 0.0 },
  { "Earthy", 1.0 },
  { "Earven", 1.0 },
  { "Earvie", 1.0 },
  { "Earvin", 1.0 },
  { "Eary", 0.0 },
  { "Easha", 0.0 },
  { "Eashaan", 1.0 },
  { "Eashan", 1.0 },
  { "Easley", 1.0 },
  { "Eason", 1.0 },
  { "Eastan", 1.0 },
  { "Easten", 1.0 },
  { "Easter", 0.011840689 },
  { "Easther", 0.0 },
  { "Eastin", 0.9726776 },
  { "Eastlyn", 0.0 },
  { "Eastlynn", 0.0 },
  { "Eastman", 1.0 },
  { "Easton", 0.98443484 },
  { "Eastyn", 0.5934959 },
  { "Eastynn", 0.0 },
  { "Eathan", 1.0 },
  { "Eathel", 0.026819924 },
  { "Eathen", 1.0 },
  { "Eather", 0.010928961 },
  { "Eathin", 1.0 },
  { "Eathon", 1.0 },
  { "Eathyn", 1.0 },
  { "Eaton", 1.0 },
  { "Eava", 0.0 },
  { "Eavan", 0.03726708 },
  { "Eaven", 1.0 },
  { "Eavie", 0.0 },
  { "Eb", 1.0 },
  { "Ebaad", 1.0 },
  { "Eban", 1.0 },
  { "Ebanie", 0.0 },
  { "Ebany", 0.0 },
  { "Ebaristo", 1.0 },
  { "Ebay", 1.0 },
  { "Ebb", 1.0 },
  { "Ebba", 0.006289308 },
  { "Ebbe", 1.0 },
  { "Ebben", 1.0 },
  { "Ebbie", 0.48545176 },
  { "Ebbin", 1.0 },
  { "Ebbony", 0.0 },
  { "Ebby", 0.18518518 },
  { "Ebe", 0.0 },
  { "Ebecca", 0.0 },
  { "Ebelia", 0.0 },
  { "Ebelin", 0.0 },
  { "Ebelina", 0.0 },
  { "Ebelyn", 0.0 },
  { "Eben", 0.99813604 },
  { "Ebenezer", 0.97307223 },
  { "Eber", 1.0 },
  { "Eberardo", 1.0 },
  { "Ebere", 0.0 },
  { "Eberhard", 1.0 },
  { "Ebert", 1.0 },
  { "Ebin", 1.0 },
  { "Ebna", 0.0 },
  { "Ebon", 1.0 },
  { "Ebone", 0.0 },
  { "Ebonee", 0.0 },
  { "Eboney", 0.0 },
  { "Eboni", 0.00077208155 },
  { "Ebonie", 0.0 },
  { "Ebonii", 0.0 },
  { "Ebonique", 0.0 },
  { "Ebonne", 0.0 },
  { "Ebonnie", 0.0 },
  { "Ebony", 0.011618406 },
  { "Ebonye", 0.0 },
  { "Ebraheem", 1.0 },
  { "Ebrahim", 1.0 },
  { "Ebrahima", 1.0 },
  { "Ebrima", 1.0 },
  { "Ebru", 0.0 },
  { "Ebubechukwu", 1.0 },
  { "Ebunoluwa", 0.0 },
  { "Ebward", 1.0 },
  { "Ecaterina", 0.0 },
  { "Ece", 0.0 },
  { "Ecequiel", 1.0 },
  { "Echelle", 0.0 },
  { "Echo", 0.026490066 },
  { "Echoe", 0.0 },
  { "Echol", 1.0 },
  { "Ecker", 1.0 },
  { "Ecko", 0.104761906 },
  { "Ecrin", 0.0 },
  { "Ecstasy", 0.0 },
  { "Ector", 1.0 },
  { "Ed", 0.99373174 },
  { "Eda", 0.0 },
  { "Edahi", 1.0 },
  { "Edalia", 0.0 },
  { "Edaline", 0.0 },
  { "Edalyn", 0.0 },
  { "Edan", 0.8758568 },
  { "Edana", 0.0 },
  { "Edawrd", 1.0 },
  { "Edberg", 1.0 },
  { "Edbert", 1.0 },
  { "Edd", 0.9976147 },
  { "Edda", 0.0 },
  { "Edden", 0.8636364 },
  { "Edder", 1.0 },
  { "Eddi", 0.952 },
  { "Eddica", 0.0 },
  { "Eddie", 0.9301784 },
  { "Eddieberto", 1.0 },
  { "Eddiel", 1.0 },
  { "Eddin", 1.0 },
  { "Eddis", 0.120300755 },
  { "Eddison", 0.98417723 },
  { "Eddith", 0.0 },
  { "Eddrick", 1.0 },
  { "Eddward", 1.0 },
  { "Eddy", 0.9756152 },
  { "Eddye", 0.02 },
  { "Eddyson", 1.0 },
  { "Eddythe", 0.0 },
  { "Ede", 0.0 },
  { "Edee", 0.0 },
  { "Edel", 0.8924485 },
  { "Edelia", 0.0 },
  { "Edelin", 0.0 },
  { "Edelina", 0.0 },
  { "Edeline", 0.0 },
  { "Edell", 0.15306123 },
  { "Edelle", 0.0 },
  { "Edelmira", 0.0 },
  { "Edelmiro", 1.0 },
  { "Edelweiss", 0.0 },
  { "Edelyn", 0.0 },
  { "Edelynn", 0.0 },
  { "Edem", 1.0 },
  { "Eden", 0.14770995 },
  { "Edena", 0.0 },
  { "Edengrace", 0.0 },
  { "Edenilson", 1.0 },
  { "Edenrose", 0.0 },
  { "Eder", 1.0 },
  { "Ederick", 1.0 },
  { "Ederson", 1.0 },
  { "Edessa", 0.0 },
  { "Edford", 1.0 },
  { "Edgar", 0.995327 },
  { "Edgard", 1.0 },
  { "Edgardo", 1.0 },
  { "Edgareduardo", 1.0 },
  { "Edgbert", 1.0 },
  { "Edge", 1.0 },
  { "Edgel", 1.0 },
  { "Edger", 1.0 },
  { "Edgerin", 1.0 },
  { "Edgerrin", 1.0 },
  { "Edguin", 1.0 },
  { "Edher", 1.0 },
  { "Edi", 0.9310345 },
  { "Edia", 0.0 },
  { "Ediberto", 1.0 },
  { "Edica", 0.0 },
  { "Edice", 0.0 },
  { "Edid", 0.0 },
  { "Edie", 0.017123288 },
  { "Ediel", 1.0 },
  { "Edier", 1.0 },
  { "Edieth", 0.0 },
  { "Edika", 0.0 },
  { "Edil", 0.83870965 },
  { "Edilberto", 1.0 },
  { "Edilia", 0.0 },
  { "Edilson", 1.0 },
  { "Edin", 0.94158417 },
  { "Edina", 0.0 },
  { "Edinson", 1.0 },
  { "Edir", 1.0 },
  { "Edis", 0.74050635 },
  { "Edisa", 0.0 },
  { "Edisha", 0.0 },
  { "Edison", 0.9904349 },
  { "Edisson", 1.0 },
  { "Edit", 0.0 },
  { "Edita", 0.0 },
  { "Edith", 0.003100548 },
  { "Editha", 0.0 },
  { "Edithe", 0.0 },
  { "Edithmae", 0.0 },
  { "Ediz", 1.0 },
  { "Edjuan", 1.0 },
  { "Edker", 1.0 },
  { "Edla", 0.0 },
  { "Edley", 1.0 },
  { "Edlin", 0.046979867 },
  { "Edlow", 1.0 },
  { "Edlyn", 0.0 },
  { "Edlynn", 0.0 },
  { "Edma", 0.0 },
  { "Edmae", 0.0 },
  { "Edman", 1.0 },
  { "Edmanuel", 1.0 },
  { "Edmar", 1.0 },
  { "Edmay", 0.0 },
  { "Edmee", 0.0 },
  { "Edmere", 0.0 },
  { "Edmilson", 1.0 },
  { "Edmon", 1.0 },
  { "Edmona", 0.0 },
  { "Edmond", 0.9997117 },
  { "Edmondo", 1.0 },
  { "Edmonia", 0.0 },
  { "Edmont", 1.0 },
  { "Edmound", 1.0 },
  { "Edmund", 0.9988147 },
  { "Edmundo", 1.0 },
  { "Edna", 0.0035300734 },
  { "Ednah", 0.0 },
  { "Ednamae", 0.0 },
  { "Ednamay", 0.0 },
  { "Ednar", 0.0 },
  { "Edner", 0.175 },
  { "Ednesha", 0.0 },
  { "Edney", 1.0 },
  { "Ednita", 0.0 },
  { "Edo", 1.0 },
  { "Edoardo", 1.0 },
  { "Edolia", 0.0 },
  { "Edom", 0.0 },
  { "Edon", 1.0 },
  { "Edona", 0.0 },
  { "Edonis", 1.0 },
  { "Edony", 0.0 },
  { "Edora", 0.0 },
  { "Edouard", 1.0 },
  { "Edra", 0.0 },
  { "Edras", 1.0 },
  { "Edrees", 1.0 },
  { "Edrei", 1.0 },
  { "Edrena", 0.0 },
  { "Edrey", 1.0 },
  { "Edria", 0.0 },
  { "Edrian", 1.0 },
  { "Edriana", 0.0 },
  { "Edrianna", 0.0 },
  { "Edric", 1.0 },
  { "Edrica", 0.0 },
  { "Edrick", 1.0 },
  { "Edricka", 0.0 },
  { "Edrie", 0.0 },
  { "Edriel", 1.0 },
  { "Edrik", 1.0 },
  { "Edrin", 1.0 },
  { "Edrina", 0.0 },
  { "Edris", 0.2462845 },
  { "Edro", 1.0 },
  { "Edroy", 1.0 },
  { "Edsel", 1.0 },
  { "Edsell", 1.0 },
  { "Edsil", 1.0 },
  { "Edsol", 1.0 },
  { "Edson", 1.0 },
  { "Edsson", 1.0 },
  { "Edu", 1.0 },
  { "Eduan", 1.0 },
  { "Eduar", 1.0 },
  { "Eduard", 1.0 },
  { "Eduarda", 0.0 },
  { "Eduardo", 0.99574393 },
  { "Eduardoluis", 1.0 },
  { "Eduin", 1.0 },
  { "Edurdo", 1.0 },
  { "Eduvigen", 0.0 },
  { "Eduviges", 0.0 },
  { "Eduvijes", 0.0 },
  { "Eduvina", 0.0 },
  { "Edvard", 1.0 },
  { "Edvardo", 1.0 },
  { "Edvin", 1.0 },
  { "Edw", 1.0 },
  { "Edwa", 0.0 },
  { "Edwad", 1.0 },
  { "Edwana", 0.0 },
  { "Edwar", 1.0 },
  { "Edward", 0.99584836 },
  { "Edwarda", 0.0 },
  { "Edwardd", 1.0 },
  { "Edwardine", 0.0 },
  { "Edwardjames", 1.0 },
  { "Edwardo", 1.0 },
  { "Edwards", 1.0 },
  { "Edweina", 0.0 },
  { "Edwell", 1.0 },
  { "Edwen", 1.0 },
  { "Edwena", 0.0 },
  { "Edwidge", 0.45454547 },
  { "Edwill", 1.0 },
  { "Edwin", 0.99504167 },
  { "Edwina", 0.0 },
  { "Edwind", 1.0 },
  { "Edwing", 1.0 },
  { "Edwinn", 1.0 },
  { "Edwinna", 0.0 },
  { "Edwon", 1.0 },
  { "Edwood", 1.0 },
  { "Edword", 1.0 },
  { "Edwrd", 1.0 },
  { "Edwuin", 1.0 },
  { "Edwyn", 1.0 },
  { "Edwyna", 0.0 },
  { "Edwynn", 1.0 },
  { "Edy", 0.74285716 },
  { "Edyce", 0.0 },
  { "Edye", 0.0 },
  { "Edyn", 0.09541063 },
  { "Edynn", 0.0 },
  { "Edyson", 1.0 },
  { "Edyta", 0.0 },
  { "Edyth", 0.0 },
  { "Edytha", 0.0 },
  { "Edythe", 0.0 },
  { "Edzel", 1.0 },
  { "Edzon", 1.0 },
  { "Eean", 1.0 },
  { "Eelijah", 1.0 },
  { "Eelis", 1.0 },
  { "Eeliyah", 0.0 },
  { "Eelyn", 0.0 },
  { "Eeman", 0.0 },
  { "Eera", 0.0 },
  { "Eero", 1.0 },
  { "Eesa", 1.0 },
  { "Eesha", 0.0 },
  { "Eeshan", 1.0 },
  { "Eeva", 0.0 },
  { "Eevee", 0.0 },
  { "Eevie", 0.0 },
  { "Eeyan", 1.0 },
  { "Efe", 1.0 },
  { "Effa", 0.0 },
  { "Effie", 0.005501153 },
  { "Efford", 1.0 },
  { "Effrem", 1.0 },
  { "Effren", 1.0 },
  { "Effrey", 1.0 },
  { "Effy", 0.0 },
  { "Efia", 0.0 },
  { "Efigenia", 0.0 },
  { "Efosa", 1.0 },
  { "Efraim", 1.0 },
  { "Efrain", 0.99831903 },
  { "Efram", 1.0 },
  { "Efran", 1.0 },
  { "Efrat", 0.0 },
  { "Efrata", 0.0 },
  { "Efrayim", 1.0 },
  { "Efrem", 1.0 },
  { "Efren", 1.0 },
  { "Efrian", 1.0 },
  { "Efrin", 1.0 },
  { "Efrosini", 0.0 },
  { "Efstathia", 0.0 },
  { "Efstathios", 1.0 },
  { "Efstratios", 1.0 },
  { "Efthimia", 0.0 },
  { "Efthimios", 1.0 },
  { "Efthymia", 0.0 },
  { "Eftihia", 0.0 },
  { "Efton", 1.0 },
  { "Efua", 0.0 },
  { "Egan", 0.9501526 },
  { "Egbert", 1.0 },
  { "Ege", 1.0 },
  { "Eghosa", 1.0 },
  { "Egidio", 1.0 },
  { "Egina", 0.0 },
  { "Egla", 0.0 },
  { "Egon", 1.0 },
  { "Egor", 1.0 },
  { "Egypt", 0.09988942 },
  { "Egzon", 1.0 },
  { "Eh", 0.5796767 },
  { "Ehaan", 1.0 },
  { "Ehab", 1.0 },
  { "Ehan", 1.0 },
  { "Ehitan", 1.0 },
  { "Ehlana", 0.0 },
  { "Ehlena", 0.0 },
  { "Ehlijah", 1.0 },
  { "Ehren", 0.9850877 },
  { "Ehrin", 0.4 },
  { "Ehron", 1.0 },
  { "Ehsan", 1.0 },
  { "Ehtan", 1.0 },
  { "Ehud", 1.0 },
  { "Ehvan", 1.0 },
  { "Eiad", 1.0 },
  { "Eian", 1.0 },
  { "Eibhleann", 0.0 },
  { "Eibhlin", 0.0 },
  { "Eichael", 1.0 },
  { "Eichi", 1.0 },
  { "Eid", 1.0 },
  { "Eidan", 1.0 },
  { "Eidel", 0.0 },
  { "Eiden", 1.0 },
  { "Eider", 0.0 },
  { "Eidy", 0.0 },
  { "Eiichi", 1.0 },
  { "Eijah", 1.0 },
  { "Eiji", 1.0 },
  { "Eiker", 1.0 },
  { "Eiko", 0.0 },
  { "Eila", 0.0 },
  { "Eilah", 0.0 },
  { "Eilam", 1.0 },
  { "Eilan", 1.0 },
  { "Eilani", 0.0 },
  { "Eilany", 0.0 },
  { "Eilean", 0.0 },
  { "Eilee", 0.0 },
  { "Eileen", 0.0021879603 },
  { "Eileena", 0.0 },
  { "Eileene", 0.0 },
  { "Eileigh", 0.0 },
  { "Eilen", 0.0 },
  { "Eilene", 0.0 },
  { "Eiler", 1.0 },
  { "Eilert", 1.0 },
  { "Eiley", 0.0 },
  { "Eiliana", 0.0 },
  { "Eilidh", 0.0 },
  { "Eilijah", 1.0 },
  { "Eilin", 0.0 },
  { "Eilis", 0.0 },
  { "Eilise", 0.0 },
  { "Eilish", 0.0 },
  { "Eiliyah", 0.0 },
  { "Eiljah", 1.0 },
  { "Eilleen", 0.0 },
  { "Eillen", 0.0 },
  { "Eilley", 0.0 },
  { "Eillie", 0.0 },
  { "Eilon", 1.0 },
  { "Eilonwy", 0.0 },
  { "Eily", 0.0 },
  { "Eilyn", 0.0 },
  { "Eilynn", 0.0 },
  { "Eilzabeth", 0.0 },
  { "Eimaan", 0.0 },
  { "Eimaj", 1.0 },
  { "Eiman", 0.0 },
  { "Eimear", 0.0 },
  { "Eimi", 0.0 },
  { "Eimile", 0.0 },
  { "Eimly", 0.0 },
  { "Eimmy", 0.0 },
  { "Eimy", 0.0 },
  { "Ein", 1.0 },
  { "Eina", 0.0 },
  { "Einar", 1.0 },
  { "Einard", 1.0 },
  { "Einav", 0.0 },
  { "Einer", 1.0 },
  { "Einin", 0.0 },
  { "Eino", 1.0 },
  { "Einstein", 1.0 },
  { "Eion", 1.0 },
  { "Eira", 0.0 },
  { "Eirc", 1.0 },
  { "Eire", 0.0 },
  { "Eireann", 0.0 },
  { "Eireen", 0.0 },
  { "Eiren", 1.0 },
  { "Eirene", 0.0 },
  { "Eirian", 0.0 },
  { "Eirik", 1.0 },
  { "Eirini", 0.0 },
  { "Eirinn", 0.0 },
  { "Eirnin", 1.0 },
  { "Eisa", 0.7370518 },
  { "Eisele", 0.0 },
  { "Eisen", 1.0 },
  { "Eisenhower", 1.0 },
  { "Eisha", 0.0 },
  { "Eislee", 0.0 },
  { "Eisleigh", 0.0 },
  { "Eisley", 0.012479201 },
  { "Eissa", 1.0 },
  { "Eita", 1.0 },
  { "Eitan", 1.0 },
  { "Eitel", 1.0 },
  { "Eith", 1.0 },
  { "Eithan", 1.0 },
  { "Eithel", 0.0 },
  { "Eithen", 1.0 },
  { "Eithne", 0.0 },
  { "Eithyn", 1.0 },
  { "Eito", 1.0 },
  { "Eiva", 0.0 },
  { "Eivan", 1.0 },
  { "Eiven", 1.0 },
  { "Eivin", 1.0 },
  { "Eiyanna", 0.0 },
  { "Eiza", 0.0 },
  { "Eizabella", 0.0 },
  { "Eizabeth", 0.0 },
  { "Eizan", 1.0 },
  { "Eizley", 0.0 },
  { "Ej", 1.0 },
  { "Eja", 0.0 },
  { "Ejay", 1.0 },
  { "Ejaz", 1.0 },
  { "Ekaansh", 1.0 },
  { "Ekam", 0.6371951 },
  { "Ekambir", 1.0 },
  { "Ekamjeet", 1.0 },
  { "Ekamjit", 1.0 },
  { "Ekamjot", 0.7755102 },
  { "Ekamveer", 1.0 },
  { "Ekansh", 1.0 },
  { "Ekaterina", 0.0 },
  { "Ekaterini", 0.0 },
  { "Ekco", 0.0 },
  { "Ekene", 0.54285717 },
  { "Eker", 1.0 },
  { "Ekin", 0.95862067 },
  { "Ekko", 0.0 },
  { "Eknoor", 0.10784314 },
  { "Eko", 1.0 },
  { "Ekow", 1.0 },
  { "Ekram", 0.0 },
  { "Ekrem", 1.0 },
  { "Ekta", 0.0 },
  { "El", 0.8637993 },
  { "Ela", 0.0 },
  { "Elaan", 0.5 },
  { "Elad", 1.0 },
  { "Eladia", 0.0 },
  { "Eladio", 1.0 },
  { "Elaena", 0.0 },
  { "Elaf", 0.0 },
  { "Elah", 0.0 },
  { "Elaheh", 0.0 },
  { "Elahna", 0.0 },
  { "Elahni", 0.0 },
  { "Elai", 1.0 },
  { "Elaia", 0.0 },
  { "Elaida", 0.0 },
  { "Elaijah", 0.035460994 },
  { "Elain", 0.0 },
  { "Elaina", 0.0 },
  { "Elainah", 0.0 },
  { "Elaine", 0.002540753 },
  { "Elainea", 0.0 },
  { "Elainey", 0.0 },
  { "Elaini", 0.0 },
  { "Elainie", 0.0 },
  { "Elainna", 0.0 },
  { "Elainy", 0.0 },
  { "Elaisa", 0.0 },
  { "Elaise", 0.0 },
  { "Elaisha", 0.0 },
  { "Elaiya", 0.0 },
  { "Elaiza", 0.0 },
  { "Elajah", 0.0 },
  { "Elajuwon", 1.0 },
  { "Elam", 1.0 },
  { "Elan", 0.79387105 },
  { "Elana", 0.0 },
  { "Elanah", 0.0 },
  { "Eland", 1.0 },
  { "Elanda", 0.0 },
  { "Elander", 0.0 },
  { "Elandra", 0.0 },
  { "Elane", 0.0 },
  { "Elaney", 0.0 },
  { "Elani", 0.0 },
  { "Elania", 0.0 },
  { "Elanie", 0.0 },
  { "Elanna", 0.0 },
  { "Elannah", 0.0 },
  { "Elanni", 0.0 },
  { "Elannie", 0.0 },
  { "Elanny", 0.0 },
  { "Elanor", 0.0 },
  { "Elanora", 0.0 },
  { "Elanore", 0.0 },
  { "Elante", 1.0 },
  { "Elantra", 0.0 },
  { "Elanur", 0.0 },
  { "Elany", 0.0 },
  { "Elara", 0.0 },
  { "Elaria", 0.0 },
  { "Elario", 1.0 },
  { "Elasha", 0.0 },
  { "Elasia", 0.0 },
  { "Elauna", 0.0 },
  { "Elaura", 0.0 },
  { "Elay", 1.0 },
  { "Elaya", 0.0 },
  { "Elayah", 0.0 },
  { "Elayiah", 0.0 },
  { "Elayjah", 0.0 },
  { "Elayla", 0.0 },
  { "Elayna", 0.0 },
  { "Elaynah", 0.0 },
  { "Elayne", 0.0 },
  { "Elaysha", 0.0 },
  { "Elayshia", 0.0 },
  { "Elaysia", 0.0 },
  { "Elazar", 1.0 },
  { "Elazia", 0.0 },
  { "Elba", 0.08632101 },
  { "Elber", 1.0 },
  { "Elbern", 1.0 },
  { "Elbert", 0.9971062 },
  { "Elberta", 0.0 },
  { "Elbertha", 0.0 },
  { "Elbia", 0.0 },
  { "Elbie", 0.94186044 },
  { "Elbin", 1.0 },
  { "Elbira", 0.0 },
  { "Elbis", 1.0 },
  { "Elbonie", 0.0 },
  { "Elbony", 0.0 },
  { "Elbridge", 1.0 },
  { "Elburn", 1.0 },
  { "Elby", 1.0 },
  { "Elchanan", 1.0 },
  { "Elchonon", 1.0 },
  { "Elcid", 1.0 },
  { "Elcie", 0.0 },
  { "Elco", 1.0 },
  { "Elcy", 0.0 },
  { "Elda", 0.0047323946 },
  { "Eldad", 1.0 },
  { "Eldamae", 0.0 },
  { "Eldan", 1.0 },
  { "Eldana", 0.0 },
  { "Eldar", 1.0 },
  { "Eldean", 0.39071038 },
  { "Eldee", 0.54545456 },
  { "Eldeen", 0.0 },
  { "Elden", 0.99802583 },
  { "Eldena", 0.0 },
  { "Eldene", 0.0 },
  { "Elder", 0.973029 },
  { "Elderine", 0.0 },
  { "Eldie", 0.6458333 },
  { "Eldin", 1.0 },
  { "Eldina", 0.0 },
  { "Eldine", 0.0 },
  { "Eldion", 1.0 },
  { "Eldo", 1.0 },
  { "Eldon", 0.9978495 },
  { "Eldona", 0.0 },
  { "Eldonna", 0.0 },
  { "Eldor", 1.0 },
  { "Eldora", 0.0 },
  { "Eldoris", 0.0 },
  { "Eldra", 0.6438356 },
  { "Eldred", 0.92720973 },
  { "Eldredge", 1.0 },
  { "Eldren", 1.0 },
  { "Eldric", 1.0 },
  { "Eldrich", 1.0 },
  { "Eldrick", 1.0 },
  { "Eldrid", 0.8214286 },
  { "Eldridge", 1.0 },
  { "Eldrige", 1.0 },
  { "Eldrin", 1.0 },
  { "Eldwin", 1.0 },
  { "Ele", 0.0 },
  { "Elea", 0.0 },
  { "Eleah", 0.0 },
  { "Elean", 0.3125 },
  { "Eleana", 0.0 },
  { "Eleanar", 0.0 },
  { "Eleane", 0.0 },
  { "Eleaner", 0.0 },
  { "Eleanna", 0.0 },
  { "Eleanor", 0.002164019 },
  { "Eleanora", 0.0 },
  { "Eleanore", 0.0 },
  { "Eleany", 0.0 },
  { "Eleasa", 0.0 },
  { "Eleasah", 0.0 },
  { "Eleasar", 1.0 },
  { "Elease", 0.0 },
  { "Eleasha", 0.0 },
  { "Eleazar", 0.9984845 },
  { "Eleazer", 1.0 },
  { "Elec", 1.0 },
  { "Elecia", 0.0 },
  { "Eleck", 1.0 },
  { "Elecktra", 0.0 },
  { "Electa", 0.0 },
  { "Electra", 0.0 },
  { "Eleda", 0.0 },
  { "Elee", 0.0 },
  { "Eleecia", 0.0 },
  { "Eleen", 0.0 },
  { "Eleena", 0.0 },
  { "Eleene", 0.0 },
  { "Eleesa", 0.0 },
  { "Eleese", 0.0 },
  { "Eleesha", 0.0 },
  { "Eleesia", 0.0 },
  { "Eleeza", 0.0 },
  { "Elefteria", 0.0 },
  { "Elefterios", 1.0 },
  { "Eleftheria", 0.0 },
  { "Eleftherios", 1.0 },
  { "Eleigh", 0.0 },
  { "Eleigha", 0.0 },
  { "Eleina", 0.0 },
  { "Eleisa", 0.0 },
  { "Eleise", 0.0 },
  { "Eleisha", 0.0 },
  { "Elek", 1.0 },
  { "Elektra", 0.0 },
  { "Elemer", 1.0 },
  { "Elen", 0.0 },
  { "Elena", 0.0013248618 },
  { "Elenah", 0.0 },
  { "Elenamarie", 0.0 },
  { "Elend", 1.0 },
  { "Elender", 0.0 },
  { "Elene", 0.0 },
  { "Elener", 0.0 },
  { "Eleni", 0.0 },
  { "Elenia", 0.0 },
  { "Elenie", 0.0 },
  { "Elenis", 0.0 },
  { "Elenita", 0.0 },
  { "Elenna", 0.0 },
  { "Elenny", 0.0 },
  { "Eleno", 1.0 },
  { "Elenoa", 0.0 },
  { "Elenor", 0.0 },
  { "Elenora", 0.0 },
  { "Elenore", 0.0 },
  { "Eleny", 0.0 },
  { "Eleodoro", 1.0 },
  { "Eleonor", 0.0 },
  { "Eleonora", 0.0 },
  { "Eleonore", 0.0 },
  { "Eleora", 0.0 },
  { "Eleri", 0.0 },
  { "Elery", 1.0 },
  { "Eles", 1.0 },
  { "Elesa", 0.0 },
  { "Elese", 0.0 },
  { "Elesha", 0.0 },
  { "Eleshia", 0.0 },
  { "Elesia", 0.0 },
  { "Elessa", 0.0 },
  { "Elester", 0.9627329 },
  { "Elestine", 0.0 },
  { "Elet", 1.0 },
  { "Eleta", 0.0 },
  { "Eletha", 0.0 },
  { "Elethia", 0.0 },
  { "Eletise", 1.0 },
  { "Eleuteria", 0.0 },
  { "Eleuterio", 1.0 },
  { "Elex", 1.0 },
  { "Elexa", 0.0 },
  { "Elexander", 1.0 },
  { "Elexas", 0.0 },
  { "Elexcia", 0.0 },
  { "Elexes", 0.0 },
  { "Elexi", 0.0 },
  { "Elexia", 0.0 },
  { "Elexis", 0.0 },
  { "Elexius", 0.0 },
  { "Elexsis", 0.0 },
  { "Elexus", 0.0 },
  { "Elexys", 0.0 },
  { "Eley", 1.0 },
  { "Eleya", 0.0 },
  { "Eleyah", 0.0 },
  { "Eleyana", 0.0 },
  { "Eleyna", 0.0 },
  { "Elezabeth", 0.0 },
  { "Elfa", 0.0 },
  { "Elfago", 1.0 },
  { "Elfego", 1.0 },
  { "Elfida", 0.0 },
  { "Elfie", 0.0 },
  { "Elford", 1.0 },
  { "Elfred", 1.0 },
  { "Elfreda", 0.0 },
  { "Elfredia", 0.0 },
  { "Elfreida", 0.0 },
  { "Elfrida", 0.0 },
  { "Elfrieda", 0.0 },
  { "Elfriede", 0.0 },
  { "Elga", 0.08 },
  { "Elgan", 1.0 },
  { "Elgar", 1.0 },
  { "Elgene", 0.40677965 },
  { "Elger", 1.0 },
  { "Elgia", 0.32352942 },
  { "Elgie", 0.60610574 },
  { "Elgin", 0.98891467 },
  { "Elgina", 0.0 },
  { "Elhadj", 1.0 },
  { "Elhadji", 1.0 },
  { "Elham", 0.07224335 },
  { "Elhana", 0.0 },
  { "Eli", 0.9935094 },
  { "Elia", 0.109556176 },
  { "Eliab", 1.0 },
  { "Eliabeth", 0.0 },
  { "Eliah", 0.7090576 },
  { "Eliahna", 0.0 },
  { "Eliahs", 1.0 },
  { "Eliahu", 1.0 },
  { "Eliajah", 1.0 },
  { "Eliakim", 1.0 },
  { "Eliam", 1.0 },
  { "Elian", 0.9909353 },
  { "Eliana", 0.00084075483 },
  { "Elianagrace", 0.0 },
  { "Elianah", 0.0 },
  { "Eliandra", 0.0 },
  { "Eliane", 0.0 },
  { "Eliani", 0.0 },
  { "Elianie", 0.0 },
  { "Elianis", 0.0 },
  { "Elianna", 0.0 },
  { "Eliannah", 0.0 },
  { "Elianne", 0.0 },
  { "Elianni", 0.0 },
  { "Eliannie", 0.0 },
  { "Elianny", 0.0 },
  { "Eliano", 1.0 },
  { "Eliany", 0.0 },
  { "Elianys", 0.0 },
  { "Eliara", 0.0 },
  { "Elias", 0.99759614 },
  { "Eliasar", 1.0 },
  { "Eliase", 1.0 },
  { "Eliasib", 1.0 },
  { "Eliason", 1.0 },
  { "Eliasz", 1.0 },
  { "Eliav", 1.0 },
  { "Eliaz", 1.0 },
  { "Eliazar", 1.0 },
  { "Eliazbeth", 0.0 },
  { "Eliazer", 1.0 },
  { "Eliberto", 1.0 },
  { "Elibeth", 0.0 },
  { "Eliborio", 1.0 },
  { "Elic", 1.0 },
  { "Elica", 0.0 },
  { "Elice", 0.028688524 },
  { "Eliceo", 1.0 },
  { "Elicia", 0.0 },
  { "Eliciana", 0.0 },
  { "Elicio", 1.0 },
  { "Elick", 1.0 },
  { "Elida", 0.0 },
  { "Elide", 0.0 },
  { "Elided", 0.0 },
  { "Elidet", 0.0 },
  { "Elideth", 0.0 },
  { "Elidia", 0.0 },
  { "Elidio", 1.0 },
  { "Elie", 0.9068677 },
  { "Elieana", 0.0 },
  { "Eliecer", 1.0 },
  { "Elieen", 0.0 },
  { "Eliejah", 1.0 },
  { "Eliel", 1.0 },
  { "Elien", 0.0 },
  { "Elienai", 0.026086956 },
  { "Eliene", 0.0 },
  { "Elier", 1.0 },
  { "Eliese", 0.0 },
  { "Elieser", 1.0 },
  { "Eliesha", 0.0 },
  { "Eliette", 0.0 },
  { "Eliezar", 1.0 },
  { "Eliezel", 1.0 },
  { "Eliezer", 1.0 },
  { "Elif", 0.0 },
  { "Eliga", 1.0 },
  { "Eligah", 1.0 },
  { "Elige", 1.0 },
  { "Eliger", 1.0 },
  { "Eligh", 1.0 },
  { "Eligha", 1.0 },
  { "Elight", 1.0 },
  { "Eligio", 1.0 },
  { "Elih", 1.0 },
  { "Elihu", 1.0 },
  { "Elihue", 1.0 },
  { "Elii", 1.0 },
  { "Eliijah", 1.0 },
  { "Elija", 1.0 },
  { "Elijaah", 1.0 },
  { "Elijah", 0.9960252 },
  { "Elijaha", 1.0 },
  { "Elijahh", 1.0 },
  { "Elijahjames", 1.0 },
  { "Elijahjohn", 1.0 },
  { "Elijahjuan", 1.0 },
  { "Elijahpaul", 1.0 },
  { "Elijahray", 1.0 },
  { "Elijahwan", 1.0 },
  { "Elijahwon", 1.0 },
  { "Elijames", 1.0 },
  { "Elijan", 1.0 },
  { "Elijawon", 1.0 },
  { "Elijay", 1.0 },
  { "Elijha", 1.0 },
  { "Elijhah", 1.0 },
  { "Elijia", 1.0 },
  { "Elijiah", 1.0 },
  { "Elijio", 1.0 },
  { "Elijsha", 1.0 },
  { "Elijuah", 1.0 },
  { "Elik", 1.0 },
  { "Elika", 0.0 },
  { "Elikai", 1.0 },
  { "Elikem", 1.0 },
  { "Elilah", 0.0 },
  { "Elilta", 0.0 },
  { "Elim", 0.59205776 },
  { "Elimar", 0.0 },
  { "Elimelec", 1.0 },
  { "Elimelech", 1.0 },
  { "Elin", 0.026058631 },
  { "Elina", 0.0 },
  { "Elinah", 0.0 },
  { "Elinam", 0.0 },
  { "Elinar", 0.0 },
  { "Elinda", 0.0 },
  { "Eline", 0.0 },
  { "Eliner", 0.0 },
  { "Elinn", 0.0 },
  { "Elinor", 0.0 },
  { "Elinora", 0.0 },
  { "Elinore", 0.0 },
  { "Elio", 1.0 },
  { "Eliodoro", 1.0 },
  { "Elioenai", 1.0 },
  { "Elion", 1.0 },
  { "Eliona", 0.0 },
  { "Elionaid", 1.0 },
  { "Elionna", 0.0 },
  { "Elior", 1.0 },
  { "Eliora", 0.0 },
  { "Eliorah", 0.0 },
  { "Eliose", 0.0 },
  { "Eliot", 0.94268346 },
  { "Elioth", 1.0 },
  { "Eliott", 1.0 },
  { "Eliotte", 0.0 },
  { "Elira", 0.0 },
  { "Eliran", 1.0 },
  { "Elis", 0.4848485 },
  { "Elisa", 0.003300012 },
  { "Elisabel", 0.0 },
  { "Elisabella", 0.0 },
  { "Elisabet", 0.0 },
  { "Elisabeta", 0.0 },
  { "Elisabeth", 0.00059515936 },
  { "Elisabethe", 0.0 },
  { "Elisabetta", 0.0 },
  { "Elisah", 0.7338129 },
  { "Elisama", 0.0 },
  { "Elisandra", 0.0 },
  { "Elisandro", 1.0 },
  { "Elisaul", 1.0 },
  { "Elisavet", 0.0 },
  { "Elisbeth", 0.0 },
  { "Eliscia", 0.0 },
  { "Elise", 0.00097201864 },
  { "Elisea", 0.0 },
  { "Elisebeth", 0.0 },
  { "Elisee", 1.0 },
  { "Elisei", 1.0 },
  { "Eliseo", 1.0 },
  { "Eliset", 0.0 },
  { "Elisey", 1.0 },
  { "Elish", 1.0 },
  { "Elisha", 0.49215153 },
  { "Elishah", 0.8879668 },
  { "Elishea", 0.0 },
  { "Elisheba", 0.0 },
  { "Elisheva", 0.0 },
  { "Elishia", 0.0 },
  { "Elishka", 0.0 },
  { "Elishua", 1.0 },
  { "Elisia", 0.0 },
  { "Elisiah", 1.0 },
  { "Elisiana", 0.0 },
  { "Elisianna", 0.0 },
  { "Elisio", 1.0 },
  { "Elisjah", 1.0 },
  { "Eliska", 0.0 },
  { "Elison", 0.8196721 },
  { "Elissa", 0.0 },
  { "Elissabeth", 0.0 },
  { "Elissar", 0.0 },
  { "Elisse", 0.0 },
  { "Elissha", 0.0 },
  { "Elissia", 0.0 },
  { "Elisya", 0.0 },
  { "Elita", 0.0 },
  { "Elitania", 0.0 },
  { "Elite", 1.0 },
  { "Elitha", 0.0 },
  { "Elithia", 0.0 },
  { "Eliu", 1.0 },
  { "Eliud", 1.0 },
  { "Elius", 1.0 },
  { "Eliut", 1.0 },
  { "Eliuth", 1.0 },
  { "Eliverto", 1.0 },
  { "Elivia", 0.0 },
  { "Elix", 1.0 },
  { "Elixabeth", 0.0 },
  { "Elixander", 1.0 },
  { "Elixis", 0.0 },
  { "Eliya", 0.13915858 },
  { "Eliyah", 0.3534884 },
  { "Eliyahna", 0.0 },
  { "Eliyahu", 1.0 },
  { "Eliyana", 0.0 },
  { "Eliyanah", 0.0 },
  { "Eliyanna", 0.0 },
  { "Eliyas", 1.0 },
  { "Eliyjah", 1.0 },
  { "Eliyohu", 1.0 },
  { "Eliz", 0.0 },
  { "Eliza", 0.0036040752 },
  { "Elizabath", 0.0 },
  { "Elizabe", 0.0 },
  { "Elizabeath", 0.0 },
  { "Elizabeht", 0.0 },
  { "Elizabel", 0.0 },
  { "Elizabella", 0.0 },
  { "Elizabelle", 0.0 },
  { "Elizaberh", 0.0 },
  { "Elizabet", 0.0 },
  { "Elizabeta", 0.0 },
  { "Elizabete", 0.0 },
  { "Elizabeth", 0.0031812363 },
  { "Elizabetha", 0.0 },
  { "Elizabethann", 0.0 },
  { "Elizabethanne", 0.0 },
  { "Elizabethe", 0.0 },
  { "Elizabethgrace", 0.0 },
  { "Elizabethmarie", 0.0 },
  { "Elizabethrose", 0.0 },
  { "Elizabith", 0.0 },
  { "Elizabth", 0.0 },
  { "Elizadeth", 0.0 },
  { "Elizaeth", 0.0 },
  { "Elizah", 0.54031414 },
  { "Elizaida", 0.0 },
  { "Elizajane", 0.0 },
  { "Elizama", 0.0 },
  { "Elizamarie", 0.0 },
  { "Elizander", 1.0 },
  { "Elizandra", 0.0 },
  { "Elizandro", 1.0 },
  { "Elizar", 1.0 },
  { "Elizardo", 1.0 },
  { "Elizaveta", 0.0 },
  { "Elizbeath", 0.0 },
  { "Elizbeth", 0.0 },
  { "Elize", 0.055944055 },
  { "Elizeabeth", 0.0 },
  { "Elizebath", 0.0 },
  { "Elizebeth", 0.0 },
  { "Elizebth", 0.0 },
  { "Elizeo", 1.0 },
  { "Elizer", 1.0 },
  { "Elizet", 0.0 },
  { "Elizeth", 0.0 },
  { "Elizette", 0.0 },
  { "Elizha", 1.0 },
  { "Elizia", 0.0 },
  { "Eliziah", 1.0 },
  { "Elizibeth", 0.0 },
  { "Elizjah", 1.0 },
  { "Elizza", 0.0 },
  { "Elizzabeth", 0.0 },
  { "Elizzie", 0.0 },
  { "Eljay", 1.0 },
  { "Eljean", 0.0 },
  { "Eljin", 1.0 },
  { "Elka", 0.0 },
  { "Elkan", 1.0 },
  { "Elkanah", 1.0 },
  { "Elke", 0.0 },
  { "Elkin", 1.0 },
  { "Elkins", 1.0 },
  { "Elky", 0.0 },
  { "Ell", 0.9350649 },
  { "Ella", 0.0030046105 },
  { "Ellabelle", 0.0 },
  { "Ellaclaire", 0.0 },
  { "Elladean", 0.0 },
  { "Ellagrace", 0.0 },
  { "Ellah", 0.0 },
  { "Ellaina", 0.0 },
  { "Ellaine", 0.0 },
  { "Ellajane", 0.0 },
  { "Ellajean", 0.0 },
  { "Ellajo", 0.0 },
  { "Ellakate", 0.0 },
  { "Ellalee", 0.0 },
  { "Ellalynn", 0.0 },
  { "Ellamae", 0.0 },
  { "Ellamaria", 0.0 },
  { "Ellamarie", 0.0 },
  { "Ellamay", 0.0 },
  { "Ellan", 0.0 },
  { "Ellana", 0.0 },
  { "Ellanah", 0.0 },
  { "Ellani", 0.0 },
  { "Ellanie", 0.0 },
  { "Ellanor", 0.0 },
  { "Ellanora", 0.0 },
  { "Ellanore", 0.0 },
  { "Ellany", 0.0 },
  { "Ellar", 0.0 },
  { "Ellarae", 0.0 },
  { "Ellard", 1.0 },
  { "Ellaree", 0.0 },
  { "Ellarene", 0.0 },
  { "Ellaria", 0.0 },
  { "Ellarie", 0.0 },
  { "Ellarine", 0.0 },
  { "Ellarose", 0.0 },
  { "Ellary", 0.0 },
  { "Ellasandra", 0.0 },
  { "Ellasia", 0.0 },
  { "Ellason", 0.0 },
  { "Ellasophia", 0.0 },
  { "Ellasyn", 0.0 },
  { "Ellawease", 0.0 },
  { "Ellawee", 0.0 },
  { "Ellawese", 0.0 },
  { "Ellawyn", 0.0 },
  { "Ellaya", 0.0 },
  { "Ellayah", 0.0 },
  { "Ellayna", 0.0 },
  { "Elle", 0.0 },
  { "Ellea", 0.0 },
  { "Elleah", 0.0 },
  { "Ellean", 0.0 },
  { "Elleana", 0.0 },
  { "Elleanna", 0.0 },
  { "Elleanor", 0.0 },
  { "Elleanora", 0.0 },
  { "Ellease", 0.0 },
  { "Ellece", 0.0 },
  { "Ellee", 0.0 },
  { "Elleen", 0.0 },
  { "Elleigh", 0.0 },
  { "Ellen", 0.0027223132 },
  { "Ellena", 0.0 },
  { "Ellenah", 0.0 },
  { "Ellender", 0.0 },
  { "Ellene", 0.0 },
  { "Elleni", 0.0 },
  { "Ellenie", 0.0 },
  { "Ellenmarie", 0.0 },
  { "Ellenor", 0.0 },
  { "Ellenora", 0.0 },
  { "Ellenore", 0.0 },
  { "Elleny", 0.0 },
  { "Elleona", 0.0 },
  { "Elleora", 0.0 },
  { "Eller", 0.0 },
  { "Elleri", 0.0 },
  { "Ellerie", 0.0 },
  { "Ellery", 0.42141053 },
  { "Elles", 1.0 },
  { "Ellese", 0.0 },
  { "Ellesha", 0.0 },
  { "Elleson", 0.0 },
  { "Ellesse", 0.0 },
  { "Ellesyn", 0.0 },
  { "Ellet", 1.0 },
  { "Ellette", 0.0 },
  { "Ellexa", 0.0 },
  { "Ellexis", 0.0 },
  { "Ellexus", 0.0 },
  { "Elley", 0.0 },
  { "Elli", 0.013272312 },
  { "Ellia", 0.0 },
  { "Elliah", 0.0 },
  { "Elliahna", 0.0 },
  { "Ellian", 1.0 },
  { "Elliana", 0.0 },
  { "Ellianah", 0.0 },
  { "Elliani", 0.0 },
  { "Elliann", 0.0 },
  { "Ellianna", 0.0 },
  { "Elliannah", 0.0 },
  { "Ellianne", 0.0 },
  { "Ellias", 1.0 },
  { "Elliauna", 0.0 },
  { "Ellice", 0.0 },
  { "Ellicia", 0.0 },
  { "Ellie", 0.020339536 },
  { "Ellieana", 0.0 },
  { "Ellieann", 0.0 },
  { "Ellieanna", 0.0 },
  { "Ellieanne", 0.0 },
  { "Elliegrace", 0.0 },
  { "Elliekate", 0.0 },
  { "Elliemae", 0.0 },
  { "Elliemarie", 0.0 },
  { "Elliemay", 0.0 },
  { "Elliena", 0.0 },
  { "Ellierose", 0.0 },
  { "Elliet", 0.0 },
  { "Elliett", 0.0 },
  { "Elliette", 0.0 },
  { "Ellijah", 1.0 },
  { "Ellika", 0.0 },
  { "Ellin", 0.0 },
  { "Ellina", 0.0 },
  { "Elline", 0.0 },
  { "Ellington", 0.48926014 },
  { "Ellinor", 0.0 },
  { "Ellinore", 0.0 },
  { "Elliona", 0.0 },
  { "Ellionna", 0.0 },
  { "Elliora", 0.0 },
  { "Elliot", 0.9150583 },
  { "Elliott", 0.9280352 },
  { "Elliotte", 0.10352423 },
  { "Ellis", 0.9176578 },
  { "Ellisa", 0.0 },
  { "Ellise", 0.0 },
  { "Ellisen", 0.0 },
  { "Ellisha", 0.0 },
  { "Ellisia", 0.0 },
  { "Ellison", 0.39742646 },
  { "Ellissa", 0.0 },
  { "Ellissia", 0.0 },
  { "Elliston", 0.53846157 },
  { "Ellisyn", 0.0 },
  { "Ellivia", 0.0 },
  { "Elliya", 0.0 },
  { "Elliyah", 0.0 },
  { "Elliyana", 0.0 },
  { "Elliyanna", 0.0 },
  { "Elliza", 0.0 },
  { "Ellizabeth", 0.0 },
  { "Ellnora", 0.0 },
  { "Ellodie", 0.0 },
  { "Ellody", 0.0 },
  { "Elloise", 0.0 },
  { "Ellon", 0.0 },
  { "Ellora", 0.0 },
  { "Elloree", 0.0 },
  { "Ellorie", 0.0 },
  { "Ellory", 0.0 },
  { "Ellouise", 0.0 },
  { "Elloween", 0.0 },
  { "Ellowyn", 0.0 },
  { "Ellsa", 0.0 },
  { "Ellsie", 0.0 },
  { "Ellsworth", 1.0 },
  { "Ellwood", 1.0 },
  { "Ellwyn", 1.0 },
  { "Elly", 0.0029291154 },
  { "Ellya", 0.0 },
  { "Ellyana", 0.0 },
  { "Ellyanah", 0.0 },
  { "Ellyanna", 0.0 },
  { "Ellyce", 0.0 },
  { "Ellycia", 0.0 },
  { "Ellye", 0.0 },
  { "Ellyette", 0.0 },
  { "Ellymae", 0.0 },
  { "Ellyn", 0.0 },
  { "Ellyne", 0.0 },
  { "Ellynn", 0.0 },
  { "Ellynor", 0.0 },
  { "Ellyona", 0.0 },
  { "Ellyonna", 0.0 },
  { "Ellyot", 0.0 },
  { "Ellyott", 0.0 },
  { "Ellys", 0.0 },
  { "Ellysa", 0.0 },
  { "Ellyse", 0.0 },
  { "Ellysen", 0.0 },
  { "Ellysia", 0.0 },
  { "Ellyson", 0.0 },
  { "Ellyssa", 0.0 },
  { "Ellyza", 0.0 },
  { "Elma", 0.022034671 },
  { "Elmae", 0.0 },
  { "Elman", 1.0 },
  { "Elmar", 0.93485343 },
  { "Elmarie", 0.0 },
  { "Elmeda", 0.0 },
  { "Elmedin", 1.0 },
  { "Elmedina", 0.0 },
  { "Elmen", 1.0 },
  { "Elmer", 0.9864971 },
  { "Elmerine", 0.0 },
  { "Elmeta", 0.0 },
  { "Elmi", 0.6666667 },
  { "Elmin", 1.0 },
  { "Elmina", 0.0 },
  { "Elmir", 1.0 },
  { "Elmira", 0.0 },
  { "Elmire", 0.0 },
  { "Elmo", 0.9760798 },
  { "Elmon", 1.0 },
  { "Elmond", 1.0 },
  { "Elmont", 1.0 },
  { "Elmor", 1.0 },
  { "Elmore", 0.99747604 },
  { "Elmus", 1.0 },
  { "Elmyra", 0.0 },
  { "Elna", 0.0 },
  { "Elnara", 0.0 },
  { "Elnatan", 1.0 },
  { "Elnathan", 1.0 },
  { "Elnaz", 0.0 },
  { "Elneda", 0.0 },
  { "Elner", 0.012562814 },
  { "Elneta", 0.0 },
  { "Elnita", 0.0 },
  { "Elno", 1.0 },
  { "Elnor", 0.0 },
  { "Elnora", 0.0012740657 },
  { "Elnorah", 0.0 },
  { "Elnore", 0.0 },
  { "Elnoria", 0.0 },
  { "Elo", 1.0 },
  { "Eloda", 0.0 },
  { "Elodee", 0.0 },
  { "Elodia", 0.0 },
  { "Elodie", 0.0 },
  { "Elody", 0.0 },
  { "Elof", 1.0 },
  { "Elohim", 1.0 },
  { "Eloi", 1.0 },
  { "Eloida", 0.0 },
  { "Eloina", 0.0 },
  { "Eloine", 0.0 },
  { "Elois", 0.0037721614 },
  { "Eloisa", 0.0 },
  { "Eloise", 0.0022440562 },
  { "Eloiza", 0.0 },
  { "Elom", 1.0 },
  { "Elon", 0.75986195 },
  { "Elona", 0.0 },
  { "Elonda", 0.0 },
  { "Elondra", 0.0 },
  { "Eloni", 0.0 },
  { "Elonie", 0.0 },
  { "Elonna", 0.0 },
  { "Elonte", 1.0 },
  { "Elonzo", 1.0 },
  { "Elora", 0.0 },
  { "Elorah", 0.0 },
  { "Eloria", 0.0 },
  { "Eloris", 0.0 },
  { "Elosia", 0.0 },
  { "Elosie", 0.0 },
  { "Elouise", 0.0005304477 },
  { "Elovie", 0.0 },
  { "Elowen", 0.0 },
  { "Elowese", 0.0 },
  { "Elowise", 0.0 },
  { "Elowyn", 0.0 },
  { "Elowynn", 0.0 },
  { "Eloy", 1.0 },
  { "Eloyce", 0.0 },
  { "Eloyd", 1.0 },
  { "Eloyse", 0.0 },
  { "Elpha", 0.0 },
  { "Elphege", 1.0 },
  { "Elphie", 0.0 },
  { "Elpida", 0.0 },
  { "Elpidia", 0.0 },
  { "Elpidio", 1.0 },
  { "Elra", 1.0 },
  { "Elray", 1.0 },
  { "Elree", 0.7083333 },
  { "Elrena", 0.0 },
  { "Elrene", 0.0 },
  { "Elreta", 0.0 },
  { "Elrey", 1.0 },
  { "Elric", 1.0 },
  { "Elrick", 1.0 },
  { "Elrico", 1.0 },
  { "Elridge", 1.0 },
  { "Elrita", 0.0 },
  { "Elrod", 1.0 },
  { "Elroi", 1.0 },
  { "Elron", 1.0 },
  { "Elrose", 0.0 },
  { "Elroy", 0.99917513 },
  { "Elry", 1.0 },
  { "Elsa", 0.00074807636 },
  { "Elsabeth", 0.0 },
  { "Elsah", 0.0 },
  { "Elsbeth", 0.0 },
  { "Else", 0.0 },
  { "Elsee", 0.0 },
  { "Elsey", 0.0 },
  { "Elsha", 0.0 },
  { "Elshaddai", 0.42857143 },
  { "Elsi", 0.0 },
  { "Elsia", 0.0 },
  { "Elsie", 0.005004118 },
  { "Elsiemae", 0.0 },
  { "Elsmer", 1.0 },
  { "Elso", 1.0 },
  { "Elson", 1.0 },
  { "Elspeth", 0.0 },
  { "Elssa", 0.0 },
  { "Elster", 1.0 },
  { "Elston", 0.9952875 },
  { "Elsworth", 1.0 },
  { "Elsy", 0.0 },
  { "Elsye", 0.0 },
  { "Elta", 0.0 },
  { "Eltha", 0.0 },
  { "Elthea", 0.0 },
  { "Eltis", 0.0 },
  { "Elton", 0.9909849 },
  { "Eltra", 0.0 },
  { "Elua", 0.0 },
  { "Eluid", 1.0 },
  { "Eluster", 1.0 },
  { "Eluteria", 0.0 },
  { "Eluterio", 1.0 },
  { "Eluzer", 1.0 },
  { "Elva", 0.025408687 },
  { "Elvada", 0.0 },
  { "Elvan", 1.0 },
  { "Elve", 0.36363637 },
  { "Elveda", 0.0 },
  { "Elvedin", 1.0 },
  { "Elven", 1.0 },
  { "Elvena", 0.0 },
  { "Elvenia", 0.0 },
  { "Elver", 0.8501529 },
  { "Elvera", 0.0 },
  { "Elverda", 0.0 },
  { "Elveria", 0.0 },
  { "Elvern", 1.0 },
  { "Elverna", 0.0 },
  { "Elvert", 1.0 },
  { "Elverta", 0.0 },
  { "Elves", 1.0 },
  { "Elvester", 1.0 },
  { "Elveta", 0.0 },
  { "Elvi", 0.13445379 },
  { "Elvia", 0.0041897553 },
  { "Elvida", 0.0 },
  { "Elvie", 0.22473651 },
  { "Elvin", 0.98840266 },
  { "Elvina", 0.0 },
  { "Elvine", 0.0 },
  { "Elvio", 1.0 },
  { "Elvir", 1.0 },
  { "Elvira", 0.001653141 },
  { "Elvire", 0.0 },
  { "Elviria", 0.0 },
  { "Elvis", 0.99092865 },
  { "Elvita", 0.0 },
  { "Elviz", 1.0 },
  { "Elvon", 1.0 },
  { "Elvy", 0.3986014 },
  { "Elvyn", 0.88297874 },
  { "Elwanda", 0.0 },
  { "Elward", 1.0 },
  { "Elway", 1.0 },
  { "Elwell", 1.0 },
  { "Elwillie", 0.0 },
  { "Elwin", 0.9990105 },
  { "Elwood", 0.9974006 },
  { "Elworth", 1.0 },
  { "Elwyn", 0.97623515 },
  { "Ely", 0.9102359 },
  { "Elya", 0.56763923 },
  { "Elyah", 0.5 },
  { "Elyahna", 0.0 },
  { "Elyan", 1.0 },
  { "Elyana", 0.0 },
  { "Elyanah", 0.0 },
  { "Elyane", 0.0 },
  { "Elyanna", 0.0 },
  { "Elyannah", 0.0 },
  { "Elyas", 1.0 },
  { "Elyce", 0.0 },
  { "Elycia", 0.0 },
  { "Elyda", 0.0 },
  { "Elydia", 0.0 },
  { "Elye", 1.0 },
  { "Elyes", 1.0 },
  { "Elyh", 1.0 },
  { "Elyijah", 1.0 },
  { "Elyis", 1.0 },
  { "Elyja", 1.0 },
  { "Elyjah", 1.0 },
  { "Elyjiah", 1.0 },
  { "Elyn", 0.024017468 },
  { "Elyna", 0.0 },
  { "Elyne", 0.0 },
  { "Elynn", 0.0 },
  { "Elynna", 0.0 },
  { "Elynne", 0.0 },
  { "Elynor", 0.0 },
  { "Elynore", 0.0 },
  { "Elyon", 1.0 },
  { "Elyott", 1.0 },
  { "Elysa", 0.0 },
  { "Elysabeth", 0.0 },
  { "Elyse", 0.0010578475 },
  { "Elysha", 0.037410073 },
  { "Elyshia", 0.0 },
  { "Elysia", 0.0019471488 },
  { "Elysian", 0.0 },
  { "Elysiana", 0.0 },
  { "Elysium", 0.09615385 },
  { "Elyssa", 0.0 },
  { "Elysse", 0.0 },
  { "Elyssia", 0.0 },
  { "Elyus", 1.0 },
  { "Elyvia", 0.0 },
  { "Elyza", 0.0 },
  { "Elyzabeth", 0.0 },
  { "Elyzah", 0.0 },
  { "Elyze", 0.0 },
  { "Elyzza", 0.0 },
  { "Elza", 0.74699223 },
  { "Elzabeth", 0.0 },
  { "Elzada", 0.0 },
  { "Elzadie", 0.0 },
  { "Elzbieta", 0.0 },
  { "Elze", 1.0 },
  { "Elzear", 1.0 },
  { "Elzena", 0.0 },
  { "Elzenia", 0.0 },
  { "Elzia", 0.88304096 },
  { "Elziabeth", 0.0 },
  { "Elzie", 0.8658097 },
  { "Elzina", 0.0 },
  { "Elzira", 0.0 },
  { "Elzo", 1.0 },
  { "Elzora", 0.0 },
  { "Elzy", 1.0 },
  { "Ema", 0.0 },
  { "Emaad", 1.0 },
  { "Emaan", 0.033415843 },
  { "Emad", 1.0 },
  { "Emagene", 0.0 },
  { "Emagin", 0.0 },
  { "Emagine", 0.0 },
  { "Emah", 0.0 },
  { "Emahni", 0.0 },
  { "Emaje", 1.0 },
  { "Emajean", 0.0 },
  { "Emalea", 0.0 },
  { "Emaleah", 0.0 },
  { "Emalee", 0.0 },
  { "Emalei", 0.0 },
  { "Emaleigh", 0.0 },
  { "Emalena", 0.0 },
  { "Emalene", 0.0 },
  { "Emaley", 0.0 },
  { "Emali", 0.0 },
  { "Emalia", 0.0 },
  { "Emaliah", 0.0 },
  { "Emalie", 0.0 },
  { "Emalin", 0.0 },
  { "Emalina", 0.0 },
  { "Emaline", 0.0 },
  { "Emalise", 0.0 },
  { "Emaliya", 0.0 },
  { "Emaly", 0.0 },
  { "Emalyn", 0.0 },
  { "Emalyne", 0.0 },
  { "Emalynn", 0.0 },
  { "Emalynne", 0.0 },
  { "Eman", 0.09081365 },
  { "Emanda", 0.0 },
  { "Emane", 0.0 },
  { "Emanee", 0.0 },
  { "Emani", 0.06333404 },
  { "Emanie", 0.0 },
  { "Emanii", 0.0 },
  { "Emanni", 0.0 },
  { "Emannuel", 1.0 },
  { "Emanual", 1.0 },
  { "Emanuel", 0.99809396 },
  { "Emanuela", 0.0 },
  { "Emanuele", 1.0 },
  { "Emanuell", 1.0 },
  { "Emanuella", 0.0 },
  { "Emanuelle", 0.5552408 },
  { "Emanuelly", 0.0 },
  { "Emar", 1.0 },
  { "Emara", 0.0 },
  { "Emare", 1.0 },
  { "Emaree", 0.0 },
  { "Emareon", 1.0 },
  { "Emari", 0.45892736 },
  { "Emaria", 0.0 },
  { "Emariah", 0.0 },
  { "Emarie", 0.0 },
  { "Emarii", 1.0 },
  { "Emarion", 1.0 },
  { "Emariya", 0.0 },
  { "Emarosa", 0.0 },
  { "Emarri", 1.0 },
  { "Emary", 0.11016949 },
  { "Emauni", 0.0 },
  { "Emauri", 0.8067227 },
  { "Emaya", 0.0 },
  { "Emayah", 0.0 },
  { "Ember", 0.01370224 },
  { "Emberlee", 0.0 },
  { "Emberleigh", 0.0 },
  { "Emberley", 0.0 },
  { "Emberli", 0.0 },
  { "Emberlie", 0.0 },
  { "Emberlin", 0.0 },
  { "Emberly", 0.0 },
  { "Emberlyn", 0.0 },
  { "Emberlynn", 0.0 },
  { "Emberlynne", 0.0 },
  { "Embert", 1.0 },
  { "Embra", 0.0 },
  { "Embree", 0.042918455 },
  { "Embrey", 0.0 },
  { "Embri", 0.0 },
  { "Embrie", 0.0 },
  { "Embry", 0.47683108 },
  { "Embrya", 0.0 },
  { "Embyr", 0.0 },
  { "Eme", 0.0 },
  { "Emeal", 1.0 },
  { "Emedio", 1.0 },
  { "Emee", 0.0 },
  { "Emeilia", 0.0 },
  { "Emeka", 0.96028036 },
  { "Emel", 0.3529412 },
  { "Emelda", 0.0 },
  { "Emele", 0.0 },
  { "Emelee", 0.0 },
  { "Emelene", 0.0 },
  { "Emeli", 0.0 },
  { "Emelia", 0.0 },
  { "Emeliah", 0.0 },
  { "Emeliana", 0.0 },
  { "Emelie", 0.0 },
  { "Emelin", 0.0 },
  { "Emelina", 0.0 },
  { "Emelinda", 0.0 },
  { "Emeline", 0.0 },
  { "Emelio", 1.0 },
  { "Emelita", 0.0 },
  { "Emellia", 0.0 },
  { "Emellie", 0.0 },
  { "Emelly", 0.0 },
  { "Emely", 0.00089721306 },
  { "Emelya", 0.0 },
  { "Emelye", 0.0 },
  { "Emelyn", 0.0 },
  { "Emelyne", 0.0 },
  { "Emelynn", 0.0 },
  { "Emem", 0.0 },
  { "Emer", 0.24509804 },
  { "Emera", 0.0 },
  { "Emeral", 0.15873016 },
  { "Emerald", 0.052300658 },
  { "Emeralda", 0.0 },
  { "Emeraude", 0.0 },
  { "Emercyn", 0.0 },
  { "Emere", 1.0 },
  { "Emeree", 0.0 },
  { "Emerey", 0.0 },
  { "Emeri", 0.0442035 },
  { "Emeria", 0.0 },
  { "Emeric", 1.0 },
  { "Emerich", 1.0 },
  { "Emerick", 1.0 },
  { "Emerie", 0.0041067763 },
  { "Emerii", 0.0 },
  { "Emerik", 1.0 },
  { "Emeril", 0.79746836 },
  { "Emerine", 0.0 },
  { "Emeris", 1.0 },
  { "Emerita", 0.0 },
  { "Emerito", 1.0 },
  { "Emerlee", 0.0 },
  { "Emerleigh", 0.0 },
  { "Emerline", 0.0 },
  { "Emerly", 0.0 },
  { "Emerlyn", 0.0 },
  { "Emerlynn", 0.0 },
  { "Emersen", 0.07038513 },
  { "Emerson", 0.5633216 },
  { "Emersyn", 0.014120667 },
  { "Emersynn", 0.0 },
  { "Emert", 1.0 },
  { "Emery", 0.5116865 },
  { "Emeryk", 1.0 },
  { "Emeryn", 0.0 },
  { "Emerzon", 1.0 },
  { "Emese", 0.0 },
  { "Emet", 1.0 },
  { "Emeterio", 1.0 },
  { "Emeth", 1.0 },
  { "Emett", 1.0 },
  { "Emi", 0.0 },
  { "Emia", 0.0 },
  { "Emiah", 0.0 },
  { "Emidio", 1.0 },
  { "Emie", 0.0 },
  { "Emiel", 1.0 },
  { "Emier", 1.0 },
  { "Emigdio", 1.0 },
  { "Emijah", 0.0 },
  { "Emika", 0.0 },
  { "Emiko", 0.0036845985 },
  { "Emil", 0.9957862 },
  { "Emila", 0.0 },
  { "Emilce", 0.0 },
  { "Emilda", 0.0 },
  { "Emile", 0.9258531 },
  { "Emilea", 0.0 },
  { "Emileah", 0.0 },
  { "Emilee", 0.00036199094 },
  { "Emileigh", 0.0 },
  { "Emilene", 0.0 },
  { "Emileo", 1.0 },
  { "Emiley", 0.0 },
  { "Emili", 0.0 },
  { "Emilia", 0.0 },
  { "Emiliah", 0.0 },
  { "Emilian", 1.0 },
  { "Emiliana", 0.0 },
  { "Emiliann", 0.0 },
  { "Emilianna", 0.0 },
  { "Emilianne", 0.0 },
  { "Emiliano", 0.99975055 },
  { "Emilie", 0.00028218978 },
  { "Emiliee", 0.0 },
  { "Emilien", 1.0 },
  { "Emilienne", 0.0 },
  { "Emilija", 0.0 },
  { "Emilin", 0.0 },
  { "Emilina", 0.0 },
  { "Emiline", 0.0 },
  { "Emilio", 0.99847746 },
  { "Emiliya", 0.0 },
  { "Emille", 0.0 },
  { "Emillee", 0.0 },
  { "Emillia", 0.0 },
  { "Emilliana", 0.0 },
  { "Emillianna", 0.0 },
  { "Emilliano", 1.0 },
  { "Emillie", 0.0 },
  { "Emillio", 1.0 },
  { "Emilly", 0.0 },
  { "Emilo", 1.0 },
  { "Emilse", 0.0 },
  { "Emilson", 1.0 },
  { "Emily", 0.002086638 },
  { "Emilya", 0.0 },
  { "Emilyah", 0.0 },
  { "Emilyann", 0.0 },
  { "Emilyanne", 0.0 },
  { "Emilye", 0.0 },
  { "Emilyelizabeth", 0.0 },
  { "Emilygrace", 0.0 },
  { "Emilyjane", 0.0 },
  { "Emilyjo", 0.0 },
  { "Emilymae", 0.0 },
  { "Emilymarie", 0.0 },
  { "Emilyn", 0.0 },
  { "Emilyna", 0.0 },
  { "Emilyne", 0.0 },
  { "Emilynn", 0.0 },
  { "Emilyrose", 0.0 },
  { "Emin", 1.0 },
  { "Emina", 0.0 },
  { "Emine", 0.0 },
  { "Emir", 1.0 },
  { "Emira", 0.0 },
  { "Emirah", 0.0 },
  { "Emiree", 0.0 },
  { "Emireth", 0.0 },
  { "Emirhan", 1.0 },
  { "Emiri", 0.0 },
  { "Emirra", 0.0 },
  { "Emiry", 0.0 },
  { "Emisha", 0.0 },
  { "Emit", 1.0 },
  { "Emiterio", 1.0 },
  { "Emitt", 1.0 },
  { "Emitte", 1.0 },
  { "Emiya", 0.0 },
  { "Emiyah", 0.0 },
  { "Emjay", 0.43076923 },
  { "Emlee", 0.0 },
  { "Emley", 0.0 },
  { "Emly", 0.0 },
  { "Emlyn", 0.016778523 },
  { "Emlynn", 0.0 },
  { "Emma", 0.0025216853 },
  { "Emmabella", 0.0 },
  { "Emmabelle", 0.0 },
  { "Emmabeth", 0.0 },
  { "Emmaclaire", 0.0 },
  { "Emmadell", 0.0 },
  { "Emmagene", 0.0 },
  { "Emmagrace", 0.0 },
  { "Emmah", 0.0 },
  { "Emmajane", 0.0 },
  { "Emmajean", 0.0 },
  { "Emmajo", 0.0 },
  { "Emmakate", 0.0 },
  { "Emmakay", 0.0 },
  { "Emmalani", 0.0 },
  { "Emmalea", 0.0 },
  { "Emmaleah", 0.0 },
  { "Emmalee", 0.0 },
  { "Emmaleen", 0.0 },
  { "Emmalei", 0.0 },
  { "Emmaleigh", 0.0 },
  { "Emmalena", 0.0 },
  { "Emmalene", 0.0 },
  { "Emmaley", 0.0 },
  { "Emmali", 0.0 },
  { "Emmalia", 0.0 },
  { "Emmalie", 0.0 },
  { "Emmalin", 0.0 },
  { "Emmalina", 0.0 },
  { "Emmaline", 0.0 },
  { "Emmalinn", 0.0 },
  { "Emmalisa", 0.0 },
  { "Emmalise", 0.0 },
  { "Emmalou", 0.0 },
  { "Emmalouise", 0.0 },
  { "Emmaly", 0.0 },
  { "Emmalyn", 0.0 },
  { "Emmalyne", 0.0 },
  { "Emmalynn", 0.0 },
  { "Emmalynne", 0.0 },
  { "Emmalyse", 0.0 },
  { "Emmamae", 0.0 },
  { "Emmamarie", 0.0 },
  { "Emman", 0.0 },
  { "Emmanel", 1.0 },
  { "Emmaneul", 1.0 },
  { "Emmani", 0.0 },
  { "Emmanouel", 1.0 },
  { "Emmanual", 1.0 },
  { "Emmanuel", 0.99507713 },
  { "Emmanuela", 0.0 },
  { "Emmanuell", 1.0 },
  { "Emmanuella", 0.0 },
  { "Emmanuelle", 0.20060106 },
  { "Emmanul", 1.0 },
  { "Emmarae", 0.0 },
  { "Emmaree", 0.0 },
  { "Emmari", 0.0 },
  { "Emmariah", 0.0 },
  { "Emmarie", 0.0 },
  { "Emmarose", 0.0 },
  { "Emmary", 0.0 },
  { "Emmasofia", 0.0 },
  { "Emmasophia", 0.0 },
  { "Emmasue", 0.0 },
  { "Emmauel", 1.0 },
  { "Emmaus", 0.939759 },
  { "Emme", 0.0 },
  { "Emmee", 0.0 },
  { "Emmelee", 0.0 },
  { "Emmelene", 0.0 },
  { "Emmelia", 0.0 },
  { "Emmelie", 0.0 },
  { "Emmelin", 0.0 },
  { "Emmelina", 0.0 },
  { "Emmeline", 0.0 },
  { "Emmely", 0.0 },
  { "Emmelyn", 0.0 },
  { "Emmelyne", 0.0 },
  { "Emmelynn", 0.0 },
  { "Emmer", 0.0050784857 },
  { "Emmeri", 0.0 },
  { "Emmeric", 1.0 },
  { "Emmerich", 1.0 },
  { "Emmerick", 1.0 },
  { "Emmerie", 0.0 },
  { "Emmerly", 0.0 },
  { "Emmersen", 0.0 },
  { "Emmerson", 0.18568665 },
  { "Emmersyn", 0.0 },
  { "Emmert", 1.0 },
  { "Emmery", 0.03732504 },
  { "Emmeryn", 0.0 },
  { "Emmet", 1.0 },
  { "Emmett", 0.99737084 },
  { "Emmette", 1.0 },
  { "Emmey", 0.0 },
  { "Emmi", 0.0 },
  { "Emmie", 0.0 },
  { "Emmielou", 0.0 },
  { "Emmilee", 0.0 },
  { "Emmilia", 0.0 },
  { "Emmiliano", 1.0 },
  { "Emmilie", 0.0 },
  { "Emmiline", 0.0 },
  { "Emmilou", 0.0 },
  { "Emmily", 0.0 },
  { "Emmilyn", 0.0 },
  { "Emmilynn", 0.0 },
  { "Emmit", 1.0 },
  { "Emmitt", 1.0 },
  { "Emmitte", 1.0 },
  { "Emmo", 0.0 },
  { "Emmogene", 0.0 },
  { "Emmon", 1.0 },
  { "Emmoni", 0.0 },
  { "Emmons", 1.0 },
  { "Emmori", 0.0 },
  { "Emmorie", 0.0 },
  { "Emmory", 0.048543688 },
  { "Emmrie", 0.0 },
  { "Emmry", 0.0 },
  { "Emmy", 0.0 },
  { "Emmye", 0.0 },
  { "Emmylou", 0.0 },
  { "Emmytt", 1.0 },
  { "Emna", 0.0 },
  { "Emnet", 0.0 },
  { "Emo", 0.5555556 },
  { "Emogean", 0.0 },
  { "Emogene", 0.0 },
  { "Emogine", 0.0 },
  { "Emojean", 0.0 },
  { "Emolene", 0.0 },
  { "Emon", 0.8185484 },
  { "Emond", 1.0 },
  { "Emone", 0.083333336 },
  { "Emonee", 0.0 },
  { "Emoney", 0.0 },
  { "Emoni", 0.05100182 },
  { "Emonie", 0.015317286 },
  { "Emonii", 0.0 },
  { "Emonni", 0.0 },
  { "Emonnie", 0.0 },
  { "Emontae", 1.0 },
  { "Emonte", 1.0 },
  { "Emony", 0.0 },
  { "Emora", 0.0 },
  { "Emoree", 0.0 },
  { "Emori", 0.12606838 },
  { "Emorie", 0.0 },
  { "Emory", 0.79237086 },
  { "Emperatriz", 0.0 },
  { "Emperess", 0.0 },
  { "Emperor", 1.0 },
  { "Empress", 0.0 },
  { "Empris", 0.0 },
  { "Empriss", 0.0 },
  { "Empryss", 0.0 },
  { "Emra", 0.27272728 },
  { "Emraan", 1.0 },
  { "Emrah", 1.0 },
  { "Emran", 1.0 },
  { "Emre", 1.0 },
  { "Emree", 0.015652174 },
  { "Emreigh", 0.0 },
  { "Emrey", 0.1878453 },
  { "Emri", 0.065789476 },
  { "Emric", 1.0 },
  { "Emrick", 1.0 },
  { "Emrie", 0.00660502 },
  { "Emrik", 1.0 },
  { "Emron", 1.0 },
  { "Emroy", 1.0 },
  { "Emry", 0.3241791 },
  { "Emryck", 1.0 },
  { "Emryk", 1.0 },
  { "Emryn", 0.0 },
  { "Emrys", 0.79551125 },
  { "Emslee", 0.0 },
  { "Emsley", 0.023255814 },
  { "Emslie", 0.0 },
  { "Emuel", 1.0 },
  { "Emuna", 0.0 },
  { "Emunah", 0.0 },
  { "Emy", 0.0 },
  { "Emya", 0.0 },
  { "Emyah", 0.0 },
  { "Emyia", 0.0 },
  { "Emyiah", 0.0 },
  { "Emyla", 0.0 },
  { "Emylah", 0.0 },
  { "Emyle", 0.0 },
  { "Emylee", 0.0 },
  { "Emyleigh", 0.0 },
  { "Emyli", 0.0 },
  { "Emylia", 0.0 },
  { "Emylie", 0.0 },
  { "Emyly", 0.0 },
  { "Emyr", 1.0 },
  { "Emyree", 0.0 },
  { "Emyri", 0.0 },
  { "Emyrie", 0.0 },
  { "Emyrson", 0.0 },
  { "Emytt", 1.0 },
  { "Emzie", 1.0 },
  { "Emzley", 0.0 },
  { "Emzy", 1.0 },
  { "En", 1.0 },
  { "Ena", 0.0 },
  { "Enaiya", 0.0 },
  { "Enaja", 0.0 },
  { "Enajah", 0.0 },
  { "Enajiah", 0.0 },
  { "Enalina", 0.0 },
  { "Enam", 1.0 },
  { "Enan", 1.0 },
  { "Enara", 0.0 },
  { "Enari", 0.0 },
  { "Enas", 0.0 },
  { "Enasia", 0.0 },
  { "Enaya", 0.0 },
  { "Enayah", 0.0 },
  { "Enaysia", 0.0 },
  { "Encarnacion", 0.86489254 },
  { "Enchante", 0.0 },
  { "Enchantee", 0.0 },
  { "Enchantra", 0.0 },
  { "Encil", 1.0 },
  { "Enda", 0.0 },
  { "Endea", 0.0 },
  { "Ender", 1.0 },
  { "Enderson", 1.0 },
  { "Endesha", 0.0 },
  { "Endi", 1.0 },
  { "Endia", 0.0 },
  { "Endiah", 0.0 },
  { "Endie", 0.0 },
  { "Endiya", 0.0 },
  { "Endiyah", 0.0 },
  { "Endora", 0.0 },
  { "Endra", 0.0 },
  { "Endre", 1.0 },
  { "Endrew", 1.0 },
  { "Endri", 1.0 },
  { "Endrick", 1.0 },
  { "Endrit", 1.0 },
  { "Endsley", 0.0 },
  { "Endy", 0.9684874 },
  { "Endya", 0.0 },
  { "Endyah", 0.0 },
  { "Endyia", 0.0 },
  { "Enea", 1.0 },
  { "Eneas", 1.0 },
  { "Enedelia", 0.0 },
  { "Enedina", 0.0 },
  { "Enedino", 1.0 },
  { "Eneida", 0.0 },
  { "Enely", 0.0 },
  { "Enemencio", 1.0 },
  { "Ener", 1.0 },
  { "Eneri", 0.0 },
  { "Enes", 0.34608984 },
  { "Enesa", 0.0 },
  { "Enesha", 0.0 },
  { "Enessa", 0.0 },
  { "Enette", 0.0 },
  { "Eneyda", 0.0 },
  { "Enez", 0.0 },
  { "Enfinity", 0.0 },
  { "Enga", 0.0 },
  { "Engel", 1.0 },
  { "Engelbert", 1.0 },
  { "Engelberto", 1.0 },
  { "Engels", 1.0 },
  { "Enger", 0.0 },
  { "Engie", 0.0 },
  { "England", 0.12087912 },
  { "English", 0.41241685 },
  { "Engracia", 0.0 },
  { "Engrid", 0.0 },
  { "Eni", 0.0 },
  { "Enia", 0.0 },
  { "Eniah", 0.0 },
  { "Enice", 0.0 },
  { "Enid", 0.0006718925 },
  { "Enija", 0.0 },
  { "Enijah", 0.0 },
  { "Enika", 0.0 },
  { "Enilda", 0.0 },
  { "Enio", 1.0 },
  { "Eniola", 0.11210762 },
  { "Enis", 0.47396767 },
  { "Enisa", 0.0 },
  { "Enise", 0.0 },
  { "Enisha", 0.0 },
  { "Enissa", 0.0 },
  { "Enita", 0.0 },
  { "Enith", 0.0 },
  { "Eniya", 0.0 },
  { "Eniyah", 0.0 },
  { "Eniylah", 0.0 },
  { "Enjamin", 1.0 },
  { "Enjoli", 0.0 },
  { "Enjolie", 0.0 },
  { "Enki", 1.0 },
  { "Enloe", 1.0 },
  { "Enma", 0.0 },
  { "Enmanuel", 1.0 },
  { "Enna", 0.0 },
  { "Enner", 1.0 },
  { "Enneth", 1.0 },
  { "Ennette", 0.0 },
  { "Ennice", 0.0 },
  { "Ennie", 0.0 },
  { "Ennifer", 0.0 },
  { "Ennio", 1.0 },
  { "Ennis", 0.90643275 },
  { "Enno", 1.0 },
  { "Enny", 0.0 },
  { "Eno", 1.0 },
  { "Enoc", 1.0 },
  { "Enoch", 1.0 },
  { "Enock", 1.0 },
  { "Enoe", 1.0 },
  { "Enok", 1.0 },
  { "Enola", 0.0 },
  { "Enolia", 0.0 },
  { "Enora", 0.0 },
  { "Enos", 1.0 },
  { "Enosh", 1.0 },
  { "Enri", 1.0 },
  { "Enric", 1.0 },
  { "Enrica", 0.0 },
  { "Enrick", 1.0 },
  { "Enrico", 1.0 },
  { "Enrigue", 1.0 },
  { "Enrika", 0.0 },
  { "Enrike", 1.0 },
  { "Enrique", 0.9953873 },
  { "Enriqueta", 0.0 },
  { "Enriquetta", 0.0 },
  { "Enriquez", 1.0 },
  { "Enrrique", 1.0 },
  { "Enrriqueta", 0.0 },
  { "Enry", 1.0 },
  { "Ensar", 1.0 },
  { "Ensign", 1.0 },
  { "Enslee", 0.0 },
  { "Ensleigh", 0.0 },
  { "Ensley", 0.028985508 },
  { "Enslie", 0.0 },
  { "Enso", 1.0 },
  { "Enson", 1.0 },
  { "Envee", 0.0 },
  { "Enver", 1.0 },
  { "Envi", 0.0 },
  { "Envie", 0.0 },
  { "Envy", 0.010893246 },
  { "Envyi", 0.0 },
  { "Enya", 0.0 },
  { "Enyah", 0.0 },
  { "Enyce", 0.0 },
  { "Enyia", 0.0 },
  { "Enyla", 0.0 },
  { "Enylah", 0.0 },
  { "Enyssa", 0.0 },
  { "Enza", 0.0 },
  { "Enzi", 1.0 },
  { "Enzie", 0.0 },
  { "Enzio", 1.0 },
  { "Enzlee", 0.0 },
  { "Enzley", 0.0 },
  { "Enzlie", 0.0 },
  { "Enzo", 1.0 },
  { "Enzogabriel", 1.0 },
  { "Enzzo", 1.0 },
  { "Eoghan", 1.0 },
  { "Eoin", 1.0 },
  { "Eola", 0.0 },
  { "Eolia", 0.0 },
  { "Eoline", 0.0 },
  { "Eon", 1.0 },
  { "Eona", 0.0 },
  { "Eowyn", 0.0 },
  { "Eph", 1.0 },
  { "Ephraim", 1.0 },
  { "Ephrain", 1.0 },
  { "Ephram", 1.0 },
  { "Ephrata", 0.0 },
  { "Ephratah", 0.0 },
  { "Ephrem", 1.0 },
  { "Ephriam", 1.0 },
  { "Ephrim", 1.0 },
  { "Ephron", 1.0 },
  { "Epic", 0.79569894 },
  { "Epifania", 0.0 },
  { "Epifanio", 1.0 },
  { "Epigmenio", 1.0 },
  { "Epimenia", 0.0 },
  { "Epimenio", 1.0 },
  { "Epiphany", 0.0 },
  { "Epitacio", 1.0 },
  { "Epolito", 1.0 },
  { "Eponine", 0.0 },
  { "Eppie", 0.15224913 },
  { "Epsie", 0.0 },
  { "Equan", 1.0 },
  { "Equasha", 0.0 },
  { "Equasia", 0.0 },
  { "Equilla", 0.0 },
  { "Era", 0.0060975607 },
  { "Erabella", 0.0 },
  { "Eraclio", 1.0 },
  { "Eragon", 1.0 },
  { "Erah", 0.0 },
  { "Eraina", 0.0 },
  { "Eraine", 0.0 },
  { "Eraldo", 1.0 },
  { "Eralia", 0.0 },
  { "Eralyn", 0.0 },
  { "Eralynn", 0.0 },
  { "Eran", 0.8665644 },
  { "Erandi", 0.0 },
  { "Erandy", 0.0 },
  { "Erasmo", 1.0 },
  { "Erasmus", 1.0 },
  { "Erasto", 1.0 },
  { "Erastus", 1.0 },
  { "Eray", 1.0 },
  { "Erbey", 1.0 },
  { "Erbie", 0.94949496 },
  { "Erbin", 1.0 },
  { "Erblin", 1.0 },
  { "Erby", 1.0 },
  { "Ercel", 0.4548105 },
  { "Ercell", 0.32722512 },
  { "Ercelle", 0.0 },
  { "Ercia", 0.0 },
  { "Ercie", 0.0 },
  { "Ercil", 0.9268293 },
  { "Ercilia", 0.0 },
  { "Ercole", 1.0 },
  { "Erda", 0.0 },
  { "Erdell", 0.0 },
  { "Erdem", 1.0 },
  { "Erdene", 0.0 },
  { "Erdi", 1.0 },
  { "Erdine", 0.0 },
  { "Erdman", 1.0 },
  { "Erec", 1.0 },
  { "Ereca", 0.0 },
  { "Erek", 1.0 },
  { "Ereka", 0.0 },
  { "Erelene", 0.0 },
  { "Ereline", 0.0 },
  { "Eremy", 1.0 },
  { "Eren", 0.8324084 },
  { "Erena", 0.0 },
  { "Erendida", 0.0 },
  { "Erendira", 0.0 },
  { "Erene", 0.0 },
  { "Erenest", 1.0 },
  { "Erenst", 1.0 },
  { "Ereny", 0.0 },
  { "Eres", 0.0 },
  { "Eresmia", 0.0 },
  { "Eretria", 0.0 },
  { "Eretta", 0.0 },
  { "Erez", 1.0 },
  { "Erfan", 1.0 },
  { "Erford", 1.0 },
  { "Erhan", 1.0 },
  { "Erhard", 1.0 },
  { "Erhardt", 1.0 },
  { "Erhart", 1.0 },
  { "Eri", 0.5373609 },
  { "Eria", 0.0 },
  { "Eriah", 0.0 },
  { "Erial", 0.0 },
  { "Erian", 0.45679012 },
  { "Eriana", 0.0 },
  { "Erianah", 0.0 },
  { "Eriane", 0.0 },
  { "Eriani", 0.0 },
  { "Eriann", 0.0 },
  { "Erianna", 0.0 },
  { "Eriannah", 0.0 },
  { "Erianne", 0.0 },
  { "Erianny", 0.0 },
  { "Eribella", 0.0 },
  { "Eriberto", 1.0 },
  { "Eric", 0.9951008 },
  { "Erica", 0.0044442904 },
  { "Ericah", 0.0 },
  { "Erical", 0.0 },
  { "Ericalynn", 0.0 },
  { "Ericamarie", 0.0 },
  { "Ericanicole", 0.0 },
  { "Ericanthony", 1.0 },
  { "Ericberto", 1.0 },
  { "Ericc", 1.0 },
  { "Ericca", 0.0 },
  { "Ericdaniel", 1.0 },
  { "Erice", 0.8863636 },
  { "Erich", 0.9972275 },
  { "Ericha", 0.0 },
  { "Ericia", 0.0 },
  { "Ericjames", 1.0 },
  { "Erick", 0.9940836 },
  { "Ericka", 0.0020002609 },
  { "Erickah", 0.0 },
  { "Erickia", 0.0 },
  { "Erickson", 1.0 },
  { "Ericlee", 1.0 },
  { "Ericmichael", 1.0 },
  { "Erico", 1.0 },
  { "Ericson", 1.0 },
  { "Ericsson", 1.0 },
  { "Eridani", 0.0 },
  { "Erie", 0.58281296 },
  { "Erieanna", 0.0 },
  { "Eriel", 0.113144755 },
  { "Eriella", 0.0 },
  { "Erielle", 0.0 },
  { "Erien", 0.0 },
  { "Erienne", 0.0 },
  { "Erieonna", 0.0 },
  { "Eries", 1.0 },
  { "Erihanna", 0.0 },
  { "Erik", 0.99560386 },
  { "Erika", 0.0044238144 },
  { "Erikah", 0.0 },
  { "Erikc", 1.0 },
  { "Erike", 0.39285713 },
  { "Erikia", 0.0 },
  { "Erikk", 1.0 },
  { "Erikka", 0.0 },
  { "Eriko", 0.0 },
  { "Eriks", 1.0 },
  { "Eriksen", 1.0 },
  { "Erikson", 1.0 },
  { "Eriksson", 1.0 },
  { "Eril", 1.0 },
  { "Erilyn", 0.0 },
  { "Erilynn", 0.0 },
  { "Erim", 0.0 },
  { "Erin", 0.028576236 },
  { "Erina", 0.0 },
  { "Erine", 0.12 },
  { "Erineo", 1.0 },
  { "Erini", 0.0 },
  { "Erinique", 0.0 },
  { "Erinisha", 0.0 },
  { "Erinmarie", 0.0 },
  { "Erinn", 0.040729135 },
  { "Erinne", 0.0 },
  { "Eriny", 0.0 },
  { "Erioluwa", 0.47916666 },
  { "Erion", 0.7989324 },
  { "Eriona", 0.0 },
  { "Erionna", 0.0 },
  { "Erionne", 0.0 },
  { "Eriq", 1.0 },
  { "Eriqa", 0.0 },
  { "Eriqua", 0.0 },
  { "Erique", 1.0 },
  { "Eris", 0.17663552 },
  { "Erisa", 0.0 },
  { "Erisha", 0.0 },
  { "Erison", 1.0 },
  { "Eriss", 0.0 },
  { "Erissa", 0.0 },
  { "Eritrea", 0.0 },
  { "Erivan", 1.0 },
  { "Eriverto", 1.0 },
  { "Erix", 1.0 },
  { "Eriyah", 0.0 },
  { "Eriyan", 0.0 },
  { "Eriyana", 0.0 },
  { "Eriyanna", 0.0 },
  { "Eriyon", 0.52380955 },
  { "Eriyona", 0.0 },
  { "Eriyonna", 0.0 },
  { "Erjon", 1.0 },
  { "Erka", 0.0 },
  { "Erkan", 1.0 },
  { "Erla", 0.0 },
  { "Erlan", 1.0 },
  { "Erland", 1.0 },
  { "Erle", 1.0 },
  { "Erlean", 0.0 },
  { "Erleen", 0.0 },
  { "Erlene", 0.0 },
  { "Erlin", 0.94930875 },
  { "Erlinda", 0.0 },
  { "Erline", 0.0 },
  { "Erling", 1.0 },
  { "Erlon", 1.0 },
  { "Erlyne", 0.0 },
  { "Erlys", 0.0 },
  { "Erma", 0.0043286895 },
  { "Ermadean", 0.0 },
  { "Ermadine", 0.0 },
  { "Ermagene", 0.0 },
  { "Ermajean", 0.0 },
  { "Ermal", 0.43283582 },
  { "Ermalea", 0.0 },
  { "Ermalee", 0.0 },
  { "Ermalene", 0.0 },
  { "Ermalinda", 0.0 },
  { "Ermaline", 0.0 },
  { "Erman", 1.0 },
  { "Ermel", 0.4649123 },
  { "Ermelinda", 0.0 },
  { "Ermenia", 0.0 },
  { "Ermer", 0.0 },
  { "Ermia", 0.0 },
  { "Ermias", 1.0 },
  { "Ermie", 0.035460994 },
  { "Ermil", 1.0 },
  { "Ermila", 0.0 },
  { "Ermilo", 1.0 },
  { "Ermin", 1.0 },
  { "Ermina", 0.0 },
  { "Erminda", 0.0 },
  { "Ermine", 0.11375212 },
  { "Erminia", 0.0 },
  { "Erminie", 0.0 },
  { "Erminio", 1.0 },
  { "Ermis", 1.0 },
  { "Ermma", 0.0 },
  { "Ermon", 0.92462313 },
  { "Ermond", 1.0 },
  { "Erna", 0.0012142621 },
  { "Ernad", 1.0 },
  { "Ernal", 1.0 },
  { "Ernan", 1.0 },
  { "Ernel", 1.0 },
  { "Ernell", 0.0 },
  { "Ernesha", 0.0 },
  { "Erneshia", 0.0 },
  { "Ernest", 0.99386686 },
  { "Ernesta", 0.0 },
  { "Ernesteen", 0.0 },
  { "Ernestene", 0.0 },
  { "Ernestina", 0.0 },
  { "Ernestine", 0.0036005434 },
  { "Ernesto", 0.9971306 },
  { "Ernestor", 1.0 },
  { "Ernestyne", 0.0 },
  { "Ernetta", 0.0 },
  { "Ernette", 0.0 },
  { "Erney", 1.0 },
  { "Ernice", 0.0 },
  { "Ernie", 0.9581941 },
  { "Erniest", 1.0 },
  { "Ernisha", 0.0 },
  { "Ernist", 1.0 },
  { "Ernistine", 0.0 },
  { "Erno", 1.0 },
  { "Ernst", 1.0 },
  { "Ernstine", 0.0 },
  { "Erny", 1.0 },
  { "Ero", 1.0 },
  { "Erol", 1.0 },
  { "Eron", 0.8674033 },
  { "Eronda", 0.0 },
  { "Eros", 1.0 },
  { "Eroz", 1.0 },
  { "Erran", 1.0 },
  { "Errett", 1.0 },
  { "Erric", 1.0 },
  { "Errica", 0.0 },
  { "Errick", 1.0 },
  { "Erricka", 0.0 },
  { "Errik", 1.0 },
  { "Errika", 0.0 },
  { "Errin", 0.24348608 },
  { "Errion", 1.0 },
  { "Erris", 1.0 },
  { "Errol", 1.0 },
  { "Errold", 1.0 },
  { "Erroll", 1.0 },
  { "Erron", 0.98141265 },
  { "Erryn", 0.0 },
  { "Ersa", 0.0 },
  { "Ersel", 0.75 },
  { "Ersell", 0.0 },
  { "Erselle", 0.0 },
  { "Ersheen", 0.0 },
  { "Ershel", 1.0 },
  { "Ersie", 0.011904762 },
  { "Ersilia", 0.0 },
  { "Erskin", 1.0 },
  { "Erskine", 1.0 },
  { "Ersula", 0.0 },
  { "Ertha", 0.0 },
  { "Ertie", 0.0 },
  { "Ertis", 0.33333334 },
  { "Erubey", 1.0 },
  { "Erubiel", 1.0 },
  { "Erum", 0.0 },
  { "Erva", 0.0 },
  { "Ervan", 1.0 },
  { "Erven", 1.0 },
  { "Ervena", 0.0 },
  { "Ervene", 0.0 },
  { "Ervey", 1.0 },
  { "Ervie", 0.8247863 },
  { "Ervil", 1.0 },
  { "Erville", 1.0 },
  { "Ervin", 0.9963823 },
  { "Ervina", 0.0 },
  { "Ervine", 1.0 },
  { "Erving", 1.0 },
  { "Ervy", 1.0 },
  { "Erwan", 1.0 },
  { "Erwin", 0.99764174 },
  { "Ery", 1.0 },
  { "Eryana", 0.0 },
  { "Eryanna", 0.0 },
  { "Eryc", 1.0 },
  { "Eryca", 0.0 },
  { "Eryck", 1.0 },
  { "Erycka", 0.0 },
  { "Eryk", 1.0 },
  { "Eryka", 0.0 },
  { "Erykah", 0.0 },
  { "Eryn", 0.02133879 },
  { "Eryne", 0.0 },
  { "Erynn", 0.0 },
  { "Erynne", 0.0 },
  { "Eryonna", 0.0 },
  { "Eryss", 0.0 },
  { "Eryx", 1.0 },
  { "Erza", 0.27027026 },
  { "Erzsebet", 0.0 },
  { "Esa", 0.8449848 },
  { "Esabel", 0.0 },
  { "Esabella", 0.0 },
  { "Esabelle", 0.0 },
  { "Esad", 1.0 },
  { "Esai", 1.0 },
  { "Esaiah", 1.0 },
  { "Esaias", 1.0 },
  { "Esaie", 1.0 },
  { "Esain", 1.0 },
  { "Esam", 1.0 },
  { "Esat", 1.0 },
  { "Esau", 1.0 },
  { "Esaul", 1.0 },
  { "Esaw", 1.0 },
  { "Esbeidi", 0.0 },
  { "Esbeidy", 0.0 },
  { "Esben", 1.0 },
  { "Esbeydi", 0.0 },
  { "Esbeydy", 0.0 },
  { "Escar", 1.0 },
  { "Escarlet", 0.0 },
  { "Escarleth", 0.0 },
  { "Escarlett", 0.0 },
  { "Eschelle", 0.0 },
  { "Escher", 1.0 },
  { "Eschol", 1.0 },
  { "Esco", 1.0 },
  { "Escolastica", 0.0 },
  { "Esdras", 1.0 },
  { "Esean", 1.0 },
  { "Esekiel", 1.0 },
  { "Esenia", 0.0 },
  { "Eseosa", 0.0 },
  { "Esequiel", 1.0 },
  { "Eseta", 0.0 },
  { "Esey", 1.0 },
  { "Esgar", 1.0 },
  { "Esgardo", 1.0 },
  { "Esha", 0.0 },
  { "Eshaal", 0.0 },
  { "Eshaan", 1.0 },
  { "Eshal", 0.0 },
  { "Eshan", 1.0 },
  { "Eshana", 0.0 },
  { "Eshani", 0.0 },
  { "Eshanti", 0.0 },
  { "Eshaun", 1.0 },
  { "Eshawn", 1.0 },
  { "Eshawna", 0.0 },
  { "Eshe", 0.0 },
  { "Eshell", 0.0 },
  { "Esher", 1.0 },
  { "Eshika", 0.0 },
  { "Eshin", 1.0 },
  { "Eshita", 0.0 },
  { "Eshon", 1.0 },
  { "Eshter", 0.0 },
  { "Eshton", 1.0 },
  { "Eshwar", 1.0 },
  { "Esi", 0.0 },
  { "Esiah", 1.0 },
  { "Esias", 1.0 },
  { "Esiquiel", 1.0 },
  { "Esiquio", 1.0 },
  { "Eskel", 1.0 },
  { "Esker", 1.0 },
  { "Eskil", 1.0 },
  { "Esko", 1.0 },
  { "Eslem", 0.0 },
  { "Esley", 0.9605735 },
  { "Esli", 0.22510822 },
  { "Eslie", 0.625 },
  { "Esly", 0.019933555 },
  { "Eslyn", 0.0 },
  { "Esma", 0.0 },
  { "Esmae", 0.0 },
  { "Esmael", 1.0 },
  { "Esmail", 1.0 },
  { "Esmaralda", 0.0 },
  { "Esmarie", 0.0 },
  { "Esmay", 0.0 },
  { "Esme", 0.0 },
  { "Esmee", 0.0 },
  { "Esmer", 0.0 },
  { "Esmerai", 0.0 },
  { "Esmeraida", 0.0 },
  { "Esmerald", 0.0 },
  { "Esmeralda", 0.004064857 },
  { "Esmeraldo", 0.0 },
  { "Esmerelda", 0.0 },
  { "Esmerie", 0.0 },
  { "Esmerlda", 0.0 },
  { "Esmi", 0.0 },
  { "Esmia", 0.0 },
  { "Esmie", 0.0 },
  { "Esmirna", 0.0 },
  { "Esmond", 1.0 },
  { "Esnaider", 1.0 },
  { "Esneider", 1.0 },
  { "Esneyder", 1.0 },
  { "Esohe", 0.0 },
  { "Esosa", 0.24390244 },
  { "Espanola", 0.0 },
  { "Esparanza", 0.0 },
  { "Espen", 0.9375 },
  { "Esper", 0.8684211 },
  { "Esperance", 0.0 },
  { "Esperansa", 0.0 },
  { "Esperanza", 0.0018817204 },
  { "Espie", 0.7083333 },
  { "Espiridion", 1.0 },
  { "Espn", 0.9 },
  { "Esprit", 0.0 },
  { "Espy", 1.0 },
  { "Espyn", 0.15555556 },
  { "Esque", 1.0 },
  { "Esquiel", 1.0 },
  { "Esquire", 1.0 },
  { "Esra", 0.0 },
  { "Esraa", 0.0 },
  { "Esrael", 1.0 },
  { "Esrom", 1.0 },
  { "Essa", 0.75259876 },
  { "Essam", 1.0 },
  { "Essance", 0.0 },
  { "Essence", 0.0 },
  { "Essense", 0.0 },
  { "Essex", 1.0 },
  { "Essey", 1.0 },
  { "Essfa", 0.0 },
  { "Essiah", 1.0 },
  { "Essica", 0.0 },
  { "Essie", 0.02995181 },
  { "Essiemae", 0.0 },
  { "Essien", 1.0 },
  { "Essined", 0.0 },
  { "Essix", 1.0 },
  { "Essye", 0.0 },
  { "Essynce", 0.0 },
  { "Esta", 0.0061169006 },
  { "Estaban", 1.0 },
  { "Estacia", 0.0 },
  { "Estafani", 0.0 },
  { "Estafania", 0.0 },
  { "Estal", 1.0 },
  { "Estalee", 0.0 },
  { "Estaleen", 0.0 },
  { "Estalene", 0.0 },
  { "Estaline", 0.0 },
  { "Estanislada", 0.0 },
  { "Estanislado", 1.0 },
  { "Estanislao", 1.0 },
  { "Estarlin", 1.0 },
  { "Estavan", 1.0 },
  { "Estavon", 1.0 },
  { "Esteban", 0.9989448 },
  { "Estee", 0.057563588 },
  { "Esteen", 0.0 },
  { "Estefan", 1.0 },
  { "Estefana", 0.0 },
  { "Estefani", 0.0038976858 },
  { "Estefania", 0.0008229098 },
  { "Estefanie", 0.0 },
  { "Estefanita", 0.0 },
  { "Estefanny", 0.0 },
  { "Estefano", 1.0 },
  { "Estefany", 0.0010834236 },
  { "Estefanya", 0.0 },
  { "Esteffany", 0.0 },
  { "Estefhany", 0.0 },
  { "Estel", 0.839052 },
  { "Estela", 0.0 },
  { "Estele", 0.0 },
  { "Estelee", 0.0 },
  { "Estelene", 0.0 },
  { "Esteline", 0.0 },
  { "Estelita", 0.0 },
  { "Estell", 0.11445909 },
  { "Estella", 0.0014195014 },
  { "Estellar", 0.0 },
  { "Estelle", 0.002998303 },
  { "Estellene", 0.0 },
  { "Esteller", 0.0 },
  { "Estelline", 0.0 },
  { "Estellise", 0.0 },
  { "Esten", 1.0 },
  { "Estephan", 1.0 },
  { "Estephani", 0.0 },
  { "Estephania", 0.0 },
  { "Estephanie", 0.0 },
  { "Estephany", 0.0 },
  { "Estephen", 1.0 },
  { "Ester", 0.05594274 },
  { "Estera", 0.0 },
  { "Esterine", 0.0 },
  { "Esterlene", 0.0 },
  { "Esterline", 0.0 },
  { "Estes", 0.969697 },
  { "Estevan", 0.9987956 },
  { "Esteve", 1.0 },
  { "Esteven", 1.0 },
  { "Estevon", 1.0 },
  { "Esteysi", 0.0 },
  { "Estha", 0.0 },
  { "Esthefani", 0.0 },
  { "Esthefania", 0.0 },
  { "Esthefany", 0.0 },
  { "Esthel", 0.0 },
  { "Esthela", 0.0 },
  { "Esther", 0.0037848833 },
  { "Estherlene", 0.0 },
  { "Esthermae", 0.0 },
  { "Esti", 0.0 },
  { "Estibaliz", 0.0 },
  { "Estiben", 1.0 },
  { "Estie", 0.0 },
  { "Estil", 1.0 },
  { "Estill", 0.99441344 },
  { "Estilla", 0.0 },
  { "Estin", 1.0 },
  { "Estine", 0.0 },
  { "Estis", 1.0 },
  { "Estivalis", 0.0 },
  { "Estiven", 1.0 },
  { "Estle", 0.8941799 },
  { "Estol", 1.0 },
  { "Eston", 1.0 },
  { "Estoria", 0.0 },
  { "Estrada", 1.0 },
  { "Estralita", 0.0 },
  { "Estrelita", 0.0 },
  { "Estrella", 0.0 },
  { "Estrellita", 0.0 },
  { "Estreya", 0.0 },
  { "Estuardo", 1.0 },
  { "Estus", 1.0 },
  { "Esty", 0.0 },
  { "Esveidy", 0.0 },
  { "Esven", 1.0 },
  { "Esvin", 1.0 },
  { "Eswin", 1.0 },
  { "Eszter", 0.0 },
  { "Eta", 0.0 },
  { "Etai", 1.0 },
  { "Etalo", 1.0 },
  { "Etan", 1.0 },
  { "Etana", 0.0 },
  { "Etash", 1.0 },
  { "Etasha", 0.0 },
  { "Etelka", 0.0 },
  { "Etelvina", 0.0 },
  { "Eternal", 1.0 },
  { "Eterniti", 0.0 },
  { "Eternity", 0.0 },
  { "Etha", 0.0 },
  { "Ethaen", 1.0 },
  { "Ethal", 0.0 },
  { "Etham", 1.0 },
  { "Ethan", 0.9983381 },
  { "Ethanael", 1.0 },
  { "Ethanalexander", 1.0 },
  { "Ethanandrew", 1.0 },
  { "Ethane", 1.0 },
  { "Ethaneal", 1.0 },
  { "Ethangabriel", 1.0 },
  { "Ethanial", 1.0 },
  { "Ethaniel", 1.0 },
  { "Ethanjacob", 1.0 },
  { "Ethanjames", 1.0 },
  { "Ethanjay", 1.0 },
  { "Ethanjohn", 1.0 },
  { "Ethanjoseph", 1.0 },
  { "Ethanmatthew", 1.0 },
  { "Ethanmichael", 1.0 },
  { "Ethann", 1.0 },
  { "Ethanpaul", 1.0 },
  { "Ethany", 0.0 },
  { "Ethean", 1.0 },
  { "Ethel", 0.0053184084 },
  { "Ethelann", 0.0 },
  { "Ethelbert", 0.9726776 },
  { "Ethelda", 0.0 },
  { "Etheldra", 0.0 },
  { "Etheldreda", 0.0 },
  { "Ethele", 0.0 },
  { "Ethelean", 0.0 },
  { "Ethelee", 0.0 },
  { "Etheleen", 0.0 },
  { "Ethelen", 0.0 },
  { "Ethelene", 0.0 },
  { "Ethelind", 0.0 },
  { "Etheline", 0.0 },
  { "Ethell", 0.0 },
  { "Ethelle", 0.0 },
  { "Ethellee", 0.0 },
  { "Ethelmae", 0.0 },
  { "Ethelmay", 0.0 },
  { "Ethelreda", 0.0 },
  { "Ethelrene", 0.0 },
  { "Ethelrine", 0.0 },
  { "Ethelwyn", 0.0 },
  { "Ethelyn", 0.0 },
  { "Ethelyne", 0.0 },
  { "Ethelynn", 0.0 },
  { "Ethen", 1.0 },
  { "Ether", 0.0515625 },
  { "Etheridge", 1.0 },
  { "Etherine", 0.0 },
  { "Ethian", 1.0 },
  { "Ethie", 0.0 },
  { "Ethil", 0.0 },
  { "Ethin", 1.0 },
  { "Ethleen", 0.0 },
  { "Ethlyn", 0.0 },
  { "Ethna", 0.0 },
  { "Ethne", 0.0 },
  { "Ethny", 0.0 },
  { "Ethon", 1.0 },
  { "Ethredge", 1.0 },
  { "Ethridge", 1.0 },
  { "Ethyl", 0.0 },
  { "Ethyle", 0.0 },
  { "Ethyleen", 0.0 },
  { "Ethylene", 0.0 },
  { "Ethyn", 1.0 },
  { "Ethynn", 1.0 },
  { "Etienne", 0.94425327 },
  { "Etinosa", 1.0 },
  { "Etna", 0.0 },
  { "Etnie", 0.0 },
  { "Etoile", 0.0 },
  { "Etola", 0.0 },
  { "Etolia", 0.0 },
  { "Eton", 1.0 },
  { "Etonya", 0.0 },
  { "Etosha", 0.0 },
  { "Etoshia", 0.0 },
  { "Etoy", 0.0 },
  { "Etoya", 0.0 },
  { "Etoyi", 1.0 },
  { "Etoyle", 0.0 },
  { "Etrulia", 0.0 },
  { "Etsel", 1.0 },
  { "Etsub", 0.0 },
  { "Etsuko", 0.0 },
  { "Etsuo", 1.0 },
  { "Etta", 0.000563132 },
  { "Ettalyn", 0.0 },
  { "Ettamae", 0.0 },
  { "Ettel", 0.0 },
  { "Etter", 0.0 },
  { "Etti", 0.0 },
  { "Ettie", 0.0 },
  { "Ettore", 1.0 },
  { "Etty", 0.0 },
  { "Etzio", 1.0 },
  { "Eua", 0.0 },
  { "Eual", 1.0 },
  { "Euan", 1.0 },
  { "Euba", 0.0 },
  { "Eubert", 1.0 },
  { "Euclid", 1.0 },
  { "Euclide", 1.0 },
  { "Euclides", 1.0 },
  { "Euda", 0.0 },
  { "Eudean", 0.0 },
  { "Eudelia", 0.0 },
  { "Eudell", 0.3538874 },
  { "Eudella", 0.0 },
  { "Eudena", 0.0 },
  { "Eudene", 0.0 },
  { "Eudice", 0.0 },
  { "Eudine", 0.0 },
  { "Eudon", 1.0 },
  { "Eudora", 0.0 },
  { "Eudy", 1.0 },
  { "Euel", 1.0 },
  { "Euell", 1.0 },
  { "Euella", 0.0 },
  { "Eufaula", 0.0 },
  { "Eufelia", 0.0 },
  { "Eufemia", 0.0 },
  { "Eufemio", 1.0 },
  { "Eufracia", 0.0 },
  { "Eufracio", 1.0 },
  { "Eufrasia", 0.0 },
  { "Eugean", 1.0 },
  { "Eugen", 1.0 },
  { "Eugena", 0.0 },
  { "Eugene", 0.99310553 },
  { "Eugenia", 0.0005088368 },
  { "Eugenie", 0.0 },
  { "Eugenio", 1.0 },
  { "Eugie", 0.0 },
  { "Eugina", 0.0 },
  { "Eugine", 1.0 },
  { "Euginia", 0.0 },
  { "Eugne", 1.0 },
  { "Eugonda", 0.0 },
  { "Euguene", 1.0 },
  { "Eugune", 1.0 },
  { "Euin", 1.0 },
  { "Eujin", 0.0 },
  { "Eula", 0.0070056976 },
  { "Eulah", 0.0 },
  { "Eulala", 0.0 },
  { "Eulalah", 0.0 },
  { "Eulalee", 0.0 },
  { "Eulalia", 0.0 },
  { "Eulalie", 0.0 },
  { "Eulalio", 1.0 },
  { "Eulamae", 0.0 },
  { "Eulan", 1.0 },
  { "Eulanda", 0.0 },
  { "Eulane", 0.0 },
  { "Eular", 0.0 },
  { "Eulas", 1.0 },
  { "Eulean", 0.0 },
  { "Eulee", 0.0 },
  { "Eulema", 0.0 },
  { "Eulene", 0.0 },
  { "Eules", 1.0 },
  { "Euless", 1.0 },
  { "Euleta", 0.0 },
  { "Eulia", 0.0 },
  { "Eulice", 0.9790795 },
  { "Eulices", 1.0 },
  { "Eulie", 1.0 },
  { "Eulina", 0.0 },
  { "Eulinda", 0.0 },
  { "Euline", 0.0 },
  { "Eulis", 1.0 },
  { "Eulises", 1.0 },
  { "Eulla", 0.0 },
  { "Eulogia", 0.0 },
  { "Eulogio", 1.0 },
  { "Eulojia", 0.0 },
  { "Eulojio", 1.0 },
  { "Eulon", 1.0 },
  { "Eulonda", 0.0 },
  { "Eulos", 1.0 },
  { "Eulus", 1.0 },
  { "Eulys", 1.0 },
  { "Eumeka", 0.0 },
  { "Eun", 0.01724138 },
  { "Euna", 0.0 },
  { "Eunetta", 0.0 },
  { "Eunia", 0.0 },
  { "Eunice", 0.014626455 },
  { "Eunie", 0.0 },
  { "Euniece", 0.0 },
  { "Eunika", 0.0 },
  { "Euniqua", 0.0 },
  { "Eunique", 0.016949153 },
  { "Eunise", 0.0 },
  { "Eunita", 0.0 },
  { "Eunji", 0.0 },
  { "Eupha", 0.0 },
  { "Euphemia", 0.0 },
  { "Euphemie", 0.0 },
  { "Euphoria", 0.0 },
  { "Euple", 0.0 },
  { "Eura", 0.05465192 },
  { "Euradell", 0.0 },
  { "Eural", 1.0 },
  { "Eurania", 0.0 },
  { "Eurasia", 0.0 },
  { "Euree", 0.0 },
  { "Eureeka", 0.0 },
  { "Eureka", 0.005952381 },
  { "Eurel", 1.0 },
  { "Euretha", 0.0 },
  { "Euretta", 0.0 },
  { "Euri", 0.53846157 },
  { "Euriah", 0.9230769 },
  { "Eurica", 0.0 },
  { "Euricka", 0.0 },
  { "Eurie", 0.6666667 },
  { "Euriel", 1.0 },
  { "Eurijah", 1.0 },
  { "Eurika", 0.0 },
  { "Euris", 1.0 },
  { "Eurith", 0.0 },
  { "Eurma", 0.0 },
  { "Eury", 1.0 },
  { "Eurydice", 0.0 },
  { "Eusebia", 0.0 },
  { "Eusebio", 1.0 },
  { "Eusevia", 0.0 },
  { "Eusevio", 1.0 },
  { "Eustace", 1.0 },
  { "Eustacia", 0.0 },
  { "Eustacio", 1.0 },
  { "Eustaquio", 1.0 },
  { "Eustice", 1.0 },
  { "Eustis", 1.0 },
  { "Eustolia", 0.0 },
  { "Eustolio", 1.0 },
  { "Eutha", 0.0 },
  { "Eutimia", 0.0 },
  { "Eutimio", 1.0 },
  { "Eutiquio", 1.0 },
  { "Euva", 0.0 },
  { "Euzelia", 0.0 },
  { "Eva", 0.0038258636 },
  { "Evaan", 1.0 },
  { "Evabelle", 0.0 },
  { "Evada", 0.0 },
  { "Evadean", 0.0 },
  { "Evadell", 0.0 },
  { "Evadene", 0.0 },
  { "Evadine", 0.0 },
  { "Evadna", 0.0 },
  { "Evadne", 0.0 },
  { "Evaeh", 0.0 },
  { "Evagelia", 0.0 },
  { "Evagelos", 1.0 },
  { "Evagene", 0.0 },
  { "Evaggelia", 0.0 },
  { "Evagrace", 0.0 },
  { "Evah", 0.0 },
  { "Evaine", 0.0 },
  { "Evajane", 0.0 },
  { "Evajean", 0.0 },
  { "Evajo", 0.0 },
  { "Evalani", 0.0 },
  { "Evald", 1.0 },
  { "Evalean", 0.0 },
  { "Evalee", 0.0 },
  { "Evaleen", 0.0 },
  { "Evaleena", 0.0 },
  { "Evalei", 0.0 },
  { "Evaleigh", 0.0 },
  { "Evalen", 0.0 },
  { "Evalena", 0.0 },
  { "Evalene", 0.0 },
  { "Evalet", 0.0 },
  { "Evalett", 0.0 },
  { "Evalette", 0.0 },
  { "Evalia", 0.0 },
  { "Evalie", 0.0 },
  { "Evalin", 0.0 },
  { "Evalina", 0.0 },
  { "Evalinda", 0.0 },
  { "Evaline", 0.0 },
  { "Evalisa", 0.0 },
  { "Evalise", 0.0 },
  { "Evalisse", 0.0 },
  { "Evaliz", 0.0 },
  { "Evalou", 0.0 },
  { "Evaluna", 0.0 },
  { "Evaly", 0.0 },
  { "Evalyn", 0.0 },
  { "Evalyna", 0.0 },
  { "Evalyne", 0.0 },
  { "Evalynn", 0.0 },
  { "Evalynne", 0.0 },
  { "Evalyse", 0.0 },
  { "Evamae", 0.0 },
  { "Evamaria", 0.0 },
  { "Evamarie", 0.0 },
  { "Evan", 0.9845699 },
  { "Evana", 0.0 },
  { "Evander", 1.0 },
  { "Evanee", 0.0 },
  { "Evanell", 0.0 },
  { "Evanelle", 0.0 },
  { "Evaney", 0.0 },
  { "Evangalene", 0.0 },
  { "Evangaline", 0.0 },
  { "Evangel", 1.0 },
  { "Evangela", 0.0 },
  { "Evangeleen", 0.0 },
  { "Evangelena", 0.0 },
  { "Evangelene", 0.0 },
  { "Evangelia", 0.0 },
  { "Evangelin", 0.0 },
  { "Evangelina", 0.0 },
  { "Evangeline", 0.0 },
  { "Evangelita", 0.0 },
  { "Evangelo", 1.0 },
  { "Evangelos", 1.0 },
  { "Evangely", 0.0 },
  { "Evangelyn", 0.0 },
  { "Evangelyne", 0.0 },
  { "Evangelynn", 0.0 },
  { "Evangline", 0.0 },
  { "Evani", 0.0 },
  { "Evania", 0.0 },
  { "Evanie", 0.0 },
  { "Evanjames", 1.0 },
  { "Evanjelina", 0.0 },
  { "Evann", 0.5536232 },
  { "Evanna", 0.0 },
  { "Evannah", 0.0 },
  { "Evanne", 0.0 },
  { "Evanni", 0.0 },
  { "Evannie", 0.0 },
  { "Evanny", 0.0 },
  { "Evanora", 0.0 },
  { "Evans", 0.9912191 },
  { "Evanston", 1.0 },
  { "Evante", 1.0 },
  { "Evanthia", 0.0 },
  { "Evany", 0.0 },
  { "Evanyelin", 0.0 },
  { "Evar", 1.0 },
  { "Evard", 1.0 },
  { "Evarista", 0.0 },
  { "Evaristo", 1.0 },
  { "Evarose", 0.0 },
  { "Evart", 1.0 },
  { "Evaughn", 0.0 },
  { "Evay", 1.0 },
  { "Evaya", 0.0 },
  { "Evdokia", 0.0 },
  { "Evdoxia", 0.0 },
  { "Eve", 0.0 },
  { "Evea", 0.0 },
  { "Eveah", 0.0 },
  { "Eveana", 0.0 },
  { "Eveanna", 0.0 },
  { "Evee", 0.0 },
  { "Evel", 1.0 },
  { "Evelean", 0.0 },
  { "Evelee", 0.0 },
  { "Eveleen", 0.0 },
  { "Eveleigh", 0.0 },
  { "Evelen", 0.0 },
  { "Evelena", 0.0 },
  { "Evelene", 0.0 },
  { "Evelet", 0.0 },
  { "Evelett", 0.0 },
  { "Evelette", 0.0 },
  { "Eveli", 0.0 },
  { "Evelia", 0.0 },
  { "Evelie", 0.0 },
  { "Evelien", 0.0 },
  { "Evelin", 0.0007524454 },
  { "Evelina", 0.0 },
  { "Evelinda", 0.0 },
  { "Eveline", 0.0 },
  { "Evelinn", 0.0 },
  { "Evelio", 1.0 },
  { "Evelis", 0.0 },
  { "Evelise", 0.0 },
  { "Evelisse", 0.0 },
  { "Eveliz", 0.0 },
  { "Evell", 1.0 },
  { "Evella", 0.0 },
  { "Evellyn", 0.0 },
  { "Evely", 0.0 },
  { "Evelyn", 0.0033030047 },
  { "Evelyna", 0.0 },
  { "Evelyne", 0.0 },
  { "Evelynn", 0.0 },
  { "Evelynne", 0.0 },
  { "Evelynrose", 0.0 },
  { "Evelyon", 0.0 },
  { "Evelyse", 0.0 },
  { "Evemarie", 0.0 },
  { "Even", 1.0 },
  { "Evenie", 0.0 },
  { "Evening", 0.0 },
  { "Evennie", 0.0 },
  { "Evenny", 0.0 },
  { "Evens", 1.0 },
  { "Eveny", 0.0 },
  { "Ever", 0.60946137 },
  { "Evera", 0.0 },
  { "Everado", 1.0 },
  { "Everal", 0.5 },
  { "Everard", 1.0 },
  { "Everardo", 1.0 },
  { "Everdeen", 0.0 },
  { "Everee", 0.0 },
  { "Everest", 0.8819444 },
  { "Everet", 1.0 },
  { "Everett", 0.9942536 },
  { "Everetta", 0.0 },
  { "Everette", 0.9850256 },
  { "Evergreen", 0.0 },
  { "Everhett", 1.0 },
  { "Everick", 1.0 },
  { "Everitt", 1.0 },
  { "Everlea", 0.0 },
  { "Everlean", 0.0 },
  { "Everleaner", 0.0 },
  { "Everlee", 0.0 },
  { "Everleen", 0.0 },
  { "Everlei", 0.0 },
  { "Everleigh", 0.0 },
  { "Everlena", 0.0 },
  { "Everlene", 0.0 },
  { "Everlener", 0.0 },
  { "Everley", 0.0 },
  { "Everli", 0.0 },
  { "Everlie", 0.0 },
  { "Everliegh", 0.0 },
  { "Everlin", 0.0 },
  { "Everlina", 0.0 },
  { "Everline", 0.0 },
  { "Everly", 0.0012406948 },
  { "Everlyn", 0.0 },
  { "Everlynn", 0.0 },
  { "Everlyse", 0.0 },
  { "Evern", 0.6792453 },
  { "Everrett", 1.0 },
  { "Everrette", 1.0 },
  { "Everson", 1.0 },
  { "Eversyn", 0.0 },
  { "Evert", 1.0 },
  { "Everth", 1.0 },
  { "Everton", 1.0 },
  { "Evertt", 1.0 },
  { "Evertte", 1.0 },
  { "Every", 0.5 },
  { "Evester", 1.0 },
  { "Evet", 0.0 },
  { "Evett", 0.0 },
  { "Evetta", 0.0 },
  { "Evette", 0.0 },
  { "Evey", 0.0 },
  { "Eveyln", 0.0 },
  { "Evgenia", 0.0 },
  { "Evi", 0.0 },
  { "Evia", 0.0 },
  { "Evian", 0.48358864 },
  { "Eviana", 0.0 },
  { "Evianna", 0.0 },
  { "Evie", 0.007474813 },
  { "Evienne", 0.0 },
  { "Evila", 0.0 },
  { "Evilin", 0.0 },
  { "Evilo", 0.0 },
  { "Evilyn", 0.0 },
  { "Evilynn", 0.0 },
  { "Evin", 0.85662866 },
  { "Evina", 0.0 },
  { "Evins", 1.0 },
  { "Evion", 1.0 },
  { "Evionna", 0.0 },
  { "Evita", 0.0 },
  { "Evleen", 0.0 },
  { "Evleyn", 0.0 },
  { "Evlin", 0.0 },
  { "Evline", 0.0 },
  { "Evlyn", 0.0 },
  { "Evlynn", 0.0 },
  { "Evnika", 0.0 },
  { "Evo", 1.0 },
  { "Evodio", 1.0 },
  { "Evola", 0.0 },
  { "Evoleht", 0.0 },
  { "Evolet", 0.0 },
  { "Evoleth", 0.0 },
  { "Evolett", 0.0 },
  { "Evolette", 0.0 },
  { "Evon", 0.16205803 },
  { "Evona", 0.0 },
  { "Evonda", 0.0 },
  { "Evone", 0.012048192 },
  { "Evoni", 0.0 },
  { "Evonia", 0.0 },
  { "Evonie", 0.0 },
  { "Evonn", 0.0 },
  { "Evonna", 0.0 },
  { "Evonne", 0.0 },
  { "Evonnie", 0.0 },
  { "Evonny", 0.0 },
  { "Evontae", 1.0 },
  { "Evonte", 1.0 },
  { "Evony", 0.0 },
  { "Evora", 0.0 },
  { "Evorn", 0.0 },
  { "Evra", 0.0 },
  { "Evran", 1.0 },
  { "Evren", 0.95527154 },
  { "Evrett", 1.0 },
  { "Evrhett", 1.0 },
  { "Evrin", 1.0 },
  { "Evva", 0.0 },
  { "Evvie", 0.0 },
  { "Evvy", 0.0 },
  { "Evy", 0.0 },
  { "Evyan", 0.0 },
  { "Evyana", 0.0 },
  { "Evyanna", 0.0 },
  { "Evyenia", 0.0 },
  { "Evylen", 0.0 },
  { "Evylene", 0.0 },
  { "Evylin", 0.0 },
  { "Evyn", 0.44585988 },
  { "Evynn", 0.021645023 },
  { "Evynne", 0.0 },
  { "Evyonne", 0.0 },
  { "Ewa", 0.0 },
  { "Ewald", 1.0 },
  { "Ewalt", 1.0 },
  { "Ewan", 1.0 },
  { "Ewanda", 0.0 },
  { "Ewaoluwa", 0.0 },
  { "Eward", 1.0 },
  { "Ewart", 1.0 },
  { "Ewel", 1.0 },
  { "Ewelina", 0.0 },
  { "Ewell", 0.99659866 },
  { "Ewen", 1.0 },
  { "Ewin", 1.0 },
  { "Ewing", 1.0 },
  { "Exa", 0.0 },
  { "Exael", 1.0 },
  { "Exander", 1.0 },
  { "Exar", 1.0 },
  { "Exavier", 1.0 },
  { "Exavion", 1.0 },
  { "Exavior", 1.0 },
  { "Excel", 0.36666667 },
  { "Excell", 0.9880096 },
  { "Exel", 1.0 },
  { "Exell", 1.0 },
  { "Exequiel", 1.0 },
  { "Exer", 0.0 },
  { "Exia", 0.0 },
  { "Exie", 0.0029112082 },
  { "Exilda", 0.0 },
  { "Exiquio", 1.0 },
  { "Exodus", 0.8547297 },
  { "Exton", 1.0 },
  { "Exum", 1.0 },
  { "Exzander", 1.0 },
  { "Exzavier", 1.0 },
  { "Exzavion", 1.0 },
  { "Exzavior", 1.0 },
  { "Eya", 0.0 },
  { "Eyad", 1.0 },
  { "Eyal", 1.0 },
  { "Eyan", 1.0 },
  { "Eyana", 0.0 },
  { "Eyani", 0.0 },
  { "Eyanna", 0.0 },
  { "Eyas", 1.0 },
  { "Eyasu", 1.0 },
  { "Eydan", 1.0 },
  { "Eyden", 0.9764151 },
  { "Eydi", 0.0 },
  { "Eydie", 0.0 },
  { "Eyen", 1.0 },
  { "Eygpt", 0.0 },
  { "Eyian", 1.0 },
  { "Eyla", 0.0 },
  { "Eylah", 0.0 },
  { "Eylan", 1.0 },
  { "Eyleen", 0.0 },
  { "Eylin", 0.0 },
  { "Eylul", 0.0 },
  { "Eymen", 1.0 },
  { "Eymi", 0.0 },
  { "Eymy", 0.0 },
  { "Eyoab", 1.0 },
  { "Eyob", 1.0 },
  { "Eyoel", 1.0 },
  { "Eyon", 1.0 },
  { "Eyona", 0.0 },
  { "Eyonna", 0.0 },
  { "Eyosias", 1.0 },
  { "Eyra", 0.0 },
  { "Eyram", 0.3125 },
  { "Eytan", 1.0 },
  { "Eythan", 1.0 },
  { "Eythel", 0.0 },
  { "Eythen", 1.0 },
  { "Eyuel", 1.0 },
  { "Eyva", 0.0 },
  { "Eyvan", 1.0 },
  { "Eyvette", 0.0 },
  { "Eyvin", 1.0 },
  { "Eyvone", 0.0 },
  { "Eyvonne", 0.0 },
  { "Ezaan", 1.0 },
  { "Ezabel", 0.0 },
  { "Ezabella", 0.0 },
  { "Ezabelle", 0.0 },
  { "Ezael", 1.0 },
  { "Ezai", 1.0 },
  { "Ezaiah", 1.0 },
  { "Ezana", 1.0 },
  { "Ezara", 0.0 },
  { "Ezaria", 0.0 },
  { "Ezariah", 0.6969697 },
  { "Ezariyah", 0.0 },
  { "Ezavier", 1.0 },
  { "Ezayah", 1.0 },
  { "Eze", 1.0 },
  { "Ezechiel", 1.0 },
  { "Ezekeal", 1.0 },
  { "Ezekeial", 1.0 },
  { "Ezekeil", 1.0 },
  { "Ezekiah", 1.0 },
  { "Ezekial", 1.0 },
  { "Ezekias", 1.0 },
  { "Ezekiel", 0.99964136 },
  { "Ezekio", 1.0 },
  { "Ezekyel", 1.0 },
  { "Ezel", 1.0 },
  { "Ezell", 0.88630706 },
  { "Ezella", 0.0 },
  { "Ezelle", 0.3508772 },
  { "Ezequel", 1.0 },
  { "Ezequias", 1.0 },
  { "Ezequiel", 1.0 },
  { "Ezequil", 1.0 },
  { "Ezera", 1.0 },
  { "Ezeriah", 1.0 },
  { "Ezgi", 0.0 },
  { "Eziah", 0.97619045 },
  { "Ezias", 1.0 },
  { "Ezichi", 0.0 },
  { "Eziel", 1.0 },
  { "Ezikiel", 1.0 },
  { "Ezinne", 0.0 },
  { "Ezio", 1.0 },
  { "Ezion", 1.0 },
  { "Eziquel", 1.0 },
  { "Eziquiel", 1.0 },
  { "Eziquio", 1.0 },
  { "Eziya", 0.0 },
  { "Eziyah", 0.0 },
  { "Ezkiel", 1.0 },
  { "Ezlynn", 0.0 },
  { "Ezma", 0.0 },
  { "Ezmae", 0.0 },
  { "Ezmariah", 0.0 },
  { "Ezmay", 0.0 },
  { "Ezme", 0.0 },
  { "Ezmeralda", 0.0 },
  { "Ezmerelda", 0.0 },
  { "Ezmie", 0.0 },
  { "Ezola", 0.0 },
  { "Ezora", 0.0 },
  { "Ezoza", 0.0 },
  { "Ezperanza", 0.0 },
  { "Ezquiel", 1.0 },
  { "Ezra", 0.9569183 },
  { "Ezrael", 1.0 },
  { "Ezrah", 0.7786017 },
  { "Ezreal", 1.0 },
  { "Ezren", 1.0 },
  { "Ezri", 0.15 },
  { "Ezria", 0.0 },
  { "Ezriah", 1.0 },
  { "Ezrie", 0.0 },
  { "Ezriel", 1.0 },
  { "Eztli", 0.0 },
  { "Ezykiel", 1.0 },
  { "Ezzah", 0.0 },
  { "Ezzard", 1.0 },
  { "Ezzie", 0.13194445 },
  { "Faaiz", 1.0 },
  { "Faaizah", 0.0 },
  { "Faaris", 1.0 },
  { "Faatima", 0.0 },
  { "Faatimah", 0.0 },
  { "Faaz", 1.0 },
  { "Fabain", 1.0 },
  { "Faber", 1.0 },
  { "Fabia", 0.0 },
  { "Fabian", 0.99139816 },
  { "Fabiana", 0.0 },
  { "Fabianna", 0.0 },
  { "Fabiano", 1.0 },
  { "Fabien", 1.0 },
  { "Fabiene", 0.0 },
  { "Fabienne", 0.0 },
  { "Fabiha", 0.0 },
  { "Fabin", 1.0 },
  { "Fabio", 1.0 },
  { "Fabiola", 0.006010433 },
  { "Fabion", 1.0 },
  { "Fabius", 1.0 },
  { "Fable", 0.04950495 },
  { "Fabriana", 0.0 },
  { "Fabrice", 1.0 },
  { "Fabricio", 1.0 },
  { "Fabrienne", 0.0 },
  { "Fabrisio", 1.0 },
  { "Fabrizio", 1.0 },
  { "Fabrizzio", 1.0 },
  { "Faby", 0.0 },
  { "Fabyan", 1.0 },
  { "Fachon", 0.0 },
  { "Facundo", 1.0 },
  { "Fada", 0.0 },
  { "Fadak", 0.0 },
  { "Fadeelah", 0.0 },
  { "Fadel", 1.0 },
  { "Fadi", 1.0 },
  { "Fadia", 0.0 },
  { "Fadil", 1.0 },
  { "Fadila", 0.0 },
  { "Fadima", 0.0 },
  { "Fadra", 0.0 },
  { "Faduma", 0.0 },
  { "Fadumo", 0.0 },
  { "Fadwa", 0.0 },
  { "Fady", 1.0 },
  { "Fae", 0.0 },
  { "Faedra", 0.0 },
  { "Faelan", 0.8333333 },
  { "Faelyn", 0.0 },
  { "Faelynn", 0.0 },
  { "Faeryn", 0.0 },
  { "Fahad", 1.0 },
  { "Fahd", 1.0 },
  { "Fahed", 1.0 },
  { "Faheem", 1.0 },
  { "Faheemah", 0.0 },
  { "Fahim", 1.0 },
  { "Fahima", 0.0 },
  { "Fahm", 0.0 },
  { "Fahmi", 1.0 },
  { "Fahmida", 0.0 },
  { "Fahren", 0.0 },
  { "Fahtima", 0.0 },
  { "Faida", 0.0 },
  { "Faiga", 0.0 },
  { "Faige", 0.0 },
  { "Faigy", 0.0 },
  { "Faiha", 0.0 },
  { "Fain", 0.9220779 },
  { "Faina", 0.0 },
  { "Faiq", 1.0 },
  { "Fair", 0.10869565 },
  { "Faira", 0.0 },
  { "Fairah", 0.0 },
  { "Fairbanks", 1.0 },
  { "Fairen", 0.0 },
  { "Fairie", 0.0 },
  { "Fairley", 1.0 },
  { "Fairy", 0.0 },
  { "Fairyn", 0.0 },
  { "Faisa", 0.0 },
  { "Faisal", 1.0 },
  { "Faison", 1.0 },
  { "Faith", 0.001743885 },
  { "Faithann", 0.0 },
  { "Faithanne", 0.0 },
  { "Faithe", 0.0 },
  { "Faithful", 0.0 },
  { "Faithlyn", 0.0 },
  { "Faithlynn", 0.0 },
  { "Faithmarie", 0.0 },
  { "Faiyaz", 1.0 },
  { "Faiz", 1.0 },
  { "Faiza", 0.0 },
  { "Faizaan", 1.0 },
  { "Faizah", 0.0 },
  { "Faizal", 1.0 },
  { "Faizan", 1.0 },
  { "Faizon", 1.0 },
  { "Fajar", 0.0 },
  { "Fajr", 0.0 },
  { "Falak", 0.0 },
  { "Falan", 0.0 },
  { "Falana", 0.0 },
  { "Falanda", 0.0 },
  { "Falando", 1.0 },
  { "Falba", 0.0 },
  { "Falco", 1.0 },
  { "Falcon", 0.93352604 },
  { "Falecia", 0.0 },
  { "Faleisha", 0.0 },
  { "Falen", 0.0 },
  { "Falena", 0.0 },
  { "Falencia", 0.0 },
  { "Falesha", 0.0 },
  { "Faleshia", 0.0 },
  { "Falicia", 0.0 },
  { "Falicity", 0.0 },
  { "Falin", 0.0 },
  { "Falina", 0.0 },
  { "Faline", 0.0 },
  { "Falisa", 0.0 },
  { "Falisha", 0.0 },
  { "Falishia", 0.0 },
  { "Fallan", 0.0 },
  { "Fallen", 0.0 },
  { "Fallie", 0.0 },
  { "Fallin", 0.0 },
  { "Fallon", 0.043010753 },
  { "Fallou", 1.0 },
  { "Fallyn", 0.0 },
  { "Fallynn", 0.0 },
  { "Falon", 0.042783506 },
  { "Falona", 0.0 },
  { "Falonda", 0.0 },
  { "Falone", 0.0 },
  { "Falyn", 0.0 },
  { "Falynn", 0.0 },
  { "Falynne", 0.0 },
  { "Falysha", 0.0 },
  { "Fama", 0.0 },
  { "Fame", 0.0 },
  { "Famie", 0.0 },
  { "Famous", 1.0 },
  { "Fan", 0.0 },
  { "Fana", 0.0 },
  { "Fanchon", 0.0 },
  { "Fanci", 0.0 },
  { "Fancie", 0.0 },
  { "Fancy", 0.0 },
  { "Faneisha", 0.0 },
  { "Fanessa", 0.0 },
  { "Fani", 0.0 },
  { "Fania", 0.0 },
  { "Fanie", 0.0 },
  { "Fanisha", 0.0 },
  { "Fanita", 0.0 },
  { "Fanna", 0.0 },
  { "Fannette", 0.0 },
  { "Fannie", 0.0043294616 },
  { "Fanniemae", 0.0 },
  { "Fanny", 0.0 },
  { "Fannye", 0.0 },
  { "Fanon", 1.0 },
  { "Fanta", 0.0 },
  { "Fantaisa", 0.0 },
  { "Fantasha", 0.0 },
  { "Fantashia", 0.0 },
  { "Fantasia", 0.0 },
  { "Fantasy", 0.0 },
  { "Fantaysia", 0.0 },
  { "Fantazia", 0.0 },
  { "Fanuel", 1.0 },
  { "Fany", 0.0 },
  { "Fanya", 0.0 },
  { "Faolan", 1.0 },
  { "Faora", 0.0 },
  { "Fara", 0.0 },
  { "Faraaz", 1.0 },
  { "Farad", 1.0 },
  { "Faraday", 0.0 },
  { "Farah", 0.018200202 },
  { "Farai", 1.0 },
  { "Faraj", 1.0 },
  { "Faraji", 1.0 },
  { "Faran", 0.2 },
  { "Faraz", 1.0 },
  { "Farbod", 1.0 },
  { "Fard", 1.0 },
  { "Fardeen", 1.0 },
  { "Fardi", 1.0 },
  { "Fardin", 1.0 },
  { "Fardosa", 0.0 },
  { "Fardowsa", 0.0 },
  { "Fardy", 1.0 },
  { "Fareed", 1.0 },
  { "Fareeda", 0.0 },
  { "Fareedah", 0.0 },
  { "Fareeha", 0.0 },
  { "Faren", 0.0 },
  { "Fares", 1.0 },
  { "Farha", 0.0 },
  { "Farhaan", 1.0 },
  { "Farhad", 1.0 },
  { "Farhan", 1.0 },
  { "Farhana", 0.0 },
  { "Farheen", 0.0 },
  { "Farhiya", 0.0 },
  { "Farhiyo", 0.0 },
  { "Fari", 0.0 },
  { "Faria", 0.0 },
  { "Fariah", 0.0 },
  { "Fariba", 0.0 },
  { "Farica", 0.0 },
  { "Farice", 0.0 },
  { "Farid", 1.0 },
  { "Farida", 0.0 },
  { "Faridah", 0.0 },
  { "Fariha", 0.0 },
  { "Farihah", 0.0 },
  { "Farin", 0.1491228 },
  { "Farina", 0.0 },
  { "Faris", 0.9908592 },
  { "Farisa", 0.0 },
  { "Fariz", 1.0 },
  { "Fariza", 0.0 },
  { "Farjana", 0.0 },
  { "Farley", 0.9906367 },
  { "Farm", 0.0 },
  { "Farmer", 1.0 },
  { "Farnaz", 0.0 },
  { "Farnum", 1.0 },
  { "Farol", 0.0 },
  { "Faron", 0.97806835 },
  { "Farooq", 1.0 },
  { "Farouk", 1.0 },
  { "Farouq", 1.0 },
  { "Farra", 0.0 },
  { "Farrad", 1.0 },
  { "Farrah", 0.000680206 },
  { "Farrakhan", 1.0 },
  { "Farran", 0.0 },
  { "Farrar", 0.0 },
  { "Farrel", 0.9562716 },
  { "Farrell", 0.90104824 },
  { "Farren", 0.3024055 },
  { "Farrie", 0.0 },
  { "Farrin", 0.115384616 },
  { "Farris", 0.8501917 },
  { "Farron", 0.83406115 },
  { "Farrow", 1.0 },
  { "Farrukh", 1.0 },
  { "Farryn", 0.0 },
  { "Farshad", 1.0 },
  { "Farshid", 1.0 },
  { "Fartun", 0.0 },
  { "Faruk", 1.0 },
  { "Faruq", 1.0 },
  { "Farwa", 0.0 },
  { "Faryal", 0.0 },
  { "Faryl", 0.0 },
  { "Faryn", 0.0 },
  { "Farynn", 0.0 },
  { "Farzad", 1.0 },
  { "Farzan", 1.0 },
  { "Farzana", 0.0 },
  { "Farzeen", 0.0 },
  { "Farzin", 1.0 },
  { "Farzona", 0.0 },
  { "Fasha", 0.0 },
  { "Fashionette", 0.0 },
  { "Fatai", 1.0 },
  { "Fate", 0.9064465 },
  { "Fateema", 0.0 },
  { "Fateemah", 0.0 },
  { "Fateen", 1.0 },
  { "Fateh", 1.0 },
  { "Fateha", 0.0 },
  { "Fatema", 0.0 },
  { "Fatemah", 0.0 },
  { "Fatemeh", 0.0 },
  { "Faten", 0.0 },
  { "Fathi", 0.8108108 },
  { "Fathia", 0.0 },
  { "Fathima", 0.0 },
  { "Fathma", 0.0 },
  { "Fatia", 0.0 },
  { "Fatih", 1.0 },
  { "Fatiha", 0.0 },
  { "Fatim", 0.0 },
  { "Fatima", 0.0015038577 },
  { "Fatimah", 0.0 },
  { "Fatimat", 0.0 },
  { "Fatimata", 0.0 },
  { "Fatimatou", 0.0 },
  { "Fatimazahra", 0.0 },
  { "Fatime", 0.0 },
  { "Fatimetou", 0.0 },
  { "Fatin", 0.14492753 },
  { "Fatina", 0.0 },
  { "Fatisha", 0.0 },
  { "Fatma", 0.0 },
  { "Fatmah", 0.0 },
  { "Fatmata", 0.0 },
  { "Fatme", 0.0 },
  { "Fatmeh", 0.0 },
  { "Fatmir", 1.0 },
  { "Fatmire", 0.0 },
  { "Fatou", 0.0 },
  { "Fatouma", 0.0 },
  { "Fatoumata", 0.0 },
  { "Fatoumatta", 0.0 },
  { "Fattima", 0.0 },
  { "Fatu", 0.0 },
  { "Fatuma", 0.0 },
  { "Fatumata", 0.0 },
  { "Fatumo", 0.0 },
  { "Fatyma", 0.0 },
  { "Faun", 0.0 },
  { "Fauna", 0.0 },
  { "Faune", 0.0 },
  { "Fauniel", 0.0 },
  { "Faust", 1.0 },
  { "Fausta", 0.0 },
  { "Faustin", 1.0 },
  { "Faustina", 0.0 },
  { "Faustine", 0.0 },
  { "Faustino", 1.0 },
  { "Fausto", 1.0 },
  { "Fauzia", 0.0 },
  { "Faven", 0.0 },
  { "Favian", 1.0 },
  { "Faviana", 0.0 },
  { "Favio", 1.0 },
  { "Faviola", 0.0 },
  { "Favion", 1.0 },
  { "Favor", 0.17613636 },
  { "Favour", 0.10451978 },
  { "Fawad", 1.0 },
  { "Fawaz", 1.0 },
  { "Fawkes", 1.0 },
  { "Fawn", 0.0 },
  { "Fawna", 0.0 },
  { "Fawnda", 0.0 },
  { "Fawne", 0.0 },
  { "Fawnia", 0.0 },
  { "Fawnna", 0.0 },
  { "Fawwaz", 1.0 },
  { "Fawzan", 1.0 },
  { "Fawzi", 1.0 },
  { "Fawzia", 0.0 },
  { "Fay", 0.11488447 },
  { "Faya", 0.0 },
  { "Fayann", 0.0 },
  { "Fayaz", 1.0 },
  { "Faybian", 1.0 },
  { "Faydean", 0.0 },
  { "Faydell", 0.0 },
  { "Fayden", 1.0 },
  { "Faydene", 0.0 },
  { "Faydra", 0.0 },
  { "Faye", 0.0075943056 },
  { "Fayelyn", 0.0 },
  { "Fayelynn", 0.0 },
  { "Fayerene", 0.0 },
  { "Fayeth", 0.0 },
  { "Fayetta", 0.0 },
  { "Fayette", 0.43067846 },
  { "Fayez", 1.0 },
  { "Fayga", 0.0 },
  { "Fayha", 0.0 },
  { "Fayla", 0.0 },
  { "Faylee", 0.0 },
  { "Fayleen", 0.0 },
  { "Faylene", 0.0 },
  { "Faylin", 0.0 },
  { "Faylinn", 0.0 },
  { "Faylyn", 0.0 },
  { "Faylynn", 0.0 },
  { "Fayma", 0.0 },
  { "Fayne", 0.3529412 },
  { "Faynell", 0.0 },
  { "Fayola", 0.0 },
  { "Fayrene", 0.0 },
  { "Fayrouz", 0.0 },
  { "Faysal", 1.0 },
  { "Fayt", 1.0 },
  { "Fayte", 0.0 },
  { "Fayth", 0.0 },
  { "Faythe", 0.0 },
  { "Fayza", 0.0 },
  { "Fazal", 1.0 },
  { "Fazon", 1.0 },
  { "Fe", 0.0 },
  { "Feather", 0.0 },
  { "Febbie", 0.0 },
  { "Febe", 0.0 },
  { "Feben", 0.0 },
  { "Febie", 0.0 },
  { "Febra", 0.0 },
  { "Fed", 1.0 },
  { "Feda", 0.0 },
  { "Fedaa", 0.0 },
  { "Feddie", 0.0 },
  { "Fedel", 1.0 },
  { "Fedele", 1.0 },
  { "Fedelia", 0.0 },
  { "Fedelina", 0.0 },
  { "Federica", 0.0 },
  { "Federick", 1.0 },
  { "Federico", 0.999401 },
  { "Fedor", 1.0 },
  { "Fedora", 0.0 },
  { "Fedra", 0.0 },
  { "Fedrick", 1.0 },
  { "Feffrey", 1.0 },
  { "Feiga", 0.0 },
  { "Feige", 0.0 },
  { "Feigy", 0.0 },
  { "Feish", 1.0 },
  { "Fela", 0.12820514 },
  { "Felando", 1.0 },
  { "Felcia", 0.0 },
  { "Felder", 1.0 },
  { "Felechia", 0.0 },
  { "Felecia", 0.0 },
  { "Felecie", 0.0 },
  { "Felecity", 0.0 },
  { "Feleica", 0.0 },
  { "Feleicia", 0.0 },
  { "Feleisha", 0.0 },
  { "Felena", 0.0 },
  { "Felesha", 0.0 },
  { "Feleshia", 0.0 },
  { "Felesia", 0.0 },
  { "Feliberto", 1.0 },
  { "Felica", 0.0 },
  { "Felice", 0.14271027 },
  { "Felicea", 0.0 },
  { "Felicha", 0.0 },
  { "Felichia", 0.0 },
  { "Felicia", 0.0030643851 },
  { "Feliciana", 0.0 },
  { "Feliciano", 1.0 },
  { "Felicidad", 0.0 },
  { "Felicie", 0.0 },
  { "Felicita", 0.0 },
  { "Felicitas", 0.0 },
  { "Felicite", 0.0 },
  { "Feliciti", 0.0 },
  { "Felicity", 0.00051475636 },
  { "Feliks", 1.0 },
  { "Felimon", 1.0 },
  { "Felina", 0.0 },
  { "Felinda", 0.0 },
  { "Felipa", 0.0 },
  { "Felipe", 0.99549043 },
  { "Felipedejesus", 1.0 },
  { "Felipita", 0.0 },
  { "Felis", 0.59615386 },
  { "Felisa", 0.0 },
  { "Feliscia", 0.0 },
  { "Felise", 0.0 },
  { "Felisha", 0.0 },
  { "Felishia", 0.0 },
  { "Felisia", 0.0 },
  { "Felisiano", 1.0 },
  { "Felisita", 0.0 },
  { "Felisitas", 0.0 },
  { "Felisity", 0.0 },
  { "Felissa", 0.0 },
  { "Felissia", 0.0 },
  { "Felita", 0.0 },
  { "Felix", 0.9915717 },
  { "Feliz", 0.4334828 },
  { "Feliza", 0.0 },
  { "Felizardo", 1.0 },
  { "Felizia", 0.0 },
  { "Fellicia", 0.0 },
  { "Fellipe", 1.0 },
  { "Felma", 0.0 },
  { "Feloniz", 0.0 },
  { "Felton", 0.9992336 },
  { "Feltus", 1.0 },
  { "Felty", 1.0 },
  { "Felycia", 0.0 },
  { "Felyx", 1.0 },
  { "Female", 0.00385505 },
  { "Femi", 0.5294118 },
  { "Femke", 0.0 },
  { "Fender", 1.0 },
  { "Fendi", 0.0 },
  { "Fenet", 0.0 },
  { "Feng", 1.0 },
  { "Fenisha", 0.0 },
  { "Fenix", 0.77022654 },
  { "Fenley", 0.0 },
  { "Fenn", 1.0 },
  { "Fenna", 0.0 },
  { "Fennec", 1.0 },
  { "Fennell", 1.0 },
  { "Fenner", 1.0 },
  { "Fennie", 0.0 },
  { "Fenrir", 1.0 },
  { "Fenris", 1.0 },
  { "Fenton", 1.0 },
  { "Fentress", 1.0 },
  { "Fenway", 1.0 },
  { "Fenwick", 1.0 },
  { "Feodor", 1.0 },
  { "Feodora", 0.0 },
  { "Feona", 0.0 },
  { "Ferando", 1.0 },
  { "Feras", 1.0 },
  { "Ferd", 1.0 },
  { "Ferdie", 1.0 },
  { "Ferdinan", 1.0 },
  { "Ferdinand", 1.0 },
  { "Ferdinando", 1.0 },
  { "Ferdy", 1.0 },
  { "Ferdynand", 1.0 },
  { "Ferenc", 1.0 },
  { "Fergie", 0.0 },
  { "Fergus", 1.0 },
  { "Ferguson", 1.0 },
  { "Ferid", 1.0 },
  { "Feride", 0.0 },
  { "Ferin", 0.0 },
  { "Ferlando", 1.0 },
  { "Ferlin", 1.0 },
  { "Ferma", 0.0 },
  { "Ferman", 1.0 },
  { "Fermen", 1.0 },
  { "Fermin", 1.0 },
  { "Fermina", 0.0 },
  { "Fermon", 1.0 },
  { "Fern", 0.013768803 },
  { "Ferna", 0.0 },
  { "Fernado", 1.0 },
  { "Fernan", 1.0 },
  { "Fernand", 1.0 },
  { "Fernanda", 0.0017800904 },
  { "Fernande", 0.0 },
  { "Fernandeo", 1.0 },
  { "Fernandez", 1.0 },
  { "Fernando", 0.9938296 },
  { "Ferne", 0.0 },
  { "Fernell", 0.54545456 },
  { "Fernetta", 0.0 },
  { "Ferney", 1.0 },
  { "Fernie", 0.9690141 },
  { "Fernley", 1.0 },
  { "Ferol", 0.015923567 },
  { "Feroz", 1.0 },
  { "Ferra", 0.0 },
  { "Ferrah", 0.0 },
  { "Ferran", 0.5 },
  { "Ferrante", 1.0 },
  { "Ferrari", 0.13461539 },
  { "Ferras", 1.0 },
  { "Ferrel", 0.9448621 },
  { "Ferrell", 0.9218524 },
  { "Ferren", 0.0 },
  { "Ferrie", 0.0 },
  { "Ferril", 1.0 },
  { "Ferrill", 1.0 },
  { "Ferrin", 0.23076923 },
  { "Ferris", 0.9073189 },
  { "Ferrol", 0.4054054 },
  { "Ferron", 0.8938053 },
  { "Ferry", 0.85714287 },
  { "Ferryn", 0.0 },
  { "Feryal", 0.0 },
  { "Feryl", 0.0 },
  { "Fess", 1.0 },
  { "Fester", 1.0 },
  { "Festus", 1.0 },
  { "Fetina", 0.0 },
  { "Feven", 0.0 },
  { "Fey", 0.0 },
  { "Feyisayo", 0.0 },
  { "Feynman", 1.0 },
  { "Feysal", 1.0 },
  { "Feyza", 0.0 },
  { "Fher", 1.0 },
  { "Fhernando", 1.0 },
  { "Fia", 0.0 },
  { "Fiala", 0.0 },
  { "Fiama", 0.0 },
  { "Fiamma", 0.0 },
  { "Fiana", 0.0 },
  { "Fianna", 0.0 },
  { "Fibbie", 0.0 },
  { "Fidel", 1.0 },
  { "Fidela", 0.0 },
  { "Fidelia", 0.0 },
  { "Fidelina", 0.0 },
  { "Fidelio", 1.0 },
  { "Fidelis", 0.3006135 },
  { "Fidella", 0.0 },
  { "Fidelmar", 1.0 },
  { "Fidencia", 0.0 },
  { "Fidencio", 1.0 },
  { "Fidensio", 1.0 },
  { "Field", 1.0 },
  { "Fielden", 1.0 },
  { "Fielder", 1.0 },
  { "Fielding", 1.0 },
  { "Fieldon", 1.0 },
  { "Fields", 1.0 },
  { "Fiera", 0.0 },
  { "Fierra", 0.0 },
  { "Fiesta", 0.0 },
  { "Fiffany", 0.0 },
  { "Fifi", 0.0 },
  { "Fiifi", 1.0 },
  { "Fikir", 0.0 },
  { "Fikisha", 0.0 },
  { "Filadelfio", 1.0 },
  { "Filamena", 0.0 },
  { "Filbert", 1.0 },
  { "Filberto", 1.0 },
  { "Filemon", 1.0 },
  { "Filex", 1.0 },
  { "Fili", 1.0 },
  { "Filiberto", 1.0 },
  { "Filicia", 0.0 },
  { "Filicity", 0.0 },
  { "Filimon", 1.0 },
  { "Filip", 1.0 },
  { "Filipa", 0.0 },
  { "Filipe", 1.0 },
  { "Filippa", 0.0 },
  { "Filippo", 1.0 },
  { "Filippos", 1.0 },
  { "Filisha", 0.0 },
  { "Filiz", 0.0 },
  { "Fillip", 1.0 },
  { "Fillmore", 1.0 },
  { "Filmon", 1.0 },
  { "Filmore", 1.0 },
  { "Filomena", 0.0 },
  { "Filomeno", 1.0 },
  { "Filomina", 0.0 },
  { "Filsan", 0.0 },
  { "Filza", 0.0 },
  { "Fin", 1.0 },
  { "Fina", 0.0 },
  { "Finas", 1.0 },
  { "Finau", 0.54545456 },
  { "Finbar", 1.0 },
  { "Finbarr", 1.0 },
  { "Finch", 1.0 },
  { "Findlay", 0.863388 },
  { "Findley", 0.7167382 },
  { "Fineas", 1.0 },
  { "Finely", 0.0 },
  { "Fines", 1.0 },
  { "Finessa", 0.0 },
  { "Finesse", 0.08018868 },
  { "Finest", 1.0 },
  { "Finian", 1.0 },
  { "Finis", 0.9977273 },
  { "Finland", 1.0 },
  { "Finlay", 0.83074933 },
  { "Finlea", 0.0 },
  { "Finlee", 0.104477614 },
  { "Finleigh", 0.0 },
  { "Finley", 0.44458798 },
  { "Finly", 1.0 },
  { "Finn", 0.9849169 },
  { "Finna", 0.0 },
  { "Finnan", 1.0 },
  { "Finnbar", 1.0 },
  { "Finnean", 1.0 },
  { "Finneas", 1.0 },
  { "Finnegan", 0.9932976 },
  { "Finneus", 1.0 },
  { "Finnian", 1.0 },
  { "Finnick", 1.0 },
  { "Finnie", 0.8333333 },
  { "Finnigan", 1.0 },
  { "Finnis", 1.0 },
  { "Finnlay", 1.0 },
  { "Finnlee", 0.5591398 },
  { "Finnleigh", 0.0 },
  { "Finnley", 0.6434136 },
  { "Finnly", 0.67391306 },
  { "Finola", 0.0 },
  { "Fintan", 1.0 },
  { "Finton", 1.0 },
  { "Finus", 1.0 },
  { "Fion", 0.0 },
  { "Fiona", 0.0002055414 },
  { "Fionn", 1.0 },
  { "Fionna", 0.0 },
  { "Fionnlagh", 1.0 },
  { "Fionnuala", 0.0 },
  { "Fionnula", 0.0 },
  { "Fiora", 0.0 },
  { "Fiore", 0.97689074 },
  { "Fiorela", 0.0 },
  { "Fiorella", 0.0 },
  { "Fiorenza", 0.0 },
  { "Fiori", 0.3529412 },
  { "Fira", 0.0 },
  { "Firas", 1.0 },
  { "Firdaus", 0.0 },
  { "Firdavs", 1.0 },
  { "Firdaws", 0.0 },
  { "Firdous", 0.0 },
  { "Firman", 1.0 },
  { "Firmin", 1.0 },
  { "Firyal", 0.0 },
  { "Fischer", 0.99448276 },
  { "Fishel", 1.0 },
  { "Fisher", 0.9946065 },
  { "Fisnik", 1.0 },
  { "Fitima", 0.0 },
  { "Fitz", 1.0 },
  { "Fitzgerald", 1.0 },
  { "Fitzhugh", 1.0 },
  { "Fitzpatrick", 1.0 },
  { "Fitzroy", 1.0 },
  { "Fitzwilliam", 1.0 },
  { "Fiyinfoluwa", 0.31578946 },
  { "Fiza", 0.0 },
  { "Fizza", 0.0 },
  { "Fjolla", 0.0 },
  { "Flabio", 1.0 },
  { "Flake", 1.0 },
  { "Flame", 0.0 },
  { "Flamur", 1.0 },
  { "Flannery", 0.0 },
  { "Flara", 0.0 },
  { "Flarence", 0.0 },
  { "Flarrie", 0.0 },
  { "Flash", 1.0 },
  { "Flaura", 0.0 },
  { "Flava", 0.0 },
  { "Flavel", 1.0 },
  { "Flavia", 0.0 },
  { "Flavian", 1.0 },
  { "Flavil", 1.0 },
  { "Flavio", 1.0 },
  { "Flavious", 1.0 },
  { "Flavis", 1.0 },
  { "Flavius", 1.0 },
  { "Flay", 0.9411765 },
  { "Flechia", 0.0 },
  { "Flecia", 0.0 },
  { "Fleda", 0.0 },
  { "Fleet", 1.0 },
  { "Fleeta", 0.0 },
  { "Fleetwood", 1.0 },
  { "Flem", 1.0 },
  { "Fleming", 1.0 },
  { "Flemmie", 0.0 },
  { "Flemming", 1.0 },
  { "Flemon", 1.0 },
  { "Flerida", 0.0 },
  { "Flesha", 0.0 },
  { "Fleshia", 0.0 },
  { "Fleta", 0.0 },
  { "Fletcher", 0.9905297 },
  { "Fleur", 0.0 },
  { "Fleurette", 0.0 },
  { "Flex", 1.0 },
  { "Flicia", 0.0 },
  { "Flint", 1.0 },
  { "Flip", 1.0 },
  { "Flo", 0.0 },
  { "Floda", 0.0 },
  { "Flodie", 0.0 },
  { "Floe", 0.0 },
  { "Floella", 0.0 },
  { "Floetta", 0.0 },
  { "Floice", 0.0 },
  { "Floid", 1.0 },
  { "Floie", 0.0 },
  { "Flois", 0.0 },
  { "Flona", 0.0 },
  { "Flonnie", 0.0 },
  { "Flor", 0.013372093 },
  { "Flora", 0.0025343313 },
  { "Florabel", 0.0 },
  { "Florabell", 0.0 },
  { "Florabelle", 0.0 },
  { "Floraida", 0.0 },
  { "Floraine", 0.0 },
  { "Floral", 0.0 },
  { "Floralee", 0.0 },
  { "Floramae", 0.0 },
  { "Floran", 1.0 },
  { "Florance", 0.0 },
  { "Florann", 0.0 },
  { "Floranne", 0.0 },
  { "Florastine", 0.0 },
  { "Flord", 1.0 },
  { "Flordemaria", 0.0 },
  { "Flordia", 0.0 },
  { "Flore", 0.0 },
  { "Florean", 0.0 },
  { "Florece", 0.0 },
  { "Florecita", 0.0 },
  { "Floreda", 0.0 },
  { "Floree", 0.0 },
  { "Floreen", 0.0 },
  { "Floreine", 0.0 },
  { "Florella", 0.0 },
  { "Floren", 1.0 },
  { "Florena", 0.0 },
  { "Florence", 0.0042722463 },
  { "Florencia", 0.0 },
  { "Florencio", 1.0 },
  { "Florenda", 0.0 },
  { "Florene", 0.0 },
  { "Florent", 1.0 },
  { "Florentina", 0.0 },
  { "Florentine", 0.017699115 },
  { "Florentino", 1.0 },
  { "Florenz", 0.71875 },
  { "Florenzo", 1.0 },
  { "Flores", 0.6333333 },
  { "Floresita", 0.0 },
  { "Florestela", 0.0 },
  { "Florestine", 0.0 },
  { "Floreta", 0.0 },
  { "Floretha", 0.0 },
  { "Floretta", 0.0 },
  { "Florette", 0.0 },
  { "Flori", 0.0 },
  { "Floria", 0.0 },
  { "Florian", 0.9842362 },
  { "Floriana", 0.0 },
  { "Floribel", 0.0 },
  { "Floriberto", 1.0 },
  { "Florice", 0.0 },
  { "Florida", 0.0014156286 },
  { "Floridalma", 0.0 },
  { "Floride", 0.0 },
  { "Florie", 0.0 },
  { "Florien", 0.0 },
  { "Floriene", 0.0 },
  { "Florin", 1.0 },
  { "Florina", 0.0 },
  { "Florince", 0.0 },
  { "Florinda", 0.0 },
  { "Florindo", 1.0 },
  { "Florine", 0.00044412861 },
  { "Florio", 1.0 },
  { "Floris", 0.031837918 },
  { "Florisa", 0.0 },
  { "Florisel", 0.0 },
  { "Florita", 0.0 },
  { "Flormaria", 0.0 },
  { "Flornce", 0.0 },
  { "Florrie", 0.0 },
  { "Florrine", 0.0 },
  { "Flory", 0.6458333 },
  { "Floryan", 1.0 },
  { "Flosie", 0.0 },
  { "Floss", 0.0 },
  { "Flossie", 0.0016949152 },
  { "Flossy", 0.0 },
  { "Flourish", 0.0 },
  { "Flournoy", 1.0 },
  { "Flower", 0.0 },
  { "Floy", 0.046582058 },
  { "Floya", 0.0 },
  { "Floyce", 0.02268431 },
  { "Floyd", 0.9911194 },
  { "Floyda", 0.0 },
  { "Floyde", 1.0 },
  { "Floydell", 0.0 },
  { "Floydene", 0.0 },
  { "Floydia", 0.0 },
  { "Floye", 0.0 },
  { "Floyed", 1.0 },
  { "Flozell", 1.0 },
  { "Flynn", 0.91861963 },
  { "Flynt", 1.0 },
  { "Foch", 1.0 },
  { "Foday", 1.0 },
  { "Fode", 1.0 },
  { "Foister", 1.0 },
  { "Fola", 0.0 },
  { "Folami", 0.0 },
  { "Folarin", 1.0 },
  { "Folasade", 0.0 },
  { "Folashade", 0.0 },
  { "Foley", 1.0 },
  { "Folia", 0.0 },
  { "Folke", 1.0 },
  { "Foluke", 0.0 },
  { "Fon", 1.0 },
  { "Fonda", 0.0 },
  { "Fong", 0.9836601 },
  { "Fonisha", 0.0 },
  { "Fonnie", 0.20967741 },
  { "Fonta", 0.47826087 },
  { "Fontaine", 0.58484846 },
  { "Fontana", 0.0 },
  { "Fontane", 1.0 },
  { "Fontella", 0.0 },
  { "Fontelle", 0.0 },
  { "Fontilla", 0.0 },
  { "Fonza", 1.0 },
  { "Fonzie", 1.0 },
  { "Fonzo", 1.0 },
  { "Forace", 1.0 },
  { "Foram", 0.0 },
  { "Forbes", 1.0 },
  { "Forbus", 1.0 },
  { "Ford", 0.99917066 },
  { "Forde", 1.0 },
  { "Fordham", 1.0 },
  { "Fordie", 0.0 },
  { "Fordyce", 1.0 },
  { "Forest", 0.97037756 },
  { "Forester", 1.0 },
  { "Forestine", 0.0 },
  { "Forestt", 1.0 },
  { "Forever", 0.037037037 },
  { "Forman", 1.0 },
  { "Formeka", 0.0 },
  { "Forney", 1.0 },
  { "Forrest", 0.98032016 },
  { "Forrester", 1.0 },
  { "Forrestine", 0.0 },
  { "Forrestt", 1.0 },
  { "Forris", 1.0 },
  { "Forster", 1.0 },
  { "Fort", 1.0 },
  { "Fortino", 1.0 },
  { "Fortuna", 0.0 },
  { "Fortunata", 0.0 },
  { "Fortunate", 0.0 },
  { "Fortunato", 1.0 },
  { "Fortune", 0.374269 },
  { "Forum", 0.0 },
  { "Fosteen", 0.0 },
  { "Foster", 0.9885405 },
  { "Fostina", 0.0 },
  { "Fostine", 0.0 },
  { "Fotima", 0.0 },
  { "Fotini", 0.0 },
  { "Fotios", 1.0 },
  { "Fotis", 1.0 },
  { "Foua", 0.0 },
  { "Fouad", 1.0 },
  { "Fount", 1.0 },
  { "Fountain", 1.0 },
  { "Fouzia", 0.0 },
  { "Fowler", 1.0 },
  { "Fox", 0.98655915 },
  { "Foxx", 1.0 },
  { "Foxy", 0.0 },
  { "Foy", 0.83379394 },
  { "Foye", 0.31903484 },
  { "Foyster", 1.0 },
  { "Fozie", 0.0 },
  { "Fraak", 1.0 },
  { "Fraces", 0.0 },
  { "Fracine", 0.0 },
  { "Fracisco", 1.0 },
  { "Fradel", 0.0 },
  { "Frady", 0.0 },
  { "Frager", 1.0 },
  { "Fraida", 0.0 },
  { "Fraidel", 0.0 },
  { "Fraidy", 0.0 },
  { "Frak", 1.0 },
  { "Frampton", 1.0 },
  { "Fran", 0.06772983 },
  { "Franc", 0.61538464 },
  { "Franca", 0.0 },
  { "Franccesca", 0.0 },
  { "France", 0.24428478 },
  { "Francee", 0.0 },
  { "Franceen", 0.0 },
  { "Francel", 0.0 },
  { "Francelia", 0.0 },
  { "Francelina", 0.0 },
  { "Francell", 0.33333334 },
  { "Francella", 0.0 },
  { "Francelle", 0.0 },
  { "Francellia", 0.0 },
  { "Francely", 0.0 },
  { "Francena", 0.0 },
  { "Francene", 0.0 },
  { "Francenia", 0.0 },
  { "Frances", 0.008383074 },
  { "Francesa", 0.0 },
  { "Francesc", 0.3448276 },
  { "Francesca", 0.0011698394 },
  { "Francesco", 1.0 },
  { "Francese", 0.0 },
  { "Franceska", 0.0 },
  { "Francess", 0.0 },
  { "Francessca", 0.0 },
  { "Francetta", 0.0 },
  { "Francey", 0.0 },
  { "Franchell", 0.0 },
  { "Franchelle", 0.0 },
  { "Franchesca", 0.0 },
  { "Franchesco", 1.0 },
  { "Francheska", 0.0 },
  { "Franchessca", 0.0 },
  { "Franchesska", 0.0 },
  { "Franchester", 0.0 },
  { "Franchetta", 0.0 },
  { "Franchette", 0.0 },
  { "Franchezca", 0.0 },
  { "Franchon", 0.0 },
  { "Franchot", 1.0 },
  { "Franci", 0.0 },
  { "Francia", 0.0 },
  { "Francico", 1.0 },
  { "Francie", 0.0032661948 },
  { "Franciene", 0.0 },
  { "Francies", 0.013471503 },
  { "Francile", 0.0 },
  { "Francille", 0.0 },
  { "Francina", 0.0 },
  { "Francine", 0.00030762347 },
  { "Francis", 0.9073856 },
  { "Francisc", 1.0 },
  { "Francisca", 0.0050123255 },
  { "Francisco", 0.9927938 },
  { "Franciscojavier", 1.0 },
  { "Franciscojr", 1.0 },
  { "Franciscus", 1.0 },
  { "Francise", 0.0 },
  { "Franciska", 0.0 },
  { "Franciso", 1.0 },
  { "Francisquita", 0.0 },
  { "Franciszek", 1.0 },
  { "Franciszka", 0.0 },
  { "Francita", 0.0 },
  { "Franck", 1.0 },
  { "Franclin", 1.0 },
  { "Franco", 1.0 },
  { "Francois", 0.99702734 },
  { "Francoise", 0.0 },
  { "Francsico", 1.0 },
  { "Francy", 0.0 },
  { "Francyne", 0.0 },
  { "Francys", 0.0 },
  { "Franda", 0.0 },
  { "Frandy", 1.0 },
  { "Franes", 0.0 },
  { "Franey", 0.0 },
  { "Frani", 0.0 },
  { "Frania", 0.0 },
  { "Franics", 1.0 },
  { "Franis", 1.0 },
  { "Franisco", 1.0 },
  { "Frank", 0.99495643 },
  { "Franka", 0.0 },
  { "Franke", 1.0 },
  { "Frankee", 0.0 },
  { "Frankel", 1.0 },
  { "Frankey", 0.9652778 },
  { "Franki", 0.073737375 },
  { "Frankie", 0.5505101 },
  { "Frankin", 1.0 },
  { "Franklen", 1.0 },
  { "Franklin", 0.9947716 },
  { "Frankline", 1.0 },
  { "Frankly", 1.0 },
  { "Franklyn", 0.9966119 },
  { "Franklynn", 0.0 },
  { "Franko", 1.0 },
  { "Franky", 0.9839858 },
  { "Frankye", 0.022058824 },
  { "Frann", 0.0 },
  { "Franne", 0.0 },
  { "Frannie", 0.0 },
  { "Franny", 0.0 },
  { "Frans", 1.0 },
  { "Franshesca", 0.0 },
  { "Fransheska", 0.0 },
  { "Fransica", 0.0 },
  { "Fransico", 1.0 },
  { "Fransisca", 0.0 },
  { "Fransisco", 1.0 },
  { "Frantasia", 0.0 },
  { "Frantisek", 1.0 },
  { "Frantz", 1.0 },
  { "Frantzy", 1.0 },
  { "Franyelis", 0.0 },
  { "Franz", 1.0 },
  { "Franzetta", 0.0 },
  { "Franziska", 0.0 },
  { "Fraser", 1.0 },
  { "Frasier", 1.0 },
  { "Fray", 1.0 },
  { "Fraya", 0.0 },
  { "Frayah", 0.0 },
  { "Frayda", 0.0 },
  { "Frazer", 1.0 },
  { "Frazier", 1.0 },
  { "Fread", 1.0 },
  { "Freada", 0.0 },
  { "Fred", 0.9941154 },
  { "Freda", 0.00061291846 },
  { "Fredarius", 1.0 },
  { "Fredasia", 0.0 },
  { "Fredda", 0.0 },
  { "Fredderick", 1.0 },
  { "Freddi", 0.5263158 },
  { "Freddia", 0.0 },
  { "Freddick", 1.0 },
  { "Freddie", 0.8761916 },
  { "Freddrick", 1.0 },
  { "Freddy", 0.9932891 },
  { "Freddye", 0.0 },
  { "Fredeline", 0.0 },
  { "Frederi", 1.0 },
  { "Frederic", 1.0 },
  { "Frederica", 0.0 },
  { "Frederich", 1.0 },
  { "Frederick", 0.99577266 },
  { "Fredericka", 0.0 },
  { "Frederico", 1.0 },
  { "Frederik", 1.0 },
  { "Frederika", 0.0 },
  { "Frederique", 0.0 },
  { "Fredi", 0.90611356 },
  { "Fredia", 0.0 },
  { "Fredick", 1.0 },
  { "Fredie", 0.96745324 },
  { "Fredina", 0.0 },
  { "Fredine", 0.0 },
  { "Fredirick", 1.0 },
  { "Fredis", 1.0 },
  { "Fredith", 0.0 },
  { "Fredlyn", 0.0 },
  { "Fredna", 0.0 },
  { "Fredo", 1.0 },
  { "Fredonia", 0.0 },
  { "Fredreck", 1.0 },
  { "Fredreick", 1.0 },
  { "Fredreka", 0.0 },
  { "Fredric", 1.0 },
  { "Fredrica", 0.0 },
  { "Fredrich", 1.0 },
  { "Fredrick", 0.99593335 },
  { "Fredricka", 0.0 },
  { "Fredricks", 1.0 },
  { "Fredrico", 1.0 },
  { "Fredrik", 1.0 },
  { "Fredrika", 0.0 },
  { "Fredy", 1.0 },
  { "Fredys", 1.0 },
  { "Free", 0.47916666 },
  { "Freeda", 0.0 },
  { "Freedia", 0.0 },
  { "Freedom", 0.34763408 },
  { "Freeland", 1.0 },
  { "Freelin", 1.0 },
  { "Freelon", 1.0 },
  { "Freeman", 0.9995322 },
  { "Freemon", 1.0 },
  { "Freemont", 1.0 },
  { "Freesia", 0.0 },
  { "Freida", 0.0 },
  { "Freidy", 0.0 },
  { "Freja", 0.0 },
  { "Freland", 1.0 },
  { "Freman", 1.0 },
  { "Fremon", 1.0 },
  { "Fremont", 1.0 },
  { "French", 0.99114263 },
  { "Frenchie", 0.18888889 },
  { "Frenda", 0.0 },
  { "Frenesi", 0.0 },
  { "Freta", 0.0 },
  { "Frey", 1.0 },
  { "Freya", 0.0 },
  { "Freyah", 0.0 },
  { "Freyda", 0.0 },
  { "Freyja", 0.0 },
  { "Freylin", 1.0 },
  { "Frezell", 1.0 },
  { "Frica", 0.0 },
  { "Frida", 0.0 },
  { "Friday", 0.0 },
  { "Fridda", 0.0 },
  { "Friddie", 1.0 },
  { "Frieda", 0.0 },
  { "Friedrich", 1.0 },
  { "Friel", 1.0 },
  { "Friend", 1.0 },
  { "Frika", 0.0 },
  { "Frimet", 0.0 },
  { "Frimmy", 0.0 },
  { "Frimy", 0.0 },
  { "Frink", 1.0 },
  { "Frisco", 1.0 },
  { "Frita", 0.0 },
  { "Fritha", 0.0 },
  { "Fritz", 1.0 },
  { "Fritzgerald", 1.0 },
  { "Fritzi", 0.0 },
  { "Fritzie", 0.0 },
  { "Fritzy", 0.0 },
  { "Frizell", 1.0 },
  { "Froilan", 1.0 },
  { "Frona", 0.0 },
  { "Froney", 0.0 },
  { "Fronia", 0.0 },
  { "Fronie", 0.0 },
  { "Fronnie", 0.0 },
  { "Frontis", 1.0 },
  { "Frost", 1.0 },
  { "Frosty", 1.0 },
  { "Froy", 1.0 },
  { "Froylan", 1.0 },
  { "Frozine", 0.0 },
  { "Fruma", 0.0 },
  { "Frumencio", 1.0 },
  { "Frumie", 0.0 },
  { "Frutoso", 1.0 },
  { "Fryda", 0.0 },
  { "Fu", 1.0 },
  { "Fuad", 1.0 },
  { "Fue", 1.0 },
  { "Fujie", 0.0 },
  { "Fujiko", 0.0 },
  { "Fujio", 1.0 },
  { "Fujiye", 0.0 },
  { "Fuka", 0.0 },
  { "Fukuichi", 1.0 },
  { "Fulgencio", 1.0 },
  { "Fuller", 1.0 },
  { "Fulton", 1.0 },
  { "Fulvio", 1.0 },
  { "Fumi", 0.0 },
  { "Fumie", 0.0 },
  { "Fumiko", 0.0 },
  { "Fumio", 1.0 },
  { "Fumiye", 0.0 },
  { "Fumiyo", 0.0 },
  { "Funda", 0.0 },
  { "Funmilayo", 0.0 },
  { "Funston", 1.0 },
  { "Fuquan", 1.0 },
  { "Furaha", 0.0 },
  { "Furiosa", 0.0 },
  { "Furious", 1.0 },
  { "Furkan", 1.0 },
  { "Furlon", 1.0 },
  { "Furman", 1.0 },
  { "Furnell", 1.0 },
  { "Furney", 1.0 },
  { "Furqan", 1.0 },
  { "Fury", 0.0 },
  { "Fusae", 0.0 },
  { "Fusako", 0.0 },
  { "Fusaye", 0.0 },
  { "Fushia", 0.0 },
  { "Future", 0.77037036 },
  { "Fuzail", 1.0 },
  { "Fynlee", 0.0 },
  { "Fynleigh", 0.0 },
  { "Fynley", 0.0 },
  { "Fynlie", 0.0 },
  { "Fynn", 0.9303226 },
  { "Fynnegan", 1.0 },
  { "Fynnigan", 1.0 },
  { "Fynnlee", 0.0 },
  { "Fynnleigh", 0.0 },
  { "Fynnley", 0.1875 },
  { "Fyodor", 1.0 },
  { "Fyrn", 0.0 },
  { "Fysher", 1.0 },
  { "Gaal", 0.0 },
  { "Gabbanelli", 0.0 },
  { "Gabbi", 0.0 },
  { "Gabbie", 0.0 },
  { "Gabbriel", 0.0 },
  { "Gabbriella", 0.0 },
  { "Gabbrielle", 0.0 },
  { "Gabby", 0.020915033 },
  { "Gabe", 1.0 },
  { "Gabel", 1.0 },
  { "Gaber", 1.0 },
  { "Gaberial", 0.96460176 },
  { "Gaberiel", 1.0 },
  { "Gaberielle", 0.0 },
  { "Gaberille", 0.0 },
  { "Gabi", 0.0 },
  { "Gabie", 0.0 },
  { "Gabiel", 1.0 },
  { "Gabiela", 0.0 },
  { "Gabija", 0.0 },
  { "Gabin", 1.0 },
  { "Gabina", 0.0 },
  { "Gabino", 1.0 },
  { "Gabirel", 1.0 },
  { "Gabirelle", 0.0 },
  { "Gable", 0.9912537 },
  { "Gabor", 1.0 },
  { "Gabrael", 1.0 },
  { "Gabrail", 1.0 },
  { "Gabreal", 0.77717394 },
  { "Gabreella", 0.0 },
  { "Gabreial", 0.0 },
  { "Gabreil", 0.9126984 },
  { "Gabreilla", 0.0 },
  { "Gabreille", 0.0 },
  { "Gabrel", 1.0 },
  { "Gabrella", 0.0 },
  { "Gabrelle", 0.0 },
  { "Gabria", 0.0 },
  { "Gabrial", 0.8557377 },
  { "Gabriala", 0.0 },
  { "Gabrialla", 0.0 },
  { "Gabrialle", 0.0 },
  { "Gabrian", 1.0 },
  { "Gabriana", 0.0 },
  { "Gabrianna", 0.0 },
  { "Gabrieal", 0.53846157 },
  { "Gabriel", 0.9801806 },
  { "Gabriela", 0.0047777076 },
  { "Gabrielah", 0.0 },
  { "Gabrielalexande", 1.0 },
  { "Gabrielangelo", 1.0 },
  { "Gabriele", 0.27101448 },
  { "Gabrieljohn", 1.0 },
  { "Gabriell", 0.21985383 },
  { "Gabriella", 0.00062225474 },
  { "Gabriellah", 0.0 },
  { "Gabriellamarie", 0.0 },
  { "Gabrielle", 0.005533161 },
  { "Gabriellia", 0.0 },
  { "Gabrielly", 0.0 },
  { "Gabrielmichael", 1.0 },
  { "Gabriely", 0.0 },
  { "Gabrien", 1.0 },
  { "Gabril", 1.0 },
  { "Gabrille", 0.0 },
  { "Gabrionna", 0.0 },
  { "Gabriyel", 0.45833334 },
  { "Gabryal", 1.0 },
  { "Gabryel", 0.664825 },
  { "Gabryela", 0.0 },
  { "Gabryele", 0.0 },
  { "Gabryell", 0.0 },
  { "Gabryella", 0.0 },
  { "Gabryelle", 0.0 },
  { "Gabryl", 1.0 },
  { "Gabryle", 1.0 },
  { "Gabrylle", 0.0 },
  { "Gaby", 0.022589052 },
  { "Gad", 1.0 },
  { "Gaddiel", 1.0 },
  { "Gaddis", 1.0 },
  { "Gadeer", 0.0 },
  { "Gadge", 1.0 },
  { "Gadi", 1.0 },
  { "Gadiel", 1.0 },
  { "Gadriel", 1.0 },
  { "Gadsden", 1.0 },
  { "Gae", 0.0 },
  { "Gaea", 0.0 },
  { "Gaebriel", 1.0 },
  { "Gaege", 1.0 },
  { "Gael", 0.9700557 },
  { "Gaela", 0.0 },
  { "Gaelan", 1.0 },
  { "Gaelen", 0.8965517 },
  { "Gaell", 1.0 },
  { "Gaelle", 0.0 },
  { "Gaely", 0.0 },
  { "Gaelyn", 0.0 },
  { "Gaetan", 1.0 },
  { "Gaetana", 0.0 },
  { "Gaetano", 1.0 },
  { "Gaeton", 1.0 },
  { "Gagan", 0.875 },
  { "Gagandeep", 0.7206704 },
  { "Gage", 0.99595267 },
  { "Gagik", 1.0 },
  { "Gahan", 1.0 },
  { "Gahel", 1.0 },
  { "Gai", 0.0 },
  { "Gaia", 0.0 },
  { "Gaibriel", 1.0 },
  { "Gaiden", 1.0 },
  { "Gaige", 0.9728453 },
  { "Gaije", 1.0 },
  { "Gail", 0.04251469 },
  { "Gaila", 0.0 },
  { "Gailand", 1.0 },
  { "Gailann", 0.0 },
  { "Gailanne", 0.0 },
  { "Gailard", 1.0 },
  { "Gaile", 0.0055370987 },
  { "Gaileen", 0.0 },
  { "Gailen", 0.9765625 },
  { "Gailene", 0.0 },
  { "Gaillard", 1.0 },
  { "Gailon", 1.0 },
  { "Gailord", 1.0 },
  { "Gailya", 0.0 },
  { "Gailyn", 0.0 },
  { "Gailynn", 0.0 },
  { "Gaines", 1.0 },
  { "Gains", 1.0 },
  { "Gaither", 0.9907407 },
  { "Gaitlin", 0.0 },
  { "Gaius", 1.0 },
  { "Gaje", 1.0 },
  { "Gajuan", 1.0 },
  { "Gal", 0.48135594 },
  { "Gala", 0.0 },
  { "Galadriel", 0.0 },
  { "Galan", 1.0 },
  { "Galatea", 0.0 },
  { "Galathia", 0.0 },
  { "Galatia", 0.0 },
  { "Galaxie", 0.0 },
  { "Galaxy", 0.06451613 },
  { "Galdino", 1.0 },
  { "Gale", 0.38311931 },
  { "Galen", 0.9663502 },
  { "Galena", 0.0 },
  { "Galene", 0.0 },
  { "Gali", 0.0 },
  { "Galia", 0.0 },
  { "Galiana", 0.0 },
  { "Galicia", 0.0 },
  { "Galilea", 0.0 },
  { "Galileah", 0.0 },
  { "Galilee", 0.0 },
  { "Galileo", 1.0 },
  { "Galin", 1.0 },
  { "Galina", 0.0 },
  { "Galinda", 0.0 },
  { "Galisa", 0.0 },
  { "Galit", 0.0 },
  { "Galiyah", 0.0 },
  { "Gallagher", 1.0 },
  { "Gallie", 0.0 },
  { "Galloway", 1.0 },
  { "Galo", 1.0 },
  { "Galon", 1.0 },
  { "Galvester", 1.0 },
  { "Galveston", 1.0 },
  { "Galvin", 1.0 },
  { "Galya", 0.0 },
  { "Galylea", 0.0 },
  { "Galyn", 0.41573033 },
  { "Galynn", 0.0 },
  { "Gamal", 1.0 },
  { "Gamaliel", 1.0 },
  { "Gamalier", 1.0 },
  { "Gamari", 1.0 },
  { "Gambit", 1.0 },
  { "Gamble", 0.94382024 },
  { "Gamel", 1.0 },
  { "Games", 1.0 },
  { "Gamila", 0.0 },
  { "Gamir", 1.0 },
  { "Gamya", 0.0 },
  { "Gana", 0.0 },
  { "Ganae", 0.0 },
  { "Ganajah", 0.0 },
  { "Gandalf", 1.0 },
  { "Gandolfo", 1.0 },
  { "Ganell", 0.0 },
  { "Ganelle", 0.0 },
  { "Ganesa", 0.0 },
  { "Ganesh", 1.0 },
  { "Ganessa", 0.0 },
  { "Gani", 1.0 },
  { "Gania", 0.0 },
  { "Ganiya", 0.0 },
  { "Ganiyah", 0.0 },
  { "Ganna", 0.0 },
  { "Gannen", 1.0 },
  { "Gannicus", 1.0 },
  { "Gannon", 1.0 },
  { "Gannyn", 1.0 },
  { "Gano", 1.0 },
  { "Ganon", 1.0 },
  { "Gant", 1.0 },
  { "Gantt", 1.0 },
  { "Ganyn", 1.0 },
  { "Ganza", 1.0 },
  { "Gao", 0.0 },
  { "Gaolee", 0.0 },
  { "Gaonou", 0.0 },
  { "Gaosheng", 0.0 },
  { "Gaoussou", 1.0 },
  { "Gaozong", 0.0 },
  { "Gaquan", 1.0 },
  { "Gar", 1.0 },
  { "Gara", 0.0 },
  { "Garak", 1.0 },
  { "Garald", 1.0 },
  { "Garan", 1.0 },
  { "Garang", 1.0 },
  { "Garbiel", 1.0 },
  { "Garbielle", 0.0 },
  { "Garbriel", 1.0 },
  { "Garbrielle", 0.0 },
  { "Garcelle", 0.0 },
  { "Garcia", 0.92156863 },
  { "Gard", 1.0 },
  { "Garda", 0.0 },
  { "Gardell", 1.0 },
  { "Garden", 1.0 },
  { "Gardenia", 0.0 },
  { "Gardina", 0.0 },
  { "Gardiner", 1.0 },
  { "Gardner", 0.9982651 },
  { "Gardy", 1.0 },
  { "Gared", 1.0 },
  { "Garek", 1.0 },
  { "Gareld", 1.0 },
  { "Garen", 0.98851675 },
  { "Garet", 1.0 },
  { "Gareth", 0.99871397 },
  { "Garett", 1.0 },
  { "Garette", 1.0 },
  { "Garey", 1.0 },
  { "Garfield", 1.0 },
  { "Gargi", 0.0 },
  { "Garhett", 1.0 },
  { "Gari", 0.23981191 },
  { "Garian", 1.0 },
  { "Garic", 1.0 },
  { "Garick", 1.0 },
  { "Garie", 0.22727273 },
  { "Gariel", 0.75 },
  { "Gariella", 0.0 },
  { "Garielle", 0.0 },
  { "Garik", 1.0 },
  { "Garima", 0.0 },
  { "Garin", 1.0 },
  { "Garine", 0.0 },
  { "Garion", 1.0 },
  { "Garison", 1.0 },
  { "Garit", 1.0 },
  { "Garitt", 1.0 },
  { "Garius", 1.0 },
  { "Garl", 1.0 },
  { "Garla", 0.0 },
  { "Garlan", 1.0 },
  { "Garland", 0.9661259 },
  { "Garlen", 1.0 },
  { "Garlene", 0.0 },
  { "Garlin", 1.0 },
  { "Garlon", 1.0 },
  { "Garlond", 1.0 },
  { "Garlund", 1.0 },
  { "Garlyn", 0.6875 },
  { "Garman", 1.0 },
  { "Garmon", 1.0 },
  { "Garn", 1.0 },
  { "Garna", 0.0 },
  { "Garnel", 1.0 },
  { "Garnell", 0.8039604 },
  { "Garnelle", 0.0 },
  { "Garner", 0.9891714 },
  { "Garnet", 0.22301994 },
  { "Garneta", 0.0 },
  { "Garnett", 0.5782457 },
  { "Garnetta", 0.0 },
  { "Garnette", 0.0 },
  { "Garney", 1.0 },
  { "Garnie", 0.84615386 },
  { "Garnieta", 0.0 },
  { "Garnita", 0.0 },
  { "Garo", 1.0 },
  { "Garold", 1.0 },
  { "Garon", 1.0 },
  { "Garr", 1.0 },
  { "Garrad", 1.0 },
  { "Garran", 1.0 },
  { "Garrard", 1.0 },
  { "Garratt", 1.0 },
  { "Garred", 1.0 },
  { "Garrek", 1.0 },
  { "Garrel", 1.0 },
  { "Garrell", 1.0 },
  { "Garren", 0.9903134 },
  { "Garret", 0.9996153 },
  { "Garreth", 1.0 },
  { "Garrett", 0.9965001 },
  { "Garrette", 1.0 },
  { "Garrey", 1.0 },
  { "Garrhett", 1.0 },
  { "Garri", 0.0 },
  { "Garric", 1.0 },
  { "Garrick", 1.0 },
  { "Garrie", 0.82168674 },
  { "Garrik", 1.0 },
  { "Garrin", 1.0 },
  { "Garrion", 1.0 },
  { "Garris", 1.0 },
  { "Garrison", 0.99931574 },
  { "Garrit", 1.0 },
  { "Garritt", 1.0 },
  { "Garrod", 1.0 },
  { "Garron", 1.0 },
  { "Garrus", 1.0 },
  { "Garry", 0.9962429 },
  { "Garryn", 0.0 },
  { "Garson", 1.0 },
  { "Garth", 1.0 },
  { "Gartha", 0.0 },
  { "Gartrell", 1.0 },
  { "Garv", 1.0 },
  { "Garvens", 1.0 },
  { "Garvey", 1.0 },
  { "Garvice", 1.0 },
  { "Garvie", 1.0 },
  { "Garvin", 1.0 },
  { "Garvis", 1.0 },
  { "Garwin", 1.0 },
  { "Garwood", 1.0 },
  { "Gary", 0.99635804 },
  { "Garyl", 1.0 },
  { "Garylee", 1.0 },
  { "Garyn", 0.75420874 },
  { "Garyon", 1.0 },
  { "Garyson", 1.0 },
  { "Garytt", 1.0 },
  { "Gasia", 0.0 },
  { "Gaspar", 1.0 },
  { "Gaspard", 1.0 },
  { "Gaspare", 1.0 },
  { "Gasper", 1.0 },
  { "Gaston", 1.0 },
  { "Gaten", 1.0 },
  { "Gates", 0.86904764 },
  { "Gatha", 0.0 },
  { "Gathel", 0.0 },
  { "Gather", 1.0 },
  { "Gatlen", 1.0 },
  { "Gatlin", 0.9974516 },
  { "Gatlyn", 0.9596774 },
  { "Gatlynn", 0.42105263 },
  { "Gator", 1.0 },
  { "Gatsby", 0.9137931 },
  { "Gattis", 1.0 },
  { "Gattlin", 1.0 },
  { "Gaudalupe", 0.0 },
  { "Gaudencio", 1.0 },
  { "Gaudy", 0.0 },
  { "Gauge", 1.0 },
  { "Gaurav", 1.0 },
  { "Gauri", 0.0 },
  { "Gaurika", 0.0 },
  { "Gautam", 1.0 },
  { "Gautham", 1.0 },
  { "Gavan", 1.0 },
  { "Gaven", 1.0 },
  { "Gavi", 0.0 },
  { "Gavian", 1.0 },
  { "Gavien", 1.0 },
  { "Gavin", 0.99780655 },
  { "Gavina", 0.0 },
  { "Gavinn", 1.0 },
  { "Gavino", 1.0 },
  { "Gaviota", 0.0 },
  { "Gavon", 1.0 },
  { "Gavriel", 0.9961059 },
  { "Gavriela", 0.0 },
  { "Gavriella", 0.0 },
  { "Gavrielle", 0.0 },
  { "Gavril", 1.0 },
  { "Gavvin", 1.0 },
  { "Gavy", 0.0 },
  { "Gavyn", 0.97622985 },
  { "Gavyne", 1.0 },
  { "Gavynn", 1.0 },
  { "Gawain", 1.0 },
  { "Gawaine", 1.0 },
  { "Gay", 0.07136218 },
  { "Gaya", 0.0 },
  { "Gayane", 0.0 },
  { "Gayann", 0.0 },
  { "Gayanne", 0.0 },
  { "Gayathri", 0.0 },
  { "Gayatri", 0.0 },
  { "Gaye", 0.0 },
  { "Gayel", 0.0 },
  { "Gayge", 1.0 },
  { "Gayl", 0.024115756 },
  { "Gayla", 0.00055330136 },
  { "Gaylan", 0.9125475 },
  { "Gayland", 1.0 },
  { "Gaylard", 1.0 },
  { "Gayle", 0.07471585 },
  { "Gaylee", 0.0 },
  { "Gayleen", 0.0 },
  { "Gaylen", 0.85328835 },
  { "Gaylene", 0.0 },
  { "Gaylia", 0.0 },
  { "Gaylin", 0.57591623 },
  { "Gaylon", 0.9409214 },
  { "Gaylor", 1.0 },
  { "Gaylord", 0.9991791 },
  { "Gaylyn", 0.0 },
  { "Gaylynn", 0.0 },
  { "Gaylynne", 0.0 },
  { "Gayna", 0.0 },
  { "Gaynard", 1.0 },
  { "Gaynel", 0.0 },
  { "Gaynell", 0.004216444 },
  { "Gaynelle", 0.0 },
  { "Gaynol", 0.0 },
  { "Gaynor", 0.475 },
  { "Gayola", 0.0 },
  { "Gayron", 1.0 },
  { "Gaytha", 0.0 },
  { "Gaythel", 0.0 },
  { "Gayton", 1.0 },
  { "Gaza", 1.0 },
  { "Gazal", 0.0 },
  { "Gazella", 0.0 },
  { "Gazelle", 0.0 },
  { "Ge", 0.91071427 },
  { "Gea", 0.0 },
  { "Gean", 0.45261437 },
  { "Geana", 0.0 },
  { "Geancarlo", 1.0 },
  { "Geane", 0.0 },
  { "Geanette", 0.0 },
  { "Geanie", 0.0 },
  { "Geanine", 0.0 },
  { "Geanna", 0.0 },
  { "Geanne", 0.0 },
  { "Geannie", 0.0 },
  { "Geannine", 0.0 },
  { "Gearald", 1.0 },
  { "Geargia", 0.0 },
  { "Gearl", 0.7866667 },
  { "Gearld", 0.9988334 },
  { "Gearldean", 0.0 },
  { "Gearldene", 0.0 },
  { "Gearldine", 0.0010660981 },
  { "Gearlean", 0.0 },
  { "Gearleen", 0.0 },
  { "Gearlene", 0.0 },
  { "Gearline", 0.0 },
  { "Gearold", 1.0 },
  { "Geary", 1.0 },
  { "Geatano", 1.0 },
  { "Gecenia", 0.0 },
  { "Gedalia", 1.0 },
  { "Gedaliah", 1.0 },
  { "Gedalya", 1.0 },
  { "Geddes", 1.0 },
  { "Geddy", 1.0 },
  { "Gedeon", 1.0 },
  { "Gee", 0.79012346 },
  { "Geena", 0.0 },
  { "Geet", 0.0 },
  { "Geeta", 0.0 },
  { "Geetanjali", 0.0 },
  { "Geetha", 0.0 },
  { "Geethika", 0.0 },
  { "Geetika", 0.0 },
  { "Gefen", 0.0 },
  { "Geff", 1.0 },
  { "Geffen", 1.0 },
  { "Geffery", 1.0 },
  { "Geffory", 1.0 },
  { "Geffrey", 1.0 },
  { "Gegory", 1.0 },
  { "Gehad", 0.0 },
  { "Gehard", 1.0 },
  { "Gehrig", 1.0 },
  { "Geidi", 0.0 },
  { "Geidy", 0.0 },
  { "Geisha", 0.0 },
  { "Geissie", 0.0 },
  { "Gejuan", 1.0 },
  { "Gela", 0.0 },
  { "Gelacio", 1.0 },
  { "Geleah", 0.0 },
  { "Gelen", 0.0 },
  { "Gelena", 0.0 },
  { "Gelene", 0.0 },
  { "Gelia", 0.0 },
  { "Gelila", 0.0 },
  { "Gelina", 0.0 },
  { "Gelinda", 0.0 },
  { "Geline", 0.0 },
  { "Gelisa", 0.0 },
  { "Gelisha", 0.0 },
  { "Gelissa", 0.0 },
  { "Gella", 0.0 },
  { "Gelsey", 0.0 },
  { "Gelsomina", 0.0 },
  { "Gelson", 1.0 },
  { "Gem", 0.0 },
  { "Gema", 0.0 },
  { "Gemar", 1.0 },
  { "Gemari", 1.0 },
  { "Gemarion", 1.0 },
  { "Gemayel", 1.0 },
  { "Gemelli", 0.0 },
  { "Gemia", 0.0 },
  { "Gemini", 0.3425926 },
  { "Gemise", 0.0 },
  { "Gemma", 0.0 },
  { "Gemmalynn", 0.0 },
  { "Gen", 0.8378378 },
  { "Gena", 0.0 },
  { "Genae", 0.0 },
  { "Genai", 0.0 },
  { "Genara", 0.0 },
  { "Genard", 1.0 },
  { "Genaro", 1.0 },
  { "Genasis", 0.0 },
  { "Genavecia", 0.0 },
  { "Genavee", 0.0 },
  { "Genaveve", 0.0 },
  { "Genavie", 0.0 },
  { "Genavieve", 0.0 },
  { "Genavive", 0.0 },
  { "Genay", 0.0 },
  { "Genaya", 0.0 },
  { "Gencie", 0.0 },
  { "Gene", 0.9475799 },
  { "Genea", 0.0 },
  { "Geneal", 0.0 },
  { "Genean", 0.0 },
  { "Geneane", 0.0 },
  { "Genece", 0.0 },
  { "Genecis", 0.0 },
  { "Genee", 0.0 },
  { "Geneen", 0.0 },
  { "Geneice", 0.0 },
  { "Geneieve", 0.0 },
  { "Geneil", 0.0 },
  { "Geneine", 0.0 },
  { "Geneiva", 0.0 },
  { "Geneive", 0.0 },
  { "Geneiveve", 0.0 },
  { "Geneivieve", 0.0 },
  { "Genel", 0.0 },
  { "Genelda", 0.0 },
  { "Genele", 0.0 },
  { "Genelia", 0.0 },
  { "Genell", 0.0 },
  { "Genella", 0.0 },
  { "Genelle", 0.0 },
  { "Genena", 0.0 },
  { "Genendy", 0.0 },
  { "Genene", 0.0 },
  { "Genera", 0.0 },
  { "General", 1.0 },
  { "Genero", 1.0 },
  { "Generosa", 0.0 },
  { "Generose", 0.0 },
  { "Generoso", 1.0 },
  { "Generra", 0.0 },
  { "Genesa", 0.0 },
  { "Genese", 0.0 },
  { "Genesee", 0.0 },
  { "Geneses", 0.0 },
  { "Genesha", 0.0 },
  { "Genesi", 0.0 },
  { "Genesia", 0.0 },
  { "Genesis", 0.03002964 },
  { "Genesiss", 0.0 },
  { "Genessa", 0.0 },
  { "Genesse", 0.0 },
  { "Genessee", 0.0 },
  { "Genessi", 0.0 },
  { "Genessis", 0.0 },
  { "Genessy", 0.0 },
  { "Genessys", 0.0 },
  { "Genesy", 0.0 },
  { "Genesys", 0.0 },
  { "Genet", 0.0 },
  { "Geneta", 0.0 },
  { "Genetha", 0.0 },
  { "Genett", 0.0 },
  { "Genetta", 0.0 },
  { "Genette", 0.0 },
  { "Geneva", 0.0035218892 },
  { "Geneve", 0.0 },
  { "Genevea", 0.0 },
  { "Genevee", 0.0 },
  { "Geneveive", 0.0 },
  { "Genever", 0.0 },
  { "Geneveve", 0.0 },
  { "Genevia", 0.0 },
  { "Genevie", 0.0 },
  { "Geneviene", 0.0 },
  { "Geneviev", 0.0 },
  { "Genevieve", 0.0013822143 },
  { "Genevive", 0.0 },
  { "Genevra", 0.0 },
  { "Genevy", 0.0 },
  { "Genghis", 1.0 },
  { "Geni", 0.0 },
  { "Genia", 0.0 },
  { "Geniah", 0.0 },
  { "Genica", 0.0 },
  { "Genice", 0.0 },
  { "Genie", 0.06032078 },
  { "Geniece", 0.0 },
  { "Geniel", 0.0 },
  { "Geniene", 0.0 },
  { "Genieva", 0.0 },
  { "Genieve", 0.0 },
  { "Genievieve", 0.0 },
  { "Genifer", 0.0 },
  { "Geniffer", 0.0 },
  { "Genika", 0.0 },
  { "Genina", 0.0 },
  { "Genine", 0.0 },
  { "Genise", 0.0 },
  { "Genises", 0.0 },
  { "Genisha", 0.0 },
  { "Genisis", 0.0 },
  { "Genissa", 0.0 },
  { "Genisse", 0.0 },
  { "Genisus", 0.0 },
  { "Genisys", 0.0 },
  { "Genita", 0.0 },
  { "Geniva", 0.0 },
  { "Genive", 0.0 },
  { "Genivieve", 0.0 },
  { "Genivive", 0.0 },
  { "Geniya", 0.0 },
  { "Geniyah", 0.0 },
  { "Genki", 1.0 },
  { "Genna", 0.0 },
  { "Gennady", 1.0 },
  { "Gennaro", 1.0 },
  { "Gennavieve", 0.0 },
  { "Gennavive", 0.0 },
  { "Gennell", 0.0 },
  { "Gennelle", 0.0 },
  { "Genner", 1.0 },
  { "Gennesis", 0.0 },
  { "Gennessy", 0.0 },
  { "Gennesy", 0.0 },
  { "Gennesys", 0.0 },
  { "Genneth", 0.0 },
  { "Gennett", 0.0 },
  { "Gennetta", 0.0 },
  { "Gennette", 0.0 },
  { "Gennevieve", 0.0 },
  { "Genni", 0.0 },
  { "Gennia", 0.0 },
  { "Gennie", 0.07262774 },
  { "Gennieve", 0.0 },
  { "Gennifer", 0.0 },
  { "Gennine", 0.0 },
  { "Genny", 0.0 },
  { "Geno", 1.0 },
  { "Genoa", 0.0 },
  { "Genola", 0.0 },
  { "Genora", 0.0 },
  { "Genoria", 0.0 },
  { "Genova", 0.0 },
  { "Genoveva", 0.0 },
  { "Genovevo", 1.0 },
  { "Genovia", 0.0 },
  { "Genovieve", 0.0 },
  { "Genowefa", 0.0 },
  { "Genrose", 0.0 },
  { "Gensen", 1.0 },
  { "Gensie", 0.0 },
  { "Gensis", 0.0 },
  { "Gent", 1.0 },
  { "Gentiana", 0.0 },
  { "Gentle", 1.0 },
  { "Gentri", 0.0 },
  { "Gentrie", 0.0 },
  { "Gentry", 0.64186144 },
  { "Genuine", 1.0 },
  { "Genva", 0.0 },
  { "Genvieve", 0.0 },
  { "Genya", 0.0 },
  { "Genysis", 0.0 },
  { "Geo", 0.98378927 },
  { "Geobani", 1.0 },
  { "Geof", 1.0 },
  { "Geoff", 1.0 },
  { "Geoffery", 1.0 },
  { "Geoffory", 1.0 },
  { "Geoffrey", 0.9974113 },
  { "Geoffry", 1.0 },
  { "Geofrey", 1.0 },
  { "Geoge", 1.0 },
  { "Geoggrey", 1.0 },
  { "Geogia", 0.0 },
  { "Geogory", 1.0 },
  { "Geomar", 1.0 },
  { "Geon", 1.0 },
  { "Geona", 0.0 },
  { "Geonna", 0.0 },
  { "Geonni", 1.0 },
  { "Geontae", 1.0 },
  { "Geonte", 1.0 },
  { "Geordan", 0.90802675 },
  { "Georden", 1.0 },
  { "Geordi", 1.0 },
  { "Geordie", 1.0 },
  { "Geordon", 1.0 },
  { "Geordy", 1.0 },
  { "Geordyn", 0.0 },
  { "Geore", 1.0 },
  { "Georffrey", 1.0 },
  { "Georg", 0.9791667 },
  { "Georga", 0.0 },
  { "Georgan", 0.0 },
  { "Georgana", 0.0 },
  { "Georgann", 0.0 },
  { "Georganna", 0.0 },
  { "Georganne", 0.0 },
  { "George", 0.99324715 },
  { "Georgea", 0.0 },
  { "Georgean", 0.0 },
  { "Georgeana", 0.0 },
  { "Georgeann", 0.0 },
  { "Georgeanna", 0.0 },
  { "Georgeanne", 0.0 },
  { "Georgeanthony", 1.0 },
  { "Georgeen", 0.0 },
  { "Georgeina", 0.0 },
  { "Georgella", 0.0 },
  { "Georgemichael", 1.0 },
  { "Georgena", 0.0 },
  { "Georgene", 0.0 },
  { "Georgenia", 0.0 },
  { "Georgenna", 0.0 },
  { "Georgenne", 0.0 },
  { "Georges", 1.0 },
  { "Georgett", 0.0 },
  { "Georgetta", 0.0 },
  { "Georgette", 0.0 },
  { "Georgi", 0.1286031 },
  { "Georgia", 0.0048423572 },
  { "Georgiaann", 0.0 },
  { "Georgialee", 0.0 },
  { "Georgiamae", 0.0 },
  { "Georgian", 0.0 },
  { "Georgiana", 0.0 },
  { "Georgiane", 0.0 },
  { "Georgiann", 0.0 },
  { "Georgianna", 0.0 },
  { "Georgianne", 0.0 },
  { "Georgie", 0.11359238 },
  { "Georgieann", 0.0 },
  { "Georgieanna", 0.0 },
  { "Georgiena", 0.0 },
  { "Georgietta", 0.0 },
  { "Georgina", 0.0 },
  { "Georgine", 0.0 },
  { "Georginia", 0.0 },
  { "Georgio", 0.9917355 },
  { "Georgios", 1.0 },
  { "Georgiy", 1.0 },
  { "Georgy", 0.5833333 },
  { "Georjean", 0.0 },
  { "Geovan", 1.0 },
  { "Geovana", 0.0 },
  { "Geovani", 1.0 },
  { "Geovanie", 1.0 },
  { "Geovanna", 0.0 },
  { "Geovanne", 1.0 },
  { "Geovanni", 1.0 },
  { "Geovannie", 1.0 },
  { "Geovanny", 1.0 },
  { "Geovany", 1.0 },
  { "Geovoni", 1.0 },
  { "Geovonie", 1.0 },
  { "Geovonni", 1.0 },
  { "Geovonnie", 1.0 },
  { "Gequan", 1.0 },
  { "Ger", 0.81395346 },
  { "Gera", 0.0 },
  { "Gerad", 1.0 },
  { "Geradette", 0.0 },
  { "Geradine", 0.0 },
  { "Gerado", 1.0 },
  { "Geraine", 0.0 },
  { "Geral", 0.60215056 },
  { "Gerald", 0.9946921 },
  { "Geralda", 0.0 },
  { "Geraldean", 0.0 },
  { "Geraldeen", 0.0 },
  { "Geraldene", 0.0 },
  { "Geraldi", 0.0 },
  { "Geraldin", 0.0 },
  { "Geraldina", 0.0 },
  { "Geraldine", 0.0035448389 },
  { "Geraldinne", 0.0 },
  { "Geraldo", 1.0 },
  { "Geraldy", 0.0 },
  { "Geraldyn", 0.0 },
  { "Geraldyne", 0.0 },
  { "Geraleen", 0.0 },
  { "Geralene", 0.0 },
  { "Geraline", 0.0 },
  { "Gerall", 1.0 },
  { "Geralyn", 0.0 },
  { "Geralynn", 0.0 },
  { "Gerame", 1.0 },
  { "Geramiah", 1.0 },
  { "Geramie", 1.0 },
  { "Geramy", 1.0 },
  { "Geran", 1.0 },
  { "Gerane", 0.0 },
  { "Gerard", 0.99806154 },
  { "Gerarda", 0.0 },
  { "Gerardette", 0.0 },
  { "Gerardina", 0.0 },
  { "Gerardine", 0.0 },
  { "Gerardo", 0.99529034 },
  { "Gerardojr", 1.0 },
  { "Gerasimos", 1.0 },
  { "Geraud", 1.0 },
  { "Gerben", 1.0 },
  { "Gerber", 1.0 },
  { "Gerd", 0.4848485 },
  { "Gerda", 0.0 },
  { "Gerdie", 0.0 },
  { "Gere", 0.33333334 },
  { "Gered", 1.0 },
  { "Gerek", 1.0 },
  { "Gereld", 1.0 },
  { "Gereldine", 0.0 },
  { "Gerelene", 0.0 },
  { "Gereline", 0.0 },
  { "Gerell", 1.0 },
  { "Geremia", 1.0 },
  { "Geremiah", 1.0 },
  { "Geremias", 1.0 },
  { "Geremie", 1.0 },
  { "Geremy", 1.0 },
  { "Geren", 1.0 },
  { "Gerene", 0.0 },
  { "Geretha", 0.0 },
  { "Gerette", 0.0 },
  { "Gergory", 1.0 },
  { "Gerhard", 1.0 },
  { "Gerhardt", 1.0 },
  { "Gerhart", 1.0 },
  { "Geri", 0.0006235969 },
  { "Geriah", 0.0 },
  { "Geriann", 0.0 },
  { "Gerianne", 0.0 },
  { "Geric", 1.0 },
  { "Gerica", 0.0 },
  { "Gericho", 1.0 },
  { "Gerick", 1.0 },
  { "Gerid", 1.0 },
  { "Gerie", 0.0 },
  { "Geriel", 1.0 },
  { "Gerik", 1.0 },
  { "Gerika", 0.0 },
  { "Gerilyn", 0.0 },
  { "Gerilynn", 0.0 },
  { "Gerimiah", 1.0 },
  { "Gerin", 1.0 },
  { "Gerise", 0.0 },
  { "Gerita", 0.0 },
  { "Geriyah", 0.0 },
  { "Gerlad", 1.0 },
  { "Gerladine", 0.0 },
  { "Gerld", 1.0 },
  { "Gerldean", 0.0 },
  { "Gerldine", 0.0 },
  { "Gerlean", 0.0 },
  { "Gerlene", 0.0 },
  { "Gerline", 0.0 },
  { "Gerlisa", 0.0 },
  { "Gerlyn", 0.0 },
  { "Germain", 0.95770395 },
  { "Germaine", 0.22497298 },
  { "German", 0.99945295 },
  { "Germane", 1.0 },
  { "Germani", 0.0 },
  { "Germanii", 0.0 },
  { "Germany", 0.39597315 },
  { "Germar", 1.0 },
  { "Germari", 1.0 },
  { "Germarion", 1.0 },
  { "Germayne", 1.0 },
  { "Germell", 1.0 },
  { "Germey", 1.0 },
  { "Germon", 1.0 },
  { "Germya", 0.0 },
  { "Gernard", 1.0 },
  { "Gernie", 1.0 },
  { "Gerniya", 0.0 },
  { "Gero", 1.0 },
  { "Gerod", 1.0 },
  { "Geroge", 1.0 },
  { "Gerogia", 0.0 },
  { "Gerold", 1.0 },
  { "Geroldine", 0.0 },
  { "Geroline", 0.0 },
  { "Gerolyn", 0.0 },
  { "Gerome", 1.0 },
  { "Geromy", 1.0 },
  { "Geron", 1.0 },
  { "Gerone", 1.0 },
  { "Geronima", 0.0 },
  { "Geronimo", 1.0 },
  { "Gerrad", 1.0 },
  { "Gerrald", 1.0 },
  { "Gerran", 1.0 },
  { "Gerrard", 1.0 },
  { "Gerre", 0.0 },
  { "Gerred", 1.0 },
  { "Gerrel", 1.0 },
  { "Gerrell", 1.0 },
  { "Gerren", 0.93559325 },
  { "Gerret", 1.0 },
  { "Gerrett", 1.0 },
  { "Gerri", 0.0031118433 },
  { "Gerriann", 0.0 },
  { "Gerrianne", 0.0 },
  { "Gerrica", 0.0 },
  { "Gerrick", 1.0 },
  { "Gerrid", 1.0 },
  { "Gerrie", 0.007982584 },
  { "Gerrika", 0.0 },
  { "Gerrilyn", 0.0 },
  { "Gerrilynn", 0.0 },
  { "Gerrin", 1.0 },
  { "Gerrit", 1.0 },
  { "Gerritt", 1.0 },
  { "Gerrod", 1.0 },
  { "Gerrold", 1.0 },
  { "Gerron", 1.0 },
  { "Gerry", 0.68346965 },
  { "Gerrye", 0.0 },
  { "Gerryn", 0.0 },
  { "Gersain", 1.0 },
  { "Gershom", 1.0 },
  { "Gershon", 1.0 },
  { "Gerson", 1.0 },
  { "Gerta", 0.0 },
  { "Gertha", 0.0 },
  { "Gerthie", 0.0 },
  { "Gertie", 0.0 },
  { "Gertis", 0.17857143 },
  { "Gertrud", 0.0 },
  { "Gertrude", 0.00320184 },
  { "Gertrudes", 0.0 },
  { "Gertrudis", 0.0 },
  { "Gertrue", 0.0 },
  { "Gertude", 0.0 },
  { "Gerturde", 0.0 },
  { "Gervais", 1.0 },
  { "Gervaise", 0.0 },
  { "Gervase", 0.9752475 },
  { "Gerver", 1.0 },
  { "Gervin", 1.0 },
  { "Gervis", 1.0 },
  { "Gervon", 1.0 },
  { "Gery", 1.0 },
  { "Geryl", 0.0952381 },
  { "Gerzon", 1.0 },
  { "Gesel", 0.0 },
  { "Gesele", 0.0 },
  { "Gesell", 0.0 },
  { "Geselle", 0.0 },
  { "Gesenia", 0.0 },
  { "Geshia", 0.0 },
  { "Gesica", 0.0 },
  { "Gesina", 0.0 },
  { "Gessel", 0.0 },
  { "Gessell", 0.0 },
  { "Gesselle", 0.0 },
  { "Gessica", 0.0 },
  { "Gesualdo", 1.0 },
  { "Geter", 1.0 },
  { "Getha", 0.0 },
  { "Gethsemane", 0.0 },
  { "Gethsemani", 0.0 },
  { "Getrude", 0.0 },
  { "Getrudes", 0.0 },
  { "Getsemani", 0.024590164 },
  { "Getsemany", 0.0 },
  { "Gettie", 0.0 },
  { "Gettis", 1.0 },
  { "Getty", 1.0 },
  { "Gettys", 1.0 },
  { "Getzel", 1.0 },
  { "Getzemani", 0.0 },
  { "Getzemany", 0.0 },
  { "Gevalia", 0.0 },
  { "Gevan", 1.0 },
  { "Gevena", 0.0 },
  { "Gevin", 1.0 },
  { "Gevon", 1.0 },
  { "Gevonte", 1.0 },
  { "Gevorg", 1.0 },
  { "Gevork", 1.0 },
  { "Gewel", 0.0 },
  { "Geysha", 0.0 },
  { "Geza", 1.0 },
  { "Gezelle", 0.0 },
  { "Ghabriel", 1.0 },
  { "Ghada", 0.0 },
  { "Ghadah", 0.0 },
  { "Ghadeer", 0.0 },
  { "Ghael", 1.0 },
  { "Ghaida", 0.0 },
  { "Ghais", 1.0 },
  { "Ghaith", 1.0 },
  { "Ghala", 0.0 },
  { "Ghaleb", 1.0 },
  { "Ghali", 1.0 },
  { "Ghalia", 0.0 },
  { "Ghana", 0.0 },
  { "Ghanem", 1.0 },
  { "Ghassan", 1.0 },
  { "Ghavin", 1.0 },
  { "Ghazal", 0.0 },
  { "Ghazi", 1.0 },
  { "Ghena", 0.0 },
  { "Ghenet", 0.0 },
  { "Ghia", 0.0 },
  { "Ghian", 1.0 },
  { "Ghianna", 0.0 },
  { "Ghina", 0.0 },
  { "Ghislaine", 0.0 },
  { "Ghislane", 0.0 },
  { "Ghita", 0.0 },
  { "Ghofran", 0.0 },
  { "Ghulam", 1.0 },
  { "Gi", 0.0 },
  { "Gia", 0.00036646143 },
  { "Giabella", 0.0 },
  { "Giacinto", 1.0 },
  { "Giacobbe", 1.0 },
  { "Giacomina", 0.0 },
  { "Giacomo", 1.0 },
  { "Giada", 0.0 },
  { "Giah", 0.0 },
  { "Giahan", 0.0 },
  { "Giahna", 0.0 },
  { "Giahnna", 0.0 },
  { "Giamarie", 0.0 },
  { "Gian", 1.0 },
  { "Giana", 0.0 },
  { "Gianah", 0.0 },
  { "Giancarlo", 1.0 },
  { "Giancarlos", 1.0 },
  { "Gianella", 0.0 },
  { "Gianelle", 0.0 },
  { "Gianelly", 0.0 },
  { "Gianessa", 0.0 },
  { "Gianetta", 0.0 },
  { "Gianfranco", 1.0 },
  { "Giang", 0.84 },
  { "Giani", 0.578199 },
  { "Gianina", 0.0 },
  { "Gianinna", 0.0 },
  { "Giankarlo", 1.0 },
  { "Gianluca", 1.0 },
  { "Gianlucas", 1.0 },
  { "Gianlucca", 1.0 },
  { "Gianluigi", 1.0 },
  { "Gianluka", 1.0 },
  { "Gianmarco", 1.0 },
  { "Gianmarcos", 1.0 },
  { "Gianmichael", 1.0 },
  { "Giann", 1.0 },
  { "Gianna", 0.00046298592 },
  { "Giannah", 0.0 },
  { "Giannamarie", 0.0 },
  { "Giannarose", 0.0 },
  { "Gianncarlo", 1.0 },
  { "Gianne", 0.0 },
  { "Giannella", 0.0 },
  { "Gianni", 0.8345816 },
  { "Giannie", 0.0 },
  { "Giannina", 0.0 },
  { "Giannis", 1.0 },
  { "Gianno", 1.0 },
  { "Gianny", 0.52272725 },
  { "Giano", 1.0 },
  { "Gianpaolo", 1.0 },
  { "Gianpaul", 1.0 },
  { "Gianpiero", 1.0 },
  { "Giany", 0.0 },
  { "Giara", 0.0 },
  { "Giavana", 0.0 },
  { "Giavanna", 0.0 },
  { "Giavannah", 0.0 },
  { "Giavanni", 0.307947 },
  { "Giavona", 0.0 },
  { "Giavonna", 0.0 },
  { "Giavonni", 0.38721806 },
  { "Giavonnie", 0.0 },
  { "Gib", 1.0 },
  { "Gibb", 1.0 },
  { "Gibbs", 1.0 },
  { "Gibelly", 0.0 },
  { "Gibert", 1.0 },
  { "Gibram", 1.0 },
  { "Gibran", 1.0 },
  { "Gibril", 1.0 },
  { "Gibson", 0.97140133 },
  { "Gicel", 0.0 },
  { "Gicela", 0.0 },
  { "Gicell", 0.0 },
  { "Gicelle", 0.0 },
  { "Gid", 1.0 },
  { "Giddeon", 1.0 },
  { "Gideon", 0.9991309 },
  { "Gidget", 0.0 },
  { "Gidgett", 0.0 },
  { "Gidgette", 0.0 },
  { "Gieselle", 0.0 },
  { "Giezi", 1.0 },
  { "Gifford", 1.0 },
  { "Gift", 0.0 },
  { "Gifty", 0.0 },
  { "Gig", 1.0 },
  { "Giget", 0.0 },
  { "Gigette", 0.0 },
  { "Gigi", 0.0 },
  { "Gihanna", 0.0 },
  { "Gil", 1.0 },
  { "Gila", 0.0 },
  { "Gilad", 1.0 },
  { "Gilana", 0.0 },
  { "Gilbert", 0.99478775 },
  { "Gilberta", 0.0 },
  { "Gilberte", 0.0 },
  { "Gilberto", 0.9978889 },
  { "Gilchrist", 1.0 },
  { "Gilda", 0.0 },
  { "Gildardo", 1.0 },
  { "Gildo", 1.0 },
  { "Gile", 1.0 },
  { "Gilead", 1.0 },
  { "Giles", 1.0 },
  { "Gilford", 1.0 },
  { "Gilfred", 1.0 },
  { "Gili", 0.0 },
  { "Gilia", 0.0 },
  { "Gilian", 0.0 },
  { "Giliana", 0.0 },
  { "Gill", 0.95672697 },
  { "Gillan", 0.0 },
  { "Gillard", 1.0 },
  { "Gillen", 1.0 },
  { "Gillermina", 0.0 },
  { "Gillermo", 1.0 },
  { "Gilles", 1.0 },
  { "Gillespie", 1.0 },
  { "Gillette", 1.0 },
  { "Gilliam", 0.93630576 },
  { "Gillian", 0.0042979023 },
  { "Gilliana", 0.0 },
  { "Gillianna", 0.0 },
  { "Gillianne", 0.0 },
  { "Gillie", 0.3723197 },
  { "Gillis", 1.0 },
  { "Gillyan", 0.0 },
  { "Gilma", 0.0 },
  { "Gilman", 1.0 },
  { "Gilmar", 1.0 },
  { "Gilmer", 1.0 },
  { "Gilmore", 1.0 },
  { "Gilroy", 1.0 },
  { "Gilson", 1.0 },
  { "Gilverto", 1.0 },
  { "Gimena", 0.0 },
  { "Gin", 0.76666665 },
  { "Gina", 0.002617595 },
  { "Ginae", 0.0 },
  { "Ginamarie", 0.0 },
  { "Ginaya", 0.0 },
  { "Gindy", 0.0 },
  { "Gineen", 0.0 },
  { "Ginelie", 0.0 },
  { "Ginell", 0.0 },
  { "Ginelle", 0.0 },
  { "Giner", 0.0 },
  { "Ginessa", 0.0 },
  { "Ginetta", 0.0 },
  { "Ginette", 0.0 },
  { "Gineva", 0.0 },
  { "Ginevra", 0.0 },
  { "Ging", 0.0 },
  { "Ginger", 0.0008951965 },
  { "Gini", 0.0 },
  { "Ginia", 0.0 },
  { "Ginine", 0.0 },
  { "Ginna", 0.0 },
  { "Ginneh", 0.0 },
  { "Ginnette", 0.0 },
  { "Ginney", 0.0 },
  { "Ginni", 0.0 },
  { "Ginnie", 0.0 },
  { "Ginnifer", 0.0 },
  { "Ginno", 1.0 },
  { "Ginny", 0.0 },
  { "Gino", 0.9989775 },
  { "Ginobili", 1.0 },
  { "Gio", 0.98730963 },
  { "Gioacchino", 1.0 },
  { "Gioanna", 0.0 },
  { "Gioanni", 1.0 },
  { "Giobani", 1.0 },
  { "Giobany", 1.0 },
  { "Gioconda", 0.0 },
  { "Gioele", 1.0 },
  { "Gioia", 0.0 },
  { "Giomar", 1.0 },
  { "Gion", 1.0 },
  { "Giona", 0.0 },
  { "Gioni", 1.0 },
  { "Gionna", 0.0 },
  { "Gionni", 0.9522059 },
  { "Gionnie", 1.0 },
  { "Gionny", 1.0 },
  { "Giordan", 0.890625 },
  { "Giordana", 0.0 },
  { "Giordano", 1.0 },
  { "Giorgi", 1.0 },
  { "Giorgia", 0.0 },
  { "Giorgina", 0.0 },
  { "Giorgio", 1.0 },
  { "Giorgios", 1.0 },
  { "Giorgos", 1.0 },
  { "Giovan", 1.0 },
  { "Giovana", 0.0 },
  { "Giovani", 0.9991882 },
  { "Giovanie", 1.0 },
  { "Giovanii", 1.0 },
  { "Giovann", 1.0 },
  { "Giovanna", 0.0 },
  { "Giovannah", 0.0 },
  { "Giovanne", 1.0 },
  { "Giovanni", 0.9864755 },
  { "Giovannie", 0.99029124 },
  { "Giovannii", 1.0 },
  { "Giovannina", 0.0 },
  { "Giovanny", 0.99492383 },
  { "Giovante", 1.0 },
  { "Giovany", 1.0 },
  { "Giovina", 0.0 },
  { "Giovoni", 1.0 },
  { "Giovonie", 1.0 },
  { "Giovonna", 0.0 },
  { "Giovonni", 1.0 },
  { "Giovonnie", 1.0 },
  { "Gipson", 1.0 },
  { "Gipsy", 0.0 },
  { "Girard", 1.0 },
  { "Girdie", 0.0 },
  { "Girish", 1.0 },
  { "Girl", 0.0 },
  { "Girlean", 0.0 },
  { "Girlee", 0.0 },
  { "Girlene", 0.0 },
  { "Girlie", 0.0 },
  { "Giro", 1.0 },
  { "Girolama", 0.0 },
  { "Girolamo", 1.0 },
  { "Girtha", 0.0 },
  { "Girther", 0.0 },
  { "Girthie", 0.0 },
  { "Girtie", 0.0 },
  { "Girtrude", 0.0 },
  { "Girtrue", 0.0 },
  { "Girty", 0.0 },
  { "Giscard", 1.0 },
  { "Gisel", 0.0 },
  { "Gisela", 0.0 },
  { "Giselda", 0.0 },
  { "Gisele", 0.0 },
  { "Gisell", 0.0 },
  { "Gisella", 0.0 },
  { "Giselle", 0.0010555863 },
  { "Giselly", 0.0 },
  { "Gisely", 0.0 },
  { "Gisette", 0.0 },
  { "Gislaine", 0.0 },
  { "Gissel", 0.0 },
  { "Gissela", 0.0 },
  { "Gissele", 0.0 },
  { "Gissell", 0.0 },
  { "Gissella", 0.0 },
  { "Gisselle", 0.0 },
  { "Gissette", 0.0 },
  { "Gita", 0.0 },
  { "Gitana", 0.0 },
  { "Gitanjali", 0.0 },
  { "Gitel", 0.0 },
  { "Gitta", 0.0 },
  { "Gittel", 0.0 },
  { "Gittle", 0.0 },
  { "Gitty", 0.0 },
  { "Gitzel", 0.0 },
  { "Giuditta", 0.0 },
  { "Giulia", 0.0 },
  { "Giulian", 1.0 },
  { "Giuliana", 0.0 },
  { "Giuliani", 1.0 },
  { "Giulianna", 0.0 },
  { "Giuliano", 1.0 },
  { "Giulietta", 0.0 },
  { "Giuliette", 0.0 },
  { "Giulio", 1.0 },
  { "Giulliana", 0.0 },
  { "Giuseppa", 0.0 },
  { "Giuseppe", 1.0 },
  { "Giuseppi", 1.0 },
  { "Giuseppina", 0.0 },
  { "Giustina", 0.0 },
  { "Givanna", 0.0 },
  { "Givanni", 1.0 },
  { "Given", 1.0 },
  { "Givon", 1.0 },
  { "Givonna", 0.0 },
  { "Givonni", 1.0 },
  { "Giya", 0.0 },
  { "Giyana", 0.0 },
  { "Giyanna", 0.0 },
  { "Gizel", 0.0 },
  { "Gizela", 0.0 },
  { "Gizele", 0.0 },
  { "Gizell", 0.0 },
  { "Gizella", 0.0 },
  { "Gizelle", 0.0 },
  { "Gizem", 0.0 },
  { "Gizzel", 0.0 },
  { "Gizzelle", 0.0 },
  { "Gjon", 1.0 },
  { "Glada", 0.0 },
  { "Gladden", 1.0 },
  { "Glade", 1.0 },
  { "Gladene", 0.0 },
  { "Glades", 0.0 },
  { "Gladie", 0.0 },
  { "Gladies", 0.0 },
  { "Gladimir", 1.0 },
  { "Gladine", 0.0 },
  { "Gladiola", 0.0 },
  { "Gladis", 0.001682935 },
  { "Gladiz", 0.0 },
  { "Gladolia", 0.0 },
  { "Gladston", 1.0 },
  { "Gladstone", 1.0 },
  { "Gladus", 0.0 },
  { "Gladwin", 1.0 },
  { "Gladwyn", 1.0 },
  { "Glady", 0.009208103 },
  { "Gladyce", 0.0 },
  { "Gladyes", 0.0 },
  { "Gladyne", 0.0 },
  { "Gladys", 0.0038288364 },
  { "Gladyse", 0.0 },
  { "Gladystine", 0.0 },
  { "Glafira", 0.0 },
  { "Glanda", 0.0 },
  { "Glasco", 1.0 },
  { "Glasper", 1.0 },
  { "Glatha", 0.0 },
  { "Glayds", 0.0 },
  { "Glean", 1.0 },
  { "Gleason", 1.0 },
  { "Gleb", 1.0 },
  { "Gleda", 0.0 },
  { "Glee", 0.02496879 },
  { "Gleen", 1.0 },
  { "Gleeta", 0.0 },
  { "Gleice", 0.0 },
  { "Glema", 0.0 },
  { "Glen", 0.989334 },
  { "Glena", 0.0 },
  { "Glenadine", 0.0 },
  { "Glenalee", 0.0 },
  { "Glenard", 1.0 },
  { "Glenda", 0.0026989689 },
  { "Glendal", 0.97354496 },
  { "Glendale", 0.8704 },
  { "Glendalee", 0.0 },
  { "Glendalis", 0.0 },
  { "Glendaliz", 0.0 },
  { "Glendall", 1.0 },
  { "Glendaly", 0.0 },
  { "Glendalys", 0.0 },
  { "Glendean", 0.0 },
  { "Glendel", 0.96875 },
  { "Glendell", 0.8421955 },
  { "Glenden", 1.0 },
  { "Glendene", 0.0 },
  { "Glender", 0.0 },
  { "Glendi", 0.0 },
  { "Glendia", 0.0 },
  { "Glendine", 0.0 },
  { "Glendle", 1.0 },
  { "Glendola", 0.0 },
  { "Glendolyn", 0.0 },
  { "Glendon", 0.98619795 },
  { "Glendora", 0.0 },
  { "Glendoria", 0.0 },
  { "Glendoris", 0.0 },
  { "Glendy", 0.0 },
  { "Glenell", 0.0 },
  { "Glenese", 0.0 },
  { "Glenesha", 0.0 },
  { "Glenetta", 0.0 },
  { "Glenette", 0.0 },
  { "Gleneva", 0.0 },
  { "Glenford", 1.0 },
  { "Glenice", 0.0 },
  { "Glenis", 0.06323185 },
  { "Glenise", 0.0 },
  { "Glenisha", 0.0 },
  { "Glenita", 0.0 },
  { "Glenmore", 1.0 },
  { "Glenn", 0.99144095 },
  { "Glenna", 0.00019564111 },
  { "Glennard", 1.0 },
  { "Glennda", 0.0 },
  { "Glenndora", 0.0 },
  { "Glenne", 0.0 },
  { "Glennell", 0.0 },
  { "Glennetta", 0.0 },
  { "Glennette", 0.0 },
  { "Glennia", 0.0 },
  { "Glennice", 0.0 },
  { "Glennie", 0.13174461 },
  { "Glennis", 0.2598198 },
  { "Glennisha", 0.0 },
  { "Glennon", 1.0 },
  { "Glennora", 0.0 },
  { "Glennwood", 1.0 },
  { "Glenny", 0.3902439 },
  { "Glennys", 0.0 },
  { "Glenola", 0.0 },
  { "Glenora", 0.0 },
  { "Glenrose", 0.0 },
  { "Glenroy", 1.0 },
  { "Glenston", 1.0 },
  { "Glenton", 1.0 },
  { "Glenva", 0.0 },
  { "Glenville", 1.0 },
  { "Glenward", 1.0 },
  { "Glenwood", 1.0 },
  { "Gleny", 0.0 },
  { "Glenyce", 0.0 },
  { "Glenys", 0.0 },
  { "Gleora", 0.0 },
  { "Glessie", 0.0 },
  { "Glida", 0.0 },
  { "Glin", 1.0 },
  { "Glinda", 0.0 },
  { "Glinnie", 0.0 },
  { "Glo", 0.0 },
  { "Glodine", 0.0 },
  { "Glora", 0.0 },
  { "Glorene", 0.0 },
  { "Gloretha", 0.0 },
  { "Gloretta", 0.0 },
  { "Glori", 0.0 },
  { "Gloria", 0.0042111846 },
  { "Gloriajean", 0.0 },
  { "Glorian", 0.0 },
  { "Gloriana", 0.0 },
  { "Gloriane", 0.0 },
  { "Gloriann", 0.0 },
  { "Glorianna", 0.0 },
  { "Glorianne", 0.0 },
  { "Gloribel", 0.0 },
  { "Glorice", 0.0 },
  { "Gloricely", 0.0 },
  { "Glorida", 0.0 },
  { "Glorie", 0.0 },
  { "Glories", 0.0 },
  { "Glorietta", 0.0 },
  { "Gloriette", 0.0 },
  { "Glorimar", 0.0 },
  { "Glorine", 0.0 },
  { "Glorious", 0.0 },
  { "Gloris", 0.0 },
  { "Gloristeen", 0.0 },
  { "Gloristine", 0.0 },
  { "Glorius", 0.0 },
  { "Glory", 0.00673989 },
  { "Glorya", 0.0 },
  { "Gloryann", 0.0 },
  { "Gloryvee", 0.0 },
  { "Glossie", 0.0 },
  { "Gloster", 1.0 },
  { "Glover", 0.99551165 },
  { "Gloyd", 1.0 },
  { "Glyda", 0.0 },
  { "Glyde", 1.0 },
  { "Glyn", 0.93762714 },
  { "Glyna", 0.0 },
  { "Glynda", 0.0 },
  { "Glyndia", 0.0 },
  { "Glyndon", 0.9354839 },
  { "Glyndora", 0.0 },
  { "Glynes", 0.0 },
  { "Glynice", 0.0 },
  { "Glynis", 0.0049407114 },
  { "Glyniss", 0.0 },
  { "Glynn", 0.92215794 },
  { "Glynna", 0.0 },
  { "Glynne", 0.0 },
  { "Glynnis", 0.0 },
  { "Gniya", 0.0 },
  { "Gobel", 1.0 },
  { "Gobind", 1.0 },
  { "Goble", 1.0 },
  { "God", 1.0 },
  { "Goddess", 0.0 },
  { "Godfred", 1.0 },
  { "Godfrey", 1.0 },
  { "Godiva", 0.0 },
  { "Godofredo", 1.0 },
  { "Godric", 1.0 },
  { "Godrick", 1.0 },
  { "Godson", 1.0 },
  { "Godswill", 1.0 },
  { "Godwill", 1.0 },
  { "Godwin", 1.0 },
  { "Goebel", 1.0 },
  { "Goeffrey", 1.0 },
  { "Goerge", 1.0 },
  { "Goff", 1.0 },
  { "Gogi", 0.0 },
  { "Gohan", 1.0 },
  { "Gohar", 0.0 },
  { "Goku", 1.0 },
  { "Gokul", 1.0 },
  { "Gola", 0.01607717 },
  { "Golan", 1.0 },
  { "Gold", 0.5 },
  { "Golda", 0.0 },
  { "Golde", 0.0 },
  { "Goldean", 0.0 },
  { "Golden", 0.5678042 },
  { "Goldena", 0.0 },
  { "Goldene", 0.0 },
  { "Goldi", 0.0 },
  { "Goldia", 0.0 },
  { "Goldie", 0.011982481 },
  { "Goldina", 0.0 },
  { "Goldine", 0.0 },
  { "Goldman", 1.0 },
  { "Goldmon", 1.0 },
  { "Goldy", 0.0 },
  { "Goldye", 0.0 },
  { "Goldyn", 0.0 },
  { "Golena", 0.0 },
  { "Goliath", 1.0 },
  { "Golie", 0.0 },
  { "Golnaz", 0.0 },
  { "Gomer", 1.0 },
  { "Gomez", 1.0 },
  { "Gonsalo", 1.0 },
  { "Gonzala", 0.0 },
  { "Gonzales", 1.0 },
  { "Gonzalo", 1.0 },
  { "Gonzella", 0.0 },
  { "Goodluck", 1.0 },
  { "Goodman", 1.0 },
  { "Goodness", 0.0 },
  { "Goodwin", 1.0 },
  { "Gopal", 1.0 },
  { "Gopi", 0.0 },
  { "Gopika", 0.0 },
  { "Gor", 1.0 },
  { "Goran", 1.0 },
  { "Gordan", 1.0 },
  { "Gordana", 0.0 },
  { "Gordean", 0.0 },
  { "Gorden", 1.0 },
  { "Gordie", 0.71985817 },
  { "Gordon", 0.99563205 },
  { "Gordy", 1.0 },
  { "Goree", 1.0 },
  { "Gorete", 0.0 },
  { "Goretti", 0.0 },
  { "Goretty", 0.0 },
  { "Gorge", 1.0 },
  { "Gorgeous", 0.0 },
  { "Gorgonio", 1.0 },
  { "Gorham", 1.0 },
  { "Gorizia", 0.0 },
  { "Gorje", 1.0 },
  { "Gorkem", 1.0 },
  { "Gorman", 1.0 },
  { "Goro", 1.0 },
  { "Goshen", 1.0 },
  { "Gospel", 1.0 },
  { "Goten", 1.0 },
  { "Gotham", 1.0 },
  { "Gottfred", 1.0 },
  { "Gottfried", 1.0 },
  { "Gotti", 1.0 },
  { "Gottlieb", 1.0 },
  { "Gottlob", 1.0 },
  { "Gould", 1.0 },
  { "Gouri", 0.0 },
  { "Govan", 1.0 },
  { "Govani", 1.0 },
  { "Govanna", 0.0 },
  { "Govanni", 1.0 },
  { "Govanny", 1.0 },
  { "Govany", 1.0 },
  { "Governor", 1.0 },
  { "Govind", 1.0 },
  { "Govinda", 1.0 },
  { "Gowri", 0.0 },
  { "Gowtham", 1.0 },
  { "Grabiel", 1.0 },
  { "Grabiela", 0.0 },
  { "Grabriel", 1.0 },
  { "Grabriela", 0.0 },
  { "Grace", 0.0027209031 },
  { "Gracean", 0.0 },
  { "Graceann", 0.0 },
  { "Graceanna", 0.0 },
  { "Graceanne", 0.0 },
  { "Gracee", 0.0 },
  { "Graceelizabeth", 0.0 },
  { "Gracelan", 0.0 },
  { "Graceland", 0.0 },
  { "Gracelee", 0.0 },
  { "Graceleigh", 0.0 },
  { "Gracelin", 0.0 },
  { "Gracelinn", 0.0 },
  { "Gracella", 0.0 },
  { "Gracely", 0.0 },
  { "Gracelyn", 0.0 },
  { "Gracelynd", 0.0 },
  { "Gracelynn", 0.0 },
  { "Gracelynne", 0.0 },
  { "Gracemarie", 0.0 },
  { "Gracemary", 0.0 },
  { "Gracen", 0.2926926 },
  { "Graceson", 0.9037657 },
  { "Gracesyn", 0.0 },
  { "Gracey", 0.0 },
  { "Graceyn", 0.0 },
  { "Graci", 0.0 },
  { "Gracia", 0.0 },
  { "Gracian", 1.0 },
  { "Graciana", 0.0 },
  { "Gracianna", 0.0 },
  { "Gracianne", 0.0 },
  { "Graciano", 1.0 },
  { "Gracie", 0.000628018 },
  { "Gracieann", 0.0 },
  { "Graciee", 0.0 },
  { "Graciela", 0.0025384014 },
  { "Graciella", 0.0 },
  { "Gracielle", 0.0 },
  { "Gracielynn", 0.0 },
  { "Graciemae", 0.0 },
  { "Gracilyn", 0.0 },
  { "Gracilynn", 0.0 },
  { "Gracin", 0.67180276 },
  { "Gracious", 0.0 },
  { "Graclyn", 0.0 },
  { "Graclynn", 0.0 },
  { "Gracy", 0.0 },
  { "Gracye", 0.0 },
  { "Gracyn", 0.033745103 },
  { "Gracynn", 0.0 },
  { "Graddy", 1.0 },
  { "Graden", 1.0 },
  { "Gradey", 1.0 },
  { "Gradie", 0.68488747 },
  { "Gradin", 1.0 },
  { "Gradon", 1.0 },
  { "Grady", 0.98560005 },
  { "Gradyn", 1.0 },
  { "Gradys", 0.0 },
  { "Grae", 0.43609023 },
  { "Graecen", 1.0 },
  { "Graecie", 0.0 },
  { "Graecyn", 0.09090909 },
  { "Graeden", 1.0 },
  { "Graedy", 1.0 },
  { "Graeham", 1.0 },
  { "Graelyn", 0.0 },
  { "Graelynn", 0.0 },
  { "Graem", 1.0 },
  { "Graeme", 1.0 },
  { "Graer", 1.0 },
  { "Graesen", 1.0 },
  { "Graeson", 0.9718574 },
  { "Graesyn", 0.7777778 },
  { "Grafton", 1.0 },
  { "Graham", 0.9964698 },
  { "Grahame", 1.0 },
  { "Grahm", 1.0 },
  { "Graice", 0.0 },
  { "Graicen", 1.0 },
  { "Graicyn", 0.0 },
  { "Graiden", 1.0 },
  { "Graidy", 1.0 },
  { "Graidys", 0.0 },
  { "Graig", 1.0 },
  { "Grainger", 1.0 },
  { "Grainne", 0.0 },
  { "Graisen", 1.0 },
  { "Graison", 0.8842444 },
  { "Graisyn", 0.40625 },
  { "Gralin", 1.0 },
  { "Gralyn", 1.0 },
  { "Gram", 1.0 },
  { "Gramm", 1.0 },
  { "Granada", 0.0 },
  { "Granderson", 1.0 },
  { "Grandin", 1.0 },
  { "Grandison", 1.0 },
  { "Grandon", 1.0 },
  { "Grandville", 1.0 },
  { "Granger", 1.0 },
  { "Granite", 1.0 },
  { "Grant", 0.99832225 },
  { "Grantham", 1.0 },
  { "Grantland", 1.0 },
  { "Grantlee", 1.0 },
  { "Grantley", 1.0 },
  { "Granvel", 1.0 },
  { "Granvil", 1.0 },
  { "Granvill", 1.0 },
  { "Granville", 1.0 },
  { "Graple", 0.0 },
  { "Grasen", 1.0 },
  { "Grasha", 0.0 },
  { "Grasiela", 0.0 },
  { "Grason", 1.0 },
  { "Grasyn", 0.6911765 },
  { "Gratia", 0.0 },
  { "Graven", 1.0 },
  { "Graves", 1.0 },
  { "Graviel", 1.0 },
  { "Graviela", 0.0 },
  { "Gray", 0.912027 },
  { "Grayce", 0.0 },
  { "Graycee", 0.0 },
  { "Graycelyn", 0.0 },
  { "Graycelynn", 0.0 },
  { "Graycen", 0.31157637 },
  { "Grayci", 0.0 },
  { "Graycie", 0.0 },
  { "Graycin", 0.44594595 },
  { "Grayden", 1.0 },
  { "Graydin", 1.0 },
  { "Graydon", 1.0 },
  { "Graye", 0.33333334 },
  { "Grayer", 1.0 },
  { "Graylan", 1.0 },
  { "Grayland", 1.0 },
  { "Graylee", 0.0 },
  { "Graylen", 1.0 },
  { "Graylin", 0.9318637 },
  { "Grayling", 1.0 },
  { "Graylon", 1.0 },
  { "Graylyn", 0.1 },
  { "Graylynn", 0.0 },
  { "Graysen", 0.7989418 },
  { "Graysie", 0.0 },
  { "Graysin", 1.0 },
  { "Grayson", 0.94803876 },
  { "Graysyn", 0.9019608 },
  { "Grayton", 1.0 },
  { "Grazia", 0.0 },
  { "Graziana", 0.0 },
  { "Graziano", 1.0 },
  { "Graziella", 0.0 },
  { "Greagory", 1.0 },
  { "Great", 1.0 },
  { "Greathel", 0.0 },
  { "Greatness", 1.0 },
  { "Grechen", 0.0 },
  { "Grecia", 0.0 },
  { "Greco", 1.0 },
  { "Greda", 0.0 },
  { "Gredmarie", 0.0 },
  { "Greeley", 0.6229508 },
  { "Greely", 1.0 },
  { "Green", 1.0 },
  { "Greenberry", 1.0 },
  { "Greene", 1.0 },
  { "Greenlea", 0.0 },
  { "Greenlee", 0.0 },
  { "Greenleigh", 0.0 },
  { "Greenley", 0.0 },
  { "Greenly", 0.0 },
  { "Greenville", 1.0 },
  { "Greenwood", 1.0 },
  { "Greer", 0.18550412 },
  { "Greeta", 0.0 },
  { "Greg", 0.9981589 },
  { "Gregario", 1.0 },
  { "Gregary", 1.0 },
  { "Gregeory", 1.0 },
  { "Gregery", 1.0 },
  { "Gregg", 0.9969088 },
  { "Greggery", 1.0 },
  { "Greggory", 1.0 },
  { "Gregoire", 1.0 },
  { "Gregor", 1.0 },
  { "Gregorey", 1.0 },
  { "Gregorg", 1.0 },
  { "Gregori", 1.0 },
  { "Gregoria", 0.0027014858 },
  { "Gregorie", 1.0 },
  { "Gregorio", 0.9995153 },
  { "Gregorios", 1.0 },
  { "Gregorita", 0.0 },
  { "Gregory", 0.99596334 },
  { "Gregoy", 1.0 },
  { "Gregrey", 1.0 },
  { "Gregrory", 1.0 },
  { "Gregroy", 1.0 },
  { "Gregry", 1.0 },
  { "Gregson", 1.0 },
  { "Greicy", 0.0 },
  { "Greidi", 0.0 },
  { "Greidis", 0.0 },
  { "Greidy", 0.0 },
  { "Greidys", 0.0 },
  { "Greig", 1.0 },
  { "Greighson", 1.0 },
  { "Greison", 1.0 },
  { "Greisy", 0.0 },
  { "Greko", 1.0 },
  { "Grenda", 0.0 },
  { "Grenisha", 0.0 },
  { "Grenville", 1.0 },
  { "Greogory", 1.0 },
  { "Greogry", 1.0 },
  { "Greory", 1.0 },
  { "Gresa", 0.0 },
  { "Gresham", 1.0 },
  { "Gresia", 0.0 },
  { "Greta", 0.00020475859 },
  { "Gretal", 0.0 },
  { "Gretchan", 0.0 },
  { "Gretchen", 0.00071386975 },
  { "Gretchin", 0.0 },
  { "Gretchyn", 0.0 },
  { "Grete", 0.0 },
  { "Gretel", 0.0 },
  { "Gretell", 0.0 },
  { "Gretha", 0.0 },
  { "Grethe", 0.0 },
  { "Grethel", 0.0 },
  { "Gretna", 0.0 },
  { "Gretta", 0.0 },
  { "Grettel", 0.0 },
  { "Grettell", 0.0 },
  { "Grey", 0.86740625 },
  { "Greyce", 0.0 },
  { "Greycen", 0.89830506 },
  { "Greycin", 1.0 },
  { "Greyden", 1.0 },
  { "Greydi", 0.0 },
  { "Greydis", 0.0 },
  { "Greydon", 1.0 },
  { "Greydy", 0.0 },
  { "Greydys", 0.0 },
  { "Greyer", 1.0 },
  { "Greylan", 1.0 },
  { "Greylin", 0.7619048 },
  { "Greyling", 1.0 },
  { "Greylon", 1.0 },
  { "Greylyn", 0.0 },
  { "Greylynn", 0.0 },
  { "Greys", 0.0 },
  { "Greysen", 0.8919949 },
  { "Greysi", 0.0 },
  { "Greysin", 1.0 },
  { "Greyson", 0.97980267 },
  { "Greyston", 1.0 },
  { "Greysun", 1.0 },
  { "Greysyn", 0.8913044 },
  { "Greyton", 1.0 },
  { "Gricel", 0.0 },
  { "Gricelda", 0.0 },
  { "Gricell", 0.0 },
  { "Grieg", 1.0 },
  { "Grier", 0.5 },
  { "Griezmann", 1.0 },
  { "Griff", 1.0 },
  { "Griffen", 1.0 },
  { "Griffey", 1.0 },
  { "Griffin", 0.9850389 },
  { "Griffinn", 1.0 },
  { "Griffith", 1.0 },
  { "Griffon", 1.0 },
  { "Griffyn", 0.8770764 },
  { "Grifin", 1.0 },
  { "Grigor", 1.0 },
  { "Grigoriy", 1.0 },
  { "Grigory", 1.0 },
  { "Grimm", 1.0 },
  { "Grinda", 0.0 },
  { "Grindl", 0.0 },
  { "Grindle", 0.0 },
  { "Griscelda", 0.0 },
  { "Grisel", 0.0043130005 },
  { "Grisela", 0.0 },
  { "Griselda", 0.0069420733 },
  { "Grisell", 0.0 },
  { "Griselle", 0.0 },
  { "Grisham", 1.0 },
  { "Grishma", 0.0 },
  { "Grissel", 0.0 },
  { "Grissom", 1.0 },
  { "Gristian", 1.0 },
  { "Grizel", 0.0 },
  { "Grizelda", 0.0 },
  { "Grizzly", 1.0 },
  { "Gross", 1.0 },
  { "Grove", 1.0 },
  { "Grovene", 0.0 },
  { "Grover", 0.9965893 },
  { "Groves", 1.0 },
  { "Grundy", 1.0 },
  { "Gryffen", 1.0 },
  { "Gryffin", 1.0 },
  { "Gryffon", 1.0 },
  { "Gryphon", 1.0 },
  { "Grzegorz", 1.0 },
  { "Guadalupe", 0.2771791 },
  { "Guadelupe", 0.0 },
  { "Guadlupe", 0.4489796 },
  { "Guadulupe", 0.0 },
  { "Guage", 1.0 },
  { "Gualberto", 1.0 },
  { "Guan", 1.0 },
  { "Guardian", 1.0 },
  { "Guarionex", 1.0 },
  { "Gudalupe", 0.15625 },
  { "Gudelia", 0.0 },
  { "Gudrun", 0.0 },
  { "Guelda", 0.0 },
  { "Guendalina", 0.0 },
  { "Guendi", 0.0 },
  { "Guendolyn", 0.0 },
  { "Guenevere", 0.0 },
  { "Guenter", 1.0 },
  { "Guenther", 1.0 },
  { "Guerdon", 1.0 },
  { "Guerin", 1.0 },
  { "Guerina", 0.0 },
  { "Guerino", 1.0 },
  { "Guerline", 0.0 },
  { "Guerrero", 1.0 },
  { "Guerrino", 1.0 },
  { "Guerry", 1.0 },
  { "Guess", 1.0 },
  { "Guhan", 1.0 },
  { "Guida", 0.0 },
  { "Guido", 1.0 },
  { "Guila", 0.0 },
  { "Guilbert", 1.0 },
  { "Guilda", 0.0 },
  { "Guilford", 1.0 },
  { "Guilherme", 1.0 },
  { "Guilian", 1.0 },
  { "Guiliana", 0.0 },
  { "Guilianna", 0.0 },
  { "Guiliano", 1.0 },
  { "Guilio", 1.0 },
  { "Guillaume", 1.0 },
  { "Guillerma", 0.0 },
  { "Guillermina", 0.0 },
  { "Guillermo", 0.9974896 },
  { "Guilliana", 0.0 },
  { "Guilmar", 1.0 },
  { "Guin", 1.0 },
  { "Guinda", 0.0 },
  { "Guinette", 0.0 },
  { "Guinevere", 0.0 },
  { "Guinivere", 0.0 },
  { "Guinn", 1.0 },
  { "Guinness", 1.0 },
  { "Guinnevere", 0.0 },
  { "Guisel", 0.0 },
  { "Guisela", 0.0 },
  { "Guisell", 0.0 },
  { "Guiselle", 0.0 },
  { "Guiseppe", 1.0 },
  { "Guiseppi", 1.0 },
  { "Guisselle", 0.0 },
  { "Guistino", 1.0 },
  { "Gul", 0.0 },
  { "Gula", 0.0 },
  { "Guled", 1.0 },
  { "Gulian", 1.0 },
  { "Guliana", 0.0 },
  { "Gulianna", 0.0 },
  { "Gullermo", 1.0 },
  { "Gumaro", 1.0 },
  { "Gumecindo", 1.0 },
  { "Gumercindo", 1.0 },
  { "Gumesindo", 1.0 },
  { "Gunar", 1.0 },
  { "Gunars", 1.0 },
  { "Gunda", 0.0 },
  { "Gunder", 1.0 },
  { "Guneet", 0.0 },
  { "Guner", 1.0 },
  { "Gunhild", 0.0 },
  { "Gunnar", 0.9987183 },
  { "Gunnard", 1.0 },
  { "Gunnarr", 1.0 },
  { "Gunner", 0.9992574 },
  { "Gunnison", 1.0 },
  { "Gunter", 1.0 },
  { "Gunther", 1.0 },
  { "Gunvor", 0.0 },
  { "Guransh", 1.0 },
  { "Gurbani", 0.0 },
  { "Gurbir", 1.0 },
  { "Gurdeep", 1.0 },
  { "Gurdit", 1.0 },
  { "Gurdon", 1.0 },
  { "Gurfateh", 1.0 },
  { "Gurinder", 1.0 },
  { "Gurjeet", 1.0 },
  { "Gurjit", 1.0 },
  { "Gurjot", 0.9653179 },
  { "Gurkamal", 1.0 },
  { "Gurkirat", 0.84210527 },
  { "Gurleen", 0.0 },
  { "Gurley", 1.0 },
  { "Gurlie", 0.0 },
  { "Gurman", 0.9015151 },
  { "Gurnaaz", 0.0 },
  { "Gurneet", 0.0 },
  { "Gurney", 1.0 },
  { "Gurnie", 1.0 },
  { "Gurnoor", 0.3559322 },
  { "Gurpal", 1.0 },
  { "Gurpreet", 0.64389235 },
  { "Gurseerat", 0.0 },
  { "Gurshaan", 1.0 },
  { "Gurshan", 1.0 },
  { "Gurshawn", 1.0 },
  { "Gursimar", 0.0 },
  { "Gursimran", 0.23076923 },
  { "Gursirat", 0.0 },
  { "Gurtaaj", 1.0 },
  { "Gurtaj", 1.0 },
  { "Gurtej", 1.0 },
  { "Gurtha", 0.0 },
  { "Gurtie", 0.0 },
  { "Gurtrude", 0.0 },
  { "Gurtrue", 0.0 },
  { "Guru", 1.0 },
  { "Gurveen", 0.0 },
  { "Gurveer", 1.0 },
  { "Gurvinder", 1.0 },
  { "Gurvir", 1.0 },
  { "Gurvis", 1.0 },
  { "Gus", 0.99973 },
  { "Guss", 1.0 },
  { "Gussie", 0.07742754 },
  { "Gust", 1.0 },
  { "Gusta", 0.0 },
  { "Gustabo", 1.0 },
  { "Gustaf", 1.0 },
  { "Gustas", 1.0 },
  { "Gustauo", 1.0 },
  { "Gustav", 1.0 },
  { "Gustava", 0.0 },
  { "Gustave", 1.0 },
  { "Gustavia", 0.0 },
  { "Gustavo", 0.9971461 },
  { "Gustavus", 1.0 },
  { "Gustena", 0.0 },
  { "Guster", 1.0 },
  { "Gustie", 0.045045044 },
  { "Gustin", 1.0 },
  { "Gustina", 0.0 },
  { "Gustine", 0.0 },
  { "Guston", 1.0 },
  { "Gusty", 1.0 },
  { "Guthrie", 0.9844961 },
  { "Guy", 0.99477285 },
  { "Guyann", 0.0 },
  { "Guyanne", 0.0 },
  { "Guydra", 0.0 },
  { "Guye", 1.0 },
  { "Guyla", 0.0 },
  { "Guylene", 0.0 },
  { "Guymon", 1.0 },
  { "Guynell", 0.0 },
  { "Guynelle", 0.0 },
  { "Guyneth", 0.0 },
  { "Guyon", 1.0 },
  { "Guyton", 1.0 },
  { "Guztavo", 1.0 },
  { "Gwain", 1.0 },
  { "Gwan", 0.0 },
  { "Gwana", 0.0 },
  { "Gwanda", 0.0 },
  { "Gwelda", 0.0 },
  { "Gwen", 0.009847596 },
  { "Gwena", 0.0 },
  { "Gwenaelle", 0.0 },
  { "Gwenavere", 0.0 },
  { "Gwenda", 0.0 },
  { "Gwendalin", 0.0 },
  { "Gwendalina", 0.0 },
  { "Gwendalyn", 0.0 },
  { "Gwendalynn", 0.0 },
  { "Gwendel", 0.0 },
  { "Gwendell", 0.09090909 },
  { "Gwendelyn", 0.0 },
  { "Gwendelynn", 0.0 },
  { "Gwender", 0.0 },
  { "Gwendia", 0.0 },
  { "Gwendloyn", 0.0 },
  { "Gwendlyn", 0.0 },
  { "Gwendlyon", 0.0 },
  { "Gwendol", 0.0 },
  { "Gwendola", 0.0 },
  { "Gwendolen", 0.0 },
  { "Gwendolene", 0.0 },
  { "Gwendolin", 0.0 },
  { "Gwendoline", 0.0 },
  { "Gwendoly", 0.0 },
  { "Gwendolyn", 0.00283902 },
  { "Gwendolyne", 0.0 },
  { "Gwendolynn", 0.0 },
  { "Gwendolynne", 0.0 },
  { "Gwendoyln", 0.0 },
  { "Gwendy", 0.0 },
  { "Gwendylan", 0.0 },
  { "Gwendylon", 0.0 },
  { "Gwenell", 0.0 },
  { "Gweneth", 0.0 },
  { "Gwenetta", 0.0 },
  { "Gwenette", 0.0 },
  { "Gweneva", 0.0 },
  { "Gwenevere", 0.0 },
  { "Gweneviere", 0.0 },
  { "Gwenevieve", 0.0 },
  { "Gwenith", 0.0 },
  { "Gwenivere", 0.0 },
  { "Gwenlyn", 0.0 },
  { "Gwenn", 0.0 },
  { "Gwenna", 0.0 },
  { "Gwennan", 0.0 },
  { "Gwenne", 0.0 },
  { "Gwenneth", 0.0 },
  { "Gwennetta", 0.0 },
  { "Gwennette", 0.0 },
  { "Gwennyth", 0.0 },
  { "Gwenyth", 0.0 },
  { "Gwenyvere", 0.0 },
  { "Gwili", 0.0 },
  { "Gwilym", 1.0 },
  { "Gwin", 0.7189189 },
  { "Gwinda", 0.0 },
  { "Gwindolyn", 0.0 },
  { "Gwinn", 0.7826087 },
  { "Gwladys", 0.0 },
  { "Gwydion", 1.0 },
  { "Gwyn", 0.1282824 },
  { "Gwynavere", 0.0 },
  { "Gwynda", 0.0 },
  { "Gwyndolin", 0.0 },
  { "Gwyndolyn", 0.0 },
  { "Gwyne", 0.0 },
  { "Gwyned", 0.0 },
  { "Gwyneth", 0.0 },
  { "Gwynetta", 0.0 },
  { "Gwynette", 0.0 },
  { "Gwynevere", 0.0 },
  { "Gwynith", 0.0 },
  { "Gwynn", 0.12337662 },
  { "Gwynne", 0.021382751 },
  { "Gwynneth", 0.0 },
  { "Gwytha", 0.0 },
  { "Gy", 1.0 },
  { "Gyan", 1.0 },
  { "Gyana", 0.0 },
  { "Gyanna", 0.0 },
  { "Gyanni", 0.0 },
  { "Gyasi", 1.0 },
  { "Gyda", 0.0 },
  { "Gyla", 0.0 },
  { "Gyle", 1.0 },
  { "Gyles", 1.0 },
  { "Gyllian", 0.0 },
  { "Gyna", 0.0 },
  { "Gynesis", 0.0 },
  { "Gyneth", 0.0 },
  { "Gynith", 0.0 },
  { "Gypsie", 0.0 },
  { "Gypsy", 0.0 },
  { "Gyra", 0.0 },
  { "Gysel", 0.0 },
  { "Gyselle", 0.0 },
  { "Gyzelle", 0.0 },
  { "Gzim", 1.0 },
  { "Ha", 0.14747475 },
  { "Haadi", 1.0 },
  { "Haadiya", 0.0 },
  { "Haadiyah", 0.0 },
  { "Haaheo", 1.0 },
  { "Haajar", 0.0 },
  { "Haaken", 1.0 },
  { "Haakim", 1.0 },
  { "Haakon", 1.0 },
  { "Haala", 0.0 },
  { "Haamid", 1.0 },
  { "Haani", 0.0 },
  { "Haania", 0.0 },
  { "Haaniya", 0.0 },
  { "Haarika", 0.0 },
  { "Haaris", 1.0 },
  { "Haasan", 1.0 },
  { "Haashim", 1.0 },
  { "Haashir", 1.0 },
  { "Haasini", 0.0 },
  { "Haaziq", 1.0 },
  { "Habacuc", 1.0 },
  { "Habeba", 0.0 },
  { "Habeeb", 1.0 },
  { "Habeeba", 0.0 },
  { "Haben", 0.8039216 },
  { "Habert", 1.0 },
  { "Habib", 1.0 },
  { "Habiba", 0.0 },
  { "Habibah", 0.0 },
  { "Habibatou", 0.0 },
  { "Habil", 1.0 },
  { "Habon", 0.0 },
  { "Habraham", 1.0 },
  { "Habram", 1.0 },
  { "Habsa", 0.0 },
  { "Haby", 0.0 },
  { "Hachiro", 1.0 },
  { "Had", 1.0 },
  { "Hada", 0.0 },
  { "Hadalyn", 0.0 },
  { "Hadan", 1.0 },
  { "Hadar", 0.0 },
  { "Hadara", 0.0 },
  { "Hadarah", 0.0 },
  { "Hadari", 1.0 },
  { "Hadas", 0.0 },
  { "Hadasa", 0.0 },
  { "Hadasah", 0.0 },
  { "Hadasha", 0.0 },
  { "Hadassa", 0.0 },
  { "Hadassah", 0.0 },
  { "Haddasah", 0.0 },
  { "Hadden", 0.94335514 },
  { "Haddi", 0.0 },
  { "Haddie", 0.0 },
  { "Haddison", 0.0 },
  { "Haddley", 0.0 },
  { "Haddon", 0.9829684 },
  { "Haddox", 1.0 },
  { "Haddy", 0.03816794 },
  { "Hade", 0.0 },
  { "Hadeed", 1.0 },
  { "Hadeel", 0.0 },
  { "Hadeer", 0.0 },
  { "Hadel", 0.0 },
  { "Hadelyn", 0.0 },
  { "Haden", 0.95822245 },
  { "Hades", 1.0 },
  { "Hadessa", 0.0 },
  { "Hadessah", 0.0 },
  { "Hadi", 1.0 },
  { "Hadia", 0.0 },
  { "Hadiah", 0.0 },
  { "Hadiatou", 0.0 },
  { "Hadie", 0.0 },
  { "Hadija", 0.0 },
  { "Hadil", 0.0 },
  { "Hadilyn", 0.0 },
  { "Hadin", 1.0 },
  { "Hadiya", 0.0 },
  { "Hadiyah", 0.0 },
  { "Hadiyyah", 0.0 },
  { "Hadiza", 0.0 },
  { "Hadja", 0.0 },
  { "Hadji", 1.0 },
  { "Hadlea", 0.0 },
  { "Hadlee", 0.0062552127 },
  { "Hadlei", 0.0 },
  { "Hadleigh", 0.0 },
  { "Hadley", 0.07144515 },
  { "Hadleyann", 0.0 },
  { "Hadli", 0.0 },
  { "Hadlie", 0.0 },
  { "Hadly", 0.0 },
  { "Hadlyn", 0.0 },
  { "Hadlynn", 0.0 },
  { "Hadrian", 1.0 },
  { "Hadriel", 1.0 },
  { "Hadrien", 1.0 },
  { "Hady", 0.78571427 },
  { "Hadya", 0.0 },
  { "Hadyn", 0.5402414 },
  { "Hae", 0.0 },
  { "Haeden", 0.8768116 },
  { "Haedon", 1.0 },
  { "Haedyn", 0.3632653 },
  { "Haegan", 1.0 },
  { "Haegen", 1.0 },
  { "Haein", 0.0 },
  { "Hael", 0.5 },
  { "Haelee", 0.0 },
  { "Haeleigh", 0.0 },
  { "Haeley", 0.0 },
  { "Haeli", 0.0 },
  { "Haelie", 0.0 },
  { "Haely", 0.0 },
  { "Haelyn", 0.0 },
  { "Haelynn", 0.0 },
  { "Haether", 0.0 },
  { "Haeun", 0.0 },
  { "Haeven", 0.11764706 },
  { "Haevyn", 0.0 },
  { "Haevynn", 0.0 },
  { "Hafeez", 1.0 },
  { "Hafeeza", 0.0 },
  { "Hafeezah", 0.0 },
  { "Hafford", 1.0 },
  { "Hafid", 1.0 },
  { "Hafiz", 1.0 },
  { "Hafsa", 0.0 },
  { "Hafsah", 0.0 },
  { "Hafso", 0.0 },
  { "Hagan", 0.90692306 },
  { "Hagar", 0.0 },
  { "Hagen", 0.9336775 },
  { "Hageo", 1.0 },
  { "Hager", 0.68292683 },
  { "Haggai", 1.0 },
  { "Haggard", 1.0 },
  { "Hagood", 1.0 },
  { "Hagop", 1.0 },
  { "Hahna", 0.0 },
  { "Hai", 0.96428573 },
  { "Haidan", 0.9104478 },
  { "Haidar", 1.0 },
  { "Haide", 0.0 },
  { "Haidee", 0.0 },
  { "Haiden", 0.69850683 },
  { "Haider", 1.0 },
  { "Haidi", 0.0 },
  { "Haidin", 0.8076923 },
  { "Haidon", 1.0 },
  { "Haidy", 0.0 },
  { "Haidyn", 0.25667152 },
  { "Haidynn", 0.0 },
  { "Haiely", 0.0 },
  { "Haifa", 0.0 },
  { "Haig", 1.0 },
  { "Haigen", 0.8064516 },
  { "Haik", 1.0 },
  { "Haila", 0.0 },
  { "Haile", 0.19740778 },
  { "Hailea", 0.0 },
  { "Haileah", 0.0 },
  { "Hailee", 0.00041666668 },
  { "Haileen", 0.0 },
  { "Hailei", 0.0 },
  { "Haileigh", 0.0 },
  { "Hailen", 0.0 },
  { "Hailey", 0.0016877363 },
  { "Haileyann", 0.0 },
  { "Haileyjade", 0.0 },
  { "Haileyjo", 0.0 },
  { "Haileymarie", 0.0 },
  { "Haileyrose", 0.0 },
  { "Haili", 0.0 },
  { "Hailie", 0.0 },
  { "Hailiey", 0.0 },
  { "Haille", 0.0 },
  { "Haillee", 0.0 },
  { "Hailley", 0.0 },
  { "Haillie", 0.0 },
  { "Hailly", 0.0 },
  { "Hailo", 0.0 },
  { "Haily", 0.0 },
  { "Hailye", 0.0 },
  { "Hailyn", 0.0 },
  { "Hailynn", 0.0 },
  { "Haim", 1.0 },
  { "Haines", 1.0 },
  { "Hairl", 1.0 },
  { "Hairo", 1.0 },
  { "Haislee", 0.0 },
  { "Haisley", 0.0 },
  { "Haisten", 1.0 },
  { "Haitham", 1.0 },
  { "Haithem", 1.0 },
  { "Haiti", 0.0 },
  { "Haiven", 0.125 },
  { "Haivyn", 0.0 },
  { "Haiyden", 1.0 },
  { "Haiylee", 0.0 },
  { "Haize", 0.7368421 },
  { "Haizel", 0.0 },
  { "Haizen", 1.0 },
  { "Haizlee", 0.0 },
  { "Haizley", 0.0 },
  { "Haja", 0.0 },
  { "Hajar", 0.0 },
  { "Hajara", 0.0 },
  { "Hajari", 1.0 },
  { "Hajer", 0.0 },
  { "Haji", 1.0 },
  { "Hajime", 1.0 },
  { "Hajin", 1.0 },
  { "Hajira", 0.0 },
  { "Hajirah", 0.0 },
  { "Hajj", 1.0 },
  { "Hajoon", 1.0 },
  { "Hajra", 0.0 },
  { "Hajrah", 0.0 },
  { "Hajun", 1.0 },
  { "Hakan", 1.0 },
  { "Hakeem", 1.0 },
  { "Hakeema", 0.0 },
  { "Hakeen", 1.0 },
  { "Hakeim", 1.0 },
  { "Haki", 1.0 },
  { "Hakiem", 1.0 },
  { "Hakim", 1.0 },
  { "Hakima", 0.0 },
  { "Hakimah", 0.0 },
  { "Hakob", 1.0 },
  { "Hakop", 1.0 },
  { "Haku", 1.0 },
  { "Hal", 0.99927443 },
  { "Hala", 0.005090909 },
  { "Halah", 0.0 },
  { "Halaina", 0.0 },
  { "Halana", 0.0 },
  { "Halane", 0.0 },
  { "Halani", 0.0 },
  { "Halas", 1.0 },
  { "Halaya", 0.0 },
  { "Halayah", 0.0 },
  { "Halayna", 0.0 },
  { "Halbert", 1.0 },
  { "Halcy", 0.0 },
  { "Halcyon", 0.0 },
  { "Halden", 1.0 },
  { "Haldon", 1.0 },
  { "Haldor", 1.0 },
  { "Haldrin", 1.0 },
  { "Hale", 0.9879931 },
  { "Halea", 0.0 },
  { "Haleah", 0.0 },
  { "Halee", 0.0 },
  { "Haleem", 1.0 },
  { "Haleema", 0.0 },
  { "Haleemah", 0.0 },
  { "Haleena", 0.0 },
  { "Haleh", 0.0 },
  { "Halei", 0.0 },
  { "Haleia", 0.0 },
  { "Haleigh", 0.00066269055 },
  { "Haleigha", 0.0 },
  { "Halema", 0.0 },
  { "Halen", 0.63316214 },
  { "Halena", 0.0 },
  { "Halene", 0.0 },
  { "Haley", 0.005326627 },
  { "Haleyann", 0.0 },
  { "Haleyjo", 0.0 },
  { "Halford", 1.0 },
  { "Halfred", 1.0 },
  { "Hali", 0.0022686026 },
  { "Halia", 0.0 },
  { "Haliana", 0.0 },
  { "Halid", 1.0 },
  { "Halie", 0.0 },
  { "Haliee", 0.0 },
  { "Haliegh", 0.0 },
  { "Haliey", 0.0 },
  { "Halil", 1.0 },
  { "Halim", 1.0 },
  { "Halima", 0.0 },
  { "Halimah", 0.0 },
  { "Halimatou", 0.0 },
  { "Halimo", 0.0 },
  { "Halina", 0.0 },
  { "Haline", 0.0 },
  { "Halit", 1.0 },
  { "Haliyah", 0.0 },
  { "Hall", 1.0 },
  { "Halla", 0.0 },
  { "Hallah", 0.0 },
  { "Hallard", 1.0 },
  { "Halle", 0.0004553734 },
  { "Hallee", 0.0 },
  { "Halleh", 0.0 },
  { "Hallei", 0.0 },
  { "Halleigh", 0.0 },
  { "Hallel", 0.0 },
  { "Halleli", 0.0 },
  { "Hallelujah", 0.0 },
  { "Hallema", 0.0 },
  { "Hallene", 0.0 },
  { "Hallet", 1.0 },
  { "Hallett", 1.0 },
  { "Halley", 0.0328125 },
  { "Halli", 0.0 },
  { "Hallie", 0.04352362 },
  { "Hallis", 1.0 },
  { "Hally", 0.0078125 },
  { "Hallye", 0.0 },
  { "Halo", 0.124370955 },
  { "Haloa", 1.0 },
  { "Halona", 0.0 },
  { "Halsey", 0.6559486 },
  { "Halstead", 1.0 },
  { "Halsten", 1.0 },
  { "Halston", 0.7904 },
  { "Halton", 1.0 },
  { "Halvor", 1.0 },
  { "Haly", 0.0 },
  { "Halye", 0.0 },
  { "Halyn", 0.0 },
  { "Halyna", 0.0 },
  { "Halynn", 0.0 },
  { "Ham", 1.0 },
  { "Hamaad", 1.0 },
  { "Hamad", 1.0 },
  { "Hamadi", 1.0 },
  { "Hamda", 0.0 },
  { "Hamdaan", 1.0 },
  { "Hamdan", 1.0 },
  { "Hamdi", 0.27602905 },
  { "Hamed", 1.0 },
  { "Hameed", 1.0 },
  { "Hameedah", 0.0 },
  { "Hameen", 1.0 },
  { "Hamer", 1.0 },
  { "Hamid", 1.0 },
  { "Hamida", 0.0 },
  { "Hamidah", 0.0 },
  { "Hamidou", 1.0 },
  { "Hamilton", 1.0 },
  { "Hamim", 1.0 },
  { "Hamin", 1.0 },
  { "Hamir", 1.0 },
  { "Hamish", 1.0 },
  { "Hamiz", 1.0 },
  { "Hamlet", 1.0 },
  { "Hamlin", 1.0 },
  { "Hammad", 1.0 },
  { "Hammed", 1.0 },
  { "Hammie", 1.0 },
  { "Hammond", 1.0 },
  { "Hamna", 0.0 },
  { "Hamnah", 0.0 },
  { "Hamp", 1.0 },
  { "Hampton", 0.9746103 },
  { "Hamsa", 1.0 },
  { "Hamse", 1.0 },
  { "Hamsika", 0.0 },
  { "Hamsini", 0.0 },
  { "Hamza", 1.0 },
  { "Hamzah", 1.0 },
  { "Hamze", 1.0 },
  { "Hamzeh", 1.0 },
  { "Han", 0.50419384 },
  { "Hana", 0.0006252605 },
  { "Hanaa", 0.0 },
  { "Hanaan", 0.0 },
  { "Hanad", 1.0 },
  { "Hanadi", 0.0 },
  { "Hanady", 0.0 },
  { "Hanae", 0.0 },
  { "Hanah", 0.0 },
  { "Hanai", 0.0 },
  { "Hanako", 0.0 },
  { "Hanalee", 0.0 },
  { "Hanalei", 0.0 },
  { "Hanan", 0.057635177 },
  { "Hanane", 0.0 },
  { "Hananiah", 0.4032258 },
  { "Hanayo", 0.0 },
  { "Hance", 1.0 },
  { "Hancel", 1.0 },
  { "Handerson", 1.0 },
  { "Handley", 1.0 },
  { "Handsome", 1.0 },
  { "Handy", 0.9907919 },
  { "Haneef", 1.0 },
  { "Haneefa", 0.0 },
  { "Haneefah", 0.0 },
  { "Haneen", 0.0 },
  { "Haneesh", 1.0 },
  { "Hanen", 0.0 },
  { "Haney", 1.0 },
  { "Hanford", 1.0 },
  { "Hang", 0.0 },
  { "Hanh", 0.044210527 },
  { "Hani", 0.88605696 },
  { "Hania", 0.0 },
  { "Haniah", 0.0 },
  { "Haniel", 0.9779736 },
  { "Hanif", 1.0 },
  { "Hanifa", 0.0 },
  { "Hanifah", 0.0 },
  { "Haniff", 1.0 },
  { "Hanika", 0.0 },
  { "Hanin", 0.0 },
  { "Hanish", 1.0 },
  { "Haniya", 0.0 },
  { "Haniyah", 0.0 },
  { "Haniyyah", 0.0 },
  { "Hank", 1.0 },
  { "Hanlee", 0.0 },
  { "Hanley", 0.7614424 },
  { "Hanna", 0.00343717 },
  { "Hannabella", 0.0 },
  { "Hannabelle", 0.0 },
  { "Hannah", 0.0016189464 },
  { "Hannaha", 0.0 },
  { "Hannahelizabeth", 0.0 },
  { "Hannahgrace", 0.0 },
  { "Hannahjo", 0.0 },
  { "Hannahlee", 0.0 },
  { "Hannahlynn", 0.0 },
  { "Hannahmae", 0.0 },
  { "Hannahmarie", 0.0 },
  { "Hannahrae", 0.0 },
  { "Hannahrose", 0.0 },
  { "Hannalee", 0.0 },
  { "Hannaleigh", 0.0 },
  { "Hannaley", 0.0 },
  { "Hannalise", 0.0 },
  { "Hannan", 0.17575757 },
  { "Hanne", 0.0 },
  { "Hannelore", 0.0 },
  { "Hanner", 0.0 },
  { "Hannes", 1.0 },
  { "Hannha", 0.0 },
  { "Hanni", 0.0 },
  { "Hannia", 0.0 },
  { "Hanniah", 0.0 },
  { "Hannibal", 1.0 },
  { "Hannie", 0.0 },
  { "Hanniel", 1.0 },
  { "Hannon", 0.8245614 },
  { "Hanns", 1.0 },
  { "Hanny", 0.0 },
  { "Hannya", 0.0 },
  { "Hanoch", 1.0 },
  { "Hanora", 0.0 },
  { "Hans", 0.9996547 },
  { "Hansel", 0.9982021 },
  { "Hansell", 1.0 },
  { "Hansen", 1.0 },
  { "Hansford", 1.0 },
  { "Hansika", 0.0 },
  { "Hansini", 0.0 },
  { "Hansley", 1.0 },
  { "Hanson", 1.0 },
  { "Hanssel", 1.0 },
  { "Hantz", 1.0 },
  { "Hanvika", 0.0 },
  { "Hanvitha", 0.0 },
  { "Hany", 0.88095236 },
  { "Hanya", 0.0 },
  { "Hanz", 1.0 },
  { "Hanzalah", 1.0 },
  { "Hanzel", 1.0 },
  { "Hanzo", 1.0 },
  { "Hao", 0.9882075 },
  { "Haochen", 1.0 },
  { "Haoran", 1.0 },
  { "Haowen", 1.0 },
  { "Haoxuan", 1.0 },
  { "Haoyang", 1.0 },
  { "Haoyu", 1.0 },
  { "Hap", 1.0 },
  { "Happiness", 0.0 },
  { "Happy", 0.5707763 },
  { "Hara", 0.0 },
  { "Harace", 1.0 },
  { "Haralabos", 1.0 },
  { "Haralambos", 1.0 },
  { "Harald", 1.0 },
  { "Haram", 0.29411766 },
  { "Haran", 1.0 },
  { "Harbert", 1.0 },
  { "Harbin", 1.0 },
  { "Harbor", 0.35362998 },
  { "Harbour", 0.33333334 },
  { "Harce", 1.0 },
  { "Harcourt", 1.0 },
  { "Hardee", 1.0 },
  { "Hardeep", 0.742268 },
  { "Harden", 1.0 },
  { "Hardie", 1.0 },
  { "Hardik", 1.0 },
  { "Hardin", 1.0 },
  { "Harding", 1.0 },
  { "Hardison", 1.0 },
  { "Hardwick", 1.0 },
  { "Hardy", 0.9981529 },
  { "Hareem", 0.0 },
  { "Harel", 1.0 },
  { "Hareld", 1.0 },
  { "Haresh", 1.0 },
  { "Harfateh", 1.0 },
  { "Harford", 1.0 },
  { "Hargie", 1.0 },
  { "Hargis", 1.0 },
  { "Hargun", 0.21186441 },
  { "Hargus", 1.0 },
  { "Hari", 1.0 },
  { "Harice", 1.0 },
  { "Harihar", 1.0 },
  { "Hariharan", 1.0 },
  { "Harika", 0.0 },
  { "Hariklia", 0.0 },
  { "Harilaos", 1.0 },
  { "Harim", 1.0 },
  { "Harin", 1.0 },
  { "Harinder", 1.0 },
  { "Harini", 0.0 },
  { "Haripriya", 0.0 },
  { "Haris", 1.0 },
  { "Harish", 1.0 },
  { "Harison", 1.0 },
  { "Harita", 0.0 },
  { "Harith", 1.0 },
  { "Harjaap", 1.0 },
  { "Harjap", 0.0 },
  { "Harjas", 0.7017544 },
  { "Harjot", 0.75 },
  { "Harkaran", 1.0 },
  { "Harkeem", 1.0 },
  { "Harker", 1.0 },
  { "Harkiran", 0.0 },
  { "Harkirat", 0.7209302 },
  { "Harl", 1.0 },
  { "Harla", 0.0 },
  { "Harlan", 0.99240667 },
  { "Harland", 0.9985133 },
  { "Harld", 1.0 },
  { "Harle", 1.0 },
  { "Harlea", 0.0 },
  { "Harlean", 0.0 },
  { "Harlee", 0.075656004 },
  { "Harleen", 0.0 },
  { "Harleequinn", 0.0 },
  { "Harlei", 0.0 },
  { "Harleigh", 0.0 },
  { "Harlem", 0.7308721 },
  { "Harlen", 0.9924007 },
  { "Harlene", 0.0 },
  { "Harlequin", 0.0 },
  { "Harlequinn", 0.0 },
  { "Harles", 1.0 },
  { "Harless", 1.0 },
  { "Harleth", 1.0 },
  { "Harley", 0.6413403 },
  { "Harleyann", 0.0 },
  { "Harleyquinn", 0.0 },
  { "Harleyrose", 0.0 },
  { "Harli", 0.0 },
  { "Harlie", 0.1831019 },
  { "Harliee", 0.0 },
  { "Harliegh", 0.0 },
  { "Harlin", 0.97898424 },
  { "Harline", 0.0 },
  { "Harliquinn", 0.0 },
  { "Harlis", 1.0 },
  { "Harliv", 0.0 },
  { "Harlo", 0.5063694 },
  { "Harlod", 1.0 },
  { "Harloe", 0.0 },
  { "Harlon", 1.0 },
  { "Harlow", 0.27479208 },
  { "Harlowe", 0.08306709 },
  { "Harly", 0.14973262 },
  { "Harlym", 0.1322314 },
  { "Harlyn", 0.3494282 },
  { "Harlynn", 0.0 },
  { "Harm", 1.0 },
  { "Harman", 0.9381139 },
  { "Harmandeep", 1.0 },
  { "Harmani", 0.0 },
  { "Harmanie", 0.0 },
  { "Harmanpreet", 0.46153846 },
  { "Harmany", 0.0 },
  { "Harmeet", 0.3529412 },
  { "Harmie", 1.0 },
  { "Harminnie", 0.0 },
  { "Harmon", 0.99674517 },
  { "Harmond", 1.0 },
  { "Harmone", 0.0 },
  { "Harmonee", 0.0 },
  { "Harmonei", 0.0 },
  { "Harmoney", 0.0 },
  { "Harmoni", 0.0 },
  { "Harmonie", 0.0 },
  { "Harmoniee", 0.0 },
  { "Harmonii", 0.0 },
  { "Harmony", 0.0008318011 },
  { "Harneet", 0.0 },
  { "Harney", 1.0 },
  { "Harnoor", 0.2688822 },
  { "Harol", 1.0 },
  { "Harold", 0.99520046 },
  { "Haroldean", 0.6315789 },
  { "Haroldene", 0.0 },
  { "Haroldine", 0.0 },
  { "Haroldo", 1.0 },
  { "Harolene", 0.0 },
  { "Harolyn", 0.0 },
  { "Haron", 1.0 },
  { "Haroon", 1.0 },
  { "Haroun", 1.0 },
  { "Harout", 1.0 },
  { "Haroutun", 1.0 },
  { "Haroutyun", 1.0 },
  { "Harpal", 1.0 },
  { "Harpar", 0.0 },
  { "Harper", 0.08197049 },
  { "Harpergrace", 0.0 },
  { "Harpreet", 0.4950298 },
  { "Harpyr", 0.0 },
  { "Harrel", 1.0 },
  { "Harrell", 1.0 },
  { "Harrey", 1.0 },
  { "Harrie", 0.8888889 },
  { "Harriel", 1.0 },
  { "Harriet", 0.001369522 },
  { "Harriett", 0.00023228803 },
  { "Harrietta", 0.0 },
  { "Harriette", 0.0 },
  { "Harril", 1.0 },
  { "Harrill", 1.0 },
  { "Harrilyn", 0.0 },
  { "Harrington", 1.0 },
  { "Harriot", 0.0 },
  { "Harris", 0.9922168 },
  { "Harrisen", 1.0 },
  { "Harrison", 0.99671084 },
  { "Harrisson", 1.0 },
  { "Harrol", 1.0 },
  { "Harrold", 1.0 },
  { "Harroll", 1.0 },
  { "Harron", 1.0 },
  { "Harry", 0.99522626 },
  { "Harryette", 0.0 },
  { "Harryson", 1.0 },
  { "Harseerat", 0.0 },
  { "Harsh", 1.0 },
  { "Harsha", 0.9151786 },
  { "Harshaan", 1.0 },
  { "Harshal", 1.0 },
  { "Harshan", 1.0 },
  { "Harshdeep", 1.0 },
  { "Harshi", 0.0 },
  { "Harshika", 0.0 },
  { "Harshil", 1.0 },
  { "Harshini", 0.0 },
  { "Harshit", 1.0 },
  { "Harshita", 0.0 },
  { "Harshith", 1.0 },
  { "Harshitha", 0.0 },
  { "Harshiv", 1.0 },
  { "Harshveer", 1.0 },
  { "Harsimar", 1.0 },
  { "Harsimran", 0.25396827 },
  { "Harsimrat", 0.0 },
  { "Hart", 0.9767981 },
  { "Hartaj", 1.0 },
  { "Hartej", 1.0 },
  { "Hartense", 0.0 },
  { "Hartford", 1.0 },
  { "Hartie", 0.0 },
  { "Hartlee", 0.0 },
  { "Hartleigh", 0.0 },
  { "Hartley", 0.5688744 },
  { "Hartli", 0.0 },
  { "Hartlie", 0.0 },
  { "Hartly", 0.0 },
  { "Hartlyn", 0.0 },
  { "Hartlynn", 0.0 },
  { "Hartman", 1.0 },
  { "Hartsel", 1.0 },
  { "Hartsell", 1.0 },
  { "Hartwell", 1.0 },
  { "Hartzel", 1.0 },
  { "Hartzell", 1.0 },
  { "Haru", 0.6 },
  { "Harue", 0.0 },
  { "Haruka", 0.0 },
  { "Haruki", 1.0 },
  { "Haruko", 0.0 },
  { "Haruma", 1.0 },
  { "Harumi", 0.078947365 },
  { "Harun", 1.0 },
  { "Haruna", 0.0 },
  { "Haruno", 0.0 },
  { "Haruo", 1.0 },
  { "Harut", 1.0 },
  { "Haruto", 1.0 },
  { "Harutun", 1.0 },
  { "Harutyun", 1.0 },
  { "Haruye", 0.0 },
  { "Haruyo", 0.0 },
  { "Haruyoshi", 1.0 },
  { "Harvard", 1.0 },
  { "Harve", 1.0 },
  { "Harveen", 0.0 },
  { "Harveer", 1.0 },
  { "Harvel", 1.0 },
  { "Harvell", 1.0 },
  { "Harver", 1.0 },
  { "Harvest", 0.47990543 },
  { "Harvester", 1.0 },
  { "Harvetta", 0.0 },
  { "Harvey", 0.99419624 },
  { "Harvi", 0.0 },
  { "Harvie", 0.9860267 },
  { "Harvin", 0.92105263 },
  { "Harvir", 1.0 },
  { "Harvis", 1.0 },
  { "Harvy", 1.0 },
  { "Harwell", 1.0 },
  { "Harwood", 1.0 },
  { "Hary", 1.0 },
  { "Hasaan", 1.0 },
  { "Hasan", 1.0 },
  { "Hasana", 0.0 },
  { "Hasanah", 0.0 },
  { "Hasanat", 0.0 },
  { "Hasani", 0.9883475 },
  { "Hasaun", 1.0 },
  { "Hascal", 1.0 },
  { "Haseeb", 1.0 },
  { "Haseebullah", 1.0 },
  { "Haseem", 1.0 },
  { "Haseena", 0.0 },
  { "Hasel", 0.014778325 },
  { "Hasen", 1.0 },
  { "Haset", 0.0 },
  { "Hasheem", 1.0 },
  { "Hashem", 1.0 },
  { "Hashim", 1.0 },
  { "Hashir", 1.0 },
  { "Hashley", 0.0 },
  { "Hasib", 1.0 },
  { "Hasiel", 1.0 },
  { "Hasika", 0.0 },
  { "Hasim", 1.0 },
  { "Hasin", 1.0 },
  { "Hasina", 0.0 },
  { "Hasinah", 0.0 },
  { "Hasini", 0.0 },
  { "Hasir", 1.0 },
  { "Hasita", 0.0 },
  { "Hasitha", 0.0 },
  { "Haskel", 1.0 },
  { "Haskell", 0.9972588 },
  { "Hasker", 1.0 },
  { "Haskie", 1.0 },
  { "Haskle", 1.0 },
  { "Hasley", 0.0 },
  { "Hasly", 0.0 },
  { "Haslyn", 0.0 },
  { "Hasmik", 0.0 },
  { "Hasna", 0.0 },
  { "Hasnaa", 0.0 },
  { "Hasnain", 1.0 },
  { "Hason", 1.0 },
  { "Hassaan", 1.0 },
  { "Hassain", 1.0 },
  { "Hassam", 1.0 },
  { "Hassan", 0.9992346 },
  { "Hassana", 0.0 },
  { "Hassanah", 0.0 },
  { "Hassanatou", 0.0 },
  { "Hassane", 1.0 },
  { "Hassani", 1.0 },
  { "Hassel", 1.0 },
  { "Hassell", 1.0 },
  { "Hasseltine", 0.0 },
  { "Hassen", 1.0 },
  { "Hasset", 0.0 },
  { "Hassie", 0.00643915 },
  { "Hassiel", 1.0 },
  { "Hassiem", 1.0 },
  { "Hasson", 1.0 },
  { "Hasten", 1.0 },
  { "Hasti", 0.0 },
  { "Hastiin", 1.0 },
  { "Hastin", 1.0 },
  { "Hasting", 1.0 },
  { "Hastings", 0.8333333 },
  { "Haston", 1.0 },
  { "Hasty", 0.0 },
  { "Hasya", 0.0 },
  { "Hatch", 1.0 },
  { "Hatcher", 1.0 },
  { "Hatem", 1.0 },
  { "Hateya", 0.0 },
  { "Hathaway", 0.0 },
  { "Hather", 0.0 },
  { "Hatice", 0.0 },
  { "Hatim", 1.0 },
  { "Hatina", 0.0 },
  { "Hatley", 0.0 },
  { "Hatsue", 0.0 },
  { "Hatsuko", 0.0 },
  { "Hatsumi", 0.0 },
  { "Hatsuye", 0.0 },
  { "Hatsuyo", 0.0 },
  { "Hattan", 1.0 },
  { "Hatti", 0.0 },
  { "Hattie", 0.004990655 },
  { "Hatton", 1.0 },
  { "Hatty", 0.0 },
  { "Hattye", 0.0 },
  { "Hatziry", 0.0 },
  { "Hau", 0.85365856 },
  { "Haunani", 0.0 },
  { "Hava", 0.0 },
  { "Havah", 0.0 },
  { "Haval", 1.0 },
  { "Havala", 0.0 },
  { "Havan", 0.0 },
  { "Havana", 0.0 },
  { "Havanah", 0.0 },
  { "Havanna", 0.0 },
  { "Havannah", 0.0 },
  { "Havard", 1.0 },
  { "Haven", 0.2409184 },
  { "Havery", 1.0 },
  { "Havick", 1.0 },
  { "Havier", 1.0 },
  { "Havik", 1.0 },
  { "Havilah", 0.0 },
  { "Haviland", 0.0 },
  { "Havilland", 0.0 },
  { "Havin", 0.0 },
  { "Havis", 1.0 },
  { "Havish", 1.0 },
  { "Havisha", 0.0 },
  { "Havoc", 1.0 },
  { "Havok", 1.0 },
  { "Havya", 0.0 },
  { "Havyn", 0.06732118 },
  { "Havynn", 0.0 },
  { "Hawa", 0.0 },
  { "Hawah", 0.0 },
  { "Hawaii", 0.0 },
  { "Hawanatu", 0.0 },
  { "Hawanya", 0.0 },
  { "Haward", 1.0 },
  { "Hawi", 0.0 },
  { "Hawk", 1.0 },
  { "Hawke", 1.0 },
  { "Hawken", 1.0 },
  { "Hawkens", 1.0 },
  { "Hawkeye", 1.0 },
  { "Hawkin", 1.0 },
  { "Hawkins", 1.0 },
  { "Hawley", 0.7109005 },
  { "Hawo", 0.0 },
  { "Hawra", 0.0 },
  { "Hawraa", 0.0 },
  { "Hawthorn", 1.0 },
  { "Hawthorne", 0.9710145 },
  { "Hawwa", 0.0 },
  { "Hawwaa", 0.0 },
  { "Haxton", 1.0 },
  { "Hay", 1.0 },
  { "Haya", 0.0 },
  { "Hayaa", 0.0 },
  { "Hayaan", 1.0 },
  { "Hayah", 0.0 },
  { "Hayam", 0.0 },
  { "Hayat", 0.0 },
  { "Hayato", 1.0 },
  { "Haydan", 0.7479452 },
  { "Haydar", 1.0 },
  { "Hayde", 0.0 },
  { "Haydee", 0.0 },
  { "Hayden", 0.79512 },
  { "Haydenn", 0.23076923 },
  { "Hayder", 1.0 },
  { "Haydi", 0.0 },
  { "Haydin", 0.60633487 },
  { "Haydn", 0.8248472 },
  { "Haydon", 0.94222224 },
  { "Haydyn", 0.5201613 },
  { "Hayes", 0.96544033 },
  { "Haygan", 1.0 },
  { "Haygen", 0.91943127 },
  { "Hayk", 1.0 },
  { "Hayla", 0.0 },
  { "Haylah", 0.0 },
  { "Haylan", 0.0 },
  { "Hayle", 0.0 },
  { "Haylea", 0.0 },
  { "Hayleah", 0.0 },
  { "Haylee", 0.0007293148 },
  { "Hayleen", 0.0 },
  { "Haylei", 0.0 },
  { "Hayleigh", 0.0 },
  { "Haylen", 0.16594517 },
  { "Hayley", 0.00095445587 },
  { "Hayli", 0.0 },
  { "Haylie", 0.0 },
  { "Hayliee", 0.0 },
  { "Hayliegh", 0.0 },
  { "Haylin", 0.0 },
  { "Hayllie", 0.0 },
  { "Haylo", 0.0 },
  { "Hayly", 0.0 },
  { "Haylyn", 0.0 },
  { "Haylynn", 0.0 },
  { "Haymon", 1.0 },
  { "Haymond", 1.0 },
  { "Hayne", 1.0 },
  { "Haynes", 0.989339 },
  { "Haynie", 1.0 },
  { "Hayoon", 0.0 },
  { "Hayoung", 0.0 },
  { "Hays", 1.0 },
  { "Hayse", 1.0 },
  { "Hayslee", 0.0 },
  { "Hayson", 1.0 },
  { "Hayston", 1.0 },
  { "Haytham", 1.0 },
  { "Haythem", 1.0 },
  { "Hayven", 0.1729785 },
  { "Hayvin", 0.0 },
  { "Hayvn", 0.0 },
  { "Hayward", 1.0 },
  { "Haywood", 1.0 },
  { "Hayword", 1.0 },
  { "Hayyan", 1.0 },
  { "Hayz", 1.0 },
  { "Hayze", 1.0 },
  { "Hayzel", 0.0 },
  { "Hayzen", 1.0 },
  { "Hayzlee", 0.0 },
  { "Hayzlie", 0.0 },
  { "Hazael", 1.0 },
  { "Hazaiah", 1.0 },
  { "Hazal", 0.0 },
  { "Haze", 0.9587629 },
  { "Hazel", 0.010594325 },
  { "Hazelann", 0.0 },
  { "Hazele", 0.0 },
  { "Hazelee", 0.0 },
  { "Hazeleen", 0.0 },
  { "Hazeleigh", 0.0 },
  { "Hazelene", 0.0 },
  { "Hazelgrace", 0.0 },
  { "Hazeline", 0.0 },
  { "Hazell", 0.022222223 },
  { "Hazelle", 0.0 },
  { "Hazelmae", 0.0 },
  { "Hazelmarie", 0.0 },
  { "Hazelrose", 0.0 },
  { "Hazeltine", 0.0 },
  { "Hazely", 0.0 },
  { "Hazelyn", 0.0 },
  { "Hazelynn", 0.0 },
  { "Hazem", 1.0 },
  { "Hazen", 0.9751157 },
  { "Haziel", 0.99241275 },
  { "Hazim", 1.0 },
  { "Hazin", 1.0 },
  { "Haziq", 1.0 },
  { "Hazir", 1.0 },
  { "Hazle", 0.017423015 },
  { "Hazlee", 0.0 },
  { "Hazleigh", 0.0 },
  { "Hazley", 0.0 },
  { "Hazlie", 0.0 },
  { "Hazlyn", 0.0 },
  { "Hazlynn", 0.0 },
  { "Hazy", 0.0 },
  { "Hazyl", 0.0 },
  { "Hazyn", 1.0 },
  { "Hazzel", 0.0 },
  { "Hazzie", 1.0 },
  { "Heahter", 0.0 },
  { "Healani", 0.0 },
  { "Healey", 0.0 },
  { "Healy", 0.0 },
  { "Heang", 0.0 },
  { "Heard", 1.0 },
  { "Hearl", 1.0 },
  { "Hearld", 1.0 },
  { "Hearman", 1.0 },
  { "Hearold", 1.0 },
  { "Heart", 0.0 },
  { "Hearther", 0.0 },
  { "Heartlee", 0.0 },
  { "Heartley", 0.0 },
  { "Heartly", 0.0 },
  { "Heartlyn", 0.0 },
  { "Heartlynn", 0.0 },
  { "Heater", 0.0 },
  { "Heath", 0.99342704 },
  { "Heathcliff", 1.0 },
  { "Heathe", 0.32 },
  { "Heather", 0.0028186373 },
  { "Heatherann", 0.0 },
  { "Heatherlee", 0.0 },
  { "Heatherly", 0.0 },
  { "Heatherlyn", 0.0 },
  { "Heatherlynn", 0.0 },
  { "Heathermarie", 0.0 },
  { "Heathr", 0.0 },
  { "Heathre", 0.0 },
  { "Heathyr", 0.0 },
  { "Heaton", 1.0 },
  { "Heavan", 0.0 },
  { "Heaven", 0.01197407 },
  { "Heavenlee", 0.0 },
  { "Heavenlei", 0.0 },
  { "Heavenleigh", 0.0 },
  { "Heavenley", 0.0 },
  { "Heavenli", 0.0 },
  { "Heavenly", 0.0 },
  { "Heavenlyjoy", 0.0 },
  { "Heavenlyn", 0.0 },
  { "Heavenor", 0.0 },
  { "Heavin", 0.0 },
  { "Heavon", 0.0 },
  { "Heavyn", 0.0 },
  { "Heavynn", 0.0 },
  { "Heba", 0.0 },
  { "Hebah", 0.0 },
  { "Hebe", 0.0 },
  { "Heber", 1.0 },
  { "Hebert", 1.0 },
  { "Heberth", 1.0 },
  { "Heberto", 1.0 },
  { "Hebron", 0.9137931 },
  { "Hec", 1.0 },
  { "Hector", 0.995234 },
  { "Hedaya", 0.0 },
  { "Hedda", 0.0 },
  { "Heddie", 0.0 },
  { "Heddy", 0.0 },
  { "Heder", 1.0 },
  { "Hedgar", 1.0 },
  { "Hedi", 0.0 },
  { "Hedie", 0.0 },
  { "Hedieh", 0.0 },
  { "Hedit", 0.0 },
  { "Hedley", 1.0 },
  { "Hedrick", 1.0 },
  { "Hedvig", 0.0 },
  { "Hedwig", 0.0 },
  { "Hedwige", 0.0 },
  { "Hedy", 0.0 },
  { "Hee", 0.0 },
  { "Heeba", 0.0 },
  { "Heela", 0.0 },
  { "Heena", 0.0 },
  { "Heer", 0.0 },
  { "Heera", 0.0 },
  { "Heet", 1.0 },
  { "Heeya", 0.0 },
  { "Heflin", 1.0 },
  { "Hefziba", 0.0 },
  { "Heida", 0.0 },
  { "Heide", 0.0 },
  { "Heidee", 0.0 },
  { "Heidemarie", 0.0 },
  { "Heiden", 1.0 },
  { "Heidi", 0.0025437225 },
  { "Heidiann", 0.0 },
  { "Heidie", 0.0 },
  { "Heidimarie", 0.0 },
  { "Heidy", 0.0 },
  { "Heike", 0.0 },
  { "Heiko", 1.0 },
  { "Heiley", 0.0 },
  { "Heili", 0.0 },
  { "Heilly", 0.0 },
  { "Heily", 0.0 },
  { "Heilyn", 0.0 },
  { "Hein", 1.0 },
  { "Heiner", 1.0 },
  { "Heinrich", 1.0 },
  { "Heinz", 1.0 },
  { "Heiress", 0.0 },
  { "Heiry", 0.0 },
  { "Heisy", 0.0 },
  { "Heith", 1.0 },
  { "Heitor", 1.0 },
  { "Hektor", 1.0 },
  { "Hela", 0.0 },
  { "Heladio", 1.0 },
  { "Helaena", 0.0 },
  { "Helaina", 0.0 },
  { "Helaine", 0.0 },
  { "Helal", 1.0 },
  { "Helam", 1.0 },
  { "Helaman", 1.0 },
  { "Helan", 0.0 },
  { "Helana", 0.0 },
  { "Helane", 0.0 },
  { "Helayna", 0.0 },
  { "Helayne", 0.0 },
  { "Heldana", 0.0 },
  { "Helder", 1.0 },
  { "Heleana", 0.0 },
  { "Heleen", 0.0 },
  { "Heleena", 0.0 },
  { "Heleina", 0.0 },
  { "Helem", 0.0 },
  { "Helen", 0.0030412797 },
  { "Helena", 0.0 },
  { "Helenann", 0.0 },
  { "Helene", 0.0 },
  { "Helenmae", 0.0 },
  { "Helenmarie", 0.0 },
  { "Helenna", 0.0 },
  { "Heleyna", 0.0 },
  { "Helga", 0.0 },
  { "Helge", 1.0 },
  { "Heli", 0.11627907 },
  { "Helia", 0.0 },
  { "Heliana", 0.0 },
  { "Helin", 0.0 },
  { "Helina", 0.0 },
  { "Helio", 1.0 },
  { "Heliodoro", 1.0 },
  { "Helios", 1.0 },
  { "Helissa", 0.0 },
  { "Helius", 1.0 },
  { "Helix", 1.0 },
  { "Hellan", 0.0 },
  { "Hellen", 0.0 },
  { "Hellena", 0.0 },
  { "Hellene", 0.0 },
  { "Heller", 0.0 },
  { "Hellon", 0.0 },
  { "Helly", 0.0 },
  { "Helma", 0.0 },
  { "Helmar", 1.0 },
  { "Helmer", 1.0 },
  { "Helmi", 0.0 },
  { "Helmie", 0.0 },
  { "Helmut", 1.0 },
  { "Helmuth", 1.0 },
  { "Helo", 1.0 },
  { "Heloisa", 0.0 },
  { "Heloise", 0.0 },
  { "Helon", 0.007451565 },
  { "Helsea", 0.0 },
  { "Helton", 1.0 },
  { "Helvi", 0.0 },
  { "Helvie", 0.0 },
  { "Helyn", 0.0 },
  { "Helyne", 0.0 },
  { "Hema", 0.0 },
  { "Hemal", 1.0 },
  { "Hemali", 0.0 },
  { "Heman", 1.0 },
  { "Hemani", 0.0 },
  { "Hemant", 1.0 },
  { "Hemanth", 1.0 },
  { "Hemen", 0.0 },
  { "Hemerson", 1.0 },
  { "Hemi", 0.65957445 },
  { "Hemingway", 1.0 },
  { "Hemma", 0.0 },
  { "Hemza", 1.0 },
  { "Hena", 0.0 },
  { "Henach", 1.0 },
  { "Hence", 1.0 },
  { "Henchy", 0.0 },
  { "Hend", 0.0 },
  { "Hendel", 0.0 },
  { "Henderson", 1.0 },
  { "Hendley", 0.0 },
  { "Hendrex", 1.0 },
  { "Hendric", 1.0 },
  { "Hendrick", 1.0 },
  { "Hendricks", 1.0 },
  { "Hendrik", 1.0 },
  { "Hendrix", 0.94006896 },
  { "Hendrixx", 1.0 },
  { "Hendry", 1.0 },
  { "Hendryx", 1.0 },
  { "Hendy", 0.0 },
  { "Heneretta", 0.0 },
  { "Henerietta", 0.0 },
  { "Henery", 1.0 },
  { "Henesis", 0.0 },
  { "Henessey", 0.0 },
  { "Henessy", 0.0 },
  { "Henesy", 0.0 },
  { "Heng", 1.0 },
  { "Henil", 1.0 },
  { "Henlee", 0.0 },
  { "Henleigh", 0.0 },
  { "Henley", 0.23186034 },
  { "Henli", 0.0 },
  { "Henlie", 0.0 },
  { "Henly", 0.4347826 },
  { "Henna", 0.0 },
  { "Hennah", 0.0 },
  { "Hennesey", 0.0 },
  { "Hennesie", 0.0 },
  { "Hennessey", 0.0 },
  { "Hennessy", 0.045045044 },
  { "Hennesy", 0.0 },
  { "Hennie", 0.0 },
  { "Henning", 1.0 },
  { "Hennley", 0.0 },
  { "Hennry", 1.0 },
  { "Henny", 0.086181276 },
  { "Henoc", 1.0 },
  { "Henoch", 1.0 },
  { "Henock", 1.0 },
  { "Henok", 1.0 },
  { "Henon", 1.0 },
  { "Henos", 1.0 },
  { "Henreitta", 0.0 },
  { "Henrene", 0.0 },
  { "Henretta", 0.0 },
  { "Henretter", 0.0 },
  { "Henrettia", 0.0 },
  { "Henrey", 1.0 },
  { "Henri", 0.8714256 },
  { "Henrick", 1.0 },
  { "Henrie", 0.28169015 },
  { "Henriella", 0.0 },
  { "Henrietta", 0.0010252972 },
  { "Henriette", 0.0 },
  { "Henrik", 1.0 },
  { "Henrika", 0.0 },
  { "Henrine", 0.0 },
  { "Henrique", 1.0 },
  { "Henritta", 0.0 },
  { "Henrri", 1.0 },
  { "Henrry", 1.0 },
  { "Henry", 0.9933173 },
  { "Henryetta", 0.0 },
  { "Henryk", 1.0 },
  { "Henryka", 0.0 },
  { "Hensel", 1.0 },
  { "Henslee", 0.0 },
  { "Hensleigh", 0.0 },
  { "Hensley", 0.14136125 },
  { "Henson", 1.0 },
  { "Henton", 1.0 },
  { "Henya", 0.0 },
  { "Henzlee", 0.0 },
  { "Henzley", 0.0 },
  { "Hephzibah", 0.0 },
  { "Her", 1.0 },
  { "Hera", 0.0 },
  { "Heraclio", 1.0 },
  { "Herald", 1.0 },
  { "Heraldo", 1.0 },
  { "Heran", 0.0 },
  { "Herb", 1.0 },
  { "Herber", 1.0 },
  { "Herbert", 0.995118 },
  { "Herberta", 0.0 },
  { "Herberth", 1.0 },
  { "Herberto", 1.0 },
  { "Herbet", 1.0 },
  { "Herbey", 1.0 },
  { "Herbie", 1.0 },
  { "Herby", 1.0 },
  { "Herchel", 1.0 },
  { "Herchell", 1.0 },
  { "Hercilia", 0.0 },
  { "Herculano", 1.0 },
  { "Hercules", 1.0 },
  { "Herdis", 1.0 },
  { "Heri", 1.0 },
  { "Heriberta", 0.0 },
  { "Heriberto", 0.9983519 },
  { "Herica", 0.0 },
  { "Herick", 1.0 },
  { "Herik", 1.0 },
  { "Herika", 0.0 },
  { "Herlaine", 0.0 },
  { "Herlane", 0.0 },
  { "Herlene", 0.0 },
  { "Herley", 1.0 },
  { "Herlin", 1.0 },
  { "Herlinda", 0.0 },
  { "Herline", 0.0 },
  { "Herma", 0.0 },
  { "Hermalinda", 0.0 },
  { "Herman", 0.99416375 },
  { "Hermance", 0.0 },
  { "Hermanda", 0.0 },
  { "Hermania", 0.0 },
  { "Hermann", 1.0 },
  { "Hermas", 1.0 },
  { "Hermela", 0.0 },
  { "Hermelinda", 0.0 },
  { "Hermelindo", 1.0 },
  { "Hermen", 1.0 },
  { "Hermena", 0.0 },
  { "Hermene", 0.0 },
  { "Hermenegildo", 1.0 },
  { "Hermenia", 0.0 },
  { "Hermes", 1.0 },
  { "Hermia", 0.0 },
  { "Hermie", 0.03785489 },
  { "Hermila", 0.0 },
  { "Hermilinda", 0.0 },
  { "Hermilo", 1.0 },
  { "Hermina", 0.0 },
  { "Hermine", 0.0 },
  { "Herminia", 0.0 },
  { "Herminio", 1.0 },
  { "Hermino", 1.0 },
  { "Hermione", 0.0 },
  { "Hermit", 1.0 },
  { "Hermoine", 0.0 },
  { "Hermon", 0.99097747 },
  { "Hermond", 1.0 },
  { "Hermonie", 0.0 },
  { "Hernaldo", 1.0 },
  { "Hernan", 1.0 },
  { "Hernandez", 1.0 },
  { "Hernando", 1.0 },
  { "Herndon", 1.0 },
  { "Hernesto", 1.0 },
  { "Herney", 1.0 },
  { "Herny", 1.0 },
  { "Hero", 0.6412777 },
  { "Herod", 1.0 },
  { "Herold", 1.0 },
  { "Heron", 0.9905123 },
  { "Herrel", 1.0 },
  { "Herrell", 1.0 },
  { "Herrick", 1.0 },
  { "Herron", 1.0 },
  { "Herry", 1.0 },
  { "Hersch", 1.0 },
  { "Herschal", 1.0 },
  { "Herschel", 1.0 },
  { "Herschell", 1.0 },
  { "Hersel", 1.0 },
  { "Hersey", 1.0 },
  { "Hersh", 1.0 },
  { "Hershal", 1.0 },
  { "Hershall", 1.0 },
  { "Hershel", 0.99949807 },
  { "Hershell", 1.0 },
  { "Hershey", 1.0 },
  { "Hershy", 1.0 },
  { "Hersie", 1.0 },
  { "Herson", 1.0 },
  { "Herta", 0.0 },
  { "Hertha", 0.0 },
  { "Hertis", 1.0 },
  { "Heru", 1.0 },
  { "Herve", 1.0 },
  { "Hervey", 1.0 },
  { "Hervie", 1.0 },
  { "Hervin", 1.0 },
  { "Hervy", 1.0 },
  { "Hery", 1.0 },
  { "Hesham", 1.0 },
  { "Hesher", 1.0 },
  { "Heshimu", 1.0 },
  { "Heshy", 1.0 },
  { "Hesper", 0.0 },
  { "Hess", 1.0 },
  { "Hessa", 0.0 },
  { "Hessel", 1.0 },
  { "Hessie", 0.014109347 },
  { "Hesston", 1.0 },
  { "Hesta", 0.0 },
  { "Hestel", 0.0 },
  { "Hester", 0.036416654 },
  { "Hestia", 0.0 },
  { "Heston", 1.0 },
  { "Het", 1.0 },
  { "Hetal", 0.0 },
  { "Hether", 0.0 },
  { "Hettie", 0.0 },
  { "Hetty", 0.0 },
  { "Hettye", 0.0 },
  { "Hetvi", 0.0 },
  { "Hevan", 0.0 },
  { "Heven", 0.0 },
  { "Hever", 1.0 },
  { "Hevin", 0.0 },
  { "Hevyn", 0.0 },
  { "Hewan", 0.0 },
  { "Hewell", 1.0 },
  { "Hewey", 1.0 },
  { "Hewitt", 1.0 },
  { "Hewlett", 1.0 },
  { "Heyab", 0.0 },
  { "Heyam", 0.0 },
  { "Heydan", 1.0 },
  { "Heyden", 1.0 },
  { "Heydi", 0.0 },
  { "Heydy", 0.0 },
  { "Heylee", 0.0 },
  { "Heylen", 0.0 },
  { "Heyley", 0.0 },
  { "Heyli", 0.0 },
  { "Heylie", 0.0 },
  { "Heylin", 0.0 },
  { "Heymi", 0.0 },
  { "Heysel", 0.0 },
  { "Heyward", 1.0 },
  { "Heywood", 1.0 },
  { "Hezakiah", 1.0 },
  { "Hezeki", 1.0 },
  { "Hezekiah", 0.99924606 },
  { "Hezekiel", 1.0 },
  { "Hezekyah", 1.0 },
  { "Hezikiah", 1.0 },
  { "Hezkiah", 1.0 },
  { "Hezron", 1.0 },
  { "Hezzie", 1.0 },
  { "Hiatt", 1.0 },
  { "Hiawatha", 0.7538712 },
  { "Hiba", 0.0 },
  { "Hibah", 0.0 },
  { "Hibaq", 0.0 },
  { "Hibba", 0.0 },
  { "Hibbard", 1.0 },
  { "Hibo", 0.0 },
  { "Hicham", 1.0 },
  { "Hickman", 1.0 },
  { "Hickory", 1.0 },
  { "Hicks", 1.0 },
  { "Hickson", 1.0 },
  { "Hidaya", 0.0 },
  { "Hidayah", 0.0 },
  { "Hideki", 1.0 },
  { "Hideko", 0.0 },
  { "Hidemi", 1.0 },
  { "Hideo", 1.0 },
  { "Hidi", 0.0 },
  { "Hidie", 0.0 },
  { "Hiede", 0.0 },
  { "Hiedi", 0.0 },
  { "Hien", 0.48259494 },
  { "Hiep", 1.0 },
  { "Hieu", 0.9655172 },
  { "Hifza", 0.0 },
  { "Higinia", 0.0 },
  { "Higinio", 1.0 },
  { "Hiiaka", 0.0 },
  { "Hiilani", 0.0 },
  { "Hiilei", 0.0 },
  { "Hijinio", 1.0 },
  { "Hikari", 0.0 },
  { "Hikaru", 0.8888889 },
  { "Hikeem", 1.0 },
  { "Hikma", 0.0 },
  { "Hikmah", 0.0 },
  { "Hila", 0.0 },
  { "Hilah", 0.0 },
  { "Hilaire", 0.6041667 },
  { "Hilal", 0.33898306 },
  { "Hilaree", 0.0 },
  { "Hilari", 0.0 },
  { "Hilaria", 0.0 },
  { "Hilarie", 0.0 },
  { "Hilario", 1.0 },
  { "Hilarion", 1.0 },
  { "Hilary", 0.084003985 },
  { "Hilbert", 1.0 },
  { "Hilberto", 1.0 },
  { "Hilburn", 1.0 },
  { "Hilda", 0.00226631 },
  { "Hildagard", 0.0 },
  { "Hildagarde", 0.0 },
  { "Hildah", 0.0 },
  { "Hildana", 0.0 },
  { "Hilde", 0.0 },
  { "Hildebrando", 1.0 },
  { "Hildegard", 0.0 },
  { "Hildegarde", 0.0 },
  { "Hilder", 0.16129032 },
  { "Hildia", 0.0 },
  { "Hildie", 0.0 },
  { "Hilding", 1.0 },
  { "Hildon", 1.0 },
  { "Hildra", 0.0 },
  { "Hildred", 0.14872521 },
  { "Hildreth", 0.10948081 },
  { "Hildur", 0.0 },
  { "Hildy", 0.0 },
  { "Hilery", 0.66972476 },
  { "Hiley", 0.0 },
  { "Hilia", 0.0 },
  { "Hiliana", 0.0 },
  { "Hiliary", 0.0 },
  { "Hilinai", 0.0 },
  { "Hilja", 0.0 },
  { "Hill", 1.0 },
  { "Hilla", 0.0 },
  { "Hillard", 1.0 },
  { "Hillaree", 0.0 },
  { "Hillarey", 0.0 },
  { "Hillari", 0.0 },
  { "Hillarie", 0.0 },
  { "Hillary", 0.042437285 },
  { "Hillel", 1.0 },
  { "Hillery", 0.50301206 },
  { "Hilliard", 1.0 },
  { "Hilliary", 0.016233766 },
  { "Hillie", 1.0 },
  { "Hillip", 1.0 },
  { "Hillis", 0.9690476 },
  { "Hillman", 1.0 },
  { "Hillory", 0.18518518 },
  { "Hilma", 0.0 },
  { "Hilman", 1.0 },
  { "Hilmar", 1.0 },
  { "Hilmer", 1.0 },
  { "Hilmon", 1.0 },
  { "Hilo", 1.0 },
  { "Hilrey", 1.0 },
  { "Hilry", 1.0 },
  { "Hilton", 0.99615157 },
  { "Hilyard", 1.0 },
  { "Hima", 0.0 },
  { "Himani", 0.0 },
  { "Himansh", 1.0 },
  { "Himanshu", 1.0 },
  { "Himari", 0.0 },
  { "Himmat", 1.0 },
  { "Hina", 0.0 },
  { "Hinaea", 0.0 },
  { "Hinako", 0.0 },
  { "Hinal", 0.0 },
  { "Hinami", 0.0 },
  { "Hinano", 0.0 },
  { "Hinata", 0.040268455 },
  { "Hinatea", 0.0 },
  { "Hinckley", 1.0 },
  { "Hind", 0.0 },
  { "Hinda", 0.0 },
  { "Hindel", 0.0 },
  { "Hindy", 0.0 },
  { "Hines", 1.0 },
  { "Hing", 1.0 },
  { "Hinlee", 0.0 },
  { "Hinley", 0.0 },
  { "Hinsley", 0.0 },
  { "Hinson", 1.0 },
  { "Hinton", 1.0 },
  { "Hipolita", 0.0 },
  { "Hipolito", 1.0 },
  { "Hira", 0.0 },
  { "Hirah", 0.0 },
  { "Hiral", 0.0 },
  { "Hiram", 1.0 },
  { "Hiran", 1.0 },
  { "Hiren", 1.0 },
  { "Hirma", 0.0 },
  { "Hiro", 0.98759305 },
  { "Hiroaki", 1.0 },
  { "Hiroki", 1.0 },
  { "Hiroko", 0.0 },
  { "Hiromi", 0.066390045 },
  { "Hiromu", 1.0 },
  { "Hiromy", 0.0 },
  { "Hiroshi", 1.0 },
  { "Hiroto", 1.0 },
  { "Hiroyuki", 1.0 },
  { "Hirsch", 1.0 },
  { "Hirsh", 1.0 },
  { "Hirva", 0.0 },
  { "Hirvin", 1.0 },
  { "Hirving", 1.0 },
  { "Hisa", 0.0 },
  { "Hisae", 0.0 },
  { "Hisako", 0.0 },
  { "Hisao", 1.0 },
  { "Hisashi", 1.0 },
  { "Hisaye", 0.0 },
  { "Hisayo", 0.0 },
  { "Hisela", 0.0 },
  { "Hishaam", 1.0 },
  { "Hisham", 1.0 },
  { "Hiten", 1.0 },
  { "Hitesh", 1.0 },
  { "Hitha", 0.0 },
  { "Hitney", 0.0 },
  { "Hitomi", 0.0 },
  { "Hitoshi", 1.0 },
  { "Hitzel", 0.0 },
  { "Hiwot", 0.0 },
  { "Hixie", 0.0 },
  { "Hixon", 1.0 },
  { "Hiya", 0.0 },
  { "Hiyab", 0.16666667 },
  { "Hiyam", 0.0 },
  { "Hiyan", 1.0 },
  { "Hjalmar", 1.0 },
  { "Hjalmer", 1.0 },
  { "Hjordis", 0.0 },
  { "Hla", 0.0 },
  { "Hlee", 0.0 },
  { "Hli", 0.0 },
  { "Ho", 1.0 },
  { "Hoa", 0.4924812 },
  { "Hoai", 0.85365856 },
  { "Hoan", 1.0 },
  { "Hoang", 0.9351145 },
  { "Hoarce", 1.0 },
  { "Hobart", 1.0 },
  { "Hobbes", 1.0 },
  { "Hobbie", 1.0 },
  { "Hobbs", 1.0 },
  { "Hobby", 1.0 },
  { "Hobert", 1.0 },
  { "Hobie", 1.0 },
  { "Hobson", 1.0 },
  { "Hoby", 1.0 },
  { "Hoda", 0.0 },
  { "Hodalis", 0.0 },
  { "Hodan", 0.0 },
  { "Hodari", 1.0 },
  { "Hodaya", 0.0 },
  { "Hodge", 1.0 },
  { "Hodges", 1.0 },
  { "Hoffman", 1.0 },
  { "Hogan", 1.0 },
  { "Hoke", 1.0 },
  { "Hoku", 1.0 },
  { "Hokulani", 0.0 },
  { "Holbert", 1.0 },
  { "Holbrook", 1.0 },
  { "Holdan", 1.0 },
  { "Holden", 0.9925496 },
  { "Holder", 1.0 },
  { "Holdin", 1.0 },
  { "Holdon", 1.0 },
  { "Holdyn", 0.94033414 },
  { "Holger", 1.0 },
  { "Holiday", 0.0 },
  { "Hollace", 0.06017192 },
  { "Hollan", 0.24770643 },
  { "Holland", 0.37309605 },
  { "Holle", 0.0 },
  { "Hollee", 0.0 },
  { "Holleigh", 0.0 },
  { "Hollen", 0.0 },
  { "Holley", 0.047419805 },
  { "Holli", 0.0005805852 },
  { "Holliann", 0.0 },
  { "Hollianne", 0.0 },
  { "Hollice", 0.71428573 },
  { "Holliday", 0.0 },
  { "Hollie", 0.07536307 },
  { "Hollin", 0.0 },
  { "Hollis", 0.7761243 },
  { "Hollister", 0.7706422 },
  { "Holloway", 1.0 },
  { "Holly", 0.0076759467 },
  { "Hollyann", 0.0 },
  { "Hollyanne", 0.0 },
  { "Hollye", 0.0 },
  { "Hollylynn", 0.0 },
  { "Hollymarie", 0.0 },
  { "Hollyn", 0.0 },
  { "Hollynd", 0.0 },
  { "Hollynn", 0.0 },
  { "Holman", 1.0 },
  { "Holmer", 1.0 },
  { "Holmes", 1.0 },
  { "Holsey", 1.0 },
  { "Holsten", 1.0 },
  { "Holston", 1.0 },
  { "Holt", 1.0 },
  { "Holten", 1.0 },
  { "Holter", 1.0 },
  { "Holton", 1.0 },
  { "Holy", 0.057471264 },
  { "Holyn", 0.0 },
  { "Homar", 1.0 },
  { "Homas", 1.0 },
  { "Hombre", 1.0 },
  { "Homer", 0.9939843 },
  { "Homero", 1.0 },
  { "Hommer", 1.0 },
  { "Hommy", 1.0 },
  { "Hondo", 1.0 },
  { "Honest", 0.3951613 },
  { "Honestee", 0.0 },
  { "Honesti", 0.0 },
  { "Honestie", 0.0 },
  { "Honestii", 0.0 },
  { "Honesty", 0.0 },
  { "Honey", 0.0 },
  { "Hong", 0.30448222 },
  { "Hongan", 0.0 },
  { "Hongyu", 1.0 },
  { "Honi", 0.0 },
  { "Honie", 0.0 },
  { "Honoka", 0.0 },
  { "Honor", 0.18949687 },
  { "Honora", 0.0 },
  { "Honorae", 0.0 },
  { "Honorato", 1.0 },
  { "Honore", 0.10714286 },
  { "Honoria", 0.0 },
  { "Honorine", 0.0 },
  { "Honorio", 1.0 },
  { "Honour", 0.1978022 },
  { "Hood", 1.0 },
  { "Hooker", 1.0 },
  { "Hooman", 1.0 },
  { "Hooper", 1.0 },
  { "Hoor", 0.0 },
  { "Hoorain", 0.0 },
  { "Hooria", 0.0 },
  { "Hooriya", 0.0 },
  { "Hoover", 0.9937556 },
  { "Hope", 0.005770892 },
  { "Hopelyn", 0.0 },
  { "Hopelynn", 0.0 },
  { "Hopemarie", 0.0 },
  { "Hopeton", 1.0 },
  { "Hopi", 0.0 },
  { "Hopie", 0.0 },
  { "Hopper", 1.0 },
  { "Hopson", 1.0 },
  { "Horace", 0.9962711 },
  { "Horacio", 1.0 },
  { "Horald", 1.0 },
  { "Horatio", 1.0 },
  { "Horeb", 1.0 },
  { "Horice", 1.0 },
  { "Horizon", 0.0 },
  { "Horlando", 1.0 },
  { "Horold", 1.0 },
  { "Horrace", 1.0 },
  { "Horris", 1.0 },
  { "Horst", 1.0 },
  { "Hortence", 0.0 },
  { "Hortencia", 0.0 },
  { "Hortense", 0.0 },
  { "Hortensia", 0.0 },
  { "Horton", 1.0 },
  { "Horus", 1.0 },
  { "Hosam", 1.0 },
  { "Hosanna", 0.0 },
  { "Hosannah", 0.0 },
  { "Hoscar", 1.0 },
  { "Hose", 1.0 },
  { "Hosea", 0.9959799 },
  { "Hosey", 1.0 },
  { "Hoshi", 0.0 },
  { "Hosia", 1.0 },
  { "Hosie", 0.99114335 },
  { "Hoskie", 1.0 },
  { "Hoss", 1.0 },
  { "Hossain", 1.0 },
  { "Hossam", 1.0 },
  { "Hossein", 1.0 },
  { "Hosteen", 1.0 },
  { "Hoston", 1.0 },
  { "Houa", 0.30384615 },
  { "Houda", 0.0 },
  { "Houghton", 1.0 },
  { "Housten", 1.0 },
  { "Houstin", 1.0 },
  { "Houston", 0.9811058 },
  { "Hovanes", 1.0 },
  { "Hovannes", 1.0 },
  { "Hover", 1.0 },
  { "Hovey", 1.0 },
  { "Hovhannes", 1.0 },
  { "Hovie", 1.0 },
  { "Hovig", 1.0 },
  { "Hovik", 1.0 },
  { "Hovsep", 1.0 },
  { "Howard", 0.9951583 },
  { "Howardine", 0.0 },
  { "Howe", 1.0 },
  { "Howell", 1.0 },
  { "Howie", 1.0 },
  { "Howland", 1.0 },
  { "Hoy", 1.0 },
  { "Hoyal", 1.0 },
  { "Hoyd", 1.0 },
  { "Hoye", 1.0 },
  { "Hoyet", 1.0 },
  { "Hoyett", 1.0 },
  { "Hoyle", 1.0 },
  { "Hoyt", 0.9987318 },
  { "Hoyte", 1.0 },
  { "Hoytt", 1.0 },
  { "Hozel", 0.0 },
  { "Hozie", 1.0 },
  { "Hrach", 1.0 },
  { "Hrag", 1.0 },
  { "Hrehaan", 1.0 },
  { "Hridaan", 1.0 },
  { "Hridan", 1.0 },
  { "Hriday", 1.0 },
  { "Hridhaan", 1.0 },
  { "Hridya", 0.0 },
  { "Hrihaan", 1.0 },
  { "Hripsime", 0.0 },
  { "Hrisha", 0.0 },
  { "Hrishi", 1.0 },
  { "Hrishik", 1.0 },
  { "Hrishikesh", 1.0 },
  { "Hristina", 0.0 },
  { "Hristine", 0.0 },
  { "Hristo", 1.0 },
  { "Hristopher", 1.0 },
  { "Hristos", 1.0 },
  { "Hrithik", 1.0 },
  { "Hrithika", 0.0 },
  { "Hritik", 1.0 },
  { "Hritika", 0.0 },
  { "Hriyaan", 1.0 },
  { "Hsa", 1.0 },
  { "Hser", 0.31746033 },
  { "Htoo", 1.0 },
  { "Hu", 1.0 },
  { "Huai", 0.0 },
  { "Huan", 1.0 },
  { "Huascar", 1.0 },
  { "Hub", 1.0 },
  { "Hubart", 1.0 },
  { "Hubbard", 1.0 },
  { "Hubbert", 1.0 },
  { "Hubbie", 0.0 },
  { "Huber", 1.0 },
  { "Hubert", 0.9967114 },
  { "Huberta", 0.0 },
  { "Hubertine", 0.0 },
  { "Huberto", 1.0 },
  { "Hubery", 1.0 },
  { "Hubie", 1.0 },
  { "Huburt", 1.0 },
  { "Huck", 1.0 },
  { "Huckleberry", 1.0 },
  { "Hucksley", 1.0 },
  { "Huckson", 1.0 },
  { "Huckston", 1.0 },
  { "Hud", 1.0 },
  { "Huda", 0.0 },
  { "Hudaifa", 1.0 },
  { "Hudayfa", 1.0 },
  { "Hudayfi", 1.0 },
  { "Hudes", 0.0 },
  { "Hudeyfa", 1.0 },
  { "Hudeyfi", 1.0 },
  { "Hudhayfah", 1.0 },
  { "Hudie", 1.0 },
  { "Hudis", 0.0 },
  { "Hudsen", 0.96507937 },
  { "Hudson", 0.9804712 },
  { "Hudsyn", 0.40681818 },
  { "Hudsynn", 0.0 },
  { "Hudy", 0.0 },
  { "Hue", 0.83905965 },
  { "Huebert", 1.0 },
  { "Huel", 1.0 },
  { "Huell", 1.0 },
  { "Hueston", 1.0 },
  { "Huey", 0.9992643 },
  { "Hufsa", 0.0 },
  { "Hugh", 0.9956476 },
  { "Hughe", 1.0 },
  { "Hughes", 1.0 },
  { "Hughey", 1.0 },
  { "Hughie", 1.0 },
  { "Hughlene", 0.0 },
  { "Hughlon", 1.0 },
  { "Hughston", 1.0 },
  { "Hughy", 1.0 },
  { "Hugo", 0.99902356 },
  { "Hugues", 1.0 },
  { "Huguette", 0.0 },
  { "Hui", 0.0 },
  { "Huie", 1.0 },
  { "Hula", 0.0 },
  { "Hulali", 0.0 },
  { "Hulan", 1.0 },
  { "Hulbert", 1.0 },
  { "Hulda", 0.0 },
  { "Huldah", 0.0 },
  { "Huldia", 0.0 },
  { "Hulen", 1.0 },
  { "Hulene", 0.0 },
  { "Hulet", 1.0 },
  { "Hulett", 1.0 },
  { "Huley", 1.0 },
  { "Hulices", 1.0 },
  { "Hulin", 1.0 },
  { "Hulises", 1.0 },
  { "Hulon", 1.0 },
  { "Huma", 0.0 },
  { "Humaira", 0.0 },
  { "Humayra", 0.0 },
  { "Humbert", 1.0 },
  { "Humberto", 0.99937624 },
  { "Hume", 1.0 },
  { "Humeyra", 0.0 },
  { "Humna", 0.0 },
  { "Humphery", 1.0 },
  { "Humphrey", 1.0 },
  { "Humza", 1.0 },
  { "Humzah", 1.0 },
  { "Hunberto", 1.0 },
  { "Huner", 1.0 },
  { "Hung", 1.0 },
  { "Hunner", 1.0 },
  { "Hunnie", 0.0 },
  { "Hunny", 0.0 },
  { "Hunt", 1.0 },
  { "Hunter", 0.95146394 },
  { "Huntington", 1.0 },
  { "Huntlee", 0.48076922 },
  { "Huntleigh", 0.0 },
  { "Huntley", 0.7375643 },
  { "Huntter", 1.0 },
  { "Huntur", 1.0 },
  { "Huntyr", 0.27450982 },
  { "Huong", 0.0 },
  { "Hurain", 0.0 },
  { "Hurbert", 1.0 },
  { "Hurchel", 1.0 },
  { "Hurdis", 1.0 },
  { "Hurel", 1.0 },
  { "Huriel", 1.0 },
  { "Hurl", 1.0 },
  { "Hurley", 0.97141737 },
  { "Hurlie", 1.0 },
  { "Hurman", 1.0 },
  { "Hurmon", 1.0 },
  { "Huron", 1.0 },
  { "Hurrem", 0.0 },
  { "Hurschel", 1.0 },
  { "Hursel", 1.0 },
  { "Hurshel", 1.0 },
  { "Hurshell", 1.0 },
  { "Hurst", 1.0 },
  { "Hurston", 1.0 },
  { "Hurtha", 0.0 },
  { "Hurtis", 1.0 },
  { "Husai", 1.0 },
  { "Husain", 1.0 },
  { "Husaina", 0.0 },
  { "Husam", 1.0 },
  { "Husani", 1.0 },
  { "Husayn", 1.0 },
  { "Husein", 1.0 },
  { "Husna", 0.0 },
  { "Husnain", 1.0 },
  { "Hussain", 1.0 },
  { "Hussam", 1.0 },
  { "Hussan", 1.0 },
  { "Hussein", 1.0 },
  { "Hussen", 1.0 },
  { "Hussien", 1.0 },
  { "Hussin", 1.0 },
  { "Huston", 1.0 },
  { "Hutch", 1.0 },
  { "Hutchins", 1.0 },
  { "Hutchinson", 1.0 },
  { "Hutchison", 1.0 },
  { "Hutson", 1.0 },
  { "Hutton", 0.9581994 },
  { "Hux", 1.0 },
  { "Huxlee", 0.6 },
  { "Huxleigh", 0.0 },
  { "Huxley", 0.9155722 },
  { "Huxlie", 0.0 },
  { "Huxon", 1.0 },
  { "Huxton", 1.0 },
  { "Huy", 1.0 },
  { "Huyen", 0.0 },
  { "Huynh", 1.0 },
  { "Huzaifa", 1.0 },
  { "Huzaifah", 1.0 },
  { "Hy", 1.0 },
  { "Hyacinth", 0.0 },
  { "Hyatt", 0.9131737 },
  { "Hyde", 1.0 },
  { "Hydea", 0.0 },
  { "Hydee", 0.0 },
  { "Hydeia", 0.0 },
  { "Hyden", 1.0 },
  { "Hyder", 1.0 },
  { "Hydi", 0.0 },
  { "Hydia", 0.0 },
  { "Hydiah", 0.0 },
  { "Hydie", 0.0 },
  { "Hydiea", 0.0 },
  { "Hydiyah", 0.0 },
  { "Hye", 0.0 },
  { "Hykeem", 1.0 },
  { "Hykeim", 1.0 },
  { "Hyla", 0.0 },
  { "Hylan", 1.0 },
  { "Hyland", 0.9354839 },
  { "Hylda", 0.0 },
  { "Hyle", 1.0 },
  { "Hylee", 0.0 },
  { "Hyleigh", 0.0 },
  { "Hylie", 0.0 },
  { "Hylton", 1.0 },
  { "Hyman", 1.0 },
  { "Hymen", 1.0 },
  { "Hymie", 1.0 },
  { "Hynlee", 0.0 },
  { "Hynleigh", 0.0 },
  { "Hyon", 1.0 },
  { "Hypatia", 0.0 },
  { "Hyram", 1.0 },
  { "Hyrum", 1.0 },
  { "Hyson", 1.0 },
  { "Hytham", 1.0 },
  { "Hyun", 0.6102088 },
  { "Hyung", 1.0 },
  { "Ia", 0.0 },
  { "Iaan", 1.0 },
  { "Iago", 1.0 },
  { "Iah", 0.0 },
  { "Iahn", 1.0 },
  { "Iain", 1.0 },
  { "Iaisha", 0.0 },
  { "Iakona", 1.0 },
  { "Ialene", 0.0 },
  { "Ialiyah", 0.0 },
  { "Iam", 1.0 },
  { "Ian", 0.9966133 },
  { "Iana", 0.0 },
  { "Ianah", 0.0 },
  { "Iancarlo", 1.0 },
  { "Ianmichael", 1.0 },
  { "Iann", 1.0 },
  { "Ianna", 0.0 },
  { "Iannah", 0.0 },
  { "Iantha", 0.0 },
  { "Ianthe", 0.0 },
  { "Ianthia", 0.0 },
  { "Ianto", 1.0 },
  { "Iara", 0.0 },
  { "Iasha", 0.0 },
  { "Iashia", 0.0 },
  { "Iasia", 0.0 },
  { "Iasiah", 0.9066667 },
  { "Iason", 1.0 },
  { "Iassac", 1.0 },
  { "Iayana", 0.0 },
  { "Iba", 0.0 },
  { "Ibaad", 1.0 },
  { "Ibad", 1.0 },
  { "Iban", 1.0 },
  { "Ibbie", 0.0 },
  { "Ibe", 1.0 },
  { "Ibet", 0.0 },
  { "Ibeth", 0.0 },
  { "Ibette", 0.0 },
  { "Ibhan", 1.0 },
  { "Ibin", 1.0 },
  { "Ibis", 0.17391305 },
  { "Ibiza", 0.0 },
  { "Ibn", 1.0 },
  { "Ibon", 0.0 },
  { "Ibraaheem", 1.0 },
  { "Ibraham", 1.0 },
  { "Ibraheem", 1.0 },
  { "Ibraheim", 1.0 },
  { "Ibrahem", 1.0 },
  { "Ibrahim", 1.0 },
  { "Ibrahima", 1.0 },
  { "Ibrohim", 1.0 },
  { "Ibtihaj", 0.0 },
  { "Ibtihal", 0.0 },
  { "Ibtisam", 0.0 },
  { "Ibukunoluwa", 0.5686275 },
  { "Ica", 0.0 },
  { "Icarus", 1.0 },
  { "Icee", 0.0 },
  { "Iceis", 0.0 },
  { "Icel", 0.0 },
  { "Icela", 0.0 },
  { "Iceland", 0.0 },
  { "Icelean", 0.0 },
  { "Icelene", 0.0 },
  { "Icely", 0.0 },
  { "Icelyn", 0.0 },
  { "Icelynn", 0.0 },
  { "Iceola", 0.0 },
  { "Ices", 0.0 },
  { "Icesis", 0.0 },
  { "Icess", 0.0 },
  { "Icesys", 0.0 },
  { "Icey", 0.0 },
  { "Ichael", 1.0 },
  { "Ichard", 1.0 },
  { "Ichelle", 0.0 },
  { "Ichigo", 1.0 },
  { "Ichiro", 1.0 },
  { "Icholas", 1.0 },
  { "Icia", 0.0 },
  { "Icie", 0.0 },
  { "Icis", 0.0 },
  { "Iciss", 0.0 },
  { "Icker", 1.0 },
  { "Icle", 0.0 },
  { "Icole", 0.0 },
  { "Icsel", 0.0 },
  { "Icsis", 0.0 },
  { "Icy", 0.0 },
  { "Icysis", 0.0 },
  { "Icyss", 0.0 },
  { "Ida", 0.0041015646 },
  { "Idabel", 0.0 },
  { "Idabell", 0.0 },
  { "Idabelle", 0.0 },
  { "Idah", 0.0 },
  { "Idahlia", 0.0 },
  { "Idalee", 0.0 },
  { "Idalene", 0.0 },
  { "Idali", 0.0 },
  { "Idalia", 0.0 },
  { "Idalie", 0.0 },
  { "Idalina", 0.0 },
  { "Idalis", 0.0 },
  { "Idaliz", 0.0 },
  { "Idalmis", 0.0 },
  { "Idalou", 0.0 },
  { "Idaly", 0.0 },
  { "Idalynn", 0.0 },
  { "Idalys", 0.0 },
  { "Idalyz", 0.0 },
  { "Idamae", 0.0 },
  { "Idamay", 0.0 },
  { "Idan", 1.0 },
  { "Idanell", 0.0 },
  { "Idania", 0.0 },
  { "Idara", 0.0 },
  { "Idas", 1.0 },
  { "Idasia", 0.0 },
  { "Idaya", 0.0 },
  { "Iddo", 1.0 },
  { "Ideal", 0.0 },
  { "Idean", 1.0 },
  { "Idel", 0.2173913 },
  { "Idele", 0.0 },
  { "Idelfonso", 1.0 },
  { "Idelia", 0.0 },
  { "Idelisa", 0.0 },
  { "Idell", 0.010973144 },
  { "Idella", 0.0 },
  { "Idellar", 0.0 },
  { "Idelle", 0.0 },
  { "Idellia", 0.0 },
  { "Iden", 1.0 },
  { "Idena", 0.0 },
  { "Idesha", 0.0 },
  { "Idessa", 0.0 },
  { "Idette", 0.0 },
  { "Idhant", 1.0 },
  { "Idi", 1.0 },
  { "Idia", 0.0 },
  { "Idil", 0.0 },
  { "Idiris", 1.0 },
  { "Idman", 0.0 },
  { "Ido", 1.0 },
  { "Idola", 0.0 },
  { "Idolina", 0.0 },
  { "Idoma", 0.0 },
  { "Idona", 0.0 },
  { "Idonia", 0.0 },
  { "Idonna", 0.0 },
  { "Idora", 0.0 },
  { "Idrees", 1.0 },
  { "Idrena", 0.0 },
  { "Idris", 0.9877351 },
  { "Idriss", 1.0 },
  { "Idrissa", 0.94545454 },
  { "Iduma", 0.0 },
  { "Idus", 1.0 },
  { "Idy", 0.0 },
  { "Iean", 1.0 },
  { "Ieasha", 0.0 },
  { "Ieashia", 0.0 },
  { "Ieda", 0.0 },
  { "Ieesha", 0.0 },
  { "Ieisha", 0.0 },
  { "Ieishia", 0.0 },
  { "Ien", 1.0 },
  { "Iesa", 1.0 },
  { "Iesha", 0.002018571 },
  { "Ieshea", 0.0 },
  { "Ieshia", 0.0 },
  { "Iestyn", 1.0 },
  { "Ieuan", 1.0 },
  { "Ieva", 0.0 },
  { "Ieysha", 0.0 },
  { "Ife", 0.0 },
  { "Ifeanyi", 1.0 },
  { "Ifeanyichukwu", 1.0 },
  { "Ifechukwu", 0.0 },
  { "Ifenna", 1.0 },
  { "Ifeoluwa", 0.30246913 },
  { "Ifeoma", 0.0 },
  { "Ifetayo", 0.0 },
  { "Ifeyinwa", 0.0 },
  { "Iffany", 0.0 },
  { "Iffat", 0.0 },
  { "Ifra", 0.0 },
  { "Ifrah", 0.0 },
  { "Ifrain", 1.0 },
  { "Iftu", 0.0 },
  { "Ifunanya", 0.0 },
  { "Iggy", 1.0 },
  { "Ignac", 1.0 },
  { "Ignace", 1.0 },
  { "Ignacia", 0.0 },
  { "Ignacio", 0.9987626 },
  { "Ignacita", 0.0 },
  { "Ignasio", 1.0 },
  { "Ignatia", 0.0 },
  { "Ignatius", 1.0 },
  { "Ignatuis", 1.0 },
  { "Ignatz", 1.0 },
  { "Ignazio", 1.0 },
  { "Igor", 1.0 },
  { "Ihab", 1.0 },
  { "Ihan", 1.0 },
  { "Ihla", 0.0 },
  { "Ihor", 1.0 },
  { "Ihsaan", 0.88095236 },
  { "Ihsan", 0.9852941 },
  { "Ihuoma", 0.0 },
  { "Ii", 1.0 },
  { "Iian", 1.0 },
  { "Iiana", 0.0 },
  { "Iiesha", 0.0 },
  { "Iisha", 0.0 },
  { "Iishia", 0.0 },
  { "Iiyana", 0.0 },
  { "Ija", 0.0 },
  { "Ijah", 0.16176471 },
  { "Ijahnae", 0.0 },
  { "Ijana", 0.0 },
  { "Ijanae", 0.0 },
  { "Ijanay", 0.0 },
  { "Ijaz", 1.0 },
  { "Ijeoma", 0.0 },
  { "Ijnanya", 0.0 },
  { "Ikai", 1.0 },
  { "Ikaia", 1.0 },
  { "Ikaika", 1.0 },
  { "Ike", 1.0 },
  { "Ikea", 0.015280136 },
  { "Ikeam", 1.0 },
  { "Ikechi", 1.0 },
  { "Ikechukwu", 1.0 },
  { "Ikeda", 0.0 },
  { "Ikee", 1.0 },
  { "Ikeem", 1.0 },
  { "Ikeer", 1.0 },
  { "Ikeia", 0.0 },
  { "Ikeisha", 0.0 },
  { "Ikem", 1.0 },
  { "Ikenna", 1.0 },
  { "Iker", 1.0 },
  { "Ikera", 0.0 },
  { "Ikeria", 0.0 },
  { "Ikesha", 0.0 },
  { "Ikeshia", 0.0 },
  { "Ikey", 1.0 },
  { "Ikeya", 0.0 },
  { "Ikeyia", 0.0 },
  { "Ikher", 1.0 },
  { "Ikhlaas", 0.0 },
  { "Ikhlas", 0.0 },
  { "Ikia", 0.0 },
  { "Ikie", 1.0 },
  { "Ikira", 0.0 },
  { "Ikisha", 0.0 },
  { "Ikponmwosa", 1.0 },
  { "Ikra", 0.0 },
  { "Ikraan", 0.0 },
  { "Ikram", 0.06439394 },
  { "Ikran", 0.0 },
  { "Iksha", 0.0 },
  { "Iktan", 1.0 },
  { "Ikuko", 0.0 },
  { "Ila", 0.0027214587 },
  { "Ilah", 0.0 },
  { "Ilai", 1.0 },
  { "Ilaina", 0.0 },
  { "Ilaisaane", 0.0 },
  { "Ilam", 1.0 },
  { "Ilamae", 0.0 },
  { "Ilan", 0.98087686 },
  { "Ilana", 0.0 },
  { "Ilanah", 0.0 },
  { "Ilani", 0.0 },
  { "Ilanie", 0.0 },
  { "Ilanna", 0.0 },
  { "Ilanny", 0.0 },
  { "Ilany", 0.0 },
  { "Ilar", 0.0 },
  { "Ilaria", 0.0 },
  { "Ilario", 1.0 },
  { "Ilay", 1.0 },
  { "Ilaya", 0.0 },
  { "Ilayah", 0.0 },
  { "Ilayda", 0.0 },
  { "Ilayna", 0.0 },
  { "Ilce", 0.0 },
  { "Ilcia", 0.0 },
  { "Ilda", 0.0 },
  { "Ildefonso", 1.0 },
  { "Ildiko", 0.0 },
  { "Ilea", 0.0 },
  { "Ileah", 0.0 },
  { "Ilean", 0.0 },
  { "Ileana", 0.0 },
  { "Ileane", 0.0 },
  { "Ileanna", 0.0 },
  { "Ilee", 0.0 },
  { "Ileen", 0.0 },
  { "Ileena", 0.0 },
  { "Ileene", 0.0 },
  { "Ileia", 0.0 },
  { "Ileigh", 0.0 },
  { "Ilena", 0.0 },
  { "Ilene", 0.0 },
  { "Ilenia", 0.0 },
  { "Ilenna", 0.0 },
  { "Ilenne", 0.0 },
  { "Iler", 0.0 },
  { "Ilesha", 0.0 },
  { "Ilet", 0.0 },
  { "Ileta", 0.0 },
  { "Iletta", 0.0 },
  { "Ilette", 0.0 },
  { "Iley", 0.4864865 },
  { "Ileyah", 0.0 },
  { "Ilga", 0.0 },
  { "Ilhaan", 0.0 },
  { "Ilham", 0.029940119 },
  { "Ilhan", 0.2560241 },
  { "Ilhana", 0.0 },
  { "Ilia", 0.13953489 },
  { "Iliah", 0.0 },
  { "Ilian", 0.74820143 },
  { "Iliana", 0.0 },
  { "Ilianah", 0.0 },
  { "Iliani", 0.0 },
  { "Ilianie", 0.0 },
  { "Ilianis", 0.0 },
  { "Ilianna", 0.0 },
  { "Ilianne", 0.0 },
  { "Ilianny", 0.0 },
  { "Iliany", 0.0 },
  { "Ilias", 1.0 },
  { "Ilicia", 0.0 },
  { "Ilihia", 0.0 },
  { "Ilija", 1.0 },
  { "Ilijah", 1.0 },
  { "Ilima", 0.0 },
  { "Ilina", 0.0 },
  { "Ilinca", 0.0 },
  { "Iline", 0.0 },
  { "Ilir", 1.0 },
  { "Ilirian", 1.0 },
  { "Ilirida", 0.0 },
  { "Ilisa", 0.0 },
  { "Ilise", 0.0 },
  { "Ilish", 0.0 },
  { "Ilisha", 0.0 },
  { "Ilissa", 0.0 },
  { "Ilithia", 0.0 },
  { "Ilithya", 0.0 },
  { "Ilithyia", 0.0 },
  { "Ilitia", 0.0 },
  { "Iliya", 0.8552632 },
  { "Iliyaas", 1.0 },
  { "Iliyah", 0.0 },
  { "Iliyan", 1.0 },
  { "Iliyana", 0.0 },
  { "Iliza", 0.0 },
  { "Ilka", 0.0 },
  { "Illa", 0.0 },
  { "Illah", 0.0 },
  { "Illana", 0.0 },
  { "Illeana", 0.0 },
  { "Illeanna", 0.0 },
  { "Illene", 0.0 },
  { "Illia", 0.0 },
  { "Illiam", 1.0 },
  { "Illiana", 0.0 },
  { "Illianna", 0.0 },
  { "Illias", 1.0 },
  { "Illidan", 1.0 },
  { "Illijah", 1.0 },
  { "Illinois", 0.3125 },
  { "Illissa", 0.0 },
  { "Illiyana", 0.0 },
  { "Illona", 0.0 },
  { "Illya", 0.9194805 },
  { "Illyana", 0.0 },
  { "Illyanna", 0.0 },
  { "Illyas", 1.0 },
  { "Illyria", 0.0 },
  { "Illyssa", 0.0 },
  { "Illythia", 0.0 },
  { "Ilma", 0.0 },
  { "Ilmi", 0.0 },
  { "Ilo", 0.033195022 },
  { "Ilomae", 0.0 },
  { "Ilomay", 0.0 },
  { "Ilona", 0.0 },
  { "Ilora", 0.0 },
  { "Ilori", 0.0 },
  { "Ilsa", 0.0 },
  { "Ilse", 0.0 },
  { "Ilsi", 0.0 },
  { "Ilsy", 0.0 },
  { "Ilva", 0.0 },
  { "Ilwad", 0.0 },
  { "Ily", 0.0 },
  { "Ilya", 0.8669355 },
  { "Ilyaas", 1.0 },
  { "Ilyan", 1.0 },
  { "Ilyana", 0.0 },
  { "Ilyanna", 0.0 },
  { "Ilyas", 1.0 },
  { "Ilyass", 1.0 },
  { "Ilyjah", 1.0 },
  { "Ilyn", 0.0 },
  { "Ilyne", 0.0 },
  { "Ilynn", 0.0 },
  { "Ilysa", 0.0 },
  { "Ilyse", 0.0 },
  { "Ilyssa", 0.0 },
  { "Ilythia", 0.0 },
  { "Ilyza", 0.0 },
  { "Ilze", 0.0 },
  { "Ima", 0.0 },
  { "Imaad", 1.0 },
  { "Imaan", 0.083478265 },
  { "Imaani", 0.0 },
  { "Imad", 1.0 },
  { "Imagean", 0.0 },
  { "Imagen", 0.0 },
  { "Imagene", 0.0 },
  { "Imagin", 0.0 },
  { "Imagine", 0.0 },
  { "Imahni", 0.0 },
  { "Imajae", 0.0 },
  { "Imajean", 0.0 },
  { "Imajen", 0.0 },
  { "Imal", 0.0 },
  { "Imala", 0.0 },
  { "Imalai", 0.0 },
  { "Imalay", 0.0 },
  { "Imam", 1.0 },
  { "Imamu", 1.0 },
  { "Iman", 0.16777474 },
  { "Imana", 0.0 },
  { "Imane", 0.0 },
  { "Imanee", 0.0 },
  { "Imani", 0.043385703 },
  { "Imanie", 0.0 },
  { "Imanii", 0.0 },
  { "Imanni", 0.0 },
  { "Imanol", 1.0 },
  { "Imanuel", 1.0 },
  { "Imany", 0.0 },
  { "Imar", 0.4074074 },
  { "Imara", 0.0 },
  { "Imari", 0.26190478 },
  { "Imaria", 0.0 },
  { "Imarion", 1.0 },
  { "Imauri", 1.0 },
  { "Imaya", 0.0 },
  { "Imberly", 0.0 },
  { "Imee", 0.0 },
  { "Imelda", 0.0 },
  { "Imena", 0.0 },
  { "Imer", 1.0 },
  { "Imere", 1.0 },
  { "Imesha", 0.0 },
  { "Imhotep", 1.0 },
  { "Imia", 0.0 },
  { "Imir", 1.0 },
  { "Imira", 0.0 },
  { "Imisioluwa", 0.0 },
  { "Imiya", 0.0 },
  { "Imiyah", 0.0 },
  { "Immacolata", 0.0 },
  { "Immaculata", 0.0 },
  { "Immaculate", 0.0 },
  { "Immani", 0.0 },
  { "Immanol", 1.0 },
  { "Immanuel", 1.0 },
  { "Immer", 1.0 },
  { "Immogene", 0.0 },
  { "Imo", 0.0055066077 },
  { "Imogean", 0.0 },
  { "Imogen", 0.0 },
  { "Imogene", 0.0020072993 },
  { "Imogin", 0.0 },
  { "Imogine", 0.0 },
  { "Imojean", 0.0 },
  { "Imojene", 0.0 },
  { "Imon", 0.6862745 },
  { "Imoni", 0.0 },
  { "Imonie", 0.0 },
  { "Imothy", 1.0 },
  { "Imperia", 0.0 },
  { "Impi", 0.0 },
  { "Imraan", 1.0 },
  { "Imran", 1.0 },
  { "Imrane", 1.0 },
  { "Imre", 1.0 },
  { "Imri", 0.7704918 },
  { "Imron", 1.0 },
  { "Imtiaz", 1.0 },
  { "Imunique", 0.0 },
  { "Imya", 0.0 },
  { "Imyah", 0.0 },
  { "In", 0.23809524 },
  { "Ina", 0.0019305593 },
  { "Inaara", 0.0 },
  { "Inaaya", 0.0 },
  { "Inaayah", 0.0 },
  { "Inabelle", 0.0 },
  { "Inacio", 1.0 },
  { "Inah", 0.0 },
  { "Inaki", 1.0 },
  { "Inaky", 1.0 },
  { "Inamae", 0.0 },
  { "Inanna", 0.0 },
  { "Inara", 0.0 },
  { "Inarah", 0.0 },
  { "Inari", 0.0 },
  { "Inas", 0.0 },
  { "Inasia", 0.0 },
  { "Inass", 0.0 },
  { "Inaya", 0.0 },
  { "Inayah", 0.0 },
  { "Inayat", 0.0 },
  { "Inbal", 0.0 },
  { "Inbar", 0.0 },
  { "Inchara", 0.0 },
  { "Inci", 0.0 },
  { "Inda", 0.0 },
  { "Indalecio", 1.0 },
  { "Indasha", 0.0 },
  { "Indasia", 0.0 },
  { "Indea", 0.0 },
  { "Indee", 0.0 },
  { "Independence", 0.0 },
  { "Inderjit", 1.0 },
  { "Inderpreet", 1.0 },
  { "Indeya", 0.0 },
  { "Indhira", 0.0 },
  { "Indi", 0.024390243 },
  { "India", 0.0012356979 },
  { "Indiah", 0.0 },
  { "Indian", 0.0 },
  { "Indiana", 0.3979849 },
  { "Indianna", 0.0 },
  { "Indica", 0.0 },
  { "Indie", 0.09309967 },
  { "Indigo", 0.19919607 },
  { "Indika", 0.0 },
  { "Indio", 1.0 },
  { "Indira", 0.0 },
  { "Indiya", 0.0 },
  { "Indiyah", 0.0 },
  { "Indonesia", 0.0 },
  { "Indra", 0.043165468 },
  { "Indrani", 0.0 },
  { "Indria", 0.0 },
  { "Indsay", 0.0 },
  { "Indu", 0.0 },
  { "Indy", 0.40902874 },
  { "Indya", 0.0 },
  { "Indyah", 0.0 },
  { "Indyia", 0.0 },
  { "Ineda", 0.0 },
  { "Ineisha", 0.0 },
  { "Ineka", 0.0 },
  { "Ineke", 0.0 },
  { "Inelda", 0.0 },
  { "Inell", 0.0 },
  { "Inella", 0.0 },
  { "Inelle", 0.0 },
  { "Ines", 0.06781101 },
  { "Inesa", 0.0 },
  { "Inese", 0.0 },
  { "Inesh", 1.0 },
  { "Inesha", 0.0 },
  { "Ineshia", 0.0 },
  { "Iness", 0.0 },
  { "Inessa", 0.0 },
  { "Ineta", 0.0 },
  { "Inetha", 0.0 },
  { "Inett", 0.0 },
  { "Inetta", 0.0 },
  { "Inette", 0.0 },
  { "Ineva", 0.0 },
  { "Iney", 0.0 },
  { "Inez", 0.013823805 },
  { "Ineza", 0.0 },
  { "Ineze", 0.0 },
  { "Infant", 0.52071685 },
  { "Infantboy", 1.0 },
  { "Infantfemale", 0.0 },
  { "Infantgirl", 0.0 },
  { "Infantmale", 1.0 },
  { "Infantof", 0.45967743 },
  { "Infboy", 1.0 },
  { "Infinite", 1.0 },
  { "Infiniti", 0.0 },
  { "Infinity", 0.0073099416 },
  { "Inga", 0.0 },
  { "Ingar", 0.0 },
  { "Inge", 0.0 },
  { "Ingeborg", 0.0 },
  { "Ingemar", 1.0 },
  { "Inger", 0.0 },
  { "Ingmar", 1.0 },
  { "Ingo", 1.0 },
  { "Ingolf", 1.0 },
  { "Ingra", 0.0 },
  { "Ingram", 0.9655172 },
  { "Ingred", 0.0 },
  { "Ingri", 0.0 },
  { "Ingrid", 0.00066570076 },
  { "Ingrida", 0.0 },
  { "Ingris", 0.0 },
  { "Ingrit", 0.0 },
  { "Ingry", 0.0 },
  { "Ingvald", 1.0 },
  { "Inia", 0.0 },
  { "Inice", 0.0 },
  { "Inigo", 1.0 },
  { "Inika", 0.0 },
  { "Iniki", 0.13461539 },
  { "Inikki", 0.0 },
  { "Iniko", 1.0 },
  { "Inioluwa", 0.37869823 },
  { "Inis", 0.0 },
  { "Inisha", 0.0 },
  { "Inita", 0.0 },
  { "Iniya", 0.0 },
  { "Iniyah", 0.0 },
  { "Iniyan", 1.0 },
  { "Inman", 1.0 },
  { "Inmar", 1.0 },
  { "Inmer", 1.0 },
  { "Inna", 0.0 },
  { "Innaya", 0.0 },
  { "Innessa", 0.0 },
  { "Innie", 0.0 },
  { "Innis", 0.88372093 },
  { "Innocence", 0.0 },
  { "Innocent", 1.0 },
  { "Inocencia", 0.0 },
  { "Inocencio", 1.0 },
  { "Inocente", 1.0 },
  { "Inoke", 1.0 },
  { "Inola", 0.0 },
  { "Inona", 0.0 },
  { "Inori", 0.0 },
  { "Inri", 1.0 },
  { "Insha", 0.0 },
  { "Inshirah", 0.0 },
  { "Insiya", 0.0 },
  { "Insiyah", 0.0 },
  { "Insley", 0.0 },
  { "Inta", 0.0 },
  { "Inti", 1.0 },
  { "Intisar", 0.0 },
  { "Inus", 0.0 },
  { "Inya", 0.0 },
  { "Inza", 0.0 },
  { "Io", 0.1092437 },
  { "Ioan", 0.9489796 },
  { "Ioana", 0.0 },
  { "Ioane", 1.0 },
  { "Ioanna", 0.0 },
  { "Ioannis", 1.0 },
  { "Iokepa", 1.0 },
  { "Iola", 0.0 },
  { "Iolana", 0.0 },
  { "Iolanda", 0.0 },
  { "Iolani", 0.0 },
  { "Iole", 0.0 },
  { "Iolene", 0.0 },
  { "Iolia", 0.0 },
  { "Ioma", 0.0 },
  { "Ion", 1.0 },
  { "Iona", 0.00042793565 },
  { "Ione", 0.0 },
  { "Ioni", 0.0 },
  { "Ionia", 0.0 },
  { "Ionna", 0.0 },
  { "Iori", 1.0 },
  { "Iory", 1.0 },
  { "Iosefa", 1.0 },
  { "Ioseph", 1.0 },
  { "Iosif", 1.0 },
  { "Iosua", 1.0 },
  { "Iota", 0.0 },
  { "Iovanna", 0.0 },
  { "Iowa", 0.0 },
  { "Ipek", 0.0 },
  { "Ipolito", 1.0 },
  { "Ipsa", 0.0 },
  { "Iqbal", 1.0 },
  { "Iqlas", 0.0 },
  { "Iqra", 0.0 },
  { "Iquan", 1.0 },
  { "Ira", 0.9039373 },
  { "Iracema", 0.0 },
  { "Irael", 1.0 },
  { "Irah", 0.5833333 },
  { "Iraida", 0.0 },
  { "Iraima", 0.0 },
  { "Irais", 0.0 },
  { "Iraiz", 0.0 },
  { "Iraj", 0.0 },
  { "Iralene", 0.0 },
  { "Iralyn", 0.0 },
  { "Iralynn", 0.0 },
  { "Iram", 0.870229 },
  { "Iran", 0.7531157 },
  { "Irandy", 0.0 },
  { "Irani", 0.0 },
  { "Irania", 0.0 },
  { "Irany", 0.0 },
  { "Iras", 0.0 },
  { "Irasema", 0.0 },
  { "Iratze", 0.0 },
  { "Irayda", 0.0 },
  { "Irazema", 0.0 },
  { "Irbin", 1.0 },
  { "Irby", 0.9769912 },
  { "Ire", 1.0 },
  { "Ireal", 0.0 },
  { "Irean", 0.0 },
  { "Ireana", 0.0 },
  { "Ireanna", 0.0 },
  { "Ireatha", 0.0 },
  { "Iredell", 1.0 },
  { "Iree", 0.0 },
  { "Ireen", 0.0 },
  { "Ireene", 0.0 },
  { "Ireion", 0.0 },
  { "Ireka", 0.0 },
  { "Irelan", 0.0 },
  { "Ireland", 0.036511943 },
  { "Irelia", 0.0 },
  { "Irely", 0.0 },
  { "Irelyn", 0.0 },
  { "Irelynd", 0.0 },
  { "Irelynn", 0.0 },
  { "Irelynne", 0.0 },
  { "Irem", 0.0 },
  { "Iremide", 0.64705884 },
  { "Iren", 0.92753625 },
  { "Irena", 0.0 },
  { "Irene", 0.0038123443 },
  { "Ireneo", 1.0 },
  { "Ireoluwa", 0.43220338 },
  { "Ireon", 0.25 },
  { "Ireona", 0.0 },
  { "Ireonna", 0.0 },
  { "Ireri", 0.0 },
  { "Iresha", 0.0 },
  { "Ireta", 0.0 },
  { "Iretha", 0.0 },
  { "Iretta", 0.0 },
  { "Irey", 1.0 },
  { "Ireyanna", 0.0 },
  { "Irfaan", 1.0 },
  { "Irfan", 1.0 },
  { "Irha", 0.0 },
  { "Irhaa", 0.0 },
  { "Iri", 0.0 },
  { "Iria", 0.16949153 },
  { "Irian", 0.0 },
  { "Iriana", 0.0 },
  { "Irianna", 0.0 },
  { "Iric", 1.0 },
  { "Iridessa", 0.0 },
  { "Iridian", 0.011904762 },
  { "Iridiana", 0.0 },
  { "Irie", 0.21086262 },
  { "Irieana", 0.0 },
  { "Iriee", 0.0 },
  { "Iriel", 0.0 },
  { "Irielle", 0.0 },
  { "Irihanna", 0.0 },
  { "Irin", 0.5 },
  { "Irina", 0.0 },
  { "Irine", 0.0 },
  { "Irineo", 1.0 },
  { "Irini", 0.0 },
  { "Iris", 0.008350571 },
  { "Irisa", 0.0 },
  { "Irish", 0.07931262 },
  { "Irisha", 0.0 },
  { "Irissa", 0.0 },
  { "Iristine", 0.0 },
  { "Irit", 0.0 },
  { "Irita", 0.0 },
  { "Iriyana", 0.0 },
  { "Iriz", 0.0 },
  { "Irja", 0.0 },
  { "Irl", 1.0 },
  { "Irland", 1.0 },
  { "Irlanda", 0.0 },
  { "Irlene", 0.0 },
  { "Irline", 0.0 },
  { "Irma", 0.0034305318 },
  { "Irmagene", 0.0 },
  { "Irmak", 0.0 },
  { "Irmalee", 0.0 },
  { "Irmalinda", 0.0 },
  { "Irmani", 0.0 },
  { "Irmgard", 0.0 },
  { "Irmina", 0.0 },
  { "Irmuun", 1.0 },
  { "Irna", 0.0 },
  { "Iroh", 1.0 },
  { "Iroha", 0.0 },
  { "Iron", 1.0 },
  { "Irona", 0.0 },
  { "Ironesha", 0.0 },
  { "Irsa", 0.0 },
  { "Irshad", 1.0 },
  { "Irulan", 0.0 },
  { "Irv", 1.0 },
  { "Irva", 0.0 },
  { "Irvan", 1.0 },
  { "Irven", 1.0 },
  { "Irvin", 0.99810976 },
  { "Irvina", 0.0 },
  { "Irvine", 0.9944629 },
  { "Irving", 0.9980452 },
  { "Irvyn", 1.0 },
  { "Irwin", 0.99924153 },
  { "Irwing", 1.0 },
  { "Iry", 1.0 },
  { "Iryana", 0.0 },
  { "Iryanna", 0.0 },
  { "Iryna", 0.0 },
  { "Irys", 0.0 },
  { "Iryss", 0.0 },
  { "Isa", 0.39906433 },
  { "Isaabella", 0.0 },
  { "Isaac", 0.9973136 },
  { "Isaack", 1.0 },
  { "Isaah", 1.0 },
  { "Isaak", 1.0 },
  { "Isaam", 1.0 },
  { "Isaaq", 1.0 },
  { "Isabeau", 0.0 },
  { "Isabel", 0.015553045 },
  { "Isabela", 0.0 },
  { "Isabelah", 0.0 },
  { "Isabele", 0.0 },
  { "Isabeli", 0.0 },
  { "Isabelita", 0.0 },
  { "Isabell", 0.0003508772 },
  { "Isabella", 0.0011640073 },
  { "Isabellagrace", 0.0 },
  { "Isabellah", 0.0 },
  { "Isabellamarie", 0.0 },
  { "Isabellarose", 0.0 },
  { "Isabellasophia", 0.0 },
  { "Isabelle", 0.000229392 },
  { "Isabellemarie", 0.0 },
  { "Isabellia", 0.0 },
  { "Isabelly", 0.0 },
  { "Isabelo", 1.0 },
  { "Isabeth", 0.0 },
  { "Isabeya", 0.0 },
  { "Isable", 0.0 },
  { "Isac", 1.0 },
  { "Isacc", 1.0 },
  { "Isack", 1.0 },
  { "Isador", 1.0 },
  { "Isadora", 0.0 },
  { "Isadore", 0.9718457 },
  { "Isael", 1.0 },
  { "Isah", 0.8780488 },
  { "Isaha", 1.0 },
  { "Isahbella", 0.0 },
  { "Isahi", 1.0 },
  { "Isahia", 1.0 },
  { "Isahiah", 1.0 },
  { "Isahias", 1.0 },
  { "Isai", 0.995254 },
  { "Isaia", 1.0 },
  { "Isaiah", 0.9970088 },
  { "Isaiaha", 1.0 },
  { "Isaiahmichael", 1.0 },
  { "Isaiahs", 1.0 },
  { "Isaian", 1.0 },
  { "Isaias", 1.0 },
  { "Isaic", 1.0 },
  { "Isaid", 1.0 },
  { "Isaih", 1.0 },
  { "Isaiha", 1.0 },
  { "Isaihas", 1.0 },
  { "Isain", 1.0 },
  { "Isair", 1.0 },
  { "Isaira", 0.0 },
  { "Isairis", 0.0 },
  { "Isais", 1.0 },
  { "Isaish", 1.0 },
  { "Isaiyah", 1.0 },
  { "Isajah", 1.0 },
  { "Isak", 1.0 },
  { "Isal", 0.0 },
  { "Isalei", 0.0 },
  { "Isalena", 0.0 },
  { "Isalia", 0.0 },
  { "Isaly", 0.0 },
  { "Isam", 1.0 },
  { "Isamar", 0.041120652 },
  { "Isamara", 0.0 },
  { "Isamari", 0.0 },
  { "Isamarie", 0.0 },
  { "Isamary", 0.0 },
  { "Isamel", 1.0 },
  { "Isami", 1.0 },
  { "Isamu", 1.0 },
  { "Isan", 1.0 },
  { "Isana", 0.0 },
  { "Isander", 1.0 },
  { "Isandro", 1.0 },
  { "Isao", 1.0 },
  { "Isaque", 1.0 },
  { "Isara", 0.0 },
  { "Isarael", 1.0 },
  { "Isarel", 1.0 },
  { "Isarely", 0.0 },
  { "Isata", 0.0 },
  { "Isatou", 0.0 },
  { "Isatu", 0.0 },
  { "Isau", 1.0 },
  { "Isaul", 1.0 },
  { "Isaura", 0.0 },
  { "Isauro", 1.0 },
  { "Isavel", 0.0 },
  { "Isavela", 0.0 },
  { "Isavella", 0.0 },
  { "Isay", 1.0 },
  { "Isaya", 1.0 },
  { "Isayah", 1.0 },
  { "Isayana", 0.0 },
  { "Isayiah", 1.0 },
  { "Isbel", 0.0 },
  { "Isbell", 0.0 },
  { "Isbella", 0.0 },
  { "Isco", 1.0 },
  { "Iseah", 1.0 },
  { "Isebell", 0.0 },
  { "Isebella", 0.0 },
  { "Isel", 0.0 },
  { "Isela", 0.0 },
  { "Iselda", 0.0 },
  { "Iselin", 0.0 },
  { "Iselis", 0.0 },
  { "Isella", 0.0 },
  { "Iselle", 0.0 },
  { "Iselys", 0.0 },
  { "Isen", 1.0 },
  { "Isenia", 0.0 },
  { "Iseral", 1.0 },
  { "Ises", 0.0 },
  { "Iseult", 0.0 },
  { "Ish", 1.0 },
  { "Isha", 0.0 },
  { "Ishaal", 0.0 },
  { "Ishaan", 1.0 },
  { "Ishaani", 0.0 },
  { "Ishaanvi", 0.0 },
  { "Ishaaq", 1.0 },
  { "Ishah", 0.0 },
  { "Ishak", 1.0 },
  { "Isham", 1.0 },
  { "Ishamel", 1.0 },
  { "Ishan", 1.0 },
  { "Ishana", 0.0 },
  { "Ishanae", 0.0 },
  { "Ishani", 0.0 },
  { "Ishant", 1.0 },
  { "Ishanth", 1.0 },
  { "Ishanti", 0.0 },
  { "Ishanvi", 0.0 },
  { "Ishaq", 1.0 },
  { "Ishara", 0.0 },
  { "Ishaun", 1.0 },
  { "Ishawn", 1.0 },
  { "Ishayu", 1.0 },
  { "Ishbel", 0.0 },
  { "Ishea", 0.0 },
  { "Ishi", 0.088607594 },
  { "Ishia", 0.0 },
  { "Ishiah", 1.0 },
  { "Ishika", 0.0 },
  { "Ishita", 0.0 },
  { "Ishitha", 0.0 },
  { "Ishmael", 1.0 },
  { "Ishmail", 1.0 },
  { "Ishmam", 1.0 },
  { "Ishman", 1.0 },
  { "Ishmeal", 1.0 },
  { "Ishmeet", 0.33333334 },
  { "Ishmel", 1.0 },
  { "Ishmil", 1.0 },
  { "Ishna", 0.0 },
  { "Ishraq", 1.0 },
  { "Ishrat", 0.0 },
  { "Ishta", 0.0 },
  { "Ishwaq", 0.0 },
  { "Ishwari", 0.0 },
  { "Ishya", 0.0 },
  { "Isia", 0.11363637 },
  { "Isiaah", 1.0 },
  { "Isiac", 1.0 },
  { "Isiah", 0.9995299 },
  { "Isiaha", 1.0 },
  { "Isiaih", 1.0 },
  { "Isias", 1.0 },
  { "Isiash", 1.0 },
  { "Isibeal", 0.0 },
  { "Isibella", 0.0 },
  { "Isidor", 1.0 },
  { "Isidora", 0.0 },
  { "Isidore", 1.0 },
  { "Isidoro", 1.0 },
  { "Isidra", 0.0 },
  { "Isidro", 1.0 },
  { "Isileli", 1.0 },
  { "Isioma", 0.0 },
  { "Isis", 0.0011007155 },
  { "Isiss", 0.0 },
  { "Iskandar", 1.0 },
  { "Iskander", 1.0 },
  { "Isla", 0.0 },
  { "Islah", 0.07575758 },
  { "Islam", 0.80216384 },
  { "Island", 0.024590164 },
  { "Islarose", 0.0 },
  { "Islay", 0.0 },
  { "Islee", 0.0 },
  { "Isley", 0.22653316 },
  { "Islynn", 0.0 },
  { "Isma", 0.0 },
  { "Ismaaeel", 1.0 },
  { "Ismaeel", 1.0 },
  { "Ismael", 0.9978832 },
  { "Ismaela", 0.0 },
  { "Ismah", 0.0 },
  { "Ismahan", 0.0 },
  { "Ismail", 1.0 },
  { "Ismaila", 1.0 },
  { "Ismar", 0.8942308 },
  { "Ismari", 0.0 },
  { "Ismary", 0.0 },
  { "Ismat", 0.0 },
  { "Ismay", 0.0 },
  { "Ismeal", 1.0 },
  { "Ismel", 1.0 },
  { "Ismelda", 0.0 },
  { "Ismene", 0.0 },
  { "Ismenia", 0.0 },
  { "Ismerai", 0.0 },
  { "Ismeralda", 0.0 },
  { "Ismet", 1.0 },
  { "Isobel", 0.0 },
  { "Isobell", 0.0 },
  { "Isobella", 0.0 },
  { "Isobelle", 0.0 },
  { "Isoke", 0.0 },
  { "Isoken", 0.0 },
  { "Isola", 0.0 },
  { "Isolde", 0.0 },
  { "Isolene", 0.0 },
  { "Isolina", 0.0 },
  { "Isom", 1.0 },
  { "Ison", 1.0 },
  { "Isra", 0.0056561087 },
  { "Israa", 0.0 },
  { "Israe", 0.0 },
  { "Israel", 0.98084545 },
  { "Israela", 0.0 },
  { "Israella", 0.0 },
  { "Israelle", 0.0 },
  { "Israh", 0.0 },
  { "Israt", 0.0 },
  { "Israyel", 1.0 },
  { "Isreal", 0.98651475 },
  { "Isriel", 1.0 },
  { "Isrrael", 1.0 },
  { "Issa", 0.7916219 },
  { "Issaac", 1.0 },
  { "Issabel", 0.0 },
  { "Issabela", 0.0 },
  { "Issabell", 0.0 },
  { "Issabella", 0.0 },
  { "Issabelle", 0.0 },
  { "Issac", 0.9991931 },
  { "Issacc", 1.0 },
  { "Issachar", 1.0 },
  { "Issack", 1.0 },
  { "Issael", 1.0 },
  { "Issah", 1.0 },
  { "Issai", 1.0 },
  { "Issaiah", 1.0 },
  { "Issaias", 1.0 },
  { "Issaic", 1.0 },
  { "Issaih", 1.0 },
  { "Issak", 1.0 },
  { "Issam", 1.0 },
  { "Issamar", 0.0 },
  { "Issay", 1.0 },
  { "Isse", 1.0 },
  { "Issei", 1.0 },
  { "Issel", 0.0 },
  { "Issela", 0.0 },
  { "Issey", 1.0 },
  { "Issiac", 1.0 },
  { "Issiah", 1.0 },
  { "Issiaka", 1.0 },
  { "Issic", 1.0 },
  { "Issie", 0.45454547 },
  { "Issis", 0.0 },
  { "Issys", 0.0 },
  { "Istvan", 1.0 },
  { "Isys", 0.0 },
  { "Isyss", 0.0 },
  { "Iszabella", 0.0 },
  { "Iszac", 1.0 },
  { "Iszak", 1.0 },
  { "Ita", 0.0 },
  { "Itai", 1.0 },
  { "Italee", 0.0 },
  { "Itali", 0.0 },
  { "Italia", 0.0 },
  { "Italie", 0.0 },
  { "Italo", 1.0 },
  { "Italy", 0.0044682752 },
  { "Italya", 0.0 },
  { "Itamar", 0.93700784 },
  { "Itan", 1.0 },
  { "Itasca", 0.0 },
  { "Itasha", 0.0 },
  { "Itaska", 0.0 },
  { "Itati", 0.0 },
  { "Itaty", 0.0 },
  { "Itay", 1.0 },
  { "Itayetzi", 0.0 },
  { "Itcel", 0.0 },
  { "Itha", 0.0 },
  { "Ithalia", 0.0 },
  { "Ithan", 1.0 },
  { "Ithel", 1.0 },
  { "Ithiel", 1.0 },
  { "Ithzel", 0.0 },
  { "Itia", 0.0 },
  { "Itiana", 0.0 },
  { "Itianna", 0.0 },
  { "Itiel", 1.0 },
  { "Itisha", 0.0 },
  { "Itohan", 0.0 },
  { "Itsamari", 0.0 },
  { "Itsel", 0.0 },
  { "Itsue", 0.0 },
  { "Itsuki", 1.0 },
  { "Itsuko", 0.0 },
  { "Itsuo", 1.0 },
  { "Itta", 0.0 },
  { "Ittai", 1.0 },
  { "Itxel", 0.0 },
  { "Itza", 0.0 },
  { "Itzabella", 0.0 },
  { "Itzabelle", 0.0 },
  { "Itzae", 0.8218085 },
  { "Itzael", 1.0 },
  { "Itzamar", 0.0 },
  { "Itzamara", 0.0 },
  { "Itzamaray", 0.0 },
  { "Itzanami", 0.0 },
  { "Itzany", 0.0 },
  { "Itzary", 0.0 },
  { "Itzayana", 0.0 },
  { "Itzayani", 0.0 },
  { "Itzayanna", 0.0 },
  { "Itzcoatl", 1.0 },
  { "Itzel", 0.006542722 },
  { "Itzela", 0.0 },
  { "Itzell", 0.0 },
  { "Itzelle", 0.0 },
  { "Itzelt", 0.0 },
  { "Itzely", 0.0 },
  { "Itzhak", 1.0 },
  { "Itzhel", 0.0 },
  { "Itzia", 0.0 },
  { "Itziar", 1.0 },
  { "Itzuri", 0.0 },
  { "Itzury", 0.0 },
  { "Itzy", 0.0 },
  { "Iula", 0.0 },
  { "Iuma", 0.0 },
  { "Iva", 0.014861269 },
  { "Ivaan", 1.0 },
  { "Ivadean", 0.0 },
  { "Ivadel", 0.0 },
  { "Ivadell", 0.0 },
  { "Ivadelle", 0.0 },
  { "Ivagene", 0.0 },
  { "Ivah", 0.0 },
  { "Ival", 0.6968974 },
  { "Ivalee", 0.0 },
  { "Ivalene", 0.0 },
  { "Ivaline", 0.0 },
  { "Ivalou", 0.0 },
  { "Ivan", 0.99500465 },
  { "Ivana", 0.0 },
  { "Ivanah", 0.0 },
  { "Ivandejesus", 1.0 },
  { "Ivane", 0.0 },
  { "Ivanell", 0.0 },
  { "Ivanelle", 0.0 },
  { "Ivanhoe", 1.0 },
  { "Ivani", 0.0 },
  { "Ivania", 0.0 },
  { "Ivaniel", 1.0 },
  { "Ivanka", 0.0 },
  { "Ivann", 1.0 },
  { "Ivanna", 0.0 },
  { "Ivannah", 0.0 },
  { "Ivannia", 0.0 },
  { "Ivano", 1.0 },
  { "Ivany", 0.0 },
  { "Ivanya", 0.0 },
  { "Ivar", 1.0 },
  { "Ivars", 1.0 },
  { "Ivary", 0.0 },
  { "Ivaya", 0.0 },
  { "Ive", 0.21428572 },
  { "Ivee", 0.0 },
  { "Ivel", 0.48387095 },
  { "Ivelin", 0.0 },
  { "Ivelis", 0.0 },
  { "Ivelise", 0.0 },
  { "Ivelisse", 0.0 },
  { "Iveliz", 0.0 },
  { "Ivell", 0.0 },
  { "Ivelyn", 0.0 },
  { "Iven", 1.0 },
  { "Ivena", 0.0 },
  { "Iver", 0.9245902 },
  { "Ivera", 0.0 },
  { "Iverna", 0.0 },
  { "Iverson", 0.989318 },
  { "Ivery", 0.67918086 },
  { "Ives", 1.0 },
  { "Ivet", 0.0 },
  { "Iveth", 0.0 },
  { "Ivett", 0.0 },
  { "Ivetta", 0.0 },
  { "Ivette", 0.0009573959 },
  { "Ivey", 0.3627831 },
  { "Ivi", 0.0 },
  { "Ivia", 0.0 },
  { "Ivian", 0.0 },
  { "Iviana", 0.0 },
  { "Ivianna", 0.0 },
  { "Iviannah", 0.0 },
  { "Ivica", 1.0 },
  { "Ivie", 0.047262248 },
  { "Ivin", 1.0 },
  { "Ivion", 1.0 },
  { "Iviona", 0.0 },
  { "Ivionna", 0.0 },
  { "Ivis", 0.22137405 },
  { "Ivison", 1.0 },
  { "Ivo", 0.9930556 },
  { "Ivol", 1.0 },
  { "Ivola", 0.0 },
  { "Ivon", 0.3195938 },
  { "Ivona", 0.0 },
  { "Ivone", 0.0 },
  { "Ivonn", 0.0 },
  { "Ivonna", 0.0 },
  { "Ivonne", 0.0023894862 },
  { "Ivor", 0.94383395 },
  { "Ivoree", 0.0 },
  { "Ivori", 0.0 },
  { "Ivorie", 0.0 },
  { "Ivory", 0.47107533 },
  { "Ivoryana", 0.0 },
  { "Ivoryanna", 0.0 },
  { "Ivoryrose", 0.0 },
  { "Ivra", 0.0 },
  { "Ivree", 0.0 },
  { "Ivri", 1.0 },
  { "Ivry", 0.07462686 },
  { "Ivy", 0.06937266 },
  { "Ivyana", 0.0 },
  { "Ivyann", 0.0 },
  { "Ivyanna", 0.0 },
  { "Ivyanne", 0.0 },
  { "Ivye", 0.0 },
  { "Ivyl", 1.0 },
  { "Ivylynn", 0.0 },
  { "Ivymarie", 0.0 },
  { "Ivyn", 1.0 },
  { "Ivyon", 1.0 },
  { "Ivyona", 0.0 },
  { "Ivyonna", 0.0 },
  { "Ivyrose", 0.0 },
  { "Ivyunna", 0.0 },
  { "Iwalani", 0.0 },
  { "Iwan", 1.0 },
  { "Iwana", 0.0 },
  { "Iwao", 1.0 },
  { "Iwona", 0.0 },
  { "Ixareli", 0.0 },
  { "Ixayana", 0.0 },
  { "Ixcel", 0.0 },
  { "Ixchel", 0.0 },
  { "Ixchell", 0.0 },
  { "Ixel", 0.0 },
  { "Ixsel", 0.0 },
  { "Ixtzel", 0.0 },
  { "Ixzel", 0.0 },
  { "Iya", 0.0 },
  { "Iyaad", 1.0 },
  { "Iyad", 1.0 },
  { "Iyah", 0.0 },
  { "Iyahna", 0.0 },
  { "Iyali", 0.0 },
  { "Iyan", 1.0 },
  { "Iyana", 0.0 },
  { "Iyanah", 0.0 },
  { "Iyani", 0.0 },
  { "Iyania", 0.0 },
  { "Iyanla", 0.0 },
  { "Iyanna", 0.0 },
  { "Iyannah", 0.0 },
  { "Iyanni", 0.0 },
  { "Iyanuoluwa", 0.13636364 },
  { "Iyari", 0.042857144 },
  { "Iyasia", 0.0 },
  { "Iyauna", 0.0 },
  { "Iyaunna", 0.0 },
  { "Iycess", 0.0 },
  { "Iyeisha", 0.0 },
  { "Iyesha", 0.0 },
  { "Iyeshia", 0.0 },
  { "Iyhana", 0.0 },
  { "Iyiana", 0.0 },
  { "Iyinoluwa", 0.0 },
  { "Iyisha", 0.0 },
  { "Iyla", 0.0 },
  { "Iylah", 0.0 },
  { "Iylan", 0.0 },
  { "Iylee", 0.0 },
  { "Iyleen", 0.0 },
  { "Iymona", 0.0 },
  { "Iyon", 1.0 },
  { "Iyona", 0.0 },
  { "Iyonah", 0.0 },
  { "Iyone", 0.0 },
  { "Iyoni", 0.0 },
  { "Iyonia", 0.0 },
  { "Iyonna", 0.0 },
  { "Iyonnah", 0.0 },
  { "Iyonnie", 0.0 },
  { "Iysha", 0.0 },
  { "Iyshia", 0.0 },
  { "Iysis", 0.0 },
  { "Iysiss", 0.0 },
  { "Iyssis", 0.0 },
  { "Iyuna", 0.0 },
  { "Iyunna", 0.0 },
  { "Iza", 0.0 },
  { "Izaac", 1.0 },
  { "Izaack", 1.0 },
  { "Izaah", 1.0 },
  { "Izaak", 1.0 },
  { "Izaan", 1.0 },
  { "Izabel", 0.0 },
  { "Izabela", 0.0 },
  { "Izabelah", 0.0 },
  { "Izabele", 0.0 },
  { "Izabell", 0.0 },
  { "Izabella", 0.0 },
  { "Izabellah", 0.0 },
  { "Izabelle", 0.0 },
  { "Izac", 1.0 },
  { "Izacc", 1.0 },
  { "Izach", 1.0 },
  { "Izack", 1.0 },
  { "Izadora", 0.0 },
  { "Izaeah", 1.0 },
  { "Izaeh", 1.0 },
  { "Izael", 1.0 },
  { "Izah", 1.0 },
  { "Izaha", 1.0 },
  { "Izahbella", 0.0 },
  { "Izahia", 1.0 },
  { "Izai", 1.0 },
  { "Izaia", 1.0 },
  { "Izaiah", 0.99951285 },
  { "Izaias", 1.0 },
  { "Izaic", 1.0 },
  { "Izaih", 1.0 },
  { "Izaiha", 1.0 },
  { "Izair", 1.0 },
  { "Izais", 1.0 },
  { "Izaiya", 1.0 },
  { "Izaiyah", 1.0 },
  { "Izak", 1.0 },
  { "Izalea", 0.0 },
  { "Izamar", 0.013035382 },
  { "Izamara", 0.0 },
  { "Izamary", 0.0 },
  { "Izan", 1.0 },
  { "Izara", 0.0 },
  { "Izaria", 0.0 },
  { "Izariah", 0.0 },
  { "Izarra", 0.0 },
  { "Izavella", 0.0 },
  { "Izavier", 1.0 },
  { "Izavion", 1.0 },
  { "Izaya", 1.0 },
  { "Izayah", 1.0 },
  { "Izayha", 1.0 },
  { "Izayiah", 1.0 },
  { "Izayuh", 1.0 },
  { "Izea", 1.0 },
  { "Izeah", 1.0 },
  { "Izeal", 1.0 },
  { "Izear", 1.0 },
  { "Izebella", 0.0 },
  { "Izeck", 1.0 },
  { "Izeiah", 1.0 },
  { "Izek", 1.0 },
  { "Izekiel", 1.0 },
  { "Izel", 0.20510775 },
  { "Izela", 0.0 },
  { "Izelia", 0.0 },
  { "Izell", 0.97507334 },
  { "Izella", 0.0 },
  { "Izellah", 0.0 },
  { "Izelle", 0.0 },
  { "Izen", 1.0 },
  { "Izena", 0.0 },
  { "Izetta", 0.0 },
  { "Izeyah", 1.0 },
  { "Izhane", 0.0 },
  { "Izhar", 1.0 },
  { "Iziah", 1.0 },
  { "Iziaha", 1.0 },
  { "Izibella", 0.0 },
  { "Izic", 1.0 },
  { "Izick", 1.0 },
  { "Izidora", 0.0 },
  { "Izik", 1.0 },
  { "Izma", 0.0 },
  { "Izmael", 1.0 },
  { "Izna", 0.0 },
  { "Izobel", 0.0 },
  { "Izola", 0.0 },
  { "Izona", 0.0 },
  { "Izora", 0.0 },
  { "Izra", 1.0 },
  { "Izrael", 1.0 },
  { "Izreal", 1.0 },
  { "Izriel", 1.0 },
  { "Izsabella", 0.0 },
  { "Izsak", 1.0 },
  { "Izuchukwu", 1.0 },
  { "Izumi", 0.0 },
  { "Izyaan", 1.0 },
  { "Izyah", 1.0 },
  { "Izyan", 1.0 },
  { "Izybella", 0.0 },
  { "Izyck", 1.0 },
  { "Izyk", 1.0 },
  { "Izza", 0.0 },
  { "Izzabel", 0.0 },
  { "Izzabela", 0.0 },
  { "Izzabell", 0.0 },
  { "Izzabella", 0.0 },
  { "Izzabellah", 0.0 },
  { "Izzabelle", 0.0 },
  { "Izzac", 1.0 },
  { "Izzack", 1.0 },
  { "Izzah", 0.0 },
  { "Izzaiah", 1.0 },
  { "Izzak", 1.0 },
  { "Izzat", 1.0 },
  { "Izzi", 0.0 },
  { "Izziah", 1.0 },
  { "Izzibella", 0.0 },
  { "Izzie", 0.0 },
  { "Izzik", 1.0 },
  { "Izzy", 0.3091873 },
  { "Izzybella", 0.0 },
  { "Ja", 0.66 },
  { "Jaabir", 1.0 },
  { "Jaad", 1.0 },
  { "Jaada", 0.0 },
  { "Jaade", 0.0 },
  { "Jaaden", 1.0 },
  { "Jaafar", 1.0 },
  { "Jaala", 0.0 },
  { "Jaalah", 0.0 },
  { "Jaalen", 1.0 },
  { "Jaali", 1.0 },
  { "Jaaliyah", 0.0 },
  { "Jaalyn", 0.54545456 },
  { "Jaamal", 1.0 },
  { "Jaan", 1.0 },
  { "Jaana", 0.0 },
  { "Jaanai", 0.0 },
  { "Jaanna", 0.0 },
  { "Jaanvi", 0.0 },
  { "Jaaron", 1.0 },
  { "Jaasia", 0.0 },
  { "Jaasiel", 1.0 },
  { "Jaasir", 1.0 },
  { "Jaason", 1.0 },
  { "Jaasritha", 0.0 },
  { "Jaavon", 1.0 },
  { "Jaazaniah", 0.25 },
  { "Jaaziah", 0.96407187 },
  { "Jaaziel", 0.98507464 },
  { "Jab", 1.0 },
  { "Jabaar", 1.0 },
  { "Jabahri", 1.0 },
  { "Jabali", 1.0 },
  { "Jabar", 1.0 },
  { "Jabare", 1.0 },
  { "Jabaree", 1.0 },
  { "Jabari", 1.0 },
  { "Jabarie", 1.0 },
  { "Jabarion", 1.0 },
  { "Jabaris", 1.0 },
  { "Jabarius", 1.0 },
  { "Jabarr", 1.0 },
  { "Jabarri", 1.0 },
  { "Jabarrie", 1.0 },
  { "Jabary", 1.0 },
  { "Jabbaar", 1.0 },
  { "Jabbar", 1.0 },
  { "Jabdiel", 1.0 },
  { "Jabe", 1.0 },
  { "Jabel", 1.0 },
  { "Jaben", 1.0 },
  { "Jaber", 1.0 },
  { "Jabes", 1.0 },
  { "Jabez", 1.0 },
  { "Jabian", 1.0 },
  { "Jabien", 1.0 },
  { "Jabier", 1.0 },
  { "Jabin", 1.0 },
  { "Jabina", 0.0 },
  { "Jabir", 1.0 },
  { "Jabo", 1.0 },
  { "Jaboa", 0.0 },
  { "Jabob", 1.0 },
  { "Jabon", 1.0 },
  { "Jabora", 0.0 },
  { "Jaboree", 1.0 },
  { "Jabori", 1.0 },
  { "Jaborie", 1.0 },
  { "Jaboris", 1.0 },
  { "Jabrae", 1.0 },
  { "Jabrail", 1.0 },
  { "Jabrandon", 1.0 },
  { "Jabraun", 1.0 },
  { "Jabrayah", 0.0 },
  { "Jabrayden", 1.0 },
  { "Jabraylen", 1.0 },
  { "Jabraylin", 1.0 },
  { "Jabraylon", 1.0 },
  { "Jabre", 0.9264706 },
  { "Jabrea", 0.0 },
  { "Jabree", 0.81333333 },
  { "Jabreel", 1.0 },
  { "Jabreena", 0.0 },
  { "Jabreia", 0.0 },
  { "Jabrel", 1.0 },
  { "Jabrell", 1.0 },
  { "Jabreon", 1.0 },
  { "Jabreya", 0.0 },
  { "Jabri", 0.9227053 },
  { "Jabria", 0.0 },
  { "Jabriah", 0.0 },
  { "Jabrian", 1.0 },
  { "Jabriel", 1.0 },
  { "Jabrielle", 0.0 },
  { "Jabrien", 1.0 },
  { "Jabril", 1.0 },
  { "Jabrill", 1.0 },
  { "Jabrina", 0.0 },
  { "Jabrion", 1.0 },
  { "Jabriya", 0.0 },
  { "Jabriyah", 0.0 },
  { "Jabron", 1.0 },
  { "Jabryan", 1.0 },
  { "Jabulani", 1.0 },
  { "Jabus", 1.0 },
  { "Jac", 1.0 },
  { "Jacab", 1.0 },
  { "Jacaden", 1.0 },
  { "Jacai", 1.0 },
  { "Jacaiden", 1.0 },
  { "Jacaleb", 1.0 },
  { "Jacalyn", 0.0 },
  { "Jacalynn", 0.0 },
  { "Jacameron", 1.0 },
  { "Jacan", 1.0 },
  { "Jacara", 0.0 },
  { "Jacaranda", 0.0 },
  { "Jacare", 1.0 },
  { "Jacaree", 1.0 },
  { "Jacarey", 1.0 },
  { "Jacari", 0.9581448 },
  { "Jacaria", 0.0 },
  { "Jacarie", 1.0 },
  { "Jacarii", 1.0 },
  { "Jacarion", 1.0 },
  { "Jacarious", 1.0 },
  { "Jacarius", 1.0 },
  { "Jacarla", 0.0 },
  { "Jacarr", 1.0 },
  { "Jacarra", 0.0 },
  { "Jacarri", 1.0 },
  { "Jacarria", 0.0 },
  { "Jacarter", 1.0 },
  { "Jacary", 1.0 },
  { "Jacaryous", 1.0 },
  { "Jacauri", 1.0 },
  { "Jacaury", 1.0 },
  { "Jacavion", 1.0 },
  { "Jacayden", 1.0 },
  { "Jacayla", 0.0 },
  { "Jacbo", 1.0 },
  { "Jaccari", 1.0 },
  { "Jacci", 0.0 },
  { "Jaccob", 1.0 },
  { "Jace", 0.9887581 },
  { "Jacee", 0.02364865 },
  { "Jaceion", 1.0 },
  { "Jacek", 1.0 },
  { "Jacelin", 0.0 },
  { "Jaceline", 0.0 },
  { "Jacella", 0.0 },
  { "Jacelle", 0.0 },
  { "Jacely", 0.0 },
  { "Jacelyn", 0.0 },
  { "Jacelynn", 0.0 },
  { "Jacen", 1.0 },
  { "Jacenda", 0.0 },
  { "Jacenia", 0.0 },
  { "Jacent", 1.0 },
  { "Jacenta", 0.0 },
  { "Jaceon", 1.0 },
  { "Jacere", 1.0 },
  { "Jaceson", 1.0 },
  { "Jacetin", 1.0 },
  { "Jaceton", 1.0 },
  { "Jacey", 0.056512024 },
  { "Jaceyon", 1.0 },
  { "Jacgueline", 0.0 },
  { "Jachai", 0.9653979 },
  { "Jache", 0.0 },
  { "Jachelle", 0.0 },
  { "Jachin", 1.0 },
  { "Jachob", 1.0 },
  { "Jaci", 0.0 },
  { "Jacia", 0.0 },
  { "Jaciah", 0.0 },
  { "Jacian", 1.0 },
  { "Jaciana", 0.0 },
  { "Jacianna", 0.0 },
  { "Jacie", 0.0013455328 },
  { "Jaciel", 0.9917898 },
  { "Jacieon", 1.0 },
  { "Jacier", 1.0 },
  { "Jacilyn", 0.0 },
  { "Jacilynn", 0.0 },
  { "Jacin", 1.0 },
  { "Jacina", 0.0 },
  { "Jacinda", 0.0 },
  { "Jacine", 0.0 },
  { "Jacinta", 0.0 },
  { "Jacinth", 0.47826087 },
  { "Jacintha", 0.0 },
  { "Jacinto", 1.0 },
  { "Jacion", 1.0 },
  { "Jacione", 1.0 },
  { "Jacionna", 0.0 },
  { "Jacir", 1.0 },
  { "Jaciya", 0.0 },
  { "Jaciyah", 0.0 },
  { "Jaciyon", 1.0 },
  { "Jack", 0.9961177 },
  { "Jackalin", 0.0 },
  { "Jackaline", 0.0 },
  { "Jackalyn", 0.0 },
  { "Jackalynn", 0.0 },
  { "Jacke", 1.0 },
  { "Jackee", 0.0 },
  { "Jackelin", 0.0 },
  { "Jackeline", 0.0 },
  { "Jackelinne", 0.0 },
  { "Jackelyn", 0.0 },
  { "Jackelyne", 0.0 },
  { "Jackelynn", 0.0 },
  { "Jackey", 0.9472954 },
  { "Jackhenry", 1.0 },
  { "Jacki", 0.0014208582 },
  { "Jackia", 0.0 },
  { "Jackie", 0.4639088 },
  { "Jackielyn", 0.0 },
  { "Jackilyn", 0.0 },
  { "Jackilynn", 0.0 },
  { "Jackjohn", 1.0 },
  { "Jackleen", 0.0 },
  { "Jacklen", 0.0 },
  { "Jacklene", 0.0 },
  { "Jacklin", 0.0 },
  { "Jackline", 0.0 },
  { "Jacklon", 0.0 },
  { "Jacklyn", 0.0003071253 },
  { "Jacklyne", 0.0 },
  { "Jacklynn", 0.0 },
  { "Jacklynne", 0.0 },
  { "Jackman", 1.0 },
  { "Jackob", 1.0 },
  { "Jackolyn", 0.0 },
  { "Jackquelin", 0.0 },
  { "Jackqueline", 0.0 },
  { "Jackquelyn", 0.0 },
  { "Jackqulin", 0.0 },
  { "Jackquline", 0.0 },
  { "Jackqulyn", 0.0 },
  { "Jacks", 1.0 },
  { "Jacksen", 1.0 },
  { "Jacksin", 1.0 },
  { "Jackson", 0.99734765 },
  { "Jackston", 1.0 },
  { "Jacksyn", 0.79464287 },
  { "Jackthomas", 1.0 },
  { "Jackueline", 0.0 },
  { "Jacky", 0.8500728 },
  { "Jackye", 0.0 },
  { "Jacleen", 0.0 },
  { "Jaclene", 0.0 },
  { "Jaclin", 0.0 },
  { "Jaclyn", 0.0021114345 },
  { "Jaclyne", 0.0 },
  { "Jaclynn", 0.0 },
  { "Jaclynne", 0.0 },
  { "Jaco", 1.0 },
  { "Jacob", 0.99754834 },
  { "Jacoba", 0.0 },
  { "Jacobalexander", 1.0 },
  { "Jacobanthony", 1.0 },
  { "Jacobb", 1.0 },
  { "Jacobdaniel", 1.0 },
  { "Jacobe", 1.0 },
  { "Jacobee", 1.0 },
  { "Jacobey", 1.0 },
  { "Jacobi", 0.9181071 },
  { "Jacobia", 0.33333334 },
  { "Jacobian", 1.0 },
  { "Jacobie", 0.97317076 },
  { "Jacobjames", 1.0 },
  { "Jacoblee", 1.0 },
  { "Jacobmatthew", 1.0 },
  { "Jacobo", 1.0 },
  { "Jacobrobert", 1.0 },
  { "Jacobryan", 1.0 },
  { "Jacobs", 1.0 },
  { "Jacobson", 1.0 },
  { "Jacobthomas", 1.0 },
  { "Jacobus", 1.0 },
  { "Jacoby", 0.98778003 },
  { "Jacodi", 1.0 },
  { "Jacody", 1.0 },
  { "Jacolbi", 1.0 },
  { "Jacolby", 0.9893314 },
  { "Jacole", 0.03787879 },
  { "Jacolyn", 0.0 },
  { "Jacon", 1.0 },
  { "Jacop", 1.0 },
  { "Jacopo", 1.0 },
  { "Jacora", 0.0 },
  { "Jacore", 1.0 },
  { "Jacoree", 1.0 },
  { "Jacorey", 1.0 },
  { "Jacori", 0.98607886 },
  { "Jacoria", 0.0 },
  { "Jacorian", 1.0 },
  { "Jacorie", 1.0 },
  { "Jacorien", 1.0 },
  { "Jacorion", 1.0 },
  { "Jacorious", 1.0 },
  { "Jacorius", 1.0 },
  { "Jacorri", 1.0 },
  { "Jacorrian", 1.0 },
  { "Jacorrion", 1.0 },
  { "Jacory", 1.0 },
  { "Jacoub", 1.0 },
  { "Jacoury", 1.0 },
  { "Jacovian", 1.0 },
  { "Jacoy", 1.0 },
  { "Jacoya", 0.0 },
  { "Jacqeline", 0.0 },
  { "Jacqelyn", 0.0 },
  { "Jacqlene", 0.0 },
  { "Jacqline", 0.0 },
  { "Jacqlyn", 0.0 },
  { "Jacqlynn", 0.0 },
  { "Jacqua", 0.0 },
  { "Jacqual", 1.0 },
  { "Jacqualin", 0.0 },
  { "Jacqualine", 0.0 },
  { "Jacqualyn", 0.0 },
  { "Jacqualyne", 0.0 },
  { "Jacqualynn", 0.0 },
  { "Jacquan", 1.0 },
  { "Jacquana", 0.0 },
  { "Jacquane", 1.0 },
  { "Jacquanna", 0.0 },
  { "Jacquari", 1.0 },
  { "Jacquarius", 1.0 },
  { "Jacquay", 0.56666666 },
  { "Jacque", 0.32313442 },
  { "Jacquece", 0.0 },
  { "Jacquee", 0.0 },
  { "Jacquees", 1.0 },
  { "Jacquel", 0.30988592 },
  { "Jacqueleen", 0.0 },
  { "Jacquelen", 0.0 },
  { "Jacquelene", 0.0 },
  { "Jacqueli", 0.0 },
  { "Jacquelin", 0.0 },
  { "Jacquelina", 0.0 },
  { "Jacqueline", 0.0032913173 },
  { "Jacqueling", 0.0 },
  { "Jacquelinne", 0.0 },
  { "Jacquell", 0.516129 },
  { "Jacquella", 0.0 },
  { "Jacquelle", 0.0 },
  { "Jacquelline", 0.0 },
  { "Jacquely", 0.0 },
  { "Jacquelyn", 0.0013053591 },
  { "Jacquelyne", 0.0 },
  { "Jacquelynn", 0.0 },
  { "Jacquelynne", 0.0 },
  { "Jacquenette", 0.0 },
  { "Jacques", 0.9741977 },
  { "Jacquese", 0.39430895 },
  { "Jacquesha", 0.0 },
  { "Jacquetta", 0.0 },
  { "Jacquette", 0.0 },
  { "Jacquez", 1.0 },
  { "Jacqueze", 1.0 },
  { "Jacqui", 0.014705882 },
  { "Jacquia", 0.0 },
  { "Jacquie", 0.0 },
  { "Jacquil", 1.0 },
  { "Jacquiline", 0.0 },
  { "Jacquilla", 0.0 },
  { "Jacquille", 1.0 },
  { "Jacquilyn", 0.0 },
  { "Jacquilynn", 0.0 },
  { "Jacquin", 0.67391306 },
  { "Jacquis", 0.88505745 },
  { "Jacquise", 0.60833335 },
  { "Jacquisha", 0.0 },
  { "Jacquita", 0.0 },
  { "Jacquitta", 0.0 },
  { "Jacquleen", 0.0 },
  { "Jacqulene", 0.0 },
  { "Jacqulin", 0.0 },
  { "Jacqulina", 0.0 },
  { "Jacquline", 0.0 },
  { "Jacqulyn", 0.0 },
  { "Jacqulyne", 0.0 },
  { "Jacqulynn", 0.0 },
  { "Jacquoline", 0.0 },
  { "Jacquolyn", 0.0 },
  { "Jacquon", 1.0 },
  { "Jacsen", 1.0 },
  { "Jacson", 1.0 },
  { "Jacub", 1.0 },
  { "Jacueline", 0.0 },
  { "Jaculin", 0.0 },
  { "Jaculine", 0.0 },
  { "Jacy", 0.17770392 },
  { "Jacyeon", 1.0 },
  { "Jacyion", 1.0 },
  { "Jacyln", 0.0 },
  { "Jacylyn", 0.0 },
  { "Jacyn", 0.5 },
  { "Jacynda", 0.0 },
  { "Jacynth", 0.0 },
  { "Jacynthia", 0.0 },
  { "Jacyon", 1.0 },
  { "Jacyra", 0.0 },
  { "Jad", 1.0 },
  { "Jada", 0.0038166132 },
  { "Jadaan", 1.0 },
  { "Jadae", 0.0 },
  { "Jadah", 0.0 },
  { "Jadai", 0.0 },
  { "Jadaiah", 0.0 },
  { "Jadaija", 0.0 },
  { "Jadaisha", 0.0 },
  { "Jadakis", 1.0 },
  { "Jadakiss", 0.8712871 },
  { "Jadalee", 0.0 },
  { "Jadali", 0.0 },
  { "Jadalin", 0.0 },
  { "Jadalise", 0.0 },
  { "Jadaliz", 0.0 },
  { "Jadalyn", 0.0 },
  { "Jadalynn", 0.0 },
  { "Jadalys", 0.0 },
  { "Jadalyse", 0.0 },
  { "Jadamarie", 0.0 },
  { "Jadan", 0.76571035 },
  { "Jadaria", 0.0 },
  { "Jadarian", 1.0 },
  { "Jadarien", 1.0 },
  { "Jadarion", 1.0 },
  { "Jadarious", 1.0 },
  { "Jadarius", 1.0 },
  { "Jadarose", 0.0 },
  { "Jadarrian", 1.0 },
  { "Jadarrien", 1.0 },
  { "Jadarrion", 1.0 },
  { "Jadarrious", 1.0 },
  { "Jadarrius", 1.0 },
  { "Jadasha", 0.0 },
  { "Jadasia", 0.0 },
  { "Jadaveon", 1.0 },
  { "Jadavian", 1.0 },
  { "Jadavion", 1.0 },
  { "Jadaya", 0.0 },
  { "Jadayah", 0.0 },
  { "Jadd", 1.0 },
  { "Jadda", 0.0 },
  { "Jaddan", 1.0 },
  { "Jadden", 0.9161677 },
  { "Jaddiel", 1.0 },
  { "Jade", 0.06419434 },
  { "Jadea", 0.0 },
  { "Jadeah", 0.0 },
  { "Jadean", 0.25 },
  { "Jadeann", 0.0 },
  { "Jaded", 0.0 },
  { "Jadee", 0.0 },
  { "Jadeen", 0.25 },
  { "Jadein", 1.0 },
  { "Jadel", 1.0 },
  { "Jadelin", 0.0 },
  { "Jadeline", 0.0 },
  { "Jadell", 1.0 },
  { "Jadelyn", 0.0 },
  { "Jadelynn", 0.0 },
  { "Jadelynne", 0.0 },
  { "Jademarie", 0.0 },
  { "Jaden", 0.84259 },
  { "Jadence", 0.15706806 },
  { "Jadene", 0.0 },
  { "Jadenn", 0.875 },
  { "Jadenne", 0.0 },
  { "Jadeon", 1.0 },
  { "Jader", 1.0 },
  { "Jadereon", 1.0 },
  { "Jaderian", 1.0 },
  { "Jaderion", 1.0 },
  { "Jaderious", 1.0 },
  { "Jaderius", 1.0 },
  { "Jaderrick", 1.0 },
  { "Jadesha", 0.0 },
  { "Jadesola", 0.0 },
  { "Jadeth", 0.0 },
  { "Jadeveon", 1.0 },
  { "Jadey", 0.0 },
  { "Jadeyn", 0.061516453 },
  { "Jadha", 0.0 },
  { "Jadhiel", 1.0 },
  { "Jadi", 0.0 },
  { "Jadia", 0.0 },
  { "Jadiah", 0.59375 },
  { "Jadiamond", 0.0 },
  { "Jadian", 0.8873239 },
  { "Jadiana", 0.0 },
  { "Jadie", 0.07953064 },
  { "Jadiel", 1.0 },
  { "Jadielys", 0.0 },
  { "Jadien", 0.87083334 },
  { "Jadier", 1.0 },
  { "Jadin", 0.6959811 },
  { "Jadine", 0.0 },
  { "Jadir", 1.0 },
  { "Jadira", 0.0 },
  { "Jadis", 0.52014655 },
  { "Jadison", 1.0 },
  { "Jadiss", 1.0 },
  { "Jadius", 1.0 },
  { "Jadiyah", 0.0 },
  { "Jadlyn", 0.0 },
  { "Jadlynn", 0.0 },
  { "Jadn", 1.0 },
  { "Jadon", 0.98236406 },
  { "Jadonna", 0.0 },
  { "Jadonte", 1.0 },
  { "Jadora", 0.0 },
  { "Jadore", 0.09508716 },
  { "Jadrian", 0.9084249 },
  { "Jadriel", 1.0 },
  { "Jadrien", 0.98554915 },
  { "Jadus", 1.0 },
  { "Jadwiga", 0.0 },
  { "Jady", 0.024630541 },
  { "Jadyel", 1.0 },
  { "Jadyen", 1.0 },
  { "Jadyn", 0.22464655 },
  { "Jadynce", 0.0 },
  { "Jadyne", 0.45833334 },
  { "Jadynn", 0.059753954 },
  { "Jadynne", 0.0 },
  { "Jadzia", 0.0 },
  { "Jadziah", 0.0 },
  { "Jae", 0.5621688 },
  { "Jaea", 0.0 },
  { "Jaeana", 0.0 },
  { "Jaeanna", 0.0 },
  { "Jaece", 1.0 },
  { "Jaecee", 0.0 },
  { "Jaeceion", 1.0 },
  { "Jaeceon", 1.0 },
  { "Jaeci", 0.0 },
  { "Jaecia", 0.0 },
  { "Jaecion", 1.0 },
  { "Jaecob", 1.0 },
  { "Jaecyon", 1.0 },
  { "Jaeda", 0.0 },
  { "Jaedah", 0.0 },
  { "Jaedalyn", 0.0 },
  { "Jaedan", 0.8485401 },
  { "Jaede", 0.0 },
  { "Jaeden", 0.8434298 },
  { "Jaedin", 0.7732342 },
  { "Jaedon", 0.98421055 },
  { "Jaedyn", 0.43070114 },
  { "Jaedynn", 0.1 },
  { "Jaegar", 1.0 },
  { "Jaeger", 1.0 },
  { "Jaekob", 1.0 },
  { "Jaekwon", 1.0 },
  { "Jael", 0.39619827 },
  { "Jaela", 0.0 },
  { "Jaelah", 0.0 },
  { "Jaelan", 0.8592058 },
  { "Jaelani", 0.0 },
  { "Jaelanie", 0.0 },
  { "Jaelea", 0.0 },
  { "Jaeleah", 0.0 },
  { "Jaelee", 0.0 },
  { "Jaeleen", 0.0 },
  { "Jaelei", 0.0 },
  { "Jaeleigh", 0.0 },
  { "Jaelen", 0.8507565 },
  { "Jaelene", 0.0 },
  { "Jaeley", 0.0 },
  { "Jaeli", 0.0 },
  { "Jaelia", 0.0 },
  { "Jaeliah", 0.0 },
  { "Jaeliana", 0.0 },
  { "Jaeliani", 0.0 },
  { "Jaelianna", 0.0 },
  { "Jaelie", 0.0 },
  { "Jaelin", 0.5730503 },
  { "Jaelina", 0.0 },
  { "Jaeline", 0.0 },
  { "Jaelinn", 0.0 },
  { "Jaelithe", 0.0 },
  { "Jaeliyah", 0.0 },
  { "Jaell", 1.0 },
  { "Jaella", 0.0 },
  { "Jaelle", 0.0 },
  { "Jaelon", 1.0 },
  { "Jaely", 0.0 },
  { "Jaelyn", 0.08352932 },
  { "Jaelyne", 0.0 },
  { "Jaelynn", 0.01398218 },
  { "Jaelynne", 0.0 },
  { "Jaelys", 0.0 },
  { "Jaemarie", 0.0 },
  { "Jaemeson", 1.0 },
  { "Jaemi", 0.0 },
  { "Jaemie", 0.0 },
  { "Jaemin", 1.0 },
  { "Jaemir", 1.0 },
  { "Jaemon", 1.0 },
  { "Jaems", 1.0 },
  { "Jaen", 1.0 },
  { "Jaena", 0.0 },
  { "Jaenelle", 0.0 },
  { "Jaeon", 1.0 },
  { "Jaeona", 0.0 },
  { "Jaeonna", 0.0 },
  { "Jaequan", 1.0 },
  { "Jaeron", 1.0 },
  { "Jaes", 1.0 },
  { "Jaesa", 0.0 },
  { "Jaesean", 1.0 },
  { "Jaesha", 0.0 },
  { "Jaeshaun", 1.0 },
  { "Jaeshawn", 1.0 },
  { "Jaeshon", 1.0 },
  { "Jaeson", 1.0 },
  { "Jaesun", 1.0 },
  { "Jaesyn", 1.0 },
  { "Jaethan", 1.0 },
  { "Jaetyn", 1.0 },
  { "Jaevaughn", 1.0 },
  { "Jaeven", 1.0 },
  { "Jaeveon", 1.0 },
  { "Jaevian", 1.0 },
  { "Jaevien", 1.0 },
  { "Jaevier", 1.0 },
  { "Jaevin", 1.0 },
  { "Jaevion", 1.0 },
  { "Jaevon", 1.0 },
  { "Jaevyn", 1.0 },
  { "Jaewon", 1.0 },
  { "Jaewoo", 1.0 },
  { "Jaeya", 0.0 },
  { "Jaeyla", 0.0 },
  { "Jaeyon", 1.0 },
  { "Jafar", 1.0 },
  { "Jafari", 1.0 },
  { "Jafer", 1.0 },
  { "Jafet", 1.0 },
  { "Jafeth", 1.0 },
  { "Jaffar", 1.0 },
  { "Jaffer", 1.0 },
  { "Jaffet", 1.0 },
  { "Jafus", 1.0 },
  { "Jag", 1.0 },
  { "Jagan", 1.0 },
  { "Jagar", 1.0 },
  { "Jagdeep", 1.0 },
  { "Jagen", 1.0 },
  { "Jager", 1.0 },
  { "Jaggar", 1.0 },
  { "Jagger", 0.9845294 },
  { "Jaggyr", 1.0 },
  { "Jagjit", 1.0 },
  { "Jagjot", 1.0 },
  { "Jagmeet", 1.0 },
  { "Jago", 1.0 },
  { "Jagr", 1.0 },
  { "Jagroop", 1.0 },
  { "Jaguar", 1.0 },
  { "Jagur", 1.0 },
  { "Jah", 1.0 },
  { "Jahaad", 1.0 },
  { "Jahaan", 0.95 },
  { "Jahad", 1.0 },
  { "Jahai", 1.0 },
  { "Jahaida", 0.0 },
  { "Jahair", 1.0 },
  { "Jahaira", 0.0 },
  { "Jahaire", 1.0 },
  { "Jahairy", 0.0 },
  { "Jahala", 0.0 },
  { "Jahan", 0.94483984 },
  { "Jahana", 0.0 },
  { "Jahanara", 0.0 },
  { "Jahanna", 0.0 },
  { "Jahara", 0.027322404 },
  { "Jahare", 1.0 },
  { "Jaharee", 1.0 },
  { "Jahari", 0.9010989 },
  { "Jaharie", 1.0 },
  { "Jaharri", 1.0 },
  { "Jahasia", 0.0 },
  { "Jahaud", 1.0 },
  { "Jahaun", 1.0 },
  { "Jahaven", 1.0 },
  { "Jahayra", 0.0 },
  { "Jahaziah", 1.0 },
  { "Jahaziel", 1.0 },
  { "Jahbari", 1.0 },
  { "Jahcari", 1.0 },
  { "Jahcere", 1.0 },
  { "Jahcure", 1.0 },
  { "Jahda", 0.0 },
  { "Jahdae", 0.0 },
  { "Jahdai", 0.33333334 },
  { "Jahdari", 1.0 },
  { "Jahde", 0.0 },
  { "Jahden", 1.0 },
  { "Jahdiel", 1.0 },
  { "Jahdir", 1.0 },
  { "Jahdon", 1.0 },
  { "Jaheam", 1.0 },
  { "Jaheed", 1.0 },
  { "Jaheem", 1.0 },
  { "Jaheen", 1.0 },
  { "Jaheer", 1.0 },
  { "Jaheim", 0.99858356 },
  { "Jaheir", 1.0 },
  { "Jahel", 0.96644294 },
  { "Jahem", 1.0 },
  { "Jahfari", 1.0 },
  { "Jahi", 1.0 },
  { "Jahia", 0.0 },
  { "Jahid", 1.0 },
  { "Jahida", 0.0 },
  { "Jahidi", 1.0 },
  { "Jahiel", 1.0 },
  { "Jahiem", 1.0 },
  { "Jahier", 1.0 },
  { "Jahim", 1.0 },
  { "Jahime", 1.0 },
  { "Jahin", 1.0 },
  { "Jahir", 1.0 },
  { "Jahira", 0.0 },
  { "Jahirah", 0.0 },
  { "Jahiro", 1.0 },
  { "Jahiya", 0.0 },
  { "Jahiyah", 0.0 },
  { "Jahjuan", 1.0 },
  { "Jahkai", 1.0 },
  { "Jahkari", 1.0 },
  { "Jahkayla", 0.0 },
  { "Jahkeem", 1.0 },
  { "Jahkeim", 1.0 },
  { "Jahkel", 1.0 },
  { "Jahkhi", 1.0 },
  { "Jahki", 1.0 },
  { "Jahkia", 0.0 },
  { "Jahkim", 1.0 },
  { "Jahking", 1.0 },
  { "Jahkir", 1.0 },
  { "Jahkira", 0.0 },
  { "Jahkobe", 1.0 },
  { "Jahkobi", 1.0 },
  { "Jahkye", 1.0 },
  { "Jahla", 0.0 },
  { "Jahlani", 0.9447236 },
  { "Jahlaya", 0.0 },
  { "Jahlayah", 0.0 },
  { "Jahlea", 0.0 },
  { "Jahleah", 0.0 },
  { "Jahleal", 1.0 },
  { "Jahlee", 1.0 },
  { "Jahleel", 1.0 },
  { "Jahleil", 1.0 },
  { "Jahlen", 1.0 },
  { "Jahleya", 0.0 },
  { "Jahlia", 0.0 },
  { "Jahliah", 0.0 },
  { "Jahliel", 1.0 },
  { "Jahlik", 1.0 },
  { "Jahlil", 1.0 },
  { "Jahlin", 1.0 },
  { "Jahlique", 1.0 },
  { "Jahlisa", 0.0 },
  { "Jahlissa", 0.0 },
  { "Jahliya", 0.0 },
  { "Jahliyah", 0.0 },
  { "Jahlon", 1.0 },
  { "Jahlyn", 1.0 },
  { "Jahlynn", 0.0 },
  { "Jahmaad", 1.0 },
  { "Jahmaal", 1.0 },
  { "Jahmad", 1.0 },
  { "Jahmai", 1.0 },
  { "Jahmaine", 1.0 },
  { "Jahmair", 1.0 },
  { "Jahmal", 1.0 },
  { "Jahmali", 1.0 },
  { "Jahmall", 1.0 },
  { "Jahmani", 1.0 },
  { "Jahmar", 1.0 },
  { "Jahmarcus", 1.0 },
  { "Jahmaree", 1.0 },
  { "Jahmari", 1.0 },
  { "Jahmarion", 1.0 },
  { "Jahmarley", 1.0 },
  { "Jahmauri", 1.0 },
  { "Jahmaya", 0.0 },
  { "Jahmeek", 1.0 },
  { "Jahmeel", 1.0 },
  { "Jahmeer", 1.0 },
  { "Jahmeir", 1.0 },
  { "Jahmel", 1.0 },
  { "Jahmela", 0.0 },
  { "Jahmelia", 0.0 },
  { "Jahmell", 1.0 },
  { "Jahmere", 1.0 },
  { "Jahmez", 1.0 },
  { "Jahmi", 1.0 },
  { "Jahmia", 0.0 },
  { "Jahmiah", 0.23913044 },
  { "Jahmiel", 1.0 },
  { "Jahmier", 1.0 },
  { "Jahmiere", 1.0 },
  { "Jahmil", 1.0 },
  { "Jahmila", 0.0 },
  { "Jahmir", 1.0 },
  { "Jahmira", 0.0 },
  { "Jahmire", 1.0 },
  { "Jahmiya", 0.0 },
  { "Jahmiyah", 0.0 },
  { "Jahmon", 1.0 },
  { "Jahmya", 0.0 },
  { "Jahmyah", 0.0 },
  { "Jahmyia", 0.0 },
  { "Jahn", 1.0 },
  { "Jahna", 0.0 },
  { "Jahnae", 0.0 },
  { "Jahnai", 0.096491225 },
  { "Jahnari", 0.20833333 },
  { "Jahnasia", 0.0 },
  { "Jahnathan", 1.0 },
  { "Jahnavi", 0.0 },
  { "Jahnay", 0.0 },
  { "Jahnaya", 0.0 },
  { "Jahne", 0.0 },
  { "Jahnea", 0.0 },
  { "Jahnee", 0.0 },
  { "Jahneil", 1.0 },
  { "Jahnel", 0.0 },
  { "Jahnell", 0.0 },
  { "Jahnelle", 0.0 },
  { "Jahnessa", 0.0 },
  { "Jahni", 0.41262135 },
  { "Jahnia", 0.0 },
  { "Jahniah", 0.0 },
  { "Jahnice", 0.0 },
  { "Jahniece", 0.0 },
  { "Jahniel", 1.0 },
  { "Jahnique", 0.0 },
  { "Jahnise", 0.0 },
  { "Jahniya", 0.0 },
  { "Jahniyah", 0.0 },
  { "Jahnna", 0.0 },
  { "Jahnvi", 0.0 },
  { "Jahnya", 0.0 },
  { "Jahnyah", 0.0 },
  { "Jahnyia", 0.0 },
  { "Jahnyla", 0.0 },
  { "Jahod", 1.0 },
  { "Jahon", 1.0 },
  { "Jahongir", 1.0 },
  { "Jahonna", 0.0 },
  { "Jahquan", 1.0 },
  { "Jahque", 1.0 },
  { "Jahquel", 1.0 },
  { "Jahquell", 1.0 },
  { "Jahquez", 1.0 },
  { "Jahray", 1.0 },
  { "Jahred", 1.0 },
  { "Jahree", 1.0 },
  { "Jahrel", 1.0 },
  { "Jahrell", 1.0 },
  { "Jahri", 1.0 },
  { "Jahria", 0.0 },
  { "Jahriah", 0.0 },
  { "Jahriel", 1.0 },
  { "Jahrod", 1.0 },
  { "Jahron", 1.0 },
  { "Jahsai", 1.0 },
  { "Jahsan", 1.0 },
  { "Jahsean", 1.0 },
  { "Jahseem", 1.0 },
  { "Jahseer", 1.0 },
  { "Jahseim", 1.0 },
  { "Jahseir", 1.0 },
  { "Jahshaun", 1.0 },
  { "Jahshawn", 1.0 },
  { "Jahshua", 1.0 },
  { "Jahsi", 1.0 },
  { "Jahsiah", 1.0 },
  { "Jahsier", 1.0 },
  { "Jahsim", 1.0 },
  { "Jahsir", 1.0 },
  { "Jahsire", 1.0 },
  { "Jahsiyah", 1.0 },
  { "Jahson", 1.0 },
  { "Jahsun", 1.0 },
  { "Jahtavious", 1.0 },
  { "Jahvari", 1.0 },
  { "Jahvaughn", 1.0 },
  { "Jahvel", 1.0 },
  { "Jahvier", 1.0 },
  { "Jahvion", 1.0 },
  { "Jahvon", 1.0 },
  { "Jahvonte", 1.0 },
  { "Jahwan", 1.0 },
  { "Jahya", 0.0 },
  { "Jahyda", 0.0 },
  { "Jahyden", 1.0 },
  { "Jahyr", 1.0 },
  { "Jahyra", 0.0 },
  { "Jahzair", 1.0 },
  { "Jahzara", 0.0 },
  { "Jahzarah", 0.0 },
  { "Jahzari", 0.0 },
  { "Jahzaria", 0.0 },
  { "Jahzarra", 0.0 },
  { "Jahzeel", 0.75132275 },
  { "Jahzel", 0.07936508 },
  { "Jahzell", 0.0 },
  { "Jahzelle", 0.0 },
  { "Jahziah", 0.9017341 },
  { "Jahziel", 0.9558824 },
  { "Jahzier", 1.0 },
  { "Jahzion", 1.0 },
  { "Jahzir", 1.0 },
  { "Jahziya", 0.0 },
  { "Jahziyah", 0.0 },
  { "Jahzlynn", 0.0 },
  { "Jahzon", 1.0 },
  { "Jai", 0.783105 },
  { "Jaia", 0.0 },
  { "Jaiah", 0.0 },
  { "Jaiana", 0.0 },
  { "Jaianna", 0.0 },
  { "Jaiannah", 0.0 },
  { "Jaice", 0.8229167 },
  { "Jaicee", 0.0 },
  { "Jaiceion", 1.0 },
  { "Jaicen", 1.0 },
  { "Jaiceon", 1.0 },
  { "Jaicey", 0.0 },
  { "Jaiceyon", 1.0 },
  { "Jaici", 0.0 },
  { "Jaicie", 0.0 },
  { "Jaicion", 1.0 },
  { "Jaico", 1.0 },
  { "Jaicob", 1.0 },
  { "Jaicyon", 1.0 },
  { "Jaid", 0.028901733 },
  { "Jaida", 0.0 },
  { "Jaidah", 0.0 },
  { "Jaidalyn", 0.0 },
  { "Jaidalynn", 0.0 },
  { "Jaidan", 0.6127285 },
  { "Jaidden", 1.0 },
  { "Jaide", 0.0 },
  { "Jaidee", 0.0 },
  { "Jaideep", 1.0 },
  { "Jaidel", 1.0 },
  { "Jaidelyn", 0.0 },
  { "Jaiden", 0.76834327 },
  { "Jaidence", 0.13636364 },
  { "Jaidenn", 1.0 },
  { "Jaidev", 1.0 },
  { "Jaidi", 0.0 },
  { "Jaidin", 0.60625 },
  { "Jaidlyn", 0.0 },
  { "Jaidn", 1.0 },
  { "Jaidon", 0.9513473 },
  { "Jaidy", 0.0 },
  { "Jaidyn", 0.34131885 },
  { "Jaidynn", 0.121212125 },
  { "Jaie", 0.14705883 },
  { "Jaiel", 0.5555556 },
  { "Jaielle", 0.0 },
  { "Jaier", 1.0 },
  { "Jaiheem", 1.0 },
  { "Jaiheim", 1.0 },
  { "Jaiiden", 1.0 },
  { "Jaijuan", 1.0 },
  { "Jaik", 1.0 },
  { "Jaikob", 1.0 },
  { "Jaikub", 1.0 },
  { "Jaila", 0.0 },
  { "Jailah", 0.0 },
  { "Jailan", 0.82222223 },
  { "Jailani", 0.0 },
  { "Jaileah", 0.0 },
  { "Jailee", 0.0 },
  { "Jaileen", 0.0 },
  { "Jaileene", 0.0 },
  { "Jailei", 0.0 },
  { "Jaileigh", 0.0 },
  { "Jailen", 0.8068182 },
  { "Jailene", 0.0 },
  { "Jailenne", 0.0 },
  { "Jailey", 0.0 },
  { "Jaili", 0.0 },
  { "Jailia", 0.0 },
  { "Jailin", 0.4090909 },
  { "Jailine", 0.0 },
  { "Jailinne", 0.0 },
  { "Jailiyah", 0.0 },
  { "Jailon", 1.0 },
  { "Jaily", 0.0 },
  { "Jailyn", 0.1366382 },
  { "Jailyne", 0.0 },
  { "Jailynn", 0.023000523 },
  { "Jailynne", 0.0 },
  { "Jaima", 0.0 },
  { "Jaimal", 1.0 },
  { "Jaiman", 1.0 },
  { "Jaimar", 1.0 },
  { "Jaimari", 1.0 },
  { "Jaimarie", 0.0 },
  { "Jaimarion", 1.0 },
  { "Jaimaya", 0.0 },
  { "Jaime", 0.57447463 },
  { "Jaimee", 0.009621839 },
  { "Jaimelee", 0.0 },
  { "Jaimelyn", 0.0 },
  { "Jaimelynn", 0.0 },
  { "Jaimen", 1.0 },
  { "Jaimere", 1.0 },
  { "Jaimes", 1.0 },
  { "Jaimeson", 0.9377432 },
  { "Jaimey", 0.1724138 },
  { "Jaimi", 0.0 },
  { "Jaimie", 0.086893484 },
  { "Jaimielee", 0.0 },
  { "Jaimin", 1.0 },
  { "Jaimir", 1.0 },
  { "Jaimison", 0.75 },
  { "Jaimmie", 0.0 },
  { "Jaimon", 1.0 },
  { "Jaimy", 0.07073171 },
  { "Jaimya", 0.0 },
  { "Jaimyn", 1.0 },
  { "Jaimz", 1.0 },
  { "Jain", 0.0 },
  { "Jaina", 0.0 },
  { "Jainaba", 0.0 },
  { "Jainah", 0.0 },
  { "Jaine", 0.0 },
  { "Jainee", 0.0 },
  { "Jaini", 0.0 },
  { "Jainie", 0.0 },
  { "Jainil", 1.0 },
  { "Jainiya", 0.0 },
  { "Jainiyah", 0.0 },
  { "Jainy", 0.0 },
  { "Jaion", 1.0 },
  { "Jaiona", 0.0 },
  { "Jaionna", 0.0 },
  { "Jaiquan", 1.0 },
  { "Jaiquez", 1.0 },
  { "Jair", 0.9979783 },
  { "Jaira", 0.0 },
  { "Jairah", 0.0 },
  { "Jairdan", 1.0 },
  { "Jairden", 1.0 },
  { "Jaire", 0.9100257 },
  { "Jaired", 1.0 },
  { "Jairee", 1.0 },
  { "Jairen", 1.0 },
  { "Jairius", 1.0 },
  { "Jairo", 1.0 },
  { "Jairon", 1.0 },
  { "Jairus", 1.0 },
  { "Jairy", 0.0 },
  { "Jais", 1.0 },
  { "Jaisa", 0.0 },
  { "Jaisal", 1.0 },
  { "Jaise", 0.92156863 },
  { "Jaisean", 1.0 },
  { "Jaisen", 1.0 },
  { "Jaiseon", 1.0 },
  { "Jaisha", 0.0 },
  { "Jaishaun", 1.0 },
  { "Jaishawn", 1.0 },
  { "Jaishon", 1.0 },
  { "Jaisiah", 1.0 },
  { "Jaisley", 0.0 },
  { "Jaislyn", 0.0 },
  { "Jaison", 1.0 },
  { "Jaisy", 0.0 },
  { "Jaisyn", 0.5 },
  { "Jaithan", 1.0 },
  { "Jaithen", 1.0 },
  { "Jaiton", 1.0 },
  { "Jaival", 1.0 },
  { "Jaivan", 1.0 },
  { "Jaiveer", 1.0 },
  { "Jaiven", 1.0 },
  { "Jaiveon", 1.0 },
  { "Jaiver", 1.0 },
  { "Jaivian", 1.0 },
  { "Jaivien", 1.0 },
  { "Jaivin", 1.0 },
  { "Jaivion", 1.0 },
  { "Jaivon", 1.0 },
  { "Jaivyn", 1.0 },
  { "Jaivyon", 1.0 },
  { "Jaiwan", 1.0 },
  { "Jaiya", 0.0 },
  { "Jaiyah", 0.0 },
  { "Jaiyana", 0.0 },
  { "Jaiyanna", 0.0 },
  { "Jaiyce", 1.0 },
  { "Jaiyda", 0.0 },
  { "Jaiyden", 0.9677419 },
  { "Jaiyla", 0.0 },
  { "Jaiylah", 0.0 },
  { "Jaiyon", 1.0 },
  { "Jaiza", 0.0 },
  { "Jaizen", 1.0 },
  { "Jaizon", 1.0 },
  { "Jaja", 1.0 },
  { "Jajaira", 0.0 },
  { "Jajaun", 1.0 },
  { "Jajuan", 0.99523395 },
  { "Jajuana", 0.0 },
  { "Jajuane", 1.0 },
  { "Jak", 1.0 },
  { "Jakab", 1.0 },
  { "Jakada", 0.0 },
  { "Jakaden", 1.0 },
  { "Jakaela", 0.0 },
  { "Jakahri", 1.0 },
  { "Jakai", 0.9080861 },
  { "Jakaia", 0.0 },
  { "Jakaiden", 1.0 },
  { "Jakaila", 0.0 },
  { "Jakailah", 0.0 },
  { "Jakailyn", 0.0 },
  { "Jakaira", 0.0 },
  { "Jakaiya", 0.0 },
  { "Jakaiyah", 0.0 },
  { "Jakala", 0.0 },
  { "Jakalah", 0.0 },
  { "Jakale", 1.0 },
  { "Jakaleb", 1.0 },
  { "Jakalen", 1.0 },
  { "Jakalia", 0.0 },
  { "Jakalya", 0.0 },
  { "Jakalyn", 0.0 },
  { "Jakalynn", 0.0 },
  { "Jakameron", 1.0 },
  { "Jakanye", 1.0 },
  { "Jakar", 1.0 },
  { "Jakara", 0.0 },
  { "Jakarah", 0.0 },
  { "Jakare", 1.0 },
  { "Jakaree", 1.0 },
  { "Jakari", 0.9277467 },
  { "Jakaria", 0.0 },
  { "Jakarie", 1.0 },
  { "Jakarii", 1.0 },
  { "Jakarion", 1.0 },
  { "Jakarious", 1.0 },
  { "Jakaris", 1.0 },
  { "Jakarius", 1.0 },
  { "Jakarra", 0.0 },
  { "Jakarri", 1.0 },
  { "Jakashia", 0.0 },
  { "Jakasia", 0.0 },
  { "Jakauri", 1.0 },
  { "Jakavian", 1.0 },
  { "Jakavion", 1.0 },
  { "Jakavious", 1.0 },
  { "Jakaya", 0.0 },
  { "Jakayah", 0.0 },
  { "Jakayden", 1.0 },
  { "Jakayia", 0.0 },
  { "Jakayla", 0.0 },
  { "Jakaylah", 0.0 },
  { "Jakayle", 0.0 },
  { "Jakaylee", 0.0 },
  { "Jakaylen", 1.0 },
  { "Jakaylin", 0.2 },
  { "Jakaylon", 1.0 },
  { "Jake", 0.9982389 },
  { "Jakea", 0.0 },
  { "Jakeal", 1.0 },
  { "Jakeara", 0.0 },
  { "Jakeb", 1.0 },
  { "Jakeel", 1.0 },
  { "Jakeela", 0.0 },
  { "Jakeelah", 0.0 },
  { "Jakeem", 1.0 },
  { "Jakeena", 0.0 },
  { "Jakeia", 0.0 },
  { "Jakeil", 1.0 },
  { "Jakeim", 1.0 },
  { "Jakeira", 0.0 },
  { "Jakeisha", 0.0 },
  { "Jakeith", 1.0 },
  { "Jakeitha", 0.0 },
  { "Jakel", 0.96153843 },
  { "Jakela", 0.0 },
  { "Jakelia", 0.0 },
  { "Jakelin", 0.0 },
  { "Jakeline", 0.0 },
  { "Jakell", 0.962963 },
  { "Jakelle", 0.0 },
  { "Jakelyn", 0.0 },
  { "Jakelyne", 0.0 },
  { "Jakelynn", 0.0 },
  { "Jakema", 0.0 },
  { "Jaken", 1.0 },
  { "Jakendra", 0.0 },
  { "Jakendrick", 1.0 },
  { "Jakenya", 0.0 },
  { "Jakenzie", 0.0 },
  { "Jakeob", 1.0 },
  { "Jakera", 0.0 },
  { "Jakerah", 0.0 },
  { "Jakeria", 0.0 },
  { "Jakerion", 1.0 },
  { "Jakeriya", 0.0 },
  { "Jakerra", 0.0 },
  { "Jakerria", 0.0 },
  { "Jakeryan", 1.0 },
  { "Jakesha", 0.0 },
  { "Jakeshia", 0.0 },
  { "Jaketa", 0.0 },
  { "Jakeveon", 1.0 },
  { "Jakevia", 0.0 },
  { "Jakevion", 1.0 },
  { "Jakevious", 1.0 },
  { "Jakevis", 1.0 },
  { "Jakey", 1.0 },
  { "Jakeya", 0.0 },
  { "Jakeyah", 0.0 },
  { "Jakeyla", 0.0 },
  { "Jakhai", 0.98 },
  { "Jakhari", 1.0 },
  { "Jakhi", 1.0 },
  { "Jakhia", 0.0 },
  { "Jakhira", 0.0 },
  { "Jakhiya", 0.0 },
  { "Jakhy", 1.0 },
  { "Jakhya", 0.0 },
  { "Jakhye", 1.0 },
  { "Jakhyia", 0.0 },
  { "Jakhyla", 0.0 },
  { "Jaki", 0.6632997 },
  { "Jakia", 0.0 },
  { "Jakiah", 0.13004485 },
  { "Jakiara", 0.0 },
  { "Jakiaya", 0.0 },
  { "Jakie", 0.9780928 },
  { "Jakiel", 1.0 },
  { "Jakiem", 1.0 },
  { "Jakier", 1.0 },
  { "Jakiera", 0.0 },
  { "Jakierra", 0.0 },
  { "Jakii", 1.0 },
  { "Jakil", 1.0 },
  { "Jakila", 0.0 },
  { "Jakilah", 0.0 },
  { "Jakim", 1.0 },
  { "Jakima", 0.0 },
  { "Jakin", 1.0 },
  { "Jaking", 1.0 },
  { "Jakir", 1.0 },
  { "Jakira", 0.0 },
  { "Jakirah", 0.0 },
  { "Jakiria", 0.0 },
  { "Jakirra", 0.0 },
  { "Jakirrah", 0.0 },
  { "Jakirria", 0.0 },
  { "Jakisha", 0.0 },
  { "Jakita", 0.0 },
  { "Jakius", 1.0 },
  { "Jakiya", 0.0 },
  { "Jakiyah", 0.0 },
  { "Jakiyla", 0.0 },
  { "Jakiylah", 0.0 },
  { "Jakiyra", 0.0 },
  { "Jakk", 1.0 },
  { "Jakkar", 1.0 },
  { "Jakki", 0.0 },
  { "Jakkia", 0.33333334 },
  { "Jakkob", 1.0 },
  { "Jakkson", 1.0 },
  { "Jaklyn", 0.0 },
  { "Jaklynn", 0.0 },
  { "Jakob", 1.0 },
  { "Jakobe", 1.0 },
  { "Jakobee", 1.0 },
  { "Jakobey", 1.0 },
  { "Jakobi", 0.980445 },
  { "Jakobie", 1.0 },
  { "Jakoby", 1.0 },
  { "Jakoda", 1.0 },
  { "Jakodi", 1.0 },
  { "Jakolbe", 1.0 },
  { "Jakolbi", 1.0 },
  { "Jakolby", 1.0 },
  { "Jakora", 0.0 },
  { "Jakorey", 1.0 },
  { "Jakori", 0.9883721 },
  { "Jakoria", 0.0 },
  { "Jakorian", 1.0 },
  { "Jakorie", 1.0 },
  { "Jakory", 1.0 },
  { "Jakota", 1.0 },
  { "Jakov", 1.0 },
  { "Jaks", 1.0 },
  { "Jaksen", 1.0 },
  { "Jakson", 1.0 },
  { "Jaksyn", 1.0 },
  { "Jakub", 1.0 },
  { "Jakwan", 1.0 },
  { "Jakwaun", 1.0 },
  { "Jakwon", 1.0 },
  { "Jakya", 0.0 },
  { "Jakyah", 0.0 },
  { "Jakyan", 1.0 },
  { "Jakye", 1.0 },
  { "Jakyi", 1.0 },
  { "Jakyia", 0.0 },
  { "Jakyiah", 0.0 },
  { "Jakyla", 0.0 },
  { "Jakylah", 0.0 },
  { "Jakylan", 1.0 },
  { "Jakyle", 1.0 },
  { "Jakylee", 0.0 },
  { "Jakylen", 1.0 },
  { "Jakylia", 0.0 },
  { "Jakylin", 1.0 },
  { "Jakylon", 1.0 },
  { "Jakyra", 0.0 },
  { "Jakyrah", 0.0 },
  { "Jakyran", 1.0 },
  { "Jakyre", 1.0 },
  { "Jakyree", 1.0 },
  { "Jakyren", 1.0 },
  { "Jakyri", 1.0 },
  { "Jakyria", 0.0 },
  { "Jakyriah", 0.0 },
  { "Jakyrian", 1.0 },
  { "Jakyrie", 1.0 },
  { "Jakyrin", 1.0 },
  { "Jakyrion", 1.0 },
  { "Jakyron", 1.0 },
  { "Jakzenny", 0.0 },
  { "Jal", 1.0 },
  { "Jala", 0.0 },
  { "Jalaa", 0.0 },
  { "Jalaal", 1.0 },
  { "Jalacia", 0.0 },
  { "Jalae", 0.0 },
  { "Jalah", 0.009009009 },
  { "Jalaia", 0.0 },
  { "Jalaiah", 0.0 },
  { "Jalaila", 0.0 },
  { "Jalaina", 0.0 },
  { "Jalaine", 0.0 },
  { "Jalaiya", 0.0 },
  { "Jalaiyah", 0.0 },
  { "Jalal", 1.0 },
  { "Jalan", 0.92569 },
  { "Jalana", 0.0 },
  { "Jaland", 1.0 },
  { "Jalanda", 0.0 },
  { "Jalane", 0.0 },
  { "Jalani", 0.57210964 },
  { "Jalanie", 0.0 },
  { "Jalanna", 0.0 },
  { "Jalanni", 0.0 },
  { "Jalante", 1.0 },
  { "Jalasha", 0.0 },
  { "Jalashia", 0.0 },
  { "Jalasia", 0.0 },
  { "Jalaun", 1.0 },
  { "Jalay", 0.0 },
  { "Jalaya", 0.0 },
  { "Jalayah", 0.0 },
  { "Jalaycia", 0.0 },
  { "Jalayha", 0.0 },
  { "Jalayia", 0.0 },
  { "Jalayiah", 0.0 },
  { "Jalayla", 0.0 },
  { "Jalaylah", 0.0 },
  { "Jalayna", 0.0 },
  { "Jalayne", 0.0 },
  { "Jalaysha", 0.0 },
  { "Jalayshia", 0.0 },
  { "Jalaysia", 0.0 },
  { "Jalea", 0.0 },
  { "Jaleah", 0.0 },
  { "Jaleaha", 0.0 },
  { "Jaleal", 1.0 },
  { "Jalean", 1.0 },
  { "Jaleana", 0.0 },
  { "Jaleasa", 0.0 },
  { "Jaleb", 1.0 },
  { "Jalecia", 0.0 },
  { "Jalee", 0.0 },
  { "Jaleea", 0.0 },
  { "Jaleeah", 0.0 },
  { "Jaleek", 1.0 },
  { "Jaleel", 0.9941691 },
  { "Jaleela", 0.0 },
  { "Jaleen", 0.52155775 },
  { "Jaleena", 0.0 },
  { "Jaleesa", 0.0019163206 },
  { "Jaleese", 0.0 },
  { "Jaleesha", 0.0 },
  { "Jaleesia", 0.0 },
  { "Jaleeya", 0.0 },
  { "Jaleeyah", 0.0 },
  { "Jaleeza", 0.0 },
  { "Jaleh", 0.0 },
  { "Jalei", 0.0 },
  { "Jaleia", 0.0 },
  { "Jaleiah", 0.0 },
  { "Jaleigh", 0.0 },
  { "Jaleigha", 0.0 },
  { "Jaleil", 1.0 },
  { "Jalein", 1.0 },
  { "Jaleisa", 0.0 },
  { "Jaleisha", 0.0 },
  { "Jaleiya", 0.0 },
  { "Jaleiyah", 0.0 },
  { "Jalem", 1.0 },
  { "Jalen", 0.9559515 },
  { "Jalena", 0.0 },
  { "Jalencia", 0.0 },
  { "Jalend", 1.0 },
  { "Jalene", 0.05560166 },
  { "Jalenn", 1.0 },
  { "Jaleny", 0.0 },
  { "Jaleo", 1.0 },
  { "Jaleon", 1.0 },
  { "Jaleria", 0.0 },
  { "Jalesa", 0.0 },
  { "Jalese", 0.0 },
  { "Jalesha", 0.0 },
  { "Jaleshia", 0.0 },
  { "Jalesia", 0.0 },
  { "Jalessa", 0.0 },
  { "Jalesse", 0.0 },
  { "Jalessia", 0.0 },
  { "Jalexa", 0.0 },
  { "Jalexi", 0.0 },
  { "Jalexia", 0.0 },
  { "Jalexie", 0.0 },
  { "Jalexis", 0.0 },
  { "Jalexus", 0.0 },
  { "Jalexy", 0.0 },
  { "Jaley", 0.0 },
  { "Jaleya", 0.0 },
  { "Jaleyah", 0.0 },
  { "Jaleyiah", 0.0 },
  { "Jaleyza", 0.0 },
  { "Jali", 0.0 },
  { "Jalia", 0.0 },
  { "Jaliah", 0.0068649887 },
  { "Jalian", 1.0 },
  { "Jaliana", 0.0 },
  { "Jaliayah", 0.0 },
  { "Jalica", 0.0 },
  { "Jalice", 0.0 },
  { "Jalicia", 0.0 },
  { "Jalie", 0.0 },
  { "Jaliea", 0.0 },
  { "Jalieah", 0.0 },
  { "Jaliek", 1.0 },
  { "Jaliel", 1.0 },
  { "Jalien", 0.9382716 },
  { "Jaliene", 0.0 },
  { "Jaliesa", 0.0 },
  { "Jalijah", 1.0 },
  { "Jalik", 1.0 },
  { "Jalil", 0.9980143 },
  { "Jalila", 0.0 },
  { "Jalilah", 0.0 },
  { "Jalill", 1.0 },
  { "Jalin", 0.7818013 },
  { "Jalina", 0.0 },
  { "Jalinda", 0.0 },
  { "Jaline", 0.0 },
  { "Jalique", 1.0 },
  { "Jalis", 0.0 },
  { "Jalisa", 0.0010131713 },
  { "Jalise", 0.0 },
  { "Jalisha", 0.0 },
  { "Jalishia", 0.0 },
  { "Jalisia", 0.0 },
  { "Jalissa", 0.0 },
  { "Jalisse", 0.0 },
  { "Jalissia", 0.0 },
  { "Jalita", 0.0 },
  { "Jalitza", 0.0 },
  { "Jalivia", 0.0 },
  { "Jaliya", 0.0 },
  { "Jaliyah", 0.0 },
  { "Jaliyha", 0.0 },
  { "Jaliyiah", 0.0 },
  { "Jaliyl", 1.0 },
  { "Jaliza", 0.0 },
  { "Jallen", 1.0 },
  { "Jallisa", 0.0 },
  { "Jalliyah", 0.0 },
  { "Jalmer", 1.0 },
  { "Jalna", 0.0 },
  { "Jalob", 1.0 },
  { "Jalon", 0.9685775 },
  { "Jalonda", 0.0 },
  { "Jaloni", 0.66233766 },
  { "Jalonni", 1.0 },
  { "Jalonnie", 1.0 },
  { "Jalontae", 1.0 },
  { "Jalonte", 1.0 },
  { "Jalpa", 0.0 },
  { "Jalun", 1.0 },
  { "Jalya", 0.0 },
  { "Jalyah", 0.0 },
  { "Jalyce", 0.0 },
  { "Jalycia", 0.0 },
  { "Jalyia", 0.0 },
  { "Jalyiah", 0.0 },
  { "Jalyla", 0.0 },
  { "Jalylah", 0.0 },
  { "Jalyn", 0.2586152 },
  { "Jalyna", 0.0 },
  { "Jalyne", 0.06369427 },
  { "Jalynn", 0.07380152 },
  { "Jalynne", 0.0 },
  { "Jalyric", 0.1 },
  { "Jalysa", 0.0 },
  { "Jalyse", 0.0 },
  { "Jalysia", 0.0 },
  { "Jalyssa", 0.0 },
  { "Jalyssia", 0.0 },
  { "Jalyza", 0.0 },
  { "Jam", 1.0 },
  { "Jama", 0.046683047 },
  { "Jamaa", 1.0 },
  { "Jamaad", 1.0 },
  { "Jamaah", 1.0 },
  { "Jamaal", 0.99451756 },
  { "Jamaar", 1.0 },
  { "Jamaari", 1.0 },
  { "Jamaca", 0.0 },
  { "Jamacia", 0.0 },
  { "Jamad", 1.0 },
  { "Jamae", 0.06329114 },
  { "Jamael", 1.0 },
  { "Jamah", 1.0 },
  { "Jamahd", 1.0 },
  { "Jamahl", 1.0 },
  { "Jamahri", 1.0 },
  { "Jamai", 0.88209605 },
  { "Jamaia", 0.0 },
  { "Jamaiah", 0.0 },
  { "Jamaica", 0.021433355 },
  { "Jamaicia", 0.0 },
  { "Jamaika", 0.0 },
  { "Jamail", 1.0 },
  { "Jamaile", 1.0 },
  { "Jamain", 1.0 },
  { "Jamaine", 0.9877676 },
  { "Jamair", 1.0 },
  { "Jamaira", 0.0 },
  { "Jamaire", 1.0 },
  { "Jamaiya", 0.0 },
  { "Jamaiyah", 0.0 },
  { "Jamaka", 0.0 },
  { "Jamal", 0.9915119 },
  { "Jamala", 0.0 },
  { "Jamalachi", 1.0 },
  { "Jamale", 1.0 },
  { "Jamalia", 0.0 },
  { "Jamall", 1.0 },
  { "Jamalle", 1.0 },
  { "Jamalyn", 0.0 },
  { "Jaman", 1.0 },
  { "Jamanda", 0.0 },
  { "Jamane", 1.0 },
  { "Jamani", 0.5300752 },
  { "Jamantha", 0.0 },
  { "Jamar", 0.99512 },
  { "Jamara", 0.04928806 },
  { "Jamarae", 1.0 },
  { "Jamarah", 0.0 },
  { "Jamarco", 1.0 },
  { "Jamarcus", 1.0 },
  { "Jamard", 1.0 },
  { "Jamare", 1.0 },
  { "Jamarea", 0.70689654 },
  { "Jamaree", 0.99292785 },
  { "Jamareo", 1.0 },
  { "Jamareon", 1.0 },
  { "Jamarey", 1.0 },
  { "Jamari", 0.93739545 },
  { "Jamaria", 0.032314412 },
  { "Jamariae", 1.0 },
  { "Jamariah", 0.0 },
  { "Jamarian", 0.9928656 },
  { "Jamariana", 0.0 },
  { "Jamarie", 0.8614173 },
  { "Jamariea", 1.0 },
  { "Jamarien", 1.0 },
  { "Jamarieon", 1.0 },
  { "Jamarii", 1.0 },
  { "Jamarin", 1.0 },
  { "Jamario", 1.0 },
  { "Jamarion", 1.0 },
  { "Jamariona", 0.0 },
  { "Jamarious", 1.0 },
  { "Jamaris", 0.82579184 },
  { "Jamariun", 1.0 },
  { "Jamarius", 1.0 },
  { "Jamariya", 0.0 },
  { "Jamariyah", 0.0 },
  { "Jamariyon", 1.0 },
  { "Jamarkis", 1.0 },
  { "Jamarkus", 1.0 },
  { "Jamarl", 1.0 },
  { "Jamarley", 1.0 },
  { "Jamarlon", 1.0 },
  { "Jamaro", 1.0 },
  { "Jamarques", 1.0 },
  { "Jamarquez", 1.0 },
  { "Jamarquis", 1.0 },
  { "Jamarqus", 1.0 },
  { "Jamarr", 1.0 },
  { "Jamarra", 0.0 },
  { "Jamarre", 1.0 },
  { "Jamarreon", 1.0 },
  { "Jamarri", 1.0 },
  { "Jamarria", 0.0 },
  { "Jamarrian", 1.0 },
  { "Jamarrie", 1.0 },
  { "Jamarrio", 1.0 },
  { "Jamarrion", 1.0 },
  { "Jamarris", 1.0 },
  { "Jamarrius", 1.0 },
  { "Jamarus", 1.0 },
  { "Jamarvion", 1.0 },
  { "Jamary", 0.8076923 },
  { "Jamarya", 0.0 },
  { "Jamaryon", 1.0 },
  { "Jamas", 1.0 },
  { "Jamasia", 0.0 },
  { "Jamason", 1.0 },
  { "Jamaul", 1.0 },
  { "Jamaun", 1.0 },
  { "Jamaur", 1.0 },
  { "Jamauri", 0.98682636 },
  { "Jamauria", 0.0 },
  { "Jamaurie", 1.0 },
  { "Jamaurion", 1.0 },
  { "Jamaury", 1.0 },
  { "Jamay", 0.0 },
  { "Jamaya", 0.0 },
  { "Jamayah", 0.0 },
  { "Jamayca", 0.0 },
  { "Jamayel", 1.0 },
  { "Jamayia", 0.0 },
  { "Jamayiah", 0.0 },
  { "Jamayka", 0.0 },
  { "Jamayla", 0.0 },
  { "Jamayra", 0.0 },
  { "Jame", 0.894475 },
  { "Jamea", 0.0 },
  { "Jameah", 0.0 },
  { "Jameal", 1.0 },
  { "Jamear", 1.0 },
  { "Jameca", 0.0 },
  { "Jamecca", 0.0 },
  { "Jamece", 0.0 },
  { "Jamecia", 0.0 },
  { "Jamee", 0.074555404 },
  { "Jameece", 0.0 },
  { "Jameek", 1.0 },
  { "Jameeka", 0.0 },
  { "Jameel", 0.99353683 },
  { "Jameela", 0.0 },
  { "Jameelah", 0.0 },
  { "Jameele", 0.0 },
  { "Jameen", 1.0 },
  { "Jameer", 1.0 },
  { "Jameera", 0.0 },
  { "Jameerah", 0.0 },
  { "Jameese", 0.0 },
  { "Jameesha", 0.0 },
  { "Jamei", 0.0 },
  { "Jameia", 0.0 },
  { "Jameiah", 0.0 },
  { "Jameica", 0.0 },
  { "Jameice", 0.0 },
  { "Jameika", 0.0 },
  { "Jameil", 1.0 },
  { "Jameila", 0.0 },
  { "Jameion", 1.0 },
  { "Jameir", 1.0 },
  { "Jameira", 0.0 },
  { "Jameire", 1.0 },
  { "Jameis", 1.0 },
  { "Jameisha", 0.0 },
  { "Jameison", 1.0 },
  { "Jameka", 0.0 },
  { "Jamekia", 0.0 },
  { "Jamel", 0.96644723 },
  { "Jamela", 0.0 },
  { "Jamelah", 0.0 },
  { "Jamele", 1.0 },
  { "Jamelia", 0.0 },
  { "Jameliah", 0.0 },
  { "Jamell", 0.96385545 },
  { "Jamella", 0.0 },
  { "Jamellah", 0.0 },
  { "Jamelle", 0.6701209 },
  { "Jamelvin", 1.0 },
  { "Jamely", 0.0 },
  { "Jamelyn", 0.0 },
  { "Jamen", 1.0 },
  { "Jamena", 0.0 },
  { "Jamene", 0.0 },
  { "Jameon", 1.0 },
  { "Jamequa", 0.0 },
  { "Jamer", 1.0 },
  { "Jamera", 0.0 },
  { "Jamerah", 0.0 },
  { "Jamere", 0.98463684 },
  { "Jameria", 0.0 },
  { "Jameriah", 0.0 },
  { "Jamerial", 0.0 },
  { "Jamerian", 1.0 },
  { "Jamerica", 0.0 },
  { "Jamerio", 1.0 },
  { "Jamerion", 1.0 },
  { "Jamerious", 1.0 },
  { "Jameris", 1.0 },
  { "Jamerius", 1.0 },
  { "Jameriya", 0.0 },
  { "Jamerra", 0.0 },
  { "Jamerria", 0.0 },
  { "Jamerson", 1.0 },
  { "James", 0.99548775 },
  { "Jamesa", 0.0 },
  { "Jamesandrew", 1.0 },
  { "Jamesanthony", 1.0 },
  { "Jamescia", 0.0 },
  { "Jamesdaniel", 1.0 },
  { "Jamesdavid", 1.0 },
  { "Jamesdean", 1.0 },
  { "Jamese", 0.0 },
  { "Jamesedward", 1.0 },
  { "Jamesen", 0.9576271 },
  { "Jamesena", 0.0 },
  { "Jamesetta", 0.0 },
  { "Jamesha", 0.0 },
  { "Jameshia", 0.0 },
  { "Jamesia", 0.0 },
  { "Jamesina", 0.0 },
  { "Jamesjoseph", 1.0 },
  { "Jameslee", 1.0 },
  { "Jamesley", 1.0 },
  { "Jamesly", 1.0 },
  { "Jamesmatthew", 1.0 },
  { "Jamesmichael", 1.0 },
  { "Jameson", 0.9706907 },
  { "Jamespatrick", 1.0 },
  { "Jamespaul", 1.0 },
  { "Jamesrobert", 1.0 },
  { "Jamesryan", 1.0 },
  { "Jamess", 1.0 },
  { "Jamessa", 0.0 },
  { "Jamesson", 1.0 },
  { "Jamesthomas", 1.0 },
  { "Jameswilliam", 1.0 },
  { "Jamesyn", 0.43846154 },
  { "Jameta", 0.0 },
  { "Jametra", 0.0 },
  { "Jametria", 0.0 },
  { "Jametrice", 0.0 },
  { "Jametrius", 1.0 },
  { "Jametta", 0.0 },
  { "Jamette", 0.0 },
  { "Jamey", 0.68750656 },
  { "Jameya", 0.0 },
  { "Jameyah", 0.0 },
  { "Jamez", 1.0 },
  { "Jamhal", 1.0 },
  { "Jami", 0.040621214 },
  { "Jamia", 0.001507159 },
  { "Jamiah", 0.13386825 },
  { "Jamial", 1.0 },
  { "Jamian", 1.0 },
  { "Jamiann", 0.0 },
  { "Jamianne", 0.0 },
  { "Jamias", 1.0 },
  { "Jamiaya", 0.0 },
  { "Jamica", 0.0 },
  { "Jamicah", 1.0 },
  { "Jamice", 0.0 },
  { "Jamichael", 1.0 },
  { "Jamicheal", 1.0 },
  { "Jamicia", 0.0 },
  { "Jamicka", 0.0 },
  { "Jamie", 0.24138665 },
  { "Jamieann", 0.0 },
  { "Jamiece", 0.0 },
  { "Jamiee", 0.0 },
  { "Jamieka", 0.0 },
  { "Jamiel", 0.9758577 },
  { "Jamiela", 0.0 },
  { "Jamielee", 0.0 },
  { "Jamielle", 0.0 },
  { "Jamielyn", 0.0 },
  { "Jamielynn", 0.0 },
  { "Jamiemarie", 0.0 },
  { "Jamien", 0.9892009 },
  { "Jamieon", 1.0 },
  { "Jamier", 1.0 },
  { "Jamiera", 0.0 },
  { "Jamiere", 1.0 },
  { "Jamiesha", 0.0 },
  { "Jamieson", 0.94598335 },
  { "Jamih", 1.0 },
  { "Jamii", 0.0 },
  { "Jamiir", 1.0 },
  { "Jamik", 1.0 },
  { "Jamika", 0.0 },
  { "Jamikal", 1.0 },
  { "Jamikel", 1.0 },
  { "Jamikka", 0.0 },
  { "Jamil", 0.964104 },
  { "Jamila", 0.0 },
  { "Jamilah", 0.00729927 },
  { "Jamile", 0.5233645 },
  { "Jamilee", 0.0 },
  { "Jamileh", 0.0 },
  { "Jamiles", 0.0 },
  { "Jamilet", 0.0 },
  { "Jamileth", 0.0 },
  { "Jamilett", 0.0 },
  { "Jamilette", 0.0 },
  { "Jamilex", 0.0 },
  { "Jamiley", 0.0 },
  { "Jamilia", 0.0 },
  { "Jamilka", 0.0 },
  { "Jamill", 1.0 },
  { "Jamilla", 0.0 },
  { "Jamillah", 0.0 },
  { "Jamille", 0.36879432 },
  { "Jamillette", 0.0 },
  { "Jamillia", 0.0 },
  { "Jamilliah", 0.0 },
  { "Jamily", 0.0 },
  { "Jamilya", 0.0 },
  { "Jamilyah", 0.0 },
  { "Jamilyn", 0.0 },
  { "Jamilynn", 0.0 },
  { "Jamima", 0.0 },
  { "Jamin", 0.95778525 },
  { "Jamina", 0.0 },
  { "Jamine", 0.29718006 },
  { "Jamion", 1.0 },
  { "Jamiqua", 0.0 },
  { "Jamique", 1.0 },
  { "Jamir", 0.996083 },
  { "Jamira", 0.0 },
  { "Jamiracle", 0.0 },
  { "Jamirah", 0.0 },
  { "Jamire", 1.0 },
  { "Jamiria", 0.0 },
  { "Jamirion", 1.0 },
  { "Jamiron", 1.0 },
  { "Jamiroquai", 1.0 },
  { "Jamiroquan", 1.0 },
  { "Jamirr", 1.0 },
  { "Jamirra", 0.0 },
  { "Jamirrah", 0.0 },
  { "Jamirya", 0.0 },
  { "Jamis", 1.0 },
  { "Jamisa", 0.0 },
  { "Jamise", 0.0 },
  { "Jamisen", 0.6185567 },
  { "Jamisha", 0.0 },
  { "Jamison", 0.9030557 },
  { "Jamisyn", 0.06451613 },
  { "Jamita", 0.0 },
  { "Jamius", 1.0 },
  { "Jamiya", 0.0 },
  { "Jamiyah", 0.0 },
  { "Jamiyha", 0.0 },
  { "Jamiyl", 1.0 },
  { "Jamiyla", 0.0 },
  { "Jamiylah", 0.0 },
  { "Jammal", 1.0 },
  { "Jammar", 1.0 },
  { "Jammel", 1.0 },
  { "Jammes", 1.0 },
  { "Jammey", 1.0 },
  { "Jammi", 0.0 },
  { "Jammie", 0.3751931 },
  { "Jamms", 1.0 },
  { "Jammy", 0.7186147 },
  { "Jamod", 1.0 },
  { "Jamol", 1.0 },
  { "Jamon", 0.9976726 },
  { "Jamond", 1.0 },
  { "Jamone", 1.0 },
  { "Jamoni", 0.5770751 },
  { "Jamonica", 0.0 },
  { "Jamonie", 0.87234044 },
  { "Jamont", 1.0 },
  { "Jamonta", 1.0 },
  { "Jamontae", 1.0 },
  { "Jamontay", 1.0 },
  { "Jamonte", 1.0 },
  { "Jamontez", 1.0 },
  { "Jamor", 1.0 },
  { "Jamora", 0.0 },
  { "Jamore", 1.0 },
  { "Jamori", 1.0 },
  { "Jamoria", 0.0 },
  { "Jamorian", 1.0 },
  { "Jamorie", 1.0 },
  { "Jamorion", 1.0 },
  { "Jamorris", 1.0 },
  { "Jams", 1.0 },
  { "Jamse", 1.0 },
  { "Jamson", 1.0 },
  { "Jamual", 1.0 },
  { "Jamuel", 1.0 },
  { "Jamus", 1.0 },
  { "Jamy", 0.3377425 },
  { "Jamya", 0.0 },
  { "Jamyah", 0.0 },
  { "Jamye", 0.014167651 },
  { "Jamyia", 0.0 },
  { "Jamyiah", 0.0 },
  { "Jamyis", 1.0 },
  { "Jamykal", 1.0 },
  { "Jamyl", 1.0 },
  { "Jamyla", 0.0 },
  { "Jamylah", 0.0 },
  { "Jamyle", 1.0 },
  { "Jamyleth", 0.0 },
  { "Jamylex", 0.0 },
  { "Jamyn", 1.0 },
  { "Jamyr", 1.0 },
  { "Jamyra", 0.0 },
  { "Jamyrah", 0.0 },
  { "Jamyre", 1.0 },
  { "Jamyri", 0.26086956 },
  { "Jamyria", 0.0 },
  { "Jamyriah", 0.0 },
  { "Jamyrie", 0.0 },
  { "Jamyrion", 1.0 },
  { "Jamyron", 1.0 },
  { "Jamyson", 1.0 },
  { "Jan", 0.28555512 },
  { "Jana", 0.0008825926 },
  { "Janaa", 0.0 },
  { "Janaan", 0.0 },
  { "Janace", 0.0 },
  { "Janacia", 0.0 },
  { "Janada", 0.0 },
  { "Janadia", 0.0 },
  { "Janae", 0.00036460866 },
  { "Janaea", 0.0 },
  { "Janaee", 0.0 },
  { "Janaeh", 0.0 },
  { "Janael", 0.0 },
  { "Janaesha", 0.0 },
  { "Janaeya", 0.0 },
  { "Janaeyah", 0.0 },
  { "Janah", 0.0 },
  { "Janahi", 0.0 },
  { "Janahla", 0.0 },
  { "Janai", 0.030706622 },
  { "Janaia", 0.0 },
  { "Janaiah", 0.0 },
  { "Janaih", 0.0 },
  { "Janaii", 0.0 },
  { "Janaija", 0.0 },
  { "Janaijah", 0.0 },
  { "Janaila", 0.0 },
  { "Janaina", 0.0 },
  { "Janaira", 0.0 },
  { "Janais", 0.0 },
  { "Janaisa", 0.0 },
  { "Janaisha", 0.0 },
  { "Janaisia", 0.0 },
  { "Janaiya", 0.0 },
  { "Janaiyah", 0.0 },
  { "Janaja", 0.0 },
  { "Janajah", 0.0 },
  { "Janak", 1.0 },
  { "Janaka", 1.0 },
  { "Janaki", 0.0 },
  { "Janal", 0.067567565 },
  { "Janala", 0.0 },
  { "Janalee", 0.0 },
  { "Janalene", 0.0 },
  { "Janalis", 0.0 },
  { "Janalise", 0.0 },
  { "Janaliz", 0.0 },
  { "Janalle", 0.0 },
  { "Janalyn", 0.0 },
  { "Janalynn", 0.0 },
  { "Janalyse", 0.0 },
  { "Janan", 0.015384615 },
  { "Janani", 0.0 },
  { "Janann", 0.0 },
  { "Jananne", 0.0 },
  { "Janara", 0.0 },
  { "Janard", 1.0 },
  { "Janari", 0.6631579 },
  { "Janaria", 0.0 },
  { "Janariah", 0.0 },
  { "Janaris", 1.0 },
  { "Janarius", 1.0 },
  { "Janas", 0.10869565 },
  { "Janascia", 0.0 },
  { "Janasha", 0.0 },
  { "Janashia", 0.0 },
  { "Janasia", 0.0 },
  { "Janat", 0.0 },
  { "Janath", 0.0 },
  { "Janathan", 1.0 },
  { "Janathean", 1.0 },
  { "Janautica", 0.0 },
  { "Janavi", 0.0 },
  { "Janavia", 0.0 },
  { "Janay", 0.0 },
  { "Janaya", 0.0 },
  { "Janayah", 0.0 },
  { "Janaye", 0.0 },
  { "Janayia", 0.0 },
  { "Janayiah", 0.0 },
  { "Janayja", 0.0 },
  { "Janayla", 0.0 },
  { "Janayra", 0.0 },
  { "Janaysha", 0.0 },
  { "Janayshia", 0.0 },
  { "Janaysia", 0.0 },
  { "Janazia", 0.0 },
  { "Jancarlo", 1.0 },
  { "Jancarlos", 1.0 },
  { "Jance", 0.9350649 },
  { "Jancey", 0.0 },
  { "Janci", 0.0 },
  { "Jancie", 0.0 },
  { "Jancy", 0.015723271 },
  { "Janda", 0.0 },
  { "Jande", 0.0 },
  { "Jandee", 0.0 },
  { "Jandel", 0.9800797 },
  { "Jandell", 0.78571427 },
  { "Jandery", 0.0 },
  { "Jandi", 0.0 },
  { "Jandiel", 1.0 },
  { "Jandra", 0.0 },
  { "Jandre", 1.0 },
  { "Jandriel", 1.0 },
  { "Jandy", 0.083333336 },
  { "Jane", 0.0030617286 },
  { "Janea", 0.0 },
  { "Janeah", 0.0 },
  { "Janeal", 0.0 },
  { "Janean", 0.0 },
  { "Janeane", 0.0 },
  { "Janeann", 0.0 },
  { "Janeanne", 0.0 },
  { "Janear", 0.0 },
  { "Janece", 0.0 },
  { "Janecia", 0.0 },
  { "Janee", 0.0018650917 },
  { "Janeece", 0.0 },
  { "Janeeka", 0.0 },
  { "Janeel", 0.0 },
  { "Janeen", 0.0 },
  { "Janeene", 0.0 },
  { "Janeesa", 0.0 },
  { "Janeese", 0.0 },
  { "Janeesha", 0.0 },
  { "Janeeva", 0.0 },
  { "Janei", 0.0 },
  { "Janeia", 0.0 },
  { "Janeiah", 0.0 },
  { "Janeice", 0.0 },
  { "Janeicia", 0.0 },
  { "Janeida", 0.0 },
  { "Janeidy", 0.0 },
  { "Janeigh", 0.0 },
  { "Janeika", 0.0 },
  { "Janeil", 0.09583333 },
  { "Janeily", 0.0 },
  { "Janeira", 0.0 },
  { "Janeiro", 1.0 },
  { "Janeiry", 0.0 },
  { "Janeisa", 0.0 },
  { "Janeise", 0.0 },
  { "Janeisha", 0.0 },
  { "Janeisy", 0.0 },
  { "Janeiya", 0.0 },
  { "Janek", 1.0 },
  { "Janeka", 0.0 },
  { "Janekia", 0.0 },
  { "Janel", 0.0026967807 },
  { "Janela", 0.0 },
  { "Janelda", 0.0 },
  { "Janele", 0.0 },
  { "Janelee", 0.0 },
  { "Janeli", 0.0 },
  { "Janelie", 0.0 },
  { "Janelis", 0.0 },
  { "Janelise", 0.0 },
  { "Janelisse", 0.0 },
  { "Janeliz", 0.0 },
  { "Janell", 0.0014854043 },
  { "Janella", 0.0 },
  { "Janelle", 0.0016286029 },
  { "Janellen", 0.0 },
  { "Janelli", 0.0 },
  { "Janellie", 0.0 },
  { "Janelly", 0.0 },
  { "Janellys", 0.0 },
  { "Janely", 0.0 },
  { "Janelyn", 0.0 },
  { "Janelys", 0.0 },
  { "Janelyz", 0.0 },
  { "Janemarie", 0.0 },
  { "Janene", 0.0 },
  { "Janenne", 0.0 },
  { "Janequa", 0.0 },
  { "Janera", 0.0 },
  { "Janeria", 0.0 },
  { "Janerica", 0.0 },
  { "Janes", 1.0 },
  { "Janesa", 0.0 },
  { "Janese", 0.0 },
  { "Janesha", 0.0 },
  { "Janeshia", 0.0 },
  { "Janesia", 0.0 },
  { "Janess", 0.0 },
  { "Janessa", 0.0 },
  { "Janessah", 0.0 },
  { "Janesse", 0.0 },
  { "Janessia", 0.0 },
  { "Janet", 0.0027239546 },
  { "Janeta", 0.0 },
  { "Janete", 0.0 },
  { "Janeth", 0.0 },
  { "Janetha", 0.0 },
  { "Janetlee", 0.0 },
  { "Janetra", 0.0 },
  { "Janett", 0.0 },
  { "Janetta", 0.0 },
  { "Janette", 0.0013169447 },
  { "Janetzi", 0.0 },
  { "Janetzy", 0.0 },
  { "Janeva", 0.0 },
  { "Janey", 0.0 },
  { "Janeya", 0.0 },
  { "Janeyah", 0.0 },
  { "Jangelo", 1.0 },
  { "Janhavi", 0.0 },
  { "Jani", 0.04814138 },
  { "Jania", 0.0 },
  { "Janiah", 0.0 },
  { "Janiaha", 0.0 },
  { "Janiaya", 0.0 },
  { "Janiayah", 0.0 },
  { "Janic", 0.0 },
  { "Janica", 0.0 },
  { "Janice", 0.0028479937 },
  { "Janicia", 0.0 },
  { "Janick", 1.0 },
  { "Janicka", 0.0 },
  { "Janie", 0.0036978978 },
  { "Janiece", 0.0 },
  { "Janiecia", 0.0 },
  { "Janieka", 0.0 },
  { "Janiel", 0.7496977 },
  { "Janielis", 0.0 },
  { "Janieliz", 0.0 },
  { "Janielle", 0.0 },
  { "Janiely", 0.0 },
  { "Janielys", 0.0 },
  { "Janien", 0.0 },
  { "Janiene", 0.0 },
  { "Janier", 1.0 },
  { "Janiera", 0.0 },
  { "Janiese", 0.0 },
  { "Janiesha", 0.0 },
  { "Janieya", 0.0 },
  { "Janifer", 0.0 },
  { "Janiha", 0.0 },
  { "Janihya", 0.0 },
  { "Janii", 0.0 },
  { "Janiia", 0.0 },
  { "Janijah", 0.0 },
  { "Janika", 0.0 },
  { "Janikqua", 0.0 },
  { "Janil", 0.0 },
  { "Janila", 0.0 },
  { "Janilah", 0.0 },
  { "Janilee", 0.0 },
  { "Janill", 0.0 },
  { "Janille", 0.0 },
  { "Janilya", 0.0 },
  { "Janilyn", 0.0 },
  { "Janin", 0.0 },
  { "Janina", 0.0 },
  { "Janine", 0.0003306779 },
  { "Janinne", 0.0 },
  { "Janiqua", 0.0 },
  { "Janique", 0.0 },
  { "Janira", 0.0 },
  { "Janirah", 0.0 },
  { "Janiris", 0.0 },
  { "Janis", 0.003334902 },
  { "Janisa", 0.0 },
  { "Janise", 0.0 },
  { "Janisha", 0.0 },
  { "Janishia", 0.0 },
  { "Janisia", 0.0 },
  { "Janissa", 0.0 },
  { "Janisse", 0.0 },
  { "Janit", 0.0 },
  { "Janita", 0.0 },
  { "Janith", 0.0 },
  { "Janitha", 0.0 },
  { "Janitra", 0.0 },
  { "Janitta", 0.0 },
  { "Janitza", 0.0 },
  { "Janitzy", 0.0 },
  { "Janivea", 0.0 },
  { "Janiya", 0.00061050063 },
  { "Janiyaa", 0.0 },
  { "Janiyah", 0.0 },
  { "Janiyan", 0.0 },
  { "Janiyha", 0.0 },
  { "Janiyia", 0.0 },
  { "Janiyla", 0.0 },
  { "Janiylah", 0.0 },
  { "Janiyyah", 0.0 },
  { "Janiza", 0.0 },
  { "Jankarlo", 1.0 },
  { "Janki", 0.0 },
  { "Janko", 1.0 },
  { "Janluca", 1.0 },
  { "Janlucas", 1.0 },
  { "Janluis", 1.0 },
  { "Janlyn", 0.0 },
  { "Janmarco", 1.0 },
  { "Janmarcos", 1.0 },
  { "Janmarie", 0.0 },
  { "Janmichael", 1.0 },
  { "Jann", 0.05856451 },
  { "Janna", 0.0 },
  { "Jannae", 0.0 },
  { "Jannah", 0.0 },
  { "Jannai", 0.0 },
  { "Jannali", 0.0 },
  { "Jannalyn", 0.0 },
  { "Jannan", 0.0 },
  { "Jannat", 0.0 },
  { "Jannatul", 0.0 },
  { "Jannay", 0.0 },
  { "Janne", 0.0 },
  { "Jannea", 0.0 },
  { "Jannean", 0.0 },
  { "Jannel", 0.0 },
  { "Janneli", 0.0 },
  { "Jannell", 0.0 },
  { "Jannelle", 0.0 },
  { "Jannelly", 0.0 },
  { "Jannely", 0.0 },
  { "Jannene", 0.0 },
  { "Jannesa", 0.0 },
  { "Jannessa", 0.0 },
  { "Jannet", 0.0 },
  { "Jannete", 0.0 },
  { "Janneth", 0.0 },
  { "Jannett", 0.0 },
  { "Jannetta", 0.0 },
  { "Jannette", 0.0 },
  { "Janney", 0.0 },
  { "Janni", 0.0 },
  { "Jannia", 0.0 },
  { "Janniah", 0.0 },
  { "Jannica", 0.0 },
  { "Jannice", 0.0 },
  { "Jannie", 0.0018920198 },
  { "Janniel", 1.0 },
  { "Jannifer", 0.0 },
  { "Jannik", 1.0 },
  { "Jannika", 0.0 },
  { "Jannike", 0.0 },
  { "Jannina", 0.0 },
  { "Jannine", 0.0 },
  { "Jannis", 0.0 },
  { "Jannita", 0.0 },
  { "Janniyah", 0.0 },
  { "Jannuel", 1.0 },
  { "Janny", 0.0 },
  { "Janoah", 1.0 },
  { "Janon", 0.0 },
  { "Janora", 0.0 },
  { "Janorris", 1.0 },
  { "Janos", 1.0 },
  { "Janovia", 0.0 },
  { "Jansel", 1.0 },
  { "Jansen", 0.8903127 },
  { "Jansiel", 1.0 },
  { "Janson", 1.0 },
  { "Janssen", 1.0 },
  { "Jansyn", 0.16666667 },
  { "Jante", 0.74545455 },
  { "Jantel", 0.0 },
  { "Janthony", 1.0 },
  { "Jantsen", 1.0 },
  { "Jantz", 1.0 },
  { "Jantzen", 0.97862595 },
  { "Januari", 0.0 },
  { "Januarie", 0.0 },
  { "January", 0.0 },
  { "Januel", 1.0 },
  { "Januell", 1.0 },
  { "Januelle", 1.0 },
  { "Januita", 0.0 },
  { "Janus", 0.19620253 },
  { "Janusz", 1.0 },
  { "Janvi", 0.0 },
  { "Janvier", 0.53125 },
  { "Janxiel", 1.0 },
  { "Jany", 0.0 },
  { "Janya", 0.0 },
  { "Janyah", 0.0 },
  { "Janyce", 0.0 },
  { "Janye", 0.0 },
  { "Janyha", 0.0 },
  { "Janyhia", 0.0 },
  { "Janyi", 0.0 },
  { "Janyia", 0.0 },
  { "Janyiah", 0.0 },
  { "Janyl", 0.0 },
  { "Janyla", 0.0 },
  { "Janylah", 0.0 },
  { "Janyll", 0.0 },
  { "Janyne", 0.0 },
  { "Janyra", 0.0 },
  { "Janyria", 0.0 },
  { "Janyriah", 0.0 },
  { "Janys", 0.0 },
  { "Janyse", 0.0 },
  { "Janyssa", 0.0 },
  { "Janyth", 0.0 },
  { "Janyus", 1.0 },
  { "Janzel", 1.0 },
  { "Janzen", 1.0 },
  { "Janziel", 1.0 },
  { "Jaona", 0.0 },
  { "Jaoni", 0.0 },
  { "Jaonna", 0.0 },
  { "Jaonte", 1.0 },
  { "Jaosn", 1.0 },
  { "Jap", 1.0 },
  { "Japaul", 1.0 },
  { "Japera", 0.0 },
  { "Japeth", 1.0 },
  { "Japhet", 1.0 },
  { "Japheth", 1.0 },
  { "Japhy", 1.0 },
  { "Japji", 0.0 },
  { "Japleen", 0.0 },
  { "Japneet", 0.0 },
  { "Japnoor", 0.0 },
  { "Japonica", 0.0 },
  { "Japree", 1.0 },
  { "Japria", 0.0 },
  { "Japrice", 0.0 },
  { "Jaqai", 1.0 },
  { "Jaqari", 1.0 },
  { "Jaqaun", 1.0 },
  { "Jaqavious", 1.0 },
  { "Jaqlyn", 0.0 },
  { "Jaqua", 0.6923077 },
  { "Jaquae", 0.85 },
  { "Jaquai", 1.0 },
  { "Jaquail", 1.0 },
  { "Jaquain", 1.0 },
  { "Jaquaisha", 0.0 },
  { "Jaqual", 1.0 },
  { "Jaquala", 0.0 },
  { "Jaquale", 1.0 },
  { "Jaqualen", 1.0 },
  { "Jaqualin", 1.0 },
  { "Jaqualine", 0.0 },
  { "Jaqualla", 0.0 },
  { "Jaqualon", 1.0 },
  { "Jaqualyn", 0.89719623 },
  { "Jaquan", 0.9941503 },
  { "Jaquana", 0.0 },
  { "Jaquanda", 0.0 },
  { "Jaquandra", 0.0 },
  { "Jaquandre", 1.0 },
  { "Jaquane", 1.0 },
  { "Jaquann", 1.0 },
  { "Jaquanna", 0.0 },
  { "Jaquantae", 1.0 },
  { "Jaquante", 1.0 },
  { "Jaquar", 1.0 },
  { "Jaquari", 1.0 },
  { "Jaquarion", 1.0 },
  { "Jaquarious", 1.0 },
  { "Jaquaris", 1.0 },
  { "Jaquarius", 1.0 },
  { "Jaquarrius", 1.0 },
  { "Jaquasha", 0.0 },
  { "Jaquashia", 0.0 },
  { "Jaquasia", 0.0 },
  { "Jaquata", 0.0 },
  { "Jaquaun", 1.0 },
  { "Jaquaveon", 1.0 },
  { "Jaquavia", 0.0 },
  { "Jaquavian", 1.0 },
  { "Jaquavien", 1.0 },
  { "Jaquavion", 1.0 },
  { "Jaquavious", 1.0 },
  { "Jaquavis", 1.0 },
  { "Jaquavius", 1.0 },
  { "Jaquawn", 1.0 },
  { "Jaquay", 0.7067669 },
  { "Jaquaya", 0.0 },
  { "Jaquayla", 0.0 },
  { "Jaquaylin", 1.0 },
  { "Jaquaylon", 1.0 },
  { "Jaquayvion", 1.0 },
  { "Jaquaze", 1.0 },
  { "Jaque", 0.8544304 },
  { "Jaqueal", 1.0 },
  { "Jaqueisha", 0.0 },
  { "Jaquel", 0.75449103 },
  { "Jaquela", 0.0 },
  { "Jaquelene", 0.0 },
  { "Jaquelin", 0.0 },
  { "Jaquelina", 0.0 },
  { "Jaqueline", 0.0015517474 },
  { "Jaquelinee", 0.0 },
  { "Jaquelinne", 0.0 },
  { "Jaquell", 0.978355 },
  { "Jaquella", 0.0 },
  { "Jaquelle", 1.0 },
  { "Jaquelline", 0.0 },
  { "Jaquelyn", 0.0 },
  { "Jaquelyne", 0.0 },
  { "Jaquelynn", 0.0 },
  { "Jaqueria", 0.0 },
  { "Jaques", 0.98392284 },
  { "Jaquese", 0.7181818 },
  { "Jaquesha", 0.0 },
  { "Jaquest", 1.0 },
  { "Jaqueta", 0.0 },
  { "Jaquetta", 0.0 },
  { "Jaquette", 0.0 },
  { "Jaquez", 1.0 },
  { "Jaqueze", 1.0 },
  { "Jaqui", 0.575 },
  { "Jaquia", 0.0 },
  { "Jaquice", 0.0 },
  { "Jaquil", 1.0 },
  { "Jaquila", 0.0 },
  { "Jaquill", 1.0 },
  { "Jaquilla", 0.0 },
  { "Jaquille", 1.0 },
  { "Jaquilyn", 0.0 },
  { "Jaquin", 0.973822 },
  { "Jaquincy", 1.0 },
  { "Jaquinn", 1.0 },
  { "Jaquinta", 0.0 },
  { "Jaquinton", 1.0 },
  { "Jaquira", 0.0 },
  { "Jaquis", 0.9590164 },
  { "Jaquise", 0.8312236 },
  { "Jaquisha", 0.0 },
  { "Jaquita", 0.0 },
  { "Jaquitta", 0.0 },
  { "Jaquline", 0.0 },
  { "Jaqulyn", 0.0 },
  { "Jaqulynn", 0.0 },
  { "Jaquoia", 0.0 },
  { "Jaquon", 1.0 },
  { "Jaquori", 1.0 },
  { "Jaquory", 1.0 },
  { "Jaquoya", 0.0 },
  { "Jaquwan", 1.0 },
  { "Jaqwan", 1.0 },
  { "Jaqwon", 1.0 },
  { "Jara", 0.0 },
  { "Jaraad", 1.0 },
  { "Jarad", 1.0 },
  { "Jarade", 1.0 },
  { "Jarae", 0.23396227 },
  { "Jarael", 1.0 },
  { "Jarah", 0.02606635 },
  { "Jarai", 1.0 },
  { "Jarail", 1.0 },
  { "Jarald", 1.0 },
  { "Jaramiah", 1.0 },
  { "Jaramie", 1.0 },
  { "Jaramy", 1.0 },
  { "Jaran", 1.0 },
  { "Jarard", 1.0 },
  { "Jaray", 1.0 },
  { "Jaraya", 0.0 },
  { "Jarayah", 0.0 },
  { "Jard", 1.0 },
  { "Jardan", 1.0 },
  { "Jarden", 1.0 },
  { "Jardin", 0.41666666 },
  { "Jardon", 1.0 },
  { "Jardyn", 0.0 },
  { "Jare", 1.0 },
  { "Jareal", 1.0 },
  { "Jareb", 1.0 },
  { "Jared", 0.9961466 },
  { "Jaredd", 1.0 },
  { "Jaree", 0.46464646 },
  { "Jareem", 1.0 },
  { "Jareese", 1.0 },
  { "Jarek", 1.0 },
  { "Jareka", 0.0 },
  { "Jarel", 0.9943128 },
  { "Jareli", 0.0 },
  { "Jarelin", 0.0 },
  { "Jarelis", 0.0 },
  { "Jareliz", 0.0 },
  { "Jarell", 1.0 },
  { "Jarelle", 1.0 },
  { "Jarelly", 0.0 },
  { "Jarely", 0.0 },
  { "Jarelyn", 0.0 },
  { "Jarelys", 0.0 },
  { "Jarem", 1.0 },
  { "Jaremiah", 1.0 },
  { "Jaremy", 1.0 },
  { "Jaren", 0.9496918 },
  { "Jarena", 0.0 },
  { "Jareny", 0.0 },
  { "Jareo", 1.0 },
  { "Jaresha", 0.0 },
  { "Jaret", 0.992305 },
  { "Jareth", 0.9789196 },
  { "Jarethzy", 0.0 },
  { "Jaretsi", 0.0 },
  { "Jaretssi", 0.0 },
  { "Jaretsy", 0.0 },
  { "Jarett", 1.0 },
  { "Jaretta", 0.0 },
  { "Jarette", 1.0 },
  { "Jaretzi", 0.0 },
  { "Jaretzy", 0.0 },
  { "Jarexi", 0.0 },
  { "Jarexy", 0.0 },
  { "Jarez", 1.0 },
  { "Jarhett", 1.0 },
  { "Jarhia", 0.0 },
  { "Jarhonda", 0.0 },
  { "Jari", 0.36935166 },
  { "Jaria", 0.0 },
  { "Jariah", 0.15996504 },
  { "Jarian", 1.0 },
  { "Jariana", 0.0 },
  { "Jarianna", 0.0 },
  { "Jarib", 1.0 },
  { "Jaric", 1.0 },
  { "Jarica", 0.0 },
  { "Jarick", 1.0 },
  { "Jaricka", 0.0 },
  { "Jarico", 1.0 },
  { "Jarid", 1.0 },
  { "Jarie", 0.3529412 },
  { "Jariel", 0.97522235 },
  { "Jarielis", 0.0 },
  { "Jarieliz", 0.0 },
  { "Jariell", 1.0 },
  { "Jarielle", 0.0 },
  { "Jariely", 0.0 },
  { "Jarielys", 0.0 },
  { "Jarien", 1.0 },
  { "Jarif", 1.0 },
  { "Jarik", 1.0 },
  { "Jarika", 0.0 },
  { "Jarilyn", 0.0 },
  { "Jarimiah", 1.0 },
  { "Jarin", 0.9674235 },
  { "Jarina", 0.0 },
  { "Jario", 1.0 },
  { "Jarion", 1.0 },
  { "Jarious", 1.0 },
  { "Jarique", 1.0 },
  { "Jaris", 0.9268293 },
  { "Jarisa", 0.0 },
  { "Jarison", 1.0 },
  { "Jarissa", 0.0 },
  { "Jarit", 1.0 },
  { "Jarita", 0.0 },
  { "Jaritsa", 0.0 },
  { "Jaritza", 0.0 },
  { "Jaritzi", 0.0 },
  { "Jaritzy", 0.0 },
  { "Jarius", 1.0 },
  { "Jariya", 0.0 },
  { "Jariyah", 0.014025246 },
  { "Jarl", 1.0 },
  { "Jarlene", 0.0 },
  { "Jarlin", 0.0 },
  { "Jarline", 0.0 },
  { "Jarlyn", 0.0 },
  { "Jarma", 0.0 },
  { "Jarmain", 1.0 },
  { "Jarmaine", 1.0 },
  { "Jarmal", 1.0 },
  { "Jarmall", 1.0 },
  { "Jarman", 1.0 },
  { "Jarmani", 1.0 },
  { "Jarmar", 1.0 },
  { "Jarmarcus", 1.0 },
  { "Jarmarion", 1.0 },
  { "Jarmaris", 1.0 },
  { "Jarmel", 1.0 },
  { "Jarmell", 1.0 },
  { "Jarmen", 1.0 },
  { "Jarmila", 0.0 },
  { "Jarmon", 1.0 },
  { "Jarnae", 0.0 },
  { "Jarnell", 1.0 },
  { "Jaro", 1.0 },
  { "Jarod", 0.9995709 },
  { "Jarodd", 1.0 },
  { "Jarol", 1.0 },
  { "Jarold", 1.0 },
  { "Jarom", 1.0 },
  { "Jarome", 1.0 },
  { "Jaromir", 1.0 },
  { "Jaron", 0.99549425 },
  { "Jaronda", 0.0 },
  { "Jarone", 1.0 },
  { "Jaronn", 1.0 },
  { "Jaronte", 1.0 },
  { "Jaroslav", 1.0 },
  { "Jaroslaw", 1.0 },
  { "Jarquavious", 1.0 },
  { "Jarquavius", 1.0 },
  { "Jarques", 1.0 },
  { "Jarquez", 1.0 },
  { "Jarquis", 1.0 },
  { "Jarquise", 1.0 },
  { "Jarrad", 1.0 },
  { "Jarrah", 0.078125 },
  { "Jarran", 1.0 },
  { "Jarrard", 1.0 },
  { "Jarratt", 1.0 },
  { "Jarreau", 1.0 },
  { "Jarred", 0.9993882 },
  { "Jarrek", 1.0 },
  { "Jarrel", 1.0 },
  { "Jarrell", 0.9945585 },
  { "Jarrelle", 1.0 },
  { "Jarren", 0.9950544 },
  { "Jarret", 1.0 },
  { "Jarreth", 1.0 },
  { "Jarrett", 0.9964738 },
  { "Jarrette", 1.0 },
  { "Jarriah", 0.0 },
  { "Jarrian", 1.0 },
  { "Jarrica", 0.0 },
  { "Jarrick", 1.0 },
  { "Jarrid", 1.0 },
  { "Jarriel", 1.0 },
  { "Jarriet", 1.0 },
  { "Jarrin", 1.0 },
  { "Jarrion", 1.0 },
  { "Jarris", 1.0 },
  { "Jarrison", 1.0 },
  { "Jarrit", 1.0 },
  { "Jarritt", 1.0 },
  { "Jarrius", 1.0 },
  { "Jarrod", 0.9974059 },
  { "Jarrold", 1.0 },
  { "Jarron", 1.0 },
  { "Jarrot", 1.0 },
  { "Jarrott", 1.0 },
  { "Jarry", 1.0 },
  { "Jarryd", 1.0 },
  { "Jarryl", 1.0 },
  { "Jarryn", 1.0 },
  { "Jartavious", 1.0 },
  { "Jartavis", 1.0 },
  { "Jartavius", 1.0 },
  { "Jaruis", 1.0 },
  { "Jarule", 1.0 },
  { "Jarus", 1.0 },
  { "Jarvais", 1.0 },
  { "Jarvaris", 1.0 },
  { "Jarvas", 1.0 },
  { "Jarvell", 1.0 },
  { "Jarvez", 1.0 },
  { "Jarvie", 1.0 },
  { "Jarvin", 1.0 },
  { "Jarvion", 1.0 },
  { "Jarvis", 0.9927651 },
  { "Jarvius", 1.0 },
  { "Jarvon", 1.0 },
  { "Jarvous", 1.0 },
  { "Jarvus", 1.0 },
  { "Jary", 1.0 },
  { "Jarya", 0.0 },
  { "Jaryah", 0.0 },
  { "Jaryan", 1.0 },
  { "Jaryd", 1.0 },
  { "Jaryel", 1.0 },
  { "Jaryia", 0.0 },
  { "Jaryiah", 0.0 },
  { "Jaryl", 1.0 },
  { "Jaryn", 0.61316395 },
  { "Jas", 0.8898305 },
  { "Jasa", 0.0 },
  { "Jasaan", 1.0 },
  { "Jasabelle", 0.0 },
  { "Jasahn", 1.0 },
  { "Jasai", 0.98214287 },
  { "Jasaiah", 0.9029126 },
  { "Jasalin", 0.0 },
  { "Jasalyn", 0.0 },
  { "Jasalynn", 0.0 },
  { "Jasamine", 0.0 },
  { "Jasan", 1.0 },
  { "Jasana", 0.0 },
  { "Jasandra", 0.0 },
  { "Jasani", 0.2793296 },
  { "Jasara", 0.0 },
  { "Jasarah", 0.0 },
  { "Jasaun", 1.0 },
  { "Jasavion", 1.0 },
  { "Jasaya", 0.0 },
  { "Jascha", 1.0 },
  { "Jasdeep", 0.8171642 },
  { "Jase", 0.9940483 },
  { "Jasean", 1.0 },
  { "Jasear", 1.0 },
  { "Jasee", 0.0 },
  { "Jaseem", 1.0 },
  { "Jaseena", 0.0 },
  { "Jaseer", 1.0 },
  { "Jaseir", 1.0 },
  { "Jasek", 1.0 },
  { "Jasel", 0.0 },
  { "Jaselin", 0.0 },
  { "Jasella", 0.0 },
  { "Jaselle", 0.0 },
  { "Jaselyn", 0.0 },
  { "Jaselynn", 0.0 },
  { "Jasem", 1.0 },
  { "Jasemine", 0.0 },
  { "Jasen", 1.0 },
  { "Jasenia", 0.0 },
  { "Jasenya", 0.0 },
  { "Jaseon", 1.0 },
  { "Jaseph", 1.0 },
  { "Jaser", 1.0 },
  { "Jasera", 0.0 },
  { "Jasere", 1.0 },
  { "Jasey", 0.009505703 },
  { "Jash", 1.0 },
  { "Jasha", 0.0 },
  { "Jashad", 1.0 },
  { "Jashae", 0.0 },
  { "Jashala", 0.0 },
  { "Jashan", 0.9766355 },
  { "Jashana", 0.0 },
  { "Jashandeep", 1.0 },
  { "Jashanna", 0.0 },
  { "Jashanpreet", 1.0 },
  { "Jashante", 0.0 },
  { "Jashanti", 0.0 },
  { "Jashara", 0.0 },
  { "Jashaun", 1.0 },
  { "Jashauna", 0.0 },
  { "Jashawn", 0.9834791 },
  { "Jashawna", 0.0 },
  { "Jashay", 0.0 },
  { "Jashayla", 0.0 },
  { "Jashea", 0.0 },
  { "Jasheem", 1.0 },
  { "Jashelle", 0.0 },
  { "Jasher", 1.0 },
  { "Jashia", 0.0 },
  { "Jashira", 0.0 },
  { "Jashiya", 0.0 },
  { "Jashiyah", 0.0 },
  { "Jashley", 0.0 },
  { "Jashod", 1.0 },
  { "Jashon", 0.99298245 },
  { "Jashona", 0.0 },
  { "Jashonda", 0.0 },
  { "Jashone", 1.0 },
  { "Jashonna", 0.0 },
  { "Jashua", 1.0 },
  { "Jashun", 1.0 },
  { "Jashya", 0.0 },
  { "Jashyia", 0.0 },
  { "Jashyra", 0.0 },
  { "Jasi", 0.36 },
  { "Jasia", 0.012605042 },
  { "Jasiah", 0.8963037 },
  { "Jasian", 1.0 },
  { "Jasiana", 0.0 },
  { "Jasianna", 0.0 },
  { "Jasias", 1.0 },
  { "Jasibe", 0.0 },
  { "Jasicianna", 0.0 },
  { "Jasie", 0.0 },
  { "Jasiel", 0.92391306 },
  { "Jasielle", 0.0 },
  { "Jasier", 1.0 },
  { "Jasik", 1.0 },
  { "Jasilyn", 0.0 },
  { "Jasilynn", 0.0 },
  { "Jasim", 1.0 },
  { "Jasiman", 0.0 },
  { "Jasime", 0.0 },
  { "Jasimen", 0.0 },
  { "Jasimine", 0.0 },
  { "Jasin", 1.0 },
  { "Jasine", 0.0 },
  { "Jasinto", 1.0 },
  { "Jasion", 1.0 },
  { "Jasir", 1.0 },
  { "Jasira", 0.0 },
  { "Jasirah", 0.0 },
  { "Jasire", 1.0 },
  { "Jasiri", 0.75757575 },
  { "Jasiya", 0.039215688 },
  { "Jasiyah", 0.38086957 },
  { "Jasjeet", 1.0 },
  { "Jaskaran", 1.0 },
  { "Jaskarn", 1.0 },
  { "Jaskiran", 0.0 },
  { "Jaskirat", 0.7016129 },
  { "Jaslean", 0.0 },
  { "Jasleen", 0.0 },
  { "Jasleene", 0.0 },
  { "Jaslen", 0.0 },
  { "Jaslena", 0.0 },
  { "Jaslene", 0.0 },
  { "Jaslenne", 0.0 },
  { "Jasley", 0.0 },
  { "Jaslin", 0.0 },
  { "Jasline", 0.0 },
  { "Jaslinn", 0.0 },
  { "Jasly", 0.0 },
  { "Jaslyn", 0.0 },
  { "Jaslyne", 0.0 },
  { "Jaslynn", 0.0 },
  { "Jaslynne", 0.0 },
  { "Jasma", 0.0 },
  { "Jasmain", 0.0 },
  { "Jasmaine", 0.0072815535 },
  { "Jasman", 0.15081967 },
  { "Jasmane", 0.0 },
  { "Jasmany", 1.0 },
  { "Jasmari", 0.0 },
  { "Jasmarie", 0.0 },
  { "Jasmary", 0.0 },
  { "Jasmeen", 0.0 },
  { "Jasmeet", 0.2549801 },
  { "Jasmeh", 0.0 },
  { "Jasmely", 0.0 },
  { "Jasmen", 0.017828202 },
  { "Jasmene", 0.0 },
  { "Jasmere", 0.0 },
  { "Jasmia", 0.0 },
  { "Jasmie", 0.0 },
  { "Jasmien", 0.0 },
  { "Jasmijn", 0.0 },
  { "Jasmil", 0.0 },
  { "Jasmin", 0.013279065 },
  { "Jasmina", 0.0 },
  { "Jasminda", 0.0 },
  { "Jasmine", 0.005181816 },
  { "Jasminemarie", 0.0 },
  { "Jasminerose", 0.0 },
  { "Jasminn", 0.0 },
  { "Jasminne", 0.0 },
  { "Jasmir", 0.7692308 },
  { "Jasmire", 0.0 },
  { "Jasmon", 0.36633664 },
  { "Jasmond", 0.6532258 },
  { "Jasmone", 0.0 },
  { "Jasmonique", 0.0 },
  { "Jasmyn", 0.0 },
  { "Jasmyne", 0.0 },
  { "Jasmynn", 0.0 },
  { "Jasmynne", 0.0 },
  { "Jasn", 1.0 },
  { "Jasna", 0.0 },
  { "Jasneet", 0.0 },
  { "Jasniel", 1.0 },
  { "Jasnoor", 0.14141414 },
  { "Jaso", 1.0 },
  { "Jasom", 1.0 },
  { "Jason", 0.9951328 },
  { "Jasona", 0.0 },
  { "Jasonanthony", 1.0 },
  { "Jasonjr", 1.0 },
  { "Jasonlee", 1.0 },
  { "Jasonn", 1.0 },
  { "Jasonna", 0.0 },
  { "Jasonpaul", 1.0 },
  { "Jasontyler", 1.0 },
  { "Jaspal", 1.0 },
  { "Jaspar", 1.0 },
  { "Jaspen", 1.0 },
  { "Jasper", 0.98162603 },
  { "Jaspreet", 0.3956044 },
  { "Jaspyr", 1.0 },
  { "Jasraj", 1.0 },
  { "Jasreen", 0.0 },
  { "Jasreet", 0.0 },
  { "Jassan", 1.0 },
  { "Jassar", 1.0 },
  { "Jassel", 0.0 },
  { "Jasselle", 0.0 },
  { "Jassem", 1.0 },
  { "Jassen", 1.0 },
  { "Jasser", 1.0 },
  { "Jassiah", 0.9201878 },
  { "Jassica", 0.0 },
  { "Jassidy", 0.0 },
  { "Jassie", 0.0 },
  { "Jassiel", 0.98673743 },
  { "Jassiem", 1.0 },
  { "Jassim", 1.0 },
  { "Jassir", 1.0 },
  { "Jasslyn", 0.0 },
  { "Jasslynn", 0.0 },
  { "Jassmen", 0.0 },
  { "Jassmin", 0.0 },
  { "Jassmine", 0.0 },
  { "Jassmyn", 0.0 },
  { "Jasson", 1.0 },
  { "Jasten", 1.0 },
  { "Jastin", 0.93607306 },
  { "Jaston", 1.0 },
  { "Jastyn", 0.0 },
  { "Jasuan", 1.0 },
  { "Jasun", 1.0 },
  { "Jasur", 1.0 },
  { "Jaswinder", 1.0 },
  { "Jaswiry", 0.0 },
  { "Jasy", 0.0 },
  { "Jasya", 0.0 },
  { "Jasyah", 0.7567568 },
  { "Jasye", 1.0 },
  { "Jasyia", 0.0 },
  { "Jasyiah", 0.37037036 },
  { "Jasyn", 1.0 },
  { "Jasyra", 0.0 },
  { "Jaszlyn", 0.0 },
  { "Jaszmin", 0.0 },
  { "Jaszmine", 0.0 },
  { "Jata", 0.0 },
  { "Jataiya", 0.0 },
  { "Jatana", 0.0 },
  { "Jatanna", 0.0 },
  { "Jatara", 0.0 },
  { "Jatari", 1.0 },
  { "Jatarius", 1.0 },
  { "Jatasha", 0.0 },
  { "Jatasia", 0.0 },
  { "Jataun", 0.0 },
  { "Jataurus", 1.0 },
  { "Jatava", 0.0 },
  { "Jataveon", 1.0 },
  { "Jatavia", 0.0 },
  { "Jatavian", 1.0 },
  { "Jatavien", 1.0 },
  { "Jatavion", 1.0 },
  { "Jatavious", 1.0 },
  { "Jatavis", 1.0 },
  { "Jatavius", 1.0 },
  { "Jataya", 0.0 },
  { "Jatayvion", 1.0 },
  { "Jaten", 1.0 },
  { "Jateria", 0.0 },
  { "Jaterica", 0.0 },
  { "Jaterion", 1.0 },
  { "Jaterious", 1.0 },
  { "Jaterius", 1.0 },
  { "Jaterra", 0.0 },
  { "Jaterria", 0.0 },
  { "Jaterrian", 1.0 },
  { "Jaterrica", 0.0 },
  { "Jaterrion", 1.0 },
  { "Jaterrious", 1.0 },
  { "Jaterrius", 1.0 },
  { "Jathan", 1.0 },
  { "Jathaniel", 1.0 },
  { "Jathen", 1.0 },
  { "Jathniel", 1.0 },
  { "Jathon", 1.0 },
  { "Jathziry", 0.0 },
  { "Jatia", 0.0 },
  { "Jatiana", 0.0 },
  { "Jatin", 1.0 },
  { "Jatina", 0.0 },
  { "Jatinder", 1.0 },
  { "Jatisha", 0.0 },
  { "Jatiya", 0.0 },
  { "Jatniel", 1.0 },
  { "Jaton", 0.47008547 },
  { "Jatonya", 0.0 },
  { "Jatori", 0.20833333 },
  { "Jatoria", 0.0 },
  { "Jatorian", 1.0 },
  { "Jatorria", 0.0 },
  { "Jatory", 1.0 },
  { "Jatoya", 0.0 },
  { "Jatwan", 1.0 },
  { "Jatyler", 1.0 },
  { "Jatyra", 0.0 },
  { "Jatziri", 0.0 },
  { "Jatziry", 0.0 },
  { "Jauan", 1.0 },
  { "Jaudiel", 1.0 },
  { "Jauier", 1.0 },
  { "Jaun", 1.0 },
  { "Jauna", 0.0 },
  { "Jaunell", 0.0 },
  { "Jauneta", 0.0 },
  { "Jaunice", 0.0 },
  { "Jaunita", 0.0 },
  { "Jaunna", 0.0 },
  { "Jaunte", 1.0 },
  { "Jauquan", 1.0 },
  { "Jaurice", 1.0 },
  { "Jauron", 1.0 },
  { "Jaushua", 1.0 },
  { "Jaustin", 1.0 },
  { "Jauwana", 0.0 },
  { "Java", 0.5405405 },
  { "Javad", 1.0 },
  { "Javae", 0.24404761 },
  { "Javaeh", 0.0 },
  { "Javahn", 1.0 },
  { "Javair", 1.0 },
  { "Javale", 1.0 },
  { "Javan", 0.9871642 },
  { "Javana", 0.0 },
  { "Javani", 1.0 },
  { "Javanna", 0.0 },
  { "Javanni", 1.0 },
  { "Javant", 1.0 },
  { "Javanta", 1.0 },
  { "Javantay", 1.0 },
  { "Javante", 1.0 },
  { "Javar", 1.0 },
  { "Javare", 1.0 },
  { "Javaree", 1.0 },
  { "Javareon", 1.0 },
  { "Javares", 1.0 },
  { "Javari", 1.0 },
  { "Javaria", 0.0 },
  { "Javarian", 1.0 },
  { "Javarie", 1.0 },
  { "Javario", 1.0 },
  { "Javarion", 1.0 },
  { "Javarious", 1.0 },
  { "Javaris", 1.0 },
  { "Javarius", 1.0 },
  { "Javarous", 1.0 },
  { "Javarri", 1.0 },
  { "Javarrie", 1.0 },
  { "Javarrion", 1.0 },
  { "Javarris", 1.0 },
  { "Javarrius", 1.0 },
  { "Javarron", 1.0 },
  { "Javarus", 1.0 },
  { "Javary", 1.0 },
  { "Javas", 1.0 },
  { "Javaughn", 1.0 },
  { "Javaun", 1.0 },
  { "Javaunte", 1.0 },
  { "Javawn", 1.0 },
  { "Javaya", 0.0 },
  { "Javayah", 0.0 },
  { "Jave", 1.0 },
  { "Javea", 0.0 },
  { "Javeah", 0.0 },
  { "Javean", 1.0 },
  { "Javed", 1.0 },
  { "Javeed", 1.0 },
  { "Javein", 1.0 },
  { "Javeion", 1.0 },
  { "Javel", 1.0 },
  { "Javelin", 0.0 },
  { "Javell", 1.0 },
  { "Javelle", 1.0 },
  { "Javelyn", 0.0 },
  { "Javen", 0.96747965 },
  { "Javene", 0.0 },
  { "Javeon", 1.0 },
  { "Javere", 1.0 },
  { "Javeria", 0.0 },
  { "Javery", 1.0 },
  { "Javetta", 0.0 },
  { "Javette", 0.0 },
  { "Javeya", 0.0 },
  { "Javeyah", 0.0 },
  { "Javeyon", 1.0 },
  { "Javez", 1.0 },
  { "Javi", 1.0 },
  { "Javia", 0.0 },
  { "Javiah", 0.0 },
  { "Javiair", 1.0 },
  { "Javian", 0.99739355 },
  { "Javiana", 0.0 },
  { "Javianna", 0.0 },
  { "Javiar", 1.0 },
  { "Javid", 1.0 },
  { "Javiel", 1.0 },
  { "Javien", 1.0 },
  { "Javieon", 1.0 },
  { "Javier", 0.9948692 },
  { "Javiera", 0.0 },
  { "Javiere", 1.0 },
  { "Javierjr", 1.0 },
  { "Javin", 0.9976744 },
  { "Javina", 0.0 },
  { "Javion", 0.99795955 },
  { "Javiona", 0.0 },
  { "Javione", 1.0 },
  { "Javionna", 0.0 },
  { "Javionne", 1.0 },
  { "Javionte", 1.0 },
  { "Javious", 1.0 },
  { "Javir", 1.0 },
  { "Javis", 0.99401915 },
  { "Javita", 0.0 },
  { "Javius", 1.0 },
  { "Javiyon", 1.0 },
  { "Javlyn", 0.0 },
  { "Javohn", 1.0 },
  { "Javon", 0.95490384 },
  { "Javona", 0.0 },
  { "Javonda", 0.0 },
  { "Javondre", 1.0 },
  { "Javone", 0.9744186 },
  { "Javoni", 0.953917 },
  { "Javonia", 0.0 },
  { "Javonie", 1.0 },
  { "Javonn", 1.0 },
  { "Javonna", 0.0 },
  { "Javonne", 0.45970148 },
  { "Javonni", 0.88643533 },
  { "Javonnie", 0.8979592 },
  { "Javonta", 1.0 },
  { "Javontae", 1.0 },
  { "Javontai", 1.0 },
  { "Javontay", 1.0 },
  { "Javontaye", 1.0 },
  { "Javonte", 0.9889706 },
  { "Javontez", 1.0 },
  { "Javonti", 1.0 },
  { "Javor", 1.0 },
  { "Javori", 1.0 },
  { "Javoris", 1.0 },
  { "Javorius", 1.0 },
  { "Javy", 1.0 },
  { "Javyion", 1.0 },
  { "Javyn", 1.0 },
  { "Javyon", 1.0 },
  { "Jawaad", 1.0 },
  { "Jawaan", 1.0 },
  { "Jawad", 1.0 },
  { "Jawaher", 0.0 },
  { "Jawan", 0.9913793 },
  { "Jawana", 0.0 },
  { "Jawanda", 0.0 },
  { "Jawane", 1.0 },
  { "Jawann", 1.0 },
  { "Jawanna", 0.0 },
  { "Jawanza", 0.97572815 },
  { "Jawara", 0.98207885 },
  { "Jawarren", 1.0 },
  { "Jawaski", 1.0 },
  { "Jawaun", 1.0 },
  { "Jawayne", 1.0 },
  { "Jawdat", 1.0 },
  { "Jawhar", 1.0 },
  { "Jawon", 0.9933599 },
  { "Jawone", 1.0 },
  { "Jawonna", 0.0 },
  { "Jaworski", 1.0 },
  { "Jawuan", 1.0 },
  { "Jawun", 1.0 },
  { "Jawvan", 1.0 },
  { "Jawwaad", 1.0 },
  { "Jawwad", 1.0 },
  { "Jax", 0.99094063 },
  { "Jaxan", 1.0 },
  { "Jaxcyn", 1.0 },
  { "Jaxden", 1.0 },
  { "Jaxel", 1.0 },
  { "Jaxen", 0.98866564 },
  { "Jaxi", 0.0 },
  { "Jaxie", 0.0 },
  { "Jaxiel", 1.0 },
  { "Jaxin", 1.0 },
  { "Jaxion", 1.0 },
  { "Jaxlyn", 0.0 },
  { "Jaxlynn", 0.0 },
  { "Jaxn", 1.0 },
  { "Jaxom", 1.0 },
  { "Jaxon", 0.99577814 },
  { "Jaxonjames", 1.0 },
  { "Jaxper", 1.0 },
  { "Jaxs", 1.0 },
  { "Jaxsen", 0.99535245 },
  { "Jaxsin", 1.0 },
  { "Jaxson", 0.99809045 },
  { "Jaxsten", 1.0 },
  { "Jaxstin", 1.0 },
  { "Jaxston", 1.0 },
  { "Jaxstyn", 1.0 },
  { "Jaxsun", 1.0 },
  { "Jaxsyn", 0.8558719 },
  { "Jaxten", 1.0 },
  { "Jaxtin", 1.0 },
  { "Jaxton", 1.0 },
  { "Jaxtyn", 1.0 },
  { "Jaxun", 1.0 },
  { "Jaxx", 0.9874477 },
  { "Jaxxen", 1.0 },
  { "Jaxxin", 1.0 },
  { "Jaxxon", 1.0 },
  { "Jaxxson", 1.0 },
  { "Jaxxton", 1.0 },
  { "Jaxxyn", 1.0 },
  { "Jaxyn", 0.7669441 },
  { "Jaxzen", 1.0 },
  { "Jaxzon", 1.0 },
  { "Jaxzyn", 1.0 },
  { "Jay", 0.9869592 },
  { "Jaya", 0.0074481866 },
  { "Jayace", 1.0 },
  { "Jayah", 0.0 },
  { "Jayahna", 0.0 },
  { "Jayan", 1.0 },
  { "Jayana", 0.0 },
  { "Jayanah", 0.0 },
  { "Jayandre", 1.0 },
  { "Jayani", 0.0 },
  { "Jayann", 0.0 },
  { "Jayanna", 0.0 },
  { "Jayannah", 0.0 },
  { "Jayanne", 0.0 },
  { "Jayanni", 0.0 },
  { "Jayansh", 1.0 },
  { "Jayant", 1.0 },
  { "Jayanth", 1.0 },
  { "Jayanthony", 1.0 },
  { "Jayanti", 0.0 },
  { "Jayar", 1.0 },
  { "Jayaun", 1.0 },
  { "Jayauna", 0.0 },
  { "Jayben", 1.0 },
  { "Jaybin", 1.0 },
  { "Jaybree", 0.0 },
  { "Jaybriel", 1.0 },
  { "Jayc", 1.0 },
  { "Jayce", 0.94467014 },
  { "Jaycean", 1.0 },
  { "Jaycee", 0.116983496 },
  { "Jayceeon", 1.0 },
  { "Jayceion", 1.0 },
  { "Jaycek", 1.0 },
  { "Jaycelyn", 0.0 },
  { "Jaycelynn", 0.0 },
  { "Jaycen", 0.994382 },
  { "Jayceon", 0.9951771 },
  { "Jayceona", 0.0 },
  { "Jayceonna", 0.0 },
  { "Jaycey", 0.0 },
  { "Jayceyon", 1.0 },
  { "Jayci", 0.0 },
  { "Jaycia", 0.0 },
  { "Jaycian", 1.0 },
  { "Jayciana", 0.0 },
  { "Jaycie", 0.0015033073 },
  { "Jaycieon", 1.0 },
  { "Jaycii", 0.0 },
  { "Jaycin", 1.0 },
  { "Jaycion", 1.0 },
  { "Jayco", 1.0 },
  { "Jaycob", 1.0 },
  { "Jaycon", 1.0 },
  { "Jaycub", 1.0 },
  { "Jayd", 0.24367817 },
  { "Jayda", 0.0013518081 },
  { "Jaydah", 0.0 },
  { "Jaydalee", 0.0 },
  { "Jaydalin", 0.0 },
  { "Jaydalis", 0.0 },
  { "Jaydalise", 0.0 },
  { "Jaydaliz", 0.0 },
  { "Jaydalyn", 0.0 },
  { "Jaydalynn", 0.0 },
  { "Jaydamarie", 0.0 },
  { "Jaydan", 0.82305545 },
  { "Jaydann", 0.0 },
  { "Jaydden", 1.0 },
  { "Jayde", 0.05174741 },
  { "Jaydean", 1.0 },
  { "Jaydee", 0.44771242 },
  { "Jaydeen", 0.5947368 },
  { "Jaydeep", 1.0 },
  { "Jaydehn", 1.0 },
  { "Jaydein", 1.0 },
  { "Jaydel", 1.0 },
  { "Jaydelin", 0.0 },
  { "Jaydeliz", 0.0 },
  { "Jaydelyn", 0.0 },
  { "Jaydelynn", 0.0 },
  { "Jaydem", 1.0 },
  { "Jayden", 0.90273684 },
  { "Jaydenalexander", 1.0 },
  { "Jaydence", 0.42857143 },
  { "Jaydenjames", 1.0 },
  { "Jaydenlee", 1.0 },
  { "Jaydenmatthew", 1.0 },
  { "Jaydenmichael", 1.0 },
  { "Jaydenn", 0.8600583 },
  { "Jaydhen", 1.0 },
  { "Jaydi", 0.0 },
  { "Jaydia", 0.0 },
  { "Jaydian", 1.0 },
  { "Jaydie", 0.0 },
  { "Jaydiel", 1.0 },
  { "Jaydien", 1.0 },
  { "Jaydin", 0.7218007 },
  { "Jaydis", 0.90225565 },
  { "Jaydn", 0.61957616 },
  { "Jaydon", 0.97664165 },
  { "Jaydrian", 1.0 },
  { "Jaydrien", 1.0 },
  { "Jaydun", 1.0 },
  { "Jaydus", 1.0 },
  { "Jaydy", 0.0 },
  { "Jaydyn", 0.5650752 },
  { "Jaydynn", 0.275 },
  { "Jaye", 0.30339733 },
  { "Jayeda", 0.0 },
  { "Jayeden", 1.0 },
  { "Jayel", 0.47972974 },
  { "Jayela", 0.0 },
  { "Jayelin", 1.0 },
  { "Jayelle", 0.0 },
  { "Jayelyn", 0.0 },
  { "Jayelynn", 0.0 },
  { "Jayen", 1.0 },
  { "Jayesh", 1.0 },
  { "Jayetta", 0.0 },
  { "Jayger", 1.0 },
  { "Jayhden", 1.0 },
  { "Jayia", 0.0 },
  { "Jayiah", 0.0 },
  { "Jayiden", 1.0 },
  { "Jayin", 1.0 },
  { "Jayion", 1.0 },
  { "Jayjay", 1.0 },
  { "Jayjuan", 1.0 },
  { "Jayk", 1.0 },
  { "Jayke", 1.0 },
  { "Jayken", 1.0 },
  { "Jaykin", 1.0 },
  { "Jayko", 1.0 },
  { "Jaykob", 1.0 },
  { "Jaykon", 1.0 },
  { "Jaykub", 1.0 },
  { "Jaykwan", 1.0 },
  { "Jaykwon", 1.0 },
  { "Jayla", 0.0013728868 },
  { "Jaylaa", 0.0 },
  { "Jaylaah", 0.0 },
  { "Jaylaan", 0.0 },
  { "Jaylah", 0.0 },
  { "Jaylamarie", 0.0 },
  { "Jaylan", 0.84388864 },
  { "Jaylana", 0.0 },
  { "Jayland", 1.0 },
  { "Jaylani", 0.031767957 },
  { "Jaylanie", 0.0 },
  { "Jaylanis", 0.0 },
  { "Jaylann", 0.0 },
  { "Jaylanni", 0.0 },
  { "Jaylannie", 0.0 },
  { "Jaylany", 0.0 },
  { "Jaylarose", 0.0 },
  { "Jaylaun", 1.0 },
  { "Jayle", 0.0 },
  { "Jaylea", 0.0 },
  { "Jayleah", 0.0 },
  { "Jaylean", 0.0 },
  { "Jayleana", 0.0 },
  { "Jayleanna", 0.0 },
  { "Jaylece", 0.0 },
  { "Jaylee", 0.015714286 },
  { "Jayleen", 0.02211357 },
  { "Jayleena", 0.0 },
  { "Jayleene", 0.0 },
  { "Jaylei", 0.0 },
  { "Jayleigh", 0.0 },
  { "Jaylein", 0.23809524 },
  { "Jaylem", 1.0 },
  { "Jaylen", 0.88257533 },
  { "Jaylena", 0.0 },
  { "Jaylend", 1.0 },
  { "Jaylene", 0.009338812 },
  { "Jaylenn", 0.36679536 },
  { "Jaylenne", 0.0 },
  { "Jayleon", 1.0 },
  { "Jaylese", 0.0 },
  { "Jaylex", 1.0 },
  { "Jayley", 0.0 },
  { "Jayli", 0.0 },
  { "Jaylia", 0.0 },
  { "Jayliah", 0.0 },
  { "Jaylian", 1.0 },
  { "Jayliana", 0.0 },
  { "Jayliani", 0.0 },
  { "Jaylianie", 0.0 },
  { "Jaylianis", 0.0 },
  { "Jaylianiz", 0.0 },
  { "Jaylianna", 0.0 },
  { "Jayliannie", 0.0 },
  { "Jayliany", 0.0 },
  { "Jaylicia", 0.0 },
  { "Jaylie", 0.0 },
  { "Jaylien", 0.6041667 },
  { "Jaylin", 0.557292 },
  { "Jaylina", 0.0 },
  { "Jaylind", 1.0 },
  { "Jayline", 0.006127451 },
  { "Jaylinn", 0.04307692 },
  { "Jaylinne", 0.0 },
  { "Jaylis", 0.0 },
  { "Jaylisa", 0.0 },
  { "Jaylise", 0.0 },
  { "Jaylissa", 0.0 },
  { "Jaylisse", 0.0 },
  { "Jayliyah", 0.0 },
  { "Jayliz", 0.0 },
  { "Jayllen", 1.0 },
  { "Jayln", 0.646875 },
  { "Jaylnn", 0.0 },
  { "Jaylon", 0.9729643 },
  { "Jaylond", 1.0 },
  { "Jayloni", 1.0 },
  { "Jaylonn", 1.0 },
  { "Jaylun", 1.0 },
  { "Jayly", 0.0 },
  { "Jaylyn", 0.23667377 },
  { "Jaylyne", 0.048076924 },
  { "Jaylynn", 0.056526948 },
  { "Jaylynne", 0.0 },
  { "Jayma", 0.0 },
  { "Jayman", 1.0 },
  { "Jaymani", 1.0 },
  { "Jaymar", 1.0 },
  { "Jaymari", 1.0 },
  { "Jaymarie", 0.0 },
  { "Jaymarion", 1.0 },
  { "Jaymason", 1.0 },
  { "Jayme", 0.2124 },
  { "Jaymee", 0.011241447 },
  { "Jaymeir", 1.0 },
  { "Jaymel", 1.0 },
  { "Jaymen", 1.0 },
  { "Jaymere", 1.0 },
  { "Jaymes", 0.9733807 },
  { "Jaymesha", 0.0 },
  { "Jaymeson", 0.96103895 },
  { "Jaymez", 1.0 },
  { "Jaymi", 0.0037907506 },
  { "Jaymiah", 0.0 },
  { "Jaymian", 1.0 },
  { "Jaymichael", 1.0 },
  { "Jaymie", 0.10823408 },
  { "Jaymien", 1.0 },
  { "Jaymier", 1.0 },
  { "Jaymin", 1.0 },
  { "Jaymion", 1.0 },
  { "Jaymir", 1.0 },
  { "Jaymis", 1.0 },
  { "Jaymisha", 0.0 },
  { "Jaymison", 1.0 },
  { "Jaymiya", 0.0 },
  { "Jaymon", 1.0 },
  { "Jaymond", 1.0 },
  { "Jayms", 1.0 },
  { "Jaymya", 0.0 },
  { "Jaymz", 1.0 },
  { "Jayn", 0.0 },
  { "Jayna", 0.0 },
  { "Jaynae", 0.0 },
  { "Jaynah", 0.0 },
  { "Jaynalis", 0.0 },
  { "Jayne", 0.0011219409 },
  { "Jaynee", 0.0 },
  { "Jayneen", 0.0 },
  { "Jaynell", 0.0 },
  { "Jaynelle", 0.0 },
  { "Jaynesha", 0.0 },
  { "Jaynette", 0.0 },
  { "Jayni", 0.15625 },
  { "Jaynia", 0.0 },
  { "Jayniah", 0.0 },
  { "Jaynice", 0.0 },
  { "Jaynie", 0.0 },
  { "Jaynisha", 0.0 },
  { "Jayniyah", 0.0 },
  { "Jaynne", 0.0 },
  { "Jayon", 1.0 },
  { "Jayona", 0.0 },
  { "Jayonah", 0.0 },
  { "Jayonn", 1.0 },
  { "Jayonna", 0.0 },
  { "Jayonni", 0.52380955 },
  { "Jayonte", 1.0 },
  { "Jayquan", 1.0 },
  { "Jayquin", 1.0 },
  { "Jayquon", 1.0 },
  { "Jayqwan", 1.0 },
  { "Jayr", 1.0 },
  { "Jayra", 0.0 },
  { "Jayre", 0.0 },
  { "Jayree", 1.0 },
  { "Jayrell", 1.0 },
  { "Jayren", 1.0 },
  { "Jayriel", 1.0 },
  { "Jayrin", 1.0 },
  { "Jayro", 1.0 },
  { "Jayron", 1.0 },
  { "Jaysa", 0.0 },
  { "Jaysan", 1.0 },
  { "Jaysaun", 1.0 },
  { "Jayse", 0.9823279 },
  { "Jaysea", 0.0 },
  { "Jaysean", 1.0 },
  { "Jaysen", 1.0 },
  { "Jayseon", 1.0 },
  { "Jaysha", 0.0 },
  { "Jayshan", 1.0 },
  { "Jayshaun", 1.0 },
  { "Jayshawn", 1.0 },
  { "Jayshon", 1.0 },
  { "Jayshun", 1.0 },
  { "Jaysia", 0.0 },
  { "Jaysiah", 1.0 },
  { "Jaysian", 1.0 },
  { "Jaysie", 0.0 },
  { "Jaysin", 1.0 },
  { "Jaysion", 1.0 },
  { "Jayslin", 0.0 },
  { "Jayson", 0.99897444 },
  { "Jaysson", 1.0 },
  { "Jaysten", 1.0 },
  { "Jaystin", 1.0 },
  { "Jayston", 1.0 },
  { "Jaysun", 1.0 },
  { "Jaytee", 1.0 },
  { "Jayten", 1.0 },
  { "Jaythan", 1.0 },
  { "Jaythen", 1.0 },
  { "Jaythian", 1.0 },
  { "Jaython", 1.0 },
  { "Jaytin", 1.0 },
  { "Jayton", 1.0 },
  { "Jayva", 0.0 },
  { "Jayvan", 1.0 },
  { "Jayvaughn", 1.0 },
  { "Jayvaun", 1.0 },
  { "Jayvean", 1.0 },
  { "Jayvee", 1.0 },
  { "Jayveer", 1.0 },
  { "Jayvein", 1.0 },
  { "Jayveion", 1.0 },
  { "Jayven", 1.0 },
  { "Jayveon", 1.0 },
  { "Jayvia", 0.0 },
  { "Jayvian", 1.0 },
  { "Jayvien", 1.0 },
  { "Jayvier", 1.0 },
  { "Jayvin", 1.0 },
  { "Jayvion", 1.0 },
  { "Jayviona", 0.0 },
  { "Jayvionna", 0.0 },
  { "Jayvis", 1.0 },
  { "Jayvius", 1.0 },
  { "Jayvn", 1.0 },
  { "Jayvon", 1.0 },
  { "Jayvone", 1.0 },
  { "Jayvonn", 1.0 },
  { "Jayvonna", 0.0 },
  { "Jayvonne", 1.0 },
  { "Jayvonni", 1.0 },
  { "Jayvonte", 1.0 },
  { "Jayvyn", 1.0 },
  { "Jaywana", 0.0 },
  { "Jaywanna", 0.0 },
  { "Jaywon", 1.0 },
  { "Jayz", 1.0 },
  { "Jayza", 0.0 },
  { "Jayze", 1.0 },
  { "Jayzen", 1.0 },
  { "Jayzeon", 1.0 },
  { "Jayziah", 1.0 },
  { "Jayziel", 1.0 },
  { "Jayzier", 1.0 },
  { "Jayzin", 1.0 },
  { "Jayzion", 1.0 },
  { "Jayzon", 1.0 },
  { "Jaz", 0.671875 },
  { "Jaza", 0.0 },
  { "Jazabel", 0.0 },
  { "Jazabell", 0.0 },
  { "Jazabella", 0.0 },
  { "Jazabelle", 0.0 },
  { "Jazae", 0.0 },
  { "Jazael", 1.0 },
  { "Jazahria", 0.0 },
  { "Jazai", 1.0 },
  { "Jazaiah", 0.64285713 },
  { "Jazaih", 1.0 },
  { "Jazaiya", 0.0 },
  { "Jazale", 0.0 },
  { "Jazalin", 0.0 },
  { "Jazalle", 0.0 },
  { "Jazalyn", 0.0 },
  { "Jazalynn", 0.0 },
  { "Jazamine", 0.0 },
  { "Jazanae", 0.0 },
  { "Jazaniah", 0.0 },
  { "Jazara", 0.0 },
  { "Jazarah", 0.0 },
  { "Jazari", 0.30985916 },
  { "Jazaria", 0.0 },
  { "Jazariah", 0.0 },
  { "Jazarian", 1.0 },
  { "Jazarion", 1.0 },
  { "Jazariya", 0.0 },
  { "Jazariyah", 0.0 },
  { "Jazavian", 1.0 },
  { "Jazavier", 1.0 },
  { "Jazavion", 1.0 },
  { "Jazay", 0.0 },
  { "Jazaya", 0.0 },
  { "Jazayah", 0.0 },
  { "Jazayvion", 1.0 },
  { "Jazbel", 0.0 },
  { "Jaze", 1.0 },
  { "Jazeel", 1.0 },
  { "Jazeer", 1.0 },
  { "Jazeera", 0.0 },
  { "Jazel", 0.018867925 },
  { "Jazell", 0.0 },
  { "Jazella", 0.0 },
  { "Jazelle", 0.0 },
  { "Jazelyn", 0.0 },
  { "Jazelynn", 0.0 },
  { "Jazemine", 0.0 },
  { "Jazen", 1.0 },
  { "Jazer", 1.0 },
  { "Jazette", 0.0 },
  { "Jazharia", 0.0 },
  { "Jazhiel", 1.0 },
  { "Jazia", 0.0 },
  { "Jaziah", 0.5396073 },
  { "Jazib", 1.0 },
  { "Jaziel", 0.9773313 },
  { "Jazier", 1.0 },
  { "Jazilyn", 0.0 },
  { "Jazilynn", 0.0 },
  { "Jazimine", 0.0 },
  { "Jazin", 1.0 },
  { "Jazion", 1.0 },
  { "Jazir", 1.0 },
  { "Jazira", 0.0 },
  { "Jazirah", 0.0 },
  { "Jazire", 0.0 },
  { "Jazive", 0.0 },
  { "Jaziya", 0.0 },
  { "Jaziyah", 0.033379693 },
  { "Jazlean", 0.0 },
  { "Jazlee", 0.0 },
  { "Jazleen", 0.0 },
  { "Jazleene", 0.0 },
  { "Jazlen", 0.0 },
  { "Jazlena", 0.0 },
  { "Jazlene", 0.0 },
  { "Jazlin", 0.0 },
  { "Jazlina", 0.0 },
  { "Jazline", 0.0 },
  { "Jazly", 0.0 },
  { "Jazlyn", 0.0 },
  { "Jazlyne", 0.0 },
  { "Jazlynn", 0.0 },
  { "Jazlynne", 0.0 },
  { "Jazma", 0.0 },
  { "Jazmaine", 0.0 },
  { "Jazman", 0.032352943 },
  { "Jazmane", 0.0 },
  { "Jazmany", 1.0 },
  { "Jazmari", 0.0 },
  { "Jazmariah", 0.0 },
  { "Jazmarie", 0.0 },
  { "Jazmeen", 0.0 },
  { "Jazmein", 0.0 },
  { "Jazmen", 0.0046554934 },
  { "Jazmene", 0.0 },
  { "Jazmenn", 0.0 },
  { "Jazmere", 0.0 },
  { "Jazmia", 0.0 },
  { "Jazmin", 0.0056146425 },
  { "Jazmina", 0.0 },
  { "Jazmine", 0.002814659 },
  { "Jazminn", 0.0 },
  { "Jazminne", 0.0 },
  { "Jazmon", 0.13793103 },
  { "Jazmond", 0.6296296 },
  { "Jazmone", 0.0 },
  { "Jazmun", 0.0 },
  { "Jazmyn", 0.0 },
  { "Jazmyne", 0.0 },
  { "Jazmynn", 0.0 },
  { "Jazmynne", 0.0 },
  { "Jazon", 1.0 },
  { "Jazper", 1.0 },
  { "Jazsmin", 0.0 },
  { "Jazsmine", 0.0 },
  { "Jazuri", 0.0 },
  { "Jazya", 0.0 },
  { "Jazyah", 0.0 },
  { "Jazyia", 0.0 },
  { "Jazyiah", 0.0 },
  { "Jazymne", 0.0 },
  { "Jazyon", 1.0 },
  { "Jazyra", 0.0 },
  { "Jazyria", 0.0 },
  { "Jazyriah", 0.0 },
  { "Jazz", 0.5856905 },
  { "Jazzabella", 0.0 },
  { "Jazzabelle", 0.0 },
  { "Jazzae", 0.0 },
  { "Jazzalyn", 0.0 },
  { "Jazzalynn", 0.0 },
  { "Jazzanae", 0.0 },
  { "Jazzarae", 0.0 },
  { "Jazzariah", 0.0 },
  { "Jazzel", 0.0 },
  { "Jazzell", 0.0 },
  { "Jazzelle", 0.0 },
  { "Jazzelyn", 0.0 },
  { "Jazzi", 0.0 },
  { "Jazzia", 0.0 },
  { "Jazziah", 0.0 },
  { "Jazzie", 0.0 },
  { "Jazziel", 1.0 },
  { "Jazzilyn", 0.0 },
  { "Jazzilynn", 0.0 },
  { "Jazzleen", 0.0 },
  { "Jazzlene", 0.0 },
  { "Jazzlin", 0.0 },
  { "Jazzlyn", 0.0 },
  { "Jazzlyne", 0.0 },
  { "Jazzlynn", 0.0 },
  { "Jazzlynne", 0.0 },
  { "Jazzma", 0.0 },
  { "Jazzmaine", 0.0 },
  { "Jazzman", 0.09090909 },
  { "Jazzmarie", 0.0 },
  { "Jazzmen", 0.0 },
  { "Jazzmene", 0.0 },
  { "Jazzmin", 0.0 },
  { "Jazzmine", 0.0 },
  { "Jazzminn", 0.0 },
  { "Jazzmon", 0.0 },
  { "Jazzmond", 0.0 },
  { "Jazzmun", 0.0 },
  { "Jazzmyn", 0.0 },
  { "Jazzmyne", 0.0 },
  { "Jazzmynn", 0.0 },
  { "Jazzy", 0.0 },
  { "Jb", 1.0 },
  { "Jc", 0.9780415 },
  { "Jceion", 1.0 },
  { "Jceon", 1.0 },
  { "Jceyon", 1.0 },
  { "Jcion", 1.0 },
  { "Jcorey", 1.0 },
  { "Jcyon", 1.0 },
  { "Jd", 0.97692305 },
  { "Jda", 0.0 },
  { "Jdah", 0.0 },
  { "Jdan", 1.0 },
  { "Jden", 1.0 },
  { "Jdin", 1.0 },
  { "Jdon", 1.0 },
  { "Jdyn", 1.0 },
  { "Jdynn", 1.0 },
  { "Je", 1.0 },
  { "Jea", 0.0 },
  { "Jeaden", 1.0 },
  { "Jeadon", 1.0 },
  { "Jealisa", 0.0 },
  { "Jealousy", 0.0 },
  { "Jealyn", 0.0 },
  { "Jeamileth", 0.0 },
  { "Jean", 0.049225822 },
  { "Jeana", 0.0 },
  { "Jeanae", 0.0 },
  { "Jeanann", 0.0 },
  { "Jeananne", 0.0 },
  { "Jeanasia", 0.0 },
  { "Jeanaya", 0.0 },
  { "Jeanbaptiste", 1.0 },
  { "Jeancarlo", 1.0 },
  { "Jeancarlos", 1.0 },
  { "Jeanchristophe", 1.0 },
  { "Jeanclaude", 1.0 },
  { "Jeane", 0.0035603025 },
  { "Jeanea", 0.0 },
  { "Jeanean", 0.0 },
  { "Jeaneane", 0.0 },
  { "Jeanee", 0.0 },
  { "Jeaneen", 0.0 },
  { "Jeanel", 0.0 },
  { "Jeanell", 0.0 },
  { "Jeanella", 0.0 },
  { "Jeanelle", 0.0 },
  { "Jeanelly", 0.0 },
  { "Jeanene", 0.0 },
  { "Jeanenne", 0.0 },
  { "Jeanessa", 0.0 },
  { "Jeanet", 0.0 },
  { "Jeanete", 0.0 },
  { "Jeaneth", 0.0 },
  { "Jeanett", 0.0 },
  { "Jeanetta", 0.0 },
  { "Jeanette", 0.0032939448 },
  { "Jeanettie", 0.0 },
  { "Jeani", 0.0 },
  { "Jeania", 0.0 },
  { "Jeanice", 0.0 },
  { "Jeanie", 0.0 },
  { "Jeaniece", 0.0 },
  { "Jeaniene", 0.0 },
  { "Jeanifer", 0.0 },
  { "Jeanina", 0.0 },
  { "Jeanine", 0.00046437015 },
  { "Jeaninne", 0.0 },
  { "Jeanique", 0.0 },
  { "Jeanise", 0.0 },
  { "Jeanita", 0.0 },
  { "Jeanitta", 0.0 },
  { "Jeaniyah", 0.0 },
  { "Jeanjacques", 1.0 },
  { "Jeanluc", 1.0 },
  { "Jeanluca", 1.0 },
  { "Jeanlucas", 1.0 },
  { "Jeanluke", 1.0 },
  { "Jeanmarc", 1.0 },
  { "Jeanmarco", 1.0 },
  { "Jeanmarie", 0.0 },
  { "Jeanmichael", 1.0 },
  { "Jeanmichel", 1.0 },
  { "Jeann", 0.0 },
  { "Jeanna", 0.0 },
  { "Jeanne", 0.002211224 },
  { "Jeannea", 0.0 },
  { "Jeannean", 0.0 },
  { "Jeannedarc", 0.0 },
  { "Jeannee", 0.0 },
  { "Jeannell", 0.0 },
  { "Jeannelle", 0.0 },
  { "Jeannemarie", 0.0 },
  { "Jeannene", 0.0 },
  { "Jeannet", 0.0 },
  { "Jeannete", 0.0 },
  { "Jeannett", 0.0 },
  { "Jeannetta", 0.0 },
  { "Jeannette", 0.00070930197 },
  { "Jeanney", 0.0 },
  { "Jeanni", 0.0 },
  { "Jeannia", 0.0 },
  { "Jeannice", 0.0 },
  { "Jeannicole", 0.0 },
  { "Jeannie", 0.001529137 },
  { "Jeannifer", 0.0 },
  { "Jeannine", 0.0002499063 },
  { "Jeanny", 0.0 },
  { "Jeanpaul", 1.0 },
  { "Jeanphilippe", 1.0 },
  { "Jeanpierre", 1.0 },
  { "Jeantte", 0.0 },
  { "Jeany", 0.0 },
  { "Jearl", 0.9087838 },
  { "Jearld", 1.0 },
  { "Jearldean", 0.0 },
  { "Jearldine", 0.0 },
  { "Jearlean", 0.0 },
  { "Jearlene", 0.0 },
  { "Jearline", 0.0 },
  { "Jearold", 1.0 },
  { "Jeason", 1.0 },
  { "Jeaven", 1.0 },
  { "Jeb", 1.0 },
  { "Jebadiah", 1.0 },
  { "Jebb", 1.0 },
  { "Jebediah", 1.0 },
  { "Jebidiah", 1.0 },
  { "Jebreel", 1.0 },
  { "Jebria", 0.0 },
  { "Jebron", 1.0 },
  { "Jecaryous", 1.0 },
  { "Jeccica", 0.0 },
  { "Jecenia", 0.0 },
  { "Jeckson", 1.0 },
  { "Jeconiah", 1.0 },
  { "Jecorey", 1.0 },
  { "Jecori", 1.0 },
  { "Jecory", 1.0 },
  { "Jed", 1.0 },
  { "Jeda", 0.0 },
  { "Jedadia", 1.0 },
  { "Jedadiah", 1.0 },
  { "Jedah", 0.0 },
  { "Jedaiah", 1.0 },
  { "Jedarius", 1.0 },
  { "Jedd", 1.0 },
  { "Jeddie", 1.0 },
  { "Jedediah", 1.0 },
  { "Jeden", 1.0 },
  { "Jedi", 1.0 },
  { "Jediael", 1.0 },
  { "Jediah", 1.0 },
  { "Jedidah", 0.0 },
  { "Jedidiah", 0.995667 },
  { "Jediel", 1.0 },
  { "Jedikiah", 1.0 },
  { "Jedrek", 1.0 },
  { "Jedric", 1.0 },
  { "Jedrick", 1.0 },
  { "Jedriel", 1.0 },
  { "Jedrik", 1.0 },
  { "Jee", 0.11627907 },
  { "Jeel", 0.5 },
  { "Jeena", 0.0 },
  { "Jeenifer", 0.0 },
  { "Jeese", 1.0 },
  { "Jeesica", 0.0 },
  { "Jeet", 1.0 },
  { "Jeeva", 1.0 },
  { "Jeevan", 1.0 },
  { "Jeevika", 0.0 },
  { "Jeeya", 0.0 },
  { "Jeeyoung", 0.0 },
  { "Jef", 1.0 },
  { "Jeferson", 1.0 },
  { "Jefery", 1.0 },
  { "Jeff", 0.9978515 },
  { "Jeffary", 1.0 },
  { "Jeffer", 1.0 },
  { "Jefferey", 1.0 },
  { "Jefferi", 1.0 },
  { "Jefferie", 1.0 },
  { "Jefferson", 1.0 },
  { "Jeffery", 0.99448204 },
  { "Jeffey", 1.0 },
  { "Jeffie", 0.4008289 },
  { "Jeffifer", 0.0 },
  { "Jeffon", 1.0 },
  { "Jefford", 1.0 },
  { "Jefforey", 1.0 },
  { "Jeffory", 1.0 },
  { "Jeffray", 1.0 },
  { "Jeffre", 1.0 },
  { "Jeffree", 1.0 },
  { "Jeffren", 1.0 },
  { "Jeffrery", 1.0 },
  { "Jeffrey", 0.9964156 },
  { "Jeffreyjames", 1.0 },
  { "Jeffri", 1.0 },
  { "Jeffrie", 0.9152709 },
  { "Jeffries", 1.0 },
  { "Jeffro", 1.0 },
  { "Jeffry", 0.99934286 },
  { "Jeffy", 1.0 },
  { "Jefre", 1.0 },
  { "Jefren", 1.0 },
  { "Jefrey", 1.0 },
  { "Jefri", 1.0 },
  { "Jefrin", 1.0 },
  { "Jefry", 1.0 },
  { "Jefte", 1.0 },
  { "Jeg", 1.0 },
  { "Jehad", 1.0 },
  { "Jehan", 0.24311927 },
  { "Jehiel", 1.0 },
  { "Jehieli", 0.0 },
  { "Jehilyn", 0.0 },
  { "Jehlani", 0.6 },
  { "Jehna", 0.0 },
  { "Jehnna", 0.0 },
  { "Jehonadab", 1.0 },
  { "Jehoshua", 1.0 },
  { "Jehovah", 1.0 },
  { "Jehovany", 1.0 },
  { "Jehremy", 1.0 },
  { "Jehron", 1.0 },
  { "Jehu", 1.0 },
  { "Jeice", 1.0 },
  { "Jeicob", 1.0 },
  { "Jeida", 0.0 },
  { "Jeidan", 1.0 },
  { "Jeiden", 1.0 },
  { "Jeidi", 0.0 },
  { "Jeidy", 0.0 },
  { "Jeidyn", 1.0 },
  { "Jeiel", 1.0 },
  { "Jeila", 0.0 },
  { "Jeilani", 0.0 },
  { "Jeilany", 0.0 },
  { "Jeileen", 0.0 },
  { "Jeilene", 0.0 },
  { "Jeilianys", 0.0 },
  { "Jeilin", 0.0 },
  { "Jeily", 0.0 },
  { "Jeilyn", 0.0 },
  { "Jeilynn", 0.0 },
  { "Jeimi", 0.0 },
  { "Jeimmy", 0.0 },
  { "Jeimy", 0.0 },
  { "Jeiner", 1.0 },
  { "Jeinny", 0.0 },
  { "Jeiny", 0.0 },
  { "Jeira", 0.0 },
  { "Jeiren", 1.0 },
  { "Jeiri", 0.0 },
  { "Jeiry", 0.0 },
  { "Jeison", 1.0 },
  { "Jeisy", 0.0 },
  { "Jeiza", 0.0 },
  { "Jejuan", 1.0 },
  { "Jekai", 1.0 },
  { "Jekalyn", 0.0 },
  { "Jekari", 1.0 },
  { "Jekayla", 0.0 },
  { "Jekeria", 0.0 },
  { "Jekhari", 1.0 },
  { "Jekhi", 1.0 },
  { "Jekia", 0.0 },
  { "Jekiah", 0.0 },
  { "Jekobe", 1.0 },
  { "Jekori", 1.0 },
  { "Jela", 0.0 },
  { "Jelah", 0.0 },
  { "Jelaina", 0.0 },
  { "Jelaine", 0.0 },
  { "Jelan", 1.0 },
  { "Jelana", 0.0 },
  { "Jelani", 0.9015544 },
  { "Jelanie", 0.0 },
  { "Jelany", 0.0 },
  { "Jelaya", 0.0 },
  { "Jelayne", 0.0 },
  { "Jeleah", 0.0 },
  { "Jelecia", 0.0 },
  { "Jeleesa", 0.0 },
  { "Jelen", 1.0 },
  { "Jelena", 0.0 },
  { "Jelene", 0.0 },
  { "Jelesa", 0.0 },
  { "Jelesia", 0.0 },
  { "Jelessa", 0.0 },
  { "Jelia", 0.0 },
  { "Jeliah", 0.0 },
  { "Jeliana", 0.0 },
  { "Jelica", 0.0 },
  { "Jelicia", 0.0 },
  { "Jeliel", 1.0 },
  { "Jelina", 0.0 },
  { "Jelisa", 0.0 },
  { "Jelise", 0.0 },
  { "Jelisha", 0.0 },
  { "Jelisia", 0.0 },
  { "Jelissa", 0.0 },
  { "Jelitza", 0.0 },
  { "Jeliyah", 0.0 },
  { "Jellisa", 0.0 },
  { "Jelon", 1.0 },
  { "Jeloni", 1.0 },
  { "Jelsy", 0.0 },
  { "Jelyn", 0.0 },
  { "Jelynn", 0.0 },
  { "Jelysa", 0.0 },
  { "Jelyssa", 0.0 },
  { "Jem", 0.34285715 },
  { "Jema", 0.0 },
  { "Jemaine", 1.0 },
  { "Jemal", 1.0 },
  { "Jemale", 1.0 },
  { "Jemar", 1.0 },
  { "Jemarcus", 1.0 },
  { "Jemari", 1.0 },
  { "Jemario", 1.0 },
  { "Jemarion", 1.0 },
  { "Jemarius", 1.0 },
  { "Jemarr", 1.0 },
  { "Jemauri", 1.0 },
  { "Jemaya", 0.0 },
  { "Jemeka", 0.0 },
  { "Jemekia", 0.0 },
  { "Jemel", 1.0 },
  { "Jemelia", 0.0 },
  { "Jemell", 1.0 },
  { "Jemelle", 1.0 },
  { "Jemely", 0.0 },
  { "Jemere", 1.0 },
  { "Jemeria", 0.0 },
  { "Jemerrio", 1.0 },
  { "Jemery", 1.0 },
  { "Jemes", 1.0 },
  { "Jemi", 0.0 },
  { "Jemia", 0.0 },
  { "Jemiah", 0.33673468 },
  { "Jemica", 0.0 },
  { "Jemichael", 1.0 },
  { "Jemier", 1.0 },
  { "Jemika", 0.0 },
  { "Jemil", 1.0 },
  { "Jemila", 0.0 },
  { "Jemilla", 0.0 },
  { "Jemily", 0.0 },
  { "Jemima", 0.0 },
  { "Jemimah", 0.0 },
  { "Jemina", 0.0 },
  { "Jemini", 0.24637681 },
  { "Jemir", 1.0 },
  { "Jemira", 0.0 },
  { "Jemiya", 0.0 },
  { "Jemiyah", 0.0 },
  { "Jemma", 0.0 },
  { "Jemmah", 0.0 },
  { "Jemmerio", 1.0 },
  { "Jemmie", 0.5472637 },
  { "Jemmy", 0.0 },
  { "Jemon", 1.0 },
  { "Jemond", 1.0 },
  { "Jemuel", 1.0 },
  { "Jemya", 0.0 },
  { "Jemyah", 0.0 },
  { "Jen", 0.21234567 },
  { "Jena", 0.0005395822 },
  { "Jenabelle", 0.0 },
  { "Jenacia", 0.0 },
  { "Jenae", 0.0 },
  { "Jenafer", 0.0 },
  { "Jenah", 0.0 },
  { "Jenai", 0.0 },
  { "Jenaia", 0.0 },
  { "Jenaiah", 0.0 },
  { "Jenaiya", 0.0 },
  { "Jenaka", 0.0 },
  { "Jenal", 0.0 },
  { "Jenalea", 0.0 },
  { "Jenalee", 0.0 },
  { "Jenali", 0.0 },
  { "Jenalis", 0.0 },
  { "Jenalise", 0.0 },
  { "Jenaliz", 0.0 },
  { "Jenalyn", 0.0 },
  { "Jenalynn", 0.0 },
  { "Jenalys", 0.0 },
  { "Jenalyse", 0.0 },
  { "Jenan", 0.0 },
  { "Jenanne", 0.0 },
  { "Jenara", 0.0 },
  { "Jenard", 1.0 },
  { "Jenaro", 1.0 },
  { "Jenascia", 0.0 },
  { "Jenasia", 0.0 },
  { "Jenasis", 0.0 },
  { "Jenasys", 0.0 },
  { "Jenave", 0.0 },
  { "Jenavecia", 0.0 },
  { "Jenavee", 0.0 },
  { "Jenaveve", 0.0 },
  { "Jenavi", 0.0 },
  { "Jenavicia", 0.0 },
  { "Jenavie", 0.0 },
  { "Jenavieve", 0.0 },
  { "Jenavive", 0.0 },
  { "Jenavy", 0.0 },
  { "Jenay", 0.00524659 },
  { "Jenaya", 0.0 },
  { "Jenayah", 0.0 },
  { "Jenaye", 0.0 },
  { "Jencarlo", 1.0 },
  { "Jencarlos", 1.0 },
  { "Jenci", 0.0 },
  { "Jencie", 0.0 },
  { "Jency", 0.046296295 },
  { "Jencyn", 0.0 },
  { "Jendaya", 0.0 },
  { "Jendayi", 0.0 },
  { "Jendriel", 1.0 },
  { "Jendry", 1.0 },
  { "Jene", 0.2912534 },
  { "Jenea", 0.0 },
  { "Jeneal", 0.0 },
  { "Jenean", 0.0 },
  { "Jeneane", 0.0 },
  { "Jeneanne", 0.0 },
  { "Jeneba", 0.0 },
  { "Jeneca", 0.0 },
  { "Jenece", 0.0 },
  { "Jenecia", 0.0 },
  { "Jenedy", 0.0 },
  { "Jenee", 0.0 },
  { "Jeneen", 0.0 },
  { "Jeneene", 0.0 },
  { "Jenefer", 0.0 },
  { "Jeneffer", 0.0 },
  { "Jeneice", 0.0 },
  { "Jeneil", 0.0 },
  { "Jeneine", 0.0 },
  { "Jeneka", 0.0 },
  { "Jenel", 0.0 },
  { "Jenele", 0.0 },
  { "Jenelee", 0.0 },
  { "Jenell", 0.0 },
  { "Jenella", 0.0 },
  { "Jenelle", 0.0 },
  { "Jenelly", 0.0 },
  { "Jenely", 0.0 },
  { "Jenene", 0.0 },
  { "Jenera", 0.0 },
  { "Jenesa", 0.0 },
  { "Jenese", 0.0 },
  { "Jenesha", 0.0 },
  { "Jenesi", 0.0 },
  { "Jenesia", 0.0 },
  { "Jenesis", 0.011825573 },
  { "Jeness", 0.0 },
  { "Jenessa", 0.0 },
  { "Jenesse", 0.0 },
  { "Jenessia", 0.0 },
  { "Jenessis", 0.0 },
  { "Jenessy", 0.0 },
  { "Jenesy", 0.0 },
  { "Jenesys", 0.0 },
  { "Jenet", 0.0 },
  { "Jenett", 0.0 },
  { "Jenetta", 0.0 },
  { "Jenette", 0.0 },
  { "Jenettie", 0.0 },
  { "Jeneva", 0.0 },
  { "Jenevi", 0.0 },
  { "Jenevie", 0.0 },
  { "Jenevieve", 0.0 },
  { "Jenevive", 0.0 },
  { "Jenevy", 0.0 },
  { "Jeneya", 0.0 },
  { "Jeni", 0.0 },
  { "Jenia", 0.0 },
  { "Jeniah", 0.0 },
  { "Jenibelle", 0.0 },
  { "Jenica", 0.0 },
  { "Jenice", 0.0 },
  { "Jenicia", 0.0 },
  { "Jenicka", 0.0 },
  { "Jenie", 0.0 },
  { "Jeniece", 0.0 },
  { "Jeniel", 1.0 },
  { "Jenielle", 0.0 },
  { "Jeniene", 0.0 },
  { "Jenifer", 0.0008658009 },
  { "Jeniffer", 0.0 },
  { "Jenika", 0.0 },
  { "Jenil", 1.0 },
  { "Jenilca", 0.0 },
  { "Jenilee", 0.0 },
  { "Jenille", 0.0 },
  { "Jenilyn", 0.0 },
  { "Jenin", 0.0 },
  { "Jenina", 0.0 },
  { "Jenine", 0.0 },
  { "Jeninne", 0.0 },
  { "Jenipher", 0.0 },
  { "Jeniqua", 0.0 },
  { "Jenique", 0.0 },
  { "Jenis", 0.0 },
  { "Jenisa", 0.0 },
  { "Jenise", 0.0 },
  { "Jenish", 1.0 },
  { "Jenisha", 0.0 },
  { "Jenisis", 0.0 },
  { "Jenissa", 0.0 },
  { "Jenisse", 0.0 },
  { "Jenisys", 0.0 },
  { "Jenita", 0.0 },
  { "Jenith", 0.0 },
  { "Jenitha", 0.0 },
  { "Jenitza", 0.0 },
  { "Jeniva", 0.0 },
  { "Jenive", 0.0 },
  { "Jeniveve", 0.0 },
  { "Jenivieve", 0.0 },
  { "Jeniya", 0.0 },
  { "Jeniyah", 0.0 },
  { "Jenkarlo", 1.0 },
  { "Jenkins", 1.0 },
  { "Jenn", 0.0 },
  { "Jenna", 0.0017886225 },
  { "Jennabel", 0.0 },
  { "Jennabella", 0.0 },
  { "Jennabelle", 0.0 },
  { "Jennaca", 0.0 },
  { "Jennae", 0.0 },
  { "Jennafer", 0.0 },
  { "Jennah", 0.0 },
  { "Jennaka", 0.0 },
  { "Jennalea", 0.0 },
  { "Jennalee", 0.0 },
  { "Jennaleigh", 0.0 },
  { "Jennalise", 0.0 },
  { "Jennaliz", 0.0 },
  { "Jennalyn", 0.0 },
  { "Jennalynn", 0.0 },
  { "Jennalyse", 0.0 },
  { "Jennamarie", 0.0 },
  { "Jennarae", 0.0 },
  { "Jennarose", 0.0 },
  { "Jennasis", 0.0 },
  { "Jennavecia", 0.0 },
  { "Jennavee", 0.0 },
  { "Jennaveve", 0.0 },
  { "Jennavi", 0.0 },
  { "Jennavicia", 0.0 },
  { "Jennavie", 0.0 },
  { "Jennavieve", 0.0 },
  { "Jennavive", 0.0 },
  { "Jennay", 0.0 },
  { "Jennaya", 0.0 },
  { "Jenne", 0.0 },
  { "Jennea", 0.0 },
  { "Jennean", 0.0 },
  { "Jennedy", 0.0 },
  { "Jennee", 0.0 },
  { "Jennefer", 0.0 },
  { "Jenneffer", 0.0 },
  { "Jenneh", 0.0 },
  { "Jenneifer", 0.0 },
  { "Jennel", 0.0 },
  { "Jennell", 0.0 },
  { "Jennelle", 0.0 },
  { "Jennely", 0.0 },
  { "Jennelyn", 0.0 },
  { "Jennene", 0.0 },
  { "Jenner", 0.9698795 },
  { "Jennesa", 0.0 },
  { "Jennesis", 0.0 },
  { "Jenness", 0.0 },
  { "Jennessa", 0.0 },
  { "Jennessy", 0.0 },
  { "Jennesy", 0.0 },
  { "Jennet", 0.0 },
  { "Jenneth", 0.0 },
  { "Jennett", 0.0 },
  { "Jennetta", 0.0 },
  { "Jennette", 0.0 },
  { "Jennevie", 0.0 },
  { "Jennevieve", 0.0 },
  { "Jennevy", 0.0 },
  { "Jenney", 0.0 },
  { "Jennfer", 0.0 },
  { "Jennfier", 0.0 },
  { "Jenni", 0.0 },
  { "Jennia", 0.0 },
  { "Jenniah", 0.0 },
  { "Jennica", 0.0 },
  { "Jennice", 0.0 },
  { "Jennicka", 0.0 },
  { "Jennie", 0.0037708222 },
  { "Jenniefer", 0.0 },
  { "Jennieke", 0.0 },
  { "Jennielee", 0.0 },
  { "Jennier", 0.0 },
  { "Jennieve", 0.0 },
  { "Jennife", 0.0 },
  { "Jennifer", 0.0032909752 },
  { "Jenniferann", 0.0 },
  { "Jenniferanne", 0.0 },
  { "Jennifere", 0.0 },
  { "Jenniferlee", 0.0 },
  { "Jenniferlynn", 0.0 },
  { "Jennifermarie", 0.0 },
  { "Jenniferr", 0.0 },
  { "Jenniferrose", 0.0 },
  { "Jenniffer", 0.0 },
  { "Jennifier", 0.0 },
  { "Jennifr", 0.0 },
  { "Jenniger", 0.0 },
  { "Jennika", 0.0 },
  { "Jennilee", 0.0 },
  { "Jennille", 0.0 },
  { "Jennilyn", 0.0 },
  { "Jennilynn", 0.0 },
  { "Jennine", 0.0 },
  { "Jenning", 1.0 },
  { "Jennings", 0.97045827 },
  { "Jenniper", 0.0 },
  { "Jennipher", 0.0 },
  { "Jennis", 0.59183675 },
  { "Jennisa", 0.0 },
  { "Jennise", 0.0 },
  { "Jenniver", 0.0 },
  { "Jenniya", 0.0 },
  { "Jenniyah", 0.0 },
  { "Jennnifer", 0.0 },
  { "Jenny", 0.0066433144 },
  { "Jennya", 0.0 },
  { "Jennye", 0.0 },
  { "Jennyfer", 0.0 },
  { "Jennylee", 0.0 },
  { "Jennylyn", 0.0 },
  { "Jennylynn", 0.0 },
  { "Jeno", 1.0 },
  { "Jenoah", 1.0 },
  { "Jenohn", 0.0 },
  { "Jenola", 0.0 },
  { "Jenora", 0.0 },
  { "Jenova", 0.0 },
  { "Jenri", 1.0 },
  { "Jenrri", 1.0 },
  { "Jenrry", 1.0 },
  { "Jenry", 1.0 },
  { "Jens", 1.0 },
  { "Jensen", 0.75850165 },
  { "Jensie", 0.0 },
  { "Jensiel", 1.0 },
  { "Jensin", 1.0 },
  { "Jensine", 0.0 },
  { "Jenson", 0.9815195 },
  { "Jenssy", 1.0 },
  { "Jensy", 0.6020408 },
  { "Jensyn", 0.16820702 },
  { "Jentezen", 1.0 },
  { "Jentri", 0.0 },
  { "Jentrie", 0.0 },
  { "Jentry", 0.2808425 },
  { "Jentzen", 1.0 },
  { "Jenuel", 1.0 },
  { "Jeny", 0.0 },
  { "Jenya", 0.0 },
  { "Jenyah", 0.0 },
  { "Jenyce", 0.0 },
  { "Jenyfer", 0.0 },
  { "Jenyiah", 0.0 },
  { "Jenyka", 0.0 },
  { "Jenyla", 0.0 },
  { "Jenysis", 0.0 },
  { "Jenyssa", 0.0 },
  { "Jenzel", 1.0 },
  { "Jenzen", 1.0 },
  { "Jenziel", 1.0 },
  { "Jeoffrey", 1.0 },
  { "Jeon", 1.0 },
  { "Jeong", 1.0 },
  { "Jeopardy", 0.0 },
  { "Jeorge", 1.0 },
  { "Jeorgia", 0.0 },
  { "Jeorgina", 0.0 },
  { "Jeovan", 1.0 },
  { "Jeovana", 0.0 },
  { "Jeovani", 1.0 },
  { "Jeovanna", 0.0 },
  { "Jeovanni", 1.0 },
  { "Jeovanny", 1.0 },
  { "Jeovany", 1.0 },
  { "Jep", 1.0 },
  { "Jephte", 1.0 },
  { "Jephthah", 1.0 },
  { "Jephthe", 1.0 },
  { "Jeppie", 1.0 },
  { "Jepson", 1.0 },
  { "Jeptha", 1.0 },
  { "Jequan", 1.0 },
  { "Jequarius", 1.0 },
  { "Jequetta", 0.0 },
  { "Jequita", 0.0 },
  { "Jer", 0.45454547 },
  { "Jera", 0.0 },
  { "Jerad", 1.0 },
  { "Jerade", 1.0 },
  { "Jerae", 0.08955224 },
  { "Jerah", 0.0 },
  { "Jerahmy", 1.0 },
  { "Jerail", 1.0 },
  { "Jeral", 0.9767981 },
  { "Jerald", 0.9960789 },
  { "Jeraldean", 0.0 },
  { "Jeraldene", 0.0 },
  { "Jeraldi", 0.0 },
  { "Jeraldin", 0.0 },
  { "Jeraldine", 0.0 },
  { "Jeraldo", 1.0 },
  { "Jeraldy", 0.0 },
  { "Jeraldyn", 0.0 },
  { "Jeralee", 0.0 },
  { "Jeralene", 0.0 },
  { "Jeraline", 0.0 },
  { "Jeralyn", 0.0 },
  { "Jeralynn", 0.0 },
  { "Jeramaine", 1.0 },
  { "Jerame", 1.0 },
  { "Jeramee", 1.0 },
  { "Jeramey", 1.0 },
  { "Jerami", 0.984252 },
  { "Jeramia", 1.0 },
  { "Jeramiah", 1.0 },
  { "Jeramie", 0.9879163 },
  { "Jeramih", 1.0 },
  { "Jeramiha", 1.0 },
  { "Jeramine", 1.0 },
  { "Jeramiyah", 1.0 },
  { "Jeramy", 0.99887717 },
  { "Jeramya", 1.0 },
  { "Jeramyah", 1.0 },
  { "Jeran", 0.9838384 },
  { "Jerane", 0.0 },
  { "Jerard", 1.0 },
  { "Jerardo", 1.0 },
  { "Jerauld", 1.0 },
  { "Jeray", 1.0 },
  { "Jerdean", 0.0 },
  { "Jerdine", 0.0 },
  { "Jere", 0.78643817 },
  { "Jereal", 1.0 },
  { "Jereck", 1.0 },
  { "Jered", 1.0 },
  { "Jerediah", 1.0 },
  { "Jeree", 0.024154589 },
  { "Jereimah", 1.0 },
  { "Jerek", 1.0 },
  { "Jerel", 0.99858034 },
  { "Jereld", 1.0 },
  { "Jereldine", 0.0 },
  { "Jerelean", 0.0 },
  { "Jerelene", 0.0 },
  { "Jerelin", 0.0 },
  { "Jereline", 0.0 },
  { "Jerell", 0.99689054 },
  { "Jerelle", 0.9396985 },
  { "Jerelly", 0.0 },
  { "Jerely", 0.0 },
  { "Jerelyn", 0.0 },
  { "Jerem", 1.0 },
  { "Jeremah", 1.0 },
  { "Jeremai", 1.0 },
  { "Jeremaiah", 1.0 },
  { "Jeremaih", 1.0 },
  { "Jeremaine", 1.0 },
  { "Jereme", 1.0 },
  { "Jeremee", 1.0 },
  { "Jeremery", 1.0 },
  { "Jeremey", 1.0 },
  { "Jeremi", 0.9719567 },
  { "Jeremia", 0.98435056 },
  { "Jeremiah", 0.9965228 },
  { "Jeremiaha", 1.0 },
  { "Jeremiahs", 1.0 },
  { "Jeremial", 1.0 },
  { "Jeremian", 1.0 },
  { "Jeremias", 1.0 },
  { "Jeremie", 0.98333335 },
  { "Jeremih", 1.0 },
  { "Jeremiha", 1.0 },
  { "Jeremiya", 1.0 },
  { "Jeremiyah", 1.0 },
  { "Jeremmy", 1.0 },
  { "Jeremy", 0.99470204 },
  { "Jeremya", 0.7307692 },
  { "Jeremyah", 1.0 },
  { "Jeremyh", 1.0 },
  { "Jeremyiah", 1.0 },
  { "Jeren", 1.0 },
  { "Jerena", 0.0 },
  { "Jerene", 0.0 },
  { "Jereny", 1.0 },
  { "Jereomy", 1.0 },
  { "Jeresa", 0.0 },
  { "Jeresiah", 1.0 },
  { "Jeret", 1.0 },
  { "Jereth", 1.0 },
  { "Jerett", 1.0 },
  { "Jeretta", 0.0 },
  { "Jerey", 1.0 },
  { "Jerez", 1.0 },
  { "Jerhonda", 0.0 },
  { "Jeri", 0.016459288 },
  { "Jeria", 0.0 },
  { "Jeriah", 0.7974203 },
  { "Jerian", 1.0 },
  { "Jeriana", 0.0 },
  { "Jeriann", 0.0 },
  { "Jerianna", 0.0 },
  { "Jerianne", 0.0 },
  { "Jeric", 1.0 },
  { "Jerica", 0.0 },
  { "Jericah", 0.0 },
  { "Jericca", 0.0 },
  { "Jericha", 0.0 },
  { "Jericho", 0.938564 },
  { "Jericia", 0.0 },
  { "Jerick", 1.0 },
  { "Jericka", 0.0 },
  { "Jericko", 1.0 },
  { "Jerico", 0.9898089 },
  { "Jerid", 1.0 },
  { "Jerie", 0.0 },
  { "Jeriel", 1.0 },
  { "Jeries", 1.0 },
  { "Jeriesha", 0.0 },
  { "Jerik", 1.0 },
  { "Jerika", 0.0 },
  { "Jerikah", 0.0 },
  { "Jerikka", 0.0 },
  { "Jeriko", 1.0 },
  { "Jerilee", 0.0 },
  { "Jerilene", 0.0 },
  { "Jerilou", 0.0 },
  { "Jerilyn", 0.0 },
  { "Jerilynn", 0.0 },
  { "Jerilynne", 0.0 },
  { "Jerimah", 1.0 },
  { "Jerimaine", 1.0 },
  { "Jerime", 1.0 },
  { "Jerimee", 1.0 },
  { "Jerimey", 1.0 },
  { "Jerimi", 1.0 },
  { "Jerimia", 1.0 },
  { "Jerimiah", 1.0 },
  { "Jerimie", 1.0 },
  { "Jerimih", 1.0 },
  { "Jerimiha", 1.0 },
  { "Jerimiyah", 1.0 },
  { "Jerimy", 1.0 },
  { "Jerimya", 1.0 },
  { "Jerimyah", 1.0 },
  { "Jerin", 0.9083192 },
  { "Jerina", 0.0 },
  { "Jerine", 0.0 },
  { "Jeriod", 1.0 },
  { "Jerion", 1.0 },
  { "Jerious", 1.0 },
  { "Jeris", 0.59861594 },
  { "Jerisha", 0.0 },
  { "Jerison", 1.0 },
  { "Jerissa", 0.0 },
  { "Jerit", 1.0 },
  { "Jerita", 0.0 },
  { "Jerith", 1.0 },
  { "Jerius", 1.0 },
  { "Jeriyah", 0.0 },
  { "Jerjuan", 1.0 },
  { "Jerkayla", 0.0 },
  { "Jerkiya", 0.0 },
  { "Jerl", 1.0 },
  { "Jerldean", 0.0 },
  { "Jerldine", 0.0 },
  { "Jerlean", 0.0 },
  { "Jerleen", 0.0 },
  { "Jerlene", 0.0 },
  { "Jerlin", 0.0 },
  { "Jerline", 0.0 },
  { "Jerlisa", 0.0 },
  { "Jerlisha", 0.0 },
  { "Jerlyn", 0.0 },
  { "Jermail", 1.0 },
  { "Jermain", 1.0 },
  { "Jermaine", 0.97660524 },
  { "Jermal", 1.0 },
  { "Jermale", 1.0 },
  { "Jermall", 1.0 },
  { "Jerman", 1.0 },
  { "Jermane", 1.0 },
  { "Jermanee", 0.0 },
  { "Jermani", 0.18526785 },
  { "Jermanie", 0.8828125 },
  { "Jermanii", 0.0 },
  { "Jermanine", 1.0 },
  { "Jermany", 0.46606335 },
  { "Jermar", 1.0 },
  { "Jermarcus", 1.0 },
  { "Jermari", 1.0 },
  { "Jermaria", 0.0 },
  { "Jermario", 1.0 },
  { "Jermarion", 1.0 },
  { "Jermarius", 1.0 },
  { "Jermarkus", 1.0 },
  { "Jermaul", 1.0 },
  { "Jermaya", 0.0 },
  { "Jermayne", 1.0 },
  { "Jerme", 1.0 },
  { "Jermecia", 0.0 },
  { "Jermeisha", 0.0 },
  { "Jermeka", 0.0 },
  { "Jermel", 0.996136 },
  { "Jermell", 1.0 },
  { "Jermelle", 1.0 },
  { "Jermere", 1.0 },
  { "Jermeria", 0.0 },
  { "Jermery", 1.0 },
  { "Jermesha", 0.0 },
  { "Jermeshia", 0.0 },
  { "Jermey", 1.0 },
  { "Jermia", 0.0 },
  { "Jermiah", 0.9596514 },
  { "Jermiane", 1.0 },
  { "Jermica", 0.0 },
  { "Jermichael", 1.0 },
  { "Jermicheal", 1.0 },
  { "Jermie", 1.0 },
  { "Jermih", 1.0 },
  { "Jermika", 0.0 },
  { "Jermil", 1.0 },
  { "Jermine", 1.0 },
  { "Jermir", 1.0 },
  { "Jermira", 0.0 },
  { "Jermisha", 0.0 },
  { "Jermiya", 0.0 },
  { "Jermiyah", 0.09550562 },
  { "Jermol", 1.0 },
  { "Jermon", 1.0 },
  { "Jermond", 1.0 },
  { "Jermone", 1.0 },
  { "Jermonica", 0.0 },
  { "Jermont", 1.0 },
  { "Jermonte", 1.0 },
  { "Jermy", 1.0 },
  { "Jermya", 0.0 },
  { "Jermyah", 0.5135135 },
  { "Jermyia", 0.0 },
  { "Jermyn", 1.0 },
  { "Jermyra", 0.0 },
  { "Jernae", 0.0 },
  { "Jernard", 1.0 },
  { "Jernee", 0.0 },
  { "Jernei", 0.0 },
  { "Jernell", 0.18518518 },
  { "Jerneshia", 0.0 },
  { "Jerney", 0.071428575 },
  { "Jerni", 0.0 },
  { "Jerniah", 0.0 },
  { "Jernice", 0.0 },
  { "Jernie", 0.0 },
  { "Jernika", 0.0 },
  { "Jernisha", 0.0 },
  { "Jerniya", 0.0 },
  { "Jerniyah", 0.0 },
  { "Jernya", 0.0 },
  { "Jerod", 1.0 },
  { "Jerode", 1.0 },
  { "Jeroen", 1.0 },
  { "Jerol", 0.9305556 },
  { "Jerold", 1.0 },
  { "Jeroldine", 0.0 },
  { "Jerolene", 0.0 },
  { "Jeroline", 0.0 },
  { "Jerolyn", 0.0 },
  { "Jerom", 1.0 },
  { "Jeroma", 0.0 },
  { "Jerome", 0.9933878 },
  { "Jeromee", 1.0 },
  { "Jeromey", 1.0 },
  { "Jeromi", 1.0 },
  { "Jeromiah", 1.0 },
  { "Jeromie", 1.0 },
  { "Jeromy", 1.0 },
  { "Jeron", 1.0 },
  { "Jerona", 0.0 },
  { "Jeronda", 0.0 },
  { "Jerone", 1.0 },
  { "Jeronica", 0.0 },
  { "Jeronimo", 1.0 },
  { "Jerquan", 1.0 },
  { "Jerra", 0.0 },
  { "Jerrad", 1.0 },
  { "Jerrae", 0.0 },
  { "Jerrah", 0.0 },
  { "Jerrail", 1.0 },
  { "Jerral", 1.0 },
  { "Jerrald", 1.0 },
  { "Jerralee", 0.0 },
  { "Jerrall", 1.0 },
  { "Jerralyn", 0.0 },
  { "Jerrame", 1.0 },
  { "Jerramie", 1.0 },
  { "Jerramy", 1.0 },
  { "Jerran", 1.0 },
  { "Jerrard", 1.0 },
  { "Jerray", 1.0 },
  { "Jerre", 0.56303114 },
  { "Jerred", 1.0 },
  { "Jerrel", 0.98934865 },
  { "Jerrell", 0.9870592 },
  { "Jerrelle", 1.0 },
  { "Jerremiah", 1.0 },
  { "Jerremy", 1.0 },
  { "Jerren", 1.0 },
  { "Jerrene", 0.0 },
  { "Jerret", 1.0 },
  { "Jerrett", 1.0 },
  { "Jerri", 0.017774098 },
  { "Jerria", 0.0 },
  { "Jerriah", 0.0 },
  { "Jerrian", 1.0 },
  { "Jerriana", 0.0 },
  { "Jerriann", 0.0 },
  { "Jerrianna", 0.0 },
  { "Jerrianne", 0.0 },
  { "Jerric", 1.0 },
  { "Jerrica", 0.0 },
  { "Jerricca", 0.0 },
  { "Jerricha", 0.0 },
  { "Jerricho", 1.0 },
  { "Jerrick", 1.0 },
  { "Jerricka", 0.0 },
  { "Jerrico", 1.0 },
  { "Jerrid", 1.0 },
  { "Jerrie", 0.061651178 },
  { "Jerriel", 1.0 },
  { "Jerrik", 1.0 },
  { "Jerrika", 0.0 },
  { "Jerril", 1.0 },
  { "Jerrilee", 0.0 },
  { "Jerrill", 1.0 },
  { "Jerrilyn", 0.0 },
  { "Jerrilyne", 0.0 },
  { "Jerrilynn", 0.0 },
  { "Jerrime", 1.0 },
  { "Jerrimiah", 1.0 },
  { "Jerrimy", 1.0 },
  { "Jerrin", 0.96767676 },
  { "Jerrina", 0.0 },
  { "Jerrine", 0.0 },
  { "Jerrion", 1.0 },
  { "Jerriona", 0.0 },
  { "Jerrious", 1.0 },
  { "Jerris", 0.58 },
  { "Jerrisa", 0.0 },
  { "Jerrisha", 0.0 },
  { "Jerrison", 1.0 },
  { "Jerrit", 1.0 },
  { "Jerrita", 0.0 },
  { "Jerritt", 1.0 },
  { "Jerrius", 1.0 },
  { "Jerriyah", 0.0 },
  { "Jerrlyn", 0.0 },
  { "Jerrod", 0.9989139 },
  { "Jerrol", 1.0 },
  { "Jerrold", 1.0 },
  { "Jerroll", 1.0 },
  { "Jerrolyn", 0.0 },
  { "Jerrome", 1.0 },
  { "Jerron", 1.0 },
  { "Jerrud", 1.0 },
  { "Jerry", 0.97248685 },
  { "Jerryca", 0.0 },
  { "Jerryd", 1.0 },
  { "Jerrye", 0.0 },
  { "Jerryl", 0.9607843 },
  { "Jerrylee", 1.0 },
  { "Jerrylene", 0.0 },
  { "Jerryn", 1.0 },
  { "Jersain", 1.0 },
  { "Jersee", 0.0 },
  { "Jersei", 0.0 },
  { "Jersen", 1.0 },
  { "Jersey", 0.07765668 },
  { "Jersi", 0.0 },
  { "Jersiah", 1.0 },
  { "Jersie", 0.0 },
  { "Jerson", 1.0 },
  { "Jersy", 0.0 },
  { "Jertavious", 1.0 },
  { "Jeru", 1.0 },
  { "Jerud", 1.0 },
  { "Jerusalem", 0.2166065 },
  { "Jerusalen", 0.0 },
  { "Jerusha", 0.0 },
  { "Jervaughn", 1.0 },
  { "Jervin", 1.0 },
  { "Jervis", 1.0 },
  { "Jervon", 1.0 },
  { "Jervontae", 1.0 },
  { "Jervonte", 1.0 },
  { "Jerwan", 1.0 },
  { "Jerwin", 1.0 },
  { "Jery", 1.0 },
  { "Jeryd", 1.0 },
  { "Jeryiah", 0.0 },
  { "Jeryka", 0.0 },
  { "Jerykah", 0.0 },
  { "Jeryl", 0.43054786 },
  { "Jeryme", 1.0 },
  { "Jerymiah", 1.0 },
  { "Jeryn", 0.6822917 },
  { "Jerzee", 0.0 },
  { "Jerzei", 0.0 },
  { "Jerzey", 0.029940119 },
  { "Jerzi", 0.0 },
  { "Jerzie", 0.0 },
  { "Jerzy", 0.48387095 },
  { "Jes", 1.0 },
  { "Jesa", 0.0 },
  { "Jesabel", 0.0 },
  { "Jesai", 1.0 },
  { "Jesaiah", 1.0 },
  { "Jesaias", 1.0 },
  { "Jesalee", 0.0 },
  { "Jesalyn", 0.0 },
  { "Jesalynn", 0.0 },
  { "Jesara", 0.0 },
  { "Jescenia", 0.0 },
  { "Jescie", 0.0 },
  { "Jesco", 1.0 },
  { "Jese", 1.0 },
  { "Jesean", 1.0 },
  { "Jeseca", 0.0 },
  { "Jesee", 0.8863636 },
  { "Jeseka", 0.0 },
  { "Jesel", 0.0 },
  { "Jeselle", 0.0 },
  { "Jeselyn", 0.0 },
  { "Jesenia", 0.0013057671 },
  { "Jesenya", 0.0 },
  { "Jeser", 1.0 },
  { "Jesha", 0.0 },
  { "Jeshaiah", 1.0 },
  { "Jeshaun", 1.0 },
  { "Jeshawn", 1.0 },
  { "Jeshia", 0.0 },
  { "Jeshon", 1.0 },
  { "Jeshua", 0.99774873 },
  { "Jeshuah", 1.0 },
  { "Jeshurun", 1.0 },
  { "Jeshwa", 1.0 },
  { "Jesi", 0.06495727 },
  { "Jesiah", 0.91190666 },
  { "Jesica", 0.0 },
  { "Jesicah", 0.0 },
  { "Jesicca", 0.0 },
  { "Jesie", 0.40625 },
  { "Jesiel", 1.0 },
  { "Jesika", 0.0 },
  { "Jesikah", 0.0 },
  { "Jesilyn", 0.0 },
  { "Jesiree", 0.0 },
  { "Jesiyah", 1.0 },
  { "Jeslee", 0.0 },
  { "Jesleen", 0.0 },
  { "Jeslene", 0.0 },
  { "Jesley", 0.0 },
  { "Jesli", 0.0 },
  { "Jeslie", 0.0 },
  { "Jeslin", 0.0 },
  { "Jesly", 0.0 },
  { "Jeslyn", 0.0 },
  { "Jeslynn", 0.0 },
  { "Jesmarie", 0.0 },
  { "Jesmin", 0.0 },
  { "Jesmine", 0.0 },
  { "Jeson", 1.0 },
  { "Jesper", 1.0 },
  { "Jess", 0.9830314 },
  { "Jessa", 0.0010072523 },
  { "Jessabel", 0.0 },
  { "Jessabell", 0.0 },
  { "Jessabella", 0.0 },
  { "Jessabelle", 0.0 },
  { "Jessaca", 0.0 },
  { "Jessah", 0.0 },
  { "Jessalee", 0.0 },
  { "Jessalin", 0.0 },
  { "Jessalyn", 0.0 },
  { "Jessalynn", 0.0 },
  { "Jessalynne", 0.0 },
  { "Jessamae", 0.0 },
  { "Jessamarie", 0.0 },
  { "Jessamine", 0.0 },
  { "Jessamy", 0.0 },
  { "Jessamyn", 0.007002801 },
  { "Jessca", 0.0 },
  { "Jesscia", 0.0 },
  { "Jesse", 0.9721773 },
  { "Jesseca", 0.0 },
  { "Jessee", 0.8418848 },
  { "Jesseica", 0.0 },
  { "Jessejames", 1.0 },
  { "Jesseka", 0.0 },
  { "Jessel", 0.05586592 },
  { "Jesselee", 1.0 },
  { "Jesselin", 0.0 },
  { "Jessell", 0.0 },
  { "Jesselle", 0.0 },
  { "Jessely", 0.0 },
  { "Jesselyn", 0.0 },
  { "Jesselynn", 0.0 },
  { "Jessen", 1.0 },
  { "Jessena", 0.0 },
  { "Jessenia", 0.0 },
  { "Jessenya", 0.0 },
  { "Jesseray", 1.0 },
  { "Jesses", 1.0 },
  { "Jessey", 0.76349616 },
  { "Jessi", 0.17531404 },
  { "Jessia", 0.0 },
  { "Jessiah", 0.8348559 },
  { "Jessiana", 0.0 },
  { "Jessianna", 0.0 },
  { "Jessianne", 0.0 },
  { "Jessic", 0.0 },
  { "Jessica", 0.0034148172 },
  { "Jessicaann", 0.0 },
  { "Jessicaanne", 0.0 },
  { "Jessicah", 0.0 },
  { "Jessical", 0.0 },
  { "Jessicalee", 0.0 },
  { "Jessicalynn", 0.0 },
  { "Jessicamae", 0.0 },
  { "Jessicamarie", 0.0 },
  { "Jessican", 0.0 },
  { "Jessicanicole", 0.0 },
  { "Jessicarose", 0.0 },
  { "Jessicca", 0.0 },
  { "Jessice", 0.0 },
  { "Jessicia", 0.0 },
  { "Jessicka", 0.0 },
  { "Jessico", 0.0 },
  { "Jessie", 0.39734405 },
  { "Jessieca", 0.0 },
  { "Jessiejames", 1.0 },
  { "Jessiel", 1.0 },
  { "Jessielynn", 0.0 },
  { "Jessiemae", 0.0 },
  { "Jessika", 0.0 },
  { "Jessikah", 0.0 },
  { "Jessilyn", 0.0 },
  { "Jessilynn", 0.0 },
  { "Jessimae", 0.0 },
  { "Jessimar", 0.0 },
  { "Jessina", 0.0 },
  { "Jessinia", 0.0 },
  { "Jessiqua", 0.0 },
  { "Jessiyah", 0.0 },
  { "Jesska", 0.0 },
  { "Jesslene", 0.0 },
  { "Jesslin", 0.0 },
  { "Jessly", 0.0 },
  { "Jesslyn", 0.0 },
  { "Jesslynn", 0.0 },
  { "Jessmarie", 0.0 },
  { "Jesson", 1.0 },
  { "Jesssica", 0.0 },
  { "Jessten", 1.0 },
  { "Jesstin", 1.0 },
  { "Jesstina", 0.0 },
  { "Jesstine", 0.0 },
  { "Jesston", 1.0 },
  { "Jessuly", 0.0 },
  { "Jessup", 1.0 },
  { "Jessus", 1.0 },
  { "Jessy", 0.71472 },
  { "Jessyca", 0.0 },
  { "Jessye", 0.0 },
  { "Jessyka", 0.0 },
  { "Jesteen", 0.0 },
  { "Jesten", 1.0 },
  { "Jestene", 0.0 },
  { "Jester", 1.0 },
  { "Jestin", 1.0 },
  { "Jestina", 0.0 },
  { "Jestine", 0.0 },
  { "Jestiny", 0.0 },
  { "Jeston", 1.0 },
  { "Jestyn", 1.0 },
  { "Jesu", 1.0 },
  { "Jesua", 1.0 },
  { "Jesualdo", 1.0 },
  { "Jesuan", 1.0 },
  { "Jesucita", 0.0 },
  { "Jesue", 1.0 },
  { "Jesus", 0.98826706 },
  { "Jesusa", 0.0 },
  { "Jesusalberto", 1.0 },
  { "Jesusangel", 1.0 },
  { "Jesusantonio", 1.0 },
  { "Jesusdaniel", 1.0 },
  { "Jesusenrique", 1.0 },
  { "Jesusita", 0.0 },
  { "Jesusjr", 1.0 },
  { "Jesusmanuel", 1.0 },
  { "Jesy", 0.6666667 },
  { "Jesyca", 0.0 },
  { "Jesyka", 0.0 },
  { "Jet", 0.9700338 },
  { "Jetaime", 0.0 },
  { "Jetaun", 0.0 },
  { "Jete", 0.0 },
  { "Jeter", 1.0 },
  { "Jeth", 1.0 },
  { "Jethero", 1.0 },
  { "Jethro", 1.0 },
  { "Jethroe", 1.0 },
  { "Jetli", 1.0 },
  { "Jetlyn", 0.0 },
  { "Jetmir", 1.0 },
  { "Jetoi", 0.0 },
  { "Jeton", 1.0 },
  { "Jetsen", 1.0 },
  { "Jetson", 1.0 },
  { "Jett", 0.9717242 },
  { "Jetta", 0.0 },
  { "Jette", 0.0625 },
  { "Jettie", 0.050526317 },
  { "Jetton", 1.0 },
  { "Jettrin", 1.0 },
  { "Jettsen", 1.0 },
  { "Jettson", 1.0 },
  { "Jetty", 0.023622047 },
  { "Jettye", 0.0 },
  { "Jetzabel", 0.0 },
  { "Jetzael", 1.0 },
  { "Jetzibe", 0.0 },
  { "Jetziel", 1.0 },
  { "Jeudy", 1.0 },
  { "Jeune", 0.0 },
  { "Jeury", 1.0 },
  { "Jevaeh", 0.0 },
  { "Jevan", 1.0 },
  { "Jevante", 1.0 },
  { "Jevaughn", 1.0 },
  { "Jevaun", 1.0 },
  { "Jeveah", 0.0 },
  { "Jeven", 1.0 },
  { "Jeveon", 1.0 },
  { "Jevette", 0.0 },
  { "Jevin", 1.0 },
  { "Jevion", 1.0 },
  { "Jevita", 0.0 },
  { "Jevon", 0.98083806 },
  { "Jevonda", 0.0 },
  { "Jevone", 1.0 },
  { "Jevonn", 1.0 },
  { "Jevonna", 0.0 },
  { "Jevonne", 0.0 },
  { "Jevonta", 1.0 },
  { "Jevontae", 1.0 },
  { "Jevontay", 1.0 },
  { "Jevonte", 1.0 },
  { "Jevyn", 1.0 },
  { "Jewan", 1.0 },
  { "Jewel", 0.11559188 },
  { "Jeweldean", 0.0 },
  { "Jeweldene", 0.0 },
  { "Jeweldine", 0.0 },
  { "Jeweleah", 0.0 },
  { "Jewelean", 0.0 },
  { "Jewelee", 0.0 },
  { "Jewelene", 0.0 },
  { "Jewelia", 0.0 },
  { "Jewelian", 0.41666666 },
  { "Jeweliana", 0.0 },
  { "Jewelianna", 0.0 },
  { "Jewelie", 0.0 },
  { "Jeweliet", 0.0 },
  { "Jeweline", 0.0 },
  { "Jewelisa", 0.0 },
  { "Jewelissa", 0.0 },
  { "Jewell", 0.13669108 },
  { "Jewelle", 0.0 },
  { "Jewellee", 0.0 },
  { "Jewellene", 0.0 },
  { "Jewellia", 0.0 },
  { "Jewels", 0.008859358 },
  { "Jewely", 0.0 },
  { "Jewelya", 0.0 },
  { "Jewelyn", 0.0 },
  { "Jewelyssa", 0.0 },
  { "Jewelz", 0.18076923 },
  { "Jewett", 1.0 },
  { "Jewl", 0.0 },
  { "Jewlia", 0.0 },
  { "Jewlian", 1.0 },
  { "Jewliana", 0.0 },
  { "Jewlius", 1.0 },
  { "Jewlz", 0.0 },
  { "Jex", 1.0 },
  { "Jexiel", 1.0 },
  { "Jexton", 1.0 },
  { "Jey", 1.0 },
  { "Jeyceon", 1.0 },
  { "Jeycob", 1.0 },
  { "Jeyda", 0.0 },
  { "Jeydan", 1.0 },
  { "Jeyden", 1.0 },
  { "Jeydi", 0.0 },
  { "Jeydon", 1.0 },
  { "Jeydy", 0.0 },
  { "Jeyko", 1.0 },
  { "Jeyla", 0.0 },
  { "Jeylah", 0.0 },
  { "Jeylan", 0.78571427 },
  { "Jeylani", 0.54545456 },
  { "Jeylanie", 0.0 },
  { "Jeyleen", 0.0 },
  { "Jeylen", 0.29411766 },
  { "Jeylene", 0.0 },
  { "Jeyli", 0.0 },
  { "Jeylianis", 0.0 },
  { "Jeylin", 0.0 },
  { "Jeyline", 0.0 },
  { "Jeylon", 1.0 },
  { "Jeyly", 0.0 },
  { "Jeymi", 0.0 },
  { "Jeyren", 1.0 },
  { "Jeysen", 1.0 },
  { "Jeyshangelise", 0.0 },
  { "Jeyson", 1.0 },
  { "Jezabel", 0.0 },
  { "Jezabell", 0.0 },
  { "Jezabella", 0.0 },
  { "Jezabelle", 0.0 },
  { "Jezebel", 0.0 },
  { "Jezebell", 0.0 },
  { "Jezebelle", 0.0 },
  { "Jezel", 0.0 },
  { "Jezell", 0.0 },
  { "Jezelle", 0.0 },
  { "Jezenia", 0.0 },
  { "Jezeniah", 0.0 },
  { "Jezer", 1.0 },
  { "Jeziah", 0.93351066 },
  { "Jeziel", 1.0 },
  { "Jezika", 0.0 },
  { "Jeziyah", 0.0 },
  { "Jezlin", 0.0 },
  { "Jezlyn", 0.0 },
  { "Jezlynn", 0.0 },
  { "Jezrael", 1.0 },
  { "Jezreel", 0.7628866 },
  { "Jezzel", 0.0 },
  { "Jezzelle", 0.0 },
  { "Jguadalupe", 1.0 },
  { "Jhace", 1.0 },
  { "Jhada", 0.0 },
  { "Jhade", 0.0 },
  { "Jhaden", 1.0 },
  { "Jhadiel", 1.0 },
  { "Jhaeda", 0.0 },
  { "Jhael", 1.0 },
  { "Jhai", 0.76744187 },
  { "Jhaiden", 1.0 },
  { "Jhair", 1.0 },
  { "Jhaki", 1.0 },
  { "Jhala", 0.0 },
  { "Jhalen", 1.0 },
  { "Jhalia", 0.0 },
  { "Jhalil", 1.0 },
  { "Jhalin", 1.0 },
  { "Jhalyn", 1.0 },
  { "Jhamal", 1.0 },
  { "Jhamar", 1.0 },
  { "Jhamari", 1.0 },
  { "Jhamarion", 1.0 },
  { "Jhamel", 1.0 },
  { "Jhamere", 1.0 },
  { "Jhamilet", 0.0 },
  { "Jhamir", 1.0 },
  { "Jhamya", 0.0 },
  { "Jhan", 0.9700599 },
  { "Jhana", 0.0 },
  { "Jhanae", 0.0 },
  { "Jhanai", 0.0 },
  { "Jhancarlos", 1.0 },
  { "Jhane", 0.0 },
  { "Jhanee", 0.0 },
  { "Jhanel", 0.0 },
  { "Jhanelle", 0.0 },
  { "Jhanet", 0.0 },
  { "Jhani", 0.0 },
  { "Jhania", 0.0 },
  { "Jhaniah", 0.0 },
  { "Jhaniya", 0.0 },
  { "Jhaniyah", 0.0 },
  { "Jhanna", 0.0 },
  { "Jhanvi", 0.0 },
  { "Jhanya", 0.0 },
  { "Jhared", 1.0 },
  { "Jhari", 1.0 },
  { "Jhariel", 1.0 },
  { "Jharline", 0.0 },
  { "Jhase", 1.0 },
  { "Jhasir", 1.0 },
  { "Jhasmin", 0.0 },
  { "Jhasmine", 0.0 },
  { "Jhavier", 1.0 },
  { "Jhavon", 1.0 },
  { "Jhayce", 1.0 },
  { "Jhayda", 0.0 },
  { "Jhayden", 0.9649123 },
  { "Jhayla", 0.0 },
  { "Jhaylen", 1.0 },
  { "Jhaziel", 1.0 },
  { "Jhena", 0.0 },
  { "Jhenae", 0.0 },
  { "Jhene", 0.0 },
  { "Jhenesis", 0.0 },
  { "Jhenifer", 0.0 },
  { "Jhenna", 0.0 },
  { "Jheremy", 1.0 },
  { "Jheri", 0.0 },
  { "Jherica", 0.0 },
  { "Jherika", 0.0 },
  { "Jherrica", 0.0 },
  { "Jheryl", 1.0 },
  { "Jhet", 1.0 },
  { "Jhett", 0.9930939 },
  { "Jhia", 0.0 },
  { "Jhiya", 0.0 },
  { "Jhoan", 1.0 },
  { "Jhoana", 0.0 },
  { "Jhoanna", 0.0 },
  { "Jhobany", 1.0 },
  { "Jhoel", 1.0 },
  { "Jhomar", 1.0 },
  { "Jhon", 1.0 },
  { "Jhonae", 0.0 },
  { "Jhonael", 1.0 },
  { "Jhonas", 1.0 },
  { "Jhonatan", 1.0 },
  { "Jhonathan", 1.0 },
  { "Jhonathon", 1.0 },
  { "Jhonattan", 1.0 },
  { "Jhonen", 1.0 },
  { "Jhonie", 1.0 },
  { "Jhoniel", 1.0 },
  { "Jhonna", 0.0 },
  { "Jhonnatan", 1.0 },
  { "Jhonni", 0.0 },
  { "Jhonnie", 0.91061455 },
  { "Jhonny", 1.0 },
  { "Jhony", 1.0 },
  { "Jhordan", 0.688 },
  { "Jhordy", 1.0 },
  { "Jhordyn", 0.12931034 },
  { "Jhori", 0.0 },
  { "Jhoselin", 0.0 },
  { "Jhoseline", 0.0 },
  { "Jhoselyn", 0.0 },
  { "Jhoselyne", 0.0 },
  { "Jhosep", 1.0 },
  { "Jhoseph", 1.0 },
  { "Jhoshua", 1.0 },
  { "Jhosmar", 1.0 },
  { "Jhosselyn", 0.0 },
  { "Jhostin", 1.0 },
  { "Jhosue", 1.0 },
  { "Jhournee", 0.0 },
  { "Jhourni", 0.0 },
  { "Jhovan", 1.0 },
  { "Jhovana", 0.0 },
  { "Jhovani", 1.0 },
  { "Jhovanna", 0.0 },
  { "Jhovanni", 1.0 },
  { "Jhovanny", 1.0 },
  { "Jhovany", 1.0 },
  { "Jhue", 1.0 },
  { "Ji", 0.3872549 },
  { "Jia", 0.15296641 },
  { "Jiaan", 1.0 },
  { "Jiacheng", 1.0 },
  { "Jiada", 0.0 },
  { "Jiah", 0.0 },
  { "Jiahao", 1.0 },
  { "Jiahna", 0.0 },
  { "Jiair", 1.0 },
  { "Jiaire", 1.0 },
  { "Jiali", 0.0 },
  { "Jialin", 0.0 },
  { "Jiamei", 0.0 },
  { "Jiaming", 1.0 },
  { "Jian", 0.9440559 },
  { "Jiana", 0.0 },
  { "Jianah", 0.0 },
  { "Jiancarlo", 1.0 },
  { "Jiancarlos", 1.0 },
  { "Jiani", 0.0 },
  { "Jianna", 0.0 },
  { "Jiannah", 0.0 },
  { "Jianne", 0.0 },
  { "Jianni", 0.5230126 },
  { "Jianny", 1.0 },
  { "Jiapsi", 0.0 },
  { "Jiaqi", 0.0 },
  { "Jiar", 1.0 },
  { "Jiara", 0.0 },
  { "Jiarui", 1.0 },
  { "Jiavanna", 0.0 },
  { "Jiaxin", 0.0 },
  { "Jiaya", 0.0 },
  { "Jiayi", 0.22105263 },
  { "Jiayue", 0.0 },
  { "Jibrael", 1.0 },
  { "Jibrail", 1.0 },
  { "Jibran", 1.0 },
  { "Jibreal", 1.0 },
  { "Jibreel", 1.0 },
  { "Jibri", 1.0 },
  { "Jibria", 0.0 },
  { "Jibriel", 1.0 },
  { "Jibril", 1.0 },
  { "Jicel", 0.0 },
  { "Jicela", 0.0 },
  { "Jidenna", 1.0 },
  { "Jie", 0.8269231 },
  { "Jiesha", 0.0 },
  { "Jieun", 0.0 },
  { "Jigar", 1.0 },
  { "Jiggs", 1.0 },
  { "Jigme", 1.0 },
  { "Jigna", 0.0 },
  { "Jihaad", 1.0 },
  { "Jihad", 0.9972988 },
  { "Jihae", 0.0 },
  { "Jihan", 0.09210526 },
  { "Jihanna", 0.0 },
  { "Jiho", 1.0 },
  { "Jihoo", 1.0 },
  { "Jihoon", 1.0 },
  { "Jihyun", 0.0 },
  { "Jikai", 1.0 },
  { "Jikayla", 0.0 },
  { "Jil", 0.0 },
  { "Jilberto", 1.0 },
  { "Jilda", 0.0 },
  { "Jildardo", 1.0 },
  { "Jileen", 0.0 },
  { "Jilene", 0.0 },
  { "Jiles", 1.0 },
  { "Jilian", 0.0 },
  { "Jiliana", 0.0 },
  { "Jilisa", 0.0 },
  { "Jilissa", 0.0 },
  { "Jill", 0.0024092107 },
  { "Jilla", 0.0 },
  { "Jillaine", 0.0 },
  { "Jillan", 0.0 },
  { "Jillana", 0.0 },
  { "Jillane", 0.0 },
  { "Jillann", 0.0 },
  { "Jillanna", 0.0 },
  { "Jillanne", 0.0 },
  { "Jillayne", 0.0 },
  { "Jillean", 0.0 },
  { "Jilleen", 0.0 },
  { "Jillena", 0.0 },
  { "Jillene", 0.0 },
  { "Jillesa", 0.0 },
  { "Jillia", 0.0 },
  { "Jilliam", 0.0 },
  { "Jillian", 0.0028093364 },
  { "Jilliana", 0.0 },
  { "Jilliane", 0.0 },
  { "Jilliann", 0.0 },
  { "Jillianna", 0.0 },
  { "Jillianne", 0.0 },
  { "Jillien", 0.0 },
  { "Jilliene", 0.0 },
  { "Jillienne", 0.0 },
  { "Jillinda", 0.0 },
  { "Jillion", 0.0 },
  { "Jillisa", 0.0 },
  { "Jillissa", 0.0 },
  { "Jilliyn", 0.0 },
  { "Jillmarie", 0.0 },
  { "Jillyan", 0.0 },
  { "Jillyn", 0.0 },
  { "Jillynn", 0.0 },
  { "Jilma", 0.0 },
  { "Jilyan", 0.0 },
  { "Jim", 0.99468803 },
  { "Jima", 0.0 },
  { "Jimal", 1.0 },
  { "Jimalee", 0.0 },
  { "Jimar", 1.0 },
  { "Jimari", 1.0 },
  { "Jimarion", 1.0 },
  { "Jimaya", 0.0 },
  { "Jimbo", 1.0 },
  { "Jimbob", 1.0 },
  { "Jimeka", 0.0 },
  { "Jimel", 1.0 },
  { "Jimell", 1.0 },
  { "Jimella", 0.0 },
  { "Jimena", 0.000709157 },
  { "Jimenez", 1.0 },
  { "Jimenna", 0.0 },
  { "Jimere", 1.0 },
  { "Jimesha", 0.0 },
  { "Jimetta", 0.0 },
  { "Jimette", 0.0 },
  { "Jimey", 1.0 },
  { "Jimi", 0.64357543 },
  { "Jimia", 0.0 },
  { "Jimiah", 0.0 },
  { "Jimica", 0.0 },
  { "Jimie", 0.9756098 },
  { "Jimika", 0.0 },
  { "Jimin", 0.42465752 },
  { "Jimique", 1.0 },
  { "Jimisha", 0.0 },
  { "Jimiya", 0.0 },
  { "Jimiyah", 0.0 },
  { "Jimm", 1.0 },
  { "Jimma", 0.0 },
  { "Jimme", 1.0 },
  { "Jimmeka", 0.0 },
  { "Jimmel", 1.0 },
  { "Jimmer", 1.0 },
  { "Jimmesha", 0.0 },
  { "Jimmey", 1.0 },
  { "Jimmi", 0.14848486 },
  { "Jimmia", 0.0 },
  { "Jimmiah", 0.0 },
  { "Jimmica", 0.0 },
  { "Jimmie", 0.8296426 },
  { "Jimmy", 0.99229205 },
  { "Jimmya", 0.0 },
  { "Jimmye", 0.042471044 },
  { "Jimmylee", 1.0 },
  { "Jimon", 1.0 },
  { "Jimson", 1.0 },
  { "Jimy", 1.0 },
  { "Jimya", 0.0 },
  { "Jimyah", 0.0 },
  { "Jin", 0.7457507 },
  { "Jina", 0.0 },
  { "Jinah", 0.0 },
  { "Jinal", 0.0 },
  { "Jinan", 0.029411765 },
  { "Jinane", 0.0 },
  { "Jinay", 1.0 },
  { "Jinaya", 0.0 },
  { "Jinayah", 0.0 },
  { "Jincy", 0.0 },
  { "Jineane", 0.0 },
  { "Jineen", 0.0 },
  { "Jinelle", 0.0 },
  { "Jinessa", 0.0 },
  { "Jinette", 0.0 },
  { "Jing", 0.074074075 },
  { "Jinger", 0.0 },
  { "Jingyi", 0.0 },
  { "Jinhee", 0.0 },
  { "Jini", 0.0 },
  { "Jiniyah", 0.0 },
  { "Jinjer", 0.0 },
  { "Jinks", 1.0 },
  { "Jinna", 0.0 },
  { "Jinnah", 0.0 },
  { "Jinni", 0.0 },
  { "Jinnie", 0.0 },
  { "Jinnifer", 0.0 },
  { "Jinny", 0.0 },
  { "Jino", 1.0 },
  { "Jinora", 0.0 },
  { "Jinu", 1.0 },
  { "Jinwoo", 1.0 },
  { "Jinx", 0.0 },
  { "Jio", 1.0 },
  { "Jion", 1.0 },
  { "Jioni", 1.0 },
  { "Jionna", 0.0 },
  { "Jionni", 0.9812362 },
  { "Jionnie", 1.0 },
  { "Jionny", 1.0 },
  { "Jiovana", 0.0 },
  { "Jiovani", 1.0 },
  { "Jiovanna", 0.0 },
  { "Jiovanni", 1.0 },
  { "Jiovannie", 1.0 },
  { "Jiovanny", 1.0 },
  { "Jiovany", 1.0 },
  { "Jiovonni", 1.0 },
  { "Jiquan", 1.0 },
  { "Jiquez", 1.0 },
  { "Jira", 0.0 },
  { "Jirah", 0.11 },
  { "Jiraiya", 0.9847561 },
  { "Jiram", 1.0 },
  { "Jireh", 0.47836348 },
  { "Jireth", 0.0 },
  { "Jiri", 1.0 },
  { "Jiro", 1.0 },
  { "Jiromi", 0.0 },
  { "Jiron", 1.0 },
  { "Jisaiah", 1.0 },
  { "Jisel", 0.0 },
  { "Jisela", 0.0 },
  { "Jisele", 0.0 },
  { "Jisell", 0.0 },
  { "Jisella", 0.0 },
  { "Jiselle", 0.0 },
  { "Jisha", 0.0 },
  { "Jishnu", 1.0 },
  { "Jisiah", 1.0 },
  { "Jisoo", 0.0 },
  { "Jissel", 0.0 },
  { "Jissela", 0.0 },
  { "Jissele", 0.0 },
  { "Jissell", 0.0 },
  { "Jisselle", 0.0 },
  { "Jissie", 0.8181818 },
  { "Jiten", 1.0 },
  { "Jitesh", 1.0 },
  { "Jitsuo", 1.0 },
  { "Jitu", 1.0 },
  { "Jitzel", 0.0 },
  { "Jiuliana", 0.0 },
  { "Jivan", 1.0 },
  { "Jivon", 1.0 },
  { "Jiwon", 0.0 },
  { "Jiwoo", 0.24615385 },
  { "Jiya", 0.0 },
  { "Jiyaan", 1.0 },
  { "Jiyah", 0.0 },
  { "Jiyan", 1.0 },
  { "Jiyana", 0.0 },
  { "Jiyanna", 0.0 },
  { "Jiyoung", 0.0 },
  { "Jiyu", 0.0 },
  { "Jizel", 0.0 },
  { "Jizele", 0.0 },
  { "Jizell", 0.0 },
  { "Jizelle", 0.0 },
  { "Jizzel", 0.0 },
  { "Jizzelle", 0.0 },
  { "Jj", 1.0 },
  { "Jjames", 1.0 },
  { "Jjesus", 1.0 },
  { "Jjuan", 1.0 },
  { "Jkai", 1.0 },
  { "Jkari", 1.0 },
  { "Jkayla", 0.0 },
  { "Jkhari", 1.0 },
  { "Jkia", 0.0 },
  { "Jkira", 0.0 },
  { "Jkiyah", 0.0 },
  { "Jkobe", 1.0 },
  { "Jkobi", 1.0 },
  { "Jkwon", 1.0 },
  { "Jkyla", 0.0 },
  { "Jl", 1.0 },
  { "Jla", 0.0 },
  { "Jlah", 0.0 },
  { "Jlan", 1.0 },
  { "Jlaya", 0.0 },
  { "Jlayah", 0.0 },
  { "Jlea", 0.0 },
  { "Jleah", 0.0 },
  { "Jlee", 0.0 },
  { "Jleigh", 0.0 },
  { "Jlen", 1.0 },
  { "Jliana", 0.0 },
  { "Jlin", 1.0 },
  { "Jlisa", 0.0 },
  { "Jliyah", 0.0 },
  { "Jlon", 1.0 },
  { "Jlyn", 0.40145984 },
  { "Jlynn", 0.086021505 },
  { "Jlyssa", 0.0 },
  { "Jm", 1.0 },
  { "Jmar", 1.0 },
  { "Jmarcus", 1.0 },
  { "Jmari", 1.0 },
  { "Jmarie", 0.0 },
  { "Jmarion", 1.0 },
  { "Jmauri", 1.0 },
  { "Jmaya", 0.0 },
  { "Jme", 0.0 },
  { "Jmere", 1.0 },
  { "Jmia", 0.0 },
  { "Jmichael", 1.0 },
  { "Jmir", 1.0 },
  { "Jmiyah", 0.0 },
  { "Jmya", 0.0 },
  { "Jmyah", 0.0 },
  { "Jmyiah", 0.0 },
  { "Jmyra", 0.0 },
  { "Jnae", 0.0 },
  { "Jnai", 0.0 },
  { "Jnaiya", 0.0 },
  { "Jnasia", 0.0 },
  { "Jnay", 0.0 },
  { "Jnaya", 0.0 },
  { "Jnia", 0.0 },
  { "Jniah", 0.0 },
  { "Jniaya", 0.0 },
  { "Jniya", 0.0 },
  { "Jniyah", 0.0 },
  { "Jno", 1.0 },
  { "Jnya", 0.0 },
  { "Jnyah", 0.0 },
  { "Jnyia", 0.0 },
  { "Jnyla", 0.0 },
  { "Jo", 0.009986983 },
  { "Joa", 0.25 },
  { "Joab", 1.0 },
  { "Joachim", 1.0 },
  { "Joacim", 1.0 },
  { "Joah", 1.0 },
  { "Joahan", 1.0 },
  { "Joahn", 1.0 },
  { "Joahna", 0.0 },
  { "Joahnna", 0.0 },
  { "Joahua", 1.0 },
  { "Joakim", 1.0 },
  { "Joakima", 0.0 },
  { "Joakin", 1.0 },
  { "Joal", 0.795082 },
  { "Joaly", 0.0 },
  { "Joan", 0.01229617 },
  { "Joana", 0.0 },
  { "Joanah", 0.0 },
  { "Joanann", 0.0 },
  { "Joanathan", 1.0 },
  { "Joandaly", 0.0 },
  { "Joandra", 0.0 },
  { "Joandre", 1.0 },
  { "Joandri", 1.0 },
  { "Joandry", 1.0 },
  { "Joandy", 1.0 },
  { "Joane", 0.0 },
  { "Joanel", 1.0 },
  { "Joaneliz", 0.0 },
  { "Joanell", 0.0 },
  { "Joanelle", 0.0 },
  { "Joanetta", 0.0 },
  { "Joanette", 0.0 },
  { "Joangel", 1.0 },
  { "Joangela", 0.0 },
  { "Joani", 0.0 },
  { "Joanie", 0.0 },
  { "Joanita", 0.0 },
  { "Joanmarie", 0.0 },
  { "Joann", 0.0034941402 },
  { "Joanna", 0.0030071347 },
  { "Joannah", 0.0 },
  { "Joannamarie", 0.0 },
  { "Joanne", 0.0023808512 },
  { "Joannette", 0.0 },
  { "Joannie", 0.0 },
  { "Joanny", 0.0295858 },
  { "Joanthan", 1.0 },
  { "Joanthon", 1.0 },
  { "Joanthony", 1.0 },
  { "Joany", 0.078125 },
  { "Joao", 1.0 },
  { "Joaogabriel", 1.0 },
  { "Joaolucas", 1.0 },
  { "Joaopaulo", 1.0 },
  { "Joaopedro", 1.0 },
  { "Joaovictor", 1.0 },
  { "Joaovitor", 1.0 },
  { "Joaquim", 1.0 },
  { "Joaquin", 0.9980093 },
  { "Joaquina", 0.0 },
  { "Joas", 1.0 },
  { "Joash", 1.0 },
  { "Joason", 1.0 },
  { "Joathan", 1.0 },
  { "Job", 1.0 },
  { "Joban", 1.0 },
  { "Jobana", 0.0 },
  { "Jobani", 1.0 },
  { "Jobanny", 1.0 },
  { "Jobany", 1.0 },
  { "Jobari", 1.0 },
  { "Jobe", 1.0 },
  { "Joben", 1.0 },
  { "Jobeth", 0.0 },
  { "Jobey", 1.0 },
  { "Jobi", 0.125 },
  { "Jobie", 0.8875502 },
  { "Jobin", 1.0 },
  { "Jobina", 0.0 },
  { "Jobita", 0.0 },
  { "Joby", 0.9425676 },
  { "Jobyna", 0.0 },
  { "Joc", 1.0 },
  { "Jocabed", 0.0 },
  { "Jocabeth", 0.0 },
  { "Jocalyn", 0.0 },
  { "Jocalynn", 0.0 },
  { "Jocarol", 0.0 },
  { "Jocasta", 0.0 },
  { "Joce", 1.0 },
  { "Jocee", 0.0 },
  { "Joceleen", 0.0 },
  { "Jocelene", 0.0 },
  { "Jocelin", 0.0 },
  { "Joceline", 0.0 },
  { "Jocelinne", 0.0 },
  { "Jocell", 0.0 },
  { "Jocelle", 0.0 },
  { "Jocellyn", 0.0 },
  { "Jocely", 0.0 },
  { "Jocelyn", 0.0034191532 },
  { "Jocelyne", 0.0 },
  { "Jocelynmarie", 0.0 },
  { "Jocelynn", 0.0 },
  { "Jocelynne", 0.0 },
  { "Jocene", 0.0 },
  { "Jocephus", 1.0 },
  { "Jocey", 0.0 },
  { "Joceyln", 0.0 },
  { "Jochebed", 0.0 },
  { "Jochelle", 0.0 },
  { "Joci", 0.0 },
  { "Jociah", 1.0 },
  { "Jocie", 0.0 },
  { "Jociel", 1.0 },
  { "Jocile", 0.0 },
  { "Jocilyn", 0.0 },
  { "Jocilynn", 0.0 },
  { "Jocinda", 0.0 },
  { "Jock", 1.0 },
  { "Jocko", 1.0 },
  { "Joclyn", 0.0 },
  { "Joclynn", 0.0 },
  { "Jocob", 1.0 },
  { "Jocoby", 1.0 },
  { "Jocqua", 1.0 },
  { "Jocqueline", 0.0 },
  { "Jocques", 1.0 },
  { "Jocquez", 1.0 },
  { "Jocqui", 1.0 },
  { "Jocsan", 1.0 },
  { "Jocylin", 0.0 },
  { "Jocylyn", 0.0 },
  { "Joda", 0.15178572 },
  { "Jodan", 1.0 },
  { "Jodana", 0.0 },
  { "Jodanna", 0.0 },
  { "Jodarius", 1.0 },
  { "Joddie", 0.26086956 },
  { "Jode", 0.14619882 },
  { "Jodean", 0.0 },
  { "Jodeane", 0.0 },
  { "Jodeci", 0.48923078 },
  { "Jodee", 0.010583707 },
  { "Jodeen", 0.0 },
  { "Jodel", 0.0 },
  { "Jodell", 0.0 },
  { "Jodelle", 0.0 },
  { "Joden", 1.0 },
  { "Jodena", 0.0 },
  { "Jodene", 0.0 },
  { "Jodette", 0.0 },
  { "Jodey", 0.6503497 },
  { "Jodhveer", 1.0 },
  { "Jodi", 0.011394946 },
  { "Jodiann", 0.0 },
  { "Jodianne", 0.0 },
  { "Jodice", 1.0 },
  { "Jodie", 0.11700671 },
  { "Jodiel", 1.0 },
  { "Jodilyn", 0.0 },
  { "Jodilynn", 0.0 },
  { "Jodina", 0.0 },
  { "Jodine", 0.0 },
  { "Jodonna", 0.0 },
  { "Jody", 0.35882673 },
  { "Jodyann", 0.0 },
  { "Jodye", 0.0 },
  { "Jodyne", 0.0 },
  { "Joe", 0.9754826 },
  { "Joean", 0.0 },
  { "Joeana", 0.0 },
  { "Joeangel", 1.0 },
  { "Joeann", 0.0 },
  { "Joeanna", 0.0 },
  { "Joeanne", 0.0 },
  { "Joeanthony", 1.0 },
  { "Joeb", 1.0 },
  { "Joed", 1.0 },
  { "Joedon", 1.0 },
  { "Joedy", 0.9230769 },
  { "Joee", 0.056179777 },
  { "Joeen", 0.0 },
  { "Joei", 0.0 },
  { "Joeisha", 0.0 },
  { "Joel", 0.99040896 },
  { "Joela", 0.0 },
  { "Joelaine", 0.0 },
  { "Joelan", 1.0 },
  { "Joele", 0.0 },
  { "Joelee", 0.0 },
  { "Joeleen", 0.0 },
  { "Joelene", 0.0 },
  { "Joeli", 0.0 },
  { "Joelia", 0.0 },
  { "Joelie", 0.0 },
  { "Joeliel", 1.0 },
  { "Joelina", 0.0 },
  { "Joeline", 0.0 },
  { "Joelis", 0.0 },
  { "Joelisa", 0.0 },
  { "Joelissa", 0.0 },
  { "Joeliz", 0.0 },
  { "Joell", 0.484985 },
  { "Joella", 0.0 },
  { "Joelle", 0.027560242 },
  { "Joellen", 0.0 },
  { "Joelliane", 0.0 },
  { "Joellie", 0.0 },
  { "Joelly", 0.0 },
  { "Joellyn", 0.0 },
  { "Joelouis", 1.0 },
  { "Joely", 0.0 },
  { "Joelyn", 0.0 },
  { "Joelyne", 0.0 },
  { "Joelynn", 0.0 },
  { "Joelys", 0.0 },
  { "Joemar", 1.0 },
  { "Joemichael", 1.0 },
  { "Joemy", 0.0 },
  { "Joen", 0.5903614 },
  { "Joena", 0.0 },
  { "Joenathan", 1.0 },
  { "Joene", 0.0 },
  { "Joenell", 0.0 },
  { "Joeph", 1.0 },
  { "Joephine", 0.0 },
  { "Joequan", 1.0 },
  { "Joeray", 1.0 },
  { "Joerell", 1.0 },
  { "Joes", 1.0 },
  { "Joesef", 1.0 },
  { "Joeseph", 1.0 },
  { "Joesette", 0.0 },
  { "Joesha", 0.0 },
  { "Joesiah", 1.0 },
  { "Joesiyah", 1.0 },
  { "Joesph", 0.99922603 },
  { "Joesphine", 0.0 },
  { "Joetta", 0.0 },
  { "Joette", 0.0 },
  { "Joevan", 1.0 },
  { "Joevani", 1.0 },
  { "Joevanni", 1.0 },
  { "Joevanny", 1.0 },
  { "Joevany", 1.0 },
  { "Joevon", 1.0 },
  { "Joey", 0.89147717 },
  { "Joeylynn", 0.0 },
  { "Joezette", 0.0 },
  { "Joeziah", 1.0 },
  { "Joffre", 1.0 },
  { "Joffrey", 1.0 },
  { "Jofiel", 1.0 },
  { "Jogina", 0.0 },
  { "Joh", 1.0 },
  { "Johaan", 1.0 },
  { "Johah", 1.0 },
  { "Johan", 0.98682415 },
  { "Johana", 0.0018272426 },
  { "Johanah", 0.0 },
  { "Johanan", 1.0 },
  { "Johandry", 1.0 },
  { "Johandy", 1.0 },
  { "Johann", 0.86105174 },
  { "Johanna", 0.002556531 },
  { "Johannah", 0.0 },
  { "Johanne", 0.0 },
  { "Johannes", 1.0 },
  { "Johannie", 0.0 },
  { "Johanny", 0.13125 },
  { "Johansel", 1.0 },
  { "Johansen", 1.0 },
  { "Johanson", 1.0 },
  { "Johanthan", 1.0 },
  { "Johany", 0.43103448 },
  { "Johao", 1.0 },
  { "Johar", 1.0 },
  { "Johara", 0.0 },
  { "Johari", 0.3781321 },
  { "Joharis", 0.0 },
  { "Johary", 1.0 },
  { "Johathan", 1.0 },
  { "Johathon", 1.0 },
  { "Johaun", 1.0 },
  { "Johel", 1.0 },
  { "Johhny", 1.0 },
  { "Johileny", 0.0 },
  { "Johm", 1.0 },
  { "John", 0.9957743 },
  { "Johna", 0.0024420025 },
  { "Johnaaron", 1.0 },
  { "Johnadam", 1.0 },
  { "Johnae", 0.0 },
  { "Johnael", 1.0 },
  { "Johnah", 0.0 },
  { "Johnai", 0.0 },
  { "Johnalbert", 1.0 },
  { "Johnalexander", 1.0 },
  { "Johnallen", 1.0 },
  { "Johnalyn", 0.0 },
  { "Johnan", 1.0 },
  { "Johnandrew", 1.0 },
  { "Johnanna", 0.0 },
  { "Johnanthan", 1.0 },
  { "Johnanthony", 1.0 },
  { "Johnas", 1.0 },
  { "Johnasia", 0.0 },
  { "Johnatan", 1.0 },
  { "Johnatha", 1.0 },
  { "Johnathan", 0.9962094 },
  { "Johnathen", 1.0 },
  { "Johnathin", 1.0 },
  { "Johnathn", 1.0 },
  { "Johnatho", 1.0 },
  { "Johnathon", 0.99789757 },
  { "Johnathyn", 1.0 },
  { "Johnaton", 1.0 },
  { "Johnattan", 1.0 },
  { "Johnavan", 1.0 },
  { "Johnaven", 1.0 },
  { "Johnavin", 1.0 },
  { "Johnavon", 1.0 },
  { "Johnay", 0.0 },
  { "Johnaya", 0.0 },
  { "Johnbenedict", 1.0 },
  { "Johncarl", 1.0 },
  { "Johncarlo", 1.0 },
  { "Johncarlos", 1.0 },
  { "Johncarter", 1.0 },
  { "Johncharles", 1.0 },
  { "Johnchristian", 1.0 },
  { "Johnchristopher", 1.0 },
  { "Johnda", 0.0 },
  { "Johndaniel", 1.0 },
  { "Johndavid", 1.0 },
  { "Johndrea", 0.0 },
  { "Johne", 0.9264706 },
  { "Johnea", 0.0 },
  { "Johnecia", 0.0 },
  { "Johnedward", 1.0 },
  { "Johnee", 0.0 },
  { "Johneen", 0.0 },
  { "Johneice", 0.0 },
  { "Johneisha", 0.0 },
  { "Johneka", 0.0 },
  { "Johnel", 0.98015875 },
  { "Johnell", 0.7715573 },
  { "Johnella", 0.0 },
  { "Johnelle", 0.030023094 },
  { "Johnene", 0.0 },
  { "Johneric", 1.0 },
  { "Johnese", 0.0 },
  { "Johnesha", 0.0 },
  { "Johneshia", 0.0 },
  { "Johnesia", 0.0 },
  { "Johnessa", 0.0 },
  { "Johnethan", 1.0 },
  { "Johnetta", 0.0 },
  { "Johnette", 0.0 },
  { "Johney", 0.99606556 },
  { "Johnfrancis", 1.0 },
  { "Johngabriel", 1.0 },
  { "Johnhenry", 1.0 },
  { "Johni", 0.0 },
  { "Johnia", 0.0 },
  { "Johniah", 0.0 },
  { "Johnica", 0.0 },
  { "Johnice", 0.0 },
  { "Johnicia", 0.0 },
  { "Johnie", 0.8025855 },
  { "Johniece", 0.0 },
  { "Johniel", 1.0 },
  { "Johniesha", 0.0 },
  { "Johnika", 0.0 },
  { "Johnine", 0.0 },
  { "Johniqua", 0.0 },
  { "Johnique", 0.0 },
  { "Johnise", 0.0 },
  { "Johnisha", 0.0 },
  { "Johnita", 0.0 },
  { "Johnitta", 0.0 },
  { "Johniya", 0.0 },
  { "Johniyah", 0.0 },
  { "Johnjack", 1.0 },
  { "Johnjames", 1.0 },
  { "Johnjoseph", 1.0 },
  { "Johnlee", 1.0 },
  { "Johnlloyd", 1.0 },
  { "Johnlucas", 1.0 },
  { "Johnluis", 1.0 },
  { "Johnluke", 1.0 },
  { "Johnmarco", 1.0 },
  { "Johnmark", 1.0 },
  { "Johnmartin", 1.0 },
  { "Johnmatthew", 1.0 },
  { "Johnmichael", 1.0 },
  { "Johnmorgan", 1.0 },
  { "Johnn", 1.0 },
  { "Johnna", 0.0 },
  { "Johnnae", 0.0 },
  { "Johnnathan", 1.0 },
  { "Johnnathon", 1.0 },
  { "Johnnay", 0.0 },
  { "Johnneisha", 0.0 },
  { "Johnnel", 1.0 },
  { "Johnnell", 1.0 },
  { "Johnnesha", 0.0 },
  { "Johnnessa", 0.0 },
  { "Johnnetta", 0.0 },
  { "Johnnette", 0.0 },
  { "Johnney", 1.0 },
  { "Johnni", 0.052380953 },
  { "Johnnia", 0.0 },
  { "Johnnice", 0.0 },
  { "Johnnie", 0.6747319 },
  { "Johnniemae", 0.0 },
  { "Johnniqua", 0.0 },
  { "Johnnisha", 0.0 },
  { "Johnnita", 0.0 },
  { "Johnny", 0.9881854 },
  { "Johnnyangel", 1.0 },
  { "Johnnye", 0.040955633 },
  { "Johnnyjoe", 1.0 },
  { "Johnnylee", 1.0 },
  { "Johnnyray", 1.0 },
  { "Johnoliver", 1.0 },
  { "Johnothan", 1.0 },
  { "Johnovan", 1.0 },
  { "Johnparker", 1.0 },
  { "Johnpatrick", 1.0 },
  { "Johnpaul", 1.0 },
  { "Johnpeter", 1.0 },
  { "Johnphilip", 1.0 },
  { "Johnphillip", 1.0 },
  { "Johnray", 1.0 },
  { "Johnrichard", 1.0 },
  { "Johnrobert", 1.0 },
  { "Johnross", 1.0 },
  { "Johnrussell", 1.0 },
  { "Johnryan", 1.0 },
  { "Johnscott", 1.0 },
  { "Johnse", 1.0 },
  { "Johnsie", 0.0 },
  { "Johnson", 0.99666464 },
  { "Johnston", 1.0 },
  { "Johnsy", 0.0 },
  { "Johnta", 0.9781659 },
  { "Johntae", 0.977707 },
  { "Johntavia", 0.0 },
  { "Johntavious", 1.0 },
  { "Johntavis", 1.0 },
  { "Johntavius", 1.0 },
  { "Johntay", 1.0 },
  { "Johnte", 1.0 },
  { "Johntel", 1.0 },
  { "Johntell", 1.0 },
  { "Johntez", 1.0 },
  { "Johnthan", 1.0 },
  { "Johnthomas", 1.0 },
  { "Johnthon", 1.0 },
  { "Johntrell", 1.0 },
  { "Johntyler", 1.0 },
  { "Johnvictor", 1.0 },
  { "Johnvincent", 1.0 },
  { "Johnwesley", 1.0 },
  { "Johnwilliam", 1.0 },
  { "Johny", 0.9924942 },
  { "Johnya", 0.0 },
  { "Johnye", 0.0 },
  { "Johnyla", 0.0 },
  { "Johon", 1.0 },
  { "Johonna", 0.0 },
  { "Johrdan", 1.0 },
  { "Johsua", 1.0 },
  { "Johua", 1.0 },
  { "Johusa", 1.0 },
  { "Johvanna", 0.0 },
  { "Johvanny", 1.0 },
  { "Joi", 0.0 },
  { "Joia", 0.0 },
  { "Joice", 0.0 },
  { "Joicy", 0.0 },
  { "Joie", 0.09173616 },
  { "Joielle", 0.0 },
  { "Joilyn", 0.0 },
  { "Joise", 0.0 },
  { "Joiya", 0.0 },
  { "Jojean", 0.0 },
  { "Joji", 1.0 },
  { "Jojo", 0.64220184 },
  { "Jojuan", 1.0 },
  { "Jokari", 1.0 },
  { "Joksan", 1.0 },
  { "Jola", 0.0 },
  { "Jolaine", 0.0 },
  { "Jolan", 0.6 },
  { "Jolana", 0.0 },
  { "Jolanda", 0.0 },
  { "Jolane", 0.0 },
  { "Jolani", 0.0 },
  { "Jolanta", 0.0 },
  { "Jolaoluwa", 0.0 },
  { "Jolayne", 0.0 },
  { "Jole", 0.0862069 },
  { "Jolea", 0.0 },
  { "Joleah", 0.0 },
  { "Jolean", 0.0 },
  { "Jolecia", 0.0 },
  { "Jolee", 0.0 },
  { "Joleen", 0.0 },
  { "Joleena", 0.0 },
  { "Joleene", 0.0 },
  { "Joleesa", 0.0 },
  { "Jolei", 0.0 },
  { "Joleigh", 0.0 },
  { "Joleigha", 0.0 },
  { "Jolen", 0.78723407 },
  { "Jolena", 0.0 },
  { "Jolene", 0.00039100685 },
  { "Jolenna", 0.0 },
  { "Jolesa", 0.0 },
  { "Jolesha", 0.0 },
  { "Jolet", 0.0 },
  { "Joleta", 0.0 },
  { "Joleth", 0.0 },
  { "Joletha", 0.0 },
  { "Jolett", 0.0 },
  { "Joletta", 0.0 },
  { "Jolette", 0.0 },
  { "Joley", 0.0 },
  { "Joli", 0.0 },
  { "Jolia", 0.0 },
  { "Jolian", 1.0 },
  { "Joliana", 0.0 },
  { "Jolianna", 0.0 },
  { "Jolicia", 0.0 },
  { "Jolie", 0.0 },
  { "Jolieann", 0.0 },
  { "Joliee", 0.0 },
  { "Jolien", 0.0 },
  { "Joliene", 0.0 },
  { "Joliet", 0.0 },
  { "Joliette", 0.0 },
  { "Jolin", 0.10268949 },
  { "Jolina", 0.0 },
  { "Jolinda", 0.0 },
  { "Joline", 0.0 },
  { "Jolisa", 0.0 },
  { "Jolisha", 0.0 },
  { "Jolissa", 0.0 },
  { "Jolita", 0.0 },
  { "Joliyah", 0.0 },
  { "Jolleen", 0.0 },
  { "Jollene", 0.0 },
  { "Jollette", 0.0 },
  { "Jollie", 1.0 },
  { "Jolly", 0.7532467 },
  { "Jolon", 1.0 },
  { "Jolonda", 0.0 },
  { "Jolyn", 0.0 },
  { "Jolynda", 0.0 },
  { "Jolyne", 0.0 },
  { "Jolynn", 0.0 },
  { "Jolynne", 0.0 },
  { "Jolyon", 1.0 },
  { "Jolysa", 0.0 },
  { "Jolyssa", 0.0 },
  { "Jomaira", 0.0 },
  { "Jomal", 1.0 },
  { "Jomana", 0.0 },
  { "Jomanda", 0.0 },
  { "Jomar", 1.0 },
  { "Jomara", 0.0 },
  { "Jomarcus", 1.0 },
  { "Jomari", 0.8238806 },
  { "Jomarie", 0.010660981 },
  { "Jomarion", 1.0 },
  { "Jomaris", 0.0 },
  { "Jomary", 0.0 },
  { "Jomayra", 0.0 },
  { "Jomei", 1.0 },
  { "Jomeka", 0.0 },
  { "Jomel", 1.0 },
  { "Jomes", 1.0 },
  { "Jometh", 1.0 },
  { "Jomiah", 0.0 },
  { "Jomira", 0.0 },
  { "Jomo", 1.0 },
  { "Jon", 0.99250704 },
  { "Jona", 0.1750503 },
  { "Jonadab", 1.0 },
  { "Jonae", 0.0 },
  { "Jonael", 1.0 },
  { "Jonah", 0.99104416 },
  { "Jonahan", 1.0 },
  { "Jonahel", 1.0 },
  { "Jonahs", 1.0 },
  { "Jonahtan", 1.0 },
  { "Jonai", 0.032894738 },
  { "Jonalee", 0.0 },
  { "Jonalyn", 0.0 },
  { "Jonam", 1.0 },
  { "Jonan", 1.0 },
  { "Jonanthan", 1.0 },
  { "Jonanthony", 1.0 },
  { "Jonas", 0.99878746 },
  { "Jonasia", 0.0 },
  { "Jonatan", 1.0 },
  { "Jonath", 1.0 },
  { "Jonatha", 0.9147059 },
  { "Jonatham", 1.0 },
  { "Jonathan", 0.99576205 },
  { "Jonathandavid", 1.0 },
  { "Jonathanjames", 1.0 },
  { "Jonathanjoseph", 1.0 },
  { "Jonathanmichael", 1.0 },
  { "Jonathaon", 1.0 },
  { "Jonathen", 1.0 },
  { "Jonathin", 1.0 },
  { "Jonathn", 1.0 },
  { "Jonathna", 1.0 },
  { "Jonathon", 0.9965277 },
  { "Jonathyn", 1.0 },
  { "Jonaton", 1.0 },
  { "Jonattan", 1.0 },
  { "Jonatthan", 1.0 },
  { "Jonavan", 1.0 },
  { "Jonaven", 1.0 },
  { "Jonavin", 1.0 },
  { "Jonavon", 1.0 },
  { "Jonay", 0.0 },
  { "Jonaya", 0.0 },
  { "Jonaye", 0.0 },
  { "Jonbenet", 0.0 },
  { "Joncarlo", 1.0 },
  { "Joncarlos", 1.0 },
  { "Jonce", 1.0 },
  { "Jonchristopher", 1.0 },
  { "Jonda", 0.0 },
  { "Jondarius", 1.0 },
  { "Jondavid", 1.0 },
  { "Jondra", 0.0 },
  { "Jondrea", 0.0 },
  { "Jone", 0.033755273 },
  { "Jonea", 0.0 },
  { "Jonecia", 0.0 },
  { "Jonee", 0.0 },
  { "Joneen", 0.0 },
  { "Joneer", 0.0 },
  { "Joneisha", 0.0 },
  { "Joneka", 0.0 },
  { "Jonel", 0.49615976 },
  { "Jonell", 0.077848814 },
  { "Jonella", 0.0 },
  { "Jonelle", 0.0066266963 },
  { "Jonene", 0.0 },
  { "Joneric", 1.0 },
  { "Jonerik", 1.0 },
  { "Jones", 0.99640936 },
  { "Jonesha", 0.0 },
  { "Joneshia", 0.0 },
  { "Jonessa", 0.0 },
  { "Jonesy", 1.0 },
  { "Jonet", 0.0 },
  { "Jonethan", 1.0 },
  { "Jonethen", 1.0 },
  { "Jonetta", 0.0 },
  { "Jonette", 0.0 },
  { "Joney", 1.0 },
  { "Jong", 1.0 },
  { "Jonh", 1.0 },
  { "Jonhatan", 1.0 },
  { "Jonhathan", 1.0 },
  { "Jonhenry", 1.0 },
  { "Joni", 0.018902864 },
  { "Jonia", 0.0 },
  { "Joniah", 0.0 },
  { "Jonibek", 1.0 },
  { "Jonica", 0.0 },
  { "Jonice", 0.0 },
  { "Jonicia", 0.0 },
  { "Jonie", 0.034455754 },
  { "Joniece", 0.0 },
  { "Joniel", 1.0 },
  { "Joniell", 1.0 },
  { "Jonier", 0.0 },
  { "Joniesha", 0.0 },
  { "Jonika", 0.0 },
  { "Jonikka", 0.0 },
  { "Jonilee", 0.0 },
  { "Jonina", 0.0 },
  { "Jonine", 0.0 },
  { "Joniqua", 0.0 },
  { "Jonique", 0.0 },
  { "Jonis", 1.0 },
  { "Jonise", 0.0 },
  { "Jonisha", 0.0 },
  { "Jonita", 0.0 },
  { "Jonithan", 1.0 },
  { "Joniya", 0.0 },
  { "Joniyah", 0.0 },
  { "Jonjon", 1.0 },
  { "Jonluc", 1.0 },
  { "Jonluca", 1.0 },
  { "Jonlucas", 1.0 },
  { "Jonluke", 1.0 },
  { "Jonlyn", 0.0 },
  { "Jonmarc", 1.0 },
  { "Jonmark", 1.0 },
  { "Jonmatthew", 1.0 },
  { "Jonmichael", 1.0 },
  { "Jonn", 1.0 },
  { "Jonna", 0.0 },
  { "Jonnae", 0.0 },
  { "Jonnah", 0.25641027 },
  { "Jonnatan", 1.0 },
  { "Jonnathan", 1.0 },
  { "Jonnathon", 1.0 },
  { "Jonnay", 0.0 },
  { "Jonne", 0.0 },
  { "Jonnell", 0.1594203 },
  { "Jonnelle", 0.0 },
  { "Jonnesha", 0.0 },
  { "Jonnetta", 0.0 },
  { "Jonnette", 0.0 },
  { "Jonney", 1.0 },
  { "Jonni", 0.0041017225 },
  { "Jonnica", 0.0 },
  { "Jonnie", 0.35478085 },
  { "Jonniel", 1.0 },
  { "Jonnika", 0.0 },
  { "Jonnique", 0.0 },
  { "Jonnisha", 0.0 },
  { "Jonnita", 0.0 },
  { "Jonny", 0.9590753 },
  { "Jonnye", 0.0 },
  { "Jonoah", 1.0 },
  { "Jonothan", 1.0 },
  { "Jonothon", 1.0 },
  { "Jonovan", 1.0 },
  { "Jonpatrick", 1.0 },
  { "Jonpaul", 1.0 },
  { "Jonpierre", 1.0 },
  { "Jonquavious", 1.0 },
  { "Jonquel", 1.0 },
  { "Jonquez", 1.0 },
  { "Jonquil", 0.20446096 },
  { "Jonquin", 1.0 },
  { "Jonrobert", 1.0 },
  { "Jonross", 1.0 },
  { "Jonryan", 1.0 },
  { "Jonson", 1.0 },
  { "Jonta", 0.8674699 },
  { "Jontae", 0.81641024 },
  { "Jontarius", 1.0 },
  { "Jontasia", 0.0 },
  { "Jontavia", 0.0 },
  { "Jontavion", 1.0 },
  { "Jontavious", 1.0 },
  { "Jontavis", 1.0 },
  { "Jontavius", 1.0 },
  { "Jontay", 0.9074074 },
  { "Jontaya", 0.0 },
  { "Jontaye", 1.0 },
  { "Jonte", 0.8385714 },
  { "Jontel", 0.60784316 },
  { "Jontelle", 0.0 },
  { "Jonteria", 0.0 },
  { "Jontez", 1.0 },
  { "Jonthan", 1.0 },
  { "Jonthomas", 1.0 },
  { "Jontia", 0.0 },
  { "Jontre", 1.0 },
  { "Jontrell", 1.0 },
  { "Jontue", 0.6936937 },
  { "Jontyler", 1.0 },
  { "Jonuel", 1.0 },
  { "Jonus", 1.0 },
  { "Jonwesley", 1.0 },
  { "Jony", 1.0 },
  { "Jonya", 0.0 },
  { "Jonylah", 0.0 },
  { "Joo", 0.33333334 },
  { "Jood", 0.17791411 },
  { "Joon", 0.90726817 },
  { "Joory", 0.0 },
  { "Jooyoung", 1.0 },
  { "Jophiel", 1.0 },
  { "Jophy", 1.0 },
  { "Joplin", 0.024509804 },
  { "Joplyn", 0.0 },
  { "Joplynn", 0.0 },
  { "Joquan", 1.0 },
  { "Joquavious", 1.0 },
  { "Joquetta", 0.0 },
  { "Joquin", 1.0 },
  { "Joquita", 0.0 },
  { "Jora", 0.0 },
  { "Jorah", 0.46268657 },
  { "Joram", 1.0 },
  { "Joran", 1.0 },
  { "Jorawar", 1.0 },
  { "Joray", 1.0 },
  { "Jorda", 1.0 },
  { "Jordaan", 1.0 },
  { "Jordache", 1.0 },
  { "Jordae", 0.0 },
  { "Jordahn", 0.0 },
  { "Jordai", 0.0 },
  { "Jordain", 0.21532847 },
  { "Jordan", 0.73822314 },
  { "Jordana", 0.0 },
  { "Jordanalexander", 1.0 },
  { "Jordanchristoph", 1.0 },
  { "Jordane", 0.04191617 },
  { "Jordani", 1.0 },
  { "Jordania", 0.0 },
  { "Jordanlee", 1.0 },
  { "Jordanmarie", 0.0 },
  { "Jordanmichael", 1.0 },
  { "Jordann", 0.0505145 },
  { "Jordanna", 0.0 },
  { "Jordanne", 0.0 },
  { "Jordanny", 1.0 },
  { "Jordano", 1.0 },
  { "Jordany", 1.0 },
  { "Jordayn", 0.0 },
  { "Jorddy", 1.0 },
  { "Jorde", 1.0 },
  { "Jordee", 0.0 },
  { "Jordell", 1.0 },
  { "Jorden", 0.73989433 },
  { "Jordeyn", 0.0 },
  { "Jordi", 0.9372477 },
  { "Jordian", 0.0 },
  { "Jordie", 0.75 },
  { "Jordin", 0.34877127 },
  { "Jordinn", 0.0 },
  { "Jordis", 0.021978023 },
  { "Jordon", 0.8790301 },
  { "Jordun", 1.0 },
  { "Jordy", 0.9873495 },
  { "Jordyan", 0.14285715 },
  { "Jordyn", 0.08892522 },
  { "Jordyne", 0.0 },
  { "Jordynn", 0.023431595 },
  { "Jordynne", 0.0 },
  { "Joree", 0.0 },
  { "Joreen", 0.0 },
  { "Jorel", 1.0 },
  { "Jorell", 1.0 },
  { "Jorelys", 0.0 },
  { "Joren", 1.0 },
  { "Jorene", 0.0 },
  { "Joretha", 0.0 },
  { "Joretta", 0.0 },
  { "Jorey", 0.8979592 },
  { "Jorga", 0.0 },
  { "Jorgan", 1.0 },
  { "Jorge", 0.99464315 },
  { "Jorgealberto", 1.0 },
  { "Jorgeantonio", 1.0 },
  { "Jorgedavid", 1.0 },
  { "Jorgejr", 1.0 },
  { "Jorgeluis", 1.0 },
  { "Jorgen", 1.0 },
  { "Jorgi", 0.0 },
  { "Jorgia", 0.0 },
  { "Jorgie", 0.0 },
  { "Jorgina", 0.0 },
  { "Jori", 0.069350146 },
  { "Joria", 0.0 },
  { "Joriah", 0.54545456 },
  { "Jorian", 0.9093484 },
  { "Joriann", 0.0 },
  { "Jorianna", 0.0 },
  { "Jorie", 0.012269938 },
  { "Joriel", 1.0 },
  { "Jorien", 1.0 },
  { "Jorim", 1.0 },
  { "Jorin", 1.0 },
  { "Joris", 1.0 },
  { "Jorita", 0.0 },
  { "Jorja", 0.0 },
  { "Jorje", 1.0 },
  { "Jorjia", 0.0 },
  { "Jorleny", 0.0 },
  { "Jorley", 0.0 },
  { "Jorma", 1.0 },
  { "Jorman", 1.0 },
  { "Jorn", 1.0 },
  { "Jorome", 1.0 },
  { "Joron", 1.0 },
  { "Jorrel", 1.0 },
  { "Jorrell", 1.0 },
  { "Jorren", 1.0 },
  { "Jorri", 0.0 },
  { "Jorrie", 0.0 },
  { "Jorrin", 1.0 },
  { "Jorryn", 0.49044585 },
  { "Jory", 0.85365856 },
  { "Joryel", 1.0 },
  { "Joryn", 0.0 },
  { "Jos", 1.0 },
  { "Josa", 1.0 },
  { "Josabet", 0.0 },
  { "Josabeth", 0.0 },
  { "Josael", 1.0 },
  { "Josafat", 1.0 },
  { "Josai", 1.0 },
  { "Josaia", 1.0 },
  { "Josaiah", 1.0 },
  { "Josaih", 1.0 },
  { "Josalin", 0.0 },
  { "Josalina", 0.0 },
  { "Josaline", 0.0 },
  { "Josalyn", 0.0 },
  { "Josalyne", 0.0 },
  { "Josalynn", 0.0 },
  { "Josan", 1.0 },
  { "Josann", 0.0 },
  { "Josanna", 0.0 },
  { "Josanne", 0.0 },
  { "Josaphat", 1.0 },
  { "Josaphina", 0.0 },
  { "Josaphine", 0.0 },
  { "Josbel", 1.0 },
  { "Joscar", 1.0 },
  { "Joscelin", 0.0 },
  { "Josceline", 0.0 },
  { "Joscelyn", 0.0 },
  { "Joscelyne", 0.0 },
  { "Joscelynn", 0.0 },
  { "Josclyn", 0.0 },
  { "Jose", 0.9925729 },
  { "Josea", 1.0 },
  { "Joseadrian", 1.0 },
  { "Josealberto", 1.0 },
  { "Josealejandro", 1.0 },
  { "Josealfredo", 1.0 },
  { "Josean", 1.0 },
  { "Joseandres", 1.0 },
  { "Joseangel", 1.0 },
  { "Joseantonio", 1.0 },
  { "Josearmando", 1.0 },
  { "Josecarlos", 1.0 },
  { "Josecruz", 1.0 },
  { "Josedaniel", 1.0 },
  { "Josedavid", 1.0 },
  { "Josede", 1.0 },
  { "Josedejesus", 1.0 },
  { "Joseduardo", 1.0 },
  { "Josee", 0.0 },
  { "Joseeduardo", 1.0 },
  { "Joseenrique", 1.0 },
  { "Josef", 1.0 },
  { "Josefa", 0.0 },
  { "Josefernando", 1.0 },
  { "Joseff", 1.0 },
  { "Josefina", 0.002652922 },
  { "Josefine", 0.0 },
  { "Josefita", 0.0 },
  { "Josefrancisco", 1.0 },
  { "Josegabriel", 1.0 },
  { "Joseguadalupe", 1.0 },
  { "Joseh", 1.0 },
  { "Josehine", 0.0 },
  { "Josehp", 1.0 },
  { "Josehua", 1.0 },
  { "Josei", 0.0 },
  { "Joseiah", 1.0 },
  { "Joseignacio", 1.0 },
  { "Josejavier", 1.0 },
  { "Josejesus", 1.0 },
  { "Josejr", 1.0 },
  { "Josejuan", 1.0 },
  { "Josejulian", 1.0 },
  { "Josel", 1.0 },
  { "Joselen", 0.0 },
  { "Joselene", 0.0 },
  { "Joselin", 0.0 },
  { "Joselina", 0.0 },
  { "Joseline", 0.0 },
  { "Joselinne", 0.0 },
  { "Joselito", 1.0 },
  { "Joselle", 0.0 },
  { "Josellyn", 0.0 },
  { "Joseluis", 1.0 },
  { "Joseluiz", 1.0 },
  { "Josely", 0.0 },
  { "Joselyn", 0.0003082994 },
  { "Joselyne", 0.0 },
  { "Joselynn", 0.0 },
  { "Joselynne", 0.0 },
  { "Josemanuel", 1.0 },
  { "Josemaria", 1.0 },
  { "Josemiguel", 1.0 },
  { "Josen", 1.0 },
  { "Josenid", 0.0 },
  { "Josep", 1.0 },
  { "Josepablo", 1.0 },
  { "Joseph", 0.9959212 },
  { "Josepha", 0.0 },
  { "Josephallen", 1.0 },
  { "Josephandrew", 1.0 },
  { "Josephanthony", 1.0 },
  { "Josephdaniel", 1.0 },
  { "Josephe", 1.0 },
  { "Josephene", 0.0 },
  { "Josephin", 0.0 },
  { "Josephina", 0.0 },
  { "Josephine", 0.0032608623 },
  { "Josephjames", 1.0 },
  { "Josephjohn", 1.0 },
  { "Josephlee", 1.0 },
  { "Josephmichael", 1.0 },
  { "Josephpatrick", 1.0 },
  { "Josephpaul", 1.0 },
  { "Josephthomas", 1.0 },
  { "Josephus", 1.0 },
  { "Josephy", 1.0 },
  { "Josephyne", 0.0 },
  { "Josepine", 0.0 },
  { "Josera", 0.0 },
  { "Joseramon", 1.0 },
  { "Josericardo", 1.0 },
  { "Joseroberto", 1.0 },
  { "Joses", 1.0 },
  { "Joset", 0.6875 },
  { "Joseth", 1.0 },
  { "Josett", 0.0 },
  { "Josetta", 0.0 },
  { "Josette", 0.0 },
  { "Josey", 0.24871717 },
  { "Josgar", 1.0 },
  { "Josgart", 1.0 },
  { "Josh", 1.0 },
  { "Josha", 0.938326 },
  { "Joshalyn", 0.0 },
  { "Joshalynn", 0.0 },
  { "Joshanae", 0.0 },
  { "Joshau", 1.0 },
  { "Joshaua", 1.0 },
  { "Joshaun", 1.0 },
  { "Joshawa", 1.0 },
  { "Joshawn", 1.0 },
  { "Joshelin", 0.0 },
  { "Joshelyn", 0.0 },
  { "Joshep", 1.0 },
  { "Josheph", 1.0 },
  { "Josheua", 1.0 },
  { "Joshewa", 1.0 },
  { "Joshia", 1.0 },
  { "Joshiah", 1.0 },
  { "Joshie", 0.0 },
  { "Joshika", 0.0 },
  { "Joshitha", 0.0 },
  { "Joshlin", 0.23333333 },
  { "Joshlyn", 0.004191115 },
  { "Joshlynn", 0.0 },
  { "Joshoa", 1.0 },
  { "Joshoua", 1.0 },
  { "Joshton", 1.0 },
  { "Joshu", 1.0 },
  { "Joshua", 0.9959106 },
  { "Joshuaa", 1.0 },
  { "Joshuaaaron", 1.0 },
  { "Joshuaalexander", 1.0 },
  { "Joshuaanthony", 1.0 },
  { "Joshuacaleb", 1.0 },
  { "Joshuadaniel", 1.0 },
  { "Joshuadavid", 1.0 },
  { "Joshuah", 1.0 },
  { "Joshuajames", 1.0 },
  { "Joshuajay", 1.0 },
  { "Joshuajohn", 1.0 },
  { "Joshuajoseph", 1.0 },
  { "Joshual", 1.0 },
  { "Joshualee", 1.0 },
  { "Joshuamichael", 1.0 },
  { "Joshuan", 1.0 },
  { "Joshuapaul", 1.0 },
  { "Joshuar", 1.0 },
  { "Joshuaray", 1.0 },
  { "Joshuarobert", 1.0 },
  { "Joshuaryan", 1.0 },
  { "Joshue", 1.0 },
  { "Joshuea", 1.0 },
  { "Joshuel", 1.0 },
  { "Joshuia", 1.0 },
  { "Joshula", 1.0 },
  { "Joshus", 1.0 },
  { "Joshusa", 1.0 },
  { "Joshuwa", 1.0 },
  { "Joshva", 1.0 },
  { "Joshwa", 1.0 },
  { "Joshya", 1.0 },
  { "Josi", 0.0 },
  { "Josia", 0.9579832 },
  { "Josiah", 0.9963208 },
  { "Josiaha", 1.0 },
  { "Josiahs", 1.0 },
  { "Josian", 1.0 },
  { "Josiana", 0.0 },
  { "Josiane", 0.0 },
  { "Josianna", 0.0 },
  { "Josianne", 0.0 },
  { "Josias", 1.0 },
  { "Josie", 0.008507209 },
  { "Josiel", 1.0 },
  { "Josielyn", 0.0 },
  { "Josielynn", 0.0 },
  { "Josiephene", 0.0 },
  { "Josiephine", 0.0 },
  { "Josif", 1.0 },
  { "Josiha", 1.0 },
  { "Josiiah", 1.0 },
  { "Josilin", 0.0 },
  { "Josilyn", 0.0 },
  { "Josilyne", 0.0 },
  { "Josilynn", 0.0 },
  { "Josimar", 1.0 },
  { "Josina", 0.0 },
  { "Josine", 0.0 },
  { "Josip", 1.0 },
  { "Josiphine", 0.0 },
  { "Josiya", 1.0 },
  { "Josiyah", 1.0 },
  { "Josje", 1.0 },
  { "Josjeph", 1.0 },
  { "Joskar", 1.0 },
  { "Joslen", 0.0 },
  { "Joslene", 0.0 },
  { "Joslin", 0.007751938 },
  { "Josline", 0.0 },
  { "Joslyn", 0.0028615228 },
  { "Joslyne", 0.0 },
  { "Joslynn", 0.0 },
  { "Joslynne", 0.0 },
  { "Josman", 1.0 },
  { "Josmar", 1.0 },
  { "Josmarie", 0.0 },
  { "Josmary", 0.0 },
  { "Josmel", 1.0 },
  { "Josmine", 0.0 },
  { "Josniel", 1.0 },
  { "Joson", 1.0 },
  { "Jospeh", 1.0 },
  { "Josph", 1.0 },
  { "Josphe", 1.0 },
  { "Josphine", 0.0 },
  { "Josphua", 1.0 },
  { "Joss", 0.62580645 },
  { "Jossalin", 0.0 },
  { "Jossalyn", 0.0 },
  { "Jossalynn", 0.0 },
  { "Josse", 1.0 },
  { "Josselin", 0.0 },
  { "Josseline", 0.0 },
  { "Josselyn", 0.0 },
  { "Josselyne", 0.0 },
  { "Josselynn", 0.0 },
  { "Jossette", 0.0 },
  { "Jossiah", 1.0 },
  { "Jossica", 0.0 },
  { "Jossie", 0.008555612 },
  { "Jossiel", 1.0 },
  { "Jossiephine", 0.0 },
  { "Jossilyn", 0.0 },
  { "Jossilynn", 0.0 },
  { "Jossimar", 1.0 },
  { "Josslin", 0.0 },
  { "Josslyn", 0.0 },
  { "Josslynn", 0.0 },
  { "Josslynne", 0.0 },
  { "Jossue", 1.0 },
  { "Jossy", 0.0 },
  { "Jostein", 1.0 },
  { "Josten", 1.0 },
  { "Jostin", 1.0 },
  { "Joston", 1.0 },
  { "Jostyn", 0.8 },
  { "Josua", 1.0 },
  { "Josuah", 1.0 },
  { "Josue", 0.9960184 },
  { "Josuel", 1.0 },
  { "Josuha", 1.0 },
  { "Josuhe", 1.0 },
  { "Josy", 0.0 },
  { "Josyah", 1.0 },
  { "Josyiah", 1.0 },
  { "Josylin", 0.0 },
  { "Josziah", 1.0 },
  { "Jotaro", 1.0 },
  { "Jotavious", 1.0 },
  { "Jotham", 1.0 },
  { "Jothan", 1.0 },
  { "Joua", 0.0 },
  { "Jouan", 1.0 },
  { "Jouanna", 0.0 },
  { "Joud", 0.35748792 },
  { "Jouette", 0.0 },
  { "Joule", 0.0 },
  { "Joules", 0.0 },
  { "Joumana", 0.0 },
  { "Jourdain", 0.82439023 },
  { "Jourdan", 0.43417084 },
  { "Jourden", 0.68773234 },
  { "Jourdin", 0.35682818 },
  { "Jourdon", 0.9 },
  { "Jourdyn", 0.1737931 },
  { "Jourdynn", 0.0 },
  { "Jouri", 0.0 },
  { "Journae", 0.0 },
  { "Journe", 0.0 },
  { "Journee", 0.00971942 },
  { "Journei", 0.0 },
  { "Journeigh", 0.0 },
  { "Journeii", 0.0 },
  { "Journey", 0.08640438 },
  { "Journi", 0.0 },
  { "Journie", 0.004765687 },
  { "Journiee", 0.0 },
  { "Journii", 0.0 },
  { "Journy", 0.0 },
  { "Journye", 0.0 },
  { "Joury", 0.0 },
  { "Jouse", 1.0 },
  { "Jousha", 1.0 },
  { "Joushua", 1.0 },
  { "Jovaan", 1.0 },
  { "Jovahn", 1.0 },
  { "Jovahni", 1.0 },
  { "Jovahny", 1.0 },
  { "Jovan", 0.89282876 },
  { "Jovana", 0.0 },
  { "Jovanah", 0.0 },
  { "Jovanda", 0.0 },
  { "Jovane", 1.0 },
  { "Jovani", 0.98157537 },
  { "Jovania", 0.0 },
  { "Jovanie", 0.97089946 },
  { "Jovaniel", 1.0 },
  { "Jovanii", 1.0 },
  { "Jovanka", 0.0 },
  { "Jovann", 0.9478261 },
  { "Jovanna", 0.0 },
  { "Jovannah", 0.0 },
  { "Jovanne", 0.68817204 },
  { "Jovanni", 0.9686558 },
  { "Jovannie", 0.96636087 },
  { "Jovanny", 0.9962782 },
  { "Jovanta", 1.0 },
  { "Jovantae", 1.0 },
  { "Jovante", 1.0 },
  { "Jovany", 0.99741787 },
  { "Jovar", 1.0 },
  { "Jovari", 1.0 },
  { "Jovaughn", 1.0 },
  { "Jovaun", 1.0 },
  { "Jovawn", 1.0 },
  { "Jove", 1.0 },
  { "Jovee", 0.0 },
  { "Jovel", 1.0 },
  { "Jovell", 1.0 },
  { "Joven", 1.0 },
  { "Jovetta", 0.0 },
  { "Jovette", 0.0 },
  { "Jovey", 0.0 },
  { "Jovi", 0.2794971 },
  { "Jovia", 0.0 },
  { "Jovial", 0.0 },
  { "Jovian", 0.98493975 },
  { "Joviana", 0.0 },
  { "Jovianna", 0.0 },
  { "Jovianne", 0.0 },
  { "Jovie", 0.0 },
  { "Jovienne", 0.0 },
  { "Jovin", 1.0 },
  { "Jovina", 0.0 },
  { "Jovita", 0.0015394088 },
  { "Jovohn", 1.0 },
  { "Jovon", 0.8973722 },
  { "Jovona", 0.0 },
  { "Jovonda", 0.0 },
  { "Jovone", 1.0 },
  { "Jovoni", 0.939759 },
  { "Jovonie", 1.0 },
  { "Jovonn", 0.8148148 },
  { "Jovonna", 0.0 },
  { "Jovonne", 0.13658537 },
  { "Jovonni", 1.0 },
  { "Jovonnie", 0.8235294 },
  { "Jovonny", 1.0 },
  { "Jovonta", 1.0 },
  { "Jovontae", 1.0 },
  { "Jovonte", 1.0 },
  { "Jowan", 1.0 },
  { "Jowana", 0.0 },
  { "Jowanda", 0.0 },
  { "Jowanna", 0.0 },
  { "Jowel", 1.0 },
  { "Jowell", 0.99226004 },
  { "Jowen", 1.0 },
  { "Jowharah", 0.0 },
  { "Joxiel", 1.0 },
  { "Joy", 0.018200545 },
  { "Joya", 0.0 },
  { "Joyace", 0.0 },
  { "Joyah", 0.0 },
  { "Joyal", 0.0 },
  { "Joyana", 0.0 },
  { "Joyann", 0.0 },
  { "Joyanna", 0.0 },
  { "Joyanne", 0.0 },
  { "Joyce", 0.005606791 },
  { "Joyceann", 0.0 },
  { "Joycee", 0.0 },
  { "Joycelene", 0.0 },
  { "Joycelin", 0.0 },
  { "Joyceline", 0.0 },
  { "Joycelyn", 0.0 },
  { "Joycelynn", 0.0 },
  { "Joycene", 0.0 },
  { "Joycie", 0.0 },
  { "Joyclyn", 0.0 },
  { "Joydan", 0.0 },
  { "Joyden", 0.5 },
  { "Joye", 0.0023249055 },
  { "Joyee", 0.0 },
  { "Joyel", 0.0 },
  { "Joyell", 0.0 },
  { "Joyelle", 0.0 },
  { "Joyetta", 0.0 },
  { "Joyette", 0.0 },
  { "Joyful", 0.0 },
  { "Joyia", 0.0 },
  { "Joyice", 0.0 },
  { "Joyl", 0.0 },
  { "Joyleen", 0.0 },
  { "Joylene", 0.0 },
  { "Joylin", 0.0 },
  { "Joylyn", 0.0 },
  { "Joylynn", 0.0 },
  { "Joylynne", 0.0 },
  { "Joymarie", 0.0 },
  { "Joynae", 0.0 },
  { "Joynell", 0.0 },
  { "Joyner", 1.0 },
  { "Joyous", 0.0 },
  { "Joyse", 0.0 },
  { "Joyzelle", 0.0 },
  { "Jozaiah", 1.0 },
  { "Jozalyn", 0.0 },
  { "Jozalynn", 0.0 },
  { "Jozee", 0.0 },
  { "Jozef", 1.0 },
  { "Jozefa", 0.0 },
  { "Jozelle", 0.0 },
  { "Jozelyn", 0.0 },
  { "Jozelynn", 0.0 },
  { "Jozeph", 1.0 },
  { "Jozephine", 0.0 },
  { "Jozett", 0.0 },
  { "Jozetta", 0.0 },
  { "Jozette", 0.0 },
  { "Jozey", 0.0 },
  { "Jozi", 0.0 },
  { "Joziah", 0.9981189 },
  { "Jozie", 0.0 },
  { "Joziel", 1.0 },
  { "Jozilyn", 0.0 },
  { "Joziyah", 1.0 },
  { "Jozlin", 0.0 },
  { "Jozlyn", 0.0 },
  { "Jozlyne", 0.0 },
  { "Jozlynn", 0.0 },
  { "Jozlynne", 0.0 },
  { "Jozsef", 1.0 },
  { "Jozy", 0.13333334 },
  { "Jozyah", 1.0 },
  { "Jozzlynn", 0.0 },
  { "Jp", 1.0 },
  { "Jquan", 1.0 },
  { "Jqwon", 1.0 },
  { "Jr", 1.0 },
  { "Jrake", 1.0 },
  { "Jraya", 0.0 },
  { "Jrayden", 1.0 },
  { "Jream", 0.18421052 },
  { "Jrew", 1.0 },
  { "Jron", 1.0 },
  { "Jru", 0.8269231 },
  { "Jrue", 0.85714287 },
  { "Jsai", 1.0 },
  { "Jsamine", 0.0 },
  { "Jsaon", 1.0 },
  { "Jsean", 1.0 },
  { "Jshaun", 1.0 },
  { "Jshawn", 1.0 },
  { "Jshin", 1.0 },
  { "Jshon", 1.0 },
  { "Jshun", 1.0 },
  { "Jsiah", 1.0 },
  { "Jsoeph", 1.0 },
  { "Json", 1.0 },
  { "Jssica", 0.0 },
  { "Jsutin", 1.0 },
  { "Jt", 1.0 },
  { "Ju", 0.33333334 },
  { "Jua", 1.0 },
  { "Juaita", 0.0 },
  { "Jual", 1.0 },
  { "Juan", 0.9920682 },
  { "Juana", 0.005053986 },
  { "Juanalberto", 1.0 },
  { "Juanandres", 1.0 },
  { "Juanangel", 1.0 },
  { "Juanantonio", 1.0 },
  { "Juancarlo", 1.0 },
  { "Juancarlos", 1.0 },
  { "Juanda", 0.0 },
  { "Juandalynn", 0.0 },
  { "Juandaniel", 1.0 },
  { "Juandavid", 1.0 },
  { "Juandedios", 1.0 },
  { "Juandiego", 1.0 },
  { "Juane", 1.0 },
  { "Juanell", 0.0 },
  { "Juanelle", 0.0 },
  { "Juanenrique", 1.0 },
  { "Juanesha", 0.0 },
  { "Juanesteban", 1.0 },
  { "Juanetta", 0.0 },
  { "Juanette", 0.0 },
  { "Juanfelipe", 1.0 },
  { "Juanfernando", 1.0 },
  { "Juanfrancisco", 1.0 },
  { "Juanice", 0.0 },
  { "Juanika", 0.0 },
  { "Juaniqua", 0.0 },
  { "Juanisha", 0.0 },
  { "Juanita", 0.0047642626 },
  { "Juanito", 0.99526966 },
  { "Juanitta", 0.0 },
  { "Juanjesus", 1.0 },
  { "Juanjose", 1.0 },
  { "Juanjr", 1.0 },
  { "Juanluis", 1.0 },
  { "Juanmanuel", 1.0 },
  { "Juanmarcos", 1.0 },
  { "Juanmartin", 1.0 },
  { "Juanmiguel", 1.0 },
  { "Juanna", 0.0 },
  { "Juanpablo", 1.0 },
  { "Juanpedro", 1.0 },
  { "Juanramon", 1.0 },
  { "Juansebastian", 1.0 },
  { "Juante", 1.0 },
  { "Juantia", 0.0 },
  { "Juany", 0.0 },
  { "Juanya", 1.0 },
  { "Juanyae", 1.0 },
  { "Juanye", 1.0 },
  { "Juaquin", 1.0 },
  { "Juaquina", 0.0 },
  { "Juarez", 1.0 },
  { "Juaria", 0.0 },
  { "Juawan", 1.0 },
  { "Juawana", 0.0 },
  { "Juba", 1.0 },
  { "Jubal", 1.0 },
  { "Jubei", 1.0 },
  { "Jubentino", 1.0 },
  { "Jubilee", 0.002948403 },
  { "Jubril", 1.0 },
  { "Jud", 1.0 },
  { "Juda", 0.6138107 },
  { "Judaea", 0.0 },
  { "Judah", 0.9732488 },
  { "Judaline", 0.0 },
  { "Judalon", 0.0 },
  { "Judas", 1.0 },
  { "Judd", 1.0 },
  { "Juddie", 0.4074074 },
  { "Juddson", 1.0 },
  { "Jude", 0.94298375 },
  { "Judea", 0.23414634 },
  { "Judeah", 0.0 },
  { "Judean", 0.0 },
  { "Judee", 0.0 },
  { "Judeen", 0.0 },
  { "Judell", 0.0 },
  { "Juden", 1.0 },
  { "Judene", 0.0 },
  { "Judeth", 0.0 },
  { "Judette", 0.0 },
  { "Judey", 0.0 },
  { "Judge", 1.0 },
  { "Judi", 0.0 },
  { "Judia", 0.0 },
  { "Judiah", 1.0 },
  { "Judiann", 0.0 },
  { "Judianne", 0.0 },
  { "Judie", 0.0 },
  { "Judiel", 1.0 },
  { "Judieth", 0.0 },
  { "Judilyn", 0.0 },
  { "Judilynn", 0.0 },
  { "Judine", 0.0 },
  { "Judit", 0.0 },
  { "Judite", 0.0 },
  { "Judith", 0.0027390972 },
  { "Judithann", 0.0 },
  { "Judithanne", 0.0 },
  { "Judithe", 0.0 },
  { "Judon", 1.0 },
  { "Judsen", 1.0 },
  { "Judson", 1.0 },
  { "Judtih", 0.0 },
  { "Judy", 0.0028572474 },
  { "Judyann", 0.0 },
  { "Judye", 0.0 },
  { "Judylynn", 0.0 },
  { "Judyne", 0.0 },
  { "Judyth", 0.0 },
  { "Judythe", 0.0 },
  { "Juel", 0.55813956 },
  { "Juelene", 0.0 },
  { "Juelez", 1.0 },
  { "Juelian", 1.0 },
  { "Juell", 0.8333333 },
  { "Juella", 0.0 },
  { "Juelle", 0.23188406 },
  { "Juellz", 1.0 },
  { "Juels", 1.0 },
  { "Juelz", 0.9560895 },
  { "Juelze", 1.0 },
  { "Juergen", 1.0 },
  { "Jugraj", 1.0 },
  { "Juhee", 0.0 },
  { "Juhi", 0.0 },
  { "Juila", 0.0 },
  { "Juile", 0.0 },
  { "Juiliana", 0.0 },
  { "Juilianna", 0.0 },
  { "Juilo", 1.0 },
  { "Jujhar", 1.0 },
  { "Jujuan", 0.98891354 },
  { "Jula", 0.0 },
  { "Julain", 1.0 },
  { "Julaine", 0.0 },
  { "Julana", 0.0 },
  { "Julane", 0.0 },
  { "Julani", 0.7368421 },
  { "Julann", 0.0 },
  { "Julanne", 0.0 },
  { "Julayne", 0.0 },
  { "Jule", 0.4128495 },
  { "Julea", 0.0 },
  { "Juleah", 0.0 },
  { "Julean", 1.0 },
  { "Juleana", 0.0 },
  { "Juleanna", 0.0 },
  { "Julee", 0.0 },
  { "Juleeanna", 0.0 },
  { "Juleen", 0.0 },
  { "Juleena", 0.0 },
  { "Juleesa", 0.0 },
  { "Juleidy", 0.0 },
  { "Juleigh", 0.0 },
  { "Juleimy", 0.0 },
  { "Julein", 1.0 },
  { "Juleisy", 0.0 },
  { "Julen", 1.0 },
  { "Julena", 0.0 },
  { "Julene", 0.0 },
  { "Julenny", 0.0 },
  { "Juleny", 0.0 },
  { "Juleon", 1.0 },
  { "Julep", 0.0 },
  { "Jules", 0.8710344 },
  { "Julessa", 0.0 },
  { "Juletta", 0.0 },
  { "Julette", 0.0 },
  { "Juleus", 1.0 },
  { "Juley", 0.0 },
  { "Julez", 0.90756303 },
  { "Juli", 0.0 },
  { "Julia", 0.0038121426 },
  { "Juliaann", 0.0 },
  { "Juliaanne", 0.0 },
  { "Juliaette", 0.0 },
  { "Juliagrace", 0.0 },
  { "Juliah", 0.0 },
  { "Juliahna", 0.0 },
  { "Juliahnna", 0.0 },
  { "Juliam", 1.0 },
  { "Juliamae", 0.0 },
  { "Juliamarie", 0.0 },
  { "Julian", 0.98453176 },
  { "Juliana", 0.00090399233 },
  { "Julianah", 0.0 },
  { "Juliane", 0.0 },
  { "Juliani", 0.2761194 },
  { "Julianie", 0.0 },
  { "Julianis", 0.0 },
  { "Julianita", 0.0 },
  { "Juliann", 0.004217687 },
  { "Julianna", 0.0006153118 },
  { "Juliannah", 0.0 },
  { "Juliannamarie", 0.0 },
  { "Julianne", 0.0 },
  { "Julianni", 0.1388889 },
  { "Juliannie", 0.0 },
  { "Julianno", 1.0 },
  { "Julianny", 0.0 },
  { "Juliano", 1.0 },
  { "Juliany", 0.0 },
  { "Julianys", 0.0 },
  { "Juliarose", 0.0 },
  { "Julias", 1.0 },
  { "Juliauna", 0.0 },
  { "Juliaunna", 0.0 },
  { "Julibeth", 0.0 },
  { "Julica", 0.0 },
  { "Julice", 1.0 },
  { "Julicia", 0.0 },
  { "Julie", 0.0029955243 },
  { "Juliea", 0.0 },
  { "Juliean", 1.0 },
  { "Julieana", 0.0 },
  { "Julieann", 0.0 },
  { "Julieanna", 0.0 },
  { "Julieanne", 0.0 },
  { "Juliella", 0.0 },
  { "Juliemarie", 0.0 },
  { "Julien", 0.981948 },
  { "Juliena", 0.0 },
  { "Juliene", 0.0 },
  { "Julienn", 1.0 },
  { "Julienna", 0.0 },
  { "Julienne", 0.012403101 },
  { "Julieonna", 0.0 },
  { "Julies", 1.0 },
  { "Juliessa", 0.0 },
  { "Juliet", 0.0 },
  { "Julieta", 0.0 },
  { "Juliete", 0.0 },
  { "Julieth", 0.0 },
  { "Juliett", 0.0 },
  { "Julietta", 0.0 },
  { "Juliette", 0.0 },
  { "Julieza", 0.0 },
  { "Julin", 0.0 },
  { "Julina", 0.0 },
  { "Julinda", 0.0 },
  { "Juline", 0.0 },
  { "Julio", 0.9929132 },
  { "Julioalberto", 1.0 },
  { "Juliocesar", 1.0 },
  { "Julion", 1.0 },
  { "Juliona", 0.0 },
  { "Julionna", 0.0 },
  { "Julious", 1.0 },
  { "Julis", 0.9778761 },
  { "Julisa", 0.0 },
  { "Julisha", 0.0 },
  { "Julisia", 0.0 },
  { "Julissa", 0.00047911494 },
  { "Julissia", 0.0 },
  { "Julita", 0.0 },
  { "Julitsa", 0.0 },
  { "Julitta", 0.0 },
  { "Julitza", 0.0 },
  { "Juliun", 1.0 },
  { "Julius", 0.99465287 },
  { "Juliuz", 1.0 },
  { "Julivette", 0.0 },
  { "Julixa", 0.0 },
  { "Juliya", 0.0 },
  { "Juliyah", 0.0 },
  { "Juliyan", 1.0 },
  { "Juliyana", 0.0 },
  { "Juliyanna", 0.0 },
  { "Juliza", 0.0 },
  { "Julizza", 0.0 },
  { "Jull", 0.0 },
  { "Jullia", 0.0 },
  { "Jullian", 0.7221571 },
  { "Julliana", 0.0 },
  { "Jullianna", 0.0 },
  { "Jullianne", 0.0 },
  { "Jullie", 0.0 },
  { "Jullien", 1.0 },
  { "Julliet", 0.0 },
  { "Julliette", 0.0 },
  { "Jullisa", 0.0 },
  { "Jullissa", 0.0 },
  { "Jullius", 1.0 },
  { "Jully", 0.0 },
  { "Julonda", 0.0 },
  { "Juluis", 1.0 },
  { "Julus", 1.0 },
  { "July", 0.18802395 },
  { "Julya", 0.0 },
  { "Julyan", 1.0 },
  { "Julyana", 0.0 },
  { "Julyanna", 0.0 },
  { "Julye", 0.0 },
  { "Julyen", 1.0 },
  { "Julyn", 0.0 },
  { "Julynn", 0.0 },
  { "Julysa", 0.0 },
  { "Julyssa", 0.0 },
  { "Juma", 1.0 },
  { "Jumaane", 1.0 },
  { "Jumah", 1.0 },
  { "Jumal", 1.0 },
  { "Jumalay", 0.0 },
  { "Juman", 0.0 },
  { "Jumana", 0.0 },
  { "Jumanah", 0.0 },
  { "Jumanji", 1.0 },
  { "Jumanne", 1.0 },
  { "Jumar", 1.0 },
  { "Jumarcus", 1.0 },
  { "Jumari", 1.0 },
  { "Jumarion", 1.0 },
  { "Jumel", 1.0 },
  { "Jumoke", 1.0 },
  { "Jun", 0.9239216 },
  { "Juna", 0.007575758 },
  { "Junae", 0.0 },
  { "Junah", 0.9189189 },
  { "Junaid", 1.0 },
  { "Junathaen", 1.0 },
  { "Junathean", 1.0 },
  { "Junayd", 1.0 },
  { "June", 0.016569914 },
  { "Junea", 0.0 },
  { "Juneann", 0.0 },
  { "Juneau", 0.125 },
  { "Junell", 0.0 },
  { "Junella", 0.0 },
  { "Junelle", 0.0 },
  { "Junellen", 0.0 },
  { "Junerose", 0.0 },
  { "Junetta", 0.0 },
  { "Junette", 0.0 },
  { "Juneve", 0.0 },
  { "Jung", 0.503268 },
  { "Jungwoo", 1.0 },
  { "Junhao", 1.0 },
  { "Junhee", 1.0 },
  { "Junho", 1.0 },
  { "Juni", 0.2 },
  { "Junia", 0.0 },
  { "Juniah", 0.0 },
  { "Juniata", 0.0 },
  { "Junice", 0.0 },
  { "Junichi", 1.0 },
  { "Junie", 0.10884831 },
  { "Juniel", 1.0 },
  { "Junies", 1.0 },
  { "Junietta", 0.0 },
  { "Junilla", 0.0 },
  { "Junior", 0.99515396 },
  { "Junious", 1.0 },
  { "Juniper", 0.009232155 },
  { "Junis", 0.627451 },
  { "Junita", 0.0 },
  { "Junito", 1.0 },
  { "Junius", 1.0 },
  { "Juniya", 0.0 },
  { "Juniyah", 0.0 },
  { "Junjie", 1.0 },
  { "Junko", 0.0 },
  { "Junming", 1.0 },
  { "Junne", 0.0 },
  { "Junnie", 0.13402061 },
  { "Juno", 0.21031208 },
  { "Junor", 1.0 },
  { "Junot", 1.0 },
  { "Junpei", 1.0 },
  { "Junuis", 1.0 },
  { "Junus", 1.0 },
  { "Junxi", 1.0 },
  { "Juny", 1.0 },
  { "Junya", 0.0 },
  { "Junyi", 1.0 },
  { "Junyu", 1.0 },
  { "Junzhe", 1.0 },
  { "Jupiter", 0.5448276 },
  { "Juquan", 1.0 },
  { "Juquana", 0.0 },
  { "Jura", 0.0 },
  { "Jurany", 0.0 },
  { "Jurate", 0.0 },
  { "Jurea", 0.0 },
  { "Jurel", 1.0 },
  { "Jurell", 0.9652778 },
  { "Jurem", 1.0 },
  { "Jurene", 0.0 },
  { "Juretta", 0.0 },
  { "Jurgen", 1.0 },
  { "Juri", 0.03787879 },
  { "Juriah", 1.0 },
  { "Jurian", 1.0 },
  { "Juriana", 0.0 },
  { "Juridia", 0.0 },
  { "Jurie", 0.0 },
  { "Juriel", 1.0 },
  { "Juris", 1.0 },
  { "Jurita", 0.0 },
  { "Juritza", 0.0 },
  { "Jurlean", 0.0 },
  { "Jurlene", 0.0 },
  { "Jurline", 0.0 },
  { "Jurnee", 0.0025454545 },
  { "Jurnei", 0.0 },
  { "Jurney", 0.027777778 },
  { "Jurni", 0.0 },
  { "Jurnie", 0.0 },
  { "Jurnii", 0.0 },
  { "Juron", 1.0 },
  { "Jurrell", 1.0 },
  { "Jurrien", 1.0 },
  { "Jury", 0.05357143 },
  { "Jushawn", 1.0 },
  { "Jushua", 1.0 },
  { "Jusiah", 1.0 },
  { "Jusin", 1.0 },
  { "Jusitn", 1.0 },
  { "Jussiah", 1.0 },
  { "Jussica", 0.0 },
  { "Justa", 0.0 },
  { "Justain", 1.0 },
  { "Justan", 1.0 },
  { "Justas", 1.0 },
  { "Justeen", 0.0 },
  { "Justeena", 0.0 },
  { "Justen", 0.9987345 },
  { "Justene", 0.0 },
  { "Justess", 0.0 },
  { "Justhin", 1.0 },
  { "Justi", 0.22727273 },
  { "Justian", 1.0 },
  { "Justic", 1.0 },
  { "Justice", 0.52253103 },
  { "Justien", 0.0 },
  { "Justilia", 0.0 },
  { "Justin", 0.99510014 },
  { "Justina", 0.000507872 },
  { "Justinanthony", 1.0 },
  { "Justine", 0.05990519 },
  { "Justinia", 0.0 },
  { "Justinian", 1.0 },
  { "Justiniano", 1.0 },
  { "Justinjames", 1.0 },
  { "Justinkyle", 1.0 },
  { "Justinlee", 1.0 },
  { "Justinmichael", 1.0 },
  { "Justinn", 1.0 },
  { "Justinne", 0.0 },
  { "Justino", 1.0 },
  { "Justinpaul", 1.0 },
  { "Justinray", 1.0 },
  { "Justinrobert", 1.0 },
  { "Justinryan", 1.0 },
  { "Justinthomas", 1.0 },
  { "Justion", 1.0 },
  { "Justis", 0.77654254 },
  { "Justise", 0.2112676 },
  { "Justiss", 0.11320755 },
  { "Justiz", 1.0 },
  { "Justn", 1.0 },
  { "Justo", 1.0 },
  { "Juston", 1.0 },
  { "Justun", 1.0 },
  { "Justus", 0.9191185 },
  { "Justy", 0.0 },
  { "Justyce", 0.20612583 },
  { "Justyn", 0.9647985 },
  { "Justyna", 0.0 },
  { "Justyne", 0.0 },
  { "Justys", 1.0 },
  { "Justyse", 0.0 },
  { "Jusuf", 1.0 },
  { "Jusus", 1.0 },
  { "Jutin", 1.0 },
  { "Jutta", 0.0 },
  { "Juvenal", 1.0 },
  { "Juvencio", 1.0 },
  { "Juvens", 1.0 },
  { "Juventina", 0.0 },
  { "Juventino", 1.0 },
  { "Juvia", 0.0 },
  { "Juvon", 1.0 },
  { "Juvonte", 1.0 },
  { "Juwaan", 1.0 },
  { "Juwahn", 1.0 },
  { "Juwairiyah", 0.0 },
  { "Juwan", 0.99721605 },
  { "Juwana", 0.0 },
  { "Juwanda", 0.0 },
  { "Juwann", 1.0 },
  { "Juwanna", 0.0 },
  { "Juwaun", 1.0 },
  { "Juwayria", 0.0 },
  { "Juwayriya", 0.0 },
  { "Juwel", 1.0 },
  { "Juwell", 1.0 },
  { "Juwelz", 1.0 },
  { "Juwon", 1.0 },
  { "Juwuan", 1.0 },
  { "Juyne", 0.0 },
  { "Juztin", 1.0 },
  { "Jvante", 1.0 },
  { "Jvaughn", 1.0 },
  { "Jven", 1.0 },
  { "Jveon", 1.0 },
  { "Jvian", 1.0 },
  { "Jvier", 1.0 },
  { "Jvion", 1.0 },
  { "Jvon", 1.0 },
  { "Jvonn", 1.0 },
  { "Jvonne", 1.0 },
  { "Jvontae", 1.0 },
  { "Jvonte", 1.0 },
  { "Jw", 1.0 },
  { "Jwan", 0.8143712 },
  { "Jwana", 0.0 },
  { "Jwaun", 1.0 },
  { "Jwon", 1.0 },
  { "Jwuan", 1.0 },
  { "Jwyanza", 1.0 },
  { "Jya", 0.0 },
  { "Jyah", 0.0 },
  { "Jyair", 1.0 },
  { "Jyaire", 1.0 },
  { "Jyana", 0.0 },
  { "Jyanna", 0.0 },
  { "Jyasia", 0.0 },
  { "Jyden", 1.0 },
  { "Jye", 1.0 },
  { "Jyelle", 0.0 },
  { "Jyena", 0.0 },
  { "Jyheem", 1.0 },
  { "Jyheim", 1.0 },
  { "Jyhiem", 1.0 },
  { "Jyia", 0.0 },
  { "Jyiah", 0.0 },
  { "Jyion", 1.0 },
  { "Jykeria", 0.0 },
  { "Jyl", 0.0 },
  { "Jyla", 0.0 },
  { "Jylan", 1.0 },
  { "Jylen", 1.0 },
  { "Jylene", 0.0 },
  { "Jyler", 1.0 },
  { "Jyles", 1.0 },
  { "Jylian", 0.0 },
  { "Jylin", 1.0 },
  { "Jylisa", 0.0 },
  { "Jylissa", 0.0 },
  { "Jyll", 0.0 },
  { "Jyllian", 0.0 },
  { "Jylon", 1.0 },
  { "Jymari", 1.0 },
  { "Jyme", 0.0 },
  { "Jymere", 1.0 },
  { "Jymir", 1.0 },
  { "Jymme", 0.0 },
  { "Jymon", 1.0 },
  { "Jynae", 0.0 },
  { "Jynell", 0.0 },
  { "Jynelle", 0.0 },
  { "Jynesis", 0.0 },
  { "Jynessa", 0.0 },
  { "Jynia", 0.0 },
  { "Jyniah", 0.0 },
  { "Jynna", 0.0 },
  { "Jyon", 1.0 },
  { "Jyonna", 0.0 },
  { "Jyoti", 0.0 },
  { "Jyotsna", 0.0 },
  { "Jyquan", 1.0 },
  { "Jyquavious", 1.0 },
  { "Jyquez", 1.0 },
  { "Jyra", 0.0 },
  { "Jyrah", 0.0 },
  { "Jyran", 1.0 },
  { "Jyree", 1.0 },
  { "Jyrell", 1.0 },
  { "Jyrelle", 1.0 },
  { "Jyren", 1.0 },
  { "Jyrese", 1.0 },
  { "Jyrin", 1.0 },
  { "Jyrine", 1.0 },
  { "Jyron", 1.0 },
  { "Jysaiah", 1.0 },
  { "Jyselle", 0.0 },
  { "Jyshaun", 1.0 },
  { "Jyshawn", 1.0 },
  { "Jyshon", 1.0 },
  { "Jysiah", 1.0 },
  { "Jysir", 1.0 },
  { "Jyson", 1.0 },
  { "Jyssica", 0.0 },
  { "Jyvon", 1.0 },
  { "Jywon", 1.0 },
  { "Jyzaiah", 1.0 },
  { "Jyzelle", 0.0 },
  { "Jzabehl", 0.0 },
  { "Jziah", 1.0 },
  { "Jzon", 1.0 },
  { "Ka", 0.14364035 },
  { "Kaaden", 1.0 },
  { "Kaajal", 0.0 },
  { "Kaala", 0.0 },
  { "Kaaliyah", 0.0 },
  { "Kaalyn", 0.0 },
  { "Kaamil", 1.0 },
  { "Kaamilah", 0.0 },
  { "Kaamilya", 0.0 },
  { "Kaan", 1.0 },
  { "Kaara", 0.0 },
  { "Kaaran", 0.0 },
  { "Kaare", 1.0 },
  { "Kaaren", 0.0 },
  { "Kaari", 0.0 },
  { "Kaarin", 0.0 },
  { "Kaarina", 0.0 },
  { "Kaarlo", 1.0 },
  { "Kaaron", 0.0 },
  { "Kaashif", 1.0 },
  { "Kaashvi", 0.0 },
  { "Kaavya", 0.0 },
  { "Kaaya", 0.0 },
  { "Kaayla", 0.0 },
  { "Kabao", 0.0 },
  { "Kabe", 1.0 },
  { "Kabeer", 1.0 },
  { "Kabel", 1.0 },
  { "Kabella", 0.0 },
  { "Kaben", 1.0 },
  { "Kabir", 1.0 },
  { "Kable", 1.0 },
  { "Kabrea", 0.0 },
  { "Kabree", 0.0 },
  { "Kabren", 1.0 },
  { "Kabresha", 0.0 },
  { "Kabreyia", 0.0 },
  { "Kabri", 0.0 },
  { "Kabria", 0.0 },
  { "Kabriel", 1.0 },
  { "Kabrina", 0.0 },
  { "Kabron", 1.0 },
  { "Kabryn", 1.0 },
  { "Kace", 0.98029554 },
  { "Kacee", 0.08885942 },
  { "Kacei", 0.0 },
  { "Kacelyn", 0.0 },
  { "Kacelynn", 0.0 },
  { "Kacen", 1.0 },
  { "Kaceon", 1.0 },
  { "Kaceson", 1.0 },
  { "Kaceton", 1.0 },
  { "Kacey", 0.16083688 },
  { "Kaceyon", 1.0 },
  { "Kache", 0.56153846 },
  { "Kachelle", 0.0 },
  { "Kachet", 0.0 },
  { "Kachina", 0.0 },
  { "Kachiri", 0.0 },
  { "Kaci", 0.009093934 },
  { "Kacia", 0.0 },
  { "Kacie", 0.0026956447 },
  { "Kacin", 1.0 },
  { "Kacper", 1.0 },
  { "Kacy", 0.15968858 },
  { "Kacyn", 0.6910569 },
  { "Kada", 0.0 },
  { "Kadaija", 0.0 },
  { "Kadaisha", 0.0 },
  { "Kadaja", 0.0 },
  { "Kadajah", 0.0 },
  { "Kadan", 0.98419863 },
  { "Kadance", 0.021437578 },
  { "Kadar", 1.0 },
  { "Kadari", 1.0 },
  { "Kadarian", 1.0 },
  { "Kadarion", 1.0 },
  { "Kadarious", 1.0 },
  { "Kadarius", 1.0 },
  { "Kadarrius", 1.0 },
  { "Kadasha", 0.0 },
  { "Kadashia", 0.0 },
  { "Kadasia", 0.0 },
  { "Kadavion", 1.0 },
  { "Kadaysha", 0.0 },
  { "Kadaysia", 0.0 },
  { "Kadden", 1.0 },
  { "Kaddie", 0.0 },
  { "Kaddy", 0.0 },
  { "Kade", 0.9881826 },
  { "Kadean", 1.0 },
  { "Kadedra", 0.0 },
  { "Kadedria", 0.0 },
  { "Kadee", 0.0 },
  { "Kadeedra", 0.0 },
  { "Kadeeja", 0.0 },
  { "Kadeejah", 0.0 },
  { "Kadeem", 1.0 },
  { "Kadeen", 1.0 },
  { "Kadeesha", 0.0 },
  { "Kadeidra", 0.0 },
  { "Kadeidre", 0.0 },
  { "Kadeija", 0.0 },
  { "Kadeijah", 0.0 },
  { "Kadein", 1.0 },
  { "Kadeisha", 0.0 },
  { "Kadeja", 0.0 },
  { "Kadejah", 0.0 },
  { "Kadejha", 0.0 },
  { "Kadejia", 0.0 },
  { "Kadejiah", 0.0 },
  { "Kadel", 1.0 },
  { "Kadell", 1.0 },
  { "Kadelyn", 0.0 },
  { "Kaden", 0.982328 },
  { "Kadence", 0.08114056 },
  { "Kadenn", 1.0 },
  { "Kadenze", 0.0 },
  { "Kader", 1.0 },
  { "Kadera", 0.0 },
  { "Kaderius", 1.0 },
  { "Kadesh", 1.0 },
  { "Kadesha", 0.0 },
  { "Kadeshia", 0.0 },
  { "Kadesia", 0.0 },
  { "Kadetra", 0.0 },
  { "Kadetria", 0.0 },
  { "Kadey", 0.0 },
  { "Kadeyn", 1.0 },
  { "Kadezha", 0.0 },
  { "Kadezia", 0.0 },
  { "Kadi", 0.0 },
  { "Kadia", 0.0 },
  { "Kadian", 0.33587787 },
  { "Kadiatou", 0.0 },
  { "Kadiatu", 0.0 },
  { "Kadidia", 0.0 },
  { "Kadidiatou", 0.0 },
  { "Kadidja", 0.0 },
  { "Kadidra", 0.0 },
  { "Kadie", 0.0 },
  { "Kadiedra", 0.0 },
  { "Kadien", 1.0 },
  { "Kadience", 0.0 },
  { "Kadiesha", 0.0 },
  { "Kadija", 0.0 },
  { "Kadijah", 0.0 },
  { "Kadijatou", 0.0 },
  { "Kadijatu", 0.0 },
  { "Kadijha", 0.0 },
  { "Kadin", 0.9639895 },
  { "Kadince", 0.0 },
  { "Kadir", 1.0 },
  { "Kadira", 0.0 },
  { "Kadis", 1.0 },
  { "Kadisha", 0.0 },
  { "Kadison", 0.42857143 },
  { "Kadjah", 0.0 },
  { "Kadmiel", 1.0 },
  { "Kado", 1.0 },
  { "Kadon", 1.0 },
  { "Kadra", 0.0 },
  { "Kadraya", 0.0 },
  { "Kadren", 1.0 },
  { "Kadri", 0.61538464 },
  { "Kadria", 0.0 },
  { "Kadrian", 0.9632107 },
  { "Kadriana", 0.0 },
  { "Kadrianna", 0.0 },
  { "Kadrien", 1.0 },
  { "Kady", 0.0 },
  { "Kadyn", 0.6759329 },
  { "Kadynce", 0.007151371 },
  { "Kadynn", 0.18309858 },
  { "Kae", 0.0 },
  { "Kaebri", 0.0 },
  { "Kaecyn", 1.0 },
  { "Kaed", 1.0 },
  { "Kaeda", 0.0 },
  { "Kaedan", 0.9848024 },
  { "Kaedance", 0.0 },
  { "Kaede", 0.15486726 },
  { "Kaeden", 0.9626124 },
  { "Kaedence", 0.026970955 },
  { "Kaedin", 0.98571426 },
  { "Kaedn", 1.0 },
  { "Kaedon", 1.0 },
  { "Kaedyn", 0.6451807 },
  { "Kaedynce", 0.0 },
  { "Kaedynn", 0.23809524 },
  { "Kaegan", 0.64028776 },
  { "Kaegen", 1.0 },
  { "Kaeisha", 0.0 },
  { "Kael", 0.99476266 },
  { "Kaela", 0.0 },
  { "Kaelah", 0.0 },
  { "Kaelan", 0.76807404 },
  { "Kaelana", 0.0 },
  { "Kaelani", 0.0 },
  { "Kaele", 0.0 },
  { "Kaelea", 0.0 },
  { "Kaeleah", 0.0 },
  { "Kaeleb", 1.0 },
  { "Kaelee", 0.0 },
  { "Kaeleen", 0.0 },
  { "Kaelei", 0.0 },
  { "Kaeleigh", 0.0 },
  { "Kaelem", 1.0 },
  { "Kaelen", 0.6468717 },
  { "Kaelene", 0.0 },
  { "Kaeley", 0.0 },
  { "Kaeli", 0.0 },
  { "Kaelia", 0.0 },
  { "Kaeliana", 0.0 },
  { "Kaelib", 1.0 },
  { "Kaelie", 0.0 },
  { "Kaeliegh", 0.0 },
  { "Kaelin", 0.24363425 },
  { "Kaella", 0.0 },
  { "Kaelly", 0.0 },
  { "Kaelob", 1.0 },
  { "Kaelon", 1.0 },
  { "Kaeloni", 0.0 },
  { "Kaelub", 1.0 },
  { "Kaelum", 1.0 },
  { "Kaely", 0.0 },
  { "Kaelyb", 1.0 },
  { "Kaelyn", 0.005568412 },
  { "Kaelyne", 0.0 },
  { "Kaelynn", 0.0 },
  { "Kaelynne", 0.0 },
  { "Kaeman", 1.0 },
  { "Kaemen", 1.0 },
  { "Kaemon", 1.0 },
  { "Kaen", 1.0 },
  { "Kaena", 0.20224719 },
  { "Kaenan", 1.0 },
  { "Kaenon", 1.0 },
  { "Kaeo", 1.0 },
  { "Kaeon", 1.0 },
  { "Kaeron", 1.0 },
  { "Kaery", 0.0 },
  { "Kaesen", 1.0 },
  { "Kaesha", 0.0 },
  { "Kaeshawn", 1.0 },
  { "Kaeshon", 1.0 },
  { "Kaesin", 1.0 },
  { "Kaeson", 1.0 },
  { "Kaeston", 1.0 },
  { "Kaesyn", 0.8224852 },
  { "Kaethe", 0.0 },
  { "Kaetlin", 0.0 },
  { "Kaetlyn", 0.0 },
  { "Kaetlynn", 0.0 },
  { "Kaeto", 1.0 },
  { "Kaeveon", 1.0 },
  { "Kaevion", 1.0 },
  { "Kaevon", 1.0 },
  { "Kaeya", 0.0 },
  { "Kaeyla", 0.0 },
  { "Kaffie", 0.0 },
  { "Kafi", 0.0 },
  { "Kagan", 0.8862928 },
  { "Kage", 1.0 },
  { "Kagen", 0.9664694 },
  { "Kager", 1.0 },
  { "Kagome", 0.0 },
  { "Kahaan", 1.0 },
  { "Kahala", 0.0 },
  { "Kahan", 1.0 },
  { "Kahana", 0.0 },
  { "Kahani", 0.0 },
  { "Kahanuola", 1.0 },
  { "Kahari", 0.9821883 },
  { "Kahdeem", 1.0 },
  { "Kahdejah", 0.0 },
  { "Kahden", 1.0 },
  { "Kahdijah", 0.0 },
  { "Kahea", 0.0 },
  { "Kahealani", 0.0 },
  { "Kaheem", 1.0 },
  { "Kaheim", 1.0 },
  { "Kahekili", 1.0 },
  { "Kahia", 0.0 },
  { "Kahiau", 1.0 },
  { "Kahiem", 1.0 },
  { "Kahil", 1.0 },
  { "Kahila", 0.0 },
  { "Kahir", 1.0 },
  { "Kahl", 1.0 },
  { "Kahla", 0.0 },
  { "Kahlan", 0.011876484 },
  { "Kahlani", 0.0 },
  { "Kahlaya", 0.0 },
  { "Kahle", 1.0 },
  { "Kahlea", 0.0 },
  { "Kahleah", 0.0 },
  { "Kahleb", 1.0 },
  { "Kahlee", 0.25688073 },
  { "Kahleel", 1.0 },
  { "Kahleesi", 0.0 },
  { "Kahlei", 0.0 },
  { "Kahleia", 0.0 },
  { "Kahleil", 1.0 },
  { "Kahlel", 1.0 },
  { "Kahlen", 0.2005988 },
  { "Kahler", 0.8695652 },
  { "Kahley", 0.0 },
  { "Kahleya", 0.0 },
  { "Kahli", 0.21493213 },
  { "Kahlia", 0.0 },
  { "Kahliah", 0.0 },
  { "Kahlid", 1.0 },
  { "Kahlie", 0.0 },
  { "Kahliel", 1.0 },
  { "Kahlif", 1.0 },
  { "Kahlil", 1.0 },
  { "Kahlila", 0.0 },
  { "Kahlilah", 0.0 },
  { "Kahlill", 1.0 },
  { "Kahlin", 0.8428571 },
  { "Kahlina", 0.0 },
  { "Kahlis", 0.0 },
  { "Kahliya", 0.0 },
  { "Kahliyah", 0.0 },
  { "Kahlo", 1.0 },
  { "Kahloni", 0.0 },
  { "Kahlyn", 0.0 },
  { "Kahlynn", 0.0 },
  { "Kahmal", 1.0 },
  { "Kahmani", 0.78 },
  { "Kahmar", 1.0 },
  { "Kahmari", 0.7408638 },
  { "Kahmel", 1.0 },
  { "Kahmia", 0.0 },
  { "Kahmiah", 0.0 },
  { "Kahmila", 0.0 },
  { "Kahmir", 1.0 },
  { "Kahmiya", 0.0 },
  { "Kahmiyah", 0.0 },
  { "Kahmora", 0.0 },
  { "Kahmya", 0.0 },
  { "Kahmyah", 0.0 },
  { "Kahmyra", 0.0 },
  { "Kahn", 1.0 },
  { "Kahne", 0.973822 },
  { "Kahner", 1.0 },
  { "Kahniya", 0.0 },
  { "Kahniyah", 0.0 },
  { "Kahnye", 1.0 },
  { "Kaho", 0.0 },
  { "Kahree", 1.0 },
  { "Kahreem", 1.0 },
  { "Kahri", 0.5915493 },
  { "Kahrin", 0.0 },
  { "Kahron", 1.0 },
  { "Kahryn", 0.0 },
  { "Kahseem", 1.0 },
  { "Kahtai", 1.0 },
  { "Kahyla", 0.0 },
  { "Kai", 0.8527915 },
  { "Kaia", 0.0037965071 },
  { "Kaiah", 0.0 },
  { "Kaian", 1.0 },
  { "Kaiana", 0.0 },
  { "Kaiann", 0.0 },
  { "Kaianna", 0.0 },
  { "Kaianne", 0.0 },
  { "Kaiba", 1.0 },
  { "Kaibree", 0.0 },
  { "Kaibren", 1.0 },
  { "Kaicee", 0.0 },
  { "Kaicen", 1.0 },
  { "Kaicey", 0.0 },
  { "Kaicy", 0.0 },
  { "Kaicyn", 0.7058824 },
  { "Kaid", 1.0 },
  { "Kaida", 0.0 },
  { "Kaidan", 0.9311828 },
  { "Kaidance", 0.0 },
  { "Kaide", 1.0 },
  { "Kaidee", 0.0 },
  { "Kaiden", 0.9592352 },
  { "Kaidence", 0.08733778 },
  { "Kaidenn", 1.0 },
  { "Kaidin", 0.97089946 },
  { "Kaidince", 0.0 },
  { "Kaido", 1.0 },
  { "Kaidon", 1.0 },
  { "Kaidra", 0.0 },
  { "Kaidy", 0.0 },
  { "Kaidyn", 0.61370826 },
  { "Kaidynce", 0.017910447 },
  { "Kaidynn", 0.35135135 },
  { "Kaie", 1.0 },
  { "Kaiea", 0.9285714 },
  { "Kaiel", 1.0 },
  { "Kaielle", 0.0 },
  { "Kaien", 1.0 },
  { "Kaiesha", 0.0 },
  { "Kaif", 1.0 },
  { "Kaigan", 0.33333334 },
  { "Kaige", 0.9859155 },
  { "Kaigen", 0.8684211 },
  { "Kaihan", 1.0 },
  { "Kaii", 1.0 },
  { "Kaiicen", 1.0 },
  { "Kaiiden", 1.0 },
  { "Kaiis", 1.0 },
  { "Kaija", 0.0 },
  { "Kaijah", 0.0 },
  { "Kaikane", 1.0 },
  { "Kaikea", 1.0 },
  { "Kaikoa", 1.0 },
  { "Kaiky", 1.0 },
  { "Kail", 0.93835616 },
  { "Kaila", 0.0 },
  { "Kailah", 0.0 },
  { "Kailahni", 0.0 },
  { "Kailan", 0.41884816 },
  { "Kailana", 0.0 },
  { "Kailand", 0.8194444 },
  { "Kailani", 0.005154639 },
  { "Kailanie", 0.0 },
  { "Kailanni", 0.0 },
  { "Kailanny", 0.0 },
  { "Kailany", 0.0 },
  { "Kailar", 1.0 },
  { "Kailas", 1.0 },
  { "Kailash", 1.0 },
  { "Kailaya", 0.0 },
  { "Kailayah", 0.0 },
  { "Kaile", 0.030726258 },
  { "Kailea", 0.0 },
  { "Kaileah", 0.0 },
  { "Kaileb", 1.0 },
  { "Kailee", 0.002015599 },
  { "Kaileeann", 0.0 },
  { "Kaileemarie", 0.0 },
  { "Kaileen", 0.0 },
  { "Kaileena", 0.0 },
  { "Kailei", 0.0 },
  { "Kaileia", 0.0 },
  { "Kaileigh", 0.0 },
  { "Kaileigha", 0.0 },
  { "Kailen", 0.49658832 },
  { "Kailena", 0.0 },
  { "Kailene", 0.0 },
  { "Kaileo", 1.0 },
  { "Kailer", 0.9513889 },
  { "Kailey", 0.0004064545 },
  { "Kaili", 0.015401954 },
  { "Kailia", 0.0 },
  { "Kailiah", 0.0 },
  { "Kailiana", 0.0 },
  { "Kailianna", 0.0 },
  { "Kailib", 1.0 },
  { "Kailie", 0.0 },
  { "Kailin", 0.11372867 },
  { "Kailina", 0.0 },
  { "Kailiyah", 0.0 },
  { "Kailla", 0.0 },
  { "Kaille", 0.0 },
  { "Kaillou", 1.0 },
  { "Kailly", 0.0 },
  { "Kailo", 1.0 },
  { "Kailob", 1.0 },
  { "Kailon", 0.96517414 },
  { "Kailoni", 0.0 },
  { "Kailor", 0.5833333 },
  { "Kailub", 1.0 },
  { "Kailum", 1.0 },
  { "Kaily", 0.0 },
  { "Kailye", 0.0 },
  { "Kailyn", 0.0061437804 },
  { "Kailyne", 0.0 },
  { "Kailynn", 0.0 },
  { "Kailynne", 0.0 },
  { "Kaimalu", 1.0 },
  { "Kaiman", 1.0 },
  { "Kaimana", 0.9145183 },
  { "Kaimani", 0.9019608 },
  { "Kaimarie", 0.0 },
  { "Kaimen", 1.0 },
  { "Kaimere", 1.0 },
  { "Kaimi", 0.59375 },
  { "Kaimilani", 0.0 },
  { "Kaiming", 1.0 },
  { "Kaimipono", 1.0 },
  { "Kaimya", 0.0 },
  { "Kain", 1.0 },
  { "Kaina", 0.0 },
  { "Kainaan", 1.0 },
  { "Kainaat", 0.0 },
  { "Kainalu", 1.0 },
  { "Kainan", 1.0 },
  { "Kainani", 0.0 },
  { "Kainat", 0.0 },
  { "Kaine", 1.0 },
  { "Kainen", 1.0 },
  { "Kainin", 1.0 },
  { "Kainoa", 0.9856 },
  { "Kainoah