# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

inherit autotools

DESCRIPTION="A library for parsing, sorting and filtering your mail"
SRC_URI="https://downloads.sourceforge.net/${PN}/${P}.tar.gz"
HOMEPAGE="http://libsieve.sourceforge.net/"

SLOT="0"
LICENSE="MIT LGPL-2.1"
KEYWORDS="~alpha amd64 ~ppc ~sparc x86"

RDEPEND="!<net-mail/mailutils-2.1"

S=${WORKDIR}/${P}/src

src_prepare() {
	default
	mv configure.{in,ac} || die
	eautoreconf
}

src_configure() {
	econf --disable-static
}

src_install() {
	default
	find "${ED}" -name '*.la' -delete || die
}
