/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import javax.xml.transform.TransformerConfigurationException;

public class DecimalFormatManager {
    private DecimalFormatSymbols defaultDFS;
    private Hashtable formatTable = new Hashtable();
    private boolean usingOriginalDefault = true;

    public DecimalFormatManager() {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        DecimalFormatManager.setDefaults(decimalFormatSymbols);
        this.defaultDFS = decimalFormatSymbols;
    }

    public static void setDefaults(DecimalFormatSymbols decimalFormatSymbols) {
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormatSymbols.setGroupingSeparator(',');
        decimalFormatSymbols.setInfinity("Infinity");
        decimalFormatSymbols.setMinusSign('-');
        decimalFormatSymbols.setNaN("NaN");
        decimalFormatSymbols.setPercent('%');
        decimalFormatSymbols.setPerMill('\u2030');
        decimalFormatSymbols.setZeroDigit('0');
        decimalFormatSymbols.setDigit('#');
        decimalFormatSymbols.setPatternSeparator(';');
    }

    public void setDefaultDecimalFormat(DecimalFormatSymbols decimalFormatSymbols) throws TransformerConfigurationException {
        if (!this.usingOriginalDefault && !decimalFormatSymbols.equals(this.defaultDFS)) {
            throw new TransformerConfigurationException("There are two conflicting definitions of the default decimal format");
        }
        this.defaultDFS = decimalFormatSymbols;
        this.usingOriginalDefault = false;
    }

    public DecimalFormatSymbols getDefaultDecimalFormat() {
        return this.defaultDFS;
    }

    public void setNamedDecimalFormat(int n, DecimalFormatSymbols decimalFormatSymbols) throws TransformerConfigurationException {
        Integer n2 = new Integer(n);
        DecimalFormatSymbols decimalFormatSymbols2 = (DecimalFormatSymbols)this.formatTable.get(n2);
        if (decimalFormatSymbols2 != null && !decimalFormatSymbols.equals(decimalFormatSymbols2)) {
            throw new TransformerConfigurationException("Duplicate declaration of decimal-format");
        }
        this.formatTable.put(n2, decimalFormatSymbols);
    }

    public DecimalFormatSymbols getNamedDecimalFormat(int n) {
        return (DecimalFormatSymbols)this.formatTable.get(new Integer(n));
    }
}

