// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
/// Check that we generate checks for functions even though the mangledName
/// property in the AST dump JSON does not match the LLVM IR name.
// RUN: %clang_cc1 -triple=x86_64-unknown-linux-gnu -emit-llvm -o - %s | FileCheck %s --check-prefix=ELF
// RUN: %clang_cc1 -triple=x86_64-apple-macho -emit-llvm -o - %s | FileCheck %s --check-prefix=MACHO
// RUN: %clang_cc1 -triple=x86_64-windows-msvc -emit-llvm -o - %s | FileCheck %s --check-prefix=MSVC
// RUN: %clang_cc1 -triple=x86_64-windows-gnu -emit-llvm -o - %s | FileCheck %s --check-prefix=MINGW
// RUN: %clang_cc1 -triple=i686-unknown-win32 -emit-llvm -o - %s | FileCheck %s --check-prefix=WIN32
// RUN: %clang_cc1 -triple thumbv7s-apple-darwin -target-abi apcs-gnu -emit-llvm -o - %s | FileCheck %s --check-prefix=THUMB-DARWIN

// UTC_ARGS: --disable
// ELF: target datalayout = "e-m:e-
// MACHO: target datalayout = "e-m:o-
// MSVC: target datalayout = "e-m:w-
// MINGW: target datalayout = "e-m:w-
// WIN32: target datalayout = "e-m:x-
// THUMB-DARWIN: target datalayout = "e-m:o-
// UTC_ARGS: --enable

#ifdef __arm__
typedef __attribute__((neon_vector_type(8))) __INT8_TYPE__ int8x8_t;
int8x8_t test_vaba_s8(int8x8_t a, int8x8_t b, int8x8_t c) {
  return a + b + c;
}
#endif

/// Check global variable mangling
[[gnu::used]] static int i1 = 1;
int i2 = 2;

[[clang::noinline,gnu::used]] static int static_noinline_fn(int arg) { return arg; }

[[gnu::visibility("hidden")]] int hidden_visibility(int arg) { return arg; }

#ifdef __ELF__
[[gnu::visibility("protected")]] int protected_visibility(int arg) { return arg; }
#endif

[[gnu::visibility("default")]] int default_visibility(int arg) { return arg; }

int no_visibility(int arg) { return arg; }


/// FIXME: the i386 @fastcall@12 is not being checked here
#ifdef _WIN32
int __fastcall fastcall(int arg, long arg2, long arg3) { return arg; }
#endif

