/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.jupyter.core.editor.settings.JupyterDSettingsMarkdownRenderMode;
import com.intellij.jupyter.core.editor.settings.JupyterSettings;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.ui.JupyterUiUtilKt;
import com.intellij.notebooks.jupyter.core.jupyter.CellType;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellEventListener;
import com.intellij.notebooks.visualization.ui.EditorNotebook;
import com.intellij.notebooks.visualization.ui.EditorNotebookKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.LightColors;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefHealthMonitor;
import com.intellij.ui.jcef.JBCefNotifications;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.event.HierarchyEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0002J\u001a\u0010\r\u001a\u00020\u000b*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0002J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J \u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/core/editor/NotebookCefHealthManager;", "Lcom/intellij/openapi/Disposable$Default;", "textEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/fileEditor/FileEditor;Lcom/intellij/openapi/editor/Editor;)V", "notificationPanel", "Lcom/intellij/ui/EditorNotificationPanel;", "subscribeToAppArmorStatus", "", "informCefDisabled", "onMarkdownCell", "Lcom/intellij/notebooks/visualization/ui/EditorNotebook;", "runnable", "Lkotlin/Function0;", "showAppArmorNotificationIfNecessary", "status", "Lcom/intellij/ui/jcef/JBCefHealthMonitor$Status;", "showCefUnsupportedNotification", "showEditorNotification", "panel", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookCefHealthManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCefHealthManager.kt\ncom/intellij/jupyter/core/editor/NotebookCefHealthManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1761#2,3:154\n1761#2,3:157\n*S KotlinDebug\n*F\n+ 1 NotebookCefHealthManager.kt\ncom/intellij/jupyter/core/editor/NotebookCefHealthManager\n*L\n96#1:154,3\n101#1:157,3\n*E\n"})
public final class NotebookCefHealthManager
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileEditor textEditor;
    @NotNull
    private final Editor editor;
    @Nullable
    private EditorNotificationPanel notificationPanel;

    public NotebookCefHealthManager(@NotNull FileEditor textEditor, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)textEditor, (String)"textEditor");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.textEditor = textEditor;
        this.editor = editor;
        this.subscribeToAppArmorStatus();
        this.informCefDisabled();
    }

    private final void subscribeToAppArmorStatus() {
        block2: {
            if (!SystemInfo.isLinux) {
                return;
            }
            if (JupyterSettings.Companion.getInstance().getMarkdownRenderMode() != JupyterDSettingsMarkdownRenderMode.NOTEBOOK_CEF || JBCefHealthMonitor.getInstance().getStatus() == JBCefHealthMonitor.Status.OK) {
                return;
            }
            MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
            Topic topic = JBCefHealthMonitor.JBCefHealthCheckTopic.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, arg_0 -> NotebookCefHealthManager.subscribeToAppArmorStatus$lambda$0(this, arg_0));
            EditorNotebook editorNotebook = EditorNotebookKt.getNotebook((Editor)this.editor);
            if (editorNotebook == null) break block2;
            this.onMarkdownCell(editorNotebook, (Function0<Unit>)((Function0)() -> NotebookCefHealthManager.subscribeToAppArmorStatus$lambda$1(this)));
        }
    }

    private final void informCefDisabled() {
        block2: {
            if (JBCefApp.isSupported()) {
                return;
            }
            if (PropertiesComponent.getInstance().getBoolean("jupyter.cef.unsupported.notification.disabled")) {
                return;
            }
            EditorNotebook editorNotebook = EditorNotebookKt.getNotebook((Editor)this.editor);
            if (editorNotebook == null) break block2;
            this.onMarkdownCell(editorNotebook, (Function0<Unit>)((Function0)() -> NotebookCefHealthManager.informCefDisabled$lambda$0(this)));
        }
    }

    private final void onMarkdownCell(EditorNotebook $this$onMarkdownCell, Function0<Unit> runnable) {
        boolean bl;
        block5: {
            Iterable $this$any$iv = $this$onMarkdownCell.getCells();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    EditorCell it = (EditorCell)element$iv;
                    boolean bl2 = false;
                    if (!(it.getType() == CellType.MARKDOWN)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            runnable.invoke();
        } else {
            $this$onMarkdownCell.addCellEventsListener((Disposable)$this$onMarkdownCell, arg_0 -> NotebookCefHealthManager.onMarkdownCell$lambda$1(runnable, arg_0));
        }
    }

    private final EditorNotificationPanel showAppArmorNotificationIfNecessary(JBCefHealthMonitor.Status status) {
        EditorNotificationPanel panel = JBCefNotifications.createEditorNotificationPanel((Editor)this.editor, (JBCefHealthMonitor.Status)status);
        if (panel != null) {
            this.showEditorNotification(this.textEditor, this.editor, panel);
        }
        return panel;
    }

    static /* synthetic */ EditorNotificationPanel showAppArmorNotificationIfNecessary$default(NotebookCefHealthManager notebookCefHealthManager, JBCefHealthMonitor.Status status, int n, Object object) {
        if ((n & 1) != 0) {
            JBCefHealthMonitor.Status status2 = JBCefHealthMonitor.getInstance().getStatus();
            Intrinsics.checkNotNullExpressionValue((Object)status2, (String)"getStatus(...)");
            status = status2;
        }
        return notebookCefHealthManager.showAppArmorNotificationIfNecessary(status);
    }

    private final void showCefUnsupportedNotification(FileEditor textEditor, Editor editor) {
        if (PropertiesComponent.getInstance().getBoolean("jupyter.cef.unsupported.notification.disabled")) {
            return;
        }
        if (JBCefApp.isSupported()) {
            return;
        }
        EditorNotificationPanel panel = new EditorNotificationPanel(editor, LightColors.YELLOW, null, EditorNotificationPanel.Status.Warning);
        panel.setText(JupyterBundle.message("notification.jre.cef.not.supported", new Object[0]));
        panel.createActionLabel(IdeBundle.message((String)"label.dont.show", (Object[])new Object[0]), () -> NotebookCefHealthManager.showCefUnsupportedNotification$lambda$0(editor, textEditor, panel));
        this.showEditorNotification(textEditor, editor, panel);
    }

    private final void showEditorNotification(FileEditor textEditor, Editor editor, EditorNotificationPanel panel) {
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
        panel.setCloseAction(() -> NotebookCefHealthManager.showEditorNotification$lambda$0(fileEditorManager, textEditor, panel));
        if (!editor.getComponent().isDisplayable()) {
            JComponent jComponent = editor.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            JupyterUiUtilKt.onComponentAddedToHierarchy(jComponent, (Function1<? super HierarchyEvent, Unit>)((Function1)arg_0 -> NotebookCefHealthManager.showEditorNotification$lambda$1(fileEditorManager, textEditor, panel, arg_0)));
        } else {
            fileEditorManager.addTopComponent(textEditor, (JComponent)panel);
        }
    }

    private static final void subscribeToAppArmorStatus$lambda$0(NotebookCefHealthManager this$0, JBCefHealthMonitor.Status status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        SwingUtilities.invokeLater(() -> NotebookCefHealthManager.subscribeToAppArmorStatus$lambda$0$0(this$0, status));
    }

    private static final void subscribeToAppArmorStatus$lambda$0$0(NotebookCefHealthManager this$0, JBCefHealthMonitor.Status $status) {
        Intrinsics.checkNotNull((Object)$status);
        EditorNotificationPanel panel = this$0.showAppArmorNotificationIfNecessary($status);
        EditorNotificationPanel notificationPanel = this$0.notificationPanel;
        if (panel == null && notificationPanel != null) {
            Project project = this$0.editor.getProject();
            Intrinsics.checkNotNull((Object)project);
            FileEditorManager.getInstance((Project)project).removeTopComponent(this$0.textEditor, (JComponent)notificationPanel);
            this$0.notificationPanel = null;
        }
        this$0.notificationPanel = panel;
    }

    private static final Unit subscribeToAppArmorStatus$lambda$1(NotebookCefHealthManager this$0) {
        NotebookCefHealthManager.showAppArmorNotificationIfNecessary$default(this$0, null, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit informCefDisabled$lambda$0(NotebookCefHealthManager this$0) {
        this$0.showCefUnsupportedNotification(this$0.textEditor, this$0.editor);
        return Unit.INSTANCE;
    }

    private static final void onMarkdownCell$lambda$1(Function0 $runnable, List events) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)events, (String)"events");
            Iterable $this$any$iv = events;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    EditorCellEventListener.EditorCellEvent it = (EditorCellEventListener.EditorCellEvent)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof EditorCellEventListener.CellCreated && ((EditorCellEventListener.CellCreated)it).getCell().getType() == CellType.MARKDOWN)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            $runnable.invoke();
        }
    }

    private static final void showCefUnsupportedNotification$lambda$0(Editor $editor, FileEditor $textEditor, EditorNotificationPanel $panel) {
        PropertiesComponent.getInstance().setValue("jupyter.cef.unsupported.notification.disabled", true);
        Project project = $editor.getProject();
        Intrinsics.checkNotNull((Object)project);
        FileEditorManager.getInstance((Project)project).removeTopComponent($textEditor, (JComponent)$panel);
    }

    private static final void showEditorNotification$lambda$0(FileEditorManager $fileEditorManager, FileEditor $textEditor, EditorNotificationPanel $panel) {
        $fileEditorManager.removeTopComponent($textEditor, (JComponent)$panel);
    }

    private static final Unit showEditorNotification$lambda$1(FileEditorManager $fileEditorManager, FileEditor $textEditor, EditorNotificationPanel $panel, HierarchyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SwingUtilities.invokeLater(() -> NotebookCefHealthManager.showEditorNotification$lambda$1$0($fileEditorManager, $textEditor, $panel));
        return Unit.INSTANCE;
    }

    private static final void showEditorNotification$lambda$1$0(FileEditorManager $fileEditorManager, FileEditor $textEditor, EditorNotificationPanel $panel) {
        $fileEditorManager.addTopComponent($textEditor, (JComponent)$panel);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/core/editor/NotebookCefHealthManager$Companion;", "", "<init>", "()V", "install", "", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull FileEditor fileEditor, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Disposer.register((Disposable)((Disposable)fileEditor), (Disposable)((Disposable)new NotebookCefHealthManager(fileEditor, editor)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

