/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.util;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.TextRange;
import com.intellij.protobuf.lang.lexer.StringLexer;
import java.util.Arrays;

public class ProtoString {
    private final String original;
    private final String parsed;
    private final ImmutableList<TextRange> invalidEscapeRanges;
    private final boolean unterminated;
    private final int[] sourceOffsets;

    public String getOriginal() {
        return this.original;
    }

    public String toString() {
        return this.parsed;
    }

    public ImmutableList<TextRange> getInvalidEscapeRanges() {
        return this.invalidEscapeRanges;
    }

    public boolean isUnterminated() {
        return this.unterminated;
    }

    public int getOriginalOffset(int offset) {
        return this.sourceOffsets[offset];
    }

    public static ProtoString parse(String encoded) {
        String parsed;
        if (encoded.isEmpty()) {
            throw new IllegalArgumentException("String must not be empty.");
        }
        if (encoded.charAt(0) != '\'' && encoded.charAt(0) != '\"') {
            throw new IllegalArgumentException("String must start with a single or double quote.");
        }
        int[] offsets = new int[encoded.length()];
        ImmutableList.Builder invalidEscapeRanges = ImmutableList.builder();
        StringBuilder result = new StringBuilder(encoded.length());
        StringLexer lexer = new StringLexer();
        lexer.start(encoded);
        boolean lastWasLiteral = false;
        while (lexer.hasMoreTokens()) {
            CharSequence value = lexer.currentTokenValue();
            int start = lexer.getTokenStart();
            for (int i = 0; i < value.length(); ++i) {
                offsets[result.length() + i] = start + i;
            }
            result.append(value);
            if (lexer.isCurrentTokenInvalid()) {
                invalidEscapeRanges.add((Object)TextRange.create((int)lexer.getTokenStart(), (int)lexer.getTokenEnd()));
            }
            lastWasLiteral = lexer.isCurrentTokenLiteral();
            lexer.advance();
        }
        boolean unterminated = false;
        if (!lastWasLiteral || result.charAt(result.length() - 1) != result.charAt(0) || result.length() == 1) {
            unterminated = true;
            parsed = result.substring(1);
        } else {
            parsed = result.substring(1, result.length() - 1);
        }
        offsets = Arrays.copyOfRange(offsets, 1, 1 + parsed.length());
        return new ProtoString(encoded, parsed, unterminated, (ImmutableList<TextRange>)invalidEscapeRanges.build(), offsets);
    }

    private ProtoString(String original, String parsed, boolean unterminated, ImmutableList<TextRange> invalidEscapeRanges, int[] offsets) {
        this.original = original;
        this.parsed = parsed;
        this.unterminated = unterminated;
        this.invalidEscapeRanges = invalidEscapeRanges;
        this.sourceOffsets = offsets;
    }
}

