/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.jvm.names;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.protobuf.jvm.names.JavaNameGenerator;
import com.intellij.protobuf.jvm.names.NameUtils;
import com.intellij.protobuf.lang.psi.PbEnumDefinition;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbNamedTypeElement;
import com.intellij.protobuf.lang.psi.PbOneofDefinition;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class Proto2DefinitionClassNames {
    private static final String OUTER_CLASS_NAME_SUFFIX = "OuterClass";
    private final PbFile file;
    private final QualifiedName protoPackage;
    private final String descriptorPackage;
    private final String classPackage;
    private final String classPrefix;
    private final String outerClassName;
    private final boolean isMultipleFiles;

    public Proto2DefinitionClassNames(PbFile file, QualifiedName protoPackage, String descriptorPackage, String classPackage, String classPrefix, String outerClassName, boolean isMultipleFiles) {
        this.file = file;
        this.protoPackage = protoPackage;
        this.descriptorPackage = descriptorPackage;
        this.classPackage = classPackage;
        this.classPrefix = classPrefix;
        this.outerClassName = outerClassName;
        this.isMultipleFiles = isMultipleFiles;
    }

    public Set<String> outerClassNames(JavaNameGenerator nameGenerator) {
        ImmutableSet.Builder names = ImmutableSet.builder();
        names.add((Object)(this.descriptorPackage + this.classPrefix + this.outerClassName));
        if (this.isMultipleFiles) {
            this.collectMultipleFileOuterClassNames(nameGenerator, (ImmutableSet.Builder<String>)names);
        }
        return names.build();
    }

    private void collectMultipleFileOuterClassNames(JavaNameGenerator nameGenerator, ImmutableSet.Builder<String> results) {
        for (PbSymbol symbol : this.file.getPackageSymbolMap(this.protoPackage).values().stream().flatMap(Collection::stream).toList()) {
            String name;
            if (PbPsiUtil.isMessageElement(symbol)) {
                results.addAll(nameGenerator.messageClassNames((PbMessageType)symbol));
                continue;
            }
            if (!PbPsiUtil.isEnumElement(symbol) || (name = nameGenerator.enumClassName((PbEnumDefinition)symbol)) == null) continue;
            results.add((Object)name);
        }
    }

    public static String getDefaultOuterClassName(PbFile file) {
        Object defaultName = NameUtils.underscoreToCapitalizedCamelCase(FileUtil.getNameWithoutExtension((String)file.getName()));
        if (Proto2DefinitionClassNames.fileHasConflictingOuterClassName(file, (String)defaultName)) {
            defaultName = (String)defaultName + OUTER_CLASS_NAME_SUFFIX;
        }
        return defaultName;
    }

    @Nullable
    public String messageClassName(PbMessageType messageType) {
        return this.typeClassName(messageType);
    }

    @Nullable
    public String enumClassName(PbEnumDefinition enumDefinition) {
        return this.typeClassName(enumDefinition);
    }

    @Nullable
    public String oneofEnumClassName(PbOneofDefinition oneof) {
        QualifiedName typeName = oneof.getQualifiedName();
        if (typeName == null) {
            return null;
        }
        String caseName = NameUtils.underscoreToCapitalizedCamelCase(oneof.getName()) + "Case";
        QualifiedName fileLocalQualifiers = typeName.removeHead(this.protoPackage.getComponentCount()).removeLastComponent().append(caseName);
        return this.typeClassName(fileLocalQualifiers.toString());
    }

    @Nullable
    private String typeClassName(PbNamedTypeElement typeElement) {
        QualifiedName typeName = typeElement.getQualifiedName();
        if (typeName == null) {
            return null;
        }
        QualifiedName fileLocalQualifiers = typeName.removeHead(this.protoPackage.getComponentCount());
        return this.typeClassName(fileLocalQualifiers.toString());
    }

    private String typeClassName(String localName) {
        return this.isMultipleFiles ? this.classPackage + this.classPrefix + localName : this.classPackage + this.classPrefix + this.outerClassName + "." + localName;
    }

    private static boolean fileHasConflictingOuterClassName(PbFile file, String outerClassName) {
        Map<String, Collection<PbSymbol>> packageSymbolMap = file.getPackageSymbolMap(file.getPackageQualifiedName());
        if (packageSymbolMap.containsKey(outerClassName)) {
            return true;
        }
        List<PbMessageType> messagesToVisit = packageSymbolMap.values().stream().flatMap(Collection::stream).filter(PbMessageType.class::isInstance).map(PbMessageType.class::cast).toList();
        for (PbMessageType message : messagesToVisit) {
            if (!Proto2DefinitionClassNames.messageHasConflictingOuterClassName(message, outerClassName)) continue;
            return true;
        }
        return false;
    }

    private static boolean messageHasConflictingOuterClassName(PbMessageType message, String outerClassName) {
        Map symbolMap = message.getSymbolMap();
        Collection matches = (Collection)symbolMap.get(outerClassName);
        if (matches != null) {
            if (ContainerUtil.exists((Iterable)matches, PbNamedTypeElement.class::isInstance)) {
                return true;
            }
        }
        List<PbMessageType> messagesToVisit = symbolMap.values().stream().flatMap(Collection::stream).filter(PbMessageType.class::isInstance).map(PbMessageType.class::cast).toList();
        for (PbMessageType nestedMessage : messagesToVisit) {
            if (!Proto2DefinitionClassNames.messageHasConflictingOuterClassName(nestedMessage, outerClassName)) continue;
            return true;
        }
        return false;
    }
}

