/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl.mssql;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MsSqlVector
implements Serializable {
    private final byte[] myBytes;
    private volatile StringHolder myStringHolder;

    public MsSqlVector(byte[] bytes) {
        this.myBytes = bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringHolder holder = this.myStringHolder;
        if (holder == null) {
            MsSqlVector msSqlVector = this;
            synchronized (msSqlVector) {
                holder = this.myStringHolder;
                if (holder == null) {
                    this.myStringHolder = holder = new StringHolder(this.myBytes);
                }
            }
        }
        return holder.myValue;
    }

    private static class StringHolder {
        final String myValue;

        StringHolder(byte[] bytes) {
            this.myValue = StringHolder.computeStringRepresentation(bytes);
        }

        private static String computeStringRepresentation(byte[] bytes) {
            int offset = 8;
            int floatCount = (bytes.length - offset) / 4;
            float[] result = new float[floatCount];
            ByteBuffer buffer = ByteBuffer.wrap(bytes, offset, bytes.length - offset).order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < floatCount; ++i) {
                result[i] = buffer.getFloat();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < floatCount; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(result[i]);
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

