/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.ConnDatabaseNotifications;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceBriefConfig;
import com.intellij.database.dataSource.DataSourceBriefConfigs;
import com.intellij.database.dataSource.DataSourceFun;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.RegularIntrospectionContext;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorageService;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.introspection.DatabaseModelLoader;
import com.intellij.database.introspection.DatabaseModelLoaderHelper;
import com.intellij.database.introspection.DbmsMismatchException;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTaskHelper;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.JBIterable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseIntrospectionSession {
    private static final Logger LOG = Logger.getInstance(DatabaseIntrospectionSession.class);
    private static final AtomicLong ourIdCounter = new AtomicLong();
    public static final String SINGLE_DB_WARNING = "ignore.single.db.warning";
    @NotNull
    private final DBIntrospectionContext myIntrospectionContext;
    @NotNull
    private final LoaderContext myLoaderContext;
    @NotNull
    private final LocalDataSource myDataSource;
    @NotNull
    private final DBIntrospector myIntrospector;
    private final ProgressIndicator myIndicator;
    private final ModalityState myModality;
    private final boolean myFirstTime;
    private GuardedRef<?> mySrcSession;
    private boolean myIntrospectorPrepared;
    private boolean mySingleModeReported;
    private final long mySessionId;

    protected DatabaseIntrospectionSession(@NotNull LoaderContext loaderContext, @NotNull ProgressIndicator indicator, @NotNull ModalityState modality) {
        if (loaderContext == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(0);
        }
        if (indicator == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(1);
        }
        if (modality == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(2);
        }
        this.myIntrospectorPrepared = false;
        this.mySessionId = ourIdCounter.getAndIncrement();
        this.myIntrospectionContext = (DBIntrospectionContext)loaderContext.getProject().getService(RegularIntrospectionContext.class);
        this.myLoaderContext = loaderContext;
        this.myDataSource = loaderContext.getDataSource();
        this.myIndicator = indicator;
        this.myModality = modality;
        this.mySingleModeReported = "true".equals(this.myLoaderContext.getDataSource().getAdditionalProperty(SINGLE_DB_WARNING));
        ModelFactory modelFactory = this.myDataSource.isTemporary() ? ModelFactory.BLACK_HOLE : this.createModelFactory(this.myDataSource);
        DBIntrospectionOptions options = DataSourceFun.getIntrospectionOptions((LocalDataSource)this.myDataSource);
        if (this.myLoaderContext.isOutdatedCheck()) {
            options = options.copyWithSkipModelContentValidation(true);
        }
        this.myIntrospector = DBIntrospectorFactory.createIntrospector((DBIntrospectionContext)this.myIntrospectionContext, (ModelFactory)modelFactory, (LocalDataSource)this.myDataSource);
        this.myIntrospector.setOptions(options);
        this.myIntrospector.setErrorSink((arg_0, arg_1) -> ((ErrorHandler)this.myLoaderContext.getErrorHandler()).addError(arg_0, arg_1));
        BasicModModel dataSourceModel = (BasicModModel)ObjectUtils.tryCast((Object)this.myDataSource.getModel(), BasicModModel.class);
        TreePattern theScope = this.myDataSource.getIntrospectionScope();
        theScope = loaderContext.getScopeUpdater().updateVisibleNamespacesPlain(theScope, (CasingProvider)this.myDataSource.getModel());
        if (theScope.isEmpty()) {
            theScope = null;
        }
        DataSourceBriefConfig dsConfig = DataSourceBriefConfigs.getConfig((DatabaseConnectionPoint)this.myDataSource);
        BasicModModel model = this.myIntrospector.init(dataSourceModel, dsConfig, theScope);
        this.myFirstTime = model.getModelRoots().isEmpty();
        if (model != dataSourceModel) {
            BasicModel dsModel = (BasicModel)ObjectUtils.tryCast((Object)this.myDataSource.getModel(), BasicModModel.class);
            if (model == dsModel) {
                return;
            }
            this.myDataSource.setModel((DasModel)model);
        }
    }

    @NotNull
    public LoaderContext getLoaderContext() {
        LoaderContext loaderContext = this.myLoaderContext;
        if (loaderContext == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(3);
        }
        return loaderContext;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myLoaderContext.getProject();
        if (project == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(4);
        }
        return project;
    }

    @NotNull
    public DBIntrospector getIntrospector() {
        DBIntrospector dBIntrospector = this.myIntrospector;
        if (dBIntrospector == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(5);
        }
        return dBIntrospector;
    }

    public long getSessionId() {
        return this.mySessionId;
    }

    protected abstract void performDbSpecificOperation(@Nullable ObjectPath var1, boolean var2, @NotNull @NotNull ThrowableConsumer<@NotNull DatabaseConnection, Exception> var3) throws SQLException;

    public void run() throws SQLException {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (this.myLoaderContext.isEmpty()) {
            return;
        }
        DatabaseModelLoader.Listener publisher = (DatabaseModelLoader.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DatabaseModelLoader.TOPIC);
        publisher.started(this);
        LocalDataSource dataSource = this.myLoaderContext.getDataSource();
        try {
            dataSource.performBatch(this::introspectUnderDataSourceBatch);
            publisher.finished(this, this.myLoaderContext.getErrorHandler().hasErrors() ? DatabaseModelLoader.FinishedState.WARN : DatabaseModelLoader.FinishedState.OK);
        }
        catch (Throwable th) {
            boolean connectionFailed;
            boolean warnings = this.myLoaderContext.getErrorHandler().hasErrors();
            boolean bl = connectionFailed = !(th instanceof IntrospectionPce);
            publisher.finished(this, connectionFailed ? DatabaseModelLoader.FinishedState.CONNECTION_FAILED : (warnings ? DatabaseModelLoader.FinishedState.FAILED : DatabaseModelLoader.FinishedState.CANCELLED));
            ExceptionUtil.rethrow((Throwable)th);
        }
    }

    private void introspectUnderDataSourceBatch() {
        try {
            this.introspectIt();
        }
        catch (ProcessCanceledException pce) {
            LOG.debug("Introspection was canceled");
            throw pce;
        }
        catch (SQLException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private void introspectIt() throws SQLException, ProcessCanceledException {
        this.myIndicator.checkCanceled();
        List tasks = this.myLoaderContext.getTasks();
        if (tasks.isEmpty()) {
            return;
        }
        try {
            if (this.myIntrospector.isMetadataAccessDependsOnConnection()) {
                this.introspectTasksInDifferentSessions(tasks);
            } else {
                this.introspectTasksInDefaultSession(tasks);
            }
        }
        finally {
            this.closeSrcSession();
            this.myIntrospectorPrepared = false;
        }
        TreePattern theScope = this.myDataSource.getIntrospectionScope();
        theScope = this.myLoaderContext.getScopeUpdater().updateVisibleNamespaces(theScope, (BasicModel)this.myIntrospector.getModel());
        this.myDataSource.setIntrospectionScope(theScope);
        this.myIntrospector.performFinalDiagnostics();
    }

    private void introspectTasksInDifferentSessions(@NotNull Collection<IntrospectionTask> tasks) {
        IntrospectionTask task1;
        if (tasks == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(6);
        }
        TreePattern desiredScope = DatabaseModelLoaderHelper.collectDatabasesScope(tasks);
        BasicDatabase defaultDatabase = this.myLoaderContext.getDefaultDatabase();
        String defaultDatabaseName = defaultDatabase != null ? defaultDatabase.getRealName() : null;
        String initialDatabaseName = desiredScope != null ? this.guessInitialDatabase(desiredScope) : defaultDatabaseName;
        if (this.myFirstTime || DatabaseModelLoaderHelper.containsTasksRelatedToInitialDatabase(tasks, initialDatabaseName)) {
            ObjectPath initialConnectionPath = initialDatabaseName != null ? ObjectPath.create((String)initialDatabaseName, (ObjectKind)ObjectKind.DATABASE) : null;
            this.introspectTasksInDatabaseSession(tasks, initialConnectionPath);
        } else {
            this.myIntrospector.introspect(tasks);
        }
        ArrayList<IntrospectionTask> mentionedTasks = new ArrayList<IntrospectionTask>();
        while ((task1 = (IntrospectionTask)this.myIntrospector.listDeferredTasks().stream().filter(t -> !mentionedTasks.contains(t)).findFirst().orElse(null)) != null) {
            mentionedTasks.add(task1);
            BasicDatabase db = null;
            BasicModel model = this.myLoaderContext.getBasicModel();
            if (model != null) {
                IntrospectionTaskHelper th = IntrospectionTaskHelper.prepareHelper((BasicRoot)model.getRoot());
                db = th.databaseOf(task1);
            }
            if (db == null || !db.isAllowConnections()) {
                db = this.myLoaderContext.getDefaultDatabase();
            }
            if (db == null) {
                LOG.warn("PANIC! cannot determine the database for task: " + String.valueOf(task1));
                break;
            }
            this.introspectDeferredTasksInDatabaseSession(db);
        }
    }

    private void introspectTasksInDefaultSession(@NotNull Collection<IntrospectionTask> tasks) {
        if (tasks == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(7);
        }
        this.introspectTasksInDatabaseSession(tasks, null);
    }

    private void introspectTasksInDatabaseSession(@NotNull Collection<IntrospectionTask> tasks, @Nullable ObjectPath connectionPath) {
        if (tasks == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(8);
        }
        try {
            this.connectAndDoIntrospectOperation(connectionPath, () -> this.performTasksInTheConnectedSession(tasks));
        }
        catch (SQLException e) {
            LOG.warn("Failed to introspect tasks using this db path", (Throwable)e);
        }
    }

    private void performTasksInTheConnectedSession(@NotNull Collection<IntrospectionTask> tasks) {
        if (tasks == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(9);
        }
        if (this.myLoaderContext.isAllowedToChangeDsSettings() && this.myDataSource.getIntrospectionScope().isEmpty()) {
            this.myIntrospector.introspectNamespaces();
            this.updateDataSourceScope();
        }
        this.myIntrospector.introspect(tasks);
        this.myIntrospector.processDeferredTasks();
    }

    private void updateDataSourceScope() {
        if (!this.myLoaderContext.isAllowedToChangeDsSettings()) {
            return;
        }
        TreePattern theScope = this.myDataSource.getIntrospectionScope();
        if (theScope.isEmpty()) {
            TreePattern newScope = this.myIntrospector.getDefaultScope();
            this.myDataSource.setIntrospectionScope(newScope);
            LOG.trace("Set new introspection scope: " + String.valueOf(newScope));
        }
    }

    private void introspectDeferredTasksInDatabaseSession(@NotNull BasicDatabase db) {
        if (db == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(10);
        }
        String dbName = db.getName();
        ObjectPath dbPath = ObjectPaths.of((DasObject)db);
        try {
            this.reconnectAndDoIntrospectOperation(dbPath, () -> this.myIntrospector.processDeferredTasks());
        }
        catch (SQLException e) {
            LOG.warn("Failed to introspect deferred tasks related to the database " + dbName, (Throwable)e);
        }
    }

    private void checkSingleDbModeNecessity(@Nullable ObjectPath initialPath, @NotNull DatabaseConnectionPoint point, @Nullable String currentDb) {
        String db;
        if (point == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(11);
        }
        if (this.mySingleModeReported || currentDb == null) {
            return;
        }
        if (!JdbcUrlParserUtil.isDatabaseBounded((DatabaseConnectionPoint)point) || !JdbcUrlParserUtil.isReboundable((DatabaseConnectionPoint)point)) {
            return;
        }
        String string = db = initialPath == null ? JdbcUrlParserUtil.getBoundParameter((DatabaseConnectionPoint)point) : initialPath.name;
        if (db == null || db.equalsIgnoreCase(currentDb)) {
            return;
        }
        String dataSourceName = this.myLoaderContext.getDataSource().getName();
        ConnDatabaseNotifications.DATABASE_VIEW_GROUP().createNotification(dataSourceName, DatabaseBundle.message((String)"notification.content.connection.to.expected.but.connected.to", (Object[])new Object[]{db, currentDb}), NotificationType.WARNING).setDisplayId("DatabaseModelLoader.single.db.mode.required").setListener(this::hyperlinkUpdate).notify(this.myLoaderContext.getProject());
        this.mySingleModeReported = true;
    }

    private void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
        if (notification == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(12);
        }
        if (event == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(13);
        }
        if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        if (event.getDescription().equals("ignore")) {
            this.myLoaderContext.getDataSource().setAdditionalProperty(SINGLE_DB_WARNING, "true");
        } else if (event.getDescription().equals("enable")) {
            this.setSingleDbMode();
        }
    }

    private void setSingleDbMode() {
        this.myLoaderContext.getDataSource().setRewriteBounds(false);
        DataSourceUtil.performAutoSyncTask(this.myLoaderContext);
    }

    @Nullable
    private String guessInitialDatabase(@NotNull TreePattern desiredIntrospectionScope) {
        NamingFamily databases;
        LocalDataSource dataSource;
        if (desiredIntrospectionScope == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(14);
        }
        if (!JdbcUrlParserUtil.isDatabaseBounded((DatabaseConnectionPoint)(dataSource = this.myLoaderContext.getDataSource())) || !JdbcUrlParserUtil.isReboundable((DatabaseConnectionPoint)dataSource)) {
            return null;
        }
        if (dataSource.getDbms().in(Dbms.AZURE_LIKE)) {
            return null;
        }
        BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)this.myLoaderContext.getDataSource().getModel(), BasicModel.class);
        NamingFamily namingFamily = databases = model == null ? null : (NamingFamily)ObjectUtils.tryCast((Object)model.getRoot().familyOf(ObjectKind.DATABASE), NamingFamily.class);
        if (databases == null || databases.isEmpty()) {
            return null;
        }
        TreePattern scope = dataSource.getIntrospectionScope();
        TreePattern intersection = TreePatternUtils.intersect((TreePattern[])new TreePattern[]{scope, desiredIntrospectionScope});
        if (!JdbcUrlParserUtil.outOfBounds((DatabaseConnectionPoint)this.myLoaderContext.getDataSource(), (TreePattern)intersection)) {
            return null;
        }
        return DatabaseIntrospectionSession.get1stMatchingDatabase(intersection, databases, db -> !this.myLoaderContext.getScopeUpdater().isRemoved(db));
    }

    @Nullable
    private static String get1stMatchingDatabase(@NotNull TreePattern intersection, @NotNull NamingFamily<?> databases, @NotNull Predicate<? super BasicNamespace> predicate) {
        if (intersection == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(15);
        }
        if (databases == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(16);
        }
        if (predicate == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(17);
        }
        Condition existingDb = x -> {
            if ("*".equals(x)) {
                return false;
            }
            BasicMateNamespace db = (BasicMateNamespace)databases.get(x);
            return db != null && predicate.test((BasicNamespace)db);
        };
        TreePatternNode.Group group = intersection.root.getGroup(ObjectKind.DATABASE);
        if (group == null || group.children == null) {
            return null;
        }
        return (String)JBIterable.of((Object[])group.children).flatten(g -> JBIterable.of((Object[])g.naming.names)).transform(ObjectName::name).filter(existingDb).first();
    }

    public void connectAndDoIntrospectOperation(@Nullable ObjectPath dbPath, @NotNull Runnable operation) throws SQLException {
        if (operation == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(18);
        }
        this.performDbSpecificOperation(dbPath, false, (ThrowableConsumer<DatabaseConnection, Exception>)((ThrowableConsumer)connection2 -> this.handlingException((DatabaseConnection)connection2, (ThrowableConsumer<DatabaseConnection, Exception>)((ThrowableConsumer)connection22 -> {
            this.prepareIntrospectorIfNeeded((DatabaseConnection)connection22);
            this.myIndicator.setText(DatabaseBundle.message((String)"progress.text.performing.introspection.default.db", (Object[])new Object[]{this.myFirstTime ? 0 : 1, connection22.getDbms().getDisplayName()}));
            try {
                this.myIntrospector.attachToDB((DatabaseConnectionCore)connection22);
                this.checkSingleDbModeNecessity(dbPath, connection2.getConnectionPoint(), this.myIntrospector.getCurrentDatabase());
                operation.run();
            }
            finally {
                this.myIntrospector.detachFromDB();
            }
        }))));
    }

    public void reconnectAndDoIntrospectOperation(@NotNull ObjectPath dbPath, @NotNull Runnable operation) throws SQLException {
        if (dbPath == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(19);
        }
        if (operation == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(20);
        }
        this.performDbSpecificOperation(dbPath, true, (ThrowableConsumer<DatabaseConnection, Exception>)((ThrowableConsumer)connection2 -> this.handlingException((DatabaseConnection)connection2, (ThrowableConsumer<DatabaseConnection, Exception>)((ThrowableConsumer)connection22 -> {
            this.prepareIntrospectorIfNeeded((DatabaseConnection)connection22);
            this.myIndicator.setText(DatabaseBundle.message((String)"progress.text.performing.introspection", (Object[])new Object[]{this.myFirstTime ? 0 : 1, connection22.getDbms().getDisplayName(), dbPath.kind.getPresentableName(), dbPath.getName()}));
            try {
                this.myIntrospector.attachToDB((DatabaseConnectionCore)connection22);
                this.checkSingleDbModeNecessity(dbPath, connection2.getConnectionPoint(), this.myIntrospector.getCurrentDatabase());
                operation.run();
            }
            finally {
                this.myIntrospector.detachFromDB();
            }
        }))));
    }

    private void prepareIntrospectorIfNeeded(@NotNull DatabaseConnection connection2) {
        if (connection2 == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(21);
        }
        if (!this.myIntrospectorPrepared) {
            this.myIndicator.setText(DatabaseBundle.message((String)"progress.text.performing.introspection.preparing.introspector", (Object[])new Object[0]));
            this.closeSrcSession();
            this.initIntrospector(connection2);
            this.myIntrospectorPrepared = true;
        }
    }

    private void initIntrospector(@NotNull DatabaseConnection databaseConnection) {
        if (databaseConnection == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(22);
        }
        this.myIntrospector.attachToDB((DatabaseConnectionCore)databaseConnection);
        this.myIntrospector.setProgressIndicator(this.myIndicator);
        BasicModModel model = this.myIntrospector.getModel();
        ModelTextStorage modelTextStorage = model.getTextStorage();
        if (modelTextStorage instanceof DbSrcModelStorage) {
            DbSrcModelStorage storage = (DbSrcModelStorage)modelTextStorage;
            this.mySrcSession = storage.startWriteSession(this.myLoaderContext.getProject(), (BasicModel)model, this.myModality, false, true);
        }
    }

    private void closeSrcSession() {
        try {
            if (this.mySrcSession != null) {
                this.mySrcSession.close();
            }
        }
        finally {
            this.mySrcSession = null;
        }
    }

    @NotNull
    private ModelFactory createModelFactory(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(23);
        }
        DbSrcModelStorageService storageService = DbSrcModelStorageService.getInstance();
        @Nullable Project dataSourceProject = dataSource.isGlobal() ? null : this.myLoaderContext.getProject();
        ModelFactory modelFactory = storageService.createFactory(dataSourceProject, dataSource.getUniqueId());
        if (modelFactory == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(24);
        }
        return modelFactory;
    }

    private void handlingException(@NotNull DatabaseConnection connection2, @NotNull @NotNull ThrowableConsumer<@NotNull DatabaseConnection, Exception> consumer) {
        if (connection2 == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(25);
        }
        if (consumer == null) {
            DatabaseIntrospectionSession.$$$reportNull$$$0(26);
        }
        try {
            consumer.consume((Object)connection2);
        }
        catch (DbmsMismatchException e) {
            throw e;
        }
        catch (Throwable e) {
            AsyncUtil.addUnhandledError((ErrorHandler)this.myLoaderContext.getErrorHandler(), (Throwable)e, (LocalDataSource)this.myLoaderContext.getDataSource(), (Project)this.getProject());
            throw new IntrospectionPce();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loaderContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/introspection/DatabaseIntrospectionSession";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "db";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desiredIntrospectionScope";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intersection";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databases";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbPath";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseConnection";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/introspection/DatabaseIntrospectionSession";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoaderContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntrospector";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createModelFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 24: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "introspectTasksInDifferentSessions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "introspectTasksInDefaultSession";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "introspectTasksInDatabaseSession";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performTasksInTheConnectedSession";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "introspectDeferredTasksInDatabaseSession";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkSingleDbModeNecessity";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hyperlinkUpdate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "guessInitialDatabase";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "get1stMatchingDatabase";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "connectAndDoIntrospectOperation";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "reconnectAndDoIntrospectOperation";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "prepareIntrospectorIfNeeded";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "initIntrospector";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createModelFactory";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "handlingException";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 24 -> new IllegalStateException(string);
        };
    }

    private static class IntrospectionPce
    extends ProcessCanceledException {
        private IntrospectionPce() {
        }
    }
}

