/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.config;

import com.intellij.lang.javascript.config.JSConfig;
import com.intellij.lang.javascript.config.JSFileImports;
import com.intellij.lang.javascript.config.JSFileImportsResolver;
import com.intellij.lang.javascript.config.JSImportResolveContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b'\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0016J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lcom/intellij/lang/javascript/config/JSFileImportsBase;", "Lcom/intellij/lang/javascript/config/JSFileImports;", "project", "Lcom/intellij/openapi/project/Project;", "myContext", "Lcom/intellij/lang/javascript/config/JSImportResolveContext;", "myResolver", "Lcom/intellij/lang/javascript/config/JSFileImportsResolver;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/javascript/config/JSImportResolveContext;Lcom/intellij/lang/javascript/config/JSFileImportsResolver;)V", "config", "Lcom/intellij/lang/javascript/config/JSConfig;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/javascript/config/JSConfig;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getMyContext", "()Lcom/intellij/lang/javascript/config/JSImportResolveContext;", "getMyResolver", "()Lcom/intellij/lang/javascript/config/JSFileImportsResolver;", "startCaching", "", "stopCaching", "resolveFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "moduleName", "", "containingFile", "equals", "", "o", "", "hashCode", "", "intellij.javascript.backend"})
@ApiStatus.Internal
public abstract class JSFileImportsBase
implements JSFileImports {
    @NotNull
    private final Project project;
    @NotNull
    private final JSImportResolveContext myContext;
    @NotNull
    private final JSFileImportsResolver myResolver;

    public JSFileImportsBase(@NotNull Project project, @NotNull JSImportResolveContext myContext, @NotNull JSFileImportsResolver myResolver) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)myContext, (String)"myContext");
        Intrinsics.checkNotNullParameter((Object)myResolver, (String)"myResolver");
        this.project = project;
        this.myContext = myContext;
        this.myResolver = myResolver;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final JSImportResolveContext getMyContext() {
        return this.myContext;
    }

    @NotNull
    protected final JSFileImportsResolver getMyResolver() {
        return this.myResolver;
    }

    public JSFileImportsBase(@NotNull Project project, @NotNull JSConfig config) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        JSImportResolveContext jSImportResolveContext = config.getResolveContext();
        Intrinsics.checkNotNullExpressionValue((Object)jSImportResolveContext, (String)"getResolveContext(...)");
        JSFileImportsResolver jSFileImportsResolver = config.getImportResolver();
        Intrinsics.checkNotNullExpressionValue((Object)jSFileImportsResolver, (String)"getImportResolver(...)");
        this(project, jSImportResolveContext, jSFileImportsResolver);
    }

    public void startCaching() {
        this.myResolver.startCaching();
    }

    public void stopCaching() {
        this.myResolver.stopCaching();
    }

    @Nullable
    public VirtualFile resolveFile(@NotNull String moduleName, @NotNull VirtualFile containingFile) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
        return this.myResolver.resolveFileModule(moduleName, containingFile);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !Intrinsics.areEqual(this.getClass(), o.getClass())) {
            return false;
        }
        JSFileImportsBase base = (JSFileImportsBase)o;
        return Intrinsics.areEqual((Object)this.myContext, (Object)base.myContext);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.myContext};
        return Objects.hash(objectArray);
    }
}

