/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.impl;

import com.intellij.jsp.JavaeeJspBundle;
import com.intellij.jsp.impl.CustomTagSupportUtil;
import com.intellij.jsp.impl.TldAttributeDescriptor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TldAttributeDescriptorImpl
extends BasicXmlAttributeDescriptor
implements PsiWritableMetaData,
TldAttributeDescriptor {
    private XmlTag myTag;
    private String myName;
    private String myType;
    private boolean myRequired;
    private boolean myFragment;
    private CustomTagSupportUtil.ValueAccessor myValueAccessor;
    private String[] myPossibleValues;
    @NonNls
    private static final String VALUES_PREFIX = "@values[";
    private static final String VALUES_SUFFIX = "]";
    private static final String VALUES_DELIMETER = ",";
    private String myMethodSignature;
    private boolean myDeferred;
    private boolean myDynamic;

    public TldAttributeDescriptorImpl() {
        this.myValueAccessor = CustomTagSupportUtil.ValueAccessor.SUB_TAG_ACCESSOR;
    }

    public TldAttributeDescriptorImpl(XmlTag tag, CustomTagSupportUtil.ValueAccessor valueAccessor) {
        this.myValueAccessor = valueAccessor;
        this.init((PsiElement)tag);
    }

    public String getDefaultName() {
        return this.getName();
    }

    public boolean isRequired() {
        return this.myRequired;
    }

    public boolean isFixed() {
        return false;
    }

    public boolean hasIdType() {
        return false;
    }

    public boolean hasIdRefType() {
        return false;
    }

    public String getDefaultValue() {
        return null;
    }

    public boolean isEnumerated() {
        return false;
    }

    public String[] getEnumeratedValues() {
        return this.myPossibleValues;
    }

    public PsiElement getDeclaration() {
        return this.myTag;
    }

    public String getName() {
        return this.myName;
    }

    public void init(PsiElement element) {
        XmlTag methodTag;
        String description;
        this.myTag = (XmlTag)element;
        if ("http://java.sun.com/JSP/Page".equals(this.myTag.getNamespace())) {
            this.myValueAccessor = CustomTagSupportUtil.ValueAccessor.ATTRIBUTE_ACCESSOR;
        }
        this.myName = this.myValueAccessor.getValue(this.myTag, "name");
        this.myRequired = CustomTagSupportUtil.isTrue(this.myValueAccessor.getValue(this.myTag, "required"));
        this.myFragment = Boolean.parseBoolean(this.myValueAccessor.getValue(this.myTag, "fragment"));
        this.myDynamic = Boolean.parseBoolean(this.myValueAccessor.getValue(this.myTag, "rtexprvalue"));
        this.myType = this.myValueAccessor.getValue(this.myTag, "type");
        XmlTag deferredValueTag = this.myTag.findFirstSubTag("deferred-value");
        if (deferredValueTag != null) {
            this.myDeferred = true;
            if (this.myType == null) {
                this.myType = CustomTagSupportUtil.ValueAccessor.SUB_TAG_ACCESSOR.getValue(deferredValueTag, "type");
            }
        }
        if ((description = this.myValueAccessor.getValue(this.myTag, "description")) != null) {
            this.setupPossibleValues(description);
        }
        if ((methodTag = this.myTag.findFirstSubTag("deferred-method")) != null) {
            this.myDeferred = true;
            this.myMethodSignature = CustomTagSupportUtil.ValueAccessor.SUB_TAG_ACCESSOR.getValue(methodTag, "method-signature");
        } else {
            this.myMethodSignature = this.guessMethodSignature();
        }
    }

    @Nullable
    private String guessMethodSignature() {
        @NonNls String localName = this.myName;
        if ("action".equals(localName)) {
            return null;
        }
        if ("valueChangeListener".equals(localName)) {
            return "void action( javax.faces.event.ValueChangeEvent ) ";
        }
        if ("validator".equals(localName)) {
            return "void validate(javax.faces.context.FacesContext, javax.faces.component.UIComponent, java.lang.Object)";
        }
        if ("beforePhase".equals(localName) || "afterPhase".equals(localName)) {
            return "void beforePhase(javax.faces.event.PhaseEvent)";
        }
        if ("actionListener".equals(localName)) {
            return "void action( javax.faces.event.ActionEvent ) ";
        }
        return null;
    }

    private void setupPossibleValues(String value) {
        int valuesStart = value.indexOf(VALUES_PREFIX);
        if (valuesStart >= 0) {
            ArrayList<String> values = new ArrayList<String>();
            int prefixLength = VALUES_PREFIX.length();
            String valuesString = value.substring(valuesStart + prefixLength, value.indexOf(VALUES_SUFFIX, valuesStart + prefixLength));
            StringTokenizer tokenizer = new StringTokenizer(valuesString, VALUES_DELIMETER);
            while (tokenizer.hasMoreTokens()) {
                values.add(tokenizer.nextToken());
            }
            this.myPossibleValues = ArrayUtilRt.toStringArray(values);
        }
    }

    public Object @NotNull [] getDependencies() {
        Object[] objectArray = new Object[]{this.myTag};
        if (objectArray == null) {
            TldAttributeDescriptorImpl.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    public void setName(String name) throws IncorrectOperationException {
        this.myName = name.substring(name.indexOf(58) + 1);
        this.myValueAccessor.setValue(this.myTag, "name", this.myName);
    }

    public String getType() {
        return this.myType;
    }

    public boolean isDeferred() {
        return this.myDeferred;
    }

    public boolean isDynamic() {
        return this.myDynamic;
    }

    public String validateValue(XmlElement context, String value) {
        PsiElement parentElement;
        String message = super.validateValue(context, value);
        if (message == null && this.myFragment && (parentElement = context.getParent()) instanceof XmlAttribute) {
            return JavaeeJspBundle.message("fragment.attribute.value.should.be.specified.with.jsp.attribute", new Object[0]);
        }
        return message;
    }

    public boolean isIndirectSyntax() {
        return this.myFragment;
    }

    public String getMethodSignature() {
        return this.myMethodSignature;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsp/impl/TldAttributeDescriptorImpl", "getDependencies"));
    }
}

