/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.canvas;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.canvas.Canvas;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.core.canvas.Font;
import org.jetbrains.letsPlot.core.canvas.LineCap;
import org.jetbrains.letsPlot.core.canvas.LineJoin;
import org.jetbrains.letsPlot.core.canvas.TextAlign;
import org.jetbrains.letsPlot.core.canvas.TextBaseline;
import org.jetbrains.letsPlot.core.canvas.TextMetrics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 p2\u00020\u0001:\u0001pB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J8\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016J8\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016J0\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004H\u0016JP\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004H\u0016JH\u0010'\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010+\u001a\u00020\u0007H\u0016J\b\u0010,\u001a\u00020\u0007H\u0016J(\u0010-\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004H\u0016J \u00100\u001a\u00020\u00072\u0006\u00101\u001a\u0002022\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0018\u00103\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000202H\u0016J\u0010\u00107\u001a\u00020\u00042\u0006\u00106\u001a\u000202H\u0016J\u0018\u00108\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016J\b\u00109\u001a\u00020\u0007H\u0016J\u0010\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u0004H\u0016J\b\u0010<\u001a\u00020\u0007H\u0016J\u0010\u0010=\u001a\u00020\u00072\u0006\u0010>\u001a\u00020\u0004H\u0016J\u0018\u0010=\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010?\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020@H\u0002J\u0010\u0010?\u001a\u00020B2\u0006\u0010C\u001a\u00020BH\u0002J\u0012\u0010D\u001a\u00020\u00072\b\u0010E\u001a\u0004\u0018\u00010FH\u0016J\u0010\u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020BH\u0016J\u0010\u0010I\u001a\u00020\u00072\u0006\u0010J\u001a\u00020\u0004H\u0016J\u0010\u0010K\u001a\u00020\u00072\u0006\u0010L\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u00020\u00072\u0006\u0010O\u001a\u00020@H\u0016J\u0010\u0010P\u001a\u00020\u00072\u0006\u0010Q\u001a\u00020\u0004H\u0016J\u0010\u0010R\u001a\u00020\u00072\u0006\u0010S\u001a\u00020TH\u0016J\u0010\u0010U\u001a\u00020\u00072\u0006\u0010V\u001a\u00020\u0004H\u0016J\u0010\u0010W\u001a\u00020\u00072\u0006\u0010X\u001a\u00020\u0004H\u0016J\u0012\u0010Y\u001a\u00020\u00072\b\u0010E\u001a\u0004\u0018\u00010FH\u0016J\u0010\u0010Z\u001a\u00020\u00072\u0006\u0010[\u001a\u00020\\H\u0016J\u0010\u0010]\u001a\u00020\u00072\u0006\u0010^\u001a\u00020_H\u0016J8\u0010`\u001a\u00020\u00072\u0006\u0010a\u001a\u00020\u00042\u0006\u0010b\u001a\u00020\u00042\u0006\u0010c\u001a\u00020\u00042\u0006\u0010d\u001a\u00020\u00042\u0006\u0010e\u001a\u00020\u00042\u0006\u0010f\u001a\u00020\u0004H\u0016J\b\u0010g\u001a\u00020\u0007H\u0016J(\u0010h\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004H\u0016J \u0010i\u001a\u00020\u00072\u0006\u00101\u001a\u0002022\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016J8\u0010j\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00042\u0006\u0010k\u001a\u00020\u00042\u0006\u0010l\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010m\u001a\u00020\u00042\u0006\u0010n\u001a\u00020\u0004H\u0016J\u0018\u0010o\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006q"}, d2={"Lorg/jetbrains/letsPlot/core/canvas/ScaledContext2d;", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "ctx", "myScale", "", "(Lorg/jetbrains/letsPlot/core/canvas/Context2d;D)V", "arc", "", "x", "y", "radius", "startAngle", "endAngle", "anticlockwise", "", "beginPath", "bezierCurveTo", "cp1x", "cp1y", "cp2x", "cp2y", "clearRect", "rect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "clip", "closePath", "descaled", "value", "drawImage", "snapshot", "Lorg/jetbrains/letsPlot/core/canvas/Canvas$Snapshot;", "dw", "dh", "sx", "sy", "sw", "sh", "dx", "dy", "ellipse", "radiusX", "radiusY", "rotation", "fill", "fillEvenOdd", "fillRect", "w", "h", "fillText", "text", "", "lineTo", "measureText", "Lorg/jetbrains/letsPlot/core/canvas/TextMetrics;", "str", "measureTextWidth", "moveTo", "restore", "rotate", "angle", "save", "scale", "xy", "scaled", "", "values", "Lorg/jetbrains/letsPlot/core/canvas/Font;", "font", "setFillStyle", "color", "Lorg/jetbrains/letsPlot/commons/values/Color;", "setFont", "f", "setGlobalAlpha", "alpha", "setLineCap", "lineCap", "Lorg/jetbrains/letsPlot/core/canvas/LineCap;", "setLineDash", "lineDash", "setLineDashOffset", "lineDashOffset", "setLineJoin", "lineJoin", "Lorg/jetbrains/letsPlot/core/canvas/LineJoin;", "setLineWidth", "lineWidth", "setStrokeMiterLimit", "miterLimit", "setStrokeStyle", "setTextAlign", "align", "Lorg/jetbrains/letsPlot/core/canvas/TextAlign;", "setTextBaseline", "baseline", "Lorg/jetbrains/letsPlot/core/canvas/TextBaseline;", "setTransform", "m00", "m10", "m01", "m11", "m02", "m12", "stroke", "strokeRect", "strokeText", "transform", "ry", "rx", "tx", "ty", "translate", "Companion", "canvas"})
public final class ScaledContext2d
implements Context2d {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context2d ctx;
    private final double myScale;

    private ScaledContext2d(Context2d ctx2, double myScale) {
        this.ctx = ctx2;
        this.myScale = myScale;
    }

    private final double scaled(double value) {
        return this.myScale * value;
    }

    private final double descaled(double value) {
        return value / this.myScale;
    }

    private final double[] scaled(double[] values2) {
        if (this.myScale == 1.0) {
            return values2;
        }
        double[] res = new double[values2.length];
        int n = values2.length;
        for (int i = 0; i < n; ++i) {
            res[i] = this.scaled(values2[i]);
        }
        return res;
    }

    private final Font scaled(Font font) {
        return Font.copy$default(font, null, null, this.scaled(font.getFontSize()), null, 11, null);
    }

    @Override
    public void drawImage(@NotNull Canvas.Snapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        this.drawImage(snapshot, 0.0, 0.0);
    }

    @Override
    public void drawImage(@NotNull Canvas.Snapshot snapshot, double x2, double y2) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        this.ctx.drawImage(snapshot, this.scaled(x2), this.scaled(y2));
    }

    @Override
    public void drawImage(@NotNull Canvas.Snapshot snapshot, double x2, double y2, double dw, double dh) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        this.ctx.drawImage(snapshot, this.scaled(x2), this.scaled(y2), this.scaled(dw), this.scaled(dh));
    }

    @Override
    public void drawImage(@NotNull Canvas.Snapshot snapshot, double sx, double sy, double sw, double sh, double dx, double dy, double dw, double dh) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        this.ctx.drawImage(snapshot, this.scaled(sx), this.scaled(sy), this.scaled(sw), this.scaled(sh), this.scaled(dx), this.scaled(dy), this.scaled(dw), this.scaled(dh));
    }

    @Override
    public void beginPath() {
        this.ctx.beginPath();
    }

    @Override
    public void closePath() {
        this.ctx.closePath();
    }

    @Override
    public void clip() {
        this.ctx.clip();
    }

    @Override
    public void stroke() {
        this.ctx.stroke();
    }

    @Override
    public void fill() {
        this.ctx.fill();
    }

    @Override
    public void fillRect(double x2, double y2, double w, double h) {
        this.ctx.fillRect(this.scaled(x2), this.scaled(y2), this.scaled(w), this.scaled(h));
    }

    @Override
    public void moveTo(double x2, double y2) {
        this.ctx.moveTo(this.scaled(x2), this.scaled(y2));
    }

    @Override
    public void lineTo(double x2, double y2) {
        this.ctx.lineTo(this.scaled(x2), this.scaled(y2));
    }

    @Override
    public void arc(double x2, double y2, double radius, double startAngle, double endAngle, boolean anticlockwise) {
        this.ctx.arc(this.scaled(x2), this.scaled(y2), this.scaled(radius), startAngle, endAngle, anticlockwise);
    }

    @Override
    public void ellipse(double x2, double y2, double radiusX, double radiusY, double rotation, double startAngle, double endAngle, boolean anticlockwise) {
        this.ctx.ellipse(this.scaled(x2), this.scaled(y2), this.scaled(radiusX), this.scaled(radiusY), rotation, startAngle, endAngle, anticlockwise);
    }

    @Override
    public void save() {
        this.ctx.save();
    }

    @Override
    public void restore() {
        this.ctx.restore();
    }

    @Override
    public void setFillStyle(@Nullable Color color) {
        this.ctx.setFillStyle(color);
    }

    @Override
    public void setStrokeStyle(@Nullable Color color) {
        this.ctx.setStrokeStyle(color);
    }

    @Override
    public void setGlobalAlpha(double alpha) {
        this.ctx.setGlobalAlpha(alpha);
    }

    @Override
    public void setFont(@NotNull Font f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        this.ctx.setFont(this.scaled(f));
    }

    @Override
    public void setLineWidth(double lineWidth) {
        this.ctx.setLineWidth(this.scaled(lineWidth));
    }

    @Override
    public void strokeRect(double x2, double y2, double w, double h) {
        this.ctx.strokeRect(this.scaled(x2), this.scaled(y2), this.scaled(w), this.scaled(h));
    }

    @Override
    public void strokeText(@NotNull String text2, double x2, double y2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.ctx.strokeText(text2, this.scaled(x2), this.scaled(y2));
    }

    @Override
    public void fillText(@NotNull String text2, double x2, double y2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.ctx.fillText(text2, this.scaled(x2), this.scaled(y2));
    }

    @Override
    public void scale(double x2, double y2) {
        this.ctx.scale(x2, y2);
    }

    @Override
    public void scale(double xy2) {
        this.scale(xy2, xy2);
    }

    @Override
    public void rotate(double angle) {
        this.ctx.rotate(angle);
    }

    @Override
    public void translate(double x2, double y2) {
        this.ctx.translate(this.scaled(x2), this.scaled(y2));
    }

    @Override
    public void transform(double sx, double ry, double rx, double sy, double tx, double ty) {
        this.ctx.transform(sx, ry, rx, sy, this.scaled(tx), this.scaled(ty));
    }

    @Override
    public void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x2, double y2) {
        this.ctx.bezierCurveTo(this.scaled(cp1x), this.scaled(cp1y), this.scaled(cp2x), this.scaled(cp2y), this.scaled(x2), this.scaled(y2));
    }

    @Override
    public void setLineJoin(@NotNull LineJoin lineJoin) {
        Intrinsics.checkNotNullParameter((Object)((Object)lineJoin), (String)"lineJoin");
        this.ctx.setLineJoin(lineJoin);
    }

    @Override
    public void setLineCap(@NotNull LineCap lineCap) {
        Intrinsics.checkNotNullParameter((Object)((Object)lineCap), (String)"lineCap");
        this.ctx.setLineCap(lineCap);
    }

    @Override
    public void setStrokeMiterLimit(double miterLimit) {
        this.ctx.setStrokeMiterLimit(miterLimit);
    }

    @Override
    public void setTextBaseline(@NotNull TextBaseline baseline) {
        Intrinsics.checkNotNullParameter((Object)((Object)baseline), (String)"baseline");
        this.ctx.setTextBaseline(baseline);
    }

    @Override
    public void setTextAlign(@NotNull TextAlign align) {
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        this.ctx.setTextAlign(align);
    }

    @Override
    public void setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.ctx.setTransform(m00, m10, m01, m11, this.scaled(m02), this.scaled(m12));
    }

    @Override
    public void fillEvenOdd() {
        this.ctx.fillEvenOdd();
    }

    @Override
    public void setLineDash(@NotNull double[] lineDash) {
        Intrinsics.checkNotNullParameter((Object)lineDash, (String)"lineDash");
        this.ctx.setLineDash(this.scaled(lineDash));
    }

    @Override
    public void setLineDashOffset(double lineDashOffset) {
        this.ctx.setLineDashOffset(lineDashOffset);
    }

    @Override
    public double measureTextWidth(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return this.descaled(this.ctx.measureTextWidth(str));
    }

    @Override
    @NotNull
    public TextMetrics measureText(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        TextMetrics metrics = this.ctx.measureText(str);
        return new TextMetrics(this.descaled(metrics.getAscent()), this.descaled(metrics.getDescent()), new DoubleRectangle(this.descaled(metrics.getBbox().getLeft()), this.descaled(metrics.getBbox().getTop()), this.descaled(metrics.getBbox().getWidth()), this.descaled(metrics.getBbox().getHeight())));
    }

    @Override
    public void clearRect(@NotNull DoubleRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        this.ctx.clearRect(new DoubleRectangle(this.scaled(rect2.getLeft()), this.scaled(rect2.getTop()), this.scaled(rect2.getWidth()), this.scaled(rect2.getHeight())));
    }

    @Override
    public void drawBezierCurve(@NotNull List<? extends Vec<?>> points2) {
        Context2d.DefaultImpls.drawBezierCurve(this, points2);
    }

    public /* synthetic */ ScaledContext2d(Context2d ctx2, double myScale, DefaultConstructorMarker $constructor_marker) {
        this(ctx2, myScale);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/core/canvas/ScaledContext2d$Companion;", "", "()V", "wrap", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "ctx", "pixelDensity", "", "canvas"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Context2d wrap(@NotNull Context2d ctx2, double pixelDensity) {
            Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
            if (pixelDensity == 1.0) {
                return ctx2;
            }
            return new ScaledContext2d(ctx2, pixelDensity, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

