/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.remotebrowser;

import com.intellij.ide.CopyPasteSupport;
import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerItemsDeleteProvider;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd.MoveCopyPasteSupport;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd.MyDnDSource;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd.MyDnDTarget;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerTree
extends ProjectViewTree {
    private final CopyPasteSupport myCopyPasteSupport = new MoveCopyPasteSupport();
    @Nullable
    private final Project myProject;
    private Deployable myServer;
    private PublishConfig myConfig;

    public ServerTree(@Nullable Project project, @Nullable Deployable server, ServerTreeNode root) {
        super((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode((Object)root)));
        this.myProject = project;
        this.myServer = server;
        this.enableDnD();
        TreeSpeedSearch.installOn((JTree)((Object)this));
    }

    public void setServer(@Nullable Deployable server) {
        this.myServer = server;
    }

    public void setConfig(PublishConfig config) {
        this.myConfig = config;
    }

    public Color getFileColorFor(Object object) {
        SimpleTextAttributes attr;
        if (object instanceof ServerTreeNode && (attr = ((ServerTreeNode)((Object)object)).getNameAttributes()) != null) {
            return attr.getBgColor();
        }
        return super.getFileColorFor(object);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            ServerTree.$$$reportNull$$$0(0);
        }
        super.uiDataSnapshot(sink);
        sink.set(WebDeploymentDataKeys.REMOTE_ITEMS, (Object)this.getSelectedFileObjects());
        sink.set(WebDeploymentDataKeys.SERVER_TREE, (Object)this);
        sink.set(WebDeploymentDataKeys.DEPLOYABLE, (Object)this.myServer);
        sink.set(WebDeploymentDataKeys.SERVER_NODES, (Object)this.getSelectedNodes());
        sink.set(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, (Object)new ServerItemsDeleteProvider());
        sink.set(PlatformDataKeys.CUT_PROVIDER, (Object)this.myCopyPasteSupport.getCutProvider());
        sink.set(PlatformDataKeys.COPY_PROVIDER, (Object)this.myCopyPasteSupport.getCopyProvider());
        sink.set(PlatformDataKeys.PASTE_PROVIDER, (Object)this.myCopyPasteSupport.getPasteProvider());
        ServerTreeNode rootNode = (ServerTreeNode)((Object)TreeUtil.getUserObject((Object)this.getModel().getRoot()));
        sink.set(WebDeploymentDataKeys.REMOTE_CONNECTION, (Object)(rootNode == null ? null : rootNode.getOpenRemoteConnection()));
        if (this.myConfig != null) {
            sink.set(WebDeploymentDataKeys.PUBLISH_CONFIG, (Object)this.myConfig);
        } else if (this.myProject != null) {
            sink.set(WebDeploymentDataKeys.PUBLISH_CONFIG, (Object)PublishConfig.getInstance(this.myProject));
        }
        if (this.myServer == null || this.myProject == null || this.myProject.isDisposed() || this.myProject.isDefault()) {
            return;
        }
        FileObject[] objects = this.getSelectedFileObjects();
        sink.lazy(CommonDataKeys.NAVIGATABLE_ARRAY, () -> {
            ArrayList<OpenFileDescriptor> result = new ArrayList<OpenFileDescriptor>();
            for (VirtualFile vFile : this.getMappedLocalItems(false, objects)) {
                result.add(new OpenFileDescriptor(this.myProject, vFile));
            }
            return result.toArray(Navigatable.EMPTY_NAVIGATABLE_ARRAY);
        });
        sink.lazy(CommonDataKeys.NAVIGATABLE, () -> {
            VirtualFile[] files = this.getMappedLocalItems(false, objects);
            return files.length > 0 ? new OpenFileDescriptor(this.myProject, files[0]) : null;
        });
        sink.lazy(WebDeploymentDataKeys.MAPPED_LOCAL_ITEMS, () -> this.getMappedLocalItems(true, objects));
        sink.lazy(SelectInContext.DATA_KEY, () -> {
            VirtualFile[] files = this.getMappedLocalItems(true, objects);
            return files.length > 0 ? new FileSelectInContext(this.myProject, files[0], null) : null;
        });
    }

    public ServerTreeNode[] getSelectedNodes() {
        ArrayList<ServerTreeNode> result = new ArrayList<ServerTreeNode>();
        TreePath[] treePaths = this.getSelectionModel().getSelectionPaths();
        if (treePaths == null) {
            return new ServerTreeNode[0];
        }
        for (TreePath treePath : treePaths) {
            ServerTreeNode serverTreeNode = ServerTree.getServerTreeNode(treePath);
            if (serverTreeNode == null) continue;
            result.add(serverTreeNode);
        }
        return result.toArray(new ServerTreeNode[0]);
    }

    @Nullable
    public static ServerTreeNode getServerTreeNode(TreePath treePath) {
        Object o = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        return o instanceof ServerTreeNode ? (ServerTreeNode)((Object)o) : null;
    }

    private FileObject[] getSelectedFileObjects() {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (ServerTreeNode node : this.getSelectedNodes()) {
            FileObject fileObject = node.getFileObject();
            if (fileObject == null) continue;
            result.add(fileObject);
        }
        return result.toArray(new FileObject[0]);
    }

    private VirtualFile[] getMappedLocalItems(boolean ignoreExcludedPaths, FileObject[] objects) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (FileObject deployedItem : objects) {
            DeploymentPathMapping mapping = (DeploymentPathMapping)PublishConfig.getInstance(this.myProject).getNearestMappingDeploy2Local(deployedItem, false, (Mappable)this.myServer, ignoreExcludedPaths).getFirst();
            if (mapping == null) continue;
            String localPath = mapping.mapToLocalPath(deployedItem.getName(), (Mappable)this.myServer);
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(localPath);
            if (vFile == null) continue;
            result.add(vFile);
        }
        return VfsUtilCore.toVirtualFileArray(result);
    }

    public Project getProject() {
        return this.myProject;
    }

    public Deployable getServer() {
        return this.myServer;
    }

    private void enableDnD() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && this.myProject != null && !this.myProject.isDefault()) {
            DnDManager.getInstance().registerTarget((DnDTarget)new MyDnDTarget(this), (JComponent)((Object)this));
            DnDManager.getInstance().registerSource((DnDSource)new MyDnDSource(this), (JComponent)((Object)this));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/ServerTree", "uiDataSnapshot"));
    }
}

