/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.velocity.VtlTypeSystem;
import com.intellij.velocity.psi.VtlArgumentList;
import com.intellij.velocity.psi.VtlCallExpression;
import com.intellij.velocity.psi.VtlCallable;
import com.intellij.velocity.psi.VtlExpression;
import com.intellij.velocity.psi.VtlLanguage;
import com.intellij.velocity.psi.VtlMacro;
import com.intellij.velocity.psi.VtlMethodCallExpression;
import com.intellij.velocity.psi.VtlVariable;
import com.intellij.velocity.psi.VtlVariableType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VtlParameterInfoHandler
implements ParameterInfoHandler<VtlArgumentList, VtlCallable>,
DumbAware {
    public VtlArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        if (context == null) {
            VtlParameterInfoHandler.$$$reportNull$$$0(0);
        }
        return VtlParameterInfoHandler.findArgumentList((ParameterInfoContext)context);
    }

    @Nullable
    private static VtlArgumentList findArgumentList(ParameterInfoContext context) {
        PsiFile file = context.getFile();
        PsiElement elementAt = file.getViewProvider().findElementAt(context.getOffset(), (Language)VtlLanguage.INSTANCE);
        if (elementAt == null) {
            return null;
        }
        VtlCallExpression call = (VtlCallExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, VtlCallExpression.class);
        if (call == null) {
            return null;
        }
        return call.findArgumentList();
    }

    public void showParameterInfo(@NotNull VtlArgumentList element, @NotNull CreateParameterInfoContext context) {
        PsiElement parent;
        if (element == null) {
            VtlParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (context == null) {
            VtlParameterInfoHandler.$$$reportNull$$$0(2);
        }
        if (!((parent = element.getParent()) instanceof VtlCallExpression)) {
            return;
        }
        Object[] candidates = ((VtlCallExpression)parent).getCallableCandidates();
        if (candidates.length == 0) {
            return;
        }
        context.setItemsToShow(candidates);
        context.showHint((PsiElement)element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public VtlArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            VtlParameterInfoHandler.$$$reportNull$$$0(3);
        }
        return VtlParameterInfoHandler.findArgumentList((ParameterInfoContext)context);
    }

    public void updateParameterInfo(@NotNull VtlArgumentList argumentList, @NotNull UpdateParameterInfoContext context) {
        if (argumentList == null) {
            VtlParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            VtlParameterInfoHandler.$$$reportNull$$$0(5);
        }
        assert (argumentList.isValid());
        PsiElement prevOwner = context.getParameterOwner();
        int prevOwnerTextOffset = prevOwner == null ? 0 : prevOwner.getTextOffset();
        context.setParameterOwner((PsiElement)argumentList);
        if (prevOwnerTextOffset != 0 && prevOwnerTextOffset != argumentList.getTextOffset()) {
            context.removeHint();
            context.setCurrentParameter(-1);
            return;
        }
        int offset = context.getEditor().getCaretModel().getOffset() - argumentList.getTextRange().getStartOffset();
        if (offset < 0) {
            context.setCurrentParameter(-1);
            return;
        }
        int index = 0;
        for (ASTNode child : argumentList.getNode().getChildren(null)) {
            PsiElement psiChild = child.getPsi();
            offset -= child.getTextLength();
            if (!(psiChild instanceof VtlExpression)) continue;
            if (offset <= 0) break;
            ++index;
        }
        context.setCurrentParameter(index);
    }

    public void updateUI(VtlCallable callable, @NotNull ParameterInfoUIContext context) {
        PsiElement list;
        if (context == null) {
            VtlParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if (!(list = context.getParameterOwner()).isValid()) {
            return;
        }
        int index = context.getCurrentParameterIndex();
        boolean applicable = VtlParameterInfoHandler.isApplicable(callable, list, index);
        int highlightStart = -1;
        int highlightEnd = -1;
        StringBuilder sb = new StringBuilder();
        VtlVariable[] variables = callable.getParameters();
        boolean isMacro = callable instanceof VtlMacro;
        String delimiter = isMacro ? " " : ", ";
        for (int i = 0; i < variables.length; ++i) {
            VtlVariable variable;
            VtlVariableType type;
            if (i > 0) {
                sb.append(delimiter);
            }
            if (i == index) {
                highlightStart = sb.length();
            }
            if ((type = (variable = variables[i]).getPsiType()) != null) {
                sb.append(type.getPresentableText()).append(" ");
            }
            if (isMacro) {
                sb.append('$');
            }
            sb.append(variable.getName());
            if (i != index) continue;
            highlightEnd = sb.length();
        }
        if (variables.length == 0) {
            sb.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        }
        boolean deprecated = callable.isDeprecated();
        context.setupUIComponentPresentation(sb.toString(), highlightStart, highlightEnd, !applicable, deprecated, false, context.getDefaultParameterColor());
    }

    private static boolean isApplicable(VtlCallable callable, PsiElement list, int index) {
        boolean applicable = callable.getParameters().length > index || index == 0 && callable.getParameters().length == 0;
        PsiElement parent = list.getParent();
        if (applicable && parent instanceof VtlMethodCallExpression) {
            VtlExpression[] arguments = ((VtlMethodCallExpression)parent).getArgumentList().getArguments();
            VtlVariable[] parameters = callable.getParameters();
            for (int i = 0; i < index; ++i) {
                VtlVariableType paramType = parameters[i].getPsiType();
                VtlVariableType argType = arguments[i].getPsiType();
                if (argType == null && paramType == null) continue;
                paramType = VtlTypeSystem.getTypeSystem().getBoxedType(paramType, list);
                if (argType != null && paramType != null && VtlTypeSystem.getTypeSystem().areTypesConvertible(argType, paramType)) continue;
                return false;
            }
        }
        return applicable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
        }
        objectArray2[1] = "com/intellij/velocity/VtlParameterInfoHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForParameterInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showParameterInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateParameterInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateUI";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

