/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.qute.lang.completion;

import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.quarkus.qute.lang.completion.QuteSectionInsertHandlerKt;
import com.intellij.quarkus.qute.lang.psi.PsiQuteSection;
import com.intellij.quarkus.qute.lang.psi.PsiQuteTag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/quarkus/qute/lang/completion/QuteSectionInsertHandler;", "Lcom/intellij/codeInsight/completion/BasicInsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "<init>", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "buildSectionClosingTagString", "", "tagName", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQuteSectionInsertHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuteSectionInsertHandler.kt\ncom/intellij/quarkus/qute/lang/completion/QuteSectionInsertHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class QuteSectionInsertHandler
extends BasicInsertHandler<LookupElement> {
    @NotNull
    public static final QuteSectionInsertHandler INSTANCE = new QuteSectionInsertHandler();

    private QuteSectionInsertHandler() {
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        PsiFile psiFile = context.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        int startOffset = context.getStartOffset();
        PsiElement tagNameElement = file.findElementAt(startOffset);
        PsiQuteTag quteTag = (PsiQuteTag)PsiTreeUtil.getParentOfType((PsiElement)tagNameElement, PsiQuteTag.class);
        if (quteTag == null) {
            QuteSectionInsertHandlerKt.access$getLOG$p().debug("No PsiQuteTag found");
            return;
        }
        String string = item.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
        String lookupString = string;
        PsiQuteSection section = (PsiQuteSection)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(startOffset), PsiQuteSection.class);
        if (section == null) {
            QuteSectionInsertHandlerKt.access$getLOG$p().debug("No PsiQuteSection found");
            return;
        }
        Document document = context.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        PsiElement psiElement = quteTag.getTagOpener();
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            n2 = document2.getLineNumber(it.getTextOffset());
        } else {
            n2 = -1;
        }
        int tagOpenerLine = n2;
        PsiElement psiElement2 = quteTag.getTagCloser();
        if (psiElement2 != null) {
            PsiElement it = psiElement2;
            boolean bl = false;
            n = document2.getLineNumber(it.getTextOffset());
        } else {
            n = -1;
        }
        int tagCloserLine = n;
        boolean hasTagCloser = tagOpenerLine != -1 && tagCloserLine != -1 && tagOpenerLine == tagCloserLine;
        int insertOffset = hasTagCloser ? quteTag.getTextRange().getEndOffset() : context.getEditor().getCaretModel().getOffset();
        String string2 = (hasTagCloser ? "" : "}") + this.buildSectionClosingTagString(lookupString);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String stringToInsert = string2;
        if (((CharSequence)stringToInsert).length() > 0) {
            document2.insertString(insertOffset, (CharSequence)stringToInsert);
            context.commitDocument();
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)context.getProject());
        codeStyleManager.reformat((PsiElement)section);
        EditorModificationUtil.insertStringAtCaret((Editor)context.getEditor(), (String)" ", (boolean)false, (int)1);
    }

    private final String buildSectionClosingTagString(String tagName) {
        return "\n\n{/" + tagName + "}";
    }
}

