/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.cron;

import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.config.QsConfigPlaceholderReference;
import com.intellij.util.text.PlaceholderTextRanges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\u0004\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\b"}, d2={"isQsScheduledCronValue", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "isSimpleValue", "value", "", "qsPropertyReferenceValue", "intellij.quarkus.cron"})
@SourceDebugExtension(value={"SMAP\nqsCronUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 qsCronUtils.kt\ncom/intellij/quarkus/cron/QsCronUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,55:1\n4225#2,11:56\n19#3:67\n*S KotlinDebug\n*F\n+ 1 qsCronUtils.kt\ncom/intellij/quarkus/cron/QsCronUtilsKt\n*L\n45#1:56,11\n46#1:67\n*E\n"})
public final class QsCronUtilsKt {
    public static final boolean isQsScheduledCronValue(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (!QuarkusUtils.INSTANCE.hasQuarkusLibrary(module)) {
            return false;
        }
        UElement uHostElement = UastContextKt.toUElement((PsiElement)psiElement);
        Pair pair = UAnnotationUtils.getContainingUAnnotationEntry((UElement)uHostElement);
        if (pair == null) {
            return false;
        }
        Pair pair2 = pair;
        UAnnotation uAnnotation = (UAnnotation)pair2.component1();
        String annotationParamName = (String)pair2.component2();
        if (annotationParamName == null || Intrinsics.areEqual((Object)"cron", (Object)annotationParamName)) {
            PsiAnnotation psiAnnotation = uAnnotation.getJavaPsi();
            if (psiAnnotation == null) {
                return false;
            }
            PsiAnnotation psiAnnotation2 = psiAnnotation;
            return !psiAnnotation2.getProject().isDefault() && Intrinsics.areEqual((Object)psiAnnotation2.getQualifiedName(), (Object)"io.quarkus.scheduler.Scheduled") && uHostElement instanceof UExpression;
        }
        return false;
    }

    public static final boolean isSimpleValue(@Nullable String value) {
        if (value == null) {
            return false;
        }
        if (StringsKt.startsWith$default((String)value, (String)"{", (boolean)false, (int)2, null)) {
            return false;
        }
        return PlaceholderTextRanges.getPlaceholderRanges((String)value, (String)"{", (String)"}").isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String qsPropertyReferenceValue(@NotNull PsiElement psiElement) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        PsiReference[] psiReferenceArray = psiElement.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        Object[] $this$filterIsInstance$iv = psiReferenceArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof QsConfigPlaceholderReference)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        QsConfigPlaceholderReference qsConfigPlaceholderReference = (QsConfigPlaceholderReference)((Object)CollectionsKt.firstOrNull((List)((List)destination$iv$iv)));
        if (qsConfigPlaceholderReference == null) {
            return null;
        }
        QsConfigPlaceholderReference reference = qsConfigPlaceholderReference;
        PsiElement $this$asSafely$iv = reference.resolve();
        boolean $i$f$asSafely = false;
        PsiElement psiElement2 = $this$asSafely$iv;
        if (!(psiElement2 instanceof Property)) {
            psiElement2 = null;
        }
        Property property = (Property)psiElement2;
        return property != null ? property.getValue() : null;
    }
}

