/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.generate;

import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.microservices.jvm.inject.InjectionConstructorHandler;
import com.intellij.microservices.jvm.inject.InjectionDescriptor;
import com.intellij.microservices.jvm.inject.InjectionGenerator;
import com.intellij.microservices.jvm.inject.InjectionGeneratorContext;
import com.intellij.microservices.jvm.inject.InjectionGeneratorHelper;
import com.intellij.microservices.jvm.inject.InjectionType;
import com.intellij.microservices.jvm.inject.InjectionUtilsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.actions.generate.GenerateAutowiredDependenciesJvmKt;
import com.intellij.spring.model.actions.generate.InjectTypeRenderer;
import com.intellij.spring.model.actions.generate.SpringBeanDependencyGeneratorHelperKt;
import com.intellij.spring.model.actions.generate.autowire.SpringBeanPointerWrapper;
import com.intellij.spring.model.actions.generate.generators.LookupMethodInjectionGenerator;
import com.intellij.spring.model.actions.generate.generators.ObjectFactoryInjectionGenerator;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.utils.SpringAutowireUtils;
import com.intellij.spring.settings.SpringInjectionSettings;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B5\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0017\u0010\u0017\u001a\t\u0018\u00010\u0018\u00a2\u0006\u0002\b\u00192\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0014J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020$2\u0006\u0010%\u001a\u00020\u0007H\u0014J\u001a\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0014J\b\u0010(\u001a\u00020)H\u0014J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u001a\u0010,\u001a\u00020+2\u0006\u0010\u0012\u001a\u00020\u00022\b\u0010-\u001a\u0004\u0018\u00010\"H\u0014J\n\u0010.\u001a\u0004\u0018\u00010\"H\u0014J\u0010\u0010/\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\"0$H\u0002J\n\u00101\u001a\u0004\u0018\u00010\"H\u0002J\u0010\u00102\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J(\u00103\u001a\u00020+2\u0006\u0010\u0012\u001a\u00020\u00022\f\u00104\u001a\b\u0012\u0004\u0012\u00020\"0$2\b\b\u0001\u00105\u001a\u00020\u0007H\u0002J\u0012\u00106\u001a\u00020\u001b2\b\u00107\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u00108\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u001c\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00069"}, d2={"Lcom/intellij/spring/model/actions/generate/SpringBeanDependencyGeneratorHelper;", "Lcom/intellij/microservices/jvm/inject/InjectionGeneratorHelper;", "Lcom/intellij/spring/model/actions/generate/autowire/SpringBeanPointerWrapper;", "elementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "name", "", "context", "Lcom/intellij/microservices/jvm/inject/InjectionGeneratorContext;", "modelProvider", "Lkotlin/Function0;", "Lcom/intellij/spring/CommonSpringModel;", "<init>", "(Lcom/intellij/psi/SmartPsiElementPointer;Ljava/lang/String;Lcom/intellij/microservices/jvm/inject/InjectionGeneratorContext;Lkotlin/jvm/functions/Function0;)V", "getModelProvider", "()Lkotlin/jvm/functions/Function0;", "getBeanName", "bean", "getBeanIcon", "Ljavax/swing/Icon;", "getBeanLocation", "getBeanIdentifyingPsiElement", "getBeanType", "Lcom/intellij/psi/PsiType;", "Lcom/intellij/openapi/util/NlsSafe;", "hasFieldInjection", "", "uClass", "Lorg/jetbrains/uast/UClass;", "hasSetterInjection", "injectionGenerator", "Lcom/intellij/microservices/jvm/inject/InjectionGenerator;", "type", "Lcom/intellij/microservices/jvm/inject/InjectionType;", "findMatchingBeans", "", "prefix", "getBeanDescriptor", "Lcom/intellij/microservices/jvm/inject/InjectionDescriptor;", "getConstructorHandler", "Lcom/intellij/microservices/jvm/inject/InjectionConstructorHandler;", "askInjectionType", "", "injectBean", "injectionType", "getInjectionType", "hasConstructorInjection", "prototypeInjectionTypes", "defaultClassInjectionType", "isKotlinTestClass", "askBeanInjection", "injectionTypes", "dialogCaption", "isConfigurationMethod", "elementAtCaret", "isTestContextConfigurationClass", "intellij.spring.core"})
@SourceDebugExtension(value={"SMAP\nSpringBeanDependencyGeneratorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBeanDependencyGeneratorHelper.kt\ncom/intellij/spring/model/actions/generate/SpringBeanDependencyGeneratorHelper\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,230:1\n19#2:231\n1563#3:232\n1634#3,3:233\n1761#3,3:236\n1#4:239\n207#5:240\n*S KotlinDebug\n*F\n+ 1 SpringBeanDependencyGeneratorHelper.kt\ncom/intellij/spring/model/actions/generate/SpringBeanDependencyGeneratorHelper\n*L\n56#1:231\n105#1:232\n105#1:233,3\n158#1:236,3\n199#1:240\n*E\n"})
public abstract class SpringBeanDependencyGeneratorHelper
extends InjectionGeneratorHelper<SpringBeanPointerWrapper> {
    @NotNull
    private final Function0<CommonSpringModel> modelProvider;

    public SpringBeanDependencyGeneratorHelper(@NotNull SmartPsiElementPointer<PsiElement> elementPointer, @NotNull String name, @NotNull InjectionGeneratorContext context, @NotNull Function0<? extends CommonSpringModel> modelProvider) {
        Intrinsics.checkNotNullParameter(elementPointer, (String)"elementPointer");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(modelProvider, (String)"modelProvider");
        super(elementPointer, name, context);
        this.modelProvider = modelProvider;
    }

    @NotNull
    protected final Function0<CommonSpringModel> getModelProvider() {
        return this.modelProvider;
    }

    @NotNull
    protected String getBeanName(@NotNull SpringBeanPointerWrapper bean) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        return bean.getName();
    }

    @Nullable
    protected Icon getBeanIcon(@NotNull SpringBeanPointerWrapper bean) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        return bean.getIcon();
    }

    @Nullable
    protected String getBeanLocation(@NotNull SpringBeanPointerWrapper bean) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        return bean.getLocation();
    }

    @Nullable
    protected PsiElement getBeanIdentifyingPsiElement(@NotNull SpringBeanPointerWrapper bean) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        PsiElement $this$asSafely$iv = ((CommonModelElement)bean.getBean().getSpringBean()).getIdentifyingPsiElement();
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof PsiMethod)) {
            psiElement = null;
        }
        PsiMethod psiMethod = (PsiMethod)psiElement;
        return psiMethod != null ? (PsiElement)psiMethod : (PsiElement)bean.getBean().getBeanClass();
    }

    @Nullable
    protected PsiType getBeanType(@NotNull SpringBeanPointerWrapper bean) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        return bean.getInjectedBeanType();
    }

    protected boolean hasFieldInjection(@NotNull UClass uClass) {
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        return SpringAutowireUtils.getInstance().hasFieldInjection(uClass);
    }

    protected boolean hasSetterInjection(@NotNull UClass uClass) {
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        return SpringAutowireUtils.getInstance().hasSetterInjection(uClass);
    }

    @Nullable
    protected InjectionGenerator injectionGenerator(@NotNull InjectionType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> LookupMethodInjectionGenerator.INSTANCE;
            case 2 -> {
                InjectionType v1 = this.defaultClassInjectionType();
                if (v1 == null) {
                    v1 = InjectionType.CONSTRUCTOR;
                }
                yield new ObjectFactoryInjectionGenerator(v1, this.getConstructorHandler());
            }
            default -> super.injectionGenerator(type);
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<SpringBeanPointerWrapper> findMatchingBeans(@NotNull String prefix) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        CamelHumpMatcher matcher = new CamelHumpMatcher(prefix, true);
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
        Ref exactMatch = ref;
        HashMap candidates = new HashMap();
        Processor processor2 = new Processor<SpringBeanPointer<?>>(prefix, exactMatch, matcher, candidates){
            final /* synthetic */ String $prefix;
            final /* synthetic */ Ref<SpringBeanPointer<?>> $exactMatch;
            final /* synthetic */ CamelHumpMatcher $matcher;
            final /* synthetic */ HashMap<SpringBeanPointer<?>, Integer> $candidates;
            {
                this.$prefix = $prefix;
                this.$exactMatch = $exactMatch;
                this.$matcher = $matcher;
                this.$candidates = $candidates;
            }

            public boolean process(SpringBeanPointer<?> t) {
                Intrinsics.checkNotNullParameter(t, (String)"t");
                String string = t.getName();
                if (string == null) {
                    return true;
                }
                String beanName = string;
                if (Intrinsics.areEqual((Object)beanName, (Object)this.$prefix)) {
                    this.$exactMatch.set(t);
                    return false;
                }
                if (this.$matcher.prefixMatches(beanName)) {
                    ((Map)this.$candidates).put(t, this.$matcher.matchingDegree(beanName));
                }
                return true;
            }
        };
        CommonSpringModel commonSpringModel = (CommonSpringModel)this.modelProvider.invoke();
        if (commonSpringModel == null) {
            return CollectionsKt.emptyList();
        }
        CommonSpringModel springModel = commonSpringModel;
        springModel.processAllBeans(processor2, true);
        SpringBeanPointer pointer = (SpringBeanPointer)exactMatch.get();
        if (pointer != null) {
            String string = pointer.getName();
            if (string == null) {
                string = "";
            }
            return CollectionsKt.listOf((Object)new SpringBeanPointerWrapper(pointer, string, SpringPresentationProvider.getSpringIcon((Object)pointer), null, false, null, 56, null));
        }
        ArrayList result2 = new ArrayList(candidates.entrySet());
        CollectionsKt.sortWith((List)result2, (arg_0, arg_1) -> SpringBeanDependencyGeneratorHelper.findMatchingBeans$lambda$1(SpringBeanDependencyGeneratorHelper::findMatchingBeans$lambda$0, arg_0, arg_1));
        Iterable $this$map$iv = result2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            SpringBeanPointer springBeanPointer = (SpringBeanPointer)k;
            String string = ((SpringBeanPointer)it.getKey()).getName();
            if (string == null) {
                string = "";
            }
            collection.add(new SpringBeanPointerWrapper(springBeanPointer, string, SpringPresentationProvider.getSpringIcon(it.getKey()), null, false, null, 56, null));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    protected InjectionDescriptor getBeanDescriptor(@NotNull SpringBeanPointerWrapper bean, @NotNull InjectionType type) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        CommonSpringModel commonSpringModel = (CommonSpringModel)this.modelProvider.invoke();
        if (commonSpringModel == null) {
            return null;
        }
        CommonSpringModel springModel = commonSpringModel;
        UClass uClass = this.getContext().getUClass();
        if (uClass == null) {
            return null;
        }
        UClass targetUClass = uClass;
        return GenerateAutowiredDependenciesJvmKt.getBeanDescriptor(bean.getBean(), springModel, this.getContext().getProject(), targetUClass, type, bean.getName(), bean.getInjectedBeanType());
    }

    @NotNull
    protected InjectionConstructorHandler getConstructorHandler() {
        return GenerateAutowiredDependenciesJvmKt.getSPRING_CONSTRUCTOR_HANDLER();
    }

    protected void askInjectionType(@NotNull SpringBeanPointerWrapper bean) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        List list = SpringBeanDependencyGeneratorHelperKt.access$getDEFAULT_AUTOWIRING_TYPES$p();
        String string = SpringBundle.message("popup.title.select.injection.type", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.askBeanInjection(bean, list, string);
    }

    protected void injectBean(@NotNull SpringBeanPointerWrapper bean, @Nullable InjectionType injectionType) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        SpringInjectionSettings settings = SpringInjectionSettings.Companion.getInstance(this.getContext().getProject());
        if (Intrinsics.areEqual((Object)bean.getBean().getSpringBean().getSpringScope(), (Object)SpringBeanScope.PROTOTYPE_SCOPE)) {
            InjectionType defaultPrototypeInjectionType = settings.getPrototypeBeanInjectionType();
            if (defaultPrototypeInjectionType == null) {
                List<InjectionType> list = this.prototypeInjectionTypes();
                String string = SpringBundle.message("popup.title.select.prototypeInjection.type", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.askBeanInjection(bean, list, string);
            } else {
                super.injectBean((Object)bean, defaultPrototypeInjectionType);
            }
        } else {
            super.injectBean((Object)bean, injectionType);
        }
    }

    @Nullable
    protected InjectionType getInjectionType() {
        UClass uClass = this.getContext().getUClass();
        if (uClass == null) {
            return null;
        }
        UClass uClass2 = uClass;
        return this.isConfigurationMethod(InjectionUtilsKt.getElementAtCaret((Editor)this.getContext().getEditor())) ? InjectionType.CONFIGURATION_METHOD : (this.isKotlinTestClass(uClass2) ? InjectionType.CONSTRUCTOR : (this.hasFieldInjection(uClass2) || this.isTestContextConfigurationClass(uClass2) ? InjectionType.FIELD : (this.hasSetterInjection(uClass2) ? InjectionType.SETTER : (this.hasConstructorInjection(uClass2) ? InjectionType.CONSTRUCTOR : SpringInjectionSettings.Companion.getInstance(this.getContext().getProject()).getDefaultBeanInjectionType()))));
    }

    private final boolean hasConstructorInjection(UClass uClass) {
        boolean bl;
        block3: {
            SpringJavaClassInfo springJavaClassInfo = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)uClass.getJavaPsi());
            Intrinsics.checkNotNullExpressionValue((Object)springJavaClassInfo, (String)"getSpringJavaClassInfo(...)");
            SpringJavaClassInfo model = springJavaClassInfo;
            Set set = model.resolve().getBeans();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getBeans(...)");
            Iterable $this$any$iv = set;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SpringBeanPointer it = (SpringBeanPointer)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it.getBeanClass(), (Object)uClass.getJavaPsi()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final List<InjectionType> prototypeInjectionTypes() {
        Object object;
        block3: {
            block2: {
                object = this.defaultClassInjectionType();
                if (object == null) break block2;
                InjectionType it = object;
                boolean bl = false;
                List list = CollectionsKt.listOf((Object)it);
                object = list;
                if (list != null) break block3;
            }
            object = SpringBeanDependencyGeneratorHelperKt.access$getDEFAULT_AUTOWIRING_TYPES$p();
        }
        Object defaultInjectionTypes = object;
        Object[] objectArray = new InjectionType[]{InjectionType.OBJECT_FACTORY_METHOD, InjectionType.LOOKUP_METHOD};
        List injectionTypes = CollectionsKt.plus((Collection)((Collection)defaultInjectionTypes), (Iterable)CollectionsKt.listOf((Object[])objectArray));
        return injectionTypes;
    }

    private final InjectionType defaultClassInjectionType() {
        UClass uClass = this.getContext().getUClass();
        if (uClass == null) {
            return null;
        }
        UClass uClass2 = uClass;
        return this.isKotlinTestClass(uClass2) ? InjectionType.CONSTRUCTOR : (this.hasFieldInjection(uClass2) || this.isTestContextConfigurationClass(uClass2) ? InjectionType.FIELD : (this.hasSetterInjection(uClass2) ? InjectionType.SETTER : SpringInjectionSettings.Companion.getInstance(this.getContext().getProject()).getDefaultBeanInjectionType()));
    }

    private final boolean isKotlinTestClass(UClass uClass) {
        return this.isTestContextConfigurationClass(uClass) && Intrinsics.areEqual((Object)this.getContext().getContainingFile().getLanguage().getID(), (Object)"kotlin");
    }

    private final void askBeanInjection(SpringBeanPointerWrapper bean, List<? extends InjectionType> injectionTypes, @NlsContexts.PopupTitle String dialogCaption) {
        JBPopupFactory.getInstance().createPopupChooserBuilder(injectionTypes).setRenderer((ListCellRenderer)new InjectTypeRenderer()).setSelectionMode(0).setTitle(dialogCaption).setItemChosenCallback(arg_0 -> SpringBeanDependencyGeneratorHelper.askBeanInjection$lambda$1(arg_0 -> SpringBeanDependencyGeneratorHelper.askBeanInjection$lambda$0(this, bean, arg_0), arg_0)).createPopup().showInBestPositionFor(this.getContext().getEditor());
    }

    private final boolean isConfigurationMethod(PsiElement elementAtCaret) {
        if (elementAtCaret == null) {
            return false;
        }
        Project project = elementAtCaret.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!SpringInjectionSettings.Companion.getInstance(project).isInjectToBeanMethodSignature()) {
            return false;
        }
        PsiElement $this$getUastParentOfType_u24default$iv = elementAtCaret;
        boolean strict$iv = false;
        boolean $i$f$getUastParentOfType = false;
        UMethod uMethod = (UMethod)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UMethod.class, (boolean)strict$iv);
        if (uMethod == null) {
            return false;
        }
        UMethod uMethod2 = uMethod;
        return uMethod2.getJavaPsi().hasAnnotation("org.springframework.context.annotation.Bean");
    }

    private final boolean isTestContextConfigurationClass(UClass uClass) {
        return SpringTestContextUtil.getInstance().isTestContextConfigurationClass(uClass.getJavaPsi());
    }

    private static final int findMatchingBeans$lambda$0(Map.Entry t1, Map.Entry t2) {
        int n = ((Number)t2.getValue()).intValue();
        Object v = t1.getValue();
        Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
        int matchingDegree = n - ((Number)v).intValue();
        if (matchingDegree == 0) {
            return StringUtil.compare((String)((SpringBeanPointer)t1.getKey()).getName(), (String)((SpringBeanPointer)t2.getKey()).getName(), (boolean)false);
        }
        return matchingDegree;
    }

    private static final int findMatchingBeans$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final Unit askBeanInjection$lambda$0(SpringBeanDependencyGeneratorHelper this$0, SpringBeanPointerWrapper $bean, InjectionType it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.invoke($bean, it);
        return Unit.INSTANCE;
    }

    private static final void askBeanInjection$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InjectionType.values().length];
            try {
                nArray[InjectionType.LOOKUP_METHOD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InjectionType.OBJECT_FACTORY_METHOD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

