/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.generate;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.codeInsight.generation.MemberChooserObjectBase;
import com.intellij.codeInsight.generation.PsiElementMemberChooserObject;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.model.SpringBeanPointer;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class SpringBeanClassMember
extends MemberChooserObjectBase
implements ClassMember {
    private final SpringBeanPointer<?> mySpringBean;

    public SpringBeanClassMember(SpringBeanPointer<?> springBean) {
        super(SpringPresentationProvider.getSpringBeanName(springBean), SpringPresentationProvider.getSpringIcon(springBean));
        this.mySpringBean = springBean;
    }

    public MemberChooserObject getParentNodeDelegate() {
        return new SpringFileMemberChooserObjectBase(this.getSpringBean().getContainingFile());
    }

    public SpringBeanPointer<?> getSpringBean() {
        return this.mySpringBean;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SpringBeanClassMember member = (SpringBeanClassMember)((Object)o);
        return Objects.equals(this.mySpringBean, member.mySpringBean);
    }

    public int hashCode() {
        return this.mySpringBean != null ? this.mySpringBean.hashCode() : 0;
    }

    private static final class SpringFileMemberChooserObjectBase
    extends PsiElementMemberChooserObject {
        SpringFileMemberChooserObjectBase(@NotNull PsiFile psiFile) {
            if (psiFile == null) {
                SpringFileMemberChooserObjectBase.$$$reportNull$$$0(0);
            }
            super((PsiElement)psiFile, psiFile.getName(), psiFile instanceof XmlFile ? SpringApiIcons.SpringConfig : SpringApiIcons.SpringJavaConfig);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/spring/model/actions/generate/SpringBeanClassMember$SpringFileMemberChooserObjectBase", "<init>"));
        }
    }
}

