/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.google.common.collect.Iterables;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonCodeStyleService;
import com.jetbrains.python.ast.PyAstStatementList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyIndentUtil {
    @NonNls
    public static final String TWO_SPACES = "  ";
    @NonNls
    public static final String FOUR_SPACES = "    ";

    private PyIndentUtil() {
    }

    public static int getLineIndentSize(@NotNull CharSequence line) {
        char c;
        int stop;
        if (line == null) {
            PyIndentUtil.$$$reportNull$$$0(0);
        }
        for (stop = 0; stop < line.length() && ((c = line.charAt(stop)) == ' ' || c == '\t'); ++stop) {
        }
        return stop;
    }

    @NotNull
    public static String getLineIndent(@NotNull String line) {
        if (line == null) {
            PyIndentUtil.$$$reportNull$$$0(1);
        }
        String string = line.substring(0, PyIndentUtil.getLineIndentSize(line));
        if (string == null) {
            PyIndentUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static CharSequence getLineIndent(@NotNull CharSequence line) {
        if (line == null) {
            PyIndentUtil.$$$reportNull$$$0(3);
        }
        CharSequence charSequence = line.subSequence(0, PyIndentUtil.getLineIndentSize(line));
        if (charSequence == null) {
            PyIndentUtil.$$$reportNull$$$0(4);
        }
        return charSequence;
    }

    @NotNull
    public static String getElementIndent(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PyIndentUtil.$$$reportNull$$$0(5);
        }
        if (anchor instanceof PsiFile) {
            return "";
        }
        PyAstStatementList statementList = PyIndentUtil.getAnchorStatementList(anchor);
        if (statementList == null) {
            return "";
        }
        PsiElement prevSibling = statementList.getPrevSibling();
        String whitespace = prevSibling instanceof PsiWhiteSpace ? prevSibling.getText() : "";
        int i = whitespace.lastIndexOf("\n");
        if (i >= 0 && statementList.getStatements().length != 0) {
            String string = whitespace.substring(i + 1);
            if (string == null) {
                PyIndentUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        return PyIndentUtil.getExpectedBlockIndent(statementList);
    }

    @NotNull
    private static String getExpectedBlockIndent(@NotNull PyAstStatementList anchor) {
        if (anchor == null) {
            PyIndentUtil.$$$reportNull$$$0(7);
        }
        String indentStep = PyIndentUtil.getIndentFromSettings(anchor.getContainingFile());
        PyAstStatementList parentBlock = (PyAstStatementList)PsiTreeUtil.getParentOfType((PsiElement)anchor, PyAstStatementList.class, (boolean)true);
        if (parentBlock != null) {
            String string = PyIndentUtil.getElementIndent((PsiElement)parentBlock) + indentStep;
            if (string == null) {
                PyIndentUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = indentStep;
        if (string == null) {
            PyIndentUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    private static PyAstStatementList getAnchorStatementList(@NotNull PsiElement element) {
        if (element == null) {
            PyIndentUtil.$$$reportNull$$$0(10);
        }
        PyAstStatementList statementList = null;
        if (element instanceof PsiWhiteSpace) {
            statementList = (PyAstStatementList)ObjectUtils.tryCast((Object)element.getNextSibling(), PyAstStatementList.class);
        }
        if (statementList == null) {
            statementList = (PyAstStatementList)PsiTreeUtil.getParentOfType((PsiElement)element, PyAstStatementList.class, (boolean)false);
        }
        return statementList;
    }

    public static boolean areTabsUsedForIndentation(@NotNull PsiFile file) {
        if (file == null) {
            PyIndentUtil.$$$reportNull$$$0(11);
        }
        return PythonCodeStyleService.getInstance().isTabIndentation(file);
    }

    public static int getIndentSizeFromSettings(@NotNull PsiFile file) {
        if (file == null) {
            PyIndentUtil.$$$reportNull$$$0(12);
        }
        return PythonCodeStyleService.getInstance().getIndentSize(file);
    }

    @NotNull
    public static String getIndentFromSettings(@NotNull PsiFile file) {
        boolean useTabs;
        if (file == null) {
            PyIndentUtil.$$$reportNull$$$0(13);
        }
        String string = (useTabs = PyIndentUtil.areTabsUsedForIndentation(file)) ? "\t" : StringUtil.repeatSymbol((char)' ', (int)PyIndentUtil.getIndentSizeFromSettings(file));
        if (string == null) {
            PyIndentUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public static List<String> removeCommonIndent(@NotNull Iterable<String> lines, boolean ignoreFirstLine) {
        if (lines == null) {
            PyIndentUtil.$$$reportNull$$$0(15);
        }
        return PyIndentUtil.changeIndent(lines, ignoreFirstLine, "");
    }

    @NotNull
    public static String removeCommonIndent(@NotNull String s, boolean ignoreFirstLine) {
        if (s == null) {
            PyIndentUtil.$$$reportNull$$$0(16);
        }
        List<String> trimmed = PyIndentUtil.removeCommonIndent(LineTokenizer.tokenizeIntoList((CharSequence)s, (boolean)false, (boolean)false), ignoreFirstLine);
        String string = StringUtil.join(trimmed, (String)"\n");
        if (string == null) {
            PyIndentUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public static String changeIndent(@NotNull String s, boolean ignoreFirstLine, String newIndent) {
        if (s == null) {
            PyIndentUtil.$$$reportNull$$$0(18);
        }
        List<String> trimmed = PyIndentUtil.changeIndent(LineTokenizer.tokenizeIntoList((CharSequence)s, (boolean)false, (boolean)false), ignoreFirstLine, newIndent);
        String string = StringUtil.join(trimmed, (String)"\n");
        if (string == null) {
            PyIndentUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static List<String> changeIndent(@NotNull Iterable<String> lines, boolean ignoreFirstLine, String newIndent) {
        if (lines == null) {
            PyIndentUtil.$$$reportNull$$$0(20);
        }
        String oldIndent = PyIndentUtil.findCommonIndent(lines, ignoreFirstLine);
        if (Iterables.isEmpty(lines)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PyIndentUtil.$$$reportNull$$$0(21);
            }
            return list;
        }
        List result = ContainerUtil.map((Iterable)Iterables.skip(lines, (int)(ignoreFirstLine ? 1 : 0)), line -> {
            if (StringUtil.isEmptyOrSpaces((String)line)) {
                return "";
            }
            return newIndent + line.substring(oldIndent.length());
        });
        if (ignoreFirstLine) {
            List list = ContainerUtil.prepend((List)result, (Object[])new String[]{(String)Iterables.get(lines, (int)0)});
            if (list == null) {
                PyIndentUtil.$$$reportNull$$$0(22);
            }
            return list;
        }
        List list = result;
        if (list == null) {
            PyIndentUtil.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    public static String findCommonIndent(@NotNull String s, boolean ignoreFirstLine) {
        if (s == null) {
            PyIndentUtil.$$$reportNull$$$0(24);
        }
        return PyIndentUtil.findCommonIndent(LineTokenizer.tokenizeIntoList((CharSequence)s, (boolean)false, (boolean)false), ignoreFirstLine);
    }

    @NotNull
    public static String findCommonIndent(@NotNull Iterable<String> lines, boolean ignoreFirstLine) {
        if (lines == null) {
            PyIndentUtil.$$$reportNull$$$0(25);
        }
        String minIndent = null;
        boolean allLinesEmpty = true;
        if (Iterables.isEmpty(lines)) {
            return "";
        }
        boolean hasBadEmptyLineIndent = false;
        for (String line : Iterables.skip(lines, (int)(ignoreFirstLine ? 1 : 0))) {
            boolean lineEmpty = StringUtil.isEmptyOrSpaces((String)line);
            if (lineEmpty && !allLinesEmpty) continue;
            String indent = PyIndentUtil.getLineIndent(line);
            if (minIndent == null || !lineEmpty && allLinesEmpty || minIndent.startsWith(indent)) {
                minIndent = indent;
            } else if (!indent.startsWith(minIndent)) {
                if (lineEmpty) {
                    hasBadEmptyLineIndent = true;
                } else {
                    return "";
                }
            }
            allLinesEmpty &= lineEmpty;
        }
        if (allLinesEmpty && hasBadEmptyLineIndent) {
            return "";
        }
        String string = StringUtil.notNullize(minIndent);
        if (string == null) {
            PyIndentUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static String getLineIndent(@NotNull Document document, int lineNumber) {
        if (document == null) {
            PyIndentUtil.$$$reportNull$$$0(27);
        }
        TextRange lineRange = TextRange.create((int)document.getLineStartOffset(lineNumber), (int)document.getLineEndOffset(lineNumber));
        String line = document.getText(lineRange);
        return PyIndentUtil.getLineIndent(line);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 8, 9, 14, 17, 19, 21, 22, 23, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/PyIndentUtil";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 16: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/PyIndentUtil";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineIndent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementIndent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedBlockIndent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentFromSettings";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "removeCommonIndent";
                break;
            }
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "changeIndent";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findCommonIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndentSize";
                break;
            }
            case 1: 
            case 3: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndent";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementIndent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedBlockIndent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAnchorStatementList";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "areTabsUsedForIndentation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIndentSizeFromSettings";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getIndentFromSettings";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeCommonIndent";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "changeIndent";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findCommonIndent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 8, 9, 14, 17, 19, 21, 22, 23, 26 -> new IllegalStateException(string);
        };
    }
}

