/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.UpdateInspectionOptionFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.ChainedComparisonsQuickFix;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyChainedComparisonsInspection
extends PyInspection {
    private static final String INSPECTION_SHORT_NAME = "PyChainedComparisonsInspection";
    public boolean ignoreConstantInTheMiddle = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreConstantInTheMiddle", (String)PyPsiBundle.message("INSP.chained.comparisons.ignore.statements.with.constant.in.the.middle", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PyChainedComparisonsInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyChainedComparisonsInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            PyChainedComparisonsInspection.$$$reportNull$$$0(2);
        }
        return new Visitor(holder, this.ignoreConstantInTheMiddle, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyChainedComparisonsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyChainedComparisonsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private class Visitor
    extends PyInspectionVisitor {
        boolean myIsLeft;
        boolean myIsRight;
        PyElementType myOperator;
        boolean getInnerRight;
        boolean isConstantInTheMiddle;
        boolean ignoreConstantInTheMiddle;

        Visitor(ProblemsHolder holder, @NotNull boolean ignoreConstantInTheMiddle, TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
            this.ignoreConstantInTheMiddle = ignoreConstantInTheMiddle;
        }

        @Override
        public void visitPyBinaryExpression(@NotNull PyBinaryExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.myIsLeft = false;
            this.myIsRight = false;
            this.myOperator = null;
            this.getInnerRight = false;
            PyBinaryExpression leftExpression = PyUtil.as(node.getLeftExpression(), PyBinaryExpression.class);
            PyBinaryExpression rightExpression = PyUtil.as(node.getRightExpression(), PyBinaryExpression.class);
            if (leftExpression != null && rightExpression != null && node.getOperator() == PyTokenTypes.AND_KEYWORD) {
                boolean applicable = false;
                if (leftExpression.getOperator() == PyTokenTypes.AND_KEYWORD) {
                    PyBinaryExpression leftLeft = PyUtil.as(leftExpression.getLeftExpression(), PyBinaryExpression.class);
                    PyBinaryExpression leftRight = PyUtil.as(leftExpression.getRightExpression(), PyBinaryExpression.class);
                    if (leftLeft != null && (this.isRightSimplified(leftLeft, rightExpression) || this.isLeftSimplified(leftLeft, rightExpression))) {
                        applicable = true;
                        this.getInnerRight = false;
                    } else if (leftRight != null && (this.isRightSimplified(leftRight, rightExpression) || this.isLeftSimplified(leftRight, rightExpression))) {
                        applicable = true;
                        this.getInnerRight = true;
                    }
                } else if (this.isRightSimplified(leftExpression, rightExpression) || this.isLeftSimplified(leftExpression, rightExpression)) {
                    applicable = true;
                }
                if (applicable) {
                    if (this.isConstantInTheMiddle) {
                        if (!this.ignoreConstantInTheMiddle) {
                            this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.simplify.chained.comparison", new Object[0]), new LocalQuickFix[]{new ChainedComparisonsQuickFix(this.myIsLeft, this.myIsRight, this.getInnerRight), LocalQuickFix.from((ModCommandAction)new UpdateInspectionOptionFix((InspectionProfileEntry)PyChainedComparisonsInspection.this, "ignoreConstantInTheMiddle", PyPsiBundle.message("INSP.chained.comparisons.ignore.statements.with.constant.in.the.middle", new Object[0]), true))});
                        }
                    } else {
                        this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.simplify.chained.comparison", new Object[0]), new LocalQuickFix[]{new ChainedComparisonsQuickFix(this.myIsLeft, this.myIsRight, this.getInnerRight)});
                    }
                }
            }
        }

        private boolean isRightSimplified(@NotNull PyBinaryExpression leftExpression, @NotNull PyBinaryExpression rightExpression) {
            PyExpression leftRight;
            if (leftExpression == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (rightExpression == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if ((leftRight = leftExpression.getRightExpression()) instanceof PyBinaryExpression && PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)((PyBinaryExpression)leftRight).getOperator()) && this.isRightSimplified((PyBinaryExpression)leftRight, rightExpression)) {
                return true;
            }
            this.myOperator = leftExpression.getOperator();
            if (PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)this.myOperator) && leftRight != null) {
                if (leftRight.getText().equals(this.getLeftExpression(rightExpression, true).getText())) {
                    this.myIsLeft = false;
                    this.myIsRight = true;
                    this.isConstantInTheMiddle = leftRight instanceof PyLiteralExpression;
                    return true;
                }
                PyExpression right = this.getSmallestRight(rightExpression, true);
                if (right != null && leftRight.getText().equals(right.getText())) {
                    this.myIsLeft = false;
                    this.myIsRight = false;
                    this.isConstantInTheMiddle = leftRight instanceof PyLiteralExpression;
                    return true;
                }
            }
            return false;
        }

        private static boolean isOpposite(PyElementType op1, PyElementType op2) {
            if (!(op1 != PyTokenTypes.GT && op1 != PyTokenTypes.GE || op2 != PyTokenTypes.LT && op2 != PyTokenTypes.LE)) {
                return true;
            }
            return !(op2 != PyTokenTypes.GT && op2 != PyTokenTypes.GE || op1 != PyTokenTypes.LT && op1 != PyTokenTypes.LE);
        }

        private boolean isLeftSimplified(PyBinaryExpression leftExpression, PyBinaryExpression rightExpression) {
            PyExpression leftLeft = leftExpression.getLeftExpression();
            if (leftLeft instanceof PyBinaryExpression && PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)((PyBinaryExpression)leftLeft).getOperator()) && this.isLeftSimplified((PyBinaryExpression)leftLeft, rightExpression)) {
                return true;
            }
            this.myOperator = leftExpression.getOperator();
            if (PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)this.myOperator) && leftLeft != null) {
                if (leftLeft.getText().equals(this.getLeftExpression(rightExpression, false).getText())) {
                    this.myIsLeft = true;
                    this.myIsRight = true;
                    this.isConstantInTheMiddle = leftLeft instanceof PyLiteralExpression;
                    return true;
                }
                PyExpression right = this.getSmallestRight(rightExpression, false);
                if (right != null && leftLeft.getText().equals(right.getText())) {
                    this.myIsLeft = true;
                    this.myIsRight = false;
                    this.isConstantInTheMiddle = leftLeft instanceof PyLiteralExpression;
                    return true;
                }
            }
            return false;
        }

        private PyExpression getLeftExpression(PyBinaryExpression expression, boolean isRight) {
            PyExpression result2 = expression;
            while (result2 instanceof PyBinaryExpression && (PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)result2.getOperator()) || PyTokenTypes.EQUALITY_OPERATIONS.contains((IElementType)result2.getOperator()))) {
                boolean opposite = Visitor.isOpposite(result2.getOperator(), this.myOperator);
                if (isRight && opposite || !isRight && !opposite) break;
                result2 = result2.getLeftExpression();
            }
            return result2;
        }

        @Nullable
        private PyExpression getSmallestRight(PyBinaryExpression expression, boolean isRight) {
            PyExpression result2 = expression;
            while (result2 instanceof PyBinaryExpression && (PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)result2.getOperator()) || PyTokenTypes.EQUALITY_OPERATIONS.contains((IElementType)result2.getOperator()))) {
                boolean opposite = Visitor.isOpposite(result2.getOperator(), this.myOperator);
                if (isRight && !opposite || !isRight && opposite) break;
                result2 = result2.getRightExpression();
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftExpression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightExpression";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyChainedComparisonsInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyBinaryExpression";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isRightSimplified";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

