/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.tokens.predicates;

import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.parser.SQLParserActionKind;
import org.jkiss.dbeaver.model.sql.parser.SQLTokenPredicate;
import org.jkiss.dbeaver.model.sql.parser.TokenEntry;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicateNode;

public class TokenPredicatesCondition
implements SQLTokenPredicate {
    private final SQLParserActionKind actionKind;
    private final TokenPredicateNode prefixPredicate;
    private final TokenPredicateNode suffixPredicate;
    private final List<List<TokenEntry>> prefixes;
    private final List<List<TokenEntry>> suffixes;
    public final int maxPrefixLength;
    public final int maxSuffixLength;
    public final String parameter;

    public TokenPredicatesCondition(@NotNull SQLParserActionKind actionKind, @NotNull TokenPredicateNode prefixPredicate, @NotNull TokenPredicateNode suffixPredicate) {
        this(actionKind, prefixPredicate, suffixPredicate, null);
    }

    public TokenPredicatesCondition(@NotNull SQLParserActionKind actionKind, @NotNull TokenPredicateNode prefixPredicate, @NotNull TokenPredicateNode suffixPredicate, @Nullable String parameter) {
        this.actionKind = actionKind;
        this.prefixPredicate = prefixPredicate;
        this.suffixPredicate = suffixPredicate;
        this.prefixes = Collections.unmodifiableList(prefixPredicate.expand());
        this.suffixes = Collections.unmodifiableList(suffixPredicate.expand());
        this.maxPrefixLength = this.prefixes.stream().mapToInt(List::size).max().orElse(0);
        this.maxSuffixLength = this.suffixes.stream().mapToInt(List::size).max().orElse(0);
        this.parameter = parameter;
    }

    public int getMaxSuffixLength() {
        return this.maxSuffixLength;
    }

    @Nullable
    public String getParameter() {
        return this.parameter;
    }

    @NotNull
    public List<List<TokenEntry>> getPrefixes() {
        return this.prefixes;
    }

    @NotNull
    public List<List<TokenEntry>> getSuffixes() {
        return this.suffixes;
    }

    @NotNull
    public SQLParserActionKind getActionKind() {
        return this.actionKind;
    }

    public String toString() {
        return "TokenEnvironmentCondition[action: [" + String.valueOf(this.actionKind) + "], prefix: [" + String.valueOf(this.prefixPredicate) + "], suffix: [" + String.valueOf(this.suffixPredicate) + "]]";
    }
}

