﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codeconnections/model/ListRepositoryLinksResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::CodeConnections::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListRepositoryLinksResult::ListRepositoryLinksResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListRepositoryLinksResult& ListRepositoryLinksResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("RepositoryLinks")) {
    Aws::Utils::Array<JsonView> repositoryLinksJsonList = jsonValue.GetArray("RepositoryLinks");
    for (unsigned repositoryLinksIndex = 0; repositoryLinksIndex < repositoryLinksJsonList.GetLength(); ++repositoryLinksIndex) {
      m_repositoryLinks.push_back(repositoryLinksJsonList[repositoryLinksIndex].AsObject());
    }
    m_repositoryLinksHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
