// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: scheduler/scheduler.proto

/*
	Package scheduler is a generated protocol buffer package.

	It is generated from these files:
		scheduler/scheduler.proto

	It has these top-level messages:
		Event
		Response
		Call
*/
package scheduler

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import mesos "github.com/mesos/mesos-go/api/v1/lib"
import _ "github.com/gogo/protobuf/gogoproto"

import strconv "strconv"

import bytes "bytes"

import strings "strings"
import reflect "reflect"

import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Possible event types, followed by message definitions if
// applicable.
type Event_Type int32

const (
	// This must be the first enum value in this list, to
	// ensure that if 'type' is not set, the default value
	// is UNKNOWN. This enables enum values to be added
	// in a backwards-compatible way. See: MESOS-4997.
	Event_UNKNOWN                 Event_Type = 0
	Event_SUBSCRIBED              Event_Type = 1
	Event_OFFERS                  Event_Type = 2
	Event_INVERSE_OFFERS          Event_Type = 9
	Event_RESCIND                 Event_Type = 3
	Event_RESCIND_INVERSE_OFFER   Event_Type = 10
	Event_UPDATE                  Event_Type = 4
	Event_UPDATE_OPERATION_STATUS Event_Type = 11
	Event_MESSAGE                 Event_Type = 5
	Event_FAILURE                 Event_Type = 6
	Event_ERROR                   Event_Type = 7
	// Periodic message sent by the Mesos master according to
	// 'Subscribed.heartbeat_interval_seconds'. If the scheduler does
	// not receive any events (including heartbeats) for an extended
	// period of time (e.g., 5 x heartbeat_interval_seconds), there is
	// likely a network partition. In such a case the scheduler should
	// close the existing subscription connection and resubscribe
	// using a backoff strategy.
	Event_HEARTBEAT Event_Type = 8
)

var Event_Type_name = map[int32]string{
	0:  "UNKNOWN",
	1:  "SUBSCRIBED",
	2:  "OFFERS",
	9:  "INVERSE_OFFERS",
	3:  "RESCIND",
	10: "RESCIND_INVERSE_OFFER",
	4:  "UPDATE",
	11: "UPDATE_OPERATION_STATUS",
	5:  "MESSAGE",
	6:  "FAILURE",
	7:  "ERROR",
	8:  "HEARTBEAT",
}
var Event_Type_value = map[string]int32{
	"UNKNOWN":                 0,
	"SUBSCRIBED":              1,
	"OFFERS":                  2,
	"INVERSE_OFFERS":          9,
	"RESCIND":                 3,
	"RESCIND_INVERSE_OFFER":   10,
	"UPDATE":                  4,
	"UPDATE_OPERATION_STATUS": 11,
	"MESSAGE":                 5,
	"FAILURE":                 6,
	"ERROR":                   7,
	"HEARTBEAT":               8,
}

func (x Event_Type) Enum() *Event_Type {
	p := new(Event_Type)
	*p = x
	return p
}
func (x Event_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Event_Type_name, int32(x))
}
func (x *Event_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Event_Type_value, data, "Event_Type")
	if err != nil {
		return err
	}
	*x = Event_Type(value)
	return nil
}
func (Event_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{0, 0} }

// Each of the responses of type `FOO` corresponds to `Foo` message below.
type Response_Type int32

const (
	Response_UNKNOWN Response_Type = 0
	// DEPRECATED.
	//
	// See 'ReconcileOperations' below.
	Response_RECONCILE_OPERATIONS Response_Type = 1
)

var Response_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "RECONCILE_OPERATIONS",
}
var Response_Type_value = map[string]int32{
	"UNKNOWN":              0,
	"RECONCILE_OPERATIONS": 1,
}

func (x Response_Type) Enum() *Response_Type {
	p := new(Response_Type)
	*p = x
	return p
}
func (x Response_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Response_Type_name, int32(x))
}
func (x *Response_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Response_Type_value, data, "Response_Type")
	if err != nil {
		return err
	}
	*x = Response_Type(value)
	return nil
}
func (Response_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{1, 0} }

// Possible call types, followed by message definitions if
// applicable.
type Call_Type int32

const (
	// See comments above on `Event::Type` for more details on this enum value.
	Call_UNKNOWN                      Call_Type = 0
	Call_SUBSCRIBE                    Call_Type = 1
	Call_TEARDOWN                     Call_Type = 2
	Call_ACCEPT                       Call_Type = 3
	Call_DECLINE                      Call_Type = 4
	Call_ACCEPT_INVERSE_OFFERS        Call_Type = 13
	Call_DECLINE_INVERSE_OFFERS       Call_Type = 14
	Call_REVIVE                       Call_Type = 5
	Call_KILL                         Call_Type = 6
	Call_SHUTDOWN                     Call_Type = 7
	Call_ACKNOWLEDGE                  Call_Type = 8
	Call_ACKNOWLEDGE_OPERATION_STATUS Call_Type = 15
	Call_RECONCILE                    Call_Type = 9
	Call_RECONCILE_OPERATIONS         Call_Type = 16
	Call_MESSAGE                      Call_Type = 10
	Call_REQUEST                      Call_Type = 11
	Call_SUPPRESS                     Call_Type = 12
	Call_UPDATE_FRAMEWORK             Call_Type = 17
)

var Call_Type_name = map[int32]string{
	0:  "UNKNOWN",
	1:  "SUBSCRIBE",
	2:  "TEARDOWN",
	3:  "ACCEPT",
	4:  "DECLINE",
	13: "ACCEPT_INVERSE_OFFERS",
	14: "DECLINE_INVERSE_OFFERS",
	5:  "REVIVE",
	6:  "KILL",
	7:  "SHUTDOWN",
	8:  "ACKNOWLEDGE",
	15: "ACKNOWLEDGE_OPERATION_STATUS",
	9:  "RECONCILE",
	16: "RECONCILE_OPERATIONS",
	10: "MESSAGE",
	11: "REQUEST",
	12: "SUPPRESS",
	17: "UPDATE_FRAMEWORK",
}
var Call_Type_value = map[string]int32{
	"UNKNOWN":                      0,
	"SUBSCRIBE":                    1,
	"TEARDOWN":                     2,
	"ACCEPT":                       3,
	"DECLINE":                      4,
	"ACCEPT_INVERSE_OFFERS":        13,
	"DECLINE_INVERSE_OFFERS":       14,
	"REVIVE":                       5,
	"KILL":                         6,
	"SHUTDOWN":                     7,
	"ACKNOWLEDGE":                  8,
	"ACKNOWLEDGE_OPERATION_STATUS": 15,
	"RECONCILE":                    9,
	"RECONCILE_OPERATIONS":         16,
	"MESSAGE":                      10,
	"REQUEST":                      11,
	"SUPPRESS":                     12,
	"UPDATE_FRAMEWORK":             17,
}

func (x Call_Type) Enum() *Call_Type {
	p := new(Call_Type)
	*p = x
	return p
}
func (x Call_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Call_Type_name, int32(x))
}
func (x *Call_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Call_Type_value, data, "Call_Type")
	if err != nil {
		return err
	}
	*x = Call_Type(value)
	return nil
}
func (Call_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{2, 0} }

// *
// Scheduler event API.
//
// An event is described using the standard protocol buffer "union"
// trick, see:
// https://developers.google.com/protocol-buffers/docs/techniques#union.
type Event struct {
	// Type of the event, indicates which optional field below should be
	// present if that type has a nested message definition.
	// Enum fields should be optional, see: MESOS-4997.
	Type                  Event_Type                   `protobuf:"varint,1,opt,name=type,enum=mesos.scheduler.Event_Type" json:"type"`
	Subscribed            *Event_Subscribed            `protobuf:"bytes,2,opt,name=subscribed" json:"subscribed,omitempty"`
	Offers                *Event_Offers                `protobuf:"bytes,3,opt,name=offers" json:"offers,omitempty"`
	InverseOffers         *Event_InverseOffers         `protobuf:"bytes,9,opt,name=inverse_offers,json=inverseOffers" json:"inverse_offers,omitempty"`
	Rescind               *Event_Rescind               `protobuf:"bytes,4,opt,name=rescind" json:"rescind,omitempty"`
	RescindInverseOffer   *Event_RescindInverseOffer   `protobuf:"bytes,10,opt,name=rescind_inverse_offer,json=rescindInverseOffer" json:"rescind_inverse_offer,omitempty"`
	Update                *Event_Update                `protobuf:"bytes,5,opt,name=update" json:"update,omitempty"`
	UpdateOperationStatus *Event_UpdateOperationStatus `protobuf:"bytes,11,opt,name=update_operation_status,json=updateOperationStatus" json:"update_operation_status,omitempty"`
	Message               *Event_Message               `protobuf:"bytes,6,opt,name=message" json:"message,omitempty"`
	Failure               *Event_Failure               `protobuf:"bytes,7,opt,name=failure" json:"failure,omitempty"`
	Error                 *Event_Error                 `protobuf:"bytes,8,opt,name=error" json:"error,omitempty"`
}

func (m *Event) Reset()                    { *m = Event{} }
func (*Event) ProtoMessage()               {}
func (*Event) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{0} }

func (m *Event) GetType() Event_Type {
	if m != nil {
		return m.Type
	}
	return Event_UNKNOWN
}

func (m *Event) GetSubscribed() *Event_Subscribed {
	if m != nil {
		return m.Subscribed
	}
	return nil
}

func (m *Event) GetOffers() *Event_Offers {
	if m != nil {
		return m.Offers
	}
	return nil
}

func (m *Event) GetInverseOffers() *Event_InverseOffers {
	if m != nil {
		return m.InverseOffers
	}
	return nil
}

func (m *Event) GetRescind() *Event_Rescind {
	if m != nil {
		return m.Rescind
	}
	return nil
}

func (m *Event) GetRescindInverseOffer() *Event_RescindInverseOffer {
	if m != nil {
		return m.RescindInverseOffer
	}
	return nil
}

func (m *Event) GetUpdate() *Event_Update {
	if m != nil {
		return m.Update
	}
	return nil
}

func (m *Event) GetUpdateOperationStatus() *Event_UpdateOperationStatus {
	if m != nil {
		return m.UpdateOperationStatus
	}
	return nil
}

func (m *Event) GetMessage() *Event_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *Event) GetFailure() *Event_Failure {
	if m != nil {
		return m.Failure
	}
	return nil
}

func (m *Event) GetError() *Event_Error {
	if m != nil {
		return m.Error
	}
	return nil
}

// First event received when the scheduler subscribes.
type Event_Subscribed struct {
	FrameworkID *mesos.FrameworkID `protobuf:"bytes,1,req,name=framework_id,json=frameworkId" json:"framework_id,omitempty"`
	// This value will be set if the master is sending heartbeats. See
	// the comment above on 'HEARTBEAT' for more details.
	HeartbeatIntervalSeconds *float64 `protobuf:"fixed64,2,opt,name=heartbeat_interval_seconds,json=heartbeatIntervalSeconds" json:"heartbeat_interval_seconds,omitempty"`
	// Since Mesos 1.1.
	MasterInfo *mesos.MasterInfo `protobuf:"bytes,3,opt,name=master_info,json=masterInfo" json:"master_info,omitempty"`
}

func (m *Event_Subscribed) Reset()                    { *m = Event_Subscribed{} }
func (*Event_Subscribed) ProtoMessage()               {}
func (*Event_Subscribed) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{0, 0} }

func (m *Event_Subscribed) GetFrameworkID() *mesos.FrameworkID {
	if m != nil {
		return m.FrameworkID
	}
	return nil
}

func (m *Event_Subscribed) GetHeartbeatIntervalSeconds() float64 {
	if m != nil && m.HeartbeatIntervalSeconds != nil {
		return *m.HeartbeatIntervalSeconds
	}
	return 0
}

func (m *Event_Subscribed) GetMasterInfo() *mesos.MasterInfo {
	if m != nil {
		return m.MasterInfo
	}
	return nil
}

// Received whenever there are new resources that are offered to the
// scheduler. Each offer corresponds to a set of resources on an
// agent. Until the scheduler accepts or declines an offer the
// resources are considered allocated to the scheduler.
type Event_Offers struct {
	Offers []mesos.Offer `protobuf:"bytes,1,rep,name=offers" json:"offers"`
}

func (m *Event_Offers) Reset()                    { *m = Event_Offers{} }
func (*Event_Offers) ProtoMessage()               {}
func (*Event_Offers) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{0, 1} }

func (m *Event_Offers) GetOffers() []mesos.Offer {
	if m != nil {
		return m.Offers
	}
	return nil
}

// Received whenever there are resources requested back from the
// scheduler. Each inverse offer specifies the agent, and
// optionally specific resources. Accepting or Declining an inverse
// offer informs the allocator of the scheduler's ability to release
// the specified resources without violating an SLA. If no resources
// are specified then all resources on the agent are requested to be
// released.
type Event_InverseOffers struct {
	InverseOffers []mesos.InverseOffer `protobuf:"bytes,1,rep,name=inverse_offers,json=inverseOffers" json:"inverse_offers"`
}

func (m *Event_InverseOffers) Reset()                    { *m = Event_InverseOffers{} }
func (*Event_InverseOffers) ProtoMessage()               {}
func (*Event_InverseOffers) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{0, 2} }

func (m *Event_InverseOffers) GetInverseOffers() []mesos.InverseOffer {
	if m != nil {
		return m.InverseOffers
	}
	return nil
}

// Received when a particular offer is no longer valid (e.g., the
// agent corresponding to the offer has been removed) and hence
// needs to be rescinded. Any future calls ('Accept' / 'Decline') made
// by the scheduler regarding this offer will be invalid.
type Event_Rescind struct {
	OfferID mesos.OfferID `protobuf:"bytes,1,req,name=offer_id,json=offerId" json:"offer_id"`
}

func (m *Event_Rescind) Reset()                    { *m = Event_Rescind{} }
func (*Event_Rescind) ProtoMessage()               {}
func (*Event_Rescind) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{0, 3} }

func (m *Event_Rescind) GetOfferID() mesos.OfferID {
	if m != nil {
		return m.OfferID
	}
	return mesos.OfferID{}
}

// Received when a particular inverse offer is no longer valid
// (e.g., the agent corresponding to the offer has been removed)
// and hence needs to be rescinded. Any future calls ('Accept' /
// 'Decline') made by the scheduler regarding this inverse offer
// will be invalid.
type Event_RescindInverseOffer struct {
	InverseOfferID mesos.OfferID `protobuf:"bytes,1,req,name=inverse_offer_id,json=inverseOfferId" json:"inverse_offer_id"`
}

func (m *Event_RescindInverseOffer) Reset()      { *m = Event_RescindInverseOffer{} }
func (*Event_RescindInverseOffer) ProtoMessage() {}
func (*Event_RescindInverseOffer) Descriptor() ([]byte, []int) {
	return fileDescriptorScheduler, []int{0, 4}
}

func (m *Event_RescindInverseOffer) GetInverseOfferID() mesos.OfferID {
	if m != nil {
		return m.InverseOfferID
	}
	return mesos.OfferID{}
}

// Received whenever there is a status update that is generated by
// the executor or agent or master. Status updates should be used by
// executors to reliably communicate the status of the tasks that
// they manage. It is crucial that a terminal update (see TaskState
// in v1/mesos.proto) is sent by the executor as soon as the task
// terminates, in order for Mesos to release the resources allocated
// to the task. It is also the responsibility of the scheduler to
// explicitly acknowledge the receipt of a status update. See
// 'Acknowledge' in the 'Call' section below for the semantics.
//
// A task status update may be used for guaranteed delivery of some
// task-related information, e.g., task's health update. Such
// information may be shadowed by subsequent task status updates, that
// do not preserve fields of the previously sent message.
type Event_Update struct {
	Status mesos.TaskStatus `protobuf:"bytes,1,req,name=status" json:"status"`
}

func (m *Event_Update) Reset()                    { *m = Event_Update{} }
func (*Event_Update) ProtoMessage()               {}
func (*Event_Update) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{0, 5} }

func (m *Event_Update) GetStatus() mesos.TaskStatus {
	if m != nil {
		return m.Status
	}
	return mesos.TaskStatus{}
}

// EXPERIMENTAL.
//
// Received when there is an operation status update generated by the
// master, agent, or resource provider. These updates are only sent to
// the framework for operations which had the operation ID set by the
// framework. It is the responsibility of the scheduler to explicitly
// acknowledge the receipt of a status update.
// See 'AcknowledgeOperationStatus' in the 'Call' section below for
// the semantics.
type Event_UpdateOperationStatus struct {
	Status mesos.OperationStatus `protobuf:"bytes,1,req,name=status" json:"status"`
}

func (m *Event_UpdateOperationStatus) Reset()      { *m = Event_UpdateOperationStatus{} }
func (*Event_UpdateOperationStatus) ProtoMessage() {}
func (*Event_UpdateOperationStatus) Descriptor() ([]byte, []int) {
	return fileDescriptorScheduler, []int{0, 6}
}

func (m *Event_UpdateOperationStatus) GetStatus() mesos.OperationStatus {
	if m != nil {
		return m.Status
	}
	return mesos.OperationStatus{}
}

// Received when a custom message generated by the executor is
// forwarded by the master. Note that this message is not
// interpreted by Mesos and is only forwarded (without reliability
// guarantees) to the scheduler. It is up to the executor to retry
// if the message is dropped for any reason.
type Event_Message struct {
	AgentID    mesos.AgentID    `protobuf:"bytes,1,req,name=agent_id,json=agentId" json:"agent_id"`
	ExecutorID mesos.ExecutorID `protobuf:"bytes,2,req,name=executor_id,json=executorId" json:"executor_id"`
	Data       []byte           `protobuf:"bytes,3,req,name=data" json:"data,omitempty"`
}

func (m *Event_Message) Reset()                    { *m = Event_Message{} }
func (*Event_Message) ProtoMessage()               {}
func (*Event_Message) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{0, 7} }

func (m *Event_Message) GetAgentID() mesos.AgentID {
	if m != nil {
		return m.AgentID
	}
	return mesos.AgentID{}
}

func (m *Event_Message) GetExecutorID() mesos.ExecutorID {
	if m != nil {
		return m.ExecutorID
	}
	return mesos.ExecutorID{}
}

func (m *Event_Message) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// Received when an agent is removed from the cluster (e.g., failed
// health checks) or when an executor is terminated. Note that, this
// event coincides with receipt of terminal UPDATE events for any
// active tasks belonging to the agent or executor and receipt of
// 'Rescind' events for any outstanding offers belonging to the
// agent. Note that there is no guaranteed order between the
// 'Failure', 'Update' and 'Rescind' events when an agent or executor
// is removed.
// TODO(vinod): Consider splitting the lost agent and terminated
// executor into separate events and ensure it's reliably generated.
type Event_Failure struct {
	AgentID *mesos.AgentID `protobuf:"bytes,1,opt,name=agent_id,json=agentId" json:"agent_id,omitempty"`
	// If this was just a failure of an executor on an agent then
	// 'executor_id' will be set and possibly 'status' (if we were
	// able to determine the exit status).
	ExecutorID *mesos.ExecutorID `protobuf:"bytes,2,opt,name=executor_id,json=executorId" json:"executor_id,omitempty"`
	// On Posix, `status` corresponds to termination information in the
	// `stat_loc` area returned from a `waitpid` call. On Windows, `status`
	// is obtained via calling the `GetExitCodeProcess()` function. For
	// messages coming from Posix agents, schedulers need to apply
	// `WEXITSTATUS` family macros or equivalent transformations to obtain
	// exit codes.
	//
	// TODO(alexr): Consider unifying Windows and Posix behavior by returning
	// exit code here, see MESOS-7241.
	Status *int32 `protobuf:"varint,3,opt,name=status" json:"status,omitempty"`
}

func (m *Event_Failure) Reset()                    { *m = Event_Failure{} }
func (*Event_Failure) ProtoMessage()               {}
func (*Event_Failure) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{0, 8} }

func (m *Event_Failure) GetAgentID() *mesos.AgentID {
	if m != nil {
		return m.AgentID
	}
	return nil
}

func (m *Event_Failure) GetExecutorID() *mesos.ExecutorID {
	if m != nil {
		return m.ExecutorID
	}
	return nil
}

func (m *Event_Failure) GetStatus() int32 {
	if m != nil && m.Status != nil {
		return *m.Status
	}
	return 0
}

// Received when there is an unrecoverable error in the scheduler (e.g.,
// scheduler failed over, rate limiting, authorization errors etc.). The
// scheduler should abort on receiving this event.
type Event_Error struct {
	Message string `protobuf:"bytes,1,req,name=message" json:"message"`
}

func (m *Event_Error) Reset()                    { *m = Event_Error{} }
func (*Event_Error) ProtoMessage()               {}
func (*Event_Error) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{0, 9} }

func (m *Event_Error) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// *
// NOTE: After resolution of MESOS-9648, this message is not currently used by
// Mesos. It is left in place in anticipation of future use.
//
// Synchronous responses for calls made to the scheduler API.
type Response struct {
	Type Response_Type `protobuf:"varint,1,opt,name=type,enum=mesos.scheduler.Response_Type" json:"type"`
	// DEPRECATED.
	ReconcileOperations *Response_ReconcileOperations `protobuf:"bytes,2,opt,name=reconcile_operations,json=reconcileOperations" json:"reconcile_operations,omitempty"`
}

func (m *Response) Reset()                    { *m = Response{} }
func (*Response) ProtoMessage()               {}
func (*Response) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{1} }

func (m *Response) GetType() Response_Type {
	if m != nil {
		return m.Type
	}
	return Response_UNKNOWN
}

func (m *Response) GetReconcileOperations() *Response_ReconcileOperations {
	if m != nil {
		return m.ReconcileOperations
	}
	return nil
}

// DEPRECATED.
type Response_ReconcileOperations struct {
	OperationStatuses []mesos.OperationStatus `protobuf:"bytes,1,rep,name=operation_statuses,json=operationStatuses" json:"operation_statuses"`
}

func (m *Response_ReconcileOperations) Reset()      { *m = Response_ReconcileOperations{} }
func (*Response_ReconcileOperations) ProtoMessage() {}
func (*Response_ReconcileOperations) Descriptor() ([]byte, []int) {
	return fileDescriptorScheduler, []int{1, 0}
}

func (m *Response_ReconcileOperations) GetOperationStatuses() []mesos.OperationStatus {
	if m != nil {
		return m.OperationStatuses
	}
	return nil
}

// *
// Scheduler call API.
//
// Like Event, a Call is described using the standard protocol buffer
// "union" trick (see above).
type Call struct {
	// Identifies who generated this call. Master assigns a framework id
	// when a new scheduler subscribes for the first time. Once assigned,
	// the scheduler must set the 'framework_id' here and within its
	// FrameworkInfo (in any further 'Subscribe' calls). This allows the
	// master to identify a scheduler correctly across disconnections,
	// failovers, etc.
	FrameworkID *mesos.FrameworkID `protobuf:"bytes,1,opt,name=framework_id,json=frameworkId" json:"framework_id,omitempty"`
	// Type of the call, indicates which optional field below should be
	// present if that type has a nested message definition.
	// See comments on `Event::Type` above on the reasoning behind this
	// field being optional.
	Type                       Call_Type                        `protobuf:"varint,2,opt,name=type,enum=mesos.scheduler.Call_Type" json:"type"`
	Subscribe                  *Call_Subscribe                  `protobuf:"bytes,3,opt,name=subscribe" json:"subscribe,omitempty"`
	Accept                     *Call_Accept                     `protobuf:"bytes,4,opt,name=accept" json:"accept,omitempty"`
	Decline                    *Call_Decline                    `protobuf:"bytes,5,opt,name=decline" json:"decline,omitempty"`
	AcceptInverseOffers        *Call_AcceptInverseOffers        `protobuf:"bytes,13,opt,name=accept_inverse_offers,json=acceptInverseOffers" json:"accept_inverse_offers,omitempty"`
	DeclineInverseOffers       *Call_DeclineInverseOffers       `protobuf:"bytes,14,opt,name=decline_inverse_offers,json=declineInverseOffers" json:"decline_inverse_offers,omitempty"`
	Revive                     *Call_Revive                     `protobuf:"bytes,15,opt,name=revive" json:"revive,omitempty"`
	Kill                       *Call_Kill                       `protobuf:"bytes,6,opt,name=kill" json:"kill,omitempty"`
	Shutdown                   *Call_Shutdown                   `protobuf:"bytes,7,opt,name=shutdown" json:"shutdown,omitempty"`
	Acknowledge                *Call_Acknowledge                `protobuf:"bytes,8,opt,name=acknowledge" json:"acknowledge,omitempty"`
	AcknowledgeOperationStatus *Call_AcknowledgeOperationStatus `protobuf:"bytes,17,opt,name=acknowledge_operation_status,json=acknowledgeOperationStatus" json:"acknowledge_operation_status,omitempty"`
	Reconcile                  *Call_Reconcile                  `protobuf:"bytes,9,opt,name=reconcile" json:"reconcile,omitempty"`
	ReconcileOperations        *Call_ReconcileOperations        `protobuf:"bytes,18,opt,name=reconcile_operations,json=reconcileOperations" json:"reconcile_operations,omitempty"`
	Message                    *Call_Message                    `protobuf:"bytes,10,opt,name=message" json:"message,omitempty"`
	Request                    *Call_Request                    `protobuf:"bytes,11,opt,name=request" json:"request,omitempty"`
	Suppress                   *Call_Suppress                   `protobuf:"bytes,16,opt,name=suppress" json:"suppress,omitempty"`
	UpdateFramework            *Call_UpdateFramework            `protobuf:"bytes,19,opt,name=update_framework,json=updateFramework" json:"update_framework,omitempty"`
}

func (m *Call) Reset()                    { *m = Call{} }
func (*Call) ProtoMessage()               {}
func (*Call) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{2} }

func (m *Call) GetFrameworkID() *mesos.FrameworkID {
	if m != nil {
		return m.FrameworkID
	}
	return nil
}

func (m *Call) GetType() Call_Type {
	if m != nil {
		return m.Type
	}
	return Call_UNKNOWN
}

func (m *Call) GetSubscribe() *Call_Subscribe {
	if m != nil {
		return m.Subscribe
	}
	return nil
}

func (m *Call) GetAccept() *Call_Accept {
	if m != nil {
		return m.Accept
	}
	return nil
}

func (m *Call) GetDecline() *Call_Decline {
	if m != nil {
		return m.Decline
	}
	return nil
}

func (m *Call) GetAcceptInverseOffers() *Call_AcceptInverseOffers {
	if m != nil {
		return m.AcceptInverseOffers
	}
	return nil
}

func (m *Call) GetDeclineInverseOffers() *Call_DeclineInverseOffers {
	if m != nil {
		return m.DeclineInverseOffers
	}
	return nil
}

func (m *Call) GetRevive() *Call_Revive {
	if m != nil {
		return m.Revive
	}
	return nil
}

func (m *Call) GetKill() *Call_Kill {
	if m != nil {
		return m.Kill
	}
	return nil
}

func (m *Call) GetShutdown() *Call_Shutdown {
	if m != nil {
		return m.Shutdown
	}
	return nil
}

func (m *Call) GetAcknowledge() *Call_Acknowledge {
	if m != nil {
		return m.Acknowledge
	}
	return nil
}

func (m *Call) GetAcknowledgeOperationStatus() *Call_AcknowledgeOperationStatus {
	if m != nil {
		return m.AcknowledgeOperationStatus
	}
	return nil
}

func (m *Call) GetReconcile() *Call_Reconcile {
	if m != nil {
		return m.Reconcile
	}
	return nil
}

func (m *Call) GetReconcileOperations() *Call_ReconcileOperations {
	if m != nil {
		return m.ReconcileOperations
	}
	return nil
}

func (m *Call) GetMessage() *Call_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *Call) GetRequest() *Call_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *Call) GetSuppress() *Call_Suppress {
	if m != nil {
		return m.Suppress
	}
	return nil
}

func (m *Call) GetUpdateFramework() *Call_UpdateFramework {
	if m != nil {
		return m.UpdateFramework
	}
	return nil
}

// Subscribes the scheduler with the master to receive events. A
// scheduler must send other calls only after it has received the
// SUBCRIBED event.
type Call_Subscribe struct {
	// See the comments below on 'framework_id' on the semantics for
	// 'framework_info.id'.
	FrameworkInfo *mesos.FrameworkInfo `protobuf:"bytes,1,req,name=framework_info,json=frameworkInfo" json:"framework_info,omitempty"`
	// List of suppressed roles for which the framework does not wish to be
	// offered resources. The framework can decide to suppress all or a subset
	// of roles the framework (re)registers as.
	SuppressedRoles []string `protobuf:"bytes,2,rep,name=suppressed_roles,json=suppressedRoles" json:"suppressed_roles,omitempty"`
}

func (m *Call_Subscribe) Reset()                    { *m = Call_Subscribe{} }
func (*Call_Subscribe) ProtoMessage()               {}
func (*Call_Subscribe) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{2, 0} }

func (m *Call_Subscribe) GetFrameworkInfo() *mesos.FrameworkInfo {
	if m != nil {
		return m.FrameworkInfo
	}
	return nil
}

func (m *Call_Subscribe) GetSuppressedRoles() []string {
	if m != nil {
		return m.SuppressedRoles
	}
	return nil
}

// Accepts an offer, performing the specified operations
// in a sequential manner.
//
// E.g. Launch a task with a newly reserved persistent volume:
//
//   Accept {
//     offer_ids: [ ... ]
//     operations: [
//       { type: RESERVE,
//         reserve: { resources: [ disk(role):2 ] } }
//       { type: CREATE,
//         create: { volumes: [ disk(role):1+persistence ] } }
//       { type: LAUNCH,
//         launch: { task_infos ... disk(role):1;disk(role):1+persistence } }
//     ]
//   }
//
// Note that any of the offer's resources not used in the 'Accept'
// call (e.g., to launch a task) are considered unused and might be
// reoffered to other frameworks. In other words, the same OfferID
// cannot be used in more than one 'Accept' call.
type Call_Accept struct {
	OfferIDs   []mesos.OfferID         `protobuf:"bytes,1,rep,name=offer_ids,json=offerIds" json:"offer_ids"`
	Operations []mesos.Offer_Operation `protobuf:"bytes,2,rep,name=operations" json:"operations"`
	Filters    *mesos.Filters          `protobuf:"bytes,3,opt,name=filters" json:"filters,omitempty"`
}

func (m *Call_Accept) Reset()                    { *m = Call_Accept{} }
func (*Call_Accept) ProtoMessage()               {}
func (*Call_Accept) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{2, 1} }

func (m *Call_Accept) GetOfferIDs() []mesos.OfferID {
	if m != nil {
		return m.OfferIDs
	}
	return nil
}

func (m *Call_Accept) GetOperations() []mesos.Offer_Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *Call_Accept) GetFilters() *mesos.Filters {
	if m != nil {
		return m.Filters
	}
	return nil
}

// Declines an offer, signaling the master to potentially reoffer
// the resources to a different framework. Note that this is same
// as sending an Accept call with no operations. See comments on
// top of 'Accept' for semantics.
type Call_Decline struct {
	OfferIDs []mesos.OfferID `protobuf:"bytes,1,rep,name=offer_ids,json=offerIds" json:"offer_ids"`
	Filters  *mesos.Filters  `protobuf:"bytes,2,opt,name=filters" json:"filters,omitempty"`
}

func (m *Call_Decline) Reset()                    { *m = Call_Decline{} }
func (*Call_Decline) ProtoMessage()               {}
func (*Call_Decline) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{2, 2} }

func (m *Call_Decline) GetOfferIDs() []mesos.OfferID {
	if m != nil {
		return m.OfferIDs
	}
	return nil
}

func (m *Call_Decline) GetFilters() *mesos.Filters {
	if m != nil {
		return m.Filters
	}
	return nil
}

// Accepts an inverse offer. Inverse offers should only be accepted
// if the resources in the offer can be safely evacuated before the
// provided unavailability.
type Call_AcceptInverseOffers struct {
	InverseOfferIDs []mesos.OfferID `protobuf:"bytes,1,rep,name=inverse_offer_ids,json=inverseOfferIds" json:"inverse_offer_ids"`
	Filters         *mesos.Filters  `protobuf:"bytes,2,opt,name=filters" json:"filters,omitempty"`
}

func (m *Call_AcceptInverseOffers) Reset()      { *m = Call_AcceptInverseOffers{} }
func (*Call_AcceptInverseOffers) ProtoMessage() {}
func (*Call_AcceptInverseOffers) Descriptor() ([]byte, []int) {
	return fileDescriptorScheduler, []int{2, 3}
}

func (m *Call_AcceptInverseOffers) GetInverseOfferIDs() []mesos.OfferID {
	if m != nil {
		return m.InverseOfferIDs
	}
	return nil
}

func (m *Call_AcceptInverseOffers) GetFilters() *mesos.Filters {
	if m != nil {
		return m.Filters
	}
	return nil
}

// Declines an inverse offer. Inverse offers should be declined if
// the resources in the offer might not be safely evacuated before
// the provided unavailability.
type Call_DeclineInverseOffers struct {
	InverseOfferIDs []mesos.OfferID `protobuf:"bytes,1,rep,name=inverse_offer_ids,json=inverseOfferIds" json:"inverse_offer_ids"`
	Filters         *mesos.Filters  `protobuf:"bytes,2,opt,name=filters" json:"filters,omitempty"`
}

func (m *Call_DeclineInverseOffers) Reset()      { *m = Call_DeclineInverseOffers{} }
func (*Call_DeclineInverseOffers) ProtoMessage() {}
func (*Call_DeclineInverseOffers) Descriptor() ([]byte, []int) {
	return fileDescriptorScheduler, []int{2, 4}
}

func (m *Call_DeclineInverseOffers) GetInverseOfferIDs() []mesos.OfferID {
	if m != nil {
		return m.InverseOfferIDs
	}
	return nil
}

func (m *Call_DeclineInverseOffers) GetFilters() *mesos.Filters {
	if m != nil {
		return m.Filters
	}
	return nil
}

// Revive offers for the specified roles. If `roles` is empty,
// the `REVIVE` call will revive offers for all of the roles
// the framework is currently subscribed to.
type Call_Revive struct {
	Roles []string `protobuf:"bytes,1,rep,name=roles" json:"roles,omitempty"`
}

func (m *Call_Revive) Reset()                    { *m = Call_Revive{} }
func (*Call_Revive) ProtoMessage()               {}
func (*Call_Revive) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{2, 5} }

func (m *Call_Revive) GetRoles() []string {
	if m != nil {
		return m.Roles
	}
	return nil
}

// Kills a specific task. If the scheduler has a custom executor,
// the kill is forwarded to the executor and it is up to the
// executor to kill the task and send a TASK_KILLED (or TASK_FAILED)
// update. Note that Mesos releases the resources for a task once it
// receives a terminal update (See TaskState in v1/mesos.proto) for
// it. If the task is unknown to the master, a TASK_LOST update is
// generated.
//
// If a task within a task group is killed before the group is
// delivered to the executor, all tasks in the task group are
// killed. When a task group has been delivered to the executor,
// it is up to the executor to decide how to deal with the kill.
// Note The default Mesos executor will currently kill all the
// tasks in the task group if it gets a kill for any task.
type Call_Kill struct {
	TaskID  mesos.TaskID   `protobuf:"bytes,1,req,name=task_id,json=taskId" json:"task_id"`
	AgentID *mesos.AgentID `protobuf:"bytes,2,opt,name=agent_id,json=agentId" json:"agent_id,omitempty"`
	// If set, overrides any previously specified kill policy for this task.
	// This includes 'TaskInfo.kill_policy' and 'Executor.kill.kill_policy'.
	// Can be used to forcefully kill a task which is already being killed.
	KillPolicy *mesos.KillPolicy `protobuf:"bytes,3,opt,name=kill_policy,json=killPolicy" json:"kill_policy,omitempty"`
}

func (m *Call_Kill) Reset()                    { *m = Call_Kill{} }
func (*Call_Kill) ProtoMessage()               {}
func (*Call_Kill) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{2, 6} }

func (m *Call_Kill) GetTaskID() mesos.TaskID {
	if m != nil {
		return m.TaskID
	}
	return mesos.TaskID{}
}

func (m *Call_Kill) GetAgentID() *mesos.AgentID {
	if m != nil {
		return m.AgentID
	}
	return nil
}

func (m *Call_Kill) GetKillPolicy() *mesos.KillPolicy {
	if m != nil {
		return m.KillPolicy
	}
	return nil
}

// Shuts down a custom executor. When the executor gets a shutdown
// event, it is expected to kill all its tasks (and send TASK_KILLED
// updates) and terminate. If the executor doesn't terminate within
// a certain timeout (configurable via
// '--executor_shutdown_grace_period' agent flag), the agent will
// forcefully destroy the container (executor and its tasks) and
// transition its active tasks to TASK_LOST.
type Call_Shutdown struct {
	ExecutorID mesos.ExecutorID `protobuf:"bytes,1,req,name=executor_id,json=executorId" json:"executor_id"`
	AgentID    mesos.AgentID    `protobuf:"bytes,2,req,name=agent_id,json=agentId" json:"agent_id"`
}

func (m *Call_Shutdown) Reset()                    { *m = Call_Shutdown{} }
func (*Call_Shutdown) ProtoMessage()               {}
func (*Call_Shutdown) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{2, 7} }

func (m *Call_Shutdown) GetExecutorID() mesos.ExecutorID {
	if m != nil {
		return m.ExecutorID
	}
	return mesos.ExecutorID{}
}

func (m *Call_Shutdown) GetAgentID() mesos.AgentID {
	if m != nil {
		return m.AgentID
	}
	return mesos.AgentID{}
}

// Acknowledges the receipt of status update. Schedulers are
// responsible for explicitly acknowledging the receipt of status
// updates that have 'Update.status().uuid()' field set. Such status
// updates are retried by the agent until they are acknowledged by
// the scheduler.
type Call_Acknowledge struct {
	AgentID mesos.AgentID `protobuf:"bytes,1,req,name=agent_id,json=agentId" json:"agent_id"`
	TaskID  mesos.TaskID  `protobuf:"bytes,2,req,name=task_id,json=taskId" json:"task_id"`
	UUID    []byte        `protobuf:"bytes,3,req,name=uuid" json:"uuid,omitempty"`
}

func (m *Call_Acknowledge) Reset()                    { *m = Call_Acknowledge{} }
func (*Call_Acknowledge) ProtoMessage()               {}
func (*Call_Acknowledge) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{2, 8} }

func (m *Call_Acknowledge) GetAgentID() mesos.AgentID {
	if m != nil {
		return m.AgentID
	}
	return mesos.AgentID{}
}

func (m *Call_Acknowledge) GetTaskID() mesos.TaskID {
	if m != nil {
		return m.TaskID
	}
	return mesos.TaskID{}
}

func (m *Call_Acknowledge) GetUUID() []byte {
	if m != nil {
		return m.UUID
	}
	return nil
}

// EXPERIMENTAL.
//
// Acknowledges the receipt of an operation status update. Schedulers
// are responsible for explicitly acknowledging the receipt of updates
// which have the 'UpdateOperationStatus.status().uuid()' field set.
// Such status updates are retried by the agent or resource provider
// until they are acknowledged by the scheduler.
type Call_AcknowledgeOperationStatus struct {
	// If the operation affects resources that belong to a SLRP, both
	// `agent_id` and `resource_provider_id` have to be set.
	//
	// If the operation affects resources that belong to a SERP, only
	// `resource_provider_id` has to be set.
	AgentID            *mesos.AgentID            `protobuf:"bytes,1,opt,name=agent_id,json=agentId" json:"agent_id,omitempty"`
	ResourceProviderID *mesos.ResourceProviderID `protobuf:"bytes,2,opt,name=resource_provider_id,json=resourceProviderId" json:"resource_provider_id,omitempty"`
	UUID               []byte                    `protobuf:"bytes,3,req,name=uuid" json:"uuid,omitempty"`
	OperationID        mesos.OperationID         `protobuf:"bytes,4,req,name=operation_id,json=operationId" json:"operation_id"`
}

func (m *Call_AcknowledgeOperationStatus) Reset()      { *m = Call_AcknowledgeOperationStatus{} }
func (*Call_AcknowledgeOperationStatus) ProtoMessage() {}
func (*Call_AcknowledgeOperationStatus) Descriptor() ([]byte, []int) {
	return fileDescriptorScheduler, []int{2, 9}
}

func (m *Call_AcknowledgeOperationStatus) GetAgentID() *mesos.AgentID {
	if m != nil {
		return m.AgentID
	}
	return nil
}

func (m *Call_AcknowledgeOperationStatus) GetResourceProviderID() *mesos.ResourceProviderID {
	if m != nil {
		return m.ResourceProviderID
	}
	return nil
}

func (m *Call_AcknowledgeOperationStatus) GetUUID() []byte {
	if m != nil {
		return m.UUID
	}
	return nil
}

func (m *Call_AcknowledgeOperationStatus) GetOperationID() mesos.OperationID {
	if m != nil {
		return m.OperationID
	}
	return mesos.OperationID{}
}

// Allows the scheduler to query the status for non-terminal tasks.
// This causes the master to send back the latest task status for
// each task in 'tasks', if possible. Tasks that are no longer known
// will result in a TASK_LOST, TASK_UNKNOWN, or TASK_UNREACHABLE update.
// If 'tasks' is empty, then the master will send the latest status
// for each task currently known.
type Call_Reconcile struct {
	Tasks []Call_Reconcile_Task `protobuf:"bytes,1,rep,name=tasks" json:"tasks"`
}

func (m *Call_Reconcile) Reset()                    { *m = Call_Reconcile{} }
func (*Call_Reconcile) ProtoMessage()               {}
func (*Call_Reconcile) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{2, 10} }

func (m *Call_Reconcile) GetTasks() []Call_Reconcile_Task {
	if m != nil {
		return m.Tasks
	}
	return nil
}

// TODO(vinod): Support arbitrary queries than just state of tasks.
type Call_Reconcile_Task struct {
	TaskID  mesos.TaskID   `protobuf:"bytes,1,req,name=task_id,json=taskId" json:"task_id"`
	AgentID *mesos.AgentID `protobuf:"bytes,2,opt,name=agent_id,json=agentId" json:"agent_id,omitempty"`
}

func (m *Call_Reconcile_Task) Reset()      { *m = Call_Reconcile_Task{} }
func (*Call_Reconcile_Task) ProtoMessage() {}
func (*Call_Reconcile_Task) Descriptor() ([]byte, []int) {
	return fileDescriptorScheduler, []int{2, 10, 0}
}

func (m *Call_Reconcile_Task) GetTaskID() mesos.TaskID {
	if m != nil {
		return m.TaskID
	}
	return mesos.TaskID{}
}

func (m *Call_Reconcile_Task) GetAgentID() *mesos.AgentID {
	if m != nil {
		return m.AgentID
	}
	return nil
}

// EXPERIMENTAL.
//
// Allows the scheduler to query the status of operations. This causes
// the master to send back the latest status for each operation in
// 'operations', if possible. If 'operations' is empty, then the
// master will send the latest status for each operation currently
// known.
type Call_ReconcileOperations struct {
	Operations []Call_ReconcileOperations_Operation `protobuf:"bytes,1,rep,name=operations" json:"operations"`
}

func (m *Call_ReconcileOperations) Reset()      { *m = Call_ReconcileOperations{} }
func (*Call_ReconcileOperations) ProtoMessage() {}
func (*Call_ReconcileOperations) Descriptor() ([]byte, []int) {
	return fileDescriptorScheduler, []int{2, 11}
}

func (m *Call_ReconcileOperations) GetOperations() []Call_ReconcileOperations_Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

type Call_ReconcileOperations_Operation struct {
	OperationID mesos.OperationID `protobuf:"bytes,1,req,name=operation_id,json=operationId" json:"operation_id"`
	// If `agent_id` is not set and the master doesn't know the operation,
	// then it will return `OPERATION_UNKNOWN`; if `agent_id` is set, it can
	// return more fine-grained states depending on the state of the
	// corresponding agent.
	AgentID            *mesos.AgentID            `protobuf:"bytes,2,opt,name=agent_id,json=agentId" json:"agent_id,omitempty"`
	ResourceProviderID *mesos.ResourceProviderID `protobuf:"bytes,3,opt,name=resource_provider_id,json=resourceProviderId" json:"resource_provider_id,omitempty"`
}

func (m *Call_ReconcileOperations_Operation) Reset()      { *m = Call_ReconcileOperations_Operation{} }
func (*Call_ReconcileOperations_Operation) ProtoMessage() {}
func (*Call_ReconcileOperations_Operation) Descriptor() ([]byte, []int) {
	return fileDescriptorScheduler, []int{2, 11, 0}
}

func (m *Call_ReconcileOperations_Operation) GetOperationID() mesos.OperationID {
	if m != nil {
		return m.OperationID
	}
	return mesos.OperationID{}
}

func (m *Call_ReconcileOperations_Operation) GetAgentID() *mesos.AgentID {
	if m != nil {
		return m.AgentID
	}
	return nil
}

func (m *Call_ReconcileOperations_Operation) GetResourceProviderID() *mesos.ResourceProviderID {
	if m != nil {
		return m.ResourceProviderID
	}
	return nil
}

// Sends arbitrary binary data to the executor. Note that Mesos
// neither interprets this data nor makes any guarantees about the
// delivery of this message to the executor.
type Call_Message struct {
	AgentID    mesos.AgentID    `protobuf:"bytes,1,req,name=agent_id,json=agentId" json:"agent_id"`
	ExecutorID mesos.ExecutorID `protobuf:"bytes,2,req,name=executor_id,json=executorId" json:"executor_id"`
	Data       []byte           `protobuf:"bytes,3,req,name=data" json:"data,omitempty"`
}

func (m *Call_Message) Reset()                    { *m = Call_Message{} }
func (*Call_Message) ProtoMessage()               {}
func (*Call_Message) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{2, 12} }

func (m *Call_Message) GetAgentID() mesos.AgentID {
	if m != nil {
		return m.AgentID
	}
	return mesos.AgentID{}
}

func (m *Call_Message) GetExecutorID() mesos.ExecutorID {
	if m != nil {
		return m.ExecutorID
	}
	return mesos.ExecutorID{}
}

func (m *Call_Message) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// Requests a specific set of resources from Mesos's allocator. If
// the allocator has support for this, corresponding offers will be
// sent asynchronously via the OFFERS event(s).
//
// NOTE: The built-in hierarchical allocator doesn't have support
// for this call and hence simply ignores it.
type Call_Request struct {
	Requests []mesos.Request `protobuf:"bytes,1,rep,name=requests" json:"requests"`
}

func (m *Call_Request) Reset()                    { *m = Call_Request{} }
func (*Call_Request) ProtoMessage()               {}
func (*Call_Request) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{2, 13} }

func (m *Call_Request) GetRequests() []mesos.Request {
	if m != nil {
		return m.Requests
	}
	return nil
}

// Suppress offers for the specified roles. If `roles` is empty,
// the `SUPPRESS` call will suppress offers for all of the roles
// the framework is currently subscribed to.
type Call_Suppress struct {
	Roles []string `protobuf:"bytes,1,rep,name=roles" json:"roles,omitempty"`
}

func (m *Call_Suppress) Reset()                    { *m = Call_Suppress{} }
func (*Call_Suppress) ProtoMessage()               {}
func (*Call_Suppress) Descriptor() ([]byte, []int) { return fileDescriptorScheduler, []int{2, 14} }

func (m *Call_Suppress) GetRoles() []string {
	if m != nil {
		return m.Roles
	}
	return nil
}

// Updates the FrameworkInfo. All fields can be updated except for:
//
// * FrameworkInfo.checkpoint
// * FrameworkInfo.principal
// * FrameworkInfo.user
//
// The call returns after the update is either applied completely or
// not applied at all. No incomplete updates occur.
//
// The HTTP response codes specific to this call are:
//
// * 200 OK: update operation was successfully completed.
// * 400 Bad Request: the requested update is not valid.
// * 403 Forbidden: framework is not authorized to use some entities
//   requested by the update (e.g. not authorized to use some of the
//   supplied roles).
// * 409 Conflict: framework disappeared while this call was being processed
//   (example: the framework was removed by a concurrent TEARDOWN call).
//
type Call_UpdateFramework struct {
	FrameworkInfo mesos.FrameworkInfo `protobuf:"bytes,1,req,name=framework_info,json=frameworkInfo" json:"framework_info"`
	// List of suppressed roles for which the framework does not wish to be
	// offered resources. The framework can decide to suppress all or a subset
	// of roles provided in the new `framework_info`.
	SuppressedRoles []string `protobuf:"bytes,2,rep,name=suppressed_roles,json=suppressedRoles" json:"suppressed_roles,omitempty"`
}

func (m *Call_UpdateFramework) Reset()      { *m = Call_UpdateFramework{} }
func (*Call_UpdateFramework) ProtoMessage() {}
func (*Call_UpdateFramework) Descriptor() ([]byte, []int) {
	return fileDescriptorScheduler, []int{2, 15}
}

func (m *Call_UpdateFramework) GetFrameworkInfo() mesos.FrameworkInfo {
	if m != nil {
		return m.FrameworkInfo
	}
	return mesos.FrameworkInfo{}
}

func (m *Call_UpdateFramework) GetSuppressedRoles() []string {
	if m != nil {
		return m.SuppressedRoles
	}
	return nil
}

func init() {
	proto.RegisterType((*Event)(nil), "mesos.scheduler.Event")
	proto.RegisterType((*Event_Subscribed)(nil), "mesos.scheduler.Event.Subscribed")
	proto.RegisterType((*Event_Offers)(nil), "mesos.scheduler.Event.Offers")
	proto.RegisterType((*Event_InverseOffers)(nil), "mesos.scheduler.Event.InverseOffers")
	proto.RegisterType((*Event_Rescind)(nil), "mesos.scheduler.Event.Rescind")
	proto.RegisterType((*Event_RescindInverseOffer)(nil), "mesos.scheduler.Event.RescindInverseOffer")
	proto.RegisterType((*Event_Update)(nil), "mesos.scheduler.Event.Update")
	proto.RegisterType((*Event_UpdateOperationStatus)(nil), "mesos.scheduler.Event.UpdateOperationStatus")
	proto.RegisterType((*Event_Message)(nil), "mesos.scheduler.Event.Message")
	proto.RegisterType((*Event_Failure)(nil), "mesos.scheduler.Event.Failure")
	proto.RegisterType((*Event_Error)(nil), "mesos.scheduler.Event.Error")
	proto.RegisterType((*Response)(nil), "mesos.scheduler.Response")
	proto.RegisterType((*Response_ReconcileOperations)(nil), "mesos.scheduler.Response.ReconcileOperations")
	proto.RegisterType((*Call)(nil), "mesos.scheduler.Call")
	proto.RegisterType((*Call_Subscribe)(nil), "mesos.scheduler.Call.Subscribe")
	proto.RegisterType((*Call_Accept)(nil), "mesos.scheduler.Call.Accept")
	proto.RegisterType((*Call_Decline)(nil), "mesos.scheduler.Call.Decline")
	proto.RegisterType((*Call_AcceptInverseOffers)(nil), "mesos.scheduler.Call.AcceptInverseOffers")
	proto.RegisterType((*Call_DeclineInverseOffers)(nil), "mesos.scheduler.Call.DeclineInverseOffers")
	proto.RegisterType((*Call_Revive)(nil), "mesos.scheduler.Call.Revive")
	proto.RegisterType((*Call_Kill)(nil), "mesos.scheduler.Call.Kill")
	proto.RegisterType((*Call_Shutdown)(nil), "mesos.scheduler.Call.Shutdown")
	proto.RegisterType((*Call_Acknowledge)(nil), "mesos.scheduler.Call.Acknowledge")
	proto.RegisterType((*Call_AcknowledgeOperationStatus)(nil), "mesos.scheduler.Call.AcknowledgeOperationStatus")
	proto.RegisterType((*Call_Reconcile)(nil), "mesos.scheduler.Call.Reconcile")
	proto.RegisterType((*Call_Reconcile_Task)(nil), "mesos.scheduler.Call.Reconcile.Task")
	proto.RegisterType((*Call_ReconcileOperations)(nil), "mesos.scheduler.Call.ReconcileOperations")
	proto.RegisterType((*Call_ReconcileOperations_Operation)(nil), "mesos.scheduler.Call.ReconcileOperations.Operation")
	proto.RegisterType((*Call_Message)(nil), "mesos.scheduler.Call.Message")
	proto.RegisterType((*Call_Request)(nil), "mesos.scheduler.Call.Request")
	proto.RegisterType((*Call_Suppress)(nil), "mesos.scheduler.Call.Suppress")
	proto.RegisterType((*Call_UpdateFramework)(nil), "mesos.scheduler.Call.UpdateFramework")
	proto.RegisterEnum("mesos.scheduler.Event_Type", Event_Type_name, Event_Type_value)
	proto.RegisterEnum("mesos.scheduler.Response_Type", Response_Type_name, Response_Type_value)
	proto.RegisterEnum("mesos.scheduler.Call_Type", Call_Type_name, Call_Type_value)
}
func (x Event_Type) String() string {
	s, ok := Event_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x Response_Type) String() string {
	s, ok := Response_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x Call_Type) String() string {
	s, ok := Call_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (this *Event) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event)
	if !ok {
		that2, ok := that.(Event)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Subscribed.Equal(that1.Subscribed) {
		return fmt.Errorf("Subscribed this(%v) Not Equal that(%v)", this.Subscribed, that1.Subscribed)
	}
	if !this.Offers.Equal(that1.Offers) {
		return fmt.Errorf("Offers this(%v) Not Equal that(%v)", this.Offers, that1.Offers)
	}
	if !this.InverseOffers.Equal(that1.InverseOffers) {
		return fmt.Errorf("InverseOffers this(%v) Not Equal that(%v)", this.InverseOffers, that1.InverseOffers)
	}
	if !this.Rescind.Equal(that1.Rescind) {
		return fmt.Errorf("Rescind this(%v) Not Equal that(%v)", this.Rescind, that1.Rescind)
	}
	if !this.RescindInverseOffer.Equal(that1.RescindInverseOffer) {
		return fmt.Errorf("RescindInverseOffer this(%v) Not Equal that(%v)", this.RescindInverseOffer, that1.RescindInverseOffer)
	}
	if !this.Update.Equal(that1.Update) {
		return fmt.Errorf("Update this(%v) Not Equal that(%v)", this.Update, that1.Update)
	}
	if !this.UpdateOperationStatus.Equal(that1.UpdateOperationStatus) {
		return fmt.Errorf("UpdateOperationStatus this(%v) Not Equal that(%v)", this.UpdateOperationStatus, that1.UpdateOperationStatus)
	}
	if !this.Message.Equal(that1.Message) {
		return fmt.Errorf("Message this(%v) Not Equal that(%v)", this.Message, that1.Message)
	}
	if !this.Failure.Equal(that1.Failure) {
		return fmt.Errorf("Failure this(%v) Not Equal that(%v)", this.Failure, that1.Failure)
	}
	if !this.Error.Equal(that1.Error) {
		return fmt.Errorf("Error this(%v) Not Equal that(%v)", this.Error, that1.Error)
	}
	return nil
}
func (this *Event) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event)
	if !ok {
		that2, ok := that.(Event)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.Subscribed.Equal(that1.Subscribed) {
		return false
	}
	if !this.Offers.Equal(that1.Offers) {
		return false
	}
	if !this.InverseOffers.Equal(that1.InverseOffers) {
		return false
	}
	if !this.Rescind.Equal(that1.Rescind) {
		return false
	}
	if !this.RescindInverseOffer.Equal(that1.RescindInverseOffer) {
		return false
	}
	if !this.Update.Equal(that1.Update) {
		return false
	}
	if !this.UpdateOperationStatus.Equal(that1.UpdateOperationStatus) {
		return false
	}
	if !this.Message.Equal(that1.Message) {
		return false
	}
	if !this.Failure.Equal(that1.Failure) {
		return false
	}
	if !this.Error.Equal(that1.Error) {
		return false
	}
	return true
}
func (this *Event_Subscribed) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_Subscribed)
	if !ok {
		that2, ok := that.(Event_Subscribed)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_Subscribed")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_Subscribed but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_Subscribed but is not nil && this == nil")
	}
	if !this.FrameworkID.Equal(that1.FrameworkID) {
		return fmt.Errorf("FrameworkID this(%v) Not Equal that(%v)", this.FrameworkID, that1.FrameworkID)
	}
	if this.HeartbeatIntervalSeconds != nil && that1.HeartbeatIntervalSeconds != nil {
		if *this.HeartbeatIntervalSeconds != *that1.HeartbeatIntervalSeconds {
			return fmt.Errorf("HeartbeatIntervalSeconds this(%v) Not Equal that(%v)", *this.HeartbeatIntervalSeconds, *that1.HeartbeatIntervalSeconds)
		}
	} else if this.HeartbeatIntervalSeconds != nil {
		return fmt.Errorf("this.HeartbeatIntervalSeconds == nil && that.HeartbeatIntervalSeconds != nil")
	} else if that1.HeartbeatIntervalSeconds != nil {
		return fmt.Errorf("HeartbeatIntervalSeconds this(%v) Not Equal that(%v)", this.HeartbeatIntervalSeconds, that1.HeartbeatIntervalSeconds)
	}
	if !this.MasterInfo.Equal(that1.MasterInfo) {
		return fmt.Errorf("MasterInfo this(%v) Not Equal that(%v)", this.MasterInfo, that1.MasterInfo)
	}
	return nil
}
func (this *Event_Subscribed) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_Subscribed)
	if !ok {
		that2, ok := that.(Event_Subscribed)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.FrameworkID.Equal(that1.FrameworkID) {
		return false
	}
	if this.HeartbeatIntervalSeconds != nil && that1.HeartbeatIntervalSeconds != nil {
		if *this.HeartbeatIntervalSeconds != *that1.HeartbeatIntervalSeconds {
			return false
		}
	} else if this.HeartbeatIntervalSeconds != nil {
		return false
	} else if that1.HeartbeatIntervalSeconds != nil {
		return false
	}
	if !this.MasterInfo.Equal(that1.MasterInfo) {
		return false
	}
	return true
}
func (this *Event_Offers) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_Offers)
	if !ok {
		that2, ok := that.(Event_Offers)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_Offers")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_Offers but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_Offers but is not nil && this == nil")
	}
	if len(this.Offers) != len(that1.Offers) {
		return fmt.Errorf("Offers this(%v) Not Equal that(%v)", len(this.Offers), len(that1.Offers))
	}
	for i := range this.Offers {
		if !this.Offers[i].Equal(&that1.Offers[i]) {
			return fmt.Errorf("Offers this[%v](%v) Not Equal that[%v](%v)", i, this.Offers[i], i, that1.Offers[i])
		}
	}
	return nil
}
func (this *Event_Offers) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_Offers)
	if !ok {
		that2, ok := that.(Event_Offers)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Offers) != len(that1.Offers) {
		return false
	}
	for i := range this.Offers {
		if !this.Offers[i].Equal(&that1.Offers[i]) {
			return false
		}
	}
	return true
}
func (this *Event_InverseOffers) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_InverseOffers)
	if !ok {
		that2, ok := that.(Event_InverseOffers)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_InverseOffers")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_InverseOffers but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_InverseOffers but is not nil && this == nil")
	}
	if len(this.InverseOffers) != len(that1.InverseOffers) {
		return fmt.Errorf("InverseOffers this(%v) Not Equal that(%v)", len(this.InverseOffers), len(that1.InverseOffers))
	}
	for i := range this.InverseOffers {
		if !this.InverseOffers[i].Equal(&that1.InverseOffers[i]) {
			return fmt.Errorf("InverseOffers this[%v](%v) Not Equal that[%v](%v)", i, this.InverseOffers[i], i, that1.InverseOffers[i])
		}
	}
	return nil
}
func (this *Event_InverseOffers) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_InverseOffers)
	if !ok {
		that2, ok := that.(Event_InverseOffers)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.InverseOffers) != len(that1.InverseOffers) {
		return false
	}
	for i := range this.InverseOffers {
		if !this.InverseOffers[i].Equal(&that1.InverseOffers[i]) {
			return false
		}
	}
	return true
}
func (this *Event_Rescind) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_Rescind)
	if !ok {
		that2, ok := that.(Event_Rescind)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_Rescind")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_Rescind but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_Rescind but is not nil && this == nil")
	}
	if !this.OfferID.Equal(&that1.OfferID) {
		return fmt.Errorf("OfferID this(%v) Not Equal that(%v)", this.OfferID, that1.OfferID)
	}
	return nil
}
func (this *Event_Rescind) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_Rescind)
	if !ok {
		that2, ok := that.(Event_Rescind)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.OfferID.Equal(&that1.OfferID) {
		return false
	}
	return true
}
func (this *Event_RescindInverseOffer) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_RescindInverseOffer)
	if !ok {
		that2, ok := that.(Event_RescindInverseOffer)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_RescindInverseOffer")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_RescindInverseOffer but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_RescindInverseOffer but is not nil && this == nil")
	}
	if !this.InverseOfferID.Equal(&that1.InverseOfferID) {
		return fmt.Errorf("InverseOfferID this(%v) Not Equal that(%v)", this.InverseOfferID, that1.InverseOfferID)
	}
	return nil
}
func (this *Event_RescindInverseOffer) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_RescindInverseOffer)
	if !ok {
		that2, ok := that.(Event_RescindInverseOffer)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.InverseOfferID.Equal(&that1.InverseOfferID) {
		return false
	}
	return true
}
func (this *Event_Update) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_Update)
	if !ok {
		that2, ok := that.(Event_Update)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_Update")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_Update but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_Update but is not nil && this == nil")
	}
	if !this.Status.Equal(&that1.Status) {
		return fmt.Errorf("Status this(%v) Not Equal that(%v)", this.Status, that1.Status)
	}
	return nil
}
func (this *Event_Update) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_Update)
	if !ok {
		that2, ok := that.(Event_Update)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Status.Equal(&that1.Status) {
		return false
	}
	return true
}
func (this *Event_UpdateOperationStatus) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_UpdateOperationStatus)
	if !ok {
		that2, ok := that.(Event_UpdateOperationStatus)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_UpdateOperationStatus")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_UpdateOperationStatus but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_UpdateOperationStatus but is not nil && this == nil")
	}
	if !this.Status.Equal(&that1.Status) {
		return fmt.Errorf("Status this(%v) Not Equal that(%v)", this.Status, that1.Status)
	}
	return nil
}
func (this *Event_UpdateOperationStatus) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_UpdateOperationStatus)
	if !ok {
		that2, ok := that.(Event_UpdateOperationStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Status.Equal(&that1.Status) {
		return false
	}
	return true
}
func (this *Event_Message) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_Message)
	if !ok {
		that2, ok := that.(Event_Message)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_Message")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_Message but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_Message but is not nil && this == nil")
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	if !this.ExecutorID.Equal(&that1.ExecutorID) {
		return fmt.Errorf("ExecutorID this(%v) Not Equal that(%v)", this.ExecutorID, that1.ExecutorID)
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return fmt.Errorf("Data this(%v) Not Equal that(%v)", this.Data, that1.Data)
	}
	return nil
}
func (this *Event_Message) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_Message)
	if !ok {
		that2, ok := that.(Event_Message)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return false
	}
	if !this.ExecutorID.Equal(&that1.ExecutorID) {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	return true
}
func (this *Event_Failure) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_Failure)
	if !ok {
		that2, ok := that.(Event_Failure)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_Failure")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_Failure but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_Failure but is not nil && this == nil")
	}
	if !this.AgentID.Equal(that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	if !this.ExecutorID.Equal(that1.ExecutorID) {
		return fmt.Errorf("ExecutorID this(%v) Not Equal that(%v)", this.ExecutorID, that1.ExecutorID)
	}
	if this.Status != nil && that1.Status != nil {
		if *this.Status != *that1.Status {
			return fmt.Errorf("Status this(%v) Not Equal that(%v)", *this.Status, *that1.Status)
		}
	} else if this.Status != nil {
		return fmt.Errorf("this.Status == nil && that.Status != nil")
	} else if that1.Status != nil {
		return fmt.Errorf("Status this(%v) Not Equal that(%v)", this.Status, that1.Status)
	}
	return nil
}
func (this *Event_Failure) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_Failure)
	if !ok {
		that2, ok := that.(Event_Failure)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.AgentID.Equal(that1.AgentID) {
		return false
	}
	if !this.ExecutorID.Equal(that1.ExecutorID) {
		return false
	}
	if this.Status != nil && that1.Status != nil {
		if *this.Status != *that1.Status {
			return false
		}
	} else if this.Status != nil {
		return false
	} else if that1.Status != nil {
		return false
	}
	return true
}
func (this *Event_Error) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_Error)
	if !ok {
		that2, ok := that.(Event_Error)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_Error")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_Error but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_Error but is not nil && this == nil")
	}
	if this.Message != that1.Message {
		return fmt.Errorf("Message this(%v) Not Equal that(%v)", this.Message, that1.Message)
	}
	return nil
}
func (this *Event_Error) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_Error)
	if !ok {
		that2, ok := that.(Event_Error)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Message != that1.Message {
		return false
	}
	return true
}
func (this *Response) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response)
	if !ok {
		that2, ok := that.(Response)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.ReconcileOperations.Equal(that1.ReconcileOperations) {
		return fmt.Errorf("ReconcileOperations this(%v) Not Equal that(%v)", this.ReconcileOperations, that1.ReconcileOperations)
	}
	return nil
}
func (this *Response) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response)
	if !ok {
		that2, ok := that.(Response)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.ReconcileOperations.Equal(that1.ReconcileOperations) {
		return false
	}
	return true
}
func (this *Response_ReconcileOperations) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_ReconcileOperations)
	if !ok {
		that2, ok := that.(Response_ReconcileOperations)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_ReconcileOperations")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_ReconcileOperations but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_ReconcileOperations but is not nil && this == nil")
	}
	if len(this.OperationStatuses) != len(that1.OperationStatuses) {
		return fmt.Errorf("OperationStatuses this(%v) Not Equal that(%v)", len(this.OperationStatuses), len(that1.OperationStatuses))
	}
	for i := range this.OperationStatuses {
		if !this.OperationStatuses[i].Equal(&that1.OperationStatuses[i]) {
			return fmt.Errorf("OperationStatuses this[%v](%v) Not Equal that[%v](%v)", i, this.OperationStatuses[i], i, that1.OperationStatuses[i])
		}
	}
	return nil
}
func (this *Response_ReconcileOperations) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_ReconcileOperations)
	if !ok {
		that2, ok := that.(Response_ReconcileOperations)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.OperationStatuses) != len(that1.OperationStatuses) {
		return false
	}
	for i := range this.OperationStatuses {
		if !this.OperationStatuses[i].Equal(&that1.OperationStatuses[i]) {
			return false
		}
	}
	return true
}
func (this *Call) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call)
	if !ok {
		that2, ok := that.(Call)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call but is not nil && this == nil")
	}
	if !this.FrameworkID.Equal(that1.FrameworkID) {
		return fmt.Errorf("FrameworkID this(%v) Not Equal that(%v)", this.FrameworkID, that1.FrameworkID)
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Subscribe.Equal(that1.Subscribe) {
		return fmt.Errorf("Subscribe this(%v) Not Equal that(%v)", this.Subscribe, that1.Subscribe)
	}
	if !this.Accept.Equal(that1.Accept) {
		return fmt.Errorf("Accept this(%v) Not Equal that(%v)", this.Accept, that1.Accept)
	}
	if !this.Decline.Equal(that1.Decline) {
		return fmt.Errorf("Decline this(%v) Not Equal that(%v)", this.Decline, that1.Decline)
	}
	if !this.AcceptInverseOffers.Equal(that1.AcceptInverseOffers) {
		return fmt.Errorf("AcceptInverseOffers this(%v) Not Equal that(%v)", this.AcceptInverseOffers, that1.AcceptInverseOffers)
	}
	if !this.DeclineInverseOffers.Equal(that1.DeclineInverseOffers) {
		return fmt.Errorf("DeclineInverseOffers this(%v) Not Equal that(%v)", this.DeclineInverseOffers, that1.DeclineInverseOffers)
	}
	if !this.Revive.Equal(that1.Revive) {
		return fmt.Errorf("Revive this(%v) Not Equal that(%v)", this.Revive, that1.Revive)
	}
	if !this.Kill.Equal(that1.Kill) {
		return fmt.Errorf("Kill this(%v) Not Equal that(%v)", this.Kill, that1.Kill)
	}
	if !this.Shutdown.Equal(that1.Shutdown) {
		return fmt.Errorf("Shutdown this(%v) Not Equal that(%v)", this.Shutdown, that1.Shutdown)
	}
	if !this.Acknowledge.Equal(that1.Acknowledge) {
		return fmt.Errorf("Acknowledge this(%v) Not Equal that(%v)", this.Acknowledge, that1.Acknowledge)
	}
	if !this.AcknowledgeOperationStatus.Equal(that1.AcknowledgeOperationStatus) {
		return fmt.Errorf("AcknowledgeOperationStatus this(%v) Not Equal that(%v)", this.AcknowledgeOperationStatus, that1.AcknowledgeOperationStatus)
	}
	if !this.Reconcile.Equal(that1.Reconcile) {
		return fmt.Errorf("Reconcile this(%v) Not Equal that(%v)", this.Reconcile, that1.Reconcile)
	}
	if !this.ReconcileOperations.Equal(that1.ReconcileOperations) {
		return fmt.Errorf("ReconcileOperations this(%v) Not Equal that(%v)", this.ReconcileOperations, that1.ReconcileOperations)
	}
	if !this.Message.Equal(that1.Message) {
		return fmt.Errorf("Message this(%v) Not Equal that(%v)", this.Message, that1.Message)
	}
	if !this.Request.Equal(that1.Request) {
		return fmt.Errorf("Request this(%v) Not Equal that(%v)", this.Request, that1.Request)
	}
	if !this.Suppress.Equal(that1.Suppress) {
		return fmt.Errorf("Suppress this(%v) Not Equal that(%v)", this.Suppress, that1.Suppress)
	}
	if !this.UpdateFramework.Equal(that1.UpdateFramework) {
		return fmt.Errorf("UpdateFramework this(%v) Not Equal that(%v)", this.UpdateFramework, that1.UpdateFramework)
	}
	return nil
}
func (this *Call) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call)
	if !ok {
		that2, ok := that.(Call)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.FrameworkID.Equal(that1.FrameworkID) {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.Subscribe.Equal(that1.Subscribe) {
		return false
	}
	if !this.Accept.Equal(that1.Accept) {
		return false
	}
	if !this.Decline.Equal(that1.Decline) {
		return false
	}
	if !this.AcceptInverseOffers.Equal(that1.AcceptInverseOffers) {
		return false
	}
	if !this.DeclineInverseOffers.Equal(that1.DeclineInverseOffers) {
		return false
	}
	if !this.Revive.Equal(that1.Revive) {
		return false
	}
	if !this.Kill.Equal(that1.Kill) {
		return false
	}
	if !this.Shutdown.Equal(that1.Shutdown) {
		return false
	}
	if !this.Acknowledge.Equal(that1.Acknowledge) {
		return false
	}
	if !this.AcknowledgeOperationStatus.Equal(that1.AcknowledgeOperationStatus) {
		return false
	}
	if !this.Reconcile.Equal(that1.Reconcile) {
		return false
	}
	if !this.ReconcileOperations.Equal(that1.ReconcileOperations) {
		return false
	}
	if !this.Message.Equal(that1.Message) {
		return false
	}
	if !this.Request.Equal(that1.Request) {
		return false
	}
	if !this.Suppress.Equal(that1.Suppress) {
		return false
	}
	if !this.UpdateFramework.Equal(that1.UpdateFramework) {
		return false
	}
	return true
}
func (this *Call_Subscribe) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_Subscribe)
	if !ok {
		that2, ok := that.(Call_Subscribe)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_Subscribe")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_Subscribe but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_Subscribe but is not nil && this == nil")
	}
	if !this.FrameworkInfo.Equal(that1.FrameworkInfo) {
		return fmt.Errorf("FrameworkInfo this(%v) Not Equal that(%v)", this.FrameworkInfo, that1.FrameworkInfo)
	}
	if len(this.SuppressedRoles) != len(that1.SuppressedRoles) {
		return fmt.Errorf("SuppressedRoles this(%v) Not Equal that(%v)", len(this.SuppressedRoles), len(that1.SuppressedRoles))
	}
	for i := range this.SuppressedRoles {
		if this.SuppressedRoles[i] != that1.SuppressedRoles[i] {
			return fmt.Errorf("SuppressedRoles this[%v](%v) Not Equal that[%v](%v)", i, this.SuppressedRoles[i], i, that1.SuppressedRoles[i])
		}
	}
	return nil
}
func (this *Call_Subscribe) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_Subscribe)
	if !ok {
		that2, ok := that.(Call_Subscribe)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.FrameworkInfo.Equal(that1.FrameworkInfo) {
		return false
	}
	if len(this.SuppressedRoles) != len(that1.SuppressedRoles) {
		return false
	}
	for i := range this.SuppressedRoles {
		if this.SuppressedRoles[i] != that1.SuppressedRoles[i] {
			return false
		}
	}
	return true
}
func (this *Call_Accept) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_Accept)
	if !ok {
		that2, ok := that.(Call_Accept)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_Accept")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_Accept but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_Accept but is not nil && this == nil")
	}
	if len(this.OfferIDs) != len(that1.OfferIDs) {
		return fmt.Errorf("OfferIDs this(%v) Not Equal that(%v)", len(this.OfferIDs), len(that1.OfferIDs))
	}
	for i := range this.OfferIDs {
		if !this.OfferIDs[i].Equal(&that1.OfferIDs[i]) {
			return fmt.Errorf("OfferIDs this[%v](%v) Not Equal that[%v](%v)", i, this.OfferIDs[i], i, that1.OfferIDs[i])
		}
	}
	if len(this.Operations) != len(that1.Operations) {
		return fmt.Errorf("Operations this(%v) Not Equal that(%v)", len(this.Operations), len(that1.Operations))
	}
	for i := range this.Operations {
		if !this.Operations[i].Equal(&that1.Operations[i]) {
			return fmt.Errorf("Operations this[%v](%v) Not Equal that[%v](%v)", i, this.Operations[i], i, that1.Operations[i])
		}
	}
	if !this.Filters.Equal(that1.Filters) {
		return fmt.Errorf("Filters this(%v) Not Equal that(%v)", this.Filters, that1.Filters)
	}
	return nil
}
func (this *Call_Accept) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_Accept)
	if !ok {
		that2, ok := that.(Call_Accept)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.OfferIDs) != len(that1.OfferIDs) {
		return false
	}
	for i := range this.OfferIDs {
		if !this.OfferIDs[i].Equal(&that1.OfferIDs[i]) {
			return false
		}
	}
	if len(this.Operations) != len(that1.Operations) {
		return false
	}
	for i := range this.Operations {
		if !this.Operations[i].Equal(&that1.Operations[i]) {
			return false
		}
	}
	if !this.Filters.Equal(that1.Filters) {
		return false
	}
	return true
}
func (this *Call_Decline) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_Decline)
	if !ok {
		that2, ok := that.(Call_Decline)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_Decline")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_Decline but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_Decline but is not nil && this == nil")
	}
	if len(this.OfferIDs) != len(that1.OfferIDs) {
		return fmt.Errorf("OfferIDs this(%v) Not Equal that(%v)", len(this.OfferIDs), len(that1.OfferIDs))
	}
	for i := range this.OfferIDs {
		if !this.OfferIDs[i].Equal(&that1.OfferIDs[i]) {
			return fmt.Errorf("OfferIDs this[%v](%v) Not Equal that[%v](%v)", i, this.OfferIDs[i], i, that1.OfferIDs[i])
		}
	}
	if !this.Filters.Equal(that1.Filters) {
		return fmt.Errorf("Filters this(%v) Not Equal that(%v)", this.Filters, that1.Filters)
	}
	return nil
}
func (this *Call_Decline) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_Decline)
	if !ok {
		that2, ok := that.(Call_Decline)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.OfferIDs) != len(that1.OfferIDs) {
		return false
	}
	for i := range this.OfferIDs {
		if !this.OfferIDs[i].Equal(&that1.OfferIDs[i]) {
			return false
		}
	}
	if !this.Filters.Equal(that1.Filters) {
		return false
	}
	return true
}
func (this *Call_AcceptInverseOffers) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_AcceptInverseOffers)
	if !ok {
		that2, ok := that.(Call_AcceptInverseOffers)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_AcceptInverseOffers")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_AcceptInverseOffers but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_AcceptInverseOffers but is not nil && this == nil")
	}
	if len(this.InverseOfferIDs) != len(that1.InverseOfferIDs) {
		return fmt.Errorf("InverseOfferIDs this(%v) Not Equal that(%v)", len(this.InverseOfferIDs), len(that1.InverseOfferIDs))
	}
	for i := range this.InverseOfferIDs {
		if !this.InverseOfferIDs[i].Equal(&that1.InverseOfferIDs[i]) {
			return fmt.Errorf("InverseOfferIDs this[%v](%v) Not Equal that[%v](%v)", i, this.InverseOfferIDs[i], i, that1.InverseOfferIDs[i])
		}
	}
	if !this.Filters.Equal(that1.Filters) {
		return fmt.Errorf("Filters this(%v) Not Equal that(%v)", this.Filters, that1.Filters)
	}
	return nil
}
func (this *Call_AcceptInverseOffers) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_AcceptInverseOffers)
	if !ok {
		that2, ok := that.(Call_AcceptInverseOffers)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.InverseOfferIDs) != len(that1.InverseOfferIDs) {
		return false
	}
	for i := range this.InverseOfferIDs {
		if !this.InverseOfferIDs[i].Equal(&that1.InverseOfferIDs[i]) {
			return false
		}
	}
	if !this.Filters.Equal(that1.Filters) {
		return false
	}
	return true
}
func (this *Call_DeclineInverseOffers) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_DeclineInverseOffers)
	if !ok {
		that2, ok := that.(Call_DeclineInverseOffers)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_DeclineInverseOffers")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_DeclineInverseOffers but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_DeclineInverseOffers but is not nil && this == nil")
	}
	if len(this.InverseOfferIDs) != len(that1.InverseOfferIDs) {
		return fmt.Errorf("InverseOfferIDs this(%v) Not Equal that(%v)", len(this.InverseOfferIDs), len(that1.InverseOfferIDs))
	}
	for i := range this.InverseOfferIDs {
		if !this.InverseOfferIDs[i].Equal(&that1.InverseOfferIDs[i]) {
			return fmt.Errorf("InverseOfferIDs this[%v](%v) Not Equal that[%v](%v)", i, this.InverseOfferIDs[i], i, that1.InverseOfferIDs[i])
		}
	}
	if !this.Filters.Equal(that1.Filters) {
		return fmt.Errorf("Filters this(%v) Not Equal that(%v)", this.Filters, that1.Filters)
	}
	return nil
}
func (this *Call_DeclineInverseOffers) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_DeclineInverseOffers)
	if !ok {
		that2, ok := that.(Call_DeclineInverseOffers)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.InverseOfferIDs) != len(that1.InverseOfferIDs) {
		return false
	}
	for i := range this.InverseOfferIDs {
		if !this.InverseOfferIDs[i].Equal(&that1.InverseOfferIDs[i]) {
			return false
		}
	}
	if !this.Filters.Equal(that1.Filters) {
		return false
	}
	return true
}
func (this *Call_Revive) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_Revive)
	if !ok {
		that2, ok := that.(Call_Revive)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_Revive")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_Revive but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_Revive but is not nil && this == nil")
	}
	if len(this.Roles) != len(that1.Roles) {
		return fmt.Errorf("Roles this(%v) Not Equal that(%v)", len(this.Roles), len(that1.Roles))
	}
	for i := range this.Roles {
		if this.Roles[i] != that1.Roles[i] {
			return fmt.Errorf("Roles this[%v](%v) Not Equal that[%v](%v)", i, this.Roles[i], i, that1.Roles[i])
		}
	}
	return nil
}
func (this *Call_Revive) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_Revive)
	if !ok {
		that2, ok := that.(Call_Revive)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Roles) != len(that1.Roles) {
		return false
	}
	for i := range this.Roles {
		if this.Roles[i] != that1.Roles[i] {
			return false
		}
	}
	return true
}
func (this *Call_Kill) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_Kill)
	if !ok {
		that2, ok := that.(Call_Kill)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_Kill")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_Kill but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_Kill but is not nil && this == nil")
	}
	if !this.TaskID.Equal(&that1.TaskID) {
		return fmt.Errorf("TaskID this(%v) Not Equal that(%v)", this.TaskID, that1.TaskID)
	}
	if !this.AgentID.Equal(that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	if !this.KillPolicy.Equal(that1.KillPolicy) {
		return fmt.Errorf("KillPolicy this(%v) Not Equal that(%v)", this.KillPolicy, that1.KillPolicy)
	}
	return nil
}
func (this *Call_Kill) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_Kill)
	if !ok {
		that2, ok := that.(Call_Kill)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.TaskID.Equal(&that1.TaskID) {
		return false
	}
	if !this.AgentID.Equal(that1.AgentID) {
		return false
	}
	if !this.KillPolicy.Equal(that1.KillPolicy) {
		return false
	}
	return true
}
func (this *Call_Shutdown) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_Shutdown)
	if !ok {
		that2, ok := that.(Call_Shutdown)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_Shutdown")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_Shutdown but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_Shutdown but is not nil && this == nil")
	}
	if !this.ExecutorID.Equal(&that1.ExecutorID) {
		return fmt.Errorf("ExecutorID this(%v) Not Equal that(%v)", this.ExecutorID, that1.ExecutorID)
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	return nil
}
func (this *Call_Shutdown) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_Shutdown)
	if !ok {
		that2, ok := that.(Call_Shutdown)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ExecutorID.Equal(&that1.ExecutorID) {
		return false
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return false
	}
	return true
}
func (this *Call_Acknowledge) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_Acknowledge)
	if !ok {
		that2, ok := that.(Call_Acknowledge)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_Acknowledge")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_Acknowledge but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_Acknowledge but is not nil && this == nil")
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	if !this.TaskID.Equal(&that1.TaskID) {
		return fmt.Errorf("TaskID this(%v) Not Equal that(%v)", this.TaskID, that1.TaskID)
	}
	if !bytes.Equal(this.UUID, that1.UUID) {
		return fmt.Errorf("UUID this(%v) Not Equal that(%v)", this.UUID, that1.UUID)
	}
	return nil
}
func (this *Call_Acknowledge) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_Acknowledge)
	if !ok {
		that2, ok := that.(Call_Acknowledge)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return false
	}
	if !this.TaskID.Equal(&that1.TaskID) {
		return false
	}
	if !bytes.Equal(this.UUID, that1.UUID) {
		return false
	}
	return true
}
func (this *Call_AcknowledgeOperationStatus) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_AcknowledgeOperationStatus)
	if !ok {
		that2, ok := that.(Call_AcknowledgeOperationStatus)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_AcknowledgeOperationStatus")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_AcknowledgeOperationStatus but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_AcknowledgeOperationStatus but is not nil && this == nil")
	}
	if !this.AgentID.Equal(that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	if !this.ResourceProviderID.Equal(that1.ResourceProviderID) {
		return fmt.Errorf("ResourceProviderID this(%v) Not Equal that(%v)", this.ResourceProviderID, that1.ResourceProviderID)
	}
	if !bytes.Equal(this.UUID, that1.UUID) {
		return fmt.Errorf("UUID this(%v) Not Equal that(%v)", this.UUID, that1.UUID)
	}
	if !this.OperationID.Equal(&that1.OperationID) {
		return fmt.Errorf("OperationID this(%v) Not Equal that(%v)", this.OperationID, that1.OperationID)
	}
	return nil
}
func (this *Call_AcknowledgeOperationStatus) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_AcknowledgeOperationStatus)
	if !ok {
		that2, ok := that.(Call_AcknowledgeOperationStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.AgentID.Equal(that1.AgentID) {
		return false
	}
	if !this.ResourceProviderID.Equal(that1.ResourceProviderID) {
		return false
	}
	if !bytes.Equal(this.UUID, that1.UUID) {
		return false
	}
	if !this.OperationID.Equal(&that1.OperationID) {
		return false
	}
	return true
}
func (this *Call_Reconcile) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_Reconcile)
	if !ok {
		that2, ok := that.(Call_Reconcile)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_Reconcile")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_Reconcile but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_Reconcile but is not nil && this == nil")
	}
	if len(this.Tasks) != len(that1.Tasks) {
		return fmt.Errorf("Tasks this(%v) Not Equal that(%v)", len(this.Tasks), len(that1.Tasks))
	}
	for i := range this.Tasks {
		if !this.Tasks[i].Equal(&that1.Tasks[i]) {
			return fmt.Errorf("Tasks this[%v](%v) Not Equal that[%v](%v)", i, this.Tasks[i], i, that1.Tasks[i])
		}
	}
	return nil
}
func (this *Call_Reconcile) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_Reconcile)
	if !ok {
		that2, ok := that.(Call_Reconcile)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Tasks) != len(that1.Tasks) {
		return false
	}
	for i := range this.Tasks {
		if !this.Tasks[i].Equal(&that1.Tasks[i]) {
			return false
		}
	}
	return true
}
func (this *Call_Reconcile_Task) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_Reconcile_Task)
	if !ok {
		that2, ok := that.(Call_Reconcile_Task)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_Reconcile_Task")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_Reconcile_Task but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_Reconcile_Task but is not nil && this == nil")
	}
	if !this.TaskID.Equal(&that1.TaskID) {
		return fmt.Errorf("TaskID this(%v) Not Equal that(%v)", this.TaskID, that1.TaskID)
	}
	if !this.AgentID.Equal(that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	return nil
}
func (this *Call_Reconcile_Task) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_Reconcile_Task)
	if !ok {
		that2, ok := that.(Call_Reconcile_Task)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.TaskID.Equal(&that1.TaskID) {
		return false
	}
	if !this.AgentID.Equal(that1.AgentID) {
		return false
	}
	return true
}
func (this *Call_ReconcileOperations) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_ReconcileOperations)
	if !ok {
		that2, ok := that.(Call_ReconcileOperations)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_ReconcileOperations")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_ReconcileOperations but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_ReconcileOperations but is not nil && this == nil")
	}
	if len(this.Operations) != len(that1.Operations) {
		return fmt.Errorf("Operations this(%v) Not Equal that(%v)", len(this.Operations), len(that1.Operations))
	}
	for i := range this.Operations {
		if !this.Operations[i].Equal(&that1.Operations[i]) {
			return fmt.Errorf("Operations this[%v](%v) Not Equal that[%v](%v)", i, this.Operations[i], i, that1.Operations[i])
		}
	}
	return nil
}
func (this *Call_ReconcileOperations) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_ReconcileOperations)
	if !ok {
		that2, ok := that.(Call_ReconcileOperations)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Operations) != len(that1.Operations) {
		return false
	}
	for i := range this.Operations {
		if !this.Operations[i].Equal(&that1.Operations[i]) {
			return false
		}
	}
	return true
}
func (this *Call_ReconcileOperations_Operation) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_ReconcileOperations_Operation)
	if !ok {
		that2, ok := that.(Call_ReconcileOperations_Operation)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_ReconcileOperations_Operation")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_ReconcileOperations_Operation but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_ReconcileOperations_Operation but is not nil && this == nil")
	}
	if !this.OperationID.Equal(&that1.OperationID) {
		return fmt.Errorf("OperationID this(%v) Not Equal that(%v)", this.OperationID, that1.OperationID)
	}
	if !this.AgentID.Equal(that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	if !this.ResourceProviderID.Equal(that1.ResourceProviderID) {
		return fmt.Errorf("ResourceProviderID this(%v) Not Equal that(%v)", this.ResourceProviderID, that1.ResourceProviderID)
	}
	return nil
}
func (this *Call_ReconcileOperations_Operation) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_ReconcileOperations_Operation)
	if !ok {
		that2, ok := that.(Call_ReconcileOperations_Operation)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.OperationID.Equal(&that1.OperationID) {
		return false
	}
	if !this.AgentID.Equal(that1.AgentID) {
		return false
	}
	if !this.ResourceProviderID.Equal(that1.ResourceProviderID) {
		return false
	}
	return true
}
func (this *Call_Message) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_Message)
	if !ok {
		that2, ok := that.(Call_Message)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_Message")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_Message but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_Message but is not nil && this == nil")
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	if !this.ExecutorID.Equal(&that1.ExecutorID) {
		return fmt.Errorf("ExecutorID this(%v) Not Equal that(%v)", this.ExecutorID, that1.ExecutorID)
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return fmt.Errorf("Data this(%v) Not Equal that(%v)", this.Data, that1.Data)
	}
	return nil
}
func (this *Call_Message) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_Message)
	if !ok {
		that2, ok := that.(Call_Message)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return false
	}
	if !this.ExecutorID.Equal(&that1.ExecutorID) {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	return true
}
func (this *Call_Request) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_Request)
	if !ok {
		that2, ok := that.(Call_Request)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_Request")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_Request but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_Request but is not nil && this == nil")
	}
	if len(this.Requests) != len(that1.Requests) {
		return fmt.Errorf("Requests this(%v) Not Equal that(%v)", len(this.Requests), len(that1.Requests))
	}
	for i := range this.Requests {
		if !this.Requests[i].Equal(&that1.Requests[i]) {
			return fmt.Errorf("Requests this[%v](%v) Not Equal that[%v](%v)", i, this.Requests[i], i, that1.Requests[i])
		}
	}
	return nil
}
func (this *Call_Request) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_Request)
	if !ok {
		that2, ok := that.(Call_Request)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Requests) != len(that1.Requests) {
		return false
	}
	for i := range this.Requests {
		if !this.Requests[i].Equal(&that1.Requests[i]) {
			return false
		}
	}
	return true
}
func (this *Call_Suppress) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_Suppress)
	if !ok {
		that2, ok := that.(Call_Suppress)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_Suppress")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_Suppress but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_Suppress but is not nil && this == nil")
	}
	if len(this.Roles) != len(that1.Roles) {
		return fmt.Errorf("Roles this(%v) Not Equal that(%v)", len(this.Roles), len(that1.Roles))
	}
	for i := range this.Roles {
		if this.Roles[i] != that1.Roles[i] {
			return fmt.Errorf("Roles this[%v](%v) Not Equal that[%v](%v)", i, this.Roles[i], i, that1.Roles[i])
		}
	}
	return nil
}
func (this *Call_Suppress) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_Suppress)
	if !ok {
		that2, ok := that.(Call_Suppress)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Roles) != len(that1.Roles) {
		return false
	}
	for i := range this.Roles {
		if this.Roles[i] != that1.Roles[i] {
			return false
		}
	}
	return true
}
func (this *Call_UpdateFramework) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_UpdateFramework)
	if !ok {
		that2, ok := that.(Call_UpdateFramework)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_UpdateFramework")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_UpdateFramework but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_UpdateFramework but is not nil && this == nil")
	}
	if !this.FrameworkInfo.Equal(&that1.FrameworkInfo) {
		return fmt.Errorf("FrameworkInfo this(%v) Not Equal that(%v)", this.FrameworkInfo, that1.FrameworkInfo)
	}
	if len(this.SuppressedRoles) != len(that1.SuppressedRoles) {
		return fmt.Errorf("SuppressedRoles this(%v) Not Equal that(%v)", len(this.SuppressedRoles), len(that1.SuppressedRoles))
	}
	for i := range this.SuppressedRoles {
		if this.SuppressedRoles[i] != that1.SuppressedRoles[i] {
			return fmt.Errorf("SuppressedRoles this[%v](%v) Not Equal that[%v](%v)", i, this.SuppressedRoles[i], i, that1.SuppressedRoles[i])
		}
	}
	return nil
}
func (this *Call_UpdateFramework) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_UpdateFramework)
	if !ok {
		that2, ok := that.(Call_UpdateFramework)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.FrameworkInfo.Equal(&that1.FrameworkInfo) {
		return false
	}
	if len(this.SuppressedRoles) != len(that1.SuppressedRoles) {
		return false
	}
	for i := range this.SuppressedRoles {
		if this.SuppressedRoles[i] != that1.SuppressedRoles[i] {
			return false
		}
	}
	return true
}
func (this *Event) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 15)
	s = append(s, "&scheduler.Event{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.Subscribed != nil {
		s = append(s, "Subscribed: "+fmt.Sprintf("%#v", this.Subscribed)+",\n")
	}
	if this.Offers != nil {
		s = append(s, "Offers: "+fmt.Sprintf("%#v", this.Offers)+",\n")
	}
	if this.InverseOffers != nil {
		s = append(s, "InverseOffers: "+fmt.Sprintf("%#v", this.InverseOffers)+",\n")
	}
	if this.Rescind != nil {
		s = append(s, "Rescind: "+fmt.Sprintf("%#v", this.Rescind)+",\n")
	}
	if this.RescindInverseOffer != nil {
		s = append(s, "RescindInverseOffer: "+fmt.Sprintf("%#v", this.RescindInverseOffer)+",\n")
	}
	if this.Update != nil {
		s = append(s, "Update: "+fmt.Sprintf("%#v", this.Update)+",\n")
	}
	if this.UpdateOperationStatus != nil {
		s = append(s, "UpdateOperationStatus: "+fmt.Sprintf("%#v", this.UpdateOperationStatus)+",\n")
	}
	if this.Message != nil {
		s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	}
	if this.Failure != nil {
		s = append(s, "Failure: "+fmt.Sprintf("%#v", this.Failure)+",\n")
	}
	if this.Error != nil {
		s = append(s, "Error: "+fmt.Sprintf("%#v", this.Error)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_Subscribed) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&scheduler.Event_Subscribed{")
	if this.FrameworkID != nil {
		s = append(s, "FrameworkID: "+fmt.Sprintf("%#v", this.FrameworkID)+",\n")
	}
	if this.HeartbeatIntervalSeconds != nil {
		s = append(s, "HeartbeatIntervalSeconds: "+valueToGoStringScheduler(this.HeartbeatIntervalSeconds, "float64")+",\n")
	}
	if this.MasterInfo != nil {
		s = append(s, "MasterInfo: "+fmt.Sprintf("%#v", this.MasterInfo)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_Offers) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&scheduler.Event_Offers{")
	if this.Offers != nil {
		s = append(s, "Offers: "+fmt.Sprintf("%#v", this.Offers)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_InverseOffers) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&scheduler.Event_InverseOffers{")
	if this.InverseOffers != nil {
		s = append(s, "InverseOffers: "+fmt.Sprintf("%#v", this.InverseOffers)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_Rescind) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&scheduler.Event_Rescind{")
	s = append(s, "OfferID: "+strings.Replace(this.OfferID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_RescindInverseOffer) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&scheduler.Event_RescindInverseOffer{")
	s = append(s, "InverseOfferID: "+strings.Replace(this.InverseOfferID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_Update) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&scheduler.Event_Update{")
	s = append(s, "Status: "+strings.Replace(this.Status.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_UpdateOperationStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&scheduler.Event_UpdateOperationStatus{")
	s = append(s, "Status: "+strings.Replace(this.Status.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_Message) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&scheduler.Event_Message{")
	s = append(s, "AgentID: "+strings.Replace(this.AgentID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "ExecutorID: "+strings.Replace(this.ExecutorID.GoString(), `&`, ``, 1)+",\n")
	if this.Data != nil {
		s = append(s, "Data: "+valueToGoStringScheduler(this.Data, "byte")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_Failure) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&scheduler.Event_Failure{")
	if this.AgentID != nil {
		s = append(s, "AgentID: "+fmt.Sprintf("%#v", this.AgentID)+",\n")
	}
	if this.ExecutorID != nil {
		s = append(s, "ExecutorID: "+fmt.Sprintf("%#v", this.ExecutorID)+",\n")
	}
	if this.Status != nil {
		s = append(s, "Status: "+valueToGoStringScheduler(this.Status, "int32")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_Error) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&scheduler.Event_Error{")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&scheduler.Response{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.ReconcileOperations != nil {
		s = append(s, "ReconcileOperations: "+fmt.Sprintf("%#v", this.ReconcileOperations)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_ReconcileOperations) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&scheduler.Response_ReconcileOperations{")
	if this.OperationStatuses != nil {
		s = append(s, "OperationStatuses: "+fmt.Sprintf("%#v", this.OperationStatuses)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 22)
	s = append(s, "&scheduler.Call{")
	if this.FrameworkID != nil {
		s = append(s, "FrameworkID: "+fmt.Sprintf("%#v", this.FrameworkID)+",\n")
	}
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.Subscribe != nil {
		s = append(s, "Subscribe: "+fmt.Sprintf("%#v", this.Subscribe)+",\n")
	}
	if this.Accept != nil {
		s = append(s, "Accept: "+fmt.Sprintf("%#v", this.Accept)+",\n")
	}
	if this.Decline != nil {
		s = append(s, "Decline: "+fmt.Sprintf("%#v", this.Decline)+",\n")
	}
	if this.AcceptInverseOffers != nil {
		s = append(s, "AcceptInverseOffers: "+fmt.Sprintf("%#v", this.AcceptInverseOffers)+",\n")
	}
	if this.DeclineInverseOffers != nil {
		s = append(s, "DeclineInverseOffers: "+fmt.Sprintf("%#v", this.DeclineInverseOffers)+",\n")
	}
	if this.Revive != nil {
		s = append(s, "Revive: "+fmt.Sprintf("%#v", this.Revive)+",\n")
	}
	if this.Kill != nil {
		s = append(s, "Kill: "+fmt.Sprintf("%#v", this.Kill)+",\n")
	}
	if this.Shutdown != nil {
		s = append(s, "Shutdown: "+fmt.Sprintf("%#v", this.Shutdown)+",\n")
	}
	if this.Acknowledge != nil {
		s = append(s, "Acknowledge: "+fmt.Sprintf("%#v", this.Acknowledge)+",\n")
	}
	if this.AcknowledgeOperationStatus != nil {
		s = append(s, "AcknowledgeOperationStatus: "+fmt.Sprintf("%#v", this.AcknowledgeOperationStatus)+",\n")
	}
	if this.Reconcile != nil {
		s = append(s, "Reconcile: "+fmt.Sprintf("%#v", this.Reconcile)+",\n")
	}
	if this.ReconcileOperations != nil {
		s = append(s, "ReconcileOperations: "+fmt.Sprintf("%#v", this.ReconcileOperations)+",\n")
	}
	if this.Message != nil {
		s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	}
	if this.Request != nil {
		s = append(s, "Request: "+fmt.Sprintf("%#v", this.Request)+",\n")
	}
	if this.Suppress != nil {
		s = append(s, "Suppress: "+fmt.Sprintf("%#v", this.Suppress)+",\n")
	}
	if this.UpdateFramework != nil {
		s = append(s, "UpdateFramework: "+fmt.Sprintf("%#v", this.UpdateFramework)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_Subscribe) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&scheduler.Call_Subscribe{")
	if this.FrameworkInfo != nil {
		s = append(s, "FrameworkInfo: "+fmt.Sprintf("%#v", this.FrameworkInfo)+",\n")
	}
	if this.SuppressedRoles != nil {
		s = append(s, "SuppressedRoles: "+fmt.Sprintf("%#v", this.SuppressedRoles)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_Accept) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&scheduler.Call_Accept{")
	if this.OfferIDs != nil {
		s = append(s, "OfferIDs: "+fmt.Sprintf("%#v", this.OfferIDs)+",\n")
	}
	if this.Operations != nil {
		s = append(s, "Operations: "+fmt.Sprintf("%#v", this.Operations)+",\n")
	}
	if this.Filters != nil {
		s = append(s, "Filters: "+fmt.Sprintf("%#v", this.Filters)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_Decline) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&scheduler.Call_Decline{")
	if this.OfferIDs != nil {
		s = append(s, "OfferIDs: "+fmt.Sprintf("%#v", this.OfferIDs)+",\n")
	}
	if this.Filters != nil {
		s = append(s, "Filters: "+fmt.Sprintf("%#v", this.Filters)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_AcceptInverseOffers) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&scheduler.Call_AcceptInverseOffers{")
	if this.InverseOfferIDs != nil {
		s = append(s, "InverseOfferIDs: "+fmt.Sprintf("%#v", this.InverseOfferIDs)+",\n")
	}
	if this.Filters != nil {
		s = append(s, "Filters: "+fmt.Sprintf("%#v", this.Filters)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_DeclineInverseOffers) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&scheduler.Call_DeclineInverseOffers{")
	if this.InverseOfferIDs != nil {
		s = append(s, "InverseOfferIDs: "+fmt.Sprintf("%#v", this.InverseOfferIDs)+",\n")
	}
	if this.Filters != nil {
		s = append(s, "Filters: "+fmt.Sprintf("%#v", this.Filters)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_Revive) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&scheduler.Call_Revive{")
	if this.Roles != nil {
		s = append(s, "Roles: "+fmt.Sprintf("%#v", this.Roles)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_Kill) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&scheduler.Call_Kill{")
	s = append(s, "TaskID: "+strings.Replace(this.TaskID.GoString(), `&`, ``, 1)+",\n")
	if this.AgentID != nil {
		s = append(s, "AgentID: "+fmt.Sprintf("%#v", this.AgentID)+",\n")
	}
	if this.KillPolicy != nil {
		s = append(s, "KillPolicy: "+fmt.Sprintf("%#v", this.KillPolicy)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_Shutdown) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&scheduler.Call_Shutdown{")
	s = append(s, "ExecutorID: "+strings.Replace(this.ExecutorID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "AgentID: "+strings.Replace(this.AgentID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_Acknowledge) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&scheduler.Call_Acknowledge{")
	s = append(s, "AgentID: "+strings.Replace(this.AgentID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "TaskID: "+strings.Replace(this.TaskID.GoString(), `&`, ``, 1)+",\n")
	if this.UUID != nil {
		s = append(s, "UUID: "+valueToGoStringScheduler(this.UUID, "byte")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_AcknowledgeOperationStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&scheduler.Call_AcknowledgeOperationStatus{")
	if this.AgentID != nil {
		s = append(s, "AgentID: "+fmt.Sprintf("%#v", this.AgentID)+",\n")
	}
	if this.ResourceProviderID != nil {
		s = append(s, "ResourceProviderID: "+fmt.Sprintf("%#v", this.ResourceProviderID)+",\n")
	}
	if this.UUID != nil {
		s = append(s, "UUID: "+valueToGoStringScheduler(this.UUID, "byte")+",\n")
	}
	s = append(s, "OperationID: "+strings.Replace(this.OperationID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_Reconcile) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&scheduler.Call_Reconcile{")
	if this.Tasks != nil {
		s = append(s, "Tasks: "+fmt.Sprintf("%#v", this.Tasks)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_Reconcile_Task) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&scheduler.Call_Reconcile_Task{")
	s = append(s, "TaskID: "+strings.Replace(this.TaskID.GoString(), `&`, ``, 1)+",\n")
	if this.AgentID != nil {
		s = append(s, "AgentID: "+fmt.Sprintf("%#v", this.AgentID)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_ReconcileOperations) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&scheduler.Call_ReconcileOperations{")
	if this.Operations != nil {
		s = append(s, "Operations: "+fmt.Sprintf("%#v", this.Operations)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_ReconcileOperations_Operation) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&scheduler.Call_ReconcileOperations_Operation{")
	s = append(s, "OperationID: "+strings.Replace(this.OperationID.GoString(), `&`, ``, 1)+",\n")
	if this.AgentID != nil {
		s = append(s, "AgentID: "+fmt.Sprintf("%#v", this.AgentID)+",\n")
	}
	if this.ResourceProviderID != nil {
		s = append(s, "ResourceProviderID: "+fmt.Sprintf("%#v", this.ResourceProviderID)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_Message) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&scheduler.Call_Message{")
	s = append(s, "AgentID: "+strings.Replace(this.AgentID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "ExecutorID: "+strings.Replace(this.ExecutorID.GoString(), `&`, ``, 1)+",\n")
	if this.Data != nil {
		s = append(s, "Data: "+valueToGoStringScheduler(this.Data, "byte")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_Request) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&scheduler.Call_Request{")
	if this.Requests != nil {
		s = append(s, "Requests: "+fmt.Sprintf("%#v", this.Requests)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_Suppress) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&scheduler.Call_Suppress{")
	if this.Roles != nil {
		s = append(s, "Roles: "+fmt.Sprintf("%#v", this.Roles)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_UpdateFramework) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&scheduler.Call_UpdateFramework{")
	s = append(s, "FrameworkInfo: "+strings.Replace(this.FrameworkInfo.GoString(), `&`, ``, 1)+",\n")
	if this.SuppressedRoles != nil {
		s = append(s, "SuppressedRoles: "+fmt.Sprintf("%#v", this.SuppressedRoles)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringScheduler(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *Event) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintScheduler(dAtA, i, uint64(m.Type))
	if m.Subscribed != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Subscribed.Size()))
		n1, err := m.Subscribed.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Offers != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Offers.Size()))
		n2, err := m.Offers.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.Rescind != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Rescind.Size()))
		n3, err := m.Rescind.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.Update != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Update.Size()))
		n4, err := m.Update.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.Message != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Message.Size()))
		n5, err := m.Message.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.Failure != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Failure.Size()))
		n6, err := m.Failure.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.Error != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Error.Size()))
		n7, err := m.Error.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.InverseOffers != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.InverseOffers.Size()))
		n8, err := m.InverseOffers.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.RescindInverseOffer != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.RescindInverseOffer.Size()))
		n9, err := m.RescindInverseOffer.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.UpdateOperationStatus != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.UpdateOperationStatus.Size()))
		n10, err := m.UpdateOperationStatus.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}

func (m *Event_Subscribed) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_Subscribed) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.FrameworkID == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("framework_id")
	} else {
		dAtA[i] = 0xa
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.FrameworkID.Size()))
		n11, err := m.FrameworkID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.HeartbeatIntervalSeconds != nil {
		dAtA[i] = 0x11
		i++
		i = encodeFixed64Scheduler(dAtA, i, uint64(math.Float64bits(float64(*m.HeartbeatIntervalSeconds))))
	}
	if m.MasterInfo != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.MasterInfo.Size()))
		n12, err := m.MasterInfo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	return i, nil
}

func (m *Event_Offers) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_Offers) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Offers) > 0 {
		for _, msg := range m.Offers {
			dAtA[i] = 0xa
			i++
			i = encodeVarintScheduler(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Event_InverseOffers) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_InverseOffers) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.InverseOffers) > 0 {
		for _, msg := range m.InverseOffers {
			dAtA[i] = 0xa
			i++
			i = encodeVarintScheduler(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Event_Rescind) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_Rescind) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintScheduler(dAtA, i, uint64(m.OfferID.Size()))
	n13, err := m.OfferID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n13
	return i, nil
}

func (m *Event_RescindInverseOffer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_RescindInverseOffer) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintScheduler(dAtA, i, uint64(m.InverseOfferID.Size()))
	n14, err := m.InverseOfferID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n14
	return i, nil
}

func (m *Event_Update) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_Update) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintScheduler(dAtA, i, uint64(m.Status.Size()))
	n15, err := m.Status.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n15
	return i, nil
}

func (m *Event_UpdateOperationStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_UpdateOperationStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintScheduler(dAtA, i, uint64(m.Status.Size()))
	n16, err := m.Status.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n16
	return i, nil
}

func (m *Event_Message) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_Message) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintScheduler(dAtA, i, uint64(m.AgentID.Size()))
	n17, err := m.AgentID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n17
	dAtA[i] = 0x12
	i++
	i = encodeVarintScheduler(dAtA, i, uint64(m.ExecutorID.Size()))
	n18, err := m.ExecutorID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n18
	if m.Data == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("data")
	} else {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *Event_Failure) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_Failure) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.AgentID != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.AgentID.Size()))
		n19, err := m.AgentID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if m.ExecutorID != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.ExecutorID.Size()))
		n20, err := m.ExecutorID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if m.Status != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(*m.Status))
	}
	return i, nil
}

func (m *Event_Error) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_Error) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintScheduler(dAtA, i, uint64(len(m.Message)))
	i += copy(dAtA[i:], m.Message)
	return i, nil
}

func (m *Response) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintScheduler(dAtA, i, uint64(m.Type))
	if m.ReconcileOperations != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.ReconcileOperations.Size()))
		n21, err := m.ReconcileOperations.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	return i, nil
}

func (m *Response_ReconcileOperations) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_ReconcileOperations) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.OperationStatuses) > 0 {
		for _, msg := range m.OperationStatuses {
			dAtA[i] = 0xa
			i++
			i = encodeVarintScheduler(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Call) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.FrameworkID != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.FrameworkID.Size()))
		n22, err := m.FrameworkID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	dAtA[i] = 0x10
	i++
	i = encodeVarintScheduler(dAtA, i, uint64(m.Type))
	if m.Subscribe != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Subscribe.Size()))
		n23, err := m.Subscribe.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	if m.Accept != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Accept.Size()))
		n24, err := m.Accept.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	if m.Decline != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Decline.Size()))
		n25, err := m.Decline.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	if m.Kill != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Kill.Size()))
		n26, err := m.Kill.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	if m.Shutdown != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Shutdown.Size()))
		n27, err := m.Shutdown.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n27
	}
	if m.Acknowledge != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Acknowledge.Size()))
		n28, err := m.Acknowledge.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	if m.Reconcile != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Reconcile.Size()))
		n29, err := m.Reconcile.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n29
	}
	if m.Message != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Message.Size()))
		n30, err := m.Message.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n30
	}
	if m.Request != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Request.Size()))
		n31, err := m.Request.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n31
	}
	if m.AcceptInverseOffers != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.AcceptInverseOffers.Size()))
		n32, err := m.AcceptInverseOffers.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n32
	}
	if m.DeclineInverseOffers != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.DeclineInverseOffers.Size()))
		n33, err := m.DeclineInverseOffers.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n33
	}
	if m.Revive != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Revive.Size()))
		n34, err := m.Revive.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n34
	}
	if m.Suppress != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Suppress.Size()))
		n35, err := m.Suppress.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n35
	}
	if m.AcknowledgeOperationStatus != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.AcknowledgeOperationStatus.Size()))
		n36, err := m.AcknowledgeOperationStatus.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n36
	}
	if m.ReconcileOperations != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.ReconcileOperations.Size()))
		n37, err := m.ReconcileOperations.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n37
	}
	if m.UpdateFramework != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.UpdateFramework.Size()))
		n38, err := m.UpdateFramework.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n38
	}
	return i, nil
}

func (m *Call_Subscribe) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_Subscribe) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.FrameworkInfo == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("framework_info")
	} else {
		dAtA[i] = 0xa
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.FrameworkInfo.Size()))
		n39, err := m.FrameworkInfo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n39
	}
	if len(m.SuppressedRoles) > 0 {
		for _, s := range m.SuppressedRoles {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *Call_Accept) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_Accept) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.OfferIDs) > 0 {
		for _, msg := range m.OfferIDs {
			dAtA[i] = 0xa
			i++
			i = encodeVarintScheduler(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Operations) > 0 {
		for _, msg := range m.Operations {
			dAtA[i] = 0x12
			i++
			i = encodeVarintScheduler(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Filters != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Filters.Size()))
		n40, err := m.Filters.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n40
	}
	return i, nil
}

func (m *Call_Decline) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_Decline) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.OfferIDs) > 0 {
		for _, msg := range m.OfferIDs {
			dAtA[i] = 0xa
			i++
			i = encodeVarintScheduler(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Filters != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Filters.Size()))
		n41, err := m.Filters.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n41
	}
	return i, nil
}

func (m *Call_AcceptInverseOffers) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_AcceptInverseOffers) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.InverseOfferIDs) > 0 {
		for _, msg := range m.InverseOfferIDs {
			dAtA[i] = 0xa
			i++
			i = encodeVarintScheduler(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Filters != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Filters.Size()))
		n42, err := m.Filters.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n42
	}
	return i, nil
}

func (m *Call_DeclineInverseOffers) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_DeclineInverseOffers) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.InverseOfferIDs) > 0 {
		for _, msg := range m.InverseOfferIDs {
			dAtA[i] = 0xa
			i++
			i = encodeVarintScheduler(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Filters != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.Filters.Size()))
		n43, err := m.Filters.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n43
	}
	return i, nil
}

func (m *Call_Revive) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_Revive) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Roles) > 0 {
		for _, s := range m.Roles {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *Call_Kill) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_Kill) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintScheduler(dAtA, i, uint64(m.TaskID.Size()))
	n44, err := m.TaskID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n44
	if m.AgentID != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.AgentID.Size()))
		n45, err := m.AgentID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n45
	}
	if m.KillPolicy != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.KillPolicy.Size()))
		n46, err := m.KillPolicy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n46
	}
	return i, nil
}

func (m *Call_Shutdown) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_Shutdown) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintScheduler(dAtA, i, uint64(m.ExecutorID.Size()))
	n47, err := m.ExecutorID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n47
	dAtA[i] = 0x12
	i++
	i = encodeVarintScheduler(dAtA, i, uint64(m.AgentID.Size()))
	n48, err := m.AgentID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n48
	return i, nil
}

func (m *Call_Acknowledge) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_Acknowledge) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintScheduler(dAtA, i, uint64(m.AgentID.Size()))
	n49, err := m.AgentID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n49
	dAtA[i] = 0x12
	i++
	i = encodeVarintScheduler(dAtA, i, uint64(m.TaskID.Size()))
	n50, err := m.TaskID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n50
	if m.UUID == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("uuid")
	} else {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(len(m.UUID)))
		i += copy(dAtA[i:], m.UUID)
	}
	return i, nil
}

func (m *Call_AcknowledgeOperationStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_AcknowledgeOperationStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.AgentID != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.AgentID.Size()))
		n51, err := m.AgentID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n51
	}
	if m.ResourceProviderID != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.ResourceProviderID.Size()))
		n52, err := m.ResourceProviderID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n52
	}
	if m.UUID == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("uuid")
	} else {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(len(m.UUID)))
		i += copy(dAtA[i:], m.UUID)
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintScheduler(dAtA, i, uint64(m.OperationID.Size()))
	n53, err := m.OperationID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n53
	return i, nil
}

func (m *Call_Reconcile) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_Reconcile) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Tasks) > 0 {
		for _, msg := range m.Tasks {
			dAtA[i] = 0xa
			i++
			i = encodeVarintScheduler(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Call_Reconcile_Task) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_Reconcile_Task) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintScheduler(dAtA, i, uint64(m.TaskID.Size()))
	n54, err := m.TaskID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n54
	if m.AgentID != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.AgentID.Size()))
		n55, err := m.AgentID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n55
	}
	return i, nil
}

func (m *Call_ReconcileOperations) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_ReconcileOperations) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Operations) > 0 {
		for _, msg := range m.Operations {
			dAtA[i] = 0xa
			i++
			i = encodeVarintScheduler(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Call_ReconcileOperations_Operation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_ReconcileOperations_Operation) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintScheduler(dAtA, i, uint64(m.OperationID.Size()))
	n56, err := m.OperationID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n56
	if m.AgentID != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.AgentID.Size()))
		n57, err := m.AgentID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n57
	}
	if m.ResourceProviderID != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(m.ResourceProviderID.Size()))
		n58, err := m.ResourceProviderID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n58
	}
	return i, nil
}

func (m *Call_Message) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_Message) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintScheduler(dAtA, i, uint64(m.AgentID.Size()))
	n59, err := m.AgentID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n59
	dAtA[i] = 0x12
	i++
	i = encodeVarintScheduler(dAtA, i, uint64(m.ExecutorID.Size()))
	n60, err := m.ExecutorID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n60
	if m.Data == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("data")
	} else {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintScheduler(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *Call_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_Request) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Requests) > 0 {
		for _, msg := range m.Requests {
			dAtA[i] = 0xa
			i++
			i = encodeVarintScheduler(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Call_Suppress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_Suppress) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Roles) > 0 {
		for _, s := range m.Roles {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *Call_UpdateFramework) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_UpdateFramework) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintScheduler(dAtA, i, uint64(m.FrameworkInfo.Size()))
	n61, err := m.FrameworkInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n61
	if len(m.SuppressedRoles) > 0 {
		for _, s := range m.SuppressedRoles {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func encodeFixed64Scheduler(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Scheduler(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintScheduler(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedEvent(r randyScheduler, easy bool) *Event {
	this := &Event{}
	this.Type = Event_Type([]int32{0, 1, 2, 9, 3, 10, 4, 11, 5, 6, 7, 8}[r.Intn(12)])
	if r.Intn(10) != 0 {
		this.Subscribed = NewPopulatedEvent_Subscribed(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Offers = NewPopulatedEvent_Offers(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Rescind = NewPopulatedEvent_Rescind(r, easy)
	}
	if r.Intn(10) == 0 {
		this.Update = NewPopulatedEvent_Update(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Message = NewPopulatedEvent_Message(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Failure = NewPopulatedEvent_Failure(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Error = NewPopulatedEvent_Error(r, easy)
	}
	if r.Intn(10) != 0 {
		this.InverseOffers = NewPopulatedEvent_InverseOffers(r, easy)
	}
	if r.Intn(10) != 0 {
		this.RescindInverseOffer = NewPopulatedEvent_RescindInverseOffer(r, easy)
	}
	if r.Intn(10) != 0 {
		this.UpdateOperationStatus = NewPopulatedEvent_UpdateOperationStatus(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_Subscribed(r randyScheduler, easy bool) *Event_Subscribed {
	this := &Event_Subscribed{}
	this.FrameworkID = mesos.NewPopulatedFrameworkID(r, easy)
	if r.Intn(10) != 0 {
		v1 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v1 *= -1
		}
		this.HeartbeatIntervalSeconds = &v1
	}
	if r.Intn(10) != 0 {
		this.MasterInfo = mesos.NewPopulatedMasterInfo(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_Offers(r randyScheduler, easy bool) *Event_Offers {
	this := &Event_Offers{}
	if r.Intn(10) != 0 {
		v2 := r.Intn(5)
		this.Offers = make([]mesos.Offer, v2)
		for i := 0; i < v2; i++ {
			v3 := mesos.NewPopulatedOffer(r, easy)
			this.Offers[i] = *v3
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_InverseOffers(r randyScheduler, easy bool) *Event_InverseOffers {
	this := &Event_InverseOffers{}
	if r.Intn(10) != 0 {
		v4 := r.Intn(5)
		this.InverseOffers = make([]mesos.InverseOffer, v4)
		for i := 0; i < v4; i++ {
			v5 := mesos.NewPopulatedInverseOffer(r, easy)
			this.InverseOffers[i] = *v5
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_Rescind(r randyScheduler, easy bool) *Event_Rescind {
	this := &Event_Rescind{}
	v6 := mesos.NewPopulatedOfferID(r, easy)
	this.OfferID = *v6
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_RescindInverseOffer(r randyScheduler, easy bool) *Event_RescindInverseOffer {
	this := &Event_RescindInverseOffer{}
	v7 := mesos.NewPopulatedOfferID(r, easy)
	this.InverseOfferID = *v7
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_Update(r randyScheduler, easy bool) *Event_Update {
	this := &Event_Update{}
	v8 := mesos.NewPopulatedTaskStatus(r, easy)
	this.Status = *v8
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_UpdateOperationStatus(r randyScheduler, easy bool) *Event_UpdateOperationStatus {
	this := &Event_UpdateOperationStatus{}
	v9 := mesos.NewPopulatedOperationStatus(r, easy)
	this.Status = *v9
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_Message(r randyScheduler, easy bool) *Event_Message {
	this := &Event_Message{}
	v10 := mesos.NewPopulatedAgentID(r, easy)
	this.AgentID = *v10
	v11 := mesos.NewPopulatedExecutorID(r, easy)
	this.ExecutorID = *v11
	v12 := r.Intn(100)
	this.Data = make([]byte, v12)
	for i := 0; i < v12; i++ {
		this.Data[i] = byte(r.Intn(256))
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_Failure(r randyScheduler, easy bool) *Event_Failure {
	this := &Event_Failure{}
	if r.Intn(10) != 0 {
		this.AgentID = mesos.NewPopulatedAgentID(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ExecutorID = mesos.NewPopulatedExecutorID(r, easy)
	}
	if r.Intn(10) != 0 {
		v13 := int32(r.Int31())
		if r.Intn(2) == 0 {
			v13 *= -1
		}
		this.Status = &v13
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_Error(r randyScheduler, easy bool) *Event_Error {
	this := &Event_Error{}
	this.Message = string(randStringScheduler(r))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse(r randyScheduler, easy bool) *Response {
	this := &Response{}
	this.Type = Response_Type([]int32{0, 1}[r.Intn(2)])
	if r.Intn(10) != 0 {
		this.ReconcileOperations = NewPopulatedResponse_ReconcileOperations(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_ReconcileOperations(r randyScheduler, easy bool) *Response_ReconcileOperations {
	this := &Response_ReconcileOperations{}
	if r.Intn(10) != 0 {
		v14 := r.Intn(5)
		this.OperationStatuses = make([]mesos.OperationStatus, v14)
		for i := 0; i < v14; i++ {
			v15 := mesos.NewPopulatedOperationStatus(r, easy)
			this.OperationStatuses[i] = *v15
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall(r randyScheduler, easy bool) *Call {
	this := &Call{}
	if r.Intn(10) != 0 {
		this.FrameworkID = mesos.NewPopulatedFrameworkID(r, easy)
	}
	this.Type = Call_Type([]int32{0, 1, 2, 3, 4, 13, 14, 5, 6, 7, 8, 15, 9, 16, 10, 11, 12, 17}[r.Intn(18)])
	if r.Intn(10) != 0 {
		this.Subscribe = NewPopulatedCall_Subscribe(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Accept = NewPopulatedCall_Accept(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Decline = NewPopulatedCall_Decline(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Kill = NewPopulatedCall_Kill(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Shutdown = NewPopulatedCall_Shutdown(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Acknowledge = NewPopulatedCall_Acknowledge(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Reconcile = NewPopulatedCall_Reconcile(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Message = NewPopulatedCall_Message(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Request = NewPopulatedCall_Request(r, easy)
	}
	if r.Intn(10) != 0 {
		this.AcceptInverseOffers = NewPopulatedCall_AcceptInverseOffers(r, easy)
	}
	if r.Intn(10) != 0 {
		this.DeclineInverseOffers = NewPopulatedCall_DeclineInverseOffers(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Revive = NewPopulatedCall_Revive(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Suppress = NewPopulatedCall_Suppress(r, easy)
	}
	if r.Intn(10) != 0 {
		this.AcknowledgeOperationStatus = NewPopulatedCall_AcknowledgeOperationStatus(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ReconcileOperations = NewPopulatedCall_ReconcileOperations(r, easy)
	}
	if r.Intn(10) != 0 {
		this.UpdateFramework = NewPopulatedCall_UpdateFramework(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_Subscribe(r randyScheduler, easy bool) *Call_Subscribe {
	this := &Call_Subscribe{}
	this.FrameworkInfo = mesos.NewPopulatedFrameworkInfo(r, easy)
	if r.Intn(10) != 0 {
		v16 := r.Intn(10)
		this.SuppressedRoles = make([]string, v16)
		for i := 0; i < v16; i++ {
			this.SuppressedRoles[i] = string(randStringScheduler(r))
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_Accept(r randyScheduler, easy bool) *Call_Accept {
	this := &Call_Accept{}
	if r.Intn(10) != 0 {
		v17 := r.Intn(5)
		this.OfferIDs = make([]mesos.OfferID, v17)
		for i := 0; i < v17; i++ {
			v18 := mesos.NewPopulatedOfferID(r, easy)
			this.OfferIDs[i] = *v18
		}
	}
	if r.Intn(10) != 0 {
		v19 := r.Intn(5)
		this.Operations = make([]mesos.Offer_Operation, v19)
		for i := 0; i < v19; i++ {
			v20 := mesos.NewPopulatedOffer_Operation(r, easy)
			this.Operations[i] = *v20
		}
	}
	if r.Intn(10) != 0 {
		this.Filters = mesos.NewPopulatedFilters(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_Decline(r randyScheduler, easy bool) *Call_Decline {
	this := &Call_Decline{}
	if r.Intn(10) != 0 {
		v21 := r.Intn(5)
		this.OfferIDs = make([]mesos.OfferID, v21)
		for i := 0; i < v21; i++ {
			v22 := mesos.NewPopulatedOfferID(r, easy)
			this.OfferIDs[i] = *v22
		}
	}
	if r.Intn(10) != 0 {
		this.Filters = mesos.NewPopulatedFilters(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_AcceptInverseOffers(r randyScheduler, easy bool) *Call_AcceptInverseOffers {
	this := &Call_AcceptInverseOffers{}
	if r.Intn(10) != 0 {
		v23 := r.Intn(5)
		this.InverseOfferIDs = make([]mesos.OfferID, v23)
		for i := 0; i < v23; i++ {
			v24 := mesos.NewPopulatedOfferID(r, easy)
			this.InverseOfferIDs[i] = *v24
		}
	}
	if r.Intn(10) != 0 {
		this.Filters = mesos.NewPopulatedFilters(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_DeclineInverseOffers(r randyScheduler, easy bool) *Call_DeclineInverseOffers {
	this := &Call_DeclineInverseOffers{}
	if r.Intn(10) != 0 {
		v25 := r.Intn(5)
		this.InverseOfferIDs = make([]mesos.OfferID, v25)
		for i := 0; i < v25; i++ {
			v26 := mesos.NewPopulatedOfferID(r, easy)
			this.InverseOfferIDs[i] = *v26
		}
	}
	if r.Intn(10) != 0 {
		this.Filters = mesos.NewPopulatedFilters(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_Revive(r randyScheduler, easy bool) *Call_Revive {
	this := &Call_Revive{}
	if r.Intn(10) != 0 {
		v27 := r.Intn(10)
		this.Roles = make([]string, v27)
		for i := 0; i < v27; i++ {
			this.Roles[i] = string(randStringScheduler(r))
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_Kill(r randyScheduler, easy bool) *Call_Kill {
	this := &Call_Kill{}
	v28 := mesos.NewPopulatedTaskID(r, easy)
	this.TaskID = *v28
	if r.Intn(10) != 0 {
		this.AgentID = mesos.NewPopulatedAgentID(r, easy)
	}
	if r.Intn(10) != 0 {
		this.KillPolicy = mesos.NewPopulatedKillPolicy(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_Shutdown(r randyScheduler, easy bool) *Call_Shutdown {
	this := &Call_Shutdown{}
	v29 := mesos.NewPopulatedExecutorID(r, easy)
	this.ExecutorID = *v29
	v30 := mesos.NewPopulatedAgentID(r, easy)
	this.AgentID = *v30
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_Acknowledge(r randyScheduler, easy bool) *Call_Acknowledge {
	this := &Call_Acknowledge{}
	v31 := mesos.NewPopulatedAgentID(r, easy)
	this.AgentID = *v31
	v32 := mesos.NewPopulatedTaskID(r, easy)
	this.TaskID = *v32
	v33 := r.Intn(100)
	this.UUID = make([]byte, v33)
	for i := 0; i < v33; i++ {
		this.UUID[i] = byte(r.Intn(256))
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_AcknowledgeOperationStatus(r randyScheduler, easy bool) *Call_AcknowledgeOperationStatus {
	this := &Call_AcknowledgeOperationStatus{}
	if r.Intn(10) != 0 {
		this.AgentID = mesos.NewPopulatedAgentID(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ResourceProviderID = mesos.NewPopulatedResourceProviderID(r, easy)
	}
	v34 := r.Intn(100)
	this.UUID = make([]byte, v34)
	for i := 0; i < v34; i++ {
		this.UUID[i] = byte(r.Intn(256))
	}
	v35 := mesos.NewPopulatedOperationID(r, easy)
	this.OperationID = *v35
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_Reconcile(r randyScheduler, easy bool) *Call_Reconcile {
	this := &Call_Reconcile{}
	if r.Intn(10) != 0 {
		v36 := r.Intn(5)
		this.Tasks = make([]Call_Reconcile_Task, v36)
		for i := 0; i < v36; i++ {
			v37 := NewPopulatedCall_Reconcile_Task(r, easy)
			this.Tasks[i] = *v37
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_Reconcile_Task(r randyScheduler, easy bool) *Call_Reconcile_Task {
	this := &Call_Reconcile_Task{}
	v38 := mesos.NewPopulatedTaskID(r, easy)
	this.TaskID = *v38
	if r.Intn(10) != 0 {
		this.AgentID = mesos.NewPopulatedAgentID(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_ReconcileOperations(r randyScheduler, easy bool) *Call_ReconcileOperations {
	this := &Call_ReconcileOperations{}
	if r.Intn(10) != 0 {
		v39 := r.Intn(5)
		this.Operations = make([]Call_ReconcileOperations_Operation, v39)
		for i := 0; i < v39; i++ {
			v40 := NewPopulatedCall_ReconcileOperations_Operation(r, easy)
			this.Operations[i] = *v40
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_ReconcileOperations_Operation(r randyScheduler, easy bool) *Call_ReconcileOperations_Operation {
	this := &Call_ReconcileOperations_Operation{}
	v41 := mesos.NewPopulatedOperationID(r, easy)
	this.OperationID = *v41
	if r.Intn(10) != 0 {
		this.AgentID = mesos.NewPopulatedAgentID(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ResourceProviderID = mesos.NewPopulatedResourceProviderID(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_Message(r randyScheduler, easy bool) *Call_Message {
	this := &Call_Message{}
	v42 := mesos.NewPopulatedAgentID(r, easy)
	this.AgentID = *v42
	v43 := mesos.NewPopulatedExecutorID(r, easy)
	this.ExecutorID = *v43
	v44 := r.Intn(100)
	this.Data = make([]byte, v44)
	for i := 0; i < v44; i++ {
		this.Data[i] = byte(r.Intn(256))
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_Request(r randyScheduler, easy bool) *Call_Request {
	this := &Call_Request{}
	if r.Intn(10) != 0 {
		v45 := r.Intn(5)
		this.Requests = make([]mesos.Request, v45)
		for i := 0; i < v45; i++ {
			v46 := mesos.NewPopulatedRequest(r, easy)
			this.Requests[i] = *v46
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_Suppress(r randyScheduler, easy bool) *Call_Suppress {
	this := &Call_Suppress{}
	if r.Intn(10) != 0 {
		v47 := r.Intn(10)
		this.Roles = make([]string, v47)
		for i := 0; i < v47; i++ {
			this.Roles[i] = string(randStringScheduler(r))
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_UpdateFramework(r randyScheduler, easy bool) *Call_UpdateFramework {
	this := &Call_UpdateFramework{}
	v48 := mesos.NewPopulatedFrameworkInfo(r, easy)
	this.FrameworkInfo = *v48
	if r.Intn(10) != 0 {
		v49 := r.Intn(10)
		this.SuppressedRoles = make([]string, v49)
		for i := 0; i < v49; i++ {
			this.SuppressedRoles[i] = string(randStringScheduler(r))
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyScheduler interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneScheduler(r randyScheduler) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringScheduler(r randyScheduler) string {
	v50 := r.Intn(100)
	tmps := make([]rune, v50)
	for i := 0; i < v50; i++ {
		tmps[i] = randUTF8RuneScheduler(r)
	}
	return string(tmps)
}
func randUnrecognizedScheduler(r randyScheduler, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldScheduler(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldScheduler(dAtA []byte, r randyScheduler, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateScheduler(dAtA, uint64(key))
		v51 := r.Int63()
		if r.Intn(2) == 0 {
			v51 *= -1
		}
		dAtA = encodeVarintPopulateScheduler(dAtA, uint64(v51))
	case 1:
		dAtA = encodeVarintPopulateScheduler(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateScheduler(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateScheduler(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateScheduler(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateScheduler(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Event) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovScheduler(uint64(m.Type))
	if m.Subscribed != nil {
		l = m.Subscribed.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Offers != nil {
		l = m.Offers.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Rescind != nil {
		l = m.Rescind.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Update != nil {
		l = m.Update.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Message != nil {
		l = m.Message.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Failure != nil {
		l = m.Failure.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.InverseOffers != nil {
		l = m.InverseOffers.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.RescindInverseOffer != nil {
		l = m.RescindInverseOffer.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.UpdateOperationStatus != nil {
		l = m.UpdateOperationStatus.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	return n
}

func (m *Event_Subscribed) Size() (n int) {
	var l int
	_ = l
	if m.FrameworkID != nil {
		l = m.FrameworkID.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.HeartbeatIntervalSeconds != nil {
		n += 9
	}
	if m.MasterInfo != nil {
		l = m.MasterInfo.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	return n
}

func (m *Event_Offers) Size() (n int) {
	var l int
	_ = l
	if len(m.Offers) > 0 {
		for _, e := range m.Offers {
			l = e.Size()
			n += 1 + l + sovScheduler(uint64(l))
		}
	}
	return n
}

func (m *Event_InverseOffers) Size() (n int) {
	var l int
	_ = l
	if len(m.InverseOffers) > 0 {
		for _, e := range m.InverseOffers {
			l = e.Size()
			n += 1 + l + sovScheduler(uint64(l))
		}
	}
	return n
}

func (m *Event_Rescind) Size() (n int) {
	var l int
	_ = l
	l = m.OfferID.Size()
	n += 1 + l + sovScheduler(uint64(l))
	return n
}

func (m *Event_RescindInverseOffer) Size() (n int) {
	var l int
	_ = l
	l = m.InverseOfferID.Size()
	n += 1 + l + sovScheduler(uint64(l))
	return n
}

func (m *Event_Update) Size() (n int) {
	var l int
	_ = l
	l = m.Status.Size()
	n += 1 + l + sovScheduler(uint64(l))
	return n
}

func (m *Event_UpdateOperationStatus) Size() (n int) {
	var l int
	_ = l
	l = m.Status.Size()
	n += 1 + l + sovScheduler(uint64(l))
	return n
}

func (m *Event_Message) Size() (n int) {
	var l int
	_ = l
	l = m.AgentID.Size()
	n += 1 + l + sovScheduler(uint64(l))
	l = m.ExecutorID.Size()
	n += 1 + l + sovScheduler(uint64(l))
	if m.Data != nil {
		l = len(m.Data)
		n += 1 + l + sovScheduler(uint64(l))
	}
	return n
}

func (m *Event_Failure) Size() (n int) {
	var l int
	_ = l
	if m.AgentID != nil {
		l = m.AgentID.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.ExecutorID != nil {
		l = m.ExecutorID.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Status != nil {
		n += 1 + sovScheduler(uint64(*m.Status))
	}
	return n
}

func (m *Event_Error) Size() (n int) {
	var l int
	_ = l
	l = len(m.Message)
	n += 1 + l + sovScheduler(uint64(l))
	return n
}

func (m *Response) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovScheduler(uint64(m.Type))
	if m.ReconcileOperations != nil {
		l = m.ReconcileOperations.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	return n
}

func (m *Response_ReconcileOperations) Size() (n int) {
	var l int
	_ = l
	if len(m.OperationStatuses) > 0 {
		for _, e := range m.OperationStatuses {
			l = e.Size()
			n += 1 + l + sovScheduler(uint64(l))
		}
	}
	return n
}

func (m *Call) Size() (n int) {
	var l int
	_ = l
	if m.FrameworkID != nil {
		l = m.FrameworkID.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	n += 1 + sovScheduler(uint64(m.Type))
	if m.Subscribe != nil {
		l = m.Subscribe.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Accept != nil {
		l = m.Accept.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Decline != nil {
		l = m.Decline.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Kill != nil {
		l = m.Kill.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Shutdown != nil {
		l = m.Shutdown.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Acknowledge != nil {
		l = m.Acknowledge.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Reconcile != nil {
		l = m.Reconcile.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Message != nil {
		l = m.Message.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Request != nil {
		l = m.Request.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.AcceptInverseOffers != nil {
		l = m.AcceptInverseOffers.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.DeclineInverseOffers != nil {
		l = m.DeclineInverseOffers.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Revive != nil {
		l = m.Revive.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Suppress != nil {
		l = m.Suppress.Size()
		n += 2 + l + sovScheduler(uint64(l))
	}
	if m.AcknowledgeOperationStatus != nil {
		l = m.AcknowledgeOperationStatus.Size()
		n += 2 + l + sovScheduler(uint64(l))
	}
	if m.ReconcileOperations != nil {
		l = m.ReconcileOperations.Size()
		n += 2 + l + sovScheduler(uint64(l))
	}
	if m.UpdateFramework != nil {
		l = m.UpdateFramework.Size()
		n += 2 + l + sovScheduler(uint64(l))
	}
	return n
}

func (m *Call_Subscribe) Size() (n int) {
	var l int
	_ = l
	if m.FrameworkInfo != nil {
		l = m.FrameworkInfo.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if len(m.SuppressedRoles) > 0 {
		for _, s := range m.SuppressedRoles {
			l = len(s)
			n += 1 + l + sovScheduler(uint64(l))
		}
	}
	return n
}

func (m *Call_Accept) Size() (n int) {
	var l int
	_ = l
	if len(m.OfferIDs) > 0 {
		for _, e := range m.OfferIDs {
			l = e.Size()
			n += 1 + l + sovScheduler(uint64(l))
		}
	}
	if len(m.Operations) > 0 {
		for _, e := range m.Operations {
			l = e.Size()
			n += 1 + l + sovScheduler(uint64(l))
		}
	}
	if m.Filters != nil {
		l = m.Filters.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	return n
}

func (m *Call_Decline) Size() (n int) {
	var l int
	_ = l
	if len(m.OfferIDs) > 0 {
		for _, e := range m.OfferIDs {
			l = e.Size()
			n += 1 + l + sovScheduler(uint64(l))
		}
	}
	if m.Filters != nil {
		l = m.Filters.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	return n
}

func (m *Call_AcceptInverseOffers) Size() (n int) {
	var l int
	_ = l
	if len(m.InverseOfferIDs) > 0 {
		for _, e := range m.InverseOfferIDs {
			l = e.Size()
			n += 1 + l + sovScheduler(uint64(l))
		}
	}
	if m.Filters != nil {
		l = m.Filters.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	return n
}

func (m *Call_DeclineInverseOffers) Size() (n int) {
	var l int
	_ = l
	if len(m.InverseOfferIDs) > 0 {
		for _, e := range m.InverseOfferIDs {
			l = e.Size()
			n += 1 + l + sovScheduler(uint64(l))
		}
	}
	if m.Filters != nil {
		l = m.Filters.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	return n
}

func (m *Call_Revive) Size() (n int) {
	var l int
	_ = l
	if len(m.Roles) > 0 {
		for _, s := range m.Roles {
			l = len(s)
			n += 1 + l + sovScheduler(uint64(l))
		}
	}
	return n
}

func (m *Call_Kill) Size() (n int) {
	var l int
	_ = l
	l = m.TaskID.Size()
	n += 1 + l + sovScheduler(uint64(l))
	if m.AgentID != nil {
		l = m.AgentID.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.KillPolicy != nil {
		l = m.KillPolicy.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	return n
}

func (m *Call_Shutdown) Size() (n int) {
	var l int
	_ = l
	l = m.ExecutorID.Size()
	n += 1 + l + sovScheduler(uint64(l))
	l = m.AgentID.Size()
	n += 1 + l + sovScheduler(uint64(l))
	return n
}

func (m *Call_Acknowledge) Size() (n int) {
	var l int
	_ = l
	l = m.AgentID.Size()
	n += 1 + l + sovScheduler(uint64(l))
	l = m.TaskID.Size()
	n += 1 + l + sovScheduler(uint64(l))
	if m.UUID != nil {
		l = len(m.UUID)
		n += 1 + l + sovScheduler(uint64(l))
	}
	return n
}

func (m *Call_AcknowledgeOperationStatus) Size() (n int) {
	var l int
	_ = l
	if m.AgentID != nil {
		l = m.AgentID.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.ResourceProviderID != nil {
		l = m.ResourceProviderID.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.UUID != nil {
		l = len(m.UUID)
		n += 1 + l + sovScheduler(uint64(l))
	}
	l = m.OperationID.Size()
	n += 1 + l + sovScheduler(uint64(l))
	return n
}

func (m *Call_Reconcile) Size() (n int) {
	var l int
	_ = l
	if len(m.Tasks) > 0 {
		for _, e := range m.Tasks {
			l = e.Size()
			n += 1 + l + sovScheduler(uint64(l))
		}
	}
	return n
}

func (m *Call_Reconcile_Task) Size() (n int) {
	var l int
	_ = l
	l = m.TaskID.Size()
	n += 1 + l + sovScheduler(uint64(l))
	if m.AgentID != nil {
		l = m.AgentID.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	return n
}

func (m *Call_ReconcileOperations) Size() (n int) {
	var l int
	_ = l
	if len(m.Operations) > 0 {
		for _, e := range m.Operations {
			l = e.Size()
			n += 1 + l + sovScheduler(uint64(l))
		}
	}
	return n
}

func (m *Call_ReconcileOperations_Operation) Size() (n int) {
	var l int
	_ = l
	l = m.OperationID.Size()
	n += 1 + l + sovScheduler(uint64(l))
	if m.AgentID != nil {
		l = m.AgentID.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.ResourceProviderID != nil {
		l = m.ResourceProviderID.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	return n
}

func (m *Call_Message) Size() (n int) {
	var l int
	_ = l
	l = m.AgentID.Size()
	n += 1 + l + sovScheduler(uint64(l))
	l = m.ExecutorID.Size()
	n += 1 + l + sovScheduler(uint64(l))
	if m.Data != nil {
		l = len(m.Data)
		n += 1 + l + sovScheduler(uint64(l))
	}
	return n
}

func (m *Call_Request) Size() (n int) {
	var l int
	_ = l
	if len(m.Requests) > 0 {
		for _, e := range m.Requests {
			l = e.Size()
			n += 1 + l + sovScheduler(uint64(l))
		}
	}
	return n
}

func (m *Call_Suppress) Size() (n int) {
	var l int
	_ = l
	if len(m.Roles) > 0 {
		for _, s := range m.Roles {
			l = len(s)
			n += 1 + l + sovScheduler(uint64(l))
		}
	}
	return n
}

func (m *Call_UpdateFramework) Size() (n int) {
	var l int
	_ = l
	l = m.FrameworkInfo.Size()
	n += 1 + l + sovScheduler(uint64(l))
	if len(m.SuppressedRoles) > 0 {
		for _, s := range m.SuppressedRoles {
			l = len(s)
			n += 1 + l + sovScheduler(uint64(l))
		}
	}
	return n
}

func sovScheduler(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozScheduler(x uint64) (n int) {
	return sovScheduler(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Event) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Subscribed:` + strings.Replace(fmt.Sprintf("%v", this.Subscribed), "Event_Subscribed", "Event_Subscribed", 1) + `,`,
		`Offers:` + strings.Replace(fmt.Sprintf("%v", this.Offers), "Event_Offers", "Event_Offers", 1) + `,`,
		`Rescind:` + strings.Replace(fmt.Sprintf("%v", this.Rescind), "Event_Rescind", "Event_Rescind", 1) + `,`,
		`Update:` + strings.Replace(fmt.Sprintf("%v", this.Update), "Event_Update", "Event_Update", 1) + `,`,
		`Message:` + strings.Replace(fmt.Sprintf("%v", this.Message), "Event_Message", "Event_Message", 1) + `,`,
		`Failure:` + strings.Replace(fmt.Sprintf("%v", this.Failure), "Event_Failure", "Event_Failure", 1) + `,`,
		`Error:` + strings.Replace(fmt.Sprintf("%v", this.Error), "Event_Error", "Event_Error", 1) + `,`,
		`InverseOffers:` + strings.Replace(fmt.Sprintf("%v", this.InverseOffers), "Event_InverseOffers", "Event_InverseOffers", 1) + `,`,
		`RescindInverseOffer:` + strings.Replace(fmt.Sprintf("%v", this.RescindInverseOffer), "Event_RescindInverseOffer", "Event_RescindInverseOffer", 1) + `,`,
		`UpdateOperationStatus:` + strings.Replace(fmt.Sprintf("%v", this.UpdateOperationStatus), "Event_UpdateOperationStatus", "Event_UpdateOperationStatus", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_Subscribed) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_Subscribed{`,
		`FrameworkID:` + strings.Replace(fmt.Sprintf("%v", this.FrameworkID), "FrameworkID", "mesos.FrameworkID", 1) + `,`,
		`HeartbeatIntervalSeconds:` + valueToStringScheduler(this.HeartbeatIntervalSeconds) + `,`,
		`MasterInfo:` + strings.Replace(fmt.Sprintf("%v", this.MasterInfo), "MasterInfo", "mesos.MasterInfo", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_Offers) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_Offers{`,
		`Offers:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Offers), "Offer", "mesos.Offer", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_InverseOffers) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_InverseOffers{`,
		`InverseOffers:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.InverseOffers), "InverseOffer", "mesos.InverseOffer", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_Rescind) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_Rescind{`,
		`OfferID:` + strings.Replace(strings.Replace(this.OfferID.String(), "OfferID", "mesos.OfferID", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_RescindInverseOffer) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_RescindInverseOffer{`,
		`InverseOfferID:` + strings.Replace(strings.Replace(this.InverseOfferID.String(), "OfferID", "mesos.OfferID", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_Update) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_Update{`,
		`Status:` + strings.Replace(strings.Replace(this.Status.String(), "TaskStatus", "mesos.TaskStatus", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_UpdateOperationStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_UpdateOperationStatus{`,
		`Status:` + strings.Replace(strings.Replace(this.Status.String(), "OperationStatus", "mesos.OperationStatus", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_Message) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_Message{`,
		`AgentID:` + strings.Replace(strings.Replace(this.AgentID.String(), "AgentID", "mesos.AgentID", 1), `&`, ``, 1) + `,`,
		`ExecutorID:` + strings.Replace(strings.Replace(this.ExecutorID.String(), "ExecutorID", "mesos.ExecutorID", 1), `&`, ``, 1) + `,`,
		`Data:` + valueToStringScheduler(this.Data) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_Failure) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_Failure{`,
		`AgentID:` + strings.Replace(fmt.Sprintf("%v", this.AgentID), "AgentID", "mesos.AgentID", 1) + `,`,
		`ExecutorID:` + strings.Replace(fmt.Sprintf("%v", this.ExecutorID), "ExecutorID", "mesos.ExecutorID", 1) + `,`,
		`Status:` + valueToStringScheduler(this.Status) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_Error) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_Error{`,
		`Message:` + fmt.Sprintf("%v", this.Message) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`ReconcileOperations:` + strings.Replace(fmt.Sprintf("%v", this.ReconcileOperations), "Response_ReconcileOperations", "Response_ReconcileOperations", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_ReconcileOperations) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_ReconcileOperations{`,
		`OperationStatuses:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.OperationStatuses), "OperationStatus", "mesos.OperationStatus", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call{`,
		`FrameworkID:` + strings.Replace(fmt.Sprintf("%v", this.FrameworkID), "FrameworkID", "mesos.FrameworkID", 1) + `,`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Subscribe:` + strings.Replace(fmt.Sprintf("%v", this.Subscribe), "Call_Subscribe", "Call_Subscribe", 1) + `,`,
		`Accept:` + strings.Replace(fmt.Sprintf("%v", this.Accept), "Call_Accept", "Call_Accept", 1) + `,`,
		`Decline:` + strings.Replace(fmt.Sprintf("%v", this.Decline), "Call_Decline", "Call_Decline", 1) + `,`,
		`Kill:` + strings.Replace(fmt.Sprintf("%v", this.Kill), "Call_Kill", "Call_Kill", 1) + `,`,
		`Shutdown:` + strings.Replace(fmt.Sprintf("%v", this.Shutdown), "Call_Shutdown", "Call_Shutdown", 1) + `,`,
		`Acknowledge:` + strings.Replace(fmt.Sprintf("%v", this.Acknowledge), "Call_Acknowledge", "Call_Acknowledge", 1) + `,`,
		`Reconcile:` + strings.Replace(fmt.Sprintf("%v", this.Reconcile), "Call_Reconcile", "Call_Reconcile", 1) + `,`,
		`Message:` + strings.Replace(fmt.Sprintf("%v", this.Message), "Call_Message", "Call_Message", 1) + `,`,
		`Request:` + strings.Replace(fmt.Sprintf("%v", this.Request), "Call_Request", "Call_Request", 1) + `,`,
		`AcceptInverseOffers:` + strings.Replace(fmt.Sprintf("%v", this.AcceptInverseOffers), "Call_AcceptInverseOffers", "Call_AcceptInverseOffers", 1) + `,`,
		`DeclineInverseOffers:` + strings.Replace(fmt.Sprintf("%v", this.DeclineInverseOffers), "Call_DeclineInverseOffers", "Call_DeclineInverseOffers", 1) + `,`,
		`Revive:` + strings.Replace(fmt.Sprintf("%v", this.Revive), "Call_Revive", "Call_Revive", 1) + `,`,
		`Suppress:` + strings.Replace(fmt.Sprintf("%v", this.Suppress), "Call_Suppress", "Call_Suppress", 1) + `,`,
		`AcknowledgeOperationStatus:` + strings.Replace(fmt.Sprintf("%v", this.AcknowledgeOperationStatus), "Call_AcknowledgeOperationStatus", "Call_AcknowledgeOperationStatus", 1) + `,`,
		`ReconcileOperations:` + strings.Replace(fmt.Sprintf("%v", this.ReconcileOperations), "Call_ReconcileOperations", "Call_ReconcileOperations", 1) + `,`,
		`UpdateFramework:` + strings.Replace(fmt.Sprintf("%v", this.UpdateFramework), "Call_UpdateFramework", "Call_UpdateFramework", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_Subscribe) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_Subscribe{`,
		`FrameworkInfo:` + strings.Replace(fmt.Sprintf("%v", this.FrameworkInfo), "FrameworkInfo", "mesos.FrameworkInfo", 1) + `,`,
		`SuppressedRoles:` + fmt.Sprintf("%v", this.SuppressedRoles) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_Accept) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_Accept{`,
		`OfferIDs:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.OfferIDs), "OfferID", "mesos.OfferID", 1), `&`, ``, 1) + `,`,
		`Operations:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Operations), "Offer_Operation", "mesos.Offer_Operation", 1), `&`, ``, 1) + `,`,
		`Filters:` + strings.Replace(fmt.Sprintf("%v", this.Filters), "Filters", "mesos.Filters", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_Decline) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_Decline{`,
		`OfferIDs:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.OfferIDs), "OfferID", "mesos.OfferID", 1), `&`, ``, 1) + `,`,
		`Filters:` + strings.Replace(fmt.Sprintf("%v", this.Filters), "Filters", "mesos.Filters", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_AcceptInverseOffers) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_AcceptInverseOffers{`,
		`InverseOfferIDs:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.InverseOfferIDs), "OfferID", "mesos.OfferID", 1), `&`, ``, 1) + `,`,
		`Filters:` + strings.Replace(fmt.Sprintf("%v", this.Filters), "Filters", "mesos.Filters", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_DeclineInverseOffers) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_DeclineInverseOffers{`,
		`InverseOfferIDs:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.InverseOfferIDs), "OfferID", "mesos.OfferID", 1), `&`, ``, 1) + `,`,
		`Filters:` + strings.Replace(fmt.Sprintf("%v", this.Filters), "Filters", "mesos.Filters", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_Revive) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_Revive{`,
		`Roles:` + fmt.Sprintf("%v", this.Roles) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_Kill) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_Kill{`,
		`TaskID:` + strings.Replace(strings.Replace(this.TaskID.String(), "TaskID", "mesos.TaskID", 1), `&`, ``, 1) + `,`,
		`AgentID:` + strings.Replace(fmt.Sprintf("%v", this.AgentID), "AgentID", "mesos.AgentID", 1) + `,`,
		`KillPolicy:` + strings.Replace(fmt.Sprintf("%v", this.KillPolicy), "KillPolicy", "mesos.KillPolicy", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_Shutdown) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_Shutdown{`,
		`ExecutorID:` + strings.Replace(strings.Replace(this.ExecutorID.String(), "ExecutorID", "mesos.ExecutorID", 1), `&`, ``, 1) + `,`,
		`AgentID:` + strings.Replace(strings.Replace(this.AgentID.String(), "AgentID", "mesos.AgentID", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_Acknowledge) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_Acknowledge{`,
		`AgentID:` + strings.Replace(strings.Replace(this.AgentID.String(), "AgentID", "mesos.AgentID", 1), `&`, ``, 1) + `,`,
		`TaskID:` + strings.Replace(strings.Replace(this.TaskID.String(), "TaskID", "mesos.TaskID", 1), `&`, ``, 1) + `,`,
		`UUID:` + valueToStringScheduler(this.UUID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_AcknowledgeOperationStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_AcknowledgeOperationStatus{`,
		`AgentID:` + strings.Replace(fmt.Sprintf("%v", this.AgentID), "AgentID", "mesos.AgentID", 1) + `,`,
		`ResourceProviderID:` + strings.Replace(fmt.Sprintf("%v", this.ResourceProviderID), "ResourceProviderID", "mesos.ResourceProviderID", 1) + `,`,
		`UUID:` + valueToStringScheduler(this.UUID) + `,`,
		`OperationID:` + strings.Replace(strings.Replace(this.OperationID.String(), "OperationID", "mesos.OperationID", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_Reconcile) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_Reconcile{`,
		`Tasks:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Tasks), "Call_Reconcile_Task", "Call_Reconcile_Task", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_Reconcile_Task) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_Reconcile_Task{`,
		`TaskID:` + strings.Replace(strings.Replace(this.TaskID.String(), "TaskID", "mesos.TaskID", 1), `&`, ``, 1) + `,`,
		`AgentID:` + strings.Replace(fmt.Sprintf("%v", this.AgentID), "AgentID", "mesos.AgentID", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_ReconcileOperations) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_ReconcileOperations{`,
		`Operations:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Operations), "Call_ReconcileOperations_Operation", "Call_ReconcileOperations_Operation", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_ReconcileOperations_Operation) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_ReconcileOperations_Operation{`,
		`OperationID:` + strings.Replace(strings.Replace(this.OperationID.String(), "OperationID", "mesos.OperationID", 1), `&`, ``, 1) + `,`,
		`AgentID:` + strings.Replace(fmt.Sprintf("%v", this.AgentID), "AgentID", "mesos.AgentID", 1) + `,`,
		`ResourceProviderID:` + strings.Replace(fmt.Sprintf("%v", this.ResourceProviderID), "ResourceProviderID", "mesos.ResourceProviderID", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_Message) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_Message{`,
		`AgentID:` + strings.Replace(strings.Replace(this.AgentID.String(), "AgentID", "mesos.AgentID", 1), `&`, ``, 1) + `,`,
		`ExecutorID:` + strings.Replace(strings.Replace(this.ExecutorID.String(), "ExecutorID", "mesos.ExecutorID", 1), `&`, ``, 1) + `,`,
		`Data:` + valueToStringScheduler(this.Data) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_Request) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_Request{`,
		`Requests:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Requests), "Request", "mesos.Request", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_Suppress) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_Suppress{`,
		`Roles:` + fmt.Sprintf("%v", this.Roles) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_UpdateFramework) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_UpdateFramework{`,
		`FrameworkInfo:` + strings.Replace(strings.Replace(this.FrameworkInfo.String(), "FrameworkInfo", "mesos.FrameworkInfo", 1), `&`, ``, 1) + `,`,
		`SuppressedRoles:` + fmt.Sprintf("%v", this.SuppressedRoles) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringScheduler(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Event) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Event: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Event: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Event_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subscribed", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subscribed == nil {
				m.Subscribed = &Event_Subscribed{}
			}
			if err := m.Subscribed.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Offers == nil {
				m.Offers = &Event_Offers{}
			}
			if err := m.Offers.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rescind", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Rescind == nil {
				m.Rescind = &Event_Rescind{}
			}
			if err := m.Rescind.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Update", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Update == nil {
				m.Update = &Event_Update{}
			}
			if err := m.Update.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Message == nil {
				m.Message = &Event_Message{}
			}
			if err := m.Message.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Failure", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Failure == nil {
				m.Failure = &Event_Failure{}
			}
			if err := m.Failure.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &Event_Error{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InverseOffers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.InverseOffers == nil {
				m.InverseOffers = &Event_InverseOffers{}
			}
			if err := m.InverseOffers.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RescindInverseOffer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RescindInverseOffer == nil {
				m.RescindInverseOffer = &Event_RescindInverseOffer{}
			}
			if err := m.RescindInverseOffer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdateOperationStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpdateOperationStatus == nil {
				m.UpdateOperationStatus = &Event_UpdateOperationStatus{}
			}
			if err := m.UpdateOperationStatus.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_Subscribed) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Subscribed: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Subscribed: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FrameworkID == nil {
				m.FrameworkID = &mesos.FrameworkID{}
			}
			if err := m.FrameworkID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatIntervalSeconds", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(dAtA[iNdEx-8])
			v |= uint64(dAtA[iNdEx-7]) << 8
			v |= uint64(dAtA[iNdEx-6]) << 16
			v |= uint64(dAtA[iNdEx-5]) << 24
			v |= uint64(dAtA[iNdEx-4]) << 32
			v |= uint64(dAtA[iNdEx-3]) << 40
			v |= uint64(dAtA[iNdEx-2]) << 48
			v |= uint64(dAtA[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.HeartbeatIntervalSeconds = &v2
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MasterInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MasterInfo == nil {
				m.MasterInfo = &mesos.MasterInfo{}
			}
			if err := m.MasterInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("framework_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_Offers) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Offers: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Offers: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Offers = append(m.Offers, mesos.Offer{})
			if err := m.Offers[len(m.Offers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_InverseOffers) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InverseOffers: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InverseOffers: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InverseOffers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InverseOffers = append(m.InverseOffers, mesos.InverseOffer{})
			if err := m.InverseOffers[len(m.InverseOffers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_Rescind) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Rescind: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Rescind: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OfferID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OfferID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("offer_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_RescindInverseOffer) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RescindInverseOffer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RescindInverseOffer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InverseOfferID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.InverseOfferID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("inverse_offer_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_Update) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Update: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Update: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("status")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_UpdateOperationStatus) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateOperationStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateOperationStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("status")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_Message) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Message: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Message: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AgentID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutorID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ExecutorID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000004)
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("agent_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("executor_id")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("data")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_Failure) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Failure: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Failure: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AgentID == nil {
				m.AgentID = &mesos.AgentID{}
			}
			if err := m.AgentID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutorID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecutorID == nil {
				m.ExecutorID = &mesos.ExecutorID{}
			}
			if err := m.ExecutorID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Status = &v
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_Error) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Error: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Error: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("message")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Response: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Response: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Response_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReconcileOperations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReconcileOperations == nil {
				m.ReconcileOperations = &Response_ReconcileOperations{}
			}
			if err := m.ReconcileOperations.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_ReconcileOperations) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReconcileOperations: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReconcileOperations: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OperationStatuses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OperationStatuses = append(m.OperationStatuses, mesos.OperationStatus{})
			if err := m.OperationStatuses[len(m.OperationStatuses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Call: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Call: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FrameworkID == nil {
				m.FrameworkID = &mesos.FrameworkID{}
			}
			if err := m.FrameworkID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Call_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subscribe", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subscribe == nil {
				m.Subscribe = &Call_Subscribe{}
			}
			if err := m.Subscribe.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Accept", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Accept == nil {
				m.Accept = &Call_Accept{}
			}
			if err := m.Accept.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Decline", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Decline == nil {
				m.Decline = &Call_Decline{}
			}
			if err := m.Decline.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kill", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Kill == nil {
				m.Kill = &Call_Kill{}
			}
			if err := m.Kill.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Shutdown", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Shutdown == nil {
				m.Shutdown = &Call_Shutdown{}
			}
			if err := m.Shutdown.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Acknowledge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Acknowledge == nil {
				m.Acknowledge = &Call_Acknowledge{}
			}
			if err := m.Acknowledge.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reconcile", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Reconcile == nil {
				m.Reconcile = &Call_Reconcile{}
			}
			if err := m.Reconcile.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Message == nil {
				m.Message = &Call_Message{}
			}
			if err := m.Message.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Request", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Request == nil {
				m.Request = &Call_Request{}
			}
			if err := m.Request.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AcceptInverseOffers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AcceptInverseOffers == nil {
				m.AcceptInverseOffers = &Call_AcceptInverseOffers{}
			}
			if err := m.AcceptInverseOffers.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeclineInverseOffers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeclineInverseOffers == nil {
				m.DeclineInverseOffers = &Call_DeclineInverseOffers{}
			}
			if err := m.DeclineInverseOffers.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Revive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Revive == nil {
				m.Revive = &Call_Revive{}
			}
			if err := m.Revive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Suppress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Suppress == nil {
				m.Suppress = &Call_Suppress{}
			}
			if err := m.Suppress.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AcknowledgeOperationStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AcknowledgeOperationStatus == nil {
				m.AcknowledgeOperationStatus = &Call_AcknowledgeOperationStatus{}
			}
			if err := m.AcknowledgeOperationStatus.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReconcileOperations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReconcileOperations == nil {
				m.ReconcileOperations = &Call_ReconcileOperations{}
			}
			if err := m.ReconcileOperations.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdateFramework", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpdateFramework == nil {
				m.UpdateFramework = &Call_UpdateFramework{}
			}
			if err := m.UpdateFramework.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_Subscribe) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Subscribe: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Subscribe: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FrameworkInfo == nil {
				m.FrameworkInfo = &mesos.FrameworkInfo{}
			}
			if err := m.FrameworkInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SuppressedRoles", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SuppressedRoles = append(m.SuppressedRoles, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("framework_info")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_Accept) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Accept: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Accept: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OfferIDs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OfferIDs = append(m.OfferIDs, mesos.OfferID{})
			if err := m.OfferIDs[len(m.OfferIDs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Operations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Operations = append(m.Operations, mesos.Offer_Operation{})
			if err := m.Operations[len(m.Operations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Filters == nil {
				m.Filters = &mesos.Filters{}
			}
			if err := m.Filters.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_Decline) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Decline: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Decline: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OfferIDs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OfferIDs = append(m.OfferIDs, mesos.OfferID{})
			if err := m.OfferIDs[len(m.OfferIDs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Filters == nil {
				m.Filters = &mesos.Filters{}
			}
			if err := m.Filters.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_AcceptInverseOffers) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AcceptInverseOffers: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AcceptInverseOffers: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InverseOfferIDs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InverseOfferIDs = append(m.InverseOfferIDs, mesos.OfferID{})
			if err := m.InverseOfferIDs[len(m.InverseOfferIDs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Filters == nil {
				m.Filters = &mesos.Filters{}
			}
			if err := m.Filters.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_DeclineInverseOffers) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeclineInverseOffers: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeclineInverseOffers: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InverseOfferIDs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InverseOfferIDs = append(m.InverseOfferIDs, mesos.OfferID{})
			if err := m.InverseOfferIDs[len(m.InverseOfferIDs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Filters == nil {
				m.Filters = &mesos.Filters{}
			}
			if err := m.Filters.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_Revive) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Revive: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Revive: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Roles", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Roles = append(m.Roles, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_Kill) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Kill: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Kill: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TaskID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AgentID == nil {
				m.AgentID = &mesos.AgentID{}
			}
			if err := m.AgentID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KillPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.KillPolicy == nil {
				m.KillPolicy = &mesos.KillPolicy{}
			}
			if err := m.KillPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("task_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_Shutdown) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Shutdown: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Shutdown: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutorID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ExecutorID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AgentID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("executor_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("agent_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_Acknowledge) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Acknowledge: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Acknowledge: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AgentID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TaskID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UUID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UUID = append(m.UUID[:0], dAtA[iNdEx:postIndex]...)
			if m.UUID == nil {
				m.UUID = []byte{}
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000004)
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("agent_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("task_id")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("uuid")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_AcknowledgeOperationStatus) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AcknowledgeOperationStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AcknowledgeOperationStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AgentID == nil {
				m.AgentID = &mesos.AgentID{}
			}
			if err := m.AgentID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceProviderID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResourceProviderID == nil {
				m.ResourceProviderID = &mesos.ResourceProviderID{}
			}
			if err := m.ResourceProviderID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UUID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UUID = append(m.UUID[:0], dAtA[iNdEx:postIndex]...)
			if m.UUID == nil {
				m.UUID = []byte{}
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OperationID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OperationID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("uuid")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("operation_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_Reconcile) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reconcile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reconcile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tasks = append(m.Tasks, Call_Reconcile_Task{})
			if err := m.Tasks[len(m.Tasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_Reconcile_Task) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Task: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Task: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TaskID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AgentID == nil {
				m.AgentID = &mesos.AgentID{}
			}
			if err := m.AgentID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("task_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_ReconcileOperations) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReconcileOperations: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReconcileOperations: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Operations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Operations = append(m.Operations, Call_ReconcileOperations_Operation{})
			if err := m.Operations[len(m.Operations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_ReconcileOperations_Operation) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Operation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Operation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OperationID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OperationID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AgentID == nil {
				m.AgentID = &mesos.AgentID{}
			}
			if err := m.AgentID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceProviderID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResourceProviderID == nil {
				m.ResourceProviderID = &mesos.ResourceProviderID{}
			}
			if err := m.ResourceProviderID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("operation_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_Message) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Message: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Message: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AgentID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutorID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ExecutorID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000004)
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("agent_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("executor_id")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("data")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Requests", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Requests = append(m.Requests, mesos.Request{})
			if err := m.Requests[len(m.Requests)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_Suppress) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Suppress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Suppress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Roles", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Roles = append(m.Roles, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_UpdateFramework) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateFramework: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateFramework: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.FrameworkInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SuppressedRoles", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SuppressedRoles = append(m.SuppressedRoles, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("framework_info")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipScheduler(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthScheduler
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowScheduler
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipScheduler(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthScheduler = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowScheduler   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("scheduler/scheduler.proto", fileDescriptorScheduler) }

var fileDescriptorScheduler = []byte{
	// 2065 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x58, 0x4d, 0x70, 0x23, 0x47,
	0x15, 0x76, 0xcb, 0xfa, 0x7d, 0xb2, 0xa5, 0x71, 0xfb, 0x67, 0x67, 0x27, 0x8e, 0xec, 0xb8, 0x42,
	0xe1, 0xa4, 0x58, 0x7b, 0x31, 0x9b, 0x2c, 0x24, 0xa1, 0x2a, 0xfa, 0x19, 0x6f, 0x06, 0xff, 0xa6,
	0x25, 0x6d, 0x0a, 0x0a, 0x10, 0x63, 0x4d, 0xdb, 0x3b, 0x65, 0x59, 0x23, 0x66, 0x46, 0x5e, 0xf6,
	0x04, 0x47, 0x4e, 0x14, 0x07, 0x38, 0x52, 0x14, 0x95, 0x0b, 0xc5, 0x01, 0xae, 0x1c, 0x39, 0x00,
	0x15, 0x2e, 0x54, 0x8e, 0x39, 0xb9, 0x62, 0x71, 0x80, 0x63, 0x0e, 0x1c, 0x38, 0x52, 0xdd, 0xd3,
	0x33, 0x9a, 0x91, 0x34, 0x5a, 0xec, 0xa5, 0xa0, 0x72, 0x51, 0x69, 0x5e, 0x7f, 0xef, 0xf5, 0x9b,
	0xf7, 0x5e, 0xbf, 0xf7, 0xf5, 0xc0, 0x5d, 0xa7, 0xfd, 0x84, 0x1a, 0xfd, 0x0e, 0xb5, 0xb7, 0x83,
	0x7f, 0x5b, 0x3d, 0xdb, 0x72, 0x2d, 0x5c, 0xbc, 0xa0, 0x8e, 0xe5, 0x6c, 0x05, 0x62, 0xe5, 0xfe,
	0x99, 0xe9, 0x3e, 0xe9, 0x9f, 0x6c, 0xb5, 0xad, 0x8b, 0x6d, 0xbe, 0xe6, 0xfd, 0xde, 0x3b, 0xb3,
	0xb6, 0xf5, 0x9e, 0xb9, 0x7d, 0xf9, 0xe5, 0xed, 0x8e, 0x79, 0xe2, 0xc9, 0x3c, 0x13, 0xca, 0xbd,
	0x90, 0xc6, 0x99, 0x75, 0x66, 0x6d, 0x73, 0xf1, 0x49, 0xff, 0x94, 0x3f, 0xf1, 0x07, 0xfe, 0xcf,
	0x83, 0x6f, 0xfc, 0xb6, 0x08, 0x29, 0xf5, 0x92, 0x76, 0x5d, 0xfc, 0x06, 0x24, 0xdd, 0x67, 0x3d,
	0x2a, 0xa3, 0x75, 0xb4, 0x59, 0xd8, 0x79, 0x69, 0x6b, 0xc4, 0x95, 0x2d, 0x8e, 0xda, 0x6a, 0x3c,
	0xeb, 0xd1, 0x4a, 0xf2, 0xa3, 0xab, 0xb5, 0x19, 0xc2, 0xe1, 0xb8, 0x0c, 0xe0, 0xf4, 0x4f, 0x9c,
	0xb6, 0x6d, 0x9e, 0x50, 0x43, 0x4e, 0xac, 0xa3, 0xcd, 0xfc, 0xce, 0x2b, 0x31, 0xca, 0xf5, 0x00,
	0x48, 0x42, 0x4a, 0xf8, 0x0d, 0x48, 0x5b, 0xa7, 0xa7, 0xd4, 0x76, 0xe4, 0x59, 0xae, 0xfe, 0x72,
	0x8c, 0xfa, 0x11, 0x07, 0x11, 0x01, 0xc6, 0x5f, 0x85, 0x8c, 0x4d, 0x9d, 0xb6, 0xd9, 0x35, 0xe4,
	0x24, 0xd7, 0x2b, 0xc5, 0xe8, 0x11, 0x0f, 0x45, 0x7c, 0x38, 0xdb, 0xb0, 0xdf, 0x33, 0x74, 0x97,
	0xca, 0xa9, 0xa9, 0x1b, 0x36, 0x39, 0x88, 0x08, 0x30, 0xdb, 0xf0, 0x82, 0x3a, 0x8e, 0x7e, 0x46,
	0xe5, 0xf4, 0xd4, 0x0d, 0x0f, 0x3c, 0x14, 0xf1, 0xe1, 0x4c, 0xf3, 0x54, 0x37, 0x3b, 0x7d, 0x9b,
	0xca, 0x99, 0xa9, 0x9a, 0xbb, 0x1e, 0x8a, 0xf8, 0x70, 0xbc, 0x03, 0x29, 0x6a, 0xdb, 0x96, 0x2d,
	0x67, 0xb9, 0xde, 0x6a, 0x8c, 0x9e, 0xca, 0x30, 0xc4, 0x83, 0xe2, 0x3d, 0x28, 0x98, 0xdd, 0x4b,
	0x6a, 0x3b, 0xb4, 0x25, 0xe2, 0x9a, 0xe3, 0xca, 0xaf, 0xc6, 0x28, 0x6b, 0x1e, 0x58, 0x84, 0x77,
	0xde, 0x0c, 0x3f, 0xe2, 0xef, 0xc2, 0xb2, 0x08, 0x5b, 0x2b, 0x62, 0x54, 0x06, 0x6e, 0xf3, 0xf5,
	0xe9, 0x31, 0x0f, 0x9b, 0x26, 0x8b, 0xf6, 0xb8, 0x10, 0x1b, 0x70, 0xc7, 0x0b, 0x6f, 0xcb, 0xea,
	0x51, 0x5b, 0x77, 0x4d, 0xab, 0xdb, 0x72, 0x5c, 0xdd, 0xed, 0x3b, 0x72, 0x9e, 0xef, 0xf0, 0xa5,
	0xa9, 0xc9, 0x39, 0xf2, 0x95, 0xea, 0x5c, 0x87, 0x2c, 0xf7, 0x27, 0x89, 0x95, 0x3f, 0x23, 0x80,
	0x61, 0xf5, 0xe1, 0x5d, 0x98, 0x3b, 0xb5, 0xf5, 0x0b, 0xfa, 0xd4, 0xb2, 0xcf, 0x5b, 0xa6, 0x21,
	0xa3, 0xf5, 0xc4, 0x66, 0x7e, 0x07, 0x8b, 0x9d, 0x76, 0xfd, 0x25, 0xad, 0x56, 0x29, 0x0e, 0xae,
	0xd6, 0xf2, 0x21, 0x01, 0xc9, 0x07, 0x8a, 0x9a, 0x81, 0xdf, 0x01, 0xe5, 0x09, 0xd5, 0x6d, 0xf7,
	0x84, 0xea, 0x6e, 0xcb, 0xec, 0xba, 0xd4, 0xbe, 0xd4, 0x3b, 0x2d, 0x87, 0xb6, 0xad, 0xae, 0xe1,
	0xf0, 0xc3, 0x80, 0x88, 0x1c, 0x20, 0x34, 0x01, 0xa8, 0x7b, 0xeb, 0x78, 0x07, 0xf2, 0x17, 0xba,
	0xe3, 0x52, 0xbb, 0x65, 0x76, 0x4f, 0x2d, 0x51, 0xfc, 0x0b, 0xc2, 0x89, 0x03, 0xbe, 0xa2, 0x75,
	0x4f, 0x2d, 0x02, 0x17, 0xc1, 0x7f, 0xe5, 0x01, 0xa4, 0x45, 0x62, 0x5e, 0x0f, 0x4e, 0x0d, 0x5a,
	0x9f, 0xdd, 0xcc, 0xef, 0xcc, 0x09, 0x45, 0xbe, 0x2c, 0x8e, 0xa8, 0x40, 0x28, 0xef, 0xc3, 0x7c,
	0x24, 0xc9, 0xf8, 0xdd, 0xb1, 0x12, 0xf1, 0x8c, 0x2c, 0x0a, 0x23, 0x61, 0xb4, 0xb0, 0x15, 0xad,
	0x0b, 0x45, 0x85, 0x8c, 0xc8, 0x31, 0x7e, 0x0b, 0xb2, 0xdc, 0xc8, 0x30, 0x92, 0x85, 0xb0, 0x2f,
	0x2c, 0x8a, 0xcc, 0xc2, 0xe0, 0x6a, 0x2d, 0x23, 0x04, 0x24, 0xc3, 0x15, 0x34, 0x43, 0x39, 0x83,
	0xc5, 0x09, 0xa5, 0x82, 0x8f, 0x41, 0x8a, 0xf8, 0x17, 0x6f, 0x7a, 0x45, 0x98, 0x2e, 0x84, 0xf5,
	0xb5, 0x1a, 0x29, 0x84, 0xdd, 0xd5, 0x0c, 0xe5, 0x6b, 0x90, 0xf6, 0x2a, 0x06, 0x6f, 0x43, 0x5a,
	0x14, 0x98, 0x67, 0xd1, 0x8f, 0x78, 0x43, 0x77, 0xce, 0xbd, 0x72, 0xf1, 0xa3, 0xe7, 0xc1, 0x94,
	0x03, 0x58, 0x9e, 0x58, 0x6c, 0xf8, 0xc1, 0x88, 0xa5, 0x15, 0xdf, 0xb7, 0x28, 0x6e, 0xc4, 0xdc,
	0xaf, 0x10, 0x64, 0x44, 0x87, 0x60, 0xa1, 0xd3, 0xcf, 0x68, 0xd7, 0x1d, 0x7f, 0xbf, 0x32, 0x13,
	0x87, 0x43, 0x27, 0x04, 0x24, 0xc3, 0x15, 0x34, 0x56, 0xc4, 0x79, 0xfa, 0x03, 0xda, 0xee, 0xbb,
	0x16, 0x0f, 0x4f, 0x22, 0xf2, 0x32, 0xaa, 0x58, 0xd1, 0x6a, 0x15, 0x2c, 0x2c, 0xc0, 0x50, 0x46,
	0xc0, 0xd7, 0xd4, 0x0c, 0x8c, 0x21, 0x69, 0xe8, 0xae, 0x2e, 0xcf, 0xae, 0x27, 0x36, 0xe7, 0x08,
	0xff, 0xaf, 0xfc, 0x02, 0x41, 0x46, 0xf4, 0x22, 0xfc, 0x66, 0xc4, 0x47, 0x34, 0xc1, 0xc7, 0xfc,
	0x44, 0xff, 0x2a, 0xa3, 0xfe, 0xa1, 0xc9, 0xfe, 0x15, 0xa6, 0xf8, 0xb6, 0x12, 0x44, 0x98, 0x9d,
	0x8e, 0x54, 0x10, 0xc3, 0x2f, 0x42, 0x8a, 0xb7, 0x3c, 0x5c, 0x1a, 0xf6, 0x64, 0x16, 0xbf, 0x9c,
	0x88, 0xb5, 0x2f, 0xdc, 0xf8, 0x2b, 0x82, 0x24, 0x9b, 0x59, 0x38, 0x0f, 0x99, 0xe6, 0xe1, 0xde,
	0xe1, 0xd1, 0x07, 0x87, 0xd2, 0x0c, 0x2e, 0x00, 0xd4, 0x9b, 0x95, 0x7a, 0x95, 0x68, 0x15, 0xb5,
	0x26, 0x21, 0x0c, 0x90, 0x3e, 0xda, 0xdd, 0x55, 0x49, 0x5d, 0x4a, 0x60, 0x0c, 0x05, 0xed, 0xf0,
	0xb1, 0x4a, 0xea, 0x6a, 0x4b, 0xc8, 0x72, 0x4c, 0x99, 0xa8, 0xf5, 0xaa, 0x76, 0x58, 0x93, 0x66,
	0xf1, 0x5d, 0x58, 0x16, 0x0f, 0xad, 0x08, 0x50, 0x02, 0x66, 0xa7, 0x79, 0x5c, 0x2b, 0x37, 0x54,
	0x29, 0x89, 0x5f, 0x82, 0x3b, 0xde, 0xff, 0xd6, 0xd1, 0xb1, 0x4a, 0xca, 0x0d, 0xed, 0xe8, 0xb0,
	0x55, 0x6f, 0x94, 0x1b, 0xcd, 0xba, 0x94, 0x67, 0x06, 0x0f, 0xd4, 0x7a, 0xbd, 0xfc, 0x48, 0x95,
	0x52, 0xec, 0x61, 0xb7, 0xac, 0xed, 0x37, 0x89, 0x2a, 0xa5, 0x71, 0x0e, 0x52, 0x2a, 0x21, 0x47,
	0x44, 0xca, 0xe0, 0x79, 0xc8, 0xbd, 0xa7, 0x96, 0x49, 0xa3, 0xa2, 0x96, 0x1b, 0x52, 0x56, 0x49,
	0xfe, 0xf8, 0xc3, 0x12, 0xda, 0xf8, 0x4b, 0x02, 0xb2, 0x84, 0x3a, 0x3d, 0xab, 0xeb, 0xb0, 0xb9,
	0x12, 0x9e, 0xd9, 0xe3, 0x43, 0xc5, 0x07, 0x8e, 0x8f, 0x6d, 0x03, 0x96, 0x6c, 0xd6, 0x86, 0xda,
	0x66, 0x27, 0xd4, 0x79, 0x1d, 0x91, 0xa5, 0x7b, 0xf1, 0x96, 0x88, 0xaf, 0x15, 0x14, 0xb9, 0x53,
	0x49, 0xc8, 0x88, 0x35, 0xf7, 0xb1, 0x05, 0xc5, 0x60, 0xa7, 0x7b, 0x4c, 0x8c, 0x0f, 0x00, 0x8f,
	0x36, 0x7b, 0xea, 0x77, 0xa0, 0xb8, 0x33, 0x94, 0x66, 0xce, 0xcb, 0x88, 0x2c, 0x58, 0xd1, 0x05,
	0xea, 0x6c, 0x3c, 0x9c, 0x94, 0xe2, 0x55, 0x58, 0x22, 0x6a, 0xf5, 0xe8, 0xb0, 0xaa, 0xed, 0x87,
	0x32, 0x50, 0x97, 0x90, 0x92, 0xc8, 0x22, 0x11, 0xcb, 0x4f, 0xd6, 0x20, 0x59, 0xd5, 0x3b, 0x9d,
	0x09, 0xf3, 0x00, 0xdd, 0x6a, 0x1e, 0x3c, 0x10, 0xf9, 0x48, 0xf0, 0x7c, 0x28, 0x63, 0x51, 0x64,
	0x9b, 0x8d, 0xe7, 0xe2, 0xeb, 0x90, 0x0b, 0xd8, 0x90, 0x98, 0x02, 0x6b, 0x93, 0x55, 0x83, 0x11,
	0x46, 0x86, 0x1a, 0xac, 0x0b, 0xe9, 0xed, 0x36, 0xed, 0xb9, 0x82, 0x06, 0xad, 0x4e, 0xd6, 0x2d,
	0x73, 0x0c, 0x11, 0x58, 0xfc, 0x10, 0x32, 0x06, 0x6d, 0x77, 0xcc, 0x6e, 0x3c, 0x09, 0xe2, 0x6a,
	0x35, 0x0f, 0x44, 0x7c, 0x34, 0xde, 0x82, 0xe4, 0xb9, 0xd9, 0xe9, 0x08, 0x0a, 0x14, 0xf3, 0x8e,
	0x7b, 0x66, 0xa7, 0x43, 0x38, 0x8e, 0xb5, 0x38, 0xe7, 0x49, 0xdf, 0x35, 0xac, 0xa7, 0xdd, 0x58,
	0xf2, 0xe3, 0xbd, 0x9c, 0x40, 0x91, 0x00, 0x8f, 0xab, 0x90, 0xd7, 0xdb, 0xe7, 0x5d, 0xeb, 0x69,
	0x87, 0x1a, 0x67, 0x54, 0x70, 0xa0, 0x57, 0xe2, 0xde, 0x2f, 0x00, 0x92, 0xb0, 0x16, 0x0b, 0x6f,
	0x50, 0x9b, 0x82, 0x09, 0xc5, 0x84, 0x37, 0xa8, 0x55, 0x32, 0xd4, 0x60, 0x81, 0xf2, 0x3b, 0x0c,
	0x4c, 0x0b, 0xd4, 0x18, 0xe9, 0x7b, 0xc8, 0xf8, 0xe9, 0xf7, 0xfb, 0xd4, 0x71, 0x05, 0x93, 0x79,
	0x39, 0x6e, 0x57, 0x0e, 0x22, 0x3e, 0x1a, 0x7f, 0x07, 0x96, 0xbd, 0x24, 0xb5, 0x46, 0x66, 0xf4,
	0x3c, 0x37, 0xf3, 0xda, 0xb4, 0xfc, 0x46, 0xb9, 0xdc, 0xa2, 0x3e, 0x2e, 0xc4, 0xdf, 0x83, 0x15,
	0x91, 0xcb, 0x51, 0xfb, 0x85, 0x18, 0x4a, 0x17, 0x2e, 0x84, 0xe8, 0x06, 0x4b, 0xc6, 0x04, 0x29,
	0xab, 0x48, 0x9b, 0x5e, 0x9a, 0x97, 0x54, 0x2e, 0x4e, 0xab, 0x48, 0xc2, 0x31, 0x44, 0x60, 0x79,
	0xa1, 0xf4, 0x7b, 0x3d, 0x9b, 0x3a, 0x8e, 0x2c, 0x4d, 0x2d, 0x14, 0x81, 0x22, 0x01, 0x1e, 0xdb,
	0xb0, 0x1a, 0x4a, 0xf9, 0x38, 0x95, 0x5c, 0xe0, 0xf6, 0xee, 0x3f, 0xb7, 0x72, 0x46, 0xe9, 0xa4,
	0xa2, 0xc7, 0xae, 0xe1, 0x6f, 0xc7, 0xb4, 0x50, 0x3c, 0x2d, 0x4b, 0x13, 0xda, 0xe1, 0xc4, 0xd6,
	0xc9, 0x18, 0x90, 0xe0, 0xc5, 0x41, 0x83, 0x91, 0x17, 0xb9, 0xe5, 0x2f, 0x4c, 0xb6, 0xec, 0x51,
	0x94, 0xa0, 0x35, 0x91, 0x62, 0x3f, 0x2a, 0x50, 0x1c, 0xc8, 0x05, 0xfd, 0x03, 0xbf, 0x0d, 0x85,
	0x50, 0xc7, 0x63, 0xf4, 0xd3, 0xa3, 0x1f, 0x4b, 0x63, 0x3d, 0x8f, 0x31, 0xd0, 0xf9, 0xd3, 0xf0,
	0x23, 0x7e, 0x0d, 0x24, 0x3f, 0xf2, 0xd4, 0x68, 0xd9, 0x56, 0x87, 0xb2, 0xc1, 0x31, 0xbb, 0x99,
	0x23, 0xc5, 0xa1, 0x9c, 0x30, 0xb1, 0xf2, 0x3b, 0x04, 0x69, 0xaf, 0x32, 0xd9, 0x39, 0xf4, 0xb9,
	0x9c, 0xdf, 0xec, 0x47, 0xc9, 0x9c, 0x24, 0xa8, 0x4a, 0x56, 0x08, 0x1c, 0x92, 0x15, 0x44, 0xd1,
	0xc1, 0xef, 0x00, 0x44, 0xe6, 0x54, 0x64, 0x58, 0x30, 0xd0, 0x70, 0x64, 0x88, 0xee, 0x1a, 0xc2,
	0xe3, 0x4d, 0xc8, 0x9c, 0x9a, 0x1d, 0x77, 0x78, 0xc9, 0xf4, 0xb7, 0xde, 0xf5, 0xa4, 0xc4, 0x5f,
	0x56, 0x6c, 0xc8, 0x88, 0x52, 0x7f, 0x51, 0x8f, 0x43, 0x7b, 0x26, 0xa6, 0xef, 0xf9, 0x33, 0x04,
	0x8b, 0x13, 0xce, 0x2f, 0xae, 0xc3, 0xc2, 0x28, 0x0d, 0x8e, 0x73, 0xe4, 0x8e, 0x70, 0xa4, 0x18,
	0xe5, 0xc1, 0x0e, 0x29, 0x46, 0x89, 0xf0, 0x4d, 0xdc, 0xfa, 0x39, 0x82, 0xa5, 0x49, 0xc7, 0xfe,
	0xff, 0xed, 0x57, 0x09, 0xd2, 0x5e, 0xef, 0xc0, 0x4b, 0x90, 0xf2, 0xca, 0x0f, 0xf1, 0xf2, 0xf3,
	0x1e, 0x94, 0xdf, 0x20, 0x48, 0xb2, 0x09, 0x84, 0xdf, 0x84, 0x8c, 0xab, 0x3b, 0xa1, 0x2b, 0xde,
	0x7c, 0x88, 0xeb, 0x33, 0xea, 0x29, 0x9c, 0x4b, 0x7b, 0xcf, 0x24, 0xcd, 0xd0, 0x9a, 0x11, 0xa1,
	0xbc, 0x89, 0x1b, 0x50, 0xde, 0x1d, 0xc8, 0xb3, 0x99, 0xd7, 0xea, 0x59, 0x1d, 0xb3, 0xfd, 0x6c,
	0xe4, 0x46, 0xc7, 0x3c, 0x3a, 0xe6, 0x0b, 0x04, 0xce, 0x83, 0xff, 0xca, 0x4f, 0x10, 0x64, 0xfd,
	0xd1, 0x37, 0xca, 0xe9, 0xd1, 0x6d, 0x39, 0xfd, 0x5b, 0x91, 0x17, 0xb8, 0xd1, 0xbd, 0x42, 0xf9,
	0x25, 0x82, 0x7c, 0xa8, 0x25, 0xbe, 0xd0, 0x1d, 0x25, 0x94, 0x80, 0xc4, 0x4d, 0x12, 0xb0, 0x0a,
	0xc9, 0x7e, 0xdf, 0x34, 0xbc, 0x3b, 0x49, 0x25, 0x3b, 0xb8, 0x5a, 0x4b, 0x36, 0x9b, 0x5a, 0x8d,
	0x70, 0xa9, 0xf2, 0x61, 0x02, 0x94, 0xf8, 0xa6, 0x7d, 0xeb, 0x0b, 0x4b, 0x9b, 0x35, 0x74, 0xc7,
	0xea, 0xdb, 0x6d, 0xda, 0xea, 0xd9, 0xd6, 0xa5, 0x69, 0xd0, 0xd0, 0xcd, 0xe5, 0xae, 0xb0, 0x41,
	0x04, 0xe4, 0x58, 0x20, 0xd8, 0x1d, 0x74, 0x70, 0xb5, 0x86, 0xc7, 0xe5, 0x04, 0xdb, 0xa3, 0xb2,
	0xe7, 0xbc, 0x19, 0xfe, 0x06, 0xcc, 0x0d, 0x67, 0x97, 0x69, 0xc8, 0xc9, 0xc8, 0x87, 0x89, 0xe0,
	0x45, 0xb5, 0x5a, 0x65, 0x51, 0x44, 0x2e, 0x1f, 0x12, 0x92, 0x7c, 0xa0, 0xac, 0x19, 0xca, 0x9f,
	0x10, 0xe4, 0x82, 0x71, 0x83, 0xdf, 0x85, 0x14, 0x8b, 0xad, 0x7f, 0x4c, 0x5f, 0x7d, 0xce, 0x78,
	0xe2, 0x09, 0x12, 0x7d, 0xd4, 0x53, 0x54, 0x2e, 0x21, 0xc9, 0x84, 0xff, 0xeb, 0x43, 0xa5, 0xfc,
	0x3d, 0x31, 0xf9, 0x16, 0xf1, 0xcd, 0xc8, 0x40, 0xf0, 0x5e, 0xeb, 0x2b, 0xff, 0xf1, 0xd4, 0x9d,
	0x36, 0x2d, 0x94, 0x7f, 0x22, 0xc8, 0x05, 0xeb, 0x63, 0x49, 0x41, 0xb7, 0x4f, 0xca, 0xad, 0x3b,
	0x4b, 0x5c, 0x6d, 0xce, 0xfe, 0x17, 0x6b, 0xf3, 0x73, 0xf1, 0x65, 0xe2, 0x6d, 0xc8, 0x08, 0xc2,
	0x8c, 0xef, 0x43, 0x56, 0x50, 0xe6, 0xd1, 0xe1, 0x23, 0x10, 0x22, 0xb3, 0x01, 0x4a, 0x59, 0x87,
	0xac, 0x4f, 0x1e, 0x63, 0x46, 0xc7, 0x0f, 0xa1, 0x38, 0x42, 0xa4, 0x70, 0xf9, 0x26, 0x54, 0xc9,
	0xff, 0x58, 0x76, 0x5b, 0xc2, 0xb4, 0xf1, 0xc7, 0xc4, 0xa4, 0xdb, 0xec, 0x3c, 0xe4, 0x82, 0x0f,
	0x16, 0x12, 0xc2, 0x73, 0x90, 0x6d, 0xa8, 0x65, 0x52, 0x63, 0x8b, 0x09, 0x0c, 0x90, 0x2e, 0x57,
	0xab, 0xea, 0x71, 0x43, 0x9a, 0x65, 0x5a, 0x35, 0xb5, 0xba, 0xaf, 0x1d, 0xaa, 0x52, 0x12, 0xdf,
	0x85, 0x65, 0x6f, 0xa1, 0x35, 0xf2, 0x45, 0x63, 0x1e, 0x2b, 0xb0, 0x22, 0x70, 0xa3, 0x6b, 0x05,
	0x66, 0x8f, 0xa8, 0x8f, 0xb5, 0xc7, 0xaa, 0x94, 0xc2, 0x59, 0x48, 0xee, 0x69, 0xfb, 0xfb, 0x52,
	0x9a, 0xed, 0x59, 0x7f, 0xaf, 0xd9, 0xe0, 0x7b, 0x66, 0x70, 0x11, 0xf2, 0xe5, 0x2a, 0xf3, 0x6e,
	0x5f, 0xad, 0x3d, 0x52, 0xa5, 0x2c, 0x5e, 0x87, 0xd5, 0x90, 0x60, 0xfc, 0x9b, 0x47, 0x91, 0xbd,
	0x43, 0x70, 0x23, 0x97, 0x72, 0x58, 0x8e, 0xb9, 0xa0, 0x4b, 0xe1, 0x8f, 0x23, 0xe0, 0x7d, 0x7a,
	0x79, 0xbf, 0xa9, 0xd6, 0x1b, 0x52, 0x9e, 0xfb, 0xd0, 0x3c, 0x3e, 0x26, 0x6a, 0xbd, 0x2e, 0xcd,
	0xe1, 0x25, 0x90, 0xc4, 0x17, 0x96, 0x5d, 0x52, 0x3e, 0x50, 0x3f, 0x38, 0x22, 0x7b, 0xd2, 0x82,
	0x77, 0xb5, 0xaf, 0x3c, 0xfa, 0xf8, 0xba, 0x34, 0xf3, 0xc9, 0x75, 0x69, 0xe6, 0xd3, 0xeb, 0x12,
	0xfa, 0xec, 0xba, 0x84, 0xfe, 0x75, 0x5d, 0x42, 0x3f, 0x1a, 0x94, 0xd0, 0xaf, 0x07, 0x25, 0xf4,
	0xfb, 0x41, 0x69, 0xe6, 0x0f, 0x83, 0x12, 0xfa, 0x68, 0x50, 0x42, 0x1f, 0x0f, 0x4a, 0xe8, 0xd3,
	0x41, 0x09, 0xfd, 0x63, 0x50, 0x9a, 0xf9, 0x6c, 0x50, 0x42, 0x3f, 0xfd, 0x5b, 0x69, 0xe6, 0x5b,
	0xb9, 0xa0, 0x7f, 0xfc, 0x3b, 0x00, 0x00, 0xff, 0xff, 0x39, 0x2f, 0xc2, 0xf8, 0xae, 0x19, 0x00,
	0x00,
}
