/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.json.formatter.JsonCodeStyleSettings;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.formatter.xml.XmlCodeStyleSettings;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u001a \u0010\f\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u001a1\u0010\r\u001a\u00020\u0001*\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00012\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00110\u0010H\u0082\b\"\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"guessFormattedLength", "", "project", "Lcom/intellij/openapi/project/Project;", "response", "", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "guessFormattedLengthForJson", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "indentSize", "guessFormattedLengthForXml", "indexOfFirstNot", "from", "predicate", "Lkotlin/Function2;", "", "CDATA_BEGIN", "CDATA_END", "intellij.restClient"})
@JvmName(name="HttpClientExecutionUtil")
@SourceDebugExtension(value={"SMAP\nhttpClientExecutionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 httpClientExecutionUtils.kt\ncom/intellij/httpClient/http/request/run/HttpClientExecutionUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n111#1,5:120\n111#1,5:126\n111#1,5:131\n111#1,5:136\n111#1,5:141\n1#2:125\n*S KotlinDebug\n*F\n+ 1 httpClientExecutionUtils.kt\ncom/intellij/httpClient/http/request/run/HttpClientExecutionUtil\n*L\n41#1:120,5\n78#1:126,5\n79#1:131,5\n81#1:136,5\n102#1:141,5\n*E\n"})
public final class HttpClientExecutionUtil {
    @NotNull
    private static final String CDATA_BEGIN = "<![CDATA[";
    @NotNull
    private static final String CDATA_END = "]]>";

    public static final int guessFormattedLength(@NotNull Project project, @NotNull String response2, @NotNull FileType fileType) {
        int n;
        CodeStyleSettings settings;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance((Project)project).getMainProjectCodeStyle();
        if (codeStyleSettings == null) {
            CodeStyleSettings codeStyleSettings2 = CodeStyleSettings.getDefaults();
            codeStyleSettings = codeStyleSettings2;
            Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings2, (String)"getDefaults(...)");
        }
        int indentSize = (settings = codeStyleSettings).useTabCharacter(fileType) ? 1 : settings.getIndentSize(fileType);
        String string = fileType.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"json", (boolean)false, (int)2, null)) {
            n = HttpClientExecutionUtil.guessFormattedLengthForJson(response2, settings, indentSize);
        } else {
            String string4 = fileType.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
            string2 = string4;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string5 = string2.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
            n = StringsKt.contains$default((CharSequence)string5, (CharSequence)"xml", (boolean)false, (int)2, null) ? HttpClientExecutionUtil.guessFormattedLengthForXml(response2, settings, indentSize) : response2.length();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static final int guessFormattedLengthForJson(String response2, CodeStyleSettings settings, int indentSize) {
        JsonCodeStyleSettings jsonCodeStyleSettings = (JsonCodeStyleSettings)settings.getCustomSettingsIfCreated(JsonCodeStyleSettings.class);
        boolean spaceAfterColon = jsonCodeStyleSettings == null || jsonCodeStyleSettings.SPACE_AFTER_COLON;
        boolean spaceBeforeColon = jsonCodeStyleSettings != null && jsonCodeStyleSettings.SPACE_BEFORE_COLON;
        int newWhitespaces = 0;
        int indent = 0;
        int containedWhitespaces = 0;
        for (int i = 0; i < response2.length(); ++i) {
            char currentChar = response2.charAt(i);
            if (CharsKt.isWhitespace((char)currentChar)) {
                ++containedWhitespaces;
                continue;
            }
            if (currentChar == '\"') {
                void $this$indexOfFirstNot$iv;
                int j$iv;
                String string = response2;
                int from$iv = i + 1;
                boolean $i$f$indexOfFirstNot = false;
                for (j$iv = from$iv; j$iv < $this$indexOfFirstNot$iv.length(); ++j$iv) {
                    void j;
                    int n = j$iv;
                    void str = $this$indexOfFirstNot$iv;
                    boolean bl = false;
                    if (!(str.charAt((int)j) != '\"' || str.charAt((int)(j - true)) == '\\')) break;
                }
                i = j$iv;
                continue;
            }
            if (currentChar == ':') {
                if (spaceAfterColon) {
                    ++newWhitespaces;
                }
                if (!spaceBeforeColon) continue;
                ++newWhitespaces;
                continue;
            }
            if (currentChar == '{' || currentChar == ',' || currentChar == '[') {
                ++newWhitespaces;
                switch (currentChar) {
                    case '[': 
                    case '{': {
                        ++indent;
                    }
                }
                newWhitespaces += indentSize * indent;
                continue;
            }
            if (currentChar != '}' && currentChar != ']') continue;
            newWhitespaces += 1 + indentSize * --indent;
        }
        return response2.length() + newWhitespaces - containedWhitespaces;
    }

    /*
     * WARNING - void declaration
     */
    private static final int guessFormattedLengthForXml(String response2, CodeStyleSettings settings, int indentSize) {
        XmlCodeStyleSettings xmlSettings;
        XmlCodeStyleSettings xmlCodeStyleSettings = xmlSettings = (XmlCodeStyleSettings)settings.getCustomSettingsIfCreated(XmlCodeStyleSettings.class);
        boolean spacesAroundEquality = xmlCodeStyleSettings != null ? xmlCodeStyleSettings.XML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE : false;
        int newWhitespaces = 0;
        int indent = 0;
        boolean insideTag = false;
        int containedWhitespaces = 0;
        int heightOfLastOpen = 0;
        for (int i = 0; i < response2.length(); ++i) {
            int j;
            String str;
            int j$iv;
            boolean $i$f$indexOfFirstNot;
            Character c;
            char currentChar = response2.charAt(i);
            Integer n = i;
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = it < response2.length() - 1 ? n : null;
            if (n2 != null) {
                it = ((Number)n2).intValue();
                boolean bl2 = false;
                c = Character.valueOf(response2.charAt(it + 1));
            } else {
                c = null;
            }
            Character nextChar = c;
            if (CharsKt.isWhitespace((char)currentChar)) {
                ++containedWhitespaces;
                continue;
            }
            if (currentChar == '\"' && insideTag) {
                void $this$indexOfFirstNot$iv;
                String string = response2;
                int from$iv = i + 1;
                $i$f$indexOfFirstNot = false;
                for (j$iv = from$iv; j$iv < $this$indexOfFirstNot$iv.length(); ++j$iv) {
                    int n3 = j$iv;
                    str = $this$indexOfFirstNot$iv;
                    boolean bl3 = false;
                    if (!(str.charAt(j) != '\"')) break;
                }
                i = j$iv;
                continue;
            }
            if (currentChar == '\'' && insideTag) {
                String $this$indexOfFirstNot$iv = response2;
                int from$iv = i + 1;
                $i$f$indexOfFirstNot = false;
                for (j$iv = from$iv; j$iv < $this$indexOfFirstNot$iv.length(); ++j$iv) {
                    j = j$iv;
                    str = $this$indexOfFirstNot$iv;
                    boolean bl4 = false;
                    if (!(str.charAt(j) != '\'')) break;
                }
                i = j$iv;
                continue;
            }
            if (StringsKt.startsWith$default((String)response2, (String)CDATA_BEGIN, (int)i, (boolean)false, (int)4, null)) {
                String $this$indexOfFirstNot$iv = response2;
                int from$iv = i + 9;
                $i$f$indexOfFirstNot = false;
                for (j$iv = from$iv; j$iv < $this$indexOfFirstNot$iv.length(); ++j$iv) {
                    j = j$iv;
                    str = $this$indexOfFirstNot$iv;
                    boolean bl5 = false;
                    if (!(!StringsKt.startsWith$default((String)str, (String)CDATA_END, (int)j, (boolean)false, (int)4, null))) break;
                }
                i = j$iv + 3 - 1;
                continue;
            }
            if (currentChar == '<') {
                Character c2 = nextChar;
                char $this$indexOfFirstNot$iv = '/';
                if (c2 != null && c2.charValue() == $this$indexOfFirstNot$iv) {
                    if (heightOfLastOpen == --indent) continue;
                    newWhitespaces += indent * indentSize + 1;
                    continue;
                }
            }
            if (currentChar == '<') {
                heightOfLastOpen = indent;
                newWhitespaces += indentSize * indent + 1;
                ++indent;
                insideTag = true;
                continue;
            }
            if (currentChar == '/') {
                Character c3 = nextChar;
                char $this$indexOfFirstNot$iv = '>';
                if (c3 != null && c3.charValue() == $this$indexOfFirstNot$iv) {
                    insideTag = false;
                    --indent;
                    continue;
                }
            }
            if (currentChar == '=' && insideTag) {
                newWhitespaces += spacesAroundEquality ? 3 : 1;
                continue;
            }
            if (currentChar != '>') continue;
            insideTag = false;
            String $this$indexOfFirstNot$iv = response2;
            int from$iv = i;
            $i$f$indexOfFirstNot = false;
            for (j$iv = from$iv; j$iv < $this$indexOfFirstNot$iv.length(); ++j$iv) {
                j = j$iv;
                str = $this$indexOfFirstNot$iv;
                boolean bl6 = false;
                if (!(j < StringsKt.getLastIndex((CharSequence)str) && str.charAt(j + 1) != '<')) break;
            }
            i = j$iv;
        }
        return response2.length() - containedWhitespaces + newWhitespaces - (newWhitespaces != 0 ? 1 : 0);
    }

    private static final int indexOfFirstNot(String $this$indexOfFirstNot, int from2, Function2<? super String, ? super Integer, Boolean> predicate) {
        int j;
        boolean $i$f$indexOfFirstNot = false;
        for (j = from2; j < $this$indexOfFirstNot.length() && ((Boolean)predicate.invoke((Object)$this$indexOfFirstNot, (Object)j)).booleanValue(); ++j) {
        }
        return j;
    }

    static /* synthetic */ int indexOfFirstNot$default(String $this$indexOfFirstNot_u24default, int from2, Function2 predicate, int n, Object object) {
        int j;
        if ((n & 1) != 0) {
            from2 = 0;
        }
        boolean $i$f$indexOfFirstNot = false;
        for (j = from2; j < $this$indexOfFirstNot_u24default.length() && ((Boolean)predicate.invoke((Object)$this$indexOfFirstNot_u24default, (Object)j)).booleanValue(); ++j) {
        }
        return j;
    }
}

