/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.httpClient.http.request.HttpRequestFileType;
import com.intellij.httpClient.http.request.psi.HttpVariable;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.annotations.NotNull;

public class HttpSuffixInsertHandler
implements InsertHandler<LookupElement> {
    public static final HttpSuffixInsertHandler HEADER_OPTION = new HttpSuffixInsertHandler("=");
    public static final HttpSuffixInsertHandler SCHEME = new HttpSuffixInsertHandler("://");
    public static final HttpSuffixInsertHandler FIELD_SEPARATOR = new HttpSuffixInsertHandler(": ");
    private final String mySuffix;
    private final String myShortSuffix;

    public HttpSuffixInsertHandler(@NotNull String suffix) {
        if (suffix == null) {
            HttpSuffixInsertHandler.$$$reportNull$$$0(0);
        }
        this.mySuffix = suffix;
        this.myShortSuffix = suffix.trim();
    }

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        if (context2 == null) {
            HttpSuffixInsertHandler.$$$reportNull$$$0(1);
        }
        if (item == null) {
            HttpSuffixInsertHandler.$$$reportNull$$$0(2);
        }
        Project project = context2.getProject();
        Editor editor2 = HttpSuffixInsertHandler.getHttpFileEditor(context2);
        if (editor2 == null) {
            return;
        }
        Document document = editor2.getDocument();
        int offset = StringUtil.skipWhitespaceForward((CharSequence)document.getCharsSequence(), (int)editor2.getCaretModel().getOffset());
        if (document.getTextLength() == offset || !this.isEqualsToSuffix(document, offset)) {
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor2, (String)this.mySuffix);
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor2.getDocument());
        }
        editor2.getCaretModel().moveToOffset(offset + this.mySuffix.length());
    }

    private static Editor getHttpFileEditor(@NotNull InsertionContext context2) {
        if (context2 == null) {
            HttpSuffixInsertHandler.$$$reportNull$$$0(3);
        }
        if (context2.getFile().getFileType() == HttpRequestFileType.INSTANCE) {
            return context2.getEditor();
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)context2.getProject());
        PsiLanguageInjectionHost host = manager.getInjectionHost((PsiElement)context2.getFile());
        if (host instanceof HttpVariable) {
            return ((EditorWindow)context2.getEditor()).getDelegate();
        }
        return null;
    }

    private boolean isEqualsToSuffix(@NotNull Document document, int offset) {
        if (document == null) {
            HttpSuffixInsertHandler.$$$reportNull$$$0(4);
        }
        int endOffset = offset + this.myShortSuffix.length() - 1;
        if (document.getTextLength() <= endOffset) {
            return false;
        }
        return StringUtil.equals((CharSequence)this.myShortSuffix, (CharSequence)document.getCharsSequence().subSequence(offset, endOffset + 1).toString());
    }

    public String getSuffix() {
        return this.mySuffix;
    }

    public String toString() {
        return this.mySuffix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/http/request/completion/HttpSuffixInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getHttpFileEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isEqualsToSuffix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

