/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase;

import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.execution.rmi.RemoteObject;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlBaseErrorHandler
extends BaseDatabaseErrorHandler {
    @Override
    @NotNull
    protected ErrorInfo getErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
        if (original == null) {
            MysqlBaseErrorHandler.$$$reportNull$$$0(0);
        }
        if (cause == null) {
            MysqlBaseErrorHandler.$$$reportNull$$$0(1);
        }
        if (this.isPasswordExpired(original)) {
            return new BaseDatabaseErrorHandler.PasswordExpiredErrorInfo(dataSource, original, cause);
        }
        if (original instanceof SQLException && "08S01".equals(((SQLException)original).getSQLState())) {
            String className;
            Throwable next = original.getCause();
            String string = className = next instanceof RemoteObject.ForeignException ? ((RemoteObject.ForeignException)next).getOriginalClassName() : null;
            if (className != null && className.contains("CJCommunicationsException") && (next = next.getCause()) != null) {
                original = next;
            }
        }
        ErrorInfo errorInfo = super.getErrorInfo(dataSource, original, cause);
        if (errorInfo == null) {
            MysqlBaseErrorHandler.$$$reportNull$$$0(2);
        }
        return errorInfo;
    }

    @Override
    public int getErrorOffset(@NotNull Project project, @NotNull ErrorInfo errorInfo, @NotNull String queryText) {
        if (project == null) {
            MysqlBaseErrorHandler.$$$reportNull$$$0(3);
        }
        if (errorInfo == null) {
            MysqlBaseErrorHandler.$$$reportNull$$$0(4);
        }
        if (queryText == null) {
            MysqlBaseErrorHandler.$$$reportNull$$$0(5);
        }
        BaseDatabaseErrorHandler.OffsetInfo offsetInfo = new BaseDatabaseErrorHandler.OffsetInfoBuilder(errorInfo.getMessage(), "\\bnear '([^']*)' at line (\\d+)\\z").groupNear(1).groupLine(2).build();
        return MysqlBaseErrorHandler.getOffsetImpl(offsetInfo, queryText, StringUtil::indexOfIgnoreCase);
    }

    public boolean isPasswordExpired(@NotNull Throwable e) {
        Throwable cause;
        if (e == null) {
            MysqlBaseErrorHandler.$$$reportNull$$$0(6);
        }
        String message = GridUtilCore.getLongMessage((Throwable)((cause = e.getCause()) == null ? e : cause));
        return message.contains("ClosedOnExpiredPasswordException") || message.contains("password has expired");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mysqlbase/MysqlBaseErrorHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mysqlbase/MysqlBaseErrorHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorInfo";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getErrorOffset";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPasswordExpired";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

