/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mlapi.model.pipeline;

import com.jetbrains.mlapi.model.pipeline.ActualFile;
import com.jetbrains.mlapi.model.pipeline.VFSNode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016R!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/mlapi/model/pipeline/ActualDirectory;", "Lcom/jetbrains/mlapi/model/pipeline/VFSNode$Directory;", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "children", "", "Lcom/jetbrains/mlapi/model/pipeline/VFSNode;", "getChildren", "()Ljava/util/List;", "children$delegate", "Lkotlin/Lazy;", "toString", "", "mlapi-core"})
final class ActualDirectory
extends VFSNode.Directory {
    @NotNull
    private final Path path;
    @NotNull
    private final Lazy children$delegate;

    public ActualDirectory(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        super(PathsKt.getName((Path)path));
        this.path = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(this.path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean $i$a$-require-ActualDirectory$32 = false;
            String $i$a$-require-ActualDirectory$32 = "Directory " + this.path + " does not exist";
            throw new IllegalArgumentException($i$a$-require-ActualDirectory$32.toString());
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isDirectory(this.path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            boolean bl = false;
            String string = "Path " + this.path + " was expected to be a directory";
            throw new IllegalArgumentException(string.toString());
        }
        this.children$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends VFSNode>>(this){
            final /* synthetic */ ActualDirectory this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<VFSNode> invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = PathsKt.listDirectoryEntries$default((Path)ActualDirectory.access$getPath$p(this.this$0), null, (int)1, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    VFSNode vFSNode;
                    void directoryEntity;
                    Path path = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.isDirectory((Path)directoryEntity, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        vFSNode = new ActualDirectory((Path)directoryEntity);
                    } else {
                        LinkOption[] linkOptionArray2 = new LinkOption[]{};
                        if (Files.isRegularFile((Path)directoryEntity, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                            vFSNode = new ActualFile((Path)directoryEntity);
                        } else {
                            throw new IllegalStateException(("Directory entity " + (Path)directoryEntity + " is not a file or directory").toString());
                        }
                    }
                    collection.add(vFSNode);
                }
                return (List)destination$iv$iv;
            }
        }));
    }

    @Override
    @NotNull
    public List<VFSNode> getChildren() {
        Lazy lazy = this.children$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public String toString() {
        return this.getName() + "(n_children=" + this.getChildren().size() + ")";
    }

    public static final /* synthetic */ Path access$getPath$p(ActualDirectory $this) {
        return $this.path;
    }
}

