/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.library.ui.JSScriptingContextProvider;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.AttachRootButtonDescriptor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRootTypePresentation;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import icons.JavaScriptLanguageIcons;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLibraryRootsComponentDescriptor
extends LibraryRootsComponentDescriptor {
    private final JSScriptingContextProvider myProvider = new JSScriptingContextProvider();
    private String myDefaultDocUrl;

    public OrderRootTypePresentation getRootTypePresentation(@NotNull OrderRootType type2) {
        if (type2 == null) {
            JSLibraryRootsComponentDescriptor.$$$reportNull$$$0(0);
        }
        if (type2 == OrderRootType.CLASSES) {
            return new OrderRootTypePresentation(this.myProvider.getLibraryTypeName(OrderRootType.CLASSES), JavaScriptLanguageIcons.Library.JsCompact);
        }
        if (type2 == OrderRootType.SOURCES) {
            return new OrderRootTypePresentation(this.myProvider.getLibraryTypeName(OrderRootType.SOURCES), AllIcons.Nodes.Package);
        }
        if (type2 == OrderRootType.DOCUMENTATION) {
            return new OrderRootTypePresentation(JavaScriptBundle.message("js.library.documentation", new Object[0]), AllIcons.Nodes.JavaDocFolder);
        }
        return null;
    }

    @NotNull
    public FileChooserDescriptor createAttachFilesChooserDescriptor(String libraryName) {
        return new LibFileChooserDescriptor(true);
    }

    @NotNull
    public List<? extends RootDetector> getRootDetectors() {
        List<JSLibraryRootsDetector> list = Arrays.asList(new JSLibraryRootsDetector(OrderRootType.CLASSES, true), new JSLibraryRootsDetector(OrderRootType.SOURCES, false));
        if (list == null) {
            JSLibraryRootsComponentDescriptor.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<? extends AttachRootButtonDescriptor> createAttachButtons() {
        ArrayList<AttachRootButtonDescriptor> myButtonDescriptors = new ArrayList<AttachRootButtonDescriptor>();
        myButtonDescriptors.add(new AttachFromButtonDescriptor(OrderRootType.SOURCES, JavaScriptBundle.message("js.library.attach.debug", new Object[0])));
        myButtonDescriptors.add(new AttachFromButtonDescriptor(OrderRootType.CLASSES, JavaScriptBundle.message("js.library.attach.release", new Object[0])));
        myButtonDescriptors.add(new AttachUrlDocDescriptor());
        ArrayList<AttachRootButtonDescriptor> arrayList = myButtonDescriptors;
        if (arrayList == null) {
            JSLibraryRootsComponentDescriptor.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private void collectFilesRecursively(final List<VirtualFile> collectedFiles, VirtualFile dir, final OrderRootType rootType) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)dir, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!file.isDirectory() && JSLibraryRootsComponentDescriptor.this.myProvider.acceptsExtension(file.getExtension())) {
                    OrderRootType fileRootType;
                    OrderRootType orderRootType = fileRootType = JSLibraryRootsComponentDescriptor.this.myProvider.isCompact(file) ? OrderRootType.CLASSES : OrderRootType.SOURCES;
                    if (fileRootType == rootType) {
                        collectedFiles.add(file);
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$1", "visitFile"));
            }
        });
    }

    public OrderRootType[] getRootTypes() {
        ArrayList<OrderRootType> rootTypes = new ArrayList<OrderRootType>();
        rootTypes.addAll(Arrays.asList(super.getRootTypes()));
        rootTypes.addAll(Arrays.asList(this.myProvider.getLibraryKind().getAdditionalRootTypes()));
        return rootTypes.toArray(new OrderRootType[0]);
    }

    @Nullable
    private String getDefaultDocUrl(LibraryEditor libraryEditor) {
        if (this.myDefaultDocUrl == null) {
            for (OrderRootType rootType : this.getRootTypes()) {
                for (VirtualFile file : libraryEditor.getFiles(rootType)) {
                    ScriptingFrameworkDescriptor framework = this.myProvider.detectFramework(file);
                    if (framework == null) continue;
                    this.myDefaultDocUrl = this.myProvider.getDefaultDocUrl(framework);
                    return this.myDefaultDocUrl;
                }
            }
        }
        return this.myDefaultDocUrl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDetectors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachButtons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootTypePresentation";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private class LibFileChooserDescriptor
    extends FileChooserDescriptor {
        LibFileChooserDescriptor(boolean chooseMultiple) {
            super(true, true, false, true, false, chooseMultiple);
            String[] extensions = JSLibraryRootsComponentDescriptor.this.myProvider.getExtensions();
            if (extensions.length > 0) {
                this.withExtensionFilter(ProjectBundle.message((String)"library.attach.files.label", (Object[])new Object[0]), extensions);
            }
        }
    }

    private final class JSLibraryRootsDetector
    extends RootDetector {
        private final boolean myCompact;

        private JSLibraryRootsDetector(OrderRootType rootType, boolean compact) {
            super(rootType, false, JSLibraryRootsComponentDescriptor.this.myProvider.getLibraryTypeName(rootType));
            this.myCompact = compact;
        }

        @NotNull
        public Collection<VirtualFile> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
            if (rootCandidate == null) {
                JSLibraryRootsDetector.$$$reportNull$$$0(0);
            }
            if (progressIndicator == null) {
                JSLibraryRootsDetector.$$$reportNull$$$0(1);
            }
            ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
            this.collectRecursively(rootCandidate, result2, progressIndicator);
            ArrayList<VirtualFile> arrayList = result2;
            if (arrayList == null) {
                JSLibraryRootsDetector.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        private void collectRecursively(VirtualFile file, final List<VirtualFile> result2, final ProgressIndicator progressIndicator) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (file.isDirectory()) {
                        progressIndicator.setText2(file.getPresentableUrl());
                        progressIndicator.checkCanceled();
                    } else if (JSLibraryRootsComponentDescriptor.this.myProvider.acceptsExtension(file.getExtension()) && JSLibraryRootsDetector.this.myCompact == JSLibraryRootsComponentDescriptor.this.myProvider.isCompact(file)) {
                        result2.add(file);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$JSLibraryRootsDetector$1", "visitFile"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootCandidate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$JSLibraryRootsDetector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$JSLibraryRootsDetector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "detectRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "detectRoots";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private class AttachFromButtonDescriptor
    extends AttachRootButtonDescriptor {
        protected AttachFromButtonDescriptor(@NlsContexts.Button @NotNull OrderRootType orderRootType, String buttonText) {
            if (orderRootType == null) {
                AttachFromButtonDescriptor.$$$reportNull$$$0(0);
            }
            if (buttonText == null) {
                AttachFromButtonDescriptor.$$$reportNull$$$0(1);
            }
            super(orderRootType, buttonText);
        }

        public VirtualFile[] selectFiles(@NotNull JComponent parent, @Nullable VirtualFile initialSelection, @Nullable Module contextModule, @Nullable LibraryEditor libraryEditor) {
            Project project;
            if (parent == null) {
                AttachFromButtonDescriptor.$$$reportNull$$$0(2);
            }
            ArrayList<VirtualFile> collectedFiles = new ArrayList<VirtualFile>();
            FileChooserDescriptor chooserDescriptor = new LibFileChooserDescriptor(false).withTitle(JavaScriptBundle.message("js.library.select." + (this.getRootType() == OrderRootType.SOURCES ? "debug" : "release"), new Object[0]));
            VirtualFile chosenFile = FileChooser.chooseFile((FileChooserDescriptor)chooserDescriptor, (Component)parent, (Project)(project = contextModule != null ? contextModule.getProject() : null), null);
            if (chosenFile != null && chosenFile.isValid()) {
                if (chosenFile.isDirectory()) {
                    JSLibraryRootsComponentDescriptor.this.collectFilesRecursively(collectedFiles, chosenFile, this.getRootType());
                } else {
                    collectedFiles.add(chosenFile);
                }
            }
            for (VirtualFile file : collectedFiles) {
                ScriptingFrameworkDescriptor framework = JSLibraryRootsComponentDescriptor.this.myProvider.detectFramework(file);
                if (framework == null) continue;
                JSLibraryRootsComponentDescriptor.this.myDefaultDocUrl = JSLibraryRootsComponentDescriptor.this.myProvider.getDefaultDocUrl(framework);
                break;
            }
            return VfsUtilCore.toVirtualFileArray(collectedFiles);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "orderRootType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buttonText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$AttachFromButtonDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectFiles";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class AttachUrlDocDescriptor
    extends AttachRootButtonDescriptor {
        private AttachUrlDocDescriptor() {
            super(OrderRootType.DOCUMENTATION, ProjectBundle.message((String)"module.libraries.javadoc.url.button", (Object[])new Object[0]));
        }

        public VirtualFile[] selectFiles(@NotNull JComponent parent, @Nullable VirtualFile initialSelection, @Nullable Module contextModule, @Nullable LibraryEditor libraryEditor) {
            VirtualFile[] virtualFileArray;
            VirtualFile vFile;
            if (parent == null) {
                AttachUrlDocDescriptor.$$$reportNull$$$0(0);
            }
            if ((vFile = Util.showSpecifyJavadocUrlDialog((JComponent)parent, (String)JSLibraryRootsComponentDescriptor.this.getDefaultDocUrl(libraryEditor))) != null) {
                VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                virtualFileArray = virtualFileArray2;
                virtualFileArray2[0] = vFile;
            } else {
                virtualFileArray = VirtualFile.EMPTY_ARRAY;
            }
            return virtualFileArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$AttachUrlDocDescriptor", "selectFiles"));
        }
    }
}

