/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.jsx;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.generation.IndentedCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.CustomUncommenter;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.editing.JavascriptCommenter;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.templateLanguages.MultipleLangCommentProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import com.intellij.util.text.CharArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXCommentProvider
implements MultipleLangCommentProvider {
    @Nullable
    public Commenter getLineCommenter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Language lineStartLanguage, @NotNull Language lineEndLanguage) {
        PsiElement at;
        if (file == null) {
            JSXCommentProvider.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JSXCommentProvider.$$$reportNull$$$0(1);
        }
        if (lineStartLanguage == null) {
            JSXCommentProvider.$$$reportNull$$$0(2);
        }
        if (lineEndLanguage == null) {
            JSXCommentProvider.$$$reportNull$$$0(3);
        }
        return JSXCommentProvider.isTagBodyContext(at = JSXCommentProvider.findFirstElementOnLine(file, editor)) ? new JSXCommenter(file) : new JavascriptCommenter();
    }

    public static boolean isTagBodyContext(@Nullable PsiElement at) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)at, XmlTag.class, (boolean)false);
        JSEmbeddedContent script = JSXCommentProvider.notAtScriptStart(at) ? (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)at, JSEmbeddedContent.class, (boolean)false, (Class[])new Class[]{XmlTag.class}) : null;
        return tag != null && !(at.getParent() instanceof XmlAttribute) && !(at instanceof PsiComment) && script == null && (tag.getParentTag() != null || at.getTextOffset() != tag.getTextOffset()) || JSXCommentProvider.isJsxComment(at);
    }

    private static boolean notAtScriptStart(PsiElement at) {
        return at != null && (!JSTokenTypes.LBRACES.contains(at.getNode().getElementType()) || !(at.getParent() instanceof JSEmbeddedContent));
    }

    private static boolean isJsxComment(@Nullable PsiElement at) {
        PsiElement parent = at != null ? at.getParent() : null;
        return parent instanceof JSObjectLiteralExpression && ((JSObjectLiteralExpression)parent).getFirstProperty() == null && at.getNextSibling() instanceof PsiComment;
    }

    @Nullable
    protected static PsiElement findFirstElementOnLine(@NotNull PsiFile file, @NotNull Editor editor) {
        int number;
        Document document;
        int offset;
        PsiElement at;
        if (file == null) {
            JSXCommentProvider.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            JSXCommentProvider.$$$reportNull$$$0(5);
        }
        if ((at = file.findElementAt(offset = (document = editor.getDocument()).getLineStartOffset(number = document.getLineNumber(editor.getSelectionModel().getSelectionStart())))) instanceof PsiWhiteSpace) {
            PsiElement next = PsiTreeUtil.nextVisibleLeaf((PsiElement)at);
            return next != null && document.getLineNumber(next.getTextRange().getStartOffset()) == number ? next : at;
        }
        return at;
    }

    public boolean canProcess(@NotNull PsiFile file, @NotNull FileViewProvider viewProvider) {
        if (file == null) {
            JSXCommentProvider.$$$reportNull$$$0(6);
        }
        if (viewProvider == null) {
            JSXCommentProvider.$$$reportNull$$$0(7);
        }
        return DialectDetector.isJSX((PsiElement)file) && DialectDetector.hasJSSyntax((PsiElement)file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineStartLanguage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineEndLanguage";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/frameworks/jsx/JSXCommentProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineCommenter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findFirstElementOnLine";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class JSXCommenter
    extends JavascriptCommenter
    implements CustomUncommenter,
    IndentedCommenter {
        @NotNull
        private final PsiFile myFile;

        public JSXCommenter(@NotNull PsiFile file) {
            if (file == null) {
                JSXCommenter.$$$reportNull$$$0(0);
            }
            this.myFile = file;
        }

        @Override
        public String getLineCommentPrefix() {
            return null;
        }

        @Override
        @NotNull
        public String getBlockCommentPrefix() {
            return "{/*";
        }

        @Override
        @NotNull
        public String getBlockCommentSuffix() {
            return "*/}";
        }

        @Nullable
        public TextRange findMaximumCommentedRange(@NotNull CharSequence text) {
            if (text == null) {
                JSXCommenter.$$$reportNull$$$0(1);
            }
            int start = CharArrayUtil.indexOf((CharSequence)text, (CharSequence)this.getBlockCommentPrefix(), (int)0);
            int end = CharArrayUtil.lastIndexOf((CharSequence)text, (String)this.getBlockCommentSuffix(), (int)text.length());
            return start >= 0 && end >= start ? new TextRange(start, end + this.getBlockCommentSuffix().length()) : null;
        }

        @NotNull
        public Collection<? extends Couple<TextRange>> getCommentRangesToDelete(@NotNull CharSequence text) {
            if (text == null) {
                JSXCommenter.$$$reportNull$$$0(2);
            }
            CommonCodeStyleSettings settings = CodeStyle.getLanguageSettings((PsiFile)this.myFile);
            SmartList result2 = new SmartList();
            int start = 0;
            int end = 0;
            while (start >= 0 && end >= start) {
                start = CharArrayUtil.indexOf((CharSequence)text, (CharSequence)this.getBlockCommentPrefix(), (int)end);
                end = CharArrayUtil.indexOf((CharSequence)text, (CharSequence)this.getBlockCommentSuffix(), (int)start);
                if (start < 0 || end < start) continue;
                TextRange prefix = TextRange.from((int)start, (int)this.getBlockCommentPrefix().length());
                TextRange suffix = TextRange.from((int)end, (int)this.getBlockCommentSuffix().length());
                if (settings.BLOCK_COMMENT_ADD_SPACE) {
                    if (StringUtil.isChar((CharSequence)text, (int)prefix.getEndOffset(), (char)' ')) {
                        prefix = prefix.grown(1);
                    }
                    int suffixSpaceIdx = suffix.getStartOffset() - 1;
                    if (prefix.getEndOffset() <= suffixSpaceIdx && StringUtil.isChar((CharSequence)text, (int)suffixSpaceIdx, (char)' ')) {
                        suffix = TextRange.create((int)suffixSpaceIdx, (int)suffix.getEndOffset());
                    }
                }
                result2.add((Object)Couple.of((Object)prefix, (Object)suffix));
            }
            SmartList smartList = result2;
            if (smartList == null) {
                JSXCommenter.$$$reportNull$$$0(3);
            }
            return smartList;
        }

        @Nullable
        public Boolean forceIndentedLineComment() {
            return Boolean.TRUE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/frameworks/jsx/JSXCommentProvider$JSXCommenter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/frameworks/jsx/JSXCommentProvider$JSXCommenter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommentRangesToDelete";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findMaximumCommentedRange";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommentRangesToDelete";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

