/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u001a\"\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0007\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\nH\u0000\u001a\u001c\u0010\u000b\u001a\u00020\f*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\nH\u0000\u001a\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u001a\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u001a\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007\u001a\u0014\u0010\u0014\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\r\u001a\u00020\nH\u0007\u001a\u0014\u0010\u0014\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\u0015\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0006H\u0002\u001a\u001d\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0012H\u0000\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"setSourceFile", "", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/docker/DockerDeploymentConfiguration;", "sourceFile", "Ljava/io/File;", "setManySourceFiles", "sourceFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "isForSameFile", "", "file", "getSourceFile", "resolvePath", "Ljava/nio/file/Path;", "path", "", "resolveFile", "getPathToStore", "makeProjectRelative", "ioFile", "splitTags", "", "allTagsJoined", "(Ljava/lang/String;)[Ljava/lang/String;", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerDeploymentConfigurationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerDeploymentConfigurationUtils.kt\ncom/intellij/docker/DockerDeploymentConfigurationUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,90:1\n1#2:91\n1563#3:92\n1634#3,3:93\n37#4:96\n36#4,3:97\n37#4:103\n36#4,3:104\n3829#5:100\n4344#5,2:101\n*S KotlinDebug\n*F\n+ 1 DockerDeploymentConfigurationUtils.kt\ncom/intellij/docker/DockerDeploymentConfigurationUtilsKt\n*L\n34#1:92\n34#1:93,3\n81#1:96\n81#1:97,3\n85#1:103\n85#1:104,3\n85#1:100\n85#1:101,2\n*E\n"})
public final class DockerDeploymentConfigurationUtilsKt {
    /*
     * WARNING - void declaration
     */
    public static final void setSourceFile(@NotNull Project $this$setSourceFile, @NotNull DockerDeploymentConfiguration model, @Nullable File sourceFile) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$setSourceFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        DockerDeploymentConfiguration dockerDeploymentConfiguration = model;
        File file = sourceFile;
        if (file != null) {
            void p0;
            File file2 = file;
            DockerDeploymentConfiguration dockerDeploymentConfiguration2 = dockerDeploymentConfiguration;
            boolean bl = false;
            string = DockerDeploymentConfigurationUtilsKt.getPathToStore($this$setSourceFile, (File)p0);
            dockerDeploymentConfiguration = dockerDeploymentConfiguration2;
        } else {
            string = null;
        }
        dockerDeploymentConfiguration.setSourceFilePath(string);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static final void setManySourceFiles(@NotNull Project $this$setManySourceFiles, @NotNull DockerDeploymentConfiguration model, @NotNull List<? extends File> sourceFiles) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$setManySourceFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
        File mainFile = null;
        List<? extends File> secondaryFiles = null;
        if (sourceFiles.isEmpty()) {
            mainFile = null;
            secondaryFiles = CollectionsKt.emptyList();
        } else {
            mainFile = sourceFiles.get(0);
            secondaryFiles = sourceFiles.subList(1, sourceFiles.size());
        }
        DockerDeploymentConfigurationUtilsKt.setSourceFile($this$setManySourceFiles, model, mainFile);
        Iterable iterable = secondaryFiles;
        DockerDeploymentConfiguration dockerDeploymentConfiguration = model;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DockerDeploymentConfigurationUtilsKt.getPathToStore($this$setManySourceFiles, (File)p0));
        }
        dockerDeploymentConfiguration.setSecondarySourceFiles(CollectionsKt.toMutableList((Collection)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    public static final void setSourceFile(@NotNull Project $this$setSourceFile, @NotNull DockerDeploymentConfiguration model, @Nullable VirtualFile sourceFile) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$setSourceFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        DockerDeploymentConfiguration dockerDeploymentConfiguration = model;
        VirtualFile virtualFile = sourceFile;
        if (virtualFile != null) {
            void p0;
            VirtualFile virtualFile2 = virtualFile;
            DockerDeploymentConfiguration dockerDeploymentConfiguration2 = dockerDeploymentConfiguration;
            boolean bl = false;
            string = DockerDeploymentConfigurationUtilsKt.getPathToStore($this$setSourceFile, (VirtualFile)p0);
            dockerDeploymentConfiguration = dockerDeploymentConfiguration2;
        } else {
            string = null;
        }
        dockerDeploymentConfiguration.setSourceFilePath(string);
    }

    public static final boolean isForSameFile(@NotNull Project $this$isForSameFile, @NotNull DockerDeploymentConfiguration model, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$isForSameFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FileUtil.filesEqual((File)VfsUtilCore.virtualToIoFile((VirtualFile)file), (File)DockerDeploymentConfigurationUtilsKt.getSourceFile($this$isForSameFile, model));
    }

    @ApiStatus.Internal
    @Nullable
    public static final File getSourceFile(@NotNull Project $this$getSourceFile, @NotNull DockerDeploymentConfiguration model) {
        Intrinsics.checkNotNullParameter((Object)$this$getSourceFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        String string = StringKt.nullize((String)model.getSourceFilePath(), (boolean)true);
        if (string == null) {
            return null;
        }
        String path2 = string;
        Path path3 = DockerDeploymentConfigurationUtilsKt.resolvePath($this$getSourceFile, path2);
        return path3 != null ? path3.toFile() : null;
    }

    @Nullable
    public static final Path resolvePath(@NotNull Project $this$resolvePath, @Nullable String path2) {
        Object object;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)$this$resolvePath, (String)"<this>");
                object = path2;
                if (object == null || (object = StringKt.nullize((String)object, (boolean)true)) == null) break block5;
                String p0 = object;
                boolean bl = false;
                String string = FileUtil.toSystemIndependentName((String)p0);
                object = string;
                if (string == null) break block5;
                String p02 = object;
                boolean bl2 = false;
                Path path3 = Paths.get(p02, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
                object = path3;
                if (path3 != null) break block6;
            }
            return null;
        }
        Object file = object;
        String string = $this$resolvePath.getBasePath();
        if (string == null) {
            return file;
        }
        String projectBasePath = string;
        if (file.isAbsolute()) {
            return file;
        }
        String[] stringArray = new String[]{file.toString()};
        Path path4 = Paths.get(projectBasePath, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
        return path4;
    }

    @Nullable
    public static final File resolveFile(@NotNull Project $this$resolveFile, @Nullable String path2) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveFile, (String)"<this>");
        Path path3 = DockerDeploymentConfigurationUtilsKt.resolvePath($this$resolveFile, path2);
        return path3 != null ? path3.toFile() : null;
    }

    @Deprecated(message="use 'resolveFile' instead", replaceWith=@ReplaceWith(expression="resolveFile(path)", imports={}))
    @Nullable
    public static final File getSourceFile(@NotNull Project $this$getSourceFile, @Nullable String path2) {
        Intrinsics.checkNotNullParameter((Object)$this$getSourceFile, (String)"<this>");
        return DockerDeploymentConfigurationUtilsKt.resolveFile($this$getSourceFile, path2);
    }

    @ApiStatus.Internal
    @NotNull
    public static final String getPathToStore(@NotNull Project $this$getPathToStore, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$getPathToStore, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"virtualToIoFile(...)");
        return DockerDeploymentConfigurationUtilsKt.getPathToStore($this$getPathToStore, file2);
    }

    @NotNull
    public static final String getPathToStore(@NotNull Project $this$getPathToStore, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$getPathToStore, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = FileUtil.toSystemIndependentName((String)DockerDeploymentConfigurationUtilsKt.makeProjectRelative($this$getPathToStore, file));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        return string;
    }

    private static final String makeProjectRelative(Project $this$makeProjectRelative, File ioFile) {
        String string;
        block3: {
            block2: {
                string = $this$makeProjectRelative.getBasePath();
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string2 = FileUtil.getRelativePath((File)new File(it), (File)ioFile);
                string = string2;
                if (string2 != null) break block3;
            }
            String string3 = ioFile.getAbsolutePath();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String[] splitTags(@Nullable String allTagsJoined) {
        CharSequence charSequence = allTagsJoined;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_STRING_ARRAY, (String)"EMPTY_STRING_ARRAY");
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        CharSequence charSequence2 = allTagsJoined;
        Regex regex = new Regex("(\\s|,)+");
        int n = 0;
        Collection $this$toTypedArray$iv = regex.split(charSequence2, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] result2 = thisCollection$iv.toArray(new String[0]);
        int n2 = result2.length;
        for (int i = 0; i < n2; ++i) {
            void $this$toTypedArray$iv2;
            void $this$filterTo$iv$iv;
            String next = result2[i];
            if (!StringsKt.isBlank((CharSequence)next)) continue;
            Object $this$filter$iv = result2;
            boolean $i$f$filter = false;
            String[] stringArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n3 = ((void)$this$filterTo$iv$iv).length;
            for (int j = 0; j < n3; ++j) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[j];
                boolean bl = false;
                if (!StringsKt.isBlank((CharSequence)((CharSequence)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray2 = false;
            void thisCollection$iv2 = $this$toTypedArray$iv2;
            return thisCollection$iv2.toArray(new String[0]);
        }
        return result2;
    }
}

