/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.vcs;

import com.intellij.diagram.ChangeTracker;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.extras.EditNodeHandler;
import com.intellij.diagram.vcs.UmlDiffElement;
import com.intellij.diagram.vcs.UmlDiffNodeWithoutTracker;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
public final class DiffUmlExtras
extends DiagramExtras<UmlDiffElement> {
    private static final EditNodeHandler<UmlDiffElement> DIFF_EDIT_HANDLER = new EditNodeHandler<UmlDiffElement>(){

        public void doEdit(DiagramNode<UmlDiffElement> node, DiagramPresentationModel presentationModel) {
            String filename;
            PsiFile after;
            PsiFile before;
            FileType type;
            ChangeTracker tracker = ((UmlDiffElement)node.getIdentifyingElement()).getTracker();
            if (tracker != null) {
                type = tracker.getNotNullFile().getFileType();
                before = tracker.getBefore();
                after = tracker.getAfter();
                filename = tracker.getNotNullFile().getName();
            } else if (node instanceof UmlDiffNodeWithoutTracker) {
                UmlDiffNodeWithoutTracker diffNode = (UmlDiffNodeWithoutTracker)node;
                after = diffNode.getAfter();
                before = diffNode.getBefore();
                Object object = after != null ? after.getFileType() : (type = before != null ? before.getFileType() : null);
                filename = after != null ? after.getName() : (before != null ? before.getName() : null);
            } else {
                type = null;
                before = null;
                after = null;
                filename = null;
            }
            if (filename != null && (after != null || before != null)) {
                Project project = after != null ? after.getProject() : before.getProject();
                DiffContentFactory contentFactory = DiffContentFactory.getInstance();
                EmptyContent content1 = before == null ? contentFactory.createEmpty() : contentFactory.create(project, before.getText(), type, false);
                EmptyContent content2 = after == null ? contentFactory.createEmpty() : contentFactory.create(project, after.getText(), type, false);
                SimpleDiffRequest request = new SimpleDiffRequest(filename, (DiffContent)content1, (DiffContent)content2, null, null);
                DiffManagerEx.getInstance().showDiffBuiltin(project, (DiffRequest)request);
            }
        }
    };

    public void uiDataSnapshot(@NotNull DataSink sink, @NotNull List<DiagramNode<UmlDiffElement>> nodes, @NotNull DiagramBuilder builder) {
        DiagramNode single;
        if (sink == null) {
            DiffUmlExtras.$$$reportNull$$$0(0);
        }
        if (nodes == null) {
            DiffUmlExtras.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            DiffUmlExtras.$$$reportNull$$$0(2);
        }
        if ((single = (DiagramNode)ContainerUtil.getOnlyItem(nodes)) == null) {
            return;
        }
        sink.lazy(CommonDataKeys.NAVIGATABLE, () -> {
            Navigatable o;
            UmlDiffElement diff = (UmlDiffElement)single.getIdentifyingElement();
            PsiNamedElement namedElement = diff.getElement();
            return namedElement instanceof Navigatable ? (o = (Navigatable)namedElement) : null;
        });
    }

    public EditNodeHandler<UmlDiffElement> getEditNodeHandler() {
        return DIFF_EDIT_HANDLER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sink";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "nodes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
        }
        objectArray[1] = "com/intellij/diagram/vcs/DiffUmlExtras";
        objectArray[2] = "uiDataSnapshot";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

