\page ExampleP01 Example P01


## General description

This example shows how to store produced hits in a file using
the 'reflection' technique for persistency provided by the Reflex tool
included in ROOT. The Reflex tool allows to create a dictionary
for the hit class, making then possible to save hit objects in a .root
file. The general simulation setup (geometry, physics list, user
actions, etc...) is taken from ExampleN02. 

The provided makefile produces two executables: 'exampleP01' and
'readHits'. The first one is the actual Geant4 simulation application
with hits persistency. The second one, is just a simple 'reader' for
the produced .root file (you need to specify the name of the .root
file as argument).


## Building and running the example

This examples requires the ROOT toolkit of version 6 to be installed. The
provided CMake file checks for the existence of the package and its version. 
Once the CMake configuration has been succesfully done, the two executables
for this example (exampleP01, readHits) should be built using make 
(in your CMake build directory): 
```
make 
```

When the example is run (using the provided run.mac macro file) the
events are generated and the produced hits will be stored in 
the hits.root file. In addition, the hits will be printed out on the
screen so one can then compare them with the 'reader' output.
        
In order to read the persistified hits, a small 'reader' application
has been implemented. It can be run in the following way:

```
./readHits hits.root
```

where the argument is the name of the file to be read. All the hits
saved in that file will be then read and printed on the screen.

In addition to that the readHits.C ROOT macro file is provided, which
illustrates how one can read the hits file directly from the ROOT
prompt. 

## Remark on dictionary generation

The dictionary is generated by ${ROOTSYS}/bin/genreflex
tool. The arguments that will be used by this tool are configured 
in CMakeLists.txt using the CMake function REFLEX_GENERATE_DICTIONARY
provided by ROOT. They include the header file including headers for
all the classes we want to generate the dictionary, and additionally,
a so called selection file (xml). The role of this file is to
specify which classes we want to generate the dictionary for. The
selection file for our dictionary is in xml/ directory. Please refer
to genreflex manual for more details concerning the usage of that
tool.  

Concerning generating dictionary for the Geant4 objects, there are
also two technical remarks that need to be made here. 
The Reflex tool requires all the templated classes to be
explicitely used somewhere in the included header files in order for
the generation of the dictionary to be possible. For those templated
classes for which it is not the case, the problem can be very easily
solved by instaciating them in the headerfile which is given to
genreflex (see ExP01Classes.hh) as argument.
The second remark is that there is an unfortunate clash of names as
far as G4String class is concerned. The header of G4String class
defines __G4String which happens to be the name of a variable used
within the generated dictionary code. The solution for that is to do
```cpp
#undef __G4String
```
in include/ExP01Classes.hh file.
