package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMediaName invokes the unimkt.ListMediaName API synchronously
func (client *Client) ListMediaName(request *ListMediaNameRequest) (response *ListMediaNameResponse, err error) {
	response = CreateListMediaNameResponse()
	err = client.DoAction(request, response)
	return
}

// ListMediaNameWithChan invokes the unimkt.ListMediaName API asynchronously
func (client *Client) ListMediaNameWithChan(request *ListMediaNameRequest) (<-chan *ListMediaNameResponse, <-chan error) {
	responseChan := make(chan *ListMediaNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMediaName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMediaNameWithCallback invokes the unimkt.ListMediaName API asynchronously
func (client *Client) ListMediaNameWithCallback(request *ListMediaNameRequest, callback func(response *ListMediaNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMediaNameResponse
		var err error
		defer close(result)
		response, err = client.ListMediaName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMediaNameRequest is the request struct for api ListMediaName
type ListMediaNameRequest struct {
	*requests.RpcRequest
	EndCreateTime    requests.Integer `position:"Query" name:"EndCreateTime"`
	Business         string           `position:"Query" name:"Business"`
	Os               string           `position:"Query" name:"Os"`
	MediaStatus      string           `position:"Query" name:"MediaStatus"`
	UserId           string           `position:"Query" name:"UserId"`
	OriginSiteUserId string           `position:"Query" name:"OriginSiteUserId"`
	PageNumber       requests.Integer `position:"Query" name:"PageNumber"`
	MediaName        string           `position:"Query" name:"MediaName"`
	Environment      string           `position:"Query" name:"Environment"`
	AppName          string           `position:"Query" name:"AppName"`
	StartCreateTime  requests.Integer `position:"Query" name:"StartCreateTime"`
	TenantId         string           `position:"Query" name:"TenantId"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	UserSite         string           `position:"Query" name:"UserSite"`
	MediaType        string           `position:"Query" name:"MediaType"`
	AccessStatus     string           `position:"Query" name:"AccessStatus"`
}

// ListMediaNameResponse is the response struct for api ListMediaName
type ListMediaNameResponse struct {
	*responses.BaseResponse
	Code       string  `json:"Code" xml:"Code"`
	Success    bool    `json:"Success" xml:"Success"`
	Message    string  `json:"Message" xml:"Message"`
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	PageNumber int     `json:"PageNumber" xml:"PageNumber"`
	PageSize   int     `json:"PageSize" xml:"PageSize"`
	Total      int64   `json:"Total" xml:"Total"`
	Model      []Media `json:"Model" xml:"Model"`
}

// CreateListMediaNameRequest creates a request to invoke ListMediaName API
func CreateListMediaNameRequest() (request *ListMediaNameRequest) {
	request = &ListMediaNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "ListMediaName", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListMediaNameResponse creates a response to parse from ListMediaName response
func CreateListMediaNameResponse() (response *ListMediaNameResponse) {
	response = &ListMediaNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
