package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMethods invokes the edas.ListMethods API synchronously
func (client *Client) ListMethods(request *ListMethodsRequest) (response *ListMethodsResponse, err error) {
	response = CreateListMethodsResponse()
	err = client.DoAction(request, response)
	return
}

// ListMethodsWithChan invokes the edas.ListMethods API asynchronously
func (client *Client) ListMethodsWithChan(request *ListMethodsRequest) (<-chan *ListMethodsResponse, <-chan error) {
	responseChan := make(chan *ListMethodsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMethods(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMethodsWithCallback invokes the edas.ListMethods API asynchronously
func (client *Client) ListMethodsWithCallback(request *ListMethodsRequest, callback func(response *ListMethodsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMethodsResponse
		var err error
		defer close(result)
		response, err = client.ListMethods(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMethodsRequest is the request struct for api ListMethods
type ListMethodsRequest struct {
	*requests.RoaRequest
	AppId       string `position:"Query" name:"AppId"`
	ServiceName string `position:"Query" name:"ServiceName"`
}

// ListMethodsResponse is the response struct for api ListMethods
type ListMethodsResponse struct {
	*responses.BaseResponse
	Code              int               `json:"Code" xml:"Code"`
	Message           string            `json:"Message" xml:"Message"`
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	ServiceMethodList ServiceMethodList `json:"ServiceMethodList" xml:"ServiceMethodList"`
}

// CreateListMethodsRequest creates a request to invoke ListMethods API
func CreateListMethodsRequest() (request *ListMethodsRequest) {
	request = &ListMethodsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ListMethods", "/pop/v5/service/list_methods", "Edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListMethodsResponse creates a response to parse from ListMethods response
func CreateListMethodsResponse() (response *ListMethodsResponse) {
	response = &ListMethodsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
