package dbfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateUpgradeRecord invokes the dbfs.GenerateUpgradeRecord API synchronously
func (client *Client) GenerateUpgradeRecord(request *GenerateUpgradeRecordRequest) (response *GenerateUpgradeRecordResponse, err error) {
	response = CreateGenerateUpgradeRecordResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateUpgradeRecordWithChan invokes the dbfs.GenerateUpgradeRecord API asynchronously
func (client *Client) GenerateUpgradeRecordWithChan(request *GenerateUpgradeRecordRequest) (<-chan *GenerateUpgradeRecordResponse, <-chan error) {
	responseChan := make(chan *GenerateUpgradeRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateUpgradeRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateUpgradeRecordWithCallback invokes the dbfs.GenerateUpgradeRecord API asynchronously
func (client *Client) GenerateUpgradeRecordWithCallback(request *GenerateUpgradeRecordRequest, callback func(response *GenerateUpgradeRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateUpgradeRecordResponse
		var err error
		defer close(result)
		response, err = client.GenerateUpgradeRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateUpgradeRecordRequest is the request struct for api GenerateUpgradeRecord
type GenerateUpgradeRecordRequest struct {
	*requests.RpcRequest
	PageNumber        requests.Integer `position:"Query" name:"PageNumber"`
	BatchStrategyList string           `position:"Query" name:"BatchStrategyList"`
	PageSize          requests.Integer `position:"Query" name:"PageSize"`
}

// GenerateUpgradeRecordResponse is the response struct for api GenerateUpgradeRecord
type GenerateUpgradeRecordResponse struct {
	*responses.BaseResponse
	RequestId string        `json:"RequestId" xml:"RequestId"`
	Records   []RecordsItem `json:"Records" xml:"Records"`
}

// CreateGenerateUpgradeRecordRequest creates a request to invoke GenerateUpgradeRecord API
func CreateGenerateUpgradeRecordRequest() (request *GenerateUpgradeRecordRequest) {
	request = &GenerateUpgradeRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DBFS", "2020-04-18", "GenerateUpgradeRecord", "", "")
	request.Method = requests.POST
	return
}

// CreateGenerateUpgradeRecordResponse creates a response to parse from GenerateUpgradeRecord response
func CreateGenerateUpgradeRecordResponse() (response *GenerateUpgradeRecordResponse) {
	response = &GenerateUpgradeRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
