package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddCdrsMonitor invokes the cdrs.AddCdrsMonitor API synchronously
func (client *Client) AddCdrsMonitor(request *AddCdrsMonitorRequest) (response *AddCdrsMonitorResponse, err error) {
	response = CreateAddCdrsMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// AddCdrsMonitorWithChan invokes the cdrs.AddCdrsMonitor API asynchronously
func (client *Client) AddCdrsMonitorWithChan(request *AddCdrsMonitorRequest) (<-chan *AddCdrsMonitorResponse, <-chan error) {
	responseChan := make(chan *AddCdrsMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddCdrsMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddCdrsMonitorWithCallback invokes the cdrs.AddCdrsMonitor API asynchronously
func (client *Client) AddCdrsMonitorWithCallback(request *AddCdrsMonitorRequest, callback func(response *AddCdrsMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddCdrsMonitorResponse
		var err error
		defer close(result)
		response, err = client.AddCdrsMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddCdrsMonitorRequest is the request struct for api AddCdrsMonitor
type AddCdrsMonitorRequest struct {
	*requests.RpcRequest
	MonitorType          string           `position:"Body" name:"MonitorType"`
	CorpId               string           `position:"Body" name:"CorpId"`
	Description          string           `position:"Body" name:"Description"`
	NotifierAppSecret    string           `position:"Body" name:"NotifierAppSecret"`
	NotifierExtendValues string           `position:"Body" name:"NotifierExtendValues"`
	NotifierUrl          string           `position:"Body" name:"NotifierUrl"`
	NotifierType         string           `position:"Body" name:"NotifierType"`
	BatchIndicator       requests.Integer `position:"Body" name:"BatchIndicator"`
	BizId                string           `position:"Body" name:"BizId"`
	NotifierTimeOut      requests.Integer `position:"Body" name:"NotifierTimeOut"`
	AlgorithmVendor      string           `position:"Body" name:"AlgorithmVendor"`
}

// AddCdrsMonitorResponse is the response struct for api AddCdrsMonitor
type AddCdrsMonitorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAddCdrsMonitorRequest creates a request to invoke AddCdrsMonitor API
func CreateAddCdrsMonitorRequest() (request *AddCdrsMonitorRequest) {
	request = &AddCdrsMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "AddCdrsMonitor", "", "")
	request.Method = requests.POST
	return
}

// CreateAddCdrsMonitorResponse creates a response to parse from AddCdrsMonitor response
func CreateAddCdrsMonitorResponse() (response *AddCdrsMonitorResponse) {
	response = &AddCdrsMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
