package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFabricChannelMembers invokes the baas.DescribeFabricChannelMembers API synchronously
// api document: https://help.aliyun.com/api/baas/describefabricchannelmembers.html
func (client *Client) DescribeFabricChannelMembers(request *DescribeFabricChannelMembersRequest) (response *DescribeFabricChannelMembersResponse, err error) {
	response = CreateDescribeFabricChannelMembersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFabricChannelMembersWithChan invokes the baas.DescribeFabricChannelMembers API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricchannelmembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricChannelMembersWithChan(request *DescribeFabricChannelMembersRequest) (<-chan *DescribeFabricChannelMembersResponse, <-chan error) {
	responseChan := make(chan *DescribeFabricChannelMembersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFabricChannelMembers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFabricChannelMembersWithCallback invokes the baas.DescribeFabricChannelMembers API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricchannelmembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricChannelMembersWithCallback(request *DescribeFabricChannelMembersRequest, callback func(response *DescribeFabricChannelMembersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFabricChannelMembersResponse
		var err error
		defer close(result)
		response, err = client.DescribeFabricChannelMembers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFabricChannelMembersRequest is the request struct for api DescribeFabricChannelMembers
type DescribeFabricChannelMembersRequest struct {
	*requests.RpcRequest
	ChannelId string `position:"Query" name:"ChannelId"`
}

// DescribeFabricChannelMembersResponse is the response struct for api DescribeFabricChannelMembers
type DescribeFabricChannelMembersResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Success   bool         `json:"Success" xml:"Success"`
	ErrorCode int          `json:"ErrorCode" xml:"ErrorCode"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateDescribeFabricChannelMembersRequest creates a request to invoke DescribeFabricChannelMembers API
func CreateDescribeFabricChannelMembersRequest() (request *DescribeFabricChannelMembersRequest) {
	request = &DescribeFabricChannelMembersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeFabricChannelMembers", "baas", "openAPI")
	return
}

// CreateDescribeFabricChannelMembersResponse creates a response to parse from DescribeFabricChannelMembers response
func CreateDescribeFabricChannelMembersResponse() (response *DescribeFabricChannelMembersResponse) {
	response = &DescribeFabricChannelMembersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
