package sparkapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/synapse/2019-11-01-preview/spark"
	"github.com/Azure/go-autorest/autorest"
)

// BatchClientAPI contains the set of methods on the BatchClient type.
type BatchClientAPI interface {
	CancelSparkBatchJob(ctx context.Context, batchID int32) (result autorest.Response, err error)
	CreateSparkBatchJob(ctx context.Context, sparkBatchJobOptions spark.BatchJobOptions, detailed *bool) (result spark.BatchJob, err error)
	GetSparkBatchJob(ctx context.Context, batchID int32, detailed *bool) (result spark.BatchJob, err error)
	GetSparkBatchJobs(ctx context.Context, from *int32, size *int32, detailed *bool) (result spark.BatchJobCollection, err error)
}

var _ BatchClientAPI = (*spark.BatchClient)(nil)

// SessionClientAPI contains the set of methods on the SessionClient type.
type SessionClientAPI interface {
	CancelSparkSession(ctx context.Context, sessionID int32) (result autorest.Response, err error)
	CancelSparkStatement(ctx context.Context, sessionID int32, statementID int32) (result spark.StatementCancellationResult, err error)
	CreateSparkSession(ctx context.Context, sparkSessionOptions spark.SessionOptions, detailed *bool) (result spark.Session, err error)
	CreateSparkStatement(ctx context.Context, sessionID int32, sparkStatementOptions spark.StatementOptions) (result spark.Statement, err error)
	GetSparkSession(ctx context.Context, sessionID int32, detailed *bool) (result spark.Session, err error)
	GetSparkSessions(ctx context.Context, from *int32, size *int32, detailed *bool) (result spark.SessionCollection, err error)
	GetSparkStatement(ctx context.Context, sessionID int32, statementID int32) (result spark.Statement, err error)
	GetSparkStatements(ctx context.Context, sessionID int32) (result spark.StatementCollection, err error)
	ResetSparkSessionTimeout(ctx context.Context, sessionID int32) (result autorest.Response, err error)
}

var _ SessionClientAPI = (*spark.SessionClient)(nil)
