// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// Error thrown when request validation fails HTTP Status Code: 400 Bad Request Used for request validation errors such as malformed parameters, missing required fields, or invalid parameter values.
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ValidationException {
    /// OAuth 2.0 error code indicating validation failure Will be INVALID_REQUEST for validation errors
    pub error: crate::types::OAuth2ErrorCode,
    /// Detailed message explaining the validation failure Provides specific information about which validation failed
    pub message: ::std::string::String,
    pub(crate) meta: ::aws_smithy_types::error::ErrorMetadata,
}
impl ValidationException {
    /// OAuth 2.0 error code indicating validation failure Will be INVALID_REQUEST for validation errors
    pub fn error(&self) -> &crate::types::OAuth2ErrorCode {
        &self.error
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> &str {
        &self.message
    }
}
impl ::std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        ::std::write!(f, "ValidationException")?;
        {
            ::std::write!(f, ": {}", &self.message)?;
        }
        Ok(())
    }
}
impl ::std::error::Error for ValidationException {}
impl ::aws_types::request_id::RequestId for crate::types::error::ValidationException {
    fn request_id(&self) -> Option<&str> {
        use ::aws_smithy_types::error::metadata::ProvideErrorMetadata;
        self.meta().request_id()
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for ValidationException {
    fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        &self.meta
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::types::error::ValidationException).
    pub fn builder() -> crate::types::error::builders::ValidationExceptionBuilder {
        crate::types::error::builders::ValidationExceptionBuilder::default()
    }
}

/// A builder for [`ValidationException`](crate::types::error::ValidationException).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ValidationExceptionBuilder {
    pub(crate) error: ::std::option::Option<crate::types::OAuth2ErrorCode>,
    pub(crate) message: ::std::option::Option<::std::string::String>,
    meta: std::option::Option<::aws_smithy_types::error::ErrorMetadata>,
}
impl ValidationExceptionBuilder {
    /// OAuth 2.0 error code indicating validation failure Will be INVALID_REQUEST for validation errors
    /// This field is required.
    pub fn error(mut self, input: crate::types::OAuth2ErrorCode) -> Self {
        self.error = ::std::option::Option::Some(input);
        self
    }
    /// OAuth 2.0 error code indicating validation failure Will be INVALID_REQUEST for validation errors
    pub fn set_error(mut self, input: ::std::option::Option<crate::types::OAuth2ErrorCode>) -> Self {
        self.error = input;
        self
    }
    /// OAuth 2.0 error code indicating validation failure Will be INVALID_REQUEST for validation errors
    pub fn get_error(&self) -> &::std::option::Option<crate::types::OAuth2ErrorCode> {
        &self.error
    }
    /// Detailed message explaining the validation failure Provides specific information about which validation failed
    /// This field is required.
    pub fn message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.message = ::std::option::Option::Some(input.into());
        self
    }
    /// Detailed message explaining the validation failure Provides specific information about which validation failed
    pub fn set_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.message = input;
        self
    }
    /// Detailed message explaining the validation failure Provides specific information about which validation failed
    pub fn get_message(&self) -> &::std::option::Option<::std::string::String> {
        &self.message
    }
    /// Sets error metadata
    pub fn meta(mut self, meta: ::aws_smithy_types::error::ErrorMetadata) -> Self {
        self.meta = Some(meta);
        self
    }

    /// Sets error metadata
    pub fn set_meta(&mut self, meta: std::option::Option<::aws_smithy_types::error::ErrorMetadata>) -> &mut Self {
        self.meta = meta;
        self
    }
    /// Consumes the builder and constructs a [`ValidationException`](crate::types::error::ValidationException).
    /// This method will fail if any of the following fields are not set:
    /// - [`error`](crate::types::error::builders::ValidationExceptionBuilder::error)
    /// - [`message`](crate::types::error::builders::ValidationExceptionBuilder::message)
    pub fn build(self) -> ::std::result::Result<crate::types::error::ValidationException, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::error::ValidationException {
            error: self.error.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "error",
                    "error was not specified but it is required when building ValidationException",
                )
            })?,
            message: self.message.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "message",
                    "message was not specified but it is required when building ValidationException",
                )
            })?,
            meta: self.meta.unwrap_or_default(),
        })
    }
}
