// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// When writing a match expression against `OAuth2ErrorCode`, it is important to ensure
/// your code is forward-compatible. That is, if a match arm handles a case for a
/// feature that is supported by the service but has not been represented as an enum
/// variant in a current version of SDK, your code should continue to work when you
/// upgrade SDK to a future version in which the enum does include a variant for that
/// feature.
///
/// Here is an example of how you can make a match expression forward-compatible:
///
/// ```text
/// # let oauth2errorcode = unimplemented!();
/// match oauth2errorcode {
///     OAuth2ErrorCode::AuthcodeExpired => { /* ... */ },
///     OAuth2ErrorCode::InsufficientPermissions => { /* ... */ },
///     OAuth2ErrorCode::InvalidRequest => { /* ... */ },
///     OAuth2ErrorCode::TokenExpired => { /* ... */ },
///     OAuth2ErrorCode::UserCredentialsChanged => { /* ... */ },
///     OAuth2ErrorCode::ServerError => { /* ... */ },
///     other @ _ if other.as_str() == "NewFeature" => { /* handles a case for `NewFeature` */ },
///     _ => { /* ... */ },
/// }
/// ```
/// The above code demonstrates that when `oauth2errorcode` represents
/// `NewFeature`, the execution path will lead to the second last match arm,
/// even though the enum does not contain a variant `OAuth2ErrorCode::NewFeature`
/// in the current version of SDK. The reason is that the variable `other`,
/// created by the `@` operator, is bound to
/// `OAuth2ErrorCode::Unknown(UnknownVariantValue("NewFeature".to_owned()))`
/// and calling `as_str` on it yields `"NewFeature"`.
/// This match expression is forward-compatible when executed with a newer
/// version of SDK where the variant `OAuth2ErrorCode::NewFeature` is defined.
/// Specifically, when `oauth2errorcode` represents `NewFeature`,
/// the execution path will hit the second last match arm as before by virtue of
/// calling `as_str` on `OAuth2ErrorCode::NewFeature` also yielding `"NewFeature"`.
///
/// Explicitly matching on the `Unknown` variant should
/// be avoided for two reasons:
/// - The inner data `UnknownVariantValue` is opaque, and no further information can be extracted.
/// - It might inadvertently shadow other intended match arms.
///
/// OAuth 2.0 error codes returned by the server
///
/// Standard OAuth 2.0 error codes used in error responses to indicate
/// the specific type of error that occurred during token operations.
#[non_exhaustive]
#[derive(
    ::std::clone::Clone, ::std::cmp::Eq, ::std::cmp::Ord, ::std::cmp::PartialEq, ::std::cmp::PartialOrd, ::std::fmt::Debug, ::std::hash::Hash,
)]
pub enum OAuth2ErrorCode {
    /// Authorization code has expired
    AuthcodeExpired,
    /// Insufficient permissions to perform this operation
    InsufficientPermissions,
    /// The request is missing a required parameter, includes an invalid parameter value, or is otherwise malformed
    InvalidRequest,
    /// Token has expired and needs to be refreshed
    TokenExpired,
    /// User credentials have been changed
    UserCredentialsChanged,
    /// Internal server error occurred
    ServerError,
    /// `Unknown` contains new variants that have been added since this code was generated.
    #[deprecated(note = "Don't directly match on `Unknown`. See the docs on this enum for the correct way to handle unknown variants.")]
    Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue),
}
impl ::std::convert::From<&str> for OAuth2ErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "AUTHCODE_EXPIRED" => OAuth2ErrorCode::AuthcodeExpired,
            "INSUFFICIENT_PERMISSIONS" => OAuth2ErrorCode::InsufficientPermissions,
            "INVALID_REQUEST" => OAuth2ErrorCode::InvalidRequest,
            "TOKEN_EXPIRED" => OAuth2ErrorCode::TokenExpired,
            "USER_CREDENTIALS_CHANGED" => OAuth2ErrorCode::UserCredentialsChanged,
            "server_error" => OAuth2ErrorCode::ServerError,
            other => OAuth2ErrorCode::Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue(other.to_owned())),
        }
    }
}
impl ::std::str::FromStr for OAuth2ErrorCode {
    type Err = ::std::convert::Infallible;

    fn from_str(s: &str) -> ::std::result::Result<Self, <Self as ::std::str::FromStr>::Err> {
        ::std::result::Result::Ok(OAuth2ErrorCode::from(s))
    }
}
impl OAuth2ErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OAuth2ErrorCode::AuthcodeExpired => "AUTHCODE_EXPIRED",
            OAuth2ErrorCode::InsufficientPermissions => "INSUFFICIENT_PERMISSIONS",
            OAuth2ErrorCode::InvalidRequest => "INVALID_REQUEST",
            OAuth2ErrorCode::TokenExpired => "TOKEN_EXPIRED",
            OAuth2ErrorCode::UserCredentialsChanged => "USER_CREDENTIALS_CHANGED",
            OAuth2ErrorCode::ServerError => "server_error",
            OAuth2ErrorCode::Unknown(value) => value.as_str(),
        }
    }
    /// Returns all the `&str` representations of the enum members.
    pub const fn values() -> &'static [&'static str] {
        &[
            "AUTHCODE_EXPIRED",
            "INSUFFICIENT_PERMISSIONS",
            "INVALID_REQUEST",
            "TOKEN_EXPIRED",
            "USER_CREDENTIALS_CHANGED",
            "server_error",
        ]
    }
}
impl ::std::convert::AsRef<str> for OAuth2ErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
impl OAuth2ErrorCode {
    /// Parses the enum value while disallowing unknown variants.
    ///
    /// Unknown variants will result in an error.
    pub fn try_parse(value: &str) -> ::std::result::Result<Self, crate::error::UnknownVariantError> {
        match Self::from(value) {
            #[allow(deprecated)]
            Self::Unknown(_) => ::std::result::Result::Err(crate::error::UnknownVariantError::new(value)),
            known => Ok(known),
        }
    }
}
impl ::std::fmt::Display for OAuth2ErrorCode {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        match self {
            OAuth2ErrorCode::AuthcodeExpired => write!(f, "AUTHCODE_EXPIRED"),
            OAuth2ErrorCode::InsufficientPermissions => write!(f, "INSUFFICIENT_PERMISSIONS"),
            OAuth2ErrorCode::InvalidRequest => write!(f, "INVALID_REQUEST"),
            OAuth2ErrorCode::TokenExpired => write!(f, "TOKEN_EXPIRED"),
            OAuth2ErrorCode::UserCredentialsChanged => write!(f, "USER_CREDENTIALS_CHANGED"),
            OAuth2ErrorCode::ServerError => write!(f, "server_error"),
            OAuth2ErrorCode::Unknown(value) => write!(f, "{value}"),
        }
    }
}
