/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_dataview.h"
        #include <wx/dataview.h>
        #include <wx/dataview.h>
        #include <wx/dataview.h>
        #include <wx/dataview.h>


class sipwxDataViewModel : public ::wxDataViewModel
{
public:
    sipwxDataViewModel();
    virtual ~sipwxDataViewModel();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool IsVirtualListModel() const SIP_OVERRIDE;
    bool IsListModel() const SIP_OVERRIDE;
    bool SetValue(const ::wxDVCVariant&, const ::wxDataViewItem&, uint) SIP_OVERRIDE;
    void Resort() SIP_OVERRIDE;
    bool IsContainer(const ::wxDataViewItem&) const SIP_OVERRIDE;
    bool HasValue(const ::wxDataViewItem&, uint) const SIP_OVERRIDE;
    bool HasDefaultCompare() const SIP_OVERRIDE;
    bool HasContainerColumns(const ::wxDataViewItem&) const SIP_OVERRIDE;
    void GetValue(::wxVariant&, const ::wxDataViewItem&, uint) const SIP_OVERRIDE;
    ::wxDataViewItem GetParent(const ::wxDataViewItem&) const SIP_OVERRIDE;
    uint GetChildren(const ::wxDataViewItem&, ::wxDataViewItemArray&) const SIP_OVERRIDE;
    bool IsEnabled(const ::wxDataViewItem&, uint) const SIP_OVERRIDE;
    bool GetAttr(const ::wxDataViewItem&, uint, ::wxDataViewItemAttr&) const SIP_OVERRIDE;
    int Compare(const ::wxDataViewItem&, const ::wxDataViewItem&, uint, bool) const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxDataViewModel(const sipwxDataViewModel &);
    sipwxDataViewModel &operator = (const sipwxDataViewModel &);

    char sipPyMethods[14];
};

sipwxDataViewModel::sipwxDataViewModel(): ::wxDataViewModel(), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxDataViewModel::~sipwxDataViewModel()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

bool sipwxDataViewModel::IsVirtualListModel() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[0]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_IsVirtualListModel);

    if (!sipMeth)
        return ::wxDataViewModel::IsVirtualListModel();

    extern bool sipVH__dataview_0(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__dataview_0(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxDataViewModel::IsListModel() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[1]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_IsListModel);

    if (!sipMeth)
        return ::wxDataViewModel::IsListModel();

    extern bool sipVH__dataview_0(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__dataview_0(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxDataViewModel::SetValue(const ::wxDVCVariant& variant, const ::wxDataViewItem& item, uint col)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[2], &sipPySelf, sipName_DataViewModel, sipName_SetValue);

    if (!sipMeth)
        return 0;

    extern bool sipVH__dataview_12(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxDVCVariant&, const ::wxDataViewItem&, uint);

    return sipVH__dataview_12(sipGILState, 0, sipPySelf, sipMeth, variant, item, col);
}

void sipwxDataViewModel::Resort()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[3], &sipPySelf, SIP_NULLPTR, sipName_Resort);

    if (!sipMeth)
    {
        ::wxDataViewModel::Resort();
        return;
    }

    extern void sipVH__dataview_5(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__dataview_5(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxDataViewModel::IsContainer(const ::wxDataViewItem& item) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[4]), const_cast<sipSimpleWrapper **>(&sipPySelf), sipName_DataViewModel, sipName_IsContainer);

    if (!sipMeth)
        return 0;

    extern bool sipVH__dataview_2(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxDataViewItem&);

    return sipVH__dataview_2(sipGILState, 0, sipPySelf, sipMeth, item);
}

bool sipwxDataViewModel::HasValue(const ::wxDataViewItem& item, uint col) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[5]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_HasValue);

    if (!sipMeth)
        return ::wxDataViewModel::HasValue(item, col);

    extern bool sipVH__dataview_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxDataViewItem&, uint);

    return sipVH__dataview_6(sipGILState, 0, sipPySelf, sipMeth, item, col);
}

bool sipwxDataViewModel::HasDefaultCompare() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[6]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_HasDefaultCompare);

    if (!sipMeth)
        return ::wxDataViewModel::HasDefaultCompare();

    extern bool sipVH__dataview_0(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__dataview_0(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxDataViewModel::HasContainerColumns(const ::wxDataViewItem& item) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[7]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_HasContainerColumns);

    if (!sipMeth)
        return ::wxDataViewModel::HasContainerColumns(item);

    extern bool sipVH__dataview_2(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxDataViewItem&);

    return sipVH__dataview_2(sipGILState, 0, sipPySelf, sipMeth, item);
}

void sipwxDataViewModel::GetValue(::wxVariant& variant, const ::wxDataViewItem& item, uint col) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[8]), const_cast<sipSimpleWrapper **>(&sipPySelf), sipName_DataViewModel, sipName_GetValue);

    if (!sipMeth)
        return;

    extern void sipVH__dataview_11(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::wxVariant&, const ::wxDataViewItem&, uint);

    sipVH__dataview_11(sipGILState, 0, sipPySelf, sipMeth, variant, item, col);
}

::wxDataViewItem sipwxDataViewModel::GetParent(const ::wxDataViewItem& item) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[9]), const_cast<sipSimpleWrapper **>(&sipPySelf), sipName_DataViewModel, sipName_GetParent);

    if (!sipMeth)
        return ::wxDataViewItem();

    extern ::wxDataViewItem sipVH__dataview_10(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxDataViewItem&);

    return sipVH__dataview_10(sipGILState, 0, sipPySelf, sipMeth, item);
}

uint sipwxDataViewModel::GetChildren(const ::wxDataViewItem& item, ::wxDataViewItemArray& children) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[10]), const_cast<sipSimpleWrapper **>(&sipPySelf), sipName_DataViewModel, sipName_GetChildren);

    if (!sipMeth)
        return 0;

    extern uint sipVH__dataview_9(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxDataViewItem&, ::wxDataViewItemArray&);

    return sipVH__dataview_9(sipGILState, 0, sipPySelf, sipMeth, item, children);
}

bool sipwxDataViewModel::IsEnabled(const ::wxDataViewItem& item, uint col) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[11]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_IsEnabled);

    if (!sipMeth)
        return ::wxDataViewModel::IsEnabled(item, col);

    extern bool sipVH__dataview_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxDataViewItem&, uint);

    return sipVH__dataview_6(sipGILState, 0, sipPySelf, sipMeth, item, col);
}

bool sipwxDataViewModel::GetAttr(const ::wxDataViewItem& item, uint col, ::wxDataViewItemAttr& attr) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[12]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetAttr);

    if (!sipMeth)
        return ::wxDataViewModel::GetAttr(item, col, attr);

    extern bool sipVH__dataview_8(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxDataViewItem&, uint, ::wxDataViewItemAttr&);

    return sipVH__dataview_8(sipGILState, 0, sipPySelf, sipMeth, item, col, attr);
}

int sipwxDataViewModel::Compare(const ::wxDataViewItem& item1, const ::wxDataViewItem& item2, uint column, bool ascending) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[13]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_Compare);

    if (!sipMeth)
        return ::wxDataViewModel::Compare(item1, item2, column, ascending);

    extern int sipVH__dataview_7(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxDataViewItem&, const ::wxDataViewItem&, uint, bool);

    return sipVH__dataview_7(sipGILState, 0, sipPySelf, sipMeth, item1, item2, column, ascending);
}


PyDoc_STRVAR(doc_wxDataViewModel_AddNotifier, "AddNotifier(notifier) -> None\n"
"\n"
"Adds a wxDataViewModelNotifier to the model.");

extern "C" {static PyObject *meth_wxDataViewModel_AddNotifier(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_AddNotifier(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDataViewModelNotifier* notifier;
        ::wxDataViewModel *sipCpp;

        static const char *sipKwdList[] = {
            sipName_notifier,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ:", &sipSelf, sipType_wxDataViewModel, &sipCpp, sipType_wxDataViewModelNotifier, &notifier))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddNotifier(notifier);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_AddNotifier, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_ChangeValue, "ChangeValue(variant, item, col) -> bool\n"
"\n"
"Change the value of the given item and update the control to reflect\n"
"it.");

extern "C" {static PyObject *meth_wxDataViewModel_ChangeValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_ChangeValue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDVCVariant* variant;
        int variantState = 0;
        const ::wxDataViewItem* item;
        uint col;
        ::wxDataViewModel *sipCpp;

        static const char *sipKwdList[] = {
            sipName_variant,
            sipName_item,
            sipName_col,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J9u", &sipSelf, sipType_wxDataViewModel, &sipCpp, sipType_wxDVCVariant, &variant, &variantState, sipType_wxDataViewItem, &item, &col))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ChangeValue(*variant, *item, col);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxDVCVariant *>(variant), sipType_wxDVCVariant, variantState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_ChangeValue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_Cleared, "Cleared() -> bool\n"
"\n"
"Called to inform the model that all of its data has been changed.");

extern "C" {static PyObject *meth_wxDataViewModel_Cleared(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_Cleared(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDataViewModel *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewModel, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Cleared();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_Cleared, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_Compare, "Compare(item1, item2, column, ascending) -> int\n"
"\n"
"The compare function to be used by the control.");

extern "C" {static PyObject *meth_wxDataViewModel_Compare(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_Compare(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxDataViewItem* item1;
        const ::wxDataViewItem* item2;
        uint column;
        bool ascending;
        const ::wxDataViewModel *sipCpp;

        static const char *sipKwdList[] = {
            sipName_item1,
            sipName_item2,
            sipName_column,
            sipName_ascending,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9ub", &sipSelf, sipType_wxDataViewModel, &sipCpp, sipType_wxDataViewItem, &item1, sipType_wxDataViewItem, &item2, &column, &ascending))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxDataViewModel::Compare(*item1, *item2, column, ascending) : sipCpp->Compare(*item1, *item2, column, ascending));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_Compare, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_GetAttr, "GetAttr(item, col, attr) -> bool\n"
"\n"
"Override this to indicate that the item has special font attributes.");

extern "C" {static PyObject *meth_wxDataViewModel_GetAttr(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_GetAttr(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxDataViewItem* item;
        uint col;
        ::wxDataViewItemAttr* attr;
        const ::wxDataViewModel *sipCpp;

        static const char *sipKwdList[] = {
            sipName_item,
            sipName_col,
            sipName_attr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9uJ9", &sipSelf, sipType_wxDataViewModel, &sipCpp, sipType_wxDataViewItem, &item, &col, sipType_wxDataViewItemAttr, &attr))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxDataViewModel::GetAttr(*item, col, *attr) : sipCpp->GetAttr(*item, col, *attr));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_GetAttr, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_IsEnabled, "IsEnabled(item, col) -> bool\n"
"\n"
"Override this to indicate that the item should be disabled.");

extern "C" {static PyObject *meth_wxDataViewModel_IsEnabled(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_IsEnabled(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxDataViewItem* item;
        uint col;
        const ::wxDataViewModel *sipCpp;

        static const char *sipKwdList[] = {
            sipName_item,
            sipName_col,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9u", &sipSelf, sipType_wxDataViewModel, &sipCpp, sipType_wxDataViewItem, &item, &col))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxDataViewModel::IsEnabled(*item, col) : sipCpp->IsEnabled(*item, col));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_IsEnabled, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_GetChildren, "GetChildren(item, children) -> int\n"
"\n"
"Override this so the control can query the child items of an item.");

extern "C" {static PyObject *meth_wxDataViewModel_GetChildren(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_GetChildren(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxDataViewItem* item;
        ::wxDataViewItemArray* children;
        const ::wxDataViewModel *sipCpp;

        static const char *sipKwdList[] = {
            sipName_item,
            sipName_children,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_wxDataViewModel, &sipCpp, sipType_wxDataViewItem, &item, sipType_wxDataViewItemArray, &children))
        {
            uint sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_DataViewModel, sipName_GetChildren);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetChildren(*item, *children);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_GetChildren, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_GetParent, "GetParent(item) -> DataViewItem\n"
"\n"
"Override this to indicate which wxDataViewItem representing the parent\n"
"of item or an invalid wxDataViewItem if the root item is the parent\n"
"item.");

extern "C" {static PyObject *meth_wxDataViewModel_GetParent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_GetParent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxDataViewItem* item;
        const ::wxDataViewModel *sipCpp;

        static const char *sipKwdList[] = {
            sipName_item,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxDataViewModel, &sipCpp, sipType_wxDataViewItem, &item))
        {
            ::wxDataViewItem*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_DataViewModel, sipName_GetParent);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxDataViewItem(sipCpp->GetParent(*item));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxDataViewItem, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_GetParent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_GetValue, "GetValue(item, col) -> DVCVariant\n"
"\n"
"Override this to indicate the value of item.");

extern "C" {static PyObject *meth_wxDataViewModel_GetValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_GetValue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        ::wxDVCVariant* variant;
        const ::wxDataViewItem* item;
        uint col;
        const ::wxDataViewModel *sipCpp;

        static const char *sipKwdList[] = {
            sipName_item,
            sipName_col,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9u", &sipSelf, sipType_wxDataViewModel, &sipCpp, sipType_wxDataViewItem, &item, &col))
        {
            variant = new ::wxDVCVariant();

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_DataViewModel, sipName_GetValue);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetValue(*variant, *item, col);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(variant, sipType_wxDVCVariant, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_GetValue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_HasContainerColumns, "HasContainerColumns(item) -> bool\n"
"\n"
"Override this method to indicate if a container item merely acts as a\n"
"headline (or for categorisation) or if it also acts a normal item with\n"
"entries for further columns.");

extern "C" {static PyObject *meth_wxDataViewModel_HasContainerColumns(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_HasContainerColumns(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxDataViewItem* item;
        const ::wxDataViewModel *sipCpp;

        static const char *sipKwdList[] = {
            sipName_item,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxDataViewModel, &sipCpp, sipType_wxDataViewItem, &item))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxDataViewModel::HasContainerColumns(*item) : sipCpp->HasContainerColumns(*item));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_HasContainerColumns, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_HasDefaultCompare, "HasDefaultCompare() -> bool\n"
"\n"
"Override this to indicate that the model provides a default compare\n"
"function that the control should use if no wxDataViewColumn has been\n"
"chosen for sorting.");

extern "C" {static PyObject *meth_wxDataViewModel_HasDefaultCompare(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_HasDefaultCompare(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxDataViewModel *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewModel, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxDataViewModel::HasDefaultCompare() : sipCpp->HasDefaultCompare());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_HasDefaultCompare, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_HasValue, "HasValue(item, col) -> bool\n"
"\n"
"Return true if there is a value in the given column of this item.");

extern "C" {static PyObject *meth_wxDataViewModel_HasValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_HasValue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxDataViewItem* item;
        uint col;
        const ::wxDataViewModel *sipCpp;

        static const char *sipKwdList[] = {
            sipName_item,
            sipName_col,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9u", &sipSelf, sipType_wxDataViewModel, &sipCpp, sipType_wxDataViewItem, &item, &col))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxDataViewModel::HasValue(*item, col) : sipCpp->HasValue(*item, col));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_HasValue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_IsContainer, "IsContainer(item) -> bool\n"
"\n"
"Override this to indicate if item is a container, i.e. if it can have\n"
"child items.");

extern "C" {static PyObject *meth_wxDataViewModel_IsContainer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_IsContainer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxDataViewItem* item;
        const ::wxDataViewModel *sipCpp;

        static const char *sipKwdList[] = {
            sipName_item,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxDataViewModel, &sipCpp, sipType_wxDataViewItem, &item))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_DataViewModel, sipName_IsContainer);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsContainer(*item);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_IsContainer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_ItemAdded, "ItemAdded(parent, item) -> bool\n"
"\n"
"Call this to inform the model that an item has been added to the data.");

extern "C" {static PyObject *meth_wxDataViewModel_ItemAdded(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_ItemAdded(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDataViewItem* parent;
        const ::wxDataViewItem* item;
        ::wxDataViewModel *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_item,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_wxDataViewModel, &sipCpp, sipType_wxDataViewItem, &parent, sipType_wxDataViewItem, &item))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ItemAdded(*parent, *item);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_ItemAdded, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_ItemChanged, "ItemChanged(item) -> bool\n"
"\n"
"Call this to inform the model that an item has changed.");

extern "C" {static PyObject *meth_wxDataViewModel_ItemChanged(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_ItemChanged(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDataViewItem* item;
        ::wxDataViewModel *sipCpp;

        static const char *sipKwdList[] = {
            sipName_item,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxDataViewModel, &sipCpp, sipType_wxDataViewItem, &item))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ItemChanged(*item);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_ItemChanged, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_ItemDeleted, "ItemDeleted(parent, item) -> bool\n"
"\n"
"Call this to inform the model that an item has been deleted from the\n"
"data.");

extern "C" {static PyObject *meth_wxDataViewModel_ItemDeleted(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_ItemDeleted(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDataViewItem* parent;
        const ::wxDataViewItem* item;
        ::wxDataViewModel *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_item,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_wxDataViewModel, &sipCpp, sipType_wxDataViewItem, &parent, sipType_wxDataViewItem, &item))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ItemDeleted(*parent, *item);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_ItemDeleted, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_ItemsAdded, "ItemsAdded(parent, items) -> bool\n"
"\n"
"Call this to inform the model that several items have been added to\n"
"the data.");

extern "C" {static PyObject *meth_wxDataViewModel_ItemsAdded(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_ItemsAdded(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDataViewItem* parent;
        const ::wxDataViewItemArray* items;
        ::wxDataViewModel *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_items,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_wxDataViewModel, &sipCpp, sipType_wxDataViewItem, &parent, sipType_wxDataViewItemArray, &items))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ItemsAdded(*parent, *items);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_ItemsAdded, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_ItemsChanged, "ItemsChanged(items) -> bool\n"
"\n"
"Call this to inform the model that several items have changed.");

extern "C" {static PyObject *meth_wxDataViewModel_ItemsChanged(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_ItemsChanged(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDataViewItemArray* items;
        ::wxDataViewModel *sipCpp;

        static const char *sipKwdList[] = {
            sipName_items,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxDataViewModel, &sipCpp, sipType_wxDataViewItemArray, &items))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ItemsChanged(*items);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_ItemsChanged, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_ItemsDeleted, "ItemsDeleted(parent, items) -> bool\n"
"\n"
"Call this to inform the model that several items have been deleted.");

extern "C" {static PyObject *meth_wxDataViewModel_ItemsDeleted(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_ItemsDeleted(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDataViewItem* parent;
        const ::wxDataViewItemArray* items;
        ::wxDataViewModel *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_items,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_wxDataViewModel, &sipCpp, sipType_wxDataViewItem, &parent, sipType_wxDataViewItemArray, &items))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ItemsDeleted(*parent, *items);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_ItemsDeleted, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_RemoveNotifier, "RemoveNotifier(notifier) -> None\n"
"\n"
"Remove the notifier from the list of notifiers.");

extern "C" {static PyObject *meth_wxDataViewModel_RemoveNotifier(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_RemoveNotifier(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDataViewModelNotifier* notifier;
        ::wxDataViewModel *sipCpp;

        static const char *sipKwdList[] = {
            sipName_notifier,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ<", &sipSelf, sipType_wxDataViewModel, &sipCpp, sipType_wxDataViewModelNotifier, &notifier))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->RemoveNotifier(notifier);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_RemoveNotifier, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_Resort, "Resort() -> None\n"
"\n"
"Call this to initiate a resort after the sort function has been\n"
"changed.");

extern "C" {static PyObject *meth_wxDataViewModel_Resort(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_Resort(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxDataViewModel *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewModel, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp->::wxDataViewModel::Resort() : sipCpp->Resort());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_Resort, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_SetValue, "SetValue(variant, item, col) -> bool\n"
"\n"
"This gets called in order to set a value in the data model.");

extern "C" {static PyObject *meth_wxDataViewModel_SetValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_SetValue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxDVCVariant* variant;
        int variantState = 0;
        const ::wxDataViewItem* item;
        uint col;
        ::wxDataViewModel *sipCpp;

        static const char *sipKwdList[] = {
            sipName_variant,
            sipName_item,
            sipName_col,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J9u", &sipSelf, sipType_wxDataViewModel, &sipCpp, sipType_wxDVCVariant, &variant, &variantState, sipType_wxDataViewItem, &item, &col))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_DataViewModel, sipName_SetValue);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetValue(*variant, *item, col);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxDVCVariant *>(variant), sipType_wxDVCVariant, variantState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_SetValue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_ValueChanged, "ValueChanged(item, col) -> bool\n"
"\n"
"Call this to inform this model that a value in the model has been\n"
"changed.");

extern "C" {static PyObject *meth_wxDataViewModel_ValueChanged(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_ValueChanged(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDataViewItem* item;
        uint col;
        ::wxDataViewModel *sipCpp;

        static const char *sipKwdList[] = {
            sipName_item,
            sipName_col,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9u", &sipSelf, sipType_wxDataViewModel, &sipCpp, sipType_wxDataViewItem, &item, &col))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ValueChanged(*item, col);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_ValueChanged, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_IsListModel, "IsListModel() -> bool");

extern "C" {static PyObject *meth_wxDataViewModel_IsListModel(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_IsListModel(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxDataViewModel *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewModel, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxDataViewModel::IsListModel() : sipCpp->IsListModel());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_IsListModel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewModel_IsVirtualListModel, "IsVirtualListModel() -> bool");

extern "C" {static PyObject *meth_wxDataViewModel_IsVirtualListModel(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewModel_IsVirtualListModel(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxDataViewModel *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewModel, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxDataViewModel::IsVirtualListModel() : sipCpp->IsVirtualListModel());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewModel, sipName_IsVirtualListModel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxDataViewModel(void *, const sipTypeDef *);}
static void *cast_wxDataViewModel(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxDataViewModel *sipCpp = reinterpret_cast< ::wxDataViewModel *>(sipCppV);

    if (targetType == sipType_wxDataViewModel)
        return sipCppV;

    if (targetType == sipType_wxRefCounter)
        return static_cast< ::wxRefCounter *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxDataViewModel(void *, int);}
static void release_wxDataViewModel(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxDataViewModel *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxDataViewModel(sipSimpleWrapper *);}
static void dealloc_wxDataViewModel(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxDataViewModel *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxDataViewModel(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxDataViewModel(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxDataViewModel(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **sipOwner, PyObject **sipParseErr)
{
    sipwxDataViewModel *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxDataViewModel();
            Py_END_ALLOW_THREADS

            *sipOwner = Py_None;

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxDataViewModel[] = {{29, 0, 1}};


static PyMethodDef methods_wxDataViewModel[] = {
    {sipName_AddNotifier, SIP_MLMETH_CAST(meth_wxDataViewModel_AddNotifier), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewModel_AddNotifier},
    {sipName_ChangeValue, SIP_MLMETH_CAST(meth_wxDataViewModel_ChangeValue), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewModel_ChangeValue},
    {sipName_Cleared, meth_wxDataViewModel_Cleared, METH_VARARGS, doc_wxDataViewModel_Cleared},
    {sipName_Compare, SIP_MLMETH_CAST(meth_wxDataViewModel_Compare), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewModel_Compare},
    {sipName_GetAttr, SIP_MLMETH_CAST(meth_wxDataViewModel_GetAttr), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewModel_GetAttr},
    {sipName_GetChildren, SIP_MLMETH_CAST(meth_wxDataViewModel_GetChildren), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewModel_GetChildren},
    {sipName_GetParent, SIP_MLMETH_CAST(meth_wxDataViewModel_GetParent), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewModel_GetParent},
    {sipName_GetValue, SIP_MLMETH_CAST(meth_wxDataViewModel_GetValue), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewModel_GetValue},
    {sipName_HasContainerColumns, SIP_MLMETH_CAST(meth_wxDataViewModel_HasContainerColumns), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewModel_HasContainerColumns},
    {sipName_HasDefaultCompare, meth_wxDataViewModel_HasDefaultCompare, METH_VARARGS, doc_wxDataViewModel_HasDefaultCompare},
    {sipName_HasValue, SIP_MLMETH_CAST(meth_wxDataViewModel_HasValue), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewModel_HasValue},
    {sipName_IsContainer, SIP_MLMETH_CAST(meth_wxDataViewModel_IsContainer), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewModel_IsContainer},
    {sipName_IsEnabled, SIP_MLMETH_CAST(meth_wxDataViewModel_IsEnabled), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewModel_IsEnabled},
    {sipName_IsListModel, meth_wxDataViewModel_IsListModel, METH_VARARGS, doc_wxDataViewModel_IsListModel},
    {sipName_IsVirtualListModel, meth_wxDataViewModel_IsVirtualListModel, METH_VARARGS, doc_wxDataViewModel_IsVirtualListModel},
    {sipName_ItemAdded, SIP_MLMETH_CAST(meth_wxDataViewModel_ItemAdded), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewModel_ItemAdded},
    {sipName_ItemChanged, SIP_MLMETH_CAST(meth_wxDataViewModel_ItemChanged), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewModel_ItemChanged},
    {sipName_ItemDeleted, SIP_MLMETH_CAST(meth_wxDataViewModel_ItemDeleted), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewModel_ItemDeleted},
    {sipName_ItemsAdded, SIP_MLMETH_CAST(meth_wxDataViewModel_ItemsAdded), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewModel_ItemsAdded},
    {sipName_ItemsChanged, SIP_MLMETH_CAST(meth_wxDataViewModel_ItemsChanged), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewModel_ItemsChanged},
    {sipName_ItemsDeleted, SIP_MLMETH_CAST(meth_wxDataViewModel_ItemsDeleted), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewModel_ItemsDeleted},
    {sipName_RemoveNotifier, SIP_MLMETH_CAST(meth_wxDataViewModel_RemoveNotifier), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewModel_RemoveNotifier},
    {sipName_Resort, meth_wxDataViewModel_Resort, METH_VARARGS, doc_wxDataViewModel_Resort},
    {sipName_SetValue, SIP_MLMETH_CAST(meth_wxDataViewModel_SetValue), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewModel_SetValue},
    {sipName_ValueChanged, SIP_MLMETH_CAST(meth_wxDataViewModel_ValueChanged), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewModel_ValueChanged}
};

PyDoc_STRVAR(doc_wxDataViewModel, "DataViewModel() -> None\n"
"\n"
"wxDataViewModel is the base class for all data model to be displayed\n"
"by a wxDataViewCtrl.");


sipClassTypeDef sipTypeDef__dataview_wxDataViewModel = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxDataViewModel,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_DataViewModel,
        {0, 0, 1},
        25, methods_wxDataViewModel,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxDataViewModel,
    -1,
    -1,
    supers_wxDataViewModel,
    SIP_NULLPTR,
    init_type_wxDataViewModel,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxDataViewModel,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxDataViewModel,
    cast_wxDataViewModel,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::wxDataViewModel),
};
