//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtliostatus?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLIOStatus(pub NSInteger);
impl MTLIOStatus {
    #[doc(alias = "MTLIOStatusPending")]
    pub const Pending: Self = Self(0);
    #[doc(alias = "MTLIOStatusCancelled")]
    pub const Cancelled: Self = Self(1);
    #[doc(alias = "MTLIOStatusError")]
    pub const Error: Self = Self(2);
    #[doc(alias = "MTLIOStatusComplete")]
    pub const Complete: Self = Self(3);
}

unsafe impl Encode for MTLIOStatus {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for MTLIOStatus {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtliocommandbufferhandler?language=objc)
#[cfg(feature = "block2")]
pub type MTLIOCommandBufferHandler =
    *mut block2::DynBlock<dyn Fn(NonNull<ProtocolObject<dyn MTLIOCommandBuffer>>)>;

extern_protocol!(
    /// represents a list of IO commands for a queue to execute
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtliocommandbuffer?language=objc)
    pub unsafe trait MTLIOCommandBuffer: NSObjectProtocol {
        #[cfg(feature = "block2")]
        /// Add a block to be called when this command buffer has completed execution.
        #[unsafe(method(addCompletedHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn addCompletedHandler(&self, block: MTLIOCommandBufferHandler);

        #[cfg(feature = "MTLIOCommandQueue")]
        /// Encodes a command that loads from a handle
        /// and offset into a memory location.
        #[unsafe(method(loadBytes:size:sourceHandle:sourceHandleOffset:))]
        #[unsafe(method_family = none)]
        unsafe fn loadBytes_size_sourceHandle_sourceHandleOffset(
            &self,
            pointer: NonNull<c_void>,
            size: NSUInteger,
            source_handle: &ProtocolObject<dyn MTLIOFileHandle>,
            source_handle_offset: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLIOCommandQueue",
            feature = "MTLResource"
        ))]
        /// Encodes a command that loads from a handle
        /// and offset into a buffer and an offset.
        #[unsafe(method(loadBuffer:offset:size:sourceHandle:sourceHandleOffset:))]
        #[unsafe(method_family = none)]
        unsafe fn loadBuffer_offset_size_sourceHandle_sourceHandleOffset(
            &self,
            buffer: &ProtocolObject<dyn MTLBuffer>,
            offset: NSUInteger,
            size: NSUInteger,
            source_handle: &ProtocolObject<dyn MTLIOFileHandle>,
            source_handle_offset: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLIOCommandQueue",
            feature = "MTLResource",
            feature = "MTLTexture",
            feature = "MTLTypes"
        ))]
        /// Encodes a command that loads a region from a handle
        /// and offset into a texture at a given slice, level and origin.
        #[unsafe(method(loadTexture:slice:level:size:sourceBytesPerRow:sourceBytesPerImage:destinationOrigin:sourceHandle:sourceHandleOffset:))]
        #[unsafe(method_family = none)]
        unsafe fn loadTexture_slice_level_size_sourceBytesPerRow_sourceBytesPerImage_destinationOrigin_sourceHandle_sourceHandleOffset(
            &self,
            texture: &ProtocolObject<dyn MTLTexture>,
            slice: NSUInteger,
            level: NSUInteger,
            size: MTLSize,
            source_bytes_per_row: NSUInteger,
            source_bytes_per_image: NSUInteger,
            destination_origin: MTLOrigin,
            source_handle: &ProtocolObject<dyn MTLIOFileHandle>,
            source_handle_offset: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Encodes a command that writes the status of this commandBuffer upon completion
        /// to a buffer at a given offset
        #[unsafe(method(copyStatusToBuffer:offset:))]
        #[unsafe(method_family = none)]
        unsafe fn copyStatusToBuffer_offset(
            &self,
            buffer: &ProtocolObject<dyn MTLBuffer>,
            offset: NSUInteger,
        );

        /// Commit a command buffer so it can be executed as soon as possible.
        #[unsafe(method(commit))]
        #[unsafe(method_family = none)]
        unsafe fn commit(&self);

        /// Synchronously wait for this command buffer to complete.
        #[unsafe(method(waitUntilCompleted))]
        #[unsafe(method_family = none)]
        unsafe fn waitUntilCompleted(&self);

        /// request a cancellation of an in-flight command buffer.
        #[unsafe(method(tryCancel))]
        #[unsafe(method_family = none)]
        unsafe fn tryCancel(&self);

        /// add a barrier that starts subsequent commands after all
        /// the previously encoded commands have completed.
        #[unsafe(method(addBarrier))]
        #[unsafe(method_family = none)]
        unsafe fn addBarrier(&self);

        /// Push a new named string onto a stack of string labels.
        #[unsafe(method(pushDebugGroup:))]
        #[unsafe(method_family = none)]
        unsafe fn pushDebugGroup(&self, string: &NSString);

        /// Pop the latest named string off of the stack.
        #[unsafe(method(popDebugGroup))]
        #[unsafe(method_family = none)]
        unsafe fn popDebugGroup(&self);

        /// Append this command buffer to the end of its MTLCommandQueue.
        #[unsafe(method(enqueue))]
        #[unsafe(method_family = none)]
        unsafe fn enqueue(&self);

        #[cfg(feature = "MTLEvent")]
        /// Encodes a command that pauses execution of this command buffer until the specified event reaches a given value.
        #[unsafe(method(waitForEvent:value:))]
        #[unsafe(method_family = none)]
        unsafe fn waitForEvent_value(&self, event: &ProtocolObject<dyn MTLSharedEvent>, value: u64);

        #[cfg(feature = "MTLEvent")]
        /// Encodes a command that signals an event with a given value.
        #[unsafe(method(signalEvent:value:))]
        #[unsafe(method_family = none)]
        unsafe fn signalEvent_value(&self, event: &ProtocolObject<dyn MTLSharedEvent>, value: u64);

        /// An optional label for this handle.
        #[unsafe(method(label))]
        #[unsafe(method_family = none)]
        unsafe fn label(&self) -> Option<Retained<NSString>>;

        /// Setter for [`label`][Self::label].
        #[unsafe(method(setLabel:))]
        #[unsafe(method_family = none)]
        unsafe fn setLabel(&self, label: Option<&NSString>);

        /// status reports the completion status of the MTLIOCommandBuffer, pending, cancelled, error or complete.
        #[unsafe(method(status))]
        #[unsafe(method_family = none)]
        unsafe fn status(&self) -> MTLIOStatus;

        /// If an error occurred during execution, the NSError may contain more details about the problem.
        #[unsafe(method(error))]
        #[unsafe(method_family = none)]
        unsafe fn error(&self) -> Option<Retained<NSError>>;
    }
);
