//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_protocol!(
    /// A serial queue of command buffers to be executed by the device.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlcommandqueue?language=objc)
    pub unsafe trait MTLCommandQueue: NSObjectProtocol {
        /// A string to help identify this object
        #[unsafe(method(label))]
        #[unsafe(method_family = none)]
        fn label(&self) -> Option<Retained<NSString>>;

        /// Setter for [`label`][Self::label].
        #[unsafe(method(setLabel:))]
        #[unsafe(method_family = none)]
        fn setLabel(&self, label: Option<&NSString>);

        #[cfg(feature = "MTLDevice")]
        /// The device this queue will submit to
        #[unsafe(method(device))]
        #[unsafe(method_family = none)]
        fn device(&self) -> Retained<ProtocolObject<dyn MTLDevice>>;

        #[cfg(feature = "MTLCommandBuffer")]
        /// Returns a new autoreleased command buffer used to encode work into this queue that
        /// maintains strong references to resources used within the command buffer.
        #[unsafe(method(commandBuffer))]
        #[unsafe(method_family = none)]
        fn commandBuffer(&self) -> Option<Retained<ProtocolObject<dyn MTLCommandBuffer>>>;

        #[cfg(feature = "MTLCommandBuffer")]
        /// Parameter `descriptor`: The requested properties of the command buffer.
        ///
        /// Returns a new autoreleased command buffer used to encode work into this queue.
        #[unsafe(method(commandBufferWithDescriptor:))]
        #[unsafe(method_family = none)]
        unsafe fn commandBufferWithDescriptor(
            &self,
            descriptor: &MTLCommandBufferDescriptor,
        ) -> Option<Retained<ProtocolObject<dyn MTLCommandBuffer>>>;

        #[cfg(feature = "MTLCommandBuffer")]
        /// Returns a new autoreleased command buffer used to encode work into this queue that
        /// does not maintain strong references to resources used within the command buffer.
        #[unsafe(method(commandBufferWithUnretainedReferences))]
        #[unsafe(method_family = none)]
        unsafe fn commandBufferWithUnretainedReferences(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn MTLCommandBuffer>>>;

        /// Inform Xcode about when debug capture should start and stop.
        #[deprecated = "Use MTLCaptureScope instead"]
        #[unsafe(method(insertDebugCaptureBoundary))]
        #[unsafe(method_family = none)]
        unsafe fn insertDebugCaptureBoundary(&self);

        #[cfg(feature = "MTLResidencySet")]
        /// Marks the residency set as part of the command queue execution. This ensures that the residency set is resident during execution of all the command buffers within the queue.
        #[unsafe(method(addResidencySet:))]
        #[unsafe(method_family = none)]
        unsafe fn addResidencySet(&self, residency_set: &ProtocolObject<dyn MTLResidencySet>);

        #[cfg(feature = "MTLResidencySet")]
        /// Marks the residency sets as part of the command queue execution. This ensures that the residency sets are resident during execution of all the command buffers within the queue.
        #[unsafe(method(addResidencySets:count:))]
        #[unsafe(method_family = none)]
        unsafe fn addResidencySets_count(
            &self,
            residency_sets: NonNull<NonNull<ProtocolObject<dyn MTLResidencySet>>>,
            count: NSUInteger,
        );

        #[cfg(feature = "MTLResidencySet")]
        /// Removes the residency set from the command queue execution. This ensures that only the remaining residency sets are resident during execution of all the command buffers within the queue.
        #[unsafe(method(removeResidencySet:))]
        #[unsafe(method_family = none)]
        unsafe fn removeResidencySet(&self, residency_set: &ProtocolObject<dyn MTLResidencySet>);

        #[cfg(feature = "MTLResidencySet")]
        /// Removes the residency sets from the command queue execution. This ensures that only the remaining residency sets are resident during execution of all the command buffers within the queue.
        #[unsafe(method(removeResidencySets:count:))]
        #[unsafe(method_family = none)]
        unsafe fn removeResidencySets_count(
            &self,
            residency_sets: NonNull<NonNull<ProtocolObject<dyn MTLResidencySet>>>,
            count: NSUInteger,
        );
    }
);

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlcommandqueuedescriptor?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLCommandQueueDescriptor;
);

extern_conformance!(
    unsafe impl NSCopying for MTLCommandQueueDescriptor {}
);

unsafe impl CopyingHelper for MTLCommandQueueDescriptor {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLCommandQueueDescriptor {}
);

impl MTLCommandQueueDescriptor {
    extern_methods!(
        /// @
        /// Specify upper bound on uncompleted command buffers that may be enqueued on this queue
        #[unsafe(method(maxCommandBufferCount))]
        #[unsafe(method_family = none)]
        pub unsafe fn maxCommandBufferCount(&self) -> NSUInteger;

        /// Setter for [`maxCommandBufferCount`][Self::maxCommandBufferCount].
        #[unsafe(method(setMaxCommandBufferCount:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMaxCommandBufferCount(&self, max_command_buffer_count: NSUInteger);

        #[cfg(feature = "MTLLogState")]
        /// @
        /// Specify the MTLLogState to enable shader logging
        #[unsafe(method(logState))]
        #[unsafe(method_family = none)]
        pub unsafe fn logState(&self) -> Option<Retained<ProtocolObject<dyn MTLLogState>>>;

        #[cfg(feature = "MTLLogState")]
        /// Setter for [`logState`][Self::logState].
        #[unsafe(method(setLogState:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setLogState(&self, log_state: Option<&ProtocolObject<dyn MTLLogState>>);
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLCommandQueueDescriptor {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
