/*
 * Decompiled with CFR 0.152.
 */
package com.elovirta.pdf.ant;

import com.elovirta.pdf.ant.ClasspathResolver;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmEmptySequence;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.dita.dost.log.DITAOTAntLogger;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.XMLUtils;

public class StylesheetGeneratorTask
extends Task {
    private static final QName LANG = QName.fromClarkName((String)"{}lang");
    private static final QName ATTR = QName.fromClarkName((String)"{}attr");
    private static final QName VERSION = QName.fromClarkName((String)"{}version");
    private static final QName FORMATTER = QName.fromClarkName((String)"{}formatter");
    private static final String DEFAULT_EXTENDS = "default";
    private static final URI DEFAULT_EXTENDS_URI = URI.create("classpath:/com/elovirta/pdf/default.json");
    private File template;
    private File dstDir;
    private XMLUtils xmlUtils;
    private URIResolver resolver;
    private Processor processor;
    private XsltCompiler compiler;
    private XsltExecutable executable;
    private Xslt30Transformer transformer;
    private XPathCompiler xpathCompiler;
    private ObjectMapper yamlReader;
    private ObjectMapper jsonWriter;

    public void init() {
        this.resolver = new ClasspathResolver();
        this.xmlUtils = (XMLUtils)this.getProject().getReference("xmlutils");
        if (this.xmlUtils == null) {
            this.xmlUtils = new XMLUtils();
            this.xmlUtils.setLogger((DITAOTLogger)new DITAOTAntLogger(this.getProject()));
        }
        this.processor = this.xmlUtils.getProcessor();
        this.compiler = this.processor.newXsltCompiler();
        this.compiler.setURIResolver(this.resolver);
        try {
            this.executable = this.compiler.compile(this.resolver.resolve("classpath:/com/elovirta/pdf/merge.xsl", null));
            this.transformer = this.executable.load30();
        }
        catch (TransformerException | SaxonApiException e) {
            throw new BuildException(String.format("Failed to parse template %s", this.template), e);
        }
        this.xpathCompiler = this.processor.newXPathCompiler();
        this.xpathCompiler.declareNamespace("map", "http://www.w3.org/2005/xpath-functions/map");
        this.yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
        this.jsonWriter = new ObjectMapper();
    }

    public void execute() throws BuildException {
        if (!this.dstDir.exists()) {
            try {
                this.dstDir = Files.createDirectories(this.dstDir.toPath(), new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                throw new BuildException("Failed to generate stylesheet directory", (Throwable)e);
            }
        }
        XdmItem xdmItem = this.parseTemplate();
        this.getProject().log("Template:" + String.valueOf(xdmItem), 4);
        this.generate(xdmItem, "front-matter.xsl", "xsl/fo/front-matter.xsl", null);
        this.generate(xdmItem, "commons.xsl", "xsl/fo/commons.xsl", null);
        this.generate(xdmItem, "tables.xsl", "xsl/fo/tables.xsl", null);
        this.generate(xdmItem, "toc.xsl", "xsl/fo/toc.xsl", null);
        this.generate(xdmItem, "links.xsl", "xsl/fo/links.xsl", null);
        this.generate(xdmItem, "lists.xsl", "xsl/fo/lists.xsl", null);
        this.generate(xdmItem, "hi-domain.xsl", "xsl/fo/hi-domain.xsl", null);
        this.generate(xdmItem, "preface.xsl", "xsl/fo/preface.xsl", null);
        this.generate(xdmItem, "pr-domain.xsl", "xsl/fo/pr-domain.xsl", null);
        this.generate(xdmItem, "hazard-d.xsl", "xsl/fo/hazard-d.xsl", null);
        this.generate(xdmItem, "static-content.xsl", "xsl/fo/static-content.xsl", null);
        this.generate(xdmItem, "topic.xsl", "xsl/fo/topic.xsl", null);
        this.generate(xdmItem, "task-elements.xsl", "xsl/fo/task-elements.xsl", null);
        this.generate(xdmItem, "layout-masters.xsl", "cfg/fo/layout-masters.xsl", null);
        this.generate(xdmItem, "front-matter.xsl", "cfg/fo/attrs/front-matter-attr.xsl", ATTR);
        this.generate(xdmItem, "commons.xsl", "cfg/fo/attrs/commons-attr.xsl", ATTR);
        this.generate(xdmItem, "glossary.xsl", "cfg/fo/attrs/glossary-attr.xsl", ATTR);
        this.generate(xdmItem, "layout-masters.xsl", "cfg/fo/attrs/layout-masters-attr.xsl", ATTR);
        this.generate(xdmItem, "static-content.xsl", "cfg/fo/attrs/static-content-attr.xsl", ATTR);
        this.generate(xdmItem, "tables.xsl", "cfg/fo/attrs/tables-attr.xsl", ATTR);
        this.generate(xdmItem, "toc.xsl", "cfg/fo/attrs/toc-attr.xsl", ATTR);
        this.generate(xdmItem, "tables.xsl", "cfg/fo/attrs/tables-attr.xsl", ATTR);
        this.generate(xdmItem, "basic-settings.xsl", "cfg/fo/attrs/basic-settings.xsl", ATTR);
        this.generate(xdmItem, "links.xsl", "cfg/fo/attrs/links-attr.xsl", ATTR);
        this.generate(xdmItem, "lists.xsl", "cfg/fo/attrs/lists-attr.xsl", ATTR);
        this.generate(xdmItem, "hi-domain.xsl", "cfg/fo/attrs/hi-domain-attr.xsl", ATTR);
        this.generate(xdmItem, "index.xsl", "cfg/fo/attrs/index-attr.xsl", ATTR);
        this.generate(xdmItem, "pr-domain.xsl", "cfg/fo/attrs/pr-domain-attr.xsl", ATTR);
        this.generate(xdmItem, "sw-domain.xsl", "cfg/fo/attrs/sw-domain-attr.xsl", ATTR);
        this.generate(xdmItem, "markup-domain.xsl", "cfg/fo/attrs/markup-domain-attr.xsl", ATTR);
        this.generate(xdmItem, "ui-domain.xsl", "cfg/fo/attrs/ui-domain-attr.xsl", ATTR);
        this.generate(xdmItem, "xml-domain.xsl", "cfg/fo/attrs/xml-domain-attr.xsl", ATTR);
        this.generate(xdmItem, "hazard-d.xsl", "cfg/fo/attrs/hazard-d-attr.xsl", ATTR);
        this.generate(xdmItem, "topic.xsl", "cfg/fo/attrs/topic-attr.xsl", ATTR);
        this.generate(xdmItem, "task-elements.xsl", "cfg/fo/attrs/task-elements-attr.xsl", ATTR);
        File shell = this.generate(xdmItem, "shell.xsl", "xsl/fo/topic2fo_shell.xsl", null);
        for (String lang : new String[]{"de", "en", "es", "fi", "fr", "he", "it", "ja", "nl", "ro", "ru", "sl", "sv", "zh-CN"}) {
            this.generate(xdmItem, "vars.xsl", String.format("cfg/common/vars/%s.xml", lang), null, Collections.singletonMap(LANG, new XdmAtomicValue(lang)));
        }
    }

    private File generate(XdmItem xdmItem, String name, String dst, QName mode) throws BuildException {
        return this.generate(xdmItem, name, dst, mode, Collections.emptyMap());
    }

    @VisibleForTesting
    File generate(XdmItem xdmItem, String name, String dst, QName mode, Map<QName, XdmAtomicValue> params) throws BuildException {
        File dstFile = new File(this.dstDir.toURI().resolve(dst));
        this.getProject().log((Task)this, String.format("Generating %s", dstFile.toURI()), 2);
        try {
            String stylesheetUri = String.format("classpath:/com/elovirta/pdf/%s", name);
            XsltExecutable executable = this.compiler.compile(this.resolver.resolve(stylesheetUri, null));
            Xslt30Transformer transformer = executable.load30();
            Map<QName, XdmAtomicValue> parameters = this.getParameters();
            parameters.putAll(params);
            transformer.setStylesheetParameters(parameters);
            transformer.setGlobalContextItem(xdmItem);
            if (mode != null) {
                transformer.setInitialMode(mode);
            }
            Serializer destination = this.processor.newSerializer(dstFile);
            destination.setOutputProperty(Serializer.Property.METHOD, "xml");
            transformer.applyTemplates((XdmValue)xdmItem, (Destination)destination);
            destination.close();
            return dstFile;
        }
        catch (TransformerException | SaxonApiException e) {
            throw new BuildException(String.format("Failed to generate stylesheet %s", name), e);
        }
    }

    @VisibleForTesting
    XdmItem parseTemplate() {
        this.getProject().log((Task)this, String.format("Reading %s", this.template.toURI()), 2);
        String name = this.template.getName().toLowerCase();
        XdmItem merged = name.endsWith(".yml") || name.endsWith(".yaml") ? this.parseYamlTemplate(this.parseYaml(this.template.toURI()), this.template.toURI()) : this.parseJsonTemplate();
        return this.resolveVariables(merged);
    }

    private XdmItem resolveVariables(XdmItem base) {
        try {
            XdmValue resolved = this.transformer.callFunction(QName.fromClarkName((String)"{x}resolve"), new XdmValue[]{base});
            XdmValue expanded = this.transformer.callFunction(QName.fromClarkName((String)"{x}expandShorthand"), new XdmValue[]{resolved});
            return expanded.itemAt(0);
        }
        catch (SaxonApiException e) {
            throw new BuildException("Failed to resolve variables", (Throwable)e);
        }
    }

    private XdmItem parseJsonTemplate() {
        XdmItem xdmItem;
        FileReader in = new FileReader(this.template);
        try {
            XdmValue theme = this.processor.newJsonBuilder().parseJson((Reader)in);
            Xslt30Transformer transformer = this.executable.load30();
            Map<QName, XdmAtomicValue> parameters = Collections.singletonMap(QName.fromClarkName((String)"{}base-url"), new XdmAtomicValue(this.template.toURI()));
            transformer.setStylesheetParameters(parameters);
            transformer.setGlobalContextItem(theme.itemAt(0));
            xdmItem = transformer.applyTemplates(theme).itemAt(0);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SaxonApiException e) {
                throw new BuildException(String.format("Failed to parse template %s", this.template), (Throwable)e);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        in.close();
        return xdmItem;
    }

    private XdmItem parseYamlTemplate(XdmItem base, URI url) {
        try {
            XdmItem extendsValue = this.xpathCompiler.evaluateSingle(". ?extends", base);
            if (extendsValue != null && extendsValue.getStringValue().equals(DEFAULT_EXTENDS)) {
                XPathSelector selector = this.xpathCompiler.compile("json-doc(.)").load();
                selector.setURIResolver(this.resolver);
                selector.setContextItem((XdmItem)new XdmAtomicValue(DEFAULT_EXTENDS_URI));
                XdmItem extendsRes = selector.evaluateSingle();
                XdmValue merged = this.transformer.callFunction(QName.fromClarkName((String)"{x}merge"), new XdmValue[]{this.normalize(extendsRes, DEFAULT_EXTENDS_URI), this.normalize(base, url)});
                XdmItem added = this.xpathCompiler.evaluateSingle("map:remove(map:put(., 'extends-default', true()), 'extends')", merged.itemAt(0));
                return added.itemAt(0);
            }
            if (extendsValue != null) {
                URI extendsUri = url.resolve(extendsValue.getStringValue());
                XdmItem extendsRes = this.parseYamlTemplate(this.parseYaml(extendsUri), url);
                XdmValue merged = this.transformer.callFunction(QName.fromClarkName((String)"{x}merge"), new XdmValue[]{extendsRes, this.normalize(base, url)});
                XdmItem added = this.xpathCompiler.evaluateSingle("map:remove(., 'extends')", merged.itemAt(0));
                return added.itemAt(0);
            }
            return this.normalize(base, url).itemAt(0);
        }
        catch (SaxonApiException e) {
            throw new BuildException(String.format("Failed to parse template %s", this.template), (Throwable)e);
        }
    }

    private XdmItem normalize(XdmItem in, URI base) {
        try {
            return this.transformer.callFunction(QName.fromClarkName((String)"{x}normalize"), new XdmValue[]{this.transformer.callFunction(QName.fromClarkName((String)"{x}flatten"), new XdmValue[]{in}), XdmEmptySequence.getInstance(), new XdmAtomicValue(base)}).itemAt(0);
        }
        catch (SaxonApiException e) {
            throw new RuntimeException(e);
        }
    }

    private XdmItem parseYaml(URI abs) {
        try {
            Object yaml = this.yamlReader.readValue(abs.toURL(), Object.class);
            String json = this.jsonWriter.writeValueAsString(yaml);
            XdmValue xdmItems = this.processor.newJsonBuilder().parseJson(json);
            return xdmItems.itemAt(0);
        }
        catch (IOException | SaxonApiException e) {
            throw new BuildException("Failed to convert YAML to JSON: " + e.getMessage(), e);
        }
    }

    private Map<QName, XdmAtomicValue> getParameters() {
        HashMap<QName, XdmAtomicValue> parameters = new HashMap<QName, XdmAtomicValue>();
        parameters.put(VERSION, new XdmAtomicValue((String)Configuration.configuration.get("otrelease")));
        String formatter = this.getProject().getProperty("pdf.formatter");
        if (formatter == null) {
            formatter = "fop";
        }
        parameters.put(FORMATTER, new XdmAtomicValue(formatter));
        return parameters;
    }

    public void setTemplate(String template) {
        this.template = new File(template).getAbsoluteFile();
    }

    public void setTodir(File dstDir) {
        this.dstDir = dstDir;
    }
}

