/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.datatypes;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttBinaryData;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.internal.util.Utf8Util;
import com.hivemq.client.mqtt.datatypes.MqttUtf8String;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class MqttUtf8StringImpl
implements MqttUtf8String {
    @NotNull
    public static final MqttUtf8StringImpl PROTOCOL_NAME = new MqttUtf8StringImpl("MQTT".getBytes(StandardCharsets.UTF_8));
    private byte @Nullable [] binary;
    @Nullable
    private String string;
    private int conversions;

    @Contract(value="null -> fail")
    @NotNull
    public static MqttUtf8StringImpl of(@Nullable String string) {
        return MqttUtf8StringImpl.of(string, "UTF-8 encoded string");
    }

    @Contract(value="null, _ -> fail")
    @NotNull
    public static MqttUtf8StringImpl of(@Nullable String string, @NotNull String name) {
        Checks.notNull(string, name);
        MqttUtf8StringImpl.checkLength(string, name);
        MqttUtf8StringImpl.checkWellFormed(string, name);
        return new MqttUtf8StringImpl(string);
    }

    @Nullable
    public static MqttUtf8StringImpl of(byte @NotNull [] binary) {
        return !MqttBinaryData.isInRange(binary) || MqttUtf8StringImpl.isWellFormed(binary) ? null : new MqttUtf8StringImpl(binary);
    }

    @Nullable
    public static MqttUtf8StringImpl decode(@NotNull ByteBuf byteBuf) {
        byte[] binary = MqttBinaryData.decode(byteBuf);
        return binary == null ? null : MqttUtf8StringImpl.of(binary);
    }

    static boolean isWellFormed(byte @NotNull [] binary) {
        if (Utf8Util.isWellFormed(binary) != 0L) {
            return true;
        }
        for (byte b : binary) {
            if (b != 0) continue;
            return true;
        }
        return false;
    }

    static void checkWellFormed(@NotNull String string, @NotNull String name) {
        boolean previousCharIsHighSurrogate = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u0000') {
                throw new IllegalArgumentException(name + " [" + string + "] must not contain null character (U+0000), found at index " + i + ".");
            }
            if (previousCharIsHighSurrogate != Character.isLowSurrogate(c)) {
                throw new IllegalArgumentException(name + " [" + string + "] must not contain unmatched UTF-16 surrogate, found at index " + i + ".");
            }
            previousCharIsHighSurrogate = Character.isHighSurrogate(c);
        }
        if (previousCharIsHighSurrogate) {
            throw new IllegalArgumentException(name + " [" + string + "] must not contain unmatched UTF-16 surrogate, found at index " + (string.length() - 1) + ".");
        }
    }

    static void checkLength(@NotNull String string, @NotNull String name) {
        int utf8Length;
        if (string.length() * 3 > 65535 && (utf8Length = Utf8Util.encodedLength(string)) > 65535) {
            throw new IllegalArgumentException(name + " [" + string.substring(0, 10) + "...] must not be longer than " + 65535 + " bytes, but was " + utf8Length + " bytes.");
        }
    }

    MqttUtf8StringImpl(byte @NotNull [] binary) {
        this.binary = binary;
    }

    MqttUtf8StringImpl(@NotNull String string) {
        this.string = string;
    }

    @Override
    public boolean containsShouldNotCharacters() {
        String string = this.toString();
        boolean highSurrogate = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isISOControl(c)) {
                return true;
            }
            if (!highSurrogate) {
                if (c < '\ud83f') continue;
                if (c >= '\ufdd0' && c <= '\ufdef') {
                    return true;
                }
                if ((c & 0xFFFE) == 65534) {
                    return true;
                }
                if (c != '\ud83f' && c != '\ud87f' && c != '\ud8bf' && c != '\ud8ff' && c != '\ud93f' && c != '\ud97f' && c != '\ud9bf' && c != '\ud9ff' && c != '\uda3f' && c != '\uda7f' && c != '\udabf' && c != '\udaff' && c != '\udb3f' && c != '\udb7f' && c != '\udbbf' && c != '\udbff') continue;
                highSurrogate = true;
                continue;
            }
            if ((c & 0xDFFE) == 57342) {
                return true;
            }
            highSurrogate = false;
        }
        return false;
    }

    @Override
    @NotNull
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.toBinary()).asReadOnlyBuffer();
    }

    byte @NotNull [] toBinary() {
        byte[] binary = this.binary;
        if (binary == null) {
            String string = this.string;
            if (string == null) {
                return this.toBinary();
            }
            this.binary = binary = string.getBytes(StandardCharsets.UTF_8);
            ++this.conversions;
            if (this.conversions < 3) {
                this.string = null;
            }
        }
        return binary;
    }

    @NotNull
    public String toString() {
        String string = this.string;
        if (string == null) {
            byte[] binary = this.binary;
            if (binary == null) {
                return this.toString();
            }
            this.string = string = new String(binary, StandardCharsets.UTF_8);
            ++this.conversions;
            if (this.conversions < 3) {
                this.binary = null;
            }
        }
        return string;
    }

    public void encode(@NotNull ByteBuf byteBuf) {
        MqttBinaryData.encode(this.toBinary(), byteBuf);
    }

    public int encodedLength() {
        return MqttBinaryData.encodedLength(this.toBinary());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttUtf8StringImpl)) {
            return false;
        }
        MqttUtf8StringImpl that = (MqttUtf8StringImpl)o;
        String string = this.string;
        String thatString = that.string;
        if (string != null && thatString != null) {
            return string.equals(thatString);
        }
        byte[] binary = this.binary;
        byte[] thatBinary = that.binary;
        if (binary != null && thatBinary != null) {
            return Arrays.equals(binary, thatBinary);
        }
        return this.toString().equals(that.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(@NotNull MqttUtf8String that) {
        return this.toString().compareTo(that.toString());
    }
}

