/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.function.AddConverter;
import tech.units.indriya.function.DoubleMultiplyConverter;
import tech.units.indriya.function.ExpConverter;
import tech.units.indriya.function.LogConverter;
import tech.units.indriya.function.PowerOfIntConverter;
import tech.units.indriya.function.PowerOfPiConverter;
import tech.units.indriya.function.RationalConverter;
import tech.units.indriya.spi.NumberSystem;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Calculus {
    private static final Logger log = Logger.getLogger(Calculus.class.getName());
    public static final MathContext DEFAULT_MATH_CONTEXT;
    public static MathContext MATH_CONTEXT;
    private static NumberSystem currentSystem;
    private static final String DEFAULT_NUMBER_SYSTEM = "tech.units.indriya.function.DefaultNumberSystem";
    private static final Map<Class<? extends AbstractConverter>, Integer> normalFormOrder;

    public static List<NumberSystem> getAvailableNumberSystems() {
        ArrayList<NumberSystem> systems = new ArrayList<NumberSystem>();
        ServiceLoader<NumberSystem> loader = ServiceLoader.load(NumberSystem.class, NumberSystem.class.getClassLoader());
        loader.forEach(systems::add);
        return systems;
    }

    public static NumberSystem currentNumberSystem() {
        if (currentSystem == null) {
            currentSystem = Calculus.getNumberSystem(DEFAULT_NUMBER_SYSTEM);
        }
        return currentSystem;
    }

    public static void setCurrentNumberSystem(NumberSystem system) {
        currentSystem = system;
    }

    public static NumberSystem getNumberSystem(String name) {
        ServiceLoader<NumberSystem> loader = ServiceLoader.load(NumberSystem.class, NumberSystem.class.getClassLoader());
        for (NumberSystem system : loader) {
            if (!name.equals(system.getClass().getName())) continue;
            return system;
        }
        throw new IllegalArgumentException("NumberSystem " + name + " not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Class<? extends AbstractConverter>, Integer> getNormalFormOrder() {
        Map<Class<? extends AbstractConverter>, Integer> map = normalFormOrder;
        synchronized (map) {
            if (normalFormOrder.isEmpty()) {
                normalFormOrder.put(AbstractConverter.IDENTITY.getClass(), 0);
                normalFormOrder.put(PowerOfIntConverter.class, 1);
                normalFormOrder.put(RationalConverter.class, 2);
                normalFormOrder.put(PowerOfPiConverter.class, 3);
                normalFormOrder.put(DoubleMultiplyConverter.class, 4);
                normalFormOrder.put(AddConverter.class, 5);
                normalFormOrder.put(LogConverter.class, 6);
                normalFormOrder.put(ExpConverter.class, 7);
                normalFormOrder.put(AbstractConverter.Pair.class, 99);
            }
        }
        return Collections.unmodifiableMap(normalFormOrder);
    }

    static {
        MATH_CONTEXT = DEFAULT_MATH_CONTEXT = MathContext.DECIMAL128;
        normalFormOrder = new HashMap<Class<? extends AbstractConverter>, Integer>(9);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class Pi {
        private static final BigDecimal TWO = new BigDecimal("2");
        private static final BigDecimal THREE = new BigDecimal("3");
        private static final BigDecimal FOUR = new BigDecimal("4");
        private static final BigDecimal FIVE = new BigDecimal("5");
        private static final BigDecimal TWO_HUNDRED_THIRTY_NINE = new BigDecimal("239");
        private static final Map<Integer, BigDecimal> piCache = new ConcurrentHashMap<Integer, BigDecimal>();

        private Pi() {
        }

        public static BigDecimal ofNumDigits(int numDigits) {
            if (numDigits <= 0) {
                throw new IllegalArgumentException("numDigits is required to be greater than zero");
            }
            return piCache.computeIfAbsent(numDigits, key -> Pi.calculatePi(numDigits));
        }

        private static BigDecimal calculatePi(int numDigits) {
            int calcDigits = numDigits + 10;
            return FOUR.multiply(FOUR.multiply(Pi.arccot(FIVE, calcDigits)).subtract(Pi.arccot(TWO_HUNDRED_THIRTY_NINE, calcDigits))).setScale(numDigits, RoundingMode.DOWN);
        }

        private static BigDecimal arccot(BigDecimal x, int numDigits) {
            BigDecimal unity = BigDecimal.ONE.setScale(numDigits, RoundingMode.DOWN);
            BigDecimal sum = unity.divide(x, RoundingMode.DOWN);
            BigDecimal xpower = new BigDecimal(sum.toString());
            BigDecimal term = null;
            int nTerms = 0;
            BigDecimal nearZero = BigDecimal.ONE.scaleByPowerOfTen(-numDigits);
            log.log(Level.FINER, () -> "arccot: ARGUMENT=" + x + " (nearZero=" + nearZero + ")");
            boolean add = false;
            BigDecimal n = THREE;
            while (!(term != null && term.equals(BigDecimal.ZERO) || term != null && term.compareTo(nearZero) < 0)) {
                xpower = xpower.divide(x.pow(2), RoundingMode.DOWN);
                term = xpower.divide(n, RoundingMode.DOWN);
                sum = add ? sum.add(term) : sum.subtract(term);
                boolean bl = add = !add;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "arccot: term=" + term);
                }
                ++nTerms;
                n = n.add(TWO);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINER, "arccot: done. nTerms=" + nTerms);
            }
            return sum;
        }
    }
}

