/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.thumbnails.element;

import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class ThumbnailElement
implements ExtensionElement {
    public static final String ELEMENT = "thumbnail";
    public static final String NAMESPACE = "urn:xmpp:thumbs:1";
    public static final String ELEM_URI = "uri";
    public static final String ELEM_MEDIA_TYPE = "media-type";
    public static final String ELEM_WIDTH = "width";
    public static final String ELEM_HEIGHT = "height";
    private final String uri;
    private final String mediaType;
    private final Integer width;
    private final Integer height;

    public ThumbnailElement(String uri) {
        this(uri, null, null, null);
    }

    public ThumbnailElement(String uri, String mediaType, Integer width, Integer height) {
        this.uri = Objects.requireNonNull(uri);
        this.mediaType = mediaType;
        if (width != null && width < 0) {
            throw new IllegalArgumentException("Width cannot be negative.");
        }
        this.width = width;
        if (height != null && height < 0) {
            throw new IllegalArgumentException("Height cannot be negative.");
        }
        this.height = height;
    }

    public String getUri() {
        return this.uri;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    @Override
    public CharSequence toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder sb = new XmlStringBuilder(this, xmlEnvironment);
        return sb.attribute(ELEM_URI, this.uri).optAttribute(ELEM_MEDIA_TYPE, this.mediaType).optAttribute(ELEM_WIDTH, this.width).optAttribute(ELEM_HEIGHT, this.height).closeEmptyElement();
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }
}

