/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.eme.element;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.MessageView;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class ExplicitMessageEncryptionElement
implements ExtensionElement {
    private static final Map<String, ExplicitMessageEncryptionProtocol> PROTOCOL_LUT = new HashMap<String, ExplicitMessageEncryptionProtocol>();
    public static final String ELEMENT = "encryption";
    public static final String NAMESPACE = "urn:xmpp:eme:0";
    public static final QName QNAME = new QName("urn:xmpp:eme:0", "encryption");
    private final String encryptionNamespace;
    private final String name;
    private boolean isUnknownProtocol;
    private ExplicitMessageEncryptionProtocol protocolCache;

    public ExplicitMessageEncryptionElement(ExplicitMessageEncryptionProtocol protocol) {
        this(protocol.getNamespace(), protocol.getName());
    }

    public ExplicitMessageEncryptionElement(String encryptionNamespace) {
        this(encryptionNamespace, null);
    }

    public ExplicitMessageEncryptionElement(String encryptionNamespace, String name) {
        this.encryptionNamespace = StringUtils.requireNotNullNorEmpty(encryptionNamespace, "encryptionNamespace must not be null");
        this.name = name;
    }

    public ExplicitMessageEncryptionProtocol getProtocol() {
        if (this.protocolCache != null) {
            return this.protocolCache;
        }
        if (this.isUnknownProtocol) {
            return null;
        }
        ExplicitMessageEncryptionProtocol protocol = PROTOCOL_LUT.get(this.encryptionNamespace);
        if (protocol == null) {
            this.isUnknownProtocol = true;
            return null;
        }
        this.protocolCache = protocol;
        return protocol;
    }

    public String getEncryptionNamespace() {
        return this.encryptionNamespace;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder(this);
        xml.attribute("namespace", this.getEncryptionNamespace());
        xml.optAttribute("name", this.getName());
        xml.closeEmptyElement();
        return xml;
    }

    public static ExplicitMessageEncryptionElement from(Message message) {
        return message.getExtension(ExplicitMessageEncryptionElement.class);
    }

    public static boolean hasProtocol(MessageView message, String protocolNamespace) {
        List<ExplicitMessageEncryptionElement> emeElements = message.getExtensions(ExplicitMessageEncryptionElement.class);
        for (ExplicitMessageEncryptionElement emeElement : emeElements) {
            if (!emeElement.getEncryptionNamespace().equals(protocolNamespace)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasProtocol(MessageView message, ExplicitMessageEncryptionProtocol protocol) {
        return ExplicitMessageEncryptionElement.hasProtocol(message, protocol.namespace);
    }

    public static void set(MessageBuilder message, ExplicitMessageEncryptionProtocol protocol) {
        if (!ExplicitMessageEncryptionElement.hasProtocol((MessageView)message, protocol.namespace)) {
            message.addExtension(new ExplicitMessageEncryptionElement(protocol));
        }
    }

    public static enum ExplicitMessageEncryptionProtocol {
        openpgpV0("urn:xmpp:openpgp:0", "OpenPGP for XMPP (XEP-0373)"),
        otrV0("urn:xmpp:otr:0", "Off-the-Record Messaging (XEP-0364)"),
        omemoVAxolotl("eu.siacs.conversations.axolotl", "OMEMO Multi End Message and Object Encryption (XEP-0384)"),
        legacyOpenPGP("jabber:x:encrypted", "Legacy OpenPGP for XMPP [DANGEROUS, DO NOT USE!]");

        private final String namespace;
        private final String name;

        private ExplicitMessageEncryptionProtocol(String namespace, String name) {
            this.namespace = namespace;
            this.name = name;
            PROTOCOL_LUT.put(namespace, this);
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public static ExplicitMessageEncryptionProtocol from(String namespace) {
            return PROTOCOL_LUT.get(namespace);
        }
    }
}

