// generated by diplomat-tool
import { DataError } from "./DataError.mjs"
import { DataProvider } from "./DataProvider.mjs"
import { Locale } from "./Locale.mjs"
import { Weekday } from "./Weekday.mjs"
import { WeekdaySetIterator } from "./WeekdaySetIterator.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * A Week calculator, useful to be passed in to `week_of_year()` on Date and DateTime types
 *
 * See the [Rust documentation for `WeekInformation`](https://docs.rs/icu/latest/icu/calendar/week/struct.WeekInformation.html) for more information.
 */
const WeekInformation_box_destroy_registry = new FinalizationRegistry((ptr) => {
    wasm.icu4x_WeekInformation_destroy_mv1(ptr);
});

export class WeekInformation {
    // Internal ptr reference:
    #ptr = null;

    // Lifetimes are only to keep dependencies alive.
    // Since JS won't garbage collect until there are no incoming edges.
    #selfEdge = [];

    #internalConstructor(symbol, ptr, selfEdge) {
        if (symbol !== diplomatRuntime.internalConstructor) {
            console.error("WeekInformation is an Opaque type. You cannot call its constructor.");
            return;
        }
        this.#ptr = ptr;
        this.#selfEdge = selfEdge;

        // Are we being borrowed? If not, we can register.
        if (this.#selfEdge.length === 0) {
            WeekInformation_box_destroy_registry.register(this, this.#ptr);
        }

        return this;
    }
    get ffiValue() {
        return this.#ptr;
    }


    /**
     * Creates a new [`WeekInformation`] from locale data using compiled data.
     *
     * See the [Rust documentation for `try_new`](https://docs.rs/icu/latest/icu/calendar/week/struct.WeekInformation.html#method.try_new) for more information.
     */
    #defaultConstructor(locale) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_WeekInformation_create_mv1(diplomatReceive.buffer, locale.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DataError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DataError: ' + cause.value, { cause });
            }
            return new WeekInformation(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Creates a new [`WeekInformation`] from locale data using a particular data source.
     *
     * See the [Rust documentation for `try_new`](https://docs.rs/icu/latest/icu/calendar/week/struct.WeekInformation.html#method.try_new) for more information.
     */
    static createWithProvider(provider, locale) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_WeekInformation_create_with_provider_mv1(diplomatReceive.buffer, provider.ffiValue, locale.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DataError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DataError: ' + cause.value, { cause });
            }
            return new WeekInformation(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Returns the weekday that starts the week for this object's locale
     *
     * See the [Rust documentation for `first_weekday`](https://docs.rs/icu/latest/icu/calendar/week/struct.WeekInformation.html#structfield.first_weekday) for more information.
     */
    get firstWeekday() {

        const result = wasm.icu4x_WeekInformation_first_weekday_mv1(this.ffiValue);

        try {
            return new Weekday(diplomatRuntime.internalConstructor, result);
        }

        finally {
        }
    }

    /**
     * See the [Rust documentation for `weekend`](https://docs.rs/icu/latest/icu/calendar/week/struct.WeekInformation.html#structfield.weekend) for more information.
     *
     * See the [Rust documentation for `contains`](https://docs.rs/icu/latest/icu/calendar/provider/struct.WeekdaySet.html#method.contains) for more information.
     */
    isWeekend(day) {

        const result = wasm.icu4x_WeekInformation_is_weekend_mv1(this.ffiValue, day.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * See the [Rust documentation for `weekend`](https://docs.rs/icu/latest/icu/calendar/week/struct.WeekInformation.html#method.weekend) for more information.
     */
    get weekend() {

        const result = wasm.icu4x_WeekInformation_weekend_mv1(this.ffiValue);

        try {
            return new WeekdaySetIterator(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    constructor(locale) {
        if (arguments[0] === diplomatRuntime.exposeConstructor) {
            return this.#internalConstructor(...Array.prototype.slice.call(arguments, 1));
        } else if (arguments[0] === diplomatRuntime.internalConstructor) {
            return this.#internalConstructor(...arguments);
        } else {
            return this.#defaultConstructor(...arguments);
        }
    }
}